/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.15-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: akg_craft
-- ------------------------------------------------------
-- Server version	10.11.15-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `addresses`
--

DROP TABLE IF EXISTS `addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `addresses` (
  `id` int(11) NOT NULL,
  `primaryOwnerId` int(11) DEFAULT NULL,
  `fieldId` int(11) DEFAULT NULL,
  `countryCode` varchar(255) NOT NULL,
  `administrativeArea` varchar(255) DEFAULT NULL,
  `locality` varchar(255) DEFAULT NULL,
  `dependentLocality` varchar(255) DEFAULT NULL,
  `postalCode` varchar(255) DEFAULT NULL,
  `sortingCode` varchar(255) DEFAULT NULL,
  `addressLine1` varchar(255) DEFAULT NULL,
  `addressLine2` varchar(255) DEFAULT NULL,
  `addressLine3` varchar(255) DEFAULT NULL,
  `organization` varchar(255) DEFAULT NULL,
  `organizationTaxId` varchar(255) DEFAULT NULL,
  `fullName` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `latitude` varchar(255) DEFAULT NULL,
  `longitude` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_iqvloikvkpdwacapmodeegqbfwwsttzfiaqx` (`primaryOwnerId`),
  CONSTRAINT `fk_dwkislensiccokeopruhqgnyoosvtqpqvnxz` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_iqvloikvkpdwacapmodeegqbfwwsttzfiaqx` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `pluginId` int(11) DEFAULT NULL,
  `heading` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `dateRead` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_uukijiyyfbdpzlzeqyvxlovumrsxhmnoygak` (`userId`,`unread`,`dateRead`,`dateCreated`),
  KEY `idx_mgewutpavvnrbjchxdqzhgengtvihkgkczjl` (`dateRead`),
  KEY `fk_wruwonaklxcgxnetazpxvohcqbbhhjbqrkoe` (`pluginId`),
  CONSTRAINT `fk_wospxzotjkupqslxknxobuiyjbevdfwiqlck` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wruwonaklxcgxnetazpxvohcqbbhhjbqrkoe` FOREIGN KEY (`pluginId`) REFERENCES `plugins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexdata`
--

DROP TABLE IF EXISTS `assetindexdata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assetindexdata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sessionId` int(11) NOT NULL,
  `volumeId` int(11) NOT NULL,
  `uri` text DEFAULT NULL,
  `size` bigint(20) unsigned DEFAULT NULL,
  `timestamp` datetime DEFAULT NULL,
  `isDir` tinyint(1) DEFAULT 0,
  `recordId` int(11) DEFAULT NULL,
  `isSkipped` tinyint(1) DEFAULT 0,
  `inProgress` tinyint(1) DEFAULT 0,
  `completed` tinyint(1) DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_vvjtokdopumqivgaxhocgaebidhfqnctkahc` (`sessionId`,`volumeId`),
  KEY `idx_gzbdxenxksafpxnsqlillxlimxjghnkkkmeu` (`volumeId`),
  CONSTRAINT `fk_sbdvwtpkiwufghhdpxbxpywoanluihrohqtp` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_uttkbdmmxkkkmehzpvgxbbggkbofttzmldfc` FOREIGN KEY (`sessionId`) REFERENCES `assetindexingsessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexingsessions`
--

DROP TABLE IF EXISTS `assetindexingsessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assetindexingsessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `indexedVolumes` text DEFAULT NULL,
  `totalEntries` int(11) DEFAULT NULL,
  `processedEntries` int(11) NOT NULL DEFAULT 0,
  `cacheRemoteImages` tinyint(1) DEFAULT NULL,
  `listEmptyFolders` tinyint(1) DEFAULT 0,
  `isCli` tinyint(1) DEFAULT 0,
  `actionRequired` tinyint(1) DEFAULT 0,
  `processIfRootEmpty` tinyint(1) DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `id` int(11) NOT NULL,
  `volumeId` int(11) DEFAULT NULL,
  `folderId` int(11) NOT NULL,
  `uploaderId` int(11) DEFAULT NULL,
  `filename` varchar(255) NOT NULL,
  `mimeType` varchar(255) DEFAULT NULL,
  `kind` varchar(50) NOT NULL DEFAULT 'unknown',
  `alt` text DEFAULT NULL,
  `width` int(10) unsigned DEFAULT NULL,
  `height` int(10) unsigned DEFAULT NULL,
  `size` bigint(20) unsigned DEFAULT NULL,
  `focalPoint` varchar(13) DEFAULT NULL,
  `deletedWithVolume` tinyint(1) DEFAULT NULL,
  `keptFile` tinyint(1) DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_qvgtvxwwlxpafqemsbgcnfuuabsghawguivf` (`filename`,`folderId`),
  KEY `idx_abvtfcfcqgzppjrgofuzjkgdprqvrgecamec` (`folderId`),
  KEY `idx_bivetzxptnogsjjvthfyfqtxmejmcknttcde` (`volumeId`),
  KEY `fk_tekocsxyxnieyklrguywvjqnhanpwcufwobg` (`uploaderId`),
  CONSTRAINT `fk_lvihrokbpxzrgrmhkbhnnzcdbpixlpsyxbrj` FOREIGN KEY (`folderId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_modowmfkudoeglagnxbsrdobeahipbmutmmx` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tekocsxyxnieyklrguywvjqnhanpwcufwobg` FOREIGN KEY (`uploaderId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_tsjsorwzadpbpqdekpcuubqwgsphuvpxaufc` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assets_sites`
--

DROP TABLE IF EXISTS `assets_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_sites` (
  `assetId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `alt` text DEFAULT NULL,
  PRIMARY KEY (`assetId`,`siteId`),
  KEY `fk_aknalnuelkvjzfggeovumibomcxcvfyzuvba` (`siteId`),
  CONSTRAINT `fk_aknalnuelkvjzfggeovumibomcxcvfyzuvba` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_glkidgkgevdmgjkbjibfhlzlaocozqmqmgqu` FOREIGN KEY (`assetId`) REFERENCES `assets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `auth_oauth_tokens`
--

DROP TABLE IF EXISTS `auth_oauth_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `auth_oauth_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ownerHandle` varchar(255) NOT NULL,
  `providerType` varchar(255) NOT NULL,
  `tokenType` varchar(255) NOT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `accessToken` text DEFAULT NULL,
  `secret` text DEFAULT NULL,
  `expires` varchar(255) DEFAULT NULL,
  `refreshToken` text DEFAULT NULL,
  `resourceOwnerId` varchar(255) DEFAULT NULL,
  `values` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `authenticator`
--

DROP TABLE IF EXISTS `authenticator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `authenticator` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `auth2faSecret` varchar(255) DEFAULT NULL,
  `oldTimestamp` int(10) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_lqkqvklsscofkuzcmuhzmqyirarugttwxhkz` (`userId`),
  CONSTRAINT `fk_lqkqvklsscofkuzcmuhzmqyirarugttwxhkz` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bulkopevents`
--

DROP TABLE IF EXISTS `bulkopevents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bulkopevents` (
  `key` char(10) NOT NULL,
  `senderClass` varchar(255) NOT NULL,
  `eventName` varchar(255) NOT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`key`,`senderClass`,`eventName`),
  KEY `idx_ysvuwziiymmrgtwdrkpsowlzqogybnlfzaze` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `parentId` int(11) DEFAULT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_jdtdhiipxibhqhdrjnrsorabilokzbcngtpy` (`groupId`),
  KEY `fk_gtqjpmdvxqkiktckauevmrakbedagbcawuxa` (`parentId`),
  CONSTRAINT `fk_ekltgmycyzqgniebmeziaiuvonfituulthmy` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_gtqjpmdvxqkiktckauevmrakbedagbcawuxa` FOREIGN KEY (`parentId`) REFERENCES `categories` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_vrqtvmuntnirtheyxwwnaivpmzsdrijkpkjk` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups`
--

DROP TABLE IF EXISTS `categorygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorygroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `defaultPlacement` enum('beginning','end') NOT NULL DEFAULT 'end',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uunanhzxghwptsxiizkbzlnjuwaxvmpbntgx` (`name`),
  KEY `idx_jwjmbrdxzdvswgrzsxdsstawqtrgjopuqzgo` (`handle`),
  KEY `idx_uvwkerycvzjcvbjxqobjxhwqxoehosngowzm` (`structureId`),
  KEY `idx_iucivdbueuhqivcstqnxhmmedcbhluyifnpy` (`fieldLayoutId`),
  KEY `idx_piswzyqdhcmfztsrkgdtwovlvnvphbovffqn` (`dateDeleted`),
  CONSTRAINT `fk_aerphudzxhtbpmredahlvapzjxoudhxkwhon` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_yzkizfrsuoibmzojzqbbaosarsptufacqxgz` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups_sites`
--

DROP TABLE IF EXISTS `categorygroups_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorygroups_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT 1,
  `uriFormat` text DEFAULT NULL,
  `template` varchar(500) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_idnjmmbumtlyimwpghcnmcqvdndfqhlvokyx` (`groupId`,`siteId`),
  KEY `idx_cjkndovfayjuexqykawqmchuozjoagueujba` (`siteId`),
  CONSTRAINT `fk_ggkknmnhztypspuotgseladohqtwzrmyixrx` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_lcmrwwreuymkayhpoussqwkblzkvhsjdbksu` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedattributes`
--

DROP TABLE IF EXISTS `changedattributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `changedattributes` (
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `attribute` varchar(255) NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int(11) DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`attribute`),
  KEY `idx_khvqpffjismcfsqpdqlgcruhvygcepogvadg` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_rwywfgyogaofdouikozlmtushjaueatcoiek` (`siteId`),
  KEY `fk_xyhmlobytgekueeosolyvopkjtkrqkkfkpnm` (`userId`),
  CONSTRAINT `fk_nrkxricfghplaoujxnuyozvnhdetruyvpxhv` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_rwywfgyogaofdouikozlmtushjaueatcoiek` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_xyhmlobytgekueeosolyvopkjtkrqkkfkpnm` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedfields`
--

DROP TABLE IF EXISTS `changedfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `changedfields` (
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `layoutElementUid` char(36) NOT NULL DEFAULT '0',
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int(11) DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`fieldId`,`layoutElementUid`),
  KEY `idx_yixjevqontcntogoqmbjpqlnxgctmkhhrxlz` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_hxkitwxxoprypxilpoicfxohxearcpcokspe` (`siteId`),
  KEY `fk_lkktxosmjbksmxbgkfwwjudteinxrsdpcqnp` (`fieldId`),
  KEY `fk_tzrmrhhebfbnhvaeqtwqpyqirmjezdfehvot` (`userId`),
  CONSTRAINT `fk_hxkitwxxoprypxilpoicfxohxearcpcokspe` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_lkktxosmjbksmxbgkfwwjudteinxrsdpcqnp` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_tzrmrhhebfbnhvaeqtwqpyqirmjezdfehvot` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_vrypsfgzpzeijownmupepjjfqymlxzcjvvjy` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `contentblocks`
--

DROP TABLE IF EXISTS `contentblocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contentblocks` (
  `id` int(11) NOT NULL,
  `primaryOwnerId` int(11) DEFAULT NULL,
  `fieldId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_fbatyxybqahalcbfhhjfwmwiucjohusckaea` (`primaryOwnerId`),
  KEY `idx_cpwzlbyfwmbeyuergpumcknelghukdyfzysk` (`fieldId`),
  CONSTRAINT `fk_enihsclmaiypgqhyaifvzxuxwanxakwdvzcp` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_rawdacbutrhywmbxlthvtezzhyoirgakpxxz` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vewpqxqvrdsjnrnnonhuvfuylfcvbuzblrwb` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `craftidtokens`
--

DROP TABLE IF EXISTS `craftidtokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `craftidtokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `accessToken` text NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_aprtjzfhhgnrfsbfjhiyisovjfhnbxdbhaiq` (`userId`),
  CONSTRAINT `fk_aprtjzfhhgnrfsbfjhiyisovjfhnbxdbhaiq` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `deprecationerrors`
--

DROP TABLE IF EXISTS `deprecationerrors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `deprecationerrors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `fingerprint` varchar(255) NOT NULL,
  `lastOccurrence` datetime NOT NULL,
  `file` varchar(255) NOT NULL,
  `line` smallint(5) unsigned DEFAULT NULL,
  `message` text DEFAULT NULL,
  `traces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`traces`)),
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ggqeiyvtqgzlkparplrdgikcqzkzsmglclkk` (`key`,`fingerprint`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `drafts`
--

DROP TABLE IF EXISTS `drafts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drafts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `canonicalId` int(11) DEFAULT NULL,
  `creatorId` int(11) DEFAULT NULL,
  `provisional` tinyint(1) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL,
  `notes` text DEFAULT NULL,
  `trackChanges` tinyint(1) NOT NULL DEFAULT 0,
  `dateLastMerged` datetime DEFAULT NULL,
  `saved` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_pbjjnhpnrprdqbvwdqhmmjirshfkswdhbgnq` (`creatorId`,`provisional`),
  KEY `idx_igyysutmncnnbstaaxnbnygayzheetcgeovq` (`saved`),
  KEY `fk_pnjziqnbyykzrupscelklaupbcksriwnrrme` (`canonicalId`),
  CONSTRAINT `fk_ipktlizajpmowigitytbcucvtuqwzstrwdzy` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_pnjziqnbyykzrupscelklaupbcksriwnrrme` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3500 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elementactivity`
--

DROP TABLE IF EXISTS `elementactivity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elementactivity` (
  `elementId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `draftId` int(11) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`elementId`,`userId`,`type`),
  KEY `idx_lfntenacxydtfclryddiugdzcrshilkochqv` (`elementId`,`timestamp`,`userId`),
  KEY `fk_gesincdiwdmutikkuyhqzlrkadkbheroqanw` (`userId`),
  KEY `fk_uxobxrfpuiweyzqxztckzqcflucstlcywyqs` (`siteId`),
  KEY `fk_mgtnxakxxzfjcoldzotieovkfwsbaabewkjg` (`draftId`),
  CONSTRAINT `fk_gesincdiwdmutikkuyhqzlrkadkbheroqanw` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_mgtnxakxxzfjcoldzotieovkfwsbaabewkjg` FOREIGN KEY (`draftId`) REFERENCES `drafts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ncpfsuiybumtansfrugtqqwvywlllycrfhwm` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_uxobxrfpuiweyzqxztckzqcflucstlcywyqs` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements`
--

DROP TABLE IF EXISTS `elements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `canonicalId` int(11) DEFAULT NULL,
  `draftId` int(11) DEFAULT NULL,
  `revisionId` int(11) DEFAULT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `archived` tinyint(1) NOT NULL DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateLastMerged` datetime DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `deletedWithOwner` tinyint(1) DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qiibialuucjqeqxthdndfhqodrhcnlzfryro` (`dateDeleted`),
  KEY `idx_ycbmfgoisupnxhxbincuvcqpnilqkyuiqhag` (`fieldLayoutId`),
  KEY `idx_xagvruibfecvrqupeapkjclkpyozwbmooveu` (`type`),
  KEY `idx_gacuplsrjqjabddulzactzayoarjxuwvhnbb` (`enabled`),
  KEY `idx_tlnsdquubyavsbbrsfdevfzbltifdsoathqr` (`canonicalId`),
  KEY `idx_ufwcipjfzmbqkyzwpuxvljjnqtmluscldgsx` (`archived`,`dateCreated`),
  KEY `idx_hfbbfrbzhfugnxytcpftxoyddpuwguflobnx` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`),
  KEY `idx_tzjbhylhnfaupogwdllppqrniipqnkyxwpwd` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`,`enabled`),
  KEY `fk_nurtvhxbusantavjrasarobzxbtelrsznnqc` (`draftId`),
  KEY `fk_bzohdwhanrmeucuqmzngbmuqlvlmuqirwbwr` (`revisionId`),
  CONSTRAINT `fk_bzohdwhanrmeucuqmzngbmuqlvlmuqirwbwr` FOREIGN KEY (`revisionId`) REFERENCES `revisions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_hdleolnjwfddskkpgcpedovmcaifkpzvupof` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_iqjvcupoxaaihgbplrxhefoucnbqfqbstukh` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_nurtvhxbusantavjrasarobzxbtelrsznnqc` FOREIGN KEY (`draftId`) REFERENCES `drafts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11422 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_bulkops`
--

DROP TABLE IF EXISTS `elements_bulkops`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_bulkops` (
  `elementId` int(11) NOT NULL,
  `key` char(10) NOT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`elementId`,`key`),
  KEY `idx_vfrkqqvsamrcteuklvsypdwjixvezigivpdo` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_owners`
--

DROP TABLE IF EXISTS `elements_owners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_owners` (
  `elementId` int(11) NOT NULL,
  `ownerId` int(11) NOT NULL,
  `sortOrder` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`elementId`,`ownerId`),
  KEY `fk_dhwumnkkblggmgardwijeathnljiwubhkuzg` (`ownerId`),
  CONSTRAINT `fk_aczdnoaszuzejaadsmwxtpgjycqznkzzwago` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_dhwumnkkblggmgardwijeathnljiwubhkuzg` FOREIGN KEY (`ownerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_sites`
--

DROP TABLE IF EXISTS `elements_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `uri` varchar(255) DEFAULT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`content`)),
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_vjnigzezqicqxwafasnrqoyquqdduvdvdftq` (`elementId`,`siteId`),
  KEY `idx_ixpowpedfpxftkmpsitspmtnyxoefwchhery` (`siteId`),
  KEY `idx_faibkbrfkfvxazgejlgjrfrxnjqeblawadvk` (`title`,`siteId`),
  KEY `idx_lnznnfmrnlfaqunuspaemenziszgmlygpbnz` (`slug`,`siteId`),
  KEY `idx_cdkhcjlloeortlaiftjiniuunlenmlbluawu` (`enabled`),
  KEY `idx_icfhuppkjtndtkrunqobxqfcgpiebpzzeczy` (`uri`,`siteId`),
  CONSTRAINT `fk_jpjaekscyqockvjkuqbivtndfzwdoyxwdzxw` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ocrawvafzozycdcpcvcyeuoznawsacoananj` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11422 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entries`
--

DROP TABLE IF EXISTS `entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `entries` (
  `id` int(11) NOT NULL,
  `sectionId` int(11) DEFAULT NULL,
  `parentId` int(11) DEFAULT NULL,
  `primaryOwnerId` int(11) DEFAULT NULL,
  `fieldId` int(11) DEFAULT NULL,
  `typeId` int(11) NOT NULL,
  `postDate` datetime DEFAULT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `status` enum('live','pending','expired') NOT NULL DEFAULT 'live',
  `deletedWithEntryType` tinyint(1) DEFAULT NULL,
  `deletedWithSection` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_vxuhugvxhgwekpmglgfmpvpdaswydtlpmnsd` (`postDate`),
  KEY `idx_dqmpytanywvwebfvxiuzoelkiuzmipglvlci` (`expiryDate`),
  KEY `idx_snnelwquugcgsgcsyxztzzdagzzgbzctkkxn` (`status`),
  KEY `idx_oyusrrffxwjasnvimazilomnuayamrqrkkrs` (`sectionId`),
  KEY `idx_pcjlgiaggbycgdkknxbchlptmhrrklpwphsl` (`typeId`),
  KEY `idx_pqzzoyioccqmeqqxwdhzjuhucuqbgflktocu` (`primaryOwnerId`),
  KEY `idx_izzumizhihbjambmxxmqxetcmzycideztdow` (`fieldId`),
  KEY `fk_cbcpwmlhnhvcbapyfnqjxpyvjqlrypwyoegd` (`parentId`),
  CONSTRAINT `fk_btaaxmdovcglmftbupzffceaoihqwxqquprk` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_cbcpwmlhnhvcbapyfnqjxpyvjqlrypwyoegd` FOREIGN KEY (`parentId`) REFERENCES `entries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_qdyopajwvztatqgfirqpattfdtpbmmgivadv` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tzonnsswtfphhxpunbliniqybfolxriqvsjv` FOREIGN KEY (`typeId`) REFERENCES `entrytypes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wdykeepvoppudrfwgjrfizqwqutksqefapak` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zyczynbybirhrsunpruvzossdkcuajozzxdo` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entries_authors`
--

DROP TABLE IF EXISTS `entries_authors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `entries_authors` (
  `entryId` int(11) NOT NULL,
  `authorId` int(11) NOT NULL,
  `sortOrder` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`entryId`,`authorId`),
  KEY `idx_kkkhdomcumrntegqlbnixgdvjxgomwxstvuy` (`authorId`),
  KEY `idx_yfevyzfnrsztelswamdicptklnkglnixdqxp` (`entryId`,`sortOrder`),
  CONSTRAINT `fk_dmrvjudwrfejjxwchksnnnnilhppsfaqlymf` FOREIGN KEY (`entryId`) REFERENCES `entries` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vefmiipxkunjvixyiptlbmvvuczdjslwmyjj` FOREIGN KEY (`authorId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entrytypes`
--

DROP TABLE IF EXISTS `entrytypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `entrytypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `color` varchar(255) DEFAULT NULL,
  `hasTitleField` tinyint(1) NOT NULL DEFAULT 1,
  `titleTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text DEFAULT NULL,
  `titleFormat` varchar(255) DEFAULT NULL,
  `showSlugField` tinyint(1) DEFAULT 1,
  `slugTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `slugTranslationKeyFormat` text DEFAULT NULL,
  `showStatusField` tinyint(1) DEFAULT 1,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_vkehvdetjwprdqsulpbglbksfkusjqjgucci` (`fieldLayoutId`),
  KEY `idx_jjwomxpvnhulsribozssqisaqqlbsqjvmsyi` (`dateDeleted`),
  CONSTRAINT `fk_yafrsjzjdqztnbrxmdfobdpjjhyhaegzzlxc` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `feedme_feeds`
--

DROP TABLE IF EXISTS `feedme_feeds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `feedme_feeds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `feedUrl` text NOT NULL,
  `feedType` varchar(255) DEFAULT NULL,
  `primaryElement` varchar(255) DEFAULT NULL,
  `elementType` varchar(255) NOT NULL,
  `elementGroup` text DEFAULT NULL,
  `siteId` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `singleton` tinyint(1) NOT NULL DEFAULT 0,
  `duplicateHandle` text DEFAULT NULL,
  `updateSearchIndexes` tinyint(1) NOT NULL DEFAULT 1,
  `paginationNode` text DEFAULT NULL,
  `fieldMapping` mediumtext DEFAULT NULL,
  `fieldUnique` text DEFAULT NULL,
  `passkey` varchar(255) NOT NULL,
  `backup` tinyint(1) NOT NULL DEFAULT 0,
  `setEmptyValues` tinyint(1) NOT NULL DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `feedme_logs`
--

DROP TABLE IF EXISTS `feedme_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `feedme_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `level` int(11) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `log_time` double DEFAULT NULL,
  `prefix` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_log_level` (`level`),
  KEY `idx_log_category` (`category`)
) ENGINE=InnoDB AUTO_INCREMENT=10189 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `feedme_sequences`
--

DROP TABLE IF EXISTS `feedme_sequences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `feedme_sequences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `feedId` int(11) NOT NULL,
  `options` text DEFAULT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_sequence_key` (`key`),
  KEY `idx_sequence_feedId` (`feedId`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayouts`
--

DROP TABLE IF EXISTS `fieldlayouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `fieldlayouts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `config` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`config`)),
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qwwlwnqfvylkuewgaagypsrycjehryatpzow` (`dateDeleted`),
  KEY `idx_wchkxdaphzpbzeecvukzveawczlewmlmfyar` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fields`
--

DROP TABLE IF EXISTS `fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `handle` varchar(64) NOT NULL,
  `context` varchar(255) NOT NULL DEFAULT 'global',
  `columnSuffix` char(8) DEFAULT NULL,
  `instructions` text DEFAULT NULL,
  `searchable` tinyint(1) NOT NULL DEFAULT 1,
  `translationMethod` varchar(255) NOT NULL DEFAULT 'none',
  `translationKeyFormat` text DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `settings` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_lsqfyxfqwsraezylphubazinzxcumkbmxziw` (`handle`,`context`),
  KEY `idx_dmvvcaxllibxdtchgbgdehiojdcqsayhgqpd` (`context`),
  KEY `idx_wysugkgwsibkwauvrgcreyaivgyqbwyyvwav` (`dateDeleted`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_emailtemplates`
--

DROP TABLE IF EXISTS `formie_emailtemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_emailtemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `template` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_fieldlayout_pages`
--

DROP TABLE IF EXISTS `formie_fieldlayout_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_fieldlayout_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `label` text NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `settings` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_wsellseropllfqtjvnmmlbieaotzifgaoqox` (`layoutId`),
  CONSTRAINT `fk_cgufcpckavqgbguoganyvvagswfccogwvstd` FOREIGN KEY (`layoutId`) REFERENCES `formie_fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_fieldlayout_rows`
--

DROP TABLE IF EXISTS `formie_fieldlayout_rows`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_fieldlayout_rows` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `pageId` int(11) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_yuhycebplsysnvprbobsairuoyjungdvbqkm` (`layoutId`),
  KEY `idx_zmrariclaivgmsbxewzqoawnbqaapexcsyza` (`pageId`),
  CONSTRAINT `fk_erbaorsqdlbvwbxpocexnfcqzfuahxkbndsf` FOREIGN KEY (`layoutId`) REFERENCES `formie_fieldlayouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vjombnskdidvaxcbyuzszobrfxmbalnerazb` FOREIGN KEY (`pageId`) REFERENCES `formie_fieldlayout_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_fieldlayouts`
--

DROP TABLE IF EXISTS `formie_fieldlayouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_fieldlayouts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_fields`
--

DROP TABLE IF EXISTS `formie_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `pageId` int(11) NOT NULL,
  `rowId` int(11) NOT NULL,
  `syncId` int(11) DEFAULT NULL,
  `label` text NOT NULL,
  `handle` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `settings` mediumtext DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_tkpfjpvluewfmtufxqestjgpkiomuegvjnmb` (`layoutId`),
  KEY `idx_vgtiahcwedmvzngwifqklgdigfurdcfhyzar` (`pageId`),
  KEY `idx_fyqoxcnmaojfduuzikkmcsmgnlvzluyueneu` (`rowId`),
  KEY `idx_difxqkzzntipncmbjbqlutovxnodjcpvqade` (`syncId`),
  KEY `idx_vfldraqemfzvopodoulmlrmpudvurlqwgwvq` (`handle`),
  CONSTRAINT `fk_brpmayrtdxwysvhsjyowqeqtahmlbwfbtqsf` FOREIGN KEY (`syncId`) REFERENCES `formie_fields` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_flrlfrzkprvpccfhbtjwrrebtaxrkthvywta` FOREIGN KEY (`pageId`) REFERENCES `formie_fieldlayout_pages` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vhjkvimadlsqmaablakviavmjyozlzyukgmt` FOREIGN KEY (`rowId`) REFERENCES `formie_fieldlayout_rows` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zcenyegufgxlsaktpzfvtpfcxzziagdtsnnz` FOREIGN KEY (`layoutId`) REFERENCES `formie_fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_forms`
--

DROP TABLE IF EXISTS `formie_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` varchar(64) NOT NULL,
  `settings` mediumtext DEFAULT NULL,
  `layoutId` int(11) DEFAULT NULL,
  `templateId` int(11) DEFAULT NULL,
  `submitActionEntryId` int(11) DEFAULT NULL,
  `submitActionEntrySiteId` int(11) DEFAULT NULL,
  `defaultStatusId` int(11) DEFAULT NULL,
  `dataRetention` enum('forever','minutes','hours','days','weeks','months','years') NOT NULL DEFAULT 'forever',
  `dataRetentionValue` int(11) DEFAULT NULL,
  `userDeletedAction` enum('retain','delete') NOT NULL DEFAULT 'retain',
  `fileUploadsAction` enum('retain','delete') NOT NULL DEFAULT 'retain',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_rxajpptdthellnalugthfibzkarwjchtukgq` (`layoutId`),
  KEY `idx_prrydlukpxxlywdrkzvaqhjhukbyapajnlgh` (`templateId`),
  KEY `idx_cddfegcondnyvkxhqlpbkezolseodmoqkpaz` (`defaultStatusId`),
  KEY `idx_xsjisypncmucbgsdbizpyrnllxnswvjvyrfd` (`submitActionEntryId`),
  KEY `idx_zidgduqsvixavfkicwnyffrldjnatpbtywhb` (`submitActionEntrySiteId`),
  CONSTRAINT `fk_abcroeupevcjhiuyisknquzeodeewuxgtqdw` FOREIGN KEY (`submitActionEntryId`) REFERENCES `entries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_bsgirrthfwrrckqwjqvzctzyxqezwzmjtyxf` FOREIGN KEY (`layoutId`) REFERENCES `formie_fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_clnhfclwuejwakbvnhedsmkwizknjehniaet` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_eozbcreculatnzjfkfvyfvxyyiducufpqdaa` FOREIGN KEY (`templateId`) REFERENCES `formie_formtemplates` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_wxhceocahlfqeouayilmxgnpwsjmtfopfxpp` FOREIGN KEY (`defaultStatusId`) REFERENCES `formie_statuses` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_formtemplates`
--

DROP TABLE IF EXISTS `formie_formtemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_formtemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `template` varchar(255) DEFAULT NULL,
  `useCustomTemplates` tinyint(1) DEFAULT 1,
  `outputCssLayout` tinyint(1) DEFAULT 1,
  `outputCssTheme` tinyint(1) DEFAULT 1,
  `outputJsBase` tinyint(1) DEFAULT 1,
  `outputJsTheme` tinyint(1) DEFAULT 1,
  `outputCssLocation` varchar(255) DEFAULT NULL,
  `outputJsLocation` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ivnbqrrsusukwlcovuppjzsxzjawjzeauitw` (`fieldLayoutId`),
  CONSTRAINT `fk_fichcmwibfuzkopsjybkcsogwrymzfprbqso` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_integrations`
--

DROP TABLE IF EXISTS `formie_integrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_integrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `enabled` varchar(255) NOT NULL DEFAULT 'true',
  `settings` mediumtext DEFAULT NULL,
  `cache` longtext DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_notifications`
--

DROP TABLE IF EXISTS `formie_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `formId` int(11) NOT NULL,
  `templateId` int(11) DEFAULT NULL,
  `pdfTemplateId` int(11) DEFAULT NULL,
  `name` text NOT NULL,
  `handle` varchar(64) NOT NULL,
  `enabled` tinyint(1) DEFAULT 1,
  `subject` text DEFAULT NULL,
  `recipients` enum('email','conditions') NOT NULL DEFAULT 'email',
  `to` text DEFAULT NULL,
  `toConditions` text DEFAULT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `replyTo` text DEFAULT NULL,
  `replyToName` text DEFAULT NULL,
  `from` text DEFAULT NULL,
  `fromName` text DEFAULT NULL,
  `sender` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `attachFiles` tinyint(1) DEFAULT 1,
  `attachPdf` tinyint(1) DEFAULT 0,
  `attachAssets` text DEFAULT NULL,
  `enableConditions` tinyint(1) DEFAULT 0,
  `conditions` text DEFAULT NULL,
  `customSettings` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_zxqfoctgxwbdevfmmabgkrmwwqufuraobahh` (`formId`),
  KEY `idx_ksvgenjmxuqvmstuvbkfuptspgbbwqqmobkg` (`templateId`),
  KEY `fk_hbzxebnldpvsnatdeumrzzrlnlafggxyxqdm` (`pdfTemplateId`),
  CONSTRAINT `fk_hbzxebnldpvsnatdeumrzzrlnlafggxyxqdm` FOREIGN KEY (`pdfTemplateId`) REFERENCES `formie_pdftemplates` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_jpfstsfcpjbftrpchydfmynrxpqeyjnuyuep` FOREIGN KEY (`formId`) REFERENCES `formie_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_qafechuvybojsdanjvlitganxgabnizpjioo` FOREIGN KEY (`templateId`) REFERENCES `formie_emailtemplates` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_payments`
--

DROP TABLE IF EXISTS `formie_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) NOT NULL,
  `submissionId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `subscriptionId` int(11) DEFAULT NULL,
  `amount` decimal(14,4) DEFAULT NULL,
  `currency` varchar(255) DEFAULT NULL,
  `status` enum('pending','redirect','success','failed','processing') NOT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `redirectUrl` text DEFAULT NULL,
  `note` mediumtext DEFAULT NULL,
  `response` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_pbpccfwvxsddledccvybkyltlglhtsiiyduh` (`integrationId`),
  KEY `idx_kmdzjixkgxdsvydtmpsqepvqwlpqckytrras` (`fieldId`),
  KEY `idx_ljfmfdvtpljvxqwdzuttbyxoatjofonlzhel` (`reference`),
  KEY `fk_pewvqtdjfutudzwwlfnpwujpdxoeebrwgvaw` (`submissionId`),
  KEY `fk_hwdxrwbyjrmnjkqdmrjnhqcjvzymdyvtfxoe` (`subscriptionId`),
  CONSTRAINT `fk_hwdxrwbyjrmnjkqdmrjnhqcjvzymdyvtfxoe` FOREIGN KEY (`subscriptionId`) REFERENCES `formie_payments_subscriptions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_jdwnwutfmlpcfizxnevsycehuzmnxhvyufcr` FOREIGN KEY (`integrationId`) REFERENCES `formie_integrations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_pewvqtdjfutudzwwlfnpwujpdxoeebrwgvaw` FOREIGN KEY (`submissionId`) REFERENCES `formie_submissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zxgjdlztummejihvjzdgkspmadwkcxwnrqkr` FOREIGN KEY (`fieldId`) REFERENCES `formie_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_payments_plans`
--

DROP TABLE IF EXISTS `formie_payments_plans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_payments_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `handle` varchar(255) DEFAULT NULL,
  `reference` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `planData` text DEFAULT NULL,
  `isArchived` tinyint(1) NOT NULL,
  `dateArchived` datetime DEFAULT NULL,
  `sortOrder` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_gsqragqbhwexxmiptcirqaaumovfjyvdlfzb` (`handle`),
  KEY `idx_hmvurhqpfrkwcdmnyeirkozngfyropqjabiv` (`integrationId`),
  KEY `idx_anutxptxtxzxnmxzvfnqgasbnvvnophoojqn` (`reference`),
  CONSTRAINT `fk_hoawurlvwiyyjfmxlsfaehjrtgywcertkpqc` FOREIGN KEY (`integrationId`) REFERENCES `formie_integrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_payments_subscriptions`
--

DROP TABLE IF EXISTS `formie_payments_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_payments_subscriptions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) DEFAULT NULL,
  `submissionId` int(11) DEFAULT NULL,
  `fieldId` int(11) DEFAULT NULL,
  `planId` int(11) DEFAULT NULL,
  `reference` varchar(255) NOT NULL,
  `subscriptionData` text DEFAULT NULL,
  `trialDays` int(11) NOT NULL,
  `nextPaymentDate` datetime DEFAULT NULL,
  `hasStarted` tinyint(1) NOT NULL DEFAULT 1,
  `isSuspended` tinyint(1) NOT NULL DEFAULT 0,
  `dateSuspended` datetime DEFAULT NULL,
  `isCanceled` tinyint(1) NOT NULL,
  `dateCanceled` datetime DEFAULT NULL,
  `isExpired` tinyint(1) NOT NULL,
  `dateExpired` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_nszdpiypzhcwyakbootpxshyktpwzerfrbzf` (`integrationId`),
  KEY `idx_zhvcbesabsmcoegwdwpktdqhcsnhdovhlzrm` (`submissionId`),
  KEY `idx_uletgfycsqbvrdelunglcnjlyvabwridbkty` (`fieldId`),
  KEY `idx_ohoppbbpwtnwwyojayaxfyrsrtoctdlulqcg` (`planId`),
  KEY `idx_llfcdwbgmcnntykgljiutliqdhrvsausrbhi` (`reference`),
  KEY `idx_zzsastgcuehsnntipcjeayqiiiktxdhibpnv` (`nextPaymentDate`),
  KEY `idx_hnsdofoqxmnafdzgkfwtlqkziirrhdcazwpo` (`dateExpired`),
  KEY `idx_qwdhmcokuwuekdyrlnymwistgsyvqwirgigg` (`dateExpired`),
  CONSTRAINT `fk_fiacfdjiyvmkpafronahyrfveeuaauyzwhhb` FOREIGN KEY (`planId`) REFERENCES `formie_payments_plans` (`id`),
  CONSTRAINT `fk_luawsngdzjezbvtbzswvrecbrrsrygmvkwjz` FOREIGN KEY (`integrationId`) REFERENCES `formie_integrations` (`id`),
  CONSTRAINT `fk_mafqwsjkkhduyzenonqoxwdrdbfryetvmnju` FOREIGN KEY (`fieldId`) REFERENCES `formie_fields` (`id`),
  CONSTRAINT `fk_nopxcmmxfmondobylqzshmzbtavtmpwtmbmk` FOREIGN KEY (`submissionId`) REFERENCES `formie_submissions` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_pdftemplates`
--

DROP TABLE IF EXISTS `formie_pdftemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_pdftemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `template` varchar(255) NOT NULL,
  `filenameFormat` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_relations`
--

DROP TABLE IF EXISTS `formie_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `sourceId` int(11) NOT NULL,
  `sourceSiteId` int(11) DEFAULT NULL,
  `targetId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_fkenkvdvfrtrtzlrefzxqobmuwyusbsfllcw` (`sourceId`,`sourceSiteId`,`targetId`),
  KEY `idx_llttzpibnyhbdrymipbzkhpzmnsgwwpavcmo` (`sourceId`),
  KEY `idx_hbfnwnohjgsdoulwdajldpmcuvzhfkfckkbd` (`targetId`),
  KEY `idx_jzsaagwfentfmkfiptzvrnvhzocbvmzwbclk` (`sourceSiteId`),
  CONSTRAINT `fk_hknyrmitrylzxpxxugaflkwtwvrijhjudmdr` FOREIGN KEY (`sourceSiteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_sciuhgapcxftmbgqmnulfkbpzsolhfwnwiqc` FOREIGN KEY (`sourceId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wkyimtleaicvbvzxfclqtunufacelfllugap` FOREIGN KEY (`targetId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_sentnotifications`
--

DROP TABLE IF EXISTS `formie_sentnotifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_sentnotifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `formId` int(11) DEFAULT NULL,
  `submissionId` int(11) DEFAULT NULL,
  `notificationId` int(11) DEFAULT NULL,
  `subject` text DEFAULT NULL,
  `to` text DEFAULT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `replyTo` text DEFAULT NULL,
  `replyToName` text DEFAULT NULL,
  `from` text DEFAULT NULL,
  `fromName` text DEFAULT NULL,
  `sender` text DEFAULT NULL,
  `body` mediumtext DEFAULT NULL,
  `htmlBody` mediumtext DEFAULT NULL,
  `info` text DEFAULT NULL,
  `success` tinyint(1) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `dateUpdated` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_mqmpkuhgvgufeqlggrjgfhuiqxkjtgokjwuc` (`formId`),
  KEY `fk_sytrqqjukpgyazrxrgkxitgiptqqrffqvdxf` (`submissionId`),
  KEY `fk_ffuurdlhwmlgeojoxlzdclittlgukdtysdho` (`notificationId`),
  CONSTRAINT `fk_ffuurdlhwmlgeojoxlzdclittlgukdtysdho` FOREIGN KEY (`notificationId`) REFERENCES `formie_notifications` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_mqmpkuhgvgufeqlggrjgfhuiqxkjtgokjwuc` FOREIGN KEY (`formId`) REFERENCES `formie_forms` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_mvcayarqktrskzgiwybxpyuptxpzkgwtdbmy` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_sytrqqjukpgyazrxrgkxitgiptqqrffqvdxf` FOREIGN KEY (`submissionId`) REFERENCES `formie_submissions` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=11422 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_statuses`
--

DROP TABLE IF EXISTS `formie_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_statuses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `color` enum('green','orange','red','blue','yellow','pink','purple','turquoise','light','grey','black') NOT NULL DEFAULT 'green',
  `description` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `isDefault` tinyint(1) DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_stencils`
--

DROP TABLE IF EXISTS `formie_stencils`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_stencils` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `data` mediumtext DEFAULT NULL,
  `templateId` int(11) DEFAULT NULL,
  `submitActionEntryId` int(11) DEFAULT NULL,
  `submitActionEntrySiteId` int(11) DEFAULT NULL,
  `defaultStatusId` int(11) DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_fyzvxirpggezywbhsiojmfrlrrdkcqchhnev` (`templateId`),
  KEY `idx_rhqthqeoprhffhorqyzdddcnnbngdbmxqray` (`defaultStatusId`),
  CONSTRAINT `fk_jeuoiqhsntnbeatowkqqlsenlqvjjexrlnsv` FOREIGN KEY (`templateId`) REFERENCES `formie_formtemplates` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_pifswfutfxntlzwvfpnckosafkvzronuppem` FOREIGN KEY (`defaultStatusId`) REFERENCES `formie_statuses` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_submissions`
--

DROP TABLE IF EXISTS `formie_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_submissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`content`)),
  `formId` int(11) NOT NULL,
  `statusId` int(11) DEFAULT NULL,
  `userId` int(11) DEFAULT NULL,
  `isIncomplete` tinyint(1) DEFAULT 0,
  `isSpam` tinyint(1) DEFAULT 0,
  `spamReason` text DEFAULT NULL,
  `spamClass` varchar(255) DEFAULT NULL,
  `snapshot` text DEFAULT NULL,
  `ipAddress` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_olhwfygrtbpbmujrokconqbtpovixoozahum` (`formId`),
  KEY `idx_ihovtpcpdubtodiaudryjjvedjzylitswzah` (`statusId`),
  KEY `idx_zaogrohjldodbykdyhyhbemdldyzbmmadjga` (`userId`),
  CONSTRAINT `fk_lrgpcpaueytvbxkmowfrymxrmpukzoddkhuw` FOREIGN KEY (`formId`) REFERENCES `formie_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ookegsgoqxoncsjobblmoluviszeggpxzjtz` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_wzcashzdbqtqwjvstxacgoyyuaathxgmrusd` FOREIGN KEY (`statusId`) REFERENCES `formie_statuses` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_xmzmkirxvmsxwanzeoayftmfuxoajxbcalnw` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11421 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `globalsets`
--

DROP TABLE IF EXISTS `globalsets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `globalsets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_xbsaazzhfhszjjvlrtwakfprfftqylfpoixl` (`name`),
  KEY `idx_oekjlhinxdcgehqfghqgsitypscdnsmtpyiy` (`handle`),
  KEY `idx_pcmckodvesbnmrquykwlfoaxnixovjpovxlj` (`fieldLayoutId`),
  KEY `idx_agwesgbdiznudgikaivifjxnsxdqljydismg` (`sortOrder`),
  CONSTRAINT `fk_abuqvrvmzewsyxtxaizvqgrmfbetlpqmzscq` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_riekewyysqlkppelpzwfwrhantegwhpxccqn` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=555 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `googlemaps_addresses`
--

DROP TABLE IF EXISTS `googlemaps_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `googlemaps_addresses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `formatted` varchar(255) DEFAULT NULL,
  `raw` text DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `street1` varchar(255) DEFAULT NULL,
  `street2` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `neighborhood` varchar(255) DEFAULT NULL,
  `county` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `countryCode` varchar(255) DEFAULT NULL,
  `placeId` varchar(255) DEFAULT NULL,
  `lat` decimal(12,8) DEFAULT NULL,
  `lng` decimal(12,8) DEFAULT NULL,
  `zoom` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_kvewpboexmmxkfkedwfaeivmkkpknwcquoim` (`elementId`,`siteId`,`fieldId`),
  KEY `idx_mgjyhmxoovosoprsajqyhvfpzwjehhuecgdz` (`elementId`),
  KEY `idx_brugxkjnouwaarvezexnxaiudgikpoleaosv` (`siteId`),
  KEY `idx_qkhwwucjjehzuzyjxcybinmhbllgiahxpojr` (`fieldId`),
  KEY `idx_imafefrmhshjeanocszdytsvejjniwqognqy` (`siteId`,`fieldId`),
  KEY `idx_ngoasmkxngxsymdpmacpljledlqbichkrzcn` (`elementId`,`siteId`),
  KEY `idx_icrdjferjjmtcnfsnfexnmwpsybhosgxbijj` (`elementId`,`fieldId`),
  CONSTRAINT `fk_bdhsrifdslnlnqvynhscqmytjtclqlvkqvgh` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_nqvnkbomsoehnizexbvpzvbobwynxzlvjzau` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vivediezdmsegdgoqqvywzulessinjrfkusi` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4834 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqlschemas`
--

DROP TABLE IF EXISTS `gqlschemas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gqlschemas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `scope` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`scope`)),
  `isPublic` tinyint(1) NOT NULL DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqltokens`
--

DROP TABLE IF EXISTS `gqltokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gqltokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `accessToken` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `expiryDate` datetime DEFAULT NULL,
  `lastUsed` datetime DEFAULT NULL,
  `schemaId` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ogdlpvwgfwqnxgziosoqipsbajxwcpdwjpfq` (`accessToken`),
  UNIQUE KEY `idx_twiblfqsstzxrejysmhraysianqcokpkibmz` (`name`),
  KEY `fk_chalaclacaykoxoscfxramybbfsmeojwptnl` (`schemaId`),
  CONSTRAINT `fk_chalaclacaykoxoscfxramybbfsmeojwptnl` FOREIGN KEY (`schemaId`) REFERENCES `gqlschemas` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `imagetransformindex`
--

DROP TABLE IF EXISTS `imagetransformindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `imagetransformindex` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `assetId` int(11) NOT NULL,
  `transformer` varchar(255) DEFAULT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `format` varchar(255) DEFAULT NULL,
  `transformString` varchar(255) NOT NULL,
  `fileExists` tinyint(1) NOT NULL DEFAULT 0,
  `inProgress` tinyint(1) NOT NULL DEFAULT 0,
  `error` tinyint(1) NOT NULL DEFAULT 0,
  `dateIndexed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_fuqeeozcucihypiijzlhbyulpdsbulpbygma` (`assetId`,`transformString`)
) ENGINE=InnoDB AUTO_INCREMENT=4526 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `imagetransforms`
--

DROP TABLE IF EXISTS `imagetransforms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `imagetransforms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `mode` enum('stretch','fit','crop','letterbox') NOT NULL DEFAULT 'crop',
  `position` enum('top-left','top-center','top-right','center-left','center-center','center-right','bottom-left','bottom-center','bottom-right') NOT NULL DEFAULT 'center-center',
  `width` int(10) unsigned DEFAULT NULL,
  `height` int(10) unsigned DEFAULT NULL,
  `format` varchar(255) DEFAULT NULL,
  `quality` int(11) DEFAULT NULL,
  `interlace` enum('none','line','plane','partition') NOT NULL DEFAULT 'none',
  `fill` varchar(11) DEFAULT NULL,
  `upscale` tinyint(1) NOT NULL DEFAULT 1,
  `parameterChangeTime` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_mltxzxqagzcumyyrnndebhvcxrrukqglcxsx` (`name`),
  KEY `idx_zhmqifimxmjppdwuaxxdkxrffslngdzxcfdl` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `info`
--

DROP TABLE IF EXISTS `info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) NOT NULL,
  `schemaVersion` varchar(15) NOT NULL,
  `maintenance` tinyint(1) NOT NULL DEFAULT 0,
  `configVersion` char(12) NOT NULL DEFAULT '000000000000',
  `fieldVersion` char(12) NOT NULL DEFAULT '000000000000',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `track` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `applyTime` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_hokepbzjninyxdvfjfnijzzopbbwebbeobxn` (`track`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `plugins`
--

DROP TABLE IF EXISTS `plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `plugins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` varchar(255) NOT NULL,
  `version` varchar(255) NOT NULL,
  `schemaVersion` varchar(255) NOT NULL,
  `installDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_yjxfmhlhejuqmhasefmufgetzyskntqrqzem` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `projectconfig`
--

DROP TABLE IF EXISTS `projectconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projectconfig` (
  `path` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue`
--

DROP TABLE IF EXISTS `queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel` varchar(255) NOT NULL DEFAULT 'queue',
  `job` longblob NOT NULL,
  `description` text DEFAULT NULL,
  `timePushed` int(11) NOT NULL,
  `ttr` int(11) NOT NULL,
  `delay` int(11) NOT NULL DEFAULT 0,
  `priority` int(10) unsigned NOT NULL DEFAULT 1024,
  `dateReserved` datetime DEFAULT NULL,
  `timeUpdated` int(11) DEFAULT NULL,
  `progress` smallint(6) NOT NULL DEFAULT 0,
  `progressLabel` varchar(255) DEFAULT NULL,
  `attempt` int(11) DEFAULT NULL,
  `fail` tinyint(1) DEFAULT 0,
  `dateFailed` datetime DEFAULT NULL,
  `error` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_mbkdbqdnsdqkupumbwhvaipofvnvhvivegkc` (`channel`,`fail`,`timeUpdated`,`timePushed`),
  KEY `idx_rmgvdauuujsoeewlyivkfntmyljkozojtunh` (`channel`,`fail`,`timeUpdated`,`delay`)
) ENGINE=InnoDB AUTO_INCREMENT=24574 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `recoverycodes`
--

DROP TABLE IF EXISTS `recoverycodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `recoverycodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `recoveryCodes` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `relations`
--

DROP TABLE IF EXISTS `relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldId` int(11) NOT NULL,
  `sourceId` int(11) NOT NULL,
  `sourceSiteId` int(11) DEFAULT NULL,
  `targetId` int(11) NOT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_gtkubxldumrdhogfwakgskbciupcusvafuqe` (`fieldId`,`sourceId`,`sourceSiteId`,`targetId`),
  KEY `idx_wjqdselkasklqvojxksaspfrjjampxaiguep` (`sourceId`),
  KEY `idx_ljbakwrnceegyzzhwmologvanyctoojvyjwz` (`targetId`),
  KEY `idx_dksxuagleembzlnuapswpewfpjzdnytgmiqm` (`sourceSiteId`),
  CONSTRAINT `fk_lynlgeiiwesivccxiiqdhzsjtzqduvdqowlh` FOREIGN KEY (`sourceId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ogujvhfyrzouqcbwfswvpvzaggtbkfsmatzk` FOREIGN KEY (`sourceSiteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ubslzsujihoamjhneyxhzvnfwfemreqgvome` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=61613 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `resourcepaths`
--

DROP TABLE IF EXISTS `resourcepaths`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resourcepaths` (
  `hash` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  PRIMARY KEY (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `canonicalId` int(11) NOT NULL,
  `creatorId` int(11) DEFAULT NULL,
  `num` int(11) NOT NULL,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_vovfedpvphsnrkjgenttfyeflnvxiiktyeto` (`canonicalId`,`num`),
  KEY `fk_hhcoenppvmvdebazuoowwqofstjgxyikfbaz` (`creatorId`),
  CONSTRAINT `fk_hhcoenppvmvdebazuoowwqofstjgxyikfbaz` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_wiafzflznoonbpoobdjzrqktmxhlqxjsmeml` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4610 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindex`
--

DROP TABLE IF EXISTS `searchindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindex` (
  `elementId` int(11) NOT NULL,
  `attribute` varchar(25) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `keywords` text NOT NULL,
  PRIMARY KEY (`elementId`,`attribute`,`fieldId`,`siteId`),
  FULLTEXT KEY `idx_xktlgbqafoazkhqgwffwkojajphychvralgk` (`keywords`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindexqueue`
--

DROP TABLE IF EXISTS `searchindexqueue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindexqueue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `reserved` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_vukubcqmqptdqhnjzffekcltjlskakssoxux` (`elementId`,`siteId`,`reserved`),
  CONSTRAINT `fk_yoxlyfepzvxrllzacpkqrqvglkwxjfswxgjh` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9895 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindexqueue_fields`
--

DROP TABLE IF EXISTS `searchindexqueue_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindexqueue_fields` (
  `jobId` int(11) NOT NULL,
  `fieldHandle` varchar(255) NOT NULL,
  PRIMARY KEY (`jobId`,`fieldHandle`),
  UNIQUE KEY `idx_qdndfxhuijqbydgqelcnmyopalwmuxymxwsg` (`jobId`,`fieldHandle`),
  CONSTRAINT `fk_dcqpxgjgquvnwtwfuoqiskmkciulpaitiasy` FOREIGN KEY (`jobId`) REFERENCES `searchindexqueue` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections`
--

DROP TABLE IF EXISTS `sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `type` enum('single','channel','structure') NOT NULL DEFAULT 'channel',
  `enableVersioning` tinyint(1) NOT NULL DEFAULT 0,
  `maxAuthors` smallint(5) unsigned DEFAULT NULL,
  `propagationMethod` varchar(255) NOT NULL DEFAULT 'all',
  `defaultPlacement` enum('beginning','end') NOT NULL DEFAULT 'end',
  `previewTargets` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`previewTargets`)),
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qrpmxnrfdjqpcopeltsisloriogabqdfaurp` (`handle`),
  KEY `idx_lxsrucgwoiznmcttjddzpotbrkcackcqqoje` (`name`),
  KEY `idx_utlycaldrseybljwruetlrqruihxjocmutvg` (`structureId`),
  KEY `idx_mdzvlemchdowfonenjrjihvswxdlogpeqwyg` (`dateDeleted`),
  CONSTRAINT `fk_vfyocjkdagdwihnjzqqrvugbgscisixtvczd` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections_entrytypes`
--

DROP TABLE IF EXISTS `sections_entrytypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections_entrytypes` (
  `sectionId` int(11) NOT NULL,
  `typeId` int(11) NOT NULL,
  `sortOrder` smallint(5) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `handle` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`sectionId`,`typeId`),
  KEY `fk_fzigcrmravgmjettoztjeftkyrlaprkqnysd` (`typeId`),
  CONSTRAINT `fk_drwrmldkqtjkxxucxxbzrhgyyjkfyfcybgus` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_fzigcrmravgmjettoztjeftkyrlaprkqnysd` FOREIGN KEY (`typeId`) REFERENCES `entrytypes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections_sites`
--

DROP TABLE IF EXISTS `sections_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sectionId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT 1,
  `uriFormat` text DEFAULT NULL,
  `template` varchar(500) DEFAULT NULL,
  `enabledByDefault` tinyint(1) NOT NULL DEFAULT 1,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_sjfbyghiwpeyxcuyphrglivoldlooghoofln` (`sectionId`,`siteId`),
  KEY `idx_fvdgzfzqkyjrlybsmzbmdyzwgztjeuuwhmep` (`siteId`),
  CONSTRAINT `fk_vlwdqpgzrrzybebxkteyxjjjzurerhqwaplj` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_xxqvpgliyyjqfdpqaoetmruffzwhxcdfcnrq` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequences`
--

DROP TABLE IF EXISTS `sequences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequences` (
  `name` varchar(255) NOT NULL,
  `next` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `token` char(100) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_kilfokhjllioafxuubkvjdcixmrsekotyjhg` (`uid`),
  KEY `idx_njmiqpmztdeqgzgbsvfamewjqfrxmkphaqtj` (`token`),
  KEY `idx_tnwbupjfwdkdanuwtvpfzfalryslymvgvtze` (`dateUpdated`),
  KEY `idx_khjbkwfudyxgliaqlrendaqfjwdyxwgtuxjb` (`userId`),
  CONSTRAINT `fk_bekwypktjzctsibpuhnymderwsiuwtibgqhc` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=238 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `shunnedmessages`
--

DROP TABLE IF EXISTS `shunnedmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shunnedmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `message` varchar(255) NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_aaoaazajyxmzihslmjgrgtbicncsriryfchn` (`userId`,`message`),
  CONSTRAINT `fk_qfodjaorjzskvwglfrxoisuvanymqqcvgwlu` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sitegroups`
--

DROP TABLE IF EXISTS `sitegroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sitegroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_wotsdtzykyxrnlpgkmamgfwimmypdgimmxme` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sites`
--

DROP TABLE IF EXISTS `sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `primary` tinyint(1) NOT NULL,
  `enabled` varchar(255) NOT NULL DEFAULT 'true',
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `language` varchar(255) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT 0,
  `baseUrl` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_gvthfinszicvegnghpypqvjyxbqzddgbrape` (`dateDeleted`),
  KEY `idx_wtrpnmcmvqellmztgodbqedlonroyqvsmwyb` (`handle`),
  KEY `idx_ksomrwvmiuodevyqoavcvapuhjdbqwmaqroq` (`sortOrder`),
  KEY `fk_sfbucdquvkgcghgtwgjgnxmxyvvlinltawtl` (`groupId`),
  CONSTRAINT `fk_sfbucdquvkgcghgtwgjgnxmxyvvlinltawtl` FOREIGN KEY (`groupId`) REFERENCES `sitegroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sso_identities`
--

DROP TABLE IF EXISTS `sso_identities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sso_identities` (
  `provider` varchar(255) NOT NULL,
  `identityId` varchar(255) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`provider`,`identityId`,`userId`),
  KEY `fk_tzaclnpswsibbekhqqcwgglzwhxdxfhnxiue` (`userId`),
  CONSTRAINT `fk_tzaclnpswsibbekhqqcwgglzwhxdxfhnxiue` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structureelements`
--

DROP TABLE IF EXISTS `structureelements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `structureelements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) NOT NULL,
  `elementId` int(11) DEFAULT NULL,
  `root` int(10) unsigned DEFAULT NULL,
  `lft` int(10) unsigned NOT NULL,
  `rgt` int(10) unsigned NOT NULL,
  `level` smallint(5) unsigned NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_glwsesfxeuywleseaskiatelgqwhsavphfrk` (`structureId`,`elementId`),
  KEY `idx_ohtyplamqxdgdvwoewiufbgfssopjcnmobge` (`root`),
  KEY `idx_izhqjbyrvekgahskdtwwfrtdwxsxittabvdp` (`lft`),
  KEY `idx_mntqqgbsgtmmuqztopbyqqsewgvogzcwkgsj` (`rgt`),
  KEY `idx_crinuebacqhlojgjzlutlnsrduujsndwwxux` (`level`),
  KEY `idx_qksygbxkmeaxgbsnpapwjimqfaxckwnsynzh` (`elementId`),
  CONSTRAINT `fk_polmcjevuxconbxjzmwypjizowoyyalakuga` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=207 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structures`
--

DROP TABLE IF EXISTS `structures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `structures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `maxLevels` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_vurwjlkxxmzdpcxvjeiisrjpptdstfqmxjtf` (`dateDeleted`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `systemmessages`
--

DROP TABLE IF EXISTS `systemmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `systemmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_etrewehssuqhqbrnqtyeafgiicowmywmjdgr` (`key`,`language`),
  KEY `idx_cllsekzmrcdtmciypfmewxfovgqqebegrhwr` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taggroups`
--

DROP TABLE IF EXISTS `taggroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `taggroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uavrgdjpotgogvrnlzfdumjufmaqyuuxujly` (`name`),
  KEY `idx_yldnmnceyqfaubyllydpjbhiiduwasouaycf` (`handle`),
  KEY `idx_uyueliiozbqtgcnrxcyjoxovkmthrexvcsmt` (`dateDeleted`),
  KEY `fk_hwbtqbpxtsynsgcrpnyskmdebwhmmwsakzex` (`fieldLayoutId`),
  CONSTRAINT `fk_hwbtqbpxtsynsgcrpnyskmdebwhmmwsakzex` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_rgiwbykgvorxrpuyakeblpjfenuxaxsdxjpm` (`groupId`),
  CONSTRAINT `fk_jeakhckbbkxymeltjxwzwxufybyhyxifcjgo` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_mvibepzqksdytkxjohuuwuylabzlyrdqlfre` FOREIGN KEY (`groupId`) REFERENCES `taggroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tokens`
--

DROP TABLE IF EXISTS `tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` char(32) NOT NULL,
  `route` text DEFAULT NULL,
  `usageLimit` tinyint(3) unsigned DEFAULT NULL,
  `usageCount` tinyint(3) unsigned DEFAULT NULL,
  `expiryDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_iguhilcajijkqzzmiuaqsnvkjisprqlcqmme` (`token`),
  KEY `idx_bgrdrdanvrlcjwrwqyrwtzaipjiympabilql` (`expiryDate`)
) ENGINE=InnoDB AUTO_INCREMENT=348 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups`
--

DROP TABLE IF EXISTS `usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `usergroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_nifgpehogtkhcvvjwvdwmfwlozfdnbsujsgs` (`handle`),
  KEY `idx_jrxgafsujnsuoqncgwjlevwprvvtpfvuheha` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups_users`
--

DROP TABLE IF EXISTS `usergroups_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `usergroups_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_wbuxnxijmlcywxwuweutdpvzwupsblalziyu` (`groupId`,`userId`),
  KEY `idx_dqsqmznpdazocfzhimavjhxfgesvrsavnphg` (`userId`),
  CONSTRAINT `fk_ljeblfdgmxbubgysbibtizlwmlknlkupehih` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_nmguplpcqlnmygqmojtshsryqwgyoystbyce` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions`
--

DROP TABLE IF EXISTS `userpermissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ddentucjxuehhjtoimzoqdtygrwphwzvaxww` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_usergroups`
--

DROP TABLE IF EXISTS `userpermissions_usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions_usergroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permissionId` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ucjurorivfhaorffdrnomvhgtccyazavhutz` (`permissionId`,`groupId`),
  KEY `idx_fnmnqwfixjevawiudypfcgvtigcnbipmovhe` (`groupId`),
  CONSTRAINT `fk_ahbgiomxhstwpcelpekgmyiuypuuazcculwj` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zxjibncdboywfmcxqwhpostyonqmcgmqnmds` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_users`
--

DROP TABLE IF EXISTS `userpermissions_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permissionId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_agjecihoglwrhpzfepiretvhgyrsyeydbien` (`permissionId`,`userId`),
  KEY `idx_gwgqwdcwjrmjrewzsdulljzkbnhwohhhdole` (`userId`),
  CONSTRAINT `fk_edvjmuwynfgcnocdgkpinysmqwewednubgsx` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_xwygztsglwroncjawbabwftszxrhhcliojsx` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpreferences`
--

DROP TABLE IF EXISTS `userpreferences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpreferences` (
  `userId` int(11) NOT NULL AUTO_INCREMENT,
  `preferences` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`preferences`)),
  PRIMARY KEY (`userId`),
  CONSTRAINT `fk_ndzcvkhzlvudkhfdijyylmzljbmswdgdhemh` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `photoId` int(11) DEFAULT NULL,
  `affiliatedSiteId` int(11) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `pending` tinyint(1) NOT NULL DEFAULT 0,
  `locked` tinyint(1) NOT NULL DEFAULT 0,
  `suspended` tinyint(1) NOT NULL DEFAULT 0,
  `admin` tinyint(1) NOT NULL DEFAULT 0,
  `username` varchar(255) DEFAULT NULL,
  `fullName` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `lastLoginDate` datetime DEFAULT NULL,
  `lastLoginAttemptIp` varchar(45) DEFAULT NULL,
  `invalidLoginWindowStart` datetime DEFAULT NULL,
  `invalidLoginCount` tinyint(3) unsigned DEFAULT NULL,
  `lastInvalidLoginDate` datetime DEFAULT NULL,
  `lockoutDate` datetime DEFAULT NULL,
  `hasDashboard` tinyint(1) NOT NULL DEFAULT 0,
  `verificationCode` varchar(255) DEFAULT NULL,
  `verificationCodeIssuedDate` datetime DEFAULT NULL,
  `unverifiedEmail` varchar(255) DEFAULT NULL,
  `passwordResetRequired` tinyint(1) NOT NULL DEFAULT 0,
  `lastPasswordChangeDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_zpgnwdxlibbpqazfhgiwlypvdkvfnbhvbofm` (`active`),
  KEY `idx_yblhifndlrcnhyhntbrnildiqaxglncchxaf` (`locked`),
  KEY `idx_uvqjtsznmwpxjnrznfuhevpvmbyaohgpdsuz` (`pending`),
  KEY `idx_mlimddujldrcphevposyxvdwufmefhhekgis` (`suspended`),
  KEY `idx_suhaweibsmrkzahdbttcrozifoymoiqwaevc` (`verificationCode`),
  KEY `idx_pmwjwhvicilxxwxrvjmzmvcqqajgpeaokyhq` (`email`),
  KEY `idx_svrmuefimiuinvktrrntubsnuknqkufdojdg` (`username`),
  KEY `fk_ktgltzjkmpoqfsdclgvnmiroliayurdlnviy` (`photoId`),
  KEY `fk_tnnwhvjjcpdbztlspbsbcziwqoqjzwzwwirb` (`affiliatedSiteId`),
  CONSTRAINT `fk_ktgltzjkmpoqfsdclgvnmiroliayurdlnviy` FOREIGN KEY (`photoId`) REFERENCES `assets` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_pvogbbkodeqspdsqgfvcbkamrfjvbpqfnuvo` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tnnwhvjjcpdbztlspbsbcziwqoqjzwzwwirb` FOREIGN KEY (`affiliatedSiteId`) REFERENCES `sites` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumefolders`
--

DROP TABLE IF EXISTS `volumefolders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumefolders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parentId` int(11) DEFAULT NULL,
  `volumeId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `path` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_xymsimganfahzmnhhaxbizplgrkrozpeqovc` (`name`,`parentId`,`volumeId`),
  KEY `idx_vvdhtvkgzdckqxhuwvsmzaxijrvcrtfhcuai` (`parentId`),
  KEY `idx_lxshjhzcrxghtwsrndsufsgsfqigqpzjnrtc` (`volumeId`),
  CONSTRAINT `fk_cltqwyvsdanditwyzasjkmcotokzlpizvaaz` FOREIGN KEY (`parentId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ktzfquwhcsxsnxyahxfiduamgksdpfvfpxql` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fs` varchar(255) NOT NULL,
  `subpath` varchar(255) DEFAULT NULL,
  `transformFs` varchar(255) DEFAULT NULL,
  `transformSubpath` varchar(255) DEFAULT NULL,
  `titleTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text DEFAULT NULL,
  `altTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `altTranslationKeyFormat` text DEFAULT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_gbigkeuoxhyqciuxrrmcfnnfvmsymtdtlkgk` (`name`),
  KEY `idx_nibgarnftzszvgolotdqcktqauupeyhpcqgo` (`handle`),
  KEY `idx_ndvgpmousdymdklznjefxqtpldprglmmbqhj` (`fieldLayoutId`),
  KEY `idx_gusuktkxxflgmckzckhzuameydxzprqrhkfj` (`dateDeleted`),
  CONSTRAINT `fk_nyzfmnsroeqpwepnfcjzoeuevldyotxpgwqo` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `webauthn`
--

DROP TABLE IF EXISTS `webauthn`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `webauthn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `credentialId` varchar(255) DEFAULT NULL,
  `credential` text DEFAULT NULL,
  `credentialName` varchar(255) DEFAULT NULL,
  `dateLastUsed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_iwgkrireoeyxfnrukfprchjerpaxphldcxvj` (`userId`),
  CONSTRAINT `fk_iwgkrireoeyxfnrukfprchjerpaxphldcxvj` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `colspan` tinyint(4) DEFAULT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`settings`)),
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_nerzmenxwpjdybozzdiijnhabosizuuofrex` (`userId`),
  CONSTRAINT `fk_otipcgdghpcpsmkctrysvrtttpiqgarfiigu` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping routines for database 'akg_craft'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2026-01-20 10:39:21
/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.15-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: akg_craft
-- ------------------------------------------------------
-- Server version	10.11.15-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `addresses`
--

LOCK TABLES `addresses` WRITE;
/*!40000 ALTER TABLE `addresses` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `addresses` VALUES
(8,2,2,'US','NJ','Toms River',NULL,'08757',NULL,'1750 NJ-37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 17:32:44','2025-04-18 17:32:44');
/*!40000 ALTER TABLE `addresses` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assetindexingsessions`
--

LOCK TABLES `assetindexingsessions` WRITE;
/*!40000 ALTER TABLE `assetindexingsessions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `assetindexingsessions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `assets` VALUES
(136,2,2,1,'arbors-entrance.jpg',NULL,'image',NULL,1920,1440,1835577,NULL,NULL,NULL,'2025-04-18 18:44:35','2025-04-18 18:44:35','2025-04-18 18:44:35'),
(137,2,2,1,'arbors-room.jpg',NULL,'image',NULL,1500,1000,220928,NULL,NULL,NULL,'2025-04-18 18:44:36','2025-04-18 18:44:36','2025-04-18 18:44:36'),
(138,2,2,1,'arbors-table.jpg',NULL,'image',NULL,1500,1000,402800,NULL,NULL,NULL,'2025-04-18 18:44:36','2025-04-18 18:44:36','2025-04-18 18:44:36'),
(285,5,7,1,'hands_holding.jpg','image/jpeg','image',NULL,1601,801,850595,NULL,NULL,NULL,'2025-09-05 20:01:00','2025-07-30 22:47:59','2025-09-05 20:01:00'),
(545,2,2,1,'Arbors-Cover-Photo.jpg','image/jpeg','image',NULL,5002,3336,4317908,'0.4259;0.4685',NULL,NULL,'2025-09-02 20:43:22','2025-09-02 20:43:22','2026-01-12 19:44:15'),
(548,3,3,1,'Arbors-flyer.pdf','application/pdf','pdf',NULL,NULL,NULL,1965207,NULL,NULL,NULL,'2025-09-02 21:15:28','2025-09-02 21:15:29','2025-09-02 21:15:29'),
(612,6,8,1,'GreatPlacetoWork.jpg','image/jpeg','image',NULL,500,500,91067,NULL,NULL,NULL,'2025-09-03 21:56:34','2025-09-03 21:56:34','2025-09-03 21:56:34'),
(613,6,8,1,'StrivingforTen.jpg','image/jpeg','image',NULL,500,500,55294,NULL,NULL,NULL,'2025-09-03 21:56:34','2025-09-03 21:56:34','2025-09-03 21:56:34'),
(614,6,8,1,'5Star_OQM.jpg','image/jpeg','image',NULL,500,500,99483,NULL,NULL,NULL,'2025-09-03 21:56:35','2025-09-03 21:56:35','2025-09-03 21:56:35'),
(632,4,4,1,'Arbors-Admin.jpg','image/jpeg','image',NULL,1080,1080,62300,NULL,NULL,NULL,'2025-09-03 22:27:11','2025-09-03 22:27:11','2025-09-03 22:27:11'),
(634,4,4,1,'Arbors-AD-1.jpg','image/jpeg','image',NULL,1080,1080,75707,NULL,NULL,NULL,'2025-09-03 22:27:23','2025-09-03 22:27:23','2025-09-03 22:27:23'),
(2516,6,8,1,'StriveforTen_Updated.jpg','image/jpeg','image',NULL,1000,1000,194040,NULL,NULL,NULL,'2025-09-19 16:58:14','2025-09-19 16:58:14','2025-09-19 16:58:14'),
(2594,5,7,1,'ListenToUsVideo.jpg','image/jpeg','image',NULL,1248,702,524232,NULL,NULL,NULL,'2025-09-19 18:57:57','2025-09-19 18:57:57','2025-09-19 18:57:57'),
(2800,7,9,1,'rehab_2025-09-23-212249_sgzj.png','image/png','image',NULL,178,178,10114,NULL,NULL,NULL,'2025-09-23 21:22:49','2025-09-23 21:13:16','2025-09-23 21:22:49'),
(2803,7,9,1,'post-acute_2025-09-23-212238_tmva.png','image/png','image',NULL,178,178,8458,NULL,NULL,NULL,'2025-09-23 21:22:38','2025-09-23 21:13:36','2025-09-23 21:22:38'),
(2806,7,9,1,'advanced_2025-09-23-212231_zbhk.png','image/png','image',NULL,178,178,9147,NULL,NULL,NULL,'2025-09-23 21:22:31','2025-09-23 21:13:42','2025-09-23 21:22:31'),
(2809,7,9,1,'long-term_2025-09-23-212224_mktw.png','image/png','image',NULL,178,178,11754,NULL,NULL,NULL,'2025-09-23 21:22:24','2025-09-23 21:13:48','2025-09-23 21:22:24'),
(2855,5,7,1,'WhatisaRespiteStay_Article.jpg','image/jpeg','image',NULL,1020,510,144402,NULL,NULL,NULL,'2025-09-24 17:19:20','2025-09-24 17:19:20','2025-09-24 17:19:20'),
(2856,5,7,1,'CaringForaLovedOneatHome_Article.jpg','image/jpeg','image',NULL,1020,510,113589,NULL,NULL,NULL,'2025-09-24 17:19:27','2025-09-24 17:19:27','2025-09-24 17:19:27'),
(2857,5,7,1,'CaringFortheWholePerson_Article.jpg','image/jpeg','image',NULL,1020,510,145044,NULL,NULL,NULL,'2025-09-24 17:19:28','2025-09-24 17:19:28','2025-09-24 17:19:28'),
(2858,5,7,1,'LevelsofCareExplained_Article.jpg','image/jpeg','image',NULL,1020,510,105189,NULL,NULL,NULL,'2025-09-24 17:19:28','2025-09-24 17:19:28','2025-09-24 17:19:28'),
(2869,6,8,1,'BestOfMineralCounty.png','image/png','image',NULL,299,300,75547,NULL,NULL,NULL,'2025-09-24 18:09:43','2025-09-24 18:09:43','2025-09-24 18:09:43'),
(2870,6,8,1,'GreatPlaceToWork-2025.png','image/png','image',NULL,300,302,25150,NULL,NULL,NULL,'2025-09-24 18:09:44','2025-09-24 18:09:44','2025-09-24 18:09:44'),
(2871,6,8,1,'JointCommission.png','image/png','image',NULL,300,302,91559,NULL,NULL,NULL,'2025-09-24 18:09:44','2025-09-24 18:09:44','2025-09-24 18:09:44'),
(2872,6,8,1,'NewsweekBestNursingHomes.png','image/png','image',NULL,299,300,80372,NULL,NULL,NULL,'2025-09-24 18:09:44','2025-09-24 18:09:44','2025-09-24 18:09:44'),
(2873,6,8,1,'5-QM.png','image/png','image',NULL,1200,1200,226362,NULL,NULL,NULL,'2026-01-17 16:29:21','2025-09-24 18:09:45','2026-01-17 16:29:21'),
(2874,6,8,1,'US-News-Best-Nursing-Homes.png','image/png','image',NULL,300,302,64612,NULL,NULL,NULL,'2025-09-24 18:09:45','2025-09-24 18:09:45','2025-10-08 18:29:50'),
(2877,5,7,1,'BeyondBingo_Article.jpg','image/jpeg','image',NULL,1020,510,215411,NULL,NULL,NULL,'2025-09-24 19:41:44','2025-09-24 19:41:44','2025-09-24 19:41:44'),
(2886,6,8,1,'striving_for_ten.png','image/png','image',NULL,1810,1810,221332,NULL,NULL,NULL,'2025-09-25 14:02:18','2025-09-25 14:02:18','2025-09-25 14:02:18'),
(2887,6,8,1,'Bronze-ahca.png','image/png','image',NULL,363,362,114299,NULL,NULL,NULL,'2025-09-25 14:07:12','2025-09-25 14:05:38','2025-09-25 14:07:18'),
(2888,6,8,1,'Silver-AHCA.png','image/png','image',NULL,364,365,108343,NULL,NULL,NULL,'2025-09-25 14:06:48','2025-09-25 14:05:39','2025-09-25 14:07:01'),
(2889,6,8,1,'AHCA-Silver2.png','image/png','image',NULL,364,365,108343,NULL,NULL,NULL,'2025-09-25 15:24:15','2025-09-25 15:18:29','2025-09-25 15:24:15'),
(2890,6,8,1,'AHCA-Bronze-2.png','image/png','image',NULL,363,362,114299,NULL,NULL,NULL,'2025-09-25 15:24:27','2025-09-25 15:18:40','2025-09-25 15:24:27'),
(2927,5,7,1,'QuestionstoAsk_Blog.jpg','image/jpeg','image',NULL,1020,510,135378,NULL,NULL,NULL,'2025-09-30 19:28:01','2025-09-30 19:28:01','2025-09-30 19:28:01'),
(2931,9,13,1,'Complete-Care-Privacy-Policy.pdf','application/pdf','pdf',NULL,NULL,NULL,171776,NULL,NULL,NULL,'2025-11-05 17:40:21','2025-09-30 22:22:11','2025-11-05 17:40:21'),
(2933,9,13,1,'Complete-Care-Website-Privacy-Policy.pdf','application/pdf','pdf',NULL,NULL,NULL,124312,NULL,NULL,NULL,'2025-11-05 17:40:21','2025-09-30 22:22:21','2025-11-05 17:40:21'),
(2934,9,13,1,'Complete-Care-Terms-of-Service.pdf','application/pdf','pdf',NULL,NULL,NULL,93180,NULL,NULL,NULL,'2025-11-05 17:40:21','2025-09-30 22:22:35','2025-11-05 17:40:21'),
(2941,9,13,1,'NonDiscriminationNotice.pdf','application/pdf','pdf',NULL,NULL,NULL,151589,NULL,NULL,NULL,'2025-11-05 17:40:20','2025-09-30 22:43:05','2025-11-05 17:40:20'),
(2968,2,2,1,'DSC_1449.jpg','image/jpeg','image',NULL,6016,4016,12007055,NULL,NULL,NULL,'2025-10-06 17:44:50','2025-10-06 17:44:50','2025-10-06 17:44:50'),
(2970,6,8,1,'CMS_4-Star-QM.png','image/png','image',NULL,2160,2164,694073,NULL,NULL,NULL,'2025-10-06 17:46:00','2025-10-06 17:46:00','2025-10-06 17:46:00'),
(3011,2,2,1,'Brick-Lobby.jpg','image/jpeg','image',NULL,1600,1200,302745,NULL,NULL,NULL,'2025-10-08 18:19:10','2025-10-08 18:19:10','2025-10-08 18:19:10'),
(3017,6,8,1,'CMS-Overall-5.png','image/png','image',NULL,2160,2164,696318,NULL,NULL,NULL,'2025-10-08 18:26:17','2025-10-08 18:26:17','2025-10-08 18:26:17'),
(3018,6,8,1,'CMS-Overall-4.png','image/png','image',NULL,2160,2164,695247,NULL,NULL,NULL,'2025-10-08 18:26:56','2025-10-08 18:26:56','2025-10-08 18:26:56'),
(3019,6,8,1,'CMS-Quality-and-Overall-4.png','image/png','image',NULL,2160,2164,693858,NULL,NULL,NULL,'2025-10-08 18:28:09','2025-10-08 18:28:09','2025-10-08 18:28:09'),
(3020,6,8,1,'US-News-Short-Term.png','image/png','image',NULL,924,976,143109,NULL,NULL,NULL,'2025-10-08 18:29:13','2025-10-08 18:29:13','2025-10-08 18:29:13'),
(3021,6,8,1,'VOHRA.png','image/png','image',NULL,1275,501,71637,NULL,NULL,NULL,'2025-10-08 18:30:50','2025-10-08 18:30:50','2025-10-08 18:31:22'),
(3022,6,8,1,'Local-BOMineral-2025-Logo.png','image/png','image',NULL,3600,3600,4033236,NULL,NULL,NULL,'2025-10-08 18:31:48','2025-10-08 18:31:49','2025-10-08 18:31:49'),
(3023,6,8,1,'Local-BOMineral-2025-Logo_WINNER.png','image/png','image',NULL,3600,3600,4296041,NULL,NULL,NULL,'2025-10-08 18:32:35','2025-10-08 18:32:35','2025-10-08 18:32:35'),
(3048,4,4,1,'Brick-Admin.jpg','image/jpeg','image',NULL,1080,1080,94395,NULL,NULL,NULL,'2025-10-08 18:42:24','2025-10-08 18:42:24','2025-10-08 18:42:24'),
(3058,2,2,1,'BurlingtonWoods-Lobby.jpg','image/jpeg','image',NULL,5044,3363,5445041,NULL,NULL,NULL,'2025-10-08 18:44:46','2025-10-08 18:44:46','2025-10-08 18:44:46'),
(3084,4,4,1,'Burlington-AD-1.jpg','image/jpeg','image',NULL,1080,1080,103887,NULL,NULL,NULL,'2025-10-08 18:51:15','2025-10-08 18:51:15','2025-10-08 18:51:15'),
(3090,2,2,1,'court-house-lobby.jpg','image/jpeg','image',NULL,5968,3979,9229046,NULL,NULL,NULL,'2025-10-08 18:53:50','2025-10-08 18:53:50','2025-10-08 18:54:27'),
(3122,2,2,1,'GreenAcres-Lobby.jpg','image/jpeg','image',NULL,6016,4016,11784141,NULL,NULL,NULL,'2025-10-08 19:52:53','2025-10-08 19:52:54','2025-10-08 19:52:54'),
(3137,4,4,1,'GreenAcres-AD.jpg','image/jpeg','image',NULL,1080,1080,105237,NULL,NULL,NULL,'2025-10-08 19:59:08','2025-10-08 19:59:08','2025-10-08 19:59:08'),
(3158,2,2,1,'HolidayCity-Lobby.jpg','image/jpeg','image',NULL,6016,4016,15103883,'0.5143;0.5189',NULL,NULL,'2025-10-08 20:21:30','2025-10-08 20:21:30','2026-01-13 20:13:21'),
(3180,4,4,1,'Holiday-City-AD.jpg','image/jpeg','image',NULL,1080,1080,97681,NULL,NULL,NULL,'2025-10-08 20:25:38','2025-10-08 20:25:38','2025-10-08 20:25:38'),
(3221,4,4,1,'Bey-Lea-AL-Admin.jpg','image/jpeg','image',NULL,1080,1080,148526,NULL,NULL,NULL,'2025-10-08 22:21:38','2025-10-08 22:21:38','2025-10-08 22:21:38'),
(3235,2,2,1,'bey-lea_bathroom.jpg','image/jpeg','image',NULL,6016,4016,9138369,NULL,NULL,NULL,'2025-10-08 22:24:19','2025-10-08 22:24:19','2025-10-08 22:24:19'),
(3236,2,2,1,'bey-lea_common.jpg','image/jpeg','image',NULL,6016,4016,16366238,NULL,NULL,NULL,'2025-10-08 22:24:35','2025-10-08 22:24:36','2025-10-08 22:24:36'),
(3237,2,2,1,'bey-lea_couch.jpg','image/jpeg','image',NULL,6016,4016,12007055,NULL,NULL,NULL,'2025-10-08 22:24:47','2025-10-08 22:24:47','2025-10-08 22:24:47'),
(3238,2,2,1,'bey-lea_room.jpg','image/jpeg','image',NULL,6016,4016,12238256,NULL,NULL,NULL,'2025-10-08 22:24:58','2025-10-08 22:24:58','2025-10-08 22:24:58'),
(3239,2,2,1,'bey-lea_room2.jpg','image/jpeg','image',NULL,6016,4016,12394826,NULL,NULL,NULL,'2025-10-08 22:25:08','2025-10-08 22:25:08','2025-10-08 22:25:08'),
(3240,2,2,1,'bey-lea_bed.jpg','image/jpeg','image',NULL,6016,4016,14126115,NULL,NULL,NULL,'2025-10-08 22:25:18','2025-10-08 22:25:19','2025-10-08 22:25:19'),
(3241,2,2,1,'bey-lea_clinic.jpg','image/jpeg','image',NULL,6016,4016,10272411,NULL,NULL,NULL,'2025-10-08 22:25:30','2025-10-08 22:25:30','2025-10-08 22:25:30'),
(3242,2,2,1,'bey-lea_gym.jpg','image/jpeg','image',NULL,6016,4016,9866225,NULL,NULL,NULL,'2025-10-08 22:25:39','2025-10-08 22:25:39','2025-10-08 22:25:39'),
(3243,2,2,1,'bey-lea_kitchen.jpg','image/jpeg','image',NULL,6016,4016,12116386,NULL,NULL,NULL,'2025-10-08 22:25:46','2025-10-08 22:25:46','2025-10-08 22:25:46'),
(3244,2,2,1,'bey-lea_lobby.jpg','image/jpeg','image',NULL,6068,3413,2171386,NULL,NULL,NULL,'2025-10-08 22:25:48','2025-10-08 22:25:48','2025-10-08 22:25:48'),
(3245,2,2,1,'bey-lea_bathroom_2025-10-08-222837_modw.jpg','image/jpeg','image',NULL,1200,801,255038,NULL,NULL,NULL,'2025-10-08 22:28:38','2025-10-08 22:28:38','2025-10-08 22:28:38'),
(3246,2,2,1,'bey-lea_bed_2025-10-08-222839_xulc.jpg','image/jpeg','image',NULL,1200,801,413455,NULL,NULL,NULL,'2025-10-08 22:28:39','2025-10-08 22:28:39','2025-10-08 22:28:39'),
(3247,2,2,1,'bey-lea_clinic_2025-10-08-222840_oadk.jpg','image/jpeg','image',NULL,1200,801,286247,NULL,NULL,NULL,'2025-10-08 22:28:40','2025-10-08 22:28:40','2025-10-08 22:28:40'),
(3248,2,2,1,'bey-lea_common_2025-10-08-222840_orrb.jpg','image/jpeg','image',NULL,1200,801,451102,NULL,NULL,NULL,'2025-10-08 22:28:40','2025-10-08 22:28:40','2025-10-08 22:28:40'),
(3249,2,2,1,'bey-lea_couch_2025-10-08-222841_bwye.jpg','image/jpeg','image',NULL,1200,801,289343,NULL,NULL,NULL,'2025-10-08 22:28:41','2025-10-08 22:28:41','2025-10-08 22:28:41'),
(3250,2,2,1,'bey-lea_gym_2025-10-08-222842_arrz.jpg','image/jpeg','image',NULL,1200,801,346341,NULL,NULL,NULL,'2025-10-08 22:28:42','2025-10-08 22:28:42','2025-10-08 22:28:42'),
(3251,2,2,1,'bey-lea_kitchen_2025-10-08-222843_urug.jpg','image/jpeg','image',NULL,1200,801,399046,NULL,NULL,NULL,'2025-10-08 22:28:43','2025-10-08 22:28:43','2025-10-08 22:28:43'),
(3252,2,2,1,'bey-lea_lobby_2025-10-08-222843_pqvz.jpg','image/jpeg','image',NULL,1200,675,311470,NULL,NULL,NULL,'2025-10-08 22:28:43','2025-10-08 22:28:43','2025-10-08 22:28:43'),
(3253,2,2,1,'bey-lea_room_2025-10-08-222844_dvij.jpg','image/jpeg','image',NULL,1200,801,339247,NULL,NULL,NULL,'2025-10-08 22:28:44','2025-10-08 22:28:44','2025-10-08 22:28:44'),
(3254,2,2,1,'bey-lea_room2_2025-10-08-222845_hoiy.jpg','image/jpeg','image',NULL,1200,801,322293,NULL,NULL,NULL,'2025-10-08 22:28:45','2025-10-08 22:28:45','2025-10-08 22:28:45'),
(3276,2,2,1,'BrakeleyPark_Lobby.jpg','image/jpeg','image',NULL,1200,800,352223,NULL,NULL,NULL,'2025-10-08 22:32:31','2025-10-08 22:32:31','2025-10-08 22:32:31'),
(3278,2,2,1,'BrakeleyPark_Lobby2.jpg','image/jpeg','image',NULL,1200,800,399884,NULL,NULL,NULL,'2025-10-08 22:32:34','2025-10-08 22:32:34','2025-10-08 22:32:34'),
(3279,2,2,1,'BrakeleyPark_Lobby3.jpg','image/jpeg','image',NULL,1200,800,347819,NULL,NULL,NULL,'2025-10-08 22:32:35','2025-10-08 22:32:35','2025-10-08 22:32:35'),
(3280,2,2,1,'BrakeleyPark_RehabGym.jpg','image/jpeg','image',NULL,1200,800,321435,NULL,NULL,NULL,'2025-10-08 22:32:37','2025-10-08 22:32:37','2025-10-08 22:32:37'),
(3281,2,2,1,'BrakeleyPark_RehabGym2.jpg','image/jpeg','image',NULL,1200,800,360099,NULL,NULL,NULL,'2025-10-08 22:32:38','2025-10-08 22:32:38','2025-10-08 22:32:38'),
(3282,2,2,1,'BrakeleyPark_Room.jpg','image/jpeg','image',NULL,1200,800,355174,NULL,NULL,NULL,'2025-10-08 22:32:40','2025-10-08 22:32:40','2025-10-08 22:32:40'),
(3283,2,2,1,'BrakeleyPark_Room2.jpg','image/jpeg','image',NULL,1200,800,332176,NULL,NULL,NULL,'2025-10-08 22:32:41','2025-10-08 22:32:41','2025-10-08 22:32:41'),
(3362,2,2,1,'367A4645.jpg','image/jpeg','image',NULL,1200,800,371249,NULL,NULL,NULL,'2025-10-08 22:40:49','2025-10-08 22:40:49','2025-10-08 22:40:49'),
(3363,2,2,1,'367A4650.jpg','image/jpeg','image',NULL,1200,801,304292,NULL,NULL,NULL,'2025-10-08 22:40:50','2025-10-08 22:40:50','2025-10-08 22:40:50'),
(3364,2,2,1,'367A4664.jpg','image/jpeg','image',NULL,1200,800,263017,NULL,NULL,NULL,'2025-10-08 22:40:50','2025-10-08 22:40:50','2025-10-08 22:40:50'),
(3365,2,2,1,'367A4717.jpg','image/jpeg','image',NULL,1200,801,307841,NULL,NULL,NULL,'2025-10-08 22:40:51','2025-10-08 22:40:51','2025-10-08 22:40:51'),
(3366,2,2,1,'367A4731.jpg','image/jpeg','image',NULL,1200,801,295434,NULL,NULL,NULL,'2025-10-08 22:40:52','2025-10-08 22:40:52','2025-10-08 22:40:52'),
(3367,2,2,1,'367A4751.jpg','image/jpeg','image',NULL,1200,801,239398,NULL,NULL,NULL,'2025-10-08 22:40:53','2025-10-08 22:40:53','2025-10-08 22:40:53'),
(3368,2,2,1,'367A4760.jpg','image/jpeg','image',NULL,1200,800,269367,NULL,NULL,NULL,'2025-10-08 22:40:54','2025-10-08 22:40:54','2025-10-08 22:40:54'),
(3369,2,2,1,'367A4773.jpg','image/jpeg','image',NULL,1200,802,277448,NULL,NULL,NULL,'2025-10-08 22:40:55','2025-10-08 22:40:55','2025-10-08 22:40:55'),
(3370,2,2,1,'367A4781.jpg','image/jpeg','image',NULL,1200,800,424423,NULL,NULL,NULL,'2025-10-08 22:40:56','2025-10-08 22:40:56','2025-10-08 22:40:56'),
(3371,2,2,1,'367A4808.jpg','image/jpeg','image',NULL,1200,800,447405,NULL,NULL,NULL,'2025-10-08 22:40:58','2025-10-08 22:40:58','2025-10-08 22:40:58'),
(3372,2,2,1,'367A4820.jpg','image/jpeg','image',NULL,1200,800,490160,NULL,NULL,NULL,'2025-10-08 22:40:59','2025-10-08 22:40:59','2025-10-08 22:40:59'),
(3373,2,2,1,'DJI_0862_ChristianHome_Waupun.jpg','image/jpeg','image',NULL,1200,899,586189,NULL,NULL,NULL,'2025-10-08 22:41:00','2025-10-08 22:41:00','2025-10-08 22:41:00'),
(3374,2,2,1,'IMG_4736_ChristianHome_Waupun.jpg','image/jpeg','image',NULL,1200,800,434955,NULL,NULL,NULL,'2025-10-08 22:41:02','2025-10-08 22:41:02','2025-10-08 22:41:02'),
(3377,2,2,1,'Lobby-7.jpg','image/jpeg','image',NULL,5679,3786,6374436,NULL,NULL,NULL,'2025-10-09 14:40:19','2025-10-09 14:40:19','2025-10-09 14:40:19'),
(3416,4,4,1,'Kresson-Admin.jpg','image/jpeg','image',NULL,1080,1080,83440,NULL,NULL,NULL,'2025-10-09 14:59:18','2025-10-09 14:59:18','2025-10-09 14:59:18'),
(3418,4,4,1,'Kresson-AD.jpg','image/jpeg','image',NULL,1080,1080,109541,NULL,NULL,NULL,'2025-10-09 14:59:46','2025-10-09 14:59:46','2025-10-09 14:59:46'),
(3425,2,2,1,'Laurelton-Lobby.jpg','image/jpeg','image',NULL,6016,4016,9683171,NULL,NULL,NULL,'2025-10-09 16:20:10','2025-10-09 16:20:10','2025-10-09 16:20:23'),
(3467,2,2,1,'Marcella-Lobby-1.jpg','image/jpeg','image',NULL,6000,4000,9570894,NULL,NULL,NULL,'2025-10-09 16:32:34','2025-10-09 16:32:34','2025-10-09 16:32:34'),
(3494,4,4,1,'Marcella-Admin.jpg','image/jpeg','image',NULL,1080,1080,77980,NULL,NULL,NULL,'2025-10-09 16:37:14','2025-10-09 16:37:14','2025-10-09 16:37:14'),
(3495,4,4,1,'Taylor-Manning_Admissions.jpg','image/jpeg','image',NULL,1773,1182,207772,NULL,NULL,NULL,'2025-10-09 16:37:24','2025-10-09 16:37:24','2025-10-09 16:37:24'),
(3498,2,2,1,'Lobby-8.jpg','image/jpeg','image',NULL,5007,3340,3195440,NULL,NULL,NULL,'2025-10-09 16:38:59','2025-10-09 16:38:59','2025-10-09 16:38:59'),
(3530,2,2,1,'OceanGrove_Lobby.jpg','image/jpeg','image',NULL,6720,4480,17099464,NULL,NULL,NULL,'2025-10-09 17:00:32','2025-10-09 17:00:32','2025-10-09 17:00:45'),
(3564,2,2,1,'ShorrockGardens_Lobby.jpg','image/jpeg','image',NULL,6720,4480,17301770,'0.4268;0.5253',NULL,NULL,'2025-10-09 17:07:08','2025-10-09 17:07:08','2026-01-13 21:24:54'),
(3594,2,2,1,'Oasis-Lobby.jpg','image/jpeg','image',NULL,6720,4480,14965855,NULL,NULL,NULL,'2025-10-09 17:14:28','2025-10-09 17:14:29','2025-10-09 17:14:29'),
(3623,2,2,1,'Lobby-9.jpg','image/jpeg','image',NULL,5938,3959,1154995,NULL,NULL,NULL,'2025-10-09 17:21:43','2025-10-09 17:21:43','2025-10-09 17:21:43'),
(3648,4,4,1,'Voorhees-AD.jpg','image/jpeg','image',NULL,1080,1080,139966,NULL,NULL,NULL,'2025-10-09 17:24:30','2025-10-09 17:24:30','2025-10-09 17:24:30'),
(3689,2,2,1,'bayshore-lobby.jpg','image/jpeg','image',NULL,6720,4480,5567512,'0.6060;0.5051',NULL,NULL,'2025-10-09 20:43:00','2025-10-09 20:43:00','2026-01-14 16:18:34'),
(3712,4,4,1,'Bayshore-Admin.jpg','image/jpeg','image',NULL,1080,1080,114319,NULL,NULL,NULL,'2025-10-09 20:47:03','2025-10-09 20:47:03','2025-10-09 20:47:03'),
(3714,4,4,1,'Bayshore-AD.jpg','image/jpeg','image',NULL,1080,1080,74159,NULL,NULL,NULL,'2025-10-09 20:48:06','2025-10-09 20:48:06','2025-10-09 20:48:06'),
(3722,2,2,1,'Cedar-Grove-Lobby.jpg','image/jpeg','image',NULL,4711,3359,963786,'0.5008;0.5227',NULL,NULL,'2026-01-14 16:25:12','2025-10-09 20:50:40','2026-01-14 16:26:23'),
(3746,4,4,1,'Cedar-Grove-Admin.jpg','image/jpeg','image',NULL,1080,1080,66905,NULL,NULL,NULL,'2025-10-09 20:55:28','2025-10-09 20:55:28','2025-10-09 20:55:28'),
(3748,4,4,1,'Cedar-Grove-Admissions-Director.jpg','image/jpeg','image',NULL,1080,1080,130432,NULL,NULL,NULL,'2025-10-09 20:55:46','2025-10-09 20:55:46','2025-10-09 20:55:46'),
(3761,2,2,1,'Clark-Lobby.jpg','image/jpeg','image',NULL,6720,4480,15145752,NULL,NULL,NULL,'2025-10-13 15:57:58','2025-10-13 15:57:58','2025-10-13 15:57:58'),
(3800,4,4,1,'GreenKnoll-Admin.jpg','image/jpeg','image',NULL,1080,1080,138916,NULL,NULL,NULL,'2025-10-13 16:03:32','2025-10-13 16:03:32','2025-10-13 16:03:42'),
(3802,4,4,1,'GreenKnoll-AD.jpg','image/jpeg','image',NULL,1080,1080,73986,NULL,NULL,NULL,'2025-10-13 16:04:02','2025-10-13 16:04:02','2025-10-13 16:04:02'),
(3808,2,2,1,'Green-Knoll-Lobby.jpg','image/jpeg','image',NULL,5040,3360,2067396,'0.4840;0.5013',NULL,NULL,'2025-10-13 16:05:35','2025-10-13 16:05:35','2026-01-14 16:44:22'),
(3856,4,4,1,'Madison-Admin.jpg','image/jpeg','image',NULL,1080,1080,85590,NULL,NULL,NULL,'2025-10-13 16:15:24','2025-10-13 16:15:24','2025-10-13 16:15:24'),
(3858,4,4,1,'Madison-AD.jpg','image/jpeg','image',NULL,1080,1080,84389,NULL,NULL,NULL,'2025-10-13 16:15:40','2025-10-13 16:15:40','2025-10-13 16:15:40'),
(3865,2,2,1,'Mercerville-Lobby.jpg','image/jpeg','image',NULL,6252,4480,7301124,'0.4593;0.5013',NULL,NULL,'2025-10-13 16:20:28','2025-10-13 16:20:28','2026-01-14 17:12:24'),
(3896,2,2,1,'Orange-Park-Lobby.jpg','image/jpeg','image',NULL,5927,4480,6659867,NULL,NULL,NULL,'2025-10-13 17:02:39','2025-10-13 17:02:39','2025-10-13 17:02:39'),
(3918,4,4,1,'Orange-Admin.jpg','image/jpeg','image',NULL,1080,1080,88366,NULL,NULL,NULL,'2025-10-13 17:06:23','2025-10-13 17:06:23','2025-10-13 17:06:23'),
(3920,4,4,1,'Orange-AD.jpg','image/jpeg','image',NULL,1080,1080,83758,NULL,NULL,NULL,'2025-10-13 17:06:40','2025-10-13 17:06:40','2025-10-13 17:06:40'),
(3927,2,2,1,'Park-Place-Lobby.jpg','image/jpeg','image',NULL,6720,4480,17599905,NULL,NULL,NULL,'2025-10-13 17:19:50','2025-10-13 17:19:50','2025-10-13 17:19:50'),
(3954,4,4,1,'Park-Place-AD.jpg','image/jpeg','image',NULL,1080,1080,136300,NULL,NULL,NULL,'2025-10-13 17:22:55','2025-10-13 17:22:55','2025-10-13 17:22:55'),
(3959,2,2,1,'Plainfield-Lobby.jpg','image/jpeg','image',NULL,6720,4480,15445322,NULL,NULL,NULL,'2025-10-13 17:25:39','2025-10-13 17:25:40','2025-10-13 17:25:55'),
(3981,4,4,1,'Plainfield-AD.jpg','image/jpeg','image',NULL,1080,1080,104000,NULL,NULL,NULL,'2025-10-13 17:28:18','2025-10-13 17:28:18','2025-10-13 17:28:18'),
(3986,2,2,1,'St-Vincents-Lobby.jpg','image/jpeg','image',NULL,5902,4480,5457598,'0.5479;0.5732',NULL,NULL,'2025-10-13 17:40:31','2025-10-13 17:40:31','2026-01-14 19:06:21'),
(4008,4,4,1,'St-Vincent-Admin.jpg','image/jpeg','image',NULL,1080,1080,151258,NULL,NULL,NULL,'2025-10-13 17:43:03','2025-10-13 17:43:03','2025-10-13 17:43:03'),
(4010,4,4,1,'St-Vincents-AD.jpg','image/jpeg','image',NULL,1080,1080,72995,NULL,NULL,NULL,'2025-10-13 17:43:27','2025-10-13 17:43:27','2025-10-13 17:43:27'),
(4017,2,2,1,'Summit-Ridge-Lobby.jpg','image/jpeg','image',NULL,5007,3338,8750515,'0.4050;0.5896',NULL,NULL,'2026-01-14 19:13:35','2025-10-13 17:44:49','2026-01-14 19:17:25'),
(4018,4,4,1,'Summit-Admin.jpg','image/jpeg','image',NULL,1080,1080,100588,NULL,NULL,NULL,'2025-10-13 17:45:02','2025-10-13 17:45:02','2025-10-13 17:45:02'),
(4020,4,4,1,'Summit-AD.jpg','image/jpeg','image',NULL,1080,1080,72945,NULL,NULL,NULL,'2025-10-13 17:45:12','2025-10-13 17:45:12','2025-10-13 17:45:12'),
(4069,4,4,1,'Caldwell-AD.jpg','image/jpeg','image',NULL,1080,1080,92819,NULL,NULL,NULL,'2025-10-13 17:51:54','2025-10-13 17:51:54','2025-10-13 17:51:54'),
(4080,2,2,1,'West-Caldwell-Lobby.jpg','image/jpeg','image',NULL,6230,4480,7157860,'0.3866;0.5139',NULL,NULL,'2025-10-13 17:53:06','2025-10-13 17:53:06','2026-01-14 19:24:27'),
(4083,2,2,1,'Westfield-Lobby.jpg','image/jpeg','image',NULL,5040,3360,8684777,NULL,NULL,NULL,'2025-10-13 17:54:18','2025-10-13 17:54:18','2025-10-13 17:54:18'),
(4105,4,4,1,'Westfield-AD.jpg','image/jpeg','image',NULL,1080,1080,116843,NULL,NULL,NULL,'2025-10-13 17:56:57','2025-10-13 17:56:57','2025-10-13 17:57:21'),
(4138,4,4,1,'Woodlands-Admin.jpg','image/jpeg','image',NULL,1080,1080,94864,NULL,NULL,NULL,'2025-10-13 18:01:28','2025-10-13 18:01:28','2025-10-13 18:01:28'),
(4141,4,4,1,'Woodlands-AD.jpg','image/jpeg','image',NULL,1080,1080,80267,NULL,NULL,NULL,'2025-10-13 18:01:44','2025-10-13 18:01:44','2025-10-13 18:01:44'),
(4142,2,2,1,'Woodlands-Lobby.jpg','image/jpeg','image',NULL,5040,3360,10210881,NULL,NULL,NULL,'2025-10-13 18:02:04','2025-10-13 18:02:04','2025-10-13 18:02:04'),
(4150,2,2,1,'Roosevelt-Edison-Lounge.jpg','image/jpeg','image',NULL,5496,4480,4861132,NULL,NULL,NULL,'2025-10-13 19:05:27','2025-10-13 19:05:27','2025-10-13 19:05:27'),
(4172,4,4,1,'Edison-Admin.jpg','image/jpeg','image',NULL,1080,1080,112867,NULL,NULL,NULL,'2025-10-13 19:10:22','2025-10-13 19:10:22','2025-10-13 19:10:22'),
(4181,2,2,1,'Roosevelt-Old-Bridge-Gym.jpg','image/jpeg','image',NULL,6727,4482,15385400,NULL,NULL,NULL,'2025-10-13 19:12:29','2025-10-13 19:12:29','2025-10-13 19:12:29'),
(4207,4,4,1,'Old-Bridge-Admin.jpg','image/jpeg','image',NULL,1080,1080,78330,NULL,NULL,NULL,'2025-10-13 19:17:28','2025-10-13 19:17:28','2025-10-13 19:17:28'),
(4208,4,4,1,'Old-Bridge-AD.jpg','image/jpeg','image',NULL,1080,1080,107605,NULL,NULL,NULL,'2025-10-13 19:17:38','2025-10-13 19:17:38','2025-10-13 19:17:38'),
(4223,2,2,1,'Barn-Hill-Lobby.jpg','image/jpeg','image',NULL,6720,4480,16557805,NULL,NULL,NULL,'2025-10-13 19:26:37','2025-10-13 19:26:38','2025-10-13 19:26:38'),
(4246,4,4,1,'Barn-Hill-AD.jpg','image/jpeg','image',NULL,1080,1080,122394,NULL,NULL,NULL,'2025-10-13 19:29:49','2025-10-13 19:29:49','2025-10-13 19:29:49'),
(4276,2,2,1,'Berkshire-Lobby.jpg','image/jpeg','image',NULL,6729,4492,10943174,'0.2729;0.5399',NULL,NULL,'2025-10-13 19:34:10','2025-10-13 19:34:10','2026-01-16 20:33:17'),
(4282,2,2,1,'Brakeley-Park-Lobby.jpg','image/jpeg','image',NULL,6720,4480,17400571,NULL,NULL,NULL,'2025-10-13 19:36:08','2025-10-13 19:36:08','2025-10-13 19:36:08'),
(4322,2,2,1,'Chestnut-Hill-Lobby.jpg','image/jpeg','image',NULL,6720,4480,16641052,NULL,NULL,NULL,'2025-10-13 19:47:24','2025-10-13 19:47:24','2025-10-13 19:47:24'),
(4349,4,4,1,'Harrington-AD.jpg','image/jpeg','image',NULL,1080,1080,98776,NULL,NULL,NULL,'2025-10-14 13:43:17','2025-10-14 13:43:17','2025-10-14 13:43:17'),
(4358,2,2,1,'Fair-Lawn-Lobby.jpg','image/jpeg','image',NULL,6724,4482,15479152,NULL,NULL,NULL,'2025-10-14 16:46:43','2025-10-14 16:46:43','2025-10-14 16:46:43'),
(4385,2,2,1,'Hamilton-Plaza-Lobby.jpg','image/jpeg','image',NULL,6720,4480,15463036,NULL,NULL,NULL,'2025-10-14 16:50:16','2025-10-14 16:50:16','2025-10-14 16:50:16'),
(4414,2,2,1,'Harborage-Lobby.jpg','image/jpeg','image',NULL,6720,4480,6136127,NULL,NULL,NULL,'2025-10-14 16:54:22','2025-10-14 16:54:22','2025-10-14 16:54:22'),
(4440,2,2,1,'Harston-Lobby.jpg','image/jpeg','image',NULL,6720,4480,17233442,NULL,NULL,NULL,'2025-10-14 16:57:52','2025-10-14 16:57:52','2025-10-14 16:57:52'),
(4466,2,2,1,'Inglemoor-Lobby.jpg','image/jpeg','image',NULL,7780,5187,14898154,NULL,NULL,NULL,'2025-10-14 17:00:51','2025-10-14 17:00:51','2025-10-14 17:01:23'),
(4497,2,2,1,'Lehigh-Lobby.jpg','image/jpeg','image',NULL,6720,4480,10240320,NULL,NULL,NULL,'2025-10-14 17:06:56','2025-10-14 17:06:56','2025-10-14 17:06:56'),
(4518,4,4,1,'Lehigh-AD.jpg','image/jpeg','image',NULL,1080,1080,81384,NULL,NULL,NULL,'2025-10-14 17:09:05','2025-10-14 17:09:05','2025-10-14 17:09:05'),
(4519,4,4,1,'Lehigh-Admin.jpg','image/jpeg','image',NULL,1080,1080,88123,NULL,NULL,NULL,'2025-10-14 17:09:11','2025-10-14 17:09:11','2025-10-14 17:09:11'),
(4526,2,2,1,'Milford-Manor-Lobby.jpg','image/jpeg','image',NULL,6720,4480,16641745,NULL,NULL,NULL,'2025-10-14 17:10:03','2025-10-14 17:10:04','2025-10-14 17:10:04'),
(4554,2,2,1,'Phillipsburg-Lobby.jpg','image/jpeg','image',NULL,5040,3360,8748043,NULL,NULL,NULL,'2025-10-14 17:13:18','2025-10-14 17:13:19','2025-10-14 17:13:19'),
(4562,4,4,1,'Brakeley-AD.jpg','image/jpeg','image',NULL,1080,1080,52073,NULL,NULL,NULL,'2025-10-14 17:15:24','2025-10-14 17:15:25','2025-10-14 17:15:25'),
(4579,2,2,1,'Prospect-Heights-Lobby.jpg','image/jpeg','image',NULL,5851,4480,5149998,NULL,NULL,NULL,'2025-10-14 17:19:41','2025-10-14 17:19:41','2025-10-14 17:19:41'),
(4602,4,4,1,'Prospect-Admin.jpg','image/jpeg','image',NULL,1080,1080,95445,NULL,NULL,NULL,'2025-10-14 17:22:03','2025-10-14 17:22:03','2025-10-14 17:22:03'),
(4610,2,2,1,'Regent-Lobby.jpg','image/jpeg','image',NULL,7589,5504,5575779,NULL,NULL,NULL,'2025-10-14 17:22:40','2025-10-14 17:22:40','2025-10-14 17:22:40'),
(4620,4,4,1,'Regent-AD.jpg','image/jpeg','image',NULL,1080,1080,80740,NULL,NULL,NULL,'2025-10-14 17:25:09','2025-10-14 17:25:09','2025-10-14 17:25:09'),
(4639,2,2,1,'Wayne-Hills-Lobby.jpg','image/jpeg','image',NULL,6720,4480,14984555,NULL,NULL,NULL,'2025-10-14 17:25:33','2025-10-14 17:25:33','2025-10-14 17:25:33'),
(4786,2,2,1,'Annap-Ext-4.jpg','image/jpeg','image',NULL,3600,2400,6951080,NULL,NULL,NULL,'2025-11-04 15:00:00','2025-11-04 15:00:00','2025-11-04 15:00:00'),
(4806,2,2,1,'Annap-Activity-Rm-6.JPG','image/jpeg','image',NULL,3600,2400,7543809,'0.4051;0.6493',NULL,NULL,'2025-11-04 15:06:38','2025-11-04 15:06:38','2026-01-19 16:23:19'),
(4807,2,2,1,'Annap-Dining7.jpg','image/jpeg','image',NULL,3600,2400,6051268,'0.5127;0.5989',NULL,NULL,'2025-11-04 15:06:41','2025-11-04 15:06:41','2026-01-19 16:23:30'),
(4808,2,2,1,'Annap-Lobby6.jpg','image/jpeg','image',NULL,3600,2400,4685038,'0.5613;0.4965',NULL,NULL,'2025-11-04 15:06:43','2025-11-04 15:06:43','2026-01-19 16:24:17'),
(4809,2,2,1,'Annap-Rehab-0.JPG','image/jpeg','image',NULL,3600,2400,5787711,'0.4676;0.4653',NULL,NULL,'2025-11-04 15:06:48','2025-11-04 15:06:48','2026-01-19 16:23:56'),
(4810,2,2,1,'Annap-Renal-3.JPG','image/jpeg','image',NULL,3600,2400,6154213,'0.4965;0.5347',NULL,NULL,'2025-11-04 15:06:50','2025-11-04 15:06:50','2026-01-19 16:24:07'),
(4811,2,2,1,'Annap-Room9.JPG','image/jpeg','image',NULL,1800,1200,572890,NULL,NULL,NULL,'2025-11-04 15:06:51','2025-11-04 15:06:51','2025-11-04 15:06:51'),
(4815,4,4,1,'Annapolis-Admin.jpg','image/jpeg','image',NULL,1080,1080,112248,NULL,NULL,NULL,'2025-11-04 15:08:51','2025-11-04 15:08:51','2025-11-04 15:08:51'),
(4821,2,2,1,'BarnHill_Lobby3.jpg','image/jpeg','image',NULL,6720,4480,15760539,NULL,NULL,NULL,'2025-11-04 15:12:18','2025-11-04 15:12:18','2025-11-04 15:12:18'),
(4822,2,2,1,'BarnHill_RehabGym.jpg','image/jpeg','image',NULL,6720,4480,15255251,NULL,NULL,NULL,'2025-11-04 15:12:25','2025-11-04 15:12:26','2025-11-04 15:12:26'),
(4823,2,2,1,'BarnHill_RehabGym2.jpg','image/jpeg','image',NULL,6720,4480,14310912,NULL,NULL,NULL,'2025-11-04 15:12:32','2025-11-04 15:12:32','2025-11-04 15:12:32'),
(4824,2,2,1,'BarnHill_Room.jpg','image/jpeg','image',NULL,6720,4480,15239717,NULL,NULL,NULL,'2025-11-04 15:12:38','2025-11-04 15:12:38','2025-11-04 15:12:38'),
(4826,2,2,1,'Bayshore-Room.jpg','image/jpeg','image',NULL,6720,4480,5813145,NULL,NULL,NULL,'2025-11-04 19:13:06','2025-11-04 19:13:06','2025-11-04 19:13:06'),
(4827,2,2,1,'Bayshore-Gym.jpg','image/jpeg','image',NULL,6720,4480,6441144,NULL,NULL,NULL,'2025-11-04 19:13:17','2025-11-04 19:13:18','2025-11-04 19:13:18'),
(4828,2,2,1,'Bayshore-Dining.jpg','image/jpeg','image',NULL,6272,4480,5257882,NULL,NULL,NULL,'2025-11-04 19:14:37','2025-11-04 19:14:38','2025-11-04 19:14:38'),
(4829,2,2,1,'Bayshore-Exterior.jpg','image/jpeg','image',NULL,6245,4480,6338311,'0.5516;0.4634',NULL,NULL,'2025-11-04 19:14:45','2025-11-04 19:14:45','2026-01-14 16:19:42'),
(4834,2,2,1,'367A8053.jpg','image/jpeg','image',NULL,6720,4480,9242812,'0.5961;0.5885',NULL,NULL,'2025-11-04 19:50:12','2025-11-04 19:50:12','2026-01-16 20:33:59'),
(4835,2,2,1,'367A8068.jpg','image/jpeg','image',NULL,6720,4480,9255159,NULL,NULL,NULL,'2025-11-04 19:50:20','2025-11-04 19:50:21','2025-11-04 19:50:21'),
(4836,2,2,1,'367A8091.jpg','image/jpeg','image',NULL,6720,4480,8603718,NULL,NULL,NULL,'2025-11-04 19:50:26','2025-11-04 19:50:26','2025-11-04 19:50:26'),
(4837,2,2,1,'367A8101.jpg','image/jpeg','image',NULL,6720,4480,8787900,'0.4977;0.5694',NULL,NULL,'2025-11-04 19:50:32','2025-11-04 19:50:32','2026-01-16 20:36:41'),
(4838,2,2,1,'367A8110.jpg','image/jpeg','image',NULL,6720,4480,10633962,'0.5000;0.5885',NULL,NULL,'2025-11-04 19:50:39','2025-11-04 19:50:39','2026-01-16 20:36:50'),
(4841,2,2,1,'DSC_0779.jpg','image/jpeg','image',NULL,6016,4016,12285897,NULL,NULL,NULL,'2025-11-04 19:53:51','2025-11-04 19:53:51','2025-11-04 19:53:51'),
(4842,2,2,1,'DSC_0803-Edit.jpg','image/jpeg','image',NULL,5059,3496,9301652,NULL,NULL,NULL,'2025-11-04 19:53:58','2025-11-04 19:53:59','2025-11-04 19:53:59'),
(4843,2,2,1,'DSC_0855.jpg','image/jpeg','image',NULL,6016,4016,9287502,NULL,NULL,NULL,'2025-11-04 19:54:04','2025-11-04 19:54:04','2025-11-04 19:54:04'),
(4844,2,2,1,'DSC_0922.jpg','image/jpeg','image',NULL,6016,4016,13011894,NULL,NULL,NULL,'2025-11-04 19:54:16','2025-11-04 19:54:16','2025-11-04 19:54:16'),
(4845,2,2,1,'DSC_1021.jpg','image/jpeg','image',NULL,6016,4016,9866225,NULL,NULL,NULL,'2025-11-04 19:54:21','2025-11-04 19:54:22','2025-11-04 19:54:22'),
(4846,2,2,1,'DSC_1052.jpg','image/jpeg','image',NULL,6016,4016,10272411,NULL,NULL,NULL,'2025-11-04 19:54:28','2025-11-04 19:54:28','2025-11-04 19:54:28'),
(4861,2,2,1,'Brackenville-Lobby-01.JPG','image/jpeg','image',NULL,4200,2800,2274230,NULL,NULL,NULL,'2025-11-04 20:53:20','2025-11-04 20:53:20','2025-11-04 20:53:20'),
(4879,2,2,1,'Brackenville-Activities-13.JPG','image/jpeg','image',NULL,3600,2400,2070006,NULL,NULL,NULL,'2025-11-04 20:56:08','2025-11-04 20:56:08','2025-11-04 20:56:08'),
(4880,2,2,1,'Brackenville-ADL-Kitchen-15.JPG','image/jpeg','image',NULL,3600,2400,1535933,NULL,NULL,NULL,'2025-11-04 20:56:10','2025-11-04 20:56:10','2025-11-04 20:56:10'),
(4881,2,2,1,'Brackenville-Chapel-09.JPG','image/jpeg','image',NULL,3600,2400,2073971,NULL,NULL,NULL,'2025-11-04 20:56:11','2025-11-04 20:56:11','2025-11-04 20:56:11'),
(4882,2,2,1,'Brackenville-Dining-14.JPG','image/jpeg','image',NULL,3600,2400,1878105,NULL,NULL,NULL,'2025-11-04 20:56:13','2025-11-04 20:56:13','2025-11-04 20:56:13'),
(4883,2,2,1,'Brackenville-double-room-03.JPG','image/jpeg','image',NULL,3600,2400,1766286,NULL,NULL,NULL,'2025-11-04 20:56:14','2025-11-04 20:56:14','2025-11-04 20:56:14'),
(4884,2,2,1,'Brackenville-Exterior-03.JPG','image/jpeg','image',NULL,3600,2400,3607674,NULL,NULL,NULL,'2025-11-04 20:56:17','2025-11-04 20:56:17','2025-11-04 20:56:17'),
(4885,2,2,1,'Brackenville-Fish-Pond-06.JPG','image/jpeg','image',NULL,3600,2400,3756559,NULL,NULL,NULL,'2025-11-04 20:56:20','2025-11-04 20:56:20','2025-11-04 20:56:20'),
(4886,2,2,1,'Brackenville-Rehab-Gym-00.JPG','image/jpeg','image',NULL,3600,2400,1951484,NULL,NULL,NULL,'2025-11-04 20:56:22','2025-11-04 20:56:22','2025-11-04 20:56:22'),
(4887,2,2,1,'Brackenville-Salon-10.JPG','image/jpeg','image',NULL,3600,2400,1462751,NULL,NULL,NULL,'2025-11-04 20:56:23','2025-11-04 20:56:23','2025-11-04 20:56:23'),
(4888,2,2,1,'Brackenville-single-room-04.JPG','image/jpeg','image',NULL,3600,2400,1390890,NULL,NULL,NULL,'2025-11-04 20:56:25','2025-11-04 20:56:25','2025-11-04 20:56:25'),
(4900,4,4,1,'Brackenville-Admin.jpg','image/jpeg','image',NULL,1080,1080,102073,NULL,NULL,NULL,'2025-11-04 20:57:58','2025-11-04 20:57:58','2025-11-04 20:58:09'),
(4902,4,4,1,'Brackenville-AD.jpg','image/jpeg','image',NULL,1080,1080,92072,NULL,NULL,NULL,'2025-11-04 20:58:26','2025-11-04 20:58:26','2025-11-04 20:58:36'),
(4909,2,2,1,'BrakeleyPark_RehabGym_2025-11-04-210017_zosm.jpg','image/jpeg','image',NULL,6720,4480,16535054,NULL,NULL,NULL,'2025-11-04 21:00:18','2025-11-04 21:00:18','2025-11-04 21:00:18'),
(4910,2,2,1,'BrakeleyPark_RehabGym2_2025-11-04-210026_khnv.jpg','image/jpeg','image',NULL,6720,4480,16561624,NULL,NULL,NULL,'2025-11-04 21:00:27','2025-11-04 21:00:27','2025-11-04 21:00:27'),
(4911,2,2,1,'BrakeleyPark_Room_2025-11-04-210035_tcfl.jpg','image/jpeg','image',NULL,6721,4482,17426263,NULL,NULL,NULL,'2025-11-04 21:00:36','2025-11-04 21:00:36','2025-11-04 21:00:36'),
(4914,4,4,1,'Phillipsburg-AD.jpg','image/jpeg','image',NULL,1080,1080,52073,NULL,NULL,NULL,'2025-11-04 21:01:24','2025-11-04 21:01:24','2025-11-04 21:01:24'),
(4920,2,2,1,'sts_0008-sts_00121.jpg','image/jpeg','image',NULL,6720,4480,16664886,NULL,NULL,NULL,'2025-11-04 21:06:30','2025-11-04 21:06:30','2025-11-04 21:06:30'),
(4921,2,2,1,'sts_0031-sts_00463.jpg','image/jpeg','image',NULL,6720,4480,14579290,NULL,NULL,NULL,'2025-11-04 21:06:36','2025-11-04 21:06:36','2025-11-04 21:06:36'),
(4922,2,2,1,'sts_0050-sts_00554.jpg','image/jpeg','image',NULL,6720,4480,12721492,'0.4992;0.5720',NULL,NULL,'2025-11-04 21:06:39','2025-11-04 21:06:40','2026-01-12 19:55:28'),
(4923,2,2,1,'sts_0196-sts_020021.jpg','image/jpeg','image',NULL,6720,4480,16603779,NULL,NULL,NULL,'2025-11-04 21:06:47','2025-11-04 21:06:48','2025-11-04 21:06:48'),
(4924,2,2,1,'STS_00666.jpg','image/jpeg','image',NULL,6720,4480,12875794,NULL,NULL,NULL,'2025-11-04 21:06:54','2025-11-04 21:06:54','2025-11-04 21:06:54'),
(4927,2,2,1,'LARGE-RES_02.jpg','image/jpeg','image',NULL,5044,3363,5445041,NULL,NULL,NULL,'2025-11-04 21:17:08','2025-11-04 21:17:08','2025-11-04 21:17:08'),
(4928,2,2,1,'LARGE-RES_03.jpg','image/jpeg','image',NULL,4984,3346,887355,'0.5486;0.5013',0,0,'2026-01-12 20:58:55','2025-11-04 21:17:10','2026-01-12 20:58:55'),
(4929,2,2,1,'LARGE-RES_07.jpg','image/jpeg','image',NULL,5046,3364,6167679,NULL,NULL,NULL,'2025-11-04 21:17:14','2025-11-04 21:17:14','2025-11-04 21:17:14'),
(4930,2,2,1,'LARGE-RES_08.jpg','image/jpeg','image',NULL,5040,3360,6656168,NULL,NULL,NULL,'2025-11-04 21:17:17','2025-11-04 21:17:17','2025-11-04 21:17:17'),
(4931,2,2,1,'LARGE-RES_11.jpg','image/jpeg','image',NULL,5047,3365,5972296,NULL,NULL,NULL,'2025-11-04 21:17:19','2025-11-04 21:17:19','2025-11-04 21:17:19'),
(4932,2,2,1,'367A7508.jpg','image/jpeg','image',NULL,6720,4480,15715398,NULL,NULL,NULL,'2025-11-04 21:18:04','2025-11-04 21:18:04','2025-11-04 21:18:04'),
(4933,2,2,1,'367A7610.jpg','image/jpeg','image',NULL,6742,4488,16159901,NULL,NULL,NULL,'2025-11-04 21:18:10','2025-11-04 21:18:10','2025-11-04 21:18:10'),
(4934,2,2,1,'BW10.jpg','image/jpeg','image',NULL,2700,3000,1212421,NULL,NULL,NULL,'2025-11-04 21:18:12','2025-11-04 21:18:12','2025-11-04 21:18:12'),
(4935,2,2,1,'DSC09305-Edit.jpg','image/jpeg','image',NULL,6000,4000,13337552,NULL,NULL,NULL,'2025-11-04 21:18:50','2025-11-04 21:18:50','2025-11-04 21:18:50'),
(4944,9,13,1,'Nondiscrimination_Notice_Annapolis.pdf','application/pdf','pdf',NULL,NULL,NULL,152350,NULL,NULL,NULL,'2025-11-05 17:40:20','2025-11-05 16:07:42','2025-11-05 17:40:20'),
(4951,9,13,1,'Nondiscrimination_Notice_BarnHill.pdf','application/pdf','pdf',NULL,NULL,NULL,157695,NULL,NULL,NULL,'2025-11-05 17:40:21','2025-11-05 16:13:59','2025-11-05 17:40:21'),
(4955,2,2,1,'Woodlands_RehabGym.jpg','image/jpeg','image',NULL,5043,3363,8864244,NULL,NULL,NULL,'2025-11-05 17:09:40','2025-11-05 17:09:40','2025-11-05 17:09:40'),
(4956,2,2,1,'Woodlands_Room.jpg','image/jpeg','image',NULL,5040,3360,8204956,'0.5008;0.5808',NULL,NULL,'2025-11-05 17:09:45','2025-11-05 17:09:45','2026-01-14 20:13:12'),
(4957,2,2,1,'Woodlands_Room2.jpg','image/jpeg','image',NULL,5040,3360,8630625,'0.4437;0.6162',NULL,NULL,'2025-11-05 17:09:50','2025-11-05 17:09:50','2026-01-14 20:13:25'),
(4962,9,13,1,'Nondiscrimination_Notice_Woodlands.pdf','application/pdf','pdf',NULL,NULL,NULL,152343,NULL,NULL,NULL,'2025-11-05 17:40:20','2025-11-05 17:12:14','2025-11-05 17:40:20'),
(4973,2,2,1,'STS_0357.jpg','image/jpeg','image',NULL,6720,4480,6942081,NULL,NULL,NULL,'2025-11-05 17:14:29','2025-11-05 17:14:29','2025-11-05 17:14:29'),
(4991,2,2,1,'STS_0223.jpg','image/jpeg','image',NULL,6720,4480,16017705,NULL,NULL,NULL,'2025-11-05 17:19:18','2025-11-05 17:19:18','2025-11-05 17:19:18'),
(4992,2,2,1,'STS_0245.jpg','image/jpeg','image',NULL,4480,6720,7237748,NULL,NULL,NULL,'2025-11-05 17:19:24','2025-11-05 17:19:24','2025-11-05 17:19:24'),
(4993,2,2,1,'STS_0264.jpg','image/jpeg','image',NULL,6727,4487,6430020,NULL,NULL,NULL,'2025-11-05 17:19:28','2025-11-05 17:19:28','2025-11-05 17:19:28'),
(4994,2,2,1,'STS_0286.jpg','image/jpeg','image',NULL,6726,4485,5697350,NULL,NULL,NULL,'2025-11-05 17:19:31','2025-11-05 17:19:32','2025-11-05 17:19:32'),
(4995,2,2,1,'STS_0297.jpg','image/jpeg','image',NULL,6720,4480,5699370,NULL,NULL,NULL,'2025-11-05 17:19:35','2025-11-05 17:19:36','2025-11-05 17:19:36'),
(4996,2,2,1,'STS_0314.jpg','image/jpeg','image',NULL,6720,4480,8991306,NULL,NULL,NULL,'2025-11-05 17:19:39','2025-11-05 17:19:39','2025-11-05 17:19:39'),
(4997,2,2,1,'STS_0420.jpg','image/jpeg','image',NULL,6724,4483,11407484,NULL,NULL,NULL,'2025-11-05 17:19:45','2025-11-05 17:19:45','2025-11-05 17:19:45'),
(5001,4,4,1,'Whispering-Admin.jpg','image/jpeg','image',NULL,1080,1080,145335,NULL,NULL,NULL,'2025-11-05 17:22:23','2025-11-05 17:22:23','2025-11-05 17:22:23'),
(5003,4,4,1,'Whispering-AD.jpg','image/jpeg','image',NULL,1080,1080,95499,NULL,NULL,NULL,'2025-11-05 17:22:42','2025-11-05 17:22:42','2025-11-05 17:22:42'),
(5013,2,2,1,'Wheaton-Lobby11.JPG','image/jpeg','image',NULL,3600,2400,6418427,NULL,NULL,NULL,'2025-11-05 17:24:52','2025-11-05 17:24:52','2025-11-05 17:24:52'),
(5033,2,2,1,'Wheaton-Activities.JPG','image/jpeg','image',NULL,3600,2400,4376967,NULL,NULL,NULL,'2025-11-05 17:29:57','2025-11-05 17:29:57','2025-11-05 17:29:57'),
(5034,2,2,1,'Wheaton-Dining-17.JPG','image/jpeg','image',NULL,3600,2400,6552288,NULL,NULL,NULL,'2025-11-05 17:30:02','2025-11-05 17:30:02','2025-11-05 17:30:02'),
(5035,2,2,1,'Wheaton-Ext-19.JPG','image/jpeg','image',NULL,3600,2400,8311458,NULL,NULL,NULL,'2025-11-05 17:30:04','2025-11-05 17:30:05','2025-11-05 17:30:05'),
(5036,2,2,1,'Wheaton-Memory-Care-14.JPG','image/jpeg','image',NULL,3600,2400,4457231,NULL,NULL,NULL,'2025-11-05 17:30:07','2025-11-05 17:30:07','2025-11-05 17:30:07'),
(5037,2,2,1,'Wheaton-Rehab-07.JPG','image/jpeg','image',NULL,3600,2400,5357561,NULL,NULL,NULL,'2025-11-05 17:30:13','2025-11-05 17:30:13','2025-11-05 17:30:13'),
(5038,2,2,1,'Wheaton-Rehab-Kitchen-09.JPG','image/jpeg','image',NULL,3600,2400,4408347,NULL,NULL,NULL,'2025-11-05 17:30:15','2025-11-05 17:30:15','2025-11-05 17:30:15'),
(5039,2,2,1,'Wheaton-Room-03.JPG','image/jpeg','image',NULL,3600,2400,6775489,NULL,NULL,NULL,'2025-11-05 17:30:20','2025-11-05 17:30:20','2025-11-05 17:30:20'),
(5040,2,2,1,'Wheaton-Room-05.JPG','image/jpeg','image',NULL,3600,2400,4145822,NULL,NULL,NULL,'2025-11-05 17:30:22','2025-11-05 17:30:22','2025-11-05 17:30:22'),
(5042,4,4,1,'Wheaton-Admin.jpg','image/jpeg','image',NULL,1080,1080,109897,NULL,NULL,NULL,'2025-11-05 17:31:06','2025-11-05 17:31:06','2025-11-05 17:31:06'),
(5055,2,2,1,'Westfield_DoubleRoom.jpg','image/jpeg','image',NULL,5045,3360,8252436,'0.5328;0.5922',NULL,NULL,'2025-11-05 17:35:09','2025-11-05 17:35:09','2026-01-14 19:44:34'),
(5056,2,2,1,'Westfield_Lobby.jpg','image/jpeg','image',NULL,5040,3360,8268482,NULL,NULL,NULL,'2025-11-05 17:35:13','2025-11-05 17:35:13','2025-11-05 17:35:13'),
(5057,2,2,1,'Westfield_RehabGym.jpg','image/jpeg','image',NULL,5040,3360,8298880,'0.4874;0.5770',NULL,NULL,'2025-11-05 17:35:17','2025-11-05 17:35:17','2026-01-14 19:44:54'),
(5058,2,2,1,'Westfield_SingleRoom.jpg','image/jpeg','image',NULL,3360,5040,8023012,'0.5530;0.6136',NULL,NULL,'2025-11-05 17:35:21','2025-11-05 17:35:22','2026-01-14 19:44:44'),
(5067,2,2,1,'WestCaldwell_Room2.jpg','image/jpeg','image',NULL,6720,4480,16915460,NULL,NULL,NULL,'2025-11-05 17:38:09','2025-11-05 17:38:10','2025-11-05 17:38:10'),
(5068,2,2,1,'WestCaldwell_Room-1.jpg','image/jpeg','image',NULL,6563,4488,5708885,NULL,NULL,NULL,'2025-11-05 17:40:03','2025-11-05 17:40:03','2025-11-05 17:40:03'),
(5069,2,2,1,'WestCaldwell_RehabGym-1.jpg','image/jpeg','image',NULL,6412,4480,6572227,NULL,NULL,NULL,'2025-11-05 17:40:07','2025-11-05 17:40:07','2025-11-05 17:40:07'),
(5084,2,2,1,'WayneHills_DoubleRoom.jpg','image/jpeg','image',NULL,6720,4480,13886560,NULL,NULL,NULL,'2025-11-05 17:42:13','2025-11-05 17:42:13','2025-11-05 17:42:13'),
(5085,2,2,1,'WayneHills_RehabGym.jpg','image/jpeg','image',NULL,6720,4480,14635051,NULL,NULL,NULL,'2025-11-05 17:42:21','2025-11-05 17:42:21','2025-11-05 17:42:21'),
(5086,2,2,1,'WayneHills_RehabGym2.jpg','image/jpeg','image',NULL,6720,4480,15604435,NULL,NULL,NULL,'2025-11-05 17:42:30','2025-11-05 17:42:30','2025-11-05 17:42:30'),
(5087,2,2,1,'WayneHills_RehabGym3.jpg','image/jpeg','image',NULL,6720,4480,15861201,NULL,NULL,NULL,'2025-11-05 17:42:40','2025-11-05 17:42:41','2025-11-05 17:42:41'),
(5088,2,2,1,'WayneHills_SingleRoom.jpg','image/jpeg','image',NULL,6720,4480,14471089,NULL,NULL,NULL,'2025-11-05 17:42:47','2025-11-05 17:42:47','2025-11-05 17:42:47'),
(5095,2,2,1,'STS_0008.jpg','image/jpeg','image',NULL,6720,4480,14765477,NULL,NULL,NULL,'2025-11-05 17:46:40','2025-11-05 17:46:40','2025-11-05 17:46:40'),
(5096,2,2,1,'STS_0051.jpg','image/jpeg','image',NULL,6724,4485,16688061,NULL,NULL,NULL,'2025-11-05 17:46:50','2025-11-05 17:46:50','2025-11-05 17:46:50'),
(5097,2,2,1,'STS_0175.jpg','image/jpeg','image',NULL,6720,4480,15446419,NULL,NULL,NULL,'2025-11-05 17:47:02','2025-11-05 17:47:02','2025-11-05 17:47:02'),
(5098,2,2,1,'STS_0182.jpg','image/jpeg','image',NULL,6720,4480,12114391,NULL,NULL,NULL,'2025-11-05 17:47:06','2025-11-05 17:47:06','2025-11-05 17:47:06'),
(5105,2,2,1,'DSC09338-Edit.jpg','image/jpeg','image',NULL,5921,3947,1698627,NULL,NULL,NULL,'2025-11-05 17:49:46','2025-11-05 17:49:46','2025-11-05 17:49:46'),
(5106,2,2,1,'DSC09598-Edit.jpg','image/jpeg','image',NULL,5847,3898,781969,NULL,NULL,NULL,'2025-11-05 17:49:48','2025-11-05 17:49:48','2025-11-05 17:49:48'),
(5107,2,2,1,'DSC09617-Edit.jpg','image/jpeg','image',NULL,6000,4000,844817,NULL,NULL,NULL,'2025-11-05 17:49:49','2025-11-05 17:49:49','2025-11-05 17:49:49'),
(5108,2,2,1,'DSC09629.jpg','image/jpeg','image',NULL,5893,3929,881128,NULL,NULL,NULL,'2025-11-05 17:49:51','2025-11-05 17:49:51','2025-11-05 17:49:51'),
(5109,2,2,1,'DSC09631-Edit.jpg','image/jpeg','image',NULL,6000,4000,1111252,NULL,NULL,NULL,'2025-11-05 17:49:53','2025-11-05 17:49:53','2025-11-05 17:49:53'),
(5110,2,2,1,'DSC09643-Edit.jpg','image/jpeg','image',NULL,6000,4000,3354213,NULL,NULL,NULL,'2025-11-05 17:49:54','2025-11-05 17:49:55','2025-11-05 17:49:55'),
(5111,2,2,1,'DSC09644.jpg','image/jpeg','image',NULL,5608,3739,1414950,NULL,NULL,NULL,'2025-11-05 17:49:57','2025-11-05 17:49:57','2025-11-05 17:49:57'),
(5112,2,2,1,'Exterior.jpg','image/jpeg','image',NULL,7045,5284,7411808,NULL,NULL,NULL,'2025-11-05 17:50:00','2025-11-05 17:50:01','2025-11-05 17:50:01'),
(5122,2,2,1,'HIGH-RES_02.jpg','image/jpeg','image',NULL,5024,3349,7533603,NULL,NULL,NULL,'2025-11-05 17:56:34','2025-11-05 17:56:34','2025-11-05 17:56:34'),
(5123,2,2,1,'HIGH-RES_03.jpg','image/jpeg','image',NULL,5011,3341,7074248,NULL,NULL,NULL,'2025-11-05 17:56:38','2025-11-05 17:56:38','2025-11-05 17:56:38'),
(5124,2,2,1,'HIGH-RES_04.jpg','image/jpeg','image',NULL,5019,3346,4491314,NULL,NULL,NULL,'2025-11-05 17:56:41','2025-11-05 17:56:41','2025-11-05 17:56:41'),
(5125,2,2,1,'HIGH-RES_08.jpg','image/jpeg','image',NULL,5040,3360,6753360,NULL,NULL,NULL,'2025-11-05 17:56:46','2025-11-05 17:56:46','2025-11-05 17:56:46'),
(5127,2,2,1,'StVincents_RehabGym.jpg','image/jpeg','image',NULL,6720,4480,14402169,NULL,NULL,NULL,'2025-11-05 18:44:51','2025-11-05 18:44:51','2025-11-05 18:44:51'),
(5128,2,2,1,'StVincents_Room.jpg','image/jpeg','image',NULL,6730,4490,14473520,NULL,NULL,NULL,'2025-11-05 18:44:59','2025-11-05 18:45:00','2025-11-05 18:45:00'),
(5129,2,2,1,'StVincents_Room2.jpg','image/jpeg','image',NULL,6720,4480,16524477,'0.5000;0.5492',NULL,NULL,'2025-11-05 18:45:09','2025-11-05 18:45:09','2026-01-14 19:07:48'),
(5130,2,2,1,'Unknown-6.jpeg','image/jpeg','image',NULL,5333,4000,6368183,NULL,NULL,NULL,'2025-11-05 18:45:12','2025-11-05 18:45:12','2025-11-05 18:45:12'),
(5131,2,2,1,'Unknown-10.jpeg','image/jpeg','image',NULL,5333,4000,12643642,NULL,NULL,NULL,'2025-11-05 18:45:21','2025-11-05 18:45:21','2025-11-05 18:45:21'),
(5140,2,2,1,'Springbrook-Lobby-13.JPG','image/jpeg','image',NULL,3600,2400,4966531,NULL,NULL,NULL,'2025-11-05 18:47:37','2025-11-05 18:47:37','2025-11-05 18:47:37'),
(5146,2,2,1,'Springbrook-Dining-12.JPG','image/jpeg','image',NULL,3600,2400,6240656,NULL,NULL,NULL,'2025-11-05 18:51:42','2025-11-05 18:51:42','2025-11-05 18:51:42'),
(5147,2,2,1,'Springbrook-Ext-02.JPG','image/jpeg','image',NULL,3600,2400,7339473,NULL,NULL,NULL,'2025-11-05 18:51:45','2025-11-05 18:51:45','2025-11-05 18:51:45'),
(5148,2,2,1,'Springbrook-Ext-04.JPG','image/jpeg','image',NULL,3600,2400,7996076,NULL,NULL,NULL,'2025-11-05 18:51:51','2025-11-05 18:51:51','2025-11-05 18:51:51'),
(5149,2,2,1,'Springbrook-Gazebo-16.JPG','image/jpeg','image',NULL,3600,2400,7451139,NULL,NULL,NULL,'2025-11-05 18:51:57','2025-11-05 18:51:57','2025-11-05 18:51:57'),
(5150,2,2,1,'Springbrook-Rehab-05.JPG','image/jpeg','image',NULL,3600,2400,5494977,NULL,NULL,NULL,'2025-11-05 18:52:00','2025-11-05 18:52:00','2025-11-05 18:52:00'),
(5151,2,2,1,'Springbrook-Renal-Care-08.JPG','image/jpeg','image',NULL,3600,2400,6920244,NULL,NULL,NULL,'2025-11-05 18:52:03','2025-11-05 18:52:04','2025-11-05 18:52:04'),
(5152,2,2,1,'Springbrook-Renal-Care-09.JPG','image/jpeg','image',NULL,3600,2400,4103111,NULL,NULL,NULL,'2025-11-05 18:52:08','2025-11-05 18:52:08','2025-11-05 18:52:08'),
(5153,2,2,1,'Springbrook-Room-10.JPG','image/jpeg','image',NULL,3600,2400,3826521,NULL,NULL,NULL,'2025-11-05 18:52:09','2025-11-05 18:52:09','2025-11-05 18:52:09'),
(5156,4,4,1,'Springbrook-Admin.jpg','image/jpeg','image',NULL,1080,1080,99720,NULL,NULL,NULL,'2025-11-05 18:55:30','2025-11-05 18:55:30','2025-11-05 18:55:30'),
(5158,4,4,1,'Springbrook-AD.jpg','image/jpeg','image',NULL,1080,1080,188575,NULL,NULL,NULL,'2025-11-05 18:55:42','2025-11-05 18:55:42','2025-11-05 18:55:42'),
(5185,2,2,1,'367A3378.jpg','image/jpeg','image',NULL,6737,4490,16102863,NULL,NULL,NULL,'2025-11-05 19:02:11','2025-11-05 19:02:11','2025-11-05 19:02:11'),
(5186,2,2,1,'367A3391.jpg','image/jpeg','image',NULL,6734,4488,14319016,NULL,NULL,NULL,'2025-11-05 19:02:16','2025-11-05 19:02:16','2025-11-05 19:02:16'),
(5187,2,2,1,'367A3400.jpg','image/jpeg','image',NULL,6733,4497,15205269,NULL,NULL,NULL,'2025-11-05 19:02:26','2025-11-05 19:02:26','2025-11-05 19:02:26'),
(5188,2,2,1,'367A3416.jpg','image/jpeg','image',NULL,6739,4497,15347528,NULL,NULL,NULL,'2025-11-05 19:02:37','2025-11-05 19:02:38','2025-11-05 19:02:38'),
(5189,2,2,1,'367A3441.jpg','image/jpeg','image',NULL,6736,4502,16703198,NULL,NULL,NULL,'2025-11-05 19:02:48','2025-11-05 19:02:48','2025-11-05 19:02:48'),
(5190,2,2,1,'367A3468.jpg','image/jpeg','image',NULL,6720,4480,16812298,NULL,NULL,NULL,'2025-11-05 19:02:58','2025-11-05 19:02:58','2025-11-05 19:02:58'),
(5191,2,2,1,'367A3468_2025-11-05-190348_fmiv.jpg','image/jpeg','image',NULL,6720,4480,16812298,NULL,NULL,NULL,'2025-11-05 19:03:49','2025-11-05 19:03:49','2025-11-05 19:03:49'),
(5213,2,2,1,'Silver-Lake-Exterior-15.JPG','image/jpeg','image',NULL,3600,2400,3279450,NULL,NULL,NULL,'2025-11-05 19:13:05','2025-11-05 19:13:05','2025-11-05 19:13:05'),
(5233,2,2,1,'Silver-Lake-Dining-02.JPG','image/jpeg','image',NULL,3600,2400,2308146,NULL,NULL,NULL,'2025-11-05 19:16:53','2025-11-05 19:16:53','2025-11-05 19:16:53'),
(5234,2,2,1,'Silver-Lake-Double-Bed-07.JPG','image/jpeg','image',NULL,3600,2400,2481080,NULL,NULL,NULL,'2025-11-05 19:16:55','2025-11-05 19:16:55','2025-11-05 19:16:55'),
(5235,2,2,1,'Silver-Lake-Lobby-04.JPG','image/jpeg','image',NULL,3600,2400,2185579,NULL,NULL,NULL,'2025-11-05 19:16:56','2025-11-05 19:16:56','2025-11-05 19:16:56'),
(5236,2,2,1,'Silver-Lake-Patio-16.JPG','image/jpeg','image',NULL,3600,2400,4793286,NULL,NULL,NULL,'2025-11-05 19:16:58','2025-11-05 19:16:58','2025-11-05 19:16:58'),
(5237,2,2,1,'Silver-Lake-Rehab-Gym-05.JPG','image/jpeg','image',NULL,3600,2400,1996675,NULL,NULL,NULL,'2025-11-05 19:17:00','2025-11-05 19:17:00','2025-11-05 19:17:00'),
(5238,2,2,1,'Silver-Lake-Single-Bed-08.JPG','image/jpeg','image',NULL,3600,2400,1383493,NULL,NULL,NULL,'2025-11-05 19:17:01','2025-11-05 19:17:01','2025-11-05 19:17:01'),
(5239,2,2,1,'Silver-Lake-Sitting-Room-06.JPG','image/jpeg','image',NULL,3600,2400,1869560,NULL,NULL,NULL,'2025-11-05 19:17:03','2025-11-05 19:17:03','2025-11-05 19:17:03'),
(5241,4,4,1,'Silver-Admin.jpg','image/jpeg','image',NULL,1080,1080,73179,NULL,NULL,NULL,'2025-11-05 19:18:26','2025-11-05 19:18:26','2025-11-05 19:18:26'),
(5244,4,4,1,'Silver-AD.jpg','image/jpeg','image',NULL,1080,1080,109086,NULL,NULL,NULL,'2025-11-05 19:18:37','2025-11-05 19:18:37','2025-11-05 19:18:37'),
(5253,2,2,1,'Shrewsbury-Exterior-2.jpg','image/jpeg','image',NULL,6595,4480,7844674,'0.5694;0.4546',NULL,NULL,'2025-11-05 19:22:55','2025-11-05 19:22:56','2026-01-13 21:51:18'),
(5254,2,2,1,'STS_00111.jpg','image/jpeg','image',NULL,6720,4480,13433402,NULL,NULL,NULL,'2025-11-05 19:24:53','2025-11-05 19:24:54','2025-11-05 19:24:54'),
(5255,2,2,1,'sts_0146-sts_015012.jpg','image/jpeg','image',NULL,6720,4480,13414746,NULL,NULL,NULL,'2025-11-05 19:24:59','2025-11-05 19:24:59','2025-11-05 19:24:59'),
(5256,2,2,1,'sts_0167-sts_017214.jpg','image/jpeg','image',NULL,6720,4480,13134677,NULL,NULL,NULL,'2025-11-05 19:25:08','2025-11-05 19:25:08','2025-11-05 19:25:08'),
(5257,2,2,1,'STS_00556.jpg','image/jpeg','image',NULL,6720,4480,16051863,NULL,NULL,NULL,'2025-11-05 19:25:18','2025-11-05 19:25:18','2025-11-05 19:25:18'),
(5258,2,2,1,'STS_018315.jpg','image/jpeg','image',NULL,6720,4480,12759209,NULL,NULL,NULL,'2025-11-05 19:25:27','2025-11-05 19:25:27','2025-11-05 19:25:27'),
(5277,2,2,1,'LARGE-RES_04.jpg','image/jpeg','image',NULL,5042,3361,5854661,NULL,NULL,NULL,'2025-11-11 18:03:58','2025-11-11 18:03:58','2025-11-11 18:03:58'),
(5278,2,2,1,'LARGE-RES_06.jpg','image/jpeg','image',NULL,5040,3360,6057564,NULL,NULL,NULL,'2025-11-11 18:04:01','2025-11-11 18:04:02','2025-11-11 18:04:02'),
(5279,2,2,1,'LARGE-RES_11_2025-11-11-180403_ncyp.jpg','image/jpeg','image',NULL,5047,3365,5972296,NULL,NULL,NULL,'2025-11-11 18:04:04','2025-11-11 18:04:04','2025-11-11 18:04:04'),
(5280,2,2,1,'LARGE-RES_18.jpg','image/jpeg','image',NULL,5040,3360,7061093,NULL,NULL,NULL,'2025-11-11 18:04:07','2025-11-11 18:04:07','2025-11-11 18:04:07'),
(5281,2,2,1,'LARGE-RES_03_2025-11-11-180442_nykh.jpg','image/jpeg','image',NULL,5024,3349,5492310,NULL,NULL,NULL,'2025-11-11 18:04:42','2025-11-11 18:04:43','2025-11-11 18:04:43'),
(5282,2,2,1,'Madison_RehabGym.jpg','image/jpeg','image',NULL,6720,4480,15262450,NULL,NULL,NULL,'2025-11-11 18:05:06','2025-11-11 18:05:06','2025-11-11 18:05:06'),
(5292,9,13,1,'PI315331.24A1.pdf','application/pdf','pdf',NULL,NULL,NULL,1816799,NULL,NULL,NULL,'2025-11-12 16:03:02','2025-11-12 16:03:02','2025-11-12 16:03:02'),
(5293,9,13,1,'COMPLETE-CARE-AT-PASSAIC-LLC-2024-STATEMENT-OF-REVENUES.pdf','application/pdf','pdf',NULL,NULL,NULL,74938,NULL,NULL,NULL,'2025-11-12 16:03:03','2025-11-12 16:03:03','2025-11-12 16:03:03'),
(5294,9,13,1,'COMPLETE-CARE-AT-PASSAIC-LLC-2024-NJ-AUDIT.pdf','application/pdf','pdf',NULL,NULL,NULL,313474,NULL,NULL,NULL,'2025-11-12 16:03:03','2025-11-12 16:03:03','2025-11-12 16:03:03'),
(5680,9,13,1,'Nondiscrimination_Notice_BeyLea-3.pdf','application/pdf','pdf',NULL,NULL,NULL,152352,NULL,NULL,NULL,'2025-11-13 20:33:41','2025-11-13 20:33:41','2025-11-13 20:33:41'),
(5696,9,13,1,'Nondiscrimination_Notice_CareAge.pdf','application/pdf','pdf',NULL,NULL,NULL,157652,NULL,NULL,NULL,'2025-11-14 16:30:28','2025-11-14 16:30:28','2025-11-14 16:30:28'),
(5701,9,13,1,'Nondiscrimination_Notice_BeyLeaSNF.pdf','application/pdf','pdf',NULL,NULL,NULL,158788,NULL,NULL,NULL,'2025-11-14 16:32:56','2025-11-14 16:32:56','2025-11-14 16:32:56'),
(5709,9,13,1,'Nondiscrimination_Notice_ChristianHome.pdf','application/pdf','pdf',NULL,NULL,NULL,158439,NULL,NULL,NULL,'2025-11-14 16:35:53','2025-11-14 16:35:53','2025-11-14 16:35:53'),
(5719,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Berkshire.pdf','application/pdf','pdf',NULL,NULL,NULL,163212,NULL,NULL,NULL,'2025-11-14 16:38:15','2025-11-14 16:38:15','2025-11-14 16:38:15'),
(5724,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Brackenville.pdf','application/pdf','pdf',NULL,NULL,NULL,158508,NULL,NULL,NULL,'2025-11-14 16:40:19','2025-11-14 16:40:19','2025-11-14 16:40:19'),
(5730,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Brakeley.pdf','application/pdf','pdf',NULL,NULL,NULL,158525,NULL,NULL,NULL,'2025-11-14 16:41:40','2025-11-14 16:41:40','2025-11-14 16:41:40'),
(5744,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Brick.pdf','application/pdf','pdf',NULL,NULL,NULL,158504,NULL,NULL,NULL,'2025-11-14 16:45:17','2025-11-14 16:45:17','2025-11-14 16:45:17'),
(5749,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Burlington.pdf','application/pdf','pdf',NULL,NULL,NULL,158507,NULL,NULL,NULL,'2025-11-14 16:46:23','2025-11-14 16:46:23','2025-11-14 16:46:23'),
(5755,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Chestnut.pdf','application/pdf','pdf',NULL,NULL,NULL,158515,NULL,NULL,NULL,'2025-11-14 16:47:40','2025-11-14 16:47:41','2025-11-14 16:47:41'),
(5761,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Clark.pdf','application/pdf','pdf',NULL,NULL,NULL,158514,NULL,NULL,NULL,'2025-11-14 16:48:35','2025-11-14 16:48:35','2025-11-14 16:48:35'),
(5767,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Corsica.pdf','application/pdf','pdf',NULL,NULL,NULL,158511,NULL,NULL,NULL,'2025-11-14 16:49:42','2025-11-14 16:49:42','2025-11-14 16:49:42'),
(5773,9,13,1,'CCG_00503a_Nondiscrimination_Notice_CourtHouse.pdf','application/pdf','pdf',NULL,NULL,NULL,158509,NULL,NULL,NULL,'2025-11-14 16:50:30','2025-11-14 16:50:30','2025-11-14 16:50:30'),
(5779,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Dawnview.pdf','application/pdf','pdf',NULL,NULL,NULL,158523,NULL,NULL,NULL,'2025-11-14 16:51:25','2025-11-14 16:51:25','2025-11-14 16:51:25'),
(5785,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Fairlawn.pdf','application/pdf','pdf',NULL,NULL,NULL,158509,NULL,NULL,NULL,'2025-11-14 16:54:28','2025-11-14 16:54:28','2025-11-14 16:54:28'),
(5791,9,13,1,'CCG_00503a_Nondiscrimination_Notice_FoxHill.pdf','application/pdf','pdf',NULL,NULL,NULL,158517,NULL,NULL,NULL,'2025-11-14 16:55:28','2025-11-14 16:55:28','2025-11-14 16:55:28'),
(5797,9,13,1,'CCG_00503a_Nondiscrimination_Notice_GreenAcres.pdf','application/pdf','pdf',NULL,NULL,NULL,158503,NULL,NULL,NULL,'2025-11-14 16:56:44','2025-11-14 16:56:44','2025-11-14 16:56:44'),
(5803,9,13,1,'CCG_00503a_Nondiscrimination_Notice_GreenKnoll.pdf','application/pdf','pdf',NULL,NULL,NULL,158515,NULL,NULL,NULL,'2025-11-14 16:57:49','2025-11-14 16:57:49','2025-11-14 16:57:49'),
(5809,9,13,1,'CCG_00503a_Nondiscrimination_Notice_GrotonRegency.pdf','application/pdf','pdf',NULL,NULL,NULL,158507,NULL,NULL,NULL,'2025-11-14 16:58:49','2025-11-14 16:58:49','2025-11-14 16:58:49'),
(5815,9,13,1,'CCG_00503a_Nondiscrimination_Notice_GrotonRegency_2025-11-14-165909_umwq.pdf','application/pdf','pdf',NULL,NULL,NULL,158507,NULL,NULL,NULL,'2025-11-14 16:59:09','2025-11-14 16:59:09','2025-11-14 16:59:09'),
(5821,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Hagerstown.pdf','application/pdf','pdf',NULL,NULL,NULL,158510,NULL,NULL,NULL,'2025-11-14 17:03:37','2025-11-14 17:03:37','2025-11-14 17:03:37'),
(5827,9,13,1,'CCG_00503a_Nondiscrimination_Notice_HamiltonPlaza.pdf','application/pdf','pdf',NULL,NULL,NULL,158509,NULL,NULL,NULL,'2025-11-14 17:04:36','2025-11-14 17:04:36','2025-11-14 17:04:36'),
(5833,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Harborage.pdf','application/pdf','pdf',NULL,NULL,NULL,158511,NULL,NULL,NULL,'2025-11-14 17:05:35','2025-11-14 17:05:35','2025-11-14 17:05:35'),
(5839,9,13,1,'CCG_00503a_Nondiscrimination_Notice_HarstonHall.pdf','application/pdf','pdf',NULL,NULL,NULL,158506,NULL,NULL,NULL,'2025-11-14 17:06:41','2025-11-14 17:06:42','2025-11-14 17:06:42'),
(5845,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Heritage.pdf','application/pdf','pdf',NULL,NULL,NULL,158511,NULL,NULL,NULL,'2025-11-14 17:07:30','2025-11-14 17:07:30','2025-11-14 17:07:30'),
(5851,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Hillside.pdf','application/pdf','pdf',NULL,NULL,NULL,158503,NULL,NULL,NULL,'2025-11-14 17:08:25','2025-11-14 17:08:25','2025-11-14 17:08:25'),
(5857,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Holiday.pdf','application/pdf','pdf',NULL,NULL,NULL,158508,NULL,NULL,NULL,'2025-11-14 17:09:17','2025-11-14 17:09:18','2025-11-14 17:09:18'),
(5863,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Holmdel.pdf','application/pdf','pdf',NULL,NULL,NULL,158497,NULL,NULL,NULL,'2025-11-14 17:10:25','2025-11-14 17:10:25','2025-11-14 17:10:25'),
(5869,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Hyattsville.pdf','application/pdf','pdf',NULL,NULL,NULL,158507,NULL,NULL,NULL,'2025-11-14 17:12:18','2025-11-14 17:12:18','2025-11-14 17:12:18'),
(5875,9,13,1,'CCG_00503a_Nondiscrimination_Notice_KHS.pdf','application/pdf','pdf',NULL,NULL,NULL,158509,NULL,NULL,NULL,'2025-11-14 17:13:10','2025-11-14 17:13:10','2025-11-14 17:13:10'),
(5881,9,13,1,'CCG_00503a_Nondiscrimination_Notice_KressonView.pdf','application/pdf','pdf',NULL,NULL,NULL,158507,NULL,NULL,NULL,'2025-11-14 17:13:55','2025-11-14 17:13:55','2025-11-14 17:13:55'),
(5887,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Lehigh.pdf','application/pdf','pdf',NULL,NULL,NULL,158510,NULL,NULL,NULL,'2025-11-14 17:16:02','2025-11-14 17:16:02','2025-11-14 17:16:02'),
(5893,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Marcella.pdf','application/pdf','pdf',NULL,NULL,NULL,158511,NULL,NULL,NULL,'2025-11-14 17:16:53','2025-11-14 17:16:53','2025-11-14 17:16:53'),
(5899,9,13,1,'CCG_00503a_Nondiscrimination_Notice_MargatePark.pdf','application/pdf','pdf',NULL,NULL,NULL,158504,NULL,NULL,NULL,'2025-11-14 17:18:15','2025-11-14 17:18:15','2025-11-14 17:18:15'),
(5905,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Mercerville.pdf','application/pdf','pdf',NULL,NULL,NULL,158505,NULL,NULL,NULL,'2025-11-14 17:20:41','2025-11-14 17:20:41','2025-11-14 17:20:41'),
(5911,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Middlebury.pdf','application/pdf','pdf',NULL,NULL,NULL,158511,NULL,NULL,NULL,'2025-11-14 17:21:30','2025-11-14 17:21:30','2025-11-14 17:21:30'),
(5917,9,13,1,'CCG_00503a_Nondiscrimination_Notice_MilfordManor.pdf','application/pdf','pdf',NULL,NULL,NULL,158511,NULL,NULL,NULL,'2025-11-14 17:24:31','2025-11-14 17:24:32','2025-11-14 17:24:32'),
(5923,9,13,1,'CCG_00503a_Nondiscrimination_Notice_MultiMed.pdf','application/pdf','pdf',NULL,NULL,NULL,158519,NULL,NULL,NULL,'2025-11-14 17:26:04','2025-11-14 17:26:04','2025-11-14 17:26:04'),
(5929,9,13,1,'CCG_00503a_Nondiscrimination_Notice_OakRidge.pdf','application/pdf','pdf',NULL,NULL,NULL,158497,NULL,NULL,NULL,'2025-11-14 17:27:16','2025-11-14 17:27:16','2025-11-14 17:27:16'),
(5935,9,13,1,'CCG_00503a_Nondiscrimination_Notice_OceanGrove.pdf','application/pdf','pdf',NULL,NULL,NULL,158521,NULL,NULL,NULL,'2025-11-14 17:28:30','2025-11-14 17:28:30','2025-11-14 17:28:30'),
(5941,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Orange.pdf','application/pdf','pdf',NULL,NULL,NULL,158507,NULL,NULL,NULL,'2025-11-14 17:29:45','2025-11-14 17:29:45','2025-11-14 17:29:45'),
(5947,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Prospect.pdf','application/pdf','pdf',NULL,NULL,NULL,158502,NULL,NULL,NULL,'2025-11-14 17:31:11','2025-11-14 17:31:11','2025-11-14 17:31:11'),
(5953,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Regent.pdf','application/pdf','pdf',NULL,NULL,NULL,158514,NULL,NULL,NULL,'2025-11-14 17:32:13','2025-11-14 17:32:13','2025-11-14 17:32:13'),
(5959,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Ridgewood.pdf','application/pdf','pdf',NULL,NULL,NULL,158507,NULL,NULL,NULL,'2025-11-14 17:33:17','2025-11-14 17:33:17','2025-11-14 17:33:17'),
(5965,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Severna.pdf','application/pdf','pdf',NULL,NULL,NULL,158512,NULL,NULL,NULL,'2025-11-14 17:45:07','2025-11-14 17:45:07','2025-11-14 17:45:07'),
(5971,9,13,1,'CCG_00503a_Nondiscrimination_Notice_SheridanCommons.pdf','application/pdf','pdf',NULL,NULL,NULL,158516,NULL,NULL,NULL,'2025-11-14 17:46:23','2025-11-14 17:46:23','2025-11-14 17:46:23'),
(5977,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Shrewsbury.pdf','application/pdf','pdf',NULL,NULL,NULL,158506,NULL,NULL,NULL,'2025-11-14 17:47:39','2025-11-14 17:47:39','2025-11-14 17:47:39'),
(5982,9,13,1,'CCG_00503a_Nondiscrimination_Notice_SilverLake.pdf','application/pdf','pdf',NULL,NULL,NULL,158501,NULL,NULL,NULL,'2025-11-14 17:48:39','2025-11-14 17:48:40','2025-11-14 17:48:40'),
(5987,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Southpointe.pdf','application/pdf','pdf',NULL,NULL,NULL,158512,NULL,NULL,NULL,'2025-11-14 17:50:30','2025-11-14 17:50:30','2025-11-14 17:50:30'),
(5994,9,13,1,'CCG_00503a_Nondiscrimination_Notice_SilverSpring.pdf','application/pdf','pdf',NULL,NULL,NULL,158517,NULL,NULL,NULL,'2025-11-14 18:15:34','2025-11-14 18:15:34','2025-11-14 18:15:34'),
(6000,9,13,1,'CCG_00503a_Nondiscrimination_Notice_StVincents.pdf','application/pdf','pdf',NULL,NULL,NULL,158505,NULL,NULL,NULL,'2025-11-14 18:16:36','2025-11-14 18:16:36','2025-11-14 18:16:36'),
(6006,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Summit.pdf','application/pdf','pdf',NULL,NULL,NULL,158508,NULL,NULL,NULL,'2025-11-14 18:17:47','2025-11-14 18:17:47','2025-11-14 18:17:47'),
(6013,9,13,1,'CCG_00503a_Nondiscrimination_Notice_BLVD.pdf','application/pdf','pdf',NULL,NULL,NULL,158514,NULL,NULL,NULL,'2025-11-14 18:18:51','2025-11-14 18:18:51','2025-11-14 18:18:51'),
(6020,9,13,1,'CCG_00503a_Nondiscrimination_Notice_VictoriaCommons.pdf','application/pdf','pdf',NULL,NULL,NULL,158514,NULL,NULL,NULL,'2025-11-14 18:19:39','2025-11-14 18:19:39','2025-11-14 18:19:39'),
(6026,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Voorhees.pdf','application/pdf','pdf',NULL,NULL,NULL,158505,NULL,NULL,NULL,'2025-11-14 18:20:49','2025-11-14 18:20:49','2025-11-14 18:20:49'),
(6033,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Wayne.pdf','application/pdf','pdf',NULL,NULL,NULL,158510,NULL,NULL,NULL,'2025-11-14 18:21:47','2025-11-14 18:21:47','2025-11-14 18:21:47'),
(6039,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Wheaton.pdf','application/pdf','pdf',NULL,NULL,NULL,158504,NULL,NULL,NULL,'2025-11-14 18:22:44','2025-11-14 18:22:44','2025-11-14 18:22:44'),
(6045,9,13,1,'CCG_00503a_Nondiscrimination_Notice_Whispering.pdf','application/pdf','pdf',NULL,NULL,NULL,158516,NULL,NULL,NULL,'2025-11-14 18:23:27','2025-11-14 18:23:27','2025-11-14 18:23:27'),
(6064,4,4,1,'Corsica-AD.jpg','image/jpeg','image',NULL,1080,1080,76921,NULL,NULL,NULL,'2025-11-17 14:59:26','2025-11-17 14:59:26','2025-11-17 14:59:26'),
(6065,4,4,1,'Corsica-Admin.jpg','image/jpeg','image',NULL,1080,1080,83495,NULL,NULL,NULL,'2025-11-17 14:59:26','2025-11-17 14:59:26','2025-11-17 14:59:26'),
(6074,4,4,1,'CourtHouse-AD.jpg','image/jpeg','image',NULL,1080,1080,136015,NULL,NULL,NULL,'2025-11-17 15:01:33','2025-11-17 15:01:33','2025-11-17 15:01:33'),
(6081,4,4,1,'Dawnview-Admin.jpg','image/jpeg','image',NULL,1080,1080,76772,NULL,NULL,NULL,'2025-11-17 15:03:36','2025-11-17 15:03:36','2025-11-17 15:03:36'),
(6082,4,4,1,'Dawnview-AD.jpg','image/jpeg','image',NULL,1080,1080,137022,NULL,NULL,NULL,'2025-11-17 15:03:43','2025-11-17 15:03:43','2025-11-17 15:03:43'),
(6090,4,4,1,'Fox-Hill-Admin.jpg','image/jpeg','image',NULL,1080,1080,86164,NULL,NULL,NULL,'2025-11-24 17:09:05','2025-11-17 15:08:28','2025-11-24 17:09:05'),
(6093,4,4,1,'FoxHill-AD.jpg','image/jpeg','image',NULL,1080,1080,142923,NULL,NULL,NULL,'2025-11-17 15:11:59','2025-11-17 15:11:59','2025-11-17 15:11:59'),
(6099,4,4,1,'Virginia-AD.jpg','image/jpeg','image',NULL,1080,1080,160839,NULL,NULL,NULL,'2025-11-17 15:16:07','2025-11-17 15:16:07','2025-11-17 15:16:07'),
(6105,4,4,1,'Glendale-AD.jpg','image/jpeg','image',NULL,1080,1080,88885,NULL,NULL,NULL,'2025-11-17 15:17:03','2025-11-17 15:17:03','2025-11-17 15:17:03'),
(6112,4,4,1,'Glendale-West-AD.jpg','image/jpeg','image',NULL,1080,1080,111454,NULL,NULL,NULL,'2025-11-17 15:34:14','2025-11-17 15:34:14','2025-11-17 15:34:14'),
(6128,4,4,1,'Groton-Admin.jpg','image/jpeg','image',NULL,1080,1080,79437,NULL,NULL,NULL,'2025-11-17 15:39:49','2025-11-17 15:39:49','2025-11-17 15:39:49'),
(6130,4,4,1,'Groton-AD.jpg','image/jpeg','image',NULL,1080,1080,137965,NULL,NULL,NULL,'2025-11-17 15:41:05','2025-11-17 15:41:05','2025-11-17 15:41:05'),
(6137,4,4,1,'Groton-RCH-AD.jpg','image/jpeg','image',NULL,1080,1080,73820,NULL,NULL,NULL,'2025-11-17 15:41:55','2025-11-17 15:41:55','2025-11-17 15:41:55'),
(6143,4,4,1,'Hagerstown-AD.jpg','image/jpeg','image',NULL,1080,1080,71838,NULL,NULL,NULL,'2025-11-17 15:42:34','2025-11-17 15:42:34','2025-11-17 15:42:34'),
(6156,4,4,1,'Harrington-Admin.jpg','image/jpeg','image',NULL,1080,1080,161411,NULL,NULL,NULL,'2025-11-17 15:57:47','2025-11-17 15:57:47','2025-11-17 15:57:47'),
(6165,4,4,1,'Heritage-AD.jpg','image/jpeg','image',NULL,1080,1080,86858,NULL,NULL,NULL,'2025-11-17 15:59:50','2025-11-17 15:59:50','2025-11-17 15:59:50'),
(6167,4,4,1,'Heritage-Admin.jpg','image/jpeg','image',NULL,1080,1080,128327,NULL,NULL,NULL,'2025-11-17 16:03:15','2025-11-17 16:03:15','2025-11-17 16:03:15'),
(6173,4,4,1,'Hillside-Admin.jpg','image/jpeg','image',NULL,1080,1080,166766,NULL,NULL,NULL,'2025-11-17 16:03:58','2025-11-17 16:03:58','2025-11-17 16:03:58'),
(6175,4,4,1,'Hillside-AD.jpg','image/jpeg','image',NULL,1080,1080,97703,NULL,NULL,NULL,'2025-11-17 16:04:11','2025-11-17 16:04:11','2025-11-17 16:04:11'),
(6183,4,4,1,'Holmdel-Admin.jpg','image/jpeg','image',NULL,1080,1080,106801,NULL,NULL,NULL,'2025-11-17 16:07:56','2025-11-17 16:07:56','2025-11-17 16:07:56'),
(6185,4,4,1,'Holmdel-AD.jpg','image/jpeg','image',NULL,1080,1080,95499,NULL,NULL,NULL,'2025-11-17 16:08:16','2025-11-17 16:08:16','2025-11-17 16:08:16'),
(6191,4,4,1,'Hyattsville-AD.jpg','image/jpeg','image',NULL,1080,1080,99934,NULL,NULL,NULL,'2025-11-17 16:12:47','2025-11-17 16:12:47','2025-11-17 16:12:47'),
(6214,4,4,1,'KHS-Admin.jpg','image/jpeg','image',NULL,1080,1080,65971,NULL,NULL,NULL,'2025-11-17 16:20:31','2025-11-17 16:20:31','2025-11-17 16:20:31'),
(6216,4,4,1,'KHS-AD.jpg','image/jpeg','image',NULL,1080,1080,79925,NULL,NULL,NULL,'2025-11-17 16:20:57','2025-11-17 16:20:57','2025-11-17 16:20:57'),
(6224,4,4,1,'LaPlata-AD.jpg','image/jpeg','image',NULL,1080,1080,149206,NULL,NULL,NULL,'2025-11-17 16:22:33','2025-11-17 16:22:33','2025-11-17 16:22:33'),
(6255,4,4,1,'Meriden-Admin.jpg','image/jpeg','image',NULL,1080,1080,89665,NULL,NULL,NULL,'2025-11-17 16:36:30','2025-11-17 16:36:30','2025-11-17 16:36:30'),
(6258,4,4,1,'Meriden-AD.jpg','image/jpeg','image',NULL,1080,1080,106378,NULL,NULL,NULL,'2025-11-17 16:36:52','2025-11-17 16:36:52','2025-11-17 16:36:52'),
(6265,4,4,1,'Middlebury-Admin.jpg','image/jpeg','image',NULL,1080,1080,74221,NULL,NULL,NULL,'2025-11-17 16:38:01','2025-11-17 16:38:01','2025-11-17 16:38:01'),
(6270,4,4,1,'Middlebury-AD.jpg','image/jpeg','image',NULL,1080,1080,124845,NULL,NULL,NULL,'2025-11-17 16:38:22','2025-11-17 16:38:22','2025-11-17 16:38:22'),
(6279,4,4,1,'Multi-Admin.jpg','image/jpeg','image',NULL,1080,1080,132222,NULL,NULL,NULL,'2025-11-17 16:41:23','2025-11-17 16:41:23','2025-11-17 16:41:23'),
(6281,4,4,1,'Multi-AD.jpg','image/jpeg','image',NULL,1080,1080,160323,NULL,NULL,NULL,'2025-11-17 16:41:32','2025-11-17 16:41:32','2025-11-17 16:41:32'),
(6287,4,4,1,'Nazareth-Admin.jpg','image/jpeg','image',NULL,1080,1080,87505,NULL,NULL,NULL,'2025-11-17 16:42:25','2025-11-17 16:42:25','2025-11-17 16:42:25'),
(6292,4,4,1,'OakRidge-Admin.jpg','image/jpeg','image',NULL,1080,1080,73983,NULL,NULL,NULL,'2025-11-17 16:43:43','2025-11-17 16:43:43','2025-11-17 16:43:43'),
(6294,4,4,1,'OakRidge-AD.jpg','image/jpeg','image',NULL,1080,1080,96505,NULL,NULL,NULL,'2025-11-17 16:44:01','2025-11-17 16:44:01','2025-11-17 16:44:01'),
(6330,4,4,1,'Severna-Admin.jpg','image/jpeg','image',NULL,1080,1080,92817,NULL,NULL,NULL,'2025-11-17 16:52:18','2025-11-17 16:52:18','2025-11-17 16:52:18'),
(6341,4,4,1,'Shorrock-Admin.jpg','image/jpeg','image',NULL,1080,1080,77846,NULL,NULL,NULL,'2025-11-17 16:54:57','2025-11-17 16:54:57','2025-11-17 16:54:57'),
(6343,4,4,1,'Shorrock-AD.jpg','image/jpeg','image',NULL,1080,1080,107350,NULL,NULL,NULL,'2025-11-17 16:55:03','2025-11-17 16:55:03','2025-11-17 16:55:03'),
(6363,4,4,1,'Victoria-Admin.jpg','image/jpeg','image',NULL,1080,1080,86112,NULL,NULL,NULL,'2025-11-17 16:58:08','2025-11-17 16:58:08','2025-11-17 16:58:08'),
(6422,2,2,1,'367A3413.jpg','image/jpeg','image',NULL,6728,4491,5462043,NULL,NULL,NULL,'2025-11-19 20:57:57','2025-11-19 20:57:58','2025-11-19 20:57:58'),
(6434,4,4,1,'Hyattsville-Admin.jpg','image/jpeg','image',NULL,1080,1080,309149,NULL,NULL,NULL,'2025-11-24 14:42:12','2025-11-24 14:42:12','2025-11-24 14:42:12'),
(6460,4,4,1,'BeyLeaAL-Admin.jpg','image/jpeg','image',NULL,1080,1080,122414,NULL,NULL,NULL,'2025-12-01 19:39:53','2025-12-01 19:39:53','2025-12-01 19:39:53'),
(6519,3,3,1,'Bayshore.doc','application/msword','word',NULL,NULL,NULL,3957248,NULL,NULL,NULL,'2025-12-12 18:18:33','2025-12-12 18:18:33','2025-12-12 18:18:33'),
(6525,3,3,1,'Floor-plan-Mayfair-and-Chelsea.pdf','application/pdf','pdf',NULL,NULL,NULL,317599,NULL,NULL,NULL,'2025-12-12 18:45:11','2025-12-12 18:45:11','2025-12-12 18:45:11'),
(6526,3,3,1,'Holmdel-December2025-Calendar.pdf','application/pdf','pdf',NULL,NULL,NULL,2162299,NULL,NULL,NULL,'2025-12-12 18:45:39','2025-12-12 18:45:39','2025-12-12 18:45:39'),
(6527,2,2,1,'STS_0013.jpg','image/jpeg','image',NULL,5040,3360,3970415,NULL,NULL,NULL,'2025-12-12 18:47:11','2025-12-12 18:47:11','2025-12-12 18:47:11'),
(6528,2,2,1,'STS_0020.jpg','image/jpeg','image',NULL,5040,3360,3961803,NULL,NULL,NULL,'2025-12-12 18:47:13','2025-12-12 18:47:13','2025-12-12 18:47:13'),
(6529,2,2,1,'STS_0085.jpg','image/jpeg','image',NULL,6720,4480,9165144,NULL,NULL,NULL,'2025-12-12 18:47:16','2025-12-12 18:47:16','2025-12-12 18:47:16'),
(6530,2,2,1,'Exterior_2025-12-12-184908_qmng.jpg','image/jpeg','image',NULL,6665,4480,7678058,'0.3464;0.4343',NULL,NULL,'2025-12-12 18:49:09','2025-12-12 18:49:09','2026-01-14 16:57:15'),
(6533,2,2,1,'STS_0127.jpg','image/jpeg','image',NULL,6515,4483,8581705,NULL,NULL,NULL,'2025-12-12 18:49:58','2025-12-12 18:49:59','2025-12-12 18:49:59'),
(6542,3,3,1,'Annapolis.doc','application/msword','word',NULL,NULL,NULL,2724864,NULL,NULL,NULL,'2025-12-15 18:42:42','2025-12-15 18:42:42','2025-12-15 18:42:42'),
(6548,6,8,1,'CMS_5-Star-Overall.png','image/png','image',NULL,2160,2164,696318,NULL,NULL,NULL,'2025-12-15 19:55:28','2025-12-15 19:55:28','2025-12-15 19:55:28'),
(6557,3,3,1,'Boulevard_December2025.doc','application/msword','word',NULL,NULL,NULL,398848,NULL,NULL,NULL,'2025-12-16 14:42:20','2025-12-16 14:42:20','2025-12-16 14:42:20'),
(6569,3,3,1,'Margate-Park_December2025.pdf','application/pdf','pdf',NULL,NULL,NULL,144457,NULL,NULL,NULL,'2025-12-16 14:48:55','2025-12-16 14:48:55','2025-12-16 14:48:55'),
(6598,2,2,1,'Chestnut-Hill-Residences-Exterior.jpg','image/jpeg','image',NULL,7800,5200,12216826,NULL,NULL,NULL,'2025-12-16 15:02:23','2025-12-16 15:02:23','2025-12-16 15:02:23'),
(6600,2,2,1,'20240813-Chestnut-Hill-Photos-09.jpg','image/jpeg','image',NULL,7800,5200,14997871,NULL,NULL,NULL,'2025-12-16 15:04:45','2025-12-16 15:04:45','2025-12-16 15:04:45'),
(6601,2,2,1,'20240813-Chestnut-Hill-Photos-11.jpg','image/jpeg','image',NULL,6600,4400,15174338,NULL,NULL,NULL,'2025-12-16 15:04:51','2025-12-16 15:04:51','2025-12-16 15:04:51'),
(6602,3,3,1,'Chestnut-Hill-ALF.pdf','application/pdf','pdf',NULL,NULL,NULL,1746668,NULL,NULL,NULL,'2025-12-16 15:07:32','2025-12-16 15:07:32','2025-12-16 15:07:32'),
(6608,4,4,1,'ChestnutRes-Admin.png','image/png','image',NULL,1080,1080,1063664,NULL,NULL,NULL,'2025-12-16 15:16:02','2025-12-16 15:16:02','2025-12-16 15:16:02'),
(6614,4,4,1,'Brakeley-Admin.png','image/png','image',NULL,1080,1080,930826,NULL,NULL,NULL,'2025-12-16 15:22:37','2025-12-16 15:22:37','2025-12-16 15:22:37'),
(6620,3,3,1,'Barn-Hill.pdf','application/pdf','pdf',NULL,NULL,NULL,405602,NULL,NULL,NULL,'2026-01-02 20:39:28','2025-12-16 15:25:36','2026-01-02 20:39:28'),
(6629,4,4,1,'BarnHill-Admin.png','image/png','image',NULL,1080,1080,1019715,NULL,NULL,NULL,'2025-12-16 15:26:50','2025-12-16 15:26:50','2025-12-16 15:26:50'),
(6635,2,2,1,'367A0020.jpg','image/jpeg','image',NULL,6720,4480,15270710,NULL,NULL,NULL,'2025-12-16 15:30:17','2025-12-16 15:30:17','2025-12-16 15:30:17'),
(6636,2,2,1,'367A0034.jpg','image/jpeg','image',NULL,6720,4480,16349497,NULL,NULL,NULL,'2025-12-16 15:30:24','2025-12-16 15:30:25','2025-12-16 15:30:25'),
(6637,2,2,1,'367A0043.jpg','image/jpeg','image',NULL,6722,4480,5875903,NULL,NULL,NULL,'2025-12-16 15:30:28','2025-12-16 15:30:28','2025-12-16 15:30:28'),
(6638,2,2,1,'367A0052.jpg','image/jpeg','image',NULL,6720,4480,7074932,NULL,NULL,NULL,'2025-12-16 15:30:32','2025-12-16 15:30:33','2025-12-16 15:30:33'),
(6639,2,2,1,'367A9976.jpg','image/jpeg','image',NULL,6720,4480,16439021,NULL,NULL,NULL,'2025-12-16 15:30:40','2025-12-16 15:30:40','2025-12-16 15:30:40'),
(6640,2,2,1,'367A9985.jpg','image/jpeg','image',NULL,6720,4480,15086641,NULL,NULL,NULL,'2025-12-16 15:30:46','2025-12-16 15:30:46','2025-12-16 15:30:46'),
(6641,3,3,1,'Groton_RCH_December2025.pdf','application/pdf','pdf',NULL,NULL,NULL,312320,NULL,NULL,NULL,'2025-12-16 15:30:56','2025-12-16 15:30:56','2025-12-16 15:30:56'),
(6659,2,2,1,'367A9932.jpg','image/jpeg','image',NULL,6720,4480,15769452,NULL,NULL,NULL,'2025-12-16 15:34:40','2025-12-16 15:34:40','2025-12-16 15:34:40'),
(6680,2,2,1,'367A9927.jpg','image/jpeg','image',NULL,6720,4480,16032970,NULL,NULL,NULL,'2025-12-16 15:39:21','2025-12-16 15:39:21','2025-12-16 15:39:21'),
(6681,2,2,1,'367A9939.jpg','image/jpeg','image',NULL,6720,4480,16367230,NULL,NULL,NULL,'2025-12-16 15:39:33','2025-12-16 15:39:33','2025-12-16 15:39:33'),
(6682,2,2,1,'367A9944.jpg','image/jpeg','image',NULL,6720,4480,15269625,NULL,NULL,NULL,'2025-12-16 15:39:39','2025-12-16 15:39:39','2025-12-16 15:39:39'),
(6683,2,2,1,'367A9972.jpg','image/jpeg','image',NULL,6720,4480,15509252,NULL,NULL,NULL,'2025-12-16 15:39:48','2025-12-16 15:39:48','2025-12-16 15:39:48'),
(6684,2,2,1,'367A9993.jpg','image/jpeg','image',NULL,6720,4480,14789734,NULL,NULL,NULL,'2025-12-16 15:39:55','2025-12-16 15:39:55','2025-12-16 15:39:55'),
(6685,3,3,1,'Groton_December2025.pdf','application/pdf','pdf',NULL,NULL,NULL,338796,NULL,NULL,NULL,'2025-12-16 15:40:17','2025-12-16 15:40:17','2025-12-16 15:40:17'),
(6741,2,2,1,'Corsica-Ext-1.jpg','image/jpeg','image',NULL,3600,2400,8065283,NULL,NULL,NULL,'2025-12-30 19:44:15','2025-12-30 19:44:15','2025-12-30 19:44:15'),
(6759,2,2,1,'Corsica-Dining-11.jpg','image/jpeg','image',NULL,3600,2400,6856950,NULL,NULL,NULL,'2025-12-30 19:48:07','2025-12-30 19:48:07','2025-12-30 19:48:07'),
(6760,2,2,1,'Corsica-Lobby4.jpg','image/jpeg','image',NULL,3600,2400,7658760,NULL,NULL,NULL,'2025-12-30 19:48:10','2025-12-30 19:48:10','2025-12-30 19:48:10'),
(6761,2,2,1,'Corsica-Memory-Care-Activities.jpg','image/jpeg','image',NULL,3600,2400,4531322,NULL,NULL,NULL,'2025-12-30 19:48:12','2025-12-30 19:48:12','2025-12-30 19:48:12'),
(6762,2,2,1,'Corsica-Patios-6.jpg','image/jpeg','image',NULL,3600,2400,6321521,NULL,NULL,NULL,'2025-12-30 19:48:15','2025-12-30 19:48:15','2025-12-30 19:48:15'),
(6763,2,2,1,'Corsica-Rehab-12.jpg','image/jpeg','image',NULL,3600,2400,6996198,NULL,NULL,NULL,'2025-12-30 19:48:18','2025-12-30 19:48:18','2025-12-30 19:48:18'),
(6764,2,2,1,'Corsica-Rooms-24.jpg','image/jpeg','image',NULL,3600,2400,8848976,NULL,NULL,NULL,'2025-12-30 19:48:29','2025-12-30 19:48:29','2025-12-30 19:48:29'),
(6765,2,2,1,'Corsica-Salon-23.jpg','image/jpeg','image',NULL,3600,2400,5452615,NULL,NULL,NULL,'2025-12-30 19:48:32','2025-12-30 19:48:32','2025-12-30 19:48:32'),
(6766,2,2,1,'Corsica-STR-sitting-room.jpg','image/jpeg','image',NULL,3600,2400,6280427,NULL,NULL,NULL,'2025-12-30 19:48:36','2025-12-30 19:48:36','2025-12-30 19:48:36'),
(6767,3,3,1,'Corsica-Hills.pdf','application/pdf','pdf',NULL,NULL,NULL,1645939,NULL,NULL,NULL,'2025-12-30 20:04:54','2025-12-30 20:04:54','2025-12-30 20:04:54'),
(6772,2,2,1,'Fort-Ashby-Lobby-09.JPG','image/jpeg','image',NULL,3600,2400,1913844,NULL,NULL,NULL,'2025-12-30 20:54:09','2025-12-30 20:54:09','2025-12-30 20:54:09'),
(6792,2,2,1,'Fort-Ashby-Dining-12.JPG','image/jpeg','image',NULL,3600,2400,2499729,NULL,NULL,NULL,'2025-12-30 21:32:26','2025-12-30 21:32:26','2025-12-30 21:32:26'),
(6793,2,2,1,'Fort-Ashby-Exterior02.JPG','image/jpeg','image',NULL,3600,2400,3334366,NULL,NULL,NULL,'2025-12-30 21:32:27','2025-12-30 21:32:28','2025-12-30 21:32:28'),
(6794,2,2,1,'Fort-Ashby-Lounge-13.JPG','image/jpeg','image',NULL,3600,2400,2776228,NULL,NULL,NULL,'2025-12-30 21:32:29','2025-12-30 21:32:29','2025-12-30 21:32:29'),
(6795,2,2,1,'Fort-Ashby-rehab-10.JPG','image/jpeg','image',NULL,3600,2400,1909477,NULL,NULL,NULL,'2025-12-30 21:32:31','2025-12-30 21:32:31','2025-12-30 21:32:31'),
(6796,2,2,1,'Fort-Ashby-Room-11.JPG','image/jpeg','image',NULL,3600,2400,1836575,NULL,NULL,NULL,'2025-12-30 21:32:33','2025-12-30 21:32:33','2025-12-30 21:32:33'),
(6797,3,3,1,'Dawnview.doc','application/msword','word',NULL,NULL,NULL,766976,NULL,NULL,NULL,'2025-12-30 21:39:01','2025-12-30 21:39:01','2025-12-30 21:39:01'),
(6801,3,3,1,'Bayshore-Jan.pdf','application/pdf','pdf',NULL,NULL,NULL,1200508,NULL,NULL,NULL,'2026-01-02 19:49:10','2026-01-02 19:49:10','2026-01-02 19:49:10'),
(6803,3,3,1,'Cedar-Grove.pdf','application/pdf','pdf',NULL,NULL,NULL,228162,NULL,NULL,NULL,'2026-01-02 19:49:57','2026-01-02 19:49:57','2026-01-02 19:49:57'),
(6806,3,3,1,'Clark.pdf','application/pdf','pdf',NULL,NULL,NULL,428836,NULL,NULL,NULL,'2026-01-02 19:59:21','2026-01-02 19:52:48','2026-01-02 19:59:21'),
(6808,3,3,1,'Clark_2026-01-02-195917_vqax.pdf','application/pdf','pdf',NULL,NULL,NULL,428836,NULL,0,0,'2026-01-02 19:59:17','2026-01-02 19:59:17','2026-01-02 19:59:17'),
(6812,3,3,1,'Holmdel-January2026Calendar.pdf','application/pdf','pdf',NULL,NULL,NULL,547013,NULL,NULL,NULL,'2026-01-02 20:00:26','2026-01-02 20:00:26','2026-01-02 20:00:26'),
(6814,3,3,1,'Madison.pdf','application/pdf','pdf',NULL,NULL,NULL,2415020,NULL,NULL,NULL,'2026-01-02 20:01:59','2026-01-02 20:01:59','2026-01-02 20:01:59'),
(6818,3,3,1,'Mercerville.pdf','application/pdf','pdf',NULL,NULL,NULL,588213,NULL,NULL,NULL,'2026-01-02 20:04:04','2026-01-02 20:04:04','2026-01-02 20:04:04'),
(6820,3,3,1,'Orange-Park.pdf','application/pdf','pdf',NULL,NULL,NULL,615648,NULL,NULL,NULL,'2026-01-02 20:05:05','2026-01-02 20:05:05','2026-01-02 20:05:05'),
(6824,3,3,1,'Park-Place.pdf','application/pdf','pdf',NULL,NULL,NULL,402353,NULL,NULL,NULL,'2026-01-02 20:06:15','2026-01-02 20:06:15','2026-01-02 20:06:15'),
(6826,3,3,1,'West-Caldwell.pdf','application/pdf','pdf',NULL,NULL,NULL,257000,NULL,NULL,NULL,'2026-01-02 20:08:16','2026-01-02 20:08:16','2026-01-02 20:08:16'),
(6830,3,3,1,'Westfield.pdf','application/pdf','pdf',NULL,NULL,NULL,615167,NULL,NULL,NULL,'2026-01-02 20:08:55','2026-01-02 20:08:55','2026-01-02 20:08:55'),
(6832,3,3,1,'Woodlands.pdf','application/pdf','pdf',NULL,NULL,NULL,615066,NULL,NULL,NULL,'2026-01-02 20:10:32','2026-01-02 20:10:32','2026-01-02 20:10:32'),
(6835,3,3,1,'Glendale-Jan.pdf','application/pdf','pdf',NULL,NULL,NULL,453941,NULL,NULL,NULL,'2026-01-02 20:13:07','2026-01-02 20:13:07','2026-01-02 20:13:07'),
(6838,3,3,1,'Groton-Regency-EF.pdf','application/pdf','pdf',NULL,NULL,NULL,176447,NULL,NULL,NULL,'2026-01-02 20:15:26','2026-01-02 20:15:26','2026-01-02 20:15:26'),
(6840,3,3,1,'Groton-Regency_January2026.pdf','application/pdf','pdf',NULL,NULL,NULL,507071,NULL,NULL,NULL,'2026-01-02 20:16:40','2026-01-02 20:16:40','2026-01-02 20:16:40'),
(6844,3,3,1,'Meriden_January2026.pdf','application/pdf','pdf',NULL,NULL,NULL,522517,NULL,NULL,NULL,'2026-01-02 20:17:20','2026-01-02 20:17:20','2026-01-02 20:17:20'),
(6846,3,3,1,'Middlebury-Jan.pdf','application/pdf','pdf',NULL,NULL,NULL,905076,NULL,NULL,NULL,'2026-01-02 20:18:12','2026-01-02 20:18:12','2026-01-02 20:18:12'),
(6850,3,3,1,'Brackenville_January2026.pdf','application/pdf','pdf',NULL,NULL,NULL,276398,NULL,NULL,NULL,'2026-01-02 20:21:06','2026-01-02 20:21:06','2026-01-02 20:21:06'),
(6852,3,3,1,'Dawnview_January2026.pdf','application/pdf','pdf',NULL,NULL,NULL,501338,NULL,NULL,NULL,'2026-01-02 20:22:08','2026-01-02 20:22:08','2026-01-02 20:22:08'),
(6858,3,3,1,'Hagerstown.pdf','application/pdf','pdf',NULL,NULL,NULL,241835,NULL,NULL,NULL,'2026-01-02 20:24:27','2026-01-02 20:24:27','2026-01-02 20:24:27'),
(6860,3,3,1,'Hillside-2.pdf','application/pdf','pdf',NULL,NULL,NULL,593827,NULL,NULL,NULL,'2026-01-02 20:26:43','2026-01-02 20:26:44','2026-01-02 20:26:44'),
(6864,3,3,1,'Hillside-2_2026-01-02-202801_wfsj.pdf','application/pdf','pdf',NULL,NULL,NULL,593827,NULL,NULL,NULL,'2026-01-02 20:28:01','2026-01-02 20:28:01','2026-01-02 20:28:01'),
(6865,3,3,1,'Hyattsville-2.pdf','application/pdf','pdf',NULL,NULL,NULL,870663,NULL,NULL,NULL,'2026-01-02 20:29:12','2026-01-02 20:29:12','2026-01-02 20:29:12'),
(6867,3,3,1,'La-Plata-January.pdf','application/pdf','pdf',NULL,NULL,NULL,864869,NULL,NULL,NULL,'2026-01-02 20:30:05','2026-01-02 20:30:05','2026-01-02 20:30:05'),
(6872,3,3,1,'Multi-Medical.pdf','application/pdf','pdf',NULL,NULL,NULL,450697,NULL,NULL,NULL,'2026-01-02 20:31:54','2026-01-02 20:31:54','2026-01-02 20:31:54'),
(6877,3,3,1,'OakRidge-Jan.pdf','application/pdf','pdf',NULL,NULL,NULL,212946,NULL,NULL,NULL,'2026-01-02 20:36:08','2026-01-02 20:36:09','2026-01-02 20:36:09'),
(6880,3,3,1,'Severna-Park.pdf','application/pdf','pdf',NULL,NULL,NULL,5858335,NULL,NULL,NULL,'2026-01-02 20:37:30','2026-01-02 20:37:30','2026-01-02 20:37:30'),
(6882,3,3,1,'Springbrook.pdf','application/pdf','pdf',NULL,NULL,NULL,157928,NULL,NULL,NULL,'2026-01-02 20:38:21','2026-01-02 20:38:22','2026-01-02 20:38:22'),
(6885,3,3,1,'Barn-Hill_2026-01-02-203926_qrhk.pdf','application/pdf','pdf',NULL,NULL,NULL,405602,NULL,0,0,'2026-01-02 20:39:26','2026-01-02 20:39:26','2026-01-02 20:39:26'),
(6887,3,3,1,'Berkshire.pdf','application/pdf','pdf',NULL,NULL,NULL,444014,NULL,NULL,NULL,'2026-01-02 20:39:58','2026-01-02 20:39:58','2026-01-02 20:39:58'),
(6889,3,3,1,'Chestnut-Hill-Residences.pdf','application/pdf','pdf',NULL,NULL,NULL,657959,NULL,NULL,NULL,'2026-01-02 20:42:48','2026-01-02 20:42:48','2026-01-02 20:42:48'),
(6892,3,3,1,'Fair-Lawn-Edge.pdf','application/pdf','pdf',NULL,NULL,NULL,624578,NULL,NULL,NULL,'2026-01-02 20:43:43','2026-01-02 20:43:43','2026-01-02 20:43:43'),
(6897,3,3,1,'Hamilton-Plaza.pdf','application/pdf','pdf',NULL,NULL,NULL,358600,NULL,NULL,NULL,'2026-01-02 20:45:12','2026-01-02 20:45:12','2026-01-02 20:45:12'),
(6899,3,3,1,'Harston-Hall.pdf','application/pdf','pdf',NULL,NULL,NULL,777946,NULL,NULL,NULL,'2026-01-02 20:46:00','2026-01-02 20:46:00','2026-01-02 20:46:00'),
(6902,3,3,1,'Inglemoor.pdf','application/pdf','pdf',NULL,NULL,NULL,2311600,NULL,NULL,NULL,'2026-01-02 20:47:51','2026-01-02 20:47:51','2026-01-02 20:47:51'),
(6904,3,3,1,'Lehigh.pdf','application/pdf','pdf',NULL,NULL,NULL,650480,NULL,NULL,NULL,'2026-01-02 20:48:59','2026-01-02 20:48:59','2026-01-02 20:48:59'),
(6907,3,3,1,'Milford-Manor-Dining-Room.pdf','application/pdf','pdf',NULL,NULL,NULL,151100,NULL,NULL,NULL,'2026-01-02 20:50:09','2026-01-02 20:50:09','2026-01-02 20:50:09'),
(6911,3,3,1,'Phillipsburg.pdf','application/pdf','pdf',NULL,NULL,NULL,672200,NULL,NULL,NULL,'2026-01-02 20:51:11','2026-01-02 20:51:11','2026-01-02 20:51:11'),
(6916,3,3,1,'Wayne-Hills.pdf','application/pdf','pdf',NULL,NULL,NULL,3853557,NULL,NULL,NULL,'2026-01-02 20:53:13','2026-01-02 20:53:13','2026-01-02 20:53:13'),
(6918,3,3,1,'Arbors-January2026Calendar.pdf','application/pdf','pdf',NULL,NULL,NULL,12308983,NULL,NULL,NULL,'2026-01-02 20:54:24','2026-01-02 20:54:24','2026-01-02 20:54:24'),
(6919,3,3,1,'Arbors-January2026Calendar_2026-01-02-205430_dbyg.pdf','application/pdf','pdf',NULL,NULL,NULL,12308983,NULL,NULL,NULL,'2026-01-02 20:54:30','2026-01-02 20:54:30','2026-01-02 20:54:30'),
(6922,3,3,1,'Glendale-West.pdf','application/pdf','pdf',NULL,NULL,NULL,528460,NULL,NULL,NULL,'2026-01-02 20:58:21','2026-01-02 20:58:21','2026-01-02 20:58:21'),
(6925,3,3,1,'Hales-Corners.pdf','application/pdf','pdf',NULL,NULL,NULL,967357,NULL,NULL,NULL,'2026-01-02 20:59:12','2026-01-02 20:59:12','2026-01-02 20:59:12'),
(6927,3,3,1,'Kensington.pdf','application/pdf','pdf',NULL,NULL,NULL,516873,NULL,NULL,NULL,'2026-01-02 20:59:30','2026-01-02 20:59:30','2026-01-02 20:59:30'),
(6931,3,3,1,'Manitowoc.pdf','application/pdf','pdf',NULL,NULL,NULL,602088,NULL,NULL,NULL,'2026-01-02 21:01:04','2026-01-02 21:01:04','2026-01-02 21:01:04'),
(6934,3,3,1,'Southpointe.pdf','application/pdf','pdf',NULL,NULL,NULL,113944,NULL,NULL,NULL,'2026-01-02 21:02:06','2026-01-02 21:02:06','2026-01-02 21:02:06'),
(6949,4,4,1,'BeyLeaSNF-Admin.jpg','image/jpeg','image',NULL,1080,1080,66291,NULL,NULL,NULL,'2026-01-05 16:45:54','2026-01-05 16:45:54','2026-01-05 16:45:54'),
(6954,4,4,1,'Annapolis-Admin-1.jpg','image/jpeg','image',NULL,1080,1080,106745,NULL,NULL,NULL,'2026-01-05 17:02:02','2026-01-05 17:02:02','2026-01-05 17:02:02'),
(6964,4,4,1,'Bayshore-Admin-1.jpg','image/jpeg','image',NULL,1080,1080,98357,NULL,NULL,NULL,'2026-01-05 17:07:45','2026-01-05 17:07:45','2026-01-05 17:07:45'),
(6971,4,4,1,'Berkshire-Admin.jpg','image/jpeg','image',NULL,1080,1080,69526,NULL,NULL,NULL,'2026-01-05 17:12:18','2026-01-05 17:12:18','2026-01-05 17:12:18'),
(6986,4,4,1,'CourtHouse-Admin.jpg','image/jpeg','image',NULL,1080,1080,236270,NULL,NULL,NULL,'2026-01-05 17:22:05','2026-01-05 17:22:05','2026-01-05 17:22:05'),
(6991,4,4,1,'CourtHouse-Admin-1.jpg','image/jpeg','image',NULL,1080,1080,236061,NULL,NULL,NULL,'2026-01-05 17:23:13','2026-01-05 17:23:13','2026-01-05 17:23:13'),
(7013,4,4,1,'FairLawn-Admin.jpg','image/jpeg','image',NULL,1080,1080,100289,NULL,NULL,NULL,'2026-01-05 17:57:56','2026-01-05 17:57:56','2026-01-05 17:57:56'),
(7020,4,4,1,'GlendaleCT-Admin.jpg','image/jpeg','image',NULL,1080,1080,112763,NULL,NULL,NULL,'2026-01-05 18:17:20','2026-01-05 18:17:20','2026-01-05 18:17:20'),
(7033,4,4,1,'Hagerstown-Admin.jpg','image/jpeg','image',NULL,1080,1080,112861,NULL,0,0,'2026-01-05 18:25:51','2026-01-05 18:25:51','2026-01-05 18:25:51'),
(7038,4,4,1,'Hagerstown-Admin-1.jpg','image/jpeg','image',NULL,1080,1080,103689,NULL,NULL,NULL,'2026-01-05 18:27:22','2026-01-05 18:27:22','2026-01-05 18:27:22'),
(7042,4,4,1,'HamiltonPlaza-Admin.jpg','image/jpeg','image',NULL,1080,1080,77584,NULL,NULL,NULL,'2026-01-05 18:30:08','2026-01-05 18:30:08','2026-01-05 18:30:08'),
(7068,4,4,1,'Laurelton-Admin.jpg','image/jpeg','image',NULL,1080,1080,213232,NULL,NULL,NULL,'2026-01-05 18:50:49','2026-01-05 18:50:49','2026-01-05 18:50:49'),
(7084,4,4,1,'Monmouth-Admin.jpg','image/jpeg','image',NULL,1080,1080,82751,NULL,NULL,NULL,'2026-01-05 21:12:20','2026-01-05 21:12:20','2026-01-05 21:12:20'),
(7096,4,4,1,'Plainfield-Admin.jpg','image/jpeg','image',NULL,1080,1080,56052,NULL,NULL,NULL,'2026-01-05 21:18:57','2026-01-05 21:18:57','2026-01-05 21:18:57'),
(7126,4,4,1,'Margate-AD.jpg','image/jpeg','image',NULL,1080,1080,91098,NULL,NULL,NULL,'2026-01-06 16:51:24','2026-01-06 16:45:12','2026-01-06 16:51:24'),
(7133,4,4,1,'Margate-AD_2026-01-06-165121_gioe.jpg','image/jpeg','image',NULL,1080,1080,91106,NULL,0,0,'2026-01-06 16:51:21','2026-01-06 16:51:21','2026-01-06 16:51:21'),
(7140,4,4,1,'Margate-Admin.jpg','image/jpeg','image',NULL,1080,1080,96190,NULL,NULL,NULL,'2026-01-06 19:04:55','2026-01-06 19:04:55','2026-01-06 19:04:55'),
(7151,4,4,1,'FoxHill-AD-1.jpg','image/jpeg','image',NULL,1080,1080,316137,NULL,NULL,NULL,'2026-01-06 20:42:45','2026-01-06 20:42:45','2026-01-06 20:42:45'),
(7288,3,3,1,'Bayshore.docx','application/vnd.openxmlformats-officedocument.wordprocessingml.document','word',NULL,NULL,NULL,4045016,NULL,NULL,NULL,'2026-01-07 20:15:25','2026-01-07 20:15:25','2026-01-07 20:15:25'),
(7291,4,4,1,'Voorhees-Admin.jpg','image/jpeg','image',NULL,1080,1080,102603,NULL,NULL,NULL,'2026-01-07 20:56:48','2026-01-07 20:56:48','2026-01-07 20:56:48'),
(7299,4,4,1,'GlendaleWest-AD.jpg','image/jpeg','image',NULL,1080,1080,59207,NULL,NULL,NULL,'2026-01-07 21:05:18','2026-01-07 21:05:18','2026-01-07 21:05:18'),
(7307,4,4,1,'HolidayCity-Admin.jpg','image/jpeg','image',NULL,1080,1080,299643,NULL,NULL,NULL,'2026-01-07 21:22:46','2026-01-07 21:22:46','2026-01-07 21:22:46'),
(7310,4,4,1,'OceanGrove-Admin.jpg','image/jpeg','image',NULL,1080,1080,73094,NULL,NULL,NULL,'2026-01-07 21:24:59','2026-01-07 21:24:59','2026-01-07 21:24:59'),
(7314,4,4,1,'Shrewsbury-Admin.jpg','image/jpeg','image',NULL,1080,1080,305881,NULL,NULL,NULL,'2026-01-07 21:36:38','2026-01-07 21:36:38','2026-01-07 21:36:38'),
(7320,4,4,1,'Wall-Admin.jpg','image/jpeg','image',NULL,1080,1080,191787,NULL,NULL,NULL,'2026-01-07 21:50:14','2026-01-07 21:50:14','2026-01-07 21:50:14'),
(7324,4,4,1,'ParkPlace-Admin.jpg','image/jpeg','image',NULL,1080,1080,69889,NULL,NULL,NULL,'2026-01-07 21:52:59','2026-01-07 21:52:59','2026-01-07 21:52:59'),
(7328,4,4,1,'WestCaldwell-Admin.jpg','image/jpeg','image',NULL,1080,1080,93015,NULL,NULL,NULL,'2026-01-07 21:58:01','2026-01-07 21:58:01','2026-01-07 21:58:01'),
(7356,4,4,1,'Jefferson-Admin.jpg','image/jpeg','image',NULL,1080,1080,165956,NULL,NULL,NULL,'2026-01-08 16:02:28','2026-01-08 16:02:28','2026-01-08 16:02:28'),
(7359,4,4,1,'Jefferson-AD.jpg','image/jpeg','image',NULL,1080,1080,203438,NULL,NULL,NULL,'2026-01-08 16:18:06','2026-01-08 16:18:06','2026-01-08 16:18:06'),
(7365,4,4,1,'Harston-AD.jpg','image/jpeg','image',NULL,1080,1080,139615,NULL,NULL,NULL,'2026-01-08 17:57:47','2026-01-08 17:57:47','2026-01-08 17:57:47'),
(7646,3,3,1,'BeyLeaSNF-January2026Calendar.pdf','application/pdf','pdf',NULL,NULL,NULL,5333295,NULL,NULL,NULL,'2026-01-12 18:50:54','2026-01-12 18:50:54','2026-01-12 18:50:54'),
(7649,3,3,1,'BeyLeaALF-January2026Calendar.pdf','application/pdf','pdf',NULL,NULL,NULL,3241501,NULL,NULL,NULL,'2026-01-12 18:51:19','2026-01-12 18:51:19','2026-01-12 18:51:19'),
(7652,3,3,1,'Brick-January2026Calendar.pdf','application/pdf','pdf',NULL,NULL,NULL,6472208,NULL,NULL,NULL,'2026-01-12 18:51:38','2026-01-12 18:51:38','2026-01-12 18:51:38'),
(7655,3,3,1,'BurlingtonWoods-January2026Calendar.pdf','application/pdf','pdf',NULL,NULL,NULL,3489145,NULL,NULL,NULL,'2026-01-12 18:51:56','2026-01-12 18:51:56','2026-01-12 18:51:56'),
(7658,3,3,1,'CourtHouse-January2026Calenda.pdf','application/pdf','pdf',NULL,NULL,NULL,5728313,NULL,NULL,NULL,'2026-01-12 18:52:17','2026-01-12 18:52:17','2026-01-12 18:52:17'),
(7661,3,3,1,'GreenAcres-January2026Calendar-Main.pdf','application/pdf','pdf',NULL,NULL,NULL,4838034,NULL,NULL,NULL,'2026-01-12 18:52:37','2026-01-12 18:52:37','2026-01-12 18:52:37'),
(7664,3,3,1,'HolidayCity-January2026Calendar-Main.pdf','application/pdf','pdf',NULL,NULL,NULL,4020758,NULL,NULL,NULL,'2026-01-12 18:52:59','2026-01-12 18:52:59','2026-01-12 18:52:59'),
(7667,3,3,1,'KressonView-January2026Calendar-Main.pdf','application/pdf','pdf',NULL,NULL,NULL,5965420,NULL,NULL,NULL,'2026-01-12 18:53:21','2026-01-12 18:53:22','2026-01-12 18:53:22'),
(7670,3,3,1,'Laurelton-January2026Calendar-Main.pdf','application/pdf','pdf',NULL,NULL,NULL,8105309,NULL,NULL,NULL,'2026-01-12 18:53:44','2026-01-12 18:53:44','2026-01-12 18:53:44'),
(7674,3,3,1,'Monmouth-January2026Calendar-Main.pdf','application/pdf','pdf',NULL,NULL,NULL,4875606,NULL,NULL,NULL,'2026-01-12 19:17:21','2026-01-12 19:17:21','2026-01-12 19:17:21'),
(7677,3,3,1,'OceanGrove-January2026-Calendar.pdf','application/pdf','pdf',NULL,NULL,NULL,1384409,NULL,NULL,NULL,'2026-01-12 19:17:41','2026-01-12 19:17:41','2026-01-12 19:17:41'),
(7680,3,3,1,'Shorrock-January2026Calendar.pdf','application/pdf','pdf',NULL,NULL,NULL,8101411,NULL,NULL,NULL,'2026-01-12 19:18:09','2026-01-12 19:18:09','2026-01-12 19:18:09'),
(7683,3,3,1,'Shrewsbury-January2026Calendar.pdf','application/pdf','pdf',NULL,NULL,NULL,6120056,NULL,NULL,NULL,'2026-01-12 19:18:37','2026-01-12 19:18:37','2026-01-12 19:18:37'),
(7685,3,3,1,'VictoriaCommons-January2026Calendar.pdf','application/pdf','pdf',NULL,NULL,NULL,9519561,NULL,NULL,NULL,'2026-01-12 19:18:57','2026-01-12 19:18:57','2026-01-12 19:18:57'),
(7689,3,3,1,'Voorhees-January2026Calendar-Main.pdf','application/pdf','pdf',NULL,NULL,NULL,4105077,NULL,NULL,NULL,'2026-01-12 19:19:35','2026-01-12 19:19:36','2026-01-12 19:19:36'),
(7692,3,3,1,'Wall-January2026Calendar.pdf','application/pdf','pdf',NULL,NULL,NULL,3143175,NULL,NULL,NULL,'2026-01-12 19:19:48','2026-01-12 19:19:48','2026-01-12 19:19:48'),
(7700,2,2,1,'1351-Old-Freehold-Rd-07202023_011725-1.jpg','image/jpeg','image',NULL,5593,3413,1782261,NULL,NULL,NULL,'2026-01-12 19:48:07','2026-01-12 19:48:07','2026-01-12 19:48:07'),
(7707,2,2,1,'STS_016216-1.jpg','image/jpeg','image',NULL,6422,4480,7656086,'0.5026;0.4381',NULL,NULL,'2026-01-12 19:52:47','2026-01-12 19:52:48','2026-01-12 19:53:46'),
(7722,2,2,1,'sts_0190-sts_019420.jpg','image/jpeg','image',NULL,6720,4480,16591314,NULL,NULL,NULL,'2026-01-12 19:57:31','2026-01-12 19:57:31','2026-01-12 19:57:31'),
(7732,3,3,1,'Maple-Grove-January.pdf','application/pdf','pdf',NULL,NULL,NULL,1022253,NULL,NULL,NULL,'2026-01-12 20:13:44','2026-01-12 20:13:45','2026-01-12 20:13:45'),
(7739,2,2,1,'DSC09295-Edit.jpg','image/jpeg','image',NULL,6000,4000,9345151,NULL,NULL,NULL,'2026-01-12 20:51:48','2026-01-12 20:51:48','2026-01-12 20:51:48'),
(7740,2,2,1,'DSC09301-Edit.jpg','image/jpeg','image',NULL,6000,4000,8975231,NULL,NULL,NULL,'2026-01-12 20:51:52','2026-01-12 20:51:52','2026-01-12 20:51:52'),
(7741,2,2,1,'DSC09284-Edit-1.jpg','image/jpeg','image',NULL,5308,4000,8687353,NULL,NULL,NULL,'2026-01-12 20:52:33','2026-01-12 20:52:34','2026-01-12 20:52:34'),
(7772,2,2,1,'LARGE-RES_03.jpg','image/jpeg','image',NULL,4935,3349,1579264,NULL,NULL,NULL,'2026-01-13 16:00:18','2026-01-13 16:00:18','2026-01-13 16:00:18'),
(7778,2,2,1,'DSC00072-HDR.jpg','image/jpeg','image',NULL,5970,3980,9606325,NULL,NULL,NULL,'2026-01-13 16:07:41','2026-01-13 16:07:41','2026-01-13 16:07:41'),
(7779,2,2,1,'DSC00088-Edit.jpg','image/jpeg','image',NULL,5893,3929,7717830,NULL,NULL,NULL,'2026-01-13 16:07:44','2026-01-13 16:07:44','2026-01-13 16:07:44'),
(7780,2,2,1,'DSC00092.jpg','image/jpeg','image',NULL,6000,4000,9469630,NULL,NULL,NULL,'2026-01-13 16:07:48','2026-01-13 16:07:48','2026-01-13 16:07:48'),
(7781,2,2,1,'DSC00163-Edit.jpg','image/jpeg','image',NULL,6000,4000,8137789,NULL,NULL,NULL,'2026-01-13 16:07:51','2026-01-13 16:07:51','2026-01-13 16:07:51'),
(7782,2,2,1,'DSC00168-Edit.jpg','image/jpeg','image',NULL,6000,4000,8765863,NULL,NULL,NULL,'2026-01-13 16:07:55','2026-01-13 16:07:56','2026-01-13 16:07:56'),
(7783,2,2,1,'DSC00171-Edit.jpg','image/jpeg','image',NULL,6000,4000,6117596,NULL,NULL,NULL,'2026-01-13 16:07:58','2026-01-13 16:07:58','2026-01-13 16:07:58'),
(7784,2,2,1,'DSC00264-Edit.jpg','image/jpeg','image',NULL,6000,4000,6940371,NULL,NULL,NULL,'2026-01-13 16:08:02','2026-01-13 16:08:02','2026-01-13 16:08:02'),
(7785,2,2,1,'DSC00297-Edit.jpg','image/jpeg','image',NULL,6000,4000,7574082,NULL,NULL,NULL,'2026-01-13 16:08:05','2026-01-13 16:08:05','2026-01-13 16:08:05'),
(7791,2,2,1,'Green-Acres-Lobby.jpg','image/jpeg','image',NULL,5869,4016,6703721,'0.5328;0.4407',NULL,NULL,'2026-01-13 16:11:20','2026-01-13 16:11:20','2026-01-13 16:11:40'),
(7818,7,9,1,'Residential-Care.png','image/png','image',NULL,1800,1800,93895,NULL,NULL,NULL,'2026-01-13 19:03:11','2026-01-13 19:03:11','2026-01-13 19:03:11'),
(7826,2,2,1,'Green-Acres-Dining.jpg','image/jpeg','image',NULL,5713,4016,6211491,NULL,NULL,NULL,'2026-01-13 20:01:47','2026-01-13 20:01:47','2026-01-13 20:01:47'),
(7827,2,2,1,'Green-Acres-Gym-2.jpg','image/jpeg','image',NULL,6016,4016,15965949,NULL,NULL,NULL,'2026-01-13 20:01:53','2026-01-13 20:01:53','2026-01-13 20:01:53'),
(7828,2,2,1,'Green-Acres-Gym.jpg','image/jpeg','image',NULL,5880,4016,6211677,NULL,NULL,NULL,'2026-01-13 20:01:55','2026-01-13 20:01:55','2026-01-13 20:01:55'),
(7829,2,2,1,'Green-Acres-Lobby-2.jpg','image/jpeg','image',NULL,5712,4016,7621604,NULL,NULL,NULL,'2026-01-13 20:01:59','2026-01-13 20:01:59','2026-01-13 20:01:59'),
(7830,2,2,1,'Green-Acres-Common-Room.jpg','image/jpeg','image',NULL,6016,4016,13369720,NULL,NULL,NULL,'2026-01-13 20:02:33','2026-01-13 20:02:34','2026-01-13 20:02:34'),
(7831,2,2,1,'Green-Acres-Double-Room.jpg','image/jpeg','image',NULL,5674,4002,12276857,NULL,NULL,NULL,'2026-01-13 20:02:37','2026-01-13 20:02:37','2026-01-13 20:02:37'),
(7832,2,2,1,'Green-Acres-Hall.jpg','image/jpeg','image',NULL,6016,4016,9088892,NULL,NULL,NULL,'2026-01-13 20:02:41','2026-01-13 20:02:41','2026-01-13 20:02:41'),
(7833,2,2,1,'Green-Acres-Room-Remodeled.jpg','image/jpeg','image',NULL,6016,4016,14224511,NULL,NULL,NULL,'2026-01-13 20:02:46','2026-01-13 20:02:47','2026-01-13 20:02:47'),
(7838,2,2,1,'Holiday-City-Exterior.jpg','image/jpeg','image',NULL,5008,3336,13163803,NULL,NULL,NULL,'2026-01-13 20:09:11','2026-01-13 20:09:12','2026-01-13 20:09:12'),
(7839,2,2,1,'Holiday-City-Hallway.jpg','image/jpeg','image',NULL,6016,4016,9803124,NULL,NULL,NULL,'2026-01-13 20:09:17','2026-01-13 20:09:17','2026-01-13 20:09:17'),
(7840,2,2,1,'Holiday-City-Room.jpg','image/jpeg','image',NULL,6016,4016,13546420,NULL,NULL,NULL,'2026-01-13 20:09:21','2026-01-13 20:09:21','2026-01-13 20:09:21'),
(7841,2,2,1,'Holiday-City-Rehab-Bed.jpg','image/jpeg','image',NULL,6614,4487,6798631,NULL,NULL,NULL,'2026-01-13 20:12:36','2026-01-13 20:12:36','2026-01-13 20:12:36'),
(7842,2,2,1,'Holiday-City-Rehab-Gym.jpg','image/jpeg','image',NULL,6468,4480,7097856,NULL,NULL,NULL,'2026-01-13 20:12:39','2026-01-13 20:12:39','2026-01-13 20:12:39'),
(7847,2,2,1,'Kresson-Common-Area.jpg','image/jpeg','image',NULL,6000,4000,10623706,'0.3839;0.5568',NULL,NULL,'2026-01-13 20:21:37','2026-01-13 20:21:37','2026-01-13 20:21:57'),
(7850,2,2,1,'Kresson-Common-Area_2026-01-13-202245_qpnh.jpg','image/jpeg','image',NULL,6000,4000,10623706,NULL,NULL,NULL,'2026-01-13 20:22:46','2026-01-13 20:22:46','2026-01-13 20:22:46'),
(7851,2,2,1,'Kresson-Common-Room.jpg','image/jpeg','image',NULL,6000,4000,6260184,NULL,NULL,NULL,'2026-01-13 20:22:49','2026-01-13 20:22:49','2026-01-13 20:22:49'),
(7852,2,2,1,'Kresson-Rehab-Gym.jpg','image/jpeg','image',NULL,6000,4000,7613670,NULL,NULL,NULL,'2026-01-13 20:22:52','2026-01-13 20:22:52','2026-01-13 20:22:52'),
(7853,2,2,1,'Kresson-Room.jpg','image/jpeg','image',NULL,6000,4000,11920658,NULL,NULL,NULL,'2026-01-13 20:22:57','2026-01-13 20:22:58','2026-01-13 20:22:58'),
(7858,2,2,1,'Laurelton-Bedroom.jpg','image/jpeg','image',NULL,5975,3989,10006395,NULL,NULL,NULL,'2026-01-13 20:38:44','2026-01-13 20:38:44','2026-01-13 20:38:44'),
(7859,2,2,1,'Laurelton-Dining-Room.jpg','image/jpeg','image',NULL,5921,3953,14511241,NULL,NULL,NULL,'2026-01-13 20:38:51','2026-01-13 20:38:51','2026-01-13 20:38:51'),
(7860,2,2,1,'Laurelton-Hall.jpg','image/jpeg','image',NULL,6016,4016,10733051,NULL,NULL,NULL,'2026-01-13 20:38:55','2026-01-13 20:38:55','2026-01-13 20:38:55'),
(7861,2,2,1,'Laurelton-Kitchen.jpg','image/jpeg','image',NULL,6016,4016,13937790,NULL,NULL,NULL,'2026-01-13 20:39:02','2026-01-13 20:39:02','2026-01-13 20:39:02'),
(7862,2,2,1,'Laurelton-Lobby_2026-01-13-203906_iztr.jpg','image/jpeg','image',NULL,6016,4016,10038581,'0.4924;0.4306',NULL,NULL,'2026-01-13 20:39:07','2026-01-13 20:39:08','2026-01-13 20:42:41'),
(7863,2,2,1,'Laurelton-Rehab-Gym.jpg','image/jpeg','image',NULL,6016,4016,9073768,NULL,NULL,NULL,'2026-01-13 20:39:11','2026-01-13 20:39:11','2026-01-13 20:39:11'),
(7864,2,2,1,'Laurelton-resident-room2-Treiger.jpg','image/jpeg','image',NULL,6720,4480,14180957,NULL,NULL,NULL,'2026-01-13 20:41:16','2026-01-13 20:41:16','2026-01-13 20:41:16'),
(7868,2,2,1,'Marcella-Activity-Room.jpg','image/jpeg','image',NULL,6000,4000,14445691,NULL,NULL,NULL,'2026-01-13 20:48:49','2026-01-13 20:48:50','2026-01-13 20:48:50'),
(7869,2,2,1,'Marcella-Bedroom.jpg','image/jpeg','image',NULL,6000,4000,9653527,NULL,NULL,NULL,'2026-01-13 20:48:54','2026-01-13 20:48:54','2026-01-13 20:48:54'),
(7870,2,2,1,'Marcella-Exterior-2.jpg','image/jpeg','image',NULL,7825,5869,12211446,NULL,NULL,NULL,'2026-01-13 20:48:58','2026-01-13 20:48:58','2026-01-13 20:48:58'),
(7871,2,2,1,'Marcella-Exterior.jpg','image/jpeg','image',NULL,6000,4000,10699950,NULL,NULL,NULL,'2026-01-13 20:49:04','2026-01-13 20:49:04','2026-01-13 20:49:04'),
(7872,2,2,1,'Marcella-Gazebo.jpg','image/jpeg','image',NULL,5731,3897,7480499,NULL,NULL,NULL,'2026-01-13 20:49:07','2026-01-13 20:49:07','2026-01-13 20:49:07'),
(7873,2,2,1,'Marcella-Hallway.jpg','image/jpeg','image',NULL,6000,4000,14930154,NULL,NULL,NULL,'2026-01-13 20:49:14','2026-01-13 20:49:14','2026-01-13 20:49:14'),
(7874,2,2,1,'Marcella-Rehab-Gym.jpg','image/jpeg','image',NULL,6000,4000,12838470,NULL,NULL,NULL,'2026-01-13 20:49:19','2026-01-13 20:49:19','2026-01-13 20:49:19'),
(7881,2,2,1,'Monmouth-Lobby.jpg','image/jpeg','image',NULL,5007,3340,3195440,'0.4242;0.4937',NULL,NULL,'2026-01-13 21:02:23','2026-01-13 21:02:23','2026-01-13 21:03:08'),
(7882,2,2,1,'Monmouth-Dining.jpg','image/jpeg','image',NULL,5003,3335,3519221,NULL,NULL,NULL,'2026-01-13 21:03:25','2026-01-13 21:03:25','2026-01-13 21:03:25'),
(7883,2,2,1,'Monmouth-Lobby-2.jpg','image/jpeg','image',NULL,5224,3521,4310831,NULL,NULL,NULL,'2026-01-13 21:03:27','2026-01-13 21:03:28','2026-01-13 21:03:28'),
(7884,2,2,1,'Monmouth-Rehab-Gym.jpg','image/jpeg','image',NULL,5005,3335,3783243,NULL,NULL,NULL,'2026-01-13 21:03:30','2026-01-13 21:03:30','2026-01-13 21:03:30'),
(7885,2,2,1,'Monmouth-Room-Storage.jpg','image/jpeg','image',NULL,6720,4480,6225780,NULL,NULL,NULL,'2026-01-13 21:03:33','2026-01-13 21:03:33','2026-01-13 21:03:33'),
(7886,2,2,1,'Monmouth-Room.jpg','image/jpeg','image',NULL,6720,4480,6390369,NULL,NULL,NULL,'2026-01-13 21:03:38','2026-01-13 21:03:38','2026-01-13 21:03:38'),
(7891,2,2,1,'Ocean-Grove-Exterior.jpg','image/jpeg','image',NULL,6236,4480,8538422,'0.3150;0.4407',NULL,NULL,'2026-01-13 21:13:28','2026-01-13 21:13:28','2026-01-13 21:15:53'),
(7892,2,2,1,'Ocean-Grove-Bedroom.jpg','image/jpeg','image',NULL,6720,4480,11877165,NULL,NULL,NULL,'2026-01-13 21:14:14','2026-01-13 21:14:15','2026-01-13 21:14:15'),
(7893,2,2,1,'Ocean-Grove-Dining.jpg','image/jpeg','image',NULL,6720,4480,13080930,NULL,NULL,NULL,'2026-01-13 21:14:19','2026-01-13 21:14:19','2026-01-13 21:14:19'),
(7894,2,2,1,'Ocean-Grove-Rehab-Gym.jpg','image/jpeg','image',NULL,6723,4481,16169620,NULL,NULL,NULL,'2026-01-13 21:14:26','2026-01-13 21:14:26','2026-01-13 21:14:26'),
(7901,2,2,1,'Ocean-Grove-Lobby.jpg','image/jpeg','image',NULL,6720,4480,15491192,NULL,NULL,NULL,'2026-01-13 21:17:22','2026-01-13 21:17:23','2026-01-13 21:17:23'),
(7908,2,2,1,'ShorrockGardens_Lobby_2026-01-13-212308_rkus.jpg','image/jpeg','image',NULL,6720,4480,17301770,NULL,NULL,NULL,'2026-01-13 21:23:08','2026-01-13 21:23:09','2026-01-13 21:23:09'),
(7909,2,2,1,'ShorrockGardens_RehabGym.jpg','image/jpeg','image',NULL,6720,4481,16498452,NULL,NULL,NULL,'2026-01-13 21:23:16','2026-01-13 21:23:17','2026-01-13 21:23:17'),
(7910,2,2,1,'ShorrockGardens_Room.jpg','image/jpeg','image',NULL,6720,4480,15331623,'0.5000;0.5859',NULL,NULL,'2026-01-13 21:23:26','2026-01-13 21:23:26','2026-01-13 21:25:45'),
(7911,2,2,1,'ShorrockGardens_Room2.jpg','image/jpeg','image',NULL,6723,4484,15332942,'0.5000;0.5328',NULL,NULL,'2026-01-13 21:23:33','2026-01-13 21:23:34','2026-01-13 21:26:21'),
(7920,2,2,1,'Shrewsbury-Rehab-Gym.jpg','image/jpeg','image',NULL,6720,4480,16051863,NULL,NULL,NULL,'2026-01-13 21:33:19','2026-01-13 21:33:19','2026-01-13 21:33:19'),
(7921,2,2,1,'Shrewsbury-Room-2.jpg','image/jpeg','image',NULL,6720,4480,13134677,NULL,NULL,NULL,'2026-01-13 21:33:24','2026-01-13 21:33:25','2026-01-13 21:33:25'),
(7922,2,2,1,'Shrewsbury-Room.jpg','image/jpeg','image',NULL,6720,4480,13124097,NULL,NULL,NULL,'2026-01-13 21:33:29','2026-01-13 21:33:30','2026-01-13 21:33:30'),
(7923,2,2,1,'Shrewsbury-Dining.jpg','image/jpeg','image',NULL,6607,4480,6014603,NULL,NULL,NULL,'2026-01-13 21:33:58','2026-01-13 21:33:58','2026-01-13 21:33:58'),
(7924,2,2,1,'Oasis-Common-Room.jpg','image/jpeg','image',NULL,6720,4480,16616096,NULL,NULL,NULL,'2026-01-13 21:37:48','2026-01-13 21:37:49','2026-01-13 21:37:49'),
(7925,2,2,1,'Oasis-Dining.jpg','image/jpeg','image',NULL,6720,4480,16312581,NULL,NULL,NULL,'2026-01-13 21:38:00','2026-01-13 21:38:00','2026-01-13 21:38:00'),
(7926,2,2,1,'Oasis-Lobby_2026-01-13-213805_ryjc.jpg','image/jpeg','image',NULL,6720,4480,14965855,NULL,NULL,NULL,'2026-01-13 21:38:06','2026-01-13 21:38:06','2026-01-13 21:38:06'),
(7927,2,2,1,'Oasis-Room.jpg','image/jpeg','image',NULL,6720,4480,14559229,NULL,NULL,NULL,'2026-01-13 21:38:15','2026-01-13 21:38:15','2026-01-13 21:38:15'),
(7928,2,2,1,'Oasis-Station.jpg','image/jpeg','image',NULL,6720,4480,17082593,NULL,NULL,NULL,'2026-01-13 21:38:21','2026-01-13 21:38:21','2026-01-13 21:38:21'),
(7937,2,2,1,'Victoria-Commons-Exterior.jpg','image/jpeg','image',NULL,6000,4000,12147029,'0.5480;0.3560',NULL,NULL,'2026-01-13 21:56:53','2026-01-13 21:56:53','2026-01-13 21:58:42'),
(7938,2,2,1,'Victoria-Commons-Common-Room.jpg','image/jpeg','image',NULL,6000,4000,8339887,NULL,NULL,NULL,'2026-01-13 21:57:12','2026-01-13 21:57:13','2026-01-13 21:57:13'),
(7939,2,2,1,'Victoria-Commons-Dining.jpg','image/jpeg','image',NULL,6000,4000,9041481,NULL,NULL,NULL,'2026-01-13 21:57:16','2026-01-13 21:57:16','2026-01-13 21:57:16'),
(7940,2,2,1,'Victoria-Commons-Hallway.jpg','image/jpeg','image',NULL,6000,4000,8851715,NULL,NULL,NULL,'2026-01-13 21:57:19','2026-01-13 21:57:19','2026-01-13 21:57:19'),
(7941,2,2,1,'Victoria-Commons-Social-Room.jpg','image/jpeg','image',NULL,6000,4000,12864997,NULL,NULL,NULL,'2026-01-13 21:57:26','2026-01-13 21:57:26','2026-01-13 21:57:26'),
(7950,2,2,1,'Voorhees-Courtyard.jpg','image/jpeg','image',NULL,6000,4000,3354213,NULL,NULL,NULL,'2026-01-13 22:04:24','2026-01-13 22:04:24','2026-01-13 22:04:24'),
(7951,2,2,1,'Voorhees-Dining.jpg','image/jpeg','image',NULL,5893,3929,881128,NULL,NULL,NULL,'2026-01-13 22:04:26','2026-01-13 22:04:26','2026-01-13 22:04:26'),
(7952,2,2,1,'Voorhees-Exterior.jpg','image/jpeg','image',NULL,7045,5284,7411808,NULL,NULL,NULL,'2026-01-13 22:04:32','2026-01-13 22:04:32','2026-01-13 22:04:32'),
(7953,2,2,1,'Voorhees-Hallway.jpg','image/jpeg','image',NULL,5847,3898,781969,NULL,NULL,NULL,'2026-01-13 22:04:33','2026-01-13 22:04:33','2026-01-13 22:04:33'),
(7954,2,2,1,'Voorhees-Rehab-Gym.jpg','image/jpeg','image',NULL,6000,4000,1111252,NULL,NULL,NULL,'2026-01-13 22:04:34','2026-01-13 22:04:35','2026-01-13 22:04:35'),
(7955,2,2,1,'Voorhees-Room-2.jpg','image/jpeg','image',NULL,6000,4000,792075,NULL,NULL,NULL,'2026-01-13 22:04:37','2026-01-13 22:04:37','2026-01-13 22:04:37'),
(7956,2,2,1,'Voorhees-Room.jpg','image/jpeg','image',NULL,6000,4000,844817,NULL,NULL,NULL,'2026-01-13 22:04:39','2026-01-13 22:04:39','2026-01-13 22:04:39'),
(7957,2,2,1,'Voorhees-Seating-Area.jpg','image/jpeg','image',NULL,5608,3739,1414950,NULL,NULL,NULL,'2026-01-13 22:04:40','2026-01-13 22:04:40','2026-01-13 22:04:40'),
(7998,2,2,1,'Bayshore-Entrance.jpg','image/jpeg','image',NULL,6720,4480,7792876,'0.4470;0.4659',NULL,NULL,'2026-01-14 16:21:15','2026-01-14 16:21:15','2026-01-14 16:21:57'),
(8017,2,2,1,'LARGE-RES_14.jpg','image/jpeg','image',NULL,4834,3359,986155,'0.5192;0.5274',NULL,NULL,'2026-01-14 16:27:54','2026-01-14 16:27:18','2026-01-14 16:28:27'),
(8024,2,2,1,'Cedar-Grove-Hall.jpg','image/jpeg','image',NULL,5040,3360,7061093,NULL,NULL,NULL,'2026-01-14 16:31:30','2026-01-14 16:31:30','2026-01-14 16:31:30'),
(8025,2,2,1,'Cedar-Grove-Lobby-2.jpg','image/jpeg','image',NULL,5044,3363,6020486,NULL,NULL,NULL,'2026-01-14 16:31:33','2026-01-14 16:31:33','2026-01-14 16:31:33'),
(8026,2,2,1,'Cedar-Grove-Rehab-Gym-2.jpg','image/jpeg','image',NULL,6720,4480,17104554,NULL,NULL,NULL,'2026-01-14 16:31:58','2026-01-14 16:31:59','2026-01-14 16:31:59'),
(8027,2,2,1,'Cedar-Grove-Rehab-Gym.jpg','image/jpeg','image',NULL,6720,4480,15203574,NULL,NULL,NULL,'2026-01-14 16:32:07','2026-01-14 16:32:08','2026-01-14 16:32:08'),
(8032,2,2,1,'Clark-Bedroom.jpg','image/jpeg','image',NULL,6720,4480,14820895,NULL,NULL,NULL,'2026-01-14 16:37:09','2026-01-14 16:37:09','2026-01-14 16:37:09'),
(8033,2,2,1,'Clark-Dining.jpg','image/jpeg','image',NULL,6601,4480,6203853,NULL,NULL,NULL,'2026-01-14 16:37:14','2026-01-14 16:37:14','2026-01-14 16:37:14'),
(8034,2,2,1,'Clark-Lobby_2026-01-14-163722_hdsq.jpg','image/jpeg','image',NULL,6720,4480,15934433,'0.4369;0.4988',NULL,NULL,'2026-01-14 16:37:23','2026-01-14 16:37:23','2026-01-14 16:42:48'),
(8035,2,2,1,'Clark-Rehab-Gym.jpg','image/jpeg','image',NULL,6720,4480,15637183,'0.5000;0.5000',NULL,NULL,'2026-01-14 16:37:29','2026-01-14 16:37:29','2026-01-16 01:26:46'),
(8036,2,2,1,'Clark-Room-2.jpg','image/jpeg','image',NULL,6720,4480,15240157,NULL,NULL,NULL,'2026-01-14 16:37:35','2026-01-14 16:37:35','2026-01-14 16:37:35'),
(8051,2,2,1,'Green-Knoll-Hallway.jpg','image/jpeg','image',NULL,3360,5040,7732745,NULL,NULL,NULL,'2026-01-14 16:46:40','2026-01-14 16:46:40','2026-01-14 16:46:40'),
(8052,2,2,1,'Green-Knoll-Lobby-2.jpg','image/jpeg','image',NULL,5040,3360,6917070,NULL,NULL,NULL,'2026-01-14 16:46:43','2026-01-14 16:46:43','2026-01-14 16:46:43'),
(8053,2,2,1,'Green-Knoll-Rehab-Gym.jpg','image/jpeg','image',NULL,5044,3360,8367795,NULL,NULL,NULL,'2026-01-14 16:46:46','2026-01-14 16:46:47','2026-01-14 16:46:47'),
(8054,2,2,1,'Green-Knoll-Room.jpg','image/jpeg','image',NULL,5044,3373,8007726,NULL,NULL,NULL,'2026-01-14 16:46:50','2026-01-14 16:46:51','2026-01-14 16:46:51'),
(8060,2,2,1,'Holmdel-Bedroom-Amenities.jpg','image/jpeg','image',NULL,5040,3360,3970415,NULL,NULL,NULL,'2026-01-14 16:53:49','2026-01-14 16:53:49','2026-01-14 16:53:49'),
(8061,2,2,1,'Holmdel-Bedroom.jpg','image/jpeg','image',NULL,5040,3360,3961803,NULL,NULL,NULL,'2026-01-14 16:53:53','2026-01-14 16:53:54','2026-01-14 16:53:54'),
(8062,2,2,1,'Holmdel-Common-Area.jpg','image/jpeg','image',NULL,6720,4480,9132190,'0.4983;0.5290',NULL,NULL,'2026-01-14 16:53:57','2026-01-14 16:53:57','2026-01-14 16:56:02'),
(8063,2,2,1,'Holmdel-Kitchen.jpg','image/jpeg','image',NULL,4480,6720,6068647,NULL,NULL,NULL,'2026-01-14 16:54:00','2026-01-14 16:54:00','2026-01-14 16:54:00'),
(8064,2,2,1,'Holmdel-Porch.jpg','image/jpeg','image',NULL,6515,4483,8581705,'0.4948;0.5656',NULL,NULL,'2026-01-14 16:54:06','2026-01-14 16:54:06','2026-01-14 16:55:48'),
(8079,2,2,1,'Madison-Bedroom.jpg','image/jpeg','image',NULL,5047,3365,5972296,NULL,NULL,NULL,'2026-01-14 17:01:57','2026-01-14 17:01:57','2026-01-14 17:01:57'),
(8080,2,2,1,'Madison-Rehab-Gym.jpg','image/jpeg','image',NULL,6720,4480,15262450,NULL,NULL,NULL,'2026-01-14 17:02:06','2026-01-14 17:02:06','2026-01-14 17:02:06'),
(8081,2,2,1,'Madison-Lobby-Wide-1.jpg','image/jpeg','image',NULL,6601,4480,8300343,'0.3827;0.4773',NULL,NULL,'2026-01-14 17:02:54','2026-01-14 17:02:54','2026-01-14 17:04:12'),
(8082,2,2,1,'Madison-Lobby-Zoom-1.jpg','image/jpeg','image',NULL,6438,4437,8144157,NULL,NULL,NULL,'2026-01-14 17:03:40','2026-01-14 17:03:40','2026-01-14 17:03:40'),
(8085,2,2,1,'Madison-Bedroom-2.jpg','image/jpeg','image',NULL,5037,3358,6075444,NULL,NULL,NULL,'2026-01-14 17:04:47','2026-01-14 17:04:47','2026-01-14 17:04:47'),
(8086,2,2,1,'Madison-Rehab-Gym_2026-01-14-170453_pywe.jpg','image/jpeg','image',NULL,6720,4480,15262450,NULL,NULL,NULL,'2026-01-14 17:04:54','2026-01-14 17:04:54','2026-01-14 17:04:54'),
(8087,2,2,1,'Madison-Dialysis.jpg','image/jpeg','image',NULL,5040,3360,6057564,NULL,NULL,NULL,'2026-01-14 17:05:02','2026-01-14 17:05:02','2026-01-14 17:05:02'),
(8092,2,2,1,'Mercerville-Common-Area.jpg','image/jpeg','image',NULL,6720,4480,15322614,'0.5824;0.5492',NULL,NULL,'2026-01-14 17:11:28','2026-01-14 17:11:28','2026-01-14 17:15:33'),
(8093,2,2,1,'Mercerville-Double-Room.jpg','image/jpeg','image',NULL,6720,4480,14512710,NULL,NULL,NULL,'2026-01-14 17:11:34','2026-01-14 17:11:34','2026-01-14 17:11:34'),
(8094,2,2,1,'Mercerville-Lobby-2.jpg','image/jpeg','image',NULL,6631,4465,6612268,'0.4992;0.5316',NULL,NULL,'2026-01-14 17:11:37','2026-01-14 17:11:37','2026-01-14 17:15:44'),
(8095,2,2,1,'Mercerville-Rehab-Gym.jpg','image/jpeg','image',NULL,6746,4498,15590833,NULL,NULL,NULL,'2026-01-14 17:11:46','2026-01-14 17:11:46','2026-01-14 17:11:46'),
(8104,2,2,1,'Orange-Park-Lobby_2026-01-14-173649_reeh.jpg','image/jpeg','image',NULL,6170,4480,7367195,'0.5642;0.5202',NULL,NULL,'2026-01-14 17:36:50','2026-01-14 17:36:50','2026-01-14 17:40:29'),
(8105,2,2,1,'Orange-Park-Dining.jpg','image/jpeg','image',NULL,6581,4480,6486808,'0.5026;0.5871',NULL,NULL,'2026-01-14 17:39:25','2026-01-14 17:39:25','2026-01-14 17:41:28'),
(8106,2,2,1,'Orange-Park-Rehab-Gym.jpg','image/jpeg','image',NULL,5040,3360,8488152,NULL,NULL,NULL,'2026-01-14 17:39:28','2026-01-14 17:39:28','2026-01-14 17:39:28'),
(8107,2,2,1,'Orange-Park-Room.jpg','image/jpeg','image',NULL,5040,3360,7334835,'0.4924;0.5619',NULL,NULL,'2026-01-14 17:39:30','2026-01-14 17:39:30','2026-01-14 17:41:18'),
(8108,2,2,1,'Orange-Park-Hallway.jpg','image/jpeg','image',NULL,6424,4459,7943823,'0.4982;0.5404',NULL,NULL,'2026-01-14 17:40:07','2026-01-14 17:40:07','2026-01-14 17:41:53'),
(8117,2,2,1,'Park-Place-Bedroom.jpg','image/jpeg','image',NULL,6720,4480,16377382,'0.4975;0.5404',NULL,NULL,'2026-01-14 17:49:48','2026-01-14 17:49:49','2026-01-14 17:51:39'),
(8118,2,2,1,'Park-Place-Lounge.jpg','image/jpeg','image',NULL,6640,4480,6900460,'0.4455;0.5114',NULL,NULL,'2026-01-14 17:49:53','2026-01-14 17:49:54','2026-01-14 17:51:08'),
(8119,2,2,1,'Park-Place-Rehab-Gym-Full.jpg','image/jpeg','image',NULL,6654,4480,6159168,NULL,NULL,NULL,'2026-01-14 17:49:59','2026-01-14 17:50:00','2026-01-14 17:50:00'),
(8120,2,2,1,'Park-Place-Rehab-Gym.jpg','image/jpeg','image',NULL,6723,4487,15496297,NULL,NULL,NULL,'2026-01-14 17:50:07','2026-01-14 17:50:07','2026-01-14 17:50:07'),
(8131,2,2,1,'Plainfield-Bedroom.jpg','image/jpeg','image',NULL,6720,4480,14156576,'0.5025;0.5505',NULL,NULL,'2026-01-14 18:29:12','2026-01-14 18:29:12','2026-01-14 18:53:27'),
(8132,2,2,1,'Plainfield-Common-Area-2.jpg','image/jpeg','image',NULL,6720,4480,16014889,NULL,NULL,NULL,'2026-01-14 18:29:18','2026-01-14 18:29:18','2026-01-14 18:29:18'),
(8133,2,2,1,'Plainfield-Common-Area.jpg','image/jpeg','image',NULL,6720,4480,16215804,NULL,NULL,NULL,'2026-01-14 18:29:24','2026-01-14 18:29:24','2026-01-14 18:29:24'),
(8134,2,2,1,'Plainfield-Dining.jpg','image/jpeg','image',NULL,6660,4480,5706541,NULL,NULL,NULL,'2026-01-14 18:29:27','2026-01-14 18:29:27','2026-01-14 18:29:27'),
(8135,2,2,1,'Plainfield-Hallway.jpg','image/jpeg','image',NULL,4480,6720,17634938,NULL,NULL,NULL,'2026-01-14 18:29:39','2026-01-14 18:29:39','2026-01-14 18:29:39'),
(8136,2,2,1,'Plainfield-Lobby-2.jpg','image/jpeg','image',NULL,6871,4667,13603174,NULL,NULL,NULL,'2026-01-14 18:29:48','2026-01-14 18:29:48','2026-01-14 18:29:48'),
(8141,2,2,1,'St-Vincent-Courtyard.jpeg','image/jpeg','image',NULL,5333,4000,12643642,'0.5009;0.5606',NULL,NULL,'2026-01-14 19:05:51','2026-01-14 19:05:51','2026-01-14 19:07:05'),
(8142,2,2,1,'St-Vincents-Church.jpeg','image/jpeg','image',NULL,5333,4000,6368183,NULL,NULL,NULL,'2026-01-14 19:05:54','2026-01-14 19:05:54','2026-01-14 19:05:54'),
(8153,2,2,1,'Summit-Ridge-Lobby_2026-01-14-191330_kuav.jpg','image/jpeg','image',NULL,5007,3338,8639535,NULL,0,0,'2026-01-14 19:13:30','2026-01-14 19:13:31','2026-01-14 19:13:31'),
(8162,2,2,1,'Summit-Ridge-Common-Area.jpg','image/jpeg','image',NULL,5011,3341,7074248,NULL,NULL,NULL,'2026-01-14 19:20:50','2026-01-14 19:20:50','2026-01-14 19:20:50'),
(8163,2,2,1,'Summit-Ridge-Hallway.jpg','image/jpeg','image',NULL,5040,3360,6753360,NULL,NULL,NULL,'2026-01-14 19:20:53','2026-01-14 19:20:53','2026-01-14 19:20:53'),
(8164,2,2,1,'Summit-Ridge-Room.jpg','image/jpeg','image',NULL,5049,4480,4101381,'0.4978;0.6213',NULL,NULL,'2026-01-14 19:20:55','2026-01-14 19:20:55','2026-01-14 19:23:34'),
(8165,2,2,1,'Summit-Ridge-Rehab-Gym.jpg','image/jpeg','image',NULL,6680,4480,6169518,NULL,NULL,NULL,'2026-01-14 19:22:01','2026-01-14 19:22:01','2026-01-14 19:22:01'),
(8174,2,2,1,'West-Caldwell-Rehab-Gym.jpg','image/jpeg','image',NULL,6660,4480,7290220,'0.5085;0.5757',NULL,NULL,'2026-01-14 19:27:24','2026-01-14 19:27:24','2026-01-14 19:32:31'),
(8175,2,2,1,'West-Caldwell-Room-2.jpg','image/jpeg','image',NULL,6720,4480,16915460,'0.4924;0.5556',NULL,NULL,'2026-01-14 19:28:38','2026-01-14 19:28:38','2026-01-14 19:32:07'),
(8176,2,2,1,'West-Caldwell-Room.jpg','image/jpeg','image',NULL,6655,4488,6234802,'0.5962;0.4987',NULL,NULL,'2026-01-14 19:28:41','2026-01-14 19:28:41','2026-01-14 19:31:47'),
(8177,2,2,1,'West-Caldwell-Lobby_2026-01-14-192910_gtco.jpg','image/jpeg','image',NULL,6640,4480,7428519,'0.4446;0.5341',NULL,NULL,'2026-01-14 19:29:11','2026-01-14 19:29:11','2026-01-14 19:32:48'),
(8178,2,2,1,'West-Caldwell-Lobby_2026-01-14-192929_slyo.jpg','image/jpeg','image',NULL,6640,4480,7428519,'0.4310;0.5303',NULL,NULL,'2026-01-14 19:29:29','2026-01-14 19:29:30','2026-01-14 19:33:04'),
(8194,2,2,1,'West-Caldwell-Room_2026-01-14-193430_epnv.jpg','image/jpeg','image',NULL,6609,4488,6256289,NULL,NULL,NULL,'2026-01-14 19:34:31','2026-01-14 19:34:31','2026-01-14 19:34:31'),
(8208,2,2,1,'Whispering-Woods-Lobby.jpg','image/jpeg','image',NULL,6725,4481,6480047,NULL,NULL,NULL,'2026-01-14 20:02:54','2026-01-14 20:02:54','2026-01-14 20:02:54'),
(8211,2,2,1,'Whispering-Woods-Apartment-Room.jpg','image/jpeg','image',NULL,6727,4487,6430020,'0.5042;0.6199',NULL,NULL,'2026-01-14 20:03:40','2026-01-14 20:03:40','2026-01-14 20:05:29'),
(8212,2,2,1,'Whispering-Woods-Bed-2.jpg','image/jpeg','image',NULL,6720,4480,16017705,'0.4966;0.6528',NULL,NULL,'2026-01-14 20:03:45','2026-01-14 20:03:46','2026-01-14 20:06:24'),
(8213,2,2,1,'Whispering-Woods-Bed.jpg','image/jpeg','image',NULL,6707,4452,5355958,'0.4899;0.6112',NULL,NULL,'2026-01-14 20:03:49','2026-01-14 20:03:49','2026-01-14 20:05:56'),
(8214,2,2,1,'Whispering-Woods-Bedroom.jpg','image/jpeg','image',NULL,6720,4480,5699370,'0.5025;0.5783',NULL,NULL,'2026-01-14 20:03:53','2026-01-14 20:03:53','2026-01-14 20:05:40'),
(8215,2,2,1,'Whispering-Woods-Dining.jpg','image/jpeg','image',NULL,6720,4480,8479753,'0.5160;0.5871',NULL,NULL,'2026-01-14 20:03:57','2026-01-14 20:03:57','2026-01-14 20:06:38'),
(8216,2,2,1,'Whispering-Woods-Exterior-Zoom.jpg','image/jpeg','image',NULL,6724,4483,11407484,NULL,NULL,NULL,'2026-01-14 20:04:02','2026-01-14 20:04:02','2026-01-14 20:04:02'),
(8217,2,2,1,'Whispering-Woods-Exterior.jpg','image/jpeg','image',NULL,6720,4480,14691804,'0.4882;0.4811',NULL,NULL,'2026-01-14 20:04:10','2026-01-14 20:04:10','2026-01-14 20:07:08'),
(8218,2,2,1,'Whispering-Woods-Lobby_2026-01-14-200411_qqgo.jpg','image/jpeg','image',NULL,6725,4481,6480047,'0.4731;0.5480',NULL,NULL,'2026-01-14 20:04:13','2026-01-14 20:04:13','2026-01-14 20:06:55'),
(8227,2,2,1,'Woodlands_Lobby2.jpg','image/jpeg','image',NULL,5045,3363,10128662,'0.4546;0.5366',NULL,NULL,'2026-01-14 20:10:45','2026-01-14 20:10:45','2026-01-14 20:13:50'),
(8600,2,2,1,'Hyattesville-Dining-06.JPG','image/jpeg','image',NULL,3600,2400,2444220,NULL,NULL,NULL,'2026-01-16 01:13:04','2026-01-16 01:13:04','2026-01-16 01:13:04'),
(8601,2,2,1,'Hyattesville-Exterior-02.JPG','image/jpeg','image',NULL,3600,2400,3753178,NULL,NULL,NULL,'2026-01-16 01:13:06','2026-01-16 01:13:06','2026-01-16 01:13:06'),
(8602,2,2,1,'Hyattesville-Rehab-09.JPG','image/jpeg','image',NULL,3600,2400,1841736,NULL,NULL,NULL,'2026-01-16 01:13:07','2026-01-16 01:13:07','2026-01-16 01:13:07'),
(8603,2,2,1,'Hyattesville-Renal-Care-01.JPG','image/jpeg','image',NULL,3600,2400,1614898,NULL,NULL,NULL,'2026-01-16 01:13:08','2026-01-16 01:13:08','2026-01-16 01:13:08'),
(8604,2,2,1,'Hyattesville-Rooms-10.JPG','image/jpeg','image',NULL,3600,2400,1840210,NULL,NULL,NULL,'2026-01-16 01:13:09','2026-01-16 01:13:09','2026-01-16 01:13:09'),
(8605,2,2,1,'Hyattesville-Rooms-11.JPG','image/jpeg','image',NULL,3600,2400,1948092,NULL,NULL,NULL,'2026-01-16 01:13:10','2026-01-16 01:13:10','2026-01-16 01:13:10'),
(8623,4,4,1,'BeyLea-AD.jpg','image/jpeg','image',NULL,1080,1080,301517,NULL,NULL,NULL,'2026-01-16 12:33:51','2026-01-16 12:33:51','2026-01-16 12:33:51'),
(8676,2,2,1,'Chestnut-Dining-Room.jpg','image/jpeg','image',NULL,6950,4772,520946,NULL,NULL,NULL,'2026-01-16 16:13:56','2026-01-16 16:13:56','2026-01-16 16:13:56'),
(8677,2,2,1,'Chestnut-Res-Lobby-1.jpg','image/jpeg','image',NULL,7000,4738,521030,NULL,NULL,NULL,'2026-01-16 16:14:00','2026-01-16 16:14:00','2026-01-16 16:14:00'),
(8704,4,4,1,'ChestnutRes-AD.jpg','image/jpeg','image',NULL,1080,1080,82255,NULL,NULL,NULL,'2026-01-16 16:37:39','2026-01-16 16:37:39','2026-01-16 16:37:39'),
(8733,4,4,1,'Berkshire-AD.jpg','image/jpeg','image',NULL,1080,1080,136456,NULL,NULL,NULL,'2026-01-16 20:44:33','2026-01-16 20:44:33','2026-01-16 20:44:33'),
(8740,2,2,1,'BrakeleyPark_Lobby2_2026-01-16-204735_pkfu.jpg','image/jpeg','image',NULL,6606,4482,6006040,NULL,NULL,NULL,'2026-01-16 20:47:36','2026-01-16 20:47:36','2026-01-16 20:47:36'),
(8744,2,2,1,'ChestnutHill_RehabGym2.jpg','image/jpeg','image',NULL,6720,4480,16859905,NULL,NULL,NULL,'2026-01-16 20:50:40','2026-01-16 20:50:41','2026-01-16 20:50:41'),
(8745,2,2,1,'ChestnutHill_RehabGym3.jpg','image/jpeg','image',NULL,6720,4480,16029596,NULL,NULL,NULL,'2026-01-16 20:50:52','2026-01-16 20:50:53','2026-01-16 20:50:53'),
(8746,2,2,1,'ChestnutHill_Room2.jpg','image/jpeg','image',NULL,6720,4480,16938153,'0.5000;0.6354',NULL,NULL,'2026-01-16 20:51:05','2026-01-16 20:51:05','2026-01-16 20:58:05'),
(8747,2,2,1,'ChestnutHill_Lobby.jpg','image/jpeg','image',NULL,6572,4480,5460528,NULL,NULL,NULL,'2026-01-16 20:55:25','2026-01-16 20:55:25','2026-01-16 20:55:25'),
(8748,2,2,1,'ChestnutHill_Lobby4.jpg','image/jpeg','image',NULL,6611,4480,5735708,NULL,NULL,NULL,'2026-01-16 20:55:31','2026-01-16 20:55:31','2026-01-16 20:55:31'),
(8749,2,2,1,'ChestnutHill_RehabGym.jpg','image/jpeg','image',NULL,6644,4480,6226661,NULL,NULL,NULL,'2026-01-16 20:55:37','2026-01-16 20:55:37','2026-01-16 20:55:37'),
(8750,2,2,1,'ChestnutHill_Room.jpg','image/jpeg','image',NULL,6564,4480,5786154,'0.4870;0.5624',NULL,NULL,'2026-01-16 20:55:43','2026-01-16 20:55:43','2026-01-16 20:57:41'),
(8751,2,2,1,'ChestnutHill_Room_Seating.jpg','image/jpeg','image',NULL,6496,4480,6075702,'0.5120;0.6475',NULL,NULL,'2026-01-16 20:55:49','2026-01-16 20:55:49','2026-01-16 20:57:54'),
(8752,2,2,1,'ChestnutHill_Room2_2026-01-16-205601_ddqz.jpg','image/jpeg','image',NULL,6720,4480,16938153,NULL,NULL,NULL,'2026-01-16 20:56:01','2026-01-16 20:56:02','2026-01-16 20:56:02'),
(8753,2,2,1,'ChestnutHill_Room3.jpg','image/jpeg','image',NULL,6619,4480,5981130,'0.5035;0.5850',NULL,NULL,'2026-01-16 20:56:07','2026-01-16 20:56:07','2026-01-16 20:58:14'),
(8754,2,2,1,'ChestnutHill_Room4.jpg','image/jpeg','image',NULL,6642,4480,6208576,'0.4941;0.6250',NULL,NULL,'2026-01-16 20:56:13','2026-01-16 20:56:13','2026-01-16 20:58:23'),
(8759,4,4,1,'ChestnutRes-AD_2026-01-16-205903_jjyk.jpg','image/jpeg','image',NULL,1080,1080,82255,NULL,NULL,NULL,'2026-01-16 20:59:03','2026-01-16 20:59:03','2026-01-16 20:59:03'),
(8764,4,4,1,'ChestnutRes-Admin.jpg','image/jpeg','image',NULL,1080,1080,82621,NULL,NULL,NULL,'2026-01-16 21:29:52','2026-01-16 21:29:52','2026-01-16 21:29:52'),
(8769,4,4,1,'Chestnut-Admin.jpg','image/jpeg','image',NULL,1080,1080,85838,NULL,NULL,NULL,'2026-01-16 21:31:44','2026-01-16 21:31:44','2026-01-16 21:31:44'),
(8774,2,2,1,'Screenshot-2026-01-16-153447.png','image/png','image',NULL,1205,819,1501355,NULL,NULL,NULL,'2026-01-16 21:35:06','2026-01-16 21:35:06','2026-01-16 21:35:06'),
(8779,2,2,1,'FairLawn_Room3.jpg','image/jpeg','image',NULL,6720,4480,12018060,NULL,NULL,NULL,'2026-01-17 00:12:40','2026-01-17 00:12:40','2026-01-17 00:12:40'),
(8780,2,2,1,'FairLawn_Salon.jpg','image/jpeg','image',NULL,6736,4486,14059626,NULL,NULL,NULL,'2026-01-17 00:12:43','2026-01-17 00:12:43','2026-01-17 00:12:43'),
(8781,2,2,1,'Fair-Lawn-Lobby_2026-01-17-001245_kxgj.jpg','image/jpeg','image',NULL,6724,4482,15479152,NULL,NULL,NULL,'2026-01-17 00:12:45','2026-01-17 00:12:46','2026-01-17 00:12:46'),
(8782,2,2,1,'FairLawn_Lobby.jpg','image/jpeg','image',NULL,6739,4485,15256257,NULL,NULL,NULL,'2026-01-17 00:12:48','2026-01-17 00:12:49','2026-01-17 00:12:49'),
(8783,2,2,1,'FairLawn_RehabGym.jpg','image/jpeg','image',NULL,6720,4480,16319234,NULL,NULL,NULL,'2026-01-17 00:12:50','2026-01-17 00:12:50','2026-01-17 00:12:50'),
(8784,2,2,1,'FairLawn_RehabGym2.jpg','image/jpeg','image',NULL,6724,4481,16507532,NULL,NULL,NULL,'2026-01-17 00:12:52','2026-01-17 00:12:52','2026-01-17 00:12:52'),
(8785,2,2,1,'FairLawn_Room.jpg','image/jpeg','image',NULL,6727,4484,15833556,NULL,NULL,NULL,'2026-01-17 00:12:54','2026-01-17 00:12:55','2026-01-17 00:12:55'),
(8786,2,2,1,'FairLawn_Room2.jpg','image/jpeg','image',NULL,6720,4480,15792369,NULL,NULL,NULL,'2026-01-17 00:12:56','2026-01-17 00:12:57','2026-01-17 00:12:57'),
(8795,2,2,1,'FairLawn_Room3_2026-01-17-001839_unuq.jpg','image/jpeg','image',NULL,6720,4480,12018060,NULL,NULL,NULL,'2026-01-17 00:18:39','2026-01-17 00:18:40','2026-01-17 00:18:40'),
(8796,2,2,1,'FairLawn_Salon_2026-01-17-001842_qwip.jpg','image/jpeg','image',NULL,6736,4486,14059626,NULL,NULL,NULL,'2026-01-17 00:18:42','2026-01-17 00:18:42','2026-01-17 00:18:42'),
(8797,2,2,1,'Fair-Lawn-Lobby_2026-01-17-001843_pdqx.jpg','image/jpeg','image',NULL,6724,4482,15479152,NULL,NULL,NULL,'2026-01-17 00:18:44','2026-01-17 00:18:44','2026-01-17 00:18:44'),
(8798,2,2,1,'FairLawn_Lobby_2026-01-17-001845_fobr.jpg','image/jpeg','image',NULL,6739,4485,15256257,NULL,NULL,NULL,'2026-01-17 00:18:45','2026-01-17 00:18:45','2026-01-17 00:18:45'),
(8799,2,2,1,'FairLawn_RehabGym_2026-01-17-001847_zekw.jpg','image/jpeg','image',NULL,6720,4480,16319234,NULL,NULL,NULL,'2026-01-17 00:18:48','2026-01-17 00:18:48','2026-01-17 00:18:48'),
(8800,2,2,1,'FairLawn_RehabGym2_2026-01-17-001849_mbqx.jpg','image/jpeg','image',NULL,6724,4481,16507532,NULL,NULL,NULL,'2026-01-17 00:18:50','2026-01-17 00:18:50','2026-01-17 00:18:50'),
(8801,2,2,1,'FairLawn_Room_2026-01-17-001851_qwzd.jpg','image/jpeg','image',NULL,6727,4484,15833556,NULL,NULL,NULL,'2026-01-17 00:18:52','2026-01-17 00:18:52','2026-01-17 00:18:52'),
(8802,2,2,1,'FairLawn_Room2_2026-01-17-001853_pgud.jpg','image/jpeg','image',NULL,6720,4480,15792369,NULL,NULL,NULL,'2026-01-17 00:18:54','2026-01-17 00:18:54','2026-01-17 00:18:54'),
(8803,2,2,1,'HamiltonPlaza_RehabGym3.jpg','image/jpeg','image',NULL,6728,4483,14319257,NULL,NULL,NULL,'2026-01-17 00:20:18','2026-01-17 00:20:18','2026-01-17 00:20:18'),
(8804,2,2,1,'HamiltonPlaza_SingleRoom.jpg','image/jpeg','image',NULL,6720,4480,14781472,NULL,NULL,NULL,'2026-01-17 00:20:20','2026-01-17 00:20:21','2026-01-17 00:20:21'),
(8805,2,2,1,'HamiltonPlaza_SingleRoom2.jpg','image/jpeg','image',NULL,6720,4480,14414439,NULL,NULL,NULL,'2026-01-17 00:20:23','2026-01-17 00:20:23','2026-01-17 00:20:23'),
(8806,2,2,1,'Hamilton-Plaza-Lobby_2026-01-17-002024_xdxz.jpg','image/jpeg','image',NULL,6720,4480,15463036,NULL,NULL,NULL,'2026-01-17 00:20:25','2026-01-17 00:20:25','2026-01-17 00:20:25'),
(8807,2,2,1,'HamiltonPlaza_DoubleRoom.jpg','image/jpeg','image',NULL,6720,4480,17334892,NULL,NULL,NULL,'2026-01-17 00:20:26','2026-01-17 00:20:27','2026-01-17 00:20:27'),
(8808,2,2,1,'HamiltonPlaza_RehabGym.jpg','image/jpeg','image',NULL,6720,4480,14215266,NULL,NULL,NULL,'2026-01-17 00:20:28','2026-01-17 00:20:28','2026-01-17 00:20:28'),
(8810,2,2,1,'HamiltonPlaza_RehabGym2.jpg','image/jpeg','image',NULL,6720,4480,15073963,NULL,NULL,NULL,'2026-01-17 00:20:30','2026-01-17 00:20:31','2026-01-17 00:20:31'),
(8829,2,2,1,'Double-Room-2.jpg','image/jpeg','image',NULL,6723,4484,14955094,NULL,NULL,NULL,'2026-01-17 00:24:05','2026-01-17 00:24:05','2026-01-17 00:24:05'),
(8830,2,2,1,'Double-Room.jpg','image/jpeg','image',NULL,6720,4480,5486979,NULL,NULL,NULL,'2026-01-17 00:24:08','2026-01-17 00:24:08','2026-01-17 00:24:08'),
(8831,2,2,1,'Harborage-Lobby_2026-01-17-002408_oebx.jpg','image/jpeg','image',NULL,6720,4480,6136127,NULL,NULL,NULL,'2026-01-17 00:24:10','2026-01-17 00:24:10','2026-01-17 00:24:10'),
(8832,2,2,1,'Room-2.jpg','image/jpeg','image',NULL,6720,4480,5544754,NULL,NULL,NULL,'2026-01-17 00:24:11','2026-01-17 00:24:12','2026-01-17 00:24:12'),
(8833,2,2,1,'Room-3.jpg','image/jpeg','image',NULL,6720,4480,5134041,NULL,NULL,NULL,'2026-01-17 00:24:14','2026-01-17 00:24:14','2026-01-17 00:24:14'),
(8834,2,2,1,'Room-4.jpg','image/jpeg','image',NULL,6729,4490,5110452,NULL,NULL,NULL,'2026-01-17 00:24:17','2026-01-17 00:24:17','2026-01-17 00:24:17'),
(8835,2,2,1,'Room.jpg','image/jpeg','image',NULL,6720,4480,5430415,NULL,NULL,NULL,'2026-01-17 00:24:19','2026-01-17 00:24:19','2026-01-17 00:24:19'),
(8836,2,2,1,'Bathroom.jpg','image/jpeg','image',NULL,4480,6720,5649707,NULL,NULL,NULL,'2026-01-17 00:24:22','2026-01-17 00:24:22','2026-01-17 00:24:22'),
(8837,2,2,1,'Dinning-Area.jpg','image/jpeg','image',NULL,6720,4480,6001178,NULL,NULL,NULL,'2026-01-17 00:24:24','2026-01-17 00:24:24','2026-01-17 00:24:24'),
(8862,2,2,1,'Double-Bed-Room-4.jpg','image/jpeg','image',NULL,6723,4482,13236060,NULL,NULL,NULL,'2026-01-17 00:29:22','2026-01-17 00:29:23','2026-01-17 00:29:23'),
(8864,2,2,1,'double-bed-room.jpg','image/jpeg','image',NULL,6720,4480,17123953,NULL,NULL,NULL,'2026-01-17 00:29:24','2026-01-17 00:29:25','2026-01-17 00:29:25'),
(8865,2,2,1,'Front-of-Building-2.jpg','image/jpeg','image',NULL,4480,6720,12209431,NULL,NULL,NULL,'2026-01-17 00:29:28','2026-01-17 00:29:28','2026-01-17 00:29:28'),
(8866,2,2,1,'Front-of-Building.jpg','image/jpeg','image',NULL,6331,4220,15424743,NULL,NULL,NULL,'2026-01-17 00:29:29','2026-01-17 00:29:30','2026-01-17 00:29:30'),
(8867,2,2,1,'Harston-Lobby_2026-01-17-002931_aqjr.jpg','image/jpeg','image',NULL,6720,4480,17233442,NULL,NULL,NULL,'2026-01-17 00:29:32','2026-01-17 00:29:32','2026-01-17 00:29:32'),
(8868,2,2,1,'Lobby.jpg','image/jpeg','image',NULL,4480,6720,16473265,NULL,NULL,NULL,'2026-01-17 00:29:34','2026-01-17 00:29:34','2026-01-17 00:29:34'),
(8869,2,2,1,'Double-Bed-room-2.jpg','image/jpeg','image',NULL,6720,4480,16854161,NULL,NULL,NULL,'2026-01-17 00:29:36','2026-01-17 00:29:36','2026-01-17 00:29:36'),
(8871,2,2,1,'Double-bed-room-3.jpg','image/jpeg','image',NULL,6720,4480,16791992,NULL,NULL,NULL,'2026-01-17 00:29:38','2026-01-17 00:29:38','2026-01-17 00:29:38'),
(8882,3,3,1,'Silver-Lake_January2026.pdf','application/pdf','pdf',NULL,NULL,NULL,455270,NULL,NULL,NULL,'2026-01-17 00:31:20','2026-01-17 00:31:20','2026-01-17 00:31:20'),
(8888,2,2,1,'Inglemoor-Lobby_2026-01-17-003315_dzkx.jpg','image/jpeg','image',NULL,7780,5187,14898154,NULL,NULL,NULL,'2026-01-17 00:33:17','2026-01-17 00:33:17','2026-01-17 00:33:17'),
(8889,2,2,1,'Lobby-2.jpg','image/jpeg','image',NULL,7053,4702,12835063,NULL,NULL,NULL,'2026-01-17 00:33:20','2026-01-17 00:33:20','2026-01-17 00:33:20'),
(8918,2,2,1,'gym-rehab-2.jpg','image/jpeg','image',NULL,6720,4480,9477713,NULL,NULL,NULL,'2026-01-17 00:37:43','2026-01-17 00:37:44','2026-01-17 00:37:44'),
(8919,2,2,1,'gym-rehab-3.jpg','image/jpeg','image',NULL,6720,4480,8346964,NULL,NULL,NULL,'2026-01-17 00:37:47','2026-01-17 00:37:47','2026-01-17 00:37:47'),
(8920,2,2,1,'gym-rehab.jpg','image/jpeg','image',NULL,6720,4480,8904250,NULL,NULL,NULL,'2026-01-17 00:37:48','2026-01-17 00:37:49','2026-01-17 00:37:49'),
(8923,2,2,1,'Lehigh-Lobby_2026-01-17-003749_qrmb.jpg','image/jpeg','image',NULL,6720,4480,10240320,NULL,NULL,NULL,'2026-01-17 00:37:51','2026-01-17 00:37:51','2026-01-17 00:37:51'),
(8924,2,2,1,'patio.jpg','image/jpeg','image',NULL,6720,4480,13331122,NULL,NULL,NULL,'2026-01-17 00:37:53','2026-01-17 00:37:53','2026-01-17 00:37:53'),
(8925,2,2,1,'room-bed.jpg','image/jpeg','image',NULL,6737,4492,8445229,NULL,NULL,NULL,'2026-01-17 00:37:55','2026-01-17 00:37:56','2026-01-17 00:37:56'),
(8926,2,2,1,'367A8203.jpg','image/jpeg','image',NULL,6720,4480,10471276,NULL,NULL,NULL,'2026-01-17 00:37:58','2026-01-17 00:37:58','2026-01-17 00:37:58'),
(8927,2,2,1,'367A8236.jpg','image/jpeg','image',NULL,6720,4480,9918588,NULL,NULL,NULL,'2026-01-17 00:38:00','2026-01-17 00:38:00','2026-01-17 00:38:00'),
(8928,2,2,1,'aerial-view-2.jpg','image/jpeg','image',NULL,4032,2688,4911214,NULL,NULL,NULL,'2026-01-17 00:38:02','2026-01-17 00:38:02','2026-01-17 00:38:02'),
(8929,2,2,1,'aerial-view-3.jpg','image/jpeg','image',NULL,4032,2688,4426439,NULL,NULL,NULL,'2026-01-17 00:38:04','2026-01-17 00:38:04','2026-01-17 00:38:04'),
(8930,2,2,1,'aerial-view-4.jpg','image/jpeg','image',NULL,4032,2688,4324328,NULL,NULL,NULL,'2026-01-17 00:38:05','2026-01-17 00:38:05','2026-01-17 00:38:05'),
(8931,2,2,1,'aerial-view.jpg','image/jpeg','image',NULL,4032,2688,5033344,NULL,NULL,NULL,'2026-01-17 00:38:06','2026-01-17 00:38:06','2026-01-17 00:38:06'),
(8932,2,2,1,'double-bed-room-2_2026-01-17-003806_dnbf.jpg','image/jpeg','image',NULL,6720,4480,8485802,NULL,NULL,NULL,'2026-01-17 00:38:07','2026-01-17 00:38:08','2026-01-17 00:38:08'),
(8933,2,2,1,'double-bedroom.jpg','image/jpeg','image',NULL,6721,4483,9258349,NULL,NULL,NULL,'2026-01-17 00:38:09','2026-01-17 00:38:09','2026-01-17 00:38:09'),
(8934,2,2,1,'front-of-building-2_2026-01-17-003812_thei.jpg','image/jpeg','image',NULL,4032,2688,3206682,NULL,NULL,NULL,'2026-01-17 00:38:12','2026-01-17 00:38:12','2026-01-17 00:38:12'),
(8935,2,2,1,'front-of-building-3.jpg','image/jpeg','image',NULL,4032,2688,3412787,NULL,NULL,NULL,'2026-01-17 00:38:13','2026-01-17 00:38:13','2026-01-17 00:38:13'),
(8936,2,2,1,'front-of-building_2026-01-17-003813_svcy.jpg','image/jpeg','image',NULL,4032,2688,3115626,NULL,NULL,NULL,'2026-01-17 00:38:14','2026-01-17 00:38:14','2026-01-17 00:38:14'),
(8953,2,2,1,'MilfordManor_Room3.jpg','image/jpeg','image',NULL,6720,4480,13747666,NULL,NULL,NULL,'2026-01-17 00:42:21','2026-01-17 00:42:21','2026-01-17 00:42:21'),
(8954,2,2,1,'MilfordManor_Kitchen.jpg','image/jpeg','image',NULL,6720,4480,17210527,NULL,NULL,NULL,'2026-01-17 00:42:24','2026-01-17 00:42:24','2026-01-17 00:42:24'),
(8955,2,2,1,'MilfordManor_RehabGym.jpg','image/jpeg','image',NULL,6722,4483,16947092,NULL,NULL,NULL,'2026-01-17 00:42:25','2026-01-17 00:42:25','2026-01-17 00:42:25'),
(8956,2,2,1,'MilfordManor_RehabGym2.jpg','image/jpeg','image',NULL,6721,4483,16579580,NULL,NULL,NULL,'2026-01-17 00:42:27','2026-01-17 00:42:27','2026-01-17 00:42:27'),
(8957,2,2,1,'MilfordManor_Room.jpg','image/jpeg','image',NULL,6720,4480,14438636,NULL,NULL,NULL,'2026-01-17 00:42:29','2026-01-17 00:42:30','2026-01-17 00:42:30'),
(8958,2,2,1,'MilfordManor_Room2.jpg','image/jpeg','image',NULL,6720,4480,13142213,NULL,NULL,NULL,'2026-01-17 00:42:31','2026-01-17 00:42:32','2026-01-17 00:42:32'),
(8959,2,2,1,'Milford-Manor-Lobby_2026-01-17-004233_ctpq.jpg','image/jpeg','image',NULL,6720,4480,16641745,NULL,NULL,NULL,'2026-01-17 00:42:33','2026-01-17 00:42:34','2026-01-17 00:42:34'),
(8968,2,2,1,'Phillipsburg-Lobby_2026-01-17-004803_xrol.jpg','image/jpeg','image',NULL,5040,3360,8748043,NULL,NULL,NULL,'2026-01-17 00:48:03','2026-01-17 00:48:03','2026-01-17 00:48:03'),
(8969,2,2,1,'Phillipsburg_DoubleRoom.jpg','image/jpeg','image',NULL,5040,3360,9394086,NULL,NULL,NULL,'2026-01-17 00:48:06','2026-01-17 00:48:06','2026-01-17 00:48:06'),
(8970,2,2,1,'Phillipsburg_RehabGym.jpg','image/jpeg','image',NULL,5044,3363,9466414,NULL,NULL,NULL,'2026-01-17 00:48:07','2026-01-17 00:48:07','2026-01-17 00:48:07'),
(8971,2,2,1,'Phillipsburg_RehabGym2.jpg','image/jpeg','image',NULL,5040,3360,10029034,NULL,NULL,NULL,'2026-01-17 00:48:08','2026-01-17 00:48:08','2026-01-17 00:48:08'),
(8972,2,2,1,'Phillipsburg_SingleRoom1.jpg','image/jpeg','image',NULL,5040,3360,8152423,NULL,NULL,NULL,'2026-01-17 00:48:10','2026-01-17 00:48:10','2026-01-17 00:48:10'),
(8973,2,2,1,'Phillipsburg_SingleRoom2.jpg','image/jpeg','image',NULL,5040,3360,8057611,NULL,NULL,NULL,'2026-01-17 00:48:12','2026-01-17 00:48:12','2026-01-17 00:48:12'),
(8974,2,2,1,'Phillipsburg_SittingArea.jpg','image/jpeg','image',NULL,3360,5040,8422551,NULL,NULL,NULL,'2026-01-17 00:48:13','2026-01-17 00:48:13','2026-01-17 00:48:13'),
(8980,2,2,1,'Lobby_2026-01-17-005106_tvup.jpg','image/jpeg','image',NULL,6727,4483,13876748,NULL,NULL,NULL,'2026-01-17 00:51:08','2026-01-17 00:51:08','2026-01-17 00:51:08'),
(8981,2,2,1,'room_2026-01-17-005110_egxb.jpg','image/jpeg','image',NULL,6722,4481,4986247,NULL,NULL,NULL,'2026-01-17 00:51:11','2026-01-17 00:51:11','2026-01-17 00:51:11'),
(8982,2,2,1,'STS_0283.jpg','image/jpeg','image',NULL,6720,4481,14792872,NULL,NULL,NULL,'2026-01-17 00:51:13','2026-01-17 00:51:13','2026-01-17 00:51:13'),
(8983,2,2,1,'double-bed-room_2026-01-17-005114_qvgn.jpg','image/jpeg','image',NULL,6771,4533,13870449,NULL,NULL,NULL,'2026-01-17 00:51:15','2026-01-17 00:51:15','2026-01-17 00:51:15'),
(8984,2,2,1,'gym-rehab_2026-01-17-005117_vmiy.jpg','image/jpeg','image',NULL,6720,4480,16277667,NULL,NULL,NULL,'2026-01-17 00:51:17','2026-01-17 00:51:18','2026-01-17 00:51:18'),
(9008,2,2,1,'Hagerstown-Cover-Photo.JPG','image/jpeg','image',NULL,3600,2400,2791313,NULL,NULL,NULL,'2026-01-17 01:10:18','2026-01-17 01:10:18','2026-01-17 01:10:18'),
(9011,2,2,1,'Hagerstown-Lobby-04.JPG','image/jpeg','image',NULL,3600,2400,2594696,NULL,NULL,NULL,'2026-01-17 01:11:40','2026-01-17 01:11:41','2026-01-17 01:11:41'),
(9012,2,2,1,'Hagerstown-Patient-Room-07.JPG','image/jpeg','image',NULL,3600,2400,2290936,NULL,NULL,NULL,'2026-01-17 01:11:42','2026-01-17 01:11:42','2026-01-17 01:11:42'),
(9013,2,2,1,'Hagerstown-Rehab-05.JPG','image/jpeg','image',NULL,3600,2400,1750023,NULL,NULL,NULL,'2026-01-17 01:11:43','2026-01-17 01:11:43','2026-01-17 01:11:43'),
(9014,2,2,1,'Hagerstown-Single-Patient-Room-081.JPG','image/jpeg','image',NULL,3600,2400,2225452,NULL,NULL,NULL,'2026-01-17 01:11:44','2026-01-17 01:11:44','2026-01-17 01:11:44'),
(9015,2,2,1,'Rehab-Gym-3.jpg','image/jpeg','image',NULL,1782,1187,446227,NULL,NULL,NULL,'2026-01-17 01:11:45','2026-01-17 01:11:46','2026-01-17 01:11:46'),
(9016,2,2,1,'Rehab-Gym-4.jpg','image/jpeg','image',NULL,2010,1335,458105,NULL,NULL,NULL,'2026-01-17 01:11:47','2026-01-17 01:11:47','2026-01-17 01:11:47'),
(9017,2,2,1,'Rehab-Gym.jpg','image/jpeg','image',NULL,6000,4000,7579451,NULL,NULL,NULL,'2026-01-17 14:28:09','2026-01-17 01:11:47','2026-01-17 14:28:09'),
(9018,2,2,1,'Semi-Private-Room-2.jpg','image/jpeg','image',NULL,1782,1188,339588,NULL,NULL,NULL,'2026-01-17 01:11:48','2026-01-17 01:11:48','2026-01-17 01:11:48'),
(9025,2,2,1,'Heritage-Cover-Photo.JPG','image/jpeg','image',NULL,3600,2400,1333792,NULL,NULL,NULL,'2026-01-17 01:16:30','2026-01-17 01:16:31','2026-01-17 01:16:31'),
(9028,2,2,1,'Lobby-Copy.JPG','image/jpeg','image',NULL,3600,2400,2121450,NULL,NULL,NULL,'2026-01-17 01:17:36','2026-01-17 01:17:36','2026-01-17 01:17:36'),
(9029,2,2,1,'Patio-04-Copy.JPG','image/jpeg','image',NULL,3600,2400,2558565,NULL,NULL,NULL,'2026-01-17 01:17:37','2026-01-17 01:17:37','2026-01-17 01:17:37'),
(9030,2,2,1,'Physical-therapy-Gym-08.JPG','image/jpeg','image',NULL,3600,2400,1576819,NULL,NULL,NULL,'2026-01-17 01:17:38','2026-01-17 01:17:38','2026-01-17 01:17:38'),
(9031,2,2,1,'Physical-therapy-Gym-12.JPG','image/jpeg','image',NULL,3600,2400,1401636,NULL,NULL,NULL,'2026-01-17 01:17:39','2026-01-17 01:17:39','2026-01-17 01:17:39'),
(9032,2,2,1,'Physical-therapy-Gym-13-002.JPG','image/jpeg','image',NULL,3600,2400,1537576,NULL,NULL,NULL,'2026-01-17 01:17:41','2026-01-17 01:17:41','2026-01-17 01:17:41'),
(9033,2,2,1,'Room-06-002.JPG','image/jpeg','image',NULL,3600,2400,1314407,NULL,NULL,NULL,'2026-01-17 01:17:42','2026-01-17 01:17:42','2026-01-17 01:17:42'),
(9038,2,2,1,'Hillside-Cover-Photo.JPG','image/jpeg','image',NULL,3600,2400,3385132,NULL,NULL,NULL,'2026-01-17 01:20:17','2026-01-17 01:20:17','2026-01-17 01:20:17'),
(9041,2,2,1,'Hillside-Activities-10.JPG','image/jpeg','image',NULL,3600,2400,1914064,NULL,NULL,NULL,'2026-01-17 01:21:28','2026-01-17 01:21:28','2026-01-17 01:21:28'),
(9042,2,2,1,'Hillside-Double-Bed-08.JPG','image/jpeg','image',NULL,3600,2400,1682029,NULL,NULL,NULL,'2026-01-17 01:21:29','2026-01-17 01:21:29','2026-01-17 01:21:29'),
(9043,2,2,1,'Hillside-Lobby-05.JPG','image/jpeg','image',NULL,3600,2400,1667635,NULL,NULL,NULL,'2026-01-17 01:21:30','2026-01-17 01:21:30','2026-01-17 01:21:30'),
(9044,2,2,1,'Hillside-Lobby-and-Activities-06.JPG','image/jpeg','image',NULL,3600,2400,2028372,NULL,NULL,NULL,'2026-01-17 01:21:31','2026-01-17 01:21:31','2026-01-17 01:21:31'),
(9045,2,2,1,'Hillside-Rehab-Gym-11.JPG','image/jpeg','image',NULL,3600,2400,2269651,NULL,NULL,NULL,'2026-01-17 01:21:33','2026-01-17 01:21:33','2026-01-17 01:21:33'),
(9046,2,2,1,'Hillside-Single-Bed-07.JPG','image/jpeg','image',NULL,3600,2400,1848082,NULL,NULL,NULL,'2026-01-17 01:21:34','2026-01-17 01:21:35','2026-01-17 01:21:35'),
(9051,2,2,1,'Hyattsville-Cover-Photo.JPG','image/jpeg','image',NULL,3600,2400,3842285,NULL,NULL,NULL,'2026-01-17 01:23:43','2026-01-17 01:23:43','2026-01-17 01:23:43'),
(9056,2,2,1,'LaPlata-Cover-Photo.JPG','image/jpeg','image',NULL,3600,2400,7803801,NULL,NULL,NULL,'2026-01-17 01:26:37','2026-01-17 01:26:37','2026-01-17 01:26:37'),
(9059,2,2,1,'LaPlata-Greenhouse-05.JPG','image/jpeg','image',NULL,3600,2400,5999583,NULL,NULL,NULL,'2026-01-17 01:27:18','2026-01-17 01:27:18','2026-01-17 01:27:18'),
(9060,2,2,1,'LaPlata-Lobby-02.JPG','image/jpeg','image',NULL,3600,2400,6179919,NULL,NULL,NULL,'2026-01-17 01:27:21','2026-01-17 01:27:21','2026-01-17 01:27:21'),
(9061,2,2,1,'LaPlata-Rehab-01.JPG','image/jpeg','image',NULL,3600,2400,6053038,NULL,NULL,NULL,'2026-01-17 01:27:22','2026-01-17 01:27:22','2026-01-17 01:27:22'),
(9062,2,2,1,'LaPlata-Rooms-13.JPG','image/jpeg','image',NULL,3600,2400,4283616,NULL,NULL,NULL,'2026-01-17 01:27:24','2026-01-17 01:27:24','2026-01-17 01:27:24'),
(9063,2,2,1,'LaPlata-Rooms-14.JPG','image/jpeg','image',NULL,3600,2400,4829634,NULL,NULL,NULL,'2026-01-17 01:27:24','2026-01-17 01:27:24','2026-01-17 01:27:24'),
(9068,2,2,1,'Cover-Photo.jpg','image/jpeg','image',NULL,3600,2400,3264791,NULL,NULL,NULL,'2026-01-17 01:30:41','2026-01-17 01:30:41','2026-01-17 01:30:41'),
(9071,2,2,1,'Towson-Activities10.JPG','image/jpeg','image',NULL,3600,2400,2429732,NULL,NULL,NULL,'2026-01-17 01:31:47','2026-01-17 01:31:47','2026-01-17 01:31:47'),
(9072,2,2,1,'Towson-Lounge-06.JPG','image/jpeg','image',NULL,3600,2400,3017301,NULL,NULL,NULL,'2026-01-17 01:31:49','2026-01-17 01:31:49','2026-01-17 01:31:49'),
(9073,2,2,1,'Towson-Rehab-08.JPG','image/jpeg','image',NULL,3600,2400,2470236,NULL,NULL,NULL,'2026-01-17 01:31:50','2026-01-17 01:31:50','2026-01-17 01:31:50'),
(9074,2,2,1,'Towson-Rooms-11.JPG','image/jpeg','image',NULL,3600,2400,2303594,NULL,NULL,NULL,'2026-01-17 01:31:51','2026-01-17 01:31:51','2026-01-17 01:31:51'),
(9075,2,2,1,'Towson-Rooms-12.JPG','image/jpeg','image',NULL,3600,2400,1977526,NULL,NULL,NULL,'2026-01-17 01:31:53','2026-01-17 01:31:53','2026-01-17 01:31:53'),
(9080,2,2,1,'Oak-Ridge-Exterior-08.JPG','image/jpeg','image',NULL,3600,2400,1996966,NULL,NULL,NULL,'2026-01-17 01:34:57','2026-01-17 01:34:57','2026-01-17 01:34:57'),
(9083,2,2,1,'Oak-Ridge-Dining-12.JPG','image/jpeg','image',NULL,3600,2400,2869291,NULL,NULL,NULL,'2026-01-17 01:35:37','2026-01-17 01:35:37','2026-01-17 01:35:37'),
(9084,2,2,1,'Oak-Ridge-Exterior-08_2026-01-17-013538_kjmd.JPG','image/jpeg','image',NULL,3600,2400,1996966,NULL,NULL,NULL,'2026-01-17 01:35:38','2026-01-17 01:35:38','2026-01-17 01:35:38'),
(9085,2,2,1,'Oak-Ridge-Lobby-10.JPG','image/jpeg','image',NULL,3600,2400,1837107,NULL,NULL,NULL,'2026-01-17 01:35:39','2026-01-17 01:35:39','2026-01-17 01:35:39'),
(9086,2,2,1,'Oak-Ridge-Lounge-14.JPG','image/jpeg','image',NULL,3600,2400,2617293,NULL,NULL,NULL,'2026-01-17 01:35:40','2026-01-17 01:35:40','2026-01-17 01:35:40'),
(9087,2,2,1,'Oak-Ridge-Rehab-09.JPG','image/jpeg','image',NULL,3600,2400,2028775,NULL,NULL,NULL,'2026-01-17 01:35:42','2026-01-17 01:35:42','2026-01-17 01:35:42'),
(9088,2,2,1,'Oak-Ridge-Room15.JPG','image/jpeg','image',NULL,3600,2400,1951088,NULL,NULL,NULL,'2026-01-17 01:35:43','2026-01-17 01:35:43','2026-01-17 01:35:43'),
(9095,2,2,1,'Severna-Cover-Photo.JPG','image/jpeg','image',NULL,3600,2400,10412794,NULL,NULL,NULL,'2026-01-17 01:39:19','2026-01-17 01:39:19','2026-01-17 01:39:19'),
(9100,2,2,1,'Severna-Memory-sitting-room.JPG','image/jpeg','image',NULL,3600,2400,4251341,NULL,NULL,NULL,'2026-01-17 01:40:20','2026-01-17 01:40:20','2026-01-17 01:40:20'),
(9101,2,2,1,'Severna-Outdoor-area-11.JPG','image/jpeg','image',NULL,3600,2400,6525523,NULL,NULL,NULL,'2026-01-17 01:40:22','2026-01-17 01:40:22','2026-01-17 01:40:22'),
(9102,2,2,1,'Severna-Rehab-24.JPG','image/jpeg','image',NULL,3600,2400,4986593,NULL,NULL,NULL,'2026-01-17 01:40:22','2026-01-17 01:40:23','2026-01-17 01:40:23'),
(9103,2,2,1,'Severna-Room-19.JPG','image/jpeg','image',NULL,3600,2400,3433652,NULL,NULL,NULL,'2026-01-17 01:40:25','2026-01-17 01:40:25','2026-01-17 01:40:25'),
(9104,2,2,1,'Severna-Lobby-15.JPG','image/jpeg','image',NULL,3600,2400,5013012,NULL,NULL,NULL,'2026-01-17 01:40:26','2026-01-17 01:40:26','2026-01-17 01:40:26'),
(9105,2,2,1,'Severna-Memory-Care-patio.JPG','image/jpeg','image',NULL,3600,2400,7883092,NULL,NULL,NULL,'2026-01-17 01:40:27','2026-01-17 01:40:27','2026-01-17 01:40:27'),
(9139,2,2,1,'Lobby_2026-01-17-015416_zwse.jpg','image/jpeg','image',NULL,6720,4480,16181979,NULL,NULL,NULL,'2026-01-17 01:54:17','2026-01-17 01:54:17','2026-01-17 01:54:17'),
(9144,2,2,1,'Room-4_2026-01-17-015508_beli.jpg','image/jpeg','image',NULL,6751,4515,14360539,NULL,NULL,NULL,'2026-01-17 01:55:09','2026-01-17 01:55:09','2026-01-17 01:55:09'),
(9145,2,2,1,'Room_2026-01-17-015511_xbjk.jpg','image/jpeg','image',NULL,6720,4480,14439932,NULL,NULL,NULL,'2026-01-17 01:55:12','2026-01-17 01:55:12','2026-01-17 01:55:12'),
(9146,2,2,1,'Seating.jpg','image/jpeg','image',NULL,6720,4480,15640868,NULL,NULL,NULL,'2026-01-17 01:55:13','2026-01-17 01:55:13','2026-01-17 01:55:13'),
(9147,2,2,1,'Lobby_2026-01-17-015514_ehoy.jpg','image/jpeg','image',NULL,6720,4480,16181979,NULL,NULL,NULL,'2026-01-17 01:55:15','2026-01-17 01:55:15','2026-01-17 01:55:15'),
(9148,2,2,1,'Rehab-gym_2026-01-17-015517_dfwr.jpg','image/jpeg','image',NULL,6727,4487,16113646,NULL,NULL,NULL,'2026-01-17 01:55:17','2026-01-17 01:55:18','2026-01-17 01:55:18'),
(9149,2,2,1,'Room-2_2026-01-17-015519_kpky.jpg','image/jpeg','image',NULL,4480,6720,14378246,NULL,NULL,NULL,'2026-01-17 01:55:19','2026-01-17 01:55:20','2026-01-17 01:55:20'),
(9150,2,2,1,'Room-3_2026-01-17-015521_uide.jpg','image/jpeg','image',NULL,6862,4526,16797854,NULL,NULL,NULL,'2026-01-17 01:55:21','2026-01-17 01:55:22','2026-01-17 01:55:22'),
(9155,2,2,1,'Lobby-3-Overview.jpg','image/jpeg','image',NULL,6730,4490,16439660,NULL,NULL,NULL,'2026-01-17 01:58:39','2026-01-17 01:58:39','2026-01-17 01:58:39'),
(9160,2,2,1,'Lobby-3-Overview_2026-01-17-020007_ywnk.jpg','image/jpeg','image',NULL,6730,4490,16439660,NULL,NULL,NULL,'2026-01-17 02:00:08','2026-01-17 02:00:08','2026-01-17 02:00:08'),
(9161,2,2,1,'Lobby_2026-01-17-020010_ctlf.jpg','image/jpeg','image',NULL,6720,4480,13738260,NULL,NULL,NULL,'2026-01-17 02:00:10','2026-01-17 02:00:10','2026-01-17 02:00:10'),
(9162,2,2,1,'Rehab-Gym_2026-01-17-020012_dyno.jpg','image/jpeg','image',NULL,6727,4496,15507060,NULL,NULL,NULL,'2026-01-17 02:00:13','2026-01-17 02:00:13','2026-01-17 02:00:13'),
(9163,2,2,1,'Room-2_2026-01-17-020013_yoko.jpg','image/jpeg','image',NULL,6720,4480,15613032,NULL,NULL,NULL,'2026-01-17 02:00:14','2026-01-17 02:00:14','2026-01-17 02:00:14'),
(9164,2,2,1,'Room_2026-01-17-020016_yqrl.jpg','image/jpeg','image',NULL,6724,4484,15430334,NULL,NULL,NULL,'2026-01-17 02:00:16','2026-01-17 02:00:16','2026-01-17 02:00:16'),
(9165,2,2,1,'Lobby-2_2026-01-17-020018_goab.jpg','image/jpeg','image',NULL,6721,4483,16632258,NULL,NULL,NULL,'2026-01-17 02:00:19','2026-01-17 02:00:19','2026-01-17 02:00:19'),
(9172,2,2,1,'Rehab-Gym-2.jpg','image/jpeg','image',NULL,6743,4497,16879042,NULL,NULL,NULL,'2026-01-17 02:04:46','2026-01-17 02:04:47','2026-01-17 02:04:47'),
(9181,2,2,1,'front-of-building-2_2026-01-17-021212_iwib.jpg','image/jpeg','image',NULL,6729,4484,17092658,NULL,NULL,NULL,'2026-01-17 02:12:13','2026-01-17 02:12:13','2026-01-17 02:12:13'),
(9184,2,2,1,'room-2_2026-01-17-021302_ujoq.jpg','image/jpeg','image',NULL,6777,4516,13796805,NULL,NULL,NULL,'2026-01-17 02:13:02','2026-01-17 02:13:03','2026-01-17 02:13:03'),
(9185,2,2,1,'room-3_2026-01-17-021304_wnda.jpg','image/jpeg','image',NULL,6720,4480,16050122,NULL,NULL,NULL,'2026-01-17 02:13:05','2026-01-17 02:13:05','2026-01-17 02:13:05'),
(9186,2,2,1,'room_2026-01-17-021307_cjlj.jpg','image/jpeg','image',NULL,6736,4488,16377171,NULL,NULL,NULL,'2026-01-17 02:13:07','2026-01-17 02:13:08','2026-01-17 02:13:08'),
(9187,2,2,1,'service-area-2.jpg','image/jpeg','image',NULL,6729,4489,15409134,NULL,NULL,NULL,'2026-01-17 02:13:10','2026-01-17 02:13:10','2026-01-17 02:13:10'),
(9188,2,2,1,'service-area-3.jpg','image/jpeg','image',NULL,6737,4488,16206062,NULL,NULL,NULL,'2026-01-17 02:13:13','2026-01-17 02:13:13','2026-01-17 02:13:13'),
(9189,2,2,1,'service-area.jpg','image/jpeg','image',NULL,6720,4480,15052672,NULL,NULL,NULL,'2026-01-17 02:13:15','2026-01-17 02:13:15','2026-01-17 02:13:15'),
(9190,2,2,1,'367A4617.jpg','image/jpeg','image',NULL,6729,4486,17117599,NULL,NULL,NULL,'2026-01-17 02:13:16','2026-01-17 02:13:17','2026-01-17 02:13:17'),
(9191,2,2,1,'front-of-building-2_2026-01-17-021318_buqk.jpg','image/jpeg','image',NULL,6729,4484,17092658,NULL,NULL,NULL,'2026-01-17 02:13:18','2026-01-17 02:13:19','2026-01-17 02:13:19'),
(9192,2,2,1,'front-of-building_2026-01-17-021320_mucq.jpg','image/jpeg','image',NULL,6720,4480,17180522,NULL,NULL,NULL,'2026-01-17 02:13:20','2026-01-17 02:13:20','2026-01-17 02:13:20'),
(9193,2,2,1,'rehab-gym_2026-01-17-021322_pjfu.jpg','image/jpeg','image',NULL,6720,4480,16391671,NULL,NULL,NULL,'2026-01-17 02:13:23','2026-01-17 02:13:23','2026-01-17 02:13:23'),
(9204,2,2,1,'lobby-2_2026-01-17-021948_ohoi.jpg','image/jpeg','image',NULL,2400,1599,706325,NULL,NULL,NULL,'2026-01-17 02:19:48','2026-01-17 02:19:48','2026-01-17 02:19:48'),
(9207,2,2,1,'bathroom_2026-01-17-022012_ahso.jpg','image/jpeg','image',NULL,2400,1596,298391,NULL,NULL,NULL,'2026-01-17 02:20:12','2026-01-17 02:20:12','2026-01-17 02:20:12'),
(9208,2,2,1,'dining-area.jpg','image/jpeg','image',NULL,2400,1600,692817,NULL,NULL,NULL,'2026-01-17 02:20:12','2026-01-17 02:20:12','2026-01-17 02:20:12'),
(9209,2,2,1,'double-bed-room_2026-01-17-022013_kjiy.jpg','image/jpeg','image',NULL,2400,1599,585027,NULL,NULL,NULL,'2026-01-17 02:20:13','2026-01-17 02:20:13','2026-01-17 02:20:13'),
(9210,2,2,1,'lobby-2_2026-01-17-022014_scdz.jpg','image/jpeg','image',NULL,2400,1599,706325,NULL,NULL,NULL,'2026-01-17 02:20:14','2026-01-17 02:20:14','2026-01-17 02:20:14'),
(9211,2,2,1,'lobby_2026-01-17-022015_xccz.jpg','image/jpeg','image',NULL,2400,1600,772783,NULL,NULL,NULL,'2026-01-17 02:20:15','2026-01-17 02:20:15','2026-01-17 02:20:15'),
(9212,2,2,1,'room-2_2026-01-17-022016_htzr.jpg','image/jpeg','image',NULL,2400,1599,573030,NULL,NULL,NULL,'2026-01-17 02:20:16','2026-01-17 02:20:16','2026-01-17 02:20:16'),
(9213,2,2,1,'room_2026-01-17-022017_ximw.jpg','image/jpeg','image',NULL,2400,1600,536896,NULL,NULL,NULL,'2026-01-17 02:20:17','2026-01-17 02:20:17','2026-01-17 02:20:17'),
(9219,2,2,1,'Lobby_2026-01-17-022630_ayfg.jpg','image/jpeg','image',NULL,6725,4485,14020284,NULL,NULL,NULL,'2026-01-17 02:26:30','2026-01-17 02:26:31','2026-01-17 02:26:31'),
(9222,2,2,1,'Rehab-Gym-2_2026-01-17-022729_epec.jpg','image/jpeg','image',NULL,6746,4491,15319253,NULL,NULL,NULL,'2026-01-17 02:27:29','2026-01-17 02:27:30','2026-01-17 02:27:30'),
(9223,2,2,1,'Rehab-Gym_2026-01-17-022731_anvz.jpg','image/jpeg','image',NULL,6725,4488,16679887,NULL,NULL,NULL,'2026-01-17 02:27:32','2026-01-17 02:27:32','2026-01-17 02:27:32'),
(9224,2,2,1,'Dining-area_2026-01-17-022734_nwro.jpg','image/jpeg','image',NULL,6725,4490,16335598,NULL,NULL,NULL,'2026-01-17 02:27:35','2026-01-17 02:27:35','2026-01-17 02:27:35'),
(9225,2,2,1,'Double-bed-room_2026-01-17-022737_apcr.jpg','image/jpeg','image',NULL,6724,4488,17138809,NULL,NULL,NULL,'2026-01-17 02:27:38','2026-01-17 02:27:38','2026-01-17 02:27:38'),
(9226,2,2,1,'Lobby_2026-01-17-022739_kauj.jpg','image/jpeg','image',NULL,6725,4485,14020284,NULL,NULL,NULL,'2026-01-17 02:27:39','2026-01-17 02:27:39','2026-01-17 02:27:39'),
(9238,2,2,1,'Lobby-3.jpg','image/jpeg','image',NULL,6720,4480,17257851,NULL,NULL,NULL,'2026-01-17 02:36:47','2026-01-17 02:36:47','2026-01-17 02:36:47'),
(9244,2,2,1,'Rehab-Gym_2026-01-17-023735_rgrd.jpg','image/jpeg','image',NULL,6724,4491,14675391,NULL,NULL,NULL,'2026-01-17 02:37:36','2026-01-17 02:37:36','2026-01-17 02:37:36'),
(9245,2,2,1,'Double-Room_2026-01-17-023738_otaz.jpg','image/jpeg','image',NULL,6749,4485,14163177,NULL,NULL,NULL,'2026-01-17 02:37:38','2026-01-17 02:37:39','2026-01-17 02:37:39'),
(9246,2,2,1,'Front-of-Building-2_2026-01-17-023739_gkfl.jpg','image/jpeg','image',NULL,4032,3024,5247571,NULL,NULL,NULL,'2026-01-17 02:37:40','2026-01-17 02:37:40','2026-01-17 02:37:40'),
(9247,2,2,1,'Kitchen-Area.jpg','image/jpeg','image',NULL,6727,4495,14265124,NULL,NULL,NULL,'2026-01-17 02:37:41','2026-01-17 02:37:41','2026-01-17 02:37:41'),
(9248,2,2,1,'Lobby-2_2026-01-17-023742_xotr.jpg','image/jpeg','image',NULL,6731,4487,16147682,NULL,NULL,NULL,'2026-01-17 02:37:43','2026-01-17 02:37:43','2026-01-17 02:37:43'),
(9249,2,2,1,'Lobby-3_2026-01-17-023744_fttw.jpg','image/jpeg','image',NULL,6720,4480,17257851,NULL,NULL,NULL,'2026-01-17 02:37:45','2026-01-17 02:37:45','2026-01-17 02:37:45'),
(9250,2,2,1,'Rehab-Gym-2_2026-01-17-023746_veyd.jpg','image/jpeg','image',NULL,6728,4490,15240894,NULL,NULL,NULL,'2026-01-17 02:37:47','2026-01-17 02:37:47','2026-01-17 02:37:47'),
(9255,2,2,1,'Lobby_2026-01-17-024049_pwhf.jpg','image/jpeg','image',NULL,3000,2400,699874,NULL,NULL,NULL,'2026-01-17 02:40:50','2026-01-17 02:40:50','2026-01-17 02:40:50'),
(9258,2,2,1,'Lobby-2_2026-01-17-024131_otji.jpg','image/jpeg','image',NULL,3000,2400,591016,NULL,NULL,NULL,'2026-01-17 02:41:31','2026-01-17 02:41:31','2026-01-17 02:41:31'),
(9259,2,2,1,'Lobby_2026-01-17-024132_gtnb.jpg','image/jpeg','image',NULL,3000,2400,699874,NULL,NULL,NULL,'2026-01-17 02:41:32','2026-01-17 02:41:32','2026-01-17 02:41:32'),
(9260,2,2,1,'Room_2026-01-17-024132_vjdj.jpg','image/jpeg','image',NULL,3000,2400,834640,NULL,NULL,NULL,'2026-01-17 02:41:33','2026-01-17 02:41:33','2026-01-17 02:41:33'),
(9261,2,2,1,'Dinning-Area_2026-01-17-024134_tuxw.jpg','image/jpeg','image',NULL,3000,2400,739648,NULL,NULL,NULL,'2026-01-17 02:41:34','2026-01-17 02:41:34','2026-01-17 02:41:34'),
(9286,2,2,1,'Lobby_2026-01-17-140145_nmub.jpg','image/jpeg','image',NULL,6720,4480,5854638,NULL,NULL,NULL,'2026-01-17 14:01:46','2026-01-17 14:01:46','2026-01-17 14:01:46'),
(9289,2,2,1,'Dinning-Area-2.jpg','image/jpeg','image',NULL,6720,4480,6612263,NULL,NULL,NULL,'2026-01-17 14:03:05','2026-01-17 14:03:05','2026-01-17 14:03:05'),
(9290,2,2,1,'Dinning-Area_2026-01-17-140307_nomh.jpg','image/jpeg','image',NULL,6720,4480,6548193,NULL,NULL,NULL,'2026-01-17 14:03:08','2026-01-17 14:03:09','2026-01-17 14:03:09'),
(9291,2,2,1,'Lobby_2026-01-17-140309_zckg.jpg','image/jpeg','image',NULL,6720,4480,5854638,NULL,NULL,NULL,'2026-01-17 14:03:10','2026-01-17 14:03:10','2026-01-17 14:03:10'),
(9292,2,2,1,'Outside-seating.jpg','image/jpeg','image',NULL,6720,4480,11672543,NULL,NULL,NULL,'2026-01-17 14:03:13','2026-01-17 14:03:13','2026-01-17 14:03:13'),
(9293,2,2,1,'Rehab-Gym_2026-01-17-140315_ntdx.jpg','image/jpeg','image',NULL,6720,4480,5064411,NULL,NULL,NULL,'2026-01-17 14:03:16','2026-01-17 14:03:16','2026-01-17 14:03:16'),
(9294,2,2,1,'Dinning-Area-piano.jpg','image/jpeg','image',NULL,6720,4480,6038713,NULL,NULL,NULL,'2026-01-17 14:03:18','2026-01-17 14:03:18','2026-01-17 14:03:18'),
(9309,2,2,1,'lobby_2026-01-17-141153_gfwd.jpg','image/jpeg','image',NULL,6720,4480,16769402,NULL,NULL,NULL,'2026-01-17 14:11:53','2026-01-17 14:11:54','2026-01-17 14:11:54'),
(9312,2,2,1,'lobby_2026-01-17-141243_utls.jpg','image/jpeg','image',NULL,6720,4480,16769402,NULL,NULL,NULL,'2026-01-17 14:12:44','2026-01-17 14:12:44','2026-01-17 14:12:44'),
(9313,2,2,1,'room_2026-01-17-141246_mphf.jpg','image/jpeg','image',NULL,6720,4480,17106775,NULL,NULL,NULL,'2026-01-17 14:12:46','2026-01-17 14:12:47','2026-01-17 14:12:47'),
(9314,2,2,1,'front-of-building_2026-01-17-141247_bgai.jpg','image/jpeg','image',NULL,6723,4483,13308997,NULL,NULL,NULL,'2026-01-17 14:12:49','2026-01-17 14:12:49','2026-01-17 14:12:49'),
(9319,2,2,1,'gym-rehab_2026-01-17-141538_xcuh.jpg','image/jpeg','image',NULL,6720,4480,6184744,NULL,NULL,NULL,'2026-01-17 14:15:39','2026-01-17 14:15:39','2026-01-17 14:15:39'),
(9320,2,2,1,'lobby-2_2026-01-17-141541_tgxq.jpg','image/jpeg','image',NULL,6728,4491,5462043,NULL,NULL,NULL,'2026-01-17 14:15:42','2026-01-17 14:15:43','2026-01-17 14:15:43'),
(9321,2,2,1,'lobby_2026-01-17-141543_tphz.jpg','image/jpeg','image',NULL,6724,4486,5127591,NULL,NULL,NULL,'2026-01-17 14:15:44','2026-01-17 14:15:44','2026-01-17 14:15:44'),
(9322,2,2,1,'room-2_2026-01-17-141545_yrzi.jpg','image/jpeg','image',NULL,6720,4480,4248258,NULL,NULL,NULL,'2026-01-17 14:15:46','2026-01-17 14:15:46','2026-01-17 14:15:46'),
(9323,2,2,1,'room_2026-01-17-141548_grpc.jpg','image/jpeg','image',NULL,6720,4480,5395750,NULL,NULL,NULL,'2026-01-17 14:15:49','2026-01-17 14:15:49','2026-01-17 14:15:49'),
(9328,2,2,1,'gym-rehab-2_2026-01-17-141824_jbny.jpg','image/jpeg','image',NULL,6720,4480,16749940,NULL,NULL,NULL,'2026-01-17 14:18:25','2026-01-17 14:18:25','2026-01-17 14:18:25'),
(9331,2,2,1,'gym-rehab-3_2026-01-17-141929_vvae.jpg','image/jpeg','image',NULL,6720,4480,15575408,NULL,NULL,NULL,'2026-01-17 14:19:30','2026-01-17 14:19:30','2026-01-17 14:19:30'),
(9332,2,2,1,'gym-rehab_2026-01-17-141932_mmit.jpg','image/jpeg','image',NULL,6720,4480,8740656,NULL,NULL,NULL,'2026-01-17 14:19:33','2026-01-17 14:19:34','2026-01-17 14:19:34'),
(9333,2,2,1,'double-bed-room-2_2026-01-17-141934_xbzj.jpg','image/jpeg','image',NULL,6720,4480,14469711,NULL,NULL,NULL,'2026-01-17 14:19:35','2026-01-17 14:19:35','2026-01-17 14:19:35'),
(9334,2,2,1,'double-bed-room_2026-01-17-141936_qmwf.jpg','image/jpeg','image',NULL,6720,4480,17093791,NULL,NULL,NULL,'2026-01-17 14:19:37','2026-01-17 14:19:37','2026-01-17 14:19:37'),
(9335,2,2,1,'entertainment-area.jpg','image/jpeg','image',NULL,6720,4480,16501915,NULL,NULL,NULL,'2026-01-17 14:19:39','2026-01-17 14:19:39','2026-01-17 14:19:39'),
(9336,2,2,1,'gym-rehab-2_2026-01-17-141941_cfyt.jpg','image/jpeg','image',NULL,6720,4480,16749940,NULL,NULL,NULL,'2026-01-17 14:19:41','2026-01-17 14:19:42','2026-01-17 14:19:42'),
(9353,2,2,1,'Rehab-Gym_2026-01-17-142801_wmds.jpg','image/jpeg','image',NULL,6000,4000,7574082,NULL,0,0,'2026-01-17 14:28:02','2026-01-17 14:28:02','2026-01-17 14:28:02'),
(9354,2,2,1,'Rehab-Gym_2026-01-17-142832_rvju.jpg','image/jpeg','image',NULL,6000,4000,7574082,NULL,NULL,NULL,'2026-01-17 14:28:33','2026-01-17 14:28:34','2026-01-17 14:28:34'),
(9415,2,2,1,'Park-Place-Lobby_2026-01-17-145451_dave.jpg','image/jpeg','image',NULL,6720,4480,17599905,NULL,NULL,NULL,'2026-01-17 14:54:52','2026-01-17 14:54:52','2026-01-17 14:54:52'),
(9420,2,2,1,'Unknown-9.jpeg','image/jpeg','image',NULL,1200,1600,440115,NULL,NULL,NULL,'2026-01-17 14:59:29','2026-01-17 14:59:29','2026-01-17 14:59:29'),
(9423,2,2,1,'Unknown-8.jpeg','image/jpeg','image',NULL,1200,1600,466126,NULL,NULL,NULL,'2026-01-17 15:00:01','2026-01-17 15:00:01','2026-01-17 15:00:01'),
(9424,2,2,1,'Unknown-7.jpeg','image/jpeg','image',NULL,1200,1600,449105,NULL,NULL,NULL,'2026-01-17 15:00:02','2026-01-17 15:00:02','2026-01-17 15:00:02'),
(9425,2,2,1,'Unknown-3.jpeg','image/jpeg','image',NULL,1600,1200,446674,NULL,NULL,NULL,'2026-01-17 15:00:02','2026-01-17 15:00:02','2026-01-17 15:00:02'),
(9426,2,2,1,'Unknown.jpeg','image/jpeg','image',NULL,5333,4000,7072777,NULL,NULL,NULL,'2026-01-17 15:00:04','2026-01-17 15:00:04','2026-01-17 15:00:04'),
(9427,2,2,1,'Unknown-1.jpeg','image/jpeg','image',NULL,3793,4330,5016997,NULL,NULL,NULL,'2026-01-17 15:00:06','2026-01-17 15:00:06','2026-01-17 15:00:06'),
(9453,3,3,1,'CC-WW-Floor-Plan-Flyer-1.pdf','application/pdf','pdf',NULL,NULL,NULL,289047,NULL,NULL,NULL,'2026-01-17 15:10:42','2026-01-17 15:10:42','2026-01-17 15:10:42'),
(9466,2,2,1,'Mayfield.jpg','image/jpeg','image',NULL,669,446,123997,NULL,NULL,NULL,'2026-01-17 15:35:31','2026-01-17 15:35:31','2026-01-17 15:35:31'),
(9469,2,2,1,'Mayfield-3.jpg','image/jpeg','image',NULL,669,446,53368,NULL,NULL,NULL,'2026-01-17 15:35:52','2026-01-17 15:35:52','2026-01-17 15:35:52'),
(9470,2,2,1,'Mayfield-2.jpg','image/jpeg','image',NULL,669,446,72789,NULL,NULL,NULL,'2026-01-17 15:35:53','2026-01-17 15:35:53','2026-01-17 15:35:53'),
(9471,2,2,1,'Mayfield_2026-01-17-153553_swad.jpg','image/jpeg','image',NULL,669,446,123997,NULL,NULL,NULL,'2026-01-17 15:35:53','2026-01-17 15:35:53','2026-01-17 15:35:53'),
(9518,2,2,1,'Roosevelt-Old-Bridge-Gym_2026-01-17-161242_qxrn.jpg','image/jpeg','image',NULL,6727,4482,15385400,NULL,NULL,NULL,'2026-01-17 16:12:43','2026-01-17 16:12:43','2026-01-17 16:12:43'),
(9519,2,2,1,'Roosevelt_OldBridge_DoubleRoom.jpg','image/jpeg','image',NULL,6729,4486,16025251,NULL,NULL,NULL,'2026-01-17 16:12:46','2026-01-17 16:12:46','2026-01-17 16:12:46'),
(9520,2,2,1,'Roosevelt_OldBridge_SingleRoom.jpg','image/jpeg','image',NULL,6720,4480,15169581,NULL,NULL,NULL,'2026-01-17 16:12:48','2026-01-17 16:12:49','2026-01-17 16:12:49'),
(9524,2,2,1,'uptown-3.jpg','image/jpeg','image',NULL,669,440,69423,NULL,NULL,NULL,'2026-01-17 16:15:19','2026-01-17 16:15:19','2026-01-17 16:15:19'),
(9529,2,2,1,'uptown-3_2026-01-17-161618_wfxl.jpg','image/jpeg','image',NULL,669,440,69423,NULL,NULL,NULL,'2026-01-17 16:16:18','2026-01-17 16:16:18','2026-01-17 16:16:18'),
(9530,2,2,1,'uptown-2.jpg','image/jpeg','image',NULL,669,446,55691,NULL,NULL,NULL,'2026-01-17 16:16:19','2026-01-17 16:16:19','2026-01-17 16:16:19'),
(9531,2,2,1,'uptown.jpg','image/jpeg','image',NULL,669,454,52115,NULL,NULL,NULL,'2026-01-17 16:16:19','2026-01-17 16:16:19','2026-01-17 16:16:19'),
(9535,2,2,1,'Beacon-1.jpg','image/jpeg','image',NULL,658,468,128617,'0.3845;0.5363',NULL,NULL,'2026-01-17 16:17:55','2026-01-17 16:17:55','2026-01-20 15:33:32'),
(9540,6,8,1,'4-QM.png','image/png','image',NULL,1200,1200,225688,NULL,NULL,NULL,'2026-01-17 16:30:01','2026-01-17 16:30:01','2026-01-17 16:30:01'),
(9543,6,8,1,'4-Overall.png','image/png','image',NULL,1200,1200,226598,NULL,NULL,NULL,'2026-01-17 16:31:05','2026-01-17 16:31:05','2026-01-17 16:31:05'),
(9546,6,8,1,'5-Overall.png','image/png','image',NULL,1200,1200,227435,NULL,NULL,NULL,'2026-01-17 16:31:34','2026-01-17 16:31:34','2026-01-17 16:31:34'),
(9550,6,8,1,'Legacy-Award.png','image/png','image',NULL,1200,1200,238538,NULL,NULL,NULL,'2026-01-17 16:32:05','2026-01-17 16:32:05','2026-01-17 16:32:05'),
(9553,6,8,1,'High-5.png','image/png','image',NULL,1200,1200,190617,NULL,NULL,NULL,'2026-01-17 16:32:27','2026-01-17 16:32:27','2026-01-17 16:32:27'),
(9556,6,8,1,'WW.png','image/png','image',NULL,1200,1200,167904,NULL,NULL,NULL,'2026-01-17 16:32:50','2026-01-17 16:32:50','2026-01-17 16:32:50'),
(9559,6,8,1,'Holmdel.png','image/png','image',NULL,1200,1200,167546,NULL,NULL,NULL,'2026-01-17 16:33:11','2026-01-17 16:33:11','2026-01-17 16:33:11'),
(9581,2,2,1,'Inglemoor-Dinning-Area.jpg','image/jpeg','image',NULL,7054,4702,519302,NULL,0,0,'2026-01-17 16:45:17','2026-01-17 16:45:17','2026-01-17 16:45:17'),
(9589,2,2,1,'Inglemoor-Dining-room.jpg','image/jpeg','image',NULL,7968,5312,6390595,NULL,NULL,NULL,'2026-01-17 16:48:36','2026-01-17 16:48:37','2026-01-17 16:48:37'),
(9592,2,2,1,'MilfordManor_Lobby-website.jpg','image/jpeg','image',NULL,5725,3817,3762287,NULL,NULL,NULL,'2026-01-17 16:52:45','2026-01-17 16:52:45','2026-01-17 16:52:45'),
(9622,2,2,1,'Regent-Dining-1.jpg','image/jpeg','image',NULL,7622,5126,5004888,NULL,NULL,NULL,'2026-01-17 17:20:15','2026-01-17 17:20:15','2026-01-17 17:20:15'),
(9623,2,2,1,'Regent-Dining-2.jpg','image/jpeg','image',NULL,7718,5146,3968931,NULL,NULL,NULL,'2026-01-17 17:20:18','2026-01-17 17:20:18','2026-01-17 17:20:18'),
(9624,2,2,1,'Regent-Gym-1-edit.jpg','image/jpeg','image',NULL,7800,5200,5767530,NULL,NULL,NULL,'2026-01-17 17:20:21','2026-01-17 17:20:21','2026-01-17 17:20:21'),
(9625,2,2,1,'Regent-Gym-2.jpg','image/jpeg','image',NULL,7647,5098,4099728,NULL,NULL,NULL,'2026-01-17 17:20:24','2026-01-17 17:20:24','2026-01-17 17:20:24'),
(9626,2,2,1,'Regent-Gym-3-edit.jpg','image/jpeg','image',NULL,7524,5016,7946238,NULL,NULL,NULL,'2026-01-17 17:20:27','2026-01-17 17:20:27','2026-01-17 17:20:27'),
(9627,2,2,1,'Regent-Hall-2.jpg','image/jpeg','image',NULL,7995,5330,4537350,NULL,NULL,NULL,'2026-01-17 17:20:30','2026-01-17 17:20:30','2026-01-17 17:20:30'),
(9628,2,2,1,'Regent-Hall.jpg','image/jpeg','image',NULL,7995,5330,4554666,NULL,NULL,NULL,'2026-01-17 17:20:33','2026-01-17 17:20:33','2026-01-17 17:20:33'),
(9629,2,2,1,'Regent-Lobby-1.jpg','image/jpeg','image',NULL,7918,5278,5799070,NULL,NULL,NULL,'2026-01-17 17:20:36','2026-01-17 17:20:36','2026-01-17 17:20:36'),
(9630,2,2,1,'Regent-Lobby-2.jpg','image/jpeg','image',NULL,7901,5267,9247669,NULL,NULL,NULL,'2026-01-17 17:20:39','2026-01-17 17:20:40','2026-01-17 17:20:40'),
(9631,2,2,1,'Regent-Lobby-3.jpg','image/jpeg','image',NULL,7633,5089,5601414,NULL,NULL,NULL,'2026-01-17 17:20:42','2026-01-17 17:20:42','2026-01-17 17:20:42'),
(9632,2,2,1,'Regent-Room-1.jpg','image/jpeg','image',NULL,7542,5028,4752109,NULL,NULL,NULL,'2026-01-17 17:20:45','2026-01-17 17:20:45','2026-01-17 17:20:45'),
(9633,2,2,1,'Regent-room-2.jpg','image/jpeg','image',NULL,7598,5065,4472339,NULL,NULL,NULL,'2026-01-17 17:20:47','2026-01-17 17:20:48','2026-01-17 17:20:48'),
(9641,6,8,1,'Newsweek-Best-Nursing-Home-CC-Badge-2026.png','image/png','image',NULL,1638,1613,607723,NULL,NULL,NULL,'2026-01-17 18:14:03','2026-01-17 18:14:03','2026-01-17 18:14:03'),
(9660,6,8,1,'CC-CMS-4-O.png','image/png','image',NULL,2390,2393,739249,NULL,0,0,'2026-01-17 18:43:39','2026-01-17 18:43:39','2026-01-17 18:43:39'),
(9663,6,8,1,'CC-Badges-for-Website_High5.png','image/png','image',NULL,1200,1200,299307,NULL,NULL,NULL,'2026-01-17 18:56:43','2026-01-17 18:56:43','2026-01-17 18:56:43'),
(9664,6,8,1,'CC-Badges-for-Website_Holmdel-Google.png','image/png','image',NULL,1200,1200,197137,NULL,NULL,NULL,'2026-01-17 18:56:44','2026-01-17 18:56:44','2026-01-17 18:56:44'),
(9665,6,8,1,'CC-Badges-for-Website_Legacy-Award.png','image/png','image',NULL,1200,1200,401694,NULL,NULL,NULL,'2026-01-17 18:56:45','2026-01-17 18:56:45','2026-01-17 18:56:45'),
(9666,6,8,1,'CC-Badges-for-Website_Preferred-Provider-Place-Holder.png','image/png','image',NULL,1200,1200,297080,NULL,NULL,NULL,'2026-01-17 18:56:46','2026-01-17 18:56:46','2026-01-17 18:56:46'),
(9669,6,8,1,'CC-Badges-for-Website_Legacy-Award_2026-01-17-185804_nvfg.png','image/png','image',NULL,1200,1200,401694,NULL,NULL,NULL,'2026-01-17 18:58:04','2026-01-17 18:58:04','2026-01-17 18:58:04'),
(9672,6,8,1,'CC-Badges-for-Website_High5_2026-01-17-185838_noah.png','image/png','image',NULL,1200,1200,299307,NULL,NULL,NULL,'2026-01-17 18:58:38','2026-01-17 18:58:38','2026-01-17 18:58:38'),
(9675,6,8,1,'CC-Badges-for-Website_Preferred-Provider-Place-Holder_2026-01-17-185923_aisu.png','image/png','image',NULL,1200,1200,297080,NULL,NULL,NULL,'2026-01-17 18:59:24','2026-01-17 18:59:24','2026-01-17 18:59:24'),
(9677,6,8,1,'CC-CMS-4-O.png','image/png','image',NULL,2390,2393,739249,NULL,NULL,NULL,'2026-01-17 19:00:16','2026-01-17 19:00:16','2026-01-17 19:00:16'),
(9680,6,8,1,'Preferred-Provider-AtlantiCare.png','image/png','image',NULL,1200,1200,200022,NULL,NULL,NULL,'2026-01-17 19:03:08','2026-01-17 19:03:08','2026-01-17 19:03:08'),
(9685,2,2,1,'367A3617.jpg','image/jpeg','image',NULL,6726,4487,16458610,NULL,NULL,NULL,'2026-01-17 19:21:41','2026-01-17 19:21:41','2026-01-17 19:21:41'),
(9686,2,2,1,'367A3628.jpg','image/jpeg','image',NULL,6720,4480,13552350,NULL,NULL,NULL,'2026-01-17 19:21:44','2026-01-17 19:21:45','2026-01-17 19:21:45'),
(9687,2,2,1,'367A3644.jpg','image/jpeg','image',NULL,6729,4512,16020177,NULL,NULL,NULL,'2026-01-17 19:21:48','2026-01-17 19:21:49','2026-01-17 19:21:49'),
(9688,2,2,1,'367A3655.jpg','image/jpeg','image',NULL,6725,4484,16021937,NULL,NULL,NULL,'2026-01-17 19:21:52','2026-01-17 19:21:52','2026-01-17 19:21:52'),
(9689,2,2,1,'367A3670.jpg','image/jpeg','image',NULL,6720,4480,15612011,NULL,NULL,NULL,'2026-01-17 19:21:56','2026-01-17 19:21:56','2026-01-17 19:21:56'),
(9690,2,2,1,'367A3686.jpg','image/jpeg','image',NULL,6731,4490,16514751,NULL,NULL,NULL,'2026-01-17 19:22:00','2026-01-17 19:22:00','2026-01-17 19:22:00'),
(9691,2,2,1,'367A3695.jpg','image/jpeg','image',NULL,4480,6720,14464682,NULL,NULL,NULL,'2026-01-17 19:22:03','2026-01-17 19:22:04','2026-01-17 19:22:04'),
(9692,2,2,1,'367A3719.jpg','image/jpeg','image',NULL,6720,4480,17248026,NULL,NULL,NULL,'2026-01-17 19:22:08','2026-01-17 19:22:08','2026-01-17 19:22:08'),
(9693,2,2,1,'Care-Age-Family-Room.jpg','image/jpeg','image',NULL,6207,4138,4884770,NULL,NULL,NULL,'2026-01-17 19:26:40','2026-01-17 19:26:40','2026-01-17 19:26:40'),
(9694,2,2,1,'Care-Age-Outdoor-Patio.jpg','image/jpeg','image',NULL,6452,4302,8137573,NULL,NULL,NULL,'2026-01-17 19:26:43','2026-01-17 19:26:43','2026-01-17 19:26:43'),
(9698,6,8,1,'CC-CMS-5-O.png','image/png','image',NULL,2390,2393,733865,NULL,NULL,NULL,'2026-01-17 19:30:43','2026-01-17 19:30:43','2026-01-17 19:30:43'),
(9701,6,8,1,'CC-CMS-5-QM.png','image/png','image',NULL,2390,2393,738404,NULL,NULL,NULL,'2026-01-17 19:31:04','2026-01-17 19:31:04','2026-01-17 19:31:04'),
(9704,6,8,1,'CC-CMS-4-O_2026-01-17-193121_zejc.png','image/png','image',NULL,2390,2393,739249,NULL,NULL,NULL,'2026-01-17 19:31:22','2026-01-17 19:31:22','2026-01-17 19:31:22'),
(9707,6,8,1,'CC-CMS-4-QM.png','image/png','image',NULL,2390,2393,766366,NULL,NULL,NULL,'2026-01-17 19:31:43','2026-01-17 19:31:43','2026-01-17 19:31:43'),
(9710,6,8,1,'CC-Badges-for-Website_High5_2026-01-17-193201_wozc.png','image/png','image',NULL,1200,1200,299307,NULL,NULL,NULL,'2026-01-17 19:32:02','2026-01-17 19:32:02','2026-01-17 19:32:02'),
(9714,6,8,1,'CC-Badges-for-Website_Legacy-Award_2026-01-17-193247_vgru.png','image/png','image',NULL,1200,1200,401694,NULL,NULL,NULL,'2026-01-17 19:32:47','2026-01-17 19:32:47','2026-01-17 19:32:47'),
(9717,6,8,1,'CC-Badges-for-Website_WW-Google.png','image/png','image',NULL,1200,1200,196567,NULL,NULL,NULL,'2026-01-17 19:34:00','2026-01-17 19:34:00','2026-01-17 19:34:00'),
(9720,6,8,1,'CC-Badges-for-Website_Holmdel-Google_2026-01-17-193420_obtc.png','image/png','image',NULL,1200,1200,197137,NULL,NULL,NULL,'2026-01-17 19:34:20','2026-01-17 19:34:20','2026-01-17 19:34:20'),
(9725,6,8,1,'Badge-NursingHomes_LongTerm-year-2025.png','image/png','image',NULL,2067,2155,361594,NULL,NULL,NULL,'2026-01-17 20:00:15','2026-01-17 20:00:15','2026-01-17 20:00:15'),
(9728,6,8,1,'Badge-NursingHomes_ShortTerm-year-2025.png','image/png','image',NULL,2067,2155,387742,NULL,NULL,NULL,'2026-01-17 20:00:47','2026-01-17 20:00:47','2026-01-17 20:00:47'),
(9733,6,8,1,'Badge-NursingHomes_ShortTerm-year.png','image/png','image',NULL,1034,1077,111213,NULL,NULL,NULL,'2026-01-17 20:02:32','2026-01-17 20:02:32','2026-01-17 20:02:32'),
(9736,6,8,1,'Badge-NursingHomes_LongTerm-year.png','image/png','image',NULL,1034,1077,108853,NULL,NULL,NULL,'2026-01-17 20:02:49','2026-01-17 20:02:49','2026-01-17 20:02:49'),
(9749,2,2,1,'Hales-Corners-External-1.jpg','image/jpeg','image',NULL,6393,4262,7907101,'0.7001;0.4924',NULL,NULL,'2026-01-17 20:08:01','2026-01-17 20:08:02','2026-01-17 20:20:34'),
(9800,2,2,1,'Hales-Corners-Dining-Room.jpg','image/jpeg','image',NULL,6396,4264,4356288,NULL,NULL,NULL,'2026-01-17 20:21:51','2026-01-17 20:21:51','2026-01-17 20:21:51'),
(9803,2,2,1,'Hales-Corners-External-1_2026-01-17-202153_aync.jpg','image/jpeg','image',NULL,6393,4262,7907101,NULL,NULL,NULL,'2026-01-17 20:21:54','2026-01-17 20:21:54','2026-01-17 20:21:54'),
(9804,2,2,1,'Hales-Corners-External-2.jpg','image/jpeg','image',NULL,6401,4270,6261667,NULL,NULL,NULL,'2026-01-17 20:21:57','2026-01-17 20:21:57','2026-01-17 20:21:57'),
(9805,2,2,1,'Hales-Corners-External-3.jpg','image/jpeg','image',NULL,6209,4139,6781006,NULL,NULL,NULL,'2026-01-17 20:22:00','2026-01-17 20:22:00','2026-01-17 20:22:00'),
(9806,2,2,1,'Hales-Corners-Gym-1.jpg','image/jpeg','image',NULL,6348,4236,5122061,NULL,NULL,NULL,'2026-01-17 20:22:02','2026-01-17 20:22:02','2026-01-17 20:22:02'),
(9807,2,2,1,'Hales-Corners-Gym-2.jpg','image/jpeg','image',NULL,6150,4102,4418066,NULL,NULL,NULL,'2026-01-17 20:22:04','2026-01-17 20:22:05','2026-01-17 20:22:05'),
(9808,2,2,1,'Hales-Corners-Room.jpg','image/jpeg','image',NULL,6371,4246,5833285,NULL,NULL,NULL,'2026-01-17 20:22:07','2026-01-17 20:22:07','2026-01-17 20:22:07'),
(9809,2,2,1,'Hales-Corners-Room-1.jpg','image/jpeg','image',NULL,6262,4175,5422645,NULL,NULL,NULL,'2026-01-17 20:22:10','2026-01-17 20:22:10','2026-01-17 20:22:10'),
(9811,2,2,1,'Hales-Corners-Room-2.jpg','image/jpeg','image',NULL,6171,4117,4464544,NULL,NULL,NULL,'2026-01-17 20:22:12','2026-01-17 20:22:12','2026-01-17 20:22:12'),
(9812,2,2,1,'Hales-Corners-sitting-Room-1.jpg','image/jpeg','image',NULL,6398,4171,5112064,NULL,NULL,NULL,'2026-01-17 20:22:15','2026-01-17 20:22:15','2026-01-17 20:22:15'),
(9813,2,2,1,'Hales-Corners-Sitting-Room.jpg','image/jpeg','image',NULL,6327,4219,4815278,NULL,NULL,NULL,'2026-01-17 20:22:17','2026-01-17 20:22:17','2026-01-17 20:22:17'),
(9839,2,2,1,'Kinsington-Lobby-2.jpg','image/jpeg','image',NULL,6747,4499,16778427,NULL,NULL,NULL,'2026-01-17 20:32:17','2026-01-17 20:32:18','2026-01-17 20:32:18'),
(9843,2,2,1,'Kinsington-External-1.jpg','image/jpeg','image',NULL,6612,4414,6218596,NULL,NULL,NULL,'2026-01-17 20:33:14','2026-01-17 20:33:14','2026-01-17 20:33:14'),
(9846,2,2,1,'Kinsington-External-1_2026-01-17-203343_ffjh.jpg','image/jpeg','image',NULL,6612,4414,6218596,NULL,NULL,NULL,'2026-01-17 20:33:44','2026-01-17 20:33:44','2026-01-17 20:33:44'),
(9852,2,2,1,'Kinsington-External-1_2026-01-17-203432_vjah.jpg','image/jpeg','image',NULL,6612,4414,6218596,NULL,NULL,NULL,'2026-01-17 20:34:33','2026-01-17 20:34:33','2026-01-17 20:34:33'),
(9859,2,2,1,'Kinsington-dining-Room.jpg','image/jpeg','image',NULL,6503,4333,5200018,NULL,NULL,NULL,'2026-01-17 20:35:19','2026-01-17 20:35:19','2026-01-17 20:35:19'),
(9860,2,2,1,'Kinsington-External-1_2026-01-17-203521_igkc.jpg','image/jpeg','image',NULL,6612,4414,6218596,NULL,NULL,NULL,'2026-01-17 20:35:22','2026-01-17 20:35:22','2026-01-17 20:35:22'),
(9861,2,2,1,'Kinsington-External-2.jpg','image/jpeg','image',NULL,6604,4404,5803175,NULL,NULL,NULL,'2026-01-17 20:35:25','2026-01-17 20:35:25','2026-01-17 20:35:25'),
(9862,2,2,1,'Kinsington-External-3.jpg','image/jpeg','image',NULL,6553,4369,6019951,NULL,NULL,NULL,'2026-01-17 20:35:28','2026-01-17 20:35:28','2026-01-17 20:35:28'),
(9864,2,2,1,'Kinsington-Gym-1.jpg','image/jpeg','image',NULL,6381,4254,4141739,NULL,NULL,NULL,'2026-01-17 20:35:30','2026-01-17 20:35:30','2026-01-17 20:35:30'),
(9865,2,2,1,'Kinsington-Gym-2.jpg','image/jpeg','image',NULL,6279,4186,3483573,NULL,NULL,NULL,'2026-01-17 20:35:33','2026-01-17 20:35:33','2026-01-17 20:35:33'),
(9866,2,2,1,'Kinsington-Lobby-2_2026-01-17-203537_mjxm.jpg','image/jpeg','image',NULL,6747,4499,16778427,NULL,NULL,NULL,'2026-01-17 20:35:38','2026-01-17 20:35:38','2026-01-17 20:35:38'),
(9868,2,2,1,'Kinsington-Lobby.jpg','image/jpeg','image',NULL,6741,4505,17085312,NULL,NULL,NULL,'2026-01-17 20:35:42','2026-01-17 20:35:42','2026-01-17 20:35:42'),
(9869,2,2,1,'Kinsington-Room-1.jpg','image/jpeg','image',NULL,6429,4286,4629216,NULL,NULL,NULL,'2026-01-17 20:35:44','2026-01-17 20:35:44','2026-01-17 20:35:44'),
(9870,2,2,1,'Kinsington-Room-2.jpg','image/jpeg','image',NULL,6726,4486,15082439,NULL,NULL,NULL,'2026-01-17 20:35:48','2026-01-17 20:35:48','2026-01-17 20:35:48'),
(9871,2,2,1,'Kinsington-Room-3.jpg','image/jpeg','image',NULL,6734,4488,15935013,NULL,NULL,NULL,'2026-01-17 20:35:52','2026-01-17 20:35:52','2026-01-17 20:35:52'),
(9872,2,2,1,'Kinsington-Room-4.jpg','image/jpeg','image',NULL,6744,4493,14665365,NULL,NULL,NULL,'2026-01-17 20:35:55','2026-01-17 20:35:56','2026-01-17 20:35:56'),
(9873,2,2,1,'Kinsington-Room-5.jpg','image/jpeg','image',NULL,6728,4496,14863179,NULL,NULL,NULL,'2026-01-17 20:35:59','2026-01-17 20:35:59','2026-01-17 20:35:59'),
(9874,2,2,1,'Kinsington-Room-6.jpg','image/jpeg','image',NULL,6722,4488,15694731,NULL,NULL,NULL,'2026-01-17 20:36:03','2026-01-17 20:36:03','2026-01-17 20:36:03'),
(9876,2,2,1,'Kinsington-Sitting-area.jpg','image/jpeg','image',NULL,6755,4504,15888608,NULL,NULL,NULL,'2026-01-17 20:36:11','2026-01-17 20:36:11','2026-01-17 20:36:11'),
(9901,2,2,1,'Nazareth-External-2.jpg','image/jpeg','image',NULL,6525,4350,7677198,NULL,NULL,NULL,'2026-01-17 20:44:23','2026-01-17 20:44:23','2026-01-17 20:44:23'),
(9903,2,2,1,'Nazareth-External-1.jpg','image/jpeg','image',NULL,6433,4302,5249172,NULL,NULL,NULL,'2026-01-17 20:44:37','2026-01-17 20:44:37','2026-01-17 20:44:37'),
(9904,2,2,1,'Nazareth-External-2_2026-01-17-204439_rkzj.jpg','image/jpeg','image',NULL,6525,4350,7677198,NULL,NULL,NULL,'2026-01-17 20:44:40','2026-01-17 20:44:40','2026-01-17 20:44:40'),
(9905,2,2,1,'Nazareth-External-3.jpg','image/jpeg','image',NULL,6597,4412,7338207,NULL,NULL,NULL,'2026-01-17 20:44:43','2026-01-17 20:44:43','2026-01-17 20:44:43'),
(9906,2,2,1,'Nazareth-External-4.jpg','image/jpeg','image',NULL,6630,4422,7812700,NULL,NULL,NULL,'2026-01-17 20:44:46','2026-01-17 20:44:46','2026-01-17 20:44:46'),
(9907,2,2,1,'Nazareth-Family-Room-1.jpg','image/jpeg','image',NULL,6662,4452,5593954,NULL,NULL,NULL,'2026-01-17 20:44:48','2026-01-17 20:44:49','2026-01-17 20:44:49'),
(9908,2,2,1,'Nazareth-Family-Room-2.jpg','image/jpeg','image',NULL,6636,4426,5340714,NULL,NULL,NULL,'2026-01-17 20:44:51','2026-01-17 20:44:51','2026-01-17 20:44:51'),
(9909,2,2,1,'Nazareth-Family-Room-3.jpg','image/jpeg','image',NULL,6637,4441,5631099,NULL,NULL,NULL,'2026-01-17 20:44:54','2026-01-17 20:44:54','2026-01-17 20:44:54'),
(9910,2,2,1,'Nazareth-Gym-1.jpg','image/jpeg','image',NULL,6587,4408,4723588,NULL,NULL,NULL,'2026-01-17 20:44:56','2026-01-17 20:44:56','2026-01-17 20:44:56'),
(9911,2,2,1,'Nazareth-Gym-2.jpg','image/jpeg','image',NULL,4338,6509,5380884,NULL,NULL,NULL,'2026-01-17 20:44:59','2026-01-17 20:44:59','2026-01-17 20:44:59'),
(9912,2,2,1,'Nazareth-Gym-3.jpg','image/jpeg','image',NULL,6641,4435,5356854,NULL,NULL,NULL,'2026-01-17 20:45:01','2026-01-17 20:45:01','2026-01-17 20:45:01'),
(9913,2,2,1,'Nazareth-Room-1.jpg','image/jpeg','image',NULL,6319,4214,4549385,NULL,NULL,NULL,'2026-01-17 20:45:04','2026-01-17 20:45:04','2026-01-17 20:45:04'),
(9914,2,2,1,'Nazareth-Room-2.jpg','image/jpeg','image',NULL,6634,4423,5266516,NULL,NULL,NULL,'2026-01-17 20:45:07','2026-01-17 20:45:07','2026-01-17 20:45:07'),
(9915,2,2,1,'Nazareth-Room.jpg','image/jpeg','image',NULL,6613,4414,5039919,NULL,NULL,NULL,'2026-01-17 20:45:10','2026-01-17 20:45:10','2026-01-17 20:45:10'),
(9947,2,2,1,'St.-Marys-Lobby-2.jpg','image/jpeg','image',NULL,6627,4428,6118582,NULL,NULL,NULL,'2026-01-17 20:54:19','2026-01-17 20:54:19','2026-01-17 20:54:19'),
(9949,2,2,1,'367A5155.jpg','image/jpeg','image',NULL,6722,4482,14367097,NULL,NULL,NULL,'2026-01-17 20:54:44','2026-01-17 20:54:44','2026-01-17 20:54:44'),
(9950,2,2,1,'St.-Marys-External-1.jpg','image/jpeg','image',NULL,6564,4376,5738138,NULL,NULL,NULL,'2026-01-17 20:54:47','2026-01-17 20:54:47','2026-01-17 20:54:47'),
(9951,2,2,1,'St.-Marys-External-4.jpg','image/jpeg','image',NULL,6424,4283,5305430,NULL,NULL,NULL,'2026-01-17 20:54:50','2026-01-17 20:54:50','2026-01-17 20:54:50'),
(9952,2,2,1,'St.-Marys-External-5.jpg','image/jpeg','image',NULL,6596,4397,6604373,NULL,NULL,NULL,'2026-01-17 20:54:53','2026-01-17 20:54:53','2026-01-17 20:54:53'),
(9953,2,2,1,'St.-Marys-Gym-1.jpg','image/jpeg','image',NULL,6737,4496,15524012,NULL,NULL,NULL,'2026-01-17 20:54:57','2026-01-17 20:54:57','2026-01-17 20:54:57'),
(9954,2,2,1,'St.-Marys-Gym-2.jpg','image/jpeg','image',NULL,6722,4483,15150966,NULL,NULL,NULL,'2026-01-17 20:55:01','2026-01-17 20:55:01','2026-01-17 20:55:01'),
(9956,2,2,1,'St.-Marys-Gym-3.jpg','image/jpeg','image',NULL,6724,4482,13830605,NULL,NULL,NULL,'2026-01-17 20:55:05','2026-01-17 20:55:05','2026-01-17 20:55:05'),
(9957,2,2,1,'St.-Marys-Lobby-1.jpg','image/jpeg','image',NULL,6631,4425,5687232,NULL,NULL,NULL,'2026-01-17 20:55:07','2026-01-17 20:55:08','2026-01-17 20:55:08'),
(9958,2,2,1,'St.-Marys-Lobby-2_2026-01-17-205510_oirh.jpg','image/jpeg','image',NULL,6627,4428,6118582,NULL,NULL,NULL,'2026-01-17 20:55:10','2026-01-17 20:55:10','2026-01-17 20:55:10'),
(9959,2,2,1,'St.-Marys-Room-1.jpg','image/jpeg','image',NULL,6643,4438,4000230,NULL,NULL,NULL,'2026-01-17 20:55:13','2026-01-17 20:55:13','2026-01-17 20:55:13'),
(9960,2,2,1,'St.-Marys-Room-2.jpg','image/jpeg','image',NULL,6740,4496,15985447,NULL,NULL,NULL,'2026-01-17 20:55:17','2026-01-17 20:55:17','2026-01-17 20:55:17'),
(9962,2,2,1,'St.-Marys-Room-3.jpg','image/jpeg','image',NULL,6741,4486,15576014,NULL,NULL,NULL,'2026-01-17 20:55:22','2026-01-17 20:55:22','2026-01-17 20:55:22'),
(9971,2,2,1,'Maple-Grove-External-5.jpg','image/jpeg','image',NULL,6596,4397,6604373,NULL,NULL,NULL,'2026-01-17 20:57:56','2026-01-17 20:57:56','2026-01-17 20:57:56'),
(9972,2,2,1,'Maple-Grove-External-6.jpg','image/jpeg','image',NULL,6564,4376,5738138,NULL,NULL,NULL,'2026-01-17 20:57:59','2026-01-17 20:57:59','2026-01-17 20:57:59'),
(9973,2,2,1,'Maple-Grove-External-7.jpg','image/jpeg','image',NULL,6424,4283,5305430,NULL,NULL,NULL,'2026-01-17 20:58:01','2026-01-17 20:58:02','2026-01-17 20:58:02'),
(9989,2,2,1,'Glendale-Sitting-Area.jpg','image/jpeg','image',NULL,6726,4483,14858331,NULL,NULL,NULL,'2026-01-17 21:04:31','2026-01-17 21:04:31','2026-01-17 21:04:31'),
(9994,2,2,1,'glendale-out-side.jpg','image/jpeg','image',NULL,1000,666,123357,NULL,NULL,NULL,'2026-01-17 21:05:40','2026-01-17 21:05:40','2026-01-17 21:05:40'),
(9997,2,2,1,'Glendale-Patio-1.jpg','image/jpeg','image',NULL,6589,4393,5925603,NULL,NULL,NULL,'2026-01-17 21:06:15','2026-01-17 21:06:15','2026-01-17 21:06:15'),
(10000,2,2,1,'Glendale-Room-1.jpg','image/jpeg','image',NULL,6616,4411,4826177,NULL,NULL,NULL,'2026-01-17 21:06:37','2026-01-17 21:06:38','2026-01-17 21:06:38'),
(10004,2,2,1,'Glendale-Dining-1.jpg','image/jpeg','image',NULL,6407,4273,4949476,NULL,NULL,NULL,'2026-01-17 21:07:04','2026-01-17 21:07:04','2026-01-17 21:07:04'),
(10005,2,2,1,'Glendale-Dining-2.jpg','image/jpeg','image',NULL,6480,4286,4978087,NULL,NULL,NULL,'2026-01-17 21:07:07','2026-01-17 21:07:07','2026-01-17 21:07:07'),
(10006,2,2,1,'Glendale-Dining-3.jpg','image/jpeg','image',NULL,6720,4481,15374976,NULL,NULL,NULL,'2026-01-17 21:07:11','2026-01-17 21:07:11','2026-01-17 21:07:11'),
(10007,2,2,1,'Glendale-Dining-4.jpg','image/jpeg','image',NULL,6727,4489,14539828,NULL,NULL,NULL,'2026-01-17 21:07:14','2026-01-17 21:07:15','2026-01-17 21:07:15'),
(10009,2,2,1,'Glendale-Gym-1.jpg','image/jpeg','image',NULL,6720,4480,14810539,NULL,NULL,NULL,'2026-01-17 21:07:18','2026-01-17 21:07:18','2026-01-17 21:07:18'),
(10010,2,2,1,'Glendale-Gym-2.jpg','image/jpeg','image',NULL,6725,4486,14937171,NULL,NULL,NULL,'2026-01-17 21:07:22','2026-01-17 21:07:22','2026-01-17 21:07:22'),
(10012,2,2,1,'Glendale-Hallway.jpg','image/jpeg','image',NULL,6720,4480,15835983,NULL,NULL,NULL,'2026-01-17 21:07:26','2026-01-17 21:07:26','2026-01-17 21:07:26'),
(10013,2,2,1,'Glendale-Patio-1_2026-01-17-210728_ehto.jpg','image/jpeg','image',NULL,6589,4393,5925603,NULL,NULL,NULL,'2026-01-17 21:07:29','2026-01-17 21:07:29','2026-01-17 21:07:29'),
(10014,2,2,1,'Glendale-Patio-2.jpg','image/jpeg','image',NULL,6604,4402,7099176,NULL,NULL,NULL,'2026-01-17 21:07:32','2026-01-17 21:07:32','2026-01-17 21:07:32'),
(10015,2,2,1,'Glendale-Patio-3.jpg','image/jpeg','image',NULL,6652,4434,6356390,NULL,NULL,NULL,'2026-01-17 21:07:34','2026-01-17 21:07:34','2026-01-17 21:07:34'),
(10016,2,2,1,'Glendale-Room-1_2026-01-17-210736_tmow.jpg','image/jpeg','image',NULL,6616,4411,4826177,NULL,NULL,NULL,'2026-01-17 21:07:37','2026-01-17 21:07:37','2026-01-17 21:07:37'),
(10018,2,2,1,'Glendale-Room-2.jpg','image/jpeg','image',NULL,6647,4431,5035499,NULL,NULL,NULL,'2026-01-17 21:07:39','2026-01-17 21:07:40','2026-01-17 21:07:40'),
(10019,2,2,1,'Glendale-Room-3.jpg','image/jpeg','image',NULL,6469,4313,4300342,NULL,NULL,NULL,'2026-01-17 21:07:42','2026-01-17 21:07:42','2026-01-17 21:07:42'),
(10020,2,2,1,'Glendale-Sitting-Area_2026-01-17-210745_qpwp.jpg','image/jpeg','image',NULL,6726,4483,14858331,NULL,NULL,NULL,'2026-01-17 21:07:46','2026-01-17 21:07:46','2026-01-17 21:07:46'),
(10041,2,2,1,'KHN-Lobby-3.jpg','image/jpeg','image',NULL,6689,4475,7509542,NULL,NULL,NULL,'2026-01-17 21:15:14','2026-01-17 21:15:14','2026-01-17 21:15:14'),
(10042,2,2,1,'KH-NGym-1.jpg','image/jpeg','image',NULL,6720,4480,6757245,NULL,NULL,NULL,'2026-01-17 21:15:32','2026-01-17 21:15:33','2026-01-17 21:15:33'),
(10043,2,2,1,'KH-NGym-2.jpg','image/jpeg','image',NULL,6720,4480,7618528,NULL,NULL,NULL,'2026-01-17 21:15:35','2026-01-17 21:15:36','2026-01-17 21:15:36'),
(10044,2,2,1,'KHN-Dining-room-1.jpg','image/jpeg','image',NULL,6723,4483,16720799,NULL,NULL,NULL,'2026-01-17 21:15:40','2026-01-17 21:15:40','2026-01-17 21:15:40'),
(10045,2,2,1,'KHN-Dining-room-2.jpg','image/jpeg','image',NULL,6771,4502,16535312,NULL,NULL,NULL,'2026-01-17 21:15:44','2026-01-17 21:15:44','2026-01-17 21:15:44'),
(10046,2,2,1,'KHN-Double-Room-1.jpg','image/jpeg','image',NULL,6478,4316,4834111,NULL,NULL,NULL,'2026-01-17 21:15:47','2026-01-17 21:15:47','2026-01-17 21:15:47'),
(10047,2,2,1,'KHN-Double-Room-2.jpg','image/jpeg','image',NULL,6636,4424,5477466,NULL,NULL,NULL,'2026-01-17 21:15:50','2026-01-17 21:15:50','2026-01-17 21:15:50'),
(10048,2,2,1,'KHN-Double-Room-3.jpg','image/jpeg','image',NULL,6725,4492,16097405,NULL,NULL,NULL,'2026-01-17 21:15:54','2026-01-17 21:15:55','2026-01-17 21:15:55'),
(10049,2,2,1,'KHN-External-1.jpg','image/jpeg','image',NULL,6639,4426,7595356,NULL,NULL,NULL,'2026-01-17 21:15:57','2026-01-17 21:15:57','2026-01-17 21:15:57'),
(10050,2,2,1,'KHN-External-2.jpg','image/jpeg','image',NULL,6720,4469,7227424,NULL,NULL,NULL,'2026-01-17 21:16:00','2026-01-17 21:16:00','2026-01-17 21:16:00'),
(10051,2,2,1,'KHN-Lobby-1.jpg','image/jpeg','image',NULL,6687,4414,7801206,NULL,NULL,NULL,'2026-01-17 21:16:03','2026-01-17 21:16:03','2026-01-17 21:16:03'),
(10052,2,2,1,'KHN-Lobby-2.jpg','image/jpeg','image',NULL,6720,4414,6363662,NULL,NULL,NULL,'2026-01-17 21:16:06','2026-01-17 21:16:06','2026-01-17 21:16:06'),
(10053,2,2,1,'KHN-Lobby-3_2026-01-17-211608_cqaz.jpg','image/jpeg','image',NULL,6689,4475,7509542,NULL,NULL,NULL,'2026-01-17 21:16:09','2026-01-17 21:16:09','2026-01-17 21:16:09'),
(10054,2,2,1,'KHN-Lobby-4.jpg','image/jpeg','image',NULL,6687,4458,5609183,NULL,NULL,NULL,'2026-01-17 21:16:12','2026-01-17 21:16:12','2026-01-17 21:16:12'),
(10055,2,2,1,'KHN-Lobby-5.jpg','image/jpeg','image',NULL,6675,4450,5978379,NULL,NULL,NULL,'2026-01-17 21:16:15','2026-01-17 21:16:15','2026-01-17 21:16:15'),
(10056,2,2,1,'KHN-Patio-1.jpg','image/jpeg','image',NULL,6588,4447,7570607,NULL,NULL,NULL,'2026-01-17 21:16:19','2026-01-17 21:16:19','2026-01-17 21:16:19'),
(10057,2,2,1,'KHN-Patio-2.jpg','image/jpeg','image',NULL,6687,4425,9926501,NULL,NULL,NULL,'2026-01-17 21:16:23','2026-01-17 21:16:23','2026-01-17 21:16:23'),
(10058,2,2,1,'KHN-Patio-3.jpg','image/jpeg','image',NULL,6676,4436,10133335,NULL,NULL,NULL,'2026-01-17 21:16:26','2026-01-17 21:16:26','2026-01-17 21:16:26'),
(10059,2,2,1,'KHN-Single-Room-1.jpg','image/jpeg','image',NULL,6720,4480,16548433,NULL,NULL,NULL,'2026-01-17 21:16:34','2026-01-17 21:16:34','2026-01-17 21:16:34'),
(10060,2,2,1,'KHN-Single-Room-2.jpg','image/jpeg','image',NULL,6720,4480,6400625,NULL,NULL,NULL,'2026-01-17 21:16:37','2026-01-17 21:16:38','2026-01-17 21:16:38'),
(10061,2,2,1,'KHN-Single-Room-3.jpg','image/jpeg','image',NULL,6720,4480,15528656,NULL,NULL,NULL,'2026-01-17 21:16:42','2026-01-17 21:16:42','2026-01-17 21:16:42'),
(10062,2,2,1,'KHN-Single-Room-4.jpg','image/jpeg','image',NULL,6720,4480,15091833,NULL,NULL,NULL,'2026-01-17 21:16:46','2026-01-17 21:16:46','2026-01-17 21:16:46'),
(10069,2,2,1,'KHS-External-1.jpg','image/jpeg','image',NULL,6723,4483,13308997,NULL,NULL,NULL,'2026-01-17 21:26:29','2026-01-17 21:26:29','2026-01-17 21:26:29'),
(10070,2,2,1,'KHS-Dining-Room-1.jpg','image/jpeg','image',NULL,6729,4492,16208613,NULL,NULL,NULL,'2026-01-17 21:27:05','2026-01-17 21:27:06','2026-01-17 21:27:06'),
(10071,2,2,1,'KHS-Dining-Room-2.jpg','image/jpeg','image',NULL,6720,4480,15408751,NULL,NULL,NULL,'2026-01-17 21:27:09','2026-01-17 21:27:10','2026-01-17 21:27:10'),
(10072,2,2,1,'KHS-External-1_2026-01-17-212712_uics.jpg','image/jpeg','image',NULL,6723,4483,13308997,NULL,NULL,NULL,'2026-01-17 21:27:13','2026-01-17 21:27:14','2026-01-17 21:27:14'),
(10073,2,2,1,'KHS-Lobby-1.jpg','image/jpeg','image',NULL,6720,4480,16626235,NULL,NULL,NULL,'2026-01-17 21:27:17','2026-01-17 21:27:18','2026-01-17 21:27:18'),
(10074,2,2,1,'KHS-Lobby-2.jpg','image/jpeg','image',NULL,6720,4480,16769402,NULL,NULL,NULL,'2026-01-17 21:27:22','2026-01-17 21:27:22','2026-01-17 21:27:22'),
(10075,2,2,1,'KHS-Room-1.jpg','image/jpeg','image',NULL,6720,4480,15782952,NULL,NULL,NULL,'2026-01-17 21:27:26','2026-01-17 21:27:26','2026-01-17 21:27:26'),
(10076,2,2,1,'KHS-Room-2.jpg','image/jpeg','image',NULL,6720,4480,17106775,NULL,NULL,NULL,'2026-01-17 21:27:31','2026-01-17 21:27:31','2026-01-17 21:27:31'),
(10077,2,2,1,'KHS-Dining-Room-3.jpg','image/jpeg','image',NULL,6665,4458,5861304,NULL,NULL,NULL,'2026-01-17 21:30:25','2026-01-17 21:30:25','2026-01-17 21:30:25'),
(10078,2,2,1,'KHS-Dining-Room-4.jpg','image/jpeg','image',NULL,6627,4405,5486547,NULL,NULL,NULL,'2026-01-17 21:30:27','2026-01-17 21:30:27','2026-01-17 21:30:27'),
(10079,2,2,1,'KHS-External-2.jpg','image/jpeg','image',NULL,6639,4426,6749938,NULL,NULL,NULL,'2026-01-17 21:30:30','2026-01-17 21:30:30','2026-01-17 21:30:30'),
(10080,2,2,1,'KHS-Gym.jpg','image/jpeg','image',NULL,6588,4448,5535552,NULL,NULL,NULL,'2026-01-17 21:30:32','2026-01-17 21:30:32','2026-01-17 21:30:32'),
(10083,2,2,1,'Meriden-1.jpg','image/jpeg','image',NULL,6720,4480,5271181,NULL,NULL,NULL,'2026-01-17 21:34:53','2026-01-17 21:34:53','2026-01-17 21:34:53'),
(10084,2,2,1,'Meriden-2.jpg','image/jpeg','image',NULL,6720,4480,5208698,NULL,NULL,NULL,'2026-01-17 21:34:56','2026-01-17 21:34:56','2026-01-17 21:34:56'),
(10085,2,2,1,'Meriden-3.jpg','image/jpeg','image',NULL,6720,4480,5947913,NULL,NULL,NULL,'2026-01-17 21:34:59','2026-01-17 21:34:59','2026-01-17 21:34:59'),
(10086,2,2,1,'Meriden-4.jpg','image/jpeg','image',NULL,4480,6720,6390331,NULL,NULL,NULL,'2026-01-17 21:35:02','2026-01-17 21:35:02','2026-01-17 21:35:02'),
(10087,2,2,1,'Meriden-5.jpg','image/jpeg','image',NULL,4480,6720,5330934,NULL,NULL,NULL,'2026-01-17 21:35:05','2026-01-17 21:35:05','2026-01-17 21:35:05'),
(10088,2,2,1,'Meriden-6.jpg','image/jpeg','image',NULL,6720,4480,6008898,NULL,NULL,NULL,'2026-01-17 21:35:08','2026-01-17 21:35:08','2026-01-17 21:35:08'),
(10089,2,2,1,'Meriden-7.jpg','image/jpeg','image',NULL,6721,4481,6393657,NULL,NULL,NULL,'2026-01-17 21:35:11','2026-01-17 21:35:11','2026-01-17 21:35:11'),
(10090,2,2,1,'Meriden-8.jpg','image/jpeg','image',NULL,6720,4480,5792720,NULL,NULL,NULL,'2026-01-17 21:35:14','2026-01-17 21:35:14','2026-01-17 21:35:14'),
(10094,2,2,1,'the-Boulevard-Rendering.png','image/png','image',NULL,3232,2160,7372168,NULL,NULL,NULL,'2026-01-17 22:01:43','2026-01-17 22:01:43','2026-01-17 22:01:43'),
(10097,2,2,1,'The-Boulevard-Renders_Page_1.jpg','image/jpeg','image',NULL,1851,1918,335545,NULL,NULL,NULL,'2026-01-17 22:05:02','2026-01-17 22:05:02','2026-01-17 22:05:02'),
(10098,2,2,1,'The-Boulevard-Renders_Page_2.jpg','image/jpeg','image',NULL,1866,1943,284081,NULL,NULL,NULL,'2026-01-17 22:05:03','2026-01-17 22:05:03','2026-01-17 22:05:03'),
(10099,2,2,1,'The-Boulevard-Renders_Page_3.jpg','image/jpeg','image',NULL,1884,1869,304026,NULL,NULL,NULL,'2026-01-17 22:05:03','2026-01-17 22:05:03','2026-01-17 22:05:03'),
(10100,2,2,1,'The-Boulevard-Renders_Page_4.jpg','image/jpeg','image',NULL,1889,1914,274124,NULL,NULL,NULL,'2026-01-17 22:05:05','2026-01-17 22:05:05','2026-01-17 22:05:05'),
(10101,2,2,1,'The-Boulevard-Renders_Page_5.jpg','image/jpeg','image',NULL,1862,1953,412561,NULL,NULL,NULL,'2026-01-17 22:05:06','2026-01-17 22:05:06','2026-01-17 22:05:06'),
(10102,2,2,1,'The-Boulevard-Renders_Page_6-edited.jpg','image/jpeg','image',NULL,1865,2159,455933,NULL,NULL,NULL,'2026-01-17 22:05:07','2026-01-17 22:05:07','2026-01-17 22:05:07'),
(10149,3,3,1,'Harborage.pdf','application/pdf','pdf',NULL,NULL,NULL,1060076,NULL,NULL,NULL,'2026-01-18 17:31:12','2026-01-18 17:31:12','2026-01-18 17:31:12'),
(10152,3,3,1,'Regent.pdf','application/pdf','pdf',NULL,NULL,NULL,933990,NULL,NULL,NULL,'2026-01-18 17:32:57','2026-01-18 17:32:57','2026-01-18 17:32:57'),
(10158,3,3,1,'HC_January2026.pdf','application/pdf','pdf',NULL,NULL,NULL,183466,NULL,NULL,NULL,'2026-01-18 17:47:19','2026-01-18 17:47:19','2026-01-18 17:47:19'),
(10161,3,3,1,'KHN_January2026.pdf','application/pdf','pdf',NULL,NULL,NULL,440193,NULL,NULL,NULL,'2026-01-18 17:47:55','2026-01-18 17:47:55','2026-01-18 17:47:55'),
(10164,3,3,1,'KHS_January2026.pdf','application/pdf','pdf',NULL,NULL,NULL,498981,NULL,NULL,NULL,'2026-01-18 17:48:12','2026-01-18 17:48:12','2026-01-18 17:48:12'),
(10167,3,3,1,'Boulevard_January2026.pdf','application/pdf','pdf',NULL,NULL,NULL,544371,NULL,NULL,NULL,'2026-01-18 17:50:17','2026-01-18 17:50:17','2026-01-18 17:50:17'),
(10209,2,2,1,'367A4203.jpg','image/jpeg','image',NULL,6720,4480,14439932,NULL,NULL,NULL,'2026-01-18 18:51:34','2026-01-18 18:51:34','2026-01-18 18:51:34'),
(10210,2,2,1,'Glendale-West-External-4.jpg','image/jpeg','image',NULL,6681,4448,8767471,NULL,NULL,NULL,'2026-01-18 18:55:31','2026-01-18 18:55:31','2026-01-18 18:55:31'),
(10213,2,2,1,'Glendale-West-External-2.jpg','image/jpeg','image',NULL,6698,4461,8589064,NULL,NULL,NULL,'2026-01-18 18:56:47','2026-01-18 18:56:47','2026-01-18 18:56:47'),
(10216,2,2,1,'Care-Age-Family-Room_2026-01-18-185919_oyzh.jpg','image/jpeg','image',NULL,6207,4138,4884770,NULL,NULL,NULL,'2026-01-18 18:59:20','2026-01-18 18:59:20','2026-01-18 18:59:20'),
(10219,2,2,1,'Wall-Lobby-4.jpg','image/jpeg','image',NULL,6577,4380,5931851,NULL,NULL,NULL,'2026-01-18 19:14:48','2026-01-18 19:14:48','2026-01-18 19:14:48'),
(10220,2,2,1,'Wall-Bedroom.jpg','image/jpeg','image',NULL,6591,4408,4166604,NULL,NULL,NULL,'2026-01-18 19:15:00','2026-01-18 19:15:00','2026-01-18 19:15:00'),
(10221,2,2,1,'Wall-Dining-2.jpg','image/jpeg','image',NULL,6656,4423,6064751,NULL,NULL,NULL,'2026-01-18 19:15:05','2026-01-18 19:15:06','2026-01-18 19:15:06'),
(10222,2,2,1,'Wall-Dining-3.jpg','image/jpeg','image',NULL,6633,4422,5177037,NULL,NULL,NULL,'2026-01-18 19:15:10','2026-01-18 19:15:10','2026-01-18 19:15:10'),
(10223,2,2,1,'Wall-Exterior-2.jpg','image/jpeg','image',NULL,4032,3024,2840309,NULL,NULL,NULL,'2026-01-18 19:15:15','2026-01-18 19:15:15','2026-01-18 19:15:15'),
(10224,2,2,1,'Wall-Exterior.jpg','image/jpeg','image',NULL,6329,4480,8016123,NULL,NULL,NULL,'2026-01-18 19:15:30','2026-01-18 19:15:30','2026-01-18 19:15:30'),
(10225,2,2,1,'Wall-Lobby-1.jpg','image/jpeg','image',NULL,6638,4423,6501476,NULL,NULL,NULL,'2026-01-18 19:15:35','2026-01-18 19:15:36','2026-01-18 19:15:36'),
(10226,2,2,1,'Wall-Lobby-2.jpg','image/jpeg','image',NULL,6666,4394,6686509,NULL,NULL,NULL,'2026-01-18 19:15:43','2026-01-18 19:15:43','2026-01-18 19:15:43'),
(10227,2,2,1,'Wall-Lobby-3.jpg','image/jpeg','image',NULL,6602,4423,5779616,NULL,NULL,NULL,'2026-01-18 19:15:49','2026-01-18 19:15:49','2026-01-18 19:15:49'),
(10228,2,2,1,'Wall-Lobby-4_2026-01-18-191554_otvn.jpg','image/jpeg','image',NULL,6577,4380,5931851,NULL,NULL,NULL,'2026-01-18 19:15:54','2026-01-18 19:15:55','2026-01-18 19:15:55'),
(10229,2,2,1,'Wall-Lobby-5.jpg','image/jpeg','image',NULL,6620,4462,6571362,NULL,NULL,NULL,'2026-01-18 19:16:03','2026-01-18 19:16:03','2026-01-18 19:16:03'),
(10230,2,2,1,'Wall-PT-1.jpg','image/jpeg','image',NULL,6670,4430,4619216,NULL,NULL,NULL,'2026-01-18 19:16:07','2026-01-18 19:16:07','2026-01-18 19:16:07'),
(10231,2,2,1,'Wall-PT-2.jpg','image/jpeg','image',NULL,6620,4394,7427341,NULL,NULL,NULL,'2026-01-18 19:16:16','2026-01-18 19:16:16','2026-01-18 19:16:16'),
(10232,2,2,1,'Wall-PT-3.jpg','image/jpeg','image',NULL,6677,4411,6571085,NULL,NULL,NULL,'2026-01-18 19:16:22','2026-01-18 19:16:22','2026-01-18 19:16:22'),
(10233,2,2,1,'Wall-Rehab-Gym-2.jpg','image/jpeg','image',NULL,6322,4480,7840630,NULL,NULL,NULL,'2026-01-18 19:16:29','2026-01-18 19:16:29','2026-01-18 19:16:29'),
(10234,2,2,1,'Wall-Rehab-Gym.jpg','image/jpeg','image',NULL,6720,4480,12114391,NULL,NULL,NULL,'2026-01-18 19:16:42','2026-01-18 19:16:42','2026-01-18 19:16:42'),
(10235,2,2,1,'Wall-Room-1.jpg','image/jpeg','image',NULL,4480,6720,13660188,NULL,NULL,NULL,'2026-01-18 19:16:53','2026-01-18 19:16:53','2026-01-18 19:16:53'),
(10236,2,2,1,'Wall-Room-2.jpg','image/jpeg','image',NULL,6727,4487,16168597,NULL,NULL,NULL,'2026-01-18 19:17:06','2026-01-18 19:17:06','2026-01-18 19:17:06'),
(10237,2,2,1,'Wall-Room-3.jpg','image/jpeg','image',NULL,6720,4480,12707054,NULL,NULL,NULL,'2026-01-18 19:17:16','2026-01-18 19:17:16','2026-01-18 19:17:16'),
(10238,2,2,1,'Wall-Room-4.jpg','image/jpeg','image',NULL,6724,4485,16688061,NULL,NULL,NULL,'2026-01-18 19:17:29','2026-01-18 19:17:29','2026-01-18 19:17:29'),
(10239,2,2,1,'Wall-Room-5.jpg','image/jpeg','image',NULL,4480,6720,13771968,NULL,NULL,NULL,'2026-01-18 19:17:40','2026-01-18 19:17:40','2026-01-18 19:17:40'),
(10240,2,2,1,'Wall-Room.jpg','image/jpeg','image',NULL,6727,4486,15492139,NULL,NULL,NULL,'2026-01-18 19:17:53','2026-01-18 19:17:53','2026-01-18 19:17:53'),
(10247,2,2,1,'Middlebury-2.jpg','image/jpeg','image',NULL,6720,4480,16627798,NULL,NULL,NULL,'2026-01-18 19:29:59','2026-01-18 19:29:59','2026-01-18 19:29:59'),
(10248,2,2,1,'Middlebury-1.jpg','image/jpeg','image',NULL,6648,4451,6843827,NULL,NULL,NULL,'2026-01-18 19:30:40','2026-01-18 19:30:40','2026-01-18 19:30:40'),
(10249,2,2,1,'Middlebury-1_2026-01-18-193139_qryk.jpg','image/jpeg','image',NULL,6648,4451,6843827,NULL,NULL,NULL,'2026-01-18 19:31:40','2026-01-18 19:31:40','2026-01-18 19:31:40'),
(10250,2,2,1,'Middlebury-2_2026-01-18-193154_akbi.jpg','image/jpeg','image',NULL,6720,4480,16627798,NULL,NULL,NULL,'2026-01-18 19:31:54','2026-01-18 19:31:55','2026-01-18 19:31:55'),
(10251,2,2,1,'Middlebury-8.jpg','image/jpeg','image',NULL,6720,4480,15349982,NULL,NULL,NULL,'2026-01-18 19:32:07','2026-01-18 19:32:08','2026-01-18 19:32:08'),
(10252,2,2,1,'Middlebury-10.jpg','image/jpeg','image',NULL,6674,4432,6571730,NULL,NULL,NULL,'2026-01-18 19:32:13','2026-01-18 19:32:13','2026-01-18 19:32:13'),
(10410,3,3,1,'Annapolis-1.pdf','application/pdf','pdf',NULL,NULL,NULL,404597,NULL,NULL,NULL,'2026-01-19 16:21:46','2026-01-19 16:21:46','2026-01-19 16:21:46'),
(10426,9,13,1,'NonDiscriminationNotice-Arbors.pdf','application/pdf','pdf',NULL,NULL,NULL,159133,NULL,NULL,NULL,'2026-01-19 16:32:48','2026-01-19 16:32:48','2026-01-19 16:32:48'),
(10428,9,13,1,'Complete-Care-at-Arbors-2024-NJ-Financials.pdf','application/pdf','pdf',NULL,NULL,NULL,404882,NULL,NULL,NULL,'2026-01-19 16:36:18','2026-01-19 16:36:18','2026-01-19 16:36:18'),
(10430,9,13,1,'Arbors-MCR-CR-2024.pdf','application/pdf','pdf',NULL,NULL,NULL,1817732,NULL,NULL,NULL,'2026-01-19 16:36:33','2026-01-19 16:36:34','2026-01-19 16:36:34'),
(10431,9,13,1,'Complete-Care-at-Arbors-2024-Revenues.pdf','application/pdf','pdf',NULL,NULL,NULL,68231,NULL,NULL,NULL,'2026-01-19 16:36:45','2026-01-19 16:36:45','2026-01-19 16:36:45'),
(10432,3,3,1,'Wheaton-Jan26.pdf','application/pdf','pdf',NULL,NULL,NULL,169627,NULL,NULL,NULL,'2026-01-19 16:37:28','2026-01-19 16:37:28','2026-01-19 16:37:28'),
(10437,4,4,1,'AlyssaFrancese-1.jpg','image/jpeg','image',NULL,1080,1080,248866,NULL,NULL,NULL,'2026-01-19 17:15:09','2026-01-19 17:15:09','2026-01-19 17:15:09'),
(10460,3,3,1,'Complete-Care-at-Margate-Park_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,692109,NULL,NULL,NULL,'2026-01-19 18:47:02','2026-01-19 18:47:02','2026-01-19 18:47:02'),
(10463,3,3,1,'Complete-Care-at-Sheridan-Commons_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,693634,NULL,NULL,NULL,'2026-01-19 18:52:53','2026-01-19 18:52:53','2026-01-19 18:52:53'),
(10466,3,3,1,'Complete-Care-at-The-Boulevard_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,682304,NULL,NULL,NULL,'2026-01-19 18:54:34','2026-01-19 18:54:34','2026-01-19 18:54:34'),
(10469,8,10,1,'Complete-Care-Terms-of-Service.pdf',NULL,'pdf',NULL,NULL,NULL,93180,NULL,NULL,NULL,'2026-01-19 19:11:45','2026-01-19 19:11:45','2026-01-19 19:11:45'),
(10474,3,3,1,'CC-Berkshire_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,829766,NULL,NULL,NULL,'2026-01-19 20:41:52','2026-01-19 20:41:52','2026-01-19 20:41:52'),
(10477,3,3,1,'CC-Berkshire_Clinical-Capabilities-Chart-Flyer_Digital_2026-01-19-204324_wqcz.pdf','application/pdf','pdf',NULL,NULL,NULL,829766,NULL,NULL,NULL,'2026-01-19 20:43:24','2026-01-19 20:43:24','2026-01-19 20:43:24'),
(10478,3,3,1,'CC-Brakeley-Park_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,823275,NULL,NULL,NULL,'2026-01-19 20:43:42','2026-01-19 20:43:42','2026-01-19 20:43:42'),
(10480,3,3,1,'CC-Chestnut-Hill_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,824241,NULL,NULL,NULL,'2026-01-19 20:44:12','2026-01-19 20:44:12','2026-01-19 20:44:12'),
(10483,3,3,1,'CC-Fair-Lawn-Edge_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,836434,NULL,NULL,NULL,'2026-01-19 20:44:52','2026-01-19 20:44:52','2026-01-19 20:44:52'),
(10486,3,3,1,'CC-Hamilton-Plaza_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,837242,NULL,NULL,NULL,'2026-01-19 20:45:21','2026-01-19 20:45:21','2026-01-19 20:45:21'),
(10489,3,3,1,'CC-Harborage_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,851284,NULL,NULL,NULL,'2026-01-19 20:45:50','2026-01-19 20:45:50','2026-01-19 20:45:50'),
(10492,3,3,1,'CC-Harston-Hall_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,827924,NULL,NULL,NULL,'2026-01-19 20:46:19','2026-01-19 20:46:19','2026-01-19 20:46:19'),
(10495,3,3,1,'CC-Inglemoor_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,819134,NULL,NULL,NULL,'2026-01-19 20:46:45','2026-01-19 20:46:45','2026-01-19 20:46:45'),
(10498,3,3,1,'CC-Lehigh_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,825833,NULL,NULL,NULL,'2026-01-19 20:47:09','2026-01-19 20:47:09','2026-01-19 20:47:09'),
(10501,3,3,1,'CC-Milford-Manor_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,817438,NULL,NULL,NULL,'2026-01-19 20:47:36','2026-01-19 20:47:36','2026-01-19 20:47:36'),
(10504,3,3,1,'CC-Phillipsburg_Clinical-Capabilities-Chart-Flyer_Digital.pdf','application/pdf','pdf',NULL,NULL,NULL,812979,NULL,NULL,NULL,'2026-01-19 20:48:02','2026-01-19 20:48:02','2026-01-19 20:48:02'),
(10507,3,3,1,'CC-Arbors_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,193455,NULL,NULL,NULL,'2026-01-19 20:58:52','2026-01-19 20:58:52','2026-01-19 20:58:52'),
(10510,3,3,1,'CC-Arbors_Clinical-Capabilities-Chart-Flyer_digital_2026-01-19-205936_akqc.pdf','application/pdf','pdf',NULL,NULL,NULL,193455,NULL,NULL,NULL,'2026-01-19 20:59:36','2026-01-19 20:59:36','2026-01-19 20:59:36'),
(10513,3,3,1,'CC-Brick_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,1360663,NULL,NULL,NULL,'2026-01-19 21:01:16','2026-01-19 21:01:16','2026-01-19 21:01:16'),
(10517,3,3,1,'CC-Bey-Lea_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,1338117,NULL,NULL,NULL,'2026-01-19 21:03:28','2026-01-19 21:03:28','2026-01-19 21:03:28'),
(10522,3,3,1,'CC-Burlington-Woods_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,1352551,NULL,0,0,'2026-01-19 21:07:46','2026-01-19 21:07:46','2026-01-19 21:07:46'),
(10523,3,3,1,'CC-Burlington-Woods_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,1352551,NULL,NULL,NULL,'2026-01-19 21:10:21','2026-01-19 21:10:21','2026-01-19 21:10:21'),
(10526,3,3,1,'CC-Court-House_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,193752,NULL,NULL,NULL,'2026-01-19 21:11:34','2026-01-19 21:11:34','2026-01-19 21:11:34'),
(10529,3,3,1,'CC-Green-Acres_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,193952,NULL,NULL,NULL,'2026-01-19 21:12:13','2026-01-19 21:12:13','2026-01-19 21:12:13'),
(10532,3,3,1,'CC-Holiday-City_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,193450,NULL,NULL,NULL,'2026-01-19 21:12:51','2026-01-19 21:12:51','2026-01-19 21:12:51'),
(10535,3,3,1,'CC-Kresson-View_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,193437,NULL,NULL,NULL,'2026-01-19 21:13:19','2026-01-19 21:13:19','2026-01-19 21:13:19'),
(10538,3,3,1,'CC-Laurelton_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,194155,NULL,NULL,NULL,'2026-01-19 21:13:48','2026-01-19 21:13:48','2026-01-19 21:13:48'),
(10543,3,3,1,'CC-Marcella_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,190445,NULL,NULL,NULL,'2026-01-19 21:14:37','2026-01-19 21:14:37','2026-01-19 21:14:37'),
(10546,3,3,1,'CC-Monmouth_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,190466,NULL,NULL,NULL,'2026-01-19 21:15:11','2026-01-19 21:15:11','2026-01-19 21:15:11'),
(10549,3,3,1,'CC-Ocean-Grove_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,191116,NULL,NULL,NULL,'2026-01-19 21:15:46','2026-01-19 21:15:46','2026-01-19 21:15:46'),
(10553,3,3,1,'CC-Shorrock-Gardens_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,192342,NULL,NULL,NULL,'2026-01-19 21:16:19','2026-01-19 21:16:19','2026-01-19 21:16:19'),
(10557,3,3,1,'CC-Shrewsbury_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,191921,NULL,NULL,NULL,'2026-01-19 21:16:54','2026-01-19 21:16:54','2026-01-19 21:16:54'),
(10560,3,3,1,'CC-Voorhees_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,190773,NULL,NULL,NULL,'2026-01-19 21:17:38','2026-01-19 21:17:38','2026-01-19 21:17:38'),
(10563,3,3,1,'CC-Wall_Clinical-Capabilities-Chart-Flyer_digital.pdf','application/pdf','pdf',NULL,NULL,NULL,190710,NULL,NULL,NULL,'2026-01-19 21:18:09','2026-01-19 21:18:09','2026-01-19 21:18:09'),
(10575,8,10,NULL,'Uzziel_Pepana_USRN_Resume-2.pdf',NULL,'pdf',NULL,NULL,NULL,84006,NULL,NULL,NULL,'2026-01-19 22:40:54','2026-01-19 22:40:54','2026-01-19 22:40:54'),
(11003,2,2,1,'BrakeleyPark_Room_2026-01-20-145214_vldl.jpg','image/jpeg','image',NULL,6721,4482,17426263,NULL,NULL,NULL,'2026-01-20 14:52:15','2026-01-20 14:52:15','2026-01-20 14:52:15'),
(11004,2,2,1,'BrakeleyPark_Room2_2026-01-20-145217_taqf.jpg','image/jpeg','image',NULL,6720,4480,16337533,NULL,NULL,NULL,'2026-01-20 14:52:18','2026-01-20 14:52:18','2026-01-20 14:52:18');
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assets_sites`
--

LOCK TABLES `assets_sites` WRITE;
/*!40000 ALTER TABLE `assets_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `assets_sites` VALUES
(136,1,NULL),
(137,1,NULL),
(138,1,NULL),
(285,1,NULL),
(545,1,NULL),
(548,1,NULL),
(612,1,NULL),
(613,1,NULL),
(614,1,NULL),
(632,1,NULL),
(634,1,NULL),
(2516,1,NULL),
(2594,1,NULL),
(2800,1,NULL),
(2803,1,NULL),
(2806,1,NULL),
(2809,1,NULL),
(2855,1,NULL),
(2856,1,NULL),
(2857,1,NULL),
(2858,1,NULL),
(2869,1,NULL),
(2870,1,NULL),
(2871,1,NULL),
(2872,1,NULL),
(2873,1,NULL),
(2874,1,NULL),
(2877,1,NULL),
(2886,1,NULL),
(2887,1,NULL),
(2888,1,NULL),
(2889,1,NULL),
(2890,1,NULL),
(2927,1,NULL),
(2931,1,NULL),
(2933,1,NULL),
(2934,1,NULL),
(2941,1,NULL),
(2968,1,NULL),
(2970,1,NULL),
(3011,1,NULL),
(3017,1,NULL),
(3018,1,NULL),
(3019,1,NULL),
(3020,1,NULL),
(3021,1,NULL),
(3022,1,NULL),
(3023,1,NULL),
(3048,1,NULL),
(3058,1,NULL),
(3084,1,NULL),
(3090,1,NULL),
(3122,1,NULL),
(3137,1,NULL),
(3158,1,NULL),
(3180,1,NULL),
(3221,1,NULL),
(3235,1,NULL),
(3236,1,NULL),
(3237,1,NULL),
(3238,1,NULL),
(3239,1,NULL),
(3240,1,NULL),
(3241,1,NULL),
(3242,1,NULL),
(3243,1,NULL),
(3244,1,NULL),
(3245,1,NULL),
(3246,1,NULL),
(3247,1,NULL),
(3248,1,NULL),
(3249,1,NULL),
(3250,1,NULL),
(3251,1,NULL),
(3252,1,NULL),
(3253,1,NULL),
(3254,1,NULL),
(3276,1,NULL),
(3278,1,NULL),
(3279,1,NULL),
(3280,1,NULL),
(3281,1,NULL),
(3282,1,NULL),
(3283,1,NULL),
(3362,1,NULL),
(3363,1,NULL),
(3364,1,NULL),
(3365,1,NULL),
(3366,1,NULL),
(3367,1,NULL),
(3368,1,NULL),
(3369,1,NULL),
(3370,1,NULL),
(3371,1,NULL),
(3372,1,NULL),
(3373,1,NULL),
(3374,1,NULL),
(3377,1,NULL),
(3416,1,NULL),
(3418,1,NULL),
(3425,1,NULL),
(3467,1,NULL),
(3494,1,NULL),
(3495,1,NULL),
(3498,1,NULL),
(3530,1,NULL),
(3564,1,NULL),
(3594,1,NULL),
(3623,1,NULL),
(3648,1,NULL),
(3689,1,NULL),
(3712,1,NULL),
(3714,1,NULL),
(3722,1,NULL),
(3746,1,NULL),
(3748,1,NULL),
(3761,1,NULL),
(3800,1,NULL),
(3802,1,NULL),
(3808,1,NULL),
(3856,1,NULL),
(3858,1,NULL),
(3865,1,NULL),
(3896,1,NULL),
(3918,1,NULL),
(3920,1,NULL),
(3927,1,NULL),
(3954,1,NULL),
(3959,1,NULL),
(3981,1,NULL),
(3986,1,NULL),
(4008,1,NULL),
(4010,1,NULL),
(4017,1,NULL),
(4018,1,NULL),
(4020,1,NULL),
(4069,1,NULL),
(4080,1,NULL),
(4083,1,NULL),
(4105,1,NULL),
(4138,1,NULL),
(4141,1,NULL),
(4142,1,NULL),
(4150,1,NULL),
(4172,1,NULL),
(4181,1,NULL),
(4207,1,NULL),
(4208,1,NULL),
(4223,1,NULL),
(4246,1,NULL),
(4276,1,NULL),
(4282,1,NULL),
(4322,1,NULL),
(4349,1,NULL),
(4358,1,NULL),
(4385,1,NULL),
(4414,1,NULL),
(4440,1,NULL),
(4466,1,NULL),
(4497,1,NULL),
(4518,1,NULL),
(4519,1,NULL),
(4526,1,NULL),
(4554,1,NULL),
(4562,1,NULL),
(4579,1,NULL),
(4602,1,NULL),
(4610,1,NULL),
(4620,1,NULL),
(4639,1,NULL),
(4786,1,NULL),
(4806,1,NULL),
(4807,1,NULL),
(4808,1,NULL),
(4809,1,NULL),
(4810,1,NULL),
(4811,1,NULL),
(4815,1,NULL),
(4821,1,NULL),
(4822,1,NULL),
(4823,1,NULL),
(4824,1,NULL),
(4826,1,NULL),
(4827,1,NULL),
(4828,1,NULL),
(4829,1,NULL),
(4834,1,NULL),
(4835,1,NULL),
(4836,1,NULL),
(4837,1,NULL),
(4838,1,NULL),
(4841,1,NULL),
(4842,1,NULL),
(4843,1,NULL),
(4844,1,NULL),
(4845,1,NULL),
(4846,1,NULL),
(4861,1,NULL),
(4879,1,NULL),
(4880,1,NULL),
(4881,1,NULL),
(4882,1,NULL),
(4883,1,NULL),
(4884,1,NULL),
(4885,1,NULL),
(4886,1,NULL),
(4887,1,NULL),
(4888,1,NULL),
(4900,1,NULL),
(4902,1,NULL),
(4909,1,NULL),
(4910,1,NULL),
(4911,1,NULL),
(4914,1,NULL),
(4920,1,NULL),
(4921,1,NULL),
(4922,1,NULL),
(4923,1,NULL),
(4924,1,NULL),
(4927,1,NULL),
(4928,1,NULL),
(4929,1,NULL),
(4930,1,NULL),
(4931,1,NULL),
(4932,1,NULL),
(4933,1,NULL),
(4934,1,NULL),
(4935,1,NULL),
(4944,1,NULL),
(4951,1,NULL),
(4955,1,NULL),
(4956,1,NULL),
(4957,1,NULL),
(4962,1,NULL),
(4973,1,NULL),
(4991,1,NULL),
(4992,1,NULL),
(4993,1,NULL),
(4994,1,NULL),
(4995,1,NULL),
(4996,1,NULL),
(4997,1,NULL),
(5001,1,NULL),
(5003,1,NULL),
(5013,1,NULL),
(5033,1,NULL),
(5034,1,NULL),
(5035,1,NULL),
(5036,1,NULL),
(5037,1,NULL),
(5038,1,NULL),
(5039,1,NULL),
(5040,1,NULL),
(5042,1,NULL),
(5055,1,NULL),
(5056,1,NULL),
(5057,1,NULL),
(5058,1,NULL),
(5067,1,NULL),
(5068,1,NULL),
(5069,1,NULL),
(5084,1,NULL),
(5085,1,NULL),
(5086,1,NULL),
(5087,1,NULL),
(5088,1,NULL),
(5095,1,NULL),
(5096,1,NULL),
(5097,1,NULL),
(5098,1,NULL),
(5105,1,NULL),
(5106,1,NULL),
(5107,1,NULL),
(5108,1,NULL),
(5109,1,NULL),
(5110,1,NULL),
(5111,1,NULL),
(5112,1,NULL),
(5122,1,NULL),
(5123,1,NULL),
(5124,1,NULL),
(5125,1,NULL),
(5127,1,NULL),
(5128,1,NULL),
(5129,1,NULL),
(5130,1,NULL),
(5131,1,NULL),
(5140,1,NULL),
(5146,1,NULL),
(5147,1,NULL),
(5148,1,NULL),
(5149,1,NULL),
(5150,1,NULL),
(5151,1,NULL),
(5152,1,NULL),
(5153,1,NULL),
(5156,1,NULL),
(5158,1,NULL),
(5185,1,NULL),
(5186,1,NULL),
(5187,1,NULL),
(5188,1,NULL),
(5189,1,NULL),
(5190,1,NULL),
(5191,1,NULL),
(5213,1,NULL),
(5233,1,NULL),
(5234,1,NULL),
(5235,1,NULL),
(5236,1,NULL),
(5237,1,NULL),
(5238,1,NULL),
(5239,1,NULL),
(5241,1,NULL),
(5244,1,NULL),
(5253,1,NULL),
(5254,1,NULL),
(5255,1,NULL),
(5256,1,NULL),
(5257,1,NULL),
(5258,1,NULL),
(5277,1,NULL),
(5278,1,NULL),
(5279,1,NULL),
(5280,1,NULL),
(5281,1,NULL),
(5282,1,NULL),
(5292,1,NULL),
(5293,1,NULL),
(5294,1,NULL),
(5680,1,NULL),
(5696,1,NULL),
(5701,1,NULL),
(5709,1,NULL),
(5719,1,NULL),
(5724,1,NULL),
(5730,1,NULL),
(5744,1,NULL),
(5749,1,NULL),
(5755,1,NULL),
(5761,1,NULL),
(5767,1,NULL),
(5773,1,NULL),
(5779,1,NULL),
(5785,1,NULL),
(5791,1,NULL),
(5797,1,NULL),
(5803,1,NULL),
(5809,1,NULL),
(5815,1,NULL),
(5821,1,NULL),
(5827,1,NULL),
(5833,1,NULL),
(5839,1,NULL),
(5845,1,NULL),
(5851,1,NULL),
(5857,1,NULL),
(5863,1,NULL),
(5869,1,NULL),
(5875,1,NULL),
(5881,1,NULL),
(5887,1,NULL),
(5893,1,NULL),
(5899,1,NULL),
(5905,1,NULL),
(5911,1,NULL),
(5917,1,NULL),
(5923,1,NULL),
(5929,1,NULL),
(5935,1,NULL),
(5941,1,NULL),
(5947,1,NULL),
(5953,1,NULL),
(5959,1,NULL),
(5965,1,NULL),
(5971,1,NULL),
(5977,1,NULL),
(5982,1,NULL),
(5987,1,NULL),
(5994,1,NULL),
(6000,1,NULL),
(6006,1,NULL),
(6013,1,NULL),
(6020,1,NULL),
(6026,1,NULL),
(6033,1,NULL),
(6039,1,NULL),
(6045,1,NULL),
(6064,1,NULL),
(6065,1,NULL),
(6074,1,NULL),
(6081,1,NULL),
(6082,1,NULL),
(6090,1,NULL),
(6093,1,NULL),
(6099,1,NULL),
(6105,1,NULL),
(6112,1,NULL),
(6128,1,NULL),
(6130,1,NULL),
(6137,1,NULL),
(6143,1,NULL),
(6156,1,NULL),
(6165,1,NULL),
(6167,1,NULL),
(6173,1,NULL),
(6175,1,NULL),
(6183,1,NULL),
(6185,1,NULL),
(6191,1,NULL),
(6214,1,NULL),
(6216,1,NULL),
(6224,1,NULL),
(6255,1,NULL),
(6258,1,NULL),
(6265,1,NULL),
(6270,1,NULL),
(6279,1,NULL),
(6281,1,NULL),
(6287,1,NULL),
(6292,1,NULL),
(6294,1,NULL),
(6330,1,NULL),
(6341,1,NULL),
(6343,1,NULL),
(6363,1,NULL),
(6422,1,NULL),
(6434,1,NULL),
(6460,1,NULL),
(6519,1,NULL),
(6525,1,NULL),
(6526,1,NULL),
(6527,1,NULL),
(6528,1,NULL),
(6529,1,NULL),
(6530,1,NULL),
(6533,1,NULL),
(6542,1,NULL),
(6548,1,NULL),
(6557,1,NULL),
(6569,1,NULL),
(6598,1,NULL),
(6600,1,NULL),
(6601,1,NULL),
(6602,1,NULL),
(6608,1,NULL),
(6614,1,NULL),
(6620,1,NULL),
(6629,1,NULL),
(6635,1,NULL),
(6636,1,NULL),
(6637,1,NULL),
(6638,1,NULL),
(6639,1,NULL),
(6640,1,NULL),
(6641,1,NULL),
(6659,1,NULL),
(6680,1,NULL),
(6681,1,NULL),
(6682,1,NULL),
(6683,1,NULL),
(6684,1,NULL),
(6685,1,NULL),
(6741,1,NULL),
(6759,1,NULL),
(6760,1,NULL),
(6761,1,NULL),
(6762,1,NULL),
(6763,1,NULL),
(6764,1,NULL),
(6765,1,NULL),
(6766,1,NULL),
(6767,1,NULL),
(6772,1,NULL),
(6792,1,NULL),
(6793,1,NULL),
(6794,1,NULL),
(6795,1,NULL),
(6796,1,NULL),
(6797,1,NULL),
(6801,1,NULL),
(6803,1,NULL),
(6806,1,NULL),
(6808,1,NULL),
(6812,1,NULL),
(6814,1,NULL),
(6818,1,NULL),
(6820,1,NULL),
(6824,1,NULL),
(6826,1,NULL),
(6830,1,NULL),
(6832,1,NULL),
(6835,1,NULL),
(6838,1,NULL),
(6840,1,NULL),
(6844,1,NULL),
(6846,1,NULL),
(6850,1,NULL),
(6852,1,NULL),
(6858,1,NULL),
(6860,1,NULL),
(6864,1,NULL),
(6865,1,NULL),
(6867,1,NULL),
(6872,1,NULL),
(6877,1,NULL),
(6880,1,NULL),
(6882,1,NULL),
(6885,1,NULL),
(6887,1,NULL),
(6889,1,NULL),
(6892,1,NULL),
(6897,1,NULL),
(6899,1,NULL),
(6902,1,NULL),
(6904,1,NULL),
(6907,1,NULL),
(6911,1,NULL),
(6916,1,NULL),
(6918,1,NULL),
(6919,1,NULL),
(6922,1,NULL),
(6925,1,NULL),
(6927,1,NULL),
(6931,1,NULL),
(6934,1,NULL),
(6949,1,NULL),
(6954,1,NULL),
(6964,1,NULL),
(6971,1,NULL),
(6986,1,NULL),
(6991,1,NULL),
(7013,1,NULL),
(7020,1,NULL),
(7033,1,NULL),
(7038,1,NULL),
(7042,1,NULL),
(7068,1,NULL),
(7084,1,NULL),
(7096,1,NULL),
(7126,1,NULL),
(7133,1,NULL),
(7140,1,NULL),
(7151,1,NULL),
(7288,1,NULL),
(7291,1,NULL),
(7299,1,NULL),
(7307,1,NULL),
(7310,1,NULL),
(7314,1,NULL),
(7320,1,NULL),
(7324,1,NULL),
(7328,1,NULL),
(7356,1,NULL),
(7359,1,NULL),
(7365,1,NULL),
(7646,1,NULL),
(7649,1,NULL),
(7652,1,NULL),
(7655,1,NULL),
(7658,1,NULL),
(7661,1,NULL),
(7664,1,NULL),
(7667,1,NULL),
(7670,1,NULL),
(7674,1,NULL),
(7677,1,NULL),
(7680,1,NULL),
(7683,1,NULL),
(7685,1,NULL),
(7689,1,NULL),
(7692,1,NULL),
(7700,1,NULL),
(7707,1,NULL),
(7722,1,NULL),
(7732,1,NULL),
(7739,1,NULL),
(7740,1,NULL),
(7741,1,NULL),
(7772,1,NULL),
(7778,1,NULL),
(7779,1,NULL),
(7780,1,NULL),
(7781,1,NULL),
(7782,1,NULL),
(7783,1,NULL),
(7784,1,NULL),
(7785,1,NULL),
(7791,1,NULL),
(7818,1,NULL),
(7826,1,NULL),
(7827,1,NULL),
(7828,1,NULL),
(7829,1,NULL),
(7830,1,NULL),
(7831,1,NULL),
(7832,1,NULL),
(7833,1,NULL),
(7838,1,NULL),
(7839,1,NULL),
(7840,1,NULL),
(7841,1,NULL),
(7842,1,NULL),
(7847,1,NULL),
(7850,1,NULL),
(7851,1,NULL),
(7852,1,NULL),
(7853,1,NULL),
(7858,1,NULL),
(7859,1,NULL),
(7860,1,NULL),
(7861,1,NULL),
(7862,1,NULL),
(7863,1,NULL),
(7864,1,NULL),
(7868,1,NULL),
(7869,1,NULL),
(7870,1,NULL),
(7871,1,NULL),
(7872,1,NULL),
(7873,1,NULL),
(7874,1,NULL),
(7881,1,NULL),
(7882,1,NULL),
(7883,1,NULL),
(7884,1,NULL),
(7885,1,NULL),
(7886,1,NULL),
(7891,1,NULL),
(7892,1,NULL),
(7893,1,NULL),
(7894,1,NULL),
(7901,1,NULL),
(7908,1,NULL),
(7909,1,NULL),
(7910,1,NULL),
(7911,1,NULL),
(7920,1,NULL),
(7921,1,NULL),
(7922,1,NULL),
(7923,1,NULL),
(7924,1,NULL),
(7925,1,NULL),
(7926,1,NULL),
(7927,1,NULL),
(7928,1,NULL),
(7937,1,NULL),
(7938,1,NULL),
(7939,1,NULL),
(7940,1,NULL),
(7941,1,NULL),
(7950,1,NULL),
(7951,1,NULL),
(7952,1,NULL),
(7953,1,NULL),
(7954,1,NULL),
(7955,1,NULL),
(7956,1,NULL),
(7957,1,NULL),
(7998,1,NULL),
(8017,1,NULL),
(8024,1,NULL),
(8025,1,NULL),
(8026,1,NULL),
(8027,1,NULL),
(8032,1,NULL),
(8033,1,NULL),
(8034,1,NULL),
(8035,1,NULL),
(8036,1,NULL),
(8051,1,NULL),
(8052,1,NULL),
(8053,1,NULL),
(8054,1,NULL),
(8060,1,NULL),
(8061,1,NULL),
(8062,1,NULL),
(8063,1,NULL),
(8064,1,NULL),
(8079,1,NULL),
(8080,1,NULL),
(8081,1,NULL),
(8082,1,NULL),
(8085,1,NULL),
(8086,1,NULL),
(8087,1,NULL),
(8092,1,NULL),
(8093,1,NULL),
(8094,1,NULL),
(8095,1,NULL),
(8104,1,NULL),
(8105,1,NULL),
(8106,1,NULL),
(8107,1,NULL),
(8108,1,NULL),
(8117,1,NULL),
(8118,1,NULL),
(8119,1,NULL),
(8120,1,NULL),
(8131,1,NULL),
(8132,1,NULL),
(8133,1,NULL),
(8134,1,NULL),
(8135,1,NULL),
(8136,1,NULL),
(8141,1,NULL),
(8142,1,NULL),
(8153,1,NULL),
(8162,1,NULL),
(8163,1,NULL),
(8164,1,NULL),
(8165,1,NULL),
(8174,1,NULL),
(8175,1,NULL),
(8176,1,NULL),
(8177,1,NULL),
(8178,1,NULL),
(8194,1,NULL),
(8208,1,NULL),
(8211,1,NULL),
(8212,1,NULL),
(8213,1,NULL),
(8214,1,NULL),
(8215,1,NULL),
(8216,1,NULL),
(8217,1,NULL),
(8218,1,NULL),
(8227,1,NULL),
(8600,1,NULL),
(8601,1,NULL),
(8602,1,NULL),
(8603,1,NULL),
(8604,1,NULL),
(8605,1,NULL),
(8623,1,NULL),
(8676,1,NULL),
(8677,1,NULL),
(8704,1,NULL),
(8733,1,NULL),
(8740,1,NULL),
(8744,1,NULL),
(8745,1,NULL),
(8746,1,NULL),
(8747,1,NULL),
(8748,1,NULL),
(8749,1,NULL),
(8750,1,NULL),
(8751,1,NULL),
(8752,1,NULL),
(8753,1,NULL),
(8754,1,NULL),
(8759,1,NULL),
(8764,1,NULL),
(8769,1,NULL),
(8774,1,NULL),
(8779,1,NULL),
(8780,1,NULL),
(8781,1,NULL),
(8782,1,NULL),
(8783,1,NULL),
(8784,1,NULL),
(8785,1,NULL),
(8786,1,NULL),
(8795,1,NULL),
(8796,1,NULL),
(8797,1,NULL),
(8798,1,NULL),
(8799,1,NULL),
(8800,1,NULL),
(8801,1,NULL),
(8802,1,NULL),
(8803,1,NULL),
(8804,1,NULL),
(8805,1,NULL),
(8806,1,NULL),
(8807,1,NULL),
(8808,1,NULL),
(8810,1,NULL),
(8829,1,NULL),
(8830,1,NULL),
(8831,1,NULL),
(8832,1,NULL),
(8833,1,NULL),
(8834,1,NULL),
(8835,1,NULL),
(8836,1,NULL),
(8837,1,NULL),
(8862,1,NULL),
(8864,1,NULL),
(8865,1,NULL),
(8866,1,NULL),
(8867,1,NULL),
(8868,1,NULL),
(8869,1,NULL),
(8871,1,NULL),
(8882,1,NULL),
(8888,1,NULL),
(8889,1,NULL),
(8918,1,NULL),
(8919,1,NULL),
(8920,1,NULL),
(8923,1,NULL),
(8924,1,NULL),
(8925,1,NULL),
(8926,1,NULL),
(8927,1,NULL),
(8928,1,NULL),
(8929,1,NULL),
(8930,1,NULL),
(8931,1,NULL),
(8932,1,NULL),
(8933,1,NULL),
(8934,1,NULL),
(8935,1,NULL),
(8936,1,NULL),
(8953,1,NULL),
(8954,1,NULL),
(8955,1,NULL),
(8956,1,NULL),
(8957,1,NULL),
(8958,1,NULL),
(8959,1,NULL),
(8968,1,NULL),
(8969,1,NULL),
(8970,1,NULL),
(8971,1,NULL),
(8972,1,NULL),
(8973,1,NULL),
(8974,1,NULL),
(8980,1,NULL),
(8981,1,NULL),
(8982,1,NULL),
(8983,1,NULL),
(8984,1,NULL),
(9008,1,NULL),
(9011,1,NULL),
(9012,1,NULL),
(9013,1,NULL),
(9014,1,NULL),
(9015,1,NULL),
(9016,1,NULL),
(9017,1,NULL),
(9018,1,NULL),
(9025,1,NULL),
(9028,1,NULL),
(9029,1,NULL),
(9030,1,NULL),
(9031,1,NULL),
(9032,1,NULL),
(9033,1,NULL),
(9038,1,NULL),
(9041,1,NULL),
(9042,1,NULL),
(9043,1,NULL),
(9044,1,NULL),
(9045,1,NULL),
(9046,1,NULL),
(9051,1,NULL),
(9056,1,NULL),
(9059,1,NULL),
(9060,1,NULL),
(9061,1,NULL),
(9062,1,NULL),
(9063,1,NULL),
(9068,1,NULL),
(9071,1,NULL),
(9072,1,NULL),
(9073,1,NULL),
(9074,1,NULL),
(9075,1,NULL),
(9080,1,NULL),
(9083,1,NULL),
(9084,1,NULL),
(9085,1,NULL),
(9086,1,NULL),
(9087,1,NULL),
(9088,1,NULL),
(9095,1,NULL),
(9100,1,NULL),
(9101,1,NULL),
(9102,1,NULL),
(9103,1,NULL),
(9104,1,NULL),
(9105,1,NULL),
(9139,1,NULL),
(9144,1,NULL),
(9145,1,NULL),
(9146,1,NULL),
(9147,1,NULL),
(9148,1,NULL),
(9149,1,NULL),
(9150,1,NULL),
(9155,1,NULL),
(9160,1,NULL),
(9161,1,NULL),
(9162,1,NULL),
(9163,1,NULL),
(9164,1,NULL),
(9165,1,NULL),
(9172,1,NULL),
(9181,1,NULL),
(9184,1,NULL),
(9185,1,NULL),
(9186,1,NULL),
(9187,1,NULL),
(9188,1,NULL),
(9189,1,NULL),
(9190,1,NULL),
(9191,1,NULL),
(9192,1,NULL),
(9193,1,NULL),
(9204,1,NULL),
(9207,1,NULL),
(9208,1,NULL),
(9209,1,NULL),
(9210,1,NULL),
(9211,1,NULL),
(9212,1,NULL),
(9213,1,NULL),
(9219,1,NULL),
(9222,1,NULL),
(9223,1,NULL),
(9224,1,NULL),
(9225,1,NULL),
(9226,1,NULL),
(9238,1,NULL),
(9244,1,NULL),
(9245,1,NULL),
(9246,1,NULL),
(9247,1,NULL),
(9248,1,NULL),
(9249,1,NULL),
(9250,1,NULL),
(9255,1,NULL),
(9258,1,NULL),
(9259,1,NULL),
(9260,1,NULL),
(9261,1,NULL),
(9286,1,NULL),
(9289,1,NULL),
(9290,1,NULL),
(9291,1,NULL),
(9292,1,NULL),
(9293,1,NULL),
(9294,1,NULL),
(9309,1,NULL),
(9312,1,NULL),
(9313,1,NULL),
(9314,1,NULL),
(9319,1,NULL),
(9320,1,NULL),
(9321,1,NULL),
(9322,1,NULL),
(9323,1,NULL),
(9328,1,NULL),
(9331,1,NULL),
(9332,1,NULL),
(9333,1,NULL),
(9334,1,NULL),
(9335,1,NULL),
(9336,1,NULL),
(9353,1,NULL),
(9354,1,NULL),
(9415,1,NULL),
(9420,1,NULL),
(9423,1,NULL),
(9424,1,NULL),
(9425,1,NULL),
(9426,1,NULL),
(9427,1,NULL),
(9453,1,NULL),
(9466,1,NULL),
(9469,1,NULL),
(9470,1,NULL),
(9471,1,NULL),
(9518,1,NULL),
(9519,1,NULL),
(9520,1,NULL),
(9524,1,NULL),
(9529,1,NULL),
(9530,1,NULL),
(9531,1,NULL),
(9535,1,NULL),
(9540,1,NULL),
(9543,1,NULL),
(9546,1,NULL),
(9550,1,NULL),
(9553,1,NULL),
(9556,1,NULL),
(9559,1,NULL),
(9581,1,NULL),
(9589,1,NULL),
(9592,1,NULL),
(9622,1,NULL),
(9623,1,NULL),
(9624,1,NULL),
(9625,1,NULL),
(9626,1,NULL),
(9627,1,NULL),
(9628,1,NULL),
(9629,1,NULL),
(9630,1,NULL),
(9631,1,NULL),
(9632,1,NULL),
(9633,1,NULL),
(9641,1,NULL),
(9660,1,NULL),
(9663,1,NULL),
(9664,1,NULL),
(9665,1,NULL),
(9666,1,NULL),
(9669,1,NULL),
(9672,1,NULL),
(9675,1,NULL),
(9677,1,NULL),
(9680,1,NULL),
(9685,1,NULL),
(9686,1,NULL),
(9687,1,NULL),
(9688,1,NULL),
(9689,1,NULL),
(9690,1,NULL),
(9691,1,NULL),
(9692,1,NULL),
(9693,1,NULL),
(9694,1,NULL),
(9698,1,NULL),
(9701,1,NULL),
(9704,1,NULL),
(9707,1,NULL),
(9710,1,NULL),
(9714,1,NULL),
(9717,1,NULL),
(9720,1,NULL),
(9725,1,NULL),
(9728,1,NULL),
(9733,1,NULL),
(9736,1,NULL),
(9749,1,NULL),
(9800,1,NULL),
(9803,1,NULL),
(9804,1,NULL),
(9805,1,NULL),
(9806,1,NULL),
(9807,1,NULL),
(9808,1,NULL),
(9809,1,NULL),
(9811,1,NULL),
(9812,1,NULL),
(9813,1,NULL),
(9839,1,NULL),
(9843,1,NULL),
(9846,1,NULL),
(9852,1,NULL),
(9859,1,NULL),
(9860,1,NULL),
(9861,1,NULL),
(9862,1,NULL),
(9864,1,NULL),
(9865,1,NULL),
(9866,1,NULL),
(9868,1,NULL),
(9869,1,NULL),
(9870,1,NULL),
(9871,1,NULL),
(9872,1,NULL),
(9873,1,NULL),
(9874,1,NULL),
(9876,1,NULL),
(9901,1,NULL),
(9903,1,NULL),
(9904,1,NULL),
(9905,1,NULL),
(9906,1,NULL),
(9907,1,NULL),
(9908,1,NULL),
(9909,1,NULL),
(9910,1,NULL),
(9911,1,NULL),
(9912,1,NULL),
(9913,1,NULL),
(9914,1,NULL),
(9915,1,NULL),
(9947,1,NULL),
(9949,1,NULL),
(9950,1,NULL),
(9951,1,NULL),
(9952,1,NULL),
(9953,1,NULL),
(9954,1,NULL),
(9956,1,NULL),
(9957,1,NULL),
(9958,1,NULL),
(9959,1,NULL),
(9960,1,NULL),
(9962,1,NULL),
(9971,1,NULL),
(9972,1,NULL),
(9973,1,NULL),
(9989,1,NULL),
(9994,1,NULL),
(9997,1,NULL),
(10000,1,NULL),
(10004,1,NULL),
(10005,1,NULL),
(10006,1,NULL),
(10007,1,NULL),
(10009,1,NULL),
(10010,1,NULL),
(10012,1,NULL),
(10013,1,NULL),
(10014,1,NULL),
(10015,1,NULL),
(10016,1,NULL),
(10018,1,NULL),
(10019,1,NULL),
(10020,1,NULL),
(10041,1,NULL),
(10042,1,NULL),
(10043,1,NULL),
(10044,1,NULL),
(10045,1,NULL),
(10046,1,NULL),
(10047,1,NULL),
(10048,1,NULL),
(10049,1,NULL),
(10050,1,NULL),
(10051,1,NULL),
(10052,1,NULL),
(10053,1,NULL),
(10054,1,NULL),
(10055,1,NULL),
(10056,1,NULL),
(10057,1,NULL),
(10058,1,NULL),
(10059,1,NULL),
(10060,1,NULL),
(10061,1,NULL),
(10062,1,NULL),
(10069,1,NULL),
(10070,1,NULL),
(10071,1,NULL),
(10072,1,NULL),
(10073,1,NULL),
(10074,1,NULL),
(10075,1,NULL),
(10076,1,NULL),
(10077,1,NULL),
(10078,1,NULL),
(10079,1,NULL),
(10080,1,NULL),
(10083,1,NULL),
(10084,1,NULL),
(10085,1,NULL),
(10086,1,NULL),
(10087,1,NULL),
(10088,1,NULL),
(10089,1,NULL),
(10090,1,NULL),
(10094,1,NULL),
(10097,1,NULL),
(10098,1,NULL),
(10099,1,NULL),
(10100,1,NULL),
(10101,1,NULL),
(10102,1,NULL),
(10149,1,NULL),
(10152,1,NULL),
(10158,1,NULL),
(10161,1,NULL),
(10164,1,NULL),
(10167,1,NULL),
(10209,1,NULL),
(10210,1,NULL),
(10213,1,NULL),
(10216,1,NULL),
(10219,1,NULL),
(10220,1,NULL),
(10221,1,NULL),
(10222,1,NULL),
(10223,1,NULL),
(10224,1,NULL),
(10225,1,NULL),
(10226,1,NULL),
(10227,1,NULL),
(10228,1,NULL),
(10229,1,NULL),
(10230,1,NULL),
(10231,1,NULL),
(10232,1,NULL),
(10233,1,NULL),
(10234,1,NULL),
(10235,1,NULL),
(10236,1,NULL),
(10237,1,NULL),
(10238,1,NULL),
(10239,1,NULL),
(10240,1,NULL),
(10247,1,NULL),
(10248,1,NULL),
(10249,1,NULL),
(10250,1,NULL),
(10251,1,NULL),
(10252,1,NULL),
(10410,1,NULL),
(10426,1,NULL),
(10428,1,NULL),
(10430,1,NULL),
(10431,1,NULL),
(10432,1,NULL),
(10437,1,NULL),
(10460,1,NULL),
(10463,1,NULL),
(10466,1,NULL),
(10469,1,NULL),
(10474,1,NULL),
(10477,1,NULL),
(10478,1,NULL),
(10480,1,NULL),
(10483,1,NULL),
(10486,1,NULL),
(10489,1,NULL),
(10492,1,NULL),
(10495,1,NULL),
(10498,1,NULL),
(10501,1,NULL),
(10504,1,NULL),
(10507,1,NULL),
(10510,1,NULL),
(10513,1,NULL),
(10517,1,NULL),
(10522,1,NULL),
(10523,1,NULL),
(10526,1,NULL),
(10529,1,NULL),
(10532,1,NULL),
(10535,1,NULL),
(10538,1,NULL),
(10543,1,NULL),
(10546,1,NULL),
(10549,1,NULL),
(10553,1,NULL),
(10557,1,NULL),
(10560,1,NULL),
(10563,1,NULL),
(10575,1,NULL),
(11003,1,NULL),
(11004,1,NULL);
/*!40000 ALTER TABLE `assets_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `auth_oauth_tokens`
--

LOCK TABLES `auth_oauth_tokens` WRITE;
/*!40000 ALTER TABLE `auth_oauth_tokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `auth_oauth_tokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `authenticator`
--

LOCK TABLES `authenticator` WRITE;
/*!40000 ALTER TABLE `authenticator` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `authenticator` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `bulkopevents`
--

LOCK TABLES `bulkopevents` WRITE;
/*!40000 ALTER TABLE `bulkopevents` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `bulkopevents` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups`
--

LOCK TABLES `categorygroups` WRITE;
/*!40000 ALTER TABLE `categorygroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categorygroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups_sites`
--

LOCK TABLES `categorygroups_sites` WRITE;
/*!40000 ALTER TABLE `categorygroups_sites` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categorygroups_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedattributes`
--

LOCK TABLES `changedattributes` WRITE;
/*!40000 ALTER TABLE `changedattributes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `changedattributes` VALUES
(2,1,'postDate','2025-04-18 17:16:03',0,1),
(2,1,'slug','2025-04-18 17:58:01',0,1),
(2,1,'title','2025-04-18 17:33:58',0,1),
(2,1,'uri','2025-08-20 17:56:29',0,1),
(1353,1,'slug','2025-09-22 18:10:11',0,1),
(1353,1,'title','2025-09-22 18:03:40',0,1),
(1395,1,'slug','2025-09-22 18:10:30',0,1),
(1395,1,'title','2025-09-22 18:08:00',0,1),
(1437,1,'title','2025-10-22 18:20:15',0,1),
(1777,1,'primaryOwnerId','2025-11-17 15:43:23',0,1),
(1777,1,'slug','2025-11-17 15:43:23',0,1),
(1890,1,'primaryOwnerId','2025-11-17 15:12:02',0,1),
(1890,1,'slug','2025-11-17 15:12:02',0,1),
(2223,1,'primaryOwnerId','2026-01-19 20:59:10',0,1),
(2224,1,'primaryOwnerId','2026-01-19 20:59:10',0,1),
(2225,1,'primaryOwnerId','2026-01-19 20:59:10',0,1),
(2501,1,'primaryOwnerId','2026-01-19 20:59:10',0,1),
(6208,1,'slug','2025-11-17 16:18:48',0,1),
(6442,1,'title','2025-11-24 17:08:45',0,1),
(6651,1,'primaryOwnerId','2026-01-20 15:18:57',0,1),
(6651,1,'title','2026-01-20 15:18:57',0,1),
(6652,1,'primaryOwnerId','2026-01-20 15:18:57',0,1),
(6652,1,'title','2026-01-20 15:18:57',0,1),
(6653,1,'primaryOwnerId','2026-01-20 15:24:09',0,1),
(6653,1,'title','2026-01-20 15:24:09',0,1),
(6670,1,'primaryOwnerId','2026-01-20 15:20:16',0,1),
(6670,1,'title','2026-01-20 15:20:16',0,1),
(6671,1,'primaryOwnerId','2026-01-20 15:20:16',0,1),
(6671,1,'title','2026-01-20 15:20:16',0,1);
/*!40000 ALTER TABLE `changedattributes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedfields`
--

LOCK TABLES `changedfields` WRITE;
/*!40000 ALTER TABLE `changedfields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `changedfields` VALUES
(2,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:29',0,1),
(2,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-19 20:59:09',0,1),
(2,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:29',0,1),
(2,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:29',0,1),
(2,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2026-01-17 20:38:34',0,1),
(2,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2026-01-19 17:16:04',0,1),
(2,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-22 20:41:13',0,1),
(2,1,11,'d26c0574-65df-44ac-815a-723f6a2599ad','2025-04-18 18:17:53',0,1),
(2,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2026-01-19 16:29:55',0,1),
(2,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2026-01-02 20:54:42',0,1),
(2,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:29',0,1),
(2,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:29',0,1),
(2,1,16,'7270a303-7119-43a8-b9bb-8360964189de','2025-04-18 18:45:07',0,1),
(2,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-12-03 20:39:58',0,1),
(2,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-19 19:10:35',0,1),
(2,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:29',0,1),
(2,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:29',0,1),
(2,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:29',0,1),
(2,1,44,'2c726802-f189-49e5-935d-af3557619590','2026-01-19 17:16:04',0,1),
(2,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2026-01-05 16:30:40',0,1),
(2,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2026-01-19 20:59:09',0,1),
(2,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:29',0,1),
(2,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:29',0,1),
(2,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:29',0,1),
(2,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:29',0,1),
(2,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-23 21:59:36',0,1),
(2,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:29',0,1),
(2,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:29',0,1),
(2,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:29',0,1),
(2,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2026-01-19 16:40:31',0,1),
(2,1,73,'d87be94b-4936-41d7-917a-18a2f21b2582','2026-01-05 16:30:40',0,1),
(2,1,74,'ebf27e22-ae24-4c7b-9d65-467b86ec06da','2026-01-02 20:54:42',0,1),
(2,1,81,'a3ce6d03-a997-40d9-ac8e-0d755516c921','2026-01-05 16:30:40',0,1),
(2,1,82,'405b422b-fca3-4a5d-b552-b860066ac2ad','2026-01-05 16:30:40',0,1),
(2,1,84,'6a2ff241-d570-4bb8-b4a0-d537212fe5d0','2026-01-06 21:34:41',0,NULL),
(995,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 14:49:28',0,1),
(995,1,82,'405b422b-fca3-4a5d-b552-b860066ac2ad','2026-01-20 14:49:28',0,1),
(1023,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 14:50:45',0,1),
(1031,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1031,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-17 20:48:08',0,1),
(1031,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1031,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1031,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2026-01-17 20:48:08',0,1),
(1031,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-11-17 16:58:10',0,1),
(1031,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1031,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1031,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2026-01-12 19:19:21',0,1),
(1031,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1031,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2026-01-13 21:57:41',0,1),
(1031,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1031,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1031,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2026-01-12 15:49:50',0,1),
(1031,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1031,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1031,1,44,'2c726802-f189-49e5-935d-af3557619590','2026-01-17 14:42:35',0,1),
(1031,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1031,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1031,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1031,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1031,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1031,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1031,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1031,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2026-01-13 21:57:41',0,1),
(1031,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1031,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1031,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2025-11-14 18:19:43',0,1),
(1031,1,84,'6a2ff241-d570-4bb8-b4a0-d537212fe5d0','2026-01-15 15:27:32',0,1),
(1045,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1045,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-18 19:25:47',0,1),
(1045,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1045,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1045,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2026-01-17 20:50:38',0,1),
(1045,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2026-01-05 17:07:53',0,1),
(1045,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-09 20:46:26',0,1),
(1045,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1045,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2026-01-02 19:49:14',0,1),
(1045,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1045,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2026-01-18 19:25:47',0,1),
(1045,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1045,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2026-01-12 15:54:02',0,1),
(1045,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-09 20:46:26',0,1),
(1045,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1045,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1045,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-09 20:48:21',0,1),
(1045,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-10-09 20:46:26',0,1),
(1045,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1045,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1045,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1045,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1045,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1045,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-09 20:48:21',0,1),
(1045,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2026-01-14 16:23:12',0,1),
(1045,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1045,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1045,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2025-12-12 18:18:37',0,1),
(1045,1,82,'405b422b-fca3-4a5d-b552-b860066ac2ad','2026-01-12 18:25:57',0,1),
(1045,1,84,'6a2ff241-d570-4bb8-b4a0-d537212fe5d0','2026-01-15 15:44:13',0,1),
(1141,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 18:51:21',0,1),
(1141,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-12 18:27:00',0,1),
(1141,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 18:51:21',0,1),
(1141,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 18:51:21',0,1),
(1141,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 18:51:21',0,1),
(1141,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 18:51:21',0,1),
(1141,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 18:51:21',0,1),
(1141,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 18:51:21',0,1),
(1141,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 18:51:21',0,1),
(1141,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 18:51:21',0,1),
(1141,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 18:51:21',0,1),
(1141,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 18:51:21',0,1),
(1141,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2026-01-12 16:11:56',0,1),
(1141,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2026-01-12 16:11:56',0,1),
(1141,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 18:51:21',0,1),
(1141,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 18:51:21',0,1),
(1141,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 18:51:21',0,1),
(1141,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 18:51:21',0,1),
(1141,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 18:51:21',0,1),
(1141,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 18:51:21',0,1),
(1141,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 18:51:21',0,1),
(1141,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 18:51:21',0,1),
(1141,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 18:51:21',0,1),
(1141,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 18:51:21',0,1),
(1141,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 18:51:21',0,1),
(1141,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 18:51:21',0,1),
(1141,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2025-11-13 20:20:51',0,1),
(1141,1,82,'405b422b-fca3-4a5d-b552-b860066ac2ad','2026-01-12 18:24:34',0,1),
(1141,1,84,'6a2ff241-d570-4bb8-b4a0-d537212fe5d0','2026-01-06 21:34:39',0,NULL),
(1161,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1161,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 14:52:47',0,1),
(1161,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1161,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1161,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:33',0,1),
(1161,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2026-01-16 21:30:00',0,1),
(1161,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-16 16:05:51',0,1),
(1161,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1161,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2026-01-02 20:42:52',0,1),
(1161,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1161,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-12-16 15:07:35',0,1),
(1161,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1161,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:33',0,1),
(1161,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2026-01-14 15:18:41',0,1),
(1161,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1161,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1161,1,44,'2c726802-f189-49e5-935d-af3557619590','2026-01-16 16:40:40',0,1),
(1161,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1161,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1161,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-11-18 17:06:51',0,1),
(1161,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1161,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1161,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1161,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2026-01-16 16:27:18',0,1),
(1161,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2026-01-16 21:35:24',0,1),
(1161,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1161,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1161,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2026-01-16 16:40:40',0,1),
(1161,1,83,'ee03ee9b-cb63-4d27-b225-8175bfc4028c','2026-01-16 15:18:24',0,1),
(1161,1,84,'6a2ff241-d570-4bb8-b4a0-d537212fe5d0','2026-01-16 16:23:31',0,1),
(1185,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 14:52:39',0,1),
(1185,1,83,'ee03ee9b-cb63-4d27-b225-8175bfc4028c','2026-01-20 14:51:02',0,1),
(1191,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 16:08:33',0,1),
(1283,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 14:53:27',0,1),
(1337,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:36',0,1),
(1337,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-17 20:15:37',0,1),
(1337,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1337,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:36',0,1),
(1337,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2026-01-17 20:15:33',0,1),
(1337,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2026-01-08 15:17:35',0,1),
(1337,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-11-05 19:15:00',0,1),
(1337,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1337,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2026-01-17 00:31:21',0,1),
(1337,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1337,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-11-05 19:15:00',0,1),
(1337,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1337,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2026-01-12 17:04:34',0,1),
(1337,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-11-05 19:15:33',0,1),
(1337,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1337,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1337,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-11-05 19:19:38',0,1),
(1337,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1337,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1337,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1337,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1337,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1337,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1337,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1337,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-11-05 19:19:38',0,1),
(1337,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1337,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1337,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2025-11-14 17:48:42',0,1),
(1337,1,82,'405b422b-fca3-4a5d-b552-b860066ac2ad','2026-01-12 17:04:34',0,1),
(1337,1,84,'6a2ff241-d570-4bb8-b4a0-d537212fe5d0','2026-01-06 21:34:37',0,NULL),
(1353,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:03:40',0,1),
(1353,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 16:19:48',0,1),
(1353,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1353,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:20:10',0,1),
(1353,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2026-01-17 20:30:25',0,1),
(1353,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 22:38:45',0,1),
(1353,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 22:38:17',0,1),
(1353,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1353,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1353,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1353,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 22:41:35',0,1),
(1353,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1353,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 22:40:25',0,1),
(1353,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 22:40:25',0,1),
(1353,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:03:40',0,1),
(1353,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1353,1,44,'2c726802-f189-49e5-935d-af3557619590','2026-01-17 00:34:34',0,1),
(1353,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1353,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1353,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-11-18 16:48:51',0,1),
(1353,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1353,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1353,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-10-08 22:41:35',0,1),
(1353,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 22:38:17',0,1),
(1353,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-10-08 22:41:35',0,1),
(1353,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1353,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1353,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2025-11-14 16:35:59',0,1),
(1353,1,72,'c67c0ac3-ce5c-4eb0-b6c1-86c68413a548','2025-10-10 18:22:08',0,1),
(1353,1,82,'405b422b-fca3-4a5d-b552-b860066ac2ad','2026-01-12 17:08:47',0,1),
(1353,1,84,'6a2ff241-d570-4bb8-b4a0-d537212fe5d0','2026-01-06 21:34:37',0,NULL),
(1353,1,86,'0540783c-5e85-44a6-afb6-f9879cd880d2','2026-01-06 23:19:03',0,1),
(1353,1,87,'987e433d-3a34-4ef7-90a4-40eab1252deb','2026-01-15 21:13:35',0,1),
(1353,1,88,'6aaa2328-02d3-4dcb-b7c0-57c572b789d6','2026-01-06 23:15:44',0,1),
(1371,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 14:56:24',0,1),
(1371,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 14:56:24',0,1),
(1377,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 14:58:34',0,1),
(1377,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 14:58:31',0,1),
(1383,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:00:15',0,1),
(1383,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:00:15',0,1),
(1389,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:02:05',0,1),
(1389,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:02:05',0,1),
(1395,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:08:00',0,1),
(1395,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:10:06',0,1),
(1395,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1395,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:21:16',0,1),
(1395,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2026-01-17 20:35:05',0,1),
(1395,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2026-01-08 16:18:09',0,1),
(1395,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:10:06',0,1),
(1395,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1395,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1395,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1395,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2026-01-17 02:27:00',0,1),
(1395,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1395,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2026-01-12 17:22:26',0,1),
(1395,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2026-01-06 23:16:12',0,1),
(1395,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:08:00',0,1),
(1395,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2026-01-06 23:17:17',0,1),
(1395,1,44,'2c726802-f189-49e5-935d-af3557619590','2026-01-08 16:18:09',0,1),
(1395,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2026-01-06 23:16:12',0,1),
(1395,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2026-01-06 23:16:12',0,1),
(1395,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-11-18 17:03:04',0,1),
(1395,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1395,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1395,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1395,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1395,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2026-01-17 02:29:24',0,1),
(1395,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1395,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1395,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2025-11-13 19:44:42',0,1),
(1395,1,82,'405b422b-fca3-4a5d-b552-b860066ac2ad','2026-01-12 17:22:26',0,1),
(1395,1,84,'6a2ff241-d570-4bb8-b4a0-d537212fe5d0','2026-01-15 20:12:12',0,1),
(1395,1,86,'0540783c-5e85-44a6-afb6-f9879cd880d2','2026-01-06 23:17:45',0,1),
(1395,1,87,'987e433d-3a34-4ef7-90a4-40eab1252deb','2026-01-15 20:12:12',0,1),
(1395,1,88,'6aaa2328-02d3-4dcb-b7c0-57c572b789d6','2026-01-06 23:16:12',0,1),
(1401,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:06:16',0,1),
(1401,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:06:16',0,1),
(1413,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:04:30',0,1),
(1413,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:04:30',0,1),
(1419,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:15:56',0,1),
(1419,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:15:56',0,1),
(1425,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:17:05',0,1),
(1425,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:17:05',0,1),
(1431,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:20:16',0,1),
(1431,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:20:16',0,1),
(1437,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-10-22 18:20:15',0,1),
(1437,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:24:09',0,1),
(1437,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1437,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:37',0,1),
(1437,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2026-01-17 20:23:36',0,1),
(1437,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-11-17 15:41:59',0,1),
(1437,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:24:09',0,1),
(1437,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1437,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2026-01-02 20:16:44',0,1),
(1437,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1437,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-12-16 15:32:07',0,1),
(1437,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1437,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1437,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1437,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-10-22 18:20:15',0,1),
(1437,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1437,1,44,'2c726802-f189-49e5-935d-af3557619590','2026-01-02 20:16:44',0,1),
(1437,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1437,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1437,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1437,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1437,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1437,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1437,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1437,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-12-16 15:30:59',0,1),
(1437,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1437,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1437,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2025-11-14 16:59:13',0,1),
(1437,1,73,'d87be94b-4936-41d7-917a-18a2f21b2582','2025-10-22 23:46:58',0,1),
(1437,1,83,'ee03ee9b-cb63-4d27-b225-8175bfc4028c','2026-01-15 18:04:18',0,1),
(1437,1,84,'6a2ff241-d570-4bb8-b4a0-d537212fe5d0','2026-01-15 18:11:04',0,1),
(1437,1,89,'5bdbda4b-eb3e-495c-95f1-5fa68f4017fc','2026-01-15 16:49:36',0,1),
(1443,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:25:43',0,1),
(1443,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:25:43',0,1),
(1449,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:26:56',0,1),
(1449,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:26:56',0,1),
(1455,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:29:08',0,1),
(1455,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:29:08',0,1),
(1461,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:30:41',0,1),
(1461,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:30:41',0,1),
(1467,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:33:10',0,1),
(1467,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:33:10',0,1),
(1481,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:33:43',0,1),
(1777,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-11-17 15:43:23',0,1),
(1777,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-11-17 15:43:23',0,1),
(1890,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-11-17 15:12:02',0,1),
(1890,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-11-17 15:12:02',0,1),
(2712,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 15:12:43',0,1),
(2712,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2026-01-20 15:12:43',0,1),
(2880,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 14:52:25',0,1),
(2880,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2026-01-20 14:52:25',0,1),
(6208,1,20,'2b573339-79e1-4bb1-82cf-7c0dfabcab22','2025-11-17 16:18:46',0,1),
(6442,1,20,'2b573339-79e1-4bb1-82cf-7c0dfabcab22','2025-11-24 17:08:45',0,1),
(6507,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-12-23 18:40:44',0,1),
(6507,1,77,'0a43b411-e0ad-455e-88c6-b699add29650','2025-12-05 20:23:21',0,1),
(6507,1,81,'a3ce6d03-a997-40d9-ac8e-0d755516c921','2025-12-05 20:18:14',0,1),
(6651,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2026-01-20 15:18:57',0,1),
(6651,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2026-01-20 15:18:57',0,1),
(6652,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2026-01-20 15:18:57',0,1),
(6652,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2026-01-20 15:18:57',0,1),
(6653,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2026-01-20 15:24:09',0,1),
(6653,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2026-01-20 15:24:09',0,1),
(6670,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2026-01-20 15:20:16',0,1),
(6670,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2026-01-20 15:20:16',0,1),
(6671,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2026-01-20 15:20:16',0,1),
(6671,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2026-01-20 15:20:16',0,1),
(8584,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-15 20:56:47',0,1),
(8839,1,20,'2b573339-79e1-4bb1-82cf-7c0dfabcab22','2026-01-17 00:24:53',0,1),
(8839,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2026-01-17 00:24:53',0,1),
(8839,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2026-01-17 00:24:50',0,1),
(10154,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-18 17:41:12',0,1),
(10387,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-19 16:08:13',0,1),
(10456,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-19 18:03:41',0,1),
(10520,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 16:04:31',0,1),
(11361,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 16:14:06',0,1),
(11396,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 16:04:12',0,1),
(11399,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 16:07:00',0,1),
(11399,1,84,'6a2ff241-d570-4bb8-b4a0-d537212fe5d0','2026-01-20 16:07:14',0,1),
(11402,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 16:08:01',0,1),
(11405,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 16:08:47',0,1),
(11408,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 16:12:08',0,1),
(11418,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 16:30:58',0,1),
(11419,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2026-01-20 16:31:07',0,1);
/*!40000 ALTER TABLE `changedfields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `contentblocks`
--

LOCK TABLES `contentblocks` WRITE;
/*!40000 ALTER TABLE `contentblocks` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `contentblocks` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `craftidtokens`
--

LOCK TABLES `craftidtokens` WRITE;
/*!40000 ALTER TABLE `craftidtokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `craftidtokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `deprecationerrors`
--

LOCK TABLES `deprecationerrors` WRITE;
/*!40000 ALTER TABLE `deprecationerrors` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `deprecationerrors` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `drafts`
--

LOCK TABLES `drafts` WRITE;
/*!40000 ALTER TABLE `drafts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `drafts` VALUES
(671,NULL,1,0,'First draft','',0,NULL,1),
(1794,1915,1,1,'Draft 1',NULL,1,NULL,1),
(1893,1890,1,1,'Draft 1',NULL,1,NULL,1),
(1914,2,1,0,'Draft 1','',1,NULL,1),
(2710,1141,1,1,'Draft 1','',1,NULL,1),
(2802,1777,1,1,'Draft 1',NULL,1,NULL,1),
(3099,NULL,1,0,'First draft',NULL,0,NULL,0),
(3100,NULL,1,0,'First draft',NULL,0,NULL,0),
(3240,1337,1,1,'Draft 1','',1,NULL,1),
(3321,1031,1,1,'Draft 1','',1,NULL,1),
(3349,1045,1,1,'Draft 1','',1,NULL,1),
(3367,2,1,1,'Draft 2','',1,NULL,1),
(3491,963,1,1,'Draft 1','',1,NULL,1),
(3492,1161,1,1,'Draft 1','',1,NULL,1),
(3493,1437,1,1,'Draft 1','',1,NULL,1),
(3494,1413,1,1,'Draft 1','',1,NULL,1),
(3496,2880,1,1,'Draft 1','',1,NULL,1),
(3497,1165,1,1,'Draft 1','',1,NULL,1),
(3498,1473,1,1,'Draft 1','',1,NULL,1),
(3499,1177,1,1,'Draft 1','',1,NULL,1);
/*!40000 ALTER TABLE `drafts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elementactivity`
--

LOCK TABLES `elementactivity` WRITE;
/*!40000 ALTER TABLE `elementactivity` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elementactivity` VALUES
(2,1,1,NULL,'edit','2026-01-20 16:04:31'),
(963,1,1,NULL,'edit','2026-01-20 16:14:06'),
(995,1,1,NULL,'edit','2026-01-20 14:49:27'),
(995,1,1,NULL,'save','2026-01-20 14:49:29'),
(1023,1,1,NULL,'edit','2026-01-20 14:49:41'),
(1023,1,1,NULL,'save','2026-01-20 14:50:45'),
(1161,1,1,NULL,'edit','2026-01-20 16:04:12'),
(1161,1,1,NULL,'save','2026-01-20 14:52:47'),
(1165,1,1,NULL,'edit','2026-01-20 16:12:08'),
(1177,1,1,NULL,'edit','2026-01-20 16:31:07'),
(1185,1,1,NULL,'edit','2026-01-20 14:52:36'),
(1185,1,1,NULL,'save','2026-01-20 14:52:39'),
(1191,1,1,NULL,'edit','2026-01-20 16:08:28'),
(1191,1,1,NULL,'save','2026-01-20 16:08:33'),
(1283,1,1,NULL,'edit','2026-01-20 14:53:04'),
(1283,1,1,NULL,'save','2026-01-20 14:53:27'),
(1353,1,1,NULL,'edit','2026-01-20 16:18:30'),
(1353,1,1,NULL,'save','2026-01-20 16:19:48'),
(1371,1,1,NULL,'edit','2026-01-20 14:56:21'),
(1371,1,1,NULL,'save','2026-01-20 14:56:24'),
(1377,1,1,NULL,'edit','2026-01-20 14:58:32'),
(1377,1,1,NULL,'save','2026-01-20 14:58:34'),
(1383,1,1,NULL,'edit','2026-01-20 15:00:12'),
(1383,1,1,NULL,'save','2026-01-20 15:00:15'),
(1389,1,1,NULL,'edit','2026-01-20 15:02:00'),
(1389,1,1,NULL,'save','2026-01-20 15:02:05'),
(1395,1,1,NULL,'edit','2026-01-20 15:10:03'),
(1395,1,1,NULL,'save','2026-01-20 15:10:06'),
(1401,1,1,NULL,'edit','2026-01-20 15:06:14'),
(1401,1,1,NULL,'save','2026-01-20 15:06:16'),
(1413,1,1,NULL,'edit','2026-01-20 16:08:01'),
(1413,1,1,NULL,'save','2026-01-20 15:04:31'),
(1419,1,1,NULL,'edit','2026-01-20 15:15:54'),
(1419,1,1,NULL,'save','2026-01-20 15:15:56'),
(1425,1,1,NULL,'edit','2026-01-20 15:17:03'),
(1425,1,1,NULL,'save','2026-01-20 15:17:05'),
(1431,1,1,NULL,'edit','2026-01-20 15:19:39'),
(1431,1,1,NULL,'save','2026-01-20 15:20:16'),
(1437,1,1,NULL,'edit','2026-01-20 16:07:14'),
(1437,1,1,NULL,'save','2026-01-20 15:24:09'),
(1443,1,1,NULL,'edit','2026-01-20 15:25:41'),
(1443,1,1,NULL,'save','2026-01-20 15:25:43'),
(1449,1,1,NULL,'edit','2026-01-20 15:26:55'),
(1449,1,1,NULL,'save','2026-01-20 15:26:57'),
(1455,1,1,NULL,'edit','2026-01-20 15:29:05'),
(1455,1,1,NULL,'save','2026-01-20 15:29:08'),
(1461,1,1,NULL,'edit','2026-01-20 15:30:32'),
(1461,1,1,NULL,'save','2026-01-20 15:30:41'),
(1467,1,1,NULL,'edit','2026-01-20 15:33:07'),
(1467,1,1,NULL,'save','2026-01-20 15:33:10'),
(1473,1,1,NULL,'edit','2026-01-20 16:30:58'),
(1481,1,1,NULL,'edit','2026-01-20 15:33:36'),
(1481,1,1,NULL,'save','2026-01-20 15:33:43'),
(2712,1,1,NULL,'edit','2026-01-20 15:12:40'),
(2712,1,1,NULL,'save','2026-01-20 15:12:44'),
(2880,1,1,NULL,'edit','2026-01-20 16:08:47'),
(2880,1,1,NULL,'save','2026-01-20 14:52:26'),
(6651,1,1,NULL,'edit','2026-01-20 15:17:52'),
(6652,1,1,NULL,'edit','2026-01-20 15:18:37'),
(6653,1,1,NULL,'edit','2026-01-20 15:20:53'),
(6670,1,1,NULL,'edit','2026-01-20 15:19:38'),
(6671,1,1,NULL,'edit','2026-01-20 15:20:14');
/*!40000 ALTER TABLE `elementactivity` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements`
--

LOCK TABLES `elements` WRITE;
/*!40000 ALTER TABLE `elements` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements` VALUES
(1,NULL,NULL,NULL,NULL,'craft\\elements\\User',1,0,'2025-04-18 16:59:46','2025-04-18 16:59:46',NULL,NULL,NULL,'e3682bee-bd77-4012-b16c-20d4c1d6741e'),
(2,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-04-18 17:15:09','2026-01-19 20:59:09',NULL,NULL,NULL,'fb43295f-50d1-4199-9547-b616822746d7'),
(8,NULL,NULL,NULL,NULL,'craft\\elements\\Address',1,0,'2025-04-18 17:32:44','2025-04-18 17:37:13',NULL,NULL,NULL,'70e10205-927a-4a3d-8e91-9e3ffe573ce3'),
(56,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-04-18 18:14:39','2025-09-11 20:39:29',NULL,NULL,NULL,'cced9ffb-b1a4-432b-82dd-39ae892c0350'),
(57,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-04-18 18:14:39','2025-09-11 20:39:29',NULL,NULL,NULL,'5c75acb1-1c32-464d-a385-7d8e4367e7ad'),
(63,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-04-18 18:15:36','2025-09-11 20:39:29',NULL,NULL,NULL,'6b94fb19-0b48-4dbd-a994-fcc7c42212ac'),
(72,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,'2026-01-09 18:08:20',NULL,'65faed90-739e-412a-ae6b-1141af4adff8'),
(73,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,'2026-01-09 18:08:20',NULL,'15f1b50a-a6bf-404b-92d3-441e13132ed1'),
(74,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,'2026-01-09 18:08:20',NULL,'02403c1b-68a0-4814-9d28-465a0dd3fd27'),
(75,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,'2026-01-09 18:08:20',NULL,'d9c3d7d0-5243-443e-b0f7-d9e5c8e77f66'),
(76,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,'2026-01-09 18:08:20',NULL,'3ddce6d7-14e4-4ed9-9384-71082ffc55a9'),
(111,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:34','2025-12-05 19:07:35',NULL,NULL,NULL,'1c014517-f0ca-4b34-a4ec-8c06c66e936c'),
(112,111,NULL,46,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:40','2025-04-18 18:38:40',NULL,NULL,NULL,'b69fbe05-7e0a-444c-87cb-538dab008405'),
(113,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:44','2025-12-05 19:07:35',NULL,NULL,NULL,'e8577614-718f-4f49-9a2c-762b53180e15'),
(114,113,NULL,47,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:46','2025-04-18 18:38:46',NULL,NULL,NULL,'62564fb6-d7ee-42e1-a94c-0d101b1862ad'),
(115,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:49','2025-12-05 19:07:35',NULL,NULL,NULL,'c1291b59-240b-4c7d-a481-b43ceffa5843'),
(116,115,NULL,48,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:51','2025-04-18 18:38:51',NULL,NULL,NULL,'0de6d844-6a84-45b9-a5a4-219bf907924c'),
(117,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:54','2025-12-05 19:07:35',NULL,NULL,NULL,'c983b9b7-0678-4980-a3a6-bf04df690818'),
(118,117,NULL,49,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:56','2025-04-18 18:38:56',NULL,NULL,NULL,'6532d990-a37a-4e60-98a6-d2f6ad40d415'),
(119,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:58','2025-12-05 19:07:35',NULL,NULL,NULL,'07f26095-e9ed-4a30-9fcc-ee9e7b1c89a5'),
(120,119,NULL,50,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:39:00','2025-04-18 18:39:00',NULL,NULL,NULL,'9ef9e4fb-c780-42aa-b260-c57f1c904855'),
(121,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:39:03','2025-12-05 19:07:35',NULL,NULL,NULL,'f48f3d64-37db-4387-ad42-86a0d4022e8f'),
(122,121,NULL,51,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:39:04','2025-04-18 18:39:04',NULL,NULL,NULL,'5c8697a2-2860-47df-90df-d73d461ed250'),
(131,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-04-18 18:42:36','2025-08-20 17:52:26',NULL,NULL,NULL,'10a402bd-e708-4f1b-8f19-9d6f2dd41e56'),
(132,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-04-18 18:42:36','2025-08-20 17:52:26',NULL,NULL,NULL,'61411460-73b4-43ef-93b9-77c20db6e79f'),
(136,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-04-18 18:44:35','2025-04-18 18:44:35',NULL,NULL,NULL,'73525736-57a1-472f-b811-bd05b62fb341'),
(137,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-04-18 18:44:36','2025-04-18 18:44:36',NULL,NULL,NULL,'abf930ea-95bc-4a2c-9696-8a563fc70185'),
(138,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-04-18 18:44:36','2025-04-18 18:44:36',NULL,NULL,NULL,'10a14980-1c09-497a-af73-3d142632703b'),
(285,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-07-30 22:47:59','2025-09-05 20:01:00',NULL,NULL,NULL,'805f8534-dd6f-4152-b919-0c5d87163b8b'),
(325,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:34','2025-08-01 18:06:11',NULL,NULL,NULL,'583d4518-7524-42db-a63d-0d921f008d36'),
(326,325,NULL,153,15,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:41','2025-08-01 17:59:41',NULL,NULL,NULL,'52a01e8d-717e-470b-bbc1-3dd874556d25'),
(328,325,NULL,154,14,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:53','2025-08-01 17:59:53',NULL,NULL,NULL,'c817c185-395d-435a-84c6-42430c2239a4'),
(329,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:04:51','2025-08-01 18:04:57',NULL,NULL,NULL,'328e73a9-9198-46ee-8ce1-292e019d2ac6'),
(330,329,NULL,155,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:04:57','2025-08-01 18:04:57',NULL,NULL,NULL,'82c64f78-283c-4a64-9681-11a3be4d4d40'),
(331,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:04:57','2025-08-01 18:05:01',NULL,NULL,NULL,'de1dbf90-2df4-4a57-8ef0-88e981636992'),
(332,331,NULL,156,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:01','2025-08-01 18:05:01',NULL,NULL,NULL,'ae5cc034-9679-48f5-9594-0c61fafe6990'),
(333,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:01','2025-08-01 18:05:04',NULL,NULL,NULL,'27c35b6d-8b9d-4bcc-abaf-a2338d548dfa'),
(334,333,NULL,157,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:04','2025-08-01 18:05:04',NULL,NULL,NULL,'70055f31-2d03-42d3-a985-121a1e2b2572'),
(335,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:04','2025-08-01 18:05:08',NULL,NULL,NULL,'5d7aa22c-6b88-4187-afb5-24fffb7c6539'),
(336,335,NULL,158,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:08','2025-08-01 18:05:08',NULL,NULL,NULL,'52c8f108-5ec7-4eb7-83e1-4c214d2d933b'),
(337,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:08','2025-08-01 18:05:10',NULL,NULL,NULL,'fdc36882-7b46-43fa-8ff9-4245e8dd9bd0'),
(338,337,NULL,159,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:10','2025-08-01 18:05:10',NULL,NULL,NULL,'1070a399-73d2-43b8-ad87-2e72974ec72a'),
(339,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:10','2025-08-01 18:05:15',NULL,NULL,NULL,'2558370f-56ae-47a6-8deb-2d7cb1e6ffe8'),
(340,339,NULL,160,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:15','2025-08-01 18:05:15',NULL,NULL,NULL,'a717b773-e41d-4eb4-a975-1f516ac78eeb'),
(341,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:15','2025-08-01 18:05:18',NULL,NULL,NULL,'c8f9f0cd-8e20-41d4-984b-30b14d2471af'),
(342,341,NULL,161,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:18','2025-08-01 18:05:18',NULL,NULL,NULL,'9b932f54-8d57-46cd-8c94-e9932a283f31'),
(343,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:18','2025-08-01 18:05:21',NULL,NULL,NULL,'edff3928-0002-4ca4-8b65-c9328c6c7162'),
(344,343,NULL,162,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:21','2025-08-01 18:05:21',NULL,NULL,NULL,'6bfe948f-11ac-4494-8387-13a1d64719a8'),
(347,325,NULL,163,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:11','2025-08-01 18:06:11',NULL,NULL,NULL,'3b36b76d-7a5f-42fc-ba6e-2474c3e4f604'),
(348,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:11','2025-08-01 18:06:22',NULL,NULL,NULL,'af2219ff-28ec-46eb-b7f5-294fc48c9592'),
(349,348,NULL,164,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:22','2025-08-01 18:06:22',NULL,NULL,NULL,'49e28ec6-9273-48fd-bc9f-9624a56e7e96'),
(350,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:22','2025-08-01 18:06:40',NULL,NULL,NULL,'62a9aee5-450d-4d74-ac3c-22a50eb327d9'),
(351,350,NULL,165,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:40','2025-08-01 18:06:40',NULL,NULL,NULL,'f2c0689f-e1b0-4149-ba01-d0981abdda1e'),
(352,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:13','2025-08-01 18:07:25',NULL,NULL,NULL,'81854a0e-389f-4f30-8603-f133fa881688'),
(353,352,NULL,166,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:25','2025-08-01 18:07:25',NULL,NULL,NULL,'d5c48d8f-ac42-479e-8798-a50fc596d6d1'),
(354,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:25','2025-08-01 18:07:35',NULL,NULL,NULL,'7d9e199d-e444-4270-95c2-e0d6c18d7eda'),
(355,354,NULL,167,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:35','2025-08-01 18:07:35',NULL,NULL,NULL,'7a8fc6bc-eaf0-44e7-b00c-faab057bca0a'),
(356,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:35','2025-08-01 18:07:48',NULL,NULL,NULL,'1a91cd2e-f777-4327-82bf-9d4952df04dd'),
(357,356,NULL,168,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:48','2025-08-01 18:07:48',NULL,NULL,NULL,'da159131-b262-48b8-b0c9-8ca4af83f540'),
(358,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:51','2026-01-17 18:32:42',NULL,NULL,NULL,'83178051-07e6-40c6-ac65-1803e199667a'),
(359,358,NULL,169,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:58','2025-08-01 18:07:58',NULL,NULL,NULL,'d712ccab-478b-4d57-a770-e516c4c08e67'),
(360,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:01','2025-08-01 18:08:08',NULL,NULL,NULL,'47d21938-0536-4427-8f5f-cc02e140ab9d'),
(361,360,NULL,170,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:08','2025-08-01 18:08:08',NULL,NULL,NULL,'fae28537-8e36-4e69-a83a-8d0ddf218299'),
(362,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:10','2025-08-01 18:08:17',NULL,NULL,NULL,'d0e07c9d-1540-47f6-9214-6072a6894154'),
(363,362,NULL,171,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:17','2025-08-01 18:08:17',NULL,NULL,NULL,'695949a8-88ed-4210-8f64-4aa21bec75ad'),
(364,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:21','2025-08-01 18:08:31',NULL,NULL,NULL,'d55b94a3-92b7-4e30-85db-817cc33f7281'),
(365,364,NULL,172,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:31','2025-08-01 18:08:31',NULL,NULL,NULL,'9b0f4c33-4420-4c1a-a158-285c77d7ac98'),
(366,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:41','2025-08-01 18:09:02',NULL,NULL,NULL,'1c397521-de13-43d2-8460-dbda17e5b9dc'),
(367,366,NULL,173,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:02','2025-08-01 18:09:02',NULL,NULL,NULL,'3e8a2f04-8045-4812-af81-174a31a95925'),
(368,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:02','2025-08-01 18:09:12',NULL,NULL,NULL,'8ee85d47-9148-40ec-bd5b-c84d73572f95'),
(369,368,NULL,174,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:12','2025-08-01 18:09:12',NULL,NULL,NULL,'d99724a6-54f1-4049-b361-55adf27661e2'),
(370,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:12','2025-08-01 18:09:33',NULL,NULL,NULL,'2ce7941c-d93f-403c-bfd6-49b638f4035a'),
(371,370,NULL,175,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:33','2025-08-01 18:09:33',NULL,NULL,NULL,'c7581c6a-d0d7-4e1c-a436-ed6c88693ffd'),
(372,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:33','2025-08-01 18:09:44',NULL,NULL,NULL,'18f99c19-28c4-4251-8b65-2eb57599534e'),
(373,372,NULL,176,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:44','2025-08-01 18:09:44',NULL,NULL,NULL,'510e667e-1473-46b5-978c-c3d2101510f6'),
(374,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:44','2025-08-01 18:10:00',NULL,NULL,NULL,'f9783239-388c-401a-8006-ab0e5f64e90c'),
(375,374,NULL,177,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:00','2025-08-01 18:10:00',NULL,NULL,NULL,'cae79123-f9c7-4bf7-86e4-deb1ead10b4c'),
(376,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:00','2026-01-17 18:33:12',NULL,NULL,NULL,'82798d00-f457-47dd-a197-136a8979cb07'),
(377,376,NULL,178,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:07','2025-08-01 18:10:07',NULL,NULL,NULL,'539ea850-c01d-4267-a3ee-4238f88ce5cc'),
(378,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:07','2025-08-01 18:10:18',NULL,NULL,NULL,'8e689347-9d85-4f7e-98a0-fedc85d7efd8'),
(379,378,NULL,179,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:18','2025-08-01 18:10:18',NULL,NULL,NULL,'c04693d2-c401-4525-a351-aada42c7ef60'),
(380,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:18','2026-01-17 18:31:21',NULL,'2026-01-17 18:31:21',NULL,'5f7daf9d-7dfe-4651-aabb-f38c89bbee1a'),
(381,380,NULL,180,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:31','2025-08-01 18:10:31',NULL,'2026-01-17 18:31:21',NULL,'86babb64-34dc-45a1-863a-3200a52b8b2b'),
(382,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:45','2025-08-01 18:10:53',NULL,NULL,NULL,'59cac7d1-17fd-4d38-bb0d-aeabbdf85711'),
(383,382,NULL,181,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:53','2025-08-01 18:10:53',NULL,NULL,NULL,'99f0f1cb-7140-453a-97a3-2347159ad061'),
(384,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:57','2025-08-01 18:11:04',NULL,NULL,NULL,'f25f3853-7910-43ae-8a40-77d2c8cb955a'),
(385,384,NULL,182,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:04','2025-08-01 18:11:04',NULL,NULL,NULL,'2e6ec653-4724-40f0-9825-e0f16f6bfa46'),
(386,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:07','2025-08-01 18:11:17',NULL,NULL,NULL,'368912c4-ff2f-4791-b5f7-c7ab02e9366d'),
(387,386,NULL,183,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:17','2025-08-01 18:11:17',NULL,NULL,NULL,'c73507a9-d3c1-44e8-a1e5-6d417be2f20d'),
(388,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:20','2025-08-01 18:11:31',NULL,NULL,NULL,'95c17a71-7dbc-4bb1-bd1b-f68eef362ae3'),
(389,388,NULL,184,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:31','2025-08-01 18:11:31',NULL,NULL,NULL,'64da7682-e0dd-47fb-b824-18f245cc4a96'),
(390,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:35','2025-08-01 18:11:48',NULL,NULL,NULL,'86133147-b29a-42ed-adea-703e49287bba'),
(391,390,NULL,185,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:48','2025-08-01 18:11:48',NULL,NULL,NULL,'46f0d01f-8e54-45ad-82ce-574f2ca3b97b'),
(392,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:48','2025-08-01 18:12:02',NULL,NULL,NULL,'a250b11d-668e-42db-a3ef-4c92bd5c2c11'),
(393,392,NULL,186,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:02','2025-08-01 18:12:02',NULL,NULL,NULL,'c44b8aa0-829f-41d8-a2aa-564b5dca44b4'),
(394,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:03','2025-08-01 18:12:14',NULL,NULL,NULL,'673dd0fa-da64-4850-b460-39601e040741'),
(395,394,NULL,187,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:14','2025-08-01 18:12:14',NULL,NULL,NULL,'0a5a42ce-c4c8-4c85-bc6d-895c165cae4d'),
(396,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:14','2025-08-01 18:12:26',NULL,NULL,NULL,'bdb1359d-c180-4611-8a95-2eb8b1f816e1'),
(397,396,NULL,188,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:26','2025-08-01 18:12:26',NULL,NULL,NULL,'71b23c28-a5f2-4207-af9d-f5d212218964'),
(398,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:26','2025-08-01 18:12:34',NULL,NULL,NULL,'0cb6c888-0464-4bbb-a350-e279e9d68b35'),
(399,398,NULL,189,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:34','2025-08-01 18:12:34',NULL,NULL,NULL,'790a58f9-967e-4233-ba06-bf22f9465677'),
(400,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:46','2025-08-01 18:12:57',NULL,NULL,NULL,'c6ca4057-3b10-40f6-a7b5-bbf90d2b25aa'),
(401,400,NULL,190,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:57','2025-08-01 18:12:57',NULL,NULL,NULL,'473fe0de-7e10-487c-942b-04510711521b'),
(402,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:57','2025-08-01 18:13:07',NULL,NULL,NULL,'331b5ad6-85d6-4a40-a7e1-cb2cff2685eb'),
(403,402,NULL,191,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:07','2025-08-01 18:13:07',NULL,NULL,NULL,'7bfb3e73-2ffe-4080-843e-56ab6da363c4'),
(404,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:07','2025-08-01 18:13:20',NULL,NULL,NULL,'3a19f3c2-7434-48ca-bb52-5ed62fb004e3'),
(405,404,NULL,192,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:20','2025-08-01 18:13:20',NULL,NULL,NULL,'41e84075-2d04-47a9-bd20-a6c5f2d7f1a0'),
(406,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:20','2025-08-01 18:13:33',NULL,NULL,NULL,'4af36b42-1b01-4cd8-a0aa-90e28d3caa06'),
(407,406,NULL,193,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:33','2025-08-01 18:13:33',NULL,NULL,NULL,'82385c94-48ae-43fa-8fd6-629e2851bf81'),
(408,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:33','2025-08-01 18:13:42',NULL,NULL,NULL,'6df397ab-c7a8-4ca9-afb2-998ca8e61820'),
(409,408,NULL,194,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:42','2025-08-01 18:13:42',NULL,NULL,NULL,'62d62837-bd43-4e98-a743-3ac0d3dfccb3'),
(410,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:42','2025-08-01 18:13:53',NULL,NULL,NULL,'adb995c3-6ef3-49fd-b8f8-de40b96021d3'),
(411,410,NULL,195,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:53','2025-08-01 18:13:53',NULL,NULL,NULL,'16dbb9a1-3887-4648-97a1-e0ddda8ddec8'),
(412,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:53','2025-08-01 18:14:03',NULL,NULL,NULL,'278fe834-90b2-40c5-9857-c4d166881f23'),
(413,412,NULL,196,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:14:03','2025-08-01 18:14:03',NULL,NULL,NULL,'69ae175c-0c03-4018-83db-eff2a046c29f'),
(414,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:14:03','2025-08-01 18:14:13',NULL,NULL,NULL,'780c5721-1030-4d98-969b-9deff3557653'),
(415,414,NULL,197,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:14:13','2025-08-01 18:14:13',NULL,NULL,NULL,'7bc31cdf-c3c5-4335-b7bf-cc36f78001bf'),
(457,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:58:35','2025-09-23 20:25:31',NULL,NULL,NULL,'6afe8b39-15ff-42bb-b973-3f0fdc816be2'),
(458,457,NULL,225,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:58:42','2025-08-20 21:58:42',NULL,NULL,NULL,'885e099b-06ad-4ca9-b798-1cc8eb8f0874'),
(459,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:58:47','2025-09-23 21:13:19',NULL,NULL,NULL,'d2b03ab3-9f68-48c7-b08a-fa96143faa3a'),
(460,459,NULL,226,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:58:54','2025-08-20 21:58:54',NULL,NULL,NULL,'4a02cd04-c703-4960-81f6-b02080e8cf60'),
(461,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:02','2025-09-23 20:25:25',NULL,NULL,NULL,'f1b0b1b6-ae43-43c7-bce0-29bcc5cd3a17'),
(462,461,NULL,227,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:06','2025-08-20 21:59:06',NULL,NULL,NULL,'f8ef6ca5-d997-41af-a600-4932f5cfbf34'),
(463,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:10','2025-09-23 20:25:37',NULL,NULL,NULL,'aa400bc6-8fa9-476b-b82a-cd3ccfb1803a'),
(464,463,NULL,228,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:15','2025-08-20 21:59:15',NULL,NULL,NULL,'6dfd32dc-d32f-448f-80f9-9f9c7eb16450'),
(465,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:23','2025-09-23 21:13:37',NULL,NULL,NULL,'25b87173-d04e-40ab-bd45-abe288dd5941'),
(466,465,NULL,229,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:33','2025-08-20 21:59:33',NULL,NULL,NULL,'bd10878c-d3f4-4a77-aac0-26a4ce94cd6f'),
(467,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:39','2025-09-23 20:25:55',NULL,NULL,NULL,'6ff7afbb-4b9a-483f-9da6-218c3997ad6f'),
(468,467,NULL,230,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:45','2025-08-20 21:59:45',NULL,NULL,NULL,'7a32a7f2-637a-4b64-8ae7-7cb144e935b2'),
(469,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:56','2025-09-23 20:26:04',NULL,NULL,NULL,'cd4f4662-0b03-4087-9e8f-1b485f959b82'),
(470,469,NULL,231,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:03','2025-08-20 22:00:03',NULL,NULL,NULL,'3131549f-c089-4f69-96e5-e59fde4a9009'),
(471,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:03','2025-09-23 20:26:11',NULL,NULL,NULL,'f4ec289c-bde1-4c45-bfbb-5c1069a516e0'),
(472,471,NULL,232,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:11','2025-08-20 22:00:11',NULL,NULL,NULL,'d12f9c87-584a-4bbf-be08-e02a6ca26147'),
(473,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:11','2025-08-20 22:00:22',NULL,NULL,NULL,'e0971592-0abc-45c9-9817-fa746354d89b'),
(474,473,NULL,233,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:22','2025-08-20 22:00:22',NULL,NULL,NULL,'ce04c12a-98d4-449f-8835-7c027df5d590'),
(475,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:31','2025-09-23 20:26:26',NULL,NULL,NULL,'544f9c74-39e1-48a1-b848-5c91ce2903e3'),
(476,475,NULL,234,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:38','2025-08-20 22:00:38',NULL,NULL,NULL,'7a1268bf-5a4e-4e66-95a8-801a89088c9f'),
(477,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:42','2025-09-23 20:26:34',NULL,NULL,NULL,'aab1bf62-810e-4549-8f8d-319f5098e937'),
(478,477,NULL,235,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:46','2025-08-20 22:00:46',NULL,NULL,NULL,'f83a6d0f-e336-4b20-94d9-f7a5bea8f26f'),
(479,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:52','2026-01-13 18:02:31',NULL,NULL,NULL,'5824e18b-943c-49f4-aee0-26e9486372c4'),
(480,479,NULL,236,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:59','2025-08-20 22:00:59',NULL,NULL,NULL,'6ac0ebba-f48a-49af-a6fc-eb49875f0a4c'),
(481,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:02','2025-09-23 20:26:54',NULL,NULL,NULL,'53138f5c-15f3-46af-9c57-838c36ff6907'),
(482,481,NULL,237,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:08','2025-08-20 22:01:08',NULL,NULL,NULL,'592f6284-128f-4372-8839-e24271e9a5e0'),
(483,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:12','2025-09-23 20:27:03',NULL,NULL,NULL,'db4fc231-4ebe-49dd-9e62-ea62d3c23f72'),
(484,483,NULL,238,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:17','2025-08-20 22:01:17',NULL,NULL,NULL,'485ae322-0a90-47c8-aa28-1a535baff5c5'),
(485,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:22','2025-09-23 20:27:13',NULL,NULL,NULL,'019352c4-069d-42e8-8424-ac0de36a3ff3'),
(486,485,NULL,239,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:30','2025-08-20 22:01:30',NULL,NULL,NULL,'5b15e794-120c-4028-a939-70a24320f03a'),
(487,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:56','2025-09-23 21:13:50',NULL,NULL,NULL,'12909ae0-a512-4b87-a2de-762fc097ba48'),
(488,487,NULL,240,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:03','2025-08-20 22:02:03',NULL,NULL,NULL,'8f2f40b7-c8dd-4269-9a64-5ebeb4c3c3fb'),
(489,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:05','2025-09-23 20:29:09',NULL,NULL,NULL,'25f98012-5633-4829-b941-2757508affba'),
(490,489,NULL,241,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:13','2025-08-20 22:02:13',NULL,NULL,NULL,'b7550ee6-d64a-4724-9914-4c567aa2ece7'),
(491,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:13','2025-09-23 20:29:17',NULL,NULL,NULL,'50117c21-038a-42be-bf0c-d5732fc15be7'),
(492,491,NULL,242,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:19','2025-08-20 22:02:19',NULL,NULL,NULL,'43c9b5a3-7c85-4352-a122-8a3f4c8a8616'),
(493,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:23','2025-09-23 20:29:24',NULL,NULL,NULL,'c8d4490f-c38e-4c36-a37e-57c3a8a9b1a3'),
(494,493,NULL,243,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:28','2025-08-20 22:02:28',NULL,NULL,NULL,'1861e046-fd59-41b8-beb6-8ec6c9a75cec'),
(495,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:28','2025-09-23 20:29:38',NULL,NULL,NULL,'5e632a25-c3f5-48b7-b309-57ff17c2b80f'),
(496,495,NULL,244,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:34','2025-08-20 22:02:34',NULL,NULL,NULL,'c838b1bb-69d2-47a9-a1c1-1a84fde8ca9a'),
(497,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:53','2025-09-23 21:13:43',NULL,NULL,NULL,'68eb2786-c4db-4964-b947-56e3b1a85a38'),
(498,497,NULL,245,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:59','2025-08-20 22:02:59',NULL,NULL,NULL,'01d3e7fa-cfdf-4d96-b03e-c0e321fbc668'),
(545,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-09-02 20:43:21','2026-01-12 19:44:17',NULL,NULL,NULL,'b2b558ce-cd40-4d4c-a797-ca5bb55acd23'),
(548,NULL,NULL,NULL,9,'craft\\elements\\Asset',1,0,'2025-09-02 21:15:29','2025-09-02 21:15:29',NULL,NULL,NULL,'229e6ff4-c6db-48ed-8904-f9db2161ad70'),
(554,NULL,NULL,NULL,16,'craft\\elements\\GlobalSet',1,0,'2025-09-02 21:50:29','2026-01-19 19:13:43',NULL,NULL,NULL,'ac2e66d3-984a-4e83-b29d-422f84e8c085'),
(555,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:24:40','2025-12-05 19:07:35',NULL,NULL,NULL,'d84d167e-eaf4-4415-99d2-ab38cfaa1965'),
(556,555,NULL,273,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:24:46','2025-09-02 22:24:46',NULL,NULL,NULL,'6a620e7e-d6e3-4a23-a5f8-6258867f4daa'),
(557,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:24:46','2025-12-05 19:07:35',NULL,NULL,NULL,'1cee90b2-4187-4b57-a0bd-db245bf510a1'),
(558,557,NULL,274,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:24:52','2025-09-02 22:24:52',NULL,NULL,NULL,'f836702a-f488-4fee-90ed-15f1cb5bb4a1'),
(559,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:24:52','2025-12-05 19:07:35',NULL,NULL,NULL,'2abc4ce0-fc48-4a6c-9c02-573fdcccfd9e'),
(560,559,NULL,275,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:24:59','2025-09-02 22:24:59',NULL,NULL,NULL,'0264ae86-3a96-46f7-837a-1ee4c05e4104'),
(601,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:04','2026-01-17 19:31:06',NULL,NULL,NULL,'9a0f8b68-a562-4873-b0ed-8507a6b25f6a'),
(602,601,NULL,294,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:33','2025-09-03 21:48:33',NULL,NULL,NULL,'5493f4d8-9cd9-489a-9503-1616b9080fd0'),
(605,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:47','2025-10-03 20:24:40',NULL,NULL,NULL,'81303c7f-793e-4e55-bfa7-c02492f7c347'),
(606,605,NULL,296,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:52','2025-09-03 21:48:52',NULL,NULL,NULL,'7f0e29a6-41f3-45fd-925d-fd9e234a832a'),
(607,605,NULL,297,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:49:15','2025-09-03 21:49:15',NULL,NULL,NULL,'da47c1b6-8b38-4b88-808b-a3c12590b010'),
(608,601,NULL,298,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:49:20','2025-09-03 21:49:20',NULL,NULL,NULL,'6b9349c5-491f-4b98-9c0c-558baa78c3dd'),
(609,601,NULL,299,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:49:25','2025-09-03 21:49:26',NULL,NULL,NULL,'7d47a22a-2b18-45e2-a9be-172f304f50b1'),
(610,601,NULL,300,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:52:33','2025-09-03 21:52:33',NULL,NULL,NULL,'187fd43b-d044-4624-afc8-234a7d9a5532'),
(612,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-03 21:56:34','2025-09-03 21:56:34',NULL,NULL,NULL,'b6a9c079-dc19-4954-b3f6-6ac89a38efea'),
(613,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-03 21:56:34','2025-09-03 21:56:34',NULL,NULL,NULL,'201462f8-ba2a-4661-84ed-78215a573b9d'),
(614,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-03 21:56:35','2025-10-08 18:25:13',NULL,NULL,NULL,'1c2571b2-105d-4981-882f-33972a3fa4f6'),
(616,601,NULL,301,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:56:43','2025-09-03 21:56:43',NULL,NULL,NULL,'271d147f-fb1b-4556-92ef-f203c3166ec0'),
(617,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:56:43','2025-10-03 20:24:49',NULL,NULL,NULL,'17aedcab-15f5-449a-a2ee-a3f262aa4476'),
(618,617,NULL,302,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:56:47','2025-09-03 21:56:47',NULL,NULL,NULL,'87697077-a17f-4c23-aae4-1a85ccbe1848'),
(619,617,NULL,303,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:56:57','2025-09-03 21:56:57',NULL,NULL,NULL,'7cdd5ba4-6db4-41b5-9831-12e4bdbcac37'),
(621,617,NULL,304,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:57:10','2025-09-03 21:57:10',NULL,NULL,NULL,'13fcae8c-1e31-42a7-8a3a-cb30b2361924'),
(623,605,NULL,305,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:58:30','2025-09-03 21:58:30',NULL,NULL,NULL,'396501be-a3ae-4f36-9f6a-93100cf965c8'),
(629,601,NULL,308,5,'craft\\elements\\Entry',1,0,'2025-09-03 22:13:41','2025-09-03 22:13:41',NULL,NULL,NULL,'f99e598e-5b3f-408e-a17b-84356450ed28'),
(632,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-09-03 22:27:11','2025-09-03 22:27:11',NULL,NULL,NULL,'091c844c-50d7-4e50-bafa-a6bf56239538'),
(634,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-09-03 22:27:23','2025-09-03 22:27:23',NULL,NULL,NULL,'a5ef07ab-c50e-4220-a35a-0951d700536e'),
(945,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-19 21:03:40',NULL,NULL,NULL,'48a6c670-2b37-4c4d-8fd4-53ac20d90d2e'),
(946,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:16',NULL,'2025-09-11 18:51:16',NULL,'4677fc2c-6108-4598-bf64-bb392f01fb31'),
(947,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:16',NULL,'2025-09-11 18:51:16',NULL,'f6d15841-9c18-449c-9709-1cd9541bfcad'),
(948,945,NULL,518,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'d00d49ed-451a-4fdb-b911-c0dd3830e8f8'),
(949,946,NULL,519,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:16',NULL,'23bd81a5-b057-407f-9a12-423c4b17248f'),
(950,947,NULL,520,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:16',NULL,'429de7e3-148b-4e9e-b6f2-6e307adc6d7a'),
(951,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-19 17:36:22',NULL,NULL,NULL,'41b0861e-5cf7-40dd-9483-713f223be7e6'),
(952,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'b98b3342-f7f3-4cf7-a606-dfb8d8c57213'),
(953,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'7d66e02a-7cd7-43c9-b9f7-242ee195d3c9'),
(954,951,NULL,521,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'fee03515-569f-49ee-adf2-268d99539a65'),
(955,952,NULL,522,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'5e020e4c-9336-4523-a3b6-35fd878e2937'),
(956,953,NULL,523,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'408b201e-e403-43ec-ac8e-74c31393f3af'),
(957,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-19 21:01:27',NULL,NULL,NULL,'e399c88e-b5dc-4726-a6ed-2abac9d595cb'),
(958,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'c8a9aff4-6509-4848-8d3d-9f4311033df8'),
(959,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'14f9dc98-7af4-4950-8606-ecec2f3929d4'),
(960,957,NULL,524,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'e8874927-9f48-44ab-8399-c26f2b036a0d'),
(961,958,NULL,525,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'2448fede-bcb5-4ace-98a8-aff6695e4df6'),
(962,959,NULL,526,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'dc2ae1c5-62d2-40ce-8ed1-24d8733e65a1'),
(963,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-19 21:10:31',NULL,NULL,NULL,'73fa4e85-c923-4543-bb10-e2c4af7a8a17'),
(964,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'d81c823d-a779-49e9-a216-23cfb46cb460'),
(965,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'c254f4b1-a25c-4871-9fd3-69b5afebe8e6'),
(966,963,NULL,527,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'a21fa523-80fb-46ea-805c-0c79a2c01954'),
(967,964,NULL,528,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'3b464a7a-52fc-4e24-99dd-2d4eb9706fae'),
(968,965,NULL,529,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'dd64d8f9-be2f-40d1-a9ca-4b9f3cb36958'),
(969,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-19 21:11:44',NULL,NULL,NULL,'07e32559-1a52-481c-b6b0-cf9c82ae6850'),
(970,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'4d8952f3-ed9d-425f-9e15-5fe6f7bf26b6'),
(971,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'93a39675-83de-4d41-baf4-5f48eee70b29'),
(972,969,NULL,530,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'c5660b75-e1ce-4318-829a-c60ac71b25e8'),
(973,970,NULL,531,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'3b3fa9f9-a462-4c4c-af1f-83cd52d5b165'),
(974,971,NULL,532,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'5cf0cb2a-e814-4b30-b488-c2c1cfb581d2'),
(975,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-19 21:12:21',NULL,NULL,NULL,'2dc195b1-ef47-4f8b-8fe9-340e9da84901'),
(976,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'faa48ae5-3e79-4c59-bdc6-2aa586af5553'),
(977,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'5a8b5a39-85df-41bb-ac1e-10d860fe42e0'),
(978,975,NULL,533,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'67175160-28fc-4c6a-a070-f0ba8162580d'),
(979,976,NULL,534,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'d210c426-699d-4eea-b8e5-a8b22c5e5779'),
(980,977,NULL,535,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'4bd07ed0-8527-413c-9091-b6850b773e2c'),
(981,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-19 21:12:54',NULL,NULL,NULL,'1ce07899-fff0-4291-a8ab-81cc5f758ceb'),
(982,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'89785f90-186f-4e20-92e2-e4e13eb3fc91'),
(983,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'a60ca119-2b59-4ec7-9c47-0b6792cb9a53'),
(984,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'f8804960-fbb9-4691-82e6-47af75a67885'),
(985,981,NULL,536,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'2ff31236-ba07-46cb-8b22-885f7da30d1c'),
(986,982,NULL,537,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'f60b78b7-d499-4613-b9b2-3553ca165c5d'),
(987,983,NULL,538,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'f7435bea-b704-4e70-8961-143d3c3c1579'),
(988,984,NULL,539,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'cffbb52c-6dd3-4743-9b5d-a7ef325b2175'),
(989,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-19 21:13:24',NULL,NULL,NULL,'24ff8e10-f560-4744-b23a-be3b06e92a17'),
(990,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'55bd04a3-719f-48ca-b282-f2dd4556d0a2'),
(991,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'ce6367da-e26a-4506-a8ab-ce07526e1b47'),
(992,989,NULL,540,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'8886d22b-fe27-466a-b242-7a796f6f2f45'),
(993,990,NULL,541,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'122bb9c9-b72a-463f-9f48-f8cbaed95ea6'),
(994,991,NULL,542,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'74190f3a-9041-428a-b16e-ee4741323fee'),
(995,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-20 14:49:28',NULL,NULL,NULL,'9e6b6166-fdac-4d25-a9fd-5af0c347d533'),
(996,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'430a0992-651a-4999-8ab8-3ec562e0a769'),
(997,995,NULL,543,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'7cf080d4-86a9-4aaa-b315-118ae1207f6e'),
(998,996,NULL,544,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'d1d4a4a6-1fd3-447f-b00f-bed7b6dcbab5'),
(999,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-19 21:14:38',NULL,NULL,NULL,'6e18b054-3c3d-4c80-b7f6-2f7880b2b470'),
(1000,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'a221ac78-813c-4565-a618-069c18a125bd'),
(1001,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'4827e856-5dff-48af-b34b-97be57272aaf'),
(1002,999,NULL,545,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'e891c1c5-3d90-4227-94fa-cef374a97e4b'),
(1003,1000,NULL,546,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'7ffbf820-c595-4969-a049-c838993ee417'),
(1004,1001,NULL,547,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'e606e83b-c362-4d1f-aa6f-1c9fe4541cff'),
(1005,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-19 21:15:16',NULL,NULL,NULL,'5a87fb4c-c5fd-47b4-869e-ec6321ddf8d9'),
(1006,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'3de731a8-bb64-4220-8e1f-15102b5d8ee1'),
(1007,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'3414182c-7409-4c4f-a868-6c5f349bcd3c'),
(1008,1005,NULL,548,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'dda5d0cb-58f2-4149-958f-32b48f2bf45d'),
(1009,1006,NULL,549,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'9c234813-244f-415d-9dd0-21715c828f5f'),
(1010,1007,NULL,550,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'cbe40bb5-8ea1-4a4b-9770-3985889f0b8e'),
(1011,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-19 21:15:47',NULL,NULL,NULL,'95bbd3aa-0bb6-4efa-a47a-610d2b4e2cb3'),
(1012,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'6f95a7aa-4f67-469f-8038-8afcdb7c9685'),
(1013,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'c5bb4917-076b-4924-aec1-fd0c4f79a42c'),
(1014,1011,NULL,551,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'27bbd0e6-a56f-4a3f-8839-fd58d1be5299'),
(1015,1012,NULL,552,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'4e7c266d-b559-4240-af3a-f6a2b9e4360c'),
(1016,1013,NULL,553,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'13978b24-0157-45b8-b886-e9785b0e7126'),
(1017,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2026-01-19 21:16:20',NULL,NULL,NULL,'ce3eb7f7-2f87-4b59-9c53-05e0f3c21178'),
(1018,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'856571b0-b255-41c6-a5ae-a33bc32ab06c'),
(1019,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'c4a42116-23b5-4e52-a424-0c665420ab56'),
(1020,1017,NULL,554,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'cd4d931f-c631-47a8-8828-141c1add0474'),
(1021,1018,NULL,555,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'9cf29ee2-f40a-4ef9-ac7d-18404b1d9b61'),
(1022,1019,NULL,556,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'7c7e60b6-0853-480d-8577-ba223745e3ed'),
(1023,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-20 14:50:45',NULL,NULL,NULL,'f2039029-4db6-41fc-921f-6c250bc2b9d7'),
(1024,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'8d5e81f6-0e55-41b8-8147-3c13b5c87e67'),
(1025,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'668a4d24-7a2a-4c68-9eeb-6c95e34557bd'),
(1026,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'0d0fa5bf-4df1-4cf8-8f5c-24033275e48a'),
(1027,1023,NULL,557,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'cf8f523b-2ab7-4b05-8d54-9f197787cf21'),
(1028,1024,NULL,558,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'de20176b-6d25-4248-867c-9a8d438ac844'),
(1029,1025,NULL,559,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'0a9d5a84-0170-4d86-9106-105a3cb1a981'),
(1030,1026,NULL,560,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'6cff5b11-ddd8-4bd5-99a9-46539fc264ae'),
(1031,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-17 20:48:08',NULL,NULL,NULL,'950498f4-be9d-468b-a88c-f8c53d277de3'),
(1032,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'e0e830b2-2fe5-4efe-a492-5e1071461d5d'),
(1033,1031,NULL,561,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'93d7bde7-5e6f-49e9-b08e-455f032272e1'),
(1034,1032,NULL,562,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'d6be10d9-eee2-48c5-90db-d4f0b2c95a8d'),
(1035,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-19 21:17:42',NULL,NULL,NULL,'4c1f47b4-c776-4a3d-91bf-971cca51fc46'),
(1036,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'b1af9f9e-abb0-4b93-9b79-b41ad65d5667'),
(1037,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'b9615338-fd34-496d-b5b4-a1aedd0ec222'),
(1038,1035,NULL,563,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'5c1a9229-e14b-451a-b8c1-1e924c7e046c'),
(1039,1036,NULL,564,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'88a3cd53-502a-4fe7-83b5-4b381adcf1c8'),
(1040,1037,NULL,565,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'65be40ee-c2e1-472f-be8a-2639abc82794'),
(1041,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-19 21:18:12',NULL,NULL,NULL,'3de194dc-8f35-4e34-862d-7ec10c5e8f04'),
(1042,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'5baa6d92-c54a-4dc2-8217-dd570508fd35'),
(1043,1041,NULL,566,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'636fe767-0234-4469-80ab-8bbf0036bac8'),
(1044,1042,NULL,567,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'9f984eb8-4779-4ee1-b5ed-ba9f407893d1'),
(1045,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-18 19:25:46',NULL,NULL,NULL,'dec3ccf7-835a-4e35-8f30-b2b10064595e'),
(1046,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'0102d6b3-5998-40fc-93e2-ac2442ddb221'),
(1047,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'af9ae13b-1806-43f1-9cd4-d01bf7ea63db'),
(1048,1045,NULL,568,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'966f7852-e2ba-4820-93ab-097a0f43f29d'),
(1049,1046,NULL,569,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'d76acbc8-371a-40ac-bd6f-602642269fd9'),
(1050,1047,NULL,570,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'34283c57-d2ab-4f7a-83ca-aee032db2306'),
(1051,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-18 22:28:28',NULL,NULL,NULL,'7ecdfcf7-57f3-4966-92e3-a846e195f1f0'),
(1052,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'3953c615-c4f9-4b23-b206-81680036bf19'),
(1053,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'50fb3de6-c544-4fae-ba32-9c102626cde3'),
(1054,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'891675f1-6ee0-45e7-a0ee-c5f1def29961'),
(1055,1051,NULL,571,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'746107ef-7585-441e-90aa-bfcee8ce2a05'),
(1056,1052,NULL,572,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'0ad6941f-640f-497f-a520-3f6f0d612754'),
(1057,1053,NULL,573,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'bd598fbf-d50d-4281-9c88-da2c39fe2bd3'),
(1058,1054,NULL,574,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'f3e4bff4-6dd7-459b-81ab-324d84025de5'),
(1059,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-17 20:52:03',NULL,NULL,NULL,'1db34b40-992e-4b6a-957b-2ab444012d2d'),
(1060,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'82dd976d-5d80-4d37-91c2-975c5bfa56b7'),
(1061,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'69532f71-ad21-4e1f-8838-d65bfcaf6fb2'),
(1062,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'35450d10-89b4-4158-a5c5-02e9ce986870'),
(1063,1059,NULL,575,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'bb9c87b2-9543-4600-8052-8186727edb3c'),
(1064,1060,NULL,576,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'3320e605-1717-45f8-b8cb-051aa2ad09d2'),
(1065,1061,NULL,577,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'fad8af60-3f9b-4e49-8dce-0b22322826ff'),
(1066,1062,NULL,578,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'a7f11528-4355-46a5-9bf5-8564a92ea7a7'),
(1067,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-17 20:52:55',NULL,NULL,NULL,'3e896674-276a-4fac-9bae-6043a7566c71'),
(1068,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'1ea44685-d248-47ea-a73f-c1c827d519db'),
(1069,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'ffafd33f-b84a-4f08-9c4f-eb356107eb89'),
(1070,1067,NULL,579,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'096a387c-cf17-4eb7-baee-66df6d186421'),
(1071,1068,NULL,580,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'43db53d3-3109-4eaa-ab04-7792f01bd012'),
(1072,1069,NULL,581,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'bac4d24a-213e-45d3-99c3-97f84f2c20c8'),
(1073,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-17 20:54:09',NULL,NULL,NULL,'cf2218ca-b445-43a5-9a1f-3eb02abce60c'),
(1074,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'a5d8c15e-e74c-42ca-a88e-07f359c881fa'),
(1075,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'fea85ae0-fddf-4c69-b29b-41a708363761'),
(1076,1073,NULL,582,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'e3331081-443b-456e-8bdc-49788985f4d5'),
(1077,1074,NULL,583,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'2f0a8a72-810c-4661-9912-0cb05b93f112'),
(1078,1075,NULL,584,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'3eb1a75d-afb1-49e9-8bff-d4863316d87b'),
(1079,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-18 22:28:58',NULL,NULL,NULL,'5ae1ceec-e10f-482d-9b12-2d210b34fc9c'),
(1080,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'4f3429eb-9312-4dc9-87b3-f10cb743c365'),
(1081,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'40bc5374-c46c-4484-95ae-bc223a6c29c5'),
(1082,1079,NULL,585,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'b3b33bb7-7fdc-4d82-a425-80bc21f95332'),
(1083,1080,NULL,586,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'8ee0a6fc-a030-4d6c-ab6b-22b9dcab8887'),
(1084,1081,NULL,587,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'bdba192b-c83b-4bcf-87a1-15c2dfac991d'),
(1085,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-17 20:55:02',NULL,NULL,NULL,'560ed462-30a9-4c94-a0de-7d5cbce1bb13'),
(1086,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'964b1887-b339-4799-bc22-3d38f1bcec99'),
(1087,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'170b6a26-1f00-43fd-a16d-b8e1de89f362'),
(1088,1085,NULL,588,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'ab6e9010-8c9d-43fd-9921-66e64b8f3ab1'),
(1089,1086,NULL,589,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'cce369e7-aff6-45ee-b1d0-f4d8e1ef17ed'),
(1090,1087,NULL,590,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'ad74462a-0acc-45d9-88f3-74dbd4ac8ccb'),
(1091,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-17 20:55:36',NULL,NULL,NULL,'af8ab057-06a9-44da-a782-bce073caf3f7'),
(1092,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'1ab57f16-7dd2-438e-a80d-55d999c71173'),
(1093,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'19434827-facd-4a27-a494-9872800b7c00'),
(1094,1091,NULL,591,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'f310452f-bef2-43da-955e-ab8bbcfa8936'),
(1095,1092,NULL,592,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'f765ad23-369d-4e1e-9b9a-6d08b3eef309'),
(1096,1093,NULL,593,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'e183a3be-1a97-4aba-b30e-f87a1b5254ee'),
(1097,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-17 20:56:08',NULL,NULL,NULL,'e6a0a789-a128-4e9b-877e-cc076269bc49'),
(1098,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'c0cd0323-daed-4e05-964d-af8a63249fa5'),
(1099,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'cbb49a99-c13e-4eba-8c34-6b8a23387b19'),
(1100,1097,NULL,594,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'e6edc4a4-2f7c-41cf-8384-f76b0f961a5b'),
(1101,1098,NULL,595,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'87a71333-86d7-4929-a0cf-353398a98599'),
(1102,1099,NULL,596,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'c1e44615-926b-4d1c-882a-0bd8360c9c30'),
(1103,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-17 20:56:47',NULL,NULL,NULL,'f53d9228-7793-482e-ad9e-9266a29f470d'),
(1104,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'f7c584cc-48e7-443b-90ff-acf209238b46'),
(1105,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'338f45dd-aa66-42a4-85c1-bb6256261b91'),
(1106,1103,NULL,597,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'5bff26aa-4fa4-4926-8f2d-625ffd7225d3'),
(1107,1104,NULL,598,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'f70e062a-9e97-48e5-b354-19a4e919e692'),
(1108,1105,NULL,599,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'ef740bed-8b65-4b82-98a6-0027eeeeec08'),
(1109,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-17 20:57:14',NULL,NULL,NULL,'398ec3ba-8547-4d8c-a91c-a2de31cf9d20'),
(1110,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'2b7e749b-c62a-4693-a91a-46f8b6ddcba2'),
(1111,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'6e2b9404-765f-4991-be6b-a12b2991259d'),
(1112,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'14548fc8-ebd3-4568-889c-d54db90c442c'),
(1113,1109,NULL,600,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'844070a9-93f6-437e-96ea-3f24a1fe5866'),
(1114,1110,NULL,601,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'2e6602ca-b53e-4dec-81ac-01c98ac5f553'),
(1115,1111,NULL,602,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'05ec7e05-5c60-4b67-882e-66edaf355367'),
(1116,1112,NULL,603,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'c6c82188-bb68-421b-90c7-28bb67edbd81'),
(1117,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2026-01-17 20:58:03',NULL,NULL,NULL,'a08d8d64-84ed-4630-94bb-e92bb7619949'),
(1118,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'8bf0c634-b6dd-4835-a858-7057529489d2'),
(1119,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'cf758b45-6e11-4945-90c5-db861a5d0b8f'),
(1120,1117,NULL,604,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'f4d033fd-dcd7-43cb-aef9-37d702ce7efa'),
(1121,1118,NULL,605,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'d1ab9b0d-752d-4163-b91e-123f67052b84'),
(1122,1119,NULL,606,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'dc20d49e-5b88-4a95-af7e-d615672a0254'),
(1123,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-18 22:29:23',NULL,NULL,NULL,'5706c4a0-fcfc-4823-a969-32440ed553a3'),
(1124,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'3fe3895a-f641-40f0-91f0-a2121e5e757c'),
(1125,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'e8fe88b5-9df3-430c-8f7f-3f6d22cfa580'),
(1126,1123,NULL,607,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'6564539b-e5a1-48dd-8d99-f86a99df55e0'),
(1127,1124,NULL,608,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:20',NULL,'d852d746-ed46-4090-9777-9211be73fde7'),
(1128,1125,NULL,609,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:20',NULL,'452d4af9-a048-4f88-9abc-bf8f8e74f3da'),
(1129,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-17 20:59:26',NULL,NULL,NULL,'28a28f32-135b-474d-9045-2fb69fbcde32'),
(1130,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'18e5ed3e-7421-486b-bb13-99055ff0fb06'),
(1131,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'2e0c9d8b-55c1-48c5-9a02-d2737801c6c6'),
(1132,1129,NULL,610,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'291813ba-7229-4de4-aba7-911ce4ac6394'),
(1133,1130,NULL,611,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:20',NULL,'0949fa92-a911-4736-bf34-7e8223a20bbe'),
(1134,1131,NULL,612,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:20',NULL,'714fd2cd-0dd2-435d-a421-ba319c18ce94'),
(1135,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-17 20:59:56',NULL,NULL,NULL,'5851bd11-29aa-43b3-b611-fc88dd5e211d'),
(1136,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'c6dee479-40b3-430e-9858-341e650d0ab5'),
(1137,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'05d9e4a1-4db0-4349-abc1-7b8c59745877'),
(1138,1135,NULL,613,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'7708f32d-a59e-406a-840f-f9bf1dd0b749'),
(1139,1136,NULL,614,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'42a075b2-2fef-4890-9730-78a79bbc30d6'),
(1140,1137,NULL,615,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'3e62702c-29e4-422e-8ca8-7339310e88c5'),
(1141,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-12 18:27:00',NULL,NULL,NULL,'1d957e72-1e3c-4f74-8b78-4c0e762aab48'),
(1142,1141,NULL,616,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'4f267a08-11ce-418a-ac1f-6be097019354'),
(1143,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-17 21:00:49',NULL,NULL,NULL,'44c0f461-8c7c-4f47-b5f0-717c1c50c7a2'),
(1144,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'87aaf7fe-938f-4de7-b373-ee459a264923'),
(1145,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'f8873476-c276-43f1-8542-a4caab1bd3ba'),
(1146,1143,NULL,617,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'d4e60a3a-c323-4be2-a57f-0f627737705a'),
(1147,1144,NULL,618,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'98327891-4a30-40db-a2b7-fdc217b74322'),
(1148,1145,NULL,619,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'1cf2fd55-9139-4883-a3cc-dde3e269c2bf'),
(1149,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-18 22:29:53',NULL,NULL,NULL,'f381df8f-e64f-4bf2-abd8-61cbfcceaea2'),
(1150,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'a1bbd559-8b53-4167-9115-4e2adef24804'),
(1151,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'ec1adc96-db31-484b-b38c-762fcaaebf7b'),
(1152,1149,NULL,620,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'b136a7dc-9afb-4472-b693-4b52744631b4'),
(1153,1150,NULL,621,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'483bcb91-61eb-4e71-8b68-de6a6513779a'),
(1154,1151,NULL,622,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'43714484-1768-4f83-9ab6-d30e57461fb1'),
(1155,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-18 22:30:17',NULL,NULL,NULL,'c0f22461-831a-49b7-a594-09cc88d08098'),
(1156,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'e4a3bdea-6875-4e60-8be9-d7277eb27ef3'),
(1157,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'55922826-85ab-4780-b623-cadf0c9ea182'),
(1158,1155,NULL,623,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'b8b1578f-dc37-484b-8dab-37b24bd9377b'),
(1159,1156,NULL,624,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'04167b78-fc6a-4be2-a302-8f0b94c0d779'),
(1160,1157,NULL,625,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'ce0d8389-1634-4dbf-9e2d-6074319bdde7'),
(1161,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-20 14:52:47',NULL,NULL,NULL,'09b0cfa0-a3e5-4ad8-996a-8faaef93dada'),
(1162,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'08ecada2-bf45-40c5-b6b0-c36dc2b4d165'),
(1163,1161,NULL,626,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'9c9f8d12-26af-44ec-bf64-114ad399c910'),
(1164,1162,NULL,627,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'e0281d02-7c77-4091-bd6e-6cbd38edf2bc'),
(1165,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-17 21:06:26',NULL,NULL,NULL,'c7655616-7d4f-4c6a-b370-6126b174a372'),
(1166,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'c1ebe08d-fbf7-4c2f-9604-00444aeb05ad'),
(1167,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'85ec9aa3-6b87-4275-a805-73f2756601fa'),
(1168,1165,NULL,628,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'174a460d-f3ba-4c8a-abb3-59cac5feb1a1'),
(1169,1166,NULL,629,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'ef46220a-5e22-4147-af65-ea20db188176'),
(1170,1167,NULL,630,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'5f5b36d1-8f54-4130-ae14-2caeb4bb9092'),
(1171,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-19 20:42:05',NULL,NULL,NULL,'055d79fb-6463-4d54-8399-b6ebcc287543'),
(1172,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'1a1d4edf-2a46-43b7-90d1-7678aac6b95b'),
(1173,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'daa5ed51-917d-4918-ad5f-14e19f004c46'),
(1174,1171,NULL,631,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'c63f66be-908a-45f6-b664-2ae9dffa1cd9'),
(1175,1172,NULL,632,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'69fb9b60-8113-4fe7-9933-15d763968daa'),
(1176,1173,NULL,633,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'a1c4bb3b-e362-4186-9cd4-a0dc87724a6d'),
(1177,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-19 20:43:52',NULL,NULL,NULL,'2be2bbd1-385e-425c-8c2d-272477117748'),
(1178,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:48:37',NULL,'6cf406cf-7a73-438a-a35e-55085b1c4834'),
(1179,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:48:37',NULL,'c9bc5e99-f0a9-48bc-ba8d-ee7a89618626'),
(1180,1177,NULL,634,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'70f1a720-5733-4000-bf9a-20bfec84c620'),
(1181,1178,NULL,635,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:48:37',NULL,'a5299d6f-50e5-4c68-b2db-a911bf3d23de'),
(1182,1179,NULL,636,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:48:37',NULL,'93f7c789-d10a-41e7-905e-175963ccd047'),
(1185,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-20 14:52:39',NULL,NULL,NULL,'89bfa064-7f1a-4480-81eb-bbb78109087f'),
(1186,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'13112f7e-6a50-47cc-85cf-753fcea43111'),
(1187,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'fd5765c6-f665-4a02-815a-5105814ce806'),
(1188,1185,NULL,637,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'526e17f0-4799-4b50-9003-7cae2871fa1f'),
(1189,1186,NULL,638,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'baaa85fd-6100-4868-9429-3e10c48fad6c'),
(1190,1187,NULL,639,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'90b682ef-348b-41a1-b39a-d44e3681d170'),
(1191,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-20 16:08:33',NULL,NULL,NULL,'c917f067-e6d1-42f1-ba71-c9910cdf356f'),
(1192,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'da1a0e04-418a-42e0-a960-44584a7fdb5f'),
(1193,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'9994b8b2-4b7a-43fa-9170-eb4dbec75df9'),
(1194,1191,NULL,640,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'41b9e46c-fa99-46a8-9723-1526a6fa1e6d'),
(1195,1192,NULL,641,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'a37bc56c-550d-4537-8481-97b30c9fc51e'),
(1196,1193,NULL,642,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'5bbd680a-d39e-4ba0-8a2a-39d4704344f9'),
(1197,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-19 20:45:33',NULL,NULL,NULL,'a6698012-4054-4391-80ee-3f26c63ac0cf'),
(1198,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'ad2eba91-fdd1-4990-9a43-f7f0141ca539'),
(1199,1197,NULL,643,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'68d70228-e975-4723-93e4-bb1d919ac31e'),
(1200,1198,NULL,644,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'921c7a77-e591-405c-b040-34de76b14d8f'),
(1201,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-19 20:46:03',NULL,NULL,NULL,'b5c6ccd8-0e99-4efd-a495-8c5c49b45f2d'),
(1202,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'86fdea10-7626-43bc-bbe9-964584761c5d'),
(1203,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'ebe0438c-7661-4587-b14e-a83a21ad065b'),
(1204,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'2d327abb-b910-440f-8f3b-42793de72379'),
(1205,1201,NULL,645,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'4aeac103-0513-44b2-a75b-22fe41ff94a9'),
(1206,1202,NULL,646,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'c713e2b3-a3c2-4d20-bab6-66bae092be4d'),
(1207,1203,NULL,647,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'a17a7dc7-5a10-48fd-8429-362e1ad4b425'),
(1208,1204,NULL,648,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'45a9f629-d9c6-42fa-b588-eddba6553542'),
(1209,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-19 20:46:28',NULL,NULL,NULL,'6426c6e4-aede-4aab-8e51-3605bafda3f2'),
(1210,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'b7dc73bf-effb-4665-b518-2a72a327f95d'),
(1211,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'08f6f1b5-8aff-4d05-8675-164e9b04171c'),
(1212,1209,NULL,649,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'b3eda0a4-8a43-4e74-9355-17b70cee35dc'),
(1213,1210,NULL,650,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'051bd566-20a6-42fe-8817-296144e44534'),
(1214,1211,NULL,651,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'4af34744-eeea-4260-8231-ca668cc192a4'),
(1215,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-19 20:46:54',NULL,NULL,NULL,'5bd94697-9fd6-4d4e-8848-3fe542b3bbda'),
(1216,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'6d71c8ab-c698-4295-b08f-ffa9061c8077'),
(1217,1215,NULL,652,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'12bd724e-8184-4679-9b88-20a39863abf8'),
(1218,1216,NULL,653,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'8c43b830-8619-42d3-ab08-94055ea805c2'),
(1219,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2026-01-19 20:47:18',NULL,NULL,NULL,'a2c697ad-df34-4492-a9f1-dae21a012b6d'),
(1220,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'c6b85159-a923-4cec-9fff-f03161a2efcc'),
(1221,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'5a2a6dfc-82b9-4dcd-8e8f-4c94f5de0e3d'),
(1222,1219,NULL,654,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:38',NULL,NULL,NULL,'dcb64168-cb4b-4687-9e89-63890ed5f69c'),
(1223,1220,NULL,655,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'34480a28-3cd6-4794-a923-a7376e674dbd'),
(1224,1221,NULL,656,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'9ea4b749-d616-48e8-a736-a7f1f2fdf7f7'),
(1225,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-19 20:47:44',NULL,NULL,NULL,'37807e51-bdf9-484c-9984-d3175d293933'),
(1226,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'7204ee6d-8c0a-440d-bbed-ed5ba7c73566'),
(1227,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'f4abdad0-9da1-4584-a755-1ac496074fea'),
(1228,1225,NULL,657,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'a03b6bc5-7bd1-49f0-9358-98d36fdcce53'),
(1229,1226,NULL,658,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'957a9562-56ee-4531-a1b4-e1a063f06e7d'),
(1230,1227,NULL,659,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'6a8f51cd-ead9-4e95-a103-3517f084165a'),
(1231,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-19 20:48:11',NULL,NULL,NULL,'8f0d2923-6550-4757-8bea-573605d2135f'),
(1232,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'0bb10668-8b22-44b4-b00b-62a7aa051d2f'),
(1233,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'1fb3327e-b3f2-4b5c-954c-6bf74d4c60bf'),
(1234,1231,NULL,660,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'23ddadd8-f438-4ec7-9cf8-a36731a6a9d1'),
(1235,1232,NULL,661,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'f8b0db55-cdf6-4da2-b2e2-a90cb9710d08'),
(1236,1233,NULL,662,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'fa93c549-eba1-48dc-b3b6-f0d7638eed41'),
(1237,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-17 21:12:02',NULL,NULL,NULL,'831198a5-a1c7-4506-9bac-ba8a760422f7'),
(1238,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'bbd52683-b622-4e7f-a893-a0cdd535a5fa'),
(1239,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'9c20ffff-befb-443f-90d7-7a162a6452a5'),
(1240,1237,NULL,663,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'1c693d24-a2ba-4121-9892-11d95b30c106'),
(1241,1238,NULL,664,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'b1d6c857-74a6-49d3-b4dd-bf7bd6514fa5'),
(1242,1239,NULL,665,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'07a0b9a0-d137-487e-b40e-389d89424067'),
(1243,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-18 22:31:10',NULL,NULL,NULL,'c5279fef-fc70-454a-9f6b-c8eb84670bf9'),
(1244,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'26e0a0a0-a0c2-4f9b-9a1f-509afdfd0ab6'),
(1245,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'a977cfb5-6806-4611-b0f7-5e758613bd40'),
(1246,1243,NULL,666,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'27795513-a0ac-4529-a8a2-148532aa4999'),
(1247,1244,NULL,667,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'d69d680d-89a1-48b0-bb0c-a2883c2c3be2'),
(1248,1245,NULL,668,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'6c658dea-614a-4ef3-9b57-bd4425deb5a0'),
(1249,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-17 21:13:08',NULL,NULL,NULL,'98f6c7e0-e81c-42ec-8429-6ac1e78827c9'),
(1250,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'e2f8e639-e575-42e9-9e80-fa9c1944a2ff'),
(1251,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'5e65210f-f52e-4202-9f70-a983ed21083f'),
(1252,1249,NULL,669,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'1873b339-5e4d-4b06-ab0c-a83eb068f3bf'),
(1253,1250,NULL,670,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'fcf77344-c556-4172-8f67-0867546ff865'),
(1254,1251,NULL,671,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'093428c5-4db5-41ff-8c0f-0071ab5d4ea7'),
(1255,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-19 16:30:29',NULL,NULL,NULL,'f283d066-0b82-44eb-b879-14ec2219674a'),
(1256,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'c8cefe31-fbf7-4df4-8335-c5249aef2344'),
(1257,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'2f998d89-7531-481e-a73e-25548cab0b9a'),
(1258,1255,NULL,672,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'807ce93c-0611-45cc-86f1-a1752e4144ed'),
(1259,1256,NULL,673,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'76642036-dbbf-438e-93a7-cf306fe8714f'),
(1260,1257,NULL,674,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'3efd6cd6-5025-419b-8254-5cdeb7538790'),
(1261,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-17 20:07:09',NULL,NULL,NULL,'15943273-e8c3-4a51-b5d9-e3fc7cd32a8f'),
(1262,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'669b6452-688a-4133-908c-055a66cff5e1'),
(1263,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'32684ff2-cd50-4bc2-8df8-47ac6c9695a0'),
(1264,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'f584e501-f863-4648-8fd7-9cc2772752c8'),
(1265,1261,NULL,675,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'0a26fa57-210a-4186-80d6-03b48f59656c'),
(1266,1262,NULL,676,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'14de058b-d7c4-4cd1-b4b0-b3a031601409'),
(1267,1263,NULL,677,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'d9652a04-b7d2-47d3-98f4-c924e260267b'),
(1268,1264,NULL,678,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'bb0262df-3c23-4eaa-9d4e-3fb526dd8bf9'),
(1269,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-17 20:07:42',NULL,NULL,NULL,'d3debf21-6311-42d6-a153-c4d5a58464f6'),
(1270,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'87beb08f-b473-4f64-9cfc-55683192267a'),
(1271,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'42e051d9-ffbc-402e-b5dc-b3107c29cafc'),
(1272,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'f358722c-ef6d-4fda-8feb-6b2d93e2a041'),
(1273,1269,NULL,679,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'c0a047e6-f59b-41de-a4f1-89d32e25a0bc'),
(1274,1270,NULL,680,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'611c4c6d-e885-442b-af38-d456a49260d4'),
(1275,1271,NULL,681,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'ebed7c12-2fb9-483c-af57-f2ad48e43bbf'),
(1276,1272,NULL,682,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'a9d29ed5-3300-438c-bb92-b28dd1047f02'),
(1277,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-17 20:08:28',NULL,NULL,NULL,'406cd088-3430-4963-accc-1e6e86db6052'),
(1278,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'aa2d165b-6b89-45f2-a104-ce337866a947'),
(1279,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'fea5f623-4050-40dd-88c2-5ad59110cf95'),
(1280,1277,NULL,683,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'60065f1f-4961-4a9a-a900-814a03d767a5'),
(1281,1278,NULL,684,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'a10bd7a2-0059-4ca0-9c80-faa5ceda7d98'),
(1282,1279,NULL,685,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'94a8740d-e5bd-4f1e-b5d3-cd7d0e8d5247'),
(1283,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-20 14:53:27',NULL,NULL,NULL,'a14f333f-5d97-4f28-adf7-1eb6de8a62dd'),
(1284,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'16f849bf-8b2b-44b3-8c12-54d94e8c6e09'),
(1285,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'77e50c01-3b96-41da-aa5b-29bfbc4816eb'),
(1286,1283,NULL,686,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'b83326e2-4680-4c83-9a5e-a117bad15222'),
(1287,1284,NULL,687,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'9dcfeb26-8b38-403a-ae08-f1818117576e'),
(1288,1285,NULL,688,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'81c3b452-fba1-4ae7-a459-8483baf683d2'),
(1289,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-17 23:05:05',NULL,NULL,NULL,'1e0bb049-da11-4a90-9e51-1549b36f3102'),
(1290,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'b8e0ffb1-5428-4ab7-80c7-77a9fd1fd911'),
(1291,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'064fc539-91b2-4d4e-9566-2ef3bc7143bb'),
(1292,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'0b5324da-3ba4-4600-a30c-ede53304bf82'),
(1293,1289,NULL,689,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'b543b24d-e8a8-4cab-be14-c9d7c7bf30fb'),
(1294,1290,NULL,690,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'ad21d5eb-6be6-4f43-94db-43ba63afe000'),
(1295,1291,NULL,691,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'2efc46dd-208e-46fc-8ba1-1bafefe9dff3'),
(1296,1292,NULL,692,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'03e88e82-4b9a-4ead-86ae-e77f88bc8305'),
(1297,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-18 18:42:31',NULL,NULL,NULL,'63f83f5e-ea30-4d1a-9cd7-742ab2705cc1'),
(1298,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'de4c8138-9138-4c6a-a9a4-8b80bd5bbb5d'),
(1299,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'f2cfc895-91c2-4973-83e3-6409acd12711'),
(1300,1297,NULL,693,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'2d58e33b-1434-472d-b977-53e6be4e270e'),
(1301,1298,NULL,694,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'4cfec8e5-e0b2-4b49-8801-80c343be3782'),
(1302,1299,NULL,695,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'a9d1eb84-e219-462b-9c9e-7834ebc53e8d'),
(1303,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-17 20:10:36',NULL,NULL,NULL,'6f09b6a2-cbf4-472a-9f08-6e209deb09a1'),
(1304,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'20cbbf8d-dd29-4b59-8f34-253a4b57d02a'),
(1305,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'a8d2ac4d-bf5a-45cd-aa39-847cd30098d0'),
(1306,1303,NULL,696,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'f7550701-b282-4c05-865d-2dc9990a6b39'),
(1307,1304,NULL,697,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'b3c00404-2c96-42af-b91c-d090625debee'),
(1308,1305,NULL,698,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'9fbb9366-eb03-4898-976e-b0f0b025bcd5'),
(1309,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-18 18:46:31',NULL,NULL,NULL,'1e37f615-9815-4e6b-bef1-b6c2d9b7f291'),
(1310,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'9968f953-ee7a-43ed-8ccf-d1fbb6c53297'),
(1311,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'2a9caa7f-7ea0-424d-a570-0f087a4a2222'),
(1312,1309,NULL,699,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'20139750-d97a-4693-aa69-39ccdd656367'),
(1313,1310,NULL,700,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'7a6a4d0b-14b3-4689-96ff-bedad8dbee7d'),
(1314,1311,NULL,701,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'4ed5266a-eafa-4dff-8c2f-9809e41f8048'),
(1315,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-18 22:31:53',NULL,NULL,NULL,'af1f0dc9-56db-4a3d-adad-a0710d5382fc'),
(1316,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'8043e61a-5d17-44bb-9058-bc868dc49ce1'),
(1317,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'89ed9071-61ce-44a1-b7f2-c0fc40b5c955'),
(1318,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'4f1e758e-0e34-44b7-baec-2c9eced211e1'),
(1319,1315,NULL,702,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'ecc4c9a2-339a-45bd-bca3-5a269e212c39'),
(1320,1316,NULL,703,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:25',NULL,'874bbcfd-90e9-482b-ab82-2681ec104cdc'),
(1321,1317,NULL,704,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:25',NULL,'08b39ef2-0325-4439-ac82-4f9773940ed7'),
(1322,1318,NULL,705,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:25',NULL,'a309dc10-48fa-4065-9fa7-9c93c32da578'),
(1323,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2026-01-18 22:13:26',NULL,NULL,NULL,'6d44985a-9c4f-4f58-b4ee-714eefdab563'),
(1324,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'e0e43dea-0616-4e0d-bb7d-64ebacc06517'),
(1325,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'09f42432-3df5-4c7c-974b-e8b694ee3c4b'),
(1326,1323,NULL,706,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:39',NULL,NULL,NULL,'87fe8d58-03b3-43d3-ad8f-c4cade82789d'),
(1327,1324,NULL,707,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'7a6b7e2a-0a6f-4243-b309-fb66786d0d72'),
(1328,1325,NULL,708,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'65f511dc-8f93-479a-8d3e-6021a6b9778d'),
(1329,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-18 22:16:02',NULL,NULL,NULL,'1fd9bbc0-7bf1-46c9-ac24-0176114d3823'),
(1330,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'430de6e4-45df-469c-a0ac-15547a6ea506'),
(1331,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'ae0bbb33-7fe7-4e2f-b36d-8360e0b47ac5'),
(1332,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'c8b25d21-3bcc-43cb-a982-6aa042ce7c7a'),
(1333,1329,NULL,709,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'8fbb0b37-b9f2-4614-835e-de6c647719a5'),
(1334,1330,NULL,710,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'c26615ba-e4c9-4d9a-925b-9c90103ae00a'),
(1335,1331,NULL,711,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'0a8eb40c-1e1d-4fd1-8e2c-4a04d13a29d9'),
(1336,1332,NULL,712,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'f0b59803-a16a-4a3d-8963-809337502b79'),
(1337,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-17 20:15:37',NULL,NULL,NULL,'8dcaf5df-07b7-471a-8789-20e7877f2acf'),
(1338,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'ff30ff8c-9982-4b8c-bd0c-456261a04c3b'),
(1339,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'65c56459-3662-4e2e-bbf9-e82eb7d99d31'),
(1340,1337,NULL,713,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'c5a0b65f-7882-4513-a5d1-8039a767d40e'),
(1341,1338,NULL,714,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'ef3f32c1-0b07-4ad9-8029-f9d21d4ea52d'),
(1342,1339,NULL,715,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'bc4525aa-9015-468f-a9d9-78ace2d48ec9'),
(1343,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-17 20:16:46',NULL,NULL,NULL,'dc8c0434-33bf-4a60-8f74-5e9e67c67891'),
(1344,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'41d99e48-d5cf-408d-906d-340735136b96'),
(1345,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'41d77cae-2b52-436a-8fa4-27d35f39561f'),
(1346,1343,NULL,716,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'24024ef0-16b1-4688-984c-de8e2d231d43'),
(1347,1344,NULL,717,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'b6b20adb-acb3-49da-8df0-55b3eae7da84'),
(1348,1345,NULL,718,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'0acc5d37-de89-4bf4-8d81-4351d737de77'),
(1349,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-19 16:37:33',NULL,NULL,NULL,'1fab1df4-d265-4be0-a1fb-123a3d0f4312'),
(1350,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'345b51c1-2dd4-48fb-9194-f56d0135f9bb'),
(1351,1349,NULL,719,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'c07c82ac-f45a-4488-8e34-2752ddc02019'),
(1352,1350,NULL,720,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'80005875-b4fb-4a6f-9b0a-efc12dc3323b'),
(1353,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-20 16:19:48',NULL,NULL,NULL,'f29068a1-d909-4477-8a54-4f870de19253'),
(1354,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'253848be-d726-4334-8439-419a077a6d65'),
(1355,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'fdcb05fd-b7df-4ba7-be10-ea749bf599a4'),
(1356,1353,NULL,721,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'4c26fc44-ef5b-4836-a0e1-3e1d2bb714b9'),
(1357,1354,NULL,722,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'afbae2bd-2382-48fe-80e2-43466202bb2a'),
(1358,1355,NULL,723,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'a1a16467-6f7e-4b73-9d1b-4c4e644d69b0'),
(1359,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-18 22:22:39',NULL,NULL,NULL,'0a78517d-cd10-42a9-9b07-bd04013eaa7a'),
(1360,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'1661cb08-fadf-4970-af2d-42b2bcbcc6a6'),
(1361,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'a4b559ec-0ec4-42c3-89c5-1175ff52b3cd'),
(1362,1359,NULL,724,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'7bee03aa-7706-4450-a56b-7e342d33674c'),
(1363,1360,NULL,725,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'1efe27fb-b3ec-44f8-88c2-c76667c92eb7'),
(1364,1361,NULL,726,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'40974069-b708-4298-ac81-ef5084e2f449'),
(1365,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-18 22:25:10',NULL,NULL,NULL,'b1b7bedc-a69c-43e5-a051-864302bb5316'),
(1366,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'237f0de8-486f-455b-bb4e-cb875251ba3e'),
(1367,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'54b40113-d8ad-46f9-b11d-4728753e74b9'),
(1368,1365,NULL,727,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'c64e4f58-6d8c-4ea2-808f-11038133461e'),
(1369,1366,NULL,728,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'8308aac5-f93e-44ef-b9cb-1c4cb05e5f6c'),
(1370,1367,NULL,729,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'25559755-16d6-452a-97d2-0ad02800b00d'),
(1371,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-20 14:56:24',NULL,NULL,NULL,'1bc8135b-532b-434c-9bfd-75701f485a3c'),
(1372,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'2e261345-db78-4d7b-847e-765a6af5b014'),
(1373,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'f19dd849-9553-4f3c-8a5d-4e761016e010'),
(1374,1371,NULL,730,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'9e667f0c-03ff-4446-b89d-0c3200e4c8dd'),
(1375,1372,NULL,731,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'0f5359d8-ba45-4002-a348-b377c0ff9a0a'),
(1376,1373,NULL,732,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'58fa238e-a540-4873-95f7-8bf693d3de3b'),
(1377,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-20 14:58:34',NULL,NULL,NULL,'d3466f3d-8d29-494a-b948-a4b0893f19e2'),
(1378,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'befd8433-ea04-4e2b-8fa7-bdecc16273c1'),
(1379,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'bc9fcfa7-4653-4a00-b5b5-fa6b3cf95c43'),
(1380,1377,NULL,733,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'18c9209a-e7aa-4f4a-9bdb-0bf747856160'),
(1381,1378,NULL,734,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'4a03e149-e9f8-4ebd-b1a4-076e9a096736'),
(1382,1379,NULL,735,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'fc0ac719-9207-4ea7-8a02-530c28a50aab'),
(1383,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-20 15:00:15',NULL,NULL,NULL,'69022d4d-5d2e-4e2a-8a66-4e47358a2867'),
(1384,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'7b685ee2-7565-4acf-8e09-00c7584a4c2e'),
(1385,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'b6f03b11-d559-4b74-8c8e-111414003414'),
(1386,1383,NULL,736,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'91ed79b0-819d-4400-843b-7fe2f965145c'),
(1387,1384,NULL,737,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'c732bb86-d763-4643-a7a6-6456036e6b2c'),
(1388,1385,NULL,738,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'fc779cc1-739e-41d0-831e-489bc6ceeb1a'),
(1389,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-20 15:02:05',NULL,NULL,NULL,'fb8a6fbe-da4c-4b0d-97b9-df4fceca0c83'),
(1390,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'1252935e-8575-4ed3-9d1b-b8f45c05a53a'),
(1391,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'b5c7baba-cd62-4faa-b917-7fc71bd30dbd'),
(1392,1389,NULL,739,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'ba4a3d1c-f46b-43ba-8729-46570d722618'),
(1393,1390,NULL,740,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'b2ddb548-3695-4822-a942-b64469682468'),
(1394,1391,NULL,741,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'48f4970e-7a01-4de9-8ebd-cc3fb18a5e31'),
(1395,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-20 15:10:05',NULL,NULL,NULL,'ad605fca-f52b-4f94-ad29-1bf717718384'),
(1396,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'19773b1d-8517-4181-a953-11ef69fad669'),
(1397,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'afc0add6-72c7-49c3-8778-f1b8e7106d76'),
(1398,1395,NULL,742,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'ac8b35f6-8ade-4fa6-8698-ee9bcaed8dc3'),
(1399,1396,NULL,743,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'20b18ece-9636-458e-a861-34f802032de9'),
(1400,1397,NULL,744,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'6c1c4a3a-7ef2-46b6-bc3a-0a976a4b1d11'),
(1401,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-20 15:06:16',NULL,NULL,NULL,'10136db3-f742-4345-b1a1-3f99a22062c7'),
(1402,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'d1e067a4-53a5-4350-84c1-d64030187043'),
(1403,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'2b80baee-96c6-4993-95ca-ccf103ee535d'),
(1404,1401,NULL,745,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'3bbb8803-986e-450b-9796-659e2b7de2c7'),
(1405,1402,NULL,746,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'b03033ea-1bf9-48f2-93b0-7584f9ecd395'),
(1406,1403,NULL,747,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'b96cca2d-013e-4d54-9c2b-d6ebc1c94f64'),
(1407,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-17 20:36:03',NULL,NULL,NULL,'2ce11a9e-c93b-4ff0-89ed-0449154cae89'),
(1408,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'ce6fef3d-772f-4a4f-8b54-f29fdf182ae1'),
(1409,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'13e29f85-3faf-4d70-82e5-40842ee9b37b'),
(1410,1407,NULL,748,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'ab91c63d-5d6e-48a4-9c10-7e26395b19e5'),
(1411,1408,NULL,749,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'c534a2ab-96f0-4165-a937-a481dfad9b7b'),
(1412,1409,NULL,750,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'e7b156b5-5e57-4c89-85a1-4e4f8901dae9'),
(1413,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-20 15:04:30',NULL,NULL,NULL,'e90d7f5f-3681-4be5-8773-1c482e673ccc'),
(1414,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'ebd9af9d-9938-4547-b1d3-83cde3059a17'),
(1415,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'59cc73d1-18f2-4e04-bfca-809e0c4b69ba'),
(1416,1413,NULL,751,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'190384e1-ab95-4523-8051-9ebe0984616c'),
(1417,1414,NULL,752,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'e9370a84-57a6-4369-9473-8a91cdd74e8e'),
(1418,1415,NULL,753,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'2cb148f2-b545-4e25-b90e-de795d1043c5'),
(1419,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-20 15:15:56',NULL,NULL,NULL,'2f4b7332-a50d-492c-b8a1-863f352f896b'),
(1420,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'a3105570-e185-449a-a984-464a3b30cf02'),
(1421,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'7df53d4f-bf94-469a-984e-750a1a5cfce9'),
(1422,1419,NULL,754,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'c4302b70-c839-4f09-9d08-61441e302a2a'),
(1423,1420,NULL,755,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'f5015a23-32bc-45f0-bdd4-574e50eb3340'),
(1424,1421,NULL,756,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'e93d7c83-fe99-4ed8-9873-067781188103'),
(1425,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2026-01-20 15:17:05',NULL,NULL,NULL,'137c19fb-13a6-43b3-a183-3d975cff4c0b'),
(1426,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'e12bddeb-9d59-49e9-bfca-879d3358eedd'),
(1427,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'9a4c32a0-41a7-4196-9681-452c9b2c0589'),
(1428,1425,NULL,757,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:40',NULL,NULL,NULL,'f9d41542-541f-455a-b8e4-77971605eee1'),
(1429,1426,NULL,758,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'732f7e0a-a58e-44df-86da-ab57812d8c1d'),
(1430,1427,NULL,759,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'6b82c2d1-81ec-47b4-9d48-093d5a1093de'),
(1431,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2026-01-20 15:20:16',NULL,NULL,NULL,'48eba560-3fda-4658-863a-2ed2ea78d8c4'),
(1432,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'e6de6bdb-fda1-4ba4-a403-f7e505a85f25'),
(1433,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'1d4df37b-a1f7-44aa-a752-bd27261ee3e0'),
(1434,1431,NULL,760,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'98908d06-d1ae-4627-aba7-7930830d590f'),
(1435,1432,NULL,761,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'d9a4fded-91e0-45ae-9c88-7d40e18fa331'),
(1436,1433,NULL,762,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'66f3a2bf-6704-4029-9343-d7de7457180f'),
(1437,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2026-01-20 15:24:09',NULL,NULL,NULL,'cbfd4361-ffce-4592-b81d-197459a87850'),
(1438,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'79f8bfad-f6fd-496b-bb2b-b18aeef9c1da'),
(1439,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'df18802f-5928-4428-b780-465aeda74ac0'),
(1440,1437,NULL,763,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'3e88023a-6fd1-4295-9fbf-f91a299dea90'),
(1441,1438,NULL,764,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'f5d08f5a-95a5-41b1-914d-b306484b36ed'),
(1442,1439,NULL,765,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'9a7d5c70-c5c9-40ec-8a5c-5c258ecb9ecd'),
(1443,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2026-01-20 15:25:43',NULL,NULL,NULL,'831b2af1-17e9-43bf-a866-1b800adbf68a'),
(1444,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'e00c8df3-3971-48c8-af19-038b82eb4ba7'),
(1445,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'3c65783f-33e7-4ffc-bb0a-04996639d730'),
(1446,1443,NULL,766,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'f586d7cd-93d2-4b89-ac91-a054e12cb936'),
(1447,1444,NULL,767,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'ff273a9d-eff7-4a20-bc7a-21c1201f4103'),
(1448,1445,NULL,768,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'0322bb74-57b5-470d-964b-b30250ce5c19'),
(1449,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2026-01-20 15:26:56',NULL,NULL,NULL,'b3760ae8-a6d0-4798-b7d5-0e34e2f724eb'),
(1450,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'a1751340-9fe1-4b40-9a9d-37e0f2c3475c'),
(1451,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'c96dca8e-8a09-4e4c-82db-24631a5f6897'),
(1452,1449,NULL,769,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'5795e92e-598e-4042-9fa8-12750031e6a8'),
(1453,1450,NULL,770,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'cb5978d5-79e0-4a0f-ba7d-ff4e3da1ee70'),
(1454,1451,NULL,771,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'916f1236-d9ae-4ccd-8615-9ec2181873d9'),
(1455,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2026-01-20 15:29:08',NULL,NULL,NULL,'8652f720-82f3-44c9-87dc-ac5f3c6151fc'),
(1456,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'8c6cd355-9b93-4b0c-af81-587274a7a28c'),
(1457,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'e86f45b4-3583-4604-a341-32c0b2a92b55'),
(1458,1455,NULL,772,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'70df6f09-6608-4f8b-bee7-de4d42f3774a'),
(1459,1456,NULL,773,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'3bafd2d4-301b-455e-abb3-a874bf8b7d0d'),
(1460,1457,NULL,774,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'4dbbb847-1ac6-4514-a003-ca72f57a24e2'),
(1461,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2026-01-20 15:30:41',NULL,NULL,NULL,'e7791e13-ae0e-4fae-9b48-9b58ceaf42e8'),
(1462,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'d1707441-5c0d-45a3-93b5-841925d01056'),
(1463,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'0a29bd69-fbf6-4b46-95a2-37d02ef166f8'),
(1464,1461,NULL,775,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'54273e6b-363c-443c-ae4b-853f51fd4622'),
(1465,1462,NULL,776,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'5a9ff66e-d3a3-406f-8e0b-d0f21209ff4b'),
(1466,1463,NULL,777,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'cd6adbb7-5876-4d33-ac1a-e4746ddb1cea'),
(1467,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2026-01-20 15:33:10',NULL,NULL,NULL,'2968431d-70dd-4a0d-831a-b32a94b232c0'),
(1468,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'d84ae4c3-70cb-414b-bae9-6f1d9166db44'),
(1469,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'c84a1aa1-887f-41de-a39c-6e72f6048bff'),
(1470,1467,NULL,778,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'a04b3e26-89b2-4a53-a861-c62c8f14019b'),
(1471,1468,NULL,779,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'0fa18d33-5f4f-427c-96a0-7ad438682e27'),
(1472,1469,NULL,780,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'5af2ceb6-7782-4114-8437-d8c354c6c67e'),
(1473,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2026-01-19 18:55:06',NULL,NULL,NULL,'1b66deef-1654-4f64-80a7-f8cb4ea28cb6'),
(1474,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'88d15859-d314-492e-af61-c806c266654e'),
(1475,1473,NULL,781,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'7d170fad-ea7c-4c68-b0cd-6d00fd70097c'),
(1476,1474,NULL,782,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'5f7f1c0c-d22e-42c6-b93b-8851aee587a8'),
(1477,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2026-01-19 18:51:30',NULL,NULL,NULL,'4dac3a68-c074-41c9-a527-20c0f8126c51'),
(1478,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'7b5b31ea-9bff-410c-b9bd-cf0e6184e684'),
(1479,1477,NULL,783,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'8722911b-d004-4988-a9b2-2b0f3f68ca6b'),
(1480,1478,NULL,784,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'314cbf6d-05d4-4a79-892f-4a2579e6d857'),
(1481,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2026-01-20 15:33:43',NULL,NULL,NULL,'39cc6402-c4cc-48b9-bf88-74665c556ebb'),
(1482,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'dbe046f9-6776-4d71-ac3e-249e91a16180'),
(1483,1481,NULL,785,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'be58ee60-8046-4fd4-bb1c-db7f45a69814'),
(1484,1482,NULL,786,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'09eabf2e-24a1-4379-a4bd-5c713d80194f'),
(1487,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2026-01-19 17:16:04',NULL,NULL,NULL,'d8648c2a-9f0f-4b86-a648-71d5f39267c9'),
(1494,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2026-01-05 16:46:02',NULL,NULL,NULL,'bcc07c12-ea8c-4c99-a036-705be2becdbc'),
(1495,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2026-01-16 17:08:17',NULL,NULL,NULL,'a218a501-28dd-435f-9065-d960aabc82d2'),
(1496,945,NULL,793,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'5f6578e3-b703-4f4f-9519-c6d2d22c1188'),
(1497,1494,NULL,794,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'c34c9e2a-0a10-4471-b5ff-96ba4bc1eb94'),
(1498,1495,NULL,795,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'70a98b62-35fa-4e15-a66b-40c239a54583'),
(1499,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-12-01 19:40:26',NULL,'2025-12-01 19:40:26',NULL,'869ba898-7c45-4e23-9b77-d0773cdb9e77'),
(1500,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2026-01-16 12:39:10',NULL,NULL,NULL,'ec2cb18c-7316-4561-bedd-709e604c85da'),
(1501,951,NULL,796,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:17',NULL,NULL,NULL,'2cc6f3e1-db5f-466e-aaea-ccfa3e835f3d'),
(1502,1499,NULL,797,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,'2025-12-01 19:40:26',NULL,'2b960c80-8328-4c72-9045-9c13cb8d99ed'),
(1503,1500,NULL,798,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'04afa3b4-6ebd-4e9a-a5e2-3398fa2692c1'),
(1504,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 18:43:12',NULL,NULL,NULL,'fa6a8d9c-3388-4a14-a4ab-15a641f5c9c7'),
(1505,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2026-01-16 17:10:51',NULL,NULL,NULL,'19235825-3470-44a9-bcf5-f90804e5d549'),
(1506,957,NULL,799,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'ce8aa21f-6119-4d65-a5ca-e3544c8df9f1'),
(1507,1504,NULL,800,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'4071bdfe-4fad-4db8-a7bd-0567ea5df964'),
(1508,1505,NULL,801,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'8ac1a79d-1eb3-46de-af1f-caad72418e35'),
(1509,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 18:52:55',NULL,NULL,NULL,'4c813f98-05db-45a9-baff-afa71ea75d34'),
(1510,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 18:52:55',NULL,NULL,NULL,'c2a25819-6441-4a63-a27d-fd3a8ece8c59'),
(1511,963,NULL,802,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'22fd9aa2-a8d5-4bbf-8295-a99d3198168e'),
(1512,1509,NULL,803,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'325642a7-4c06-4361-8278-7d17876c002d'),
(1513,1510,NULL,804,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'94226a6b-0d5f-43d3-bd3a-f57cb25e54ca'),
(1514,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2026-01-05 17:23:19',NULL,NULL,NULL,'f47ec6a8-040e-4f19-b6bf-aa54fcd868f3'),
(1515,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-11-17 15:01:37',NULL,'2025-11-17 15:01:37',NULL,'2b582155-bafd-41d2-b61e-18900b57bf14'),
(1516,969,NULL,805,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'446e4054-bec5-41b2-ac2b-28a2716d7d3a'),
(1517,1514,NULL,806,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'1c650e5c-0773-4b97-bbd2-4b6a3b8566ff'),
(1518,1515,NULL,807,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,'2025-11-17 15:01:37',NULL,'7be8d060-1fde-4af5-9f3f-70d6be6f3c18'),
(1519,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-11-17 15:38:31',NULL,NULL,NULL,'a2ea9619-681e-4bce-8251-ea3ec57d5055'),
(1520,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2026-01-17 14:30:13',NULL,NULL,NULL,'01750b34-4fb1-47c1-b412-a69ea5a63651'),
(1521,975,NULL,808,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'c14d1e9f-a3cb-477e-b419-ad0729e1ef99'),
(1522,1519,NULL,809,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'cdbb91b8-a5dc-4dde-b32e-193ce3193240'),
(1523,1520,NULL,810,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'f329bcfc-4243-4c63-8072-a67f1711c59c'),
(1524,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 20:39:30',NULL,NULL,NULL,'cae0731d-61a3-476e-b171-2347ec8f448f'),
(1525,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2026-01-07 21:22:50',NULL,NULL,NULL,'5a04ca5a-45d1-4921-bdca-3968a162f1f6'),
(1526,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2026-01-16 17:03:39',NULL,NULL,NULL,'c680d7e5-a164-4fe0-b75a-d750f8b669c1'),
(1527,981,NULL,811,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'e6354882-6a38-4788-a719-5d9184e2c47a'),
(1528,1524,NULL,812,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'fe1f44f3-e0b3-422a-9236-44b13e46fde6'),
(1529,1525,NULL,813,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'f4713859-22d9-4013-8ae0-f4844cafd16b'),
(1530,1526,NULL,814,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'22e968f1-a11e-498a-bc3d-6e1b7004a362'),
(1531,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-09 14:59:55',NULL,NULL,NULL,'1c70e206-c29c-4bf5-9067-3e0c185019a7'),
(1532,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-09 14:59:55',NULL,NULL,NULL,'472435b3-86eb-42e3-9e21-4039c10d851b'),
(1533,989,NULL,815,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'de45191a-4bb2-4730-8a22-fe030c5948da'),
(1534,1531,NULL,816,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'f211a9f0-f573-48b9-a56f-b6baf9fa84a7'),
(1535,1532,NULL,817,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'d32e1c7b-b917-488b-b698-dc9bc15402e1'),
(1536,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2026-01-05 18:50:52',NULL,NULL,NULL,'7b7a96c0-fd88-4e61-b3a1-434634e705d7'),
(1537,995,NULL,818,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'5346c5a0-8582-46ca-974e-7f1915f7034f'),
(1538,1536,NULL,819,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'5de51e2c-a327-45cb-8505-c72a80d0de4f'),
(1539,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-14 16:14:34',NULL,NULL,NULL,'8f9f6928-4dea-4f6a-b61a-ce50ce7a4487'),
(1540,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-14 16:14:34',NULL,NULL,NULL,'ee6281cf-dd6a-4ead-b69b-52f35cbc3037'),
(1541,999,NULL,820,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'b4fa0f92-4aeb-44b8-b784-cea7078d71a7'),
(1542,1539,NULL,821,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'7a6ca703-0936-4b26-8dab-a6ac2fc8c3a8'),
(1543,1540,NULL,822,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'0e8889d6-7949-4344-8c01-acd2e4e9d70c'),
(1544,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2026-01-05 21:12:25',NULL,NULL,NULL,'b3d474bd-9a80-446e-be3b-f3dd8f95a749'),
(1545,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2026-01-17 14:36:42',NULL,NULL,NULL,'f797fd60-d5b7-4a1c-ba1d-cf2985a2dd0e'),
(1546,1005,NULL,823,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'cfdf2b5c-c774-4c9c-9533-83a66068228a'),
(1547,1544,NULL,824,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'9f308709-117d-44b9-bf51-dcd985e12112'),
(1548,1545,NULL,825,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'72f3a745-6155-48a3-a80f-ae5b637e6e2f'),
(1549,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2026-01-07 21:25:15',NULL,NULL,NULL,'2c4d4b91-a2cd-44e4-a698-411d971566d7'),
(1550,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-11-17 16:45:42',NULL,'2025-11-17 16:45:42',NULL,'6bfee32f-985b-4da9-aac7-6d136c688743'),
(1551,1011,NULL,826,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'6e31745b-43ad-41e0-af18-e7449a4006dd'),
(1552,1549,NULL,827,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'24083c0b-7342-45ad-a2d4-c9f153dd3997'),
(1553,1550,NULL,828,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,'2025-11-17 16:45:42',NULL,'d1398982-fbea-4427-9d84-8ca4e994ea85'),
(1554,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-11-17 16:55:07',NULL,NULL,NULL,'818e14f3-eced-4187-bb05-1e7052a16d2d'),
(1555,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-11-17 16:55:07',NULL,NULL,NULL,'1c97b0fb-ef0a-4374-af62-9d7ddcd2adaf'),
(1556,1017,NULL,829,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'d527fae8-aa6c-412c-a757-c4e33dfa5389'),
(1557,1554,NULL,830,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'d460cd6c-e9d5-4dfe-9a7a-4e64b03781ec'),
(1558,1555,NULL,831,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'35455501-4a8b-4d5f-a8aa-cbeb3eb37081'),
(1559,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'08b7891f-7ef9-492e-9a1a-4f70b6182e4b'),
(1560,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2026-01-07 21:36:47',NULL,NULL,NULL,'3beaa422-e9a0-487b-8fc8-5c51a3db68a2'),
(1561,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 17:20:39',NULL,NULL,NULL,'5fb39a85-440f-47c8-bb92-0ac03be1f30b'),
(1562,1023,NULL,832,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'24b898cc-fbd0-42ec-818b-b907e76dc91e'),
(1563,1559,NULL,833,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'deea09bf-a9ba-4433-96fa-9aaead6811db'),
(1564,1560,NULL,834,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'396907d2-ddcf-46d1-8981-67def04b52e1'),
(1565,1561,NULL,835,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'97993b18-f936-40a2-bddc-3a84c14babcd'),
(1566,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-11-17 16:58:10',NULL,'2025-11-17 16:58:10',NULL,'3cfc1ccf-a8ef-46dd-aa1e-cd1fc857648b'),
(1567,1031,NULL,836,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'a76e1caf-84dd-411b-844f-e596924a4ce4'),
(1568,1566,NULL,837,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,'2025-11-17 16:58:10',NULL,'ca03c0ae-718f-45a0-b018-be3a500378cf'),
(1569,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2026-01-07 20:56:54',NULL,NULL,NULL,'242041a7-0de1-4672-841c-dc68b0234fd2'),
(1570,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 17:24:35',NULL,NULL,NULL,'fe040441-4598-4c71-910e-ab8973b5641c'),
(1571,1035,NULL,838,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'76a6436f-bc71-4fc9-b8a3-428357e8de61'),
(1572,1569,NULL,839,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'cdf57a62-37c3-4e8d-bf55-4d37a59d2097'),
(1573,1570,NULL,840,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'6932c67a-2fc3-43ff-a5f9-df73478a6a39'),
(1574,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2026-01-07 21:52:44',NULL,NULL,NULL,'80dbadc7-dbf1-427d-83d3-9b7ccc560196'),
(1575,1041,NULL,841,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:19',NULL,NULL,NULL,'3e29aef8-b773-4acf-8035-1be83196a311'),
(1576,1574,NULL,842,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:19',NULL,NULL,NULL,'d4f3fac6-ec2d-4d4d-a2b4-88315ac164cc'),
(1577,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2026-01-05 17:07:53',NULL,NULL,NULL,'dc1d4a8f-d428-4342-9942-efcf7a829bd7'),
(1578,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-09 20:48:21',NULL,NULL,NULL,'267f52a0-90be-4067-acf5-3ca538764045'),
(1579,1045,NULL,843,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'9ef5a4b7-dee9-4bfa-8018-360096a4d121'),
(1580,1577,NULL,844,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'18a3d99a-f249-4dee-9400-d60c21c0b9e1'),
(1581,1578,NULL,845,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'5b0073cd-9b18-445f-93ed-aadd165f7367'),
(1582,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'ab186df8-b9a2-49ea-af07-66f2378ecf5e'),
(1583,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-09 20:56:04',NULL,NULL,NULL,'f1b27b4a-f865-4548-bf7e-0613c02036a6'),
(1584,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-09 20:56:04',NULL,NULL,NULL,'9cc47e5a-cf9f-48df-8d55-7bc428be06d4'),
(1585,1051,NULL,846,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'a650b655-05e4-4ef2-864b-ff66f7652d92'),
(1586,1582,NULL,847,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'446c3fc8-16d3-4de6-939d-24d8afdbe60b'),
(1587,1583,NULL,848,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'30cbeb54-8185-40fa-856a-c57b2f80399a'),
(1588,1584,NULL,849,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'06c74666-b097-4802-a6dc-212d5d809a2f'),
(1589,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'96327c94-0c72-4895-9f4f-8e04afd352df'),
(1590,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:02:33',NULL,NULL,NULL,'7d9136f2-15e1-4ab7-b2b1-56fa9e43355e'),
(1591,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:02:33',NULL,NULL,NULL,'a1f9bafa-b757-435e-8731-9219b2071673'),
(1592,1059,NULL,850,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'3a917f4d-9320-49a8-9f19-69b79db4f4c7'),
(1593,1589,NULL,851,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'f996d56f-9d63-403f-ba02-ce316e65b30d'),
(1594,1590,NULL,852,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'50c7a625-31db-4ef8-ad56-cb2e9f2729bd'),
(1595,1591,NULL,853,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'2faa8e39-89fb-4e33-9f76-96d89f68c39a'),
(1596,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:04:07',NULL,NULL,NULL,'71542126-c1bb-482b-97ef-4fe0b493c037'),
(1597,NULL,NULL,NULL,2,'craft\\elements\\Entry',0,0,'2025-09-11 18:51:19','2026-01-17 14:50:50',NULL,NULL,NULL,'f1e31aa6-e7f0-4123-bc34-c0945bb7f522'),
(1598,1067,NULL,854,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'1298d3fb-9375-4d68-b188-9c1359be283e'),
(1599,1596,NULL,855,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'9303380c-4e51-4955-99f9-918c5b6b8d48'),
(1600,1597,NULL,856,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'08cdbe79-c9d2-477e-acff-2cb18e7d7191'),
(1601,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-11-17 16:08:26',NULL,NULL,NULL,'877bfd37-9baa-457b-8185-cfee54576b3b'),
(1602,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-11-17 16:08:26',NULL,NULL,NULL,'624eff7a-6fc4-4aad-b6b7-02f89bedcca3'),
(1603,1073,NULL,857,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'ce628c80-6ce7-4a27-a78a-55dbf6f89f47'),
(1604,1601,NULL,858,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'a41048fc-3a9c-402d-bda0-ccdfe72e60e1'),
(1605,1602,NULL,859,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'f69e19b2-88de-4b99-9b7c-a76590a308f2'),
(1606,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:15:51',NULL,NULL,NULL,'f1118721-674d-4a90-9282-79cb352dbe26'),
(1607,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:15:51',NULL,NULL,NULL,'6967b0d6-ef75-4363-a983-b9e5b454ab9f'),
(1608,1079,NULL,860,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'ac2e114a-7b24-43f9-848d-0b81aab82de3'),
(1609,1606,NULL,861,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'6ce33d5c-0f53-4ec9-a16e-6c6cc55388d3'),
(1610,1607,NULL,862,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'1c1b47e0-f50c-4763-8578-925a6c5d61c9'),
(1611,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-11-17 16:35:08',NULL,NULL,NULL,'0fd673de-e926-43c2-8964-9cfb361c6b50'),
(1612,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:43:47',NULL,NULL,NULL,'93ac7653-3cca-4460-9789-0948234f458a'),
(1613,1085,NULL,863,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'62bfdfca-f0de-45c8-8eb2-89a72f5a8845'),
(1614,1611,NULL,864,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:20',NULL,NULL,NULL,'2789a5f6-d3d9-4711-b469-d77789f115d2'),
(1615,1612,NULL,865,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:20',NULL,NULL,NULL,'4e2e029c-f9c6-4106-ad34-f3639b3a7475'),
(1616,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:09:47',NULL,NULL,NULL,'e4ff0752-72c2-4db7-997b-e0c2fab843fb'),
(1617,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:09:47',NULL,NULL,NULL,'dd4f1c54-ed3e-492d-a4e2-64a4b58e1aa7'),
(1618,1091,NULL,866,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'26ecb9a6-97eb-4e7a-aa6d-323e1d108fa8'),
(1619,1616,NULL,867,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'26d9cdba-f85d-4a93-9b25-e0369b28df1c'),
(1620,1617,NULL,868,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'6d361fb2-b6d7-4a90-baca-62c4fc7a05d1'),
(1621,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2026-01-07 21:53:07',NULL,NULL,NULL,'67749652-d5a4-47f3-9731-42af69829579'),
(1622,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:23:02',NULL,NULL,NULL,'99ff09c9-fb4c-49c1-890a-b48ea561e917'),
(1623,1097,NULL,869,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'e2d2d06e-0044-4731-93d9-c1b7c02d30d0'),
(1624,1621,NULL,870,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'69669ad6-3ef8-40ba-8c6f-ed4562b6f106'),
(1625,1622,NULL,871,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'33839b4e-f77d-4e2e-8ee8-40e3a087dc2f'),
(1626,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2026-01-05 21:19:02',NULL,NULL,NULL,'2ce3deea-8f5c-488a-8774-aed3fae0e087'),
(1627,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:28:26',NULL,NULL,NULL,'048e1eef-0ea7-462f-89ba-d9008fcf2f0f'),
(1628,1103,NULL,872,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'90443b6c-75e3-4a87-b152-aa180ef0dbde'),
(1629,1626,NULL,873,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'98a0fc20-da2b-47e0-b836-07a12d30118b'),
(1630,1627,NULL,874,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'6823ffa5-5400-47b6-b9a6-f3baf4d39a4d'),
(1631,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'48d52a92-a8f0-49de-a547-f5bc7e8d9fc9'),
(1632,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:43:34',NULL,NULL,NULL,'6bc7c756-aef2-4ed6-8479-624220c98c2a'),
(1633,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:43:34',NULL,NULL,NULL,'2bfd22e4-9e3a-4af7-afe9-09be20061e66'),
(1634,1109,NULL,875,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'c21527da-4a68-46dd-9aa7-31d4fa2f0ef9'),
(1635,1631,NULL,876,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'7075bacd-530b-4fd7-8ea9-1251ed13ee4c'),
(1636,1632,NULL,877,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'fc062f0e-ba24-48e9-a1b7-5f14da43550d'),
(1637,1633,NULL,878,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'c5a58884-0d89-4fc5-884d-60ade35000b7'),
(1638,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:47:19',NULL,NULL,NULL,'7de51130-bec9-4b22-b2cc-40d3949c8d42'),
(1639,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2026-01-17 15:01:04',NULL,NULL,NULL,'d4d941e5-4019-411f-a89a-3e114d000059'),
(1640,1117,NULL,879,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'db1b1244-f5cb-4a6e-add5-669895a3dd1b'),
(1641,1638,NULL,880,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'fd652a0c-c552-4698-9159-acaba1002a7b'),
(1642,1639,NULL,881,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'f00ca14e-86d7-48cc-86c4-19d789070ac2'),
(1643,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2026-01-07 21:58:05',NULL,NULL,NULL,'93866d5c-e218-4a5c-83d1-748eabf50ca6'),
(1644,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2026-01-17 15:02:07',NULL,NULL,NULL,'f0fd69b9-cb1d-4e34-b692-f7aa1308332b'),
(1645,1123,NULL,882,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'9de724ae-da94-4d92-8e97-7a82a656291b'),
(1646,1643,NULL,883,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'28ee316e-d8f0-4a59-b4aa-f7514e5af48c'),
(1647,1644,NULL,884,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'94383d30-23a5-4549-9758-9223e57af554'),
(1648,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2026-01-17 15:03:55',NULL,NULL,NULL,'12b722db-8261-462d-a755-15979b6f0776'),
(1649,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:57:28',NULL,NULL,NULL,'f07ff0d1-bfbf-4d9e-b615-de7da942ece5'),
(1650,1129,NULL,885,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'d55c08d6-0076-4c93-85c9-547c11277fd3'),
(1651,1648,NULL,886,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'4d4fb4aa-b1ee-4e2b-b0f6-128719ce2adc'),
(1652,1649,NULL,887,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'8a8565f0-3e8b-46e8-a878-16eda6c4b32f'),
(1653,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-11-05 17:22:48',NULL,NULL,NULL,'76803157-1a52-4ad4-bf4b-5c6dd96ced73'),
(1654,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-11-05 17:22:48',NULL,NULL,NULL,'2f57269c-dff1-4ea7-8e9f-a3424434b1c9'),
(1655,1135,NULL,888,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'9608b27e-a7f2-47df-a45a-6b7f8e4e5ebe'),
(1656,1653,NULL,889,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'2eb10c5d-4451-4a81-8916-83999c45eaaf'),
(1657,1654,NULL,890,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'9efa88df-403b-48cb-9f10-0d9a348d5fd0'),
(1658,1141,NULL,891,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'a1dd39cc-e343-4483-a3dc-1e4beaa5a8ce'),
(1659,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 18:02:09',NULL,'2025-10-13 18:02:09',NULL,'3a523137-c22a-4542-b907-8e324e63286a'),
(1660,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 18:02:09',NULL,NULL,NULL,'62d624e2-e31b-4c3f-9860-4724e86067e3'),
(1661,1143,NULL,892,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'849cc0a0-0c96-463b-939e-ba9f41b6bae1'),
(1662,1659,NULL,893,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,'2025-10-13 18:02:09',NULL,'755d8179-aaeb-4bd8-8d6d-01c55c1e9b9f'),
(1663,1660,NULL,894,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'7938168f-3f25-4a40-b1e2-cdd1bcdd40ca'),
(1664,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:10:27',NULL,'2025-10-13 19:10:27',NULL,'c976e4fd-a038-489e-8477-bde184a4ee42'),
(1665,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:10:27',NULL,NULL,NULL,'1c14f825-78a0-4c69-aaab-7e5653da9f7c'),
(1666,1149,NULL,895,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'59f2f3ff-1362-4e08-9ec0-9d18531f00a2'),
(1667,1664,NULL,896,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,'2025-10-13 19:10:27',NULL,'ed2b76e3-408d-4f68-962a-adda88e19dcf'),
(1668,1665,NULL,897,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'ad45b4bf-2650-4f21-ac8b-2d2a7ca4e17e'),
(1669,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:24:55',NULL,'2025-10-13 19:24:55',NULL,'81b2f1ac-2a38-4eab-82e9-64a4c778113d'),
(1670,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:24:55',NULL,NULL,NULL,'719386ef-189c-4aa3-bd88-5f85ec1457e8'),
(1671,1155,NULL,898,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'04029068-43ff-49d3-81c8-621db14e58c9'),
(1672,1669,NULL,899,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,'2025-10-13 19:24:55',NULL,'8466022f-0af6-4d3c-b2be-db150ff7a6a8'),
(1673,1670,NULL,900,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'e755ba7a-a013-40bc-9f3e-f81b04c2d98e'),
(1674,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2026-01-16 21:29:59',NULL,NULL,NULL,'e7e6448a-d2dc-4442-8f22-aaa73546d208'),
(1675,1161,NULL,901,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'9d6c6c4b-202c-491a-847a-d0f7fd1b00ed'),
(1676,1674,NULL,902,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'db79726b-a515-41fe-acd9-a419ff26279e'),
(1677,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-12-16 15:26:54',NULL,NULL,NULL,'8e117128-fc30-4864-ab2a-2ec752739976'),
(1678,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:30:02',NULL,NULL,NULL,'9ef20d13-0f68-4d1c-84b0-488a5047dc0d'),
(1679,1165,NULL,903,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'ebec268c-1bac-491f-a0e2-99785f7f779a'),
(1680,1677,NULL,904,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'aee49ab0-ca98-4965-adef-1ce8d0bb56eb'),
(1681,1678,NULL,905,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'119a073c-fb35-4520-a35a-c2dbbe835b0a'),
(1682,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2026-01-05 17:12:30',NULL,'2026-01-05 17:12:30',NULL,'2d4b474d-0e73-48cc-8848-d539e0cb0a0d'),
(1683,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2026-01-16 20:44:54',NULL,NULL,NULL,'5413ecea-af7a-4c90-adb2-fb08a69c6858'),
(1684,1171,NULL,906,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'41486ac5-5bdb-401d-949d-a0506d41d6c6'),
(1685,1682,NULL,907,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,'2026-01-05 17:12:30',NULL,'3e8540fc-6ea4-43b6-9fdd-1b2971980111'),
(1686,1683,NULL,908,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'2d3a096f-aa14-4c23-893b-e00529728b95'),
(1687,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'802ff893-9dd0-47f6-b76b-1f79ab5cb3bd'),
(1688,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'56cb0fa7-e9c5-44e7-9b65-64a18ccf8ae7'),
(1689,1177,NULL,909,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'fae1110a-a367-4215-9a8b-6ba4046ec272'),
(1690,1687,NULL,910,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'3b35e70a-c077-4351-bd17-ef473da66bef'),
(1691,1688,NULL,911,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'a4eda232-1f4a-4461-a016-665c50316ebb'),
(1692,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-12-16 15:22:47',NULL,NULL,NULL,'71e11bb6-2370-4290-bebb-18c47e65bcc8'),
(1693,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-11-04 21:01:32',NULL,NULL,NULL,'4927887c-3d65-40a0-9f31-4c8cfd54330d'),
(1694,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2026-01-16 21:31:57',NULL,NULL,NULL,'fed36498-fd42-4455-8920-8485427e2921'),
(1695,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2026-01-16 21:29:27',NULL,NULL,NULL,'ca92fb52-1474-4b0c-a08a-b54accf3ce7e'),
(1696,1185,NULL,912,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'ee4c93be-cd3d-400d-9979-f08d3a927d51'),
(1697,1694,NULL,913,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'27e66328-8500-4cbe-ab42-3dc45ddb4eb6'),
(1698,1695,NULL,914,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'9421cb12-8c71-486a-bc81-e956452c0f44'),
(1699,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2026-01-05 17:58:01',NULL,NULL,NULL,'ba72f07f-60ac-43f1-b149-8b2cc7f13296'),
(1700,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2026-01-17 00:15:34',NULL,NULL,NULL,'198c5c70-c72b-4af9-817c-fca417943203'),
(1701,1191,NULL,915,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'3d50dea2-d914-487e-84bd-61342a08114a'),
(1702,1699,NULL,916,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'adb139dc-ce51-41eb-863c-c4153f853698'),
(1703,1700,NULL,917,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'44abfe06-6d07-468c-9bab-bb3129d06883'),
(1704,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2026-01-05 18:31:07',NULL,NULL,NULL,'e4becd4f-4f88-45e9-aa43-cba6bf902c55'),
(1705,1197,NULL,918,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'444121f4-f36b-4b38-8982-30cce4084e7a'),
(1706,1704,NULL,919,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'0598bdda-bfb2-4337-8640-a7da196530df'),
(1707,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'45d1a41a-8ae9-4339-9f60-5151521a8370'),
(1708,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-14 16:56:56',NULL,NULL,NULL,'85ba5ba2-dcd2-4d62-a5f4-e4e7899a49ad'),
(1709,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-14 16:56:56',NULL,NULL,NULL,'a5582294-c853-4a4d-b525-a7d0a8d1df93'),
(1710,1201,NULL,920,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'83f1f19b-c802-495b-ac4e-889569fd4156'),
(1711,1707,NULL,921,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'beb1f95e-9150-4d43-aa8d-dbf7bc015536'),
(1712,1708,NULL,922,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'3e781fdb-4dc0-4b47-a806-13f29b4650f1'),
(1713,1709,NULL,923,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'6ea5a8a2-7ca1-46ea-afa4-59dcd493e3dd'),
(1714,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-14 17:00:06',NULL,NULL,NULL,'d9236cf2-6abc-4b9e-9cdd-4d4d0d3591c0'),
(1715,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2026-01-08 17:57:52',NULL,NULL,NULL,'d990cde1-8e63-4ef5-9870-8fc3972bb19c'),
(1716,1209,NULL,924,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'46b9077b-a2bb-46e0-9e5c-3efdc48dd02b'),
(1717,1714,NULL,925,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'79b446c7-ec6e-4d57-abe9-d890d04da4d3'),
(1718,1715,NULL,926,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'ba3156d4-274d-46be-b952-07829b41f675'),
(1719,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-14 17:05:13',NULL,NULL,NULL,'64c70303-a72c-4aea-92ce-c5429bd30743'),
(1720,1215,NULL,927,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'30d3383e-0fe5-4b6a-8feb-df65f4c624ca'),
(1721,1719,NULL,928,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'c9d9d4da-c518-4d82-ba0d-b15820567031'),
(1722,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:09:21',NULL,'2025-10-14 17:09:21',NULL,'33f1fc78-0dac-4051-a32a-80d2c70ba679'),
(1723,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:09:21',NULL,NULL,NULL,'439ee6ec-aac0-4819-8f5d-194f2ba7bbe4'),
(1724,1219,NULL,929,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:23',NULL,NULL,NULL,'0b853c5c-8428-490a-aac0-eb738f9e93ef'),
(1725,1722,NULL,930,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,'2025-10-14 17:09:21',NULL,'ab0a4a36-83d7-4f20-9ed3-598816917770'),
(1726,1723,NULL,931,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'3dfa9614-f48a-43f1-9fed-75dee00001af'),
(1727,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:12:18',NULL,NULL,NULL,'3f0b0778-06c4-4c22-a78f-37547b8405db'),
(1728,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:12:18',NULL,NULL,NULL,'9644df4d-82f1-45cc-9361-778ff3706f07'),
(1729,1225,NULL,932,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'fb5b253f-9c1e-416e-9485-97278d2a960f'),
(1730,1727,NULL,933,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'9b104be7-5ab2-4b96-b596-c3145d9d6844'),
(1731,1728,NULL,934,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'17d578b0-68af-48f4-a4c9-82ea467b06d8'),
(1732,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2026-01-17 00:46:46',NULL,NULL,NULL,'f7b088e1-ddf5-409e-8372-6630ebc6c03a'),
(1733,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:15:30',NULL,'2025-10-14 17:15:30',NULL,'11ae1d50-4e9d-4c54-b48b-08a6dafa0591'),
(1734,1231,NULL,935,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'ff3b6f48-2d80-4a4f-8a43-8d12cd9e7865'),
(1735,1732,NULL,936,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'dc171179-0907-416d-963b-507021688924'),
(1736,1733,NULL,937,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,'2025-10-14 17:15:30',NULL,'b8eb67d9-030b-4583-85d5-f6b732efa259'),
(1737,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:22:21',NULL,NULL,NULL,'788af7e4-7d73-41d4-ac96-0d205a4d96d8'),
(1738,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2026-01-17 00:51:35',NULL,NULL,NULL,'3613d1ca-196a-4292-ac4f-5f8154c3fe4e'),
(1739,1237,NULL,938,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'31d69baf-751b-422e-a10b-79cb9012ed50'),
(1740,1737,NULL,939,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'cc47d91a-414f-4212-a14e-cd58a7f83847'),
(1741,1738,NULL,940,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'d9c9f84b-8fc2-46bc-8078-09c9085664e4'),
(1742,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:25:14',NULL,NULL,NULL,'6a79d926-9798-4b90-87e8-6f9b1ba98aab'),
(1743,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:25:14',NULL,NULL,NULL,'228b7411-ef34-4956-8205-cab4baa70528'),
(1744,1243,NULL,941,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'21869279-96e1-482b-9317-e1bce6d13352'),
(1745,1742,NULL,942,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'3ff79a04-7487-456b-838d-8978082c23e5'),
(1746,1743,NULL,943,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'e0e84cff-2980-41a7-9ae6-a44c707ce1fc'),
(1747,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:28:10',NULL,NULL,NULL,'ec1206c6-2e89-4d63-8d6f-2e22dc517182'),
(1748,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2026-01-17 00:56:24',NULL,NULL,NULL,'5abe7f78-77c0-400e-a8a0-1627bda5ca98'),
(1749,1249,NULL,944,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'555bcebc-4e66-4d31-b11f-dc62ea4f0be5'),
(1750,1747,NULL,945,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'ab669648-fd16-45e3-aad4-db2741c89bc7'),
(1751,1748,NULL,946,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'7a119e1d-8d0a-42ff-8112-cfa7aab49453'),
(1752,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2026-01-05 17:02:25',NULL,NULL,NULL,'e1c081a3-0cae-4820-8e5b-e010258bd9c1'),
(1753,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2026-01-17 00:23:10',NULL,NULL,NULL,'42912698-68d2-423f-8fe9-2a80a2580d36'),
(1754,1255,NULL,947,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'44e659cb-a664-4699-a76f-8ed6a69c05ad'),
(1755,1752,NULL,948,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'ad1bde53-106d-47ea-aec6-e25410fb1a21'),
(1756,1753,NULL,949,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'e2862ace-de8d-470f-84d2-d57b4f10a6e9'),
(1757,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'968ad18e-9c07-4f7a-86df-7fdede551920'),
(1758,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-11-04 20:58:46',NULL,'2025-11-04 20:58:46',NULL,'9ea957be-188f-49b7-8206-f375d4c6d08f'),
(1759,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-11-04 20:58:46',NULL,NULL,NULL,'2de3e020-43c0-478a-806b-a143a8d12003'),
(1760,1261,NULL,950,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'9cd00f41-7b44-4143-a3eb-5b0706fa4d75'),
(1761,1757,NULL,951,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'d14b5f05-3259-4274-b858-b113de92899f'),
(1762,1758,NULL,952,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:24',NULL,'2025-11-04 20:58:46',NULL,'9fb2dbfa-384c-4984-9e55-232f259911dc'),
(1763,1759,NULL,953,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:24',NULL,NULL,NULL,'02201b4f-61f3-4de1-8f5c-6c3c12fa383d'),
(1764,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:34',NULL,NULL,NULL,'d82ebff9-5908-4f22-bec7-1f9332e237a7'),
(1765,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-11-17 14:59:56',NULL,NULL,NULL,'93f5f7e8-4301-4b40-bf8c-6046ce439a01'),
(1766,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-11-17 14:59:56',NULL,NULL,NULL,'9105f58c-e41a-425c-8a07-d988a8ecc2a9'),
(1767,1269,NULL,954,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'fbb5940a-24c7-4e57-9090-c782be86152b'),
(1768,1764,NULL,955,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'973a3325-eede-4664-9655-93ad2dfd9575'),
(1769,1765,NULL,956,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'91b7146b-f6b1-416c-a469-3a7578b0e48c'),
(1770,1766,NULL,957,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'b1aad48c-3854-487a-b805-03ce09484897'),
(1771,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-11-17 15:03:58',NULL,NULL,NULL,'6d3bda87-f433-487f-b3e2-d02b6842b642'),
(1772,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-11-17 15:03:58',NULL,NULL,NULL,'ddde8323-5f54-4bfe-8bf6-e327cc50a1cd'),
(1773,1277,NULL,958,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'919843e7-a5a4-47fc-bdd4-106f1503e923'),
(1774,1771,NULL,959,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'64bf31c6-050b-40a8-ba90-b6206c0e454a'),
(1775,1772,NULL,960,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'fe47425f-36c0-4a02-acae-e8507aa4acb2'),
(1776,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2026-01-05 18:27:26',NULL,NULL,NULL,'c8395bcb-be25-4ef3-a610-dcd81378968f'),
(1777,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2026-01-17 00:25:00',NULL,'2026-01-17 00:25:00',NULL,'70f3485b-1285-4936-97d5-7e0aabbca8a0'),
(1778,1283,NULL,961,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'6280843f-504f-4120-801e-4475984a064f'),
(1779,1776,NULL,962,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'0efa9bef-ab8e-4d76-a7cd-83929ce58592'),
(1780,1777,NULL,963,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,'2026-01-17 00:25:00',NULL,'d2c17d3c-85a9-4621-af91-13c1685e1b1b'),
(1781,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'5368e443-5c98-489e-9860-db31db17d82e'),
(1782,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-11-17 16:03:20',NULL,NULL,NULL,'412aec4d-0997-4bc7-a129-fee5322650c2'),
(1783,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-11-17 16:03:20',NULL,NULL,NULL,'853b8c61-6a72-44a0-817c-151ee35b010f'),
(1784,1289,NULL,964,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'a71e4b86-90a4-49b3-bfac-ed673a00c619'),
(1785,1781,NULL,965,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'ad96e4ef-df1b-4355-9d03-c123070c74cb'),
(1786,1782,NULL,966,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'30bd123e-5fad-4325-8e71-dfc1eac92e93'),
(1787,1783,NULL,967,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'c2bd872c-6fa6-43a9-8794-5fbe5087d461'),
(1788,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-11-17 16:04:15',NULL,NULL,NULL,'6dc12b4c-d661-4071-8291-06d5b9cfd6cf'),
(1789,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-11-17 16:04:15',NULL,NULL,NULL,'8aef1db4-40d1-4d6e-aed7-9bc8ea3ccdd0'),
(1790,1297,NULL,968,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'ba582ce6-1373-44d7-a421-ec7d6fdffbe7'),
(1791,1788,NULL,969,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'27b07007-0ba5-4e11-8036-91d75e82beca'),
(1792,1789,NULL,970,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'3923cf3c-b335-4d70-a749-8fc02031984e'),
(1793,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-11-24 14:42:16',NULL,NULL,NULL,'b0e8d74e-cae3-4bed-b433-cb4e98a80284'),
(1794,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-11-17 16:13:13',NULL,NULL,NULL,'17a15f6c-143a-46bf-8383-901156835ab9'),
(1795,1303,NULL,971,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'092c3550-d902-457c-afb7-33011fd9ab86'),
(1796,1793,NULL,972,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'56c7d6bc-a4b2-404c-8491-755ccffe190b'),
(1797,1794,NULL,973,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'99c4e080-d14a-4409-af47-b9f539b30aa4'),
(1798,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-11-17 16:22:37',NULL,'2025-11-17 16:22:37',NULL,'81229918-1389-4a86-92eb-56599daefbce'),
(1799,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-11-17 16:22:37',NULL,NULL,NULL,'19f71060-ccf7-4fdc-a096-e765cbe4fa42'),
(1800,1309,NULL,974,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'73975a23-192f-47ab-9866-475d41f92e0b'),
(1801,1798,NULL,975,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,'2025-11-17 16:22:37',NULL,'11785b0a-fe00-4003-a98a-93e22827611c'),
(1802,1799,NULL,976,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'8b1c5678-dd33-49b3-9dbf-bb83c045c075'),
(1803,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'0206e4c2-57f8-47ef-8560-4f35cee9ac0c'),
(1804,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-11-17 16:41:36',NULL,NULL,NULL,'af57dddf-d829-46e9-93dd-8cec190c875b'),
(1805,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-11-17 16:41:36',NULL,NULL,NULL,'82518c7b-5d2c-4d07-8b4b-51454aa88f45'),
(1806,1315,NULL,977,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'f05cfc82-5f81-4a16-b351-09d2a3562004'),
(1807,1803,NULL,978,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'d9d93d76-998a-4854-96ed-6c0c36ef981e'),
(1808,1804,NULL,979,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'ae6a96b1-7c13-4fb6-83fd-df178fd7da65'),
(1809,1805,NULL,980,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'060fad59-a8f3-401e-9b3b-c367abe79c3d'),
(1810,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-11-17 16:44:05',NULL,NULL,NULL,'73e0c48a-d6b4-4ec6-a6af-83f8335f5652'),
(1811,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2026-01-17 01:37:11',NULL,NULL,NULL,'918715b2-c4bc-4658-af5a-69db0da27cc3'),
(1812,1323,NULL,981,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'25fc5d75-043d-401b-bc4e-ec235be580a4'),
(1813,1810,NULL,982,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'96c40c9a-bf39-4b02-b0b3-d1ef699c7887'),
(1814,1811,NULL,983,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'008e9455-4302-437a-8200-f2c034e19054'),
(1815,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'06b9c2ce-1651-4a8a-86a7-7c5356bb72af'),
(1816,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2026-01-17 00:29:50',NULL,NULL,NULL,'64699b22-e5f8-495a-b69f-002ec3c6c252'),
(1817,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-11-17 16:52:25',NULL,'2025-11-17 16:52:25',NULL,'0000dc09-3e71-484c-bdd8-77f99317562d'),
(1818,1329,NULL,984,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'3979d680-a116-4b1e-a7a5-0a6c121b2dc6'),
(1819,1815,NULL,985,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'12929fde-3e14-4bf7-9962-35fb681d31aa'),
(1820,1816,NULL,986,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'20ea7922-0d56-4a6a-b101-82f8b3f912b0'),
(1821,1817,NULL,987,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,'2025-11-17 16:52:25',NULL,'c7698e18-05df-4952-a42f-cf3c9b9f24cf'),
(1822,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-11-05 19:19:37',NULL,'2025-11-05 19:19:37',NULL,'471f4d74-c7fa-499a-8cae-306b30164931'),
(1823,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-11-05 19:19:37',NULL,NULL,NULL,'666740d0-f6b4-47b6-b6a0-06d620be07d4'),
(1824,1337,NULL,988,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'3cf03e59-8bbb-4c7c-ab6a-0a16b94ec7a3'),
(1825,1822,NULL,989,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,'2025-11-05 19:19:37',NULL,'86e25dad-040d-4151-9433-981ae7171fa5'),
(1826,1823,NULL,990,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'b8e50546-66e4-4357-a6ff-79e90168fd42'),
(1827,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-11-05 18:56:48',NULL,NULL,NULL,'d3297528-3b32-409c-b6be-16af3d192a2e'),
(1828,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-11-05 18:56:48',NULL,NULL,NULL,'5087fcba-21f3-4836-aa5f-bb4358991f64'),
(1829,1343,NULL,991,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'47a34faa-5c96-4fc7-8038-ed197f8f08f8'),
(1830,1827,NULL,992,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'cb7d2bb5-23a8-43c7-871e-bcebdab94058'),
(1831,1828,NULL,993,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'413693ae-357a-4d84-a471-2f80573de0c6'),
(1832,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-11-05 17:31:15',NULL,NULL,NULL,'a8a0fbbc-b600-474a-9ed9-5f0019fe100e'),
(1833,1349,NULL,994,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'a78de810-8a4e-417b-81f9-42be6866eda3'),
(1834,1832,NULL,995,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'619841f7-7e5d-42d6-b07a-3be4749d3c8a'),
(1835,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-10-08 22:38:45',NULL,NULL,NULL,'94e32ba8-ebc3-4b5e-b654-181c1c9d4545'),
(1836,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2026-01-17 00:34:34',NULL,NULL,NULL,'25e0d7c9-f92f-456b-80e8-a37d0b1767f1'),
(1837,1353,NULL,996,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'be0e5ef2-a793-433d-82d6-2456045c46fc'),
(1838,1835,NULL,997,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'5c6db164-2569-4421-8654-bce24f27e6ba'),
(1839,1836,NULL,998,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'87c30f26-abbe-4f47-9054-4b591400aeee'),
(1840,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2026-01-17 00:35:08',NULL,NULL,NULL,'6a5ff6fc-1ec6-4ae9-b309-d0857b40ffa9'),
(1841,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2026-01-17 01:52:58',NULL,NULL,NULL,'0f75f919-cb58-42dd-ae2e-4a91477fa236'),
(1842,1359,NULL,999,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'054a9a26-bdf7-45d7-8904-7fa9ecb55865'),
(1843,1840,NULL,1000,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'5b6f6017-48f2-460d-ac3a-23b26e7b8519'),
(1844,1841,NULL,1001,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'243810f1-d51b-4b1f-8162-f5e19ddb5962'),
(1845,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-11-17 15:36:43',NULL,NULL,NULL,'4cff4e0b-5e78-4452-8f7e-e59371200276'),
(1846,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-11-17 15:36:43',NULL,NULL,NULL,'ab0ec391-d1fa-4972-bbe7-45f12d4cfe8a'),
(1847,1365,NULL,1002,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'7781b427-d058-4403-aa0f-cc068a97f598'),
(1848,1845,NULL,1003,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'110582f7-c9f0-4429-81c7-3eba238f02d7'),
(1849,1846,NULL,1004,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'8c6e358e-10e8-4c81-8685-997dee75488d'),
(1850,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2026-01-17 00:37:49',NULL,NULL,NULL,'13d41bc9-272a-4b56-8acd-e47b263a7dc8'),
(1851,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-11-17 16:17:44',NULL,NULL,NULL,'6f4138d3-17a0-4d35-9eaa-aa312afd0223'),
(1852,1371,NULL,1005,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'c31ec460-aa3f-4444-8912-d9d68ea626e8'),
(1853,1850,NULL,1006,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'6f7e1ed2-fa79-4f7f-9f85-5571e196b830'),
(1854,1851,NULL,1007,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'3d978518-f030-488a-ac90-3446c7b5c99e'),
(1855,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2026-01-17 00:39:39',NULL,NULL,NULL,'7eb9ab17-2f8b-4252-bf92-afc200567d39'),
(1856,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2026-01-17 00:39:39',NULL,NULL,NULL,'a36f62f6-2a9d-4c98-99be-27f86f6fd7ed'),
(1857,1377,NULL,1008,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'870a76c4-fb89-486f-b437-7d4124e5bdc4'),
(1858,1855,NULL,1009,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'8d42fd47-6ef8-4ecc-8061-fa3a8ad0432f'),
(1859,1856,NULL,1010,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'0896b4a9-0c43-4d98-85ae-9380b42d7f00'),
(1860,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-11-17 16:42:54',NULL,NULL,NULL,'f4c2cf13-cf8d-4f75-9de0-85a34cda8767'),
(1861,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2026-01-17 00:40:18',NULL,NULL,NULL,'692c5aaf-2be0-450e-b7dd-651bf6b6bf65'),
(1862,1383,NULL,1011,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'db174a89-be16-4626-9d89-18cc50c974c2'),
(1863,1860,NULL,1012,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'a876c37e-51c7-4417-a804-26bf56eab368'),
(1864,1861,NULL,1013,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'9072cc2d-0e66-46e7-aa12-ec0b6bc7ec48'),
(1865,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-11-17 16:50:38',NULL,NULL,NULL,'68fde66d-5ac0-42f4-a230-9b18495b7cab'),
(1866,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-11-17 16:50:38',NULL,NULL,NULL,'93cb8898-e7e9-4e8e-8a28-5a848b31808c'),
(1867,1389,NULL,1014,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'1ed059d2-1144-4704-be70-5daa0ed180a0'),
(1868,1865,NULL,1015,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'21903756-72b0-4bcc-87c3-ed845b043936'),
(1869,1866,NULL,1016,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'a622bc58-439c-4405-aaa8-34d6abe614b2'),
(1870,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2026-01-08 16:18:09',NULL,NULL,NULL,'79a4a800-b9ab-42d8-a63a-b451c268f49d'),
(1871,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2026-01-08 16:18:09',NULL,NULL,NULL,'c01a1617-10de-4435-a1ec-af12f1a5b62a'),
(1872,1395,NULL,1017,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'caa05347-6568-409c-a3f9-f937b62b94db'),
(1873,1870,NULL,1018,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'69c49503-d621-4a2e-b522-3496dec7fd43'),
(1874,1871,NULL,1019,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'f92ecf03-bc16-4699-838a-268fbed4dc9b'),
(1875,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-11-17 16:32:33',NULL,NULL,NULL,'7de77e35-487c-43f4-82d4-3cd73a9d9565'),
(1876,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-11-17 16:32:33',NULL,NULL,NULL,'d6965542-553d-488f-9455-2f53e087ece4'),
(1877,1401,NULL,1020,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:27',NULL,NULL,NULL,'3f235e86-5e7a-418d-91e0-fd1bb542ed90'),
(1878,1875,NULL,1021,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:27',NULL,NULL,NULL,'3b2f4148-5f19-406a-a7f9-92b0073fd6c2'),
(1879,1876,NULL,1022,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:27',NULL,NULL,NULL,'220dc80f-f81e-435d-8d0f-c610b0e867ca'),
(1880,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-11-05 19:12:18',NULL,NULL,NULL,'11b2072d-e970-498f-a551-3269d8746893'),
(1881,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-11-05 19:12:18',NULL,NULL,NULL,'08763e8f-9bc0-4f50-b349-a7606d107ab7'),
(1882,1407,NULL,1023,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'4a2eb12d-52e8-460c-833b-ee57c3d87ec4'),
(1883,1880,NULL,1024,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'14018a65-97f2-4571-bae4-6eabeacec21a'),
(1884,1881,NULL,1025,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'9bcce777-508d-4d4d-9818-d5bd44cc5525'),
(1885,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-11-17 15:16:11',NULL,NULL,NULL,'230aafd5-fc7c-4ed5-bc04-07c152bc9305'),
(1886,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-11-17 15:16:11',NULL,NULL,NULL,'a0affaf5-f3ae-498a-b8da-a05b6090982f'),
(1887,1413,NULL,1026,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'65f855ac-56d8-4dba-8e9c-579984fc626f'),
(1888,1885,NULL,1027,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'3d742b37-3867-414b-bbe2-f41326865c39'),
(1889,1886,NULL,1028,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'8bdd245d-2d07-49e8-a0b9-7dad79746fd3'),
(1890,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-11-17 15:12:02',NULL,NULL,NULL,'a907db03-80e3-4fdc-8b3b-c6a0996071f2'),
(1891,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2026-01-06 20:43:11',NULL,NULL,NULL,'f3038bca-418b-4e59-ba90-46f17cb83fb6'),
(1892,1419,NULL,1029,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'78f3b688-0e1e-424c-af6a-d8cf547ce2db'),
(1893,1890,NULL,1030,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'1135cd0e-5f94-4fed-b2bf-ede302b67f6b'),
(1894,1891,NULL,1031,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'704d5513-6f43-4d3d-8b54-fc07f2302d92'),
(1895,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2026-01-05 18:17:24',NULL,NULL,NULL,'d33ac818-2b17-44ab-a4b6-a82f65147afd'),
(1896,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-11-17 15:17:07',NULL,NULL,NULL,'d81333f6-ce9b-48d8-b8ea-efbfcb630410'),
(1897,1425,NULL,1032,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'3fc7cbab-9fd4-4bfa-b64b-a276e58e7a84'),
(1898,1895,NULL,1033,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'b9620373-ee8e-40f8-973e-0dd43b60c231'),
(1899,1896,NULL,1034,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'99c80352-f042-40ac-b568-8d5c28bdb51b'),
(1900,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-11-17 15:41:10',NULL,NULL,NULL,'0920a6e0-b711-472c-9e82-2e7797f40822'),
(1901,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2026-01-17 13:55:07',NULL,NULL,NULL,'c7fafe4f-2c59-46f0-95a1-36187c2bb9f2'),
(1902,1431,NULL,1035,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'a85d2601-cfed-4635-8410-7e0c3ef9b540'),
(1903,1900,NULL,1036,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'cf8cc35d-2a82-4759-9e25-729180f5320f'),
(1904,1901,NULL,1037,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'090e2936-d647-4b9d-8d3c-db7f4a342ad9'),
(1905,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-11-17 15:41:58',NULL,NULL,NULL,'500423d5-fe9b-42a5-826b-7939bd7f9754'),
(1906,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2026-01-02 20:16:44',NULL,NULL,NULL,'c3123b29-086a-4c9b-8425-63e307e498d0'),
(1907,1437,NULL,1038,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'bdd3a31a-23d2-4aba-8e99-dab5f8de482c'),
(1908,1905,NULL,1039,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'b748b024-0ff4-4e84-8518-aa52c0b61ad0'),
(1909,1906,NULL,1040,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'6b9a555f-2d7c-4e25-9d47-59eb0c8370b9'),
(1910,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-11-17 15:57:50',NULL,'2025-11-17 15:57:50',NULL,'0bb92b57-5291-4f7e-88ad-87a4bc4785dc'),
(1911,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-10-14 13:43:52',NULL,NULL,NULL,'c4404b6a-770f-4759-856d-1f40e2496c8a'),
(1912,1443,NULL,1041,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'9a4a6e25-26ea-4ddf-9a33-256fc99de417'),
(1913,1910,NULL,1042,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,'2025-11-17 15:57:50',NULL,'8606d728-1a7a-404b-a5a6-ca0a58f0aa7e'),
(1914,1911,NULL,1043,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'68800b7a-9bcc-404a-8129-709b324a84bb'),
(1915,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-11-17 16:19:28',NULL,'2025-11-17 16:19:28',NULL,'1e5b50e5-aa15-41cd-844f-d693555e098c'),
(1916,NULL,NULL,NULL,2,'craft\\elements\\Entry',0,0,'2025-09-11 18:51:28','2026-01-17 14:05:55',NULL,NULL,NULL,'cb288b57-6c2b-407a-988c-1fd6fc42d6db'),
(1917,1449,NULL,1044,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'25550513-724a-4fe1-bf13-524630ad9c9a'),
(1918,1915,NULL,1045,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,'2025-11-17 16:19:28',NULL,'3ca9d135-e056-4e5e-9505-58e9675be716'),
(1919,1916,NULL,1046,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'e8c7b86b-9038-4260-b9c1-de90363db8b8'),
(1920,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-11-17 16:21:02',NULL,NULL,NULL,'14ac5709-531d-420e-9026-888e03f07ffe'),
(1921,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-11-17 16:21:02',NULL,NULL,NULL,'b83165b6-a1a8-44f9-95d5-43ca0cf6416c'),
(1922,1455,NULL,1047,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'4e19b3af-86c6-48f1-96b9-97f153cf7f1f'),
(1923,1920,NULL,1048,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'138f1306-d885-45d1-aa0c-b5b500498840'),
(1924,1921,NULL,1049,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'63943615-d97d-4702-ab4e-1bc8eb09354b'),
(1925,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-11-17 16:36:55',NULL,'2025-11-17 16:36:55',NULL,'8e4e8ed5-d2a1-423f-adce-87931beecf0e'),
(1926,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-11-17 16:36:55',NULL,NULL,NULL,'dfd8d683-58f6-468e-be34-b4b6e7c17fb9'),
(1927,1461,NULL,1050,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'243ef27b-8197-40bb-bf53-5ccabaaa9b5c'),
(1928,1925,NULL,1051,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,'2025-11-17 16:36:55',NULL,'59b2bd62-935f-4859-8080-4d09e205366c'),
(1929,1926,NULL,1052,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'986c668a-08e6-4c51-a72d-0919da9021e2'),
(1930,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-11-17 16:38:04',NULL,NULL,NULL,'f4c1f7dc-7a75-42ee-ac92-9ef9b78f61fc'),
(1931,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-11-17 16:38:25',NULL,NULL,NULL,'a438d929-77c9-4af7-abef-b2879f1e5c84'),
(1932,1467,NULL,1053,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'45ea515f-3ed9-4075-8894-188072e6c3ed'),
(1933,1930,NULL,1054,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'50604da0-dcf0-4764-a777-f68bc1810b66'),
(1934,1931,NULL,1055,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'be79f7df-2425-484e-ab24-abbba17b0ceb'),
(1935,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-12-16 14:42:53',NULL,NULL,NULL,'cfce61df-c81b-4f57-a3aa-983ba807fa20'),
(1936,1473,NULL,1056,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'45419a6a-da1f-451e-8953-6ca423ce243f'),
(1937,1935,NULL,1057,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'4ab12f2e-3542-4181-b00e-1fe92785fb63'),
(1938,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2026-01-06 19:05:05',NULL,NULL,NULL,'f6ee35b4-a050-4d7c-8729-843db1a50ea4'),
(1939,1477,NULL,1058,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'8fa91883-d767-4d14-aa41-5f61d84248bc'),
(1940,1938,NULL,1059,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'fc374cf4-3141-4289-bed8-f0135c5d6ad0'),
(1941,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-10-16 19:23:32',NULL,NULL,NULL,'327c5010-6976-4b31-a426-5bef2b9716fb'),
(1942,1481,NULL,1060,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'bdeca20e-b791-49e2-bc6a-f184d054b824'),
(1943,1941,NULL,1061,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'9db34f42-920d-4a3a-bbac-1487575bef3b'),
(1945,1255,NULL,1062,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:39','2025-09-11 18:51:39',NULL,NULL,NULL,'aeb6cd6e-166d-49b1-94c2-122362509693'),
(1950,1045,NULL,1063,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:54:53','2025-09-11 18:54:53',NULL,NULL,NULL,'037c6a7b-f4ca-4f5f-9d41-5546b1bc4dec'),
(1952,1045,NULL,1064,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:55:25','2025-09-11 18:55:25',NULL,NULL,NULL,'a4b7340f-335d-4bae-90fa-eabca932cfe4'),
(1956,1165,NULL,1066,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:58:34','2025-09-11 18:58:35',NULL,NULL,NULL,'6e371be7-c4c2-4691-9a2f-3d690e430c61'),
(1958,1165,NULL,1067,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:58:45','2025-09-11 18:58:45',NULL,NULL,NULL,'a35e30f1-61b0-4883-a550-c6061b7b17ec'),
(1960,1045,NULL,1068,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:59:21','2025-09-11 18:59:21',NULL,NULL,NULL,'579adcfc-bfd4-4709-a62d-081711589a66'),
(1961,1255,NULL,1069,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:59:27','2025-09-11 18:59:27',NULL,NULL,NULL,'7f35ef7b-b5c6-443e-a315-18c28e5f4483'),
(1963,1171,NULL,1070,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:00:06','2025-09-11 19:00:06',NULL,NULL,NULL,'71bfee52-d555-4a08-9534-077ca5cbe269'),
(1965,945,NULL,1071,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:00:18','2025-09-11 19:00:18',NULL,NULL,NULL,'769e2c1e-2d82-4230-adde-ca78df4c3414'),
(1967,951,NULL,1072,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:24','2025-09-11 19:01:24',NULL,NULL,NULL,'c324fefe-82cf-4376-97f7-2b69f44746d0'),
(1969,1261,NULL,1073,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:31','2025-09-11 19:01:31',NULL,NULL,NULL,'1da2dfd1-fdde-4e7c-8c1c-b16c1dfbf1ec'),
(1971,1177,NULL,1074,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:39','2025-09-11 19:01:39',NULL,NULL,NULL,'7428aa4c-a324-48f5-bc4b-f83ad1e242cb'),
(1972,1692,NULL,1075,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 19:01:39',NULL,NULL,NULL,'177d8af8-68d2-405d-bb09-9da61b2e8e0b'),
(1973,1693,NULL,1076,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 19:01:39',NULL,NULL,NULL,'3490e4fe-14b5-46b7-931a-24ed1625eaab'),
(1975,957,NULL,1077,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:46','2025-09-11 19:01:46',NULL,NULL,NULL,'5a6d582d-e693-4542-95d5-694ae8edd825'),
(1977,963,NULL,1078,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:52','2025-09-11 19:01:52',NULL,NULL,NULL,'ded4b389-d06d-4955-b88e-e03f1cb638f1'),
(1979,1051,NULL,1079,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:59','2025-09-11 19:01:59',NULL,NULL,NULL,'f46cb30c-a0c6-4d8a-a88b-82625188ec6d'),
(1981,1051,NULL,1080,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:02:12','2025-09-11 19:02:12',NULL,NULL,NULL,'db1d62cc-7f60-471e-af4e-b339a6f884b0'),
(1983,1185,NULL,1081,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:02:19','2025-09-11 19:02:19',NULL,NULL,NULL,'fa0de283-2588-4fb8-93b5-2bddd3befe3c'),
(1985,1161,NULL,1082,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:02:26','2025-09-11 19:02:26',NULL,NULL,NULL,'3f884b43-9ad9-4476-8d54-de21b35d977e'),
(1987,1353,NULL,1083,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:02:33','2025-09-11 19:02:33',NULL,NULL,NULL,'3f62a119-8a49-4505-b812-2432afec1c4b'),
(1989,1353,NULL,1084,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:03','2025-09-11 19:03:03',NULL,NULL,NULL,'9f717ca5-e7c2-44b7-916c-0abb30e940e0'),
(1991,1059,NULL,1085,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:09','2025-09-11 19:03:09',NULL,NULL,NULL,'53f2d592-8c00-47ab-ad91-35cb9e26d24c'),
(1993,1269,NULL,1086,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:21','2025-09-11 19:03:21',NULL,NULL,NULL,'f5dbd9bf-09ad-4271-b3cd-08dc704adbc3'),
(1995,969,NULL,1087,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:31','2025-09-11 19:03:31',NULL,NULL,NULL,'ca4f3f93-fb2c-422b-887a-3b42918a2742'),
(1997,1277,NULL,1088,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:39','2025-09-11 19:03:39',NULL,NULL,NULL,'4e32f9a1-e6c0-464e-b2af-5b3bb1e53f37'),
(1999,1191,NULL,1089,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:56','2025-09-11 19:03:56',NULL,NULL,NULL,'79286800-b391-44a3-ba13-864b0de6eebf'),
(2001,1419,NULL,1090,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:06','2025-09-11 19:04:06',NULL,NULL,NULL,'15b9b681-8401-45b0-bd13-5d8d55fef6ec'),
(2003,1419,NULL,1091,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:21','2025-09-11 19:04:21',NULL,NULL,NULL,'1efa532e-9b4c-4b07-9af8-4403ad2ce57b'),
(2005,1425,NULL,1092,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:31','2025-09-11 19:04:31',NULL,NULL,NULL,'06d52a4f-7755-48c4-87eb-7752656a9233'),
(2007,1359,NULL,1093,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:40','2025-09-11 19:04:40',NULL,NULL,NULL,'de8e5c35-5844-4e09-a2e5-4833c2b07705'),
(2009,1365,NULL,1094,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:55','2025-09-11 19:04:55',NULL,NULL,NULL,'8054172c-564b-47df-a889-5aeb069b98db'),
(2011,975,NULL,1095,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:05:04','2025-09-11 19:05:04',NULL,NULL,NULL,'7861fac0-724f-4983-8169-f3863032cfb3'),
(2013,1067,NULL,1096,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:05:28','2025-09-11 19:05:28',NULL,NULL,NULL,'c4a17551-66b4-41d0-9db9-bd0c5a6ff983'),
(2015,1431,NULL,1097,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:05:37','2025-09-11 19:05:37',NULL,NULL,NULL,'183d926c-0797-4eb4-8ea6-975b647a9ecf'),
(2017,1437,NULL,1098,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:05:50','2025-09-11 19:05:50',NULL,NULL,NULL,'e756ade6-4126-4ad8-811f-19e1cf67f171'),
(2019,1283,NULL,1099,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:06:02','2025-09-11 19:06:02',NULL,NULL,NULL,'ced759c0-5d53-4329-8723-8b737c7e5013'),
(2021,1437,NULL,1100,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:06:46','2025-09-11 19:06:47',NULL,NULL,NULL,'c6b693cf-a6a5-4087-8ee3-52d37d094925'),
(2022,1283,NULL,1101,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:06:53','2025-09-11 19:06:53',NULL,NULL,NULL,'5ae3fcb4-c324-4f2d-bbcf-8d2e8fa407d2'),
(2024,1197,NULL,1102,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:01','2025-09-11 19:07:01',NULL,NULL,NULL,'fc0623dc-0cad-463c-bda5-8e8fe27bc7de'),
(2026,1201,NULL,1103,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:11','2025-09-11 19:07:12',NULL,NULL,NULL,'b96525de-7389-41f8-8216-6e51abe1e8b6'),
(2028,1443,NULL,1104,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:29','2025-09-11 19:07:29',NULL,NULL,NULL,'fd8301a6-5532-457f-8fa1-84cbdda41116'),
(2030,1209,NULL,1105,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:38','2025-09-11 19:07:38',NULL,NULL,NULL,'e4b44308-2f90-4005-aa80-2ac211a8bf77'),
(2032,1289,NULL,1106,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:47','2025-09-11 19:07:47',NULL,NULL,NULL,'1121d306-d4be-48b2-9462-3232de9d17aa'),
(2034,1297,NULL,1107,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:59','2025-09-11 19:07:59',NULL,NULL,NULL,'65fa8d79-6df8-4b00-8a69-e093f3da6aac'),
(2036,1303,NULL,1108,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:08:08','2025-09-11 19:08:08',NULL,NULL,NULL,'69ed4dc5-add5-40fa-b43b-ac9827039a47'),
(2039,1073,NULL,1109,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:08:31','2025-09-11 19:08:31',NULL,NULL,NULL,'1c6a3457-61ed-4d09-83d1-ac5eef6dfa6d'),
(2041,981,NULL,1110,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:08:55','2025-09-11 19:08:55',NULL,NULL,NULL,'fd810555-a475-4dc2-8fce-5f1f42ed2e87'),
(2043,1215,NULL,1111,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:04','2025-09-11 19:09:04',NULL,NULL,NULL,'8f3990ad-19d7-4d8e-881b-49f19c2c58af'),
(2045,1371,NULL,1112,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:15','2025-09-11 19:09:15',NULL,NULL,NULL,'8edd622b-4958-459c-b064-61231eb17fac'),
(2047,1449,NULL,1113,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:25','2025-09-11 19:09:25',NULL,NULL,NULL,'63066403-79fc-4d19-8c64-191a0eb81c37'),
(2049,1455,NULL,1114,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:37','2025-09-11 19:09:37',NULL,NULL,NULL,'ff3e62f8-0754-42b1-a096-64f04af0c4f8'),
(2051,989,NULL,1115,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:56','2025-09-11 19:09:56',NULL,NULL,NULL,'c9c12ae3-7c68-44d9-96df-d7ce4caabfca'),
(2053,1309,NULL,1116,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:10:06','2025-09-11 19:10:06',NULL,NULL,NULL,'c8161a3d-e5b4-4737-b2d6-530516336b02'),
(2055,995,NULL,1117,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:10:16','2025-09-11 19:10:16',NULL,NULL,NULL,'2dfb8d83-0cd8-4b55-83ef-92273a04153c'),
(2057,1219,NULL,1118,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:10:32','2025-09-11 19:10:32',NULL,NULL,NULL,'fb13fab4-d7a9-4278-a6be-489bc6ea86eb'),
(2059,1079,NULL,1119,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:10:45','2025-09-11 19:10:45',NULL,NULL,NULL,'7c111a7d-bd62-416f-8e79-af0f875e7f77'),
(2061,1477,NULL,1120,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:11:04','2025-09-11 19:11:04',NULL,NULL,NULL,'3a9d6c76-22b3-4fd7-9eb6-c23943d00bfa'),
(2063,1377,NULL,1121,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:11:43','2025-09-11 19:11:43',NULL,NULL,NULL,'f91db735-2a6c-47e4-bf40-a0e90cd1e6cc'),
(2065,1461,NULL,1122,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:11:57','2025-09-11 19:11:57',NULL,NULL,NULL,'d3992f92-5b45-42ed-999b-fe134c7957a2'),
(2067,1467,NULL,1123,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:12:17','2025-09-11 19:12:17',NULL,NULL,NULL,'e4d2d6ae-69aa-4fa2-9f6c-30c0773497c1'),
(2069,1467,NULL,1124,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:12:28','2025-09-11 19:12:28',NULL,NULL,NULL,'4dd55d21-d6b3-48c3-8b00-cd66cc763be1'),
(2071,1225,NULL,1125,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:12:43','2025-09-11 19:12:43',NULL,NULL,NULL,'f919eb6c-9177-4540-8272-521b059be394'),
(2073,1225,NULL,1126,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:12:57','2025-09-11 19:12:57',NULL,NULL,NULL,'a6ce2774-35b6-4250-9ad7-5d2170515117'),
(2075,1005,NULL,1127,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:13:09','2025-09-11 19:13:09',NULL,NULL,NULL,'a94bf1a5-e38c-44f4-8a28-7ada754147b5'),
(2077,1315,NULL,1128,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:13:20','2025-09-11 19:13:20',NULL,NULL,NULL,'0fa73409-ee0d-4c09-8362-d4103abcd787'),
(2079,1085,NULL,1129,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:13:54','2025-09-11 19:13:54',NULL,NULL,NULL,'ab1fe88c-150b-4e00-81c6-4919458ee93f'),
(2081,1383,NULL,1130,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:14:08','2025-09-11 19:14:08',NULL,NULL,NULL,'6fb5e57c-6c45-426c-84e0-8dd44b4a6371'),
(2083,1323,NULL,1131,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:14:25','2025-09-11 19:14:25',NULL,NULL,NULL,'3b340bb2-b777-4403-ad32-f4dc48fd168b'),
(2085,1011,NULL,1132,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:14:55','2025-09-11 19:14:55',NULL,NULL,NULL,'4d24b9f2-448f-4cda-b181-3f5a092eedee'),
(2087,1091,NULL,1133,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:07','2025-09-11 19:15:07',NULL,NULL,NULL,'8cbaf9be-7fe2-459d-9e47-4d9e599e95a8'),
(2089,1097,NULL,1134,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:25','2025-09-11 19:15:25',NULL,NULL,NULL,'e2027a29-e251-4ab5-b941-da3ed42e565f'),
(2091,1097,NULL,1135,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:41','2025-09-11 19:15:41',NULL,NULL,NULL,'188649eb-7b5a-40a4-9d8a-d7987434cb4d'),
(2093,1231,NULL,1136,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:48','2025-09-11 19:15:48',NULL,NULL,NULL,'58843612-2201-4031-8a2e-27b4d1fdf543'),
(2095,1103,NULL,1137,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:58','2025-09-11 19:15:58',NULL,NULL,NULL,'4b531cc3-8568-42bb-a169-633998f0cbdc'),
(2097,1237,NULL,1138,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:16:11','2025-09-11 19:16:11',NULL,NULL,NULL,'e59f3c54-4311-4224-ad56-f5850287a5be'),
(2099,1243,NULL,1139,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:16:31','2025-09-11 19:16:31',NULL,NULL,NULL,'87067b26-d622-42d1-9a23-f6cce931c3bc'),
(2102,1389,NULL,1140,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:16:56','2025-09-11 19:16:56',NULL,NULL,NULL,'124437b5-cec4-48b2-9ee7-85e937bf1838'),
(2103,1243,NULL,1141,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:17:03','2025-09-11 19:17:03',NULL,NULL,NULL,'867de1e8-dc80-4d60-a5c7-87cd2e003c18'),
(2105,1149,NULL,1142,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:17:31','2025-09-11 19:17:31',NULL,NULL,NULL,'38169acf-dfa1-4d5b-b8d6-f43e340d9eb9'),
(2107,1149,NULL,1143,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:17:42','2025-09-11 19:17:42',NULL,NULL,NULL,'268757dc-351d-4c82-a469-3dffabebac7b'),
(2109,1155,NULL,1144,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:17:58','2025-09-11 19:17:58',NULL,NULL,NULL,'1b29a977-2c91-4483-b1ab-8837337ff882'),
(2111,1329,NULL,1145,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:18:15','2025-09-11 19:18:15',NULL,NULL,NULL,'429646eb-2b77-48bb-8380-1754da05cdb9'),
(2113,1329,NULL,1146,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:18:25','2025-09-11 19:18:25',NULL,NULL,NULL,'cbcbb25d-6d83-45d5-8904-a3ed7ca981d5'),
(2115,1481,NULL,1147,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:18:38','2025-09-11 19:18:38',NULL,NULL,NULL,'c280fc34-0bf7-41a9-899f-1abf988aa6ee'),
(2117,1337,NULL,1148,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:18:55','2025-09-11 19:18:55',NULL,NULL,NULL,'19284174-7252-465b-b26d-107b795e1b9a'),
(2119,1407,NULL,1149,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:07','2025-09-11 19:19:07',NULL,NULL,NULL,'098e0b0a-81ad-4706-838a-eb180aa2f551'),
(2121,1343,NULL,1150,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:20','2025-09-11 19:19:20',NULL,NULL,NULL,'30907729-e9f0-48b0-bc40-7f9f2474f864'),
(2123,1395,NULL,1151,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:37','2025-09-11 19:19:37',NULL,NULL,NULL,'034a676e-d0c3-4198-a6ca-e7f228bdd5f2'),
(2125,1401,NULL,1152,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:49','2025-09-11 19:19:49',NULL,NULL,NULL,'4b5ada0f-bd5e-4d2f-8d79-6d66c2bfddf9'),
(2127,1473,NULL,1153,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:59','2025-09-11 19:19:59',NULL,NULL,NULL,'0a81651d-9d48-4f62-aa11-cd74ba613f36'),
(2129,1031,NULL,1154,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:20:11','2025-09-11 19:20:11',NULL,NULL,NULL,'a6265b03-a98c-40b8-b3b7-a368c32df4bd'),
(2131,1413,NULL,1155,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:20:35','2025-09-11 19:20:35',NULL,NULL,NULL,'795dd5f1-22f2-4bf8-a3d2-e314c7d0fd8b'),
(2133,1035,NULL,1156,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:20:48','2025-09-11 19:20:48',NULL,NULL,NULL,'1fd64ce7-13e6-4b3b-b75c-7e92550ca2b6'),
(2135,1041,NULL,1157,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:20:57','2025-09-11 19:20:57',NULL,NULL,NULL,'9c2ef53c-f806-4d03-9676-1d79eb8d776d'),
(2137,1249,NULL,1158,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:06','2025-09-11 19:21:06',NULL,NULL,NULL,'e14b57ba-a400-4be5-ae17-3f19da532c1b'),
(2139,1123,NULL,1159,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:17','2025-09-11 19:21:17',NULL,NULL,NULL,'717b966a-f061-43a1-ac67-6d9e36a302b4'),
(2141,1129,NULL,1160,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:27','2025-09-11 19:21:27',NULL,NULL,NULL,'bc0b3233-81f6-443a-b3ee-30dbfb648e88'),
(2143,1349,NULL,1161,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:36','2025-09-11 19:21:37',NULL,NULL,NULL,'b33c7e7d-a9d9-4212-90d5-d5506decebb1'),
(2145,1135,NULL,1162,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:45','2025-09-11 19:21:45',NULL,NULL,NULL,'b2e18ab4-0ee7-4015-af21-551ddfaaaa45'),
(2147,1141,NULL,1163,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:55','2025-09-11 19:21:55',NULL,NULL,NULL,'a7892f37-90c2-44ee-bb1c-bf24b417b97a'),
(2149,1141,NULL,1164,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:22:03','2025-09-11 19:22:03',NULL,NULL,NULL,'dc8d4e0e-c074-48c4-9d5c-47020a0dd90f'),
(2152,1143,NULL,1165,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:22:43','2025-09-11 19:22:43',NULL,NULL,NULL,'bbbf47b5-b0fc-4c27-946b-24678475e6fc'),
(2154,1117,NULL,1166,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:23:17','2025-09-11 19:23:17',NULL,NULL,NULL,'d3a7392b-cf13-4484-b503-300c52fce2de'),
(2156,1109,NULL,1167,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:23:27','2025-09-11 19:23:27',NULL,NULL,NULL,'06f188b6-d912-4561-a403-92160842c7d0'),
(2158,1023,NULL,1168,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:23:46','2025-09-11 19:23:46',NULL,NULL,NULL,'183c6dc7-807d-4933-830e-ec86f265f495'),
(2160,1017,NULL,1169,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:23:59','2025-09-11 19:23:59',NULL,NULL,NULL,'28e8a7b5-4c4d-4835-98ca-60b3e29b0a85'),
(2162,999,NULL,1170,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:24:30','2025-09-11 19:24:30',NULL,NULL,NULL,'1aba5b72-1133-4e69-9ffe-ad18f4b17baa'),
(2164,1255,NULL,1171,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:34:46','2025-09-11 19:34:46',NULL,NULL,NULL,'e1f929a8-8a5a-4f05-890f-0483155ad718'),
(2166,1261,NULL,1172,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:34:52','2025-09-11 19:34:52',NULL,NULL,NULL,'d12f63d1-c3b1-49c6-ab0c-159f96d6077c'),
(2168,1177,NULL,1173,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:34:59','2025-09-11 19:34:59',NULL,NULL,NULL,'22bbf03c-f9db-4a08-b7c1-775034c245b0'),
(2170,1185,NULL,1174,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:10','2025-09-11 19:35:10',NULL,NULL,NULL,'564a2f6d-d289-44cf-9111-627c267d9070'),
(2172,1353,NULL,1175,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:16','2025-09-11 19:35:16',NULL,NULL,NULL,'59c680cd-72eb-46ba-a5a9-a8abef1dd96e'),
(2174,1277,NULL,1176,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:24','2025-09-11 19:35:24',NULL,NULL,NULL,'1f7b5541-779c-4c78-b58f-d1b705ac267f'),
(2176,1191,NULL,1177,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:30','2025-09-11 19:35:30',NULL,NULL,NULL,'057aa1ca-89a3-44bb-b2de-2288c4c0605a'),
(2178,1359,NULL,1178,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:38','2025-09-11 19:35:38',NULL,NULL,NULL,'d1a1d83f-5780-42cb-929c-73f104f97786'),
(2180,1431,NULL,1179,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:45','2025-09-11 19:35:45',NULL,NULL,NULL,'237fafc6-7654-470b-9cfc-efb98a6d7271'),
(2182,1197,NULL,1180,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:51','2025-09-11 19:35:51',NULL,NULL,NULL,'e3b2b065-886b-40e6-920d-e7df10e52616'),
(2184,1201,NULL,1181,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:58','2025-09-11 19:35:58',NULL,NULL,NULL,'1f3bae81-3cdf-42b0-bf1c-df0190d766e7'),
(2186,1309,NULL,1182,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:36:26','2025-09-11 19:36:26',NULL,NULL,NULL,'96ebee49-8963-4c9c-8597-267e083243c3'),
(2188,1443,NULL,1183,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:36:38','2025-09-11 19:36:38',NULL,NULL,NULL,'28f0121a-37b6-4ca3-af90-5e7269320ca3'),
(2190,1209,NULL,1184,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:36:45','2025-09-11 19:36:45',NULL,NULL,NULL,'953faded-417d-4438-85ac-49071795e887'),
(2192,1289,NULL,1185,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:36:53','2025-09-11 19:36:53',NULL,NULL,NULL,'e30dcae5-ccfe-49cf-93b8-a69701e666d2'),
(2194,1297,NULL,1186,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:00','2025-09-11 19:37:00',NULL,NULL,NULL,'df9825e6-1ac9-47d8-8a64-b9d919d41d54'),
(2196,1303,NULL,1187,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:09','2025-09-11 19:37:09',NULL,NULL,NULL,'1d9da0c5-dccd-4eb6-9192-0260bd1984f8'),
(2197,1215,NULL,1188,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:16','2025-09-11 19:37:16',NULL,NULL,NULL,'540ad7cf-b5e1-409f-afa7-88630103ba50'),
(2199,1371,NULL,1189,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:24','2025-09-11 19:37:24',NULL,NULL,NULL,'220dbb9c-a7bb-49a3-b5ec-06335d4d074d'),
(2201,1449,NULL,1190,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:31','2025-09-11 19:37:31',NULL,NULL,NULL,'378afe3c-7ad2-4057-8861-763cb525f48b'),
(2203,1231,NULL,1191,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:38','2025-09-11 19:37:38',NULL,NULL,NULL,'89c6954e-718d-48d5-b247-84e07933c47d'),
(2206,1161,NULL,1192,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:52:35','2025-09-11 19:52:35',NULL,NULL,NULL,'adccd7e0-b5fb-4f81-b009-4cfe297a5849'),
(2207,1255,NULL,1193,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:52:43','2025-09-11 19:52:43',NULL,NULL,NULL,'f3c60345-c1b2-4c53-99a3-6baae8d56224'),
(2208,497,NULL,1194,6,'craft\\elements\\Entry',1,0,'2025-09-11 20:12:38','2025-09-11 20:12:38',NULL,NULL,NULL,'3498aeec-5b14-4b84-bafb-08697c8b53f9'),
(2212,945,NULL,1196,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:27:20','2025-09-11 20:27:20',NULL,NULL,NULL,'b420004f-163b-4034-8658-a94341a4a0ed'),
(2214,945,NULL,1197,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:30:33','2025-09-11 20:30:33',NULL,NULL,NULL,'2374b5ae-3391-4a6d-aa6c-6e1f9f339b64'),
(2216,951,NULL,1198,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:30:50','2025-09-11 20:30:50',NULL,NULL,NULL,'9118d376-91a5-4fae-b2fe-537f74bb71dd'),
(2218,1437,NULL,1199,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:31:02','2025-09-11 20:31:02',NULL,NULL,NULL,'c4dc8153-951e-41c1-a1f4-4315cb87714f'),
(2220,1045,NULL,1200,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:37:16','2025-09-11 20:37:16',NULL,NULL,NULL,'08484410-644a-4005-8b7c-4aa667156fc5'),
(2223,56,NULL,1202,3,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2026-01-19 20:59:10',NULL,NULL,NULL,'4e5eb46e-e14e-43f3-8d8d-f5a86820c322'),
(2224,57,NULL,1203,3,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2026-01-19 20:59:10',NULL,NULL,NULL,'6811b45c-2526-425c-9771-c76348de7f60'),
(2225,63,NULL,1204,3,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2026-01-19 20:59:10',NULL,NULL,NULL,'bec226d8-89bd-4ba4-b8a9-d169181f88ca'),
(2228,945,NULL,1207,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'a1546e0b-f5e7-4d50-acf1-a056630ff547'),
(2229,1494,NULL,1208,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'d455be16-8f79-481c-b59f-bd05e884bb55'),
(2230,1495,NULL,1209,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'818f03d2-2c7f-432c-834b-4e423ee03a8f'),
(2231,951,NULL,1210,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'35bff0ce-c0b2-4bbd-93cf-8c5d2d9b2ac8'),
(2232,1499,NULL,1211,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,'2025-12-01 19:40:26',NULL,'5333d547-c46a-4718-a413-cfd01d1d7bd9'),
(2233,1500,NULL,1212,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'d168976e-2cc4-4d4c-af00-dc14d2a37bc7'),
(2234,957,NULL,1213,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'11054c99-805e-4238-af87-1a52d87a267f'),
(2235,1504,NULL,1214,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'31ca1736-0b72-49e5-8b26-1fc644fb6e0c'),
(2236,1505,NULL,1215,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'66c2d571-d2f3-4537-9dfd-ca69866967ae'),
(2237,963,NULL,1216,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'15ba3880-7c72-4877-81da-202a88bedd85'),
(2238,1509,NULL,1217,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'9e453bae-4d20-410b-81e8-2c650402d2be'),
(2239,1510,NULL,1218,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'ba139b53-862e-4d30-b107-c74786ddc7c3'),
(2240,969,NULL,1219,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'76467b31-29e9-40c7-a25c-794903e321bd'),
(2241,1514,NULL,1220,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'37c2f1d8-f48d-4d37-bf79-86544c5bf1c9'),
(2242,1515,NULL,1221,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,'2025-11-17 15:01:37',NULL,'b80b993f-bd4d-4975-8703-151af6f1e21c'),
(2243,975,NULL,1222,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'e2c3f267-0edf-4d28-a871-5534827dcd13'),
(2244,1519,NULL,1223,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'14d99b35-006a-4797-87c8-7c252b050c34'),
(2245,1520,NULL,1224,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'8c8ee26e-61fc-4272-9f5b-93cad0aea522'),
(2246,981,NULL,1225,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'5c4a8ed7-bccf-4437-aaa7-ccef65c83c1d'),
(2247,1524,NULL,1226,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'49785bf4-1804-40ae-902c-62aa105e5baf'),
(2248,1525,NULL,1227,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'49b1fef5-b341-46a6-8539-65944a4f9d37'),
(2249,1526,NULL,1228,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'fde5d0cc-d53c-4192-abec-5146012a0d9e'),
(2250,989,NULL,1229,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'1a80dca2-0fa0-4653-bd07-8c40d380e4ce'),
(2251,1531,NULL,1230,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'12ce86c0-0c3d-4ff2-b6b5-fdf5c1e2b7df'),
(2252,1532,NULL,1231,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'f13c2c60-e917-4db6-acb2-69a827a40b98'),
(2253,995,NULL,1232,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'375cd1b6-6ec5-440e-8538-f21a90afbcd2'),
(2254,1536,NULL,1233,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'441b9908-0779-4bf8-b2be-fd673573a183'),
(2255,999,NULL,1234,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'6500fb11-8903-4680-be51-66242e0c7a20'),
(2256,1539,NULL,1235,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'dd556e78-6349-447f-b8d0-707142b16ec5'),
(2257,1540,NULL,1236,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'ec389eac-6d0c-4afe-bdd2-4f08d61461c1'),
(2258,1005,NULL,1237,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'b3a7f86f-79b9-46c9-8ab2-e0e9b0e9d916'),
(2259,1544,NULL,1238,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'6f5eb08b-cc8c-4d43-a1a4-8f641b93d518'),
(2260,1545,NULL,1239,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'0a490659-8694-4bac-8ce9-52eeabd18f52'),
(2261,1011,NULL,1240,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'4f3698dd-fd09-40a7-b4c3-bfc3ad5be997'),
(2262,1549,NULL,1241,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'eb92debb-00f0-4953-928e-ac061fad2a19'),
(2263,1550,NULL,1242,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,'2025-11-17 16:45:42',NULL,'5627854d-5dc2-454c-ad79-f9a8f48b4bd5'),
(2264,1017,NULL,1243,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'bbc28ebf-a9f6-49da-acd8-ac0b6d0b7acc'),
(2265,1554,NULL,1244,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'aca4acd2-c94c-4cc5-9b3e-0312a8f8b4b7'),
(2266,1555,NULL,1245,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'75b7da17-206c-4efb-8ddf-c8b801b712b0'),
(2267,1023,NULL,1246,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'176c0ba4-bc21-4067-b569-92ef20f7e264'),
(2268,1559,NULL,1247,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:31',NULL,NULL,NULL,'e17f6c2d-9f0d-4c47-8af3-ca8ce6ea4a7b'),
(2269,1560,NULL,1248,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:31',NULL,NULL,NULL,'368a349a-efc7-4b30-b2e2-b3249d10a78d'),
(2270,1561,NULL,1249,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:31',NULL,NULL,NULL,'1fac32b3-6aad-4a48-925d-cd3835dcd99c'),
(2271,1031,NULL,1250,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'12dad23f-955f-460e-ad35-6acc8ecfd830'),
(2272,1566,NULL,1251,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,'2025-11-17 16:58:10',NULL,'81ed302a-8151-4dea-9454-f47db8b9952a'),
(2273,1035,NULL,1252,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'6411ee32-f902-4121-9ccf-0078ea5de8d5'),
(2274,1569,NULL,1253,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'9ffcb1f0-a9e9-452c-813c-02a7f4978917'),
(2275,1570,NULL,1254,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'a14619a0-72b1-40db-ad1e-5ad7a06e4946'),
(2276,1041,NULL,1255,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'70162289-9d4e-45d6-99b6-e49a8104b1d3'),
(2277,1574,NULL,1256,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'ac390979-2a8a-4b12-8501-6c6bea6cda41'),
(2278,1045,NULL,1257,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'af310d04-cb63-45fa-8a23-6afc7798913e'),
(2279,1577,NULL,1258,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'5b60e712-d1da-498a-9082-440f853077eb'),
(2280,1578,NULL,1259,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'fd2f732f-b26f-49a2-93b9-b331716686f1'),
(2281,1051,NULL,1260,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'38d50995-0253-44eb-8f77-5a17e5acf2c2'),
(2282,1582,NULL,1261,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'69f1dc7e-221e-47ad-862d-15ac4300cdeb'),
(2283,1583,NULL,1262,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'3702f942-39d6-460e-b36e-8b4540db6f7c'),
(2284,1584,NULL,1263,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'beaba663-8777-4d6c-bc57-d51a866a3c30'),
(2285,1059,NULL,1264,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'e836ae4c-c9dc-4d8b-ab0d-a6fcb75733c4'),
(2286,1589,NULL,1265,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'dcfd9632-efc0-4d7f-b776-a48ddea5b270'),
(2287,1590,NULL,1266,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'08905de6-b619-444b-aee7-a9189ee1f75c'),
(2288,1591,NULL,1267,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'a940b45d-155e-4ce6-b24b-2d2e68ffe4e1'),
(2289,1067,NULL,1268,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'d045bc02-ef67-4ed6-aeca-22f47813749c'),
(2290,1596,NULL,1269,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'1578dcc9-d907-4e8d-910f-263caaef3727'),
(2291,1597,NULL,1270,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'a33634ac-17e3-4467-bfdb-c6858f3f2024'),
(2292,1073,NULL,1271,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'a9919f68-a24e-47df-880a-5717be11b580'),
(2293,1601,NULL,1272,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'9dec0979-58c5-457b-926b-aed67e022895'),
(2294,1602,NULL,1273,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'683b5e74-9f8d-4b0f-973b-26fa1644b6b4'),
(2295,1079,NULL,1274,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'149786bc-fabb-496b-a566-85da74d4967d'),
(2296,1606,NULL,1275,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'8b1fedcb-9f31-4e98-8184-d0534b10afe3'),
(2297,1607,NULL,1276,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'35dc0f46-424d-4a7c-abfd-4897971b5b41'),
(2298,1085,NULL,1277,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:32',NULL,NULL,NULL,'c5018270-43ab-4486-a44c-0fd2c8bcd2a9'),
(2299,1611,NULL,1278,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'318a27e4-e09a-4352-bbb3-67cca0fa51a0'),
(2300,1612,NULL,1279,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'29274ee7-c4cd-4f9e-994f-d1abfc4bfa9b'),
(2301,1091,NULL,1280,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'f1135250-e2aa-43a0-91d0-c9caad7d1b29'),
(2302,1616,NULL,1281,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'42d461cd-6404-402c-a3e3-4381c5465191'),
(2303,1617,NULL,1282,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'60fde109-9d7f-46c3-b7b8-69b88a6ca346'),
(2304,1097,NULL,1283,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'db301f11-7b2a-400d-8159-ed7281d24ab4'),
(2305,1621,NULL,1284,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'e1686c55-70f9-4cea-b2e4-ce7d009313ac'),
(2306,1622,NULL,1285,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'c575a8a9-8783-42b6-9e61-4dd59a93bf68'),
(2307,1103,NULL,1286,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'bdd2c1c5-a5a2-4ed0-8941-ac20afe35b46'),
(2308,1626,NULL,1287,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'eb5f4d12-a163-48cc-b7c2-7146a9a7107d'),
(2309,1627,NULL,1288,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'742faf6d-455f-4c82-8830-f0dae1821511'),
(2310,1109,NULL,1289,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'0df07b97-babd-453b-82cd-4e18f11ba143'),
(2311,1631,NULL,1290,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'bbcadf66-9f58-4fb9-aac3-42b2c570bfee'),
(2312,1632,NULL,1291,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'4ba61cc5-0260-4953-8a79-7033f7b5096d'),
(2313,1633,NULL,1292,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'1369a244-487c-4518-ba07-64248e20b85b'),
(2314,1117,NULL,1293,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'1b9fbc17-10fb-4369-a185-46b2afa727e9'),
(2315,1638,NULL,1294,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'80d863cd-9d73-420e-b1fc-a61edb711aff'),
(2316,1639,NULL,1295,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'50ffd002-fe77-4eda-a3d2-0cf1f7b07f6b'),
(2317,1123,NULL,1296,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'601f8f21-3091-456f-9185-aa916538225a'),
(2318,1643,NULL,1297,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'c3abce8a-7758-4bc9-b353-361646b8f575'),
(2319,1644,NULL,1298,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'1778485e-5250-4a01-83a1-4816289cda3e'),
(2320,1129,NULL,1299,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'ba6bd15e-93a1-4996-a040-0b1ea2c919d0'),
(2321,1648,NULL,1300,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'0c9c9c8b-5f65-446f-9afc-5ce22954bc23'),
(2322,1649,NULL,1301,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'75cb9044-877e-4d2e-9d67-9387824fd9ab'),
(2323,1135,NULL,1302,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'fa073e70-6bd1-41c1-936a-02054306890a'),
(2324,1653,NULL,1303,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'88b97d45-a1bb-403e-91e1-af71ec7ba5ed'),
(2325,1654,NULL,1304,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'e3b15f85-f876-4a6f-bbd4-9dd6da462126'),
(2326,1143,NULL,1305,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'69f60b46-c429-48f0-aa64-abdad6aaf818'),
(2327,1659,NULL,1306,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,'2025-10-13 18:02:09',NULL,'3ed02ca8-a643-400f-a241-8db19287039f'),
(2328,1660,NULL,1307,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'f312c3e7-8f70-4c6a-9efe-872191e5164c'),
(2329,1155,NULL,1308,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:33',NULL,NULL,NULL,'d287b69c-8250-4ee9-a834-d0ba58ca4fc5'),
(2330,1669,NULL,1309,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:33',NULL,'2025-10-13 19:24:55',NULL,'af969a0f-2e30-4bc2-8ad0-c0b6e8d55eb3'),
(2331,1670,NULL,1310,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:33',NULL,NULL,NULL,'229b21e1-f73f-4cec-9f87-1198ea7163ce'),
(2332,1161,NULL,1311,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'22a2031a-af48-4eed-9a66-29a2653663bc'),
(2333,1674,NULL,1312,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'02a66161-b187-4cd4-9646-0f72924d0ca9'),
(2334,1165,NULL,1313,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'447b1859-1dd1-4510-8ee5-9430c23fb45e'),
(2335,1677,NULL,1314,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'62c9baf2-0e7a-4f34-8388-c8ecd479244f'),
(2336,1678,NULL,1315,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'daace896-c1d2-4f14-82e8-6d240e620a92'),
(2337,1171,NULL,1316,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'24f44ae8-34bd-46e5-aa09-0914caa600b2'),
(2338,1682,NULL,1317,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,'2026-01-05 17:12:30',NULL,'77d5caee-4f33-4be3-aaeb-4fd3fd3aa5c4'),
(2339,1683,NULL,1318,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'615ad73f-b89b-4ba4-a254-640a8a5d3d4c'),
(2340,1177,NULL,1319,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'f80cf382-c0ae-4d76-9d33-22cbe487fc6c'),
(2341,1692,NULL,1320,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'302bb6f1-d9bb-4cc3-bd55-43b46052e0e6'),
(2342,1693,NULL,1321,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'0583ff14-67b8-4711-9744-179778f29ace'),
(2343,1185,NULL,1322,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'d99e2d79-896b-46b8-ad33-2e3d92ac5b92'),
(2344,1694,NULL,1323,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'2de33317-f01f-4f76-946d-22dd32906035'),
(2345,1695,NULL,1324,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'20f6e708-e817-46f5-bb1c-d44613d1bea0'),
(2346,1191,NULL,1325,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'999e5bad-ced0-4cbd-9bb5-359ef3340337'),
(2347,1699,NULL,1326,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'b49521a0-f8ba-4dac-a492-ac2ab2e92e3c'),
(2348,1700,NULL,1327,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'90c34b75-3716-4000-af7c-7e24226d62bb'),
(2349,1197,NULL,1328,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'735f8e22-9d2a-48ef-b8c7-ab7e5572583d'),
(2350,1704,NULL,1329,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'000c10f4-d2c2-4071-bec1-e93a0d65c883'),
(2351,1201,NULL,1330,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'878faeb0-b61e-48e1-8c7b-2db2cc43389f'),
(2352,1707,NULL,1331,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'0f8c41f5-b2d5-4d69-ba23-592a5103aec3'),
(2353,1708,NULL,1332,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'acaa840d-86fa-442e-8e53-bf0e4beebdfd'),
(2354,1709,NULL,1333,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'cd432b78-fafc-468f-be95-a5a0967fbc7d'),
(2355,1209,NULL,1334,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'295c970e-33c8-4134-aa84-d1775bcef760'),
(2356,1714,NULL,1335,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'dd652f5c-bb0d-4383-b6a6-0250fe5553df'),
(2357,1715,NULL,1336,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'853ee76f-fb61-4858-a0b8-aca65f2f8ad0'),
(2358,1215,NULL,1337,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'4da48e8a-75ac-4a32-8211-a3e3a6c75f69'),
(2359,1719,NULL,1338,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'1adc891b-aee2-436d-95d5-a83bdd712103'),
(2360,1219,NULL,1339,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'3d9248ae-121a-4422-b4c9-54237e914052'),
(2361,1722,NULL,1340,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,'2025-10-14 17:09:21',NULL,'24822f30-3c64-4717-8006-c4e04100388a'),
(2362,1723,NULL,1341,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'c29db490-a81c-48b0-b8c3-9c840d4a9c72'),
(2363,1225,NULL,1342,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'73f673e9-a465-4b9d-89bb-caefe009bcfb'),
(2364,1727,NULL,1343,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'244ba4b5-84a2-4acc-a96b-82f8c5d71f99'),
(2365,1728,NULL,1344,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'d6e5c3cc-5eb9-436e-8b0c-6f6ce78b9d05'),
(2366,1231,NULL,1345,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'bdd115bb-c739-443f-a8a2-8dac106fa02d'),
(2367,1732,NULL,1346,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'19cfc3ae-9f47-439c-85dc-456085e59bde'),
(2368,1733,NULL,1347,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,'2025-10-14 17:15:30',NULL,'bd3e4ff3-c52b-4094-9616-0b7226bcf167'),
(2369,1237,NULL,1348,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'301e703b-180e-4835-9592-3a5fa7600feb'),
(2370,1737,NULL,1349,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'47f446bc-7243-4938-8778-6ccdae77c8e0'),
(2371,1738,NULL,1350,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'78a76273-243a-4741-ba3f-f480a40b707f'),
(2372,1243,NULL,1351,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'f6b602c3-394b-4cb1-b6b9-13d0ffc01b70'),
(2373,1742,NULL,1352,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'e0cb9382-0256-489b-b489-06cc430acd98'),
(2374,1743,NULL,1353,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'362fd34e-62a4-482a-85e9-f68906489122'),
(2375,1249,NULL,1354,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'60b1bd86-14f2-4bdd-8073-65575453f82d'),
(2376,1747,NULL,1355,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'fe0f430b-b348-4cf0-887f-143cb7151774'),
(2377,1748,NULL,1356,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'d09312ba-d309-4a58-8ec6-87a973026dcd'),
(2378,1255,NULL,1357,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'f33f77f9-fea5-4ad0-a6e8-9cb5a7868f5a'),
(2379,1752,NULL,1358,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'bc67b775-0e01-4baa-80e4-09d14ade2540'),
(2380,1753,NULL,1359,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'6851c682-011c-4aac-82cb-f7d64dd36881'),
(2381,1261,NULL,1360,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'4fe257b0-e184-41bf-9790-9eb1e990f1aa'),
(2382,1757,NULL,1361,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'3bf93cf3-aab0-4cd6-a0d2-38e962e79b2b'),
(2383,1758,NULL,1362,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,'2025-11-04 20:58:46',NULL,'320dd30b-4b1b-44d1-9551-0c5432eafb7f'),
(2384,1759,NULL,1363,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'42945697-1ae2-4285-a5d4-6f63dd66aa27'),
(2385,1269,NULL,1364,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:35',NULL,NULL,NULL,'71f985e0-ac5e-4096-8c4c-cd84d329274e'),
(2386,1764,NULL,1365,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:35',NULL,NULL,NULL,'4afd8dc9-cc58-490c-be34-7947478a9537'),
(2387,1765,NULL,1366,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:35',NULL,NULL,NULL,'90f445c8-f90a-4f78-9dae-c70091a3590f'),
(2388,1766,NULL,1367,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:35',NULL,NULL,NULL,'a0f3ec1a-5eda-4702-92d1-2f30a1988bfc'),
(2389,1277,NULL,1368,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'f29c23f3-def9-4e63-acb5-40182c356a95'),
(2390,1771,NULL,1369,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'49ddf47e-12f4-4da3-b8c6-9d64ad45483e'),
(2391,1772,NULL,1370,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'840bbd83-fdf2-4a10-bfef-562e15ad93c0'),
(2392,1283,NULL,1371,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'e8ffcc5c-0dfe-44e6-810d-5858c9b4ee34'),
(2393,1776,NULL,1372,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'2d5ac8b2-ef1d-49d5-a7bc-d1a520ba2955'),
(2394,1777,NULL,1373,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,'2026-01-17 00:25:00',NULL,'ea2d3ccc-e764-49b9-ac13-889e64227fbd'),
(2395,1289,NULL,1374,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'158f173e-9874-4200-8e2f-6120f706e8cc'),
(2396,1781,NULL,1375,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'1eb22d46-fc96-4bf6-90f2-d06e7bfe3803'),
(2397,1782,NULL,1376,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'89131c6c-7c9b-4e50-8fcd-694af4fcdfd5'),
(2398,1783,NULL,1377,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'5ca644a2-0b4e-4884-a7ca-85bab193d717'),
(2399,1297,NULL,1378,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'6ca8d549-c107-448b-b8f9-b0a2c86d79e6'),
(2400,1788,NULL,1379,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'b1bb2727-65f3-4b81-a3e4-f7df5c372159'),
(2401,1789,NULL,1380,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'35aa0712-f0da-4c82-a6f4-560eb1b3ff1e'),
(2402,1303,NULL,1381,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'db172afb-d9b3-406d-9dd6-0a049936d879'),
(2403,1793,NULL,1382,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'0ab79989-1460-4b4c-a966-cf1c33ae7521'),
(2404,1794,NULL,1383,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'5a6ba16b-cb14-45cf-bd8c-4a8bd409b61f'),
(2405,1309,NULL,1384,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'bb0429e3-3120-479c-8449-36e0494035ce'),
(2406,1798,NULL,1385,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,'2025-11-17 16:22:37',NULL,'307d5258-7f51-4824-a0b4-94ee9f610479'),
(2407,1799,NULL,1386,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'3bdef452-1787-4e86-a8e0-cfeb2eaa1377'),
(2408,1315,NULL,1387,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'39b8dbdb-4257-4a09-a9c6-4170aa7bc502'),
(2409,1803,NULL,1388,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'bebddb5c-63e4-401a-a3df-112ce48082fe'),
(2410,1804,NULL,1389,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'06123830-b9af-486a-b680-902c60f61746'),
(2411,1805,NULL,1390,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'236c0610-a142-45c5-8e3d-5dd35b0339ac'),
(2412,1323,NULL,1391,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'2f4efa94-8b11-460f-a936-1f90fb340eda'),
(2413,1810,NULL,1392,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'c4aebf86-a5df-4964-a9e3-7a38ca2faa33'),
(2414,1811,NULL,1393,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'99833e80-f9cd-47f6-9655-a5757b3618da'),
(2415,1329,NULL,1394,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:36',NULL,NULL,NULL,'914212f0-1dc6-4e77-a408-e8f6615d7469'),
(2416,1815,NULL,1395,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:36',NULL,NULL,NULL,'f5c7fb9b-1756-41f8-acb0-33eb138c2b7c'),
(2417,1816,NULL,1396,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'bd78096f-5f01-4fc1-a962-14c6e6c4f62f'),
(2418,1817,NULL,1397,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,'2025-11-17 16:52:25',NULL,'c8cbecdb-b3b4-4754-bcef-37df56fdf273'),
(2419,1337,NULL,1398,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'4dd4c136-5d42-4f74-8cf7-5aa04c35a4c9'),
(2420,1822,NULL,1399,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,'2025-11-05 19:19:37',NULL,'30af53b8-1d0f-49d4-a48c-664e46c580ab'),
(2421,1823,NULL,1400,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'8d1b1d6d-c4f5-46e0-b51f-779484f742c0'),
(2422,1343,NULL,1401,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'19b1b671-03e5-4c03-aa81-43c82c7b25a4'),
(2423,1827,NULL,1402,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'d8e033bd-666f-45c6-a719-60aec288e902'),
(2424,1828,NULL,1403,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'62b2db04-602b-4930-b2ef-c098a79f84bc'),
(2425,1349,NULL,1404,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'d66b4656-f7f7-469a-b9c1-e3c51d2b0b7d'),
(2426,1832,NULL,1405,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'4a04f375-aa30-4a31-8fc8-6c62cdd843df'),
(2427,1353,NULL,1406,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'689bd08a-0ab6-4f19-b353-c15990d0aa36'),
(2428,1835,NULL,1407,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'82e8162c-e2f4-4b58-aa51-e982e351f6bf'),
(2429,1836,NULL,1408,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'343d4adc-f8f0-4d7f-85db-ab38824a577f'),
(2430,1359,NULL,1409,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'0412a0a4-d5f3-4dfd-915e-6349ef1f3dde'),
(2431,1840,NULL,1410,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'da049ea8-74df-486e-a7c2-44fc22a24cfd'),
(2432,1841,NULL,1411,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'35eaa790-5a17-410b-a030-8377d40d951a'),
(2433,1365,NULL,1412,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'2c13f3db-0d8c-40b4-b97a-ed4b02877eb8'),
(2434,1845,NULL,1413,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'2b292a19-ce1a-45ca-b797-8b8352b0c03f'),
(2435,1846,NULL,1414,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'7dcc9947-c567-48fc-8f28-452082e360de'),
(2436,1371,NULL,1415,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'4bc9d9ba-31bf-48ce-b091-e1b2e37809e6'),
(2437,1850,NULL,1416,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'ba212c3f-a596-412b-8010-896c8635c7a3'),
(2438,1851,NULL,1417,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'625668bb-b59f-4385-b729-be0c8df447d9'),
(2439,1377,NULL,1418,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'94fff098-79fd-42e7-8043-959f261b5337'),
(2440,1855,NULL,1419,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'78fc354f-286f-4409-83fe-9d7e0ab48ee6'),
(2441,1856,NULL,1420,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'219de754-7949-4025-8356-cc77f7cee520'),
(2442,1383,NULL,1421,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'9785984c-dd86-450b-b529-e8087a3d74c6'),
(2443,1860,NULL,1422,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'a840cbe7-f639-4a9f-b1be-2c02cb2cccb3'),
(2444,1861,NULL,1423,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'19f58fd6-32c7-4770-b0cd-a3adf01002c3'),
(2445,1389,NULL,1424,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'fcdc2dce-6995-41ba-8e8f-b748e4df7a14'),
(2446,1865,NULL,1425,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'160e3d0a-1e12-4513-b797-e71c56cb5873'),
(2447,1866,NULL,1426,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'cbcc8965-9ff1-42d6-871c-df8f126844f0'),
(2448,1395,NULL,1427,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'ee63e3c3-657f-42cd-82a4-159eb5173afb'),
(2449,1870,NULL,1428,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'ac44157f-7d13-4dbf-8810-8d8191d068fd'),
(2450,1871,NULL,1429,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'8a096c6a-f26a-42ed-84c9-cb66dd2aded9'),
(2451,1401,NULL,1430,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'26a9b7cb-2bb6-4bb1-b3b0-ddce5f1db05d'),
(2452,1875,NULL,1431,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'344f3dcc-df4f-4862-8dc7-788bf7cca35d'),
(2453,1876,NULL,1432,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'6460116b-b922-4014-b99f-b0399674b736'),
(2454,1407,NULL,1433,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'4e5015bf-2cf4-49a5-82c4-6b4017b3a9ba'),
(2455,1880,NULL,1434,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'6f5fa7ae-78a6-46e9-a606-70bb2b28b856'),
(2456,1881,NULL,1435,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'a328c246-05bb-46cc-a94b-7fb52151ad08'),
(2457,1413,NULL,1436,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'e119a524-5b34-4c28-a95e-f3b48918737e'),
(2458,1885,NULL,1437,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'c78d3645-9668-4cb6-8143-ed476ca7c6eb'),
(2459,1886,NULL,1438,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'601ca390-6a8d-45c4-aa43-d18cc3960f87'),
(2460,1419,NULL,1439,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'13d8e805-1633-4a70-aaa4-a79dd5540a83'),
(2461,1890,NULL,1440,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'45a8ad70-0044-41e2-9169-f8e49485961d'),
(2462,1891,NULL,1441,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'ff1ac66d-c92e-4350-b7c7-b5ff6f6d718b'),
(2463,1425,NULL,1442,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'5d25cbb7-1ce2-4f47-a70d-bb9bb77f76f7'),
(2464,1895,NULL,1443,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'6a5c2cf4-c64c-4983-aea0-39f3c0c71e25'),
(2465,1896,NULL,1444,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'9c83df00-0358-438f-a7ae-c1ced938097e'),
(2466,1431,NULL,1445,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'6612c1de-535b-4fcd-97fd-95e01c14ab39'),
(2467,1900,NULL,1446,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'494aab11-2cd1-4443-beca-41df55b19858'),
(2468,1901,NULL,1447,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'619ba96f-c0c1-4680-ad8a-30cdd7878df7'),
(2469,1437,NULL,1448,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'0612b687-bc28-42e6-bd01-98552b99bf4a'),
(2470,1905,NULL,1449,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'caed6cba-1baa-4348-8f24-da474e051ffe'),
(2471,1906,NULL,1450,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'0340d5c2-3598-4571-b476-e46e7c5426fb'),
(2472,1443,NULL,1451,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:38',NULL,NULL,NULL,'3412bce4-5016-4097-8ca3-4e2df3d26db3'),
(2473,1910,NULL,1452,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:38',NULL,'2025-11-17 15:57:50',NULL,'3d3d9ed5-dd22-4069-8bde-d8e7d6ed79a0'),
(2474,1911,NULL,1453,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:38',NULL,NULL,NULL,'9614a6a2-90fc-42eb-8d0e-dfec76b8c68d'),
(2475,1449,NULL,1454,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'38aba39a-0322-4825-8439-e1173b1c251f'),
(2476,1915,NULL,1455,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,'2025-11-17 16:19:28',NULL,'3dd2a0bd-1b32-4c57-ad79-a564fb6e89f3'),
(2477,1916,NULL,1456,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'41948a97-c816-4437-bd78-daadd75fd33c'),
(2478,1455,NULL,1457,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'db7c4b65-ae52-41cd-9314-33f537c1f5bc'),
(2479,1920,NULL,1458,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'fcaecb61-cd2c-401b-956f-e9bc1238011a'),
(2480,1921,NULL,1459,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'88788456-bbb6-4513-8104-b076a6f86f51'),
(2481,1461,NULL,1460,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'b40150b0-3477-4388-8a3f-d90d99a8b929'),
(2482,1925,NULL,1461,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,'2025-11-17 16:36:55',NULL,'28cf4f1e-8941-417a-99e4-e5d448cb45b6'),
(2483,1926,NULL,1462,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'a74f0cfb-8234-4629-8684-aab1486dd1e4'),
(2484,1467,NULL,1463,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'b725cd86-2fff-4ea7-9b4b-6989100dc9e5'),
(2485,1930,NULL,1464,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'fbe32637-1457-4339-81f6-9011c1d42f2e'),
(2486,1931,NULL,1465,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'751e7a36-baf0-4343-9ee1-01e0c9a00fe7'),
(2487,1473,NULL,1466,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'15132208-ac5b-4d2d-921d-b49d10b9dbc5'),
(2488,1935,NULL,1467,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'89101061-0b59-4b87-8829-9dfccaa42ed9'),
(2489,1477,NULL,1468,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'4565583a-cd7e-42a2-bb8b-1eb48dd44483'),
(2490,1938,NULL,1469,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'ef99128a-288d-4762-a0bd-3ef128729c43'),
(2491,1481,NULL,1470,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'c3f3281f-4cca-4c3b-8c45-50bc9d1d259e'),
(2492,1941,NULL,1471,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'0697548d-424c-426b-884f-84436b0ef39c'),
(2495,1255,NULL,1473,1,'craft\\elements\\Entry',1,0,'2025-09-16 22:43:05','2025-09-16 22:43:05',NULL,NULL,NULL,'ebf28e94-b65d-4006-803c-d194c2e2802d'),
(2501,1487,NULL,1476,2,'craft\\elements\\Entry',1,0,'2025-09-17 19:37:16','2026-01-19 20:59:10',NULL,NULL,NULL,'a94ed8ae-0e30-4160-b54e-a86536244182'),
(2516,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-19 16:58:14','2025-09-19 16:58:14',NULL,NULL,NULL,'a88dc780-1702-4136-8c14-39c1b8af932e'),
(2518,605,NULL,1477,5,'craft\\elements\\Entry',1,0,'2025-09-19 16:58:18','2025-09-19 16:58:18',NULL,NULL,NULL,'c4ac66da-0efc-4159-9b88-86cb23f6d62a'),
(2519,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:25:28','2025-09-24 19:41:47',NULL,NULL,NULL,'798407a8-dc42-4891-824a-5b688cae9b01'),
(2520,2519,NULL,1478,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:27:09','2025-09-19 17:27:09',NULL,NULL,NULL,'fa3f1a9f-6f97-42f5-99a3-205b578e474b'),
(2522,2519,NULL,1479,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:27:31','2025-09-19 17:27:31',NULL,NULL,NULL,'e5505781-4c57-4615-8b16-d5ef7ba052ec'),
(2523,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:28:47','2025-09-24 17:20:23',NULL,NULL,NULL,'2e9f1bdb-a41c-42cc-8dde-7aa89ffddd2f'),
(2524,2523,NULL,1480,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:29:12','2025-09-19 17:29:12',NULL,NULL,NULL,'9f84aee8-686d-471e-8b34-83d6caf38ded'),
(2526,2523,NULL,1481,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:29:35','2025-09-19 17:29:35',NULL,NULL,NULL,'8f6a715d-fff5-4e6c-8926-4cdf0ec3db0d'),
(2527,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:30:10','2025-09-24 17:20:14',NULL,NULL,NULL,'fc7c950a-4533-492a-a7a7-e2afea558b45'),
(2528,2527,NULL,1482,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:31:21','2025-09-19 17:31:21',NULL,NULL,NULL,'14ceef1a-cf0a-4f95-92a4-1f227f35893c'),
(2530,2527,NULL,1483,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:31:59','2025-09-19 17:31:59',NULL,NULL,NULL,'8ad99ee4-b840-43d9-a671-379c3e9e99fb'),
(2531,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:32:19','2025-09-30 19:28:07',NULL,NULL,NULL,'f679d85c-04bf-4fdf-aa69-2619259a729e'),
(2532,2531,NULL,1484,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:33:26','2025-09-19 17:33:26',NULL,NULL,NULL,'ec10f6fb-97fa-43dc-a55a-499e37faaa0e'),
(2534,2531,NULL,1485,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:34:50','2025-09-19 17:34:50',NULL,NULL,NULL,'9e3e9ed4-21f7-4059-9a2c-e745e294f9d6'),
(2535,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:34:52','2025-09-24 17:19:43',NULL,NULL,NULL,'a7be63ba-1aef-4be2-bbdf-387693347e0c'),
(2536,2535,NULL,1486,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:35:50','2025-09-19 17:35:50',NULL,NULL,NULL,'50604867-8e85-40ba-987a-deb315a8b043'),
(2537,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:37:12','2025-09-24 17:19:53',NULL,NULL,NULL,'56881ee1-2b77-454e-b507-84c6eeef5674'),
(2538,2537,NULL,1487,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:38:19','2025-09-19 17:38:19',NULL,NULL,NULL,'4ca31b6d-0a38-4b5f-b1b4-45ff2cc21e8b'),
(2540,2535,NULL,1488,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:38:52','2025-09-19 17:38:52',NULL,NULL,NULL,'85586ca8-0eb5-4f04-a1ce-3a1396134b8f'),
(2542,2537,NULL,1489,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:18','2025-09-19 17:40:18',NULL,NULL,NULL,'493901ce-3b81-4599-b50a-4ca08a357afa'),
(2544,2535,NULL,1490,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:24','2025-09-19 17:40:24',NULL,NULL,NULL,'16370887-6b06-44bd-8209-3f7d03301751'),
(2546,2531,NULL,1491,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:31','2025-09-19 17:40:31',NULL,NULL,NULL,'cc536b73-77ec-426a-ae5d-ff768d2f5e4e'),
(2548,2527,NULL,1492,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:36','2025-09-19 17:40:36',NULL,NULL,NULL,'ddcf4584-17c9-4aeb-884f-8cbcc989ffd1'),
(2550,2523,NULL,1493,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:43','2025-09-19 17:40:43',NULL,NULL,NULL,'589cd3dd-fa2a-43a5-a2ac-a51ad123960a'),
(2552,2519,NULL,1494,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:50','2025-09-19 17:40:50',NULL,NULL,NULL,'a606d8ab-1fdf-4776-9e86-df6900369c8f'),
(2553,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:07','2025-09-19 18:50:13',NULL,NULL,NULL,'1f82e73c-c692-4568-b585-ae99eb7d380b'),
(2554,2553,NULL,1495,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:13','2025-09-19 18:50:13',NULL,NULL,NULL,'447453c2-b29f-478c-946d-abd97da673ff'),
(2555,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:13','2025-09-19 18:50:15',NULL,NULL,NULL,'b329aaf6-6f21-444a-b552-c1d9a05f909f'),
(2556,2555,NULL,1496,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:15','2025-09-19 18:50:15',NULL,NULL,NULL,'6b12fb58-47ab-496a-a6ef-81c893b554d6'),
(2557,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:15','2025-09-19 18:50:18',NULL,NULL,NULL,'d89963c6-a945-4912-b645-59a7dbe99761'),
(2558,2557,NULL,1497,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:18','2025-09-19 18:50:18',NULL,NULL,NULL,'ea0ccd3e-caa3-4ba3-b016-4af7d0df34c4'),
(2559,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:18','2025-09-19 18:50:27',NULL,NULL,NULL,'92068cd8-0a8e-4188-93e4-d0adbb22dc1e'),
(2560,2559,NULL,1498,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:27','2025-09-19 18:50:27',NULL,NULL,NULL,'34e48f02-d6e9-488f-86e0-0cffb3195a70'),
(2561,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:37','2025-09-19 18:50:45',NULL,NULL,NULL,'a231e115-688d-4f00-b246-4c3505b058dc'),
(2562,2561,NULL,1499,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:45','2025-09-19 18:50:45',NULL,NULL,NULL,'935997ba-edcf-4fd2-89ac-fbc4b386f843'),
(2563,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:45','2025-09-19 18:50:48',NULL,NULL,NULL,'a9ae196c-4c39-41b5-a34b-03614b7a607a'),
(2564,2563,NULL,1500,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:48','2025-09-19 18:50:48',NULL,NULL,NULL,'cde9bda8-b387-4efd-92c1-35b8fafb67cf'),
(2565,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:48','2025-09-19 18:50:50',NULL,NULL,NULL,'ee7ae933-c2c6-4a6a-8f16-96b6f1b9b6bd'),
(2566,2565,NULL,1501,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:50','2025-09-19 18:50:50',NULL,NULL,NULL,'d087424b-77d9-433a-b247-1ee011a5834c'),
(2567,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:50','2025-09-19 18:50:52',NULL,NULL,NULL,'be85fe8b-f433-47f1-95d4-351af20a2806'),
(2568,2567,NULL,1502,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:52','2025-09-19 18:50:52',NULL,NULL,NULL,'0b23eb9f-9b41-4259-a1ea-c97d2c437346'),
(2569,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:52','2025-09-19 18:50:55',NULL,NULL,NULL,'4dd3b51c-ef51-4e69-a1ae-51b556192a86'),
(2570,2569,NULL,1503,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:55','2025-09-19 18:50:55',NULL,NULL,NULL,'9aa038d4-3589-415e-9fce-ff6f17a1a4e4'),
(2571,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:55','2025-09-19 18:50:59',NULL,NULL,NULL,'b608439b-ca0f-4766-b3e2-94df92a69e2e'),
(2572,2571,NULL,1504,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:59','2025-09-19 18:50:59',NULL,NULL,NULL,'d42f5795-c8d7-43b8-9c6e-50db5eb4422a'),
(2573,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:59','2025-09-19 18:51:06',NULL,NULL,NULL,'d41283ba-951c-4073-81d9-a12cab8c4ca2'),
(2574,2573,NULL,1505,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:03','2025-09-19 18:51:03',NULL,NULL,NULL,'e650f765-b5b2-4adb-b603-6ffea7fe1eab'),
(2575,2573,NULL,1506,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:06','2025-09-19 18:51:06',NULL,NULL,NULL,'64a59e0d-63dd-4e47-9235-f311e24c2822'),
(2576,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:06','2025-09-19 18:51:09',NULL,NULL,NULL,'328cf59f-6de8-42e8-a1b4-0e8ca15a9118'),
(2577,2576,NULL,1507,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:09','2025-09-19 18:51:09',NULL,NULL,NULL,'efe25b57-54ec-4dda-86e7-f8e3db89d470'),
(2579,2537,NULL,1508,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:30','2025-09-19 18:51:30',NULL,NULL,NULL,'d1828e30-43ad-41ad-a279-bf18508cc953'),
(2581,2535,NULL,1509,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:46','2025-09-19 18:51:46',NULL,NULL,NULL,'2b22d8d4-2fa6-4aac-98be-d594893b5212'),
(2583,2531,NULL,1510,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:56','2025-09-19 18:51:56',NULL,NULL,NULL,'d4ea6741-e126-47b2-9b94-4261ad889e7a'),
(2585,2527,NULL,1511,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:52:10','2025-09-19 18:52:10',NULL,NULL,NULL,'533472d2-9f5b-422f-8881-c8fc9d1cec24'),
(2587,2523,NULL,1512,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:52:18','2025-09-19 18:52:18',NULL,NULL,NULL,'c2990695-289a-4a5b-82ff-a483f97bf743'),
(2589,2519,NULL,1513,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:52:27','2025-09-19 18:52:27',NULL,NULL,NULL,'f0260a8f-8d2d-4af1-9771-887da16e8f84'),
(2590,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:52:38','2025-09-19 19:15:03',NULL,NULL,NULL,'6cae16a6-f883-4139-a765-c67347143182'),
(2591,2590,NULL,1514,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:53:29','2025-09-19 18:53:29',NULL,NULL,NULL,'530fb6e6-1e63-401c-8814-5f6576b81df6'),
(2592,2537,NULL,1515,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:53:35','2025-09-19 18:53:35',NULL,NULL,NULL,'6f41855b-e4c1-4d65-90bf-3edb7c561ac0'),
(2594,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-19 18:57:57','2025-09-19 18:57:57',NULL,NULL,NULL,'42d65d55-306b-417d-8600-0bb8ec837d7a'),
(2595,2590,NULL,1516,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:57:59','2025-09-19 18:57:59',NULL,NULL,NULL,'b0b62e6c-322d-4cd0-bf67-e701786ccddc'),
(2596,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:05:39','2025-09-19 19:06:52',NULL,NULL,NULL,'ed5b5724-8a1c-4424-a8aa-bcc5e5591568'),
(2597,2596,NULL,1517,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:06:52','2025-09-19 19:06:52',NULL,NULL,NULL,'cf4c9543-4654-44b2-bc1a-0eec18aa2fdf'),
(2598,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:06:52','2025-09-19 19:06:57',NULL,NULL,NULL,'2b425daa-3c83-4d5f-855e-9aaadf81a9e3'),
(2599,2598,NULL,1518,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:06:57','2025-09-19 19:06:57',NULL,NULL,NULL,'0a37fe07-9f4b-4616-bd4d-d342ccbdab00'),
(2600,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:06:57','2025-09-19 19:07:03',NULL,NULL,NULL,'03b51710-5c79-4483-afe4-bda55784e2f3'),
(2601,2600,NULL,1519,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:03','2025-09-19 19:07:03',NULL,NULL,NULL,'57723b37-e14c-4bbe-bac4-0df0f4508f5b'),
(2602,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:03','2025-09-19 19:07:09',NULL,NULL,NULL,'bd40e808-1b5a-4674-8f1f-79ce381e440c'),
(2603,2602,NULL,1520,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:09','2025-09-19 19:07:09',NULL,NULL,NULL,'31cd7061-ac55-4c56-9548-7d2f30484574'),
(2604,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:09','2025-09-19 19:07:13',NULL,NULL,NULL,'c1580479-2261-4e66-a3b0-771bbd6898b3'),
(2605,2604,NULL,1521,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:13','2025-09-19 19:07:13',NULL,NULL,NULL,'c43cf147-5984-4462-bce8-231f550507c2'),
(2606,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:13','2025-09-19 19:07:17',NULL,NULL,NULL,'a54c9d4f-1de7-4f3f-a0d9-1bc5ef6c3b82'),
(2607,2606,NULL,1522,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:17','2025-09-19 19:07:17',NULL,NULL,NULL,'705217ff-3a28-400c-a46f-3446855a2538'),
(2608,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:17','2025-09-19 19:07:23',NULL,NULL,NULL,'f9a5647d-ff01-4f49-a021-5fc8e32ddc73'),
(2609,2608,NULL,1523,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:23','2025-09-19 19:07:23',NULL,NULL,NULL,'366283e4-5e9a-43e9-bc56-54b1250d0c21'),
(2610,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:23','2025-09-19 19:07:27',NULL,NULL,NULL,'775903a5-eb1a-492f-a3a4-59a280676468'),
(2611,2610,NULL,1524,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:27','2025-09-19 19:07:27',NULL,NULL,NULL,'9690e450-9ea6-48b5-a4ef-5e0f65ce5dc1'),
(2612,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:27','2025-09-19 19:07:36',NULL,NULL,NULL,'cf692f93-e1c4-4161-ac36-11ae0932ee6d'),
(2613,2612,NULL,1525,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:36','2025-09-19 19:07:36',NULL,NULL,NULL,'9d55947e-e594-40a3-a249-5c5c28525fde'),
(2614,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:36','2025-09-19 19:07:44',NULL,NULL,NULL,'cb61d67e-83c4-4abc-bf6e-080ed8a8a973'),
(2615,2614,NULL,1526,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:44','2025-09-19 19:07:44',NULL,NULL,NULL,'9abe030a-b0f1-49da-b606-49d5c64d67c6'),
(2618,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:47','2025-09-19 19:07:49',NULL,NULL,NULL,'b5e0de7b-b9c8-48f0-91c6-484d8caa02ca'),
(2619,2618,NULL,1528,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:49','2025-09-19 19:07:49',NULL,NULL,NULL,'13d5c252-c187-4d28-a171-c29ca8de64cd'),
(2622,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:53','2025-09-24 16:01:26',NULL,NULL,NULL,'0a1cb6bd-d0cc-4b56-94d6-4573d769d02c'),
(2623,2622,NULL,1530,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:55','2025-09-19 19:07:55',NULL,NULL,NULL,'ccb4c11c-644a-45d9-a660-734ba66b717a'),
(2624,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:55','2025-09-19 19:07:59',NULL,NULL,NULL,'501cb39a-b029-4e58-b73e-2c796bd1926c'),
(2625,2624,NULL,1531,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:59','2025-09-19 19:07:59',NULL,NULL,NULL,'5a043e60-e89d-457d-ad36-2d7d38519ce8'),
(2627,945,NULL,1533,1,'craft\\elements\\Entry',1,0,'2025-09-19 19:10:40','2025-09-19 19:10:40',NULL,NULL,NULL,'eaf36663-e691-4c12-a7c4-9e5e33ad4f2b'),
(2628,1255,NULL,1534,1,'craft\\elements\\Entry',1,0,'2025-09-19 19:10:44','2025-09-19 19:10:44',NULL,NULL,NULL,'af395f92-4d90-4e6e-828c-13b2c1e28c08'),
(2629,1165,NULL,1535,1,'craft\\elements\\Entry',1,0,'2025-09-19 19:10:48','2025-09-19 19:10:48',NULL,NULL,NULL,'e1a41b0a-395c-461c-98d7-ffda5bf0a805'),
(2631,2590,NULL,1536,12,'craft\\elements\\Entry',1,0,'2025-09-19 19:15:03','2025-09-19 19:15:03',NULL,NULL,NULL,'3b597831-2740-4f3d-9196-0d831107edfb'),
(2633,497,NULL,1537,6,'craft\\elements\\Entry',1,0,'2025-09-19 19:22:04','2025-09-19 19:22:04',NULL,NULL,NULL,'6272791a-de82-4b56-9175-163e15b04f6b'),
(2635,951,NULL,1538,1,'craft\\elements\\Entry',1,0,'2025-09-22 17:36:50','2025-09-22 17:36:50',NULL,NULL,NULL,'567baa8c-18ca-4f71-bf0c-49d45ab5d6e9'),
(2637,1353,NULL,1539,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:01:29','2025-09-22 18:01:29',NULL,NULL,NULL,'0cfd97a2-b25e-4990-8d49-4e4a73836e75'),
(2640,1359,NULL,1540,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:03:21','2025-09-22 18:03:22',NULL,NULL,NULL,'5d28cdde-151f-4f3c-866c-1ad41a17312c'),
(2641,1353,NULL,1541,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:03:40','2025-09-22 18:03:40',NULL,NULL,NULL,'9b6e0d49-0cd5-42cc-b5d3-49c6382ccb72'),
(2643,1365,NULL,1542,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:04:13','2025-09-22 18:04:13',NULL,NULL,NULL,'2f77c9ad-e35a-40f5-81ff-806c1f22da65'),
(2645,1371,NULL,1543,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:04:46','2025-09-22 18:04:46',NULL,NULL,NULL,'ec8a6866-7615-4634-a4ec-ffe1e7799e18'),
(2647,1353,NULL,1544,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:04:56','2025-09-22 18:04:56',NULL,NULL,NULL,'fa7fd048-7fe9-41c6-97e5-ae47bd39fadd'),
(2649,1359,NULL,1545,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:05:05','2025-09-22 18:05:05',NULL,NULL,NULL,'2d451d36-1ae8-48bd-bce5-4eae79f08bfc'),
(2651,1365,NULL,1546,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:05:37','2025-09-22 18:05:37',NULL,NULL,NULL,'c697e627-4e31-4d1a-880e-5b89c6307c8b'),
(2653,1377,NULL,1547,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:06:29','2025-09-22 18:06:29',NULL,NULL,NULL,'8ddfb5d1-1881-47b0-a5f8-6f766eb4e9c9'),
(2655,1383,NULL,1548,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:06:50','2025-09-22 18:06:50',NULL,NULL,NULL,'b6f34d50-21c8-4413-b4fa-cb591a437244'),
(2657,1389,NULL,1549,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:07:16','2025-09-22 18:07:16',NULL,NULL,NULL,'f5c5299c-8dfe-4fff-b2b2-214e915f50c0'),
(2659,1395,NULL,1550,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:08:00','2025-09-22 18:08:00',NULL,NULL,NULL,'d8d50f8a-5155-43f9-ad24-d17286bcab2c'),
(2661,1401,NULL,1551,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:08:33','2025-09-22 18:08:33',NULL,NULL,NULL,'af589c20-0be9-4a3e-9752-b34db1355b8d'),
(2663,1407,NULL,1552,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:08:56','2025-09-22 18:08:56',NULL,NULL,NULL,'c956fdad-0162-4993-b457-60ded1ef76f9'),
(2665,1413,NULL,1553,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:09:23','2025-09-22 18:09:23',NULL,NULL,NULL,'d60c7ef7-e87a-4f3c-b875-12d039894748'),
(2667,1413,NULL,1554,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:09:38','2025-09-22 18:09:38',NULL,NULL,NULL,'4452d2c3-b7e9-40b4-9b5d-f251e3d6fdc5'),
(2669,1413,NULL,1555,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:09:54','2025-09-22 18:09:54',NULL,NULL,NULL,'1988353a-0bb8-4430-b9a8-3cbffc4772fc'),
(2671,1359,NULL,1556,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:10:03','2025-09-22 18:10:03',NULL,NULL,NULL,'1e51a1e3-3b09-471d-86b5-8c3caa82a99a'),
(2673,1353,NULL,1557,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:10:11','2025-09-22 18:10:11',NULL,NULL,NULL,'7b3ecea1-cf13-4251-a491-14c4e29e37e8'),
(2675,1395,NULL,1558,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:10:30','2025-09-22 18:10:30',NULL,NULL,NULL,'f4e3d187-5f5b-4240-8d04-2f09cde373d0'),
(2678,1365,NULL,1559,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:10:48','2025-09-22 18:10:48',NULL,NULL,NULL,'31e57a87-8928-4f1b-8f68-ff5b8dafce53'),
(2680,1371,NULL,1560,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:11:25','2025-09-22 18:11:25',NULL,NULL,NULL,'02a82296-3dee-4128-9909-4b2cb74a82c6'),
(2682,1377,NULL,1561,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:11:35','2025-09-22 18:11:35',NULL,NULL,NULL,'044d3a09-7711-4916-9efb-81892f95fb05'),
(2684,1383,NULL,1562,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:11:49','2025-09-22 18:11:49',NULL,NULL,NULL,'8ed1ac02-aefa-4daf-9d24-698ac17f4712'),
(2686,1389,NULL,1563,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:12:03','2025-09-22 18:12:03',NULL,NULL,NULL,'b437b1a6-ba58-4119-a194-8216f04fa596'),
(2689,1401,NULL,1564,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:12:28','2025-09-22 18:12:28',NULL,NULL,NULL,'e067c24c-2576-4600-abab-2c6703865199'),
(2691,1407,NULL,1565,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:13:02','2025-09-22 18:13:02',NULL,NULL,NULL,'d95c3554-d596-4337-95e6-f25c14ea837e'),
(2693,1413,NULL,1566,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:18:15','2025-09-22 18:18:15',NULL,NULL,NULL,'7d3c09d5-33bc-49b0-9b20-52ab558dd130'),
(2695,1353,NULL,1567,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:20:10','2025-09-22 18:20:10',NULL,NULL,NULL,'cf9416ca-910d-4782-b4f7-350e2f6a7685'),
(2697,1359,NULL,1568,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:20:32','2025-09-22 18:20:33',NULL,NULL,NULL,'75051435-a9e8-4561-91e8-46d34b6aca30'),
(2698,1365,NULL,1569,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:20:52','2025-09-22 18:20:52',NULL,NULL,NULL,'bbf8407d-bac1-47fb-b03a-5b057b9a32df'),
(2699,1395,NULL,1570,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:21:16','2025-09-22 18:21:16',NULL,NULL,NULL,'c058663d-1b8b-4b28-abbe-a485ead99e64'),
(2701,1371,NULL,1571,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:21:35','2025-09-22 18:21:35',NULL,NULL,NULL,'b0bb1e40-42aa-4e8c-a453-e9d77f1d9e0f'),
(2703,1377,NULL,1572,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:22:06','2025-09-22 18:22:06',NULL,NULL,NULL,'6fadb5fa-d81a-4f7d-8b92-c83d74107c67'),
(2705,1401,NULL,1573,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:22:29','2025-09-22 18:22:29',NULL,NULL,NULL,'ce543f07-040e-4d57-bcc5-8acd57217816'),
(2707,1383,NULL,1574,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:22:45','2025-09-22 18:22:45',NULL,NULL,NULL,'aebab139-b1aa-43a9-b06b-8c7cfabcb458'),
(2709,1389,NULL,1575,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:23:01','2025-09-22 18:23:02',NULL,NULL,NULL,'ef58f931-789e-483c-a450-8b7d4d1eb7ed'),
(2711,1407,NULL,1576,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:23:24','2025-09-22 18:23:24',NULL,NULL,NULL,'f96f2cd0-e318-46d3-a704-1a5f524db1b1'),
(2712,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:31:54','2026-01-20 15:12:43',NULL,NULL,NULL,'dd61e91a-428e-4c7e-92a2-b1678fb22a9f'),
(2713,2712,NULL,1577,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:33:07','2025-09-22 18:33:07',NULL,NULL,NULL,'f0e219c3-0b40-405e-b74f-3a6a4e87fcee'),
(2716,2712,NULL,1578,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:33:47','2025-09-22 18:33:47',NULL,NULL,NULL,'c725bc56-b88f-4150-b481-9efd1c0431e5'),
(2717,2,NULL,1579,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:33:52','2025-09-22 18:33:52',NULL,NULL,NULL,'2b7dd672-66e5-45ee-a14b-413bd45df09f'),
(2719,2712,NULL,1580,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:33:59','2025-09-22 18:33:59',NULL,NULL,NULL,'055e1545-833e-4929-b4dc-1d22a9d7787d'),
(2720,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:34:20','2026-01-18 22:20:06',NULL,NULL,NULL,'8edf8d99-3b37-4cf7-8604-05cdfd866b47'),
(2721,2720,NULL,1581,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:35:27','2025-09-22 18:35:27',NULL,NULL,NULL,'c1d0d498-a622-47b1-a8d7-7e0f0a6bf998'),
(2723,2720,NULL,1582,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:35:58','2025-09-22 18:35:58',NULL,NULL,NULL,'b90d043b-1cbf-4469-beb6-f9248e860704'),
(2725,2720,NULL,1583,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:36:12','2025-09-22 18:36:12',NULL,NULL,NULL,'0f75944b-28b9-4f57-a792-1cf7f9f23fe2'),
(2727,2720,NULL,1584,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:36:20','2025-09-22 18:36:20',NULL,NULL,NULL,'7d8cf309-af4b-4543-9dea-d4576cd6748a'),
(2729,2712,NULL,1585,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:36:55','2025-09-22 18:36:55',NULL,NULL,NULL,'1ef5bc5d-deb8-4f07-a030-6782faff4a0b'),
(2731,2,NULL,1586,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:42:24','2025-09-22 18:42:24',NULL,NULL,NULL,'00c6af15-ce7d-4849-a610-326c7c928efa'),
(2732,1059,NULL,1587,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:42:30','2025-09-22 18:42:30',NULL,NULL,NULL,'f99c1038-bb40-418b-9813-63a7025dfd6f'),
(2733,1283,NULL,1588,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:42:35','2025-09-22 18:42:35',NULL,NULL,NULL,'464e4b65-76d2-4d1a-8f39-81b5f6bdda47'),
(2736,2,NULL,1589,1,'craft\\elements\\Entry',1,0,'2025-09-22 19:42:28','2025-09-22 19:42:29',NULL,NULL,NULL,'8301ac1c-cbef-421f-bfde-7c3436caf2a4'),
(2742,601,NULL,1590,5,'craft\\elements\\Entry',1,0,'2025-09-22 20:40:59','2025-09-22 20:40:59',NULL,NULL,NULL,'90518e6f-0901-4395-be9a-cd14eda0165c'),
(2743,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'a520d29b-eced-425e-bf1a-f1a35646d600'),
(2744,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'7c1de11f-ebcf-4c6e-b2e8-1c5eb53efc68'),
(2745,2,NULL,1591,1,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'5ebcf8a0-f927-4075-97e3-43891e2ffeaa'),
(2746,2743,NULL,1592,3,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'50b13f66-01f6-4bee-8165-85f2e52ab10a'),
(2747,2744,NULL,1593,3,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'5c11c11b-6c2d-46c1-96c3-9442dcacdd1d'),
(2750,601,NULL,1594,5,'craft\\elements\\Entry',1,0,'2025-09-22 20:45:52','2025-09-22 20:45:52',NULL,NULL,NULL,'53ce4217-639b-419a-a73c-6443a3417118'),
(2751,459,NULL,1595,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:24:58','2025-09-23 20:24:58',NULL,NULL,NULL,'5a05c997-033a-4a62-ba13-559b802db7ef'),
(2753,459,NULL,1596,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:08','2025-09-23 20:25:08',NULL,NULL,NULL,'83e87564-d2a9-441d-94c8-ed6e5f2bf570'),
(2754,461,NULL,1597,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:25','2025-09-23 20:25:25',NULL,NULL,NULL,'e5f3ce22-f12e-4c27-bd18-8800f1f29444'),
(2756,457,NULL,1598,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:31','2025-09-23 20:25:31',NULL,NULL,NULL,'79000580-aa18-4ac5-960c-e1ec4bacd872'),
(2758,463,NULL,1599,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:37','2025-09-23 20:25:37',NULL,NULL,NULL,'18d046ca-46ee-4d51-9f67-2c42cdcaf067'),
(2760,465,NULL,1600,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:47','2025-09-23 20:25:47',NULL,NULL,NULL,'fda55c44-299e-4f1a-ae6d-fbbeec708d23'),
(2761,467,NULL,1601,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:55','2025-09-23 20:25:55',NULL,NULL,NULL,'20ab7767-16a4-4677-91c8-e5a8581b8e17'),
(2763,469,NULL,1602,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:04','2025-09-23 20:26:04',NULL,NULL,NULL,'27d68ba6-8788-4d0e-b5ca-40669ea528b7'),
(2764,471,NULL,1603,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:11','2025-09-23 20:26:11',NULL,NULL,NULL,'7272a6d5-a6bd-495f-a010-cee877695ac9'),
(2766,475,NULL,1604,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:19','2025-09-23 20:26:19',NULL,NULL,NULL,'774aa463-25fe-45e9-85e8-89b8f2eeb2dc'),
(2768,475,NULL,1605,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:26','2025-09-23 20:26:26',NULL,NULL,NULL,'e5b5440a-7cd9-4e0b-9320-3d413c6c873d'),
(2769,477,NULL,1606,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:34','2025-09-23 20:26:34',NULL,NULL,NULL,'9c3a45da-b569-44f2-8afe-f869cae19015'),
(2770,479,NULL,1607,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:42','2025-09-23 20:26:42',NULL,NULL,NULL,'1044a086-a589-4314-8063-db7230f407f8'),
(2772,481,NULL,1608,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:54','2025-09-23 20:26:54',NULL,NULL,NULL,'2e91cad0-71c1-4ae3-b7f4-249b6bbba78d'),
(2774,483,NULL,1609,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:27:03','2025-09-23 20:27:03',NULL,NULL,NULL,'89510032-755b-4553-9af0-79e69d2f2aba'),
(2775,485,NULL,1610,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:27:13','2025-09-23 20:27:13',NULL,NULL,NULL,'54c4f5d4-0aed-4ab5-a2eb-87fb9ff18ca7'),
(2776,497,NULL,1611,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:27:28','2025-09-23 20:27:28',NULL,NULL,NULL,'d2ffd692-e9c1-4969-8340-7a3bd760e48b'),
(2778,487,NULL,1612,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:02','2025-09-23 20:29:02',NULL,NULL,NULL,'bbcf8b4e-8275-4917-a71b-81fe04c749fa'),
(2780,489,NULL,1613,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:09','2025-09-23 20:29:09',NULL,NULL,NULL,'adc63a2c-f16a-4cd2-8937-f5e39b1b1d5e'),
(2781,491,NULL,1614,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:17','2025-09-23 20:29:17',NULL,NULL,NULL,'74537ed0-d9b5-4630-a5a0-13cd647368ae'),
(2782,493,NULL,1615,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:24','2025-09-23 20:29:24',NULL,NULL,NULL,'0046eebf-0773-4e96-abdb-7005b1844456'),
(2784,495,NULL,1616,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:38','2025-09-23 20:29:38',NULL,NULL,NULL,'94205c05-e2f4-414d-a0dd-443cbfdec53b'),
(2785,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:43:42','2025-09-30 22:22:13',NULL,NULL,NULL,'e13f4958-4796-464e-b66a-72e49c7d45cb'),
(2786,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:43:49','2025-09-30 22:22:24',NULL,NULL,NULL,'e6acfaec-6184-424c-8a4f-fbe541f2fe91'),
(2787,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:43:54','2025-09-30 22:22:37',NULL,NULL,NULL,'46ebec47-7046-4634-af10-57e83a4bd1aa'),
(2791,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-30 22:41:39',NULL,NULL,NULL,'75a41dd2-8fe4-4d4a-9c95-66b0698211a3'),
(2792,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-30 22:45:18',NULL,'2025-09-30 22:45:18',NULL,'de2fd3c6-8fe9-4b33-924e-4bac8ed713ab'),
(2793,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2026-01-19 16:40:30',NULL,NULL,NULL,'bb6951d7-9f9a-4283-bc5e-6467bf906b9e'),
(2794,2,NULL,1617,1,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-23 20:45:18',NULL,NULL,NULL,'e647b307-5a23-4c78-8c3f-33870184eb7e'),
(2795,2791,NULL,1618,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-23 20:45:18',NULL,NULL,NULL,'333e2a9e-590f-4f51-beae-f7048d30c5cf'),
(2796,2792,NULL,1619,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-23 20:45:18',NULL,'2025-09-30 22:45:18',NULL,'a5deccbe-6457-4cdc-9c99-fd5a01af792d'),
(2797,2793,NULL,1620,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-23 20:45:18',NULL,NULL,NULL,'1e6b62b8-1294-42f0-8203-58ef942874b6'),
(2799,2,NULL,1621,1,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:07','2025-09-23 21:13:07',NULL,NULL,NULL,'9945537d-c2b2-459f-a8c4-fc387da11a49'),
(2800,NULL,NULL,NULL,22,'craft\\elements\\Asset',1,0,'2025-09-23 21:13:16','2025-09-23 21:22:49',NULL,NULL,NULL,'d06a14ea-0b3f-46f1-9fc3-27f80e36224e'),
(2802,459,NULL,1622,6,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:19','2025-09-23 21:13:19',NULL,NULL,NULL,'c6632179-233c-4e81-8b06-f027664fe5c6'),
(2803,NULL,NULL,NULL,22,'craft\\elements\\Asset',1,0,'2025-09-23 21:13:36','2025-09-23 21:22:40',NULL,NULL,NULL,'645ea5ae-4175-4410-ba89-7daf862ff408'),
(2805,465,NULL,1623,6,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:37','2025-09-23 21:13:37',NULL,NULL,NULL,'3c57da7a-d1fa-4fd7-8b32-89ab823a439d'),
(2806,NULL,NULL,NULL,22,'craft\\elements\\Asset',1,0,'2025-09-23 21:13:42','2025-09-23 21:22:33',NULL,NULL,NULL,'3aa27850-e4b8-4894-b00a-059bfe04c324'),
(2808,497,NULL,1624,6,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:43','2025-09-23 21:13:43',NULL,NULL,NULL,'0b046278-b13a-4781-88f7-6d2b466a1a29'),
(2809,NULL,NULL,NULL,22,'craft\\elements\\Asset',1,0,'2025-09-23 21:13:48','2025-09-23 21:22:25',NULL,NULL,NULL,'1442f42d-5abd-4e2c-a860-c63e22014cab'),
(2811,487,NULL,1625,6,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:50','2025-09-23 21:13:50',NULL,NULL,NULL,'bb03ac1d-f805-4602-abeb-2294590f0184'),
(2812,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:56:15','2025-09-23 21:56:42',NULL,NULL,NULL,'9e84d8c4-96c0-4bce-b66e-a095a9f0f08b'),
(2813,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:56:43','2025-09-23 21:56:57',NULL,NULL,NULL,'d2b74fb7-6d80-4ad7-81d2-2be6696b7351'),
(2814,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:57:02','2025-09-23 21:57:09',NULL,NULL,NULL,'331a4fd5-0801-4feb-b418-dcc4cab532ac'),
(2815,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:57:13','2025-09-23 21:57:19',NULL,NULL,NULL,'9805002c-e2bf-456f-aabe-b2e1aa762420'),
(2816,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:57:23','2025-09-23 21:57:28',NULL,NULL,NULL,'a35a41c4-7359-413b-b4a3-3abcc48f9f51'),
(2817,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:57:32','2025-09-23 21:57:37',NULL,NULL,NULL,'1160191a-e6ca-451e-8818-e29608b3a552'),
(2825,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'853cdf0a-cf7b-449b-bd96-774731d82a62'),
(2826,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'3a20e533-ab54-412e-a69e-1a235f6ec472'),
(2827,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'6ab8c753-d0ae-4279-b9a6-cb3dda256892'),
(2828,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'d64b9941-05a9-49e0-955f-2646b283f66f'),
(2829,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'e9ae92c4-d6d1-47de-9386-f392617552fd'),
(2830,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'b41f5c54-1e17-4c19-80a5-8b00f74c063d'),
(2831,2,NULL,1626,1,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'2dbaaead-55ae-46cd-b9be-dba4b3f793b2'),
(2832,2825,NULL,1627,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'cd724529-1bf1-4cda-9a89-3d2e3a80c60b'),
(2833,2826,NULL,1628,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'31244ec1-ed25-41c6-b2cb-4b15a8dcc2b8'),
(2834,2827,NULL,1629,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'64cc34f6-a02c-446f-9b55-318ad50fcdb2'),
(2835,2828,NULL,1630,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'664273f1-70f1-4ff8-8adb-93e88db663cf'),
(2836,2829,NULL,1631,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'0bdc7b3b-6c94-43cd-86d0-a3d1f9d58589'),
(2837,2830,NULL,1632,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'8d22cc7b-fcc4-40b9-b839-9a356dc70b59'),
(2839,2,NULL,1633,1,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:58','2025-09-23 21:59:58',NULL,NULL,NULL,'3360ea81-5f28-4884-90f4-189f3291f6f9'),
(2841,2,NULL,1634,1,'craft\\elements\\Entry',1,0,'2025-09-23 22:00:31','2025-09-23 22:00:31',NULL,NULL,NULL,'7545304f-aac6-4d86-9ba7-8b0e5bd29eb8'),
(2843,2,NULL,1635,1,'craft\\elements\\Entry',1,0,'2025-09-23 22:02:08','2025-09-23 22:02:08',NULL,NULL,NULL,'06e6866e-568a-4299-bf1f-e28b529632f5'),
(2847,945,NULL,1636,1,'craft\\elements\\Entry',1,0,'2025-09-24 15:56:07','2025-09-24 15:56:07',NULL,NULL,NULL,'8b61121d-1a0b-4a00-9265-b9717a0bd2b3'),
(2848,1171,NULL,1637,1,'craft\\elements\\Entry',1,0,'2025-09-24 15:56:11','2025-09-24 15:56:11',NULL,NULL,NULL,'842aa2a0-afad-411b-b604-5b4687a01a25'),
(2850,2622,NULL,1638,20,'craft\\elements\\Entry',1,0,'2025-09-24 16:01:26','2025-09-24 16:01:26',NULL,NULL,NULL,'4b6d4640-e6f3-4965-9f7e-f361c808dcf9'),
(2852,1481,NULL,1639,1,'craft\\elements\\Entry',1,0,'2025-09-24 16:04:13','2025-09-24 16:04:13',NULL,NULL,NULL,'e3788412-d844-4d8d-8a35-ccb65973bf87'),
(2853,2,NULL,1640,1,'craft\\elements\\Entry',1,0,'2025-09-24 16:06:15','2025-09-24 16:06:15',NULL,NULL,NULL,'4a19536d-7c33-4f0e-81c2-0352d7365703'),
(2854,945,NULL,1641,1,'craft\\elements\\Entry',1,0,'2025-09-24 16:40:05','2025-09-24 16:40:05',NULL,NULL,NULL,'0704a698-27b6-47ea-901e-77dbffbb45f5'),
(2855,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 17:19:20','2025-09-24 17:19:20',NULL,NULL,NULL,'e39eb379-f3ed-40d5-a676-c15e7b7caf9c'),
(2856,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 17:19:27','2025-09-24 17:19:27',NULL,NULL,NULL,'190a5570-3d3b-4219-b9ba-b279e874db56'),
(2857,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 17:19:28','2025-09-24 17:19:28',NULL,NULL,NULL,'ae1aa4c4-bb08-4885-8929-dffc5bd3fcae'),
(2858,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 17:19:28','2025-09-24 17:19:28',NULL,NULL,NULL,'89de1b06-2658-444f-a947-fc203512607b'),
(2860,2537,NULL,1642,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:19:33','2025-09-24 17:19:33',NULL,NULL,NULL,'222c9f8f-075b-423c-8194-1c4b77f8b142'),
(2862,2535,NULL,1643,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:19:43','2025-09-24 17:19:43',NULL,NULL,NULL,'a09276e7-87d2-43b3-8fad-7b8ed0c4089b'),
(2864,2537,NULL,1644,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:19:53','2025-09-24 17:19:53',NULL,NULL,NULL,'da67dd91-d7e5-4662-a2e8-f6a9cb9952a4'),
(2866,2527,NULL,1645,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:20:14','2025-09-24 17:20:14',NULL,NULL,NULL,'6d5836ee-5ca9-474e-a501-e82f00926ac0'),
(2868,2523,NULL,1646,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:20:23','2025-09-24 17:20:23',NULL,NULL,NULL,'9c454b78-f629-4187-975e-a1e1dce3c6fc'),
(2869,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:43','2025-09-24 18:09:43',NULL,NULL,NULL,'17a750d9-c9cb-4a80-b339-1d7e13b052e4'),
(2870,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:44','2025-09-24 18:09:44',NULL,NULL,NULL,'f4e7c045-25a8-492f-82e5-56ebeac79e40'),
(2871,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:44','2025-09-24 18:09:44',NULL,NULL,NULL,'725ddece-9d08-441e-97b9-a876cc319ef5'),
(2872,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:44','2025-09-24 18:09:44',NULL,NULL,NULL,'afaff2b4-2931-4511-9f19-d3b1712a4d22'),
(2873,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:45','2026-01-17 16:29:26',NULL,NULL,NULL,'b24b5202-8da9-4cba-bb7b-bc3e358aac70'),
(2874,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:45','2025-10-08 18:29:50',NULL,NULL,NULL,'acc48022-aa74-461f-be1f-e060daafaa4c'),
(2876,2531,NULL,1647,12,'craft\\elements\\Entry',0,0,'2025-09-24 18:45:18','2025-09-24 18:45:18',NULL,NULL,NULL,'c6377d46-7e13-42d8-8b21-ada7088b2ec4'),
(2877,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 19:41:44','2025-09-24 19:41:44',NULL,NULL,NULL,'1bf9dac5-dfae-41af-95bd-ed3239e532e7'),
(2879,2519,NULL,1648,12,'craft\\elements\\Entry',1,0,'2025-09-24 19:41:47','2025-09-24 19:41:47',NULL,NULL,NULL,'c37699f6-a2af-4a48-8689-05b33b681d15'),
(2880,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-24 23:06:33','2026-01-20 14:52:25',NULL,NULL,NULL,'bef2444f-80b9-482f-bf1a-b25832667146'),
(2881,2880,NULL,1649,1,'craft\\elements\\Entry',1,0,'2025-09-24 23:07:59','2025-09-24 23:07:59',NULL,NULL,NULL,'7abd4bb1-3369-4f94-a5a3-978eaca4ac90'),
(2885,1255,NULL,1651,1,'craft\\elements\\Entry',1,0,'2025-09-25 02:15:57','2025-09-25 02:15:57',NULL,NULL,NULL,'7bc7d46f-4151-4012-a966-9e56985d3335'),
(2886,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 14:02:15','2025-09-25 14:02:15',NULL,NULL,NULL,'f7d6ba8f-6ac9-461b-a87c-df38fe080397'),
(2887,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 14:05:38','2025-10-09 16:34:55',NULL,NULL,NULL,'f3ab68b0-c780-49b7-85c6-b270a22a2120'),
(2888,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 14:05:39','2025-09-25 14:07:01',NULL,NULL,NULL,'cbf53f06-3113-4c1b-a3ec-f86d25f82f6d'),
(2889,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 15:18:29','2025-09-25 15:24:16',NULL,NULL,NULL,'2196ef41-7959-416e-834f-3e7f395383ef'),
(2890,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 15:18:40','2025-09-25 15:24:29',NULL,NULL,NULL,'bf4644ad-09e8-4d62-a5d0-10f77cf961aa'),
(2891,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-09-26 17:59:45','2026-01-19 16:21:04',NULL,NULL,NULL,'091623a3-eae4-4db8-88d6-e973fdd7615a'),
(2892,2891,NULL,1652,6,'craft\\elements\\Entry',1,0,'2025-09-26 17:59:52','2025-09-26 17:59:52',NULL,NULL,NULL,'4749bab5-fdcb-4972-837c-3b9482352428'),
(2894,2,NULL,1653,1,'craft\\elements\\Entry',1,0,'2025-09-26 18:00:58','2025-09-26 18:00:58',NULL,NULL,NULL,'150705cb-79ee-4439-8edf-096636031c71'),
(2896,2,NULL,1654,1,'craft\\elements\\Entry',1,0,'2025-09-26 18:05:11','2025-09-26 18:05:11',NULL,NULL,NULL,'4117f518-2706-44a2-87d4-2a11681a4c4a'),
(2899,1255,NULL,1655,1,'craft\\elements\\Entry',1,0,'2025-09-26 20:17:54','2025-09-26 20:17:54',NULL,NULL,NULL,'bb07685c-bfd8-4f27-9515-87e73935070d'),
(2905,1177,NULL,1656,1,'craft\\elements\\Entry',1,0,'2025-09-29 18:35:28','2025-09-29 18:35:28',NULL,NULL,NULL,'c9551b91-1c37-4a62-9935-bcdb87457390'),
(2907,1177,NULL,1657,1,'craft\\elements\\Entry',1,0,'2025-09-29 18:35:55','2025-09-29 18:35:55',NULL,NULL,NULL,'3f75ab05-805a-4abe-85f9-4a34dea3282e'),
(2908,2,NULL,1658,1,'craft\\elements\\Entry',1,0,'2025-09-29 18:58:54','2025-09-29 18:58:54',NULL,NULL,NULL,'0d0f2ff1-94f7-47fa-8745-cae920c54f12'),
(2909,1395,NULL,1659,1,'craft\\elements\\Entry',1,0,'2025-09-29 18:59:03','2025-09-29 18:59:03',NULL,NULL,NULL,'65f9351d-3861-4e4e-b8c4-0ba7bcd27cf2'),
(2910,111,NULL,1660,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'c650617a-b594-4e54-bb13-14156916f521'),
(2911,113,NULL,1661,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'8ff0adae-1d66-407c-b2d4-507013201ea6'),
(2912,115,NULL,1662,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'3c8788ed-8351-455c-8912-af7f8be15220'),
(2913,117,NULL,1663,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'3c5a81c9-23fb-47bd-a420-bf380ae636c1'),
(2914,119,NULL,1664,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'f0c843a5-4350-4870-8d2e-93e13170963b'),
(2915,121,NULL,1665,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'6e4d414d-af0d-4fef-8cc7-cb0f260209d4'),
(2916,555,NULL,1666,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'f734afe7-0719-4f17-9efd-5497f899accc'),
(2917,557,NULL,1667,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'e4fa05cf-72d2-4bcf-bfcc-b1acc0e5b588'),
(2918,559,NULL,1668,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'55a9d344-dde2-4d75-adb3-59c6074b104e'),
(2925,2891,NULL,1671,6,'craft\\elements\\Entry',1,0,'2025-09-29 19:09:02','2025-09-29 19:09:02',NULL,NULL,NULL,'bbc19e60-bda0-4ab7-85c4-2d59f464dc1c'),
(2927,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-30 19:28:01','2025-09-30 19:28:01',NULL,NULL,NULL,'09d388c7-0016-4619-997e-07c4fe87c800'),
(2929,2531,NULL,1672,12,'craft\\elements\\Entry',1,0,'2025-09-30 19:28:07','2025-09-30 19:28:07',NULL,NULL,NULL,'57b7f73d-8020-4985-9b65-0c3a40be891b'),
(2931,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-09-30 22:22:11','2025-11-05 17:40:21',NULL,NULL,NULL,'d53e1dc0-a6fa-4ec6-b669-5a46d86a0c1f'),
(2933,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-09-30 22:22:21','2025-11-05 17:40:21',NULL,NULL,NULL,'bbe1e0e2-b667-4e3b-be36-6e2bd1c32344'),
(2934,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-09-30 22:22:35','2025-11-05 17:40:21',NULL,NULL,NULL,'7fda0972-eaa2-42f3-925e-2a9c367210b7'),
(2938,2,NULL,1673,1,'craft\\elements\\Entry',1,0,'2025-09-30 22:41:39','2025-09-30 22:41:39',NULL,NULL,NULL,'ddad6dd5-c5c8-4f75-8e26-bbb0ae786794'),
(2939,2791,NULL,1674,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:41:39','2025-09-30 22:41:39',NULL,NULL,NULL,'18e7b730-40a0-4fc8-ba3f-046afa3e7dcd'),
(2941,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-09-30 22:43:05','2025-11-05 17:40:20',NULL,NULL,NULL,'cce62c0f-586e-43e7-8f0b-34dfec5796b5'),
(2945,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:18','2025-09-30 22:45:57',NULL,NULL,NULL,'f15f8b74-c868-460c-9e9d-dedc7a1b36f5'),
(2946,2,NULL,1675,1,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:18','2025-09-30 22:45:18',NULL,NULL,NULL,'f079aa0c-7131-43f7-a4fc-e520537806a7'),
(2947,2793,NULL,1676,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:18','2025-09-30 22:45:18',NULL,NULL,NULL,'dbab52c4-438b-4346-ba52-f1468cd206e1'),
(2948,2945,NULL,1677,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:18','2025-09-30 22:45:18',NULL,NULL,NULL,'e80b7480-2708-4d64-a239-5861e125a7c5'),
(2951,2,NULL,1678,1,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:57','2025-09-30 22:45:57',NULL,NULL,NULL,'d8a85eda-1c40-41ce-b7b3-b85805b4382b'),
(2952,2945,NULL,1679,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:57','2025-09-30 22:45:57',NULL,NULL,NULL,'940b2d3c-d38a-4a39-a33e-bb7e3b4f024e'),
(2955,2,NULL,1680,1,'craft\\elements\\Entry',1,0,'2025-09-30 22:46:11','2025-09-30 22:46:11',NULL,NULL,NULL,'f2a7b376-7741-4819-8105-22f757c51677'),
(2956,2793,NULL,1681,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:46:11','2025-09-30 22:46:11',NULL,NULL,NULL,'8753d74d-0fe8-4bcf-9d92-5af949f3572f'),
(2959,601,NULL,1682,5,'craft\\elements\\Entry',1,0,'2025-10-03 20:24:31','2025-10-03 20:24:31',NULL,NULL,NULL,'e7687068-e69a-4297-b2e5-fcb902e1c687'),
(2961,605,NULL,1683,5,'craft\\elements\\Entry',1,0,'2025-10-03 20:24:40','2025-10-03 20:24:40',NULL,NULL,NULL,'1901a062-005c-4ef8-a664-4a22001fe540'),
(2963,617,NULL,1684,5,'craft\\elements\\Entry',1,0,'2025-10-03 20:24:49','2025-10-03 20:24:49',NULL,NULL,NULL,'36142205-ddda-4d6f-9181-a7244c956373'),
(2965,1045,NULL,1685,1,'craft\\elements\\Entry',1,0,'2025-10-06 16:09:49','2025-10-06 16:09:49',NULL,NULL,NULL,'0d01d621-5e7c-4d0e-8fc5-d8e9fb5fa3bf'),
(2966,2712,NULL,1686,1,'craft\\elements\\Entry',1,0,'2025-10-06 16:09:59','2025-10-06 16:09:59',NULL,NULL,NULL,'f2f3b5ca-4b08-4fbd-8663-5e0200c78aa2'),
(2968,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-06 17:44:48','2025-10-06 17:45:01',NULL,NULL,NULL,'1e415e16-5d61-4b38-b4ca-eea293fa5718'),
(2969,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:45:32','2026-01-17 19:31:45',NULL,NULL,NULL,'7bd0e66d-ba6f-462c-b940-8a507312e64c'),
(2970,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-06 17:45:59','2025-10-08 18:24:15',NULL,NULL,NULL,'244b1cd5-9af2-47b0-8d0f-cbee1fa1da55'),
(2971,2969,NULL,1687,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:46:02','2025-10-06 17:46:02',NULL,NULL,NULL,'ac8cf22c-9eaf-4340-8e01-73f04dd1d98c'),
(2972,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:46:14','2026-01-17 19:32:25',NULL,NULL,NULL,'9852d22d-7977-41ef-b9e5-8434fd943927'),
(2973,2972,NULL,1688,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:46:44','2025-10-06 17:46:44',NULL,NULL,NULL,'94f173b2-a178-496a-a9cd-78f2d7103b55'),
(2974,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:46:46','2025-10-09 16:34:57',NULL,NULL,NULL,'f1a45e0b-97f6-484c-aaf9-862a950df77c'),
(2975,2974,NULL,1689,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:47:00','2025-10-06 17:47:00',NULL,NULL,NULL,'46992ec8-dc68-47f1-a296-3da03000f308'),
(2976,2969,NULL,1690,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:47:25','2025-10-06 17:47:25',NULL,NULL,NULL,'e7819822-f028-4ebe-a821-66f59652192f'),
(2977,2974,NULL,1691,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:47:42','2025-10-06 17:47:42',NULL,NULL,NULL,'88b5c63d-67e7-402f-b5aa-89de02497f86'),
(2983,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'dff524c0-f322-4745-a9c9-f3b1a7a4588d'),
(2984,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'2ebdb9f4-1f94-4e6c-a05b-10cb3360ed12'),
(2985,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'00ae0086-f18d-4c0b-9118-866e6ecc58c6'),
(2986,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'26553af5-fbad-4e27-bbc0-8e13aaae314e'),
(2987,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'b9d159c2-3e0f-4ef5-8399-7071afa15be8'),
(2988,945,NULL,1692,1,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'1492e223-e36b-4823-9c76-ec2d9ce8b232'),
(2989,2983,NULL,1693,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'d78404f0-6e13-4842-a760-a268ccc6ae9c'),
(2990,2984,NULL,1694,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'b744fdd6-07ef-4759-bfab-43a08b1eba16'),
(2991,2985,NULL,1695,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'7c45e2a2-eceb-48b8-88bf-090da2be04cc'),
(2992,2986,NULL,1696,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'19b60af6-db6e-46bc-8b9c-e30b283da145'),
(2993,2987,NULL,1697,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'dd01058a-36b5-4bee-bd58-7fd825444905'),
(2995,945,NULL,1698,1,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:49','2025-10-06 17:50:49',NULL,NULL,NULL,'f80dad38-a3d9-4ef1-8767-f4692e8f8a3e'),
(2999,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'55ab1db7-1e58-4e8a-a3bc-386a040bbcef'),
(3000,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'dd4bd306-e50b-40d3-8e5c-5322170d20f1'),
(3001,945,NULL,1699,1,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'bb2ef1ca-b53e-4a8f-b034-f075201f6237'),
(3002,2999,NULL,1700,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'30e97202-0552-4122-bc2a-fac3d13d209b'),
(3003,3000,NULL,1701,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'87a8c7fe-59b7-4473-b14a-5092baeb90dd'),
(3006,945,NULL,1702,1,'craft\\elements\\Entry',1,0,'2025-10-06 17:52:05','2025-10-06 17:52:05',NULL,NULL,NULL,'ac03093c-3750-4e39-a3d5-d0cb9f9a7859'),
(3009,957,NULL,1703,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:17:50','2025-10-08 18:17:50',NULL,NULL,NULL,'c20e5e52-00cf-4069-a1d3-149780a4fc3f'),
(3011,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 18:19:10','2025-10-08 18:19:10',NULL,NULL,NULL,'dc5c17f6-765e-48b3-85a8-55202a0faf0b'),
(3014,2972,NULL,1704,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:21:43','2025-10-08 18:21:43',NULL,NULL,NULL,'f03c5430-813f-45f9-9bca-5aeb0f5c34bd'),
(3016,NULL,671,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:22:14','2026-01-17 16:30:37',NULL,'2026-01-17 16:30:37',NULL,'180780b3-2a96-4030-a27b-6e5392364481'),
(3017,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:26:16','2025-10-08 18:26:30',NULL,NULL,NULL,'13b67eac-63bd-408e-9f79-f0cf8847bc4b'),
(3018,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:26:55','2025-10-08 18:27:05',NULL,NULL,NULL,'c9a18e0b-fd23-4af0-8cc5-01e1b23e5954'),
(3019,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:28:08','2025-10-08 18:28:18',NULL,NULL,NULL,'24fb6028-a4fb-41b6-b9b9-8b60c849bba5'),
(3020,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:29:13','2025-10-08 18:30:02',NULL,NULL,NULL,'c7aaea27-9af3-4730-85a4-0bb39f7b4afa'),
(3021,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:30:50','2025-10-08 18:31:22',NULL,NULL,NULL,'5f8fe953-5abe-416d-a8da-0525c95105cd'),
(3022,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:31:41','2025-10-08 18:32:14',NULL,NULL,NULL,'8574977d-e956-4be2-8186-3a286b884e33'),
(3023,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:32:26','2025-10-08 18:32:47',NULL,NULL,NULL,'fc3421f8-4272-4d92-b724-eb867dbe405e'),
(3025,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:34:47','2026-01-17 19:35:42',NULL,'2026-01-17 19:35:42',NULL,'195a0190-3c42-41ca-8040-a184e12e6ee4'),
(3026,3025,NULL,1705,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:35:41','2025-10-08 18:35:41',NULL,'2026-01-17 19:35:42',NULL,'5e21e4d4-d6dd-4493-a82e-2b438a591bad'),
(3027,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:35:57','2025-10-08 18:36:16',NULL,NULL,NULL,'a736b85e-4e04-40a9-94dc-c1cb48631e31'),
(3028,3027,NULL,1706,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:36:16','2025-10-08 18:36:16',NULL,NULL,NULL,'0cbea65c-66d1-4a48-9c8d-b6a33060b865'),
(3029,957,NULL,1707,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:36:38','2025-10-08 18:36:38',NULL,NULL,NULL,'24d1296e-21a5-40d5-8f8c-330bedf30467'),
(3036,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'8f123bf6-963c-448e-aed5-60d1334d9ccb'),
(3037,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'67491fc8-76c6-4a66-9c71-d5f44b50bab5'),
(3038,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'5ba542a2-ede0-43ca-8441-fef9aee3afea'),
(3039,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'4a14c1e3-6853-4034-8db5-394a882839ce'),
(3040,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'3cad777e-f3f6-4f1f-bc3b-d066f73de1df'),
(3041,957,NULL,1708,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'6bbf1680-c1e8-439b-b920-cf523ab91027'),
(3042,3036,NULL,1709,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'2e9ad6d6-f5e1-4ca8-9ddd-5b39dfab7c24'),
(3043,3037,NULL,1710,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'c7af399a-8d39-4bbc-ad83-5e85731cfca4'),
(3044,3038,NULL,1711,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'16e1ff19-1d0a-4427-8f65-1c452774cd6d'),
(3045,3039,NULL,1712,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'b80e5a21-7a15-42e5-a7ec-341b23efd69f'),
(3046,3040,NULL,1713,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'d28b2edb-8ca3-4906-bb56-43b2c0cead06'),
(3048,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 18:42:24','2025-10-08 18:42:24',NULL,NULL,NULL,'56a1fb3c-8b4d-4327-a5e6-511911c4a0ca'),
(3051,957,NULL,1714,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:43:12','2025-10-08 18:43:12',NULL,NULL,NULL,'f29e2170-5dda-4b5e-8959-38478e2c0f95'),
(3052,1504,NULL,1715,2,'craft\\elements\\Entry',1,0,'2025-10-08 18:43:12','2025-10-08 18:43:12',NULL,NULL,NULL,'35df403f-543c-4c6b-8c85-8f39d3dad9cb'),
(3053,1505,NULL,1716,2,'craft\\elements\\Entry',1,0,'2025-10-08 18:43:12','2025-10-08 18:43:12',NULL,NULL,NULL,'5fcd11d2-8b9f-463a-895a-6399cdbf6c7a'),
(3055,957,NULL,1717,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:43:42','2025-10-08 18:43:42',NULL,NULL,NULL,'503f8b07-4773-43b6-a2be-e40c28829ec5'),
(3058,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 18:44:46','2025-10-08 18:44:46',NULL,NULL,NULL,'054301c8-faa7-4c0f-a0d8-34aa2934601b'),
(3059,963,NULL,1718,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:46:53','2025-10-08 18:46:53',NULL,NULL,NULL,'9b0e7323-6207-40ae-a84e-b33acc52a043'),
(3066,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'b43aabfd-e6e5-4afe-892a-ec662230bf96'),
(3067,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'1172871b-3e60-4daa-b4b0-9158465c8bf0'),
(3068,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'bd49a00d-87bf-452c-963a-5a76a777c7fa'),
(3069,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'b67311d5-3f55-49b1-9aee-af4bf1cfc1dc'),
(3070,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'2cdf0ee4-1d10-4fd9-ad1a-7868205cc2dd'),
(3071,963,NULL,1719,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'0f830da5-13ec-4510-bd46-1d43b29c49ad'),
(3072,3066,NULL,1720,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'aacc9f96-b49f-4f94-8feb-6b8ca9b9e6e7'),
(3073,3067,NULL,1721,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'3a6b6d70-4f17-4cb1-98ec-26c233367544'),
(3074,3068,NULL,1722,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'c38d949b-8425-4112-9386-3b1c0a0a8bea'),
(3075,3069,NULL,1723,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'7763659b-af9b-4bba-86dc-ae4a23c5fe77'),
(3076,3070,NULL,1724,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'423df36c-6bec-48fa-a836-16ffdf6ab642'),
(3079,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:50:11','2025-10-08 18:50:11',NULL,NULL,NULL,'e1707b8c-e2eb-48f3-8374-c8cee50bf48b'),
(3080,963,NULL,1725,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:50:11','2025-10-08 18:50:11',NULL,NULL,NULL,'e1d5b1c0-df0e-46b6-93ac-c07b26796b1c'),
(3081,3079,NULL,1726,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:50:11','2025-10-08 18:50:11',NULL,NULL,NULL,'83151760-cf8b-495e-95d3-3b8ff0495a48'),
(3084,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 18:51:15','2025-10-08 18:51:29',NULL,NULL,NULL,'f9f86cbf-1eac-4ad0-b1b8-0c15e781282e'),
(3086,963,NULL,1727,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:52:55','2025-10-08 18:52:55',NULL,NULL,NULL,'beb5010d-47de-4e80-a0d6-ae4a8c284add'),
(3087,1509,NULL,1728,2,'craft\\elements\\Entry',1,0,'2025-10-08 18:52:55','2025-10-08 18:52:55',NULL,NULL,NULL,'e2b692bc-4bd5-48dc-b3c4-6cbaf69672c0'),
(3088,1510,NULL,1729,2,'craft\\elements\\Entry',1,0,'2025-10-08 18:52:55','2025-10-08 18:52:55',NULL,NULL,NULL,'ad119916-cade-4058-b3ce-0656f73664c7'),
(3090,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 18:53:49','2025-10-08 18:54:27',NULL,NULL,NULL,'232474b4-5e67-49ff-ad01-79e918687e9e'),
(3091,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:54:51','2026-01-17 16:30:46',NULL,'2026-01-17 16:30:46',NULL,'019e342e-cde0-4f5c-b2ce-50ffb09049eb'),
(3092,3091,NULL,1730,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:55:24','2025-10-08 18:55:24',NULL,'2026-01-17 16:30:46',NULL,'0a1427e4-62d4-4a32-8ee4-56a273508e21'),
(3093,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:55:36','2025-10-08 18:55:51',NULL,NULL,NULL,'d528be92-2b52-489a-8b53-7106c43b0536'),
(3094,3093,NULL,1731,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:55:51','2025-10-08 18:55:51',NULL,NULL,NULL,'f3f5f0b0-849c-442b-8b52-cd6de2b6af71'),
(3095,969,NULL,1732,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:56:08','2025-10-08 18:56:08',NULL,NULL,NULL,'be26992b-bedf-4f4f-864e-a98a3f00e202'),
(3102,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'21bda4c0-d863-48a2-abe5-26c081922e37'),
(3103,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'76995242-ad43-4bb7-8a3a-8da9ac50cff7'),
(3104,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'a7a33caf-632e-45a9-a668-26a09c3014b8'),
(3105,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'1f4362e1-f513-4665-b739-fb32290f369c'),
(3106,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'709eb709-f9f1-4b1b-90ec-dab090c098f2'),
(3107,969,NULL,1733,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'6a3a98db-d84e-4d72-8d01-caec80c4de80'),
(3108,3102,NULL,1734,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'0fc8cae8-f860-41af-a02a-75f8e31f310e'),
(3109,3103,NULL,1735,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'c410006b-7e18-4705-bc2a-8ec99da92639'),
(3110,3104,NULL,1736,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'3617ee59-b774-4f71-b7e1-9dd7ac0f9ba2'),
(3111,3105,NULL,1737,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'80f82d97-6bf7-459b-9d5d-f38ee04dae3c'),
(3112,3106,NULL,1738,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'d01acf0d-ee03-4c40-a561-f2285c001b37'),
(3114,969,NULL,1739,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:59:33','2025-10-08 18:59:33',NULL,NULL,NULL,'4505dfc3-6dbc-490e-9423-01eb64fdd2b2'),
(3118,969,NULL,1740,1,'craft\\elements\\Entry',1,0,'2025-10-08 19:00:47','2025-10-08 19:00:47',NULL,NULL,NULL,'629d38f3-0c11-4e07-ba26-b21476a62a68'),
(3119,1514,NULL,1741,2,'craft\\elements\\Entry',1,0,'2025-10-08 19:00:47','2025-10-08 19:00:47',NULL,NULL,NULL,'e818e493-afdb-48bd-bd1d-665393b576e8'),
(3120,1515,NULL,1742,2,'craft\\elements\\Entry',1,0,'2025-10-08 19:00:47','2025-10-08 19:00:47',NULL,'2025-11-17 15:01:37',NULL,'3bab0044-19a5-4343-8e69-48f89213b1d0'),
(3122,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 19:52:53','2025-10-08 19:52:53',NULL,NULL,NULL,'af87fd51-f341-4428-ac78-492fdb8c02c3'),
(3123,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 19:54:05','2026-01-17 19:35:42',NULL,'2026-01-17 19:35:42',NULL,'8f44127f-8524-4436-8a28-f1ac404fe254'),
(3124,3123,NULL,1743,5,'craft\\elements\\Entry',1,0,'2025-10-08 19:54:15','2025-10-08 19:54:15',NULL,'2026-01-17 19:35:42',NULL,'9dc88c62-70a3-43f3-b500-2b7bd82ab5db'),
(3125,975,NULL,1744,1,'craft\\elements\\Entry',1,0,'2025-10-08 19:54:49','2025-10-08 19:54:50',NULL,NULL,NULL,'830a7f17-8a35-4d63-a22c-942530733649'),
(3137,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 19:59:08','2025-10-08 19:59:08',NULL,NULL,NULL,'4ccceeae-e63e-45b0-8e79-e7c1920d31d3'),
(3138,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'059d822b-724e-4fcb-bc8d-7cd1fac7f86c'),
(3139,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'4a4ee3ac-31d1-47b5-8715-6ab4043d92e1'),
(3140,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'2810da40-ce95-4714-8200-76b5c0e4eede'),
(3141,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'7263269e-6321-4733-9d51-0677c821a91b'),
(3142,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'c3a826ba-826c-4dd6-a935-5841c40dd622'),
(3143,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'362500c9-bdf4-44a4-97a0-42826aded357'),
(3144,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'f114560b-6a15-4011-9841-8d43a9487a16'),
(3145,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'d7e50521-a96e-496a-a3b3-1d2c7ec9a4ef'),
(3146,975,NULL,1745,1,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'b0198c8f-b922-4014-b82c-2e61dd55659a'),
(3147,3138,NULL,1746,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'8421bd29-7ff6-436f-8f96-708fb36cae2d'),
(3148,3139,NULL,1747,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'880d66c3-15aa-4e43-bf1a-7eed1143eb86'),
(3149,3140,NULL,1748,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'15584359-b7df-4a67-9631-c7423eb7e1dd'),
(3150,3141,NULL,1749,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'31390b18-ac5d-400e-bbf8-5f5cd2e49593'),
(3151,3142,NULL,1750,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'84763762-27a3-4086-89da-a9cd825265ed'),
(3152,3143,NULL,1751,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'3bf2a799-08a3-4f11-aec7-e101d5749221'),
(3153,3144,NULL,1752,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'c06d50ef-9902-405b-b5de-ba80371aa240'),
(3154,3145,NULL,1753,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'0092bbb1-79d0-4298-aea9-0f3e3c6bcee0'),
(3155,1519,NULL,1754,2,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'e941ebf3-6905-4ba1-b1ab-f5ed79003139'),
(3156,1520,NULL,1755,2,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'2c914bdc-4a7b-4fd2-b110-08716b2af8b5'),
(3158,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 20:21:30','2026-01-13 20:13:24',NULL,NULL,NULL,'83b7d259-d0a6-4d99-9467-7abb85c36e23'),
(3159,981,NULL,1756,1,'craft\\elements\\Entry',1,0,'2025-10-08 20:22:53','2025-10-08 20:22:54',NULL,NULL,NULL,'bbf24774-8c10-43e6-9ee2-5d6fb8dcdee6'),
(3166,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'d34a4ef4-e951-41e0-9fb2-f4fbc873209e'),
(3167,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'87fdc99f-8de3-424a-b23b-a74240ea791a'),
(3168,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'abd946e5-2322-4f04-8ea9-b698d3ee5fe3'),
(3169,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'0ae280fb-3cb2-4f8c-8784-15b4465073a9'),
(3170,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'3e7195c7-e715-420c-842f-27fadf0cb033'),
(3171,981,NULL,1757,1,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'dea4d9dd-1b96-4a42-ab36-87998774d0d0'),
(3172,3166,NULL,1758,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'ba7cb77c-c80a-4a7b-8af7-e901ba51d019'),
(3173,3167,NULL,1759,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'8309ecbe-aa76-4b2b-af6d-f8585fc3da26'),
(3174,3168,NULL,1760,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'675e44df-d694-4d1b-b233-3309b32dd204'),
(3175,3169,NULL,1761,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'70d6cd9c-6db3-48f0-bcc1-de7521f44642'),
(3176,3170,NULL,1762,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'7d145633-87dc-4c7a-a107-7286d02ee50b'),
(3180,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 20:25:38','2025-10-08 20:25:38',NULL,NULL,NULL,'c68a7f61-7a3e-45ed-9bc2-3bd8c1f90fcf'),
(3182,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:58','2025-10-08 20:25:58',NULL,NULL,NULL,'6831c17a-4ed4-47be-a357-2d24c2601d49'),
(3183,981,NULL,1763,1,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:57','2025-10-08 20:25:58',NULL,NULL,NULL,'85386aa8-e38c-4514-be7d-0db0739049df'),
(3184,3182,NULL,1764,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:58','2025-10-08 20:25:58',NULL,NULL,NULL,'6cfe6525-108f-48d0-9a9b-cce2039e6cdc'),
(3185,1525,NULL,1765,2,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:58','2025-10-08 20:25:58',NULL,NULL,NULL,'bf934570-09ee-42f4-8fd7-fd6ac64c5f84'),
(3186,1526,NULL,1766,2,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:58','2025-10-08 20:25:58',NULL,NULL,NULL,'787aa8e9-d8bf-4aae-8d66-799555c5d52d'),
(3188,981,NULL,1767,1,'craft\\elements\\Entry',1,0,'2025-10-08 20:26:01','2025-10-08 20:26:01',NULL,NULL,NULL,'5e8d679a-823e-454c-8b16-a5e31d9015c3'),
(3189,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Form',1,0,'2025-10-08 22:17:51','2025-10-23 01:16:23',NULL,NULL,NULL,'fe2e5e5e-abbd-4561-a3ba-37026f922a57'),
(3190,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Form',1,0,'2025-10-08 22:17:57','2025-10-23 01:16:40',NULL,NULL,NULL,'a86c2379-7dd0-4176-b497-17774e589315'),
(3191,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Form',1,0,'2025-10-08 22:18:05','2025-10-23 01:15:27',NULL,NULL,NULL,'0eb29f3f-cbde-4407-be4f-b02acee98449'),
(3192,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:49','2025-10-08 22:18:56',NULL,NULL,NULL,'fdcf5c6f-b728-447f-8c82-fbb551b5226e'),
(3193,3192,NULL,1768,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:56','2025-10-08 22:18:56',NULL,NULL,NULL,'cb42d871-81de-45fc-b52b-366d6efc1a2f'),
(3194,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:56','2025-10-08 22:18:59',NULL,NULL,NULL,'7f438e6a-e1fa-4e24-a2e9-1648ba399aa6'),
(3195,3194,NULL,1769,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:59','2025-10-08 22:18:59',NULL,NULL,NULL,'5c0344c3-000b-4c15-a977-80d3684def8a'),
(3196,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:59','2025-10-08 22:19:01',NULL,NULL,NULL,'742c6231-be5b-4f77-90a7-29083f2c688e'),
(3197,3196,NULL,1770,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:01','2025-10-08 22:19:01',NULL,NULL,NULL,'bc745dd8-db76-458d-83f9-102dbf55ff21'),
(3198,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:01','2025-10-08 22:19:04',NULL,NULL,NULL,'62fa409a-ca19-4c74-abe3-38b7808d8d7a'),
(3199,3198,NULL,1771,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:04','2025-10-08 22:19:04',NULL,NULL,NULL,'3fd9cb80-d945-4673-97b4-2752ad48de06'),
(3200,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:04','2025-10-08 22:19:06',NULL,NULL,NULL,'c1356cab-a204-400c-b6ed-106236a55ace'),
(3201,3200,NULL,1772,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:06','2025-10-08 22:19:06',NULL,NULL,NULL,'f1f30280-8da4-45d1-93ad-b1bf87fc1a99'),
(3202,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:06','2025-10-08 22:19:10',NULL,NULL,NULL,'14c7ade6-f49b-47cd-adb2-9ed996427e7b'),
(3203,3202,NULL,1773,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:10','2025-10-08 22:19:10',NULL,NULL,NULL,'23f72963-e31d-4c68-9d75-c88b1eba4ef1'),
(3204,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:10','2025-10-08 22:19:13',NULL,NULL,NULL,'5fe38de9-ef00-4a60-9edb-199aba2abeb0'),
(3205,3204,NULL,1774,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:13','2025-10-08 22:19:13',NULL,NULL,NULL,'457314c2-9b4a-48fc-b2ee-58acf9211588'),
(3206,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:13','2025-10-08 22:19:15',NULL,NULL,NULL,'21831c2c-63e7-4c73-8d71-b4382d343ec1'),
(3207,3206,NULL,1775,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:15','2025-10-08 22:19:15',NULL,NULL,NULL,'671b7251-dc16-4097-b83c-9180d0e36bc7'),
(3208,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:15','2025-10-08 22:19:18',NULL,NULL,NULL,'267ab4a4-242c-4556-adb9-da28988d3814'),
(3209,3208,NULL,1776,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:18','2025-10-08 22:19:18',NULL,NULL,NULL,'dfb00755-2955-4c8e-ad3a-bd157298da31'),
(3210,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:18','2025-10-08 22:19:21',NULL,NULL,NULL,'70a9acfe-dd17-46ba-a43c-181ef4e6f3eb'),
(3211,3210,NULL,1777,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:21','2025-10-08 22:19:21',NULL,NULL,NULL,'48dbcb6a-94b7-41d3-94e0-46747c6ed15d'),
(3212,945,NULL,1778,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:59','2025-10-08 22:19:59',NULL,NULL,NULL,'a39dd38b-4c13-4b7c-abea-a9c5fe7b968b'),
(3213,1255,NULL,1779,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:05','2025-10-08 22:20:05',NULL,NULL,NULL,'4b1aa3be-d0d8-416f-8609-420070e42fd8'),
(3214,2,NULL,1780,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:09','2025-10-08 22:20:09',NULL,NULL,NULL,'80636f1b-7665-4338-b68a-ec4787e8b947'),
(3216,2,NULL,1781,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:12','2025-10-08 22:20:12',NULL,NULL,NULL,'f86e3dc2-543a-4c52-b5aa-e3327f08f7ef'),
(3217,1165,NULL,1782,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:15','2025-10-08 22:20:15',NULL,NULL,NULL,'47659f3a-d549-4f3b-9a63-9108d9807044'),
(3218,957,NULL,1783,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:19','2025-10-08 22:20:19',NULL,NULL,NULL,'62d4ca5a-ce2c-4855-856b-11bad1d37709'),
(3219,2720,NULL,1784,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:23','2025-10-08 22:20:23',NULL,NULL,NULL,'132a0129-be0e-4488-9bc9-8637e1c22948'),
(3221,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 22:21:38','2025-10-08 22:21:38',NULL,NULL,NULL,'bdc16f15-f46f-4437-8456-4f61d3a02e89'),
(3223,951,NULL,1785,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:21:46','2025-10-08 22:21:46',NULL,NULL,NULL,'d79aa478-10ab-42d4-9220-d3d3683b044e'),
(3224,1499,NULL,1786,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:21:46','2025-10-08 22:21:46',NULL,'2025-12-01 19:40:26',NULL,'8929c7c6-6dea-4018-8d44-290bb8663880'),
(3235,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:24:18','2025-10-08 22:24:18',NULL,NULL,NULL,'627b2b6b-1518-430e-998b-bf5c8934774e'),
(3236,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:24:35','2025-10-08 22:24:35',NULL,NULL,NULL,'b5404ca1-c473-44f8-a42f-4eddf48b474c'),
(3237,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:24:46','2025-10-08 22:24:46',NULL,NULL,NULL,'9bd95623-c874-426e-afde-5af3089ba860'),
(3238,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:24:57','2025-10-08 22:24:57',NULL,NULL,NULL,'560a5bc7-8092-43fb-92dc-2a33924dce10'),
(3239,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:07','2025-10-08 22:25:07',NULL,NULL,NULL,'c322f018-7d22-4eb0-b96b-1e4f4c964427'),
(3240,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:18','2025-10-08 22:25:18',NULL,NULL,NULL,'1a74ea73-9636-466d-8569-5f588f575f87'),
(3241,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:29','2025-10-08 22:25:29',NULL,NULL,NULL,'95dfc41f-cf70-4f09-9316-e6f5e0450622'),
(3242,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:38','2025-10-08 22:25:38',NULL,NULL,NULL,'6de533ef-4635-4f28-b60d-49fcc57c4a3d'),
(3243,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:45','2025-10-08 22:25:45',NULL,NULL,NULL,'21d30ca9-2dc4-4472-a21a-e52d0e486570'),
(3244,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:47','2025-10-08 22:25:47',NULL,NULL,NULL,'22d78448-056c-46a4-a7ca-839f4fd4d268'),
(3245,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:37','2025-10-08 22:28:37',NULL,NULL,NULL,'9733e01e-92e1-409e-a13c-25f7a5b85d16'),
(3246,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:39','2025-10-08 22:28:39',NULL,NULL,NULL,'71a8753e-1f70-4071-8e74-fd3ed12702ca'),
(3247,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:40','2025-10-08 22:28:40',NULL,NULL,NULL,'fa897fc0-44eb-45bf-93d4-c784a7e678d0'),
(3248,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:40','2025-10-08 22:28:40',NULL,NULL,NULL,'4a1dcc5f-11a4-497c-a7b9-1fe32fd4b2e3'),
(3249,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:41','2025-10-08 22:28:41',NULL,NULL,NULL,'73ea64cc-e552-4ff7-a7aa-f043ac594c5e'),
(3250,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:42','2025-10-08 22:28:42',NULL,NULL,NULL,'6c862239-0290-449b-8c2e-e15b87bb2df6'),
(3251,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:43','2025-10-08 22:28:43',NULL,NULL,NULL,'4a00740d-2bfd-4662-a6f9-cb5f4348fced'),
(3252,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:43','2025-10-08 22:28:43',NULL,NULL,NULL,'241cfdf9-ee01-4999-8ccc-1201776b31ee'),
(3253,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:44','2025-10-08 22:28:44',NULL,NULL,NULL,'96d62528-d0e1-4e65-8c8c-2acdaeff7745'),
(3254,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:45','2025-10-08 22:28:45',NULL,NULL,NULL,'bfb466e7-af2b-40e0-a112-e03a3666daf1'),
(3255,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2026-01-16 15:09:33',NULL,NULL,NULL,'cb0037a3-1a81-4fc5-8c12-4b958b69b0ad'),
(3256,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2026-01-16 15:09:33',NULL,NULL,NULL,'869c3b32-0a9e-4114-ba10-ce54e2ee774f'),
(3257,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2026-01-16 15:09:33',NULL,NULL,NULL,'3af8d3b0-3cc3-4b0d-ac91-c3f0f1f90897'),
(3258,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2026-01-16 15:09:33',NULL,NULL,NULL,'926da004-87c3-4218-b38e-d6392e6b5953'),
(3259,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2026-01-16 15:09:33',NULL,NULL,NULL,'3a54dcc4-f16a-48de-87d9-39254d852dbc'),
(3260,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2026-01-16 15:16:13',NULL,NULL,NULL,'684bb1bd-2c75-48c3-b747-e40a1c53f889'),
(3261,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2026-01-16 15:16:13',NULL,NULL,NULL,'231ebd46-582a-4308-8b39-55fe0546ae63'),
(3262,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2026-01-16 15:16:13',NULL,NULL,NULL,'3204721d-8dd0-4be7-8087-109eadc1ce4f'),
(3263,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2026-01-16 15:16:13',NULL,'2026-01-16 15:16:13',NULL,'ea58d1bd-ea2e-42ac-973f-f4ab5165e693'),
(3264,951,NULL,1787,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'a6925da7-5d11-4581-94d3-eea1dbceb565'),
(3265,3255,NULL,1788,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'ed1f1483-71dd-4017-b820-aa352dc2419f'),
(3266,3256,NULL,1789,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'099bdd28-edef-4603-8fa3-c74521ac9cfd'),
(3267,3257,NULL,1790,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'92047dd5-dec8-4ae3-9d86-cad05f375f02'),
(3268,3258,NULL,1791,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'045335df-424c-4979-ae80-535040f6ee9f'),
(3269,3259,NULL,1792,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'0a99e62f-d788-4324-9f38-34aad42587b4'),
(3270,3260,NULL,1793,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'974c7b3a-2d4f-4dec-8e8a-e1982e379a40'),
(3271,3261,NULL,1794,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'bfc41e73-5d62-4f56-8c15-4fb7d010d7e1'),
(3272,3262,NULL,1795,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'8e53431c-1e44-49d8-a41f-f14f4494c16b'),
(3273,3263,NULL,1796,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,'2026-01-16 15:16:13',NULL,'779f531d-dd18-47a1-998d-3fc8ca698806'),
(3275,951,NULL,1797,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:29:34','2025-10-08 22:29:34',NULL,NULL,NULL,'4cf2679c-1e0e-4e8d-ac48-26cbd4dd71c1'),
(3276,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:31','2025-10-08 22:32:31',NULL,NULL,NULL,'aca06e20-47e4-4040-8414-8b3f22ba5765'),
(3278,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:34','2025-10-08 22:32:34',NULL,NULL,NULL,'d156ddf6-c740-4d5b-b58e-a7f63b1effa7'),
(3279,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:35','2025-10-08 22:32:35',NULL,NULL,NULL,'4f48001b-13a2-4b9e-87a8-6b6209e7f9e2'),
(3280,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:37','2025-10-08 22:32:37',NULL,NULL,NULL,'c8cfa90c-a527-4ad9-a684-4de68ee14df5'),
(3281,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:38','2025-10-08 22:32:38',NULL,NULL,NULL,'d8ad29b5-965c-462d-b8a9-ee4d77b0155e'),
(3282,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:40','2025-10-08 22:32:40',NULL,NULL,NULL,'31fb1537-f558-483f-b21d-d697983bf9e6'),
(3283,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:41','2025-10-08 22:32:41',NULL,NULL,NULL,'b730aeaa-4638-4f08-b8ff-6de3ff1625d2'),
(3284,2880,NULL,1798,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:32:49','2025-10-08 22:32:49',NULL,NULL,NULL,'58f0cd84-0616-4aa1-af03-c08cdba9af77'),
(3286,2880,NULL,1799,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:18','2025-10-08 22:33:18',NULL,NULL,NULL,'427848f1-64a1-4f1c-9dcb-11e04c74dbee'),
(3292,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'33c86f5d-fcf9-4953-995e-0ae40ee2484e'),
(3293,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'faecdb87-ed68-4322-822f-c4c743e8c4ff'),
(3294,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'d2c3740c-ae0a-4a8b-bef7-754430631cda'),
(3295,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'18acd8a1-72cf-4c59-ae41-98d7d35dcce5'),
(3296,2880,NULL,1800,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'506cf3f6-e40f-4abf-80bb-4f3f2c66014c'),
(3297,3292,NULL,1801,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:46',NULL,NULL,NULL,'10b4c630-fa31-4051-b6c3-b4e94df607c9'),
(3298,3293,NULL,1802,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:46',NULL,NULL,NULL,'d1498675-49a4-43f4-adf9-2b1d2154356d'),
(3299,3294,NULL,1803,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:46',NULL,NULL,NULL,'9f5fea88-14c7-443e-a686-ef834ef6c758'),
(3300,3295,NULL,1804,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:46',NULL,NULL,NULL,'76907b6b-16e8-486f-be6d-4ae5620742af'),
(3303,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:34:45','2025-12-01 19:36:11',NULL,NULL,NULL,'d661a50d-4334-4ddb-81be-4bd4ac48c934'),
(3304,2880,NULL,1805,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:34:45','2025-10-08 22:34:45',NULL,NULL,NULL,'b73fa99b-9207-417a-8eb0-7195479484ad'),
(3305,3303,NULL,1806,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:34:45','2025-10-08 22:34:45',NULL,NULL,NULL,'850cf421-3270-4edb-aa4b-34a3557413c1'),
(3308,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:10','2025-10-08 22:35:10',NULL,NULL,NULL,'dc424e0e-0c44-4684-977b-6bbb15e03bae'),
(3309,2880,NULL,1807,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:10','2025-10-08 22:35:10',NULL,NULL,NULL,'8c8e9f9c-5a22-43ed-ab88-e0a63102b044'),
(3310,3308,NULL,1808,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:10','2025-10-08 22:35:10',NULL,NULL,NULL,'3cd5fa52-ec18-4ce2-8817-1ce0591b6548'),
(3316,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'8969d108-e7d5-4546-96c7-01326ddffe7b'),
(3317,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'36b4f8bc-082c-4c26-86fe-a5a5f01e024f'),
(3318,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'7b34198e-87ce-4d20-9421-e4f3ff211698'),
(3319,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'f773fd54-576e-4109-a8e5-f04b3e27935f'),
(3320,2880,NULL,1809,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'3a962400-24ea-4a9c-8472-3ff801ea24da'),
(3321,3316,NULL,1810,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:47',NULL,NULL,NULL,'6fc19b16-934e-495a-961a-dd5549b40cbf'),
(3322,3317,NULL,1811,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:47',NULL,NULL,NULL,'4efc2a03-eb60-4910-ad3f-2033d80152d6'),
(3323,3318,NULL,1812,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:47',NULL,NULL,NULL,'f30893d9-052e-42ee-896a-57854d88e1db'),
(3324,3319,NULL,1813,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:47',NULL,NULL,NULL,'1f24e35e-22a1-4e7b-878a-5ac10367ae21'),
(3335,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'7e8b5496-fedf-4a84-bd26-064fe6c1b823'),
(3336,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'5f114127-ecf5-4041-a894-9ac71e46daa1'),
(3337,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'4cee0710-f8bc-4b56-b361-9798733a7552'),
(3338,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'ed8efdf6-38db-4c67-b4cf-ec8edbfa9a81'),
(3339,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'97d938f6-1902-4675-8115-424195284649'),
(3340,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'5188fac9-9e32-48d1-9f3f-3d799283a888'),
(3341,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'47e4702d-6092-4623-9b1c-4ae764aa3ccb'),
(3342,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'856794d9-80d9-4788-bcf2-8860a036d87a'),
(3343,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'fd190f6f-3cf6-42d9-b3c9-671afd744f7a'),
(3344,1353,NULL,1814,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'22eac443-6e38-4647-bfcc-2ceed65d0cdf'),
(3345,3335,NULL,1815,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'18607dcf-65e1-41ad-989a-a815d4d8d52f'),
(3346,3336,NULL,1816,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'cac4758b-5a46-4fc2-b48d-770426c52c91'),
(3347,3337,NULL,1817,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'5750e4c6-f430-4e13-b15d-4115d7a5cb40'),
(3348,3338,NULL,1818,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'a10bdd20-d263-4f02-8ede-e0da2694cf55'),
(3349,3339,NULL,1819,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'f949e1ea-175c-4582-862b-73a418fa87f5'),
(3350,3340,NULL,1820,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'f56073cb-d456-4ea0-80e4-aedcac8152eb'),
(3351,3341,NULL,1821,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'70888f46-5ee1-4d3b-9694-8f4a56f09a9f'),
(3352,3342,NULL,1822,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'0334185d-fb7f-4679-80fe-7192e4313936'),
(3353,3343,NULL,1823,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'51a63420-3e24-4b8d-9641-92445926349a'),
(3356,1353,NULL,1824,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:45','2025-10-08 22:38:45',NULL,NULL,NULL,'9fb9ec2c-3156-491a-b7e8-c4ba46690569'),
(3357,1835,NULL,1825,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:45','2025-10-08 22:38:45',NULL,NULL,NULL,'b819b9d7-247e-45d7-9f34-6833e4417e06'),
(3359,1353,NULL,1826,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:40:25','2025-10-08 22:40:25',NULL,NULL,NULL,'ace0a890-89d0-4b09-9eb7-044c82db1153'),
(3362,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:49','2025-10-08 22:40:49',NULL,NULL,NULL,'1b4870ed-c6ab-486e-84e6-846e8c82c76c'),
(3363,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:50','2025-10-08 22:40:50',NULL,NULL,NULL,'91f91620-da2c-4c51-a168-96f9397c3a6f'),
(3364,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:50','2025-10-08 22:40:50',NULL,NULL,NULL,'ed703b69-c26d-4fba-ad46-061978e899a6'),
(3365,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:51','2025-10-08 22:40:51',NULL,NULL,NULL,'843bf451-ea46-4e9b-8b0a-f4bd4912be4c'),
(3366,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:52','2025-10-08 22:40:52',NULL,NULL,NULL,'6805b5fb-6934-4a9b-b066-e113dbd18328'),
(3367,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:53','2025-10-08 22:40:53',NULL,NULL,NULL,'4ea78724-356d-4120-8b75-4a8b6fb13915'),
(3368,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:54','2025-10-08 22:40:54',NULL,NULL,NULL,'3ea5d451-bdb3-42da-a846-c469b07af340'),
(3369,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:54','2025-10-08 22:40:54',NULL,NULL,NULL,'13f5695f-b44d-4804-aa0e-e68d4a79372f'),
(3370,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:56','2025-10-08 22:40:56',NULL,NULL,NULL,'3e8998bb-8848-4315-aecc-63e6f5c989f0'),
(3371,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:57','2025-10-08 22:40:57',NULL,NULL,NULL,'a8513575-6827-4572-9e6d-b8fee7475225'),
(3372,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:59','2025-10-08 22:40:59',NULL,NULL,NULL,'512e185b-aec6-4a21-ac73-5602efb36dc0'),
(3373,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:41:00','2025-10-08 22:41:00',NULL,NULL,NULL,'79ff754c-990d-424b-84bf-15780ecf449a'),
(3374,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:41:02','2025-10-08 22:41:02',NULL,NULL,NULL,'be86a4ca-1d97-4506-8e55-b23028646685'),
(3375,1353,NULL,1827,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:41:35','2025-10-08 22:41:35',NULL,NULL,NULL,'31e28523-5181-4da7-a3d1-16fc7a2d23d3'),
(3377,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 14:40:18','2025-10-09 14:40:35',NULL,NULL,NULL,'a2e401dd-b7b3-406b-92b7-949f212de674'),
(3378,989,NULL,1828,1,'craft\\elements\\Entry',1,0,'2025-10-09 14:50:00','2025-10-09 14:50:00',NULL,NULL,NULL,'95459cf8-461f-4440-8560-13f45fe6be2b'),
(3385,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'5bac949d-a46d-4ded-993b-e8b90806b96f'),
(3386,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'4a92b04b-d692-4ca9-a373-d08b3f8f29d9'),
(3387,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'346b8250-c6af-4afb-8789-c5178d2b80ac'),
(3388,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'fc121df5-eef0-4c66-87e5-65a2358a74e6'),
(3389,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'9f94b8e1-f51d-42aa-b8e4-816969d0c359'),
(3390,989,NULL,1829,1,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'c7f87614-9b3f-4bc3-b8ed-abf52036b258'),
(3391,3385,NULL,1830,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'3f979fa2-063f-431b-ad04-2de15edfe681'),
(3392,3386,NULL,1831,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'1651373a-2219-4a68-87be-aa1004d9d7af'),
(3393,3387,NULL,1832,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'a5562963-50b6-46b4-87d9-000a9c418bca'),
(3394,3388,NULL,1833,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'6feeb8eb-4364-4a77-9311-9e9998e30d76'),
(3395,3389,NULL,1834,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'2db1c4f1-8bbe-490b-9498-33c1f39dcae9'),
(3397,989,NULL,1835,1,'craft\\elements\\Entry',1,0,'2025-10-09 14:53:20','2025-10-09 14:53:20',NULL,NULL,NULL,'98b88d7d-b0bd-4610-86ce-e01dd79d2bf6'),
(3403,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:47',NULL,NULL,NULL,'3bd68452-554a-4b19-bb92-9b3254b147f8'),
(3404,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:47',NULL,NULL,NULL,'77c79f40-cdc4-4454-8f77-4a21643d469a'),
(3405,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:47',NULL,NULL,NULL,'c1abf041-a20f-4494-b980-820bb73e3181'),
(3406,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:47',NULL,NULL,NULL,'4d1f6694-bd10-4010-a9fd-25d0736178a8'),
(3407,989,NULL,1836,1,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:47',NULL,NULL,NULL,'b47e0b82-e853-4dbd-87ed-94bb923deb18'),
(3408,3403,NULL,1837,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:47',NULL,NULL,NULL,'3cdb861b-fedf-43ed-910c-e714482161eb'),
(3409,3404,NULL,1838,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:48',NULL,NULL,NULL,'ebcc1ea3-645d-4894-a35a-e77961f17810'),
(3410,3405,NULL,1839,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:48',NULL,NULL,NULL,'1eb85fd3-d2c5-4c69-9ec5-840d2de21ace'),
(3411,3406,NULL,1840,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:48',NULL,NULL,NULL,'f3fd0b74-beb2-4158-800f-46ae81c9d342'),
(3413,989,NULL,1841,1,'craft\\elements\\Entry',1,0,'2025-10-09 14:58:54','2025-10-09 14:58:54',NULL,NULL,NULL,'d1e2ed20-5672-41f3-a7e6-e6c7541673ba'),
(3416,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 14:59:18','2025-10-09 14:59:18',NULL,NULL,NULL,'3985500b-f08c-43c8-b70f-dc76d06625b0'),
(3418,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 14:59:46','2025-10-09 14:59:46',NULL,NULL,NULL,'7183b6ff-7b93-4eab-a229-f0afc34b7046'),
(3419,989,NULL,1842,1,'craft\\elements\\Entry',1,0,'2025-10-09 14:59:55','2025-10-09 14:59:55',NULL,NULL,NULL,'6a86f8b8-cab6-4b2f-9772-b601393b4b89'),
(3420,1531,NULL,1843,2,'craft\\elements\\Entry',1,0,'2025-10-09 14:59:55','2025-10-09 14:59:55',NULL,NULL,NULL,'be0cdc78-0a56-4fb8-b998-077d76bce9ed'),
(3421,1532,NULL,1844,2,'craft\\elements\\Entry',1,0,'2025-10-09 14:59:55','2025-10-09 14:59:55',NULL,NULL,NULL,'c6bfc81e-7e24-4cfb-98a0-4823f26ea794'),
(3423,989,NULL,1845,1,'craft\\elements\\Entry',1,0,'2025-10-09 15:36:03','2025-10-09 15:36:03',NULL,NULL,NULL,'a770cda6-6715-42dc-a2ff-81a9751877cc'),
(3425,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 16:20:09','2025-10-09 16:20:23',NULL,NULL,NULL,'018ea585-8010-473e-8a32-4cbf4cbcaa10'),
(3431,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'4e1ee282-f15e-4d54-b4ed-395c31690453'),
(3432,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'25ed1b2e-0d99-4a29-b676-7951432f185c'),
(3433,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'fa0d710a-774d-4738-a884-92160e5d37d2'),
(3434,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'e82ca79b-0c06-43aa-919d-09538cba2d7d'),
(3435,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'b714b652-80d9-4f2c-a384-b970473e83a8'),
(3436,995,NULL,1846,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'2b77ad52-3fad-4488-9afe-680a7460cb0a'),
(3437,3431,NULL,1847,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'fed601b6-7f01-48b4-8fdd-8480a5f9b22e'),
(3438,3432,NULL,1848,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'08cc0e9e-b059-4903-b539-b0276500ad1d'),
(3439,3433,NULL,1849,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'42f70d31-eb8e-4050-b044-804ba67695e6'),
(3440,3434,NULL,1850,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'36bdf469-91a3-4835-8264-72328ce9663d'),
(3441,3435,NULL,1851,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'f4806e7b-fe6e-49d3-9e5f-847308966bb8'),
(3443,995,NULL,1852,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:29:17','2025-10-09 16:29:17',NULL,NULL,NULL,'7a1cee7a-e42f-4a3d-8d4c-19c3d85ae593'),
(3450,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'42f9236b-0437-42af-9478-7d80b9fe4e82'),
(3451,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'2400b99c-4ac8-4cc5-8621-320562393f18'),
(3452,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'b0562da9-378f-4add-a6ec-bee759a2c9fe'),
(3453,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'617e20cb-c418-49d2-a76b-c27e14350fc5'),
(3454,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'6e7681e6-8d64-48f6-bfe7-f05cb4750f1b'),
(3455,995,NULL,1853,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'8841635f-8616-4039-b5af-7ff7c38f1299'),
(3456,3450,NULL,1854,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'44822184-b243-481f-bea2-c3384026dc78'),
(3457,3451,NULL,1855,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'838c8104-853e-4a22-b101-0ef35d9a9440'),
(3458,3452,NULL,1856,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'df7ff97c-8bc6-4b0e-9559-bf97c46a2e6c'),
(3459,3453,NULL,1857,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'422a6c5d-be6e-408f-ab85-1e09d3afa186'),
(3460,3454,NULL,1858,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'a8c076f1-3128-4686-8cea-198a6863bc3e'),
(3463,995,NULL,1859,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:31:32','2025-10-09 16:31:32',NULL,NULL,NULL,'9e3e7b94-90a6-4eaa-877a-a0fe54290128'),
(3464,1536,NULL,1860,2,'craft\\elements\\Entry',1,0,'2025-10-09 16:31:32','2025-10-09 16:31:32',NULL,NULL,NULL,'72a36f56-4453-4270-a196-ea6835c3fd89'),
(3465,995,NULL,1861,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:31:37','2025-10-09 16:31:37',NULL,NULL,NULL,'fad055cd-029c-49ca-afa0-fd45132c8b9b'),
(3467,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 16:32:33','2025-10-09 16:32:41',NULL,NULL,NULL,'ff247821-2679-45c4-a657-fe1bb5d3dcb2'),
(3468,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-09 16:33:29','2026-01-17 19:31:25',NULL,NULL,NULL,'6360faac-521b-40ee-8abd-0fba7e83f8e8'),
(3469,3468,NULL,1862,5,'craft\\elements\\Entry',1,0,'2025-10-09 16:33:43','2025-10-09 16:33:43',NULL,NULL,NULL,'f1830387-fd43-48a3-9c57-0b43a76ece7e'),
(3471,2974,NULL,1863,5,'craft\\elements\\Entry',1,0,'2025-10-09 16:34:57','2025-10-09 16:34:57',NULL,NULL,NULL,'20c02a0d-6596-4748-a355-2a519fc45bb7'),
(3472,999,NULL,1864,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:34:59','2025-10-09 16:34:59',NULL,NULL,NULL,'d0df8df0-d3a5-410d-aab7-e2ba46c34bac'),
(3479,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'9f84783a-7d61-4ab7-baeb-b99817079b5f'),
(3480,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'1d8b1a93-7f28-4a6d-b5ff-051afe358f44'),
(3481,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'c368d4ba-d32b-4567-99e4-5b4daf8b8c1a'),
(3482,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'0af9bec1-fe2f-4691-9628-30aa98d8abcf'),
(3483,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'79d4af48-b026-48a4-bd94-1aa8c27e4fdd'),
(3484,999,NULL,1865,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'ad1e1457-b031-4c04-88a0-b1e6d7f65521'),
(3485,3479,NULL,1866,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'58cd5e75-de1d-44a2-a7ef-03d5812de62a'),
(3486,3480,NULL,1867,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'91c7cbfc-3e92-4ac4-a85b-1b5f40625a7a'),
(3487,3481,NULL,1868,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'e2553962-27d2-47c4-826a-ee1df376933d'),
(3488,3482,NULL,1869,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'3c83e31c-d901-4df2-ad9d-702ad7d6df88'),
(3489,3483,NULL,1870,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'d4ba0c40-16c5-4b05-a735-9256efa7ed3e'),
(3491,999,NULL,1871,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:52','2025-10-09 16:36:52',NULL,NULL,NULL,'e85dd643-ad35-494f-8440-e9ef7ad2db20'),
(3494,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 16:37:14','2025-10-09 16:37:14',NULL,NULL,NULL,'beb72bf0-7900-478a-a858-6a6fc664a24f'),
(3495,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 16:37:24','2025-10-09 16:37:50',NULL,NULL,NULL,'b4c6ff02-f95d-4291-9840-29837cb64bfc'),
(3498,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 16:38:58','2025-10-09 16:39:11',NULL,NULL,NULL,'6b60157f-fd52-46ea-aad4-2d078a788dc4'),
(3499,1005,NULL,1872,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:40:04','2025-10-09 16:40:04',NULL,NULL,NULL,'9a3f4d62-6d94-448c-843e-2147d2e8e81a'),
(3507,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'fc45669f-48b3-4943-a77e-9dd4730acf75'),
(3508,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'10e57df8-098e-4525-98c3-7c0dc1ebd0c9'),
(3509,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'4714385a-c300-44d9-b595-a8b88508f7d1'),
(3510,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'5345b10d-db17-4f93-96ec-4ce3590bd774'),
(3511,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'c895075f-f08f-4889-9b39-6e85151d1e38'),
(3512,1005,NULL,1873,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'502af62e-1034-4287-8e87-7c3cfbf54c75'),
(3513,3507,NULL,1874,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'83c45288-512c-4457-b230-7ba60acbf47d'),
(3514,3508,NULL,1875,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'1896a8ac-f85e-4452-8ea5-c994c2d2774b'),
(3515,3509,NULL,1876,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'dabc496b-5f20-4d5d-8f61-630a793bf332'),
(3516,3510,NULL,1877,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'6b744f56-c1cd-4035-854e-19c296f39f95'),
(3517,3511,NULL,1878,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'bb5c4b90-761d-47fb-b7f8-c52cf34d7711'),
(3522,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:54','2025-10-09 16:42:54',NULL,NULL,NULL,'62b9a044-3045-4689-9eb4-6acd4dc246b9'),
(3523,1005,NULL,1879,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:54','2025-10-09 16:42:54',NULL,NULL,NULL,'86f88adb-9bd3-4eb4-8339-dd0590ea6c9d'),
(3524,3522,NULL,1880,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:54','2025-10-09 16:42:55',NULL,NULL,NULL,'26d90215-18b6-4521-899c-a53a72505960'),
(3525,1544,NULL,1881,2,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:54','2025-10-09 16:42:55',NULL,NULL,NULL,'1399a021-fdce-4929-bebd-f6816d25f48d'),
(3526,1545,NULL,1882,2,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:54','2025-10-09 16:42:55',NULL,NULL,NULL,'23083187-842c-4388-96bd-6aabe1c82135'),
(3528,1005,NULL,1883,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:58','2025-10-09 16:42:58',NULL,NULL,NULL,'3ece6770-fc81-4117-93f7-4bccb79d1a1a'),
(3530,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 17:00:32','2025-10-09 17:00:45',NULL,NULL,NULL,'2db95d6d-ff0a-4793-835b-0ec3f007dd80'),
(3536,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'2be6d69f-9e6b-47d5-9a9a-735e1bc79444'),
(3537,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'519e1278-392f-4f7f-9b4d-1da82fad2e41'),
(3538,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'b5b3a93b-5780-4f0c-b13c-c785f787703d'),
(3539,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'aec81209-1e67-41c2-a9a3-42231a4aaecc'),
(3540,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'7024f509-7283-487c-b25d-ae771a445bce'),
(3541,1011,NULL,1884,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'936cb6f7-0696-4317-998e-0320ff451e65'),
(3542,3536,NULL,1885,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'c09ab8eb-1da5-4561-ad37-1ea9b797dd29'),
(3543,3537,NULL,1886,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'aee9273d-1b8d-435a-a35f-5e6bf04b277f'),
(3544,3538,NULL,1887,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'3d7b0d40-04ea-41c1-940c-5182bd1c57e9'),
(3545,3539,NULL,1888,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'4c008831-1c17-49c3-badc-4ed3cc247d33'),
(3546,3540,NULL,1889,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'773453b3-9468-4506-9832-d5c2e55bf38e'),
(3548,1011,NULL,1890,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:34','2025-10-09 17:04:34',NULL,NULL,NULL,'e02ea7ab-c0e9-4ce7-8d04-a64f08ad9329'),
(3554,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'aed77a2c-a9c4-4415-ba89-5d6033d2f17e'),
(3555,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'fc7b17cd-dcd3-4d3b-88cc-8443cf4e19d9'),
(3556,1011,NULL,1891,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'0c2275ef-4ee0-4387-a539-358ad5ba6241'),
(3557,3554,NULL,1892,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'b587a532-0eb9-4463-885b-4fa8cd98e591'),
(3558,3555,NULL,1893,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'53405e28-e2b1-4795-8667-ae230d821d7c'),
(3559,1549,NULL,1894,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'7a544893-34d6-4a56-ad3f-31e0688a8b90'),
(3560,1550,NULL,1895,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,'2025-11-17 16:45:42',NULL,'21d3b4da-9469-4ca1-b5a0-b3626be0c36c'),
(3562,1011,NULL,1896,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:54','2025-10-09 17:05:54',NULL,NULL,NULL,'f9a1716d-354f-469a-9c4a-c327f2d99eb5'),
(3564,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 17:07:07','2026-01-13 21:24:54',NULL,NULL,NULL,'f2572e55-c9ee-4124-9840-49f254d6f40c'),
(3565,1017,NULL,1897,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:07:55','2025-10-09 17:07:55',NULL,NULL,NULL,'d673b3e0-080a-4bd2-9be2-8ccfbe80de0e'),
(3572,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'6b004649-7dd6-4e35-9ee0-2cc48c42f26c'),
(3573,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'93585b8d-e411-48a8-978e-bd28d3ce188f'),
(3574,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'6ac64390-099f-402e-a69c-ceefd1e221cd'),
(3575,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'69bcd4a2-ba7f-4fe6-af26-332a6dcc199f'),
(3576,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'cbdb13cb-770f-4204-83b1-998acdaf45a7'),
(3577,1017,NULL,1898,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:20','2025-10-09 17:09:21',NULL,NULL,NULL,'3b3b5d70-131a-4ca3-87de-a783a7ea6dcd'),
(3578,3572,NULL,1899,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'debfc912-7805-4c9b-a73f-4e8adcc1295f'),
(3579,3573,NULL,1900,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'cf05b33e-92bf-4ec8-9da5-1d66762cecdd'),
(3580,3574,NULL,1901,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'c8ca3b57-4820-4388-8f51-5c667145c61c'),
(3581,3575,NULL,1902,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'df8f2faf-ce48-4b97-8607-c75977adeeb1'),
(3582,3576,NULL,1903,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'43e6435f-8600-4946-9528-bafffdc90196'),
(3584,1017,NULL,1904,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:46','2025-10-09 17:09:46',NULL,NULL,NULL,'7009fb8f-6366-485f-b4c2-bec683eddd24'),
(3588,1017,NULL,1905,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:10:15','2025-10-09 17:10:15',NULL,NULL,NULL,'f06119df-74ff-47c7-98c3-a97b42e4931f'),
(3589,1554,NULL,1906,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:10:15','2025-10-09 17:10:15',NULL,NULL,NULL,'e9c802f0-87b6-4c6b-ad35-1b26c3d8c2f6'),
(3590,1555,NULL,1907,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:10:15','2025-10-09 17:10:15',NULL,NULL,NULL,'27202baa-93e7-44ec-992f-bee3f3248c7c'),
(3592,1017,NULL,1908,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:10:31','2025-10-09 17:10:31',NULL,NULL,NULL,'a61bd919-ae1b-4502-82d2-aa2f525d25d9'),
(3594,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 17:14:28','2025-10-09 17:14:28',NULL,NULL,NULL,'9325eeb8-d4a9-4b68-9f2a-0e950de6e020'),
(3595,1023,NULL,1909,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:15:09','2025-10-09 17:15:09',NULL,NULL,NULL,'c4d61382-7e69-4f77-ba12-ba6b4f74823f'),
(3602,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'83b4c63d-163b-4af6-b7aa-e2c71ed8fe48'),
(3603,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'65f35979-f914-4575-a85e-6297670c5425'),
(3604,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'191a6adb-1b50-4a0b-af97-875245ef6f30'),
(3605,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'af6de89f-16c4-4e8d-b17b-f3265900ec21'),
(3606,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'f426352c-0b46-4f31-8c43-89c4f8f367d4'),
(3607,1023,NULL,1910,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'10f20865-f5f1-4d81-9c2a-f89547ed967e'),
(3608,3602,NULL,1911,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'3f75b37a-ca01-4299-9b7a-27da85af1cdd'),
(3609,3603,NULL,1912,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'1a6b88bd-ff9b-4749-b57c-e29b0716bccd'),
(3610,3604,NULL,1913,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'2c045287-9291-417b-a2ad-7a8eab8ddf24'),
(3611,3605,NULL,1914,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'22c4cba5-0022-498e-997f-fba26c88857d'),
(3612,3606,NULL,1915,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'0f8bc432-f8e3-4807-96b3-c8f51119fa12'),
(3614,1023,NULL,1916,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:20:03','2025-10-09 17:20:03',NULL,NULL,NULL,'83f93676-b07a-4ea4-889f-b117a847f620'),
(3619,1023,NULL,1917,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:20:39','2025-10-09 17:20:39',NULL,NULL,NULL,'8bc35f00-de8b-4f25-9b19-cc5d8f11b7ed'),
(3620,1560,NULL,1918,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:20:39','2025-10-09 17:20:39',NULL,NULL,NULL,'273121de-3639-44f6-852e-8ff17b221f06'),
(3621,1561,NULL,1919,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:20:39','2025-10-09 17:20:39',NULL,NULL,NULL,'0c98bb03-bdb3-40ed-9932-56c5a040eda6'),
(3623,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 17:21:43','2025-10-09 17:21:43',NULL,NULL,NULL,'82cfca8f-97c7-467d-b8fe-3ff831048619'),
(3624,1035,NULL,1920,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:22:03','2025-10-09 17:22:03',NULL,NULL,NULL,'d821524c-aa33-4879-b1e0-94a8b3096d8c'),
(3631,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'e0473c9a-8dc4-4dd4-96cd-71f0ff33e710'),
(3632,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'764a21ea-21d6-4e58-9db2-28ea928b0ab4'),
(3633,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'cf214155-f2a3-4395-8a9a-3e94f01cbc71'),
(3634,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'3e9053ab-6a78-434b-b90e-c1c37f81ca5c'),
(3635,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'bffadf16-9f4e-4c0b-83d3-4a03e07642ac'),
(3636,1035,NULL,1921,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'fe9c5e3c-8a91-4532-9511-d3be444a7c75'),
(3637,3631,NULL,1922,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'533e5584-a87c-49ca-87a4-17e2d12f8457'),
(3638,3632,NULL,1923,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'5a9587e6-6ec8-461d-8b94-d507e76b2df5'),
(3639,3633,NULL,1924,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'554c8035-77c5-42c3-9d66-0782a38018c8'),
(3640,3634,NULL,1925,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'23d2da06-7427-43e0-bd07-870d8cb082a4'),
(3641,3635,NULL,1926,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'8889c84a-72a5-4ed3-aaa6-34416465f0f4'),
(3643,1035,NULL,1927,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:52','2025-10-09 17:23:52',NULL,NULL,NULL,'a686888e-1b3e-4059-9a94-921649b5b248'),
(3648,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 17:24:29','2025-10-09 17:24:29',NULL,NULL,NULL,'24d5cd55-7d2b-4b59-b95d-60928fa86e7b'),
(3649,1035,NULL,1928,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:24:35','2025-10-09 17:24:35',NULL,NULL,NULL,'bad36670-6774-46a0-ba4a-63c9ce04fa74'),
(3650,1569,NULL,1929,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:24:35','2025-10-09 17:24:35',NULL,NULL,NULL,'925e98b4-bea5-4ae5-a2c8-9f07b170f101'),
(3651,1570,NULL,1930,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:24:35','2025-10-09 17:24:35',NULL,NULL,NULL,'38fac39a-bd5c-44e2-ac06-3792f1349712'),
(3653,1035,NULL,1931,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:24:37','2025-10-09 17:24:37',NULL,NULL,NULL,'b24dddf9-9cbd-4124-a2b5-efe1cd78dd23'),
(3655,1041,NULL,1932,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:26:17','2025-10-09 17:26:17',NULL,NULL,NULL,'d23c112a-cd19-424b-a718-93339f4ea328'),
(3662,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'82f02427-89ac-42ca-a344-0a3201c419c1'),
(3663,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'077f62b5-f904-4ba5-aad5-f4e9958226f3'),
(3664,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'e2345b31-a63a-47cd-a911-400bc682a2b9'),
(3665,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'b55a3112-bb5c-4f63-a864-464d7c5abe61'),
(3666,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'a201c89c-8475-45fa-9c4d-6e611b2afeb0'),
(3667,1041,NULL,1933,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'39e9a434-aa55-4eab-933a-fdf7a092f557'),
(3668,3662,NULL,1934,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'6ecf7d35-bc6e-49c0-9dfd-a99658ea5e8c'),
(3669,3663,NULL,1935,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'e80a19e6-6d3e-4b21-9827-059eba9a76c3'),
(3670,3664,NULL,1936,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'e6587b13-c9e7-423f-8386-d4ba61f6dc88'),
(3671,3665,NULL,1937,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'852392e0-12f5-4bc9-aff3-cf0c29bf15cc'),
(3672,3666,NULL,1938,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'9d59247f-4108-4b81-b04c-b26d0bcbb21b'),
(3674,1041,NULL,1939,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:28:11','2025-10-09 17:28:11',NULL,NULL,NULL,'e30fdf49-4123-42f9-8b86-5f091a8e801e'),
(3680,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'42bbd2a8-0093-49d4-909e-ac7afc87c2a1'),
(3681,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'cc514d58-4f97-49df-aeee-0970a4399a03'),
(3682,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'205f4452-72b0-40e5-a79b-a9bf0b788ab3'),
(3683,1041,NULL,1940,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'2cd72ad9-125c-4125-b7c5-2e21cc70235f'),
(3684,3680,NULL,1941,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'a140f62a-97c4-4267-8ed5-fa6304f5959d'),
(3685,3681,NULL,1942,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'4a5fe42d-85b9-49be-aa7f-67e0dd3371fb'),
(3686,3682,NULL,1943,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'21163904-7fb7-4895-9036-07ff25ecbd26'),
(3687,1574,NULL,1944,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'824bd24a-48d0-4b18-9f7d-442ae8312d3a'),
(3689,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 20:42:59','2026-01-14 16:18:34',NULL,NULL,NULL,'5e9e3676-39c2-40bb-8c72-4205cc2f1c20'),
(3690,1045,NULL,1945,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:44:20','2025-10-09 20:44:20',NULL,NULL,NULL,'f658dd75-296f-4a6e-ab6c-e0875cd93fc9'),
(3697,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:06','2026-01-08 19:57:40',NULL,NULL,NULL,'2f64c502-d62e-473b-9c08-ed80c734ebb9'),
(3698,3697,NULL,1946,6,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:21','2025-10-09 20:46:21',NULL,NULL,NULL,'498d04f5-1cc4-4daf-b7c7-284be8832ef7'),
(3699,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'e6cedecd-f1fb-4d88-8ede-46530b968f44'),
(3700,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'90146cdd-a8ca-4768-bd1c-172dbdae13a7'),
(3701,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'40ccec75-c670-4aba-9538-a1f67be5e416'),
(3702,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'d5944596-326a-4f16-826a-00c570db5227'),
(3703,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'466023f5-cb24-457a-942e-0ef314e26a69'),
(3704,1045,NULL,1947,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'86975381-4c63-4971-a439-93f548c4c6f9'),
(3705,3699,NULL,1948,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'b2a37535-336b-407c-beb8-0b841d44b14e'),
(3706,3700,NULL,1949,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'e4dd54fd-dc52-47b8-8018-4b3baade799f'),
(3707,3701,NULL,1950,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'14d932c5-2dd1-4723-9216-3250beeee07b'),
(3708,3702,NULL,1951,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'f8a71d94-23a1-4b16-be2d-f77e5718226d'),
(3709,3703,NULL,1952,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'31ae445d-4c5b-42a8-84f2-a5879ffbc60a'),
(3712,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 20:47:03','2025-10-09 20:47:03',NULL,NULL,NULL,'7608abe9-1b42-4396-ac87-548b8b3015cb'),
(3714,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 20:48:06','2025-10-09 20:48:06',NULL,NULL,NULL,'75da13cc-3b53-4ae3-ab40-e82046bd6efe'),
(3716,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:48:21','2025-10-09 20:48:21',NULL,NULL,NULL,'abd5fc75-96fb-4bfe-b8d3-3b2dc279ceb2'),
(3717,1045,NULL,1953,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:48:21','2025-10-09 20:48:21',NULL,NULL,NULL,'f00f71de-7603-4ba4-9742-4cdb5d04edd1'),
(3718,3716,NULL,1954,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:48:21','2025-10-09 20:48:21',NULL,NULL,NULL,'e6645617-9c73-4faa-aae1-f5426fcb856c'),
(3719,1577,NULL,1955,2,'craft\\elements\\Entry',1,0,'2025-10-09 20:48:21','2025-10-09 20:48:21',NULL,NULL,NULL,'326c24a9-6977-42bd-99c4-4be43d62af50'),
(3720,1578,NULL,1956,2,'craft\\elements\\Entry',1,0,'2025-10-09 20:48:21','2025-10-09 20:48:21',NULL,NULL,NULL,'1654ac97-add2-4f38-b6e9-f2285798e514'),
(3722,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 20:50:40','2026-01-14 16:26:23',NULL,NULL,NULL,'64cbbe56-a0ee-4bd5-9ea1-7d0444fda32b'),
(3723,1051,NULL,1957,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:52:58','2025-10-09 20:52:58',NULL,NULL,NULL,'9f878777-6985-447c-9183-bbdd4902dd54'),
(3730,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'65cf2e2b-45be-4029-b547-cd53c0904306'),
(3731,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'89f2f03a-4f72-4572-8e77-9385e0a461fc'),
(3732,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'a0008e56-ea4b-48c6-be5a-d52f1c80998f'),
(3733,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'fc290ac5-ff1e-403d-b23a-5266f398e50f'),
(3734,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'d9484c43-1e06-42ea-be7f-d1c69eb8549c'),
(3735,1051,NULL,1958,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'e10f9975-5f28-4e1c-9c54-c6cab82bf1a0'),
(3736,3730,NULL,1959,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'ba8e7849-101c-4460-b79f-c2a6828b13a1'),
(3737,3731,NULL,1960,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'690fbcd1-aa27-4058-940d-3b640d4bd401'),
(3738,3732,NULL,1961,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:28',NULL,NULL,NULL,'10d16818-acd2-4414-9449-deab38c6d8fb'),
(3739,3733,NULL,1962,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:28',NULL,NULL,NULL,'d5e8cb70-16da-466e-9bb8-b5db30171ccb'),
(3740,3734,NULL,1963,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:28',NULL,NULL,NULL,'46976404-d587-4364-a3d6-7bd3aefcec75'),
(3742,1051,NULL,1964,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:48','2025-10-09 20:54:48',NULL,NULL,NULL,'fbbe05e1-dfb8-4849-b18a-a31183d1f04a'),
(3746,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 20:55:28','2025-10-09 20:55:28',NULL,NULL,NULL,'fe81bf01-cb45-4d27-8b33-eb39a7088c2f'),
(3748,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 20:55:46','2025-10-09 20:55:46',NULL,NULL,NULL,'08d72cdd-d6ce-40ac-9ccc-48e5b4197042'),
(3749,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:56:04','2025-10-09 20:56:04',NULL,NULL,NULL,'d0bf0ca5-975c-4005-8fa4-95e2e7dbd174'),
(3750,1051,NULL,1965,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:56:04','2025-10-09 20:56:04',NULL,NULL,NULL,'605f03b2-1d79-4669-a87d-73acca795559'),
(3751,3749,NULL,1966,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:56:04','2025-10-09 20:56:04',NULL,NULL,NULL,'201b063e-b97f-4bfb-82a0-ab5e108d773d'),
(3752,1583,NULL,1967,2,'craft\\elements\\Entry',1,0,'2025-10-09 20:56:04','2025-10-09 20:56:04',NULL,NULL,NULL,'9efb0b6d-6759-43a5-a414-ac7796470e8e'),
(3753,1584,NULL,1968,2,'craft\\elements\\Entry',1,0,'2025-10-09 20:56:04','2025-10-09 20:56:04',NULL,NULL,NULL,'3703bab7-21e7-4323-97ca-76ed272dd348'),
(3755,1353,NULL,1969,1,'craft\\elements\\Entry',1,0,'2025-10-10 18:22:08','2025-10-10 18:22:08',NULL,NULL,NULL,'2eeb28ba-66c1-434d-9d55-24b3b258edd4'),
(3757,951,NULL,1970,1,'craft\\elements\\Entry',1,0,'2025-10-10 18:22:39','2025-10-10 18:22:39',NULL,NULL,NULL,'7c883abd-42b2-4ff7-acd8-8753471d25dd'),
(3759,2880,NULL,1971,1,'craft\\elements\\Entry',1,0,'2025-10-10 18:22:50','2025-10-10 18:22:51',NULL,NULL,NULL,'5d68b813-7384-4f4d-b26d-c4ef1b1b2924'),
(3761,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 15:57:58','2025-10-13 15:57:58',NULL,NULL,NULL,'5b1cf97e-925b-4eec-8d9f-60c115190faa'),
(3762,1059,NULL,1972,1,'craft\\elements\\Entry',1,0,'2025-10-13 15:58:53','2025-10-13 15:58:54',NULL,NULL,NULL,'b0141dd7-8d60-41f3-9748-75cf10ce6019'),
(3769,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'332f9153-1705-40d1-9660-9531c97dbd01'),
(3770,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'ed107e8c-0bb1-4a2b-883d-bd53ad0119eb'),
(3771,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'bae68c7d-0fe2-4291-af85-b8d3ce8a73e5'),
(3772,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'68ddda38-a8e1-46b6-8b94-5a72981d2553'),
(3773,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'660f782e-af0a-4824-9f53-db5f852d784f'),
(3774,1059,NULL,1973,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'a475f88a-023e-4306-959d-76152549d02a'),
(3775,3769,NULL,1974,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'94ebe8bb-d88e-495b-b253-2ec0bed08b10'),
(3776,3770,NULL,1975,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'f94b32be-a1db-40b1-b5f0-123a2cd3328f'),
(3777,3771,NULL,1976,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'8102b0b3-ba4d-4154-957d-fd6ff74a271b'),
(3778,3772,NULL,1977,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'e3210c99-b7f8-4202-bb7a-e87750927e52'),
(3779,3773,NULL,1978,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'cdf459e9-7fb4-45cf-a527-662247547845'),
(3781,1059,NULL,1979,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:53','2025-10-13 16:00:53',NULL,NULL,NULL,'237222d7-84b1-478f-99f5-ffd5b1543e41'),
(3785,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:01:40','2025-10-13 16:01:40',NULL,NULL,NULL,'7726370e-2ffa-4012-bf0c-50863a42f7fc'),
(3786,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:01:40','2025-10-13 16:01:40',NULL,NULL,NULL,'9f3aa730-a932-43b3-8f56-da7b7d1af718'),
(3787,1059,NULL,1980,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:01:40','2025-10-13 16:01:41',NULL,NULL,NULL,'975dfeb3-7000-45e0-9293-269deba10a06'),
(3788,3785,NULL,1981,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:01:40','2025-10-13 16:01:41',NULL,NULL,NULL,'7ce9a21d-bc07-4dfd-a6b0-aecdacee80a8'),
(3789,3786,NULL,1982,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:01:40','2025-10-13 16:01:41',NULL,NULL,NULL,'034de22f-82dd-4f4b-b240-4ed5f645a52b'),
(3793,1059,NULL,1983,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:02:33','2025-10-13 16:02:33',NULL,NULL,NULL,'3790074b-da9f-4ce4-bfb7-b6cda24aff4b'),
(3794,1590,NULL,1984,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:02:33','2025-10-13 16:02:33',NULL,NULL,NULL,'13a12d41-4e97-495e-973c-98b52d95ccfb'),
(3795,1591,NULL,1985,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:02:33','2025-10-13 16:02:33',NULL,NULL,NULL,'2f2be886-c813-46fe-ac6d-2eb7c884fd93'),
(3797,1059,NULL,1986,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:02:37','2025-10-13 16:02:37',NULL,NULL,NULL,'84670b37-732f-4463-87ab-0c456e766d36'),
(3800,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 16:03:32','2025-10-13 16:03:42',NULL,NULL,NULL,'6a8222df-62d7-40e4-9fd0-463dfcd4aed8'),
(3802,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 16:04:02','2025-10-13 16:04:02',NULL,NULL,NULL,'23e420f1-728b-4627-8617-ace60ec827f5'),
(3803,1067,NULL,1987,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:04:07','2025-10-13 16:04:07',NULL,NULL,NULL,'0470595f-7a58-4003-a3aa-e650cc6065ad'),
(3804,1596,NULL,1988,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:04:07','2025-10-13 16:04:07',NULL,NULL,NULL,'df7b6042-efab-4725-9682-3646a23bbc63'),
(3805,1597,NULL,1989,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:04:07','2025-10-13 16:04:07',NULL,NULL,NULL,'dc2ad204-8498-485b-add3-c08b6e40c69f'),
(3808,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 16:05:35','2026-01-14 16:44:22',NULL,NULL,NULL,'1e09a858-3639-49cf-bb25-9daec6ae56a6'),
(3814,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'cd08b48b-c54a-4049-8d38-c94a70086fa0'),
(3815,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'dc3d7ee6-2887-486f-acd3-5cdc0b3c9010'),
(3816,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'61a09bbb-c305-49c1-bd0e-80ce618ecfe2'),
(3817,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'ba34f517-2422-42f5-bee9-5cb10173bea9'),
(3818,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'180b7503-1a32-4e78-8272-4cedebfc42ca'),
(3819,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'1a64a325-0fa1-42da-9738-27dbce6952b0'),
(3820,1067,NULL,1990,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'c2994a54-13d2-40e6-b3ef-60ef4503bad9'),
(3821,3814,NULL,1991,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'6d1f66ba-6623-4b5e-ab3b-a4f1a0319a2a'),
(3822,3815,NULL,1992,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'fd8dc983-5af0-4dd3-bd9c-59d2a79f04a9'),
(3823,3816,NULL,1993,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'a60012b7-b41c-4e23-9986-a8374fee3682'),
(3824,3817,NULL,1994,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'3d7a3f43-5af4-457a-8e56-c5b65e28cdda'),
(3825,3818,NULL,1995,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'9552b841-31b5-4b39-ada2-efb681ba4907'),
(3826,3819,NULL,1996,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'790628a2-8962-4ce2-bef2-ca4f794290de'),
(3828,1067,NULL,1997,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:45','2025-10-13 16:07:45',NULL,NULL,NULL,'b8e85a9f-6ef1-463c-b618-a32a7e5c5fde'),
(3830,1067,NULL,1998,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:08:14','2025-10-13 16:08:14',NULL,NULL,NULL,'db54389b-6111-4521-bff1-ebf01626a6ad'),
(3833,1079,NULL,1999,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:12:15','2025-10-13 16:12:15',NULL,NULL,NULL,'de70c0c4-8783-4138-9f41-f4da79a39de6'),
(3840,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'c417b84c-a022-4d92-97d6-b5da8da0961a'),
(3841,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'3d0ee3d6-d528-4815-a861-f4f3f978fcb6'),
(3842,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'ce6e5f74-605f-4e97-a68f-2ca27f15f139'),
(3843,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'87a557b3-8da6-4906-9bd8-613191234553'),
(3844,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'0033ecc9-0e0b-4ff4-82fa-1cabb8e40ecd'),
(3845,1079,NULL,2000,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'f1d699ef-7ea3-4105-87b2-51c46485fe44'),
(3846,3840,NULL,2001,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'99bdecaf-7790-4aea-b8f5-3fbfeb303d54'),
(3847,3841,NULL,2002,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'f4f162df-b217-4938-b8f2-3bad8e94da71'),
(3848,3842,NULL,2003,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'06555db2-21a1-47b0-8e9c-7e2b5a363d1f'),
(3849,3843,NULL,2004,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'b4741a4b-fd4f-414e-849e-410546b5b878'),
(3850,3844,NULL,2005,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'1a782033-b50a-40a0-a5df-ff0c9c35ab80'),
(3852,1079,NULL,2006,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:14:29','2025-10-13 16:14:30',NULL,NULL,NULL,'22044155-52df-4b23-bbed-97aa9e030784'),
(3856,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 16:15:24','2025-10-13 16:15:24',NULL,NULL,NULL,'c3f7c8cb-36ee-4796-9f1b-dc17ac9b4a4d'),
(3858,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 16:15:40','2025-10-13 16:15:40',NULL,NULL,NULL,'bf12f978-cde5-4a38-802e-9bdd701fa97c'),
(3859,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:15:51','2025-10-13 16:15:51',NULL,NULL,NULL,'c8aa57d5-8414-4c93-98d8-d3e7c06aa840'),
(3860,1079,NULL,2007,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:15:51','2025-10-13 16:15:51',NULL,NULL,NULL,'c753f9c6-0440-4f08-ace4-56e446e1019a'),
(3861,3859,NULL,2008,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:15:51','2025-10-13 16:15:51',NULL,NULL,NULL,'0e198a6d-4252-4726-9180-781257a292d9'),
(3862,1606,NULL,2009,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:15:51','2025-10-13 16:15:51',NULL,NULL,NULL,'ac9c27ec-c03c-4b30-bbd6-d8842842a446'),
(3863,1607,NULL,2010,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:15:51','2025-10-13 16:15:51',NULL,NULL,NULL,'a72543c7-947d-4fbd-92f5-0b86c5fdbe54'),
(3865,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 16:20:27','2026-01-14 17:12:24',NULL,NULL,NULL,'393c9bff-0570-459d-926c-c6eb005839e6'),
(3866,1085,NULL,2011,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:41:23','2025-10-13 16:41:23',NULL,NULL,NULL,'4afcbd44-0710-474e-a49f-fabab0fb53c4'),
(3874,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'6c408be1-1c0b-463a-b45c-efa17737b976'),
(3875,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'6346990d-7366-4922-886c-508e138d67b0'),
(3876,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'51240748-32cb-4e66-b056-e472abb71c69'),
(3877,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'b3ba5379-c9b3-4b68-a1d6-4860bb4c6f5a'),
(3878,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'109e05e3-5db9-4f0f-a0fe-c295cf5297e5'),
(3879,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'98592287-96f5-45fd-b069-60900d7ece23'),
(3880,1085,NULL,2012,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'3987d78a-f6ca-4878-bbab-6655693adff0'),
(3881,3874,NULL,2013,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'86b63b08-2bd0-4416-bca8-743fb44af72a'),
(3882,3875,NULL,2014,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'4108a3e1-ffd0-443d-ab77-c57b9e8420c2'),
(3883,3876,NULL,2015,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'2e21e449-b4d8-4ada-bada-cd3b3c9711b4'),
(3884,3877,NULL,2016,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'b8f938ba-5aa0-47d7-9212-5c3e4b7c6fce'),
(3885,3878,NULL,2017,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'2bf92097-1ffb-422c-80a9-c0c60558906b'),
(3886,3879,NULL,2018,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'a7f12634-a672-46a5-848d-729286c7ee15'),
(3890,1085,NULL,2019,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:47','2025-10-13 16:43:47',NULL,NULL,NULL,'904648fc-327c-4e0e-9867-1aec28d3ffc3'),
(3891,1611,NULL,2020,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:47','2025-10-13 16:43:47',NULL,NULL,NULL,'14798446-6461-4058-b204-90ab6e9ef346'),
(3892,1612,NULL,2021,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:47','2025-10-13 16:43:47',NULL,NULL,NULL,'cb64ce2d-41d2-4976-95ed-06da0b073e1a'),
(3894,1085,NULL,2022,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:50','2025-10-13 16:43:50',NULL,NULL,NULL,'05331432-a920-4c05-a4af-3f239a81c072'),
(3896,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:02:38','2025-10-13 17:02:38',NULL,NULL,NULL,'7bd5068c-3814-4c9b-9898-6a251cac8c8e'),
(3902,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'78d615a6-25d1-49fc-ab40-de186ebc9b86'),
(3903,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'e2aedee6-bd93-4101-898e-14dc0e1bb0f8'),
(3904,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'e57893b7-2ddc-4ff8-98bb-b75570184257'),
(3905,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'3feef635-be19-4a6d-b213-a3dbb0217f64'),
(3906,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'75048d77-a4aa-45a8-853e-197661d92762'),
(3907,1091,NULL,2023,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'1437753d-d375-49e1-a89d-ffacf91b3706'),
(3908,3902,NULL,2024,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'dac93926-bc48-4c66-b221-ef5dd46a5b31'),
(3909,3903,NULL,2025,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'7bdf78a7-054f-4cba-b4d7-2554c0dfca26'),
(3910,3904,NULL,2026,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'f35aac30-97e6-46f8-9b78-5d2238464a42'),
(3911,3905,NULL,2027,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'76973061-f24d-4754-a056-e5a7c3cadc50'),
(3912,3906,NULL,2028,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'a52b44a1-4b80-4ee9-b922-945382806217'),
(3914,1091,NULL,2029,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:41','2025-10-13 17:05:41',NULL,NULL,NULL,'1dde69df-d240-49ae-8705-9ea3529b7b90'),
(3918,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:06:23','2025-10-13 17:06:23',NULL,NULL,NULL,'96edee62-bf13-467b-a925-cf34cb888839'),
(3920,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:06:39','2025-10-13 17:06:39',NULL,NULL,NULL,'8f2a6313-f096-4859-8d92-f71931a00bd9'),
(3921,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:09:47','2025-10-13 17:09:47',NULL,NULL,NULL,'784e35f3-7981-46f8-981f-45c8aaa3de14'),
(3922,1091,NULL,2030,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:09:47','2025-10-13 17:09:47',NULL,NULL,NULL,'5ea22ba7-d211-4980-a22a-972b2709bef0'),
(3923,3921,NULL,2031,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:09:47','2025-10-13 17:09:47',NULL,NULL,NULL,'948ce7d6-af59-4d14-bcb1-e8ae03570cb6'),
(3924,1616,NULL,2032,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:09:47','2025-10-13 17:09:47',NULL,NULL,NULL,'b3bf9d38-1e10-42d4-926e-603e6bf751ea'),
(3925,1617,NULL,2033,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:09:47','2025-10-13 17:09:47',NULL,NULL,NULL,'6e7a6af8-45c0-4923-a7ad-f44f3066c0a7'),
(3927,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:19:49','2025-10-13 17:19:49',NULL,NULL,NULL,'5c1ab61a-27d0-4c3a-a433-2b84849eb2cf'),
(3928,1097,NULL,2034,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:20:16','2025-10-13 17:20:17',NULL,NULL,NULL,'854ca287-47db-4d48-a11c-7da2b179c9b8'),
(3935,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'94c439b9-e3c0-424e-af82-b9a995f26e5d'),
(3936,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'8f7554b3-1da4-4bc6-802c-b84bc38b5176'),
(3937,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'dfa7f5e1-8c01-46f6-a66e-afeaee07d469'),
(3938,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'15fdbfc5-ad16-43fd-b420-e6312c4c2e93'),
(3939,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'4293c612-f747-46bb-bbc1-208a734a5307'),
(3940,1097,NULL,2035,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'5931751f-080b-46ac-86c7-91d4538fb645'),
(3941,3935,NULL,2036,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'e0f70a0d-a17c-4d5a-8ef5-2390352222ec'),
(3942,3936,NULL,2037,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'0e6a15ff-f522-48e2-b6cd-39e521f4c416'),
(3943,3937,NULL,2038,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'4cf83c1c-2954-4691-bdea-494c153b3d1b'),
(3944,3938,NULL,2039,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'b3bf6b64-0fc9-4aff-8b70-05346156b6e7'),
(3945,3939,NULL,2040,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'2c9b50f0-d4e4-4dd0-be41-0852aca4f3ca'),
(3948,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:22:18','2025-10-13 17:22:18',NULL,NULL,NULL,'5ba4a939-6287-43bf-bf98-d292e2bfc257'),
(3949,1097,NULL,2041,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:22:18','2025-10-13 17:22:18',NULL,NULL,NULL,'9cb6c5ce-0f50-4b78-87fe-b69c5f7e2f95'),
(3950,3948,NULL,2042,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:22:18','2025-10-13 17:22:18',NULL,NULL,NULL,'9ca96325-458a-4d2d-a5dd-bd990c090a43'),
(3954,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:22:55','2025-10-13 17:22:55',NULL,NULL,NULL,'e96116b7-f71b-4c13-893d-a88ce2c6df4c'),
(3955,1097,NULL,2043,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:23:02','2025-10-13 17:23:02',NULL,NULL,NULL,'0eec1f63-a7b5-44ce-80d0-07544ba66bf3'),
(3956,1621,NULL,2044,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:23:02','2025-10-13 17:23:02',NULL,NULL,NULL,'cae02c4a-af7b-4abc-8cc9-7aa0f19e1910'),
(3957,1622,NULL,2045,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:23:02','2025-10-13 17:23:02',NULL,NULL,NULL,'95409328-3cd5-4bf9-8370-0b27e0bf08f0'),
(3959,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:25:39','2025-10-13 17:25:55',NULL,NULL,NULL,'1701a219-50cd-430c-be86-2b75ad7f5ae1'),
(3965,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'2fab5094-9b24-4e66-b001-536f17a5ea1b'),
(3966,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'8c6dfd0e-2a3a-4439-992f-0be0b244c21c'),
(3967,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'5dd167c1-38dd-4043-9267-586773ecef14'),
(3968,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'72d15429-573d-43e4-a7c0-e2a750af6e96'),
(3969,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'ee6d7801-cb59-4569-af31-bc6bd251a7b9'),
(3970,1103,NULL,2046,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'374e34ca-4767-4641-896d-4a6b870593b4'),
(3971,3965,NULL,2047,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'348771db-2035-463b-9b16-baba6316966d'),
(3972,3966,NULL,2048,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'6b57de47-25d0-40f1-804f-449228732a23'),
(3973,3967,NULL,2049,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'1479489c-9b93-41e8-8ffa-0fc656288956'),
(3974,3968,NULL,2050,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'7fa1465a-628f-48e1-8301-fddbe2367b8c'),
(3975,3969,NULL,2051,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'62f7355d-ec49-41ed-bce3-3c51c00048da'),
(3977,1103,NULL,2052,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:45','2025-10-13 17:27:45',NULL,NULL,NULL,'3c214a87-5730-4daa-ab39-43f9ecfc7a80'),
(3981,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:28:18','2025-10-13 17:28:18',NULL,NULL,NULL,'237ec093-2328-47e2-8675-2e160f80bdf7'),
(3982,1103,NULL,2053,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:28:26','2025-10-13 17:28:26',NULL,NULL,NULL,'25848392-d487-44c6-be3f-c18f92029a66'),
(3983,1626,NULL,2054,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:28:26','2025-10-13 17:28:26',NULL,NULL,NULL,'a43b5ab2-b618-41a7-9002-78beca9e0aea'),
(3984,1627,NULL,2055,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:28:26','2025-10-13 17:28:26',NULL,NULL,NULL,'2e3aa1e8-6a80-4d77-ae34-c6cb34acb266'),
(3986,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:40:30','2026-01-14 19:06:21',NULL,NULL,NULL,'efacff44-cd06-41d0-a14b-021999a11a51'),
(3992,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'aac7f17b-239c-45dd-8241-572c213582a9'),
(3993,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'efc23a89-6b18-4db2-86a3-beabbb9e1e52'),
(3994,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'835ed6d6-ab4c-41f7-99e1-471c78621514'),
(3995,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'6837e2f9-1649-4463-9103-547f054c1a8a'),
(3996,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'ec47ff37-bb7b-425d-83ba-589379ca957f'),
(3997,1109,NULL,2056,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'cff4e695-b3f0-4cd0-a11f-1daa8ec72d56'),
(3998,3992,NULL,2057,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'2d6748bb-07e2-4188-b50b-cb2434e6d320'),
(3999,3993,NULL,2058,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'2c943d9e-a65c-4978-8c73-99215c1d4ce8'),
(4000,3994,NULL,2059,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'9a57a8a0-19ba-4691-a163-09c0d4fed136'),
(4001,3995,NULL,2060,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'8838f83d-2cfe-46ae-84d7-9abedc4c34b8'),
(4002,3996,NULL,2061,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'fa532c61-b3cb-4025-83d2-c26a58398221'),
(4004,1109,NULL,2062,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:25','2025-10-13 17:42:25',NULL,NULL,NULL,'5506daf4-2b1a-490c-8c3a-08cca7a2a2f2'),
(4008,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:43:03','2025-10-13 17:43:03',NULL,NULL,NULL,'48a087d8-0d21-4941-b82b-5a0097a2ec58'),
(4010,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:43:27','2025-10-13 17:43:27',NULL,NULL,NULL,'e4912cd6-8ea9-49d1-9e79-6303a3a22c05'),
(4011,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:43:34','2025-10-13 17:43:34',NULL,NULL,NULL,'236a698f-69e6-42e8-8744-0b6e4382e3db'),
(4012,1109,NULL,2063,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:43:34','2025-10-13 17:43:34',NULL,NULL,NULL,'061a5777-9140-463a-8b5b-1cd467c067b3'),
(4013,4011,NULL,2064,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:43:34','2025-10-13 17:43:34',NULL,NULL,NULL,'ba9e88d6-5469-4ed9-a520-cde8d581ff88'),
(4014,1632,NULL,2065,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:43:34','2025-10-13 17:43:34',NULL,NULL,NULL,'cd7bda22-7b3e-4a87-92f8-30337d89ab53'),
(4015,1633,NULL,2066,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:43:34','2025-10-13 17:43:34',NULL,NULL,NULL,'0f0a84b3-abb3-49e9-800c-aa82e8ac6b0b'),
(4017,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:44:49','2026-01-14 19:17:25',NULL,NULL,NULL,'0bdb5069-757f-42ae-9cf0-9d35c534e465'),
(4018,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:45:02','2025-10-13 17:45:02',NULL,NULL,NULL,'c8d03316-3fb3-42ca-be17-5b6690e266b0'),
(4020,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:45:12','2025-10-13 17:45:12',NULL,NULL,NULL,'99de9186-e678-4fca-aa6c-adbd851b9331'),
(4026,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'a5e6b15c-baf6-4f15-8854-3741960d6509'),
(4027,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'acf21f36-c284-4e56-8dd0-9528ffba797a'),
(4028,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'7a8e3dc4-29c1-4a3a-804d-92cdfd8c11b5'),
(4029,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'820335d6-39b8-4eb4-8c2a-6f7f5e0ee494'),
(4030,1117,NULL,2067,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'bbdc3462-f3f1-4a21-97c7-fa567143d6f7'),
(4031,4026,NULL,2068,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'6e9e2ec8-c28b-4d29-91fc-9752c4706968'),
(4032,4027,NULL,2069,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'7ff79758-31aa-4515-9b5a-3a8c6a333651'),
(4033,4028,NULL,2070,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'2b702b65-5430-4557-aab9-51098839b473'),
(4034,4029,NULL,2071,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'8d99e06e-bb73-4ca1-aa67-3e07215a74b4'),
(4035,1638,NULL,2072,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'3b94f841-2384-4369-89e2-17bd76b6d1b3'),
(4036,1639,NULL,2073,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'0040236f-b6c5-4797-ab7c-5ae72449f718'),
(4038,1117,NULL,2074,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:53','2025-10-13 17:46:53',NULL,NULL,NULL,'db48266c-b7c7-43ed-9d3f-5f9553507688'),
(4042,1117,NULL,2075,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:47:19','2025-10-13 17:47:19',NULL,NULL,NULL,'84e2bde3-0af5-4b15-aca0-00d05ee487df'),
(4043,1638,NULL,2076,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:47:19','2025-10-13 17:47:19',NULL,NULL,NULL,'3d21bb03-d970-4920-b666-a7051b366bc4'),
(4044,1639,NULL,2077,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:47:19','2025-10-13 17:47:19',NULL,NULL,NULL,'9cf4204f-4c68-4d1a-a084-ed561478c17f'),
(4046,1123,NULL,2078,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:48:10','2025-10-13 17:48:10',NULL,NULL,NULL,'359064b2-8195-4194-b2ad-7fee34905ea2'),
(4053,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'0861b384-3f2d-4ef0-a442-a7c6779de429'),
(4054,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'f4a30cd3-f01e-4f0e-8900-af8f59dc5cf1'),
(4055,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'bbcb4e4e-c500-46bb-a26e-755893ee3dc1'),
(4056,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'3c4baf18-035d-4aef-a62f-411c2be75452'),
(4057,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'2884ddd7-5175-4a0e-9869-7fe4b9bc177f'),
(4058,1123,NULL,2079,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'112ef6f1-5258-48c2-b959-caa96de24488'),
(4059,4053,NULL,2080,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'1c64e5d7-029f-4a5d-8f35-4a305e9f2172'),
(4060,4054,NULL,2081,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'378382ba-fd14-4f7e-82f2-62cd4a109364'),
(4061,4055,NULL,2082,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'0275c8b4-e54d-44bb-aab2-9070730515ad'),
(4062,4056,NULL,2083,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'a206b450-d282-437b-a886-62496e7cf940'),
(4063,4057,NULL,2084,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'cf41f687-e0ae-44da-8ec0-8d1057b2800c'),
(4069,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:51:54','2025-10-13 17:51:54',NULL,NULL,NULL,'ea737fe8-10e6-4128-8085-979721397257'),
(4070,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'157ac3b1-bfab-4b36-8e50-abe1dfad7938'),
(4071,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'d2bff5fb-7c26-4025-8815-4a8b2231b6d6'),
(4072,1123,NULL,2085,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'00ad63b7-c18d-4cda-896b-a0883999ead2'),
(4073,4070,NULL,2086,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'f4aa05af-aa20-4706-bf3e-5b9ac2fbb7a4'),
(4074,4071,NULL,2087,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'710abb8f-d559-4695-b188-66d092df5df9'),
(4075,1643,NULL,2088,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'9e6235a7-3d82-4fb1-a04b-1d1c02e77b6d'),
(4076,1644,NULL,2089,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'b53a2a44-02af-4444-9380-b4c7ee5b6425'),
(4078,1123,NULL,2090,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:50','2025-10-13 17:52:50',NULL,NULL,NULL,'4f42082e-1068-4d7a-a690-a2e4afe8510b'),
(4080,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:53:05','2026-01-14 19:24:27',NULL,NULL,NULL,'4793d098-df4d-45d3-a379-25ee987a9fd6'),
(4081,1123,NULL,2091,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:53:11','2025-10-13 17:53:11',NULL,NULL,NULL,'77f6a796-8071-4115-8750-109cc6209d8a'),
(4083,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:54:18','2025-10-13 17:54:18',NULL,NULL,NULL,'3e0f4047-7feb-4766-943a-a55d52e0bb62'),
(4089,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'81685bd5-6bbc-4371-b6f1-a72bd2c00f99'),
(4090,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'b56634c1-f27a-45dc-8568-caa429f5c977'),
(4091,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'02e1059b-723e-436e-a06e-b8738b5b2046'),
(4092,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'42cab4fd-a418-46c9-8043-e0f67c60ddb4'),
(4093,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'5c34036b-6791-446f-a1b7-cef7b719a057'),
(4094,1129,NULL,2092,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'6d78e7b2-2680-4199-8e07-131a87092bd2'),
(4095,4089,NULL,2093,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'c33ce76e-3e0d-4593-a254-c7101899639c'),
(4096,4090,NULL,2094,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'1d227f57-f732-4f5d-86b3-11b780d31ce1'),
(4097,4091,NULL,2095,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'648da2bb-1cc2-4794-86be-ae22558b02a8'),
(4098,4092,NULL,2096,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'4ce071c4-a19a-4703-b95c-800186ee6175'),
(4099,4093,NULL,2097,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'7e6a70f3-bf6f-4a8e-8c4b-617cf3cb4f74'),
(4101,1129,NULL,2098,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:56:22','2025-10-13 17:56:22',NULL,NULL,NULL,'1a044971-0a78-4a13-953a-6786a06d353a'),
(4105,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:56:57','2025-10-13 17:57:21',NULL,NULL,NULL,'40e36cdd-9451-430a-a74a-caf5150785bf'),
(4106,1129,NULL,2099,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:57:28','2025-10-13 17:57:28',NULL,NULL,NULL,'f82d604b-399a-4a49-816b-0dfb7d018e55'),
(4107,1648,NULL,2100,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:57:28','2025-10-13 17:57:28',NULL,NULL,NULL,'d14c63f5-bbe2-4898-a00c-56a65e472c06'),
(4108,1649,NULL,2101,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:57:28','2025-10-13 17:57:28',NULL,NULL,NULL,'63a37e93-74ce-484e-b349-8fe1a7d34df5'),
(4110,1143,NULL,2102,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:58:05','2025-10-13 17:58:05',NULL,NULL,NULL,'47fbca3f-8985-4d0e-a9b2-3efe7d88c667'),
(4117,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:21',NULL,NULL,NULL,'0be060e9-83d0-4186-8518-30d6c6836868'),
(4118,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:21',NULL,NULL,NULL,'5affa6aa-b918-4611-ba36-7ae7963bd0dd'),
(4119,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:21',NULL,NULL,NULL,'da352630-e965-4ed4-ad1a-15ef076621f7'),
(4120,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:21',NULL,NULL,NULL,'858a76da-ceaa-43d5-ad31-68dc64a8da98'),
(4121,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:21',NULL,NULL,NULL,'5cf3ce59-b2b9-4e7d-98c5-da8a2e4a7701'),
(4122,1143,NULL,2103,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:21',NULL,NULL,NULL,'253017e9-ebc0-4459-8503-9c1f9bc393b5'),
(4123,4117,NULL,2104,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:22',NULL,NULL,NULL,'bbeb1123-c632-4daa-8b2f-da7a2ea6670b'),
(4124,4118,NULL,2105,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:22',NULL,NULL,NULL,'351fbff7-0e2e-4e77-bea9-3f8798f7d745'),
(4125,4119,NULL,2106,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:22',NULL,NULL,NULL,'4d0db377-002b-4cda-a3b8-3967ecddf03b'),
(4126,4120,NULL,2107,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:22',NULL,NULL,NULL,'449e5ff4-a79b-4a38-8576-5dab5fb11cda'),
(4127,4121,NULL,2108,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:22',NULL,NULL,NULL,'b3075fb0-0fd3-44d8-ac47-06e66e71da34'),
(4131,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 18:00:02','2025-10-13 18:00:02',NULL,NULL,NULL,'725094e8-6c3d-4768-9f54-8a748b6e4e5e'),
(4132,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 18:00:02','2025-10-13 18:00:02',NULL,NULL,NULL,'b2e49f2c-9926-4f4c-9b45-e419dad94da4'),
(4133,1143,NULL,2109,1,'craft\\elements\\Entry',1,0,'2025-10-13 18:00:02','2025-10-13 18:00:02',NULL,NULL,NULL,'ee0b31cd-77a1-4dfb-9f82-43b90ba80ab6'),
(4134,4131,NULL,2110,3,'craft\\elements\\Entry',1,0,'2025-10-13 18:00:02','2025-10-13 18:00:02',NULL,NULL,NULL,'29b663f2-d287-46df-8efb-622e7e7d9c29'),
(4135,4132,NULL,2111,3,'craft\\elements\\Entry',1,0,'2025-10-13 18:00:02','2025-10-13 18:00:02',NULL,NULL,NULL,'3ffcb078-9b70-47f9-8246-dbf87e263c27'),
(4138,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 18:01:28','2025-10-13 18:01:28',NULL,NULL,NULL,'2902e679-f962-4baf-85c7-72231aae82f9'),
(4141,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 18:01:44','2025-10-13 18:01:44',NULL,NULL,NULL,'0b40b7d0-fd36-43ce-8b54-0c0064010888'),
(4142,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 18:02:04','2025-10-13 18:02:04',NULL,NULL,NULL,'695d4da6-e73f-4c2b-b1e8-b9fb08c01ffe'),
(4143,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-13 18:02:09','2025-10-13 18:02:09',NULL,NULL,NULL,'1de73e62-39e1-498c-9aeb-79ac75073e88'),
(4144,1143,NULL,2112,1,'craft\\elements\\Entry',1,0,'2025-10-13 18:02:09','2025-10-13 18:02:09',NULL,NULL,NULL,'b918d3a9-94dc-4a74-80e9-f674cc5737a6'),
(4145,4143,NULL,2113,2,'craft\\elements\\Entry',1,0,'2025-10-13 18:02:09','2025-10-13 18:02:09',NULL,NULL,NULL,'23ef7a3b-aee3-4315-931d-5ccbab55de8b'),
(4146,1660,NULL,2114,2,'craft\\elements\\Entry',1,0,'2025-10-13 18:02:09','2025-10-13 18:02:09',NULL,NULL,NULL,'8cd8f7df-db77-4ccc-80cc-b5fadb09f436'),
(4148,1149,NULL,2115,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:03:49','2025-10-13 19:03:49',NULL,NULL,NULL,'c623ea77-4216-43a6-8a4a-9c7463ebfa1f'),
(4150,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 19:05:27','2025-10-13 19:05:27',NULL,NULL,NULL,'ad23f0b4-70ac-4de9-8e6b-cb19a989f8f8'),
(4156,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'ba4cae3b-492a-45c1-b88a-1f9f33f2a214'),
(4157,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'3c7a713b-7dfe-4d5a-bc96-ed254af225bd'),
(4158,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2026-01-17 16:10:02',NULL,NULL,NULL,'a10eef7b-857d-4360-b1ce-f556224eb3ac'),
(4159,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'774cdad5-67a4-414f-8a78-c60d82f3b52f'),
(4160,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'456ff720-95cc-4897-8af9-c15417234740'),
(4161,1149,NULL,2116,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'c0d8ac1e-4594-415d-9ea2-bdebe1b2e456'),
(4162,4156,NULL,2117,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'2f78cc4f-3bb9-4c9c-8f71-e574fea0cb78'),
(4163,4157,NULL,2118,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'981820fa-ac79-424b-836a-02fedf1405ad'),
(4164,4158,NULL,2119,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'99e7db5c-288e-4707-9871-439e378344e5'),
(4165,4159,NULL,2120,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'904243fb-729c-4877-89f0-d86eab1b73ba'),
(4166,4160,NULL,2121,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'0038bd1e-2d55-4045-9b0d-7c9f11cf3dca'),
(4168,1149,NULL,2122,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:29','2025-10-13 19:09:29',NULL,NULL,NULL,'788b59b7-177c-44e1-8b0e-df174360219a'),
(4172,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 19:10:22','2025-10-13 19:10:22',NULL,NULL,NULL,'7fd6c38a-924a-45ef-856e-b6b9ea0f5e44'),
(4174,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:10:27','2025-10-13 19:10:27',NULL,NULL,NULL,'740f9f9a-93fa-4dc8-a08f-f67ea762b6fc'),
(4175,1149,NULL,2123,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:10:27','2025-10-13 19:10:27',NULL,NULL,NULL,'dcd4db4f-7844-4181-ae1d-945d5ed9bd4f'),
(4176,4174,NULL,2124,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:10:27','2025-10-13 19:10:27',NULL,NULL,NULL,'69169515-6e5b-42be-a96d-2b74bce36527'),
(4177,1665,NULL,2125,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:10:27','2025-10-13 19:10:27',NULL,NULL,NULL,'b9d8d18d-354f-4dbf-bb07-143666fb0d30'),
(4179,1155,NULL,2126,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:11:14','2025-10-13 19:11:14',NULL,NULL,NULL,'e78e91b4-c172-47a7-abd1-6cfcefadeb88'),
(4181,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 19:12:28','2025-10-13 19:12:28',NULL,NULL,NULL,'1ae634c0-cef3-4ae8-b695-ac297934ddb5'),
(4182,1155,NULL,2127,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:14:26','2025-10-13 19:14:26',NULL,NULL,NULL,'e1585a80-855f-4690-bc75-04ba16d790be'),
(4189,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'bddaa596-6d19-4503-962d-00a06b113845'),
(4190,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'4450f04c-5cd5-4083-9949-bd15e7cea782'),
(4191,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'7e037ca1-b057-4df0-b0bb-d38a875efb6e'),
(4192,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'409c5942-be03-43e7-86ae-4f1ce2f1a1d2'),
(4193,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'ad691c87-2e0c-43cc-8adb-2b40a175fdd4'),
(4194,1155,NULL,2128,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'3dacb6e3-9908-4c2d-920f-80a5ff5dca08'),
(4195,4189,NULL,2129,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'a29bd748-d3f8-4c18-8c5d-d622d35ab7b6'),
(4196,4190,NULL,2130,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'1fafbc51-89f1-4ecb-9e48-78ef78f3628c'),
(4197,4191,NULL,2131,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'5d1148ee-8e1e-4d31-a982-094d737f7375'),
(4198,4192,NULL,2132,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'48de7f5f-075e-43d9-b44b-ec60d9c90df0'),
(4199,4193,NULL,2133,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'7dcd9ef7-ed88-4ba1-8ab1-154409f1d8ee'),
(4207,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 19:17:28','2025-10-13 19:17:28',NULL,NULL,NULL,'946bf00f-6b48-4ef5-bde0-ea4ac46d00bc'),
(4208,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 19:17:38','2025-10-13 19:17:38',NULL,NULL,NULL,'174aff5b-5db6-4b7e-9c63-e50708b6a8be'),
(4210,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'6e9fd1b9-8e40-49f7-88c6-ea1025a670ba'),
(4211,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'b45e1ef5-5a36-4ccd-8e1c-b6b6961b1815'),
(4212,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'0375b3b1-1523-40c6-ad39-deef55dd5fd5'),
(4213,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'e6ff9754-28a3-4dc2-add7-a77d70ecf4bc'),
(4214,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'ee8f28f5-016e-46e3-8478-129c575bcf27'),
(4215,1155,NULL,2134,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'35d08a65-ae19-4646-9f1a-3f0dd55fbcbc'),
(4216,4210,NULL,2135,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'a7c337ce-7acb-4908-a613-37a6d85038bf'),
(4217,4211,NULL,2136,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'7e7cd301-99fc-452d-b93f-bae04bacf20a'),
(4218,4212,NULL,2137,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'870a853b-8311-40d3-92b7-eba16183905f'),
(4219,4213,NULL,2138,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'10ad3944-5954-43e9-9519-04b027d372fd'),
(4220,4214,NULL,2139,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'af31d3d3-2cb4-488c-b55a-10fb3f1c915e'),
(4221,1670,NULL,2140,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'47093c9a-6098-4fb7-8982-097dde1c3a1c'),
(4223,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 19:26:37','2025-10-13 19:26:37',NULL,NULL,NULL,'9000a937-4f22-424a-bf55-fbc1c23c7adb'),
(4224,1165,NULL,2141,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:27:40','2025-10-13 19:27:41',NULL,NULL,NULL,'54528f8a-8527-457f-9921-5e3917eecd0d'),
(4231,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'4992795a-fe66-41fc-9c25-4626afacfaca'),
(4232,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'f86004ff-378b-4b98-ac62-afd6bd096cc9'),
(4233,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'f0f229e0-7dc4-48d9-b4af-6cb3c64dbec1'),
(4234,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'8f7b4d4b-af9a-4600-9dd1-a66353756090'),
(4235,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'7d9447b6-8bf1-46e0-9d4a-fbecbc6f04dd'),
(4236,1165,NULL,2142,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'09ca3029-94d6-4df6-9294-c3fbe07ebb0a'),
(4237,4231,NULL,2143,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'cf0ffa1b-b0d8-42d8-a573-e9741906219b'),
(4238,4232,NULL,2144,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'9a5bf88f-8347-4008-be94-348db544d8f9'),
(4239,4233,NULL,2145,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'519e32c3-5435-417b-8371-4384808d8761'),
(4240,4234,NULL,2146,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'f925457f-27aa-4f8a-88a7-543cb547137f'),
(4241,4235,NULL,2147,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'f72f5b93-ce2c-45bd-95c2-17f4f56b2fcf'),
(4243,1165,NULL,2148,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:18','2025-10-13 19:29:18',NULL,NULL,NULL,'66d4469f-d785-4e43-b07d-33ffa5020b88'),
(4246,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 19:29:49','2025-10-13 19:29:49',NULL,NULL,NULL,'c249c36b-8c67-41ca-b805-e5a914aecad1'),
(4248,1165,NULL,2149,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:30:02','2025-10-13 19:30:02',NULL,NULL,NULL,'ff0b2076-2997-4d88-81b7-bb1a0db6e312'),
(4249,1677,NULL,2150,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:30:02','2025-10-13 19:30:03',NULL,NULL,NULL,'fc2d75b4-0612-4e62-b351-5d7d07f203e4'),
(4250,1678,NULL,2151,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:30:02','2025-10-13 19:30:03',NULL,NULL,NULL,'e1537adf-909f-4928-9409-833d841658d4'),
(4252,1165,NULL,2152,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:30:06','2025-10-13 19:30:06',NULL,NULL,NULL,'d40d682c-d9b4-46f0-9ff3-921ce74bb4d5'),
(4254,1171,NULL,2153,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:30:40','2025-10-13 19:30:40',NULL,NULL,NULL,'e2f7827e-38d7-4bb6-8a4b-b2b8d65f9ed9'),
(4261,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'21e9a836-77b2-4142-928c-105a7d8b7e0e'),
(4262,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'d8c486f7-7acc-4461-bd7e-4ce4f44ad92d'),
(4263,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'c1175a17-87b4-41e1-9a58-f07c21080351'),
(4264,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'58723179-c356-485b-ab03-861666d659a1'),
(4265,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'b2d3a936-66e9-4499-8845-f1d9b295ba61'),
(4266,1171,NULL,2154,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'0f640bc8-6baa-4685-b95e-71bcac28db27'),
(4267,4261,NULL,2155,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'e29ed76a-7ef9-47d4-9b84-b4e1e90f0a61'),
(4268,4262,NULL,2156,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'293ce225-ed38-471a-befc-ca727029971b'),
(4269,4263,NULL,2157,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'6465eb73-c99d-44d0-819a-f0129bbd0628'),
(4270,4264,NULL,2158,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'29ef6ba4-6ed7-4a21-9b23-0db2c4cff918'),
(4271,4265,NULL,2159,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'d55d0d80-53c0-402b-b56b-df91dc76f906'),
(4276,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 19:34:09','2026-01-16 20:33:17',NULL,NULL,NULL,'b2efb3ab-b61c-4207-91fa-84eed33e027d'),
(4277,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:34:44','2025-10-13 19:34:44',NULL,NULL,NULL,'7391c03a-3ffc-457c-932d-ef6a5ca26e29'),
(4278,1171,NULL,2160,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:34:44','2025-10-13 19:34:44',NULL,NULL,NULL,'80e1b5f0-0b97-4137-88ba-c51b511a714c'),
(4279,4277,NULL,2161,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:34:44','2025-10-13 19:34:44',NULL,NULL,NULL,'a709c094-80f2-4722-ad60-55534021ba67'),
(4280,1682,NULL,2162,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:34:44','2025-10-13 19:34:44',NULL,'2026-01-05 17:12:30',NULL,'0c9b9280-5870-4595-943b-cb4cf4a144c0'),
(4281,1683,NULL,2163,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:34:44','2025-10-13 19:34:44',NULL,NULL,NULL,'6ba4d252-d3fc-44fd-8364-d53f6971e2e2'),
(4282,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 19:36:07','2025-10-13 19:36:07',NULL,NULL,NULL,'c492aeca-56fc-4b46-91d7-4ebfcdda17d5'),
(4289,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'bb7c2c0c-e89a-4e4e-9e7c-4d4e46e5b8f5'),
(4290,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'0c6abb15-e685-477a-9d16-28390372afe5'),
(4291,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'332a9fe0-6943-467f-9e14-f4566cea1241'),
(4292,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'aaee8434-f389-4ec5-aeb5-0dbd2e028eac'),
(4293,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'0f04f331-644c-402d-93f9-1e87f0f48835'),
(4294,1177,NULL,2164,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'555db4d6-448b-418e-8f51-a0dde12716a9'),
(4295,4289,NULL,2165,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'26f65cf3-ecb7-448e-ba66-3a19b2f91cc7'),
(4296,4290,NULL,2166,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'cc3a27a0-0faf-4196-a41f-e31c48c3aba6'),
(4297,4291,NULL,2167,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'09bda69b-8dbb-4a50-aabc-9aad0f4da605'),
(4298,4292,NULL,2168,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'64e2b939-f78c-4431-a60b-6c29ee6afbc0'),
(4299,4293,NULL,2169,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'46bc35e9-87c2-4865-a81b-6cd67046c191'),
(4301,1177,NULL,2170,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:58','2025-10-13 19:37:58',NULL,NULL,NULL,'4ecb78d7-9669-42a6-93a7-b4054ab3f37e'),
(4306,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:00','2025-10-13 19:39:00',NULL,NULL,NULL,'b05b9be9-a134-4cbc-b62a-d561f285211d'),
(4307,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:00','2025-10-13 19:39:00',NULL,NULL,NULL,'1d46c9fd-5073-4975-92ed-ec2b875aa71e'),
(4308,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:00','2025-10-13 19:39:00',NULL,NULL,NULL,'759db7d4-e50e-4e79-925c-f61ecaf511a5'),
(4309,1177,NULL,2171,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:38:59','2025-10-13 19:39:00',NULL,NULL,NULL,'8d41802e-4231-4bed-97dd-862cd6900f05'),
(4310,4306,NULL,2172,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:00','2025-10-13 19:39:00',NULL,NULL,NULL,'f5630e4a-8b08-465b-8e17-86989062e1ad'),
(4311,4307,NULL,2173,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:00','2025-10-13 19:39:00',NULL,NULL,NULL,'6b4f7c51-05c9-4238-a451-769c4a38bd69'),
(4312,4308,NULL,2174,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:00','2025-10-13 19:39:00',NULL,NULL,NULL,'d5fc3ba4-ce5f-4c4e-a972-2ad963b3b3e3'),
(4316,1177,NULL,2175,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:32','2025-10-13 19:39:32',NULL,NULL,NULL,'72d74b7e-f94d-4ede-a4b8-a82d4983a8e7'),
(4317,1692,NULL,2176,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:32','2025-10-13 19:39:32',NULL,NULL,NULL,'063c5698-cfdb-4ec3-8700-8c9a4e638c46'),
(4318,1693,NULL,2177,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:32','2025-10-13 19:39:32',NULL,NULL,NULL,'e5130c4c-748d-46af-9f6d-a88c49176077'),
(4322,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 19:47:23','2025-10-13 19:47:23',NULL,NULL,NULL,'ad68b265-d96d-45d0-a725-496e94ae61cb'),
(4323,1185,NULL,2178,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:47:44','2025-10-13 19:47:44',NULL,NULL,NULL,'66911b05-f718-406e-ad87-73455ed96d5f'),
(4324,1694,NULL,2179,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:47:44','2025-10-13 19:47:44',NULL,NULL,NULL,'8400e6f2-1548-4b71-aea0-8926cb69fc35'),
(4325,1695,NULL,2180,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:47:44','2025-10-13 19:47:44',NULL,NULL,NULL,'dc3ca947-74b8-4bbc-862a-8109839efde7'),
(4332,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'2da53d05-df77-4d94-ac1c-d9589849bcd7'),
(4333,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'88d5e36d-acec-4e4d-96d4-50abada30ed2'),
(4334,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'d16578b8-99ea-45a9-acf9-9413622cf3b7'),
(4335,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'2bb4b4aa-7cc5-47e9-b14b-fef23d31759a'),
(4336,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'3c1092e8-e7ce-4961-b496-7baed3de9c92'),
(4337,1185,NULL,2181,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'7778e6bf-63c5-4583-8cd2-6e51be0a53fa'),
(4338,4332,NULL,2182,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'de979bd4-a980-4626-b766-f56a00a1bb5e'),
(4339,4333,NULL,2183,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'611e8e6d-19d3-4c3e-b655-4a965757b295'),
(4340,4334,NULL,2184,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'8cbdc2ec-0f84-4c4f-aecf-06ad46af66a8'),
(4341,4335,NULL,2185,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'48057c68-636c-4d10-aec2-ae821469301a'),
(4342,4336,NULL,2186,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'dc85a8f9-d4f6-4a31-9eeb-7a02d77e78fe'),
(4344,1185,NULL,2187,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:30','2025-10-13 19:51:30',NULL,NULL,NULL,'b38e5158-8a13-4ed9-beaa-018786a2bcb1'),
(4345,1185,NULL,2188,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:50','2025-10-13 19:51:50',NULL,NULL,NULL,'90993f04-07ed-47e7-ba53-2c8bc106af05'),
(4349,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-14 13:43:17','2025-10-14 13:43:17',NULL,NULL,NULL,'26c87cbe-ce40-4b6e-a39b-ae11425a8bbb'),
(4350,1443,NULL,2189,1,'craft\\elements\\Entry',1,0,'2025-10-14 13:43:52','2025-10-14 13:43:52',NULL,NULL,NULL,'17370d28-0907-4e32-9718-f8b7291211f4'),
(4351,1911,NULL,2190,2,'craft\\elements\\Entry',1,0,'2025-10-14 13:43:52','2025-10-14 13:43:52',NULL,NULL,NULL,'695d05f1-19e6-4113-98cc-86fd5bccec7a'),
(4353,945,NULL,2191,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:13:45','2025-10-14 16:13:46',NULL,NULL,NULL,'aaf734fc-149a-4608-8754-20fff11c0b0b'),
(4354,999,NULL,2192,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:14:34','2025-10-14 16:14:34',NULL,NULL,NULL,'d454a10b-c028-471b-9971-36bf13421108'),
(4355,1539,NULL,2193,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:14:34','2025-10-14 16:14:34',NULL,NULL,NULL,'fc6e7931-49f4-4a71-a1d4-59018a3fd6b8'),
(4356,1540,NULL,2194,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:14:34','2025-10-14 16:14:34',NULL,NULL,NULL,'5bce45d5-b380-4207-a683-ec94887c1340'),
(4358,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 16:46:42','2025-10-14 16:46:42',NULL,NULL,NULL,'f0e54b99-ba93-4326-ab74-edec09ee7518'),
(4365,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'65f2f2ca-f79d-446a-a26c-9f658bc96563'),
(4366,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'712ff4db-3260-4ea5-99ad-c5b0222ec4e1'),
(4367,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'56880df3-d534-4703-bcec-f46a9a57e461'),
(4368,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'8da4231c-6709-47b3-b86c-f90434936d13'),
(4369,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'58e72202-fa22-4dba-b888-8ea40e36b20c'),
(4370,1191,NULL,2195,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'6d73eb79-4ee9-492f-b94c-7433de282658'),
(4371,4365,NULL,2196,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'cc885001-c609-4809-930f-7fc29b667370'),
(4372,4366,NULL,2197,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'7827d3e1-4a72-434f-8221-13bb164caae2'),
(4373,4367,NULL,2198,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'6fda258c-87b1-469a-99c4-95197bb871f9'),
(4374,4368,NULL,2199,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'ba7df0b5-3d0e-4746-85ed-576bbefb5454'),
(4375,4369,NULL,2200,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'03ce2209-a6cb-40bd-8d01-ed684cc14084'),
(4377,1191,NULL,2201,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:25','2025-10-14 16:48:25',NULL,NULL,NULL,'ec5cb8fe-1cce-40b3-962f-6fecf24ce906'),
(4381,1191,NULL,2202,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:49:14','2025-10-14 16:49:14',NULL,NULL,NULL,'c8886d75-c546-46dc-a68a-bcfcb0bd07d8'),
(4382,1699,NULL,2203,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:49:14','2025-10-14 16:49:14',NULL,NULL,NULL,'5b0d0e80-4f94-4c3c-b3d4-10ebf3dfc9d7'),
(4383,1700,NULL,2204,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:49:14','2025-10-14 16:49:14',NULL,NULL,NULL,'6e26ddff-bb96-4a06-827d-a4fc65d1dd58'),
(4385,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 16:50:16','2025-10-14 16:50:16',NULL,NULL,NULL,'a7467d5a-c4a8-4c8f-ae77-a82d8324af8e'),
(4391,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'3b776065-9769-4b76-9953-fc959490780b'),
(4392,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'dfb79b5e-9633-46ca-ac48-957db45bc3f4'),
(4393,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'38188e70-73c6-414f-85a2-b1cf920290c5'),
(4394,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'2f5d31af-4820-4a14-b441-87e9deb1b919'),
(4395,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'51888495-0b79-4d66-b219-b72a1d2452ef'),
(4396,1197,NULL,2205,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'f09638bd-ce63-4b80-8feb-861ef5426b89'),
(4397,4391,NULL,2206,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'aceaa5dc-494a-4d87-9b4e-9c4e74635a0f'),
(4398,4392,NULL,2207,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'86a0c1c2-bbf0-48bd-8d3f-45312c012f36'),
(4399,4393,NULL,2208,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'5af57da1-de2b-4abf-85ad-444f82fff67e'),
(4400,4394,NULL,2209,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'96f2e5a6-a427-4850-8ca0-96b1c5670309'),
(4401,4395,NULL,2210,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'a2026e3b-ecbd-4674-9eff-7ed9fdd4793c'),
(4403,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:31','2026-01-08 19:57:55',NULL,NULL,NULL,'65df3a5d-a5e7-4bc3-8e2c-ae52f22451e9'),
(4404,4403,NULL,2211,6,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:36','2025-10-14 16:52:36',NULL,NULL,NULL,'34f205d3-853a-44b7-96c0-01f10a709d8b'),
(4405,1197,NULL,2212,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:41','2025-10-14 16:52:41',NULL,NULL,NULL,'6331f429-7e69-44cb-8f29-6601f1c5a663'),
(4409,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:53:18','2025-10-14 16:53:18',NULL,NULL,NULL,'f13aa7c3-d27c-4ec5-841a-526c90d2c82f'),
(4410,1197,NULL,2213,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:53:18','2025-10-14 16:53:18',NULL,NULL,NULL,'f8036931-5620-4273-98d2-57666543bb80'),
(4411,4409,NULL,2214,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:53:18','2025-10-14 16:53:18',NULL,NULL,NULL,'c86a5173-61e2-4caf-b1b6-a9e2ea9fca6e'),
(4412,1704,NULL,2215,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:53:18','2025-10-14 16:53:18',NULL,NULL,NULL,'7196f9c8-e1d3-4063-90c3-9f5a148c22e1'),
(4414,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 16:54:20','2025-10-14 16:54:20',NULL,NULL,NULL,'3fbb3e40-782e-436f-a493-605911155328'),
(4420,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'16d6b673-3735-4c33-b22d-720587a88f75'),
(4421,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'bf51a0f4-a9a4-484d-b5f9-ece81eb87250'),
(4422,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'2086f450-f1d2-4ac3-81f8-d8ae0b1f7492'),
(4423,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'63ee4371-2a12-4c3f-8d26-85b2e6f11f53'),
(4424,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'6e136f21-4c99-45b4-919f-990a2481d1a9'),
(4425,1201,NULL,2216,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'027be2ca-3329-4bd6-8d3f-8d4348e1a1b1'),
(4426,4420,NULL,2217,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'b7104d75-70bd-4633-b6b8-bcb8fc8542d5'),
(4427,4421,NULL,2218,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'e96b9f14-8b1a-46aa-9b12-d4cf44060735'),
(4428,4422,NULL,2219,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'efbf2462-d6bc-4c15-972c-3ae9086da66b'),
(4429,4423,NULL,2220,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'192a5ba2-7cd6-4761-a8b5-32fd257b0c71'),
(4430,4424,NULL,2221,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'1f54ff0e-28db-463c-8f7f-88737dbcff07'),
(4432,1201,NULL,2222,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:56:21','2025-10-14 16:56:21',NULL,NULL,NULL,'2c617e62-1244-410d-a2f4-f05cede03da2'),
(4436,1201,NULL,2223,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:56:56','2025-10-14 16:56:56',NULL,NULL,NULL,'2393e587-ae26-441d-9828-a13813aea517'),
(4437,1708,NULL,2224,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:56:56','2025-10-14 16:56:56',NULL,NULL,NULL,'cd47e4f9-5fae-4f7d-98b3-d63e53f9241c'),
(4438,1709,NULL,2225,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:56:56','2025-10-14 16:56:56',NULL,NULL,NULL,'319af4b3-eaae-4388-87fa-b9fe27ddd382'),
(4440,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 16:57:51','2025-10-14 16:57:51',NULL,NULL,NULL,'ebbd20f1-f103-4d3d-9db5-46ea4b8a9118'),
(4446,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:10',NULL,NULL,NULL,'1703f52a-3e84-41fe-a9e4-d3b514e8c876'),
(4447,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:10',NULL,NULL,NULL,'c0d66d10-577c-4a20-8696-22d1f3631f68'),
(4448,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:10',NULL,NULL,NULL,'00550f30-b927-41bf-8909-5d0f12a9fbd0'),
(4449,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:10',NULL,NULL,NULL,'465cf671-1b88-4dec-a0ba-64a9d68f2e18'),
(4450,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:10',NULL,NULL,NULL,'169c27d5-b5eb-4311-abad-ebfb4f293306'),
(4451,1209,NULL,2226,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:11',NULL,NULL,NULL,'8367eb40-bdff-4f82-894d-c2f9a05b2fc9'),
(4452,4446,NULL,2227,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:11',NULL,NULL,NULL,'9552799c-f8ca-4e16-bf8d-c32f005e19b8'),
(4453,4447,NULL,2228,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:11',NULL,NULL,NULL,'e53caff2-244a-4943-a046-34c705051337'),
(4454,4448,NULL,2229,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:11',NULL,NULL,NULL,'33877028-9f8e-4da0-a13a-635fcd76a268'),
(4455,4449,NULL,2230,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:11',NULL,NULL,NULL,'cd5a4a37-dd66-4fb0-b0d6-550769344bae'),
(4456,4450,NULL,2231,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:11',NULL,NULL,NULL,'6ebb1ee3-ebcc-477b-8b98-4110b616d907'),
(4458,1209,NULL,2232,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:35','2025-10-14 16:59:36',NULL,NULL,NULL,'5d84ab35-4c0c-4c5f-bc51-ae686ce5a714'),
(4462,1209,NULL,2233,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:00:06','2025-10-14 17:00:06',NULL,NULL,NULL,'4e3470ce-3cb6-4f5c-918c-69734c1651ea'),
(4463,1714,NULL,2234,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:00:06','2025-10-14 17:00:06',NULL,NULL,NULL,'25ebf60f-ed86-4bf9-89e3-1fd020566153'),
(4464,1715,NULL,2235,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:00:06','2025-10-14 17:00:06',NULL,NULL,NULL,'29bbeb15-85b7-4463-9370-59d8283296b6'),
(4466,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:00:49','2025-10-14 17:01:23',NULL,NULL,NULL,'0d32fdfc-d798-44f1-8d0f-d4bb1f2ea650'),
(4467,1215,NULL,2236,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:01:41','2025-10-14 17:01:41',NULL,NULL,NULL,'5323273b-c84e-47fc-8310-1c3ed7b0291f'),
(4474,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'182a432b-e782-4a30-86a3-3e8b8dde3667'),
(4475,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'5ff7ae57-b076-4b8d-bde7-974eed4f1da0'),
(4476,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'f05f92af-59c8-488a-b259-2160eaf71228'),
(4477,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'0b248ef0-b462-4adf-87c5-f197c9a1dc92'),
(4478,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'b3947e95-1681-49c2-86f8-1a2bc85bd274'),
(4479,1215,NULL,2237,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'35759317-7f82-4415-af03-acc41865763a'),
(4480,4474,NULL,2238,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'6088b5ea-258a-4207-82b7-dbe771cdd567'),
(4481,4475,NULL,2239,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'bb6a5c3f-46f4-4d9d-8df9-ed14cd9a1ab9'),
(4482,4476,NULL,2240,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'fb2cde6c-fb8d-4ca0-825f-cdbe5a8704db'),
(4483,4477,NULL,2241,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'2d8837f9-3d74-4267-a500-20a2f925d8c8'),
(4484,4478,NULL,2242,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'ed8e85c8-1a42-46f6-a91e-9daab2bacf66'),
(4486,1215,NULL,2243,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:04:16','2025-10-14 17:04:16',NULL,NULL,NULL,'6a7f4763-eada-4cfa-9268-9bd2820108ed'),
(4488,1215,NULL,2244,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:04:31','2025-10-14 17:04:31',NULL,NULL,NULL,'47ed21f0-b9ba-4295-a7a0-5397423cfef3'),
(4492,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:05:13','2025-10-14 17:05:13',NULL,NULL,NULL,'74f7669b-8d72-4f8f-8de1-3312065b8c33'),
(4493,1215,NULL,2245,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:05:13','2025-10-14 17:05:13',NULL,NULL,NULL,'7edec2de-38e7-442b-9143-f5f423ceeda0'),
(4494,4492,NULL,2246,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:05:13','2025-10-14 17:05:13',NULL,NULL,NULL,'84cb1bb0-58a7-49f1-b56b-428a51e8da79'),
(4495,1719,NULL,2247,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:05:13','2025-10-14 17:05:13',NULL,NULL,NULL,'487b40e1-fc24-468b-a1e7-c5cf186ffa5f'),
(4497,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:06:55','2025-10-14 17:06:55',NULL,NULL,NULL,'ec8d0fcf-8ac8-4baa-b864-904846e06352'),
(4504,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'f64812bb-9517-495d-9fb0-04b029d93f68'),
(4505,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'63dcfdcd-f90a-4dfb-ba21-0c424dec1e67'),
(4506,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'e4fb2a50-0323-4b9f-9423-30b2a16f433e'),
(4507,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'345aab99-8935-4c41-b53c-565b593b3ff5'),
(4508,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'cb6d7e9e-5896-4468-805e-f44517e528d2'),
(4509,1219,NULL,2248,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'bd30ee7a-8b05-4e55-814c-bd8924f0e68d'),
(4510,4504,NULL,2249,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'e89979ce-a905-4636-9aa4-d8ef513fbae1'),
(4511,4505,NULL,2250,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'9f7cda5d-8893-4945-92d5-dab22b354730'),
(4512,4506,NULL,2251,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'91ec56e4-b950-4548-ac5e-d6e9ade12049'),
(4513,4507,NULL,2252,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'1472bf84-0694-4d9b-b8a1-57d690dea452'),
(4514,4508,NULL,2253,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'34c23816-09d3-44aa-adf4-59190c0b9784'),
(4518,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-14 17:09:05','2025-10-14 17:09:05',NULL,NULL,NULL,'9236c29d-3afb-4e93-b233-74cf198a6ed1'),
(4519,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-14 17:09:11','2025-10-14 17:09:11',NULL,NULL,NULL,'277bfa08-6dfe-47fb-8671-0742e04a0cde'),
(4521,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:09:21','2025-10-14 17:09:21',NULL,NULL,NULL,'0a20cad6-20e4-426e-871e-a3a800d2aaaa'),
(4522,1219,NULL,2254,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:09:21','2025-10-14 17:09:21',NULL,NULL,NULL,'26c097af-a01d-4b8b-a557-fe0c4e86401e'),
(4523,4521,NULL,2255,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:09:21','2025-10-14 17:09:21',NULL,NULL,NULL,'63c83e86-b79a-48d9-ac53-1fb07cf50d25'),
(4524,1723,NULL,2256,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:09:21','2025-10-14 17:09:21',NULL,NULL,NULL,'f9f688a7-90d8-4b18-bfca-daacba56ec6a'),
(4526,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:10:03','2025-10-14 17:10:03',NULL,NULL,NULL,'eef3aeff-d250-4872-ae9d-3275ee45b3c0'),
(4527,1225,NULL,2257,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:10:19','2025-10-14 17:10:19',NULL,NULL,NULL,'923ca987-a0d8-4141-8dc0-207868537b4c'),
(4534,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'1387671e-81ca-4d10-ba20-5cd59efb6018'),
(4535,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'b772059b-e929-4a9f-b47b-9fe8d27f1d68'),
(4536,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'92a30bf9-3196-453a-a243-f5d40378969d'),
(4537,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'5d7d8add-d5c1-47f8-ab4d-6f1cd5b3f0ed'),
(4538,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'cac93746-fc44-4ecb-a6e7-3397d2c972d3'),
(4539,1225,NULL,2258,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'4280ec76-40a2-4b1f-abe5-1ff3eaae5de5'),
(4540,4534,NULL,2259,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'c18863d4-3a67-49e5-9b44-2bc3ae683139'),
(4541,4535,NULL,2260,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'7b38d9ec-5862-4e56-a1b6-96fc1dc10cf4'),
(4542,4536,NULL,2261,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'d377b785-e362-42ec-a313-aa8663effb89'),
(4543,4537,NULL,2262,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'83627a76-0e3d-492f-8cff-4ca25e457297'),
(4544,4538,NULL,2263,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'320e081f-81e4-49cf-8589-2f862964c7c6'),
(4546,1225,NULL,2264,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:44','2025-10-14 17:11:44',NULL,NULL,NULL,'db1d1a9b-cbea-4520-a808-3c9f98958e4e'),
(4550,1225,NULL,2265,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:12:18','2025-10-14 17:12:18',NULL,NULL,NULL,'b5bd7fa7-d08a-4bc8-b2d9-61ed0ae4bfc8'),
(4551,1727,NULL,2266,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:12:18','2025-10-14 17:12:18',NULL,NULL,NULL,'cbed09d5-9702-46bc-9c7a-3f0d96255787'),
(4552,1728,NULL,2267,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:12:18','2025-10-14 17:12:18',NULL,NULL,NULL,'54501edd-af7e-43f7-ae40-7a242811cab8'),
(4554,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:13:18','2025-10-14 17:13:18',NULL,NULL,NULL,'cef852d6-2fb5-4519-b0ff-d89f0605f204'),
(4562,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-14 17:15:24','2025-10-14 17:15:24',NULL,NULL,NULL,'600068fb-ff31-411e-a90e-487c38e9fae6'),
(4564,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'eed3a0df-460e-48c4-b3a0-dd6c8c2896a3'),
(4565,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'06d9c88d-b971-4654-8dfa-3068dea739e3'),
(4566,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'dc9f7aa8-9707-4692-abad-e4c1ea1ecf09'),
(4567,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'ccee82cc-0492-4171-ae1f-b739d2757ffa'),
(4568,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'5ce11069-c659-4e7b-8c1d-20e59a75eaa7'),
(4569,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'f3dc5f4a-0775-4a23-800f-1203e9bed476'),
(4570,1231,NULL,2268,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'7afd1984-958e-4420-9cd2-f3d4a6c385de'),
(4571,4564,NULL,2269,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'b8578131-53e5-4e6b-b5d0-08a4f5eb337e'),
(4572,4565,NULL,2270,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'30b42fa2-aba5-4e4c-a2dc-273b57c351f3'),
(4573,4566,NULL,2271,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'0fd5ccd7-d4d2-45af-9191-4033166157ab'),
(4574,4567,NULL,2272,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'2162c72f-fe52-4262-9fd9-4af809230213'),
(4575,4568,NULL,2273,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'2632f0dd-494d-48da-aece-f704468fac70'),
(4576,1732,NULL,2274,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'ee1af10e-450e-4ead-8544-5048bca7b3ea'),
(4577,4569,NULL,2275,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'13da8c3e-621a-4b1c-b573-82200a2b1c1d'),
(4579,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:19:40','2025-10-14 17:19:40',NULL,NULL,NULL,'05b33ae5-ec78-4ebf-b8ee-1ae6710a6347'),
(4586,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'7ad8ebd9-a3e2-4600-82f2-a65a4e356091'),
(4587,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'668b57c8-d8f7-4a46-9ad3-85c67e9c0f62'),
(4588,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'af19ece0-a23f-4636-8789-aa0eb064226b'),
(4589,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'e5c24651-bbf2-4dcb-aa17-6ad71472be3d'),
(4590,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'60a0dbf2-4f7e-4136-a2a9-54a2be87c234'),
(4591,1237,NULL,2276,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'e7f7c738-cb8a-46eb-ab6d-fd1b66262f91'),
(4592,4586,NULL,2277,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'a0020084-73cf-4f4b-a4ba-eea7891065d7'),
(4593,4587,NULL,2278,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'36b93d8c-1f2e-4f18-9eaf-1f3ff6217511'),
(4594,4588,NULL,2279,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'cb6498e0-5092-46b6-8c1f-8689536bb6c5'),
(4595,4589,NULL,2280,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'9acae0cb-ffe9-4f35-9fd5-352d1d64d28f'),
(4596,4590,NULL,2281,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'5c7dcf55-a18d-4b00-997f-b93704f0f08e'),
(4598,1237,NULL,2282,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:31','2025-10-14 17:21:31',NULL,NULL,NULL,'abe725f4-503a-4cae-b29f-bdf5a0ddcc4f'),
(4602,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-14 17:22:03','2025-10-14 17:22:03',NULL,NULL,NULL,'383a6331-11d5-40c8-81cd-0607c4cf5bdb'),
(4604,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:22:21','2025-10-14 17:22:21',NULL,NULL,NULL,'76635f82-2344-4382-a6c1-b3b7f934e3e7'),
(4605,1237,NULL,2283,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:22:21','2025-10-14 17:22:21',NULL,NULL,NULL,'41695181-4550-4b7f-ab45-e6761cba831f'),
(4606,4604,NULL,2284,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:22:21','2025-10-14 17:22:21',NULL,NULL,NULL,'d7e8df2d-bdd1-427c-9f67-3a1e35e8f18e'),
(4607,1737,NULL,2285,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:22:21','2025-10-14 17:22:21',NULL,NULL,NULL,'b3cad4f2-662b-4176-8e79-f1a5edf15e1e'),
(4608,1738,NULL,2286,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:22:21','2025-10-14 17:22:21',NULL,NULL,NULL,'99a63734-b4f3-4a3d-a767-663202692d5b'),
(4610,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:22:39','2025-10-14 17:22:39',NULL,NULL,NULL,'fdd5d51e-e354-4dc3-9fd5-bcaba5dbb2b5'),
(4620,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-14 17:25:09','2025-10-14 17:25:09',NULL,NULL,NULL,'74796526-0a42-4379-9ac8-35185d91c54d'),
(4621,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'457c889c-9d82-45fd-af37-25fa40acf6e5'),
(4622,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'7d78fb89-f54b-45ab-a32d-6e414dd5d11c'),
(4623,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'043a221b-80b5-4fab-9a1e-6e331b8fef90'),
(4624,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'be0f3e5e-432b-4c9d-bddf-d4348c9e4df6'),
(4625,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'a3db911a-d735-4aaa-8923-b01c0a50f2e3'),
(4626,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'55ed1e62-5782-4a35-88b4-1298eae4fc89'),
(4627,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'faccd65c-4e98-4888-8cf1-7c1250326c6f'),
(4628,1243,NULL,2287,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'1daa7fd9-3dc6-4e3b-b604-ee487dab060b'),
(4629,4621,NULL,2288,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'2f607fe7-fd6d-45f7-98fc-db98e1cf6373'),
(4630,4622,NULL,2289,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'24b875b6-767d-4f49-8696-2e7eb440d14a'),
(4631,4623,NULL,2290,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'0d328628-ba9a-473b-a6fd-f716f717cef5'),
(4632,4624,NULL,2291,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'dcec9424-6738-4fb8-b479-17e2ab94714d'),
(4633,4625,NULL,2292,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'f452a690-392a-460c-983f-a9a25fbc81ed'),
(4634,4626,NULL,2293,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'cc59f994-c547-4b8a-bfe0-ae37c63f9317'),
(4635,4627,NULL,2294,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'807bc6f6-93ff-493c-b532-c9511c188cc3'),
(4636,1742,NULL,2295,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'83d04946-40da-4282-afad-119663375a3a'),
(4637,1743,NULL,2296,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'2a68ab8b-0908-499d-a18d-db7682c9efcc'),
(4639,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:25:32','2025-10-14 17:25:32',NULL,NULL,NULL,'74593d4f-e93c-4be4-92ec-014eacadbcd6'),
(4645,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'0e702e8a-e341-45c4-97df-72c181ea7994'),
(4646,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'bad14890-e510-4357-bee8-b0b3794a1923'),
(4647,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'ac378203-56ce-489b-9e06-153ad7823d6a'),
(4648,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'23468d9c-8484-442d-9ff4-31092d7a7add'),
(4649,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'ab6bc909-f6de-484e-9a62-59750bfd55be'),
(4650,1249,NULL,2297,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'64e385be-6057-4b44-8933-c1207fab5e0b'),
(4651,4645,NULL,2298,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'4be058f4-0c90-4731-802c-35f66c2e6cba'),
(4652,4646,NULL,2299,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'09a01c49-a1d3-4d56-bc4e-3ad5f5e132ff'),
(4653,4647,NULL,2300,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'8b1bb8ba-221f-4b5d-ba39-cde94be186f0'),
(4654,4648,NULL,2301,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'5e46dc51-f861-4e30-a40b-687ac6b5d06a'),
(4655,4649,NULL,2302,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'93656225-8e67-4043-82bd-0ffe3ce27796'),
(4660,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:28:10','2025-10-14 17:28:10',NULL,NULL,NULL,'10e12fd7-e5d3-46a4-baa3-188fd6ef0612'),
(4661,1249,NULL,2303,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:28:09','2025-10-14 17:28:10',NULL,NULL,NULL,'4ceb31fb-5899-4005-9e38-740ad54babb0'),
(4662,4660,NULL,2304,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:28:10','2025-10-14 17:28:10',NULL,NULL,NULL,'70cb7f38-49c8-4f10-8d0a-d9c96c251617'),
(4663,1747,NULL,2305,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:28:10','2025-10-14 17:28:10',NULL,NULL,NULL,'3d870c27-a45d-4bbb-ad5b-e1741bdfad80'),
(4664,1748,NULL,2306,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:28:10','2025-10-14 17:28:10',NULL,NULL,NULL,'b75d6c0f-ba4b-4571-bf91-14a97e12cbd4'),
(4666,1481,NULL,2307,1,'craft\\elements\\Entry',1,0,'2025-10-14 20:32:10','2025-10-14 20:32:11',NULL,NULL,NULL,'9d0f1764-93cc-41d0-b219-16f4eb6b7cbc'),
(4668,1473,NULL,2308,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:16:00','2025-10-16 19:16:00',NULL,NULL,NULL,'f9afb73a-d7be-4f58-91fc-19cd970ce311'),
(4670,1473,NULL,2309,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:16:56','2025-10-16 19:16:56',NULL,NULL,NULL,'6a6d191d-920d-40b6-8fad-e8e14a7b31a0'),
(4674,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:18:57','2025-10-16 19:18:57',NULL,NULL,NULL,'fbd37b4c-3ee5-4e6e-96fd-2e6890abf734'),
(4675,1473,NULL,2310,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:18:56','2025-10-16 19:18:57',NULL,NULL,NULL,'1213038a-d086-4519-8002-90362dbcafd7'),
(4676,1935,NULL,2311,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:18:56','2025-10-16 19:18:57',NULL,NULL,NULL,'599d06d9-6cc5-4b7f-b9dd-5216dc01e0b0'),
(4677,4674,NULL,2312,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:18:57','2025-10-16 19:18:57',NULL,NULL,NULL,'91d17638-5c30-4b0c-a090-bad014627de7'),
(4679,1477,NULL,2313,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:19:28','2025-10-16 19:19:28',NULL,NULL,NULL,'a93bf8df-fd4d-486c-a098-d8427ec86674'),
(4681,1477,NULL,2314,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:19:52','2025-10-16 19:19:52',NULL,NULL,NULL,'31a56416-a8be-4f9b-8142-a72dcbc90354'),
(4683,1477,NULL,2315,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:20:30','2025-10-16 19:20:30',NULL,NULL,NULL,'ee5df520-098e-4b42-8319-40b516bc7b06'),
(4687,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:21:39','2026-01-06 16:51:36',NULL,NULL,NULL,'d2038a75-b8b6-4834-b69b-aecdebbfc4b0'),
(4688,1477,NULL,2316,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:21:39','2025-10-16 19:21:39',NULL,NULL,NULL,'a19273b7-d279-4649-ad42-8d7e38bf4439'),
(4689,1938,NULL,2317,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:21:39','2025-10-16 19:21:39',NULL,NULL,NULL,'3df73f4e-5719-42f2-8c34-fa69abe66925'),
(4690,4687,NULL,2318,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:21:39','2025-10-16 19:21:39',NULL,NULL,NULL,'8e8df349-71ae-4c28-9fbf-abd27c82dc6f'),
(4692,1481,NULL,2319,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:22:12','2025-10-16 19:22:12',NULL,NULL,NULL,'967c485a-f58a-4ea7-8002-5e49ad57d0b6'),
(4694,1481,NULL,2320,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:22:20','2025-10-16 19:22:21',NULL,NULL,NULL,'28de5d00-dd4c-4901-93a8-c311076939df'),
(4696,1481,NULL,2321,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:22:51','2025-10-16 19:22:51',NULL,NULL,NULL,'8ad33643-7085-4473-acc2-7711530a532f'),
(4700,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:23:32','2025-10-16 19:23:32',NULL,NULL,NULL,'d13c6438-2e1a-4a10-8926-b89b3716428c'),
(4701,1481,NULL,2322,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:23:32','2025-10-16 19:23:32',NULL,NULL,NULL,'906198c9-aab0-4d1f-b20e-8c0979d57859'),
(4702,1941,NULL,2323,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:23:32','2025-10-16 19:23:32',NULL,NULL,NULL,'0b6800da-7ec9-4778-a329-abd93467f4c9'),
(4703,4700,NULL,2324,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:23:32','2025-10-16 19:23:32',NULL,NULL,NULL,'f608a7da-2528-46c3-ab5b-1baa561302b5'),
(4704,1255,NULL,2325,1,'craft\\elements\\Entry',1,0,'2025-10-16 20:22:32','2025-10-16 20:22:32',NULL,NULL,NULL,'41cb8070-3d63-404f-a000-5e57771e069f'),
(4706,1437,NULL,2326,1,'craft\\elements\\Entry',1,0,'2025-10-22 18:20:15','2025-10-22 18:20:15',NULL,NULL,NULL,'8f0080f8-74d4-4d05-b204-0be9d78dade2'),
(4707,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-22 23:42:42','2025-10-22 23:42:42',NULL,NULL,NULL,'29bbd7b6-11b1-49e9-8e0c-935df9a51681'),
(4710,1437,NULL,2327,1,'craft\\elements\\Entry',1,0,'2025-10-22 23:46:58','2025-10-22 23:46:58',NULL,NULL,NULL,'b37d08a9-0ed9-4ef8-8674-f40e25d732ec'),
(4712,1437,NULL,2328,1,'craft\\elements\\Entry',1,0,'2025-10-22 23:47:07','2025-10-22 23:47:07',NULL,NULL,NULL,'9b4b6d0b-5784-437c-a2e8-d637c2fd55de'),
(4713,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-22 23:50:26','2025-10-22 23:50:26',NULL,NULL,NULL,'7a23257d-71ad-4481-87a6-c1a404b346f4'),
(4716,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:10:04','2025-10-23 00:10:04',NULL,NULL,NULL,'dd667d04-54fb-44d4-9c05-a4d480a92ff1'),
(4718,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:17:45','2025-10-23 00:17:45',NULL,NULL,NULL,'56c85468-bb1c-4e9a-977c-ee15b038f8a2'),
(4720,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:20:15','2025-10-23 00:20:15',NULL,NULL,NULL,'74182867-2ee6-4181-8ed6-1cbe72dd2fca'),
(4722,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:22:05','2025-10-23 00:22:05',NULL,NULL,NULL,'6896d554-4993-4d93-a4d0-73af086ca151'),
(4724,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:25:34','2025-10-23 00:25:34',NULL,NULL,NULL,'c0e2bc14-cb69-46dd-a602-9c886b48ce54'),
(4726,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:33:13','2025-10-23 00:33:13',NULL,NULL,NULL,'35ccae51-8aba-47fd-b222-cf792fcc9e12'),
(4728,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:34:41','2025-10-23 00:34:41',NULL,NULL,NULL,'91c1fdcd-6700-4cc2-afce-71812abb4549'),
(4730,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:52:01','2025-10-23 00:52:01',NULL,NULL,NULL,'86a80071-5350-42c8-bed7-a2560fccd00c'),
(4732,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:05:29','2025-10-23 01:05:29',NULL,NULL,NULL,'30818cba-d2e5-4621-84cb-f2ca982dc5ca'),
(4734,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:09:45','2025-10-23 01:09:45',NULL,NULL,NULL,'e0e3ecaf-87ca-4a89-9acd-ab7aab201579'),
(4736,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:11:03','2025-10-23 01:11:03',NULL,NULL,NULL,'ace48b90-eaf4-4c4f-a0c0-81d226b766c2'),
(4737,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:11:44','2025-10-23 01:11:44',NULL,NULL,NULL,'6bbaca74-7dde-4323-b985-a9678bbfc61a'),
(4739,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:12:39','2025-10-23 01:12:39',NULL,NULL,NULL,'f59036b0-5d28-4369-a0da-179f9da2d154'),
(4740,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:12:49','2025-10-23 01:12:49',NULL,NULL,NULL,'088ebcb3-0291-4e3a-a023-dc4262a0e478'),
(4741,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:13:08','2025-10-23 01:13:08',NULL,NULL,NULL,'86efacc0-a0e2-4813-8af8-5a1594658b9c'),
(4748,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:20:15','2025-10-23 01:20:15',NULL,NULL,NULL,'17ed538a-43b2-47b2-952b-d96fa26c294c'),
(4749,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:21:51','2025-10-23 01:21:51',NULL,NULL,NULL,'5902870a-1bbc-49dd-ace0-b2be8a2ac54b'),
(4752,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:22:16','2025-10-23 01:22:16',NULL,NULL,NULL,'208c5b19-b632-4b7e-a114-5d66310e1e48'),
(4753,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:24:10','2025-10-23 01:24:10',NULL,NULL,NULL,'d32523f7-f8b4-477b-9104-3b832d8403f9'),
(4754,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:27:32','2025-10-23 01:27:32',NULL,NULL,NULL,'892582f2-a589-4cd6-8fb4-cc0b5247fb8d'),
(4758,1437,NULL,2329,1,'craft\\elements\\Entry',1,0,'2025-10-23 01:33:57','2025-10-23 01:33:57',NULL,NULL,NULL,'fde6898d-be84-4920-bb51-c4017964d0e1'),
(4759,2,NULL,2330,1,'craft\\elements\\Entry',1,0,'2025-10-23 01:34:07','2025-10-23 01:34:07',NULL,NULL,NULL,'7fa3fd59-fc02-43af-b19a-1cb4d543ff70'),
(4760,2,NULL,2331,1,'craft\\elements\\Entry',1,0,'2025-10-23 01:39:13','2025-10-23 01:39:13',NULL,NULL,NULL,'2ecdf06d-e3f6-46c9-bec6-e9cf7177196f'),
(4761,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-25 19:31:10','2025-10-25 19:31:10',NULL,NULL,NULL,'d3978b1b-d440-45a1-af84-b37e896ca89e'),
(4762,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-26 19:36:23','2025-10-26 19:36:23',NULL,NULL,NULL,'02d6064e-cbea-4f0b-ac59-27ec94dd841f'),
(4768,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-27 15:16:45','2026-01-19 17:16:04',NULL,NULL,NULL,'6769ab48-ddb8-45e5-86dc-9a1ac1ecc2eb'),
(4769,2,NULL,2332,1,'craft\\elements\\Entry',1,0,'2025-10-27 15:16:45','2025-10-27 15:16:45',NULL,NULL,NULL,'d9c0d1c5-2e03-474a-b3c0-2741e481097c'),
(4770,4768,NULL,2333,2,'craft\\elements\\Entry',1,0,'2025-10-27 15:16:45','2025-10-27 15:16:45',NULL,NULL,NULL,'3c4b14c1-7f3c-41c5-98f3-6c36fe53a257'),
(4774,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-27 19:18:25','2025-10-27 19:18:25',NULL,NULL,NULL,'c683d921-b9f5-425d-9aa9-d5753c8a0d78'),
(4776,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-29 19:06:42','2025-10-29 19:06:42',NULL,NULL,NULL,'a5153218-617a-42ef-b6ad-3cae0c0a08aa'),
(4777,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-30 06:51:48','2025-10-30 06:51:48',NULL,NULL,NULL,'684b26ce-d5c9-4e37-9a35-745a1d1bbb31'),
(4778,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-30 07:17:08','2025-10-30 07:17:08',NULL,NULL,NULL,'44b6c93a-ad2c-4ea1-9073-e37f3fcc8587'),
(4779,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-30 07:26:39','2025-10-30 07:26:39',NULL,NULL,NULL,'f553c7d1-e259-4646-aaf9-1614139c2934'),
(4784,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-04 14:23:45','2025-11-04 14:23:45',NULL,NULL,NULL,'335fe67c-5a5c-49e9-93c9-7500b4d2d1f1'),
(4786,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 15:00:00','2025-11-04 15:00:00',NULL,NULL,NULL,'5643bbda-5b2c-485e-8a21-fb842197d361'),
(4792,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-04 15:03:21','2025-11-04 15:03:21',NULL,NULL,NULL,'da82d0d1-37bc-4799-bc75-8f504336d8de'),
(4793,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-04 15:03:21','2025-11-04 15:03:21',NULL,NULL,NULL,'d9bd54e0-2c9b-4cad-8cb6-4a349033d50c'),
(4794,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-04 15:03:21','2025-11-04 15:03:21',NULL,NULL,NULL,'48b4391d-76ae-453c-a74c-048eff78938e'),
(4795,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-04 15:03:21','2025-11-04 15:03:21',NULL,NULL,NULL,'7087d62d-5bf9-48a3-adbc-8bd3c8ece171'),
(4796,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-04 15:03:21','2025-11-04 15:03:21',NULL,NULL,NULL,'84042f22-fc31-4f11-b99d-b864643864f9'),
(4797,1255,NULL,2334,1,'craft\\elements\\Entry',1,0,'2025-11-04 15:03:21','2025-11-04 15:03:21',NULL,NULL,NULL,'b50c0aa4-9408-41fd-a7cb-3f1d79f67020'),
(4798,4792,NULL,2335,3,'craft\\elements\\Entry',1,0,'2025-11-04 15:03:21','2025-11-04 15:03:21',NULL,NULL,NULL,'dd08ea39-9d4e-40a6-a5c5-5c4e5d4fc684'),
(4799,4793,NULL,2336,3,'craft\\elements\\Entry',1,0,'2025-11-04 15:03:21','2025-11-04 15:03:21',NULL,NULL,NULL,'7131decd-314f-495a-94b1-8fb73dbf1057'),
(4800,4794,NULL,2337,3,'craft\\elements\\Entry',1,0,'2025-11-04 15:03:21','2025-11-04 15:03:21',NULL,NULL,NULL,'2067675e-fef0-4ec3-a558-a0fbcfd4a20c'),
(4801,4795,NULL,2338,3,'craft\\elements\\Entry',1,0,'2025-11-04 15:03:21','2025-11-04 15:03:21',NULL,NULL,NULL,'27ddad1e-20cd-4bc5-ad5b-b1720cb44965'),
(4802,4796,NULL,2339,3,'craft\\elements\\Entry',1,0,'2025-11-04 15:03:21','2025-11-04 15:03:21',NULL,NULL,NULL,'653e8cf7-ad47-4d60-b1da-072017df9640'),
(4804,1255,NULL,2340,1,'craft\\elements\\Entry',1,0,'2025-11-04 15:05:06','2025-11-04 15:05:06',NULL,NULL,NULL,'77ef224b-a643-4904-a023-e4a16d9fb35f'),
(4806,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 15:06:38','2026-01-19 16:23:19',NULL,NULL,NULL,'3db1afb9-00ac-4791-98e3-1b9fd16ae0d9'),
(4807,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 15:06:41','2026-01-19 16:23:30',NULL,NULL,NULL,'9d03f855-b91f-42f8-94cc-7a43bb15403e'),
(4808,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 15:06:43','2026-01-19 16:24:17',NULL,NULL,NULL,'15a3687b-83a9-46d1-bf4a-4e8eae9b847f'),
(4809,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 15:06:47','2026-01-19 16:23:56',NULL,NULL,NULL,'aa2cbac7-6a30-41af-9876-503d44e35619'),
(4810,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 15:06:50','2026-01-19 16:24:07',NULL,NULL,NULL,'94bae281-5710-46d7-a2f5-95cc5cc4256c'),
(4811,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 15:06:51','2025-11-04 15:06:51',NULL,NULL,NULL,'930fb21d-ea48-45cd-b73d-c6bf964af664'),
(4812,1255,NULL,2341,1,'craft\\elements\\Entry',1,0,'2025-11-04 15:07:03','2025-11-04 15:07:03',NULL,NULL,NULL,'5b0fd7bc-95e0-4316-948e-29a147fe5cdc'),
(4815,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-04 15:08:51','2025-11-04 15:08:51',NULL,NULL,NULL,'eb53f4b6-87e6-421d-87ac-cce4a42bedfd'),
(4817,1255,NULL,2342,1,'craft\\elements\\Entry',1,0,'2025-11-04 15:09:30','2025-11-04 15:09:31',NULL,NULL,NULL,'0757dd41-356d-4e51-a5b8-ab8dbb48fbcb'),
(4818,1752,NULL,2343,2,'craft\\elements\\Entry',1,0,'2025-11-04 15:09:31','2025-11-04 15:09:31',NULL,NULL,NULL,'68c8fda9-c136-4856-902a-e7b70f089db1'),
(4819,1753,NULL,2344,2,'craft\\elements\\Entry',1,0,'2025-11-04 15:09:31','2025-11-04 15:09:31',NULL,NULL,NULL,'267a529f-d5a1-45af-850c-e444dec632e7'),
(4820,2,NULL,2345,1,'craft\\elements\\Entry',1,0,'2025-11-04 15:10:15','2025-11-04 15:10:15',NULL,NULL,NULL,'04bfb364-4226-4df6-87dc-81ae966a0690'),
(4821,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 15:12:17','2025-11-04 15:12:17',NULL,NULL,NULL,'fe2d3641-56ae-4cc6-b9c9-e27b68eea7e5'),
(4822,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 15:12:25','2025-11-04 15:12:25',NULL,NULL,NULL,'6064566d-03f4-43d7-81a1-abde531dd0bd'),
(4823,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 15:12:31','2025-11-04 15:12:31',NULL,NULL,NULL,'d8030d1a-082c-41dc-ba84-9649a9fd4508'),
(4824,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 15:12:38','2025-11-04 15:12:38',NULL,NULL,NULL,'d71f34b6-79af-4615-b743-e169e7e17353'),
(4826,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:13:05','2025-11-04 19:13:05',NULL,NULL,NULL,'b4ca5751-7da2-4970-9651-9c71350870fa'),
(4827,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:13:16','2025-11-04 19:13:16',NULL,NULL,NULL,'05e6ba1e-c7ed-49f0-967f-cd328ff2e0a5'),
(4828,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:14:37','2025-11-04 19:14:37',NULL,NULL,NULL,'731be959-9df0-4221-b319-a7443ffb72b8'),
(4829,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:14:44','2026-01-14 16:19:42',NULL,NULL,NULL,'c34fc51f-0220-43bf-9323-35ec80ddc4d2'),
(4830,1045,NULL,2346,1,'craft\\elements\\Entry',1,0,'2025-11-04 19:14:54','2025-11-04 19:14:54',NULL,NULL,NULL,'e315d0ff-ee69-4a7e-96ee-5a29b8bac11b'),
(4832,1045,NULL,2347,1,'craft\\elements\\Entry',1,0,'2025-11-04 19:15:35','2025-11-04 19:15:35',NULL,NULL,NULL,'7402defc-f5e4-420e-809e-4562804fb179'),
(4834,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:50:10','2026-01-16 20:35:32',NULL,NULL,NULL,'ba458bee-a6ca-4307-80d5-16e14295e092'),
(4835,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:50:19','2025-11-04 19:50:19',NULL,NULL,NULL,'ed3c1a7b-3254-4a1c-bedd-e697a5005591'),
(4836,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:50:25','2026-01-16 20:37:02',NULL,NULL,NULL,'aa8e5b12-d758-4fde-b3d5-7dc02647bca1'),
(4837,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:50:31','2026-01-16 20:37:22',NULL,NULL,NULL,'ecbf1378-44bb-4b9d-b654-4a89f6365fea'),
(4838,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:50:38','2026-01-16 20:37:30',NULL,NULL,NULL,'5ea66ef9-9d14-45d7-b465-28607f9e9968'),
(4839,1171,NULL,2348,1,'craft\\elements\\Entry',1,0,'2025-11-04 19:51:07','2025-11-04 19:51:07',NULL,NULL,NULL,'d583467e-e454-4bb6-9138-bae34d1ecc60'),
(4841,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:53:50','2025-11-04 19:53:50',NULL,NULL,NULL,'dc947646-86a2-4362-9aca-722c2ee841e8'),
(4842,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:53:58','2025-11-04 19:53:58',NULL,NULL,NULL,'75700b53-2049-4a8b-b69a-9a6c4fb5324e'),
(4843,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:54:03','2025-11-04 19:54:03',NULL,NULL,NULL,'64927ef2-e032-49e4-88ce-80cee8a58fdb'),
(4844,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:54:16','2025-11-04 19:54:16',NULL,NULL,NULL,'8141fdea-2ad9-4995-b68a-9a0c7ba583cb'),
(4845,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:54:20','2025-11-04 19:54:20',NULL,NULL,NULL,'e4e2213a-962f-4bb9-95f8-67d10939be21'),
(4846,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 19:54:27','2025-11-04 19:54:27',NULL,NULL,NULL,'27b9e5c6-2ccc-40cb-b534-e971a2f11f11'),
(4849,945,NULL,2349,1,'craft\\elements\\Entry',1,0,'2025-11-04 20:24:44','2025-11-04 20:24:44',NULL,NULL,NULL,'704a56bb-04ce-429f-92e7-889b242c5278'),
(4850,1494,NULL,2350,2,'craft\\elements\\Entry',1,0,'2025-11-04 20:24:44','2025-11-04 20:24:44',NULL,NULL,NULL,'74306436-8777-428c-a925-603bfbff20db'),
(4851,1495,NULL,2351,2,'craft\\elements\\Entry',1,0,'2025-11-04 20:24:44','2025-11-04 20:24:44',NULL,NULL,NULL,'74716d80-29cb-4937-bb4c-2ba69697d792'),
(4855,951,NULL,2352,1,'craft\\elements\\Entry',1,0,'2025-11-04 20:33:01','2025-11-04 20:33:01',NULL,NULL,NULL,'82837170-7f19-4b8b-a584-afa3e15d4e7c'),
(4857,945,NULL,2353,1,'craft\\elements\\Entry',1,0,'2025-11-04 20:33:48','2025-11-04 20:33:48',NULL,NULL,NULL,'86ac203f-42a7-41d6-9fd2-edbd152229ca'),
(4859,945,NULL,2354,1,'craft\\elements\\Entry',1,0,'2025-11-04 20:33:51','2025-11-04 20:33:51',NULL,NULL,NULL,'df5e2d91-ff93-431f-89c5-297088c87ed0'),
(4861,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 20:53:19','2025-11-04 20:53:19',NULL,NULL,NULL,'18592e06-d9ab-488e-85b8-a035c713d75f'),
(4867,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:54:58','2025-11-04 20:54:58',NULL,NULL,NULL,'837ed365-d09d-4f4d-82f6-602a87aa64bb'),
(4868,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:54:58','2025-11-04 20:54:58',NULL,NULL,NULL,'0bfc051c-7e93-45da-9500-52ea68be51c3'),
(4869,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:54:58','2025-11-04 20:54:58',NULL,NULL,NULL,'44a8de49-032c-4d27-b9c2-fff24208ed60'),
(4870,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:54:58','2025-11-04 20:54:58',NULL,NULL,NULL,'56b4c8ae-5625-4ebf-aaea-4a5e2385c3d3'),
(4871,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:54:58','2025-11-04 20:54:58',NULL,NULL,NULL,'76b700c6-9eda-4fd6-bc0f-f03f57381aa9'),
(4872,1261,NULL,2355,1,'craft\\elements\\Entry',1,0,'2025-11-04 20:54:58','2025-11-04 20:54:58',NULL,NULL,NULL,'4e25732f-0ccc-4d3f-822b-e4dfc3ea2d4b'),
(4873,4867,NULL,2356,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:54:58','2025-11-04 20:54:58',NULL,NULL,NULL,'c5dd82d1-64dc-4947-91af-2b8ac29f4d3c'),
(4874,4868,NULL,2357,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:54:58','2025-11-04 20:54:58',NULL,NULL,NULL,'176593dd-0d20-438c-b1c1-e6da938ae7d3'),
(4875,4869,NULL,2358,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:54:58','2025-11-04 20:54:58',NULL,NULL,NULL,'5dee4310-f480-4ecc-962b-2c117f36631f'),
(4876,4870,NULL,2359,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:54:58','2025-11-04 20:54:58',NULL,NULL,NULL,'05e05bcd-034b-497a-9a19-cc8afac2da06'),
(4877,4871,NULL,2360,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:54:58','2025-11-04 20:54:58',NULL,NULL,NULL,'a1f4244f-97fa-4c79-9bcd-01a6c3cba21c'),
(4879,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 20:56:08','2025-11-04 20:56:08',NULL,NULL,NULL,'768ab1f1-f79b-402f-93d2-4a19457d1680'),
(4880,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 20:56:09','2025-11-04 20:56:09',NULL,NULL,NULL,'0fa3fb20-1a11-4d18-bb77-f324726ee171'),
(4881,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 20:56:11','2025-11-04 20:56:11',NULL,NULL,NULL,'031b87a6-aea5-4219-8ca3-f193f2e19567'),
(4882,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 20:56:13','2025-11-04 20:56:13',NULL,NULL,NULL,'dfc92a1f-5793-43a3-8370-1ae771f0558f'),
(4883,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 20:56:14','2025-11-04 20:56:14',NULL,NULL,NULL,'7196e89d-a692-47f3-92a4-61cb16eaad6d'),
(4884,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 20:56:17','2025-11-04 20:56:17',NULL,NULL,NULL,'ee58204e-a184-4ed9-8f75-77b1af2d2dbe'),
(4885,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 20:56:19','2025-11-04 20:56:19',NULL,NULL,NULL,'45100fa9-60e9-453f-a98f-b633d6de7bca'),
(4886,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 20:56:21','2025-11-04 20:56:21',NULL,NULL,NULL,'b3296158-9363-4a73-9a39-0826744631f9'),
(4887,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 20:56:23','2025-11-04 20:56:23',NULL,NULL,NULL,'b3359113-b65d-455c-8e12-de73b6c22f63'),
(4888,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 20:56:24','2025-11-04 20:56:24',NULL,NULL,NULL,'824db2de-11c0-4ab3-bf04-9f585e9cd9e1'),
(4889,1261,NULL,2361,1,'craft\\elements\\Entry',1,0,'2025-11-04 20:56:34','2025-11-04 20:56:34',NULL,NULL,NULL,'4c5c492b-b97e-49a3-86ea-d9ab690c1c93'),
(4893,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:57:09','2025-11-04 20:57:09',NULL,NULL,NULL,'6e7d44c8-640d-4964-a3e8-6a045647d4da'),
(4894,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:57:09','2025-11-04 20:57:09',NULL,NULL,NULL,'618e2ea7-de18-4759-85cb-d23b3e28f328'),
(4895,1261,NULL,2362,1,'craft\\elements\\Entry',1,0,'2025-11-04 20:57:09','2025-11-04 20:57:09',NULL,NULL,NULL,'da1993ff-33fc-4433-bb98-5083a0858ffc'),
(4896,4893,NULL,2363,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:57:09','2025-11-04 20:57:09',NULL,NULL,NULL,'c2de00d0-af6f-4593-b7c5-6ddfee30ae25'),
(4897,4894,NULL,2364,3,'craft\\elements\\Entry',1,0,'2025-11-04 20:57:09','2025-11-04 20:57:09',NULL,NULL,NULL,'2f843081-579c-4d70-98bd-e289ab6a0b0f'),
(4900,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-04 20:57:58','2025-11-04 20:58:09',NULL,NULL,NULL,'c0f2f305-e222-44d0-955c-900553496c9b'),
(4902,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-04 20:58:26','2025-11-04 20:58:36',NULL,NULL,NULL,'6e400e80-5917-47f5-b6f1-ab8629199cc9'),
(4904,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-11-04 20:58:46','2025-11-04 20:58:46',NULL,NULL,NULL,'efb6da59-e899-4cc8-b18e-5fc21602fd70'),
(4905,1261,NULL,2365,1,'craft\\elements\\Entry',1,0,'2025-11-04 20:58:46','2025-11-04 20:58:46',NULL,NULL,NULL,'ef063ada-f8eb-4cf9-8756-2662b666ce27'),
(4906,4904,NULL,2366,2,'craft\\elements\\Entry',1,0,'2025-11-04 20:58:46','2025-11-04 20:58:46',NULL,NULL,NULL,'8f208ee7-b2d4-47a8-80ae-a8f532571cc6'),
(4907,1759,NULL,2367,2,'craft\\elements\\Entry',1,0,'2025-11-04 20:58:46','2025-11-04 20:58:46',NULL,NULL,NULL,'5d2e5753-b140-415c-99c5-06e0d5c51442'),
(4909,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:00:17','2025-11-04 21:00:17',NULL,NULL,NULL,'aaf82f03-4e82-4c10-be62-ce923cfa061b'),
(4910,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:00:26','2025-11-04 21:00:26',NULL,NULL,NULL,'2bdf3ef0-3539-4fed-9b64-799acecf8e6c'),
(4911,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:00:35','2025-11-04 21:00:35',NULL,NULL,NULL,'b3132d30-033b-4277-93c9-1e5c9836fcb9'),
(4912,1177,NULL,2368,1,'craft\\elements\\Entry',1,0,'2025-11-04 21:00:49','2025-11-04 21:00:49',NULL,NULL,NULL,'0e20fc1f-a2b1-4aa2-a69f-c36291794263'),
(4914,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-04 21:01:24','2025-11-04 21:01:24',NULL,NULL,NULL,'a8727123-cd27-417a-9e62-c7070426f0ad'),
(4916,1177,NULL,2369,1,'craft\\elements\\Entry',1,0,'2025-11-04 21:01:32','2025-11-04 21:01:32',NULL,NULL,NULL,'e3f22738-7fe1-4905-8760-d0665ead6d1e'),
(4917,1693,NULL,2370,2,'craft\\elements\\Entry',1,0,'2025-11-04 21:01:32','2025-11-04 21:01:32',NULL,NULL,NULL,'f4c16c15-57fe-4d71-b28f-7731142b8340'),
(4920,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:06:29','2025-11-04 21:06:29',NULL,NULL,NULL,'2ec63550-88f4-45c2-87cb-857f8c6d9e24'),
(4921,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:06:35','2025-11-04 21:06:35',NULL,NULL,NULL,'b257829b-0f82-401f-95a5-e9f6fe973875'),
(4922,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:06:39','2026-01-12 19:55:31',NULL,NULL,NULL,'98b87cd0-6ae6-45b6-b02c-ed0080216f1d'),
(4923,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:06:47','2025-11-04 21:06:47',NULL,NULL,NULL,'133b15f5-0ab3-4966-9f07-a73407e10810'),
(4924,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:06:53','2025-11-04 21:06:53',NULL,NULL,NULL,'ee14c79f-fd6e-4f44-9cc4-742e1cb4bdc8'),
(4925,957,NULL,2371,1,'craft\\elements\\Entry',1,0,'2025-11-04 21:08:43','2025-11-04 21:08:43',NULL,NULL,NULL,'b2c5eb4f-d0fa-4066-ad50-b1241156ba29'),
(4927,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:17:08','2025-11-04 21:17:08',NULL,NULL,NULL,'0de17528-b618-405a-a02b-771cf0832f11'),
(4928,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:17:10','2026-01-13 15:59:56',NULL,'2026-01-13 15:59:56',NULL,'d503ea7f-95ec-4c03-a139-55ed00464ca4'),
(4929,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:17:14','2025-11-04 21:17:14',NULL,NULL,NULL,'9272fbcb-7603-4320-8dc1-8106b45b5df1'),
(4930,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:17:16','2025-11-04 21:17:16',NULL,NULL,NULL,'73eef64b-5452-4541-ac15-55a298b11538'),
(4931,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:17:19','2025-11-04 21:17:19',NULL,NULL,NULL,'a87123a3-0513-4394-ae2d-3ac4e608166a'),
(4932,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:18:03','2025-11-04 21:18:03',NULL,NULL,NULL,'e42404e7-2d48-4e82-bb43-2aef2b01b290'),
(4933,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:18:09','2025-11-04 21:18:09',NULL,NULL,NULL,'22a6c653-6dd6-43bf-ad0f-cbf865e03ab7'),
(4934,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:18:12','2025-11-04 21:18:12',NULL,NULL,NULL,'da4c2cb3-1440-4733-80a0-b5eb1452b68b'),
(4935,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-04 21:18:50','2025-11-04 21:18:50',NULL,NULL,NULL,'131e5bab-fb8c-4db7-9eaa-e6c8317c0955'),
(4936,963,NULL,2372,1,'craft\\elements\\Entry',1,0,'2025-11-04 21:19:01','2025-11-04 21:19:01',NULL,NULL,NULL,'eb1f418f-dbbc-4974-b338-431fefe3ad6a'),
(4938,963,NULL,2373,1,'craft\\elements\\Entry',1,0,'2025-11-04 21:19:11','2025-11-04 21:19:11',NULL,NULL,NULL,'d04076b8-400f-4bc9-a26c-4bf53fb2e8f0'),
(4944,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-05 16:07:42','2025-11-05 17:40:20',NULL,NULL,NULL,'9d9e9565-da84-4bd9-9ce2-756678c2a761'),
(4945,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 16:07:55','2026-01-19 16:19:29',NULL,NULL,NULL,'896fc980-2d6e-443d-bab8-cb3c17ebcef3'),
(4946,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 16:07:55','2025-11-05 16:07:55',NULL,NULL,NULL,'9a82f1f7-929e-478f-9ce7-6f246d604de5'),
(4947,1255,NULL,2374,1,'craft\\elements\\Entry',1,0,'2025-11-05 16:07:55','2025-11-05 16:07:55',NULL,NULL,NULL,'46efe508-357e-4b89-a05e-276d6feb8c0b'),
(4948,4945,NULL,2375,21,'craft\\elements\\Entry',1,0,'2025-11-05 16:07:55','2025-11-05 16:07:55',NULL,NULL,NULL,'597252cd-42bd-4b6d-ba49-d37f8a8e8ad4'),
(4949,4946,NULL,2376,21,'craft\\elements\\Entry',1,0,'2025-11-05 16:07:55','2025-11-05 16:07:55',NULL,NULL,NULL,'70c0b04a-1b3a-48b8-b781-a5253f342163'),
(4951,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-05 16:13:59','2025-11-05 17:40:21',NULL,NULL,NULL,'8f9d1ac8-ab47-4507-a713-776003e5dd5e'),
(4955,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:09:39','2025-11-05 17:09:39',NULL,NULL,NULL,'3f7c8245-371b-4205-8813-4df91afb8259'),
(4956,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:09:45','2026-01-14 20:13:12',NULL,NULL,NULL,'1b592952-279d-4e00-9be9-44c2150ba3eb'),
(4957,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:09:50','2026-01-14 20:13:25',NULL,NULL,NULL,'782dd0e6-d160-456a-b996-433462cf89ea'),
(4958,1143,NULL,2377,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:09:58','2025-11-05 17:09:58',NULL,NULL,NULL,'6999390f-f382-4eba-a229-1c1c136752d9'),
(4962,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-05 17:12:14','2025-11-05 17:40:20',NULL,NULL,NULL,'3aee7c35-768a-4490-8153-389a750a311e'),
(4964,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:12:54','2025-11-05 17:12:54',NULL,NULL,NULL,'ae6edb3e-e11c-427a-a218-9941d554b174'),
(4965,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:12:54','2025-11-05 17:12:54',NULL,NULL,NULL,'cb0a7627-066d-40b2-8ae4-b15b7b68eecd'),
(4966,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:12:54','2025-11-05 17:12:54',NULL,NULL,NULL,'b7317b41-1a71-4933-b5ef-dce89d0f392b'),
(4967,1143,NULL,2378,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:12:54','2025-11-05 17:12:54',NULL,NULL,NULL,'b9a17ce3-ba4b-466c-be3d-50dfc87222e0'),
(4968,4964,NULL,2379,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:12:54','2025-11-05 17:12:54',NULL,NULL,NULL,'c6e13175-5cee-4a5e-9a11-73060c12c34e'),
(4969,4965,NULL,2380,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:12:54','2025-11-05 17:12:54',NULL,NULL,NULL,'d09e0f24-4e5a-4ef3-994e-b152a422d97b'),
(4970,4966,NULL,2381,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:12:54','2025-11-05 17:12:54',NULL,NULL,NULL,'1a915895-f8a0-461b-986f-21ec44027d25'),
(4973,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:14:28','2025-11-05 17:14:28',NULL,NULL,NULL,'e5e3086f-f3d6-48ed-bdb7-09a543f6a56f'),
(4979,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:16:49','2026-01-17 15:05:50',NULL,NULL,NULL,'ab50c48e-3991-4e28-8089-05d07a5f065e'),
(4980,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:16:49','2025-11-05 17:16:49',NULL,NULL,NULL,'4e71b4fb-4043-4357-a371-48a37f067582'),
(4981,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:16:49','2025-11-05 17:16:49',NULL,NULL,NULL,'da88441a-b534-4f9a-8078-166dcf10ee25'),
(4982,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:16:49','2025-11-05 17:16:49',NULL,NULL,NULL,'850a275d-b6e5-400f-a258-b3b178a7edbe'),
(4983,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:16:49','2025-11-05 17:16:49',NULL,NULL,NULL,'0d907c2f-539d-4fa2-bf9a-e18b34ba2dd7'),
(4984,1135,NULL,2382,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:16:49','2025-11-05 17:16:49',NULL,NULL,NULL,'5ef1c106-a669-4293-b92a-8855f04ed3df'),
(4985,4979,NULL,2383,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:16:49','2025-11-05 17:16:49',NULL,NULL,NULL,'be8fc7c3-3a03-4817-a00a-3ec999d760ae'),
(4986,4980,NULL,2384,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:16:49','2025-11-05 17:16:49',NULL,NULL,NULL,'632a8155-9917-4880-9010-7f38014c0f51'),
(4987,4981,NULL,2385,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:16:49','2025-11-05 17:16:49',NULL,NULL,NULL,'cd2066f6-aed8-47e6-b961-318fe1ab5531'),
(4988,4982,NULL,2386,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:16:49','2025-11-05 17:16:49',NULL,NULL,NULL,'02d6fe65-6467-4e41-a13c-20957b6286a5'),
(4989,4983,NULL,2387,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:16:49','2025-11-05 17:16:49',NULL,NULL,NULL,'21ffac11-9584-4d99-9e31-99285a5f1f80'),
(4991,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:19:17','2025-11-05 17:19:17',NULL,NULL,NULL,'4e7e82f7-536a-4b1d-accf-389bb4be5a42'),
(4992,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:19:23','2025-11-05 17:19:23',NULL,NULL,NULL,'293cb104-8159-43a3-ad92-19d59b9f2580'),
(4993,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:19:27','2025-11-05 17:19:27',NULL,NULL,NULL,'5f9663ea-2c09-427d-92e5-4b4b89b65668'),
(4994,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:19:30','2025-11-05 17:19:30',NULL,NULL,NULL,'e3bdb7b3-d92a-4ee0-9c4e-05171e6ba370'),
(4995,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:19:34','2025-11-05 17:19:34',NULL,NULL,NULL,'c8412bf3-ca91-47f5-ba81-85aaed273353'),
(4996,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:19:38','2025-11-05 17:19:38',NULL,NULL,NULL,'38517215-3351-4eb6-99e7-06680d18f1f1'),
(4997,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:19:43','2025-11-05 17:19:43',NULL,NULL,NULL,'a9c99d83-c4b8-44a4-bac7-7f9b1a3ca6ab'),
(4998,1135,NULL,2388,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:20:21','2025-11-05 17:20:21',NULL,NULL,NULL,'7aa0cbe8-c477-43c0-8db9-7e4411b60179'),
(5001,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-05 17:22:23','2025-11-05 17:22:23',NULL,NULL,NULL,'580ef3e1-3918-4edd-8bc0-3b8a5b5683d8'),
(5003,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-05 17:22:42','2025-11-05 17:22:42',NULL,NULL,NULL,'df30ae86-f503-4504-b9a6-069af072bc58'),
(5004,1135,NULL,2389,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:22:48','2025-11-05 17:22:48',NULL,NULL,NULL,'cdb20d60-9780-4621-a5f8-52a67eb7e235'),
(5005,1653,NULL,2390,2,'craft\\elements\\Entry',1,0,'2025-11-05 17:22:48','2025-11-05 17:22:48',NULL,NULL,NULL,'baf8682b-a835-46de-a78f-74f34e5f7a50'),
(5006,1654,NULL,2391,2,'craft\\elements\\Entry',1,0,'2025-11-05 17:22:48','2025-11-05 17:22:48',NULL,NULL,NULL,'617dd1f4-e9bd-45e0-966b-616f652e473f'),
(5009,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:23:33','2025-11-05 17:23:33',NULL,NULL,NULL,'532c1703-73f3-4a97-9a62-49520f9c24a2'),
(5010,1135,NULL,2392,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:23:33','2025-11-05 17:23:33',NULL,NULL,NULL,'37f9a7ef-289a-4543-ac6a-efd4a4a5a6ba'),
(5011,5009,NULL,2393,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:23:33','2025-11-05 17:23:33',NULL,NULL,NULL,'710d5f50-86d3-4ee7-9136-2352e5e80cf6'),
(5013,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:24:52','2025-11-05 17:24:52',NULL,NULL,NULL,'2c7e4c10-1b7a-4110-8b84-080280154e3d'),
(5019,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:27:42','2025-11-05 17:27:42',NULL,NULL,NULL,'8b3bb267-b922-488f-8675-16c22d2179f8'),
(5020,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:27:42','2025-11-05 17:27:42',NULL,NULL,NULL,'7798276c-420d-40f6-b2f1-3462271c86f3'),
(5021,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:27:42','2025-11-05 17:27:42',NULL,NULL,NULL,'876926db-aab8-472d-ac63-ac2751e2c648'),
(5022,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:27:42','2025-11-05 17:27:42',NULL,NULL,NULL,'99d9bdf0-5efc-4790-b94a-acfa0f2ec80c'),
(5023,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:27:42','2025-11-05 17:27:42',NULL,NULL,NULL,'b3fb411f-834c-4c34-874d-7455f09784d2'),
(5024,1349,NULL,2394,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:27:42','2025-11-05 17:27:42',NULL,NULL,NULL,'c8794da3-22a0-41bb-80ba-2fff6d887633'),
(5025,5019,NULL,2395,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:27:42','2025-11-05 17:27:42',NULL,NULL,NULL,'8f520d37-b90a-43fc-b4ca-d7054d591065'),
(5026,5020,NULL,2396,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:27:42','2025-11-05 17:27:42',NULL,NULL,NULL,'f3d7f2ff-1838-4997-bcca-ce536f38376f'),
(5027,5021,NULL,2397,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:27:42','2025-11-05 17:27:42',NULL,NULL,NULL,'5791942c-1098-477b-ae9a-5ffa622bcaf0'),
(5028,5022,NULL,2398,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:27:42','2025-11-05 17:27:42',NULL,NULL,NULL,'1b5f314e-2e45-4076-99f3-f2e5c8d18096'),
(5029,5023,NULL,2399,3,'craft\\elements\\Entry',1,0,'2025-11-05 17:27:42','2025-11-05 17:27:42',NULL,NULL,NULL,'106f2a64-79a2-4e7f-9ffb-b71ad94e44ed'),
(5031,1349,NULL,2400,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:28:51','2025-11-05 17:28:51',NULL,NULL,NULL,'6eff3f08-41af-48af-bc75-50d2c24b1c5a'),
(5033,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:29:57','2025-11-05 17:29:57',NULL,NULL,NULL,'912270db-5e9f-4859-a342-e929b2999db5'),
(5034,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:30:02','2025-11-05 17:30:02',NULL,NULL,NULL,'372957db-64ba-4ccc-9bcd-a30591e60540'),
(5035,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:30:04','2025-11-05 17:30:04',NULL,NULL,NULL,'5801fd67-7e8c-4cc9-95a7-4ce3c3cafead'),
(5036,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:30:07','2025-11-05 17:30:07',NULL,NULL,NULL,'aea99382-e9a8-4057-a220-8ba2069a0be2'),
(5037,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:30:13','2025-11-05 17:30:13',NULL,NULL,NULL,'cc1f86c9-78ab-43d5-9e27-910d763b085b'),
(5038,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:30:15','2025-11-05 17:30:15',NULL,NULL,NULL,'3617ed27-4288-4cac-8b05-62d99c4ceb00'),
(5039,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:30:20','2025-11-05 17:30:20',NULL,NULL,NULL,'887a39a3-8058-4553-ab8a-0f9c286d233a'),
(5040,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:30:22','2025-11-05 17:30:22',NULL,NULL,NULL,'a4d72016-2afb-4ef1-a7d1-327d7e36af28'),
(5042,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-05 17:31:06','2025-11-05 17:31:06',NULL,NULL,NULL,'c4e1b4ed-c275-488f-8d82-4d8e6667fecc'),
(5043,1349,NULL,2401,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:31:15','2025-11-05 17:31:15',NULL,NULL,NULL,'20e01ec6-a094-4d39-9d5a-7b5aaf0a1d38'),
(5044,1832,NULL,2402,2,'craft\\elements\\Entry',1,0,'2025-11-05 17:31:15','2025-11-05 17:31:15',NULL,NULL,NULL,'b8245b38-815b-4165-93e8-fa0215387ab6'),
(5048,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:32:04','2025-11-05 17:32:04',NULL,NULL,NULL,'c49c6bf5-3f0d-44a8-9de4-9657fab5f823'),
(5049,1349,NULL,2403,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:32:04','2025-11-05 17:32:04',NULL,NULL,NULL,'30135fc8-1aa8-4686-a5f1-c9eb8e6a9ed7'),
(5050,5048,NULL,2404,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:32:04','2025-11-05 17:32:04',NULL,NULL,NULL,'7ec8baa6-9e83-437b-9a6d-84dc8872f2ca'),
(5055,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:35:09','2026-01-14 19:44:34',NULL,NULL,NULL,'b895d8a3-d46a-44be-9036-0396755e2c48'),
(5056,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:35:12','2025-11-05 17:35:12',NULL,NULL,NULL,'77f9b15e-46db-4334-942d-1a963e1e2065'),
(5057,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:35:16','2026-01-14 19:44:54',NULL,NULL,NULL,'0977645d-fbe8-4e0a-ad86-738f2cb1f2fb'),
(5058,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:35:21','2026-01-14 19:44:44',NULL,NULL,NULL,'3978d009-298d-4907-9b1c-e2cdb807e147'),
(5059,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:35:38','2025-11-05 17:35:38',NULL,NULL,NULL,'506117b7-5a60-4428-87a8-7d17e998a8bc'),
(5060,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:35:38','2025-11-05 17:35:38',NULL,NULL,NULL,'94a86ec5-a804-4e98-a88a-dca0f82f7f54'),
(5061,1129,NULL,2405,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:35:38','2025-11-05 17:35:38',NULL,NULL,NULL,'d6a2a0fc-b494-48de-9439-04bf3eeb7915'),
(5062,5059,NULL,2406,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:35:38','2025-11-05 17:35:38',NULL,NULL,NULL,'39694eeb-2421-451c-bee1-b9dc93d140de'),
(5063,5060,NULL,2407,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:35:38','2025-11-05 17:35:38',NULL,NULL,NULL,'00ceeb8e-028f-4482-aaf4-9c87f05b8284'),
(5067,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:38:09','2025-11-05 17:38:09',NULL,NULL,NULL,'3364a26e-c7b4-4576-8ac0-cc2ef911626a'),
(5068,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:40:03','2025-11-05 17:40:03',NULL,NULL,NULL,'93665fca-0085-44cb-85ea-f0b8b8340b46'),
(5069,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:40:06','2025-11-05 17:40:06',NULL,NULL,NULL,'4552a447-66ca-4a3f-b6a7-6b4d4698fb45'),
(5070,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:40:11','2025-11-05 17:40:11',NULL,NULL,NULL,'adbc9cbd-3b52-43b4-9e34-c5a50828245f'),
(5071,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:40:11','2025-11-05 17:40:11',NULL,NULL,NULL,'6bbc75be-3bf4-4243-a715-12b297c27675'),
(5072,1123,NULL,2408,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:40:11','2025-11-05 17:40:11',NULL,NULL,NULL,'53a8e0f9-c375-4e76-920c-2c5bdc21fbae'),
(5073,5070,NULL,2409,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:40:11','2025-11-05 17:40:11',NULL,NULL,NULL,'f6cef0b7-238c-4fcf-b9a8-1e90196b55df'),
(5074,5071,NULL,2410,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:40:11','2025-11-05 17:40:11',NULL,NULL,NULL,'1d058427-04a6-4ec6-b78c-972cb48689f7'),
(5076,1123,NULL,2411,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:40:21','2025-11-05 17:40:21',NULL,NULL,NULL,'13dcea9d-fe73-43a6-894d-50cce71ef267'),
(5081,1045,NULL,2412,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:41:40','2025-11-05 17:41:40',NULL,NULL,NULL,'4b7b8f77-c06e-4b87-b4c8-2328e78b482d'),
(5083,1045,NULL,2413,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:41:43','2025-11-05 17:41:43',NULL,NULL,NULL,'cc833ce9-f3f5-47b1-9ac6-94064f123242'),
(5084,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:42:12','2025-11-05 17:42:12',NULL,NULL,NULL,'41e5db5c-326e-4cad-8dc5-196e0f3c154b'),
(5085,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:42:20','2025-11-05 17:42:20',NULL,NULL,NULL,'e4156898-3a73-4b3c-b742-2f6c3284c4bf'),
(5086,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:42:29','2025-11-05 17:42:29',NULL,NULL,NULL,'74cf5c05-7f2c-4559-8c52-bb1c738e589a'),
(5087,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:42:40','2025-11-05 17:42:40',NULL,NULL,NULL,'54763cda-db4e-4053-bd40-ef2a0e0b3c4b'),
(5088,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:42:46','2025-11-05 17:42:46',NULL,NULL,NULL,'7fb0b952-e553-47f7-9ab8-f606f9410b37'),
(5089,1249,NULL,2414,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:42:50','2025-11-05 17:42:50',NULL,NULL,NULL,'35808e1f-e77c-4431-b204-605d68198524'),
(5091,1249,NULL,2415,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:43:21','2025-11-05 17:43:21',NULL,NULL,NULL,'ef2d116e-25fd-4343-9c7b-59a18a4b46f5'),
(5095,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:46:39','2025-11-05 17:46:39',NULL,NULL,NULL,'27166524-69e1-4f26-8141-8bec1c484fc8'),
(5096,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:46:49','2025-11-05 17:46:49',NULL,NULL,NULL,'04deaeb9-82df-4a85-83a3-56200879b599'),
(5097,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:47:01','2025-11-05 17:47:01',NULL,NULL,NULL,'98e74935-d8e2-4f06-bd5f-946c6637d084'),
(5098,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:47:05','2025-11-05 17:47:05',NULL,NULL,NULL,'5406194d-e71f-4069-b3e5-7b9220524302'),
(5099,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:47:50','2025-11-05 17:47:50',NULL,NULL,NULL,'5634a254-5c40-4f04-9fa9-b1e0406586b3'),
(5100,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:47:50','2025-11-05 17:47:50',NULL,NULL,NULL,'3d325a35-c67a-40c2-8361-daab8772bf7d'),
(5101,1041,NULL,2416,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:47:50','2025-11-05 17:47:50',NULL,NULL,NULL,'189a38b6-08d8-4f03-b115-bac6e0852db5'),
(5102,5099,NULL,2417,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:47:50','2025-11-05 17:47:50',NULL,NULL,NULL,'2c8b35b1-3831-48ee-8e2d-b583455e9f20'),
(5103,5100,NULL,2418,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:47:50','2025-11-05 17:47:50',NULL,NULL,NULL,'29a485dc-f40c-42c2-8748-48274d858986'),
(5105,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:49:45','2025-11-05 17:49:45',NULL,NULL,NULL,'22b43852-b2d1-4b5b-a237-aafdaf4a18eb'),
(5106,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:49:47','2025-11-05 17:49:47',NULL,NULL,NULL,'76b960ff-a0c5-42f4-8445-8f217e28ca7b'),
(5107,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:49:49','2025-11-05 17:49:49',NULL,NULL,NULL,'b4c57b83-a0e0-4090-8ebb-d72377e1a1b7'),
(5108,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:49:51','2025-11-05 17:49:51',NULL,NULL,NULL,'1b311c5d-f7d1-41cb-8821-30432b390df3'),
(5109,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:49:52','2025-11-05 17:49:52',NULL,NULL,NULL,'6e5aa723-58c7-424b-9677-6ceffb5d0561'),
(5110,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:49:54','2025-11-05 17:49:54',NULL,NULL,NULL,'f80649d6-5552-46a4-bdfe-128729da07e8'),
(5111,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:49:56','2025-11-05 17:49:56',NULL,NULL,NULL,'f5222219-2592-420f-a80f-bfccf5d5d8aa'),
(5112,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:49:59','2025-11-05 17:49:59',NULL,NULL,NULL,'721f455a-ce1c-4515-bc3b-47953de3f741'),
(5115,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:52:23','2025-11-05 17:52:23',NULL,NULL,NULL,'62698c4d-e323-4ff5-ac4d-1b5336f94860'),
(5116,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:52:23','2025-11-05 17:52:23',NULL,NULL,NULL,'72eb98a1-22e4-40ec-968c-0fc36a54f586'),
(5117,1035,NULL,2419,1,'craft\\elements\\Entry',1,0,'2025-11-05 17:52:23','2025-11-05 17:52:23',NULL,NULL,NULL,'6d7372ba-6f6b-41df-a6d2-1232edb1203c'),
(5118,5115,NULL,2420,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:52:23','2025-11-05 17:52:23',NULL,NULL,NULL,'21f7bf8e-9c8b-4720-815f-67e21eb2ae01'),
(5119,5116,NULL,2421,21,'craft\\elements\\Entry',1,0,'2025-11-05 17:52:23','2025-11-05 17:52:23',NULL,NULL,NULL,'d7af8e1e-3e63-4236-af7c-202be12b27c3'),
(5122,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:56:34','2025-11-05 17:56:34',NULL,NULL,NULL,'612f22e1-33c0-4ad2-aef2-49437fda95d9'),
(5123,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:56:37','2025-11-05 17:56:37',NULL,NULL,NULL,'5630109f-c51c-429a-932f-9237ab8ee3ba'),
(5124,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:56:41','2025-11-05 17:56:41',NULL,NULL,NULL,'df373e17-5a2e-43c5-a365-baa41dfe8e14'),
(5125,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 17:56:46','2025-11-05 17:56:46',NULL,NULL,NULL,'bfbe3999-1882-4ad2-82a2-6df5a14fa555'),
(5127,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:44:51','2025-11-05 18:44:51',NULL,NULL,NULL,'830a1da1-fdec-4462-967c-e957d43b668a'),
(5128,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:44:59','2025-11-05 18:44:59',NULL,NULL,NULL,'1130fac3-ee0b-4490-a1a6-17f003876e10'),
(5129,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:45:08','2026-01-14 19:07:48',NULL,NULL,NULL,'799dce19-381e-4471-957b-ff52007d244e'),
(5130,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:45:11','2025-11-05 18:45:11',NULL,NULL,NULL,'aa6bd580-9b10-4d14-b8bb-d0eee29098b4'),
(5131,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:45:20','2025-11-05 18:45:20',NULL,NULL,NULL,'d91fb836-72fd-4c41-ae65-370c311bd944'),
(5134,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 18:46:45','2025-11-05 18:46:45',NULL,NULL,NULL,'2464e46f-2fea-4ceb-bbe8-3ec052b2dfe7'),
(5135,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 18:46:45','2025-11-05 18:46:45',NULL,NULL,NULL,'4bc92e40-27e9-4e95-8bc6-72581276b5f1'),
(5136,1109,NULL,2422,1,'craft\\elements\\Entry',1,0,'2025-11-05 18:46:45','2025-11-05 18:46:45',NULL,NULL,NULL,'cd529187-8c37-4ff0-b979-6ddf96bc0ebc'),
(5137,5134,NULL,2423,21,'craft\\elements\\Entry',1,0,'2025-11-05 18:46:45','2025-11-05 18:46:45',NULL,NULL,NULL,'4be6b4e7-305c-4d61-aa63-f49c4cf8bf18'),
(5138,5135,NULL,2424,21,'craft\\elements\\Entry',1,0,'2025-11-05 18:46:45','2025-11-05 18:46:45',NULL,NULL,NULL,'9038c1c6-cc74-4f26-9873-2e5e11b181b3'),
(5140,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:47:37','2025-11-05 18:47:37',NULL,NULL,NULL,'59143bb2-54a5-4c5c-8fda-891e8e3933c5'),
(5146,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:51:42','2025-11-05 18:51:42',NULL,NULL,NULL,'ef83c3ac-1a76-4051-be74-d14ba1f80648'),
(5147,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:51:45','2025-11-05 18:51:45',NULL,NULL,NULL,'91b83a9d-45f1-4e78-a44b-4157737435d8'),
(5148,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:51:50','2025-11-05 18:51:50',NULL,NULL,NULL,'219d0df8-ff0d-49fa-ba6a-8372c05ba9bb'),
(5149,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:51:57','2025-11-05 18:51:57',NULL,NULL,NULL,'e6690ae6-4411-4dbd-a6a9-6b66cea866d1'),
(5150,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:52:00','2025-11-05 18:52:00',NULL,NULL,NULL,'e0bd3bf4-6178-4177-82f6-21587d879bb8'),
(5151,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:52:03','2025-11-05 18:52:03',NULL,NULL,NULL,'ebe0359d-0e36-4720-84b1-85225bef8998'),
(5152,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:52:07','2025-11-05 18:52:07',NULL,NULL,NULL,'1b81737b-a9a9-4636-9165-8edf7e1999f1'),
(5153,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 18:52:09','2025-11-05 18:52:09',NULL,NULL,NULL,'b59e9756-bf46-4cfa-b2ee-ed5fe75c25cd'),
(5156,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-05 18:55:30','2025-11-05 18:55:30',NULL,NULL,NULL,'207e8651-bf1c-479e-9957-c8164c7bf04b'),
(5158,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-05 18:55:42','2025-11-05 18:55:42',NULL,NULL,NULL,'93200c28-9b7a-43c0-bdb8-c1de995f3138'),
(5161,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:48',NULL,NULL,NULL,'aff556d2-ebf1-4487-8202-f308a4c1b985'),
(5162,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:48',NULL,NULL,NULL,'73a547e2-1b27-4304-9e80-6f0ab67c7e4f'),
(5163,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:48',NULL,NULL,NULL,'9aed8c06-ecd8-48a8-8baf-f2611521d12e'),
(5164,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:48',NULL,NULL,NULL,'05351202-acb4-4f8b-b4ed-d1e0b501c9ae'),
(5165,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:48',NULL,NULL,NULL,'b379b94c-2ca9-4853-a7e2-a1815d13e057'),
(5166,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:48',NULL,NULL,NULL,'e97a7ad8-053e-4c48-aa33-25f099f71c04'),
(5167,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:48',NULL,NULL,NULL,'a4b97ca3-d261-4d39-bffa-b89b68e4eefb'),
(5168,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:48',NULL,NULL,NULL,'561bb2c5-38bb-4730-9972-12eaee24ae4d'),
(5169,1343,NULL,2425,1,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:48',NULL,NULL,NULL,'61e01ba8-d6fd-4629-976e-41ba11bb17c4'),
(5170,5161,NULL,2426,3,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:48',NULL,NULL,NULL,'1d924efa-6282-43fa-883d-debef50b6319'),
(5171,5162,NULL,2427,3,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:48',NULL,NULL,NULL,'da077bd4-ef2d-46e9-bfaa-1a415c2aecfd'),
(5172,5163,NULL,2428,3,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:48',NULL,NULL,NULL,'291488ac-1de1-49c5-a4c4-36f23382e6c9'),
(5173,5164,NULL,2429,3,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:49',NULL,NULL,NULL,'81c920f8-712f-4a41-8db2-199f89f9f9b8'),
(5174,5165,NULL,2430,3,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:49',NULL,NULL,NULL,'5be960e1-2999-4f13-bc35-276952d9950d'),
(5175,5166,NULL,2431,3,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:49',NULL,NULL,NULL,'43c8e0bb-0b54-468b-9b4f-53d5580a73a0'),
(5176,1827,NULL,2432,2,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:49',NULL,NULL,NULL,'c74f7a3a-3657-4f30-abfc-3b2b79047d24'),
(5177,1828,NULL,2433,2,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:49',NULL,NULL,NULL,'b138c636-c2ed-455c-ba19-2ec90ae3c56f'),
(5178,5167,NULL,2434,21,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:49',NULL,NULL,NULL,'b7597f50-fee5-4c62-9e43-21acbd74c1a5'),
(5179,5168,NULL,2435,21,'craft\\elements\\Entry',1,0,'2025-11-05 18:56:48','2025-11-05 18:56:49',NULL,NULL,NULL,'be11a753-ec4e-438a-8679-99339434df7e'),
(5185,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:02:10','2025-11-05 19:02:10',NULL,NULL,NULL,'28f9abef-641e-41ea-858b-f382b4095650'),
(5186,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:02:15','2025-11-05 19:02:15',NULL,NULL,NULL,'0a8b76fb-3c0b-4b80-b621-34bc710c4bad'),
(5187,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:02:26','2025-11-05 19:02:26',NULL,NULL,NULL,'9c5ae1fe-8448-433c-8cd8-7f4495f2af67'),
(5188,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:02:37','2025-11-05 19:02:37',NULL,NULL,NULL,'4ff8f5b7-3bdd-426a-852d-636eccfbccfd'),
(5189,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:02:47','2025-11-05 19:02:47',NULL,NULL,NULL,'e4bffbea-391a-43a1-b056-ab5ddb9a5eae'),
(5190,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:02:57','2025-11-05 19:02:57',NULL,NULL,NULL,'07a703a4-7606-4fcd-bf92-18d7e6a38dad'),
(5191,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:03:48','2025-11-05 19:03:48',NULL,NULL,NULL,'a34795a2-5d56-47cd-8a55-24791584a1ea'),
(5197,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:18',NULL,NULL,NULL,'4a45254f-1b11-4162-8d9f-9e9960dcd1e1'),
(5198,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:18',NULL,NULL,NULL,'9ab8d780-c6c9-4c32-aa99-e511f47cf93d'),
(5199,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:18',NULL,NULL,NULL,'36c03ec5-f05e-42fb-99d5-f5d94735a250'),
(5200,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:18',NULL,NULL,NULL,'8042a43a-43df-4521-bb6b-eda3f0b3179f'),
(5201,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2026-01-17 02:34:58',NULL,'2026-01-17 02:34:58',NULL,'9136f74a-02d3-4cce-9a45-5e5c64405296'),
(5202,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:18',NULL,NULL,NULL,'83a2cbdc-6878-45ec-996d-91c8f7c965d7'),
(5203,1407,NULL,2436,1,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:18',NULL,NULL,NULL,'035f0286-97c6-40cb-bac2-36693ce8deff'),
(5204,5197,NULL,2437,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:18',NULL,NULL,NULL,'049b85ce-d432-4926-93fd-aa4f0f9bcebd'),
(5205,5198,NULL,2438,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:18',NULL,NULL,NULL,'7e54e4d5-be07-44dc-945b-16d9f62fddb7'),
(5206,5199,NULL,2439,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:18',NULL,NULL,NULL,'91468ab1-a5ee-4f4c-b4b5-d51b9298409c'),
(5207,5200,NULL,2440,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:18',NULL,NULL,NULL,'00bf4e0d-5756-425f-a98a-7c2880a41230'),
(5208,5201,NULL,2441,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:18',NULL,'2026-01-17 02:34:58',NULL,'d92da984-571d-4e8a-8671-ef12da0e90bc'),
(5209,1880,NULL,2442,2,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:18',NULL,NULL,NULL,'95c40fd6-a823-4c84-af5c-25290c65ea70'),
(5210,1881,NULL,2443,2,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:19',NULL,NULL,NULL,'2781ad9e-c0b5-4b9b-a12a-0025313a86b7'),
(5211,5202,NULL,2444,21,'craft\\elements\\Entry',1,0,'2025-11-05 19:12:18','2025-11-05 19:12:19',NULL,NULL,NULL,'41deac22-901a-45ff-9ef4-3878d74e63e1'),
(5213,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:13:05','2025-11-05 19:13:05',NULL,NULL,NULL,'8292f858-6471-4ebd-9fb4-7f1a1a149328'),
(5219,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:15:00','2025-11-05 19:15:00',NULL,NULL,NULL,'c5f538df-787c-4d34-babf-ddbe4a5cae16'),
(5220,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:15:00','2025-11-05 19:15:00',NULL,NULL,NULL,'22d80080-bf6e-4217-8024-361bceffcf8a'),
(5221,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:15:00','2025-11-05 19:15:00',NULL,NULL,NULL,'ec5cd648-3813-4df1-9be7-f950bf5e272a'),
(5222,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:15:00','2025-11-05 19:15:00',NULL,NULL,NULL,'85051b7f-aa4c-4925-a3f1-204da1ddf209'),
(5223,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:15:00','2025-11-05 19:15:00',NULL,NULL,NULL,'25490b6f-d6ed-44ba-8b6d-46eb59b25695'),
(5224,1337,NULL,2445,1,'craft\\elements\\Entry',1,0,'2025-11-05 19:15:00','2025-11-05 19:15:00',NULL,NULL,NULL,'85597396-aa31-498d-b074-fb03280a5ee0'),
(5225,5219,NULL,2446,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:15:00','2025-11-05 19:15:00',NULL,NULL,NULL,'98385662-e7ee-403b-8475-6ecbda7c53c7'),
(5226,5220,NULL,2447,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:15:00','2025-11-05 19:15:00',NULL,NULL,NULL,'350049f0-0d33-40b2-869a-9d9d1b1defaf'),
(5227,5221,NULL,2448,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:15:00','2025-11-05 19:15:00',NULL,NULL,NULL,'f5dd0455-3ca1-421a-8d37-e0a3f6645aaa'),
(5228,5222,NULL,2449,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:15:00','2025-11-05 19:15:00',NULL,NULL,NULL,'45a01a3c-ebad-4237-8115-891a8f693957'),
(5229,5223,NULL,2450,3,'craft\\elements\\Entry',1,0,'2025-11-05 19:15:00','2025-11-05 19:15:00',NULL,NULL,NULL,'0b49f812-79d5-49bb-a061-f1516f21e67b'),
(5231,1337,NULL,2451,1,'craft\\elements\\Entry',1,0,'2025-11-05 19:15:32','2025-11-05 19:15:32',NULL,NULL,NULL,'2928ab77-7156-4eac-97da-70e7a0c2c419'),
(5233,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:16:52','2025-11-05 19:16:52',NULL,NULL,NULL,'c4a3e638-2dab-4173-b86c-67616ccd56bc'),
(5234,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:16:55','2025-11-05 19:16:55',NULL,NULL,NULL,'f45586cb-78d3-44a2-86ce-b5ba170c94b1'),
(5235,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:16:56','2025-11-05 19:16:56',NULL,NULL,NULL,'f3d4a52a-2400-44a6-9254-2220053bce78'),
(5236,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:16:58','2025-11-05 19:16:58',NULL,NULL,NULL,'7631a60f-5f90-4a22-8739-f67632e48052'),
(5237,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:17:00','2025-11-05 19:17:00',NULL,NULL,NULL,'f1fe9ca9-725c-4886-af05-fa01c85a483e'),
(5238,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:17:01','2025-11-05 19:17:01',NULL,NULL,NULL,'878bdf09-16b9-4a5e-bf18-3ba344956c73'),
(5239,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:17:03','2025-11-05 19:17:03',NULL,NULL,NULL,'f7edf4eb-027d-4c3e-929d-0cce649a13a2'),
(5241,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-05 19:18:26','2025-11-05 19:18:26',NULL,NULL,NULL,'37df5fbc-186c-44dc-a50f-000d438700af'),
(5244,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-05 19:18:37','2025-11-05 19:18:37',NULL,NULL,NULL,'007c00a2-db72-40b8-97c8-45ea04a20f76'),
(5246,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-11-05 19:19:37','2026-01-08 15:17:35',NULL,NULL,NULL,'cbd875b0-ccd2-4dde-8c6f-6fff97c1949a'),
(5247,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 19:19:37','2025-11-05 19:19:37',NULL,NULL,NULL,'e43d853b-b91f-4455-9299-f67a5dd376d3'),
(5248,1337,NULL,2452,1,'craft\\elements\\Entry',1,0,'2025-11-05 19:19:37','2025-11-05 19:19:37',NULL,NULL,NULL,'41ee4893-b3ba-4454-a633-9ef3fff502c1'),
(5249,5246,NULL,2453,2,'craft\\elements\\Entry',1,0,'2025-11-05 19:19:37','2025-11-05 19:19:38',NULL,NULL,NULL,'a9e62e55-4bd9-40ea-a572-0803995eef3e'),
(5250,1823,NULL,2454,2,'craft\\elements\\Entry',1,0,'2025-11-05 19:19:37','2025-11-05 19:19:38',NULL,NULL,NULL,'18a613fd-6034-40cb-b31b-c1bb3440b214'),
(5251,5247,NULL,2455,21,'craft\\elements\\Entry',1,0,'2025-11-05 19:19:37','2025-11-05 19:19:38',NULL,NULL,NULL,'9b3ac19a-c6f1-41f1-ab1e-6e6c7528333b'),
(5253,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:22:55','2026-01-13 21:51:18',NULL,NULL,NULL,'61344b06-731e-45bd-8b9e-e2ab9849ef7e'),
(5254,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:24:53','2025-11-05 19:24:53',NULL,NULL,NULL,'cbec99bd-5916-441b-8717-122f7ad12b42'),
(5255,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:24:58','2025-11-05 19:24:58',NULL,NULL,NULL,'186aa260-85b3-4e25-a3ac-7fcbc554f828'),
(5256,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:25:07','2025-11-05 19:25:07',NULL,NULL,NULL,'8bc427fa-f147-4f25-ba6b-7b3b3db40885'),
(5257,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:25:17','2025-11-05 19:25:17',NULL,NULL,NULL,'f90b02c3-3fa2-4094-929f-bc286c9db863'),
(5258,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-05 19:25:26','2025-11-05 19:25:26',NULL,NULL,NULL,'8e176856-de7a-4742-ad95-4598e27aee48'),
(5261,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 19:26:13','2025-11-05 19:26:13',NULL,NULL,NULL,'63ef3592-b39a-46aa-8086-14f6d122a338'),
(5262,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-05 19:26:13','2025-11-05 19:26:13',NULL,NULL,NULL,'49dbc0cf-a4ea-41ad-b393-03fa2c840306'),
(5263,1023,NULL,2456,1,'craft\\elements\\Entry',1,0,'2025-11-05 19:26:13','2025-11-05 19:26:13',NULL,NULL,NULL,'bcf22ac4-2f44-4b71-974d-2f82da15d2f6'),
(5264,5261,NULL,2457,21,'craft\\elements\\Entry',1,0,'2025-11-05 19:26:13','2025-11-05 19:26:13',NULL,NULL,NULL,'0a59b93c-97bf-4cbb-8ce0-e9c938e7dacc'),
(5265,5262,NULL,2458,21,'craft\\elements\\Entry',1,0,'2025-11-05 19:26:13','2025-11-05 19:26:13',NULL,NULL,NULL,'9e92ffeb-613d-4f80-b637-fc180f12d78a'),
(5266,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-06 13:29:31','2025-11-06 13:29:31',NULL,NULL,NULL,'58537df5-fbca-4e05-b415-eb35c1ffceac'),
(5268,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-10 16:13:26','2025-11-10 16:13:26',NULL,NULL,NULL,'ce9f1564-275f-49e8-bc97-ca38653fdae4'),
(5272,2720,NULL,2459,1,'craft\\elements\\Entry',1,0,'2025-11-10 20:34:52','2025-11-10 20:34:52',NULL,NULL,NULL,'6b533661-a951-4e24-a86e-e248a3b36380'),
(5274,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-11 00:54:42','2025-11-11 00:54:42',NULL,NULL,NULL,'2d9cda9d-fbd5-43fe-87ae-52c4ba93a1d7'),
(5277,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-11 18:03:58','2025-11-11 18:03:58',NULL,NULL,NULL,'38654140-c5c8-4757-8ad3-0f116e8d0f15'),
(5278,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-11 18:04:01','2025-11-11 18:04:01',NULL,NULL,NULL,'1811f27f-aa01-4acd-9761-12f1ad2e72de'),
(5279,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-11 18:04:03','2025-11-11 18:04:03',NULL,NULL,NULL,'0bfa38a9-313f-42b3-a764-1284430b3ddb'),
(5280,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-11 18:04:06','2025-11-11 18:04:06',NULL,NULL,NULL,'20c539f6-9c3a-4300-aeae-676d60432881'),
(5281,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-11 18:04:42','2025-11-11 18:04:42',NULL,NULL,NULL,'5f86a520-6e85-42ab-b19d-173473112802'),
(5282,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-11 18:05:06','2025-11-11 18:05:06',NULL,NULL,NULL,'ec787842-669d-4a83-9b83-e46ff20d5b85'),
(5283,1079,NULL,2460,1,'craft\\elements\\Entry',1,0,'2025-11-11 18:06:22','2025-11-11 18:06:22',NULL,NULL,NULL,'e9855d3b-bc67-405e-a9ea-cb410bfcb68a'),
(5285,1079,NULL,2461,1,'craft\\elements\\Entry',1,0,'2025-11-11 18:06:26','2025-11-11 18:06:26',NULL,NULL,NULL,'0b04409a-8e0b-474c-a426-4a11ac063d49'),
(5286,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-11 18:13:10','2025-11-11 18:13:10',NULL,NULL,NULL,'0f24baa4-48b5-483a-8b4d-ee2b3073211c'),
(5288,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-11 22:48:18','2025-11-11 22:48:18',NULL,NULL,NULL,'6ed33ef9-95bc-4e6f-bd65-30781bf6437b'),
(5292,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-12 16:03:02','2025-11-12 16:03:26',NULL,NULL,NULL,'56cf6d5b-338d-4d26-842f-c574a7eadf89'),
(5293,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-12 16:03:03','2025-11-12 16:03:03',NULL,NULL,NULL,'4674b9f1-b220-49ff-883b-392ebc2c14c7'),
(5294,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-12 16:03:03','2025-11-12 16:03:03',NULL,NULL,NULL,'b3e85805-40bc-483f-a45f-2bff3f307186'),
(5297,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-12 20:02:59','2025-11-12 20:02:59',NULL,NULL,NULL,'1b4817f2-8be1-4bc8-a115-fda29d0ea2a0'),
(5300,1255,NULL,2462,1,'craft\\elements\\Entry',1,0,'2025-11-13 16:51:51','2025-11-13 16:51:51',NULL,NULL,NULL,'1e05816e-6e17-4659-9b8a-b1aa3979ba30'),
(5302,1255,NULL,2463,1,'craft\\elements\\Entry',1,0,'2025-11-13 16:55:01','2025-11-13 16:55:01',NULL,NULL,NULL,'85afb46e-eaa3-4491-9a6a-b58bb0a7494b'),
(5307,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:18:07','2025-11-13 19:18:07',NULL,NULL,NULL,'e346809f-f7c7-4b56-a13a-0ab777e3978b'),
(5308,1171,NULL,2464,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:18:07','2025-11-13 19:18:07',NULL,NULL,NULL,'48ec473c-0fab-4477-ad10-2879f6323348'),
(5309,5307,NULL,2465,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:18:07','2025-11-13 19:18:07',NULL,NULL,NULL,'4c0f05b2-5a03-4acb-86cf-a24c1116a20d'),
(5310,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:18:18','2025-11-13 19:18:18',NULL,NULL,NULL,'f8ea7d88-0eba-420c-b510-a14aefeed1ca'),
(5311,1045,NULL,2466,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:18:18','2025-11-13 19:18:18',NULL,NULL,NULL,'cb9b82ac-338b-44a4-b4cb-cf5686c5cfd9'),
(5312,5310,NULL,2467,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:18:18','2025-11-13 19:18:18',NULL,NULL,NULL,'a57e39a7-429b-4514-b2fb-3e37619f6596'),
(5315,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:19:40','2025-11-13 19:19:40',NULL,NULL,NULL,'b0d80939-11e4-4d7d-a3b2-e617ff480fc3'),
(5316,945,NULL,2468,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:19:40','2025-11-13 19:19:40',NULL,NULL,NULL,'78fe1712-533a-4cd5-87c0-057f01f9a85e'),
(5317,5315,NULL,2469,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:19:40','2025-11-13 19:19:40',NULL,NULL,NULL,'5716f351-417f-4fa0-b415-b1cb389b7a64'),
(5319,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:20:01','2026-01-16 12:39:10',NULL,NULL,NULL,'8a9abbfe-9684-4f2f-a2fa-7b9a92b7b1d6'),
(5320,951,NULL,2470,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:20:01','2025-11-13 19:20:01',NULL,NULL,NULL,'2d6a0c76-84d2-4e33-b8be-3edd1c950b3b'),
(5321,5319,NULL,2471,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:20:01','2025-11-13 19:20:01',NULL,NULL,NULL,'1737021b-0213-4c30-8c4d-07369b74c94a'),
(5324,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:20:32','2025-11-13 19:20:32',NULL,NULL,NULL,'0054b3c4-a3ba-4330-9281-e281dce4f482'),
(5325,1261,NULL,2472,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:20:32','2025-11-13 19:20:32',NULL,NULL,NULL,'bc6cd0bd-3c4f-4b67-8beb-8de7d1a82828'),
(5326,5324,NULL,2473,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:20:32','2025-11-13 19:20:32',NULL,NULL,NULL,'d8ea0008-5fcb-49a0-b64a-1fdb0d7947f9'),
(5329,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:21:01','2025-11-13 19:21:01',NULL,NULL,NULL,'9fb832b4-7203-4bfe-8bb8-24a723fe926f'),
(5330,1177,NULL,2474,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:21:01','2025-11-13 19:21:01',NULL,NULL,NULL,'1a3e5088-0aeb-4694-8487-60d9dce74df3'),
(5331,5329,NULL,2475,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:21:01','2025-11-13 19:21:01',NULL,NULL,NULL,'ab73ad62-d902-42d0-8a3d-aabc6cd56b78'),
(5334,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:21:34','2025-11-13 19:21:34',NULL,NULL,NULL,'ee7df75e-6e74-4ecf-948d-08d5a7a06296'),
(5335,957,NULL,2476,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:21:34','2025-11-13 19:21:35',NULL,NULL,NULL,'225d33d1-eebb-4b80-b0b9-898b076ac472'),
(5336,5334,NULL,2477,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:21:34','2025-11-13 19:21:35',NULL,NULL,NULL,'8be2ce53-f162-4128-895a-6aaa7ede8d57'),
(5339,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:22:13','2025-11-13 19:22:13',NULL,NULL,NULL,'9f8d1bb5-0393-41db-89fc-657d7e41a338'),
(5340,963,NULL,2478,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:22:13','2025-11-13 19:22:13',NULL,NULL,NULL,'8d282b39-5622-41bb-ab5f-afd4942bbaf9'),
(5341,5339,NULL,2479,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:22:13','2025-11-13 19:22:13',NULL,NULL,NULL,'aa79b382-500e-455d-8e6c-0f84d0a1b7d2'),
(5343,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:22:54','2025-11-13 19:22:54',NULL,NULL,NULL,'36159242-80a9-4e7a-bf59-b93341eaf5ec'),
(5344,2720,NULL,2480,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:22:54','2025-11-13 19:22:54',NULL,NULL,NULL,'1bc32c99-f600-47b6-bd94-7db865781ed8'),
(5345,5343,NULL,2481,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:22:54','2025-11-13 19:22:54',NULL,NULL,NULL,'21e7bf1b-35f7-4e68-bd87-e375b5ab82d5'),
(5348,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:23:50','2025-11-13 19:23:50',NULL,NULL,NULL,'3c02711a-54cd-4445-83d7-b9388e7dab5e'),
(5349,1051,NULL,2482,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:23:50','2025-11-13 19:23:50',NULL,NULL,NULL,'0a1e8dd1-8f7b-4f94-8462-fe32d95c4f99'),
(5350,5348,NULL,2483,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:23:50','2025-11-13 19:23:50',NULL,NULL,NULL,'0cd7c4fe-f08b-4abf-8575-8d2b904e8f91'),
(5353,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:24:33','2025-11-13 19:24:33',NULL,NULL,NULL,'1551a97c-ceca-47ab-a706-02cf34fe9181'),
(5354,1185,NULL,2484,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:24:33','2025-11-13 19:24:33',NULL,NULL,NULL,'54fb3604-9d7d-420f-9bfa-284b30e3f21e'),
(5355,5353,NULL,2485,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:24:33','2025-11-13 19:24:33',NULL,NULL,NULL,'8b7d5502-2266-40f6-be89-31c5de4e1096'),
(5358,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:25:27','2025-11-13 19:25:27',NULL,NULL,NULL,'586e206a-fd02-4d55-b623-6dc91f89bf2e'),
(5359,1059,NULL,2486,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:25:27','2025-11-13 19:25:27',NULL,NULL,NULL,'d8da84d3-831c-49ea-adc6-961fbf799058'),
(5360,5358,NULL,2487,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:25:27','2025-11-13 19:25:27',NULL,NULL,NULL,'91d83eb6-5105-4ef9-bddc-255817f99a2b'),
(5363,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:26:07','2025-11-13 19:26:07',NULL,NULL,NULL,'875aef06-92eb-467e-86bd-e2522303ef93'),
(5364,1269,NULL,2488,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:26:07','2025-11-13 19:26:08',NULL,NULL,NULL,'8e1f4cfb-f192-412b-a7f0-005d53c394c1'),
(5365,5363,NULL,2489,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:26:07','2025-11-13 19:26:08',NULL,NULL,NULL,'b9bddb04-a73a-4b53-8351-a40938e7bb83'),
(5368,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:26:37','2025-11-13 19:26:37',NULL,NULL,NULL,'a7ab6aed-7664-486c-8a4e-428ebb3a4808'),
(5369,969,NULL,2490,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:26:37','2025-11-13 19:26:37',NULL,NULL,NULL,'1d022575-203d-4f1a-a6b2-5a5eb63ce421'),
(5370,5368,NULL,2491,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:26:37','2025-11-13 19:26:37',NULL,NULL,NULL,'4eb2191f-2fc9-49e6-acaa-b67627f41e2c'),
(5373,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:27:11','2025-11-13 19:27:11',NULL,NULL,NULL,'27047617-d03b-442f-8bed-82ed0c831836'),
(5374,1277,NULL,2492,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:27:10','2025-11-13 19:27:11',NULL,NULL,NULL,'f8210deb-0d47-4d7c-ad22-dcc173e73a8a'),
(5375,5373,NULL,2493,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:27:11','2025-11-13 19:27:11',NULL,NULL,NULL,'185460a3-5798-4592-82b5-3c5ea098015c'),
(5376,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:27:21','2025-11-13 19:27:21',NULL,NULL,NULL,'619d3c85-bb49-4bb3-bec2-fbfa4d9e1e00'),
(5377,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:27:21','2025-11-13 19:27:21',NULL,NULL,NULL,'6f834742-ea37-48b6-8897-4b14a82376df'),
(5378,1191,NULL,2494,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:27:21','2025-11-13 19:27:21',NULL,NULL,NULL,'4245fff4-ea30-42b2-bef4-e9b43e965cdb'),
(5379,5376,NULL,2495,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:27:21','2025-11-13 19:27:21',NULL,NULL,NULL,'2415b514-bf64-491f-b2e5-18e7b6efd800'),
(5380,5377,NULL,2496,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:27:21','2025-11-13 19:27:21',NULL,NULL,NULL,'07e33b0f-dd7f-441e-9843-16d23421a38c'),
(5383,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:27:50','2025-11-13 19:27:50',NULL,NULL,NULL,'23fdb932-bdd3-43ff-8948-40b09ea91205'),
(5384,1419,NULL,2497,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:27:50','2025-11-13 19:27:50',NULL,NULL,NULL,'ff634a17-e027-4358-8c5e-30a2055f2464'),
(5385,5383,NULL,2498,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:27:50','2025-11-13 19:27:50',NULL,NULL,NULL,'1846849d-7ac6-4b1e-9a6b-6f3967bee1a5'),
(5388,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:28:49','2025-11-13 19:28:49',NULL,NULL,NULL,'338be981-7da3-4c8d-9c35-645f091ea4f1'),
(5389,1413,NULL,2499,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:28:49','2025-11-13 19:28:49',NULL,NULL,NULL,'f2d884ec-fbd5-473e-9f7c-b3a5d850da8e'),
(5390,5388,NULL,2500,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:28:49','2025-11-13 19:28:49',NULL,NULL,NULL,'4622aa62-f397-4d7b-83d4-a2e11f03e95a'),
(5393,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:29:31','2025-11-13 19:29:31',NULL,NULL,NULL,'6e0f1500-3d0e-405d-adc2-076bf60b87f2'),
(5394,1425,NULL,2501,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:29:31','2025-11-13 19:29:31',NULL,NULL,NULL,'8d5accd9-cc44-4ceb-96d8-cdaafc64b3c9'),
(5395,5393,NULL,2502,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:29:31','2025-11-13 19:29:31',NULL,NULL,NULL,'11ba5ce7-d1d7-4d27-b5c6-d377540de13d'),
(5398,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:30:15','2025-11-13 19:30:15',NULL,NULL,NULL,'f0b443e9-7513-4435-ad29-802f73d76e42'),
(5399,1359,NULL,2503,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:30:15','2025-11-13 19:30:15',NULL,NULL,NULL,'a2799c17-e310-410d-8fae-c641b6cb358e'),
(5400,5398,NULL,2504,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:30:15','2025-11-13 19:30:15',NULL,NULL,NULL,'66d50d7c-39c0-4453-9eb9-32a4e170b8f6'),
(5403,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:31:19','2025-11-13 19:31:19',NULL,NULL,NULL,'1b853c0f-87c6-44e4-881b-7bd76fb7ddf4'),
(5404,1365,NULL,2505,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:31:19','2025-11-13 19:31:19',NULL,NULL,NULL,'a96cf081-106f-4588-9894-3495df6c3527'),
(5405,5403,NULL,2506,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:31:19','2025-11-13 19:31:19',NULL,NULL,NULL,'60af98e6-6fba-40a8-b629-3846f1b1062e'),
(5408,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:32:07','2025-11-13 19:32:07',NULL,NULL,NULL,'ea418ebb-2657-446c-bedf-d15064b1e81c'),
(5409,975,NULL,2507,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:32:07','2025-11-13 19:32:07',NULL,NULL,NULL,'6c454829-3119-4db7-a55d-8259e9e9a977'),
(5410,5408,NULL,2508,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:32:07','2025-11-13 19:32:07',NULL,NULL,NULL,'00ee5742-f521-4205-9a09-bda616f71398'),
(5413,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:32:58','2025-11-13 19:32:58',NULL,NULL,NULL,'a1b2a05b-c172-429b-9ee6-14007ad5a5db'),
(5414,1067,NULL,2509,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:32:57','2025-11-13 19:32:58',NULL,NULL,NULL,'0c323f5e-c904-4b26-b3a3-871b59d30fbd'),
(5415,5413,NULL,2510,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:32:58','2025-11-13 19:32:58',NULL,NULL,NULL,'69d2bd9e-ef11-4b63-83f0-481ffd23b8c4'),
(5418,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:33:57','2025-11-13 19:33:57',NULL,NULL,NULL,'1fa78967-3053-40fb-bf80-d9b25fef4fd2'),
(5419,1431,NULL,2511,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:33:57','2025-11-13 19:33:57',NULL,NULL,NULL,'74b7cbc5-6908-4907-9c20-9eb916829573'),
(5420,5418,NULL,2512,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:33:57','2025-11-13 19:33:57',NULL,NULL,NULL,'68ececf6-7c62-45be-980b-40e46a78943e'),
(5423,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:34:26','2025-11-13 19:34:26',NULL,NULL,NULL,'5f34700e-ce4e-4da9-9b88-ccb6c93e3c30'),
(5424,1283,NULL,2513,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:34:26','2025-11-13 19:34:26',NULL,NULL,NULL,'7768ad10-19d5-4b7c-b1ef-d0988b672cf2'),
(5425,5423,NULL,2514,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:34:26','2025-11-13 19:34:26',NULL,NULL,NULL,'0fcd92af-695d-4b5e-a2d2-8abef412e5f1'),
(5428,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:34:58','2025-11-13 19:34:58',NULL,NULL,NULL,'98c47826-55fc-4172-a3aa-09654600c76a'),
(5429,1197,NULL,2515,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:34:58','2025-11-13 19:34:58',NULL,NULL,NULL,'06c96676-aa60-4cc5-a9a3-86b9952d0ba8'),
(5430,5428,NULL,2516,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:34:58','2025-11-13 19:34:58',NULL,NULL,NULL,'8be87053-4be7-44b6-9001-d635beab0353'),
(5433,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:35:39','2025-11-13 19:35:39',NULL,NULL,NULL,'1cad572d-008f-447d-a264-c70ff9e70e94'),
(5434,1201,NULL,2517,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:35:39','2025-11-13 19:35:39',NULL,NULL,NULL,'113d34f9-45bb-49ea-a933-f9d24663c662'),
(5435,5433,NULL,2518,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:35:39','2025-11-13 19:35:39',NULL,NULL,NULL,'2bd4fa5c-1f39-4dcc-a908-e62bab210d35'),
(5438,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:36:21','2025-11-13 19:36:21',NULL,NULL,NULL,'eb555487-f1d3-4ed0-b413-45f082d71dee'),
(5439,1443,NULL,2519,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:36:21','2025-11-13 19:36:21',NULL,NULL,NULL,'c37ada43-f0fd-4daf-b8e5-665c77d3edcd'),
(5440,5438,NULL,2520,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:36:21','2025-11-13 19:36:21',NULL,NULL,NULL,'1fc8463a-15f0-4250-abb5-b88b3f0852fc'),
(5443,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:36:55','2025-11-13 19:36:55',NULL,NULL,NULL,'0eb54453-3763-42fb-b703-4fd94dcb5652'),
(5444,1209,NULL,2521,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:36:55','2025-11-13 19:36:55',NULL,NULL,NULL,'06a67ee8-b942-4bb6-aa46-cda2cc03ad6c'),
(5445,5443,NULL,2522,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:36:55','2025-11-13 19:36:55',NULL,NULL,NULL,'f3f08d6d-4c98-40e1-8937-996b87e98129'),
(5447,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:37:39','2025-11-13 19:37:39',NULL,NULL,NULL,'cdca0ff9-2be0-435e-9743-9e49e5b6a422'),
(5448,1289,NULL,2523,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:37:39','2025-11-13 19:37:39',NULL,NULL,NULL,'70429028-683e-4eba-aca3-5a6eae95fa07'),
(5449,5447,NULL,2524,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:37:39','2025-11-13 19:37:39',NULL,NULL,NULL,'b56f1efc-f53b-4f74-923e-5af0b7779259'),
(5452,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:38:07','2025-11-13 19:38:07',NULL,NULL,NULL,'348793d7-390b-49c3-a40e-f17725a33cf4'),
(5453,1297,NULL,2525,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:38:07','2025-11-13 19:38:07',NULL,NULL,NULL,'944b37bc-6d86-493c-8fcb-6b1a46e38df3'),
(5454,5452,NULL,2526,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:38:07','2025-11-13 19:38:07',NULL,NULL,NULL,'2cef6bae-1c74-4285-bdd0-9d567e14a30f'),
(5457,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:39:18','2025-11-13 19:39:18',NULL,NULL,NULL,'14041cfa-1572-40df-a5ee-3dc00a727187'),
(5458,981,NULL,2527,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:39:18','2025-11-13 19:39:18',NULL,NULL,NULL,'5de96ad7-a316-486a-9518-964ad05e006c'),
(5459,5457,NULL,2528,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:39:18','2025-11-13 19:39:18',NULL,NULL,NULL,'31627577-a8a0-4f01-a911-e0d629d6093f'),
(5461,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:40:12','2025-11-13 19:40:12',NULL,NULL,NULL,'d8a68ea4-0285-48b0-8f71-f848a9998593'),
(5462,1073,NULL,2529,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:40:12','2025-11-13 19:40:12',NULL,NULL,NULL,'51a8f89e-c94f-4ae3-b9a8-768ab9efe369'),
(5463,5461,NULL,2530,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:40:12','2025-11-13 19:40:12',NULL,NULL,NULL,'eaf726a8-f7b1-4169-bff2-5d266e9546c7'),
(5466,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:40:46','2025-11-13 19:40:46',NULL,NULL,NULL,'ba324737-0b63-40fa-8ee1-3dacffed1aec'),
(5467,1303,NULL,2531,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:40:46','2025-11-13 19:40:47',NULL,NULL,NULL,'b8132755-596f-448c-868f-253b5bd884c9'),
(5468,5466,NULL,2532,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:40:46','2025-11-13 19:40:47',NULL,NULL,NULL,'54aaf5d5-af68-45d8-883b-f0adeec35797'),
(5471,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:43:56','2025-11-13 19:43:56',NULL,NULL,NULL,'da2eceb9-2135-4beb-aefe-9a1d3cee82dc'),
(5472,1215,NULL,2533,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:43:56','2025-11-13 19:43:56',NULL,NULL,NULL,'7b6dfa0c-f43b-424e-9788-41f4817844fa'),
(5473,5471,NULL,2534,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:43:56','2025-11-13 19:43:56',NULL,NULL,NULL,'bc7359e1-264c-433c-8162-b45f0007e80c'),
(5476,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:44:42','2025-11-13 19:44:42',NULL,NULL,NULL,'97f73c7a-0c36-42ca-996e-f8cb8da8d7ff'),
(5477,1395,NULL,2535,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:44:42','2025-11-13 19:44:42',NULL,NULL,NULL,'73627bdd-0bf2-48cc-aee1-89565ca3a92a'),
(5478,5476,NULL,2536,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:44:42','2025-11-13 19:44:42',NULL,NULL,NULL,'99474762-92a1-4259-b6b7-b572ebeb328b'),
(5481,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:45:56','2025-11-13 19:45:56',NULL,NULL,NULL,'fcc07b5b-1237-4026-9dac-64a45c17cf42'),
(5482,1371,NULL,2537,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:45:56','2025-11-13 19:45:56',NULL,NULL,NULL,'fd33e500-6544-4a13-877d-afbc87cffe68'),
(5483,5481,NULL,2538,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:45:56','2025-11-13 19:45:56',NULL,NULL,NULL,'735dab3f-d056-4210-9ab6-02fb8645879d'),
(5486,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:46:27','2025-11-13 19:46:27',NULL,NULL,NULL,'c7b6b7a0-0d3d-4ea9-83ac-0138f7d48966'),
(5487,1449,NULL,2539,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:46:27','2025-11-13 19:46:27',NULL,NULL,NULL,'3e3f081b-52b7-4108-8d2b-a6ced44f8fe2'),
(5488,5486,NULL,2540,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:46:27','2025-11-13 19:46:27',NULL,NULL,NULL,'94c144f2-58e5-48a5-adb4-b7ab32712bcf'),
(5491,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:47:52','2025-11-13 19:47:52',NULL,NULL,NULL,'f5ae6b66-2d53-4d54-8751-8e73bf3a25b8'),
(5492,1455,NULL,2541,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:47:52','2025-11-13 19:47:52',NULL,NULL,NULL,'68d0c596-4d69-46cf-a866-b765308f1bbc'),
(5493,5491,NULL,2542,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:47:52','2025-11-13 19:47:52',NULL,NULL,NULL,'8185b0b5-a311-4801-ab00-5393a4fa1e14'),
(5495,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:48:34','2025-11-13 19:48:34',NULL,NULL,NULL,'7ad89069-7819-48e8-b0a5-575893e2b246'),
(5496,989,NULL,2543,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:48:34','2025-11-13 19:48:34',NULL,NULL,NULL,'924f17b2-7b41-443d-9917-15cbedd8f51f'),
(5497,5495,NULL,2544,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:48:34','2025-11-13 19:48:34',NULL,NULL,NULL,'7f9aaeda-276c-4fd2-8a97-e8f4e73c6b62'),
(5500,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:49:15','2025-11-13 19:49:15',NULL,NULL,NULL,'7fbe8419-cfdb-45cc-ba02-101d851a3e77'),
(5501,1309,NULL,2545,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:49:15','2025-11-13 19:49:15',NULL,NULL,NULL,'c40311b2-4b64-414e-9a62-dca4e797b643'),
(5502,5500,NULL,2546,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:49:15','2025-11-13 19:49:15',NULL,NULL,NULL,'f1e7793f-5da9-4dcb-bca1-d05cbf25878e'),
(5505,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:51:51','2025-11-13 19:51:51',NULL,NULL,NULL,'a5040655-fe86-4934-8c5f-ccee891174ae'),
(5506,995,NULL,2547,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:51:51','2025-11-13 19:51:51',NULL,NULL,NULL,'95a0ebe5-0e6e-4def-8718-39923cf8a87c'),
(5507,5505,NULL,2548,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:51:51','2025-11-13 19:51:51',NULL,NULL,NULL,'cc15fe19-983a-428f-a1bd-12cebe4d007b'),
(5510,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:52:27','2025-11-13 19:52:27',NULL,NULL,NULL,'b3b8bda0-1842-4294-9195-addd7a388547'),
(5511,1219,NULL,2549,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:52:27','2025-11-13 19:52:27',NULL,NULL,NULL,'479f4f24-23b9-4451-9849-37f4027ba13f'),
(5512,5510,NULL,2550,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:52:27','2025-11-13 19:52:27',NULL,NULL,NULL,'143831c5-1180-44fe-b258-88e09aaec6b8'),
(5515,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:54:12','2025-11-13 19:54:12',NULL,NULL,NULL,'648a8970-30ce-4a79-9eb3-7c70f5dd071f'),
(5516,1079,NULL,2551,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:54:12','2025-11-13 19:54:12',NULL,NULL,NULL,'e5cf6fd6-eeae-4b3a-8a5d-dc90d345e67b'),
(5517,5515,NULL,2552,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:54:12','2025-11-13 19:54:12',NULL,NULL,NULL,'5b029402-c615-46e0-ab96-313ff3b87a60'),
(5520,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:55:19','2025-11-13 19:55:19',NULL,NULL,NULL,'27735b86-cd66-4ab0-a28c-834cbe5f5e9c'),
(5521,1377,NULL,2553,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:55:18','2025-11-13 19:55:19',NULL,NULL,NULL,'d74322e5-5b84-4499-9da2-bd21960523b9'),
(5522,5520,NULL,2554,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:55:19','2025-11-13 19:55:19',NULL,NULL,NULL,'dd07f71f-ce43-4655-ad23-d9d93afb4c0f'),
(5525,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:56:12','2025-11-13 19:56:12',NULL,NULL,NULL,'720fd130-d729-4b53-9390-164cdba818c5'),
(5526,999,NULL,2555,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:56:12','2025-11-13 19:56:12',NULL,NULL,NULL,'e9d7f623-7523-4bcd-a84e-bebaba22367a'),
(5527,5525,NULL,2556,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:56:12','2025-11-13 19:56:12',NULL,NULL,NULL,'de08db6e-55d4-4895-9e1b-06c1a41e2897'),
(5530,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:56:54','2025-11-13 19:56:54',NULL,NULL,NULL,'93faa378-3d9b-40b3-9acc-cadba2f562e2'),
(5531,1477,NULL,2557,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:56:54','2025-11-13 19:56:54',NULL,NULL,NULL,'08f3d493-d159-4e7a-a6dc-7b3b82ddc1d7'),
(5532,5530,NULL,2558,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:56:54','2025-11-13 19:56:54',NULL,NULL,NULL,'820881a0-f452-4839-b060-f75f0806be75'),
(5535,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:58:03','2025-11-13 19:58:03',NULL,NULL,NULL,'363a90f5-1da7-4633-84e1-a9d9c2e7a540'),
(5536,1085,NULL,2559,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:58:03','2025-11-13 19:58:03',NULL,NULL,NULL,'7c2925d0-97a6-4727-b650-9c70c2e4da7f'),
(5537,5535,NULL,2560,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:58:03','2025-11-13 19:58:03',NULL,NULL,NULL,'b9742479-659b-4565-a2a7-be9cfc296d05'),
(5540,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:58:36','2025-11-13 19:58:36',NULL,NULL,NULL,'b780f215-3f10-43c0-9f49-1c4f9dc7b165'),
(5541,1461,NULL,2561,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:58:36','2025-11-13 19:58:36',NULL,NULL,NULL,'7f6f3691-7c5a-4e64-a01d-dc94c812545c'),
(5542,5540,NULL,2562,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:58:36','2025-11-13 19:58:36',NULL,NULL,NULL,'d8e2ddb6-254f-494c-bc2b-0a878512183c'),
(5545,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:59:24','2025-11-13 19:59:24',NULL,NULL,NULL,'9753c4e7-9841-4ee8-897f-b258bcdef6fa'),
(5546,1467,NULL,2563,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:59:24','2025-11-13 19:59:24',NULL,NULL,NULL,'f0e5b7e6-fc58-4786-b52e-2d1038a71136'),
(5547,5545,NULL,2564,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:59:24','2025-11-13 19:59:24',NULL,NULL,NULL,'db8d6b8c-2a5a-4eb4-b08e-d7e0e85b4430'),
(5550,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:59:58','2025-11-13 19:59:58',NULL,NULL,NULL,'3dc09d21-6e5b-45bc-b03d-fa58c9214028'),
(5551,1225,NULL,2565,1,'craft\\elements\\Entry',1,0,'2025-11-13 19:59:58','2025-11-13 19:59:58',NULL,NULL,NULL,'7744200f-705a-444a-89ab-a7701d304570'),
(5552,5550,NULL,2566,21,'craft\\elements\\Entry',1,0,'2025-11-13 19:59:58','2025-11-13 19:59:58',NULL,NULL,NULL,'b9068230-ad82-410b-958f-131a9f1dde2f'),
(5555,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:06:04','2025-11-13 20:06:04',NULL,NULL,NULL,'393625c7-1126-41c6-a708-4d1cae5c4940'),
(5556,1005,NULL,2567,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:06:04','2025-11-13 20:06:04',NULL,NULL,NULL,'0b5b0a53-f3e6-458b-9d07-48c09ab0924b'),
(5557,5555,NULL,2568,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:06:04','2025-11-13 20:06:04',NULL,NULL,NULL,'35e2ade1-503c-4688-ba97-d4065a66e909'),
(5560,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:06:43','2025-11-13 20:06:43',NULL,NULL,NULL,'4da9c30b-6625-4df0-9ec4-dc589648e423'),
(5561,1315,NULL,2569,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:06:43','2025-11-13 20:06:43',NULL,NULL,NULL,'f033a789-e40a-48a3-a51a-e4a8a40b4c30'),
(5562,5560,NULL,2570,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:06:43','2025-11-13 20:06:44',NULL,NULL,NULL,'b2307dea-3910-456a-b3ed-29f66b9b0f4d'),
(5565,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:07:22','2025-11-13 20:07:22',NULL,NULL,NULL,'5604befd-1474-4776-bd34-d21db148e317'),
(5566,1383,NULL,2571,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:07:22','2025-11-13 20:07:22',NULL,NULL,NULL,'cd842f15-f7e7-4fef-8d1f-0e315f0431e1'),
(5567,5565,NULL,2572,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:07:22','2025-11-13 20:07:22',NULL,NULL,NULL,'c7704346-e23e-4970-8045-e4bc428b2195'),
(5570,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:07:52','2025-11-13 20:07:52',NULL,NULL,NULL,'64562e1e-4d2d-4d6b-83a3-df1447080e06'),
(5571,1323,NULL,2573,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:07:52','2025-11-13 20:07:52',NULL,NULL,NULL,'4f450709-9e01-4e0e-859b-3b59b3a45acc'),
(5572,5570,NULL,2574,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:07:52','2025-11-13 20:07:52',NULL,NULL,NULL,'ab6c69dd-e4c0-4365-a008-70c302749192'),
(5575,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:08:25','2025-11-13 20:08:25',NULL,NULL,NULL,'d2d3b35a-8ba1-4ba7-b974-1d3e8a212c05'),
(5576,1011,NULL,2575,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:08:25','2025-11-13 20:08:25',NULL,NULL,NULL,'e79bb47a-5fb7-462e-ae33-c3bd084cf2ef'),
(5577,5575,NULL,2576,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:08:25','2025-11-13 20:08:25',NULL,NULL,NULL,'cc4c910f-97ed-4ce1-a587-3e563bd1c3ec'),
(5579,1011,NULL,2577,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:08:58','2025-11-13 20:08:58',NULL,NULL,NULL,'cbcdbd74-846d-4542-bfec-2b46ef013fc0'),
(5582,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:09:30','2025-11-13 20:09:30',NULL,NULL,NULL,'2405e567-f38d-45b4-b2ea-9131e6bfd614'),
(5583,1091,NULL,2578,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:09:30','2025-11-13 20:09:30',NULL,NULL,NULL,'2e20b5f1-6ded-4bbc-927a-edfda5037f4d'),
(5584,5582,NULL,2579,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:09:30','2025-11-13 20:09:30',NULL,NULL,NULL,'6da86e3a-6b9a-48c6-a62b-b6d8157468c5'),
(5587,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:10:05','2025-11-13 20:10:05',NULL,NULL,NULL,'5139283a-3806-4083-93be-c06a52a93249'),
(5588,1097,NULL,2580,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:10:05','2025-11-13 20:10:05',NULL,NULL,NULL,'9bffb9f0-4099-480d-a445-be375979cb45'),
(5589,5587,NULL,2581,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:10:05','2025-11-13 20:10:05',NULL,NULL,NULL,'1b745318-9334-46ee-acda-80554d5ddf73'),
(5592,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:10:45','2025-11-13 20:10:45',NULL,NULL,NULL,'bfa1ae6c-5254-47a5-b54f-72ab3fb49c0a'),
(5593,1231,NULL,2582,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:10:45','2025-11-13 20:10:45',NULL,NULL,NULL,'d266889a-97eb-42d9-b659-9a2186386515'),
(5594,5592,NULL,2583,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:10:45','2025-11-13 20:10:45',NULL,NULL,NULL,'fc5955f2-5f3f-450f-96d8-81299d9b17d4'),
(5597,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:11:22','2025-11-13 20:11:22',NULL,NULL,NULL,'a6b41748-8604-46f6-84c2-06a9b9e80c69'),
(5598,1103,NULL,2584,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:11:22','2025-11-13 20:11:22',NULL,NULL,NULL,'9f635131-e8d2-43aa-9b3a-dc7fcbb82513'),
(5599,5597,NULL,2585,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:11:22','2025-11-13 20:11:22',NULL,NULL,NULL,'2613ead4-2a6f-4e63-b729-b2c9b3d5dd5c'),
(5602,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:11:57','2025-11-13 20:11:57',NULL,NULL,NULL,'de3d3aa7-2c1a-4503-bb94-a0078133e325'),
(5603,1237,NULL,2586,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:11:57','2025-11-13 20:11:57',NULL,NULL,NULL,'664471d9-dc48-4c1d-bae6-f450ea219522'),
(5604,5602,NULL,2587,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:11:57','2025-11-13 20:11:57',NULL,NULL,NULL,'fc8451db-67fe-479d-9556-b368fb5464c4'),
(5607,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:12:32','2025-11-13 20:12:32',NULL,NULL,NULL,'424112ba-09f6-4a09-951a-71883a00c687'),
(5608,1243,NULL,2588,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:12:32','2025-11-13 20:12:32',NULL,NULL,NULL,'c650f6b1-1242-4152-bb77-637d00489f53'),
(5609,5607,NULL,2589,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:12:32','2025-11-13 20:12:32',NULL,NULL,NULL,'79f6c3a7-f413-4bbe-ad69-2e61d50f87f7'),
(5612,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:13:03','2025-11-13 20:13:03',NULL,NULL,NULL,'88fbe0e3-12d2-4ac4-b594-2f5ebee92728'),
(5613,1389,NULL,2590,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:13:03','2025-11-13 20:13:03',NULL,NULL,NULL,'47539471-09cc-4e05-8d80-698fe3230d5e'),
(5614,5612,NULL,2591,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:13:03','2025-11-13 20:13:03',NULL,NULL,NULL,'55818dd3-4a21-4d12-9475-eb97c710194e'),
(5617,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:13:55','2025-11-13 20:13:55',NULL,NULL,NULL,'691ec391-7fe4-4db5-bdd1-59e4641a9df0'),
(5618,1149,NULL,2592,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:13:55','2025-11-13 20:13:55',NULL,NULL,NULL,'08019a3b-0024-4fdd-b8d4-01cfd54c9753'),
(5619,5617,NULL,2593,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:13:55','2025-11-13 20:13:55',NULL,NULL,NULL,'e7b8f8c0-bcbe-4249-9b1c-38f4c0bebc90'),
(5622,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:14:28','2025-11-13 20:14:28',NULL,NULL,NULL,'eb5e55fd-bcad-4689-8878-ddf0fe59fb2a'),
(5623,1329,NULL,2594,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:14:28','2025-11-13 20:14:28',NULL,NULL,NULL,'2e226661-83cf-448a-a2d5-63f79d27e093'),
(5624,5622,NULL,2595,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:14:28','2025-11-13 20:14:28',NULL,NULL,NULL,'bc1d5823-7f2b-464e-aa5e-4eef602491a6'),
(5627,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:15:18','2025-11-13 20:15:18',NULL,NULL,NULL,'72e15436-9ee3-43a7-abf0-33a3d8045945'),
(5628,1481,NULL,2596,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:15:18','2025-11-13 20:15:18',NULL,NULL,NULL,'603bf66b-d3b3-4fdb-8008-fde864a377ef'),
(5629,5627,NULL,2597,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:15:18','2025-11-13 20:15:18',NULL,NULL,NULL,'3506ef8c-6c61-43f9-bd9c-5d67395b6045'),
(5632,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:15:57','2025-11-13 20:15:57',NULL,NULL,NULL,'987cb1ae-7c76-4dc2-86ac-e3f2717d0654'),
(5633,1017,NULL,2598,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:15:57','2025-11-13 20:15:57',NULL,NULL,NULL,'21e9a8ba-78c7-455c-85ae-7d91b89edbdc'),
(5634,5632,NULL,2599,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:15:57','2025-11-13 20:15:57',NULL,NULL,NULL,'2fc52354-c165-49d3-bbb1-c2d0b9a7cc9c'),
(5636,1023,NULL,2600,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:16:13','2025-11-13 20:16:13',NULL,NULL,NULL,'d6385a36-90d7-46b8-88eb-8008e7ddbe0b'),
(5640,1343,NULL,2601,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:17:06','2025-11-13 20:17:06',NULL,NULL,NULL,'d8f5f583-e383-4a73-b852-885c029b902f'),
(5642,1109,NULL,2602,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:17:14','2025-11-13 20:17:14',NULL,NULL,NULL,'847d0322-b5ae-46c2-9073-1cd81c593703'),
(5644,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:17:57','2025-11-13 20:17:57',NULL,NULL,NULL,'12b1db39-6d35-4814-9b01-b1a530a1feb3'),
(5645,1117,NULL,2603,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:17:57','2025-11-13 20:17:57',NULL,NULL,NULL,'c08ccf2c-70f9-4824-9738-d7ffaf84458a'),
(5646,5644,NULL,2604,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:17:57','2025-11-13 20:17:57',NULL,NULL,NULL,'56c84902-ded4-4f5b-9765-0064af316523'),
(5649,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:18:17','2025-11-13 20:18:17',NULL,NULL,NULL,'9b8b5a54-8c42-44c0-8182-3bde5c1770e4'),
(5650,1473,NULL,2605,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:18:17','2025-11-13 20:18:17',NULL,NULL,NULL,'788b6ac8-737a-4e69-aba7-e6e8769848ea'),
(5651,5649,NULL,2606,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:18:17','2025-11-13 20:18:17',NULL,NULL,NULL,'55f12627-b3e1-4521-a38d-947d9ca63d30'),
(5653,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:18:52','2025-11-13 20:18:52',NULL,NULL,NULL,'7735d056-1819-4311-9ecf-dcaefb7c61e0'),
(5654,1031,NULL,2607,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:18:52','2025-11-13 20:18:52',NULL,NULL,NULL,'a189e7f8-3910-4e20-a647-4e02b14c5466'),
(5655,5653,NULL,2608,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:18:52','2025-11-13 20:18:52',NULL,NULL,NULL,'cb7e0910-3c3c-4ffc-9b01-d8f4ea40b2f9'),
(5657,1035,NULL,2609,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:19:02','2025-11-13 20:19:02',NULL,NULL,NULL,'ad9598a1-f9f0-4759-b115-e65ac5a51e87'),
(5659,1041,NULL,2610,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:19:10','2025-11-13 20:19:10',NULL,NULL,NULL,'9a1db1eb-eeb3-4d95-b0b0-c11c182a403d'),
(5662,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:19:38','2025-11-13 20:19:38',NULL,NULL,NULL,'166a5afe-d84b-4f81-b33e-8837f8dc0fd2'),
(5663,1249,NULL,2611,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:19:38','2025-11-13 20:19:38',NULL,NULL,NULL,'bc18d2fb-820f-4181-b7ba-4e5049f8bf66'),
(5664,5662,NULL,2612,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:19:38','2025-11-13 20:19:38',NULL,NULL,NULL,'01ce7083-2592-4cb6-b51a-6f9d221a44e7'),
(5666,1123,NULL,2613,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:19:48','2025-11-13 20:19:48',NULL,NULL,NULL,'fff4090b-a0f6-430b-bd45-8eefb588fac1'),
(5668,1129,NULL,2614,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:19:54','2025-11-13 20:19:54',NULL,NULL,NULL,'18b3bc0b-7b18-468e-9f7c-f95ebd75b441'),
(5670,1349,NULL,2615,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:20:09','2025-11-13 20:20:09',NULL,NULL,NULL,'d0e660f1-a426-4c88-9448-d29ebb4492d5'),
(5671,1135,NULL,2616,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:20:15','2025-11-13 20:20:15',NULL,NULL,NULL,'dcc6cca3-8a67-4b01-a474-2559e8229b7d'),
(5673,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:20:51','2025-11-13 20:20:51',NULL,NULL,NULL,'84af21b4-68fc-44c2-81b1-57a559a8a686'),
(5674,1141,NULL,2617,1,'craft\\elements\\Entry',1,0,'2025-11-13 20:20:51','2025-11-13 20:20:51',NULL,NULL,NULL,'ba7c5baf-85e4-4da6-9e00-72dbcd481fa6'),
(5675,5673,NULL,2618,21,'craft\\elements\\Entry',1,0,'2025-11-13 20:20:51','2025-11-13 20:20:51',NULL,NULL,NULL,'cb393205-d14f-463c-987d-0df40fd13c52'),
(5680,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-13 20:33:41','2026-01-16 12:35:27',NULL,NULL,NULL,'430dfc96-69b2-4a78-9c07-cf882160dc38'),
(5681,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-13 21:31:58','2026-01-16 12:39:10',NULL,NULL,NULL,'8e3ba80f-eca1-42be-8ec5-147fb2ead3a6'),
(5682,951,NULL,2619,1,'craft\\elements\\Entry',1,0,'2025-11-13 21:31:58','2025-11-13 21:31:58',NULL,NULL,NULL,'7bb03933-0caf-49b5-9f7f-1749248146e9'),
(5683,5681,NULL,2620,21,'craft\\elements\\Entry',1,0,'2025-11-13 21:31:58','2025-11-13 21:31:59',NULL,NULL,NULL,'17b21b38-3f3a-4d88-827b-239d94d1637c'),
(5684,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-14 09:59:59','2025-11-14 09:59:59',NULL,NULL,NULL,'3a5978c7-2c17-4746-92b3-6f76369b3877'),
(5685,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-14 10:13:16','2025-11-14 10:13:16',NULL,NULL,NULL,'8abd4e45-d4c9-4df4-9f7c-86863efa9823'),
(5691,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-14 15:53:02','2025-11-14 15:53:02',NULL,NULL,NULL,'4051b404-8fd1-4aa8-b49a-e479c4334de8'),
(5696,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:30:28','2025-11-14 16:30:28',NULL,NULL,NULL,'c76c0a80-350c-4cfb-ab24-e44403eec4dd'),
(5697,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:30:46','2025-11-14 16:30:46',NULL,NULL,NULL,'89375761-c720-422f-b9ca-eacbd3cfb610'),
(5698,2720,NULL,2621,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:30:46','2025-11-14 16:30:47',NULL,NULL,NULL,'61a5ab5a-74e1-41bf-9b8b-cc58d07b81a7'),
(5699,5697,NULL,2622,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:30:46','2025-11-14 16:30:47',NULL,NULL,NULL,'348137b7-8ed9-4c98-9d4f-bd00db94e438'),
(5701,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:32:56','2025-11-14 16:32:56',NULL,NULL,NULL,'7b4d1554-4935-4703-b47a-14d383c1ae60'),
(5702,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:33:01','2025-11-14 16:33:01',NULL,NULL,NULL,'6a7ae623-b486-4481-879c-c562a48f6ad0'),
(5703,945,NULL,2623,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:33:01','2025-11-14 16:33:01',NULL,NULL,NULL,'2b921c4e-0897-40db-8d9f-9f4bef793059'),
(5704,5702,NULL,2624,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:33:01','2025-11-14 16:33:01',NULL,NULL,NULL,'0cf34bb4-fe5e-4622-86fe-005412d1fe0c'),
(5709,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:35:53','2025-11-14 16:35:53',NULL,NULL,NULL,'5ae74911-5b87-4f14-9756-b705908deddc'),
(5710,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:35:59','2025-11-14 16:35:59',NULL,NULL,NULL,'efd0e87c-f58b-4aad-ba98-340c13f95d3b'),
(5711,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:35:59','2025-11-14 16:35:59',NULL,NULL,NULL,'f32f071c-f55f-4940-8fe2-3aa451955253'),
(5712,1353,NULL,2625,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:35:59','2025-11-14 16:35:59',NULL,NULL,NULL,'9b418d9d-6cf0-45e4-b5f0-c90d40dca6e7'),
(5713,5710,NULL,2626,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:35:59','2025-11-14 16:35:59',NULL,NULL,NULL,'b38978bf-de82-4f7e-82c1-288e50412f21'),
(5714,5711,NULL,2627,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:35:59','2025-11-14 16:35:59',NULL,NULL,NULL,'e9199d5e-8a5f-4736-9cc6-896808bb26ab'),
(5719,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:38:15','2025-11-14 16:38:15',NULL,NULL,NULL,'72f43d97-fbf3-416e-995d-4768d0143302'),
(5720,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:38:20','2025-11-14 16:38:20',NULL,NULL,NULL,'fa8e70f8-6a53-4281-8575-2cf870a5bac6'),
(5721,1171,NULL,2628,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:38:20','2025-11-14 16:38:20',NULL,NULL,NULL,'6fb10d75-54d0-4244-9722-9af3961cafb6'),
(5722,5720,NULL,2629,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:38:20','2025-11-14 16:38:20',NULL,NULL,NULL,'00f701d5-dba3-4c09-8a26-9a4aebe1c509'),
(5724,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:40:19','2025-11-14 16:40:19',NULL,NULL,NULL,'b8b6bd8d-cdf1-484c-8fc0-87524b0406ec'),
(5725,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:40:24','2025-11-14 16:40:24',NULL,NULL,NULL,'b218ee24-6c4d-4219-bdc5-84524d69ffc8'),
(5726,1261,NULL,2630,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:40:24','2025-11-14 16:40:24',NULL,NULL,NULL,'fb982886-18a9-452f-a811-9a696413b588'),
(5727,5725,NULL,2631,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:40:24','2025-11-14 16:40:24',NULL,NULL,NULL,'d583b55c-e787-43ed-a7a3-b047e9a75b01'),
(5730,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:41:40','2025-11-14 16:41:40',NULL,NULL,NULL,'d1a8a4c0-64cd-4cfe-ae0e-d1e1e6e89373'),
(5731,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:42:09','2025-11-14 16:42:09',NULL,NULL,NULL,'e729f916-e465-45fa-a98e-91d49875fc8f'),
(5732,1177,NULL,2632,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:42:08','2025-11-14 16:42:09',NULL,NULL,NULL,'40ae0d0c-34b4-46dd-a70a-8cbc0bfc190d'),
(5733,5731,NULL,2633,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:42:09','2025-11-14 16:42:09',NULL,NULL,NULL,'0eabf783-f9c8-473c-bafe-7e3c3bc24290'),
(5737,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:44:22','2025-11-14 16:44:22',NULL,NULL,NULL,'418bac6b-3c4a-4924-87c9-7b7d5a30f81d'),
(5738,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:44:22','2025-11-14 16:44:22',NULL,NULL,NULL,'62e9e73a-d9c5-4004-a5fa-1ad021852d6a'),
(5739,2880,NULL,2634,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:44:22','2025-11-14 16:44:22',NULL,NULL,NULL,'fd854cb7-b99c-4078-ace1-e7b1be46c4bf'),
(5740,5737,NULL,2635,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:44:22','2025-11-14 16:44:22',NULL,NULL,NULL,'831c0127-692c-4b5e-9d04-1c2b15078cd2'),
(5741,5738,NULL,2636,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:44:22','2025-11-14 16:44:22',NULL,NULL,NULL,'47be8d85-52e3-48e4-98ed-4068c9602ba6'),
(5744,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:45:17','2025-11-14 16:45:17',NULL,NULL,NULL,'781b00c4-fe6d-483c-95ed-9eb8ef0078c0'),
(5745,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:45:25','2025-11-14 16:45:25',NULL,NULL,NULL,'44d280be-c9b1-4dcc-acc8-0adc0a626643'),
(5746,957,NULL,2637,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:45:25','2025-11-14 16:45:25',NULL,NULL,NULL,'83879ad6-16b9-4d71-863e-789dd27c1d95'),
(5747,5745,NULL,2638,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:45:25','2025-11-14 16:45:25',NULL,NULL,NULL,'73a6b379-c6cf-4fc0-a74f-294aaf6f58a5'),
(5749,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:46:23','2025-11-14 16:46:23',NULL,NULL,NULL,'019e6ed4-b5b9-4d28-83fd-75ae2f8735f4'),
(5750,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:46:33','2025-11-14 16:46:33',NULL,NULL,NULL,'4ab3aab9-ff66-45b2-9c64-c4abf1dc4b2e'),
(5751,963,NULL,2639,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:46:33','2025-11-14 16:46:33',NULL,NULL,NULL,'c19691a6-abd7-4ce9-a24a-e3d7fbfe70a7'),
(5752,5750,NULL,2640,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:46:33','2025-11-14 16:46:33',NULL,NULL,NULL,'53e38000-7f49-47dd-8ea5-e1c7d1a34cb9'),
(5755,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:47:41','2025-11-14 16:47:41',NULL,NULL,NULL,'6928396c-4156-48bc-90b3-2cc25640b3c1'),
(5756,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:47:45','2025-11-14 16:47:45',NULL,NULL,NULL,'ad8ef8c7-0e69-4da1-8d7c-ec2f35f6fcc6'),
(5757,1185,NULL,2641,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:47:45','2025-11-14 16:47:45',NULL,NULL,NULL,'138cf9e0-b25d-496f-a6cc-48c5db8c9a61'),
(5758,5756,NULL,2642,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:47:45','2025-11-14 16:47:45',NULL,NULL,NULL,'f17f4f8f-1aef-41fc-affe-ab2ab874c5c7'),
(5761,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:48:35','2025-11-14 16:48:35',NULL,NULL,NULL,'b89876e2-9e97-4437-bde3-1c387a5eda10'),
(5762,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:48:38','2025-11-14 16:48:38',NULL,NULL,NULL,'e982e304-c7f9-4e0c-bfdd-f497433ed93a'),
(5763,1059,NULL,2643,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:48:38','2025-11-14 16:48:38',NULL,NULL,NULL,'82bc1c88-2b08-4ffe-ac19-885a9ce53973'),
(5764,5762,NULL,2644,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:48:38','2025-11-14 16:48:38',NULL,NULL,NULL,'7554ad70-a485-481a-ab6b-d38bb77741f4'),
(5767,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:49:42','2025-11-14 16:49:42',NULL,NULL,NULL,'213a5b4c-1dc9-41c3-a9a5-a773da693ba3'),
(5768,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:49:46','2025-11-14 16:49:46',NULL,NULL,NULL,'05f55d13-e96d-4d7b-9195-6d873e44633d'),
(5769,1269,NULL,2645,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:49:46','2025-11-14 16:49:46',NULL,NULL,NULL,'dbf17a8e-fff6-40e9-9f9e-19437bf10a06'),
(5770,5768,NULL,2646,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:49:46','2025-11-14 16:49:46',NULL,NULL,NULL,'834ccfff-9c2a-4e6f-b739-7f5d45d998f2'),
(5773,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:50:30','2025-11-14 16:50:30',NULL,NULL,NULL,'6e9e8526-e22e-4951-ba46-c79e2b02b4be'),
(5774,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:50:33','2025-11-14 16:50:33',NULL,NULL,NULL,'ade46a2f-9568-4ae4-b870-6468e79061cf'),
(5775,969,NULL,2647,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:50:33','2025-11-14 16:50:33',NULL,NULL,NULL,'03d0f535-42e7-4c14-862e-6df6a9154733'),
(5776,5774,NULL,2648,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:50:33','2025-11-14 16:50:33',NULL,NULL,NULL,'1c911a07-70e6-4945-9eba-7953b9a5e187'),
(5779,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:51:25','2025-11-14 16:51:25',NULL,NULL,NULL,'691b8783-894b-4fee-9634-7cbe05fa7072'),
(5780,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:51:28','2025-11-14 16:51:28',NULL,NULL,NULL,'55ffbf09-b2fb-418f-b287-9b2529acd6fc'),
(5781,1277,NULL,2649,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:51:28','2025-11-14 16:51:28',NULL,NULL,NULL,'5a733b4f-bdca-4c92-acf9-58b300f29022'),
(5782,5780,NULL,2650,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:51:28','2025-11-14 16:51:28',NULL,NULL,NULL,'f1d3c704-7979-465e-bb1f-73aedcf7d8b4'),
(5785,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:54:28','2025-11-14 16:54:28',NULL,NULL,NULL,'04b7e4ca-f8df-4608-bd7a-e859b58f7113'),
(5786,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:54:37','2025-11-14 16:54:37',NULL,NULL,NULL,'015885cf-b4f9-45ba-881e-71b8ce006da8'),
(5787,1191,NULL,2651,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:54:37','2025-11-14 16:54:37',NULL,NULL,NULL,'7ee63f68-2515-4de3-b48a-7b7147994ec3'),
(5788,5786,NULL,2652,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:54:37','2025-11-14 16:54:37',NULL,NULL,NULL,'257e1e04-b592-42e4-9365-48a13529e8c7'),
(5791,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:55:28','2025-11-14 16:55:28',NULL,NULL,NULL,'27fb55ef-158c-4628-9109-227ce8ff4a65'),
(5792,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:55:31','2025-11-14 16:55:31',NULL,NULL,NULL,'5bcf502e-5f02-4a2f-9212-e0b158b4027b'),
(5793,1419,NULL,2653,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:55:31','2025-11-14 16:55:31',NULL,NULL,NULL,'2305c313-8c4b-4aa6-a02f-41121a093aaf'),
(5794,5792,NULL,2654,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:55:31','2025-11-14 16:55:31',NULL,NULL,NULL,'ff0fadda-16a2-455f-9690-a0bdedbf5da6'),
(5797,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:56:44','2025-11-14 16:56:44',NULL,NULL,NULL,'84761aa9-3d80-439d-b475-35a665de5a66'),
(5798,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:56:47','2025-11-14 16:56:47',NULL,NULL,NULL,'fdb989b4-83c7-4078-bece-6e6e18f02620'),
(5799,975,NULL,2655,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:56:47','2025-11-14 16:56:47',NULL,NULL,NULL,'3f98653f-9dfe-4a85-84a7-82192b8788d3'),
(5800,5798,NULL,2656,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:56:47','2025-11-14 16:56:47',NULL,NULL,NULL,'42fdf355-a221-4e2d-b99b-e0326ca93286'),
(5803,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:57:49','2025-11-14 16:57:49',NULL,NULL,NULL,'0e7c4451-0821-40a9-83b5-4276ada8511e'),
(5804,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:57:53','2025-11-14 16:57:53',NULL,NULL,NULL,'e02c4fed-2226-4dbb-9b1c-7d01259e8f97'),
(5805,1067,NULL,2657,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:57:53','2025-11-14 16:57:53',NULL,NULL,NULL,'4b9ea3e4-83c9-488c-b5e4-abc3a701a7f0'),
(5806,5804,NULL,2658,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:57:53','2025-11-14 16:57:53',NULL,NULL,NULL,'e51dec22-d17c-4d87-91ae-05da1b6d0964'),
(5809,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:58:49','2025-11-14 16:58:49',NULL,NULL,NULL,'81aab63d-d2f3-4bb5-bb01-15c2f93a9eb5'),
(5810,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:58:53','2025-11-14 16:58:53',NULL,NULL,NULL,'5e39ed24-7a8b-499a-b231-3087d09b9c65'),
(5811,1431,NULL,2659,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:58:53','2025-11-14 16:58:53',NULL,NULL,NULL,'4f5bd664-1683-4ece-bd9b-81a317bf4c5a'),
(5812,5810,NULL,2660,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:58:53','2025-11-14 16:58:53',NULL,NULL,NULL,'fe66730d-d8f9-47be-b4f5-26a89003b32f'),
(5815,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 16:59:09','2025-11-14 16:59:09',NULL,NULL,NULL,'e490fac8-28be-47a4-906e-f3c9adc1caaa'),
(5816,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:59:14','2025-11-14 16:59:14',NULL,NULL,NULL,'08911c36-d211-4950-a621-067037165c6b'),
(5817,1437,NULL,2661,1,'craft\\elements\\Entry',1,0,'2025-11-14 16:59:13','2025-11-14 16:59:14',NULL,NULL,NULL,'168d95ec-3049-4ce6-9d15-276a11ba2c76'),
(5818,5816,NULL,2662,21,'craft\\elements\\Entry',1,0,'2025-11-14 16:59:14','2025-11-14 16:59:14',NULL,NULL,NULL,'9779dc71-93e6-42fc-8e13-16af1c47d973'),
(5821,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:03:37','2025-11-14 17:03:37',NULL,NULL,NULL,'1e6b6f00-50e6-4f21-961a-38e5e9cd3973'),
(5822,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:03:41','2025-11-14 17:03:41',NULL,NULL,NULL,'1d48012d-b1a6-47e2-91f7-09e4f5260f6f'),
(5823,1283,NULL,2663,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:03:41','2025-11-14 17:03:41',NULL,NULL,NULL,'e9f664be-c288-4134-8116-36c1a5bad9df'),
(5824,5822,NULL,2664,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:03:41','2025-11-14 17:03:41',NULL,NULL,NULL,'6a7c7b02-f0bf-4404-acd9-d38a7f329b15'),
(5827,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:04:36','2025-11-14 17:04:36',NULL,NULL,NULL,'9f7c15c6-efab-460e-b49a-8fb6a3fa772a'),
(5828,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:04:44','2025-11-14 17:04:44',NULL,NULL,NULL,'5b4c811c-6a3e-4da4-9a6b-375c74143577'),
(5829,1197,NULL,2665,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:04:44','2025-11-14 17:04:44',NULL,NULL,NULL,'8b8e2154-5c21-494d-9e8d-c8e4ff98cb25'),
(5830,5828,NULL,2666,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:04:44','2025-11-14 17:04:44',NULL,NULL,NULL,'277ba3ca-a26b-4dac-a604-77ebd2a1f7ed'),
(5833,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:05:35','2025-11-14 17:05:35',NULL,NULL,NULL,'061f404f-81a1-4f5d-80ea-0aae3287210a'),
(5834,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:05:38','2025-11-14 17:05:38',NULL,NULL,NULL,'6a518fb9-ec1a-432b-870d-75f6dee87e80'),
(5835,1201,NULL,2667,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:05:38','2025-11-14 17:05:38',NULL,NULL,NULL,'4c435315-8056-4419-80bb-c46bea8534c7'),
(5836,5834,NULL,2668,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:05:38','2025-11-14 17:05:38',NULL,NULL,NULL,'0c2758f1-d098-4617-86c6-0ab883cda596'),
(5839,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:06:42','2025-11-14 17:06:42',NULL,NULL,NULL,'4a1cb1a0-09b8-4380-af94-3ebbe59b426a'),
(5840,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:06:45','2025-11-14 17:06:45',NULL,NULL,NULL,'4420223e-752d-42ab-9b7b-37ec250952f0'),
(5841,1209,NULL,2669,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:06:45','2025-11-14 17:06:45',NULL,NULL,NULL,'6639c759-a9bc-4fb0-b048-b05cec7709ef'),
(5842,5840,NULL,2670,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:06:45','2025-11-14 17:06:45',NULL,NULL,NULL,'74286996-93d0-4e89-83f1-5efb4a495336'),
(5845,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:07:30','2025-11-14 17:07:30',NULL,NULL,NULL,'e14df919-881e-43fb-b572-1c1e45b90c85'),
(5846,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:07:37','2025-11-14 17:07:37',NULL,NULL,NULL,'e6f246d0-5725-4d0d-8ba9-0e08ce51a2b1'),
(5847,1289,NULL,2671,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:07:37','2025-11-14 17:07:37',NULL,NULL,NULL,'eeb6cd98-f7fe-4627-b39c-c1440b9f32d8'),
(5848,5846,NULL,2672,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:07:37','2025-11-14 17:07:37',NULL,NULL,NULL,'8d072ed3-532a-4365-81e9-b253f25db75d'),
(5851,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:08:25','2025-11-14 17:08:25',NULL,NULL,NULL,'43c97592-9889-41ea-b5c3-3881e6c63968'),
(5852,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:08:31','2025-11-14 17:08:31',NULL,NULL,NULL,'ab300b3b-1770-4c37-aaf5-dbb28f9b7232'),
(5853,1297,NULL,2673,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:08:31','2025-11-14 17:08:31',NULL,NULL,NULL,'a09df130-6ba3-4489-a572-05ad6561fdc7'),
(5854,5852,NULL,2674,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:08:31','2025-11-14 17:08:31',NULL,NULL,NULL,'5547174f-53b2-4ed2-9ecd-ec383cd103d3'),
(5857,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:09:18','2025-11-14 17:09:18',NULL,NULL,NULL,'9ca7c367-3f97-4d89-b804-3d93ad53d0dc'),
(5858,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:09:23','2025-11-14 17:09:23',NULL,NULL,NULL,'baa569bf-666c-43fe-b242-f03a0781c77c'),
(5859,981,NULL,2675,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:09:23','2025-11-14 17:09:23',NULL,NULL,NULL,'f3686ac1-98bc-412d-9562-755c42354d23'),
(5860,5858,NULL,2676,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:09:23','2025-11-14 17:09:23',NULL,NULL,NULL,'6e0e3bd9-1e36-4c6a-bf79-d2f77a30894c'),
(5863,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:10:25','2025-11-14 17:10:25',NULL,NULL,NULL,'f28c4272-ac4c-41f4-b50e-ef544f4f9d9a'),
(5864,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:10:29','2025-11-14 17:10:29',NULL,NULL,NULL,'9c1196ee-efbf-4652-8700-953c8d8b1c58'),
(5865,1073,NULL,2677,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:10:29','2025-11-14 17:10:29',NULL,NULL,NULL,'20999dfb-5f8b-413d-85a2-323834961469'),
(5866,5864,NULL,2678,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:10:29','2025-11-14 17:10:29',NULL,NULL,NULL,'90364579-46c9-4cfe-b26c-b015fe770c82'),
(5869,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:12:18','2025-11-14 17:12:18',NULL,NULL,NULL,'957120e2-2e3d-4766-8b5a-9af89cc33e73'),
(5870,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:12:22','2025-11-14 17:12:22',NULL,NULL,NULL,'97b40f7d-9e35-443c-af43-f64650200c54'),
(5871,1303,NULL,2679,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:12:22','2025-11-14 17:12:22',NULL,NULL,NULL,'8ad2bed7-d65f-487d-8041-610bf3015893'),
(5872,5870,NULL,2680,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:12:22','2025-11-14 17:12:22',NULL,NULL,NULL,'5e23ac83-8479-4107-8b66-43c22cef60e3'),
(5875,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:13:10','2025-11-14 17:13:10',NULL,NULL,NULL,'80b3026f-d52e-44b3-8d05-f48830c6e040'),
(5876,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:13:14','2025-11-14 17:13:14',NULL,NULL,NULL,'13908541-d2c5-4026-a761-9c23970f58b2'),
(5877,1455,NULL,2681,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:13:13','2025-11-14 17:13:14',NULL,NULL,NULL,'5a8fdeed-d827-4513-bf0a-7dc52ec6d27e'),
(5878,5876,NULL,2682,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:13:14','2025-11-14 17:13:14',NULL,NULL,NULL,'111f50f8-2825-4d04-9883-c5326b3b286d'),
(5881,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:13:55','2025-11-14 17:13:55',NULL,NULL,NULL,'023181d1-9a34-418f-b6e7-da294376c20f'),
(5882,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:13:58','2025-11-14 17:13:58',NULL,NULL,NULL,'97e17e3c-de15-4dfc-b20a-f5df06e0eb14'),
(5883,989,NULL,2683,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:13:58','2025-11-14 17:13:58',NULL,NULL,NULL,'b75cc211-596b-4a9c-9971-edb54247ceba'),
(5884,5882,NULL,2684,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:13:58','2025-11-14 17:13:58',NULL,NULL,NULL,'9ce3d33d-24c7-42ea-8f52-cc33ea01ba29'),
(5887,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:16:02','2025-11-14 17:16:02',NULL,NULL,NULL,'aa4913b5-b379-4e92-9141-e468a53c87a8'),
(5888,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:16:05','2025-11-14 17:16:05',NULL,NULL,NULL,'8dd496a5-b305-4fb8-ae4e-6f28223bbfea'),
(5889,1219,NULL,2685,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:16:05','2025-11-14 17:16:05',NULL,NULL,NULL,'c248b1aa-a88d-4a17-821a-866fb096c27d'),
(5890,5888,NULL,2686,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:16:05','2025-11-14 17:16:05',NULL,NULL,NULL,'2e38a27a-49bd-437f-ba5e-44a1ca829db4'),
(5893,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:16:53','2025-11-14 17:16:53',NULL,NULL,NULL,'cef3eb1f-7f6b-4381-a391-7719eff96e95'),
(5894,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:17:11','2025-11-14 17:17:11',NULL,NULL,NULL,'7e398fc0-9cfa-4231-924e-85107808157c'),
(5895,999,NULL,2687,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:17:11','2025-11-14 17:17:11',NULL,NULL,NULL,'84db5ad1-306b-498b-b742-44a5469660fb'),
(5896,5894,NULL,2688,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:17:11','2025-11-14 17:17:11',NULL,NULL,NULL,'8662faf0-a952-4b64-858d-ca01fc8abad6'),
(5899,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:18:15','2025-11-14 17:18:15',NULL,NULL,NULL,'a94934d5-b061-4f35-854d-9c9d5baea925'),
(5900,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:18:18','2025-11-14 17:18:18',NULL,NULL,NULL,'483ebd58-613b-4641-bafc-9f05c189b1f7'),
(5901,1477,NULL,2689,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:18:18','2025-11-14 17:18:18',NULL,NULL,NULL,'58875480-9136-40ef-b162-251a68e02490'),
(5902,5900,NULL,2690,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:18:18','2025-11-14 17:18:18',NULL,NULL,NULL,'6c011874-d16c-4189-974c-3c58ba2bdfeb'),
(5905,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:20:41','2025-11-14 17:20:41',NULL,NULL,NULL,'35f7bc54-c321-4098-a8d5-efb92b0dac27'),
(5906,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:20:43','2025-11-14 17:20:43',NULL,NULL,NULL,'e3184b53-cc4a-4128-9f28-09e8f49a040a'),
(5907,1085,NULL,2691,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:20:43','2025-11-14 17:20:43',NULL,NULL,NULL,'a651c0c6-74e3-4d34-9a3a-e35472dba447'),
(5908,5906,NULL,2692,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:20:43','2025-11-14 17:20:43',NULL,NULL,NULL,'e2df9aea-7d2b-47a9-8837-33f870486607'),
(5911,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:21:30','2025-11-14 17:21:30',NULL,NULL,NULL,'018c2421-66da-49c7-9479-c38f307c36ad'),
(5912,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:21:34','2025-11-14 17:21:34',NULL,NULL,NULL,'d1eb44b3-f5cd-44ac-91c8-7ecea0c11861'),
(5913,1467,NULL,2693,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:21:34','2025-11-14 17:21:34',NULL,NULL,NULL,'fcbeda23-ebaa-449e-8cef-676bfaf4d825'),
(5914,5912,NULL,2694,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:21:34','2025-11-14 17:21:34',NULL,NULL,NULL,'1368110d-7c7c-4997-aa2e-c8175a4f26b4'),
(5917,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:24:31','2025-11-14 17:24:31',NULL,NULL,NULL,'2ddaccf2-1fa0-47eb-8924-17e47d11b9cc'),
(5918,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:24:43','2025-11-14 17:24:43',NULL,NULL,NULL,'1023f539-9276-4c3f-bf00-87d099fea71f'),
(5919,1225,NULL,2695,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:24:43','2025-11-14 17:24:43',NULL,NULL,NULL,'678f6640-8c5e-4c9f-a75f-5e28ba47fe15'),
(5920,5918,NULL,2696,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:24:43','2025-11-14 17:24:43',NULL,NULL,NULL,'03f7d2be-92e1-444f-b53a-aa2cb50d3d03'),
(5923,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:26:04','2025-11-14 17:26:04',NULL,NULL,NULL,'da1b3d1e-9016-4b0f-9473-8887d3c4d422'),
(5924,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:26:13','2025-11-14 17:26:13',NULL,NULL,NULL,'844bea3c-d723-48ea-8249-177fcfbc40ad'),
(5925,1315,NULL,2697,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:26:13','2025-11-14 17:26:13',NULL,NULL,NULL,'cc1a784d-5f39-44e5-b5c6-a3ea749be36c'),
(5926,5924,NULL,2698,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:26:13','2025-11-14 17:26:13',NULL,NULL,NULL,'210af780-f09c-4731-85dc-3b2f5253a305'),
(5929,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:27:16','2025-11-14 17:27:16',NULL,NULL,NULL,'0f0f6a8b-0728-4c83-b18e-200a27eb508b'),
(5930,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:27:22','2025-11-14 17:27:22',NULL,NULL,NULL,'869b8681-1b2e-4e73-9dba-b504adf15145'),
(5931,1323,NULL,2699,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:27:22','2025-11-14 17:27:22',NULL,NULL,NULL,'87e0ca82-29d5-4f67-a6f8-525e1f66d923'),
(5932,5930,NULL,2700,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:27:22','2025-11-14 17:27:22',NULL,NULL,NULL,'e685205b-3120-4dfe-9874-68abb17b5c45'),
(5935,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:28:30','2025-11-14 17:28:30',NULL,NULL,NULL,'3cff4612-5b80-47ad-8860-5425c0e7cba7'),
(5936,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:28:32','2025-11-14 17:28:32',NULL,NULL,NULL,'29845f7f-ecbf-4a26-9054-d1d1bca6e2d3'),
(5937,1011,NULL,2701,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:28:32','2025-11-14 17:28:32',NULL,NULL,NULL,'45e60842-d7a4-4446-94f0-5f98bbde9a37'),
(5938,5936,NULL,2702,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:28:32','2025-11-14 17:28:32',NULL,NULL,NULL,'a0ef124e-13a5-4385-9c64-bbecebe071f9'),
(5941,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:29:45','2025-11-14 17:29:45',NULL,NULL,NULL,'114cc6d3-27c8-47da-b15c-4509e2f2a23a'),
(5942,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:29:48','2025-11-14 17:29:48',NULL,NULL,NULL,'74d8a6c4-0a2f-4803-b7ce-603a49e458a5'),
(5943,1091,NULL,2703,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:29:48','2025-11-14 17:29:48',NULL,NULL,NULL,'b9fadaa7-fc87-4a5f-a082-1cbff4b95152'),
(5944,5942,NULL,2704,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:29:48','2025-11-14 17:29:48',NULL,NULL,NULL,'7cec470f-6b6b-422e-ad1b-1c8b3374155e'),
(5947,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:31:11','2025-11-14 17:31:11',NULL,NULL,NULL,'9229d297-7d1d-40c9-b6af-8712e3e12b24'),
(5948,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:31:14','2025-11-14 17:31:14',NULL,NULL,NULL,'7d5a2088-aa65-41b5-ba16-ff8c7e12e856'),
(5949,1237,NULL,2705,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:31:14','2025-11-14 17:31:14',NULL,NULL,NULL,'b62f589d-9b2f-45d9-a2ed-5eaba3671b30'),
(5950,5948,NULL,2706,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:31:14','2025-11-14 17:31:14',NULL,NULL,NULL,'4e000f16-27f7-499c-9fd5-a191bce0b8e3'),
(5953,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:32:13','2025-11-14 17:32:13',NULL,NULL,NULL,'a23312c2-95b9-4e4c-8347-ab5e7c6a1a39'),
(5954,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:32:17','2025-11-14 17:32:17',NULL,NULL,NULL,'e9f375de-7b61-4546-9ca9-752869e9972c'),
(5955,1243,NULL,2707,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:32:17','2025-11-14 17:32:18',NULL,NULL,NULL,'4446f221-64b0-43dc-acfc-efc793c0f630'),
(5956,5954,NULL,2708,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:32:17','2025-11-14 17:32:18',NULL,NULL,NULL,'8dc87d23-2b91-471d-9283-c44b52ffe089'),
(5959,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:33:17','2025-11-14 17:33:17',NULL,NULL,NULL,'61e8e83f-c72c-4bbc-b0e5-dadd1f9026ac'),
(5960,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:33:20','2025-11-14 17:33:20',NULL,NULL,NULL,'526899c8-cc41-4a64-9124-d801dee98f7f'),
(5961,1389,NULL,2709,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:33:20','2025-11-14 17:33:20',NULL,NULL,NULL,'761bf813-06bb-4f77-87c4-36ccf33cad33'),
(5962,5960,NULL,2710,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:33:20','2025-11-14 17:33:20',NULL,NULL,NULL,'978263c9-a966-4a2e-be95-f9757fff144e'),
(5965,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:45:07','2025-11-14 17:45:07',NULL,NULL,NULL,'7673b2bd-bba7-485b-b0c9-6416db908338'),
(5966,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:45:13','2025-11-14 17:45:13',NULL,NULL,NULL,'0421b025-bb03-4a05-8da8-8ed2ca5856cd'),
(5967,1329,NULL,2711,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:45:12','2025-11-14 17:45:13',NULL,NULL,NULL,'e39b7d23-9f3c-41ef-8d11-f5f0edbf82dd'),
(5968,5966,NULL,2712,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:45:13','2025-11-14 17:45:13',NULL,NULL,NULL,'1687f7e4-3fb3-4a13-89e7-65ee70a164ca'),
(5971,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:46:23','2025-11-14 17:46:23',NULL,NULL,NULL,'bbab795b-dbad-4978-b99f-8e3be7f11504'),
(5972,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:46:29','2025-11-14 17:46:29',NULL,NULL,NULL,'3125e78a-4a6a-4776-84f8-20dc50b9bc76'),
(5973,1481,NULL,2713,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:46:29','2025-11-14 17:46:29',NULL,NULL,NULL,'85dac35e-a346-4d68-80cd-d5517f0ed4d4'),
(5974,5972,NULL,2714,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:46:29','2025-11-14 17:46:29',NULL,NULL,NULL,'f79a9fd2-e558-49f4-a98b-da12bd0d970e'),
(5977,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:47:39','2025-11-14 17:47:39',NULL,NULL,NULL,'7eb8d354-3fdc-49ac-9299-395ee3cbcc72'),
(5978,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:47:42','2025-11-14 17:47:42',NULL,NULL,NULL,'c9dd3a88-61bf-4bb4-a4c4-522a4529e502'),
(5979,1023,NULL,2715,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:47:42','2025-11-14 17:47:42',NULL,NULL,NULL,'b67fe16f-2ff7-4728-ae9e-a5269c90bba0'),
(5980,5978,NULL,2716,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:47:42','2025-11-14 17:47:42',NULL,NULL,NULL,'c793b74b-89b2-4a3b-b822-dccb3132d5dd'),
(5982,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:48:40','2025-11-14 17:48:40',NULL,NULL,NULL,'d37aebac-14ac-4d45-b6fe-84329a95e509'),
(5983,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:48:42','2025-11-14 17:48:42',NULL,NULL,NULL,'781f0d8d-f79b-46fa-a2fc-f4969f911c85'),
(5984,1337,NULL,2717,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:48:42','2025-11-14 17:48:42',NULL,NULL,NULL,'e1a8cf2d-a60d-40ee-9338-a7065022a49e'),
(5985,5983,NULL,2718,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:48:42','2025-11-14 17:48:42',NULL,NULL,NULL,'c1f91acc-7f13-4204-9054-da27bb4f864a'),
(5987,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 17:50:30','2025-11-14 17:50:30',NULL,NULL,NULL,'730e8d1b-90c4-4420-8b1e-21feff0d327b'),
(5988,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:50:36','2025-11-14 17:50:36',NULL,NULL,NULL,'403445a1-cf8f-4b58-8a36-d1f40aa0e65a'),
(5989,1407,NULL,2719,1,'craft\\elements\\Entry',1,0,'2025-11-14 17:50:36','2025-11-14 17:50:36',NULL,NULL,NULL,'76ab2a64-d741-4b16-87b9-3db982d02d36'),
(5990,5988,NULL,2720,21,'craft\\elements\\Entry',1,0,'2025-11-14 17:50:36','2025-11-14 17:50:36',NULL,NULL,NULL,'60d1ae4d-aece-47b3-9ebf-d5a670fa295b'),
(5994,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 18:15:34','2025-11-14 18:15:34',NULL,NULL,NULL,'267cf38f-b481-45e3-8748-e1d9bbc5ca5d'),
(5995,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:15:40','2025-11-14 18:15:40',NULL,NULL,NULL,'9c034241-815c-4f22-8828-096f51e0910b'),
(5996,1343,NULL,2721,1,'craft\\elements\\Entry',1,0,'2025-11-14 18:15:40','2025-11-14 18:15:40',NULL,NULL,NULL,'ad3890d3-bb9b-4c3a-a9b0-49ca509873fd'),
(5997,5995,NULL,2722,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:15:40','2025-11-14 18:15:41',NULL,NULL,NULL,'f556828e-985c-4e6b-a9ef-a227a6e0b36b'),
(6000,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 18:16:36','2025-11-14 18:16:36',NULL,NULL,NULL,'f7cd0456-d214-469f-b42e-89fecb077b55'),
(6001,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:17:03','2025-11-14 18:17:03',NULL,NULL,NULL,'82e2b763-fa8f-4b5c-a0ae-6e351c105ede'),
(6002,1109,NULL,2723,1,'craft\\elements\\Entry',1,0,'2025-11-14 18:17:03','2025-11-14 18:17:03',NULL,NULL,NULL,'5c88e8a4-91d1-45a3-ae18-38d578c64d0d'),
(6003,6001,NULL,2724,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:17:03','2025-11-14 18:17:03',NULL,NULL,NULL,'1f572a74-626f-41e9-9361-bb43365f44e3'),
(6006,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 18:17:47','2025-11-14 18:17:47',NULL,NULL,NULL,'59706f19-17c1-4445-9c7a-4015fd34d070'),
(6007,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:17:51','2025-11-14 18:17:51',NULL,NULL,NULL,'fca32f55-5c27-4179-bea4-7203f7ebbb00'),
(6008,1117,NULL,2725,1,'craft\\elements\\Entry',1,0,'2025-11-14 18:17:51','2025-11-14 18:17:51',NULL,NULL,NULL,'1c3aa91d-dc88-497b-8d49-4de2a62e2c78'),
(6009,6007,NULL,2726,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:17:51','2025-11-14 18:17:51',NULL,NULL,NULL,'c10ae24e-8346-4c17-8d3d-dba7dc6fc2df'),
(6010,1407,NULL,2727,1,'craft\\elements\\Entry',1,0,'2025-11-14 18:18:00','2025-11-14 18:18:00',NULL,NULL,NULL,'ba2b9047-9dc9-460d-a9d4-d46828623a92'),
(6013,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 18:18:51','2025-11-14 18:18:51',NULL,NULL,NULL,'db71ec4c-63b0-4c71-b648-9ffd95ed6c93'),
(6015,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:18:54','2025-11-14 18:18:54',NULL,NULL,NULL,'26f5b525-13d7-44d8-b35a-b507f5d13230'),
(6016,1473,NULL,2728,1,'craft\\elements\\Entry',1,0,'2025-11-14 18:18:54','2025-11-14 18:18:54',NULL,NULL,NULL,'ba04a320-a1d9-4b79-b9c1-ce7f806dc391'),
(6017,6015,NULL,2729,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:18:54','2025-11-14 18:18:54',NULL,NULL,NULL,'65dc7323-7225-49b6-9401-3351e6342c2d'),
(6020,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 18:19:39','2025-11-14 18:19:39',NULL,NULL,NULL,'b6980180-5db3-4e94-8bc6-edf859bb9609'),
(6021,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:19:43','2025-11-14 18:19:43',NULL,NULL,NULL,'af4ac66e-2557-4d42-954d-753bbf8695ca'),
(6022,1031,NULL,2730,1,'craft\\elements\\Entry',1,0,'2025-11-14 18:19:43','2025-11-14 18:19:43',NULL,NULL,NULL,'f272a255-7836-4f32-8290-2067a32e5e8f'),
(6023,6021,NULL,2731,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:19:43','2025-11-14 18:19:43',NULL,NULL,NULL,'fff86079-cadc-4ca3-9c79-c661c15026ba'),
(6026,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 18:20:49','2025-11-14 18:20:49',NULL,NULL,NULL,'11d9339b-1279-48d6-bd9c-77c78f92af7d'),
(6027,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:20:53','2025-11-14 18:20:53',NULL,NULL,NULL,'e3015fc8-30bd-4204-9c35-b3f0f5813566'),
(6028,1035,NULL,2732,1,'craft\\elements\\Entry',1,0,'2025-11-14 18:20:53','2025-11-14 18:20:53',NULL,NULL,NULL,'8912cbf8-ce04-4873-923f-fdfdc9d44f1b'),
(6029,6027,NULL,2733,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:20:53','2025-11-14 18:20:53',NULL,NULL,NULL,'f9701ffe-319e-497b-8044-cd445ecabe59'),
(6033,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 18:21:47','2025-11-14 18:21:47',NULL,NULL,NULL,'b92e6c96-1b3f-44e8-b351-4aed94be3783'),
(6034,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:21:50','2025-11-14 18:21:50',NULL,NULL,NULL,'3a31df48-175c-4077-b379-33f05c334519'),
(6035,1249,NULL,2734,1,'craft\\elements\\Entry',1,0,'2025-11-14 18:21:50','2025-11-14 18:21:50',NULL,NULL,NULL,'f619a21c-c88e-4ee6-ace5-47672c49e559'),
(6036,6034,NULL,2735,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:21:50','2025-11-14 18:21:50',NULL,NULL,NULL,'e66afb62-bf35-4a1c-b97a-e069833f58e7'),
(6039,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 18:22:44','2025-11-14 18:22:44',NULL,NULL,NULL,'f7a0eed3-1a67-4c84-a4bc-75e5c2c26dd8'),
(6040,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:22:46','2025-11-14 18:22:46',NULL,NULL,NULL,'84a6b30d-8ce1-4f3f-8aa4-0e3e2f23ce91'),
(6041,1349,NULL,2736,1,'craft\\elements\\Entry',1,0,'2025-11-14 18:22:46','2025-11-14 18:22:47',NULL,NULL,NULL,'2c624451-28a9-4486-a00a-73965e721da3'),
(6042,6040,NULL,2737,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:22:46','2025-11-14 18:22:47',NULL,NULL,NULL,'a207c5d5-bd27-4000-8727-31418612a77b'),
(6045,NULL,NULL,NULL,25,'craft\\elements\\Asset',1,0,'2025-11-14 18:23:27','2025-11-14 18:23:27',NULL,NULL,NULL,'e9055e6e-ba74-4b5d-bb2c-dc54779b9b7a'),
(6046,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:23:30','2025-11-14 18:23:30',NULL,NULL,NULL,'6e078039-ec75-43ee-9152-97c84de5b37c'),
(6047,1135,NULL,2738,1,'craft\\elements\\Entry',1,0,'2025-11-14 18:23:30','2025-11-14 18:23:30',NULL,NULL,NULL,'57cca2de-4228-4691-be39-6ff76b583bb9'),
(6048,6046,NULL,2739,21,'craft\\elements\\Entry',1,0,'2025-11-14 18:23:30','2025-11-14 18:23:30',NULL,NULL,NULL,'12705736-679c-4a96-8b94-e1d65796be55'),
(6064,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 14:59:26','2025-11-17 14:59:26',NULL,NULL,NULL,'8999f59c-2ae3-46fe-90b2-44a86457c775'),
(6065,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 14:59:26','2025-11-17 14:59:26',NULL,NULL,NULL,'c6d872a0-c2f4-4ddb-9c21-b46a47c6a5f9'),
(6068,1269,NULL,2740,1,'craft\\elements\\Entry',1,0,'2025-11-17 14:59:56','2025-11-17 14:59:56',NULL,NULL,NULL,'df7964d4-9ca7-4e25-884e-575d6b6a5d53'),
(6069,1765,NULL,2741,2,'craft\\elements\\Entry',1,0,'2025-11-17 14:59:56','2025-11-17 14:59:56',NULL,NULL,NULL,'81fa9a19-dab1-49f7-953b-07f7f85f2640'),
(6070,1766,NULL,2742,2,'craft\\elements\\Entry',1,0,'2025-11-17 14:59:56','2025-11-17 14:59:56',NULL,NULL,NULL,'7ac39263-3d78-410c-92e1-76dc36e96b79'),
(6074,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:01:33','2025-11-17 15:01:33',NULL,NULL,NULL,'a5a651e0-515c-4176-9419-570306899b1b'),
(6076,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:01:37','2025-11-17 15:01:37',NULL,NULL,NULL,'d1c8ad1d-8516-403a-868b-46beebe0b877'),
(6077,969,NULL,2743,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:01:37','2025-11-17 15:01:37',NULL,NULL,NULL,'4cbef99e-59fd-4562-b65a-a9929e28d1d2'),
(6078,6076,NULL,2744,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:01:37','2025-11-17 15:01:37',NULL,NULL,NULL,'d61a7dff-c3b3-4afb-a66f-7be8221b36ea'),
(6081,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:03:36','2025-11-17 15:03:36',NULL,NULL,NULL,'f1c0e5a1-303d-4ba2-9be8-19aa42b36ef0'),
(6082,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:03:43','2025-11-17 15:03:43',NULL,NULL,NULL,'569f18fd-5dcb-44e0-beef-dbe0849ca986'),
(6084,1277,NULL,2745,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:03:58','2025-11-17 15:03:58',NULL,NULL,NULL,'b99a1e4f-3951-4876-aa38-a9775a9060fb'),
(6085,1771,NULL,2746,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:03:58','2025-11-17 15:03:58',NULL,NULL,NULL,'0facf11a-256d-4018-80ad-099b607d2bbf'),
(6086,1772,NULL,2747,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:03:58','2025-11-17 15:03:58',NULL,NULL,NULL,'6d9cfc15-cc85-47b6-9b28-b83d2b97cb00'),
(6088,1191,NULL,2748,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:04:56','2025-11-17 15:04:56',NULL,NULL,NULL,'97a34607-998c-4c83-b5c2-727a2b8dd5e9'),
(6090,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:08:28','2025-11-24 17:09:05',NULL,NULL,NULL,'4303b382-abe1-4873-8613-49bb22c8fdb5'),
(6093,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:11:59','2025-11-17 15:11:59',NULL,NULL,NULL,'0e0cc0ce-9038-461b-aac7-7083af6d8da8'),
(6094,1419,NULL,2749,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:12:02','2025-11-17 15:12:02',NULL,NULL,NULL,'656f77d3-ac9c-422d-9199-ade66972aeb6'),
(6095,1890,NULL,2750,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:12:02','2025-11-17 15:12:02',NULL,NULL,NULL,'d885140b-af99-4098-935d-9a908f8e350d'),
(6096,1891,NULL,2751,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:12:02','2025-11-17 15:12:02',NULL,NULL,NULL,'78e918c4-3b50-45cd-b9b0-6d345bf0db8e'),
(6099,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:16:07','2025-11-17 15:16:07',NULL,NULL,NULL,'e3519613-5d70-43c9-8952-783c56544c1b'),
(6101,1413,NULL,2752,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:16:11','2025-11-17 15:16:11',NULL,NULL,NULL,'27f81d9c-a939-4518-9461-dcdad2820226'),
(6102,1885,NULL,2753,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:16:11','2025-11-17 15:16:11',NULL,NULL,NULL,'182c05a1-346b-4b20-9422-33ca8e523ae9'),
(6103,1886,NULL,2754,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:16:11','2025-11-17 15:16:11',NULL,NULL,NULL,'7e42e05c-6c29-4aab-a4ad-66309fce9125'),
(6105,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:17:03','2025-11-17 15:17:03',NULL,NULL,NULL,'27e61a74-b70b-4412-ba94-a8bf117fd0c7'),
(6107,1425,NULL,2755,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:17:07','2025-11-17 15:17:07',NULL,NULL,NULL,'898141ff-afb0-4ea2-b561-4879f0659af1'),
(6108,1896,NULL,2756,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:17:07','2025-11-17 15:17:07',NULL,NULL,NULL,'1fa41092-6627-4496-8b92-93d11c4b1e05'),
(6112,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:34:14','2025-11-17 15:34:14',NULL,NULL,NULL,'f153d493-7eca-46b3-bd0b-c3b84ce7e218'),
(6113,1359,NULL,2757,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:34:54','2025-11-17 15:34:54',NULL,NULL,NULL,'bdc45d02-1e60-4edb-8ea0-bab284a26856'),
(6114,1841,NULL,2758,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:34:54','2025-11-17 15:34:54',NULL,NULL,NULL,'57530e28-0b32-4b1b-98ca-92f8197ff08e'),
(6117,1365,NULL,2759,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:36:43','2025-11-17 15:36:43',NULL,NULL,NULL,'352da074-4059-4b31-9299-8d3d07705d8b'),
(6118,1845,NULL,2760,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:36:43','2025-11-17 15:36:44',NULL,NULL,NULL,'8932eda6-a02c-4d5b-a86c-eb938ae6fb97'),
(6119,1846,NULL,2761,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:36:43','2025-11-17 15:36:44',NULL,NULL,NULL,'7f31405c-63b8-489c-a39f-9054e6b9ca24'),
(6122,975,NULL,2762,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:38:31','2025-11-17 15:38:31',NULL,NULL,NULL,'17d15682-c897-4b90-9925-c2cba968e540'),
(6123,1519,NULL,2763,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:38:31','2025-11-17 15:38:31',NULL,NULL,NULL,'f08c0274-3ac0-48fd-a8a4-2e4f0b537db4'),
(6125,1067,NULL,2764,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:38:51','2025-11-17 15:38:51',NULL,NULL,NULL,'aa8694b4-fbf0-40fa-8e0f-0899c087e67c'),
(6128,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:39:49','2025-11-17 15:39:49',NULL,NULL,NULL,'8ee56a14-3611-4cc9-bc15-a5265e6d1fe7'),
(6130,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:41:05','2025-11-17 15:41:05',NULL,NULL,NULL,'d254defe-bc1e-43fa-aac9-43511d82c81b'),
(6131,1431,NULL,2765,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:41:10','2025-11-17 15:41:10',NULL,NULL,NULL,'d0ca8f84-42f5-4004-b918-0dc0dbc2eaf2'),
(6132,1900,NULL,2766,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:41:10','2025-11-17 15:41:10',NULL,NULL,NULL,'380e67e3-26b5-4d21-9abe-0e1b35df3bc7'),
(6133,1901,NULL,2767,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:41:10','2025-11-17 15:41:10',NULL,NULL,NULL,'207c9ee7-2897-4a73-b620-81a49aaf9503'),
(6137,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:41:55','2025-11-17 15:41:55',NULL,NULL,NULL,'f5554fa4-9df7-43ff-9265-070fefb1469a'),
(6138,1437,NULL,2768,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:41:58','2025-11-17 15:41:58',NULL,NULL,NULL,'eba485d2-086a-4792-8f02-b09fc886bfc6'),
(6139,1905,NULL,2769,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:41:58','2025-11-17 15:41:59',NULL,NULL,NULL,'6dd28d00-1afb-417c-b465-bef53dcae070'),
(6140,1906,NULL,2770,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:41:58','2025-11-17 15:41:59',NULL,NULL,NULL,'d3c88da9-226b-4e33-b399-0823cb45a81c'),
(6143,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:42:34','2025-11-17 15:42:34',NULL,NULL,NULL,'f49f8929-9672-4141-afea-6e9be3b7d3a7'),
(6145,1283,NULL,2771,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:43:23','2025-11-17 15:43:23',NULL,NULL,NULL,'e2cfd187-c230-4678-ba6e-4298fedd66c5'),
(6146,1776,NULL,2772,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:43:23','2025-11-17 15:43:23',NULL,NULL,NULL,'18b092b5-4dff-4afb-81d7-26dd98341d9c'),
(6147,1777,NULL,2773,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:43:23','2025-11-17 15:43:23',NULL,'2026-01-17 00:25:00',NULL,'35f6b140-8ecc-4b08-b90c-07cd69fe1089'),
(6149,2712,NULL,2774,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:55:31','2025-11-17 15:55:31',NULL,NULL,NULL,'13ed8509-1520-46d4-8477-7c82a3f7a748'),
(6151,1197,NULL,2775,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:56:16','2025-11-17 15:56:17',NULL,NULL,NULL,'761e307b-151b-4c33-b24d-18aa9334bf47'),
(6153,1201,NULL,2776,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:57:09','2025-11-17 15:57:09',NULL,NULL,NULL,'92456663-e5b8-4ffd-934f-bd594a2805a0'),
(6156,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:57:47','2025-11-17 15:57:47',NULL,NULL,NULL,'cb64e564-9fc5-4d8b-b699-8c09b019b522'),
(6158,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:57:50','2025-11-17 15:57:50',NULL,NULL,NULL,'cac83d9f-ed9d-44e8-b1db-abae50d9ca7f'),
(6159,1443,NULL,2777,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:57:49','2025-11-17 15:57:50',NULL,NULL,NULL,'7989e29d-bcbf-4f74-8a50-8c6ff5a38c1a'),
(6160,6158,NULL,2778,2,'craft\\elements\\Entry',1,0,'2025-11-17 15:57:50','2025-11-17 15:57:50',NULL,NULL,NULL,'e12b0cdf-f80c-4857-b70c-432e677df4ba'),
(6162,1209,NULL,2779,1,'craft\\elements\\Entry',1,0,'2025-11-17 15:58:21','2025-11-17 15:58:21',NULL,NULL,NULL,'529a76d4-cf21-46d8-9fe3-b09f32cb81e2'),
(6165,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 15:59:50','2025-11-17 15:59:50',NULL,NULL,NULL,'2599f1ec-e352-42d1-8849-31200a94db52'),
(6167,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:03:15','2025-11-17 16:03:15',NULL,NULL,NULL,'33ce8e1b-2230-4d91-9615-7cc1516488ad'),
(6168,1289,NULL,2780,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:03:20','2025-11-17 16:03:20',NULL,NULL,NULL,'23136b66-3dc6-4753-96b7-2779ee2a92c9'),
(6169,1782,NULL,2781,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:03:20','2025-11-17 16:03:20',NULL,NULL,NULL,'c38df901-8548-4a7e-8bc1-11d65d89080f'),
(6170,1783,NULL,2782,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:03:20','2025-11-17 16:03:20',NULL,NULL,NULL,'6dc88707-f114-4777-94be-88650a7eb352'),
(6173,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:03:58','2025-11-17 16:03:58',NULL,NULL,NULL,'f3c8b2d3-c6f0-4adc-8ab2-3f53c79fdd6b'),
(6175,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:04:11','2025-11-17 16:04:11',NULL,NULL,NULL,'c1333cab-399a-4cee-9df3-51d9f41fe3cd'),
(6176,1297,NULL,2783,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:04:15','2025-11-17 16:04:15',NULL,NULL,NULL,'b0eaf2cf-972b-4049-859f-72cb488dcd04'),
(6177,1788,NULL,2784,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:04:15','2025-11-17 16:04:15',NULL,NULL,NULL,'0d053fd9-eb44-4b4b-b989-010df3f00076'),
(6178,1789,NULL,2785,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:04:15','2025-11-17 16:04:15',NULL,NULL,NULL,'5b01ebed-4c99-4fad-800e-21fd716c7c52'),
(6180,981,NULL,2786,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:06:53','2025-11-17 16:06:53',NULL,NULL,NULL,'7bf9f6d3-4e79-4de2-949f-f700c03ffa81'),
(6183,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:07:56','2025-11-17 16:07:56',NULL,NULL,NULL,'549f800f-77c5-47c3-bbda-0cc5a09c50f8'),
(6185,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:08:16','2025-11-17 16:08:16',NULL,NULL,NULL,'1ce782f2-340f-4099-9c61-4a9155948341'),
(6186,1073,NULL,2787,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:08:26','2025-11-17 16:08:26',NULL,NULL,NULL,'97cf054f-304e-413f-9761-590e1065c3db'),
(6187,1601,NULL,2788,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:08:26','2025-11-17 16:08:26',NULL,NULL,NULL,'3e3abbcd-0d1e-41ba-a520-6337dedda506'),
(6188,1602,NULL,2789,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:08:26','2025-11-17 16:08:26',NULL,NULL,NULL,'78aa1cbb-7cd6-4781-bed3-bcd6341cd143'),
(6191,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:12:47','2025-11-17 16:12:47',NULL,NULL,NULL,'eb9869f5-0208-4e8b-9582-09c9b22874f5'),
(6193,1303,NULL,2790,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:13:13','2025-11-17 16:13:13',NULL,NULL,NULL,'99f93890-191f-4641-b8ae-a7e8ec4f84fc'),
(6194,1793,NULL,2791,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:13:13','2025-11-17 16:13:13',NULL,NULL,NULL,'b6f02617-519d-4266-a030-dfe3e94372de'),
(6195,1794,NULL,2792,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:13:13','2025-11-17 16:13:13',NULL,NULL,NULL,'676bb5dc-f0f7-44fd-a113-8a7a7524acf2'),
(6196,1215,NULL,2793,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:13:46','2025-11-17 16:13:46',NULL,NULL,NULL,'3d7431ce-0d43-4190-803a-6c9d6d4fc47e'),
(6199,1395,NULL,2794,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:15:23','2025-11-17 16:15:23',NULL,NULL,NULL,'c088315f-cc87-4fb8-9a14-7ff40799060e'),
(6200,1870,NULL,2795,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:15:23','2025-11-17 16:15:23',NULL,NULL,NULL,'c568ca58-21ea-4792-ba2e-797e8fb2bc5f'),
(6204,1371,NULL,2796,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:17:44','2025-11-17 16:17:44',NULL,NULL,NULL,'e63880bd-518f-44af-b10b-67d9d08ff759'),
(6205,1850,NULL,2797,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:17:44','2025-11-17 16:17:44',NULL,NULL,NULL,'d636c2dd-db2b-44b4-a5e0-acbf83f32ccb'),
(6206,1851,NULL,2798,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:17:44','2025-11-17 16:17:44',NULL,NULL,NULL,'9898ae6e-6cf2-475e-82c2-c93a19282687'),
(6208,1915,1794,NULL,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:18:46','2025-11-17 16:18:48',NULL,'2025-11-17 16:19:28',NULL,'c853e9df-405d-4e30-9681-dd8036b67331'),
(6210,1449,NULL,2799,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:19:28','2025-11-17 16:19:29',NULL,NULL,NULL,'932e82a1-0af5-40d8-b560-78ccce439a06'),
(6211,1916,NULL,2800,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:19:28','2025-11-17 16:19:29',NULL,NULL,NULL,'de9b3a38-e5a0-48fe-a4fd-4458e9fa67e7'),
(6214,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:20:31','2025-11-17 16:20:31',NULL,NULL,NULL,'3fc164b9-7884-4371-a294-865b01a88380'),
(6216,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:20:57','2025-11-17 16:20:57',NULL,NULL,NULL,'024fc15a-c068-4c78-a5a6-e2d2729e3755'),
(6217,1455,NULL,2801,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:21:02','2025-11-17 16:21:02',NULL,NULL,NULL,'926f5de2-34b5-42dd-9230-cf5a88e7737c'),
(6218,1920,NULL,2802,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:21:02','2025-11-17 16:21:02',NULL,NULL,NULL,'a34d379c-1612-4276-8ce0-0e7ba9601d74'),
(6219,1921,NULL,2803,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:21:02','2025-11-17 16:21:02',NULL,NULL,NULL,'f87c1ab9-b4d4-4cb4-99c8-0e08a0b617e8'),
(6221,989,NULL,2804,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:21:18','2025-11-17 16:21:18',NULL,NULL,NULL,'7ead657e-5d2a-46c9-8a77-dd0f8ba127ef'),
(6224,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:22:33','2025-11-17 16:22:33',NULL,NULL,NULL,'8d9f9e2b-f87e-4cf3-8f91-c6ddc8201d00'),
(6225,1309,NULL,2805,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:22:37','2025-11-17 16:22:37',NULL,NULL,NULL,'ed6aa41b-3fba-461c-b9ac-b5c5daf1a20c'),
(6226,1799,NULL,2806,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:22:37','2025-11-17 16:22:37',NULL,NULL,NULL,'c9ce1ec9-8800-4c9f-970f-d96981c3f67f'),
(6228,995,NULL,2807,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:23:26','2025-11-17 16:23:26',NULL,NULL,NULL,'d51998ac-846c-4f42-bdcf-16e06e86ac37'),
(6230,1219,NULL,2808,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:23:55','2025-11-17 16:23:56',NULL,NULL,NULL,'4adc718a-8429-4e7d-9e53-b4116e65b292'),
(6232,1079,NULL,2809,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:24:49','2025-11-17 16:24:49',NULL,NULL,NULL,'9d3beb43-cba4-49d8-80ff-029ae2935544'),
(6236,1377,NULL,2810,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:25:54','2025-11-17 16:25:54',NULL,NULL,NULL,'b50b168e-cd6d-4cd0-af77-2ac76f5de05f'),
(6237,1855,NULL,2811,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:25:54','2025-11-17 16:25:54',NULL,NULL,NULL,'00109e00-1236-4ac5-98da-e059abb9398a'),
(6238,1856,NULL,2812,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:25:54','2025-11-17 16:25:54',NULL,NULL,NULL,'f5ea969a-7890-4409-98eb-8670454d8eee'),
(6242,1401,NULL,2813,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:32:33','2025-11-17 16:32:33',NULL,NULL,NULL,'269a1ee5-7ea8-4ee9-9411-dd0879a0477e'),
(6243,1875,NULL,2814,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:32:33','2025-11-17 16:32:33',NULL,NULL,NULL,'49ce7c2d-9831-4a62-bba4-a1abadec22a5'),
(6244,1876,NULL,2815,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:32:33','2025-11-17 16:32:33',NULL,NULL,NULL,'23594a1a-b03b-4506-9464-e719aca31e2c'),
(6246,999,NULL,2816,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:33:14','2025-11-17 16:33:14',NULL,NULL,NULL,'c7147ddd-fdce-407c-985b-b4793db20860'),
(6248,1477,NULL,2817,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:33:40','2025-11-17 16:33:40',NULL,NULL,NULL,'024c0584-026a-47ce-becb-e2e4da8e84aa'),
(6251,1085,NULL,2818,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:35:08','2025-11-17 16:35:08',NULL,NULL,NULL,'31593cb2-9d88-49d2-8c5c-7b47bd9d6327'),
(6252,1611,NULL,2819,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:35:08','2025-11-17 16:35:08',NULL,NULL,NULL,'0ef6f13b-2781-44d0-abcc-b334e08f6367'),
(6255,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:36:30','2025-11-17 16:36:30',NULL,NULL,NULL,'97f0a090-98dd-4cdf-940a-f989df9c75e7'),
(6258,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:36:52','2025-11-17 16:36:52',NULL,NULL,NULL,'ba27fdde-6461-41c0-bf15-5e0621c742b3'),
(6259,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:36:55','2025-11-17 16:36:55',NULL,NULL,NULL,'782d890e-daa0-4d02-a7ae-c7ee65ea31a0'),
(6260,1461,NULL,2820,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:36:55','2025-11-17 16:36:55',NULL,NULL,NULL,'b33e5e78-d6d6-497e-8cae-63e2e2bae67d'),
(6261,6259,NULL,2821,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:36:55','2025-11-17 16:36:55',NULL,NULL,NULL,'514389fc-9074-4c96-92b7-560439eb80b8'),
(6262,1926,NULL,2822,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:36:55','2025-11-17 16:36:55',NULL,NULL,NULL,'d1546b60-38b8-4056-ab2c-a6f2a90efc70'),
(6265,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:38:01','2025-11-17 16:38:01',NULL,NULL,NULL,'eb34f6ee-8e03-4cfe-a9df-eb8fb78e13e0'),
(6266,1467,NULL,2823,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:38:04','2025-11-17 16:38:04',NULL,NULL,NULL,'11cc949f-ec6f-4e5d-a7bb-e1f9985e20a0'),
(6267,1930,NULL,2824,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:38:04','2025-11-17 16:38:04',NULL,NULL,NULL,'8e7fdf20-171d-429e-86dc-3203a5df07cc'),
(6270,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:38:21','2025-11-17 16:38:21',NULL,NULL,NULL,'7e852cb9-58f8-41b6-84cf-580d0b2084ca'),
(6271,1467,NULL,2825,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:38:25','2025-11-17 16:38:25',NULL,NULL,NULL,'66a90a20-41c8-4337-893e-a1d65860e5d3'),
(6272,1931,NULL,2826,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:38:25','2025-11-17 16:38:25',NULL,NULL,NULL,'62111fac-f3e2-47c6-a1c4-27204a35d04a'),
(6274,1225,NULL,2827,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:39:15','2025-11-17 16:39:15',NULL,NULL,NULL,'3107f9e7-ec02-41a8-9c42-b9dc2e8b5fd9'),
(6276,1005,NULL,2828,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:40:10','2025-11-17 16:40:10',NULL,NULL,NULL,'663f0ee8-17bf-4cd7-9694-77c78f4564a9'),
(6279,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:41:23','2025-11-17 16:41:23',NULL,NULL,NULL,'1238a46e-3bf4-4284-b06f-df47e9945b40'),
(6281,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:41:32','2025-11-17 16:41:32',NULL,NULL,NULL,'5ba74f42-9678-4f9a-83fd-4cf07a56bb42'),
(6282,1315,NULL,2829,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:41:36','2025-11-17 16:41:36',NULL,NULL,NULL,'9d248607-10e3-46e0-af7f-e265fee92d5b'),
(6283,1804,NULL,2830,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:41:36','2025-11-17 16:41:37',NULL,NULL,NULL,'03fe823d-920f-42b4-896f-fa1b5a04e23a'),
(6284,1805,NULL,2831,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:41:36','2025-11-17 16:41:37',NULL,NULL,NULL,'258c5d7c-6496-4b75-8332-dad1c3605dc9'),
(6287,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:42:25','2025-11-17 16:42:25',NULL,NULL,NULL,'839b2cf1-a87c-4570-88b1-3e9b5452fa7c'),
(6288,1383,NULL,2832,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:42:54','2025-11-17 16:42:54',NULL,NULL,NULL,'1d067451-6633-4207-a18f-b86a70f62c86'),
(6289,1860,NULL,2833,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:42:54','2025-11-17 16:42:54',NULL,NULL,NULL,'4e2be6fc-3460-482b-971c-a99e2370b464'),
(6292,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:43:43','2025-11-17 16:43:43',NULL,NULL,NULL,'396058db-754f-4fbb-9e4b-3f946f006ed0'),
(6294,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:44:01','2025-11-17 16:44:01',NULL,NULL,NULL,'9ed59da5-2bc5-464d-bfb3-c408f0c4479b'),
(6295,1323,NULL,2834,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:44:05','2025-11-17 16:44:05',NULL,NULL,NULL,'658b6e97-f02d-44e8-8616-ba784b93f497'),
(6296,1810,NULL,2835,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:44:05','2025-11-17 16:44:05',NULL,NULL,NULL,'30773958-5e90-440a-818e-659c846843e0'),
(6297,1811,NULL,2836,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:44:05','2025-11-17 16:44:05',NULL,NULL,NULL,'5e0c3109-a8ac-46b6-9245-d09b1e9d0f92'),
(6300,1011,NULL,2837,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:45:42','2025-11-17 16:45:42',NULL,NULL,NULL,'86794199-9bea-4be1-9f6c-ff34c40ee2f0'),
(6301,1549,NULL,2838,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:45:42','2025-11-17 16:45:42',NULL,NULL,NULL,'bb83aa88-0030-4f75-88d4-d3ddd3d609d4'),
(6303,1091,NULL,2839,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:46:07','2025-11-17 16:46:07',NULL,NULL,NULL,'e8a8d3f3-ca89-40e7-8374-b1e067ee5318'),
(6306,1097,NULL,2840,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:47:04','2025-11-17 16:47:04',NULL,NULL,NULL,'2faf6c29-bd6c-4791-9753-56341523430a'),
(6307,1621,NULL,2841,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:47:04','2025-11-17 16:47:04',NULL,NULL,NULL,'7b6c1945-7e18-4eed-b4d3-f7ad675db4a4'),
(6309,1231,NULL,2842,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:47:49','2025-11-17 16:47:49',NULL,NULL,NULL,'1a020b43-b3cc-41e0-a50b-261d0817be0d'),
(6312,1103,NULL,2843,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:48:44','2025-11-17 16:48:44',NULL,NULL,NULL,'7b905241-0edc-45b9-a583-fe5f4b97de8d'),
(6313,1626,NULL,2844,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:48:44','2025-11-17 16:48:44',NULL,NULL,NULL,'b21f8338-254a-4f2a-bb3e-da10e98ed9d3'),
(6315,1237,NULL,2845,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:49:12','2025-11-17 16:49:12',NULL,NULL,NULL,'2623c0c4-b939-44cf-b62c-73cb753ed416'),
(6317,1243,NULL,2846,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:49:29','2025-11-17 16:49:29',NULL,NULL,NULL,'08e0245b-8a3a-4f7d-956a-47286d8e0c0e'),
(6321,1389,NULL,2847,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:50:38','2025-11-17 16:50:38',NULL,NULL,NULL,'f7fe4748-a58f-4ac0-bf54-bcb083741794'),
(6322,1865,NULL,2848,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:50:38','2025-11-17 16:50:38',NULL,NULL,NULL,'095dbbdc-1004-4571-b8fc-2dea39eeec90'),
(6323,1866,NULL,2849,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:50:38','2025-11-17 16:50:38',NULL,NULL,NULL,'59363b2c-ecb0-41b9-8ebe-1e7ee558e1aa'),
(6325,1149,NULL,2850,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:51:01','2025-11-17 16:51:01',NULL,NULL,NULL,'e39c52ff-d6af-4f23-9aec-621f39dc73fe'),
(6327,1155,NULL,2851,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:51:11','2025-11-17 16:51:11',NULL,NULL,NULL,'0e4fa2b9-d827-4542-8a43-6161d10fd501'),
(6330,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:52:18','2025-11-17 16:52:18',NULL,NULL,NULL,'30474a77-7a4c-4b5e-8d1d-ff696d10c24a'),
(6331,1329,NULL,2852,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:52:25','2025-11-17 16:52:25',NULL,NULL,NULL,'d05341e0-4e2a-46df-9b9f-b51a1e09f9bd'),
(6332,1816,NULL,2853,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:52:25','2025-11-17 16:52:25',NULL,NULL,NULL,'cdb8e5b5-8bc4-4638-8e58-73b2bfe97ac2'),
(6334,1481,NULL,2854,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:52:46','2025-11-17 16:52:46',NULL,NULL,NULL,'27a7ac5f-b48b-41ef-b7a1-7b8b1e581054'),
(6336,1481,NULL,2855,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:53:01','2025-11-17 16:53:01',NULL,NULL,NULL,'22114ee3-0e48-4389-ae20-1c99d7cdc9ab'),
(6338,1017,NULL,2856,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:53:34','2025-11-17 16:53:34',NULL,NULL,NULL,'8d0e28b8-ab80-4418-826c-be14fa557978'),
(6341,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:54:57','2025-11-17 16:54:57',NULL,NULL,NULL,'6e4cd146-107f-429c-bb6b-2b32a4727df6'),
(6343,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:55:03','2025-11-17 16:55:03',NULL,NULL,NULL,'5d842592-9af5-4507-9e2c-dfeb1dbddc09'),
(6345,1017,NULL,2857,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:55:07','2025-11-17 16:55:07',NULL,NULL,NULL,'f5ead08d-cf03-4599-b73c-90983415be52'),
(6346,1554,NULL,2858,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:55:07','2025-11-17 16:55:07',NULL,NULL,NULL,'782c0baf-4a89-4d9b-836e-f326466875b8'),
(6347,1555,NULL,2859,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:55:07','2025-11-17 16:55:07',NULL,NULL,NULL,'49c68086-473d-4359-b958-da3e77dc0588'),
(6348,1023,NULL,2860,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:55:43','2025-11-17 16:55:43',NULL,NULL,NULL,'a4a16578-127d-41df-9186-0eb0c33fadaa'),
(6350,1337,NULL,2861,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:56:05','2025-11-17 16:56:05',NULL,NULL,NULL,'d78cb36f-ec03-4abb-b83f-d7a3046085fa'),
(6352,1407,NULL,2862,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:56:34','2025-11-17 16:56:34',NULL,NULL,NULL,'904ba421-be34-47c1-a5a4-3dff93f1e335'),
(6354,1343,NULL,2863,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:56:56','2025-11-17 16:56:56',NULL,NULL,NULL,'a17d97d3-a31d-4980-9a51-7f700d478d83'),
(6356,1109,NULL,2864,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:57:05','2025-11-17 16:57:06',NULL,NULL,NULL,'11f0046a-64cf-491a-ba24-10c3f77714eb'),
(6358,1117,NULL,2865,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:57:12','2025-11-17 16:57:12',NULL,NULL,NULL,'d9a4099e-e9b5-4cff-ae6e-b5793c4ea4e8'),
(6360,1473,NULL,2866,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:57:32','2025-11-17 16:57:32',NULL,NULL,NULL,'72f04040-3474-457c-bb52-6e8cae656c23'),
(6363,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-17 16:58:08','2025-11-17 16:58:08',NULL,NULL,NULL,'857defce-65da-4125-b199-312a92bdd592'),
(6365,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:58:10','2025-11-17 16:58:10',NULL,NULL,NULL,'f3fa806a-ca52-4673-b1e6-2598ee66ef92'),
(6366,1031,NULL,2867,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:58:10','2025-11-17 16:58:10',NULL,NULL,NULL,'5f73c843-ac8e-4f3a-8dbe-0c71c1e5b16a'),
(6367,6365,NULL,2868,2,'craft\\elements\\Entry',1,0,'2025-11-17 16:58:10','2025-11-17 16:58:10',NULL,NULL,NULL,'cbfb1f2f-7780-434d-8526-f3d3c6b60a1c'),
(6369,1035,NULL,2869,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:58:37','2025-11-17 16:58:37',NULL,NULL,NULL,'b4014312-501e-4928-9e54-a4ffba5f8876'),
(6370,1041,NULL,2870,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:59:02','2025-11-17 16:59:02',NULL,NULL,NULL,'38bd821b-d0c2-4109-a720-154c036fa963'),
(6372,1249,NULL,2871,1,'craft\\elements\\Entry',1,0,'2025-11-17 16:59:29','2025-11-17 16:59:29',NULL,NULL,NULL,'27b7ee13-ae98-4abf-8a8b-51b8bba9b034'),
(6375,1123,NULL,2872,1,'craft\\elements\\Entry',1,0,'2025-11-17 17:00:27','2025-11-17 17:00:27',NULL,NULL,NULL,'1af5f3cb-343c-4cb3-a28f-594f7524b90a'),
(6376,1643,NULL,2873,2,'craft\\elements\\Entry',1,0,'2025-11-17 17:00:27','2025-11-17 17:00:27',NULL,NULL,NULL,'2dd4228b-6110-40f2-a2f2-bba39f5363cc'),
(6378,1129,NULL,2874,1,'craft\\elements\\Entry',1,0,'2025-11-17 17:01:01','2025-11-17 17:01:01',NULL,NULL,NULL,'6d333592-eb44-400b-a94b-fe4e80dde6af'),
(6380,1349,NULL,2875,1,'craft\\elements\\Entry',1,0,'2025-11-17 17:01:07','2025-11-17 17:01:07',NULL,NULL,NULL,'9d176fca-5d8d-4f22-ac22-73fbd7a45a93'),
(6382,1135,NULL,2876,1,'craft\\elements\\Entry',1,0,'2025-11-17 17:01:13','2025-11-17 17:01:13',NULL,NULL,NULL,'f75dcbb9-0f76-4881-9325-7f95fff35cc0'),
(6383,1141,NULL,2877,1,'craft\\elements\\Entry',1,0,'2025-11-17 17:01:19','2025-11-17 17:01:19',NULL,NULL,NULL,'9854969d-cc5c-49d4-8568-cf355ac6c428'),
(6384,1143,NULL,2878,1,'craft\\elements\\Entry',1,0,'2025-11-17 17:01:32','2025-11-17 17:01:32',NULL,NULL,NULL,'83334511-0581-4989-97db-a4f556820d47'),
(6385,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-17 17:12:39','2025-11-17 17:12:39',NULL,NULL,NULL,'3055dd3e-7424-4bde-b6a4-bdedeee3390b'),
(6387,1059,NULL,2879,1,'craft\\elements\\Entry',1,0,'2025-11-17 17:32:09','2025-11-17 17:32:09',NULL,NULL,NULL,'1003b1c7-b225-4eed-9f5c-2eda4f0128bd'),
(6388,1255,NULL,2880,1,'craft\\elements\\Entry',1,0,'2025-11-17 18:02:15','2025-11-17 18:02:15',NULL,NULL,NULL,'7d474a7b-b582-4843-98d6-35864afe3258'),
(6389,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-17 22:20:28','2025-11-17 22:20:28',NULL,NULL,NULL,'281f18c2-3134-4529-a23f-50dba1a11912'),
(6391,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-11-18 16:47:26','2025-11-18 16:47:26',NULL,NULL,NULL,'442eb83b-8172-49dd-ab56-a3cb73123b14'),
(6392,2720,NULL,2881,1,'craft\\elements\\Entry',1,0,'2025-11-18 16:47:26','2025-11-18 16:47:26',NULL,NULL,NULL,'b5ae4dd2-deca-4b41-b242-e291b31b88dc'),
(6393,6391,NULL,2882,2,'craft\\elements\\Entry',1,0,'2025-11-18 16:47:26','2025-11-18 16:47:26',NULL,NULL,NULL,'bede80d9-280d-49dd-8be0-526fb4c69e47'),
(6394,1353,NULL,2883,1,'craft\\elements\\Entry',1,0,'2025-11-18 16:48:51','2025-11-18 16:48:51',NULL,NULL,NULL,'90d8ca2b-4270-4ccb-8167-9435bed7282b'),
(6396,1365,NULL,2884,1,'craft\\elements\\Entry',1,0,'2025-11-18 16:49:19','2025-11-18 16:49:19',NULL,NULL,NULL,'e0234d83-6571-4ea3-b561-7cb05394e7d4'),
(6398,2712,NULL,2885,1,'craft\\elements\\Entry',1,0,'2025-11-18 16:58:20','2025-11-18 16:58:20',NULL,NULL,NULL,'bb8894be-2d26-4324-8de5-ed34db841879'),
(6400,1371,NULL,2886,1,'craft\\elements\\Entry',1,0,'2025-11-18 16:59:09','2025-11-18 16:59:09',NULL,NULL,NULL,'fc9ad9b4-770e-431c-8c0c-9ea5bfb12bbd'),
(6402,1377,NULL,2887,1,'craft\\elements\\Entry',1,0,'2025-11-18 16:59:49','2025-11-18 16:59:49',NULL,NULL,NULL,'f9d63849-0854-4730-b716-09d1c91e70f7'),
(6404,1383,NULL,2888,1,'craft\\elements\\Entry',1,0,'2025-11-18 17:00:32','2025-11-18 17:00:32',NULL,NULL,NULL,'f9fee428-3126-449a-b74b-a808d709f255'),
(6406,1389,NULL,2889,1,'craft\\elements\\Entry',1,0,'2025-11-18 17:00:54','2025-11-18 17:00:54',NULL,NULL,NULL,'daedf8f6-6ed6-45ff-ad52-917b07c1e8db'),
(6408,1389,NULL,2890,1,'craft\\elements\\Entry',1,0,'2025-11-18 17:02:08','2025-11-18 17:02:08',NULL,NULL,NULL,'1c2b0a66-7b96-4fdc-9438-991ae6fe8573'),
(6410,1407,NULL,2891,1,'craft\\elements\\Entry',1,0,'2025-11-18 17:02:19','2025-11-18 17:02:20',NULL,NULL,NULL,'3b7e42e1-5155-4e5d-b037-ffa6dd8d2aac'),
(6412,1395,NULL,2892,1,'craft\\elements\\Entry',1,0,'2025-11-18 17:03:04','2025-11-18 17:03:04',NULL,NULL,NULL,'a82542f1-5efd-471e-b6bb-5c0de07abd02'),
(6414,1401,NULL,2893,1,'craft\\elements\\Entry',1,0,'2025-11-18 17:03:39','2025-11-18 17:03:39',NULL,NULL,NULL,'bed40539-0f48-4fc3-9da4-d4a112c4247f'),
(6416,1413,NULL,2894,1,'craft\\elements\\Entry',1,0,'2025-11-18 17:03:57','2025-11-18 17:03:57',NULL,NULL,NULL,'5a407d6e-6133-4807-827d-a6a6942bb547'),
(6418,1161,NULL,2895,1,'craft\\elements\\Entry',1,0,'2025-11-18 17:06:51','2025-11-18 17:06:51',NULL,NULL,NULL,'565a687b-604c-4686-8a45-0ed5c5eb1d13'),
(6422,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-11-19 20:57:56','2025-11-19 20:57:56',NULL,NULL,NULL,'37df1ee8-ef4f-478a-981a-98325b77b639'),
(6423,1461,NULL,2896,1,'craft\\elements\\Entry',1,0,'2025-11-19 20:58:44','2025-11-19 20:58:44',NULL,NULL,NULL,'63cd694b-d96b-476b-a033-bb1729173860'),
(6425,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-21 05:23:55','2025-11-21 05:23:55',NULL,NULL,NULL,'257d7743-b2b5-45b1-9c9e-46d5a4483256'),
(6426,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-23 13:10:55','2025-11-23 13:10:55',NULL,NULL,NULL,'9af0e06e-1876-49ae-835c-bac2c6f9c7bb'),
(6427,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-24 01:15:13','2025-11-24 01:15:13',NULL,NULL,NULL,'3107d546-1055-4087-96e4-63f98ff5891e'),
(6428,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-24 05:21:19','2025-11-24 05:21:19',NULL,NULL,NULL,'f18d6786-cb3c-468b-a912-8ed77fdec68a'),
(6434,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-11-24 14:42:12','2025-11-24 14:42:12',NULL,NULL,NULL,'b647e8f3-7e25-4f7f-ac29-45c80f454e1d'),
(6436,1303,NULL,2897,1,'craft\\elements\\Entry',1,0,'2025-11-24 14:42:16','2025-11-24 14:42:16',NULL,NULL,NULL,'cd8255f5-3008-46b2-a85e-7d5fb3f377da'),
(6437,1793,NULL,2898,2,'craft\\elements\\Entry',1,0,'2025-11-24 14:42:16','2025-11-24 14:42:16',NULL,NULL,NULL,'4207d202-473d-4889-88c8-307b83cc4fcb'),
(6438,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-24 16:33:31','2025-11-24 16:33:31',NULL,NULL,NULL,'6c90f733-9d66-4cee-9375-80dc4f176763'),
(6442,1890,1893,NULL,2,'craft\\elements\\Entry',1,0,'2025-11-24 17:08:45','2025-11-24 17:08:45',NULL,NULL,NULL,'9dceea0e-f9bc-495b-a944-b8babfb1b826'),
(6443,1419,NULL,2899,1,'craft\\elements\\Entry',1,0,'2025-11-24 17:09:22','2025-11-24 17:09:22',NULL,NULL,NULL,'0154183b-4f7f-4be0-8270-49ec54d4b5ab'),
(6445,1123,NULL,2900,1,'craft\\elements\\Entry',1,0,'2025-11-24 17:46:53','2025-11-24 17:46:53',NULL,NULL,NULL,'9f9f2aed-1446-4406-8b26-97b9920416d5'),
(6446,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-24 22:02:09','2025-11-24 22:02:09',NULL,NULL,NULL,'c7a8a89f-716e-44bd-b74e-210408a67a2d'),
(6447,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-24 23:08:11','2025-11-24 23:08:11',NULL,NULL,NULL,'82611df0-e23a-4034-b4f6-ac9421384b9d'),
(6451,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-11-27 02:10:34','2025-11-27 02:10:34',NULL,NULL,NULL,'7a5675a2-f402-48e1-8ed4-7704d521f54e'),
(6454,1177,NULL,2901,1,'craft\\elements\\Entry',1,0,'2025-12-01 19:35:58','2025-12-01 19:35:58',NULL,NULL,NULL,'52585f3f-ace8-4aeb-8980-f914c61779e6'),
(6455,1692,NULL,2902,2,'craft\\elements\\Entry',1,0,'2025-12-01 19:35:58','2025-12-01 19:35:58',NULL,NULL,NULL,'7885ea08-7b21-4f5a-99d7-4e72eb15e036'),
(6457,2880,NULL,2903,1,'craft\\elements\\Entry',1,0,'2025-12-01 19:36:11','2025-12-01 19:36:11',NULL,NULL,NULL,'af506716-170e-4743-b7ee-b7b69c9b3add'),
(6458,3303,NULL,2904,2,'craft\\elements\\Entry',1,0,'2025-12-01 19:36:11','2025-12-01 19:36:11',NULL,NULL,NULL,'172518d7-a716-426a-b20e-f7c52f3b3fa8'),
(6460,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-12-01 19:39:53','2025-12-01 19:39:53',NULL,NULL,NULL,'aec9f5aa-cbf2-4113-9c5a-2c98bdee77ca'),
(6462,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-12-01 19:40:26','2025-12-01 19:40:57',NULL,NULL,NULL,'73714742-4144-4101-bfdb-da1ddc4f68ee'),
(6463,951,NULL,2905,1,'craft\\elements\\Entry',1,0,'2025-12-01 19:40:26','2025-12-01 19:40:26',NULL,NULL,NULL,'817768c0-ccdf-414c-adbf-871d19dd2e21'),
(6464,6462,NULL,2906,2,'craft\\elements\\Entry',1,0,'2025-12-01 19:40:26','2025-12-01 19:40:26',NULL,NULL,NULL,'a8958a50-2a26-410f-9c1b-264803a650e8'),
(6467,951,NULL,2907,1,'craft\\elements\\Entry',1,0,'2025-12-01 19:40:57','2025-12-01 19:40:57',NULL,NULL,NULL,'0b3f9e53-fadb-4a6b-bd46-adb8f07b4505'),
(6468,6462,NULL,2908,2,'craft\\elements\\Entry',1,0,'2025-12-01 19:40:57','2025-12-01 19:40:57',NULL,NULL,NULL,'51413243-e200-4945-b891-6406a4e785a9'),
(6469,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-12-02 18:45:11','2025-12-02 18:45:11',NULL,NULL,NULL,