/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.14-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: akg_craft
-- ------------------------------------------------------
-- Server version	10.11.14-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `addresses`
--

DROP TABLE IF EXISTS `addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `addresses` (
  `id` int(11) NOT NULL,
  `primaryOwnerId` int(11) DEFAULT NULL,
  `fieldId` int(11) DEFAULT NULL,
  `countryCode` varchar(255) NOT NULL,
  `administrativeArea` varchar(255) DEFAULT NULL,
  `locality` varchar(255) DEFAULT NULL,
  `dependentLocality` varchar(255) DEFAULT NULL,
  `postalCode` varchar(255) DEFAULT NULL,
  `sortingCode` varchar(255) DEFAULT NULL,
  `addressLine1` varchar(255) DEFAULT NULL,
  `addressLine2` varchar(255) DEFAULT NULL,
  `addressLine3` varchar(255) DEFAULT NULL,
  `organization` varchar(255) DEFAULT NULL,
  `organizationTaxId` varchar(255) DEFAULT NULL,
  `fullName` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `latitude` varchar(255) DEFAULT NULL,
  `longitude` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_iqvloikvkpdwacapmodeegqbfwwsttzfiaqx` (`primaryOwnerId`),
  CONSTRAINT `fk_dwkislensiccokeopruhqgnyoosvtqpqvnxz` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_iqvloikvkpdwacapmodeegqbfwwsttzfiaqx` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `pluginId` int(11) DEFAULT NULL,
  `heading` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `dateRead` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_uukijiyyfbdpzlzeqyvxlovumrsxhmnoygak` (`userId`,`unread`,`dateRead`,`dateCreated`),
  KEY `idx_mgewutpavvnrbjchxdqzhgengtvihkgkczjl` (`dateRead`),
  KEY `fk_wruwonaklxcgxnetazpxvohcqbbhhjbqrkoe` (`pluginId`),
  CONSTRAINT `fk_wospxzotjkupqslxknxobuiyjbevdfwiqlck` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wruwonaklxcgxnetazpxvohcqbbhhjbqrkoe` FOREIGN KEY (`pluginId`) REFERENCES `plugins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexdata`
--

DROP TABLE IF EXISTS `assetindexdata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assetindexdata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sessionId` int(11) NOT NULL,
  `volumeId` int(11) NOT NULL,
  `uri` text DEFAULT NULL,
  `size` bigint(20) unsigned DEFAULT NULL,
  `timestamp` datetime DEFAULT NULL,
  `isDir` tinyint(1) DEFAULT 0,
  `recordId` int(11) DEFAULT NULL,
  `isSkipped` tinyint(1) DEFAULT 0,
  `inProgress` tinyint(1) DEFAULT 0,
  `completed` tinyint(1) DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_vvjtokdopumqivgaxhocgaebidhfqnctkahc` (`sessionId`,`volumeId`),
  KEY `idx_gzbdxenxksafpxnsqlillxlimxjghnkkkmeu` (`volumeId`),
  CONSTRAINT `fk_sbdvwtpkiwufghhdpxbxpywoanluihrohqtp` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_uttkbdmmxkkkmehzpvgxbbggkbofttzmldfc` FOREIGN KEY (`sessionId`) REFERENCES `assetindexingsessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexingsessions`
--

DROP TABLE IF EXISTS `assetindexingsessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assetindexingsessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `indexedVolumes` text DEFAULT NULL,
  `totalEntries` int(11) DEFAULT NULL,
  `processedEntries` int(11) NOT NULL DEFAULT 0,
  `cacheRemoteImages` tinyint(1) DEFAULT NULL,
  `listEmptyFolders` tinyint(1) DEFAULT 0,
  `isCli` tinyint(1) DEFAULT 0,
  `actionRequired` tinyint(1) DEFAULT 0,
  `processIfRootEmpty` tinyint(1) DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `id` int(11) NOT NULL,
  `volumeId` int(11) DEFAULT NULL,
  `folderId` int(11) NOT NULL,
  `uploaderId` int(11) DEFAULT NULL,
  `filename` varchar(255) NOT NULL,
  `mimeType` varchar(255) DEFAULT NULL,
  `kind` varchar(50) NOT NULL DEFAULT 'unknown',
  `alt` text DEFAULT NULL,
  `width` int(10) unsigned DEFAULT NULL,
  `height` int(10) unsigned DEFAULT NULL,
  `size` bigint(20) unsigned DEFAULT NULL,
  `focalPoint` varchar(13) DEFAULT NULL,
  `deletedWithVolume` tinyint(1) DEFAULT NULL,
  `keptFile` tinyint(1) DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_qvgtvxwwlxpafqemsbgcnfuuabsghawguivf` (`filename`,`folderId`),
  KEY `idx_abvtfcfcqgzppjrgofuzjkgdprqvrgecamec` (`folderId`),
  KEY `idx_bivetzxptnogsjjvthfyfqtxmejmcknttcde` (`volumeId`),
  KEY `fk_tekocsxyxnieyklrguywvjqnhanpwcufwobg` (`uploaderId`),
  CONSTRAINT `fk_lvihrokbpxzrgrmhkbhnnzcdbpixlpsyxbrj` FOREIGN KEY (`folderId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_modowmfkudoeglagnxbsrdobeahipbmutmmx` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tekocsxyxnieyklrguywvjqnhanpwcufwobg` FOREIGN KEY (`uploaderId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_tsjsorwzadpbpqdekpcuubqwgsphuvpxaufc` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assets_sites`
--

DROP TABLE IF EXISTS `assets_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_sites` (
  `assetId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `alt` text DEFAULT NULL,
  PRIMARY KEY (`assetId`,`siteId`),
  KEY `fk_aknalnuelkvjzfggeovumibomcxcvfyzuvba` (`siteId`),
  CONSTRAINT `fk_aknalnuelkvjzfggeovumibomcxcvfyzuvba` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_glkidgkgevdmgjkbjibfhlzlaocozqmqmgqu` FOREIGN KEY (`assetId`) REFERENCES `assets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `auth_oauth_tokens`
--

DROP TABLE IF EXISTS `auth_oauth_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `auth_oauth_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ownerHandle` varchar(255) NOT NULL,
  `providerType` varchar(255) NOT NULL,
  `tokenType` varchar(255) NOT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `accessToken` text DEFAULT NULL,
  `secret` text DEFAULT NULL,
  `expires` varchar(255) DEFAULT NULL,
  `refreshToken` text DEFAULT NULL,
  `resourceOwnerId` varchar(255) DEFAULT NULL,
  `values` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `authenticator`
--

DROP TABLE IF EXISTS `authenticator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `authenticator` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `auth2faSecret` varchar(255) DEFAULT NULL,
  `oldTimestamp` int(10) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_lqkqvklsscofkuzcmuhzmqyirarugttwxhkz` (`userId`),
  CONSTRAINT `fk_lqkqvklsscofkuzcmuhzmqyirarugttwxhkz` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bulkopevents`
--

DROP TABLE IF EXISTS `bulkopevents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bulkopevents` (
  `key` char(10) NOT NULL,
  `senderClass` varchar(255) NOT NULL,
  `eventName` varchar(255) NOT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`key`,`senderClass`,`eventName`),
  KEY `idx_ysvuwziiymmrgtwdrkpsowlzqogybnlfzaze` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `parentId` int(11) DEFAULT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_jdtdhiipxibhqhdrjnrsorabilokzbcngtpy` (`groupId`),
  KEY `fk_gtqjpmdvxqkiktckauevmrakbedagbcawuxa` (`parentId`),
  CONSTRAINT `fk_ekltgmycyzqgniebmeziaiuvonfituulthmy` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_gtqjpmdvxqkiktckauevmrakbedagbcawuxa` FOREIGN KEY (`parentId`) REFERENCES `categories` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_vrqtvmuntnirtheyxwwnaivpmzsdrijkpkjk` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups`
--

DROP TABLE IF EXISTS `categorygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorygroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `defaultPlacement` enum('beginning','end') NOT NULL DEFAULT 'end',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uunanhzxghwptsxiizkbzlnjuwaxvmpbntgx` (`name`),
  KEY `idx_jwjmbrdxzdvswgrzsxdsstawqtrgjopuqzgo` (`handle`),
  KEY `idx_uvwkerycvzjcvbjxqobjxhwqxoehosngowzm` (`structureId`),
  KEY `idx_iucivdbueuhqivcstqnxhmmedcbhluyifnpy` (`fieldLayoutId`),
  KEY `idx_piswzyqdhcmfztsrkgdtwovlvnvphbovffqn` (`dateDeleted`),
  CONSTRAINT `fk_aerphudzxhtbpmredahlvapzjxoudhxkwhon` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_yzkizfrsuoibmzojzqbbaosarsptufacqxgz` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups_sites`
--

DROP TABLE IF EXISTS `categorygroups_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorygroups_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT 1,
  `uriFormat` text DEFAULT NULL,
  `template` varchar(500) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_idnjmmbumtlyimwpghcnmcqvdndfqhlvokyx` (`groupId`,`siteId`),
  KEY `idx_cjkndovfayjuexqykawqmchuozjoagueujba` (`siteId`),
  CONSTRAINT `fk_ggkknmnhztypspuotgseladohqtwzrmyixrx` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_lcmrwwreuymkayhpoussqwkblzkvhsjdbksu` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedattributes`
--

DROP TABLE IF EXISTS `changedattributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `changedattributes` (
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `attribute` varchar(255) NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int(11) DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`attribute`),
  KEY `idx_khvqpffjismcfsqpdqlgcruhvygcepogvadg` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_rwywfgyogaofdouikozlmtushjaueatcoiek` (`siteId`),
  KEY `fk_xyhmlobytgekueeosolyvopkjtkrqkkfkpnm` (`userId`),
  CONSTRAINT `fk_nrkxricfghplaoujxnuyozvnhdetruyvpxhv` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_rwywfgyogaofdouikozlmtushjaueatcoiek` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_xyhmlobytgekueeosolyvopkjtkrqkkfkpnm` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedfields`
--

DROP TABLE IF EXISTS `changedfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `changedfields` (
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `layoutElementUid` char(36) NOT NULL DEFAULT '0',
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int(11) DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`fieldId`,`layoutElementUid`),
  KEY `idx_yixjevqontcntogoqmbjpqlnxgctmkhhrxlz` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_hxkitwxxoprypxilpoicfxohxearcpcokspe` (`siteId`),
  KEY `fk_lkktxosmjbksmxbgkfwwjudteinxrsdpcqnp` (`fieldId`),
  KEY `fk_tzrmrhhebfbnhvaeqtwqpyqirmjezdfehvot` (`userId`),
  CONSTRAINT `fk_hxkitwxxoprypxilpoicfxohxearcpcokspe` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_lkktxosmjbksmxbgkfwwjudteinxrsdpcqnp` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_tzrmrhhebfbnhvaeqtwqpyqirmjezdfehvot` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_vrypsfgzpzeijownmupepjjfqymlxzcjvvjy` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `contentblocks`
--

DROP TABLE IF EXISTS `contentblocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contentblocks` (
  `id` int(11) NOT NULL,
  `primaryOwnerId` int(11) DEFAULT NULL,
  `fieldId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_fbatyxybqahalcbfhhjfwmwiucjohusckaea` (`primaryOwnerId`),
  KEY `idx_cpwzlbyfwmbeyuergpumcknelghukdyfzysk` (`fieldId`),
  CONSTRAINT `fk_enihsclmaiypgqhyaifvzxuxwanxakwdvzcp` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_rawdacbutrhywmbxlthvtezzhyoirgakpxxz` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vewpqxqvrdsjnrnnonhuvfuylfcvbuzblrwb` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `craftidtokens`
--

DROP TABLE IF EXISTS `craftidtokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `craftidtokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `accessToken` text NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_aprtjzfhhgnrfsbfjhiyisovjfhnbxdbhaiq` (`userId`),
  CONSTRAINT `fk_aprtjzfhhgnrfsbfjhiyisovjfhnbxdbhaiq` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `deprecationerrors`
--

DROP TABLE IF EXISTS `deprecationerrors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `deprecationerrors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `fingerprint` varchar(255) NOT NULL,
  `lastOccurrence` datetime NOT NULL,
  `file` varchar(255) NOT NULL,
  `line` smallint(5) unsigned DEFAULT NULL,
  `message` text DEFAULT NULL,
  `traces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`traces`)),
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ggqeiyvtqgzlkparplrdgikcqzkzsmglclkk` (`key`,`fingerprint`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `drafts`
--

DROP TABLE IF EXISTS `drafts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drafts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `canonicalId` int(11) DEFAULT NULL,
  `creatorId` int(11) DEFAULT NULL,
  `provisional` tinyint(1) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL,
  `notes` text DEFAULT NULL,
  `trackChanges` tinyint(1) NOT NULL DEFAULT 0,
  `dateLastMerged` datetime DEFAULT NULL,
  `saved` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_pbjjnhpnrprdqbvwdqhmmjirshfkswdhbgnq` (`creatorId`,`provisional`),
  KEY `idx_igyysutmncnnbstaaxnbnygayzheetcgeovq` (`saved`),
  KEY `fk_pnjziqnbyykzrupscelklaupbcksriwnrrme` (`canonicalId`),
  CONSTRAINT `fk_ipktlizajpmowigitytbcucvtuqwzstrwdzy` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_pnjziqnbyykzrupscelklaupbcksriwnrrme` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1289 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elementactivity`
--

DROP TABLE IF EXISTS `elementactivity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elementactivity` (
  `elementId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `draftId` int(11) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`elementId`,`userId`,`type`),
  KEY `idx_lfntenacxydtfclryddiugdzcrshilkochqv` (`elementId`,`timestamp`,`userId`),
  KEY `fk_gesincdiwdmutikkuyhqzlrkadkbheroqanw` (`userId`),
  KEY `fk_uxobxrfpuiweyzqxztckzqcflucstlcywyqs` (`siteId`),
  KEY `fk_mgtnxakxxzfjcoldzotieovkfwsbaabewkjg` (`draftId`),
  CONSTRAINT `fk_gesincdiwdmutikkuyhqzlrkadkbheroqanw` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_mgtnxakxxzfjcoldzotieovkfwsbaabewkjg` FOREIGN KEY (`draftId`) REFERENCES `drafts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ncpfsuiybumtansfrugtqqwvywlllycrfhwm` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_uxobxrfpuiweyzqxztckzqcflucstlcywyqs` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements`
--

DROP TABLE IF EXISTS `elements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `canonicalId` int(11) DEFAULT NULL,
  `draftId` int(11) DEFAULT NULL,
  `revisionId` int(11) DEFAULT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `archived` tinyint(1) NOT NULL DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateLastMerged` datetime DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `deletedWithOwner` tinyint(1) DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qiibialuucjqeqxthdndfhqodrhcnlzfryro` (`dateDeleted`),
  KEY `idx_ycbmfgoisupnxhxbincuvcqpnilqkyuiqhag` (`fieldLayoutId`),
  KEY `idx_xagvruibfecvrqupeapkjclkpyozwbmooveu` (`type`),
  KEY `idx_gacuplsrjqjabddulzactzayoarjxuwvhnbb` (`enabled`),
  KEY `idx_tlnsdquubyavsbbrsfdevfzbltifdsoathqr` (`canonicalId`),
  KEY `idx_ufwcipjfzmbqkyzwpuxvljjnqtmluscldgsx` (`archived`,`dateCreated`),
  KEY `idx_hfbbfrbzhfugnxytcpftxoyddpuwguflobnx` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`),
  KEY `idx_tzjbhylhnfaupogwdllppqrniipqnkyxwpwd` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`,`enabled`),
  KEY `fk_nurtvhxbusantavjrasarobzxbtelrsznnqc` (`draftId`),
  KEY `fk_bzohdwhanrmeucuqmzngbmuqlvlmuqirwbwr` (`revisionId`),
  CONSTRAINT `fk_bzohdwhanrmeucuqmzngbmuqlvlmuqirwbwr` FOREIGN KEY (`revisionId`) REFERENCES `revisions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_hdleolnjwfddskkpgcpedovmcaifkpzvupof` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_iqjvcupoxaaihgbplrxhefoucnbqfqbstukh` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_nurtvhxbusantavjrasarobzxbtelrsznnqc` FOREIGN KEY (`draftId`) REFERENCES `drafts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4761 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_bulkops`
--

DROP TABLE IF EXISTS `elements_bulkops`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_bulkops` (
  `elementId` int(11) NOT NULL,
  `key` char(10) NOT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`elementId`,`key`),
  KEY `idx_vfrkqqvsamrcteuklvsypdwjixvezigivpdo` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_owners`
--

DROP TABLE IF EXISTS `elements_owners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_owners` (
  `elementId` int(11) NOT NULL,
  `ownerId` int(11) NOT NULL,
  `sortOrder` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`elementId`,`ownerId`),
  KEY `fk_dhwumnkkblggmgardwijeathnljiwubhkuzg` (`ownerId`),
  CONSTRAINT `fk_aczdnoaszuzejaadsmwxtpgjycqznkzzwago` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_dhwumnkkblggmgardwijeathnljiwubhkuzg` FOREIGN KEY (`ownerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_sites`
--

DROP TABLE IF EXISTS `elements_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `uri` varchar(255) DEFAULT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`content`)),
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_vjnigzezqicqxwafasnrqoyquqdduvdvdftq` (`elementId`,`siteId`),
  KEY `idx_ixpowpedfpxftkmpsitspmtnyxoefwchhery` (`siteId`),
  KEY `idx_faibkbrfkfvxazgejlgjrfrxnjqeblawadvk` (`title`,`siteId`),
  KEY `idx_lnznnfmrnlfaqunuspaemenziszgmlygpbnz` (`slug`,`siteId`),
  KEY `idx_cdkhcjlloeortlaiftjiniuunlenmlbluawu` (`enabled`),
  KEY `idx_icfhuppkjtndtkrunqobxqfcgpiebpzzeczy` (`uri`,`siteId`),
  CONSTRAINT `fk_jpjaekscyqockvjkuqbivtndfzwdoyxwdzxw` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ocrawvafzozycdcpcvcyeuoznawsacoananj` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4761 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entries`
--

DROP TABLE IF EXISTS `entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `entries` (
  `id` int(11) NOT NULL,
  `sectionId` int(11) DEFAULT NULL,
  `parentId` int(11) DEFAULT NULL,
  `primaryOwnerId` int(11) DEFAULT NULL,
  `fieldId` int(11) DEFAULT NULL,
  `typeId` int(11) NOT NULL,
  `postDate` datetime DEFAULT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `status` enum('live','pending','expired') NOT NULL DEFAULT 'live',
  `deletedWithEntryType` tinyint(1) DEFAULT NULL,
  `deletedWithSection` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_vxuhugvxhgwekpmglgfmpvpdaswydtlpmnsd` (`postDate`),
  KEY `idx_dqmpytanywvwebfvxiuzoelkiuzmipglvlci` (`expiryDate`),
  KEY `idx_snnelwquugcgsgcsyxztzzdagzzgbzctkkxn` (`status`),
  KEY `idx_oyusrrffxwjasnvimazilomnuayamrqrkkrs` (`sectionId`),
  KEY `idx_pcjlgiaggbycgdkknxbchlptmhrrklpwphsl` (`typeId`),
  KEY `idx_pqzzoyioccqmeqqxwdhzjuhucuqbgflktocu` (`primaryOwnerId`),
  KEY `idx_izzumizhihbjambmxxmqxetcmzycideztdow` (`fieldId`),
  KEY `fk_cbcpwmlhnhvcbapyfnqjxpyvjqlrypwyoegd` (`parentId`),
  CONSTRAINT `fk_btaaxmdovcglmftbupzffceaoihqwxqquprk` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_cbcpwmlhnhvcbapyfnqjxpyvjqlrypwyoegd` FOREIGN KEY (`parentId`) REFERENCES `entries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_qdyopajwvztatqgfirqpattfdtpbmmgivadv` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tzonnsswtfphhxpunbliniqybfolxriqvsjv` FOREIGN KEY (`typeId`) REFERENCES `entrytypes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wdykeepvoppudrfwgjrfizqwqutksqefapak` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zyczynbybirhrsunpruvzossdkcuajozzxdo` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entries_authors`
--

DROP TABLE IF EXISTS `entries_authors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `entries_authors` (
  `entryId` int(11) NOT NULL,
  `authorId` int(11) NOT NULL,
  `sortOrder` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`entryId`,`authorId`),
  KEY `idx_kkkhdomcumrntegqlbnixgdvjxgomwxstvuy` (`authorId`),
  KEY `idx_yfevyzfnrsztelswamdicptklnkglnixdqxp` (`entryId`,`sortOrder`),
  CONSTRAINT `fk_dmrvjudwrfejjxwchksnnnnilhppsfaqlymf` FOREIGN KEY (`entryId`) REFERENCES `entries` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vefmiipxkunjvixyiptlbmvvuczdjslwmyjj` FOREIGN KEY (`authorId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entrytypes`
--

DROP TABLE IF EXISTS `entrytypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `entrytypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `color` varchar(255) DEFAULT NULL,
  `hasTitleField` tinyint(1) NOT NULL DEFAULT 1,
  `titleTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text DEFAULT NULL,
  `titleFormat` varchar(255) DEFAULT NULL,
  `showSlugField` tinyint(1) DEFAULT 1,
  `slugTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `slugTranslationKeyFormat` text DEFAULT NULL,
  `showStatusField` tinyint(1) DEFAULT 1,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_vkehvdetjwprdqsulpbglbksfkusjqjgucci` (`fieldLayoutId`),
  KEY `idx_jjwomxpvnhulsribozssqisaqqlbsqjvmsyi` (`dateDeleted`),
  CONSTRAINT `fk_yafrsjzjdqztnbrxmdfobdpjjhyhaegzzlxc` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `feedme_feeds`
--

DROP TABLE IF EXISTS `feedme_feeds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `feedme_feeds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `feedUrl` text NOT NULL,
  `feedType` varchar(255) DEFAULT NULL,
  `primaryElement` varchar(255) DEFAULT NULL,
  `elementType` varchar(255) NOT NULL,
  `elementGroup` text DEFAULT NULL,
  `siteId` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `singleton` tinyint(1) NOT NULL DEFAULT 0,
  `duplicateHandle` text DEFAULT NULL,
  `updateSearchIndexes` tinyint(1) NOT NULL DEFAULT 1,
  `paginationNode` text DEFAULT NULL,
  `fieldMapping` mediumtext DEFAULT NULL,
  `fieldUnique` text DEFAULT NULL,
  `passkey` varchar(255) NOT NULL,
  `backup` tinyint(1) NOT NULL DEFAULT 0,
  `setEmptyValues` tinyint(1) NOT NULL DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `feedme_logs`
--

DROP TABLE IF EXISTS `feedme_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `feedme_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `level` int(11) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `log_time` double DEFAULT NULL,
  `prefix` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_log_level` (`level`),
  KEY `idx_log_category` (`category`)
) ENGINE=InnoDB AUTO_INCREMENT=10189 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayouts`
--

DROP TABLE IF EXISTS `fieldlayouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `fieldlayouts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `config` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`config`)),
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qwwlwnqfvylkuewgaagypsrycjehryatpzow` (`dateDeleted`),
  KEY `idx_wchkxdaphzpbzeecvukzveawczlewmlmfyar` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fields`
--

DROP TABLE IF EXISTS `fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `handle` varchar(64) NOT NULL,
  `context` varchar(255) NOT NULL DEFAULT 'global',
  `columnSuffix` char(8) DEFAULT NULL,
  `instructions` text DEFAULT NULL,
  `searchable` tinyint(1) NOT NULL DEFAULT 1,
  `translationMethod` varchar(255) NOT NULL DEFAULT 'none',
  `translationKeyFormat` text DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `settings` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_lsqfyxfqwsraezylphubazinzxcumkbmxziw` (`handle`,`context`),
  KEY `idx_dmvvcaxllibxdtchgbgdehiojdcqsayhgqpd` (`context`),
  KEY `idx_wysugkgwsibkwauvrgcreyaivgyqbwyyvwav` (`dateDeleted`)
) ENGINE=InnoDB AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_emailtemplates`
--

DROP TABLE IF EXISTS `formie_emailtemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_emailtemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `template` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_fieldlayout_pages`
--

DROP TABLE IF EXISTS `formie_fieldlayout_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_fieldlayout_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `label` text NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `settings` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_wsellseropllfqtjvnmmlbieaotzifgaoqox` (`layoutId`),
  CONSTRAINT `fk_cgufcpckavqgbguoganyvvagswfccogwvstd` FOREIGN KEY (`layoutId`) REFERENCES `formie_fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_fieldlayout_rows`
--

DROP TABLE IF EXISTS `formie_fieldlayout_rows`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_fieldlayout_rows` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `pageId` int(11) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_yuhycebplsysnvprbobsairuoyjungdvbqkm` (`layoutId`),
  KEY `idx_zmrariclaivgmsbxewzqoawnbqaapexcsyza` (`pageId`),
  CONSTRAINT `fk_erbaorsqdlbvwbxpocexnfcqzfuahxkbndsf` FOREIGN KEY (`layoutId`) REFERENCES `formie_fieldlayouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vjombnskdidvaxcbyuzszobrfxmbalnerazb` FOREIGN KEY (`pageId`) REFERENCES `formie_fieldlayout_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_fieldlayouts`
--

DROP TABLE IF EXISTS `formie_fieldlayouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_fieldlayouts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_fields`
--

DROP TABLE IF EXISTS `formie_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `pageId` int(11) NOT NULL,
  `rowId` int(11) NOT NULL,
  `syncId` int(11) DEFAULT NULL,
  `label` text NOT NULL,
  `handle` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `settings` mediumtext DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_tkpfjpvluewfmtufxqestjgpkiomuegvjnmb` (`layoutId`),
  KEY `idx_vgtiahcwedmvzngwifqklgdigfurdcfhyzar` (`pageId`),
  KEY `idx_fyqoxcnmaojfduuzikkmcsmgnlvzluyueneu` (`rowId`),
  KEY `idx_difxqkzzntipncmbjbqlutovxnodjcpvqade` (`syncId`),
  KEY `idx_vfldraqemfzvopodoulmlrmpudvurlqwgwvq` (`handle`),
  CONSTRAINT `fk_brpmayrtdxwysvhsjyowqeqtahmlbwfbtqsf` FOREIGN KEY (`syncId`) REFERENCES `formie_fields` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_flrlfrzkprvpccfhbtjwrrebtaxrkthvywta` FOREIGN KEY (`pageId`) REFERENCES `formie_fieldlayout_pages` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vhjkvimadlsqmaablakviavmjyozlzyukgmt` FOREIGN KEY (`rowId`) REFERENCES `formie_fieldlayout_rows` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zcenyegufgxlsaktpzfvtpfcxzziagdtsnnz` FOREIGN KEY (`layoutId`) REFERENCES `formie_fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_forms`
--

DROP TABLE IF EXISTS `formie_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` varchar(64) NOT NULL,
  `settings` mediumtext DEFAULT NULL,
  `layoutId` int(11) DEFAULT NULL,
  `templateId` int(11) DEFAULT NULL,
  `submitActionEntryId` int(11) DEFAULT NULL,
  `submitActionEntrySiteId` int(11) DEFAULT NULL,
  `defaultStatusId` int(11) DEFAULT NULL,
  `dataRetention` enum('forever','minutes','hours','days','weeks','months','years') NOT NULL DEFAULT 'forever',
  `dataRetentionValue` int(11) DEFAULT NULL,
  `userDeletedAction` enum('retain','delete') NOT NULL DEFAULT 'retain',
  `fileUploadsAction` enum('retain','delete') NOT NULL DEFAULT 'retain',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_rxajpptdthellnalugthfibzkarwjchtukgq` (`layoutId`),
  KEY `idx_prrydlukpxxlywdrkzvaqhjhukbyapajnlgh` (`templateId`),
  KEY `idx_cddfegcondnyvkxhqlpbkezolseodmoqkpaz` (`defaultStatusId`),
  KEY `idx_xsjisypncmucbgsdbizpyrnllxnswvjvyrfd` (`submitActionEntryId`),
  KEY `idx_zidgduqsvixavfkicwnyffrldjnatpbtywhb` (`submitActionEntrySiteId`),
  CONSTRAINT `fk_abcroeupevcjhiuyisknquzeodeewuxgtqdw` FOREIGN KEY (`submitActionEntryId`) REFERENCES `entries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_bsgirrthfwrrckqwjqvzctzyxqezwzmjtyxf` FOREIGN KEY (`layoutId`) REFERENCES `formie_fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_clnhfclwuejwakbvnhedsmkwizknjehniaet` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_eozbcreculatnzjfkfvyfvxyyiducufpqdaa` FOREIGN KEY (`templateId`) REFERENCES `formie_formtemplates` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_wxhceocahlfqeouayilmxgnpwsjmtfopfxpp` FOREIGN KEY (`defaultStatusId`) REFERENCES `formie_statuses` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_formtemplates`
--

DROP TABLE IF EXISTS `formie_formtemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_formtemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `template` varchar(255) DEFAULT NULL,
  `useCustomTemplates` tinyint(1) DEFAULT 1,
  `outputCssLayout` tinyint(1) DEFAULT 1,
  `outputCssTheme` tinyint(1) DEFAULT 1,
  `outputJsBase` tinyint(1) DEFAULT 1,
  `outputJsTheme` tinyint(1) DEFAULT 1,
  `outputCssLocation` varchar(255) DEFAULT NULL,
  `outputJsLocation` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ivnbqrrsusukwlcovuppjzsxzjawjzeauitw` (`fieldLayoutId`),
  CONSTRAINT `fk_fichcmwibfuzkopsjybkcsogwrymzfprbqso` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_integrations`
--

DROP TABLE IF EXISTS `formie_integrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_integrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `enabled` varchar(255) NOT NULL DEFAULT 'true',
  `settings` mediumtext DEFAULT NULL,
  `cache` longtext DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_notifications`
--

DROP TABLE IF EXISTS `formie_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `formId` int(11) NOT NULL,
  `templateId` int(11) DEFAULT NULL,
  `pdfTemplateId` int(11) DEFAULT NULL,
  `name` text NOT NULL,
  `handle` varchar(64) NOT NULL,
  `enabled` tinyint(1) DEFAULT 1,
  `subject` text DEFAULT NULL,
  `recipients` enum('email','conditions') NOT NULL DEFAULT 'email',
  `to` text DEFAULT NULL,
  `toConditions` text DEFAULT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `replyTo` text DEFAULT NULL,
  `replyToName` text DEFAULT NULL,
  `from` text DEFAULT NULL,
  `fromName` text DEFAULT NULL,
  `sender` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `attachFiles` tinyint(1) DEFAULT 1,
  `attachPdf` tinyint(1) DEFAULT 0,
  `attachAssets` text DEFAULT NULL,
  `enableConditions` tinyint(1) DEFAULT 0,
  `conditions` text DEFAULT NULL,
  `customSettings` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_zxqfoctgxwbdevfmmabgkrmwwqufuraobahh` (`formId`),
  KEY `idx_ksvgenjmxuqvmstuvbkfuptspgbbwqqmobkg` (`templateId`),
  KEY `fk_hbzxebnldpvsnatdeumrzzrlnlafggxyxqdm` (`pdfTemplateId`),
  CONSTRAINT `fk_hbzxebnldpvsnatdeumrzzrlnlafggxyxqdm` FOREIGN KEY (`pdfTemplateId`) REFERENCES `formie_pdftemplates` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_jpfstsfcpjbftrpchydfmynrxpqeyjnuyuep` FOREIGN KEY (`formId`) REFERENCES `formie_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_qafechuvybojsdanjvlitganxgabnizpjioo` FOREIGN KEY (`templateId`) REFERENCES `formie_emailtemplates` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_payments`
--

DROP TABLE IF EXISTS `formie_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) NOT NULL,
  `submissionId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `subscriptionId` int(11) DEFAULT NULL,
  `amount` decimal(14,4) DEFAULT NULL,
  `currency` varchar(255) DEFAULT NULL,
  `status` enum('pending','redirect','success','failed','processing') NOT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `redirectUrl` text DEFAULT NULL,
  `note` mediumtext DEFAULT NULL,
  `response` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_pbpccfwvxsddledccvybkyltlglhtsiiyduh` (`integrationId`),
  KEY `idx_kmdzjixkgxdsvydtmpsqepvqwlpqckytrras` (`fieldId`),
  KEY `idx_ljfmfdvtpljvxqwdzuttbyxoatjofonlzhel` (`reference`),
  KEY `fk_pewvqtdjfutudzwwlfnpwujpdxoeebrwgvaw` (`submissionId`),
  KEY `fk_hwdxrwbyjrmnjkqdmrjnhqcjvzymdyvtfxoe` (`subscriptionId`),
  CONSTRAINT `fk_hwdxrwbyjrmnjkqdmrjnhqcjvzymdyvtfxoe` FOREIGN KEY (`subscriptionId`) REFERENCES `formie_payments_subscriptions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_jdwnwutfmlpcfizxnevsycehuzmnxhvyufcr` FOREIGN KEY (`integrationId`) REFERENCES `formie_integrations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_pewvqtdjfutudzwwlfnpwujpdxoeebrwgvaw` FOREIGN KEY (`submissionId`) REFERENCES `formie_submissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zxgjdlztummejihvjzdgkspmadwkcxwnrqkr` FOREIGN KEY (`fieldId`) REFERENCES `formie_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_payments_plans`
--

DROP TABLE IF EXISTS `formie_payments_plans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_payments_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `handle` varchar(255) DEFAULT NULL,
  `reference` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `planData` text DEFAULT NULL,
  `isArchived` tinyint(1) NOT NULL,
  `dateArchived` datetime DEFAULT NULL,
  `sortOrder` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_gsqragqbhwexxmiptcirqaaumovfjyvdlfzb` (`handle`),
  KEY `idx_hmvurhqpfrkwcdmnyeirkozngfyropqjabiv` (`integrationId`),
  KEY `idx_anutxptxtxzxnmxzvfnqgasbnvvnophoojqn` (`reference`),
  CONSTRAINT `fk_hoawurlvwiyyjfmxlsfaehjrtgywcertkpqc` FOREIGN KEY (`integrationId`) REFERENCES `formie_integrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_payments_subscriptions`
--

DROP TABLE IF EXISTS `formie_payments_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_payments_subscriptions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) DEFAULT NULL,
  `submissionId` int(11) DEFAULT NULL,
  `fieldId` int(11) DEFAULT NULL,
  `planId` int(11) DEFAULT NULL,
  `reference` varchar(255) NOT NULL,
  `subscriptionData` text DEFAULT NULL,
  `trialDays` int(11) NOT NULL,
  `nextPaymentDate` datetime DEFAULT NULL,
  `hasStarted` tinyint(1) NOT NULL DEFAULT 1,
  `isSuspended` tinyint(1) NOT NULL DEFAULT 0,
  `dateSuspended` datetime DEFAULT NULL,
  `isCanceled` tinyint(1) NOT NULL,
  `dateCanceled` datetime DEFAULT NULL,
  `isExpired` tinyint(1) NOT NULL,
  `dateExpired` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_nszdpiypzhcwyakbootpxshyktpwzerfrbzf` (`integrationId`),
  KEY `idx_zhvcbesabsmcoegwdwpktdqhcsnhdovhlzrm` (`submissionId`),
  KEY `idx_uletgfycsqbvrdelunglcnjlyvabwridbkty` (`fieldId`),
  KEY `idx_ohoppbbpwtnwwyojayaxfyrsrtoctdlulqcg` (`planId`),
  KEY `idx_llfcdwbgmcnntykgljiutliqdhrvsausrbhi` (`reference`),
  KEY `idx_zzsastgcuehsnntipcjeayqiiiktxdhibpnv` (`nextPaymentDate`),
  KEY `idx_hnsdofoqxmnafdzgkfwtlqkziirrhdcazwpo` (`dateExpired`),
  KEY `idx_qwdhmcokuwuekdyrlnymwistgsyvqwirgigg` (`dateExpired`),
  CONSTRAINT `fk_fiacfdjiyvmkpafronahyrfveeuaauyzwhhb` FOREIGN KEY (`planId`) REFERENCES `formie_payments_plans` (`id`),
  CONSTRAINT `fk_luawsngdzjezbvtbzswvrecbrrsrygmvkwjz` FOREIGN KEY (`integrationId`) REFERENCES `formie_integrations` (`id`),
  CONSTRAINT `fk_mafqwsjkkhduyzenonqoxwdrdbfryetvmnju` FOREIGN KEY (`fieldId`) REFERENCES `formie_fields` (`id`),
  CONSTRAINT `fk_nopxcmmxfmondobylqzshmzbtavtmpwtmbmk` FOREIGN KEY (`submissionId`) REFERENCES `formie_submissions` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_pdftemplates`
--

DROP TABLE IF EXISTS `formie_pdftemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_pdftemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `template` varchar(255) NOT NULL,
  `filenameFormat` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_relations`
--

DROP TABLE IF EXISTS `formie_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `sourceId` int(11) NOT NULL,
  `sourceSiteId` int(11) DEFAULT NULL,
  `targetId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_fkenkvdvfrtrtzlrefzxqobmuwyusbsfllcw` (`sourceId`,`sourceSiteId`,`targetId`),
  KEY `idx_llttzpibnyhbdrymipbzkhpzmnsgwwpavcmo` (`sourceId`),
  KEY `idx_hbfnwnohjgsdoulwdajldpmcuvzhfkfckkbd` (`targetId`),
  KEY `idx_jzsaagwfentfmkfiptzvrnvhzocbvmzwbclk` (`sourceSiteId`),
  CONSTRAINT `fk_hknyrmitrylzxpxxugaflkwtwvrijhjudmdr` FOREIGN KEY (`sourceSiteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_sciuhgapcxftmbgqmnulfkbpzsolhfwnwiqc` FOREIGN KEY (`sourceId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wkyimtleaicvbvzxfclqtunufacelfllugap` FOREIGN KEY (`targetId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_sentnotifications`
--

DROP TABLE IF EXISTS `formie_sentnotifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_sentnotifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `formId` int(11) DEFAULT NULL,
  `submissionId` int(11) DEFAULT NULL,
  `notificationId` int(11) DEFAULT NULL,
  `subject` text DEFAULT NULL,
  `to` text DEFAULT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `replyTo` text DEFAULT NULL,
  `replyToName` text DEFAULT NULL,
  `from` text DEFAULT NULL,
  `fromName` text DEFAULT NULL,
  `sender` text DEFAULT NULL,
  `body` mediumtext DEFAULT NULL,
  `htmlBody` mediumtext DEFAULT NULL,
  `info` text DEFAULT NULL,
  `success` tinyint(1) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `dateUpdated` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_mqmpkuhgvgufeqlggrjgfhuiqxkjtgokjwuc` (`formId`),
  KEY `fk_sytrqqjukpgyazrxrgkxitgiptqqrffqvdxf` (`submissionId`),
  KEY `fk_ffuurdlhwmlgeojoxlzdclittlgukdtysdho` (`notificationId`),
  CONSTRAINT `fk_ffuurdlhwmlgeojoxlzdclittlgukdtysdho` FOREIGN KEY (`notificationId`) REFERENCES `formie_notifications` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_mqmpkuhgvgufeqlggrjgfhuiqxkjtgokjwuc` FOREIGN KEY (`formId`) REFERENCES `formie_forms` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_mvcayarqktrskzgiwybxpyuptxpzkgwtdbmy` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_sytrqqjukpgyazrxrgkxitgiptqqrffqvdxf` FOREIGN KEY (`submissionId`) REFERENCES `formie_submissions` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=4758 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_statuses`
--

DROP TABLE IF EXISTS `formie_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_statuses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `color` enum('green','orange','red','blue','yellow','pink','purple','turquoise','light','grey','black') NOT NULL DEFAULT 'green',
  `description` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `isDefault` tinyint(1) DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_stencils`
--

DROP TABLE IF EXISTS `formie_stencils`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_stencils` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `data` mediumtext DEFAULT NULL,
  `templateId` int(11) DEFAULT NULL,
  `submitActionEntryId` int(11) DEFAULT NULL,
  `submitActionEntrySiteId` int(11) DEFAULT NULL,
  `defaultStatusId` int(11) DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_fyzvxirpggezywbhsiojmfrlrrdkcqchhnev` (`templateId`),
  KEY `idx_rhqthqeoprhffhorqyzdddcnnbngdbmxqray` (`defaultStatusId`),
  CONSTRAINT `fk_jeuoiqhsntnbeatowkqqlsenlqvjjexrlnsv` FOREIGN KEY (`templateId`) REFERENCES `formie_formtemplates` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_pifswfutfxntlzwvfpnckosafkvzronuppem` FOREIGN KEY (`defaultStatusId`) REFERENCES `formie_statuses` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_submissions`
--

DROP TABLE IF EXISTS `formie_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_submissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`content`)),
  `formId` int(11) NOT NULL,
  `statusId` int(11) DEFAULT NULL,
  `userId` int(11) DEFAULT NULL,
  `isIncomplete` tinyint(1) DEFAULT 0,
  `isSpam` tinyint(1) DEFAULT 0,
  `spamReason` text DEFAULT NULL,
  `spamClass` varchar(255) DEFAULT NULL,
  `snapshot` text DEFAULT NULL,
  `ipAddress` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_olhwfygrtbpbmujrokconqbtpovixoozahum` (`formId`),
  KEY `idx_ihovtpcpdubtodiaudryjjvedjzylitswzah` (`statusId`),
  KEY `idx_zaogrohjldodbykdyhyhbemdldyzbmmadjga` (`userId`),
  CONSTRAINT `fk_lrgpcpaueytvbxkmowfrymxrmpukzoddkhuw` FOREIGN KEY (`formId`) REFERENCES `formie_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ookegsgoqxoncsjobblmoluviszeggpxzjtz` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_wzcashzdbqtqwjvstxacgoyyuaathxgmrusd` FOREIGN KEY (`statusId`) REFERENCES `formie_statuses` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_xmzmkirxvmsxwanzeoayftmfuxoajxbcalnw` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4755 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `globalsets`
--

DROP TABLE IF EXISTS `globalsets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `globalsets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_xbsaazzhfhszjjvlrtwakfprfftqylfpoixl` (`name`),
  KEY `idx_oekjlhinxdcgehqfghqgsitypscdnsmtpyiy` (`handle`),
  KEY `idx_pcmckodvesbnmrquykwlfoaxnixovjpovxlj` (`fieldLayoutId`),
  KEY `idx_agwesgbdiznudgikaivifjxnsxdqljydismg` (`sortOrder`),
  CONSTRAINT `fk_abuqvrvmzewsyxtxaizvqgrmfbetlpqmzscq` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_riekewyysqlkppelpzwfwrhantegwhpxccqn` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=555 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `googlemaps_addresses`
--

DROP TABLE IF EXISTS `googlemaps_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `googlemaps_addresses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `formatted` varchar(255) DEFAULT NULL,
  `raw` text DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `street1` varchar(255) DEFAULT NULL,
  `street2` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `neighborhood` varchar(255) DEFAULT NULL,
  `county` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `countryCode` varchar(255) DEFAULT NULL,
  `placeId` varchar(255) DEFAULT NULL,
  `lat` decimal(12,8) DEFAULT NULL,
  `lng` decimal(12,8) DEFAULT NULL,
  `zoom` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_kvewpboexmmxkfkedwfaeivmkkpknwcquoim` (`elementId`,`siteId`,`fieldId`),
  KEY `idx_mgjyhmxoovosoprsajqyhvfpzwjehhuecgdz` (`elementId`),
  KEY `idx_brugxkjnouwaarvezexnxaiudgikpoleaosv` (`siteId`),
  KEY `idx_qkhwwucjjehzuzyjxcybinmhbllgiahxpojr` (`fieldId`),
  KEY `idx_imafefrmhshjeanocszdytsvejjniwqognqy` (`siteId`,`fieldId`),
  KEY `idx_ngoasmkxngxsymdpmacpljledlqbichkrzcn` (`elementId`,`siteId`),
  KEY `idx_icrdjferjjmtcnfsnfexnmwpsybhosgxbijj` (`elementId`,`fieldId`),
  CONSTRAINT `fk_bdhsrifdslnlnqvynhscqmytjtclqlvkqvgh` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_nqvnkbomsoehnizexbvpzvbobwynxzlvjzau` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vivediezdmsegdgoqqvywzulessinjrfkusi` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1676 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqlschemas`
--

DROP TABLE IF EXISTS `gqlschemas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gqlschemas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `scope` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`scope`)),
  `isPublic` tinyint(1) NOT NULL DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqltokens`
--

DROP TABLE IF EXISTS `gqltokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gqltokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `accessToken` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `expiryDate` datetime DEFAULT NULL,
  `lastUsed` datetime DEFAULT NULL,
  `schemaId` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ogdlpvwgfwqnxgziosoqipsbajxwcpdwjpfq` (`accessToken`),
  UNIQUE KEY `idx_twiblfqsstzxrejysmhraysianqcokpkibmz` (`name`),
  KEY `fk_chalaclacaykoxoscfxramybbfsmeojwptnl` (`schemaId`),
  CONSTRAINT `fk_chalaclacaykoxoscfxramybbfsmeojwptnl` FOREIGN KEY (`schemaId`) REFERENCES `gqlschemas` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `imagetransformindex`
--

DROP TABLE IF EXISTS `imagetransformindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `imagetransformindex` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `assetId` int(11) NOT NULL,
  `transformer` varchar(255) DEFAULT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `format` varchar(255) DEFAULT NULL,
  `transformString` varchar(255) NOT NULL,
  `fileExists` tinyint(1) NOT NULL DEFAULT 0,
  `inProgress` tinyint(1) NOT NULL DEFAULT 0,
  `error` tinyint(1) NOT NULL DEFAULT 0,
  `dateIndexed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_fuqeeozcucihypiijzlhbyulpdsbulpbygma` (`assetId`,`transformString`)
) ENGINE=InnoDB AUTO_INCREMENT=605 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `imagetransforms`
--

DROP TABLE IF EXISTS `imagetransforms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `imagetransforms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `mode` enum('stretch','fit','crop','letterbox') NOT NULL DEFAULT 'crop',
  `position` enum('top-left','top-center','top-right','center-left','center-center','center-right','bottom-left','bottom-center','bottom-right') NOT NULL DEFAULT 'center-center',
  `width` int(10) unsigned DEFAULT NULL,
  `height` int(10) unsigned DEFAULT NULL,
  `format` varchar(255) DEFAULT NULL,
  `quality` int(11) DEFAULT NULL,
  `interlace` enum('none','line','plane','partition') NOT NULL DEFAULT 'none',
  `fill` varchar(11) DEFAULT NULL,
  `upscale` tinyint(1) NOT NULL DEFAULT 1,
  `parameterChangeTime` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_mltxzxqagzcumyyrnndebhvcxrrukqglcxsx` (`name`),
  KEY `idx_zhmqifimxmjppdwuaxxdkxrffslngdzxcfdl` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `info`
--

DROP TABLE IF EXISTS `info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) NOT NULL,
  `schemaVersion` varchar(15) NOT NULL,
  `maintenance` tinyint(1) NOT NULL DEFAULT 0,
  `configVersion` char(12) NOT NULL DEFAULT '000000000000',
  `fieldVersion` char(12) NOT NULL DEFAULT '000000000000',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `track` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `applyTime` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_hokepbzjninyxdvfjfnijzzopbbwebbeobxn` (`track`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `plugins`
--

DROP TABLE IF EXISTS `plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `plugins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` varchar(255) NOT NULL,
  `version` varchar(255) NOT NULL,
  `schemaVersion` varchar(255) NOT NULL,
  `installDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_yjxfmhlhejuqmhasefmufgetzyskntqrqzem` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `projectconfig`
--

DROP TABLE IF EXISTS `projectconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projectconfig` (
  `path` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue`
--

DROP TABLE IF EXISTS `queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel` varchar(255) NOT NULL DEFAULT 'queue',
  `job` longblob NOT NULL,
  `description` text DEFAULT NULL,
  `timePushed` int(11) NOT NULL,
  `ttr` int(11) NOT NULL,
  `delay` int(11) NOT NULL DEFAULT 0,
  `priority` int(10) unsigned NOT NULL DEFAULT 1024,
  `dateReserved` datetime DEFAULT NULL,
  `timeUpdated` int(11) DEFAULT NULL,
  `progress` smallint(6) NOT NULL DEFAULT 0,
  `progressLabel` varchar(255) DEFAULT NULL,
  `attempt` int(11) DEFAULT NULL,
  `fail` tinyint(1) DEFAULT 0,
  `dateFailed` datetime DEFAULT NULL,
  `error` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_mbkdbqdnsdqkupumbwhvaipofvnvhvivegkc` (`channel`,`fail`,`timeUpdated`,`timePushed`),
  KEY `idx_rmgvdauuujsoeewlyivkfntmyljkozojtunh` (`channel`,`fail`,`timeUpdated`,`delay`)
) ENGINE=InnoDB AUTO_INCREMENT=9326 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `recoverycodes`
--

DROP TABLE IF EXISTS `recoverycodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `recoverycodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `recoveryCodes` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `relations`
--

DROP TABLE IF EXISTS `relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldId` int(11) NOT NULL,
  `sourceId` int(11) NOT NULL,
  `sourceSiteId` int(11) DEFAULT NULL,
  `targetId` int(11) NOT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_gtkubxldumrdhogfwakgskbciupcusvafuqe` (`fieldId`,`sourceId`,`sourceSiteId`,`targetId`),
  KEY `idx_wjqdselkasklqvojxksaspfrjjampxaiguep` (`sourceId`),
  KEY `idx_ljbakwrnceegyzzhwmologvanyctoojvyjwz` (`targetId`),
  KEY `idx_dksxuagleembzlnuapswpewfpjzdnytgmiqm` (`sourceSiteId`),
  CONSTRAINT `fk_lynlgeiiwesivccxiiqdhzsjtzqduvdqowlh` FOREIGN KEY (`sourceId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ogujvhfyrzouqcbwfswvpvzaggtbkfsmatzk` FOREIGN KEY (`sourceSiteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ubslzsujihoamjhneyxhzvnfwfemreqgvome` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7625 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `resourcepaths`
--

DROP TABLE IF EXISTS `resourcepaths`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resourcepaths` (
  `hash` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  PRIMARY KEY (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `canonicalId` int(11) NOT NULL,
  `creatorId` int(11) DEFAULT NULL,
  `num` int(11) NOT NULL,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_vovfedpvphsnrkjgenttfyeflnvxiiktyeto` (`canonicalId`,`num`),
  KEY `fk_hhcoenppvmvdebazuoowwqofstjgxyikfbaz` (`creatorId`),
  CONSTRAINT `fk_hhcoenppvmvdebazuoowwqofstjgxyikfbaz` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_wiafzflznoonbpoobdjzrqktmxhlqxjsmeml` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2332 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindex`
--

DROP TABLE IF EXISTS `searchindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindex` (
  `elementId` int(11) NOT NULL,
  `attribute` varchar(25) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `keywords` text NOT NULL,
  PRIMARY KEY (`elementId`,`attribute`,`fieldId`,`siteId`),
  FULLTEXT KEY `idx_xktlgbqafoazkhqgwffwkojajphychvralgk` (`keywords`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindexqueue`
--

DROP TABLE IF EXISTS `searchindexqueue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindexqueue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `reserved` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_vukubcqmqptdqhnjzffekcltjlskakssoxux` (`elementId`,`siteId`,`reserved`),
  CONSTRAINT `fk_yoxlyfepzvxrllzacpkqrqvglkwxjfswxgjh` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3450 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindexqueue_fields`
--

DROP TABLE IF EXISTS `searchindexqueue_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindexqueue_fields` (
  `jobId` int(11) NOT NULL,
  `fieldHandle` varchar(255) NOT NULL,
  PRIMARY KEY (`jobId`,`fieldHandle`),
  UNIQUE KEY `idx_qdndfxhuijqbydgqelcnmyopalwmuxymxwsg` (`jobId`,`fieldHandle`),
  CONSTRAINT `fk_dcqpxgjgquvnwtwfuoqiskmkciulpaitiasy` FOREIGN KEY (`jobId`) REFERENCES `searchindexqueue` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections`
--

DROP TABLE IF EXISTS `sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `type` enum('single','channel','structure') NOT NULL DEFAULT 'channel',
  `enableVersioning` tinyint(1) NOT NULL DEFAULT 0,
  `maxAuthors` smallint(5) unsigned DEFAULT NULL,
  `propagationMethod` varchar(255) NOT NULL DEFAULT 'all',
  `defaultPlacement` enum('beginning','end') NOT NULL DEFAULT 'end',
  `previewTargets` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`previewTargets`)),
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qrpmxnrfdjqpcopeltsisloriogabqdfaurp` (`handle`),
  KEY `idx_lxsrucgwoiznmcttjddzpotbrkcackcqqoje` (`name`),
  KEY `idx_utlycaldrseybljwruetlrqruihxjocmutvg` (`structureId`),
  KEY `idx_mdzvlemchdowfonenjrjihvswxdlogpeqwyg` (`dateDeleted`),
  CONSTRAINT `fk_vfyocjkdagdwihnjzqqrvugbgscisixtvczd` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections_entrytypes`
--

DROP TABLE IF EXISTS `sections_entrytypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections_entrytypes` (
  `sectionId` int(11) NOT NULL,
  `typeId` int(11) NOT NULL,
  `sortOrder` smallint(5) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `handle` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`sectionId`,`typeId`),
  KEY `fk_fzigcrmravgmjettoztjeftkyrlaprkqnysd` (`typeId`),
  CONSTRAINT `fk_drwrmldkqtjkxxucxxbzrhgyyjkfyfcybgus` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_fzigcrmravgmjettoztjeftkyrlaprkqnysd` FOREIGN KEY (`typeId`) REFERENCES `entrytypes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections_sites`
--

DROP TABLE IF EXISTS `sections_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sectionId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT 1,
  `uriFormat` text DEFAULT NULL,
  `template` varchar(500) DEFAULT NULL,
  `enabledByDefault` tinyint(1) NOT NULL DEFAULT 1,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_sjfbyghiwpeyxcuyphrglivoldlooghoofln` (`sectionId`,`siteId`),
  KEY `idx_fvdgzfzqkyjrlybsmzbmdyzwgztjeuuwhmep` (`siteId`),
  CONSTRAINT `fk_vlwdqpgzrrzybebxkteyxjjjzurerhqwaplj` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_xxqvpgliyyjqfdpqaoetmruffzwhxcdfcnrq` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequences`
--

DROP TABLE IF EXISTS `sequences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequences` (
  `name` varchar(255) NOT NULL,
  `next` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `token` char(100) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_kilfokhjllioafxuubkvjdcixmrsekotyjhg` (`uid`),
  KEY `idx_njmiqpmztdeqgzgbsvfamewjqfrxmkphaqtj` (`token`),
  KEY `idx_tnwbupjfwdkdanuwtvpfzfalryslymvgvtze` (`dateUpdated`),
  KEY `idx_khjbkwfudyxgliaqlrendaqfjwdyxwgtuxjb` (`userId`),
  CONSTRAINT `fk_bekwypktjzctsibpuhnymderwsiuwtibgqhc` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `shunnedmessages`
--

DROP TABLE IF EXISTS `shunnedmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shunnedmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `message` varchar(255) NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_aaoaazajyxmzihslmjgrgtbicncsriryfchn` (`userId`,`message`),
  CONSTRAINT `fk_qfodjaorjzskvwglfrxoisuvanymqqcvgwlu` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sitegroups`
--

DROP TABLE IF EXISTS `sitegroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sitegroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_wotsdtzykyxrnlpgkmamgfwimmypdgimmxme` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sites`
--

DROP TABLE IF EXISTS `sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `primary` tinyint(1) NOT NULL,
  `enabled` varchar(255) NOT NULL DEFAULT 'true',
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `language` varchar(255) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT 0,
  `baseUrl` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_gvthfinszicvegnghpypqvjyxbqzddgbrape` (`dateDeleted`),
  KEY `idx_wtrpnmcmvqellmztgodbqedlonroyqvsmwyb` (`handle`),
  KEY `idx_ksomrwvmiuodevyqoavcvapuhjdbqwmaqroq` (`sortOrder`),
  KEY `fk_sfbucdquvkgcghgtwgjgnxmxyvvlinltawtl` (`groupId`),
  CONSTRAINT `fk_sfbucdquvkgcghgtwgjgnxmxyvvlinltawtl` FOREIGN KEY (`groupId`) REFERENCES `sitegroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sso_identities`
--

DROP TABLE IF EXISTS `sso_identities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sso_identities` (
  `provider` varchar(255) NOT NULL,
  `identityId` varchar(255) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`provider`,`identityId`,`userId`),
  KEY `fk_tzaclnpswsibbekhqqcwgglzwhxdxfhnxiue` (`userId`),
  CONSTRAINT `fk_tzaclnpswsibbekhqqcwgglzwhxdxfhnxiue` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structureelements`
--

DROP TABLE IF EXISTS `structureelements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `structureelements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) NOT NULL,
  `elementId` int(11) DEFAULT NULL,
  `root` int(10) unsigned DEFAULT NULL,
  `lft` int(10) unsigned NOT NULL,
  `rgt` int(10) unsigned NOT NULL,
  `level` smallint(5) unsigned NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_glwsesfxeuywleseaskiatelgqwhsavphfrk` (`structureId`,`elementId`),
  KEY `idx_ohtyplamqxdgdvwoewiufbgfssopjcnmobge` (`root`),
  KEY `idx_izhqjbyrvekgahskdtwwfrtdwxsxittabvdp` (`lft`),
  KEY `idx_mntqqgbsgtmmuqztopbyqqsewgvogzcwkgsj` (`rgt`),
  KEY `idx_crinuebacqhlojgjzlutlnsrduujsndwwxux` (`level`),
  KEY `idx_qksygbxkmeaxgbsnpapwjimqfaxckwnsynzh` (`elementId`),
  CONSTRAINT `fk_polmcjevuxconbxjzmwypjizowoyyalakuga` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=178 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structures`
--

DROP TABLE IF EXISTS `structures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `structures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `maxLevels` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_vurwjlkxxmzdpcxvjeiisrjpptdstfqmxjtf` (`dateDeleted`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `systemmessages`
--

DROP TABLE IF EXISTS `systemmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `systemmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_etrewehssuqhqbrnqtyeafgiicowmywmjdgr` (`key`,`language`),
  KEY `idx_cllsekzmrcdtmciypfmewxfovgqqebegrhwr` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taggroups`
--

DROP TABLE IF EXISTS `taggroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `taggroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uavrgdjpotgogvrnlzfdumjufmaqyuuxujly` (`name`),
  KEY `idx_yldnmnceyqfaubyllydpjbhiiduwasouaycf` (`handle`),
  KEY `idx_uyueliiozbqtgcnrxcyjoxovkmthrexvcsmt` (`dateDeleted`),
  KEY `fk_hwbtqbpxtsynsgcrpnyskmdebwhmmwsakzex` (`fieldLayoutId`),
  CONSTRAINT `fk_hwbtqbpxtsynsgcrpnyskmdebwhmmwsakzex` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_rgiwbykgvorxrpuyakeblpjfenuxaxsdxjpm` (`groupId`),
  CONSTRAINT `fk_jeakhckbbkxymeltjxwzwxufybyhyxifcjgo` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_mvibepzqksdytkxjohuuwuylabzlyrdqlfre` FOREIGN KEY (`groupId`) REFERENCES `taggroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tokens`
--

DROP TABLE IF EXISTS `tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` char(32) NOT NULL,
  `route` text DEFAULT NULL,
  `usageLimit` tinyint(3) unsigned DEFAULT NULL,
  `usageCount` tinyint(3) unsigned DEFAULT NULL,
  `expiryDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_iguhilcajijkqzzmiuaqsnvkjisprqlcqmme` (`token`),
  KEY `idx_bgrdrdanvrlcjwrwqyrwtzaipjiympabilql` (`expiryDate`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups`
--

DROP TABLE IF EXISTS `usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `usergroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_nifgpehogtkhcvvjwvdwmfwlozfdnbsujsgs` (`handle`),
  KEY `idx_jrxgafsujnsuoqncgwjlevwprvvtpfvuheha` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups_users`
--

DROP TABLE IF EXISTS `usergroups_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `usergroups_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_wbuxnxijmlcywxwuweutdpvzwupsblalziyu` (`groupId`,`userId`),
  KEY `idx_dqsqmznpdazocfzhimavjhxfgesvrsavnphg` (`userId`),
  CONSTRAINT `fk_ljeblfdgmxbubgysbibtizlwmlknlkupehih` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_nmguplpcqlnmygqmojtshsryqwgyoystbyce` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions`
--

DROP TABLE IF EXISTS `userpermissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ddentucjxuehhjtoimzoqdtygrwphwzvaxww` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_usergroups`
--

DROP TABLE IF EXISTS `userpermissions_usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions_usergroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permissionId` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ucjurorivfhaorffdrnomvhgtccyazavhutz` (`permissionId`,`groupId`),
  KEY `idx_fnmnqwfixjevawiudypfcgvtigcnbipmovhe` (`groupId`),
  CONSTRAINT `fk_ahbgiomxhstwpcelpekgmyiuypuuazcculwj` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zxjibncdboywfmcxqwhpostyonqmcgmqnmds` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_users`
--

DROP TABLE IF EXISTS `userpermissions_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permissionId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_agjecihoglwrhpzfepiretvhgyrsyeydbien` (`permissionId`,`userId`),
  KEY `idx_gwgqwdcwjrmjrewzsdulljzkbnhwohhhdole` (`userId`),
  CONSTRAINT `fk_edvjmuwynfgcnocdgkpinysmqwewednubgsx` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_xwygztsglwroncjawbabwftszxrhhcliojsx` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpreferences`
--

DROP TABLE IF EXISTS `userpreferences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpreferences` (
  `userId` int(11) NOT NULL AUTO_INCREMENT,
  `preferences` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`preferences`)),
  PRIMARY KEY (`userId`),
  CONSTRAINT `fk_ndzcvkhzlvudkhfdijyylmzljbmswdgdhemh` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `photoId` int(11) DEFAULT NULL,
  `affiliatedSiteId` int(11) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `pending` tinyint(1) NOT NULL DEFAULT 0,
  `locked` tinyint(1) NOT NULL DEFAULT 0,
  `suspended` tinyint(1) NOT NULL DEFAULT 0,
  `admin` tinyint(1) NOT NULL DEFAULT 0,
  `username` varchar(255) DEFAULT NULL,
  `fullName` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `lastLoginDate` datetime DEFAULT NULL,
  `lastLoginAttemptIp` varchar(45) DEFAULT NULL,
  `invalidLoginWindowStart` datetime DEFAULT NULL,
  `invalidLoginCount` tinyint(3) unsigned DEFAULT NULL,
  `lastInvalidLoginDate` datetime DEFAULT NULL,
  `lockoutDate` datetime DEFAULT NULL,
  `hasDashboard` tinyint(1) NOT NULL DEFAULT 0,
  `verificationCode` varchar(255) DEFAULT NULL,
  `verificationCodeIssuedDate` datetime DEFAULT NULL,
  `unverifiedEmail` varchar(255) DEFAULT NULL,
  `passwordResetRequired` tinyint(1) NOT NULL DEFAULT 0,
  `lastPasswordChangeDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_zpgnwdxlibbpqazfhgiwlypvdkvfnbhvbofm` (`active`),
  KEY `idx_yblhifndlrcnhyhntbrnildiqaxglncchxaf` (`locked`),
  KEY `idx_uvqjtsznmwpxjnrznfuhevpvmbyaohgpdsuz` (`pending`),
  KEY `idx_mlimddujldrcphevposyxvdwufmefhhekgis` (`suspended`),
  KEY `idx_suhaweibsmrkzahdbttcrozifoymoiqwaevc` (`verificationCode`),
  KEY `idx_pmwjwhvicilxxwxrvjmzmvcqqajgpeaokyhq` (`email`),
  KEY `idx_svrmuefimiuinvktrrntubsnuknqkufdojdg` (`username`),
  KEY `fk_ktgltzjkmpoqfsdclgvnmiroliayurdlnviy` (`photoId`),
  KEY `fk_tnnwhvjjcpdbztlspbsbcziwqoqjzwzwwirb` (`affiliatedSiteId`),
  CONSTRAINT `fk_ktgltzjkmpoqfsdclgvnmiroliayurdlnviy` FOREIGN KEY (`photoId`) REFERENCES `assets` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_pvogbbkodeqspdsqgfvcbkamrfjvbpqfnuvo` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tnnwhvjjcpdbztlspbsbcziwqoqjzwzwwirb` FOREIGN KEY (`affiliatedSiteId`) REFERENCES `sites` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumefolders`
--

DROP TABLE IF EXISTS `volumefolders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumefolders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parentId` int(11) DEFAULT NULL,
  `volumeId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `path` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_xymsimganfahzmnhhaxbizplgrkrozpeqovc` (`name`,`parentId`,`volumeId`),
  KEY `idx_vvdhtvkgzdckqxhuwvsmzaxijrvcrtfhcuai` (`parentId`),
  KEY `idx_lxshjhzcrxghtwsrndsufsgsfqigqpzjnrtc` (`volumeId`),
  CONSTRAINT `fk_cltqwyvsdanditwyzasjkmcotokzlpizvaaz` FOREIGN KEY (`parentId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ktzfquwhcsxsnxyahxfiduamgksdpfvfpxql` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fs` varchar(255) NOT NULL,
  `subpath` varchar(255) DEFAULT NULL,
  `transformFs` varchar(255) DEFAULT NULL,
  `transformSubpath` varchar(255) DEFAULT NULL,
  `titleTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text DEFAULT NULL,
  `altTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `altTranslationKeyFormat` text DEFAULT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_gbigkeuoxhyqciuxrrmcfnnfvmsymtdtlkgk` (`name`),
  KEY `idx_nibgarnftzszvgolotdqcktqauupeyhpcqgo` (`handle`),
  KEY `idx_ndvgpmousdymdklznjefxqtpldprglmmbqhj` (`fieldLayoutId`),
  KEY `idx_gusuktkxxflgmckzckhzuameydxzprqrhkfj` (`dateDeleted`),
  CONSTRAINT `fk_nyzfmnsroeqpwepnfcjzoeuevldyotxpgwqo` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `webauthn`
--

DROP TABLE IF EXISTS `webauthn`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `webauthn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `credentialId` varchar(255) DEFAULT NULL,
  `credential` text DEFAULT NULL,
  `credentialName` varchar(255) DEFAULT NULL,
  `dateLastUsed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_iwgkrireoeyxfnrukfprchjerpaxphldcxvj` (`userId`),
  CONSTRAINT `fk_iwgkrireoeyxfnrukfprchjerpaxphldcxvj` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `colspan` tinyint(4) DEFAULT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`settings`)),
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_nerzmenxwpjdybozzdiijnhabosizuuofrex` (`userId`),
  CONSTRAINT `fk_otipcgdghpcpsmkctrysvrtttpiqgarfiigu` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping routines for database 'akg_craft'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-10-22 20:40:00
/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.14-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: akg_craft
-- ------------------------------------------------------
-- Server version	10.11.14-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `addresses`
--

LOCK TABLES `addresses` WRITE;
/*!40000 ALTER TABLE `addresses` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `addresses` VALUES
(8,2,2,'US','NJ','Toms River',NULL,'08757',NULL,'1750 NJ-37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 17:32:44','2025-04-18 17:32:44');
/*!40000 ALTER TABLE `addresses` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assetindexingsessions`
--

LOCK TABLES `assetindexingsessions` WRITE;
/*!40000 ALTER TABLE `assetindexingsessions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `assetindexingsessions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `assets` VALUES
(86,1,1,1,'arbors.svg',NULL,'image',NULL,481,65,7435,NULL,1,1,'2025-04-18 18:31:40','2025-04-18 18:31:40','2025-04-18 18:31:40'),
(136,2,2,1,'arbors-entrance.jpg',NULL,'image',NULL,1920,1440,1835577,NULL,NULL,NULL,'2025-04-18 18:44:35','2025-04-18 18:44:35','2025-04-18 18:44:35'),
(137,2,2,1,'arbors-room.jpg',NULL,'image',NULL,1500,1000,220928,NULL,NULL,NULL,'2025-04-18 18:44:36','2025-04-18 18:44:36','2025-04-18 18:44:36'),
(138,2,2,1,'arbors-table.jpg',NULL,'image',NULL,1500,1000,402800,NULL,NULL,NULL,'2025-04-18 18:44:36','2025-04-18 18:44:36','2025-04-18 18:44:36'),
(285,5,7,1,'hands_holding.jpg','image/jpeg','image',NULL,1601,801,850595,NULL,NULL,NULL,'2025-09-05 20:01:00','2025-07-30 22:47:59','2025-09-05 20:01:00'),
(545,2,2,1,'Arbors-Cover-Photo.jpg','image/jpeg','image',NULL,5002,3336,4317908,NULL,NULL,NULL,'2025-09-02 20:43:22','2025-09-02 20:43:22','2025-09-02 20:43:22'),
(548,3,3,1,'Arbors-flyer.pdf','application/pdf','pdf',NULL,NULL,NULL,1965207,NULL,NULL,NULL,'2025-09-02 21:15:28','2025-09-02 21:15:29','2025-09-02 21:15:29'),
(612,6,8,1,'GreatPlacetoWork.jpg','image/jpeg','image',NULL,500,500,91067,NULL,NULL,NULL,'2025-09-03 21:56:34','2025-09-03 21:56:34','2025-09-03 21:56:34'),
(613,6,8,1,'StrivingforTen.jpg','image/jpeg','image',NULL,500,500,55294,NULL,NULL,NULL,'2025-09-03 21:56:34','2025-09-03 21:56:34','2025-09-03 21:56:34'),
(614,6,8,1,'5Star_OQM.jpg','image/jpeg','image',NULL,500,500,99483,NULL,NULL,NULL,'2025-09-03 21:56:35','2025-09-03 21:56:35','2025-09-03 21:56:35'),
(632,4,4,1,'Arbors-Admin.jpg','image/jpeg','image',NULL,1080,1080,62300,NULL,NULL,NULL,'2025-09-03 22:27:11','2025-09-03 22:27:11','2025-09-03 22:27:11'),
(634,4,4,1,'Arbors-AD-1.jpg','image/jpeg','image',NULL,1080,1080,75707,NULL,NULL,NULL,'2025-09-03 22:27:23','2025-09-03 22:27:23','2025-09-03 22:27:23'),
(2516,6,8,1,'StriveforTen_Updated.jpg','image/jpeg','image',NULL,1000,1000,194040,NULL,NULL,NULL,'2025-09-19 16:58:14','2025-09-19 16:58:14','2025-09-19 16:58:14'),
(2594,5,7,1,'ListenToUsVideo.jpg','image/jpeg','image',NULL,1248,702,524232,NULL,NULL,NULL,'2025-09-19 18:57:57','2025-09-19 18:57:57','2025-09-19 18:57:57'),
(2740,6,8,1,'CMS_5-Star-QM-2.png','image/png','image',NULL,2160,2164,694997,NULL,0,0,'2025-09-22 20:40:48','2025-09-22 20:40:48','2025-09-22 20:40:48'),
(2800,7,9,1,'rehab_2025-09-23-212249_sgzj.png','image/png','image',NULL,178,178,10114,NULL,NULL,NULL,'2025-09-23 21:22:49','2025-09-23 21:13:16','2025-09-23 21:22:49'),
(2803,7,9,1,'post-acute_2025-09-23-212238_tmva.png','image/png','image',NULL,178,178,8458,NULL,NULL,NULL,'2025-09-23 21:22:38','2025-09-23 21:13:36','2025-09-23 21:22:38'),
(2806,7,9,1,'advanced_2025-09-23-212231_zbhk.png','image/png','image',NULL,178,178,9147,NULL,NULL,NULL,'2025-09-23 21:22:31','2025-09-23 21:13:42','2025-09-23 21:22:31'),
(2809,7,9,1,'long-term_2025-09-23-212224_mktw.png','image/png','image',NULL,178,178,11754,NULL,NULL,NULL,'2025-09-23 21:22:24','2025-09-23 21:13:48','2025-09-23 21:22:24'),
(2855,5,7,1,'WhatisaRespiteStay_Article.jpg','image/jpeg','image',NULL,1020,510,144402,NULL,NULL,NULL,'2025-09-24 17:19:20','2025-09-24 17:19:20','2025-09-24 17:19:20'),
(2856,5,7,1,'CaringForaLovedOneatHome_Article.jpg','image/jpeg','image',NULL,1020,510,113589,NULL,NULL,NULL,'2025-09-24 17:19:27','2025-09-24 17:19:27','2025-09-24 17:19:27'),
(2857,5,7,1,'CaringFortheWholePerson_Article.jpg','image/jpeg','image',NULL,1020,510,145044,NULL,NULL,NULL,'2025-09-24 17:19:28','2025-09-24 17:19:28','2025-09-24 17:19:28'),
(2858,5,7,1,'LevelsofCareExplained_Article.jpg','image/jpeg','image',NULL,1020,510,105189,NULL,NULL,NULL,'2025-09-24 17:19:28','2025-09-24 17:19:28','2025-09-24 17:19:28'),
(2869,6,8,1,'BestOfMineralCounty.png','image/png','image',NULL,299,300,75547,NULL,NULL,NULL,'2025-09-24 18:09:43','2025-09-24 18:09:43','2025-09-24 18:09:43'),
(2870,6,8,1,'GreatPlaceToWork-2025.png','image/png','image',NULL,300,302,25150,NULL,NULL,NULL,'2025-09-24 18:09:44','2025-09-24 18:09:44','2025-09-24 18:09:44'),
(2871,6,8,1,'JointCommission.png','image/png','image',NULL,300,302,91559,NULL,NULL,NULL,'2025-09-24 18:09:44','2025-09-24 18:09:44','2025-09-24 18:09:44'),
(2872,6,8,1,'NewsweekBestNursingHomes.png','image/png','image',NULL,299,300,80372,NULL,NULL,NULL,'2025-09-24 18:09:44','2025-09-24 18:09:44','2025-09-24 18:09:44'),
(2873,6,8,1,'CMS_5-Star-QM-2.png','image/png','image',NULL,2160,2164,694997,NULL,NULL,NULL,'2025-10-06 17:12:47','2025-09-24 18:09:45','2025-10-06 17:12:47'),
(2874,6,8,1,'US-News-Best-Nursing-Homes.png','image/png','image',NULL,300,302,64612,NULL,NULL,NULL,'2025-09-24 18:09:45','2025-09-24 18:09:45','2025-10-08 18:29:50'),
(2877,5,7,1,'BeyondBingo_Article.jpg','image/jpeg','image',NULL,1020,510,215411,NULL,NULL,NULL,'2025-09-24 19:41:44','2025-09-24 19:41:44','2025-09-24 19:41:44'),
(2886,6,8,1,'striving_for_ten.png','image/png','image',NULL,1810,1810,221332,NULL,NULL,NULL,'2025-09-25 14:02:18','2025-09-25 14:02:18','2025-09-25 14:02:18'),
(2887,6,8,1,'Bronze-ahca.png','image/png','image',NULL,363,362,114299,NULL,NULL,NULL,'2025-09-25 14:07:12','2025-09-25 14:05:38','2025-09-25 14:07:18'),
(2888,6,8,1,'Silver-AHCA.png','image/png','image',NULL,364,365,108343,NULL,NULL,NULL,'2025-09-25 14:06:48','2025-09-25 14:05:39','2025-09-25 14:07:01'),
(2889,6,8,1,'AHCA-Silver2.png','image/png','image',NULL,364,365,108343,NULL,NULL,NULL,'2025-09-25 15:24:15','2025-09-25 15:18:29','2025-09-25 15:24:15'),
(2890,6,8,1,'AHCA-Bronze-2.png','image/png','image',NULL,363,362,114299,NULL,NULL,NULL,'2025-09-25 15:24:27','2025-09-25 15:18:40','2025-09-25 15:24:27'),
(2927,5,7,1,'QuestionstoAsk_Blog.jpg','image/jpeg','image',NULL,1020,510,135378,NULL,NULL,NULL,'2025-09-30 19:28:01','2025-09-30 19:28:01','2025-09-30 19:28:01'),
(2931,3,3,1,'Complete-Care-Privacy-Policy.pdf','application/pdf','pdf',NULL,NULL,NULL,171776,NULL,NULL,NULL,'2025-09-30 22:22:11','2025-09-30 22:22:11','2025-09-30 22:22:11'),
(2933,3,3,1,'Complete-Care-Website-Privacy-Policy.pdf','application/pdf','pdf',NULL,NULL,NULL,124312,NULL,NULL,NULL,'2025-09-30 22:22:21','2025-09-30 22:22:21','2025-09-30 22:22:21'),
(2934,3,3,1,'Complete-Care-Terms-of-Service.pdf','application/pdf','pdf',NULL,NULL,NULL,93180,NULL,NULL,NULL,'2025-09-30 22:22:35','2025-09-30 22:22:35','2025-09-30 22:22:35'),
(2941,3,3,1,'NonDiscriminationNotice.pdf','application/pdf','pdf',NULL,NULL,NULL,151589,NULL,NULL,NULL,'2025-09-30 22:43:05','2025-09-30 22:43:05','2025-09-30 22:43:05'),
(2968,2,2,1,'DSC_1449.jpg','image/jpeg','image',NULL,6016,4016,12007055,NULL,NULL,NULL,'2025-10-06 17:44:50','2025-10-06 17:44:50','2025-10-06 17:44:50'),
(2970,6,8,1,'CMS_4-Star-QM.png','image/png','image',NULL,2160,2164,694073,NULL,NULL,NULL,'2025-10-06 17:46:00','2025-10-06 17:46:00','2025-10-06 17:46:00'),
(3011,2,2,1,'Brick-Lobby.jpg','image/jpeg','image',NULL,1600,1200,302745,NULL,NULL,NULL,'2025-10-08 18:19:10','2025-10-08 18:19:10','2025-10-08 18:19:10'),
(3017,6,8,1,'CMS-Overall-5.png','image/png','image',NULL,2160,2164,696318,NULL,NULL,NULL,'2025-10-08 18:26:17','2025-10-08 18:26:17','2025-10-08 18:26:17'),
(3018,6,8,1,'CMS-Overall-4.png','image/png','image',NULL,2160,2164,695247,NULL,NULL,NULL,'2025-10-08 18:26:56','2025-10-08 18:26:56','2025-10-08 18:26:56'),
(3019,6,8,1,'CMS-Quality-and-Overall-4.png','image/png','image',NULL,2160,2164,693858,NULL,NULL,NULL,'2025-10-08 18:28:09','2025-10-08 18:28:09','2025-10-08 18:28:09'),
(3020,6,8,1,'US-News-Short-Term.png','image/png','image',NULL,924,976,143109,NULL,NULL,NULL,'2025-10-08 18:29:13','2025-10-08 18:29:13','2025-10-08 18:29:13'),
(3021,6,8,1,'VOHRA.png','image/png','image',NULL,1275,501,71637,NULL,NULL,NULL,'2025-10-08 18:30:50','2025-10-08 18:30:50','2025-10-08 18:31:22'),
(3022,6,8,1,'Local-BOMineral-2025-Logo.png','image/png','image',NULL,3600,3600,4033236,NULL,NULL,NULL,'2025-10-08 18:31:48','2025-10-08 18:31:49','2025-10-08 18:31:49'),
(3023,6,8,1,'Local-BOMineral-2025-Logo_WINNER.png','image/png','image',NULL,3600,3600,4296041,NULL,NULL,NULL,'2025-10-08 18:32:35','2025-10-08 18:32:35','2025-10-08 18:32:35'),
(3048,4,4,1,'Brick-Admin.jpg','image/jpeg','image',NULL,1080,1080,94395,NULL,NULL,NULL,'2025-10-08 18:42:24','2025-10-08 18:42:24','2025-10-08 18:42:24'),
(3058,2,2,1,'BurlingtonWoods-Lobby.jpg','image/jpeg','image',NULL,5044,3363,5445041,NULL,NULL,NULL,'2025-10-08 18:44:46','2025-10-08 18:44:46','2025-10-08 18:44:46'),
(3084,4,4,1,'Burlington-AD-1.jpg','image/jpeg','image',NULL,1080,1080,103887,NULL,NULL,NULL,'2025-10-08 18:51:15','2025-10-08 18:51:15','2025-10-08 18:51:15'),
(3090,2,2,1,'court-house-lobby.jpg','image/jpeg','image',NULL,5968,3979,9229046,NULL,NULL,NULL,'2025-10-08 18:53:50','2025-10-08 18:53:50','2025-10-08 18:54:27'),
(3122,2,2,1,'GreenAcres-Lobby.jpg','image/jpeg','image',NULL,6016,4016,11784141,NULL,NULL,NULL,'2025-10-08 19:52:53','2025-10-08 19:52:54','2025-10-08 19:52:54'),
(3137,4,4,1,'GreenAcres-AD.jpg','image/jpeg','image',NULL,1080,1080,105237,NULL,NULL,NULL,'2025-10-08 19:59:08','2025-10-08 19:59:08','2025-10-08 19:59:08'),
(3158,2,2,1,'HolidayCity-Lobby.jpg','image/jpeg','image',NULL,6016,4016,15103883,NULL,NULL,NULL,'2025-10-08 20:21:30','2025-10-08 20:21:30','2025-10-08 20:22:26'),
(3180,4,4,1,'Holiday-City-AD.jpg','image/jpeg','image',NULL,1080,1080,97681,NULL,NULL,NULL,'2025-10-08 20:25:38','2025-10-08 20:25:38','2025-10-08 20:25:38'),
(3221,4,4,1,'Bey-Lea-AL-Admin.jpg','image/jpeg','image',NULL,1080,1080,148526,NULL,NULL,NULL,'2025-10-08 22:21:38','2025-10-08 22:21:38','2025-10-08 22:21:38'),
(3235,2,2,1,'bey-lea_bathroom.jpg','image/jpeg','image',NULL,6016,4016,9138369,NULL,NULL,NULL,'2025-10-08 22:24:19','2025-10-08 22:24:19','2025-10-08 22:24:19'),
(3236,2,2,1,'bey-lea_common.jpg','image/jpeg','image',NULL,6016,4016,16366238,NULL,NULL,NULL,'2025-10-08 22:24:35','2025-10-08 22:24:36','2025-10-08 22:24:36'),
(3237,2,2,1,'bey-lea_couch.jpg','image/jpeg','image',NULL,6016,4016,12007055,NULL,NULL,NULL,'2025-10-08 22:24:47','2025-10-08 22:24:47','2025-10-08 22:24:47'),
(3238,2,2,1,'bey-lea_room.jpg','image/jpeg','image',NULL,6016,4016,12238256,NULL,NULL,NULL,'2025-10-08 22:24:58','2025-10-08 22:24:58','2025-10-08 22:24:58'),
(3239,2,2,1,'bey-lea_room2.jpg','image/jpeg','image',NULL,6016,4016,12394826,NULL,NULL,NULL,'2025-10-08 22:25:08','2025-10-08 22:25:08','2025-10-08 22:25:08'),
(3240,2,2,1,'bey-lea_bed.jpg','image/jpeg','image',NULL,6016,4016,14126115,NULL,NULL,NULL,'2025-10-08 22:25:18','2025-10-08 22:25:19','2025-10-08 22:25:19'),
(3241,2,2,1,'bey-lea_clinic.jpg','image/jpeg','image',NULL,6016,4016,10272411,NULL,NULL,NULL,'2025-10-08 22:25:30','2025-10-08 22:25:30','2025-10-08 22:25:30'),
(3242,2,2,1,'bey-lea_gym.jpg','image/jpeg','image',NULL,6016,4016,9866225,NULL,NULL,NULL,'2025-10-08 22:25:39','2025-10-08 22:25:39','2025-10-08 22:25:39'),
(3243,2,2,1,'bey-lea_kitchen.jpg','image/jpeg','image',NULL,6016,4016,12116386,NULL,NULL,NULL,'2025-10-08 22:25:46','2025-10-08 22:25:46','2025-10-08 22:25:46'),
(3244,2,2,1,'bey-lea_lobby.jpg','image/jpeg','image',NULL,6068,3413,2171386,NULL,NULL,NULL,'2025-10-08 22:25:48','2025-10-08 22:25:48','2025-10-08 22:25:48'),
(3245,2,2,1,'bey-lea_bathroom_2025-10-08-222837_modw.jpg','image/jpeg','image',NULL,1200,801,255038,NULL,NULL,NULL,'2025-10-08 22:28:38','2025-10-08 22:28:38','2025-10-08 22:28:38'),
(3246,2,2,1,'bey-lea_bed_2025-10-08-222839_xulc.jpg','image/jpeg','image',NULL,1200,801,413455,NULL,NULL,NULL,'2025-10-08 22:28:39','2025-10-08 22:28:39','2025-10-08 22:28:39'),
(3247,2,2,1,'bey-lea_clinic_2025-10-08-222840_oadk.jpg','image/jpeg','image',NULL,1200,801,286247,NULL,NULL,NULL,'2025-10-08 22:28:40','2025-10-08 22:28:40','2025-10-08 22:28:40'),
(3248,2,2,1,'bey-lea_common_2025-10-08-222840_orrb.jpg','image/jpeg','image',NULL,1200,801,451102,NULL,NULL,NULL,'2025-10-08 22:28:40','2025-10-08 22:28:40','2025-10-08 22:28:40'),
(3249,2,2,1,'bey-lea_couch_2025-10-08-222841_bwye.jpg','image/jpeg','image',NULL,1200,801,289343,NULL,NULL,NULL,'2025-10-08 22:28:41','2025-10-08 22:28:41','2025-10-08 22:28:41'),
(3250,2,2,1,'bey-lea_gym_2025-10-08-222842_arrz.jpg','image/jpeg','image',NULL,1200,801,346341,NULL,NULL,NULL,'2025-10-08 22:28:42','2025-10-08 22:28:42','2025-10-08 22:28:42'),
(3251,2,2,1,'bey-lea_kitchen_2025-10-08-222843_urug.jpg','image/jpeg','image',NULL,1200,801,399046,NULL,NULL,NULL,'2025-10-08 22:28:43','2025-10-08 22:28:43','2025-10-08 22:28:43'),
(3252,2,2,1,'bey-lea_lobby_2025-10-08-222843_pqvz.jpg','image/jpeg','image',NULL,1200,675,311470,NULL,NULL,NULL,'2025-10-08 22:28:43','2025-10-08 22:28:43','2025-10-08 22:28:43'),
(3253,2,2,1,'bey-lea_room_2025-10-08-222844_dvij.jpg','image/jpeg','image',NULL,1200,801,339247,NULL,NULL,NULL,'2025-10-08 22:28:44','2025-10-08 22:28:44','2025-10-08 22:28:44'),
(3254,2,2,1,'bey-lea_room2_2025-10-08-222845_hoiy.jpg','image/jpeg','image',NULL,1200,801,322293,NULL,NULL,NULL,'2025-10-08 22:28:45','2025-10-08 22:28:45','2025-10-08 22:28:45'),
(3276,2,2,1,'BrakeleyPark_Lobby.jpg','image/jpeg','image',NULL,1200,800,352223,NULL,NULL,NULL,'2025-10-08 22:32:31','2025-10-08 22:32:31','2025-10-08 22:32:31'),
(3278,2,2,1,'BrakeleyPark_Lobby2.jpg','image/jpeg','image',NULL,1200,800,399884,NULL,NULL,NULL,'2025-10-08 22:32:34','2025-10-08 22:32:34','2025-10-08 22:32:34'),
(3279,2,2,1,'BrakeleyPark_Lobby3.jpg','image/jpeg','image',NULL,1200,800,347819,NULL,NULL,NULL,'2025-10-08 22:32:35','2025-10-08 22:32:35','2025-10-08 22:32:35'),
(3280,2,2,1,'BrakeleyPark_RehabGym.jpg','image/jpeg','image',NULL,1200,800,321435,NULL,NULL,NULL,'2025-10-08 22:32:37','2025-10-08 22:32:37','2025-10-08 22:32:37'),
(3281,2,2,1,'BrakeleyPark_RehabGym2.jpg','image/jpeg','image',NULL,1200,800,360099,NULL,NULL,NULL,'2025-10-08 22:32:38','2025-10-08 22:32:38','2025-10-08 22:32:38'),
(3282,2,2,1,'BrakeleyPark_Room.jpg','image/jpeg','image',NULL,1200,800,355174,NULL,NULL,NULL,'2025-10-08 22:32:40','2025-10-08 22:32:40','2025-10-08 22:32:40'),
(3283,2,2,1,'BrakeleyPark_Room2.jpg','image/jpeg','image',NULL,1200,800,332176,NULL,NULL,NULL,'2025-10-08 22:32:41','2025-10-08 22:32:41','2025-10-08 22:32:41'),
(3362,2,2,1,'367A4645.jpg','image/jpeg','image',NULL,1200,800,371249,NULL,NULL,NULL,'2025-10-08 22:40:49','2025-10-08 22:40:49','2025-10-08 22:40:49'),
(3363,2,2,1,'367A4650.jpg','image/jpeg','image',NULL,1200,801,304292,NULL,NULL,NULL,'2025-10-08 22:40:50','2025-10-08 22:40:50','2025-10-08 22:40:50'),
(3364,2,2,1,'367A4664.jpg','image/jpeg','image',NULL,1200,800,263017,NULL,NULL,NULL,'2025-10-08 22:40:50','2025-10-08 22:40:50','2025-10-08 22:40:50'),
(3365,2,2,1,'367A4717.jpg','image/jpeg','image',NULL,1200,801,307841,NULL,NULL,NULL,'2025-10-08 22:40:51','2025-10-08 22:40:51','2025-10-08 22:40:51'),
(3366,2,2,1,'367A4731.jpg','image/jpeg','image',NULL,1200,801,295434,NULL,NULL,NULL,'2025-10-08 22:40:52','2025-10-08 22:40:52','2025-10-08 22:40:52'),
(3367,2,2,1,'367A4751.jpg','image/jpeg','image',NULL,1200,801,239398,NULL,NULL,NULL,'2025-10-08 22:40:53','2025-10-08 22:40:53','2025-10-08 22:40:53'),
(3368,2,2,1,'367A4760.jpg','image/jpeg','image',NULL,1200,800,269367,NULL,NULL,NULL,'2025-10-08 22:40:54','2025-10-08 22:40:54','2025-10-08 22:40:54'),
(3369,2,2,1,'367A4773.jpg','image/jpeg','image',NULL,1200,802,277448,NULL,NULL,NULL,'2025-10-08 22:40:55','2025-10-08 22:40:55','2025-10-08 22:40:55'),
(3370,2,2,1,'367A4781.jpg','image/jpeg','image',NULL,1200,800,424423,NULL,NULL,NULL,'2025-10-08 22:40:56','2025-10-08 22:40:56','2025-10-08 22:40:56'),
(3371,2,2,1,'367A4808.jpg','image/jpeg','image',NULL,1200,800,447405,NULL,NULL,NULL,'2025-10-08 22:40:58','2025-10-08 22:40:58','2025-10-08 22:40:58'),
(3372,2,2,1,'367A4820.jpg','image/jpeg','image',NULL,1200,800,490160,NULL,NULL,NULL,'2025-10-08 22:40:59','2025-10-08 22:40:59','2025-10-08 22:40:59'),
(3373,2,2,1,'DJI_0862_ChristianHome_Waupun.jpg','image/jpeg','image',NULL,1200,899,586189,NULL,NULL,NULL,'2025-10-08 22:41:00','2025-10-08 22:41:00','2025-10-08 22:41:00'),
(3374,2,2,1,'IMG_4736_ChristianHome_Waupun.jpg','image/jpeg','image',NULL,1200,800,434955,NULL,NULL,NULL,'2025-10-08 22:41:02','2025-10-08 22:41:02','2025-10-08 22:41:02'),
(3377,2,2,1,'Lobby-7.jpg','image/jpeg','image',NULL,5679,3786,6374436,NULL,NULL,NULL,'2025-10-09 14:40:19','2025-10-09 14:40:19','2025-10-09 14:40:19'),
(3416,4,4,1,'Kresson-Admin.jpg','image/jpeg','image',NULL,1080,1080,83440,NULL,NULL,NULL,'2025-10-09 14:59:18','2025-10-09 14:59:18','2025-10-09 14:59:18'),
(3418,4,4,1,'Kresson-AD.jpg','image/jpeg','image',NULL,1080,1080,109541,NULL,NULL,NULL,'2025-10-09 14:59:46','2025-10-09 14:59:46','2025-10-09 14:59:46'),
(3425,2,2,1,'Laurelton-Lobby.jpg','image/jpeg','image',NULL,6016,4016,9683171,NULL,NULL,NULL,'2025-10-09 16:20:10','2025-10-09 16:20:10','2025-10-09 16:20:23'),
(3467,2,2,1,'Marcella-Lobby-1.jpg','image/jpeg','image',NULL,6000,4000,9570894,NULL,NULL,NULL,'2025-10-09 16:32:34','2025-10-09 16:32:34','2025-10-09 16:32:34'),
(3494,4,4,1,'Marcella-Admin.jpg','image/jpeg','image',NULL,1080,1080,77980,NULL,NULL,NULL,'2025-10-09 16:37:14','2025-10-09 16:37:14','2025-10-09 16:37:14'),
(3495,4,4,1,'Taylor-Manning_Admissions.jpg','image/jpeg','image',NULL,1773,1182,207772,NULL,NULL,NULL,'2025-10-09 16:37:24','2025-10-09 16:37:24','2025-10-09 16:37:24'),
(3498,2,2,1,'Lobby-8.jpg','image/jpeg','image',NULL,5007,3340,3195440,NULL,NULL,NULL,'2025-10-09 16:38:59','2025-10-09 16:38:59','2025-10-09 16:38:59'),
(3530,2,2,1,'OceanGrove_Lobby.jpg','image/jpeg','image',NULL,6720,4480,17099464,NULL,NULL,NULL,'2025-10-09 17:00:32','2025-10-09 17:00:32','2025-10-09 17:00:45'),
(3564,2,2,1,'ShorrockGardens_Lobby.jpg','image/jpeg','image',NULL,6720,4480,17301770,NULL,NULL,NULL,'2025-10-09 17:07:08','2025-10-09 17:07:08','2025-10-09 17:07:08'),
(3594,2,2,1,'Oasis-Lobby.jpg','image/jpeg','image',NULL,6720,4480,14965855,NULL,NULL,NULL,'2025-10-09 17:14:28','2025-10-09 17:14:29','2025-10-09 17:14:29'),
(3623,2,2,1,'Lobby-9.jpg','image/jpeg','image',NULL,5938,3959,1154995,NULL,NULL,NULL,'2025-10-09 17:21:43','2025-10-09 17:21:43','2025-10-09 17:21:43'),
(3648,4,4,1,'Voorhees-AD.jpg','image/jpeg','image',NULL,1080,1080,139966,NULL,NULL,NULL,'2025-10-09 17:24:30','2025-10-09 17:24:30','2025-10-09 17:24:30'),
(3689,2,2,1,'bayshore-lobby.jpg','image/jpeg','image',NULL,6720,4480,5567512,NULL,NULL,NULL,'2025-10-09 20:43:00','2025-10-09 20:43:00','2025-10-09 20:43:24'),
(3712,4,4,1,'Bayshore-Admin.jpg','image/jpeg','image',NULL,1080,1080,114319,NULL,NULL,NULL,'2025-10-09 20:47:03','2025-10-09 20:47:03','2025-10-09 20:47:03'),
(3714,4,4,1,'Bayshore-AD.jpg','image/jpeg','image',NULL,1080,1080,74159,NULL,NULL,NULL,'2025-10-09 20:48:06','2025-10-09 20:48:06','2025-10-09 20:48:06'),
(3722,2,2,1,'Cedar-Grove-Lobby.jpg','image/jpeg','image',NULL,5043,3362,6510502,NULL,NULL,NULL,'2025-10-09 20:50:40','2025-10-09 20:50:40','2025-10-09 20:50:40'),
(3746,4,4,1,'Cedar-Grove-Admin.jpg','image/jpeg','image',NULL,1080,1080,66905,NULL,NULL,NULL,'2025-10-09 20:55:28','2025-10-09 20:55:28','2025-10-09 20:55:28'),
(3748,4,4,1,'Cedar-Grove-Admissions-Director.jpg','image/jpeg','image',NULL,1080,1080,130432,NULL,NULL,NULL,'2025-10-09 20:55:46','2025-10-09 20:55:46','2025-10-09 20:55:46'),
(3761,2,2,1,'Clark-Lobby.jpg','image/jpeg','image',NULL,6720,4480,15145752,NULL,NULL,NULL,'2025-10-13 15:57:58','2025-10-13 15:57:58','2025-10-13 15:57:58'),
(3800,4,4,1,'GreenKnoll-Admin.jpg','image/jpeg','image',NULL,1080,1080,138916,NULL,NULL,NULL,'2025-10-13 16:03:32','2025-10-13 16:03:32','2025-10-13 16:03:42'),
(3802,4,4,1,'GreenKnoll-AD.jpg','image/jpeg','image',NULL,1080,1080,73986,NULL,NULL,NULL,'2025-10-13 16:04:02','2025-10-13 16:04:02','2025-10-13 16:04:02'),
(3808,2,2,1,'Green-Knoll-Lobby.jpg','image/jpeg','image',NULL,5040,3360,2067396,NULL,NULL,NULL,'2025-10-13 16:05:35','2025-10-13 16:05:35','2025-10-13 16:05:35'),
(3856,4,4,1,'Madison-Admin.jpg','image/jpeg','image',NULL,1080,1080,85590,NULL,NULL,NULL,'2025-10-13 16:15:24','2025-10-13 16:15:24','2025-10-13 16:15:24'),
(3858,4,4,1,'Madison-AD.jpg','image/jpeg','image',NULL,1080,1080,84389,NULL,NULL,NULL,'2025-10-13 16:15:40','2025-10-13 16:15:40','2025-10-13 16:15:40'),
(3865,2,2,1,'Mercerville-Lobby.jpg','image/jpeg','image',NULL,6252,4480,7301124,NULL,NULL,NULL,'2025-10-13 16:20:28','2025-10-13 16:20:28','2025-10-13 16:20:28'),
(3896,2,2,1,'Orange-Park-Lobby.jpg','image/jpeg','image',NULL,5927,4480,6659867,NULL,NULL,NULL,'2025-10-13 17:02:39','2025-10-13 17:02:39','2025-10-13 17:02:39'),
(3918,4,4,1,'Orange-Admin.jpg','image/jpeg','image',NULL,1080,1080,88366,NULL,NULL,NULL,'2025-10-13 17:06:23','2025-10-13 17:06:23','2025-10-13 17:06:23'),
(3920,4,4,1,'Orange-AD.jpg','image/jpeg','image',NULL,1080,1080,83758,NULL,NULL,NULL,'2025-10-13 17:06:40','2025-10-13 17:06:40','2025-10-13 17:06:40'),
(3927,2,2,1,'Park-Place-Lobby.jpg','image/jpeg','image',NULL,6720,4480,17599905,NULL,NULL,NULL,'2025-10-13 17:19:50','2025-10-13 17:19:50','2025-10-13 17:19:50'),
(3954,4,4,1,'Park-Place-AD.jpg','image/jpeg','image',NULL,1080,1080,136300,NULL,NULL,NULL,'2025-10-13 17:22:55','2025-10-13 17:22:55','2025-10-13 17:22:55'),
(3959,2,2,1,'Plainfield-Lobby.jpg','image/jpeg','image',NULL,6720,4480,15445322,NULL,NULL,NULL,'2025-10-13 17:25:39','2025-10-13 17:25:40','2025-10-13 17:25:55'),
(3981,4,4,1,'Plainfield-AD.jpg','image/jpeg','image',NULL,1080,1080,104000,NULL,NULL,NULL,'2025-10-13 17:28:18','2025-10-13 17:28:18','2025-10-13 17:28:18'),
(3986,2,2,1,'St-Vincents-Lobby.jpg','image/jpeg','image',NULL,5902,4480,5457598,NULL,NULL,NULL,'2025-10-13 17:40:31','2025-10-13 17:40:31','2025-10-13 17:40:31'),
(4008,4,4,1,'St-Vincent-Admin.jpg','image/jpeg','image',NULL,1080,1080,151258,NULL,NULL,NULL,'2025-10-13 17:43:03','2025-10-13 17:43:03','2025-10-13 17:43:03'),
(4010,4,4,1,'St-Vincents-AD.jpg','image/jpeg','image',NULL,1080,1080,72995,NULL,NULL,NULL,'2025-10-13 17:43:27','2025-10-13 17:43:27','2025-10-13 17:43:27'),
(4017,2,2,1,'Summit-Ridge-Lobby.jpg','image/jpeg','image',NULL,5024,3349,7533603,NULL,NULL,NULL,'2025-10-13 17:44:49','2025-10-13 17:44:49','2025-10-13 17:44:49'),
(4018,4,4,1,'Summit-Admin.jpg','image/jpeg','image',NULL,1080,1080,100588,NULL,NULL,NULL,'2025-10-13 17:45:02','2025-10-13 17:45:02','2025-10-13 17:45:02'),
(4020,4,4,1,'Summit-AD.jpg','image/jpeg','image',NULL,1080,1080,72945,NULL,NULL,NULL,'2025-10-13 17:45:12','2025-10-13 17:45:12','2025-10-13 17:45:12'),
(4069,4,4,1,'Caldwell-AD.jpg','image/jpeg','image',NULL,1080,1080,92819,NULL,NULL,NULL,'2025-10-13 17:51:54','2025-10-13 17:51:54','2025-10-13 17:51:54'),
(4080,2,2,1,'West-Caldwell-Lobby.jpg','image/jpeg','image',NULL,6230,4480,7157860,NULL,NULL,NULL,'2025-10-13 17:53:06','2025-10-13 17:53:06','2025-10-13 17:53:06'),
(4083,2,2,1,'Westfield-Lobby.jpg','image/jpeg','image',NULL,5040,3360,8684777,NULL,NULL,NULL,'2025-10-13 17:54:18','2025-10-13 17:54:18','2025-10-13 17:54:18'),
(4105,4,4,1,'Westfield-AD.jpg','image/jpeg','image',NULL,1080,1080,116843,NULL,NULL,NULL,'2025-10-13 17:56:57','2025-10-13 17:56:57','2025-10-13 17:57:21'),
(4138,4,4,1,'Woodlands-Admin.jpg','image/jpeg','image',NULL,1080,1080,94864,NULL,NULL,NULL,'2025-10-13 18:01:28','2025-10-13 18:01:28','2025-10-13 18:01:28'),
(4141,4,4,1,'Woodlands-AD.jpg','image/jpeg','image',NULL,1080,1080,80267,NULL,NULL,NULL,'2025-10-13 18:01:44','2025-10-13 18:01:44','2025-10-13 18:01:44'),
(4142,2,2,1,'Woodlands-Lobby.jpg','image/jpeg','image',NULL,5040,3360,10210881,NULL,NULL,NULL,'2025-10-13 18:02:04','2025-10-13 18:02:04','2025-10-13 18:02:04'),
(4150,2,2,1,'Roosevelt-Edison-Lounge.jpg','image/jpeg','image',NULL,5496,4480,4861132,NULL,NULL,NULL,'2025-10-13 19:05:27','2025-10-13 19:05:27','2025-10-13 19:05:27'),
(4172,4,4,1,'Edison-Admin.jpg','image/jpeg','image',NULL,1080,1080,112867,NULL,NULL,NULL,'2025-10-13 19:10:22','2025-10-13 19:10:22','2025-10-13 19:10:22'),
(4181,2,2,1,'Roosevelt-Old-Bridge-Gym.jpg','image/jpeg','image',NULL,6727,4482,15385400,NULL,NULL,NULL,'2025-10-13 19:12:29','2025-10-13 19:12:29','2025-10-13 19:12:29'),
(4207,4,4,1,'Old-Bridge-Admin.jpg','image/jpeg','image',NULL,1080,1080,78330,NULL,NULL,NULL,'2025-10-13 19:17:28','2025-10-13 19:17:28','2025-10-13 19:17:28'),
(4208,4,4,1,'Old-Bridge-AD.jpg','image/jpeg','image',NULL,1080,1080,107605,NULL,NULL,NULL,'2025-10-13 19:17:38','2025-10-13 19:17:38','2025-10-13 19:17:38'),
(4223,2,2,1,'Barn-Hill-Lobby.jpg','image/jpeg','image',NULL,6720,4480,16557805,NULL,NULL,NULL,'2025-10-13 19:26:37','2025-10-13 19:26:38','2025-10-13 19:26:38'),
(4246,4,4,1,'Barn-Hill-AD.jpg','image/jpeg','image',NULL,1080,1080,122394,NULL,NULL,NULL,'2025-10-13 19:29:49','2025-10-13 19:29:49','2025-10-13 19:29:49'),
(4276,2,2,1,'Berkshire-Lobby.jpg','image/jpeg','image',NULL,6729,4492,10943174,NULL,NULL,NULL,'2025-10-13 19:34:10','2025-10-13 19:34:10','2025-10-13 19:34:10'),
(4282,2,2,1,'Brakeley-Park-Lobby.jpg','image/jpeg','image',NULL,6720,4480,17400571,NULL,NULL,NULL,'2025-10-13 19:36:08','2025-10-13 19:36:08','2025-10-13 19:36:08'),
(4322,2,2,1,'Chestnut-Hill-Lobby.jpg','image/jpeg','image',NULL,6720,4480,16641052,NULL,NULL,NULL,'2025-10-13 19:47:24','2025-10-13 19:47:24','2025-10-13 19:47:24'),
(4349,4,4,1,'Harrington-AD.jpg','image/jpeg','image',NULL,1080,1080,98776,NULL,NULL,NULL,'2025-10-14 13:43:17','2025-10-14 13:43:17','2025-10-14 13:43:17'),
(4358,2,2,1,'Fair-Lawn-Lobby.jpg','image/jpeg','image',NULL,6724,4482,15479152,NULL,NULL,NULL,'2025-10-14 16:46:43','2025-10-14 16:46:43','2025-10-14 16:46:43'),
(4385,2,2,1,'Hamilton-Plaza-Lobby.jpg','image/jpeg','image',NULL,6720,4480,15463036,NULL,NULL,NULL,'2025-10-14 16:50:16','2025-10-14 16:50:16','2025-10-14 16:50:16'),
(4414,2,2,1,'Harborage-Lobby.jpg','image/jpeg','image',NULL,6720,4480,6136127,NULL,NULL,NULL,'2025-10-14 16:54:22','2025-10-14 16:54:22','2025-10-14 16:54:22'),
(4440,2,2,1,'Harston-Lobby.jpg','image/jpeg','image',NULL,6720,4480,17233442,NULL,NULL,NULL,'2025-10-14 16:57:52','2025-10-14 16:57:52','2025-10-14 16:57:52'),
(4466,2,2,1,'Inglemoor-Lobby.jpg','image/jpeg','image',NULL,7780,5187,14898154,NULL,NULL,NULL,'2025-10-14 17:00:51','2025-10-14 17:00:51','2025-10-14 17:01:23'),
(4497,2,2,1,'Lehigh-Lobby.jpg','image/jpeg','image',NULL,6720,4480,10240320,NULL,NULL,NULL,'2025-10-14 17:06:56','2025-10-14 17:06:56','2025-10-14 17:06:56'),
(4518,4,4,1,'Lehigh-AD.jpg','image/jpeg','image',NULL,1080,1080,81384,NULL,NULL,NULL,'2025-10-14 17:09:05','2025-10-14 17:09:05','2025-10-14 17:09:05'),
(4519,4,4,1,'Lehigh-Admin.jpg','image/jpeg','image',NULL,1080,1080,88123,NULL,NULL,NULL,'2025-10-14 17:09:11','2025-10-14 17:09:11','2025-10-14 17:09:11'),
(4526,2,2,1,'Milford-Manor-Lobby.jpg','image/jpeg','image',NULL,6720,4480,16641745,NULL,NULL,NULL,'2025-10-14 17:10:03','2025-10-14 17:10:04','2025-10-14 17:10:04'),
(4554,2,2,1,'Phillipsburg-Lobby.jpg','image/jpeg','image',NULL,5040,3360,8748043,NULL,NULL,NULL,'2025-10-14 17:13:18','2025-10-14 17:13:19','2025-10-14 17:13:19'),
(4562,4,4,1,'Brakeley-AD.jpg','image/jpeg','image',NULL,1080,1080,52073,NULL,NULL,NULL,'2025-10-14 17:15:24','2025-10-14 17:15:25','2025-10-14 17:15:25'),
(4579,2,2,1,'Prospect-Heights-Lobby.jpg','image/jpeg','image',NULL,5851,4480,5149998,NULL,NULL,NULL,'2025-10-14 17:19:41','2025-10-14 17:19:41','2025-10-14 17:19:41'),
(4602,4,4,1,'Prospect-Admin.jpg','image/jpeg','image',NULL,1080,1080,95445,NULL,NULL,NULL,'2025-10-14 17:22:03','2025-10-14 17:22:03','2025-10-14 17:22:03'),
(4610,2,2,1,'Regent-Lobby.jpg','image/jpeg','image',NULL,7589,5504,5575779,NULL,NULL,NULL,'2025-10-14 17:22:40','2025-10-14 17:22:40','2025-10-14 17:22:40'),
(4620,4,4,1,'Regent-AD.jpg','image/jpeg','image',NULL,1080,1080,80740,NULL,NULL,NULL,'2025-10-14 17:25:09','2025-10-14 17:25:09','2025-10-14 17:25:09'),
(4639,2,2,1,'Wayne-Hills-Lobby.jpg','image/jpeg','image',NULL,6720,4480,14984555,NULL,NULL,NULL,'2025-10-14 17:25:33','2025-10-14 17:25:33','2025-10-14 17:25:33'),
(4738,8,10,NULL,'Complete-Care-Terms-of-Service.pdf',NULL,'pdf',NULL,NULL,NULL,93180,NULL,NULL,NULL,'2025-10-23 01:11:44','2025-10-23 01:11:44','2025-10-23 01:11:44'),
(4742,8,10,1,'Complete-Care-Privacy-Policy.pdf',NULL,'pdf',NULL,NULL,NULL,171776,NULL,NULL,NULL,'2025-10-23 01:13:08','2025-10-23 01:13:08','2025-10-23 01:13:08');
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assets_sites`
--

LOCK TABLES `assets_sites` WRITE;
/*!40000 ALTER TABLE `assets_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `assets_sites` VALUES
(86,1,NULL),
(136,1,NULL),
(137,1,NULL),
(138,1,NULL),
(285,1,NULL),
(545,1,NULL),
(548,1,NULL),
(612,1,NULL),
(613,1,NULL),
(614,1,NULL),
(632,1,NULL),
(634,1,NULL),
(2516,1,NULL),
(2594,1,NULL),
(2740,1,NULL),
(2800,1,NULL),
(2803,1,NULL),
(2806,1,NULL),
(2809,1,NULL),
(2855,1,NULL),
(2856,1,NULL),
(2857,1,NULL),
(2858,1,NULL),
(2869,1,NULL),
(2870,1,NULL),
(2871,1,NULL),
(2872,1,NULL),
(2873,1,NULL),
(2874,1,NULL),
(2877,1,NULL),
(2886,1,NULL),
(2887,1,NULL),
(2888,1,NULL),
(2889,1,NULL),
(2890,1,NULL),
(2927,1,NULL),
(2931,1,NULL),
(2933,1,NULL),
(2934,1,NULL),
(2941,1,NULL),
(2968,1,NULL),
(2970,1,NULL),
(3011,1,NULL),
(3017,1,NULL),
(3018,1,NULL),
(3019,1,NULL),
(3020,1,NULL),
(3021,1,NULL),
(3022,1,NULL),
(3023,1,NULL),
(3048,1,NULL),
(3058,1,NULL),
(3084,1,NULL),
(3090,1,NULL),
(3122,1,NULL),
(3137,1,NULL),
(3158,1,NULL),
(3180,1,NULL),
(3221,1,NULL),
(3235,1,NULL),
(3236,1,NULL),
(3237,1,NULL),
(3238,1,NULL),
(3239,1,NULL),
(3240,1,NULL),
(3241,1,NULL),
(3242,1,NULL),
(3243,1,NULL),
(3244,1,NULL),
(3245,1,NULL),
(3246,1,NULL),
(3247,1,NULL),
(3248,1,NULL),
(3249,1,NULL),
(3250,1,NULL),
(3251,1,NULL),
(3252,1,NULL),
(3253,1,NULL),
(3254,1,NULL),
(3276,1,NULL),
(3278,1,NULL),
(3279,1,NULL),
(3280,1,NULL),
(3281,1,NULL),
(3282,1,NULL),
(3283,1,NULL),
(3362,1,NULL),
(3363,1,NULL),
(3364,1,NULL),
(3365,1,NULL),
(3366,1,NULL),
(3367,1,NULL),
(3368,1,NULL),
(3369,1,NULL),
(3370,1,NULL),
(3371,1,NULL),
(3372,1,NULL),
(3373,1,NULL),
(3374,1,NULL),
(3377,1,NULL),
(3416,1,NULL),
(3418,1,NULL),
(3425,1,NULL),
(3467,1,NULL),
(3494,1,NULL),
(3495,1,NULL),
(3498,1,NULL),
(3530,1,NULL),
(3564,1,NULL),
(3594,1,NULL),
(3623,1,NULL),
(3648,1,NULL),
(3689,1,NULL),
(3712,1,NULL),
(3714,1,NULL),
(3722,1,NULL),
(3746,1,NULL),
(3748,1,NULL),
(3761,1,NULL),
(3800,1,NULL),
(3802,1,NULL),
(3808,1,NULL),
(3856,1,NULL),
(3858,1,NULL),
(3865,1,NULL),
(3896,1,NULL),
(3918,1,NULL),
(3920,1,NULL),
(3927,1,NULL),
(3954,1,NULL),
(3959,1,NULL),
(3981,1,NULL),
(3986,1,NULL),
(4008,1,NULL),
(4010,1,NULL),
(4017,1,NULL),
(4018,1,NULL),
(4020,1,NULL),
(4069,1,NULL),
(4080,1,NULL),
(4083,1,NULL),
(4105,1,NULL),
(4138,1,NULL),
(4141,1,NULL),
(4142,1,NULL),
(4150,1,NULL),
(4172,1,NULL),
(4181,1,NULL),
(4207,1,NULL),
(4208,1,NULL),
(4223,1,NULL),
(4246,1,NULL),
(4276,1,NULL),
(4282,1,NULL),
(4322,1,NULL),
(4349,1,NULL),
(4358,1,NULL),
(4385,1,NULL),
(4414,1,NULL),
(4440,1,NULL),
(4466,1,NULL),
(4497,1,NULL),
(4518,1,NULL),
(4519,1,NULL),
(4526,1,NULL),
(4554,1,NULL),
(4562,1,NULL),
(4579,1,NULL),
(4602,1,NULL),
(4610,1,NULL),
(4620,1,NULL),
(4639,1,NULL),
(4738,1,NULL),
(4742,1,NULL);
/*!40000 ALTER TABLE `assets_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `auth_oauth_tokens`
--

LOCK TABLES `auth_oauth_tokens` WRITE;
/*!40000 ALTER TABLE `auth_oauth_tokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `auth_oauth_tokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `authenticator`
--

LOCK TABLES `authenticator` WRITE;
/*!40000 ALTER TABLE `authenticator` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `authenticator` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `bulkopevents`
--

LOCK TABLES `bulkopevents` WRITE;
/*!40000 ALTER TABLE `bulkopevents` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `bulkopevents` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups`
--

LOCK TABLES `categorygroups` WRITE;
/*!40000 ALTER TABLE `categorygroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categorygroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups_sites`
--

LOCK TABLES `categorygroups_sites` WRITE;
/*!40000 ALTER TABLE `categorygroups_sites` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categorygroups_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedattributes`
--

LOCK TABLES `changedattributes` WRITE;
/*!40000 ALTER TABLE `changedattributes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `changedattributes` VALUES
(2,1,'postDate','2025-04-18 17:16:03',0,1),
(2,1,'slug','2025-04-18 17:58:01',0,1),
(2,1,'title','2025-04-18 17:33:58',0,1),
(2,1,'uri','2025-08-20 17:56:29',0,1),
(18,1,'postDate','2025-04-18 18:06:50',0,1),
(18,1,'slug','2025-04-18 18:06:50',0,1),
(18,1,'title','2025-04-18 18:06:50',0,1),
(18,1,'uri','2025-04-18 18:06:50',0,1),
(20,1,'postDate','2025-04-18 18:06:58',0,1),
(20,1,'slug','2025-04-18 18:06:58',0,1),
(20,1,'status','2025-04-18 18:06:58',0,1),
(20,1,'title','2025-04-18 18:06:58',0,1),
(20,1,'uri','2025-04-18 18:06:58',0,1),
(22,1,'postDate','2025-04-18 18:07:06',0,1),
(22,1,'slug','2025-04-18 18:07:06',0,1),
(22,1,'status','2025-04-18 18:07:06',0,1),
(22,1,'title','2025-04-18 18:07:06',0,1),
(22,1,'uri','2025-04-18 18:07:06',0,1),
(24,1,'postDate','2025-04-18 18:07:32',0,1),
(24,1,'slug','2025-04-18 18:07:32',0,1),
(24,1,'status','2025-04-18 18:07:32',0,1),
(24,1,'title','2025-04-18 18:07:32',0,1),
(24,1,'uri','2025-04-18 18:07:32',0,1),
(26,1,'postDate','2025-04-18 18:07:37',0,1),
(26,1,'slug','2025-04-18 18:07:37',0,1),
(26,1,'status','2025-04-18 18:07:37',0,1),
(26,1,'title','2025-04-18 18:07:37',0,1),
(26,1,'uri','2025-04-18 18:07:37',0,1),
(28,1,'postDate','2025-04-18 18:07:43',0,1),
(28,1,'slug','2025-04-18 18:07:43',0,1),
(28,1,'status','2025-04-18 18:07:43',0,1),
(28,1,'title','2025-04-18 18:07:43',0,1),
(28,1,'uri','2025-04-18 18:07:43',0,1),
(30,1,'postDate','2025-04-18 18:07:48',0,1),
(30,1,'slug','2025-04-18 18:07:48',0,1),
(30,1,'status','2025-04-18 18:07:48',0,1),
(30,1,'title','2025-04-18 18:07:48',0,1),
(30,1,'uri','2025-04-18 18:07:48',0,1),
(32,1,'postDate','2025-04-18 18:07:53',0,1),
(32,1,'slug','2025-04-18 18:07:53',0,1),
(32,1,'status','2025-04-18 18:07:53',0,1),
(32,1,'title','2025-04-18 18:07:53',0,1),
(32,1,'uri','2025-04-18 18:07:53',0,1),
(34,1,'postDate','2025-04-18 18:08:00',0,1),
(34,1,'slug','2025-04-18 18:08:00',0,1),
(34,1,'status','2025-04-18 18:08:00',0,1),
(34,1,'title','2025-04-18 18:08:00',0,1),
(34,1,'uri','2025-04-18 18:08:00',0,1),
(36,1,'postDate','2025-04-18 18:08:04',0,1),
(36,1,'slug','2025-04-18 18:08:04',0,1),
(36,1,'status','2025-04-18 18:08:04',0,1),
(36,1,'title','2025-08-20 21:57:06',0,1),
(36,1,'uri','2025-04-18 18:08:04',0,1),
(44,1,'primaryOwnerId','2025-09-03 22:27:30',0,1),
(56,1,'primaryOwnerId','2025-09-03 21:05:58',0,1),
(56,1,'title','2025-09-03 21:05:58',0,1),
(57,1,'primaryOwnerId','2025-09-03 21:05:58',0,1),
(57,1,'title','2025-09-03 21:05:58',0,1),
(63,1,'primaryOwnerId','2025-09-03 21:08:08',0,1),
(63,1,'title','2025-09-03 21:05:58',0,1),
(111,1,'enabled','2025-09-29 18:59:42',0,1),
(111,1,'postDate','2025-04-18 18:38:40',0,1),
(111,1,'slug','2025-04-18 18:38:40',0,1),
(111,1,'title','2025-04-18 18:38:37',0,1),
(113,1,'enabled','2025-09-29 18:59:42',0,1),
(113,1,'postDate','2025-04-18 18:38:46',0,1),
(113,1,'slug','2025-04-18 18:38:46',0,1),
(113,1,'title','2025-04-18 18:38:45',0,1),
(115,1,'enabled','2025-09-29 18:59:42',0,1),
(115,1,'postDate','2025-04-18 18:38:51',0,1),
(115,1,'slug','2025-04-18 18:38:51',0,1),
(115,1,'title','2025-04-18 18:38:50',0,1),
(117,1,'enabled','2025-09-29 18:59:42',0,1),
(117,1,'postDate','2025-04-18 18:38:56',0,1),
(117,1,'slug','2025-04-18 18:38:56',0,1),
(117,1,'title','2025-04-18 18:38:55',0,1),
(119,1,'enabled','2025-09-29 18:59:42',0,1),
(119,1,'postDate','2025-04-18 18:39:00',0,1),
(119,1,'slug','2025-04-18 18:39:00',0,1),
(119,1,'title','2025-04-18 18:39:00',0,1),
(121,1,'enabled','2025-09-29 18:59:42',0,1),
(121,1,'postDate','2025-04-18 18:39:04',0,1),
(121,1,'slug','2025-04-18 18:39:04',0,1),
(121,1,'title','2025-04-18 18:39:04',0,1),
(283,1,'postDate','2025-07-30 21:07:33',0,1),
(283,1,'slug','2025-07-30 21:07:37',0,1),
(283,1,'status','2025-07-30 21:07:33',0,1),
(283,1,'title','2025-07-30 23:10:37',0,1),
(283,1,'uri','2025-07-30 21:07:37',0,1),
(288,1,'title','2025-07-30 23:10:31',0,1),
(290,1,'title','2025-07-30 23:11:03',0,1),
(292,1,'title','2025-07-30 23:10:55',0,1),
(294,1,'postDate','2025-07-30 23:11:29',0,1),
(296,1,'postDate','2025-07-30 23:11:31',0,1),
(296,1,'title','2025-07-30 23:10:45',0,1),
(323,1,'postDate','2025-08-01 17:59:31',0,1),
(323,1,'slug','2025-08-01 17:59:31',0,1),
(323,1,'title','2025-08-01 17:59:31',0,1),
(325,1,'fieldLayoutId','2025-08-01 17:59:53',0,1),
(325,1,'postDate','2025-08-01 17:59:41',0,1),
(325,1,'slug','2025-08-01 17:59:41',0,1),
(325,1,'title','2025-08-01 17:59:41',0,1),
(325,1,'typeId','2025-08-01 17:59:53',0,1),
(329,1,'postDate','2025-08-01 18:04:57',0,1),
(329,1,'slug','2025-08-01 18:04:54',0,1),
(329,1,'title','2025-08-01 18:04:54',0,1),
(331,1,'postDate','2025-08-01 18:05:01',0,1),
(331,1,'slug','2025-08-01 18:05:00',0,1),
(331,1,'status','2025-08-01 18:05:01',0,1),
(331,1,'title','2025-08-01 18:05:00',0,1),
(333,1,'postDate','2025-08-01 18:05:04',0,1),
(333,1,'slug','2025-08-01 18:05:04',0,1),
(333,1,'status','2025-08-01 18:05:04',0,1),
(333,1,'title','2025-08-01 18:05:04',0,1),
(335,1,'postDate','2025-08-01 18:05:08',0,1),
(335,1,'slug','2025-08-01 18:05:07',0,1),
(335,1,'status','2025-08-01 18:05:08',0,1),
(335,1,'title','2025-08-01 18:05:07',0,1),
(337,1,'postDate','2025-08-01 18:05:10',0,1),
(337,1,'slug','2025-08-01 18:05:10',0,1),
(337,1,'status','2025-08-01 18:05:10',0,1),
(337,1,'title','2025-08-01 18:05:10',0,1),
(339,1,'postDate','2025-08-01 18:05:15',0,1),
(339,1,'slug','2025-08-01 18:05:14',0,1),
(339,1,'status','2025-08-01 18:05:15',0,1),
(339,1,'title','2025-08-01 18:05:14',0,1),
(341,1,'postDate','2025-08-01 18:05:18',0,1),
(341,1,'slug','2025-08-01 18:05:18',0,1),
(341,1,'status','2025-08-01 18:05:18',0,1),
(341,1,'title','2025-08-01 18:05:18',0,1),
(343,1,'postDate','2025-08-01 18:05:21',0,1),
(343,1,'slug','2025-08-01 18:05:21',0,1),
(343,1,'status','2025-08-01 18:05:21',0,1),
(343,1,'title','2025-08-01 18:05:21',0,1),
(348,1,'postDate','2025-08-01 18:06:22',0,1),
(348,1,'slug','2025-08-01 18:06:15',0,1),
(348,1,'status','2025-08-01 18:06:22',0,1),
(348,1,'title','2025-08-01 18:06:15',0,1),
(350,1,'postDate','2025-08-01 18:06:40',0,1),
(350,1,'slug','2025-08-01 18:06:27',0,1),
(350,1,'status','2025-08-01 18:06:40',0,1),
(350,1,'title','2025-08-01 18:06:27',0,1),
(352,1,'postDate','2025-08-01 18:07:25',0,1),
(352,1,'slug','2025-08-01 18:07:16',0,1),
(352,1,'title','2025-08-01 18:07:16',0,1),
(354,1,'postDate','2025-08-01 18:07:35',0,1),
(354,1,'slug','2025-08-01 18:07:27',0,1),
(354,1,'status','2025-08-01 18:07:35',0,1),
(354,1,'title','2025-08-01 18:07:27',0,1),
(356,1,'postDate','2025-08-01 18:07:48',0,1),
(356,1,'slug','2025-08-01 18:07:40',0,1),
(356,1,'status','2025-08-01 18:07:48',0,1),
(356,1,'title','2025-08-01 18:07:40',0,1),
(358,1,'postDate','2025-08-01 18:07:58',0,1),
(358,1,'slug','2025-08-01 18:07:52',0,1),
(358,1,'title','2025-08-01 18:07:52',0,1),
(360,1,'postDate','2025-08-01 18:08:08',0,1),
(360,1,'slug','2025-08-01 18:08:02',0,1),
(360,1,'title','2025-08-01 18:08:02',0,1),
(362,1,'postDate','2025-08-01 18:08:17',0,1),
(362,1,'slug','2025-08-01 18:08:11',0,1),
(362,1,'title','2025-08-01 18:08:11',0,1),
(364,1,'postDate','2025-08-01 18:08:31',0,1),
(364,1,'slug','2025-08-01 18:08:22',0,1),
(364,1,'title','2025-08-01 18:08:22',0,1),
(366,1,'postDate','2025-08-01 18:09:02',0,1),
(366,1,'slug','2025-08-01 18:08:52',0,1),
(366,1,'title','2025-08-01 18:08:52',0,1),
(368,1,'postDate','2025-08-01 18:09:12',0,1),
(368,1,'slug','2025-08-01 18:09:04',0,1),
(368,1,'status','2025-08-01 18:09:12',0,1),
(368,1,'title','2025-08-01 18:09:04',0,1),
(370,1,'postDate','2025-08-01 18:09:33',0,1),
(370,1,'slug','2025-08-01 18:09:16',0,1),
(370,1,'status','2025-08-01 18:09:33',0,1),
(370,1,'title','2025-08-01 18:09:16',0,1),
(372,1,'postDate','2025-08-01 18:09:44',0,1),
(372,1,'slug','2025-08-01 18:09:38',0,1),
(372,1,'status','2025-08-01 18:09:44',0,1),
(372,1,'title','2025-08-01 18:09:38',0,1),
(374,1,'postDate','2025-08-01 18:10:00',0,1),
(374,1,'slug','2025-08-01 18:09:48',0,1),
(374,1,'status','2025-08-01 18:10:00',0,1),
(374,1,'title','2025-08-01 18:09:48',0,1),
(376,1,'postDate','2025-08-01 18:10:07',0,1),
(376,1,'slug','2025-08-01 18:10:02',0,1),
(376,1,'status','2025-08-01 18:10:07',0,1),
(376,1,'title','2025-08-01 18:10:02',0,1),
(378,1,'postDate','2025-08-01 18:10:18',0,1),
(378,1,'slug','2025-08-01 18:10:11',0,1),
(378,1,'status','2025-08-01 18:10:18',0,1),
(378,1,'title','2025-08-01 18:10:11',0,1),
(380,1,'postDate','2025-08-01 18:10:31',0,1),
(380,1,'slug','2025-08-01 18:10:22',0,1),
(380,1,'status','2025-08-01 18:10:31',0,1),
(380,1,'title','2025-08-01 18:10:22',0,1),
(382,1,'postDate','2025-08-01 18:10:53',0,1),
(382,1,'slug','2025-08-01 18:10:47',0,1),
(382,1,'title','2025-08-01 18:10:47',0,1),
(384,1,'postDate','2025-08-01 18:11:04',0,1),
(384,1,'slug','2025-08-01 18:10:58',0,1),
(384,1,'title','2025-08-01 18:10:58',0,1),
(386,1,'postDate','2025-08-01 18:11:17',0,1),
(386,1,'slug','2025-08-01 18:11:11',0,1),
(386,1,'title','2025-08-01 18:11:11',0,1),
(388,1,'postDate','2025-08-01 18:11:31',0,1),
(388,1,'slug','2025-08-01 18:11:21',0,1),
(388,1,'title','2025-08-01 18:11:21',0,1),
(390,1,'postDate','2025-08-01 18:11:48',0,1),
(390,1,'slug','2025-08-01 18:11:41',0,1),
(390,1,'title','2025-08-01 18:11:41',0,1),
(392,1,'postDate','2025-08-01 18:12:02',0,1),
(392,1,'slug','2025-08-01 18:11:52',0,1),
(392,1,'status','2025-08-01 18:12:02',0,1),
(392,1,'title','2025-08-01 18:11:52',0,1),
(394,1,'postDate','2025-08-01 18:12:14',0,1),
(394,1,'slug','2025-08-01 18:12:07',0,1),
(394,1,'status','2025-08-01 18:12:14',0,1),
(394,1,'title','2025-08-01 18:12:07',0,1),
(396,1,'postDate','2025-08-01 18:12:26',0,1),
(396,1,'slug','2025-08-01 18:12:18',0,1),
(396,1,'status','2025-08-01 18:12:26',0,1),
(396,1,'title','2025-08-01 18:12:18',0,1),
(398,1,'postDate','2025-08-01 18:12:34',0,1),
(398,1,'slug','2025-08-01 18:12:27',0,1),
(398,1,'status','2025-08-01 18:12:34',0,1),
(398,1,'title','2025-08-01 18:12:27',0,1),
(400,1,'postDate','2025-08-01 18:12:57',0,1),
(400,1,'slug','2025-08-01 18:12:49',0,1),
(400,1,'title','2025-08-01 18:12:49',0,1),
(402,1,'postDate','2025-08-01 18:13:07',0,1),
(402,1,'slug','2025-08-01 18:13:00',0,1),
(402,1,'status','2025-08-01 18:13:07',0,1),
(402,1,'title','2025-08-01 18:13:00',0,1),
(404,1,'postDate','2025-08-01 18:13:20',0,1),
(404,1,'slug','2025-08-01 18:13:10',0,1),
(404,1,'status','2025-08-01 18:13:20',0,1),
(404,1,'title','2025-08-01 18:13:10',0,1),
(406,1,'postDate','2025-08-01 18:13:33',0,1),
(406,1,'slug','2025-08-01 18:13:23',0,1),
(406,1,'status','2025-08-01 18:13:33',0,1),
(406,1,'title','2025-08-01 18:13:23',0,1),
(408,1,'postDate','2025-08-01 18:13:42',0,1),
(408,1,'slug','2025-08-01 18:13:35',0,1),
(408,1,'status','2025-08-01 18:13:42',0,1),
(408,1,'title','2025-08-01 18:13:35',0,1),
(410,1,'postDate','2025-08-01 18:13:53',0,1),
(410,1,'slug','2025-08-01 18:13:47',0,1),
(410,1,'status','2025-08-01 18:13:53',0,1),
(410,1,'title','2025-08-01 18:13:47',0,1),
(412,1,'postDate','2025-08-01 18:14:03',0,1),
(412,1,'slug','2025-08-01 18:13:56',0,1),
(412,1,'status','2025-08-01 18:14:03',0,1),
(412,1,'title','2025-08-01 18:13:56',0,1),
(414,1,'postDate','2025-08-01 18:14:13',0,1),
(414,1,'slug','2025-08-01 18:14:08',0,1),
(414,1,'status','2025-08-01 18:14:13',0,1),
(414,1,'title','2025-08-01 18:14:08',0,1),
(426,1,'primaryOwnerId','2025-10-23 01:39:49',0,1),
(427,1,'primaryOwnerId','2025-10-23 01:39:49',0,1),
(428,1,'primaryOwnerId','2025-10-23 01:39:49',0,1),
(445,1,'primaryOwnerId','2025-09-03 22:27:30',0,1),
(453,1,'postDate','2025-08-20 21:57:20',0,1),
(453,1,'slug','2025-08-20 21:57:14',0,1),
(453,1,'title','2025-08-20 21:57:14',0,1),
(455,1,'postDate','2025-08-20 21:57:32',0,1),
(455,1,'slug','2025-08-20 21:57:26',0,1),
(455,1,'title','2025-08-20 21:57:26',0,1),
(457,1,'postDate','2025-08-20 21:58:42',0,1),
(457,1,'slug','2025-08-20 21:58:36',0,1),
(457,1,'title','2025-08-20 21:58:36',0,1),
(459,1,'postDate','2025-08-20 21:58:54',0,1),
(459,1,'slug','2025-08-20 21:58:48',0,1),
(459,1,'title','2025-08-20 21:58:48',0,1),
(461,1,'postDate','2025-08-20 21:59:06',0,1),
(461,1,'slug','2025-08-20 21:59:02',0,1),
(461,1,'title','2025-08-20 21:59:02',0,1),
(463,1,'postDate','2025-08-20 21:59:15',0,1),
(463,1,'slug','2025-08-20 21:59:11',0,1),
(463,1,'title','2025-08-20 21:59:11',0,1),
(465,1,'postDate','2025-08-20 21:59:33',0,1),
(465,1,'slug','2025-08-20 21:59:31',0,1),
(465,1,'title','2025-08-20 21:59:31',0,1),
(467,1,'postDate','2025-08-20 21:59:45',0,1),
(467,1,'slug','2025-08-20 21:59:43',0,1),
(467,1,'title','2025-08-20 21:59:43',0,1),
(469,1,'postDate','2025-08-20 22:00:03',0,1),
(469,1,'slug','2025-08-20 21:59:57',0,1),
(469,1,'title','2025-08-20 21:59:57',0,1),
(471,1,'postDate','2025-08-20 22:00:11',0,1),
(471,1,'slug','2025-08-20 22:00:07',0,1),
(471,1,'status','2025-08-20 22:00:11',0,1),
(471,1,'title','2025-08-20 22:00:07',0,1),
(473,1,'postDate','2025-08-20 22:00:22',0,1),
(473,1,'slug','2025-08-20 22:00:20',0,1),
(473,1,'status','2025-08-20 22:00:22',0,1),
(473,1,'title','2025-08-20 22:00:20',0,1),
(475,1,'postDate','2025-08-20 22:00:38',0,1),
(475,1,'slug','2025-08-20 22:00:32',0,1),
(475,1,'title','2025-08-20 22:00:32',0,1),
(477,1,'postDate','2025-08-20 22:00:46',0,1),
(477,1,'slug','2025-08-20 22:00:45',0,1),
(477,1,'title','2025-08-20 22:00:45',0,1),
(479,1,'postDate','2025-08-20 22:00:59',0,1),
(479,1,'slug','2025-08-20 22:00:55',0,1),
(479,1,'title','2025-08-20 22:00:55',0,1),
(481,1,'postDate','2025-08-20 22:01:08',0,1),
(481,1,'slug','2025-08-20 22:01:03',0,1),
(481,1,'title','2025-08-20 22:01:03',0,1),
(483,1,'postDate','2025-08-20 22:01:17',0,1),
(483,1,'slug','2025-08-20 22:01:13',0,1),
(483,1,'title','2025-08-20 22:01:13',0,1),
(485,1,'postDate','2025-08-20 22:01:30',0,1),
(485,1,'slug','2025-08-20 22:01:23',0,1),
(485,1,'title','2025-08-20 22:01:23',0,1),
(487,1,'postDate','2025-08-20 22:02:03',0,1),
(487,1,'slug','2025-08-20 22:02:00',0,1),
(487,1,'title','2025-08-20 22:02:00',0,1),
(489,1,'postDate','2025-08-20 22:02:13',0,1),
(489,1,'slug','2025-08-20 22:02:09',0,1),
(489,1,'title','2025-08-20 22:02:09',0,1),
(491,1,'postDate','2025-08-20 22:02:19',0,1),
(491,1,'slug','2025-08-20 22:02:19',0,1),
(491,1,'status','2025-08-20 22:02:19',0,1),
(491,1,'title','2025-08-20 22:02:19',0,1),
(493,1,'postDate','2025-08-20 22:02:28',0,1),
(493,1,'slug','2025-08-20 22:02:28',0,1),
(493,1,'title','2025-08-20 22:02:28',0,1),
(495,1,'postDate','2025-08-20 22:02:34',0,1),
(495,1,'slug','2025-08-20 22:02:33',0,1),
(495,1,'status','2025-08-20 22:02:34',0,1),
(495,1,'title','2025-08-20 22:02:33',0,1),
(497,1,'postDate','2025-08-20 22:02:59',0,1),
(497,1,'slug','2025-08-20 22:02:53',0,1),
(497,1,'title','2025-09-11 20:12:38',0,1),
(499,1,'postDate','2025-08-20 22:12:23',0,1),
(499,1,'slug','2025-08-20 22:12:22',0,1),
(499,1,'title','2025-08-20 22:12:22',0,1),
(501,1,'postDate','2025-08-20 22:12:28',0,1),
(501,1,'slug','2025-08-20 22:12:28',0,1),
(501,1,'status','2025-08-20 22:12:28',0,1),
(501,1,'title','2025-08-20 22:12:28',0,1),
(503,1,'postDate','2025-08-20 22:12:34',0,1),
(503,1,'slug','2025-08-20 22:12:33',0,1),
(503,1,'title','2025-08-20 22:12:33',0,1),
(506,1,'postDate','2025-08-20 22:12:50',0,1),
(506,1,'slug','2025-08-20 22:12:50',0,1),
(506,1,'title','2025-08-20 22:12:50',0,1),
(508,1,'postDate','2025-08-20 22:12:54',0,1),
(508,1,'slug','2025-08-20 22:12:54',0,1),
(508,1,'status','2025-08-20 22:12:54',0,1),
(508,1,'title','2025-08-20 22:12:54',0,1),
(510,1,'postDate','2025-08-20 22:12:57',0,1),
(510,1,'slug','2025-08-20 22:12:57',0,1),
(510,1,'status','2025-08-20 22:12:57',0,1),
(510,1,'title','2025-08-20 22:12:57',0,1),
(512,1,'postDate','2025-08-20 22:13:01',0,1),
(512,1,'slug','2025-08-20 22:13:00',0,1),
(512,1,'status','2025-08-20 22:13:01',0,1),
(512,1,'title','2025-08-20 22:13:00',0,1),
(514,1,'postDate','2025-08-20 22:13:04',0,1),
(514,1,'slug','2025-08-20 22:13:04',0,1),
(514,1,'status','2025-08-20 22:13:04',0,1),
(514,1,'title','2025-08-20 22:13:04',0,1),
(516,1,'postDate','2025-08-20 22:13:07',0,1),
(516,1,'slug','2025-08-20 22:13:07',0,1),
(516,1,'status','2025-08-20 22:13:07',0,1),
(516,1,'title','2025-08-20 22:13:07',0,1),
(518,1,'postDate','2025-08-20 22:13:10',0,1),
(518,1,'slug','2025-08-20 22:13:10',0,1),
(518,1,'status','2025-08-20 22:13:10',0,1),
(518,1,'title','2025-08-20 22:13:10',0,1),
(520,1,'postDate','2025-08-20 22:13:13',0,1),
(520,1,'slug','2025-08-20 22:13:12',0,1),
(520,1,'status','2025-08-20 22:13:13',0,1),
(520,1,'title','2025-08-20 22:13:12',0,1),
(522,1,'postDate','2025-08-20 22:13:15',0,1),
(522,1,'slug','2025-08-20 22:13:15',0,1),
(522,1,'status','2025-08-20 22:13:15',0,1),
(522,1,'title','2025-08-20 22:13:15',0,1),
(524,1,'postDate','2025-08-20 22:13:18',0,1),
(524,1,'slug','2025-08-20 22:13:18',0,1),
(524,1,'status','2025-08-20 22:13:18',0,1),
(524,1,'title','2025-08-20 22:13:18',0,1),
(530,1,'postDate','2025-08-20 22:17:46',0,1),
(530,1,'slug','2025-08-20 22:17:46',0,1),
(530,1,'title','2025-08-20 22:17:46',0,1),
(532,1,'postDate','2025-08-20 22:18:02',0,1),
(532,1,'slug','2025-08-20 22:18:02',0,1),
(532,1,'title','2025-08-20 22:18:02',0,1),
(534,1,'postDate','2025-08-20 22:18:21',0,1),
(534,1,'slug','2025-08-20 22:18:21',0,1),
(534,1,'title','2025-08-20 22:18:29',0,1),
(555,1,'enabled','2025-09-29 18:59:42',0,1),
(555,1,'postDate','2025-09-02 22:24:46',0,1),
(555,1,'slug','2025-09-02 22:24:46',0,1),
(555,1,'title','2025-09-02 22:24:41',0,1),
(557,1,'enabled','2025-09-29 18:59:42',0,1),
(557,1,'postDate','2025-09-02 22:24:52',0,1),
(557,1,'slug','2025-09-02 22:24:52',0,1),
(557,1,'status','2025-09-02 22:24:52',0,1),
(557,1,'title','2025-09-02 22:24:51',0,1),
(559,1,'enabled','2025-09-29 18:59:42',0,1),
(559,1,'postDate','2025-09-02 22:24:59',0,1),
(559,1,'slug','2025-09-02 22:24:59',0,1),
(559,1,'status','2025-09-02 22:24:59',0,1),
(559,1,'title','2025-09-02 22:24:59',0,1),
(561,1,'enabled','2025-09-29 18:59:42',0,1),
(561,1,'postDate','2025-09-02 22:25:02',0,1),
(561,1,'slug','2025-09-02 22:25:02',0,1),
(561,1,'status','2025-09-02 22:25:02',0,1),
(561,1,'title','2025-09-02 22:25:02',0,1),
(563,1,'enabled','2025-09-29 18:59:42',0,1),
(563,1,'postDate','2025-09-02 22:25:06',0,1),
(563,1,'slug','2025-09-02 22:25:06',0,1),
(563,1,'status','2025-09-02 22:25:06',0,1),
(563,1,'title','2025-09-02 22:25:06',0,1),
(601,1,'postDate','2025-09-03 21:48:33',0,1),
(601,1,'slug','2025-09-03 21:48:33',0,1),
(601,1,'title','2025-09-03 21:49:20',0,1),
(603,1,'postDate','2025-09-03 21:48:45',0,1),
(603,1,'slug','2025-09-03 21:48:45',0,1),
(603,1,'status','2025-09-03 21:48:45',0,1),
(603,1,'title','2025-09-03 21:48:44',0,1),
(605,1,'postDate','2025-09-03 21:48:52',0,1),
(605,1,'slug','2025-09-03 21:48:52',0,1),
(605,1,'title','2025-09-03 21:58:30',0,1),
(617,1,'postDate','2025-09-03 21:56:47',0,1),
(617,1,'slug','2025-09-03 21:56:47',0,1),
(617,1,'status','2025-09-03 21:56:47',0,1),
(617,1,'title','2025-09-03 21:57:10',0,1),
(951,1,'title','2025-09-22 17:36:50',0,1),
(1149,1,'slug','2025-09-11 19:17:31',0,1),
(1353,1,'slug','2025-09-22 18:10:11',0,1),
(1353,1,'title','2025-09-22 18:03:40',0,1),
(1359,1,'slug','2025-09-22 18:10:03',0,1),
(1359,1,'title','2025-09-22 18:03:21',0,1),
(1365,1,'slug','2025-09-22 18:10:48',0,1),
(1371,1,'slug','2025-09-22 18:11:25',0,1),
(1377,1,'slug','2025-09-22 18:11:36',0,1),
(1383,1,'slug','2025-09-22 18:11:49',0,1),
(1389,1,'slug','2025-09-22 18:12:03',0,1),
(1395,1,'slug','2025-09-22 18:10:30',0,1),
(1395,1,'title','2025-09-22 18:08:00',0,1),
(1401,1,'slug','2025-09-22 18:12:28',0,1),
(1401,1,'title','2025-09-22 18:08:33',0,1),
(1407,1,'slug','2025-09-22 18:13:02',0,1),
(1413,1,'slug','2025-09-22 18:09:54',0,1),
(1413,1,'title','2025-09-22 18:09:23',0,1),
(1437,1,'title','2025-10-22 18:20:15',0,1),
(1486,1,'primaryOwnerId','2025-09-17 19:37:16',0,1),
(1486,1,'slug','2025-09-17 19:37:16',0,1),
(1487,1,'primaryOwnerId','2025-09-17 19:37:16',0,1),
(1487,1,'slug','2025-09-17 19:37:16',0,1),
(1499,1,'primaryOwnerId','2025-10-08 22:21:46',0,1),
(1499,1,'slug','2025-10-08 22:21:46',0,1),
(1504,1,'primaryOwnerId','2025-10-08 18:43:12',0,1),
(1504,1,'slug','2025-10-08 18:43:12',0,1),
(1505,1,'primaryOwnerId','2025-10-08 18:43:12',0,1),
(1505,1,'slug','2025-10-08 18:43:12',0,1),
(1509,1,'primaryOwnerId','2025-10-08 18:52:55',0,1),
(1509,1,'slug','2025-10-08 18:52:55',0,1),
(1510,1,'primaryOwnerId','2025-10-08 18:52:55',0,1),
(1510,1,'slug','2025-10-08 18:52:55',0,1),
(1514,1,'primaryOwnerId','2025-10-08 19:00:47',0,1),
(1514,1,'slug','2025-10-08 19:00:47',0,1),
(1515,1,'primaryOwnerId','2025-10-08 19:00:47',0,1),
(1515,1,'slug','2025-10-08 19:00:47',0,1),
(1519,1,'primaryOwnerId','2025-10-08 19:59:16',0,1),
(1519,1,'slug','2025-10-08 19:59:16',0,1),
(1520,1,'primaryOwnerId','2025-10-08 19:59:16',0,1),
(1520,1,'slug','2025-10-08 19:59:16',0,1),
(1525,1,'primaryOwnerId','2025-10-08 20:25:58',0,1),
(1525,1,'slug','2025-10-08 20:25:58',0,1),
(1526,1,'primaryOwnerId','2025-10-08 20:25:58',0,1),
(1526,1,'slug','2025-10-08 20:25:58',0,1),
(1531,1,'primaryOwnerId','2025-10-09 14:59:55',0,1),
(1531,1,'slug','2025-10-09 14:59:55',0,1),
(1532,1,'primaryOwnerId','2025-10-09 14:59:55',0,1),
(1532,1,'slug','2025-10-09 14:59:55',0,1),
(1536,1,'primaryOwnerId','2025-10-09 16:31:32',0,1),
(1536,1,'slug','2025-10-09 16:31:32',0,1),
(1539,1,'primaryOwnerId','2025-10-14 16:14:34',0,1),
(1539,1,'slug','2025-10-14 16:14:34',0,1),
(1540,1,'primaryOwnerId','2025-10-14 16:14:34',0,1),
(1540,1,'slug','2025-10-14 16:14:34',0,1),
(1544,1,'primaryOwnerId','2025-10-09 16:42:54',0,1),
(1544,1,'slug','2025-10-09 16:42:54',0,1),
(1545,1,'primaryOwnerId','2025-10-09 16:42:54',0,1),
(1545,1,'slug','2025-10-09 16:42:54',0,1),
(1549,1,'primaryOwnerId','2025-10-09 17:05:50',0,1),
(1549,1,'slug','2025-10-09 17:05:50',0,1),
(1550,1,'primaryOwnerId','2025-10-09 17:05:50',0,1),
(1550,1,'slug','2025-10-09 17:05:50',0,1),
(1554,1,'primaryOwnerId','2025-10-09 17:10:15',0,1),
(1554,1,'slug','2025-10-09 17:10:15',0,1),
(1555,1,'primaryOwnerId','2025-10-09 17:10:15',0,1),
(1555,1,'slug','2025-10-09 17:10:15',0,1),
(1560,1,'primaryOwnerId','2025-10-09 17:20:39',0,1),
(1560,1,'slug','2025-10-09 17:20:39',0,1),
(1561,1,'primaryOwnerId','2025-10-09 17:20:39',0,1),
(1561,1,'slug','2025-10-09 17:20:39',0,1),
(1569,1,'primaryOwnerId','2025-10-09 17:24:35',0,1),
(1569,1,'slug','2025-10-09 17:24:35',0,1),
(1570,1,'primaryOwnerId','2025-10-09 17:24:35',0,1),
(1570,1,'slug','2025-10-09 17:24:35',0,1),
(1574,1,'primaryOwnerId','2025-10-09 17:29:43',0,1),
(1574,1,'slug','2025-10-09 17:29:43',0,1),
(1574,1,'title','2025-10-09 17:29:43',0,1),
(1577,1,'primaryOwnerId','2025-10-09 20:48:21',0,1),
(1577,1,'slug','2025-10-09 20:48:21',0,1),
(1577,1,'title','2025-10-09 20:48:21',0,1),
(1578,1,'primaryOwnerId','2025-10-09 20:48:21',0,1),
(1578,1,'slug','2025-10-09 20:48:21',0,1),
(1583,1,'primaryOwnerId','2025-10-09 20:56:04',0,1),
(1583,1,'slug','2025-10-09 20:56:04',0,1),
(1584,1,'primaryOwnerId','2025-10-09 20:56:04',0,1),
(1584,1,'slug','2025-10-09 20:56:04',0,1),
(1590,1,'primaryOwnerId','2025-10-13 16:02:33',0,1),
(1590,1,'slug','2025-10-13 16:02:33',0,1),
(1591,1,'primaryOwnerId','2025-10-13 16:02:33',0,1),
(1591,1,'slug','2025-10-13 16:02:33',0,1),
(1596,1,'primaryOwnerId','2025-10-13 16:04:07',0,1),
(1596,1,'slug','2025-10-13 16:04:07',0,1),
(1597,1,'primaryOwnerId','2025-10-13 16:04:07',0,1),
(1597,1,'slug','2025-10-13 16:04:07',0,1),
(1606,1,'primaryOwnerId','2025-10-13 16:15:51',0,1),
(1606,1,'slug','2025-10-13 16:15:51',0,1),
(1607,1,'primaryOwnerId','2025-10-13 16:15:51',0,1),
(1607,1,'slug','2025-10-13 16:15:51',0,1),
(1611,1,'primaryOwnerId','2025-10-13 16:43:47',0,1),
(1611,1,'slug','2025-10-13 16:43:47',0,1),
(1612,1,'primaryOwnerId','2025-10-13 16:43:47',0,1),
(1612,1,'slug','2025-10-13 16:43:47',0,1),
(1616,1,'primaryOwnerId','2025-10-13 17:09:47',0,1),
(1616,1,'slug','2025-10-13 17:09:47',0,1),
(1617,1,'primaryOwnerId','2025-10-13 17:09:47',0,1),
(1617,1,'slug','2025-10-13 17:09:47',0,1),
(1621,1,'primaryOwnerId','2025-10-13 17:23:02',0,1),
(1621,1,'slug','2025-10-13 17:23:02',0,1),
(1622,1,'primaryOwnerId','2025-10-13 17:23:02',0,1),
(1622,1,'slug','2025-10-13 17:23:02',0,1),
(1626,1,'primaryOwnerId','2025-10-13 17:28:26',0,1),
(1626,1,'slug','2025-10-13 17:28:26',0,1),
(1627,1,'primaryOwnerId','2025-10-13 17:28:26',0,1),
(1627,1,'slug','2025-10-13 17:28:26',0,1),
(1632,1,'primaryOwnerId','2025-10-13 17:43:34',0,1),
(1632,1,'slug','2025-10-13 17:43:34',0,1),
(1633,1,'primaryOwnerId','2025-10-13 17:43:34',0,1),
(1633,1,'slug','2025-10-13 17:43:34',0,1),
(1638,1,'primaryOwnerId','2025-10-13 17:47:19',0,1),
(1638,1,'slug','2025-10-13 17:46:38',0,1),
(1639,1,'primaryOwnerId','2025-10-13 17:47:19',0,1),
(1639,1,'slug','2025-10-13 17:46:38',0,1),
(1643,1,'primaryOwnerId','2025-10-13 17:52:01',0,1),
(1643,1,'slug','2025-10-13 17:52:01',0,1),
(1644,1,'primaryOwnerId','2025-10-13 17:52:01',0,1),
(1644,1,'slug','2025-10-13 17:52:01',0,1),
(1648,1,'primaryOwnerId','2025-10-13 17:57:28',0,1),
(1648,1,'slug','2025-10-13 17:57:28',0,1),
(1649,1,'primaryOwnerId','2025-10-13 17:57:28',0,1),
(1649,1,'slug','2025-10-13 17:57:28',0,1),
(1660,1,'primaryOwnerId','2025-10-13 18:02:09',0,1),
(1660,1,'slug','2025-10-13 18:02:09',0,1),
(1665,1,'primaryOwnerId','2025-10-13 19:10:27',0,1),
(1665,1,'slug','2025-10-13 19:10:27',0,1),
(1670,1,'primaryOwnerId','2025-10-13 19:24:55',0,1),
(1670,1,'slug','2025-10-13 19:24:55',0,1),
(1677,1,'primaryOwnerId','2025-10-13 19:30:02',0,1),
(1677,1,'slug','2025-10-13 19:30:02',0,1),
(1678,1,'primaryOwnerId','2025-10-13 19:30:02',0,1),
(1678,1,'slug','2025-10-13 19:30:02',0,1),
(1682,1,'primaryOwnerId','2025-10-13 19:34:44',0,1),
(1682,1,'slug','2025-10-13 19:34:44',0,1),
(1683,1,'primaryOwnerId','2025-10-13 19:34:44',0,1),
(1683,1,'slug','2025-10-13 19:34:44',0,1),
(1692,1,'primaryOwnerId','2025-10-13 19:39:32',0,1),
(1692,1,'slug','2025-10-13 19:39:32',0,1),
(1693,1,'primaryOwnerId','2025-10-13 19:39:32',0,1),
(1693,1,'slug','2025-10-13 19:39:32',0,1),
(1694,1,'primaryOwnerId','2025-10-13 19:47:44',0,1),
(1694,1,'slug','2025-10-13 19:47:44',0,1),
(1695,1,'primaryOwnerId','2025-10-13 19:47:44',0,1),
(1695,1,'slug','2025-10-13 19:47:44',0,1),
(1699,1,'primaryOwnerId','2025-10-14 16:49:14',0,1),
(1699,1,'slug','2025-10-14 16:49:14',0,1),
(1700,1,'primaryOwnerId','2025-10-14 16:49:14',0,1),
(1700,1,'slug','2025-10-14 16:49:14',0,1),
(1704,1,'primaryOwnerId','2025-10-14 16:53:18',0,1),
(1704,1,'slug','2025-10-14 16:53:18',0,1),
(1708,1,'primaryOwnerId','2025-10-14 16:56:56',0,1),
(1708,1,'slug','2025-10-14 16:56:56',0,1),
(1709,1,'primaryOwnerId','2025-10-14 16:56:56',0,1),
(1709,1,'slug','2025-10-14 16:56:56',0,1),
(1714,1,'primaryOwnerId','2025-10-14 17:00:06',0,1),
(1714,1,'slug','2025-10-14 17:00:06',0,1),
(1715,1,'primaryOwnerId','2025-10-14 17:00:06',0,1),
(1715,1,'slug','2025-10-14 17:00:06',0,1),
(1719,1,'primaryOwnerId','2025-10-14 17:05:13',0,1),
(1719,1,'slug','2025-10-14 17:05:13',0,1),
(1723,1,'primaryOwnerId','2025-10-14 17:09:21',0,1),
(1723,1,'slug','2025-10-14 17:09:21',0,1),
(1727,1,'primaryOwnerId','2025-10-14 17:12:18',0,1),
(1727,1,'slug','2025-10-14 17:12:18',0,1),
(1727,1,'title','2025-10-14 17:12:18',0,1),
(1728,1,'primaryOwnerId','2025-10-14 17:12:18',0,1),
(1728,1,'slug','2025-10-14 17:12:18',0,1),
(1732,1,'primaryOwnerId','2025-10-14 17:15:30',0,1),
(1732,1,'slug','2025-10-14 17:15:30',0,1),
(1737,1,'primaryOwnerId','2025-10-14 17:22:21',0,1),
(1737,1,'slug','2025-10-14 17:22:21',0,1),
(1738,1,'primaryOwnerId','2025-10-14 17:22:21',0,1),
(1738,1,'slug','2025-10-14 17:22:21',0,1),
(1742,1,'primaryOwnerId','2025-10-14 17:25:14',0,1),
(1742,1,'slug','2025-10-14 17:25:14',0,1),
(1743,1,'primaryOwnerId','2025-10-14 17:25:14',0,1),
(1743,1,'slug','2025-10-14 17:25:14',0,1),
(1747,1,'primaryOwnerId','2025-10-14 17:28:10',0,1),
(1747,1,'slug','2025-10-14 17:28:10',0,1),
(1748,1,'primaryOwnerId','2025-10-14 17:28:10',0,1),
(1748,1,'slug','2025-10-14 17:28:10',0,1),
(1835,1,'primaryOwnerId','2025-10-08 22:38:45',0,1),
(1835,1,'slug','2025-10-08 22:38:45',0,1),
(1835,1,'title','2025-10-08 22:38:45',0,1),
(1911,1,'primaryOwnerId','2025-10-14 13:43:52',0,1),
(1911,1,'slug','2025-10-14 13:43:52',0,1),
(1911,1,'title','2025-10-14 13:43:52',0,1),
(1935,1,'primaryOwnerId','2025-10-16 19:18:56',0,1),
(1935,1,'slug','2025-10-16 19:18:56',0,1),
(1935,1,'title','2025-10-16 19:18:56',0,1),
(1938,1,'primaryOwnerId','2025-10-16 19:21:39',0,1),
(1938,1,'slug','2025-10-16 19:21:39',0,1),
(1938,1,'title','2025-10-16 19:21:39',0,1),
(1941,1,'primaryOwnerId','2025-10-16 19:23:32',0,1),
(1941,1,'slug','2025-10-16 19:23:32',0,1),
(1941,1,'title','2025-10-16 19:23:32',0,1),
(2519,1,'postDate','2025-09-19 18:52:27',0,1),
(2519,1,'slug','2025-09-19 17:27:09',0,1),
(2519,1,'title','2025-09-19 17:25:35',0,1),
(2519,1,'uri','2025-09-19 17:27:09',0,1),
(2523,1,'postDate','2025-09-19 18:52:18',0,1),
(2523,1,'slug','2025-09-19 17:28:49',0,1),
(2523,1,'title','2025-09-19 17:28:49',0,1),
(2523,1,'uri','2025-09-19 17:28:49',0,1),
(2527,1,'postDate','2025-09-19 18:52:10',0,1),
(2527,1,'slug','2025-09-19 17:30:14',0,1),
(2527,1,'title','2025-09-19 17:30:14',0,1),
(2527,1,'uri','2025-09-19 17:30:14',0,1),
(2531,1,'enabled','2025-09-30 19:28:07',0,1),
(2531,1,'postDate','2025-09-19 18:51:56',0,1),
(2531,1,'slug','2025-09-19 17:32:33',0,1),
(2531,1,'title','2025-09-19 17:32:33',0,1),
(2531,1,'uri','2025-09-19 17:32:33',0,1),
(2535,1,'postDate','2025-09-19 18:51:46',0,1),
(2535,1,'slug','2025-09-19 17:34:59',0,1),
(2535,1,'title','2025-09-19 17:34:59',0,1),
(2535,1,'uri','2025-09-19 17:34:59',0,1),
(2537,1,'postDate','2025-09-19 18:53:35',0,1),
(2537,1,'slug','2025-09-19 17:37:13',0,1),
(2537,1,'title','2025-09-19 17:37:13',0,1),
(2537,1,'uri','2025-09-19 17:37:13',0,1),
(2553,1,'postDate','2025-09-19 18:50:13',0,1),
(2553,1,'slug','2025-09-19 18:50:13',0,1),
(2553,1,'title','2025-09-19 18:50:13',0,1),
(2555,1,'postDate','2025-09-19 18:50:15',0,1),
(2555,1,'slug','2025-09-19 18:50:15',0,1),
(2555,1,'status','2025-09-19 18:50:15',0,1),
(2555,1,'title','2025-09-19 18:50:15',0,1),
(2557,1,'postDate','2025-09-19 18:50:18',0,1),
(2557,1,'slug','2025-09-19 18:50:18',0,1),
(2557,1,'status','2025-09-19 18:50:18',0,1),
(2557,1,'title','2025-09-19 18:50:18',0,1),
(2559,1,'postDate','2025-09-19 18:50:27',0,1),
(2559,1,'slug','2025-09-19 18:50:27',0,1),
(2559,1,'status','2025-09-19 18:50:27',0,1),
(2559,1,'title','2025-09-19 18:50:27',0,1),
(2561,1,'postDate','2025-09-19 18:50:45',0,1),
(2561,1,'slug','2025-09-19 18:50:45',0,1),
(2561,1,'title','2025-09-19 18:50:45',0,1),
(2563,1,'postDate','2025-09-19 18:50:48',0,1),
(2563,1,'slug','2025-09-19 18:50:48',0,1),
(2563,1,'status','2025-09-19 18:50:48',0,1),
(2563,1,'title','2025-09-19 18:50:48',0,1),
(2565,1,'postDate','2025-09-19 18:50:50',0,1),
(2565,1,'slug','2025-09-19 18:50:50',0,1),
(2565,1,'status','2025-09-19 18:50:50',0,1),
(2565,1,'title','2025-09-19 18:50:50',0,1),
(2567,1,'postDate','2025-09-19 18:50:52',0,1),
(2567,1,'slug','2025-09-19 18:50:52',0,1),
(2567,1,'status','2025-09-19 18:50:52',0,1),
(2567,1,'title','2025-09-19 18:50:52',0,1),
(2569,1,'postDate','2025-09-19 18:50:55',0,1),
(2569,1,'slug','2025-09-19 18:50:55',0,1),
(2569,1,'status','2025-09-19 18:50:55',0,1),
(2569,1,'title','2025-09-19 18:50:55',0,1),
(2571,1,'postDate','2025-09-19 18:50:59',0,1),
(2571,1,'slug','2025-09-19 18:50:59',0,1),
(2571,1,'status','2025-09-19 18:50:59',0,1),
(2571,1,'title','2025-09-19 18:50:59',0,1),
(2573,1,'postDate','2025-09-19 18:51:03',0,1),
(2573,1,'slug','2025-09-19 18:51:03',0,1),
(2573,1,'status','2025-09-19 18:51:03',0,1),
(2573,1,'title','2025-09-19 18:51:03',0,1),
(2576,1,'postDate','2025-09-19 18:51:09',0,1),
(2576,1,'slug','2025-09-19 18:51:09',0,1),
(2576,1,'status','2025-09-19 18:51:09',0,1),
(2576,1,'title','2025-09-19 18:51:09',0,1),
(2590,1,'postDate','2025-09-19 18:53:29',0,1),
(2590,1,'slug','2025-09-19 18:52:40',0,1),
(2590,1,'title','2025-09-19 18:52:40',0,1),
(2590,1,'uri','2025-09-19 18:52:40',0,1),
(2596,1,'postDate','2025-09-19 19:06:52',0,1),
(2596,1,'slug','2025-09-19 19:06:50',0,1),
(2596,1,'title','2025-09-19 19:06:50',0,1),
(2598,1,'postDate','2025-09-19 19:06:57',0,1),
(2598,1,'slug','2025-09-19 19:06:57',0,1),
(2598,1,'status','2025-09-19 19:06:57',0,1),
(2598,1,'title','2025-09-19 19:06:57',0,1),
(2600,1,'postDate','2025-09-19 19:07:03',0,1),
(2600,1,'slug','2025-09-19 19:07:03',0,1),
(2600,1,'status','2025-09-19 19:07:03',0,1),
(2600,1,'title','2025-09-19 19:07:03',0,1),
(2602,1,'postDate','2025-09-19 19:07:09',0,1),
(2602,1,'slug','2025-09-19 19:07:09',0,1),
(2602,1,'status','2025-09-19 19:07:09',0,1),
(2602,1,'title','2025-09-19 19:07:09',0,1),
(2604,1,'postDate','2025-09-19 19:07:13',0,1),
(2604,1,'slug','2025-09-19 19:07:13',0,1),
(2604,1,'status','2025-09-19 19:07:13',0,1),
(2604,1,'title','2025-09-19 19:07:13',0,1),
(2606,1,'postDate','2025-09-19 19:07:17',0,1),
(2606,1,'slug','2025-09-19 19:07:17',0,1),
(2606,1,'status','2025-09-19 19:07:17',0,1),
(2606,1,'title','2025-09-19 19:07:17',0,1),
(2608,1,'postDate','2025-09-19 19:07:23',0,1),
(2608,1,'slug','2025-09-19 19:07:23',0,1),
(2608,1,'status','2025-09-19 19:07:23',0,1),
(2608,1,'title','2025-09-19 19:07:23',0,1),
(2610,1,'postDate','2025-09-19 19:07:27',0,1),
(2610,1,'slug','2025-09-19 19:07:27',0,1),
(2610,1,'status','2025-09-19 19:07:27',0,1),
(2610,1,'title','2025-09-19 19:07:27',0,1),
(2612,1,'postDate','2025-09-19 19:07:36',0,1),
(2612,1,'slug','2025-09-19 19:07:36',0,1),
(2612,1,'status','2025-09-19 19:07:36',0,1),
(2612,1,'title','2025-09-19 19:07:36',0,1),
(2614,1,'postDate','2025-09-19 19:07:44',0,1),
(2614,1,'slug','2025-09-19 19:07:44',0,1),
(2614,1,'status','2025-09-19 19:07:44',0,1),
(2614,1,'title','2025-09-19 19:07:44',0,1),
(2616,1,'postDate','2025-09-19 19:07:47',0,1),
(2616,1,'slug','2025-09-19 19:07:47',0,1),
(2616,1,'status','2025-09-19 19:07:47',0,1),
(2616,1,'title','2025-09-19 19:07:47',0,1),
(2618,1,'postDate','2025-09-19 19:07:49',0,1),
(2618,1,'slug','2025-09-19 19:07:49',0,1),
(2618,1,'status','2025-09-19 19:07:49',0,1),
(2618,1,'title','2025-09-19 19:07:49',0,1),
(2620,1,'postDate','2025-09-19 19:07:53',0,1),
(2620,1,'slug','2025-09-19 19:07:53',0,1),
(2620,1,'status','2025-09-19 19:07:53',0,1),
(2620,1,'title','2025-09-19 19:07:53',0,1),
(2622,1,'postDate','2025-09-19 19:07:55',0,1),
(2622,1,'slug','2025-09-19 19:07:55',0,1),
(2622,1,'status','2025-09-19 19:07:55',0,1),
(2622,1,'title','2025-09-19 19:07:55',0,1),
(2624,1,'postDate','2025-09-19 19:07:59',0,1),
(2624,1,'slug','2025-09-19 19:07:58',0,1),
(2624,1,'status','2025-09-19 19:07:59',0,1),
(2624,1,'title','2025-09-19 19:07:58',0,1),
(2712,1,'postDate','2025-09-22 18:33:07',0,1),
(2712,1,'slug','2025-09-22 18:33:59',0,1),
(2712,1,'title','2025-09-22 18:32:29',0,1),
(2712,1,'uri','2025-09-22 18:33:07',0,1),
(2720,1,'postDate','2025-09-22 18:35:27',0,1),
(2720,1,'slug','2025-09-22 18:35:58',0,1),
(2720,1,'title','2025-09-22 18:34:24',0,1),
(2720,1,'uri','2025-09-22 18:34:57',0,1),
(2785,1,'postDate','2025-09-23 20:43:48',0,1),
(2785,1,'slug','2025-09-23 20:43:48',0,1),
(2785,1,'status','2025-09-23 20:43:48',0,1),
(2785,1,'title','2025-09-23 20:43:48',0,1),
(2786,1,'postDate','2025-09-23 20:43:53',0,1),
(2786,1,'slug','2025-09-23 20:43:53',0,1),
(2786,1,'status','2025-09-23 20:43:53',0,1),
(2786,1,'title','2025-09-23 20:43:53',0,1),
(2787,1,'postDate','2025-09-23 20:44:13',0,1),
(2787,1,'slug','2025-09-23 20:44:12',0,1),
(2787,1,'status','2025-09-23 20:44:13',0,1),
(2787,1,'title','2025-09-23 20:44:12',0,1),
(2791,1,'primaryOwnerId','2025-09-30 22:41:39',0,1),
(2793,1,'primaryOwnerId','2025-09-30 22:46:11',0,1),
(2812,1,'postDate','2025-09-23 21:56:42',0,1),
(2812,1,'slug','2025-09-23 21:56:42',0,1),
(2812,1,'status','2025-09-23 21:56:42',0,1),
(2812,1,'title','2025-09-23 21:56:41',0,1),
(2813,1,'postDate','2025-09-23 21:56:57',0,1),
(2813,1,'slug','2025-09-23 21:56:57',0,1),
(2813,1,'status','2025-09-23 21:56:57',0,1),
(2813,1,'title','2025-09-23 21:56:57',0,1),
(2814,1,'postDate','2025-09-23 21:57:09',0,1),
(2814,1,'slug','2025-09-23 21:57:09',0,1),
(2814,1,'status','2025-09-23 21:57:09',0,1),
(2814,1,'title','2025-09-23 21:57:06',0,1),
(2815,1,'postDate','2025-09-23 21:57:19',0,1),
(2815,1,'slug','2025-09-23 21:57:19',0,1),
(2815,1,'status','2025-09-23 21:57:19',0,1),
(2815,1,'title','2025-09-23 21:57:19',0,1),
(2816,1,'postDate','2025-09-23 21:57:28',0,1),
(2816,1,'slug','2025-09-23 21:57:28',0,1),
(2816,1,'status','2025-09-23 21:57:28',0,1),
(2816,1,'title','2025-09-23 21:57:28',0,1),
(2817,1,'postDate','2025-09-23 21:57:37',0,1),
(2817,1,'slug','2025-09-23 21:57:37',0,1),
(2817,1,'status','2025-09-23 21:57:37',0,1),
(2817,1,'title','2025-09-23 21:57:37',0,1),
(2880,1,'postDate','2025-09-24 23:07:59',0,1),
(2880,1,'slug','2025-09-24 23:07:59',0,1),
(2880,1,'title','2025-09-24 23:06:38',0,1),
(2880,1,'uri','2025-09-24 23:07:59',0,1),
(2882,1,'postDate','2025-09-24 23:09:19',0,1),
(2882,1,'slug','2025-09-24 23:09:19',0,1),
(2882,1,'title','2025-09-24 23:08:27',0,1),
(2882,1,'uri','2025-09-24 23:09:19',0,1),
(2891,1,'postDate','2025-09-26 17:59:52',0,1),
(2891,1,'slug','2025-09-26 17:59:51',0,1),
(2891,1,'title','2025-09-26 17:59:51',0,1),
(2945,1,'primaryOwnerId','2025-09-30 22:45:57',0,1),
(2969,1,'postDate','2025-10-06 17:46:02',0,1),
(2969,1,'slug','2025-10-06 17:47:25',0,1),
(2969,1,'title','2025-10-06 17:47:25',0,1),
(2972,1,'postDate','2025-10-06 17:46:44',0,1),
(2972,1,'slug','2025-10-08 18:21:43',0,1),
(2972,1,'title','2025-10-08 18:21:43',0,1),
(2974,1,'postDate','2025-10-06 17:47:00',0,1),
(2974,1,'slug','2025-10-09 16:34:57',0,1),
(2974,1,'title','2025-10-09 16:34:57',0,1),
(3016,1,'slug','2025-10-08 18:22:24',0,1),
(3016,1,'title','2025-10-08 18:22:24',0,1),
(3025,1,'postDate','2025-10-08 18:35:41',0,1),
(3025,1,'slug','2025-10-08 18:35:37',0,1),
(3025,1,'title','2025-10-08 18:35:20',0,1),
(3027,1,'postDate','2025-10-08 18:36:16',0,1),
(3027,1,'slug','2025-10-08 18:36:15',0,1),
(3027,1,'title','2025-10-08 18:36:11',0,1),
(3091,1,'postDate','2025-10-08 18:55:24',0,1),
(3091,1,'slug','2025-10-08 18:55:24',0,1),
(3091,1,'title','2025-10-08 18:55:22',0,1),
(3093,1,'postDate','2025-10-08 18:55:51',0,1),
(3093,1,'slug','2025-10-08 18:55:51',0,1),
(3093,1,'title','2025-10-08 18:55:50',0,1),
(3123,1,'postDate','2025-10-08 19:54:15',0,1),
(3123,1,'slug','2025-10-08 19:54:15',0,1),
(3123,1,'title','2025-10-08 19:54:15',0,1),
(3189,1,'title','2025-10-23 01:16:23',0,1),
(3190,1,'title','2025-10-23 01:16:40',0,1),
(3191,1,'title','2025-10-23 01:15:28',0,1),
(3192,1,'postDate','2025-10-08 22:18:56',0,1),
(3192,1,'slug','2025-10-08 22:18:54',0,1),
(3192,1,'title','2025-10-08 22:18:54',0,1),
(3194,1,'postDate','2025-10-08 22:18:59',0,1),
(3194,1,'slug','2025-10-08 22:18:59',0,1),
(3194,1,'status','2025-10-08 22:18:59',0,1),
(3194,1,'title','2025-10-08 22:18:59',0,1),
(3196,1,'postDate','2025-10-08 22:19:01',0,1),
(3196,1,'slug','2025-10-08 22:19:01',0,1),
(3196,1,'status','2025-10-08 22:19:01',0,1),
(3196,1,'title','2025-10-08 22:19:01',0,1),
(3198,1,'postDate','2025-10-08 22:19:04',0,1),
(3198,1,'slug','2025-10-08 22:19:04',0,1),
(3198,1,'status','2025-10-08 22:19:04',0,1),
(3198,1,'title','2025-10-08 22:19:04',0,1),
(3200,1,'postDate','2025-10-08 22:19:06',0,1),
(3200,1,'slug','2025-10-08 22:19:06',0,1),
(3200,1,'status','2025-10-08 22:19:06',0,1),
(3200,1,'title','2025-10-08 22:19:06',0,1),
(3202,1,'postDate','2025-10-08 22:19:10',0,1),
(3202,1,'slug','2025-10-08 22:19:10',0,1),
(3202,1,'status','2025-10-08 22:19:10',0,1),
(3202,1,'title','2025-10-08 22:19:10',0,1),
(3204,1,'postDate','2025-10-08 22:19:13',0,1),
(3204,1,'slug','2025-10-08 22:19:13',0,1),
(3204,1,'status','2025-10-08 22:19:13',0,1),
(3204,1,'title','2025-10-08 22:19:13',0,1),
(3206,1,'postDate','2025-10-08 22:19:15',0,1),
(3206,1,'slug','2025-10-08 22:19:15',0,1),
(3206,1,'status','2025-10-08 22:19:15',0,1),
(3206,1,'title','2025-10-08 22:19:15',0,1),
(3208,1,'postDate','2025-10-08 22:19:18',0,1),
(3208,1,'slug','2025-10-08 22:19:18',0,1),
(3208,1,'status','2025-10-08 22:19:18',0,1),
(3208,1,'title','2025-10-08 22:19:18',0,1),
(3210,1,'postDate','2025-10-08 22:19:21',0,1),
(3210,1,'slug','2025-10-08 22:19:21',0,1),
(3210,1,'status','2025-10-08 22:19:21',0,1),
(3210,1,'title','2025-10-08 22:19:21',0,1),
(3468,1,'postDate','2025-10-09 16:33:43',0,1),
(3468,1,'slug','2025-10-09 16:33:43',0,1),
(3468,1,'title','2025-10-09 16:33:42',0,1),
(3697,1,'postDate','2025-10-09 20:46:21',0,1),
(3697,1,'slug','2025-10-09 20:46:15',0,1),
(3697,1,'title','2025-10-09 20:46:15',0,1),
(4403,1,'postDate','2025-10-14 16:52:36',0,1),
(4403,1,'slug','2025-10-14 16:52:36',0,1),
(4403,1,'title','2025-10-14 16:52:35',0,1);
/*!40000 ALTER TABLE `changedattributes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedfields`
--

LOCK TABLES `changedfields` WRITE;
/*!40000 ALTER TABLE `changedfields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `changedfields` VALUES
(2,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:29',0,1),
(2,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-23 01:34:07',0,1),
(2,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:29',0,1),
(2,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:29',0,1),
(2,1,5,'b2903903-6010-4012-bc8c-c8c21f059638','2025-04-18 18:32:48',0,1),
(2,1,6,'85dc9325-7c30-405d-9715-22e9294f7735','2025-04-18 17:33:58',0,1),
(2,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:29',0,1),
(2,1,8,'20f5fa3c-80d5-481b-862d-599d54f0fd29','2025-04-18 17:33:58',0,1),
(2,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-17 19:37:16',0,1),
(2,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-22 20:41:13',0,1),
(2,1,11,'d26c0574-65df-44ac-815a-723f6a2599ad','2025-04-18 18:17:53',0,1),
(2,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:29',0,1),
(2,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:29',0,1),
(2,1,14,'702dab28-10e4-44a1-9271-72e0eda7fa6e','2025-04-18 17:33:58',0,1),
(2,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:29',0,1),
(2,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:29',0,1),
(2,1,16,'7270a303-7119-43a8-b9bb-8360964189de','2025-04-18 18:45:07',0,1),
(2,1,17,'2bdc1e0d-4fd6-448b-b82c-71a75241bd23','2025-04-18 18:28:56',0,1),
(2,1,19,'0783e761-d312-48eb-a4f3-02333736ad99','2025-04-18 18:29:57',0,1),
(2,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:29',0,1),
(2,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-19 19:10:35',0,1),
(2,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:29',0,1),
(2,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:29',0,1),
(2,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:29',0,1),
(2,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-17 19:37:16',0,1),
(2,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-26 18:00:58',0,1),
(2,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:29',0,1),
(2,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:29',0,1),
(2,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:29',0,1),
(2,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:29',0,1),
(2,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:29',0,1),
(2,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-23 21:59:36',0,1),
(2,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:29',0,1),
(2,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:29',0,1),
(2,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:29',0,1),
(2,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2025-09-30 22:46:11',0,1),
(18,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:06:46',0,1),
(20,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:06:58',0,1),
(22,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:07:05',0,1),
(24,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:07:29',0,1),
(26,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:07:37',0,1),
(28,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:07:43',0,1),
(30,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:07:48',0,1),
(32,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:07:53',0,1),
(34,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:08:00',0,1),
(36,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:08:04',0,1),
(36,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-08-20 21:57:06',0,1),
(44,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-08-20 21:24:25',0,1),
(44,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-09-03 22:27:30',0,1),
(44,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-08-20 21:24:25',0,1),
(56,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-03 21:05:58',0,1),
(56,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-03 21:05:58',0,1),
(57,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-03 21:05:58',0,1),
(57,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-03 21:05:58',0,1),
(63,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-03 21:08:08',0,1),
(63,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-03 21:05:58',0,1),
(111,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-04-18 18:38:37',0,1),
(113,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-04-18 18:38:45',0,1),
(115,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-04-18 18:38:50',0,1),
(117,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-04-18 18:38:55',0,1),
(119,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-04-18 18:39:00',0,1),
(121,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-04-18 18:39:04',0,1),
(283,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-07-30 21:07:17',0,1),
(283,1,35,'6507c83d-4852-4bbd-9fee-2e10673e660b','2025-07-30 21:07:24',0,1),
(283,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-07-30 21:07:13',0,1),
(283,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-07-30 22:48:02',0,1),
(283,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-07-30 21:07:13',0,1),
(288,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-07-30 22:58:03',0,1),
(290,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-07-30 22:58:06',0,1),
(292,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-07-30 22:58:10',0,1),
(294,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-05 20:01:55',0,1),
(325,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:06:11',0,1),
(325,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:06:11',0,1),
(348,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:06:20',0,1),
(348,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:06:20',0,1),
(350,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:06:39',0,1),
(350,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:06:40',0,1),
(352,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:07:24',0,1),
(352,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:07:20',0,1),
(354,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:07:34',0,1),
(354,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:07:30',0,1),
(356,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:07:46',0,1),
(356,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:07:43',0,1),
(358,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:07:57',0,1),
(358,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:07:54',0,1),
(360,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:08:07',0,1),
(360,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:08:05',0,1),
(362,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:08:17',0,1),
(362,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:08:15',0,1),
(364,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:08:28',0,1),
(364,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:08:27',0,1),
(366,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:09:00',0,1),
(366,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:08:55',0,1),
(368,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:09:11',0,1),
(368,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:09:07',0,1),
(370,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:09:32',0,1),
(370,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:09:20',0,1),
(372,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:09:44',0,1),
(372,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:09:41',0,1),
(374,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:09:56',0,1),
(374,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:09:52',0,1),
(376,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:10:07',0,1),
(376,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:10:05',0,1),
(378,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:10:17',0,1),
(378,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:10:15',0,1),
(380,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:10:23',0,1),
(380,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:10:27',0,1),
(382,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:10:52',0,1),
(382,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:10:50',0,1),
(384,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:11:03',0,1),
(384,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:11:01',0,1),
(386,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:11:16',0,1),
(386,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:11:08',0,1),
(388,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:11:27',0,1),
(388,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:11:26',0,1),
(390,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:11:47',0,1),
(390,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:11:43',0,1),
(392,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:12:01',0,1),
(392,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:11:55',0,1),
(394,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:12:13',0,1),
(394,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:12:10',0,1),
(396,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:12:23',0,1),
(396,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:12:21',0,1),
(398,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:12:31',0,1),
(398,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:12:33',0,1),
(400,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:12:56',0,1),
(400,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:12:53',0,1),
(402,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:13:06',0,1),
(402,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:13:03',0,1),
(404,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:13:19',0,1),
(404,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:13:13',0,1),
(406,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:13:30',0,1),
(406,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:13:26',0,1),
(408,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:13:42',0,1),
(408,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:13:37',0,1),
(410,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:13:52',0,1),
(410,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:13:49',0,1),
(412,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:14:03',0,1),
(412,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:13:59',0,1),
(414,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:14:11',0,1),
(414,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:14:09',0,1),
(445,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-09-03 22:27:30',0,1),
(453,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-08-20 21:57:20',0,1),
(455,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-08-20 21:57:31',0,1),
(457,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:25:31',0,1),
(459,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:25:08',0,1),
(459,1,69,'89752275-60b9-4b61-9143-06d0fc3bb511','2025-09-23 21:13:19',0,1),
(461,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:25:25',0,1),
(463,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:25:37',0,1),
(465,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:25:47',0,1),
(465,1,69,'89752275-60b9-4b61-9143-06d0fc3bb511','2025-09-23 21:13:37',0,1),
(467,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:25:55',0,1),
(469,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:26:04',0,1),
(471,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:26:11',0,1),
(473,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-08-20 22:00:22',0,1),
(475,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:26:26',0,1),
(477,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:26:34',0,1),
(479,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:26:42',0,1),
(481,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:26:54',0,1),
(483,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:27:03',0,1),
(485,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:27:13',0,1),
(487,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:29:02',0,1),
(487,1,69,'89752275-60b9-4b61-9143-06d0fc3bb511','2025-09-23 21:13:50',0,1),
(489,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:29:09',0,1),
(491,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:29:17',0,1),
(493,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-08-20 22:02:28',0,1),
(495,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:29:38',0,1),
(497,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-19 19:22:04',0,1),
(497,1,69,'89752275-60b9-4b61-9143-06d0fc3bb511','2025-09-23 21:13:43',0,1),
(555,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-09-02 22:24:44',0,1),
(557,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-09-02 22:24:51',0,1),
(559,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-09-02 22:24:59',0,1),
(561,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-09-02 22:25:02',0,1),
(563,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-09-02 22:25:06',0,1),
(601,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-09-03 21:49:20',0,1),
(601,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-03 20:24:31',0,1),
(603,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-09-03 21:48:44',0,1),
(605,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-09-03 21:58:30',0,1),
(605,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-03 20:24:40',0,1),
(617,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-09-03 21:57:10',0,1),
(617,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-03 20:24:49',0,1),
(945,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:29',0,1),
(945,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 16:13:46',0,1),
(945,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:29',0,1),
(945,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:29',0,1),
(945,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-06 17:50:00',0,1),
(945,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:29',0,1),
(945,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-06 17:50:00',0,1),
(945,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:29',0,1),
(945,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:29',0,1),
(945,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:29',0,1),
(945,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-06 17:50:00',0,1),
(945,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:29',0,1),
(945,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-06 17:50:49',0,1),
(945,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:29',0,1),
(945,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:29',0,1),
(945,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:29',0,1),
(945,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:29',0,1),
(945,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:29',0,1),
(945,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:29',0,1),
(945,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:29',0,1),
(945,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:29',0,1),
(945,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:29',0,1),
(945,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:29',0,1),
(945,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-06 17:51:32',0,1),
(945,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:29',0,1),
(945,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:29',0,1),
(945,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:29',0,1),
(945,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2025-10-06 17:52:05',0,1),
(951,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 17:36:50',0,1),
(951,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-10 18:22:39',0,1),
(951,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:29',0,1),
(951,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:29',0,1),
(951,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:29',0,1),
(951,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 22:21:46',0,1),
(951,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 22:28:53',0,1),
(951,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:29',0,1),
(951,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:29',0,1),
(951,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:29',0,1),
(951,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 22:28:53',0,1),
(951,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:29',0,1),
(951,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:29',0,1),
(951,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:29',0,1),
(951,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 17:36:50',0,1),
(951,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:29',0,1),
(951,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:29',0,1),
(951,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:29',0,1),
(951,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:29',0,1),
(951,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:29',0,1),
(951,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:29',0,1),
(951,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:29',0,1),
(951,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:29',0,1),
(951,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 22:28:53',0,1),
(951,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-10-08 22:29:34',0,1),
(951,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:29',0,1),
(951,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:29',0,1),
(951,1,72,'c67c0ac3-ce5c-4eb0-b6c1-86c68413a548','2025-10-10 18:22:39',0,1),
(957,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:29',0,1),
(957,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 22:20:19',0,1),
(957,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:29',0,1),
(957,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:29',0,1),
(957,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-08 18:36:38',0,1),
(957,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 18:43:12',0,1),
(957,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 18:39:34',0,1),
(957,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:29',0,1),
(957,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:29',0,1),
(957,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:29',0,1),
(957,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 18:36:38',0,1),
(957,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:29',0,1),
(957,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 18:43:12',0,1),
(957,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 18:43:12',0,1),
(957,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:29',0,1),
(957,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:29',0,1),
(957,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-08 18:43:12',0,1),
(957,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:29',0,1),
(957,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:29',0,1),
(957,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:29',0,1),
(957,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-10-08 18:17:50',0,1),
(957,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:29',0,1),
(957,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:29',0,1),
(957,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:29',0,1),
(957,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:29',0,1),
(957,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:29',0,1),
(957,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:29',0,1),
(963,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:29',0,1),
(963,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 18:52:55',0,1),
(963,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:29',0,1),
(963,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:29',0,1),
(963,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-08 18:46:53',0,1),
(963,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 18:52:55',0,1),
(963,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 18:48:30',0,1),
(963,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:29',0,1),
(963,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:29',0,1),
(963,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:29',0,1),
(963,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 18:46:53',0,1),
(963,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:29',0,1),
(963,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 18:50:11',0,1),
(963,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 18:50:11',0,1),
(963,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:29',0,1),
(963,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:29',0,1),
(963,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-08 18:52:55',0,1),
(963,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-10-08 18:50:11',0,1),
(963,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:29',0,1),
(963,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:29',0,1),
(963,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:29',0,1),
(963,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:29',0,1),
(963,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:29',0,1),
(963,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 18:50:11',0,1),
(963,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:29',0,1),
(963,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:29',0,1),
(963,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:29',0,1),
(969,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(969,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 19:00:47',0,1),
(969,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(969,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(969,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-08 18:56:08',0,1),
(969,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 19:00:47',0,1),
(969,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 18:57:34',0,1),
(969,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(969,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(969,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(969,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 18:56:08',0,1),
(969,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(969,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 18:59:33',0,1),
(969,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 18:59:33',0,1),
(969,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(969,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(969,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-08 19:00:47',0,1),
(969,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(969,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(969,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(969,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(969,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(969,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(969,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:30',0,1),
(969,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(969,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(969,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(975,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(975,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 19:59:16',0,1),
(975,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(975,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(975,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-08 19:54:50',0,1),
(975,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 19:59:16',0,1),
(975,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 19:59:16',0,1),
(975,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(975,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(975,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(975,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 19:54:50',0,1),
(975,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(975,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 19:59:16',0,1),
(975,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 19:59:16',0,1),
(975,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(975,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(975,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-08 19:59:16',0,1),
(975,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(975,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(975,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(975,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(975,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(975,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(975,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 19:59:16',0,1),
(975,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(975,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(975,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(981,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(981,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 20:26:02',0,1),
(981,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(981,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(981,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-08 20:22:54',0,1),
(981,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 20:25:58',0,1),
(981,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 20:24:41',0,1),
(981,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(981,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(981,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(981,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 20:22:54',0,1),
(981,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(981,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 20:24:41',0,1),
(981,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 20:24:42',0,1),
(981,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(981,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(981,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-08 20:25:58',0,1),
(981,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(981,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(981,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(981,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(981,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(981,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(981,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 20:25:58',0,1),
(981,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(981,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(981,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(989,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(989,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-09 15:36:03',0,1),
(989,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(989,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(989,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-09 14:50:00',0,1),
(989,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-09 14:59:55',0,1),
(989,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-09 14:52:39',0,1),
(989,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(989,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(989,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(989,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-09 14:50:00',0,1),
(989,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(989,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-09 14:53:20',0,1),
(989,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-09 14:53:20',0,1),
(989,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(989,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(989,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-09 14:59:55',0,1),
(989,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(989,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(989,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(989,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(989,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(989,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(989,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-09 14:54:48',0,1),
(989,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(989,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(989,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(995,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(995,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-09 16:31:32',0,1),
(995,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(995,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(995,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-09 16:25:17',0,1),
(995,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-09 16:31:32',0,1),
(995,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-09 16:25:17',0,1),
(995,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(995,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(995,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(995,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-09 16:25:17',0,1),
(995,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(995,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-09 16:25:17',0,1),
(995,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-09 16:25:17',0,1),
(995,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(995,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(995,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:30',0,1),
(995,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(995,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(995,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(995,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(995,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(995,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(995,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-09 16:30:48',0,1),
(995,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(995,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(995,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(999,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(999,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 16:14:34',0,1),
(999,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(999,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(999,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-09 16:34:59',0,1),
(999,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-14 16:14:34',0,1),
(999,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-09 16:36:27',0,1),
(999,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(999,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(999,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(999,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-09 16:34:59',0,1),
(999,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(999,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-09 16:36:52',0,1),
(999,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:30',0,1),
(999,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(999,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(999,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-14 16:14:34',0,1),
(999,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(999,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(999,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(999,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(999,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(999,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(999,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:30',0,1),
(999,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(999,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(999,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(1005,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(1005,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-09 16:42:58',0,1),
(1005,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(1005,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(1005,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-09 16:40:04',0,1),
(1005,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-09 16:42:55',0,1),
(1005,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-09 16:42:02',0,1),
(1005,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(1005,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(1005,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(1005,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-09 16:40:04',0,1),
(1005,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(1005,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-09 16:42:02',0,1),
(1005,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-09 16:42:02',0,1),
(1005,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(1005,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(1005,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-09 16:42:55',0,1),
(1005,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(1005,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(1005,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(1005,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(1005,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(1005,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(1005,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-09 16:42:55',0,1),
(1005,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(1005,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(1005,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(1011,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(1011,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-09 17:05:54',0,1),
(1011,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(1011,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(1011,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-09 17:04:12',0,1),
(1011,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-09 17:05:50',0,1),
(1011,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-09 17:04:12',0,1),
(1011,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(1011,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(1011,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(1011,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-09 17:04:12',0,1),
(1011,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(1011,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-09 17:04:34',0,1),
(1011,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-09 17:04:34',0,1),
(1011,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(1011,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(1011,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-09 17:05:50',0,1),
(1011,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(1011,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(1011,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(1011,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(1011,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(1011,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(1011,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-09 17:05:50',0,1),
(1011,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(1011,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(1011,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(1017,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(1017,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-09 17:10:32',0,1),
(1017,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(1017,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(1017,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-09 17:07:55',0,1),
(1017,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-09 17:10:15',0,1),
(1017,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-09 17:09:21',0,1),
(1017,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(1017,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(1017,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(1017,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-09 17:07:55',0,1),
(1017,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(1017,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-09 17:09:46',0,1),
(1017,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-09 17:09:46',0,1),
(1017,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(1017,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(1017,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-09 17:10:15',0,1),
(1017,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(1017,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(1017,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(1017,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(1017,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(1017,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(1017,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:30',0,1),
(1017,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(1017,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(1017,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(1023,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1023,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-09 17:20:39',0,1),
(1023,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1023,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1023,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-09 17:15:09',0,1),
(1023,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-09 17:20:39',0,1),
(1023,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-09 17:19:43',0,1),
(1023,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1023,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1023,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1023,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-09 17:15:09',0,1),
(1023,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1023,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-09 17:20:03',0,1),
(1023,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-09 17:20:03',0,1),
(1023,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1023,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1023,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-09 17:20:39',0,1),
(1023,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1023,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1023,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1023,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1023,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1023,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1023,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-09 17:20:39',0,1),
(1023,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1023,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1023,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1031,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1031,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:31',0,1),
(1031,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1031,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1031,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:31',0,1),
(1031,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:31',0,1),
(1031,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1031,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1031,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1031,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1031,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1031,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1031,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1031,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:31',0,1),
(1031,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1031,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1031,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1031,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1031,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1031,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1031,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1031,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1031,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1031,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1031,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1031,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1031,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1035,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1035,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-09 17:24:37',0,1),
(1035,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1035,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1035,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-09 17:22:03',0,1),
(1035,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-09 17:24:35',0,1),
(1035,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-09 17:23:33',0,1),
(1035,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1035,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1035,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1035,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-09 17:22:03',0,1),
(1035,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1035,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-09 17:23:52',0,1),
(1035,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-09 17:23:52',0,1),
(1035,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1035,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1035,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-09 17:24:35',0,1),
(1035,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1035,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1035,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1035,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1035,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1035,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1035,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-09 17:24:35',0,1),
(1035,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1035,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1035,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1041,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1041,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-09 17:29:43',0,1),
(1041,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1041,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1041,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-09 17:26:18',0,1),
(1041,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-09 17:29:43',0,1),
(1041,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-09 17:27:46',0,1),
(1041,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1041,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1041,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1041,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1041,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1041,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-09 17:28:11',0,1),
(1041,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-09 17:26:18',0,1),
(1041,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1041,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1041,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1041,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1041,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1041,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1041,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1041,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1041,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1041,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-09 17:29:43',0,1),
(1041,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1041,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1041,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1045,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1045,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-09 20:48:21',0,1),
(1045,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1045,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1045,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-09 20:44:20',0,1),
(1045,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-09 20:48:21',0,1),
(1045,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-09 20:46:26',0,1),
(1045,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1045,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1045,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1045,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-09 20:44:20',0,1),
(1045,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1045,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-09 20:46:26',0,1),
(1045,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-09 20:46:26',0,1),
(1045,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1045,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1045,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-09 20:48:21',0,1),
(1045,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-10-09 20:46:26',0,1),
(1045,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1045,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1045,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1045,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1045,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1045,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-09 20:48:21',0,1),
(1045,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1045,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1045,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1051,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1051,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-09 20:56:04',0,1),
(1051,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1051,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1051,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-09 20:52:58',0,1),
(1051,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-09 20:56:04',0,1),
(1051,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-09 20:54:28',0,1),
(1051,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1051,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1051,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1051,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-09 20:52:58',0,1),
(1051,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1051,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-09 20:54:48',0,1),
(1051,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-09 20:54:48',0,1),
(1051,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1051,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1051,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-09 20:56:04',0,1),
(1051,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1051,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1051,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1051,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1051,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1051,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1051,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-09 20:56:04',0,1),
(1051,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1051,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1051,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1059,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1059,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 16:02:37',0,1),
(1059,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1059,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1059,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 15:58:54',0,1),
(1059,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 16:02:33',0,1),
(1059,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 16:00:23',0,1),
(1059,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1059,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1059,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1059,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 15:58:54',0,1),
(1059,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1059,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 16:00:53',0,1),
(1059,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 16:00:53',0,1),
(1059,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1059,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1059,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 16:02:33',0,1),
(1059,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-10-13 16:00:53',0,1),
(1059,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1059,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1059,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1059,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1059,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1059,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-13 16:01:41',0,1),
(1059,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1059,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1059,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1067,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1067,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 16:08:14',0,1),
(1067,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1067,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1067,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 16:07:23',0,1),
(1067,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 16:04:07',0,1),
(1067,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 16:07:23',0,1),
(1067,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1067,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1067,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1067,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 16:07:23',0,1),
(1067,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1067,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 16:07:45',0,1),
(1067,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 16:07:45',0,1),
(1067,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1067,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1067,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 16:04:07',0,1),
(1067,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1067,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1067,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1067,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1067,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1067,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1067,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-13 16:07:23',0,1),
(1067,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1067,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1067,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1073,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1073,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:31',0,1),
(1073,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1073,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1073,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:31',0,1),
(1073,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:31',0,1),
(1073,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1073,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1073,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1073,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1073,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1073,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1073,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1073,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:31',0,1),
(1073,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1073,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1073,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1073,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1073,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1073,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1073,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1073,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1073,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1073,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1073,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1073,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1073,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1079,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1079,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 16:15:51',0,1),
(1079,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1079,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1079,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 16:12:15',0,1),
(1079,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 16:15:51',0,1),
(1079,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 16:13:49',0,1),
(1079,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1079,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1079,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1079,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1079,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1079,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 16:14:30',0,1),
(1079,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 16:14:30',0,1),
(1079,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1079,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1079,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 16:15:51',0,1),
(1079,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1079,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1079,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1079,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1079,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1079,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1079,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-13 16:15:51',0,1),
(1079,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1079,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1079,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1085,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1085,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 16:43:51',0,1),
(1085,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1085,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1085,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 16:41:23',0,1),
(1085,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 16:43:47',0,1),
(1085,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 16:43:20',0,1),
(1085,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1085,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1085,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1085,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 16:41:23',0,1),
(1085,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1085,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 16:43:20',0,1),
(1085,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 16:43:20',0,1),
(1085,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1085,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1085,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 16:43:47',0,1),
(1085,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1085,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1085,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1085,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1085,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1085,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1085,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-13 16:43:20',0,1),
(1085,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1085,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1085,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1091,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1091,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 17:05:41',0,1),
(1091,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1091,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1091,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 17:05:16',0,1),
(1091,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 17:09:47',0,1),
(1091,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 17:05:16',0,1),
(1091,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1091,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1091,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1091,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 17:05:16',0,1),
(1091,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1091,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 17:05:41',0,1),
(1091,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 17:05:41',0,1),
(1091,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1091,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1091,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 17:09:47',0,1),
(1091,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-10-13 17:05:41',0,1),
(1091,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1091,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1091,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1091,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1091,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1091,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-13 17:09:47',0,1),
(1091,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1091,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1091,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1097,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1097,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 17:23:02',0,1),
(1097,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1097,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1097,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 17:20:17',0,1),
(1097,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 17:23:02',0,1),
(1097,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 17:21:33',0,1),
(1097,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1097,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1097,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1097,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 17:20:17',0,1),
(1097,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1097,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 17:22:18',0,1),
(1097,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 17:22:18',0,1),
(1097,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1097,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1097,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 17:23:02',0,1),
(1097,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1097,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1097,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1097,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1097,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1097,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1097,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-13 17:22:18',0,1),
(1097,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1097,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1097,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1103,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1103,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 17:28:26',0,1),
(1103,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1103,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1103,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 17:27:27',0,1),
(1103,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 17:28:26',0,1),
(1103,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 17:27:27',0,1),
(1103,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1103,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1103,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1103,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 17:27:27',0,1),
(1103,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1103,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 17:27:45',0,1),
(1103,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 17:27:45',0,1),
(1103,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1103,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1103,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 17:28:26',0,1),
(1103,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1103,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1103,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1103,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1103,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1103,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1103,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1103,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1103,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1103,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1109,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1109,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 17:43:34',0,1),
(1109,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1109,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1109,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 17:42:06',0,1),
(1109,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 17:43:34',0,1),
(1109,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 17:42:06',0,1),
(1109,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1109,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1109,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1109,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 17:42:06',0,1),
(1109,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1109,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 17:42:25',0,1),
(1109,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 17:42:25',0,1),
(1109,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1109,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1109,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 17:43:34',0,1),
(1109,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1109,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1109,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1109,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1109,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1109,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1109,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-13 17:43:34',0,1),
(1109,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1109,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1109,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1117,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1117,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 17:46:53',0,1),
(1117,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1117,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1117,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 17:46:38',0,1),
(1117,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 17:47:19',0,1),
(1117,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 17:46:38',0,1),
(1117,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1117,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1117,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1117,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 17:46:38',0,1),
(1117,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1117,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 17:46:53',0,1),
(1117,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 17:46:53',0,1),
(1117,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1117,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1117,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 17:47:19',0,1),
(1117,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1117,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1117,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1117,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1117,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1117,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1117,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1117,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1117,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1117,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1123,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1123,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 17:53:11',0,1),
(1123,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1123,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1123,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 17:48:10',0,1),
(1123,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 17:52:01',0,1),
(1123,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 17:49:38',0,1),
(1123,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1123,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1123,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1123,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 17:53:11',0,1),
(1123,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1123,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 17:49:38',0,1),
(1123,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 17:49:38',0,1),
(1123,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1123,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1123,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 17:52:01',0,1),
(1123,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1123,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1123,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1123,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1123,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1123,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1123,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-13 17:52:01',0,1),
(1123,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1123,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1123,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1129,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1129,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 17:57:28',0,1),
(1129,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1129,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1129,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 17:55:52',0,1),
(1129,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 17:57:28',0,1),
(1129,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 17:55:52',0,1),
(1129,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1129,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1129,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1129,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 17:55:52',0,1),
(1129,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1129,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 17:56:22',0,1),
(1129,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 17:56:22',0,1),
(1129,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1129,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1129,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 17:57:28',0,1),
(1129,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-10-13 17:56:22',0,1),
(1129,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1129,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1129,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1129,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1129,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1129,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1129,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1129,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1129,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1135,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1135,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:32',0,1),
(1135,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1135,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1135,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:32',0,1),
(1135,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:32',0,1),
(1135,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:32',0,1),
(1135,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1135,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1135,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1135,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:32',0,1),
(1135,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1135,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:32',0,1),
(1135,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:32',0,1),
(1135,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1135,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1135,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:32',0,1),
(1135,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1135,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1135,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1135,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1135,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1135,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1135,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1135,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1135,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1135,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1141,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 18:51:21',0,1),
(1141,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 19:22:03',0,1),
(1141,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 18:51:21',0,1),
(1141,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 18:51:21',0,1),
(1141,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 18:51:21',0,1),
(1141,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 18:51:21',0,1),
(1141,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 18:51:21',0,1),
(1141,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 18:51:21',0,1),
(1141,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 18:51:21',0,1),
(1141,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 18:51:21',0,1),
(1141,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 18:51:21',0,1),
(1141,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 18:51:21',0,1),
(1141,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 18:51:21',0,1),
(1141,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 18:51:21',0,1),
(1141,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 18:51:21',0,1),
(1141,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 18:51:21',0,1),
(1141,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 18:51:21',0,1),
(1141,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 18:51:21',0,1),
(1141,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 18:51:21',0,1),
(1141,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 18:51:21',0,1),
(1141,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 18:51:21',0,1),
(1141,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 18:51:21',0,1),
(1141,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 18:51:21',0,1),
(1141,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 18:51:21',0,1),
(1141,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 18:51:21',0,1),
(1141,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 18:51:21',0,1),
(1143,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1143,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 18:02:09',0,1),
(1143,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1143,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1143,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 17:58:05',0,1),
(1143,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 18:02:09',0,1),
(1143,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 17:59:22',0,1),
(1143,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1143,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1143,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1143,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 18:02:09',0,1),
(1143,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1143,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 17:59:22',0,1),
(1143,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 17:59:22',0,1),
(1143,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1143,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1143,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 18:02:09',0,1),
(1143,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1143,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1143,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1143,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1143,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1143,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1143,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-13 18:00:02',0,1),
(1143,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1143,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1143,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1149,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 18:51:21',0,1),
(1149,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 19:09:29',0,1),
(1149,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 18:51:21',0,1),
(1149,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 18:51:21',0,1),
(1149,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 19:09:10',0,1),
(1149,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 19:10:27',0,1),
(1149,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 19:09:10',0,1),
(1149,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 18:51:21',0,1),
(1149,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 18:51:21',0,1),
(1149,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 18:51:21',0,1),
(1149,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 19:09:10',0,1),
(1149,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 18:51:21',0,1),
(1149,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 19:09:29',0,1),
(1149,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 19:09:29',0,1),
(1149,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 18:51:21',0,1),
(1149,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 18:51:21',0,1),
(1149,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 19:10:27',0,1),
(1149,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 18:51:21',0,1),
(1149,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 18:51:21',0,1),
(1149,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-10-13 19:03:49',0,1),
(1149,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 18:51:21',0,1),
(1149,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 18:51:21',0,1),
(1149,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 18:51:21',0,1),
(1149,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 18:51:21',0,1),
(1149,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 18:51:21',0,1),
(1149,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 18:51:21',0,1),
(1155,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1155,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 19:24:55',0,1),
(1155,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1155,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1155,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 19:14:26',0,1),
(1155,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 19:24:55',0,1),
(1155,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 19:16:05',0,1),
(1155,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1155,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1155,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1155,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 19:14:26',0,1),
(1155,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1155,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 19:16:05',0,1),
(1155,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 19:16:05',0,1),
(1155,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1155,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1155,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 19:24:55',0,1),
(1155,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1155,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1155,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-10-13 19:11:14',0,1),
(1155,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1155,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1155,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1155,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-13 19:24:55',0,1),
(1155,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1155,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1155,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1161,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1161,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:33',0,1),
(1161,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1161,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1161,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:33',0,1),
(1161,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:33',0,1),
(1161,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:33',0,1),
(1161,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1161,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1161,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1161,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:33',0,1),
(1161,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1161,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:33',0,1),
(1161,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:33',0,1),
(1161,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1161,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1161,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:33',0,1),
(1161,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1161,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1161,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1161,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1161,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1161,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1161,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1161,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1161,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1161,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1165,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1165,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 19:30:06',0,1),
(1165,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1165,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1165,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 19:27:41',0,1),
(1165,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 19:30:03',0,1),
(1165,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 19:29:00',0,1),
(1165,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1165,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1165,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1165,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 19:27:41',0,1),
(1165,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1165,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 19:29:19',0,1),
(1165,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 19:29:19',0,1),
(1165,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1165,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1165,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 19:30:03',0,1),
(1165,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1165,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1165,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1165,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1165,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1165,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1165,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1165,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1165,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1165,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1171,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1171,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 19:30:40',0,1),
(1171,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1171,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1171,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 19:30:40',0,1),
(1171,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 19:34:44',0,1),
(1171,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 19:31:57',0,1),
(1171,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1171,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1171,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1171,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 19:34:44',0,1),
(1171,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1171,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 19:31:57',0,1),
(1171,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 19:31:57',0,1),
(1171,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1171,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1171,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 19:34:44',0,1),
(1171,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1171,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1171,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1171,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1171,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1171,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1171,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-13 19:34:44',0,1),
(1171,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1171,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1171,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1177,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1177,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 19:39:32',0,1),
(1177,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1177,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1177,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 19:37:45',0,1),
(1177,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 19:39:32',0,1),
(1177,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 19:37:45',0,1),
(1177,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1177,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1177,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1177,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 19:37:45',0,1),
(1177,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1177,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 19:37:58',0,1),
(1177,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 19:37:58',0,1),
(1177,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1177,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-29 18:35:28',0,1),
(1177,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 19:39:32',0,1),
(1177,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1177,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1177,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1177,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1177,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1177,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1177,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-13 19:39:00',0,1),
(1177,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1177,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-29 18:35:55',0,1),
(1177,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1185,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1185,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 19:51:31',0,1),
(1185,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1185,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1185,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-13 19:47:44',0,1),
(1185,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-13 19:47:44',0,1),
(1185,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-13 19:51:09',0,1),
(1185,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1185,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1185,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1185,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-13 19:47:44',0,1),
(1185,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1185,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-13 19:51:31',0,1),
(1185,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-13 19:47:44',0,1),
(1185,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1185,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1185,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-13 19:47:44',0,1),
(1185,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1185,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1185,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1185,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1185,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1185,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1185,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1185,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1185,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1185,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1191,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1191,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 16:49:14',0,1),
(1191,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1191,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1191,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-14 16:48:02',0,1),
(1191,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-14 16:49:14',0,1),
(1191,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-14 16:48:02',0,1),
(1191,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1191,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1191,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1191,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-14 16:48:02',0,1),
(1191,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1191,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-14 16:48:25',0,1),
(1191,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-14 16:48:25',0,1),
(1191,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1191,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1191,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-14 16:49:14',0,1),
(1191,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1191,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1191,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1191,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1191,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1191,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1191,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1191,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1191,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1191,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1197,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1197,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 16:53:18',0,1),
(1197,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1197,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1197,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-14 16:52:02',0,1),
(1197,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-14 16:53:18',0,1),
(1197,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-14 16:52:02',0,1),
(1197,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1197,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1197,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1197,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-14 16:52:02',0,1),
(1197,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1197,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-14 16:52:41',0,1),
(1197,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-14 16:52:41',0,1),
(1197,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1197,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1197,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:33',0,1),
(1197,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-10-14 16:52:41',0,1),
(1197,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1197,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1197,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1197,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1197,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1197,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-14 16:53:18',0,1),
(1197,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1197,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1197,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1201,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1201,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 16:56:57',0,1),
(1201,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1201,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1201,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-14 16:55:56',0,1),
(1201,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-14 16:56:57',0,1),
(1201,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-14 16:55:56',0,1),
(1201,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1201,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1201,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1201,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-14 16:55:56',0,1),
(1201,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1201,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-14 16:56:22',0,1),
(1201,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-14 16:56:22',0,1),
(1201,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1201,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1201,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-14 16:56:57',0,1),
(1201,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-10-14 16:56:22',0,1),
(1201,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1201,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1201,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1201,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1201,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1201,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1201,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1201,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1201,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1209,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1209,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 17:00:06',0,1),
(1209,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1209,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1209,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-14 16:59:11',0,1),
(1209,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-14 17:00:06',0,1),
(1209,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-14 16:59:11',0,1),
(1209,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1209,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1209,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1209,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-14 16:59:11',0,1),
(1209,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1209,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-14 16:59:36',0,1),
(1209,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-14 16:59:36',0,1),
(1209,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1209,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1209,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-14 17:00:06',0,1),
(1209,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-10-14 16:59:36',0,1),
(1209,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1209,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1209,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1209,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1209,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1209,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1209,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1209,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1209,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1215,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1215,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 17:05:13',0,1),
(1215,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1215,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1215,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-14 17:01:41',0,1),
(1215,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-14 17:05:13',0,1),
(1215,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-14 17:02:50',0,1),
(1215,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1215,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1215,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1215,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-14 17:01:41',0,1),
(1215,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1215,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-14 17:04:31',0,1),
(1215,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-14 17:04:31',0,1),
(1215,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1215,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1215,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:34',0,1),
(1215,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1215,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1215,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1215,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1215,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1215,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1215,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-14 17:05:13',0,1),
(1215,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1215,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1215,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1219,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1219,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 17:09:21',0,1),
(1219,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1219,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1219,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-14 17:08:27',0,1),
(1219,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-14 17:09:21',0,1),
(1219,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-14 17:08:27',0,1),
(1219,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1219,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1219,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1219,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-14 17:08:27',0,1),
(1219,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1219,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-14 17:09:21',0,1),
(1219,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-14 17:09:21',0,1),
(1219,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1219,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1219,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-14 17:09:21',0,1),
(1219,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1219,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1219,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1219,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1219,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1219,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1219,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1219,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1219,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1219,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1225,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1225,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 17:12:18',0,1),
(1225,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1225,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1225,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-14 17:10:19',0,1),
(1225,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-14 17:12:18',0,1),
(1225,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-14 17:11:27',0,1),
(1225,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1225,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1225,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1225,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-14 17:10:19',0,1),
(1225,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1225,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-14 17:11:44',0,1),
(1225,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-14 17:11:44',0,1),
(1225,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1225,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1225,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-14 17:12:18',0,1),
(1225,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1225,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1225,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1225,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1225,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1225,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1225,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1225,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1225,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1225,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1231,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1231,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 17:15:30',0,1),
(1231,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1231,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1231,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-14 17:15:30',0,1),
(1231,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-14 17:15:30',0,1),
(1231,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-14 17:15:30',0,1),
(1231,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1231,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1231,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1231,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-14 17:15:30',0,1),
(1231,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1231,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-14 17:15:30',0,1),
(1231,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-14 17:15:30',0,1),
(1231,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1231,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1231,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-14 17:15:30',0,1),
(1231,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1231,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1231,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1231,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1231,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1231,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1231,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1231,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1231,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1231,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1237,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1237,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 17:22:21',0,1),
(1237,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1237,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1237,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-14 17:21:05',0,1),
(1237,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-14 17:22:21',0,1),
(1237,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-14 17:21:05',0,1),
(1237,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1237,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1237,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1237,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-14 17:21:05',0,1),
(1237,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1237,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-14 17:21:31',0,1),
(1237,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-14 17:21:31',0,1),
(1237,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1237,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1237,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-14 17:22:21',0,1),
(1237,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1237,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1237,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1237,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1237,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1237,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1237,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-14 17:22:21',0,1),
(1237,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1237,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1237,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1243,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1243,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 17:25:14',0,1),
(1243,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1243,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1243,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-14 17:25:14',0,1),
(1243,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-14 17:25:14',0,1),
(1243,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-14 17:25:14',0,1),
(1243,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1243,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1243,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1243,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-14 17:25:14',0,1),
(1243,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1243,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-14 17:25:14',0,1),
(1243,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-14 17:25:14',0,1),
(1243,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1243,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1243,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-14 17:25:14',0,1),
(1243,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1243,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1243,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1243,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1243,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1243,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1243,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-14 17:25:14',0,1),
(1243,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1243,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1243,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1249,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1249,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 17:28:10',0,1),
(1249,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1249,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1249,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-14 17:27:21',0,1),
(1249,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-14 17:28:10',0,1),
(1249,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-14 17:27:21',0,1),
(1249,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1249,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1249,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1249,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-14 17:27:21',0,1),
(1249,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1249,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-14 17:27:21',0,1),
(1249,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-14 17:27:21',0,1),
(1249,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1249,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1249,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-14 17:28:10',0,1),
(1249,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-10-14 17:27:21',0,1),
(1249,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1249,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1249,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1249,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1249,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1249,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-14 17:28:10',0,1),
(1249,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1249,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1249,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1255,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1255,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 22:20:05',0,1),
(1255,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1255,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1255,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:34',0,1),
(1255,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:34',0,1),
(1255,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:34',0,1),
(1255,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1255,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1255,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1255,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:34',0,1),
(1255,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1255,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-25 02:15:57',0,1),
(1255,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:34',0,1),
(1255,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1255,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1255,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:34',0,1),
(1255,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1255,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1255,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1255,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1255,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1255,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1255,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1255,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1255,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1255,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1261,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1261,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:34',0,1),
(1261,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1261,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1261,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:34',0,1),
(1261,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:34',0,1),
(1261,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:34',0,1),
(1261,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1261,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1261,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1261,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:34',0,1),
(1261,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1261,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:34',0,1),
(1261,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:34',0,1),
(1261,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1261,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1261,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:34',0,1),
(1261,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1261,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1261,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1261,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1261,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1261,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1261,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1261,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1261,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1261,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1269,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1269,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1269,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1269,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1269,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1269,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1269,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1269,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1269,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1269,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1269,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1269,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1269,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1269,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1269,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1269,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1269,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1269,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1269,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1269,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1269,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1269,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1269,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1269,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1269,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1269,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1269,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1277,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1277,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1277,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1277,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1277,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1277,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1277,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1277,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1277,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1277,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1277,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1277,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1277,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1277,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1277,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1277,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1277,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1277,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1277,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1277,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1277,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1277,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1277,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1277,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1277,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1277,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1277,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1283,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1283,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:42:35',0,1),
(1283,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1283,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1283,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1283,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1283,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1283,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1283,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1283,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1283,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1283,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1283,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1283,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1283,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1283,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1283,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1283,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1283,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1283,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1283,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1283,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1283,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1283,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1283,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1283,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1283,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1289,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1289,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1289,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1289,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1289,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1289,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1289,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1289,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1289,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1289,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1289,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1289,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1289,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1289,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1289,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1289,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1289,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1289,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1289,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1289,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1289,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1289,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1289,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1289,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1289,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1289,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1289,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1297,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1297,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1297,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1297,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1297,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1297,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1297,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1297,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1297,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1297,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1297,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1297,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1297,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1297,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1297,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1297,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1297,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1297,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1297,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1297,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1297,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1297,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1297,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1297,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1297,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1297,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1297,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1303,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1303,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1303,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1303,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1303,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1303,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1303,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1303,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1303,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1303,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1303,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1303,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1303,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1303,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1303,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1303,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1303,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1303,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1303,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1303,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1303,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1303,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1303,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1303,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1303,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1303,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1303,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1309,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1309,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1309,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1309,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1309,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1309,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1309,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1309,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1309,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1309,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1309,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1309,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1309,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1309,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1309,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1309,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1309,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1309,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1309,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1309,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1309,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1309,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1309,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1309,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1309,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1309,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1309,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1315,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1315,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1315,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1315,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1315,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1315,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1315,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1315,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1315,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1315,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1315,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1315,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1315,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1315,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1315,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1315,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1315,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1315,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1315,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1315,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1315,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1315,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1315,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1315,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1315,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1315,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1315,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1323,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1323,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1323,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1323,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1323,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1323,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1323,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1323,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1323,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1323,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1323,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1323,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1323,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1323,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1323,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1323,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1323,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1323,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1323,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1323,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1323,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1323,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1323,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1323,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1323,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1323,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1323,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1329,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:36',0,1),
(1329,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:36',0,1),
(1329,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1329,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:36',0,1),
(1329,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1329,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1329,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1329,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1329,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1329,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1329,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1329,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1329,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1329,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1329,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1329,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1329,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1329,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1329,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1329,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1329,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1329,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1329,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1329,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1329,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1329,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1329,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1337,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:36',0,1),
(1337,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:36',0,1),
(1337,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1337,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:36',0,1),
(1337,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1337,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1337,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1337,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1337,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1337,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1337,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1337,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1337,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1337,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1337,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1337,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1337,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1337,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1337,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1337,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1337,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1337,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1337,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1337,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1337,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1337,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1337,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1343,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:36',0,1),
(1343,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:36',0,1),
(1343,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1343,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:36',0,1),
(1343,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1343,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1343,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1343,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1343,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1343,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1343,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1343,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1343,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1343,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1343,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1343,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1343,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1343,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1343,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1343,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1343,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1343,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1343,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1343,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1343,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1343,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1343,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1349,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:36',0,1),
(1349,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:36',0,1),
(1349,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1349,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:36',0,1),
(1349,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1349,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1349,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1349,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1349,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1349,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1349,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1349,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1349,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1349,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1349,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1349,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1349,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1349,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1349,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1349,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1349,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1349,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1349,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1349,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1349,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1349,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1349,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1353,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:03:40',0,1),
(1353,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-10 18:22:08',0,1),
(1353,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1353,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:20:10',0,1),
(1353,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-08 22:40:25',0,1),
(1353,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 22:38:45',0,1),
(1353,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 22:38:17',0,1),
(1353,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1353,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1353,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1353,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 22:41:35',0,1),
(1353,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1353,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 22:40:25',0,1),
(1353,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 22:40:25',0,1),
(1353,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:03:40',0,1),
(1353,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1353,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1353,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1353,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1353,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1353,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1353,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1353,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-10-08 22:41:35',0,1),
(1353,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 22:38:17',0,1),
(1353,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-10-08 22:41:35',0,1),
(1353,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1353,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1353,1,72,'c67c0ac3-ce5c-4eb0-b6c1-86c68413a548','2025-10-10 18:22:08',0,1),
(1359,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:03:22',0,1),
(1359,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:20:33',0,1),
(1359,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1359,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:20:33',0,1),
(1359,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1359,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1359,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1359,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1359,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1359,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1359,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1359,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1359,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1359,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1359,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:03:22',0,1),
(1359,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1359,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1359,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1359,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1359,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1359,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1359,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1359,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1359,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1359,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1359,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1359,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1365,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:20:52',0,1),
(1365,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:20:52',0,1),
(1365,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-22 18:20:52',0,1),
(1365,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:20:52',0,1),
(1365,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-22 18:20:52',0,1),
(1365,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1365,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1365,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-22 18:20:52',0,1),
(1365,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-22 18:20:52',0,1),
(1365,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-22 18:20:52',0,1),
(1365,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-22 18:20:52',0,1),
(1365,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-22 18:20:52',0,1),
(1365,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-22 18:20:52',0,1),
(1365,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-22 18:20:52',0,1),
(1365,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:20:52',0,1),
(1365,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-22 18:20:52',0,1),
(1365,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1365,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-22 18:20:52',0,1),
(1365,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-22 18:20:52',0,1),
(1365,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-22 18:20:52',0,1),
(1365,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-22 18:20:52',0,1),
(1365,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-22 18:20:52',0,1),
(1365,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1365,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1365,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-22 18:20:52',0,1),
(1365,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-22 18:20:52',0,1),
(1365,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-22 18:20:52',0,1),
(1371,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:04:46',0,1),
(1371,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:21:35',0,1),
(1371,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1371,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:21:35',0,1),
(1371,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1371,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1371,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1371,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1371,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1371,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1371,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1371,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1371,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1371,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1371,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1371,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1371,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1371,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1371,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1371,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1371,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1371,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1371,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1371,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1371,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1371,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1371,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1377,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:06:29',0,1),
(1377,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:22:06',0,1),
(1377,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1377,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:22:06',0,1),
(1377,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1377,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1377,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1377,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1377,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1377,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1377,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1377,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1377,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1377,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1377,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1377,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1377,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1377,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1377,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1377,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1377,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1377,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1377,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1377,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1377,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1377,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1377,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1383,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:06:50',0,1),
(1383,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:22:45',0,1),
(1383,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1383,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:22:45',0,1),
(1383,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1383,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1383,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1383,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1383,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1383,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1383,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1383,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1383,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1383,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1383,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1383,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1383,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1383,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1383,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1383,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1383,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1383,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1383,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1383,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1383,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1383,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1383,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1389,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:07:16',0,1),
(1389,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:23:02',0,1),
(1389,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1389,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:23:02',0,1),
(1389,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1389,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1389,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1389,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1389,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1389,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1389,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1389,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1389,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1389,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1389,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:37',0,1),
(1389,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1389,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1389,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1389,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1389,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1389,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1389,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1389,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1389,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1389,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1389,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1389,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1395,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:08:00',0,1),
(1395,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-29 18:59:03',0,1),
(1395,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1395,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:21:16',0,1),
(1395,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1395,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1395,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1395,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1395,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1395,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1395,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1395,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1395,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1395,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1395,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:08:00',0,1),
(1395,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1395,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1395,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1395,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1395,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1395,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1395,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1395,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1395,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1395,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1395,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1395,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1401,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:08:33',0,1),
(1401,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:22:29',0,1),
(1401,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1401,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:22:29',0,1),
(1401,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1401,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1401,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1401,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1401,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1401,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1401,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1401,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1401,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1401,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1401,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:08:33',0,1),
(1401,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1401,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1401,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1401,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1401,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1401,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1401,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1401,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1401,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1401,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1401,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1401,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1407,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:08:56',0,1),
(1407,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:23:24',0,1),
(1407,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1407,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:23:24',0,1),
(1407,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1407,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1407,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1407,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1407,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1407,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1407,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1407,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1407,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1407,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1407,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:37',0,1),
(1407,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1407,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1407,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1407,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1407,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1407,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1407,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1407,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1407,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1407,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1407,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1407,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1413,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:09:23',0,1),
(1413,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:18:15',0,1),
(1413,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1413,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:18:15',0,1),
(1413,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1413,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1413,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1413,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1413,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1413,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1413,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1413,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1413,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1413,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1413,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:09:23',0,1),
(1413,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1413,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1413,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1413,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1413,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1413,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1413,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1413,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1413,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1413,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1413,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1413,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1419,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:37',0,1),
(1419,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:37',0,1),
(1419,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1419,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:37',0,1),
(1419,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1419,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1419,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1419,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1419,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1419,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1419,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1419,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1419,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1419,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1419,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:37',0,1),
(1419,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1419,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1419,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1419,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1419,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1419,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1419,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1419,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1419,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1419,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1419,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1419,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1425,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:37',0,1),
(1425,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:37',0,1),
(1425,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1425,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:37',0,1),
(1425,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1425,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1425,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1425,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1425,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1425,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1425,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1425,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1425,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1425,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1425,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:37',0,1),
(1425,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1425,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1425,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1425,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1425,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1425,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1425,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1425,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1425,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1425,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1425,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1425,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1431,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:37',0,1),
(1431,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:37',0,1),
(1431,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1431,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:37',0,1),
(1431,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1431,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1431,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1431,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1431,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1431,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1431,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1431,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1431,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1431,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1431,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:37',0,1),
(1431,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1431,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1431,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1431,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1431,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1431,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1431,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1431,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1431,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1431,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1431,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1431,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1437,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-10-22 18:20:15',0,1),
(1437,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-23 01:33:57',0,1),
(1437,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1437,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:37',0,1),
(1437,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1437,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1437,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1437,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1437,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1437,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1437,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1437,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1437,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1437,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1437,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-10-22 18:20:15',0,1),
(1437,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1437,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1437,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1437,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1437,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1437,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1437,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1437,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1437,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1437,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1437,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1437,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1437,1,73,'d87be94b-4936-41d7-917a-18a2f21b2582','2025-10-22 23:46:58',0,1),
(1443,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1443,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-14 13:43:52',0,1),
(1443,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1443,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1443,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1443,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1443,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1443,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1443,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1443,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1443,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1443,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1443,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1443,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1443,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1443,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1443,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-14 13:43:52',0,1),
(1443,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1443,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1443,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1443,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1443,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1443,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1443,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1443,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1443,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1443,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1449,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1449,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:38',0,1),
(1449,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1449,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1449,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1449,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1449,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1449,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1449,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1449,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1449,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1449,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1449,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1449,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1449,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1449,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1449,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:38',0,1),
(1449,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1449,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1449,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1449,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1449,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1449,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1449,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1449,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1449,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1449,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1455,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1455,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:38',0,1),
(1455,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1455,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1455,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1455,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1455,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1455,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1455,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1455,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1455,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1455,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1455,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1455,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1455,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1455,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1455,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:38',0,1),
(1455,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1455,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1455,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1455,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1455,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1455,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1455,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1455,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1455,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1455,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1461,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1461,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:38',0,1),
(1461,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1461,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1461,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1461,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1461,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1461,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1461,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1461,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1461,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1461,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1461,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1461,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1461,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1461,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1461,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:38',0,1),
(1461,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1461,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1461,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1461,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1461,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1461,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1461,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1461,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1461,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1461,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1467,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1467,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:38',0,1),
(1467,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1467,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1467,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1467,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1467,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1467,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1467,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1467,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1467,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1467,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1467,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1467,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1467,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1467,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1467,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:38',0,1),
(1467,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1467,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1467,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1467,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1467,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1467,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1467,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1467,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1467,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1467,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1473,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1473,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-16 19:18:57',0,1),
(1473,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1473,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1473,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-16 19:16:56',0,1),
(1473,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-16 19:18:57',0,1),
(1473,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1473,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1473,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1473,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1473,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1473,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1473,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-16 19:18:57',0,1),
(1473,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-16 19:18:57',0,1),
(1473,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1473,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1473,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-16 19:18:57',0,1),
(1473,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1473,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1473,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-10-16 19:16:00',0,1),
(1473,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1473,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-10-16 19:16:00',0,1),
(1473,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1473,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1473,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1473,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1473,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1477,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1477,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-16 19:21:39',0,1),
(1477,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1477,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1477,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-16 19:19:52',0,1),
(1477,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-16 19:21:39',0,1),
(1477,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1477,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1477,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1477,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1477,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1477,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1477,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-16 19:20:30',0,1),
(1477,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-16 19:20:30',0,1),
(1477,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1477,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1477,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-16 19:21:39',0,1),
(1477,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-10-16 19:20:30',0,1),
(1477,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1477,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-10-16 19:19:28',0,1),
(1477,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1477,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-10-16 19:19:28',0,1),
(1477,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1477,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1477,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1477,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1477,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1481,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1481,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-16 19:23:32',0,1),
(1481,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1481,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1481,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-16 19:22:21',0,1),
(1481,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-16 19:23:32',0,1),
(1481,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1481,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1481,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1481,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1481,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1481,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1481,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-16 19:22:51',0,1),
(1481,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-16 19:22:51',0,1),
(1481,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1481,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1481,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-16 19:23:32',0,1),
(1481,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1481,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1481,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-10-16 19:22:12',0,1),
(1481,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1481,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-10-16 19:22:12',0,1),
(1481,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1481,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1481,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1481,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1481,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1486,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-09-17 19:37:16',0,1),
(1487,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-09-17 19:37:16',0,1),
(1499,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-08 22:21:46',0,1),
(1504,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 18:43:12',0,1),
(1504,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-08 18:43:12',0,1),
(1504,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-08 18:43:12',0,1),
(1505,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 18:43:12',0,1),
(1509,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 18:52:55',0,1),
(1509,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-08 18:52:55',0,1),
(1510,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 18:52:55',0,1),
(1510,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-08 18:52:55',0,1),
(1514,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 19:00:47',0,1),
(1514,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-08 19:00:47',0,1),
(1515,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 19:00:47',0,1),
(1519,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 19:59:16',0,1),
(1519,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-08 19:59:16',0,1),
(1520,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 19:59:16',0,1),
(1520,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-08 19:59:16',0,1),
(1525,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 20:25:58',0,1),
(1525,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-08 20:25:58',0,1),
(1526,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 20:25:58',0,1),
(1526,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-08 20:25:58',0,1),
(1531,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 14:59:55',0,1),
(1531,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-09 14:59:55',0,1),
(1531,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-09 14:59:55',0,1),
(1532,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 14:59:55',0,1),
(1532,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-09 14:59:55',0,1),
(1536,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 16:31:32',0,1),
(1536,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-09 16:31:32',0,1),
(1539,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 16:14:34',0,1),
(1539,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-14 16:14:34',0,1),
(1539,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-14 16:14:34',0,1),
(1540,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 16:14:34',0,1),
(1540,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-14 16:14:34',0,1),
(1544,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 16:42:54',0,1),
(1544,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-09 16:42:54',0,1),
(1545,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 16:42:54',0,1),
(1549,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 17:05:50',0,1),
(1549,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-09 17:05:50',0,1),
(1550,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 17:05:50',0,1),
(1554,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 17:10:15',0,1),
(1554,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-09 17:10:15',0,1),
(1555,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 17:10:15',0,1),
(1560,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 17:20:39',0,1),
(1560,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-09 17:20:39',0,1),
(1561,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 17:20:39',0,1),
(1569,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 17:24:35',0,1),
(1569,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-09 17:24:35',0,1),
(1570,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 17:24:35',0,1),
(1570,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-09 17:24:35',0,1),
(1574,1,20,'2b573339-79e1-4bb1-82cf-7c0dfabcab22','2025-10-09 17:29:43',0,1),
(1574,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 17:29:43',0,1),
(1574,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-09 17:29:43',0,1),
(1577,1,20,'2b573339-79e1-4bb1-82cf-7c0dfabcab22','2025-10-09 20:48:21',0,1),
(1577,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 20:48:21',0,1),
(1577,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-09 20:48:21',0,1),
(1577,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-09 20:48:21',0,1),
(1578,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 20:48:21',0,1),
(1578,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-09 20:48:21',0,1),
(1583,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 20:56:04',0,1),
(1583,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-09 20:56:04',0,1),
(1583,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-09 20:56:04',0,1),
(1584,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-09 20:56:04',0,1),
(1584,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-09 20:56:04',0,1),
(1590,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 16:02:33',0,1),
(1590,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 16:02:33',0,1),
(1591,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 16:02:33',0,1),
(1596,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 16:04:07',0,1),
(1596,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 16:04:07',0,1),
(1596,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 16:04:07',0,1),
(1597,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 16:04:07',0,1),
(1597,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 16:04:07',0,1),
(1606,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 16:15:51',0,1),
(1606,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 16:15:51',0,1),
(1606,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 16:15:51',0,1),
(1607,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 16:15:51',0,1),
(1607,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 16:15:51',0,1),
(1611,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 16:43:47',0,1),
(1611,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 16:43:47',0,1),
(1612,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 16:43:47',0,1),
(1616,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:09:47',0,1),
(1616,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 17:09:47',0,1),
(1616,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 17:09:47',0,1),
(1617,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:09:47',0,1),
(1617,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 17:09:47',0,1),
(1621,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:23:02',0,1),
(1621,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 17:23:02',0,1),
(1622,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:23:02',0,1),
(1622,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 17:23:02',0,1),
(1626,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:28:26',0,1),
(1626,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 17:28:26',0,1),
(1627,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:28:26',0,1),
(1627,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 17:28:26',0,1),
(1632,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:43:34',0,1),
(1632,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 17:43:34',0,1),
(1632,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 17:43:34',0,1),
(1633,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:43:34',0,1),
(1633,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 17:43:34',0,1),
(1638,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:47:19',0,1),
(1638,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 17:46:38',0,1),
(1638,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 17:47:19',0,1),
(1639,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:47:19',0,1),
(1639,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 17:46:38',0,1),
(1643,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:52:01',0,1),
(1643,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 17:52:01',0,1),
(1644,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:52:01',0,1),
(1644,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 17:52:01',0,1),
(1648,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:57:28',0,1),
(1648,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 17:57:28',0,1),
(1649,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 17:57:28',0,1),
(1649,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 17:57:28',0,1),
(1660,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 18:02:09',0,1),
(1660,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 18:02:09',0,1),
(1665,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 19:10:27',0,1),
(1670,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 19:24:55',0,1),
(1670,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 19:24:55',0,1),
(1677,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 19:30:02',0,1),
(1677,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 19:30:02',0,1),
(1678,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 19:30:02',0,1),
(1678,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-13 19:30:02',0,1),
(1682,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 19:34:44',0,1),
(1682,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 19:34:44',0,1),
(1683,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 19:34:44',0,1),
(1692,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 19:39:32',0,1),
(1692,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 19:39:32',0,1),
(1693,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 19:39:32',0,1),
(1694,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 19:47:44',0,1),
(1694,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-13 19:47:44',0,1),
(1695,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-13 19:47:44',0,1),
(1699,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 16:49:14',0,1),
(1699,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-14 16:49:14',0,1),
(1700,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 16:49:14',0,1),
(1704,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 16:53:18',0,1),
(1704,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-14 16:53:18',0,1),
(1708,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 16:56:56',0,1),
(1708,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-14 16:56:56',0,1),
(1709,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 16:56:56',0,1),
(1714,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:00:06',0,1),
(1714,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-14 17:00:06',0,1),
(1715,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:00:06',0,1),
(1719,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:05:13',0,1),
(1719,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-14 17:05:13',0,1),
(1723,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:09:21',0,1),
(1723,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-14 17:09:21',0,1),
(1727,1,20,'2b573339-79e1-4bb1-82cf-7c0dfabcab22','2025-10-14 17:12:18',0,1),
(1727,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:12:18',0,1),
(1727,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-14 17:12:18',0,1),
(1728,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:12:18',0,1),
(1732,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:15:30',0,1),
(1732,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-14 17:15:30',0,1),
(1737,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:22:21',0,1),
(1737,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-14 17:22:21',0,1),
(1737,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-14 17:22:21',0,1),
(1738,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:22:21',0,1),
(1742,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:25:14',0,1),
(1742,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-14 17:25:14',0,1),
(1743,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:25:14',0,1),
(1743,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-14 17:25:14',0,1),
(1747,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:28:10',0,1),
(1747,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-14 17:28:10',0,1),
(1748,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 17:28:10',0,1),
(1835,1,20,'2b573339-79e1-4bb1-82cf-7c0dfabcab22','2025-10-08 22:38:45',0,1),
(1835,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 22:38:45',0,1),
(1911,1,20,'2b573339-79e1-4bb1-82cf-7c0dfabcab22','2025-10-14 13:43:52',0,1),
(1911,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-14 13:43:52',0,1),
(1911,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-14 13:43:52',0,1),
(1935,1,20,'2b573339-79e1-4bb1-82cf-7c0dfabcab22','2025-10-16 19:18:56',0,1),
(1935,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-16 19:18:56',0,1),
(1938,1,20,'2b573339-79e1-4bb1-82cf-7c0dfabcab22','2025-10-16 19:21:39',0,1),
(1938,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-16 19:21:39',0,1),
(1941,1,20,'2b573339-79e1-4bb1-82cf-7c0dfabcab22','2025-10-16 19:23:32',0,1),
(1941,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-16 19:23:32',0,1),
(2519,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:52:27',0,1),
(2519,1,35,'6507c83d-4852-4bbd-9fee-2e10673e660b','2025-09-19 17:27:31',0,1),
(2519,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 17:25:45',0,1),
(2519,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-24 19:41:47',0,1),
(2519,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 17:26:58',0,1),
(2523,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:52:18',0,1),
(2523,1,35,'6507c83d-4852-4bbd-9fee-2e10673e660b','2025-09-19 17:29:09',0,1),
(2523,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 17:29:06',0,1),
(2523,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-24 17:20:23',0,1),
(2523,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 17:29:35',0,1),
(2527,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:52:10',0,1),
(2527,1,35,'6507c83d-4852-4bbd-9fee-2e10673e660b','2025-09-19 17:30:21',0,1),
(2527,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 17:30:27',0,1),
(2527,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-24 17:20:14',0,1),
(2527,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 17:31:59',0,1),
(2531,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:51:56',0,1),
(2531,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 17:34:50',0,1),
(2531,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-30 19:28:07',0,1),
(2531,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 17:34:51',0,1),
(2535,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:51:46',0,1),
(2535,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 17:35:04',0,1),
(2535,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-24 17:19:43',0,1),
(2535,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 17:35:48',0,1),
(2537,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:51:30',0,1),
(2537,1,35,'6507c83d-4852-4bbd-9fee-2e10673e660b','2025-09-19 18:51:30',0,1),
(2537,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 17:37:56',0,1),
(2537,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-24 17:19:53',0,1),
(2537,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 17:38:14',0,1),
(2590,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:53:01',0,1),
(2590,1,35,'6507c83d-4852-4bbd-9fee-2e10673e660b','2025-09-19 18:52:59',0,1),
(2590,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 18:52:51',0,1),
(2590,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-19 18:57:59',0,1),
(2590,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 18:52:51',0,1),
(2590,1,61,'b7de2ec4-9407-4c88-8439-eecd0bc52d8a','2025-09-19 18:52:42',0,1),
(2590,1,62,'479ed735-51b9-4c23-9872-4e95d2914634','2025-09-19 19:15:03',0,1),
(2712,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:32:26',0,1),
(2712,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-06 16:10:00',0,1),
(2712,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-22 18:32:59',0,1),
(2712,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:33:47',0,1),
(2712,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-22 18:33:03',0,1),
(2712,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:32:29',0,1),
(2712,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-22 18:32:35',0,1),
(2712,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-22 18:36:55',0,1),
(2720,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:34:22',0,1),
(2720,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 22:20:23',0,1),
(2720,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-22 18:35:24',0,1),
(2720,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:36:12',0,1),
(2720,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-22 18:36:20',0,1),
(2720,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:34:24',0,1),
(2720,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-22 18:34:29',0,1),
(2720,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-22 18:34:34',0,1),
(2785,1,66,'681970c0-9b7f-4dae-90d9-2db13d19dc70','2025-09-30 22:22:13',0,1),
(2785,1,67,'9cec38eb-79ed-49c5-91bc-20226553bedd','2025-09-30 22:22:13',0,1),
(2786,1,66,'681970c0-9b7f-4dae-90d9-2db13d19dc70','2025-09-30 22:22:24',0,1),
(2786,1,67,'9cec38eb-79ed-49c5-91bc-20226553bedd','2025-09-30 22:22:24',0,1),
(2787,1,66,'681970c0-9b7f-4dae-90d9-2db13d19dc70','2025-09-30 22:22:37',0,1),
(2791,1,67,'9cec38eb-79ed-49c5-91bc-20226553bedd','2025-09-30 22:41:39',0,1),
(2791,1,68,'4fdb89f2-25d0-447f-acfa-ae9e099b1ec0','2025-09-30 22:41:39',0,1),
(2793,1,66,'681970c0-9b7f-4dae-90d9-2db13d19dc70','2025-09-30 22:45:18',0,1),
(2812,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-23 21:56:41',0,1),
(2812,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-23 21:56:41',0,1),
(2813,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-23 21:56:57',0,1),
(2813,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-23 21:56:57',0,1),
(2814,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-23 21:57:09',0,1),
(2814,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-23 21:57:06',0,1),
(2815,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-23 21:57:19',0,1),
(2815,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-23 21:57:19',0,1),
(2816,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-23 21:57:28',0,1),
(2816,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-23 21:57:28',0,1),
(2817,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-23 21:57:37',0,1),
(2817,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-23 21:57:37',0,1),
(2880,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-24 23:06:35',0,1),
(2880,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-10 18:22:51',0,1),
(2880,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-24 23:07:17',0,1),
(2880,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-24 23:07:59',0,1),
(2880,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 22:34:45',0,1),
(2880,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 22:33:45',0,1),
(2880,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 22:33:18',0,1),
(2880,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-24 23:06:38',0,1),
(2880,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-24 23:06:55',0,1),
(2880,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-08 22:35:10',0,1),
(2880,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 22:35:46',0,1),
(2880,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-10-08 22:32:49',0,1),
(2880,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-24 23:07:28',0,1),
(2880,1,72,'c67c0ac3-ce5c-4eb0-b6c1-86c68413a548','2025-10-10 18:22:50',0,1),
(2882,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-24 23:08:25',0,1),
(2882,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-24 23:08:43',0,1),
(2882,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-24 23:08:55',0,1),
(2882,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-24 23:09:19',0,1),
(2882,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-24 23:09:14',0,1),
(2882,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-24 23:08:27',0,1),
(2882,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-24 23:08:29',0,1),
(2882,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-24 23:08:37',0,1),
(2923,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-29 19:07:48',0,1),
(2945,1,68,'4fdb89f2-25d0-447f-acfa-ae9e099b1ec0','2025-09-30 22:45:57',0,1),
(2969,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-06 17:47:25',0,1),
(2969,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-06 17:46:00',0,1),
(2972,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 18:21:43',0,1),
(2972,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-06 17:46:35',0,1),
(2974,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-09 16:34:57',0,1),
(2974,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-06 17:46:58',0,1),
(3016,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 18:22:24',0,1),
(3025,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 18:35:20',0,1),
(3025,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-08 18:34:54',0,1),
(3027,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 18:36:11',0,1),
(3027,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-08 18:36:06',0,1),
(3091,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 18:55:22',0,1),
(3091,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-08 18:55:12',0,1),
(3093,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 18:55:50',0,1),
(3093,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-08 18:55:41',0,1),
(3123,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 19:54:15',0,1),
(3123,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-08 19:54:10',0,1),
(3468,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-09 16:33:42',0,1),
(3468,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-09 16:33:34',0,1),
(3831,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-13 16:09:39',0,1),
(4705,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-22 18:19:28',0,1);
/*!40000 ALTER TABLE `changedfields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `contentblocks`
--

LOCK TABLES `contentblocks` WRITE;
/*!40000 ALTER TABLE `contentblocks` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `contentblocks` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `craftidtokens`
--

LOCK TABLES `craftidtokens` WRITE;
/*!40000 ALTER TABLE `craftidtokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `craftidtokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `deprecationerrors`
--

LOCK TABLES `deprecationerrors` WRITE;
/*!40000 ALTER TABLE `deprecationerrors` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `deprecationerrors` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `drafts`
--

LOCK TABLES `drafts` WRITE;
/*!40000 ALTER TABLE `drafts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `drafts` VALUES
(7,NULL,1,0,'First draft',NULL,0,NULL,0),
(52,NULL,1,0,'First draft',NULL,0,NULL,0),
(96,NULL,1,0,'First draft',NULL,0,NULL,0),
(137,NULL,1,0,'First draft',NULL,0,NULL,0),
(224,NULL,1,0,'First draft',NULL,0,NULL,0),
(280,NULL,1,0,'First draft',NULL,0,NULL,0),
(437,NULL,1,0,'First draft',NULL,0,NULL,0),
(438,NULL,1,0,'First draft',NULL,0,NULL,0),
(439,NULL,1,0,'First draft',NULL,0,NULL,0),
(440,NULL,1,0,'First draft',NULL,0,NULL,0),
(441,NULL,1,0,'First draft',NULL,0,NULL,0),
(442,NULL,1,0,'First draft',NULL,0,NULL,0),
(443,NULL,1,0,'First draft',NULL,0,NULL,0),
(554,NULL,1,0,'First draft',NULL,0,NULL,0),
(628,1289,1,1,'Draft 1','',1,NULL,1),
(664,NULL,1,0,'First draft',NULL,0,NULL,0),
(668,NULL,1,0,'First draft',NULL,0,NULL,0),
(670,NULL,1,0,'First draft',NULL,0,NULL,0),
(671,NULL,1,0,'First draft','',0,NULL,1),
(672,NULL,1,0,'First draft',NULL,0,NULL,0),
(776,NULL,1,0,'First draft',NULL,0,NULL,0),
(830,NULL,1,0,'First draft',NULL,0,NULL,0),
(870,NULL,1,0,'First draft',NULL,0,NULL,0),
(882,NULL,1,0,'First draft',NULL,0,NULL,0),
(953,1073,1,1,'Draft 1','',1,NULL,1),
(1236,NULL,1,0,'First draft',NULL,0,NULL,0),
(1285,2882,1,1,'Draft 1','',1,NULL,1);
/*!40000 ALTER TABLE `drafts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elementactivity`
--

LOCK TABLES `elementactivity` WRITE;
/*!40000 ALTER TABLE `elementactivity` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elementactivity` VALUES
(2,1,1,NULL,'edit','2025-10-13 20:12:32'),
(2,1,1,NULL,'save','2025-10-23 01:39:13'),
(18,1,1,NULL,'save','2025-04-18 18:06:50'),
(20,1,1,NULL,'save','2025-04-18 18:06:58'),
(22,1,1,NULL,'save','2025-04-18 18:07:06'),
(24,1,1,NULL,'save','2025-04-18 18:07:32'),
(26,1,1,NULL,'save','2025-04-18 18:07:37'),
(28,1,1,NULL,'save','2025-04-18 18:07:43'),
(30,1,1,NULL,'save','2025-04-18 18:07:48'),
(32,1,1,NULL,'save','2025-04-18 18:07:53'),
(34,1,1,NULL,'save','2025-04-18 18:08:00'),
(36,1,1,NULL,'edit','2025-08-20 21:57:06'),
(36,1,1,NULL,'save','2025-08-20 21:57:06'),
(44,1,1,NULL,'edit','2025-09-03 22:27:13'),
(56,1,1,NULL,'edit','2025-09-03 21:05:06'),
(57,1,1,NULL,'edit','2025-09-03 21:05:21'),
(63,1,1,NULL,'edit','2025-09-03 21:08:03'),
(63,1,1,NULL,'save','2025-09-03 21:05:57'),
(111,1,1,NULL,'save','2025-04-18 18:38:40'),
(113,1,1,NULL,'save','2025-04-18 18:38:46'),
(115,1,1,NULL,'save','2025-04-18 18:38:51'),
(117,1,1,NULL,'save','2025-04-18 18:38:56'),
(119,1,1,NULL,'save','2025-04-18 18:39:00'),
(121,1,1,NULL,'save','2025-04-18 18:39:04'),
(283,1,1,NULL,'edit','2025-07-30 22:48:01'),
(283,1,1,NULL,'save','2025-07-30 23:10:37'),
(288,1,1,NULL,'edit','2025-07-30 23:10:31'),
(288,1,1,NULL,'save','2025-07-30 23:10:31'),
(290,1,1,NULL,'edit','2025-07-30 22:58:05'),
(290,1,1,NULL,'save','2025-07-30 23:11:03'),
(292,1,1,NULL,'edit','2025-07-30 23:10:54'),
(292,1,1,NULL,'save','2025-07-30 23:10:55'),
(294,1,1,NULL,'edit','2025-09-05 20:01:25'),
(294,1,1,NULL,'save','2025-09-05 20:01:55'),
(296,1,1,NULL,'edit','2025-07-30 23:11:18'),
(296,1,1,NULL,'save','2025-07-30 23:11:31'),
(323,1,1,NULL,'save','2025-08-01 17:59:31'),
(325,1,1,NULL,'edit','2025-09-18 19:12:04'),
(325,1,1,NULL,'save','2025-08-01 18:06:11'),
(329,1,1,NULL,'save','2025-08-01 18:04:57'),
(331,1,1,NULL,'save','2025-08-01 18:05:01'),
(333,1,1,NULL,'save','2025-08-01 18:05:04'),
(335,1,1,NULL,'save','2025-08-01 18:05:08'),
(337,1,1,NULL,'save','2025-08-01 18:05:10'),
(339,1,1,NULL,'save','2025-08-01 18:05:15'),
(341,1,1,NULL,'save','2025-08-01 18:05:18'),
(343,1,1,NULL,'save','2025-08-01 18:05:21'),
(348,1,1,NULL,'save','2025-08-01 18:06:22'),
(350,1,1,NULL,'save','2025-08-01 18:06:40'),
(352,1,1,NULL,'save','2025-08-01 18:07:25'),
(354,1,1,NULL,'save','2025-08-01 18:07:35'),
(356,1,1,NULL,'save','2025-08-01 18:07:48'),
(358,1,1,NULL,'save','2025-08-01 18:07:58'),
(360,1,1,NULL,'save','2025-08-01 18:08:08'),
(362,1,1,NULL,'save','2025-08-01 18:08:17'),
(364,1,1,NULL,'save','2025-08-01 18:08:31'),
(366,1,1,NULL,'save','2025-08-01 18:09:02'),
(368,1,1,NULL,'save','2025-08-01 18:09:12'),
(370,1,1,NULL,'save','2025-08-01 18:09:33'),
(372,1,1,NULL,'save','2025-08-01 18:09:44'),
(374,1,1,NULL,'save','2025-08-01 18:10:00'),
(376,1,1,NULL,'save','2025-08-01 18:10:07'),
(378,1,1,NULL,'save','2025-08-01 18:10:18'),
(380,1,1,NULL,'save','2025-08-01 18:10:31'),
(382,1,1,NULL,'save','2025-08-01 18:10:53'),
(384,1,1,NULL,'save','2025-08-01 18:11:04'),
(386,1,1,NULL,'save','2025-08-01 18:11:17'),
(388,1,1,NULL,'save','2025-08-01 18:11:31'),
(390,1,1,NULL,'save','2025-08-01 18:11:48'),
(392,1,1,NULL,'save','2025-08-01 18:12:02'),
(394,1,1,NULL,'save','2025-08-01 18:12:14'),
(396,1,1,NULL,'save','2025-08-01 18:12:26'),
(398,1,1,NULL,'save','2025-08-01 18:12:34'),
(400,1,1,NULL,'save','2025-08-01 18:12:57'),
(402,1,1,NULL,'save','2025-08-01 18:13:07'),
(404,1,1,NULL,'save','2025-08-01 18:13:20'),
(406,1,1,NULL,'save','2025-08-01 18:13:33'),
(408,1,1,NULL,'save','2025-08-01 18:13:42'),
(410,1,1,NULL,'save','2025-08-01 18:13:53'),
(412,1,1,NULL,'save','2025-08-01 18:14:03'),
(414,1,1,NULL,'save','2025-08-01 18:14:13'),
(445,1,1,NULL,'edit','2025-09-03 22:27:27'),
(453,1,1,NULL,'save','2025-08-20 21:57:20'),
(455,1,1,NULL,'save','2025-08-20 21:57:32'),
(457,1,1,NULL,'edit','2025-09-23 20:25:30'),
(457,1,1,NULL,'save','2025-09-23 20:25:31'),
(459,1,1,NULL,'edit','2025-09-23 21:13:17'),
(459,1,1,NULL,'save','2025-09-23 21:13:19'),
(461,1,1,NULL,'save','2025-09-23 20:25:25'),
(463,1,1,NULL,'edit','2025-09-23 20:25:36'),
(463,1,1,NULL,'save','2025-09-23 20:25:37'),
(465,1,1,NULL,'edit','2025-09-23 21:13:37'),
(465,1,1,NULL,'save','2025-09-23 21:13:37'),
(467,1,1,NULL,'save','2025-09-23 20:25:55'),
(469,1,1,NULL,'edit','2025-09-23 20:26:04'),
(469,1,1,NULL,'save','2025-09-23 20:26:04'),
(471,1,1,NULL,'save','2025-09-23 20:26:11'),
(473,1,1,NULL,'save','2025-08-20 22:00:22'),
(475,1,1,NULL,'edit','2025-09-23 20:26:26'),
(475,1,1,NULL,'save','2025-09-23 20:26:26'),
(477,1,1,NULL,'save','2025-09-23 20:26:34'),
(479,1,1,NULL,'save','2025-09-23 20:26:42'),
(481,1,1,NULL,'edit','2025-09-23 20:26:53'),
(481,1,1,NULL,'save','2025-09-23 20:26:54'),
(483,1,1,NULL,'edit','2025-09-23 20:27:03'),
(483,1,1,NULL,'save','2025-09-23 20:27:03'),
(485,1,1,NULL,'save','2025-09-23 20:27:13'),
(487,1,1,NULL,'edit','2025-09-23 21:13:49'),
(487,1,1,NULL,'save','2025-09-23 21:13:50'),
(489,1,1,NULL,'edit','2025-09-23 20:29:09'),
(489,1,1,NULL,'save','2025-09-23 20:29:09'),
(491,1,1,NULL,'save','2025-09-23 20:29:17'),
(493,1,1,NULL,'save','2025-09-23 20:29:24'),
(495,1,1,NULL,'edit','2025-09-23 20:29:37'),
(495,1,1,NULL,'save','2025-09-23 20:29:38'),
(497,1,1,NULL,'edit','2025-09-23 21:13:43'),
(497,1,1,NULL,'save','2025-09-23 21:13:43'),
(499,1,1,NULL,'save','2025-08-20 22:12:23'),
(501,1,1,NULL,'save','2025-08-20 22:12:28'),
(503,1,1,NULL,'save','2025-08-20 22:12:34'),
(506,1,1,NULL,'save','2025-08-20 22:12:50'),
(508,1,1,NULL,'save','2025-08-20 22:12:54'),
(510,1,1,NULL,'save','2025-08-20 22:12:57'),
(512,1,1,NULL,'save','2025-08-20 22:13:01'),
(514,1,1,NULL,'save','2025-08-20 22:13:04'),
(516,1,1,NULL,'save','2025-08-20 22:13:07'),
(518,1,1,NULL,'save','2025-08-20 22:13:10'),
(520,1,1,NULL,'save','2025-08-20 22:13:13'),
(522,1,1,NULL,'save','2025-08-20 22:13:15'),
(524,1,1,NULL,'save','2025-08-20 22:13:18'),
(530,1,1,NULL,'save','2025-08-20 22:17:46'),
(532,1,1,NULL,'save','2025-08-20 22:18:02'),
(534,1,1,NULL,'save','2025-08-20 22:18:29'),
(555,1,1,NULL,'save','2025-09-02 22:24:46'),
(557,1,1,NULL,'save','2025-09-02 22:24:52'),
(559,1,1,NULL,'save','2025-09-02 22:24:59'),
(561,1,1,NULL,'save','2025-09-02 22:25:02'),
(563,1,1,NULL,'save','2025-09-02 22:25:06'),
(601,1,1,NULL,'edit','2025-10-03 20:24:29'),
(601,1,1,NULL,'save','2025-10-03 20:24:31'),
(603,1,1,NULL,'save','2025-09-03 21:48:45'),
(605,1,1,NULL,'edit','2025-10-03 20:24:40'),
(605,1,1,NULL,'save','2025-10-03 20:24:40'),
(614,1,1,NULL,'save','2025-10-08 18:25:13'),
(617,1,1,NULL,'edit','2025-10-03 20:24:49'),
(617,1,1,NULL,'save','2025-10-03 20:24:49'),
(945,1,1,NULL,'edit','2025-10-14 14:04:47'),
(945,1,1,NULL,'save','2025-10-14 16:13:46'),
(951,1,1,NULL,'edit','2025-10-10 18:22:38'),
(951,1,1,NULL,'save','2025-10-10 18:22:39'),
(957,1,1,NULL,'edit','2025-10-08 18:44:15'),
(957,1,1,NULL,'save','2025-10-08 22:20:19'),
(963,1,1,NULL,'edit','2025-10-08 18:51:33'),
(963,1,1,NULL,'save','2025-10-08 18:52:55'),
(969,1,1,NULL,'edit','2025-10-08 19:00:34'),
(969,1,1,NULL,'save','2025-10-08 19:00:47'),
(975,1,1,NULL,'edit','2025-10-08 19:59:13'),
(975,1,1,NULL,'save','2025-10-08 19:59:16'),
(981,1,1,NULL,'edit','2025-10-08 20:26:00'),
(981,1,1,NULL,'save','2025-10-08 20:26:01'),
(989,1,1,NULL,'edit','2025-10-09 14:59:57'),
(989,1,1,NULL,'save','2025-10-09 15:36:03'),
(995,1,1,NULL,'edit','2025-10-09 16:31:25'),
(995,1,1,NULL,'save','2025-10-09 16:31:37'),
(999,1,1,NULL,'edit','2025-10-14 16:14:26'),
(999,1,1,NULL,'save','2025-10-14 16:14:34'),
(1005,1,1,NULL,'edit','2025-10-09 16:42:56'),
(1005,1,1,NULL,'save','2025-10-09 16:42:58'),
(1011,1,1,NULL,'edit','2025-10-09 17:05:52'),
(1011,1,1,NULL,'save','2025-10-09 17:05:54'),
(1017,1,1,NULL,'edit','2025-10-09 17:10:17'),
(1017,1,1,NULL,'save','2025-10-09 17:10:32'),
(1023,1,1,NULL,'edit','2025-10-09 17:20:36'),
(1023,1,1,NULL,'save','2025-10-09 17:20:39'),
(1031,1,1,NULL,'edit','2025-09-11 19:20:07'),
(1031,1,1,NULL,'save','2025-09-11 19:20:11'),
(1035,1,1,NULL,'edit','2025-10-09 17:24:36'),
(1035,1,1,NULL,'save','2025-10-09 17:24:37'),
(1041,1,1,NULL,'edit','2025-10-09 17:29:33'),
(1041,1,1,NULL,'save','2025-10-09 17:29:43'),
(1045,1,1,NULL,'edit','2025-10-09 20:48:17'),
(1045,1,1,NULL,'save','2025-10-09 20:48:21'),
(1051,1,1,NULL,'edit','2025-10-09 20:55:51'),
(1051,1,1,NULL,'save','2025-10-09 20:56:04'),
(1059,1,1,NULL,'edit','2025-10-13 16:02:34'),
(1059,1,1,NULL,'save','2025-10-13 16:02:37'),
(1067,1,1,NULL,'edit','2025-10-13 16:07:47'),
(1067,1,1,NULL,'save','2025-10-13 16:08:14'),
(1073,1,1,NULL,'edit','2025-10-13 16:09:39'),
(1073,1,1,NULL,'save','2025-09-11 19:08:31'),
(1079,1,1,NULL,'edit','2025-10-13 16:15:43'),
(1079,1,1,NULL,'save','2025-10-13 16:15:51'),
(1085,1,1,NULL,'edit','2025-10-13 16:43:48'),
(1085,1,1,NULL,'save','2025-10-13 16:43:51'),
(1091,1,1,NULL,'edit','2025-10-13 17:06:42'),
(1091,1,1,NULL,'save','2025-10-13 17:09:47'),
(1097,1,1,NULL,'edit','2025-10-13 17:22:58'),
(1097,1,1,NULL,'save','2025-10-13 17:23:02'),
(1103,1,1,NULL,'edit','2025-10-13 17:28:21'),
(1103,1,1,NULL,'save','2025-10-13 17:28:26'),
(1109,1,1,NULL,'edit','2025-10-13 17:43:31'),
(1109,1,1,NULL,'save','2025-10-13 17:43:34'),
(1117,1,1,NULL,'edit','2025-10-13 17:47:16'),
(1117,1,1,NULL,'save','2025-10-13 17:47:19'),
(1123,1,1,NULL,'edit','2025-10-13 17:53:09'),
(1123,1,1,NULL,'save','2025-10-13 17:53:11'),
(1129,1,1,NULL,'edit','2025-10-13 17:57:25'),
(1129,1,1,NULL,'save','2025-10-13 17:57:28'),
(1135,1,1,NULL,'edit','2025-09-11 19:21:44'),
(1135,1,1,NULL,'save','2025-09-11 19:21:45'),
(1141,1,1,NULL,'edit','2025-09-11 19:22:00'),
(1141,1,1,NULL,'save','2025-09-11 19:22:03'),
(1143,1,1,NULL,'edit','2025-10-13 18:02:07'),
(1143,1,1,NULL,'save','2025-10-13 18:02:09'),
(1149,1,1,NULL,'edit','2025-10-13 19:09:53'),
(1149,1,1,NULL,'save','2025-10-13 19:10:27'),
(1155,1,1,NULL,'edit','2025-10-13 19:17:49'),
(1155,1,1,NULL,'save','2025-10-13 19:24:55'),
(1161,1,1,NULL,'edit','2025-09-11 19:49:40'),
(1161,1,1,NULL,'save','2025-09-11 19:52:35'),
(1165,1,1,NULL,'edit','2025-10-13 19:30:04'),
(1165,1,1,NULL,'save','2025-10-13 19:30:06'),
(1171,1,1,NULL,'edit','2025-10-13 19:34:12'),
(1171,1,1,NULL,'save','2025-10-13 19:34:44'),
(1177,1,1,NULL,'edit','2025-10-13 19:39:30'),
(1177,1,1,NULL,'save','2025-10-13 19:39:32'),
(1185,1,1,NULL,'edit','2025-10-13 19:51:28'),
(1185,1,1,NULL,'save','2025-10-13 19:51:50'),
(1191,1,1,NULL,'edit','2025-10-14 16:49:11'),
(1191,1,1,NULL,'save','2025-10-14 16:49:14'),
(1197,1,1,NULL,'edit','2025-10-14 16:53:12'),
(1197,1,1,NULL,'save','2025-10-14 16:53:18'),
(1201,1,1,NULL,'edit','2025-10-14 16:56:53'),
(1201,1,1,NULL,'save','2025-10-14 16:56:57'),
(1209,1,1,NULL,'edit','2025-10-14 17:00:03'),
(1209,1,1,NULL,'save','2025-10-14 17:00:06'),
(1215,1,1,NULL,'edit','2025-10-14 17:05:08'),
(1215,1,1,NULL,'save','2025-10-14 17:05:13'),
(1219,1,1,NULL,'edit','2025-10-14 17:09:06'),
(1219,1,1,NULL,'save','2025-10-14 17:09:21'),
(1225,1,1,NULL,'edit','2025-10-14 17:12:16'),
(1225,1,1,NULL,'save','2025-10-14 17:12:18'),
(1231,1,1,NULL,'edit','2025-10-14 17:15:17'),
(1231,1,1,NULL,'save','2025-10-14 17:15:30'),
(1237,1,1,NULL,'edit','2025-10-14 17:22:19'),
(1237,1,1,NULL,'save','2025-10-14 17:22:21'),
(1243,1,1,NULL,'edit','2025-10-14 17:25:11'),
(1243,1,1,NULL,'save','2025-10-14 17:25:14'),
(1249,1,1,NULL,'edit','2025-10-14 17:28:07'),
(1249,1,1,NULL,'save','2025-10-14 17:28:10'),
(1255,1,1,NULL,'edit','2025-10-08 22:20:04'),
(1255,1,1,NULL,'save','2025-10-16 20:22:32'),
(1261,1,1,NULL,'edit','2025-09-11 19:34:51'),
(1261,1,1,NULL,'save','2025-09-11 19:34:52'),
(1269,1,1,NULL,'edit','2025-09-11 19:03:20'),
(1269,1,1,NULL,'save','2025-09-11 19:03:21'),
(1277,1,1,NULL,'edit','2025-09-11 19:35:23'),
(1277,1,1,NULL,'save','2025-09-11 19:35:24'),
(1283,1,1,NULL,'edit','2025-09-22 18:33:26'),
(1283,1,1,NULL,'save','2025-09-22 18:42:35'),
(1289,1,1,NULL,'edit','2025-09-29 19:07:48'),
(1289,1,1,NULL,'save','2025-09-11 19:36:53'),
(1297,1,1,NULL,'edit','2025-09-11 19:36:59'),
(1297,1,1,NULL,'save','2025-09-11 19:37:00'),
(1303,1,1,NULL,'edit','2025-09-11 19:37:07'),
(1303,1,1,NULL,'save','2025-09-11 19:37:09'),
(1309,1,1,NULL,'edit','2025-09-11 19:36:24'),
(1309,1,1,NULL,'save','2025-09-11 19:36:26'),
(1315,1,1,NULL,'edit','2025-09-11 19:13:19'),
(1315,1,1,NULL,'save','2025-09-11 19:13:20'),
(1323,1,1,NULL,'edit','2025-09-11 19:14:24'),
(1323,1,1,NULL,'save','2025-09-11 19:14:25'),
(1329,1,1,NULL,'edit','2025-09-11 19:18:24'),
(1329,1,1,NULL,'save','2025-09-11 19:18:25'),
(1337,1,1,NULL,'edit','2025-09-11 19:18:54'),
(1337,1,1,NULL,'save','2025-09-11 19:18:55'),
(1343,1,1,NULL,'edit','2025-09-11 19:19:19'),
(1343,1,1,NULL,'save','2025-09-11 19:19:20'),
(1349,1,1,NULL,'edit','2025-09-11 19:21:35'),
(1349,1,1,NULL,'save','2025-09-11 19:21:37'),
(1353,1,1,NULL,'edit','2025-10-10 18:22:08'),
(1353,1,1,NULL,'save','2025-10-10 18:22:08'),
(1359,1,1,NULL,'edit','2025-09-22 18:20:31'),
(1359,1,1,NULL,'save','2025-09-22 18:20:33'),
(1365,1,1,NULL,'edit','2025-09-22 18:10:45'),
(1365,1,1,NULL,'save','2025-09-22 18:20:52'),
(1371,1,1,NULL,'edit','2025-09-22 18:21:33'),
(1371,1,1,NULL,'save','2025-09-22 18:21:35'),
(1377,1,1,NULL,'edit','2025-09-22 18:22:05'),
(1377,1,1,NULL,'save','2025-09-22 18:22:06'),
(1383,1,1,NULL,'edit','2025-09-22 18:22:44'),
(1383,1,1,NULL,'save','2025-09-22 18:22:45'),
(1389,1,1,NULL,'edit','2025-09-22 18:23:00'),
(1389,1,1,NULL,'save','2025-09-22 18:23:02'),
(1395,1,1,NULL,'edit','2025-09-29 18:59:00'),
(1395,1,1,NULL,'save','2025-09-29 18:59:03'),
(1401,1,1,NULL,'edit','2025-09-22 18:22:28'),
(1401,1,1,NULL,'save','2025-09-22 18:22:29'),
(1407,1,1,NULL,'edit','2025-09-22 18:23:22'),
(1407,1,1,NULL,'save','2025-09-22 18:23:24'),
(1413,1,1,NULL,'edit','2025-09-22 18:18:13'),
(1413,1,1,NULL,'save','2025-09-22 18:18:15'),
(1419,1,1,NULL,'edit','2025-09-11 19:04:21'),
(1419,1,1,NULL,'save','2025-09-11 19:04:21'),
(1425,1,1,NULL,'edit','2025-09-11 19:04:30'),
(1425,1,1,NULL,'save','2025-09-11 19:04:31'),
(1431,1,1,NULL,'edit','2025-09-11 19:35:44'),
(1431,1,1,NULL,'save','2025-09-11 19:35:45'),
(1437,1,1,NULL,'edit','2025-10-23 01:33:49'),
(1437,1,1,NULL,'save','2025-10-23 01:33:57'),
(1443,1,1,NULL,'edit','2025-10-14 13:43:20'),
(1443,1,1,NULL,'save','2025-10-14 13:43:52'),
(1449,1,1,NULL,'edit','2025-09-11 19:37:30'),
(1449,1,1,NULL,'save','2025-09-11 19:37:31'),
(1455,1,1,NULL,'edit','2025-09-11 19:09:36'),
(1455,1,1,NULL,'save','2025-09-11 19:09:37'),
(1461,1,1,NULL,'edit','2025-09-11 19:11:56'),
(1461,1,1,NULL,'save','2025-09-11 19:11:57'),
(1467,1,1,NULL,'edit','2025-09-11 19:12:27'),
(1467,1,1,NULL,'save','2025-09-11 19:12:28'),
(1473,1,1,NULL,'edit','2025-10-16 19:18:46'),
(1473,1,1,NULL,'save','2025-10-16 19:18:57'),
(1477,1,1,NULL,'edit','2025-10-16 19:21:37'),
(1477,1,1,NULL,'save','2025-10-16 19:21:39'),
(1481,1,1,NULL,'edit','2025-10-16 19:23:28'),
(1481,1,1,NULL,'save','2025-10-16 19:23:32'),
(1486,1,1,NULL,'edit','2025-09-17 19:37:14'),
(1487,1,1,NULL,'edit','2025-09-17 19:37:06'),
(1499,1,1,NULL,'edit','2025-10-08 22:21:40'),
(1504,1,1,NULL,'edit','2025-10-08 18:42:47'),
(1505,1,1,NULL,'edit','2025-10-08 18:43:08'),
(1509,1,1,NULL,'edit','2025-10-08 18:50:56'),
(1510,1,1,NULL,'edit','2025-10-08 18:51:33'),
(1510,1,1,NULL,'save','2025-10-08 18:51:43'),
(1514,1,1,NULL,'edit','2025-10-08 19:00:05'),
(1515,1,1,NULL,'edit','2025-10-08 19:00:34'),
(1519,1,1,NULL,'edit','2025-10-08 19:58:22'),
(1520,1,1,NULL,'edit','2025-10-08 19:59:12'),
(1525,1,1,NULL,'edit','2025-10-08 20:25:20'),
(1526,1,1,NULL,'edit','2025-10-08 20:25:49'),
(1531,1,1,NULL,'edit','2025-10-09 14:59:29'),
(1532,1,1,NULL,'edit','2025-10-09 14:59:50'),
(1536,1,1,NULL,'edit','2025-10-09 16:31:25'),
(1539,1,1,NULL,'edit','2025-10-09 16:37:17'),
(1540,1,1,NULL,'edit','2025-10-09 16:37:36'),
(1544,1,1,NULL,'edit','2025-10-09 16:42:39'),
(1545,1,1,NULL,'edit','2025-10-09 16:42:52'),
(1549,1,1,NULL,'edit','2025-10-09 17:05:34'),
(1550,1,1,NULL,'edit','2025-10-09 17:05:48'),
(1554,1,1,NULL,'edit','2025-10-09 17:10:05'),
(1555,1,1,NULL,'edit','2025-10-09 17:10:13'),
(1560,1,1,NULL,'edit','2025-10-09 17:20:25'),
(1561,1,1,NULL,'edit','2025-10-09 17:20:36'),
(1569,1,1,NULL,'edit','2025-10-09 17:24:19'),
(1570,1,1,NULL,'edit','2025-10-09 17:24:32'),
(1574,1,1,NULL,'edit','2025-10-09 17:29:33'),
(1577,1,1,NULL,'edit','2025-10-09 20:47:38'),
(1578,1,1,NULL,'edit','2025-10-09 20:48:17'),
(1583,1,1,NULL,'edit','2025-10-09 20:55:32'),
(1584,1,1,NULL,'edit','2025-10-09 20:55:50'),
(1590,1,1,NULL,'edit','2025-10-13 16:02:19'),
(1591,1,1,NULL,'edit','2025-10-13 16:02:30'),
(1596,1,1,NULL,'edit','2025-10-13 16:03:48'),
(1597,1,1,NULL,'edit','2025-10-13 16:04:05'),
(1606,1,1,NULL,'edit','2025-10-13 16:15:28'),
(1606,1,1,NULL,'save','2025-10-13 16:15:47'),
(1607,1,1,NULL,'edit','2025-10-13 16:15:43'),
(1611,1,1,NULL,'edit','2025-10-13 16:43:39'),
(1612,1,1,NULL,'edit','2025-10-13 16:43:45'),
(1616,1,1,NULL,'edit','2025-10-13 17:06:26'),
(1617,1,1,NULL,'edit','2025-10-13 17:06:42'),
(1621,1,1,NULL,'edit','2025-10-13 17:22:44'),
(1622,1,1,NULL,'edit','2025-10-13 17:22:58'),
(1626,1,1,NULL,'edit','2025-10-13 17:28:04'),
(1627,1,1,NULL,'edit','2025-10-13 17:28:21'),
(1632,1,1,NULL,'edit','2025-10-13 17:43:12'),
(1633,1,1,NULL,'edit','2025-10-13 17:43:30'),
(1638,1,1,NULL,'edit','2025-10-13 17:47:06'),
(1639,1,1,NULL,'edit','2025-10-13 17:47:16'),
(1643,1,1,NULL,'edit','2025-10-13 17:50:46'),
(1644,1,1,NULL,'edit','2025-10-13 17:51:57'),
(1648,1,1,NULL,'edit','2025-10-13 17:56:43'),
(1649,1,1,NULL,'edit','2025-10-13 17:57:24'),
(1659,1,1,NULL,'edit','2025-10-13 18:00:25'),
(1660,1,1,NULL,'edit','2025-10-13 18:01:48'),
(1664,1,1,NULL,'edit','2025-10-13 19:09:44'),
(1665,1,1,NULL,'edit','2025-10-13 19:09:52'),
(1669,1,1,NULL,'edit','2025-10-13 19:17:11'),
(1670,1,1,NULL,'edit','2025-10-13 19:17:49'),
(1677,1,1,NULL,'edit','2025-10-13 19:29:42'),
(1678,1,1,NULL,'edit','2025-10-13 19:29:58'),
(1682,1,1,NULL,'edit','2025-10-13 19:33:31'),
(1683,1,1,NULL,'edit','2025-10-13 19:33:46'),
(1692,1,1,NULL,'edit','2025-10-13 19:39:13'),
(1693,1,1,NULL,'edit','2025-10-13 19:39:29'),
(1694,1,1,NULL,'edit','2025-10-13 19:46:02'),
(1695,1,1,NULL,'edit','2025-10-13 19:46:11'),
(1699,1,1,NULL,'edit','2025-10-14 16:48:57'),
(1700,1,1,NULL,'edit','2025-10-14 16:49:10'),
(1704,1,1,NULL,'edit','2025-10-14 16:53:12'),
(1708,1,1,NULL,'edit','2025-10-14 16:56:44'),
(1709,1,1,NULL,'edit','2025-10-14 16:56:53'),
(1714,1,1,NULL,'edit','2025-10-14 16:59:53'),
(1715,1,1,NULL,'edit','2025-10-14 17:00:02'),
(1719,1,1,NULL,'edit','2025-10-14 17:05:07'),
(1722,1,1,NULL,'edit','2025-10-14 17:08:55'),
(1723,1,1,NULL,'edit','2025-10-14 17:09:06'),
(1727,1,1,NULL,'edit','2025-10-14 17:12:03'),
(1728,1,1,NULL,'edit','2025-10-14 17:12:15'),
(1732,1,1,NULL,'edit','2025-10-14 17:15:07'),
(1733,1,1,NULL,'edit','2025-10-14 17:15:17'),
(1737,1,1,NULL,'edit','2025-10-14 17:22:05'),
(1738,1,1,NULL,'edit','2025-10-14 17:22:19'),
(1742,1,1,NULL,'edit','2025-10-14 17:24:57'),
(1743,1,1,NULL,'edit','2025-10-14 17:25:10'),
(1747,1,1,NULL,'edit','2025-10-14 17:27:52'),
(1748,1,1,NULL,'edit','2025-10-14 17:28:07'),
(1835,1,1,NULL,'edit','2025-10-08 22:38:38'),
(1911,1,1,NULL,'edit','2025-10-14 13:43:20'),
(1935,1,1,NULL,'edit','2025-10-16 19:18:26'),
(1938,1,1,NULL,'edit','2025-10-16 19:21:18'),
(1941,1,1,NULL,'edit','2025-10-16 19:23:11'),
(2519,1,1,NULL,'edit','2025-09-24 19:41:46'),
(2519,1,1,NULL,'save','2025-09-24 19:41:47'),
(2523,1,1,NULL,'edit','2025-09-24 17:20:23'),
(2523,1,1,NULL,'save','2025-09-24 17:20:23'),
(2527,1,1,NULL,'edit','2025-09-24 17:20:13'),
(2527,1,1,NULL,'save','2025-09-24 17:20:14'),
(2531,1,1,NULL,'edit','2025-09-30 19:28:06'),
(2531,1,1,NULL,'save','2025-09-30 19:28:07'),
(2535,1,1,NULL,'edit','2025-09-24 17:19:42'),
(2535,1,1,NULL,'save','2025-09-24 17:19:43'),
(2537,1,1,NULL,'edit','2025-09-24 17:19:52'),
(2537,1,1,NULL,'save','2025-09-24 17:19:53'),
(2553,1,1,NULL,'save','2025-09-19 18:50:13'),
(2555,1,1,NULL,'save','2025-09-19 18:50:15'),
(2557,1,1,NULL,'save','2025-09-19 18:50:18'),
(2559,1,1,NULL,'save','2025-09-19 18:50:27'),
(2561,1,1,NULL,'save','2025-09-19 18:50:45'),
(2563,1,1,NULL,'save','2025-09-19 18:50:48'),
(2565,1,1,NULL,'save','2025-09-19 18:50:50'),
(2567,1,1,NULL,'save','2025-09-19 18:50:52'),
(2569,1,1,NULL,'save','2025-09-19 18:50:55'),
(2571,1,1,NULL,'save','2025-09-19 18:50:59'),
(2573,1,1,NULL,'save','2025-09-19 18:51:06'),
(2576,1,1,NULL,'save','2025-09-19 18:51:09'),
(2590,1,1,NULL,'edit','2025-09-19 19:15:01'),
(2590,1,1,NULL,'save','2025-09-19 19:15:03'),
(2596,1,1,NULL,'save','2025-09-19 19:06:52'),
(2598,1,1,NULL,'save','2025-09-19 19:06:57'),
(2600,1,1,NULL,'save','2025-09-19 19:07:03'),
(2602,1,1,NULL,'save','2025-09-19 19:07:09'),
(2604,1,1,NULL,'save','2025-09-19 19:07:13'),
(2606,1,1,NULL,'save','2025-09-19 19:07:17'),
(2608,1,1,NULL,'save','2025-09-19 19:07:23'),
(2610,1,1,NULL,'save','2025-09-19 19:07:27'),
(2612,1,1,NULL,'save','2025-09-19 19:07:36'),
(2614,1,1,NULL,'save','2025-09-19 19:07:44'),
(2616,1,1,NULL,'save','2025-09-19 19:07:47'),
(2618,1,1,NULL,'save','2025-09-19 19:07:49'),
(2620,1,1,NULL,'save','2025-09-19 19:07:53'),
(2622,1,1,NULL,'save','2025-09-24 16:01:26'),
(2624,1,1,NULL,'save','2025-09-19 19:07:59'),
(2712,1,1,NULL,'edit','2025-09-29 18:29:03'),
(2712,1,1,NULL,'save','2025-10-06 16:09:59'),
(2720,1,1,NULL,'edit','2025-10-08 22:20:23'),
(2720,1,1,NULL,'save','2025-10-08 22:20:23'),
(2740,1,1,NULL,'save','2025-09-22 20:42:41'),
(2785,1,1,NULL,'edit','2025-09-30 22:22:11'),
(2785,1,1,NULL,'save','2025-09-30 22:22:13'),
(2786,1,1,NULL,'edit','2025-09-30 22:22:22'),
(2786,1,1,NULL,'save','2025-09-30 22:22:24'),
(2787,1,1,NULL,'edit','2025-09-30 22:22:35'),
(2787,1,1,NULL,'save','2025-09-30 22:22:37'),
(2791,1,1,NULL,'edit','2025-09-30 22:41:21'),
(2791,1,1,NULL,'save','2025-09-30 22:41:25'),
(2792,1,1,NULL,'edit','2025-09-30 22:43:28'),
(2793,1,1,NULL,'edit','2025-09-30 22:46:09'),
(2800,1,1,NULL,'save','2025-09-23 21:22:49'),
(2803,1,1,NULL,'save','2025-09-23 21:22:40'),
(2806,1,1,NULL,'save','2025-09-23 21:22:33'),
(2809,1,1,NULL,'save','2025-09-23 21:22:25'),
(2812,1,1,NULL,'save','2025-09-23 21:56:42'),
(2813,1,1,NULL,'save','2025-09-23 21:56:57'),
(2814,1,1,NULL,'save','2025-09-23 21:57:09'),
(2815,1,1,NULL,'save','2025-09-23 21:57:19'),
(2816,1,1,NULL,'save','2025-09-23 21:57:28'),
(2817,1,1,NULL,'save','2025-09-23 21:57:37'),
(2873,1,1,NULL,'save','2025-10-08 18:24:25'),
(2874,1,1,NULL,'save','2025-10-08 18:29:50'),
(2880,1,1,NULL,'edit','2025-10-10 18:22:48'),
(2880,1,1,NULL,'save','2025-10-10 18:22:51'),
(2882,1,1,NULL,'edit','2025-10-22 18:19:28'),
(2882,1,1,NULL,'save','2025-09-24 23:09:19'),
(2887,1,1,NULL,'save','2025-10-09 16:34:55'),
(2888,1,1,NULL,'save','2025-09-25 14:07:01'),
(2889,1,1,NULL,'save','2025-09-25 15:24:16'),
(2890,1,1,NULL,'save','2025-09-25 15:24:29'),
(2891,1,1,NULL,'save','2025-09-29 19:09:02'),
(2945,1,1,NULL,'edit','2025-09-30 22:45:55'),
(2968,1,1,NULL,'save','2025-10-06 17:45:01'),
(2969,1,1,NULL,'save','2025-10-06 17:47:25'),
(2970,1,1,NULL,'save','2025-10-08 18:24:15'),
(2972,1,1,NULL,'edit','2025-10-08 18:21:40'),
(2972,1,1,NULL,'save','2025-10-08 18:21:43'),
(2974,1,1,NULL,'edit','2025-10-09 16:34:56'),
(2974,1,1,NULL,'save','2025-10-09 16:34:57'),
(3016,1,1,NULL,'save','2025-10-08 18:22:24'),
(3017,1,1,NULL,'save','2025-10-08 18:26:30'),
(3018,1,1,NULL,'save','2025-10-08 18:27:05'),
(3019,1,1,NULL,'save','2025-10-08 18:28:18'),
(3020,1,1,NULL,'save','2025-10-08 18:30:02'),
(3021,1,1,NULL,'save','2025-10-08 18:31:22'),
(3022,1,1,NULL,'save','2025-10-08 18:32:14'),
(3023,1,1,NULL,'save','2025-10-08 18:32:47'),
(3025,1,1,NULL,'save','2025-10-08 18:35:41'),
(3027,1,1,NULL,'save','2025-10-08 18:36:16'),
(3084,1,1,NULL,'save','2025-10-08 18:51:29'),
(3090,1,1,NULL,'save','2025-10-08 18:54:27'),
(3091,1,1,NULL,'save','2025-10-08 18:55:24'),
(3093,1,1,NULL,'save','2025-10-08 18:55:51'),
(3123,1,1,NULL,'save','2025-10-08 19:54:15'),
(3158,1,1,NULL,'save','2025-10-08 20:22:26'),
(3192,1,1,NULL,'save','2025-10-08 22:18:56'),
(3194,1,1,NULL,'save','2025-10-08 22:18:59'),
(3196,1,1,NULL,'save','2025-10-08 22:19:01'),
(3198,1,1,NULL,'save','2025-10-08 22:19:04'),
(3200,1,1,NULL,'save','2025-10-08 22:19:06'),
(3202,1,1,NULL,'save','2025-10-08 22:19:10'),
(3204,1,1,NULL,'save','2025-10-08 22:19:13'),
(3206,1,1,NULL,'save','2025-10-08 22:19:15'),
(3208,1,1,NULL,'save','2025-10-08 22:19:18'),
(3210,1,1,NULL,'save','2025-10-08 22:19:21'),
(3377,1,1,NULL,'save','2025-10-09 14:40:35'),
(3425,1,1,NULL,'save','2025-10-09 16:20:23'),
(3467,1,1,NULL,'save','2025-10-09 16:32:41'),
(3468,1,1,NULL,'save','2025-10-09 16:33:43'),
(3495,1,1,NULL,'save','2025-10-09 16:37:50'),
(3498,1,1,NULL,'save','2025-10-09 16:39:11'),
(3530,1,1,NULL,'save','2025-10-09 17:00:45'),
(3689,1,1,NULL,'save','2025-10-09 20:43:24'),
(3697,1,1,NULL,'save','2025-10-09 20:46:21'),
(3800,1,1,NULL,'save','2025-10-13 16:03:42'),
(3959,1,1,NULL,'save','2025-10-13 17:25:55'),
(4105,1,1,NULL,'save','2025-10-13 17:57:21'),
(4403,1,1,NULL,'save','2025-10-14 16:52:36'),
(4466,1,1,NULL,'save','2025-10-14 17:01:23');
/*!40000 ALTER TABLE `elementactivity` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements`
--

LOCK TABLES `elements` WRITE;
/*!40000 ALTER TABLE `elements` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements` VALUES
(1,NULL,NULL,NULL,NULL,'craft\\elements\\User',1,0,'2025-04-18 16:59:46','2025-04-18 16:59:46',NULL,NULL,NULL,'e3682bee-bd77-4012-b16c-20d4c1d6741e'),
(2,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-04-18 17:15:09','2025-10-23 01:39:13',NULL,NULL,NULL,'fb43295f-50d1-4199-9547-b616822746d7'),
(8,NULL,NULL,NULL,NULL,'craft\\elements\\Address',1,0,'2025-04-18 17:32:44','2025-04-18 17:37:13',NULL,NULL,NULL,'70e10205-927a-4a3d-8e91-9e3ffe573ce3'),
(10,8,NULL,4,NULL,'craft\\elements\\Address',1,0,'2025-04-18 17:32:44','2025-04-18 17:32:44',NULL,NULL,NULL,'d9e8d544-dbad-4f54-a2fa-87088e720db9'),
(14,NULL,7,NULL,2,'craft\\elements\\Entry',1,0,'2025-04-18 17:57:42','2025-04-18 17:57:42',NULL,NULL,NULL,'c1f79f68-e8c6-4804-933b-f8e101ccfec0'),
(16,8,NULL,7,NULL,'craft\\elements\\Address',1,0,'2025-04-18 17:37:13','2025-04-18 17:57:57',NULL,NULL,NULL,'6815ef49-b7c0-4172-83d5-784b766e1d24'),
(18,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:06:39','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'52fd2ad7-fbff-4f46-965c-e9b93f5475e1'),
(19,18,NULL,9,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:06:50','2025-04-18 18:06:50',NULL,'2025-08-20 21:57:12',NULL,'ff937fe5-a347-42af-a84d-364ede501006'),
(20,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:06:50','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'ab2ec6e7-b567-4a20-867e-593a3ae40ff6'),
(21,20,NULL,10,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:06:58','2025-04-18 18:06:58',NULL,'2025-08-20 21:57:12',NULL,'d45473b0-cdfa-4d60-b51c-0ba2eb2f25fc'),
(22,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:06:58','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'9219e8e3-d389-40e4-93d5-049cea4484d7'),
(23,22,NULL,11,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:06','2025-04-18 18:07:06',NULL,'2025-08-20 21:57:12',NULL,'94e66f9c-36d3-4154-9631-d82ffdbeb1af'),
(24,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:06','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'3a825176-0a84-4f2a-996b-3f4bd4770f3f'),
(25,24,NULL,12,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:32','2025-04-18 18:07:32',NULL,'2025-08-20 21:57:12',NULL,'2c134b83-5c7e-4a8e-83ab-aa66a981e508'),
(26,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:32','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'40928895-f36c-4108-a1e4-564ae2424ee4'),
(27,26,NULL,13,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:37','2025-04-18 18:07:37',NULL,'2025-08-20 21:57:12',NULL,'ed08da6e-f8d3-4f00-8bc2-bf0f777875f2'),
(28,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:37','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'56921bc4-017a-46d3-ac85-05b47f57bd77'),
(29,28,NULL,14,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:43','2025-04-18 18:07:43',NULL,'2025-08-20 21:57:12',NULL,'afe819d0-90cf-4853-bb8d-2c816199c653'),
(30,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:43','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'d580a613-5ab1-4051-b261-fb71b222fdad'),
(31,30,NULL,15,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:48','2025-04-18 18:07:48',NULL,'2025-08-20 21:57:12',NULL,'f6ceba8a-38e9-4a30-bbcf-3f53e7f3a3f0'),
(32,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:48','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'5818599c-3b59-4b75-8027-f3af86d4e2b7'),
(33,32,NULL,16,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:53','2025-04-18 18:07:53',NULL,'2025-08-20 21:57:12',NULL,'7ac990ce-be72-4bf1-a4f8-85d18bed1def'),
(34,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:53','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'3ccd345c-16a2-4a6e-b6a8-f959829490ca'),
(35,34,NULL,17,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:08:00','2025-04-18 18:08:00',NULL,'2025-08-20 21:57:12',NULL,'6698e76d-c879-44a8-832a-3a08edb99c6a'),
(36,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:08:00','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'30202a0c-1dab-4496-b0d9-a2e4db046073'),
(37,36,NULL,18,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:08:04','2025-04-18 18:08:04',NULL,'2025-08-20 21:57:12',NULL,'af4aec2f-2c51-443d-afd2-f243f2c6db79'),
(44,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-04-18 18:10:41','2025-09-11 18:48:35',NULL,'2025-09-11 18:48:35',NULL,'66670719-86b2-4c25-a2d7-3268eb0b40e9'),
(45,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-04-18 18:10:41','2025-08-20 21:24:25',NULL,'2025-08-20 21:24:25',NULL,'d2f1243f-5911-46b3-ad4c-1fd18163d3cf'),
(46,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-04-18 18:10:41','2025-08-20 21:24:25',NULL,'2025-08-20 21:24:25',NULL,'e89fa079-a0ca-4f25-b733-547e3e9b74f4'),
(47,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-04-18 18:10:41','2025-08-20 21:24:25',NULL,'2025-08-20 21:24:25',NULL,'136b64d8-a9bb-44f3-ad1b-5b3d0e59aeb7'),
(56,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-04-18 18:14:39','2025-09-11 20:39:29',NULL,NULL,NULL,'cced9ffb-b1a4-432b-82dd-39ae892c0350'),
(57,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-04-18 18:14:39','2025-09-11 20:39:29',NULL,NULL,NULL,'5c75acb1-1c32-464d-a385-7d8e4367e7ad'),
(63,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-04-18 18:15:36','2025-09-11 20:39:29',NULL,NULL,NULL,'6b94fb19-0b48-4dbd-a994-fcc7c42212ac'),
(72,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'65faed90-739e-412a-ae6b-1141af4adff8'),
(73,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'15f1b50a-a6bf-404b-92d3-441e13132ed1'),
(74,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'02403c1b-68a0-4814-9d28-465a0dd3fd27'),
(75,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'d9c3d7d0-5243-443e-b0f7-d9e5c8e77f66'),
(76,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'3ddce6d7-14e4-4ed9-9384-71082ffc55a9'),
(78,72,NULL,30,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'d17c8ead-0ba1-4be3-bb3f-50f7b6bb1631'),
(79,73,NULL,31,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'885375ba-05c1-41a6-89db-4b73021f8132'),
(80,74,NULL,32,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'b8cf5928-cf35-40a0-8dd5-7b268a6cb35a'),
(81,75,NULL,33,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'420bcba9-27b9-4219-ab82-5e907810c874'),
(82,76,NULL,34,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'c62a29bd-d219-4eb7-8448-3770a5e0234e'),
(86,NULL,NULL,NULL,7,'craft\\elements\\Asset',1,0,'2025-04-18 18:31:40','2025-09-04 22:50:00',NULL,'2025-09-04 22:50:00',NULL,'0fc1718b-a60f-47e7-8e1a-4c67a6e22462'),
(96,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:38:26',NULL,'2025-04-18 18:38:26',NULL,'76dad8f7-c48c-4ed9-9f87-edbba7ce9dcf'),
(97,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:38:26',NULL,'2025-04-18 18:38:26',NULL,'733b8349-6d24-4796-901f-e6cccb78f65d'),
(98,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:38:26',NULL,'2025-04-18 18:38:26',NULL,'1d77e91d-0d5a-4c40-a992-b87dcb0b8786'),
(99,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:38:26',NULL,'2025-04-18 18:38:26',NULL,'044388df-8aaa-4929-83df-33e2cceb95c1'),
(100,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:38:26',NULL,'2025-04-18 18:38:26',NULL,'894d2df8-3989-44d9-ae0e-e7860708bc75'),
(101,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:38:26',NULL,'2025-04-18 18:38:26',NULL,'17ebe246-d2b0-4c36-b223-80704f9d9182'),
(103,96,NULL,39,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:36:37',NULL,'2025-04-18 18:38:26',NULL,'e430eb07-6216-43e2-95c5-b2cc0935a963'),
(104,97,NULL,40,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:36:37',NULL,'2025-04-18 18:38:26',NULL,'14b1e5db-e0b3-4881-b609-d0f63e82af5d'),
(105,98,NULL,41,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:36:37',NULL,'2025-04-18 18:38:26',NULL,'bab88878-fb5d-498c-8b48-2eb77c8be0e6'),
(106,99,NULL,42,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:36:37',NULL,'2025-04-18 18:38:26',NULL,'9b39a9a1-7d1d-4ac8-a0e3-5e92f89ee08f'),
(107,100,NULL,43,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:36:37',NULL,'2025-04-18 18:38:26',NULL,'840fe20c-b9d9-467e-9525-3f383a31b004'),
(108,101,NULL,44,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:36:37',NULL,'2025-04-18 18:38:26',NULL,'10a5e0c4-06b0-43fc-9f28-6ded2ef94793'),
(111,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-04-18 18:38:34','2025-09-29 18:59:42',NULL,NULL,NULL,'1c014517-f0ca-4b34-a4ec-8c06c66e936c'),
(112,111,NULL,46,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:40','2025-04-18 18:38:40',NULL,NULL,NULL,'b69fbe05-7e0a-444c-87cb-538dab008405'),
(113,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-04-18 18:38:44','2025-09-29 18:59:42',NULL,NULL,NULL,'e8577614-718f-4f49-9a2c-762b53180e15'),
(114,113,NULL,47,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:46','2025-04-18 18:38:46',NULL,NULL,NULL,'62564fb6-d7ee-42e1-a94c-0d101b1862ad'),
(115,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-04-18 18:38:49','2025-09-29 18:59:42',NULL,NULL,NULL,'c1291b59-240b-4c7d-a481-b43ceffa5843'),
(116,115,NULL,48,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:51','2025-04-18 18:38:51',NULL,NULL,NULL,'0de6d844-6a84-45b9-a5a4-219bf907924c'),
(117,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-04-18 18:38:54','2025-09-29 18:59:42',NULL,NULL,NULL,'c983b9b7-0678-4980-a3a6-bf04df690818'),
(118,117,NULL,49,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:56','2025-04-18 18:38:56',NULL,NULL,NULL,'6532d990-a37a-4e60-98a6-d2f6ad40d415'),
(119,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-04-18 18:38:58','2025-09-29 18:59:42',NULL,NULL,NULL,'07f26095-e9ed-4a30-9fcc-ee9e7b1c89a5'),
(120,119,NULL,50,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:39:00','2025-04-18 18:39:00',NULL,NULL,NULL,'9ef9e4fb-c780-42aa-b260-c57f1c904855'),
(121,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-04-18 18:39:03','2025-09-29 18:59:42',NULL,NULL,NULL,'f48f3d64-37db-4387-ad42-86a0d4022e8f'),
(122,121,NULL,51,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:39:04','2025-04-18 18:39:04',NULL,NULL,NULL,'5c8697a2-2860-47df-90df-d73d461ed250'),
(124,NULL,52,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:40:11','2025-04-18 18:40:11',NULL,NULL,NULL,'5166d027-121a-4f77-9b1e-d976affec3c3'),
(131,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-04-18 18:42:36','2025-08-20 17:52:26',NULL,NULL,NULL,'10a402bd-e708-4f1b-8f19-9d6f2dd41e56'),
(132,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-04-18 18:42:36','2025-08-20 17:52:26',NULL,NULL,NULL,'61411460-73b4-43ef-93b9-77c20db6e79f'),
(134,131,NULL,55,5,'craft\\elements\\Entry',1,0,'2025-04-18 18:42:36','2025-08-20 17:52:26',NULL,NULL,NULL,'f22c54ba-b032-4465-9c01-dc3499eaf990'),
(135,132,NULL,56,5,'craft\\elements\\Entry',1,0,'2025-04-18 18:42:36','2025-08-20 17:52:26',NULL,NULL,NULL,'951dcef9-231c-4dde-b1c2-ae7b0fdeaba9'),
(136,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-04-18 18:44:35','2025-04-18 18:44:35',NULL,NULL,NULL,'73525736-57a1-472f-b811-bd05b62fb341'),
(137,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-04-18 18:44:36','2025-04-18 18:44:36',NULL,NULL,NULL,'abf930ea-95bc-4a2c-9696-8a563fc70185'),
(138,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-04-18 18:44:36','2025-04-18 18:44:36',NULL,NULL,NULL,'10a14980-1c09-497a-af73-3d142632703b'),
(220,NULL,96,NULL,2,'craft\\elements\\Entry',1,0,'2025-04-25 18:32:58','2025-04-25 18:32:58',NULL,NULL,NULL,'c5f32f5e-4201-48e7-b118-a723db8874fd'),
(283,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-07-30 21:03:21','2025-09-19 17:25:28',NULL,'2025-09-19 17:25:28',NULL,'4ec784d1-6952-4acb-85c3-56b744ba0e4f'),
(284,283,NULL,133,12,'craft\\elements\\Entry',1,0,'2025-07-30 21:07:37','2025-07-30 21:07:37',NULL,'2025-09-19 17:25:28',NULL,'d91825b2-b7b9-4fd2-9aec-343ce2cd1923'),
(285,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-07-30 22:47:59','2025-09-05 20:01:00',NULL,NULL,NULL,'805f8534-dd6f-4152-b919-0c5d87163b8b'),
(287,283,NULL,134,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:48:02','2025-07-30 22:48:02',NULL,'2025-09-19 17:25:28',NULL,'5a62d56e-00f3-4b23-9e5c-8d4e1333ea76'),
(288,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:29','2025-07-30 23:11:09',NULL,'2025-07-30 23:11:09',NULL,'f63f9936-131d-4c53-a08c-8479797747f2'),
(289,288,NULL,135,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:29','2025-07-30 22:56:29',NULL,'2025-07-30 23:11:09',NULL,'543128e6-7c91-492f-9438-6b07c988b05a'),
(290,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:32','2025-09-19 17:25:28',NULL,'2025-09-19 17:25:28',NULL,'2a15ad68-0e5b-4d2b-8e9b-d02cf1d4457f'),
(291,290,NULL,136,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:32','2025-07-30 22:56:32',NULL,'2025-09-19 17:25:28',NULL,'13ecbf19-a864-4bdc-be24-bf94ea582ebe'),
(292,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:33','2025-09-19 17:25:28',NULL,'2025-09-19 17:25:28',NULL,'fabdb4bb-67e5-4bd7-b818-c4e6e4094b75'),
(293,292,NULL,137,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:33','2025-07-30 22:56:33',NULL,'2025-09-19 17:25:28',NULL,'dcb8c580-bb1b-40fe-97ba-ad716c474ba1'),
(294,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:34','2025-09-19 17:25:28',NULL,'2025-09-19 17:25:28',NULL,'6b7a16eb-660d-4393-95fe-4f8c34f97d49'),
(295,294,NULL,138,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:34','2025-07-30 22:56:34',NULL,'2025-09-19 17:25:28',NULL,'22d6754d-4135-482b-891b-bb366b3e7d90'),
(296,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:35','2025-09-19 17:25:28',NULL,'2025-09-19 17:25:28',NULL,'8755e2a1-5452-40d8-bb12-b26a15d3c5ad'),
(297,296,NULL,139,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:35','2025-07-30 22:56:35',NULL,'2025-09-19 17:25:28',NULL,'0d1d0b08-140e-4c49-8bfa-70d3b8406bbe'),
(299,288,NULL,140,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:58:03','2025-07-30 22:58:03',NULL,'2025-07-30 23:11:09',NULL,'68b59346-df11-46ae-a35a-99ad3efd0769'),
(301,290,NULL,141,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:58:06','2025-07-30 22:58:06',NULL,'2025-09-19 17:25:28',NULL,'ecb6636c-b8a8-4058-b118-829e13f652a3'),
(303,292,NULL,142,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:58:10','2025-07-30 22:58:10',NULL,'2025-09-19 17:25:28',NULL,'c0d976a8-5eea-446d-84d0-550445c219a0'),
(305,288,NULL,143,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:10:31','2025-07-30 23:10:31',NULL,'2025-07-30 23:11:09',NULL,'f286d6c6-85f4-4ea0-83d1-77d0f50d96a8'),
(306,283,NULL,144,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:10:37','2025-07-30 23:10:37',NULL,'2025-09-19 17:25:28',NULL,'d783f074-7582-4c2e-b04a-afee352e2417'),
(308,296,NULL,145,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:10:45','2025-07-30 23:10:45',NULL,'2025-09-19 17:25:28',NULL,'8c24349f-c77d-4763-956c-b9d29db3da7d'),
(310,292,NULL,146,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:10:55','2025-07-30 23:10:55',NULL,'2025-09-19 17:25:28',NULL,'bba6679f-f1f7-48bb-bbc1-928afdadf0a2'),
(311,290,NULL,147,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:11:02','2025-07-30 23:11:02',NULL,'2025-09-19 17:25:28',NULL,'2513036e-aebf-45d2-a083-ba0cc0d0623a'),
(314,294,NULL,148,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:11:29','2025-07-30 23:11:29',NULL,'2025-09-19 17:25:28',NULL,'721a1151-d124-44df-8f94-1b90139041f8'),
(315,296,NULL,149,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:11:31','2025-07-30 23:11:31',NULL,'2025-09-19 17:25:28',NULL,'f695af88-e16a-46f4-a0d4-156e20b34fb2'),
(318,NULL,137,NULL,3,'craft\\elements\\Entry',1,0,'2025-07-31 17:41:05','2025-07-31 17:41:05',NULL,NULL,NULL,'41f2a05b-7f0e-41c8-972f-8796e135476d'),
(323,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:15','2025-08-01 18:04:08',NULL,'2025-08-01 18:04:08',NULL,'6b3e54cf-b357-46c1-8251-4cd6c1f951b1'),
(324,323,NULL,152,15,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:31','2025-08-01 17:59:31',NULL,'2025-08-01 18:04:08',NULL,'168018b4-8cee-43fd-bf87-7af9c47cced8'),
(325,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:34','2025-08-01 18:06:11',NULL,NULL,NULL,'583d4518-7524-42db-a63d-0d921f008d36'),
(326,325,NULL,153,15,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:41','2025-08-01 17:59:41',NULL,NULL,NULL,'52a01e8d-717e-470b-bbc1-3dd874556d25'),
(328,325,NULL,154,14,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:53','2025-08-01 17:59:53',NULL,NULL,NULL,'c817c185-395d-435a-84c6-42430c2239a4'),
(329,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:04:51','2025-08-01 18:04:57',NULL,NULL,NULL,'328e73a9-9198-46ee-8ce1-292e019d2ac6'),
(330,329,NULL,155,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:04:57','2025-08-01 18:04:57',NULL,NULL,NULL,'82c64f78-283c-4a64-9681-11a3be4d4d40'),
(331,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:04:57','2025-08-01 18:05:01',NULL,NULL,NULL,'de1dbf90-2df4-4a57-8ef0-88e981636992'),
(332,331,NULL,156,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:01','2025-08-01 18:05:01',NULL,NULL,NULL,'ae5cc034-9679-48f5-9594-0c61fafe6990'),
(333,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:01','2025-08-01 18:05:04',NULL,NULL,NULL,'27c35b6d-8b9d-4bcc-abaf-a2338d548dfa'),
(334,333,NULL,157,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:04','2025-08-01 18:05:04',NULL,NULL,NULL,'70055f31-2d03-42d3-a985-121a1e2b2572'),
(335,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:04','2025-08-01 18:05:08',NULL,NULL,NULL,'5d7aa22c-6b88-4187-afb5-24fffb7c6539'),
(336,335,NULL,158,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:08','2025-08-01 18:05:08',NULL,NULL,NULL,'52c8f108-5ec7-4eb7-83e1-4c214d2d933b'),
(337,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:08','2025-08-01 18:05:10',NULL,NULL,NULL,'fdc36882-7b46-43fa-8ff9-4245e8dd9bd0'),
(338,337,NULL,159,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:10','2025-08-01 18:05:10',NULL,NULL,NULL,'1070a399-73d2-43b8-ad87-2e72974ec72a'),
(339,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:10','2025-08-01 18:05:15',NULL,NULL,NULL,'2558370f-56ae-47a6-8deb-2d7cb1e6ffe8'),
(340,339,NULL,160,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:15','2025-08-01 18:05:15',NULL,NULL,NULL,'a717b773-e41d-4eb4-a975-1f516ac78eeb'),
(341,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:15','2025-08-01 18:05:18',NULL,NULL,NULL,'c8f9f0cd-8e20-41d4-984b-30b14d2471af'),
(342,341,NULL,161,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:18','2025-08-01 18:05:18',NULL,NULL,NULL,'9b932f54-8d57-46cd-8c94-e9932a283f31'),
(343,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:18','2025-08-01 18:05:21',NULL,NULL,NULL,'edff3928-0002-4ca4-8b65-c9328c6c7162'),
(344,343,NULL,162,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:21','2025-08-01 18:05:21',NULL,NULL,NULL,'6bfe948f-11ac-4494-8387-13a1d64719a8'),
(347,325,NULL,163,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:11','2025-08-01 18:06:11',NULL,NULL,NULL,'3b36b76d-7a5f-42fc-ba6e-2474c3e4f604'),
(348,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:11','2025-08-01 18:06:22',NULL,NULL,NULL,'af2219ff-28ec-46eb-b7f5-294fc48c9592'),
(349,348,NULL,164,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:22','2025-08-01 18:06:22',NULL,NULL,NULL,'49e28ec6-9273-48fd-bc9f-9624a56e7e96'),
(350,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:22','2025-08-01 18:06:40',NULL,NULL,NULL,'62a9aee5-450d-4d74-ac3c-22a50eb327d9'),
(351,350,NULL,165,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:40','2025-08-01 18:06:40',NULL,NULL,NULL,'f2c0689f-e1b0-4149-ba01-d0981abdda1e'),
(352,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:13','2025-08-01 18:07:25',NULL,NULL,NULL,'81854a0e-389f-4f30-8603-f133fa881688'),
(353,352,NULL,166,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:25','2025-08-01 18:07:25',NULL,NULL,NULL,'d5c48d8f-ac42-479e-8798-a50fc596d6d1'),
(354,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:25','2025-08-01 18:07:35',NULL,NULL,NULL,'7d9e199d-e444-4270-95c2-e0d6c18d7eda'),
(355,354,NULL,167,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:35','2025-08-01 18:07:35',NULL,NULL,NULL,'7a8fc6bc-eaf0-44e7-b00c-faab057bca0a'),
(356,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:35','2025-08-01 18:07:48',NULL,NULL,NULL,'1a91cd2e-f777-4327-82bf-9d4952df04dd'),
(357,356,NULL,168,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:48','2025-08-01 18:07:48',NULL,NULL,NULL,'da159131-b262-48b8-b0c9-8ca4af83f540'),
(358,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:51','2025-08-01 18:07:58',NULL,NULL,NULL,'83178051-07e6-40c6-ac65-1803e199667a'),
(359,358,NULL,169,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:58','2025-08-01 18:07:58',NULL,NULL,NULL,'d712ccab-478b-4d57-a770-e516c4c08e67'),
(360,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:01','2025-08-01 18:08:08',NULL,NULL,NULL,'47d21938-0536-4427-8f5f-cc02e140ab9d'),
(361,360,NULL,170,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:08','2025-08-01 18:08:08',NULL,NULL,NULL,'fae28537-8e36-4e69-a83a-8d0ddf218299'),
(362,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:10','2025-08-01 18:08:17',NULL,NULL,NULL,'d0e07c9d-1540-47f6-9214-6072a6894154'),
(363,362,NULL,171,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:17','2025-08-01 18:08:17',NULL,NULL,NULL,'695949a8-88ed-4210-8f64-4aa21bec75ad'),
(364,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:21','2025-08-01 18:08:31',NULL,NULL,NULL,'d55b94a3-92b7-4e30-85db-817cc33f7281'),
(365,364,NULL,172,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:31','2025-08-01 18:08:31',NULL,NULL,NULL,'9b0f4c33-4420-4c1a-a158-285c77d7ac98'),
(366,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:41','2025-08-01 18:09:02',NULL,NULL,NULL,'1c397521-de13-43d2-8460-dbda17e5b9dc'),
(367,366,NULL,173,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:02','2025-08-01 18:09:02',NULL,NULL,NULL,'3e8a2f04-8045-4812-af81-174a31a95925'),
(368,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:02','2025-08-01 18:09:12',NULL,NULL,NULL,'8ee85d47-9148-40ec-bd5b-c84d73572f95'),
(369,368,NULL,174,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:12','2025-08-01 18:09:12',NULL,NULL,NULL,'d99724a6-54f1-4049-b361-55adf27661e2'),
(370,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:12','2025-08-01 18:09:33',NULL,NULL,NULL,'2ce7941c-d93f-403c-bfd6-49b638f4035a'),
(371,370,NULL,175,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:33','2025-08-01 18:09:33',NULL,NULL,NULL,'c7581c6a-d0d7-4e1c-a436-ed6c88693ffd'),
(372,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:33','2025-08-01 18:09:44',NULL,NULL,NULL,'18f99c19-28c4-4251-8b65-2eb57599534e'),
(373,372,NULL,176,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:44','2025-08-01 18:09:44',NULL,NULL,NULL,'510e667e-1473-46b5-978c-c3d2101510f6'),
(374,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:44','2025-08-01 18:10:00',NULL,NULL,NULL,'f9783239-388c-401a-8006-ab0e5f64e90c'),
(375,374,NULL,177,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:00','2025-08-01 18:10:00',NULL,NULL,NULL,'cae79123-f9c7-4bf7-86e4-deb1ead10b4c'),
(376,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:00','2025-08-01 18:10:07',NULL,NULL,NULL,'82798d00-f457-47dd-a197-136a8979cb07'),
(377,376,NULL,178,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:07','2025-08-01 18:10:07',NULL,NULL,NULL,'539ea850-c01d-4267-a3ee-4238f88ce5cc'),
(378,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:07','2025-08-01 18:10:18',NULL,NULL,NULL,'8e689347-9d85-4f7e-98a0-fedc85d7efd8'),
(379,378,NULL,179,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:18','2025-08-01 18:10:18',NULL,NULL,NULL,'c04693d2-c401-4525-a351-aada42c7ef60'),
(380,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:18','2025-08-01 18:10:31',NULL,NULL,NULL,'5f7daf9d-7dfe-4651-aabb-f38c89bbee1a'),
(381,380,NULL,180,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:31','2025-08-01 18:10:31',NULL,NULL,NULL,'86babb64-34dc-45a1-863a-3200a52b8b2b'),
(382,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:45','2025-08-01 18:10:53',NULL,NULL,NULL,'59cac7d1-17fd-4d38-bb0d-aeabbdf85711'),
(383,382,NULL,181,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:53','2025-08-01 18:10:53',NULL,NULL,NULL,'99f0f1cb-7140-453a-97a3-2347159ad061'),
(384,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:57','2025-08-01 18:11:04',NULL,NULL,NULL,'f25f3853-7910-43ae-8a40-77d2c8cb955a'),
(385,384,NULL,182,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:04','2025-08-01 18:11:04',NULL,NULL,NULL,'2e6ec653-4724-40f0-9825-e0f16f6bfa46'),
(386,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:07','2025-08-01 18:11:17',NULL,NULL,NULL,'368912c4-ff2f-4791-b5f7-c7ab02e9366d'),
(387,386,NULL,183,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:17','2025-08-01 18:11:17',NULL,NULL,NULL,'c73507a9-d3c1-44e8-a1e5-6d417be2f20d'),
(388,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:20','2025-08-01 18:11:31',NULL,NULL,NULL,'95c17a71-7dbc-4bb1-bd1b-f68eef362ae3'),
(389,388,NULL,184,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:31','2025-08-01 18:11:31',NULL,NULL,NULL,'64da7682-e0dd-47fb-b824-18f245cc4a96'),
(390,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:35','2025-08-01 18:11:48',NULL,NULL,NULL,'86133147-b29a-42ed-adea-703e49287bba'),
(391,390,NULL,185,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:48','2025-08-01 18:11:48',NULL,NULL,NULL,'46f0d01f-8e54-45ad-82ce-574f2ca3b97b'),
(392,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:48','2025-08-01 18:12:02',NULL,NULL,NULL,'a250b11d-668e-42db-a3ef-4c92bd5c2c11'),
(393,392,NULL,186,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:02','2025-08-01 18:12:02',NULL,NULL,NULL,'c44b8aa0-829f-41d8-a2aa-564b5dca44b4'),
(394,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:03','2025-08-01 18:12:14',NULL,NULL,NULL,'673dd0fa-da64-4850-b460-39601e040741'),
(395,394,NULL,187,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:14','2025-08-01 18:12:14',NULL,NULL,NULL,'0a5a42ce-c4c8-4c85-bc6d-895c165cae4d'),
(396,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:14','2025-08-01 18:12:26',NULL,NULL,NULL,'bdb1359d-c180-4611-8a95-2eb8b1f816e1'),
(397,396,NULL,188,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:26','2025-08-01 18:12:26',NULL,NULL,NULL,'71b23c28-a5f2-4207-af9d-f5d212218964'),
(398,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:26','2025-08-01 18:12:34',NULL,NULL,NULL,'0cb6c888-0464-4bbb-a350-e279e9d68b35'),
(399,398,NULL,189,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:34','2025-08-01 18:12:34',NULL,NULL,NULL,'790a58f9-967e-4233-ba06-bf22f9465677'),
(400,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:46','2025-08-01 18:12:57',NULL,NULL,NULL,'c6ca4057-3b10-40f6-a7b5-bbf90d2b25aa'),
(401,400,NULL,190,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:57','2025-08-01 18:12:57',NULL,NULL,NULL,'473fe0de-7e10-487c-942b-04510711521b'),
(402,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:57','2025-08-01 18:13:07',NULL,NULL,NULL,'331b5ad6-85d6-4a40-a7e1-cb2cff2685eb'),
(403,402,NULL,191,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:07','2025-08-01 18:13:07',NULL,NULL,NULL,'7bfb3e73-2ffe-4080-843e-56ab6da363c4'),
(404,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:07','2025-08-01 18:13:20',NULL,NULL,NULL,'3a19f3c2-7434-48ca-bb52-5ed62fb004e3'),
(405,404,NULL,192,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:20','2025-08-01 18:13:20',NULL,NULL,NULL,'41e84075-2d04-47a9-bd20-a6c5f2d7f1a0'),
(406,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:20','2025-08-01 18:13:33',NULL,NULL,NULL,'4af36b42-1b01-4cd8-a0aa-90e28d3caa06'),
(407,406,NULL,193,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:33','2025-08-01 18:13:33',NULL,NULL,NULL,'82385c94-48ae-43fa-8fd6-629e2851bf81'),
(408,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:33','2025-08-01 18:13:42',NULL,NULL,NULL,'6df397ab-c7a8-4ca9-afb2-998ca8e61820'),
(409,408,NULL,194,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:42','2025-08-01 18:13:42',NULL,NULL,NULL,'62d62837-bd43-4e98-a743-3ac0d3dfccb3'),
(410,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:42','2025-08-01 18:13:53',NULL,NULL,NULL,'adb995c3-6ef3-49fd-b8f8-de40b96021d3'),
(411,410,NULL,195,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:53','2025-08-01 18:13:53',NULL,NULL,NULL,'16dbb9a1-3887-4648-97a1-e0ddda8ddec8'),
(412,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:53','2025-08-01 18:14:03',NULL,NULL,NULL,'278fe834-90b2-40c5-9857-c4d166881f23'),
(413,412,NULL,196,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:14:03','2025-08-01 18:14:03',NULL,NULL,NULL,'69ae175c-0c03-4018-83db-eff2a046c29f'),
(414,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:14:03','2025-08-01 18:14:13',NULL,NULL,NULL,'780c5721-1030-4d98-969b-9deff3557653'),
(415,414,NULL,197,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:14:13','2025-08-01 18:14:13',NULL,NULL,NULL,'7bc31cdf-c3c5-4335-b7bf-cc36f78001bf'),
(420,131,NULL,201,5,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'16280068-4786-4702-b34c-09c22cfd6196'),
(421,132,NULL,202,5,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'a06d4a0e-10ed-4645-92aa-853fc34d33bf'),
(426,56,NULL,207,3,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-10-23 01:39:49',NULL,NULL,NULL,'705e6945-919e-4d42-8f84-1f06ae7dcf2b'),
(427,57,NULL,208,3,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-10-23 01:39:49',NULL,NULL,NULL,'5981aa88-a731-49d8-b05b-699a4b3bb570'),
(428,63,NULL,209,3,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-10-23 01:39:49',NULL,NULL,NULL,'ce588e48-eda2-47ae-99f8-aaad483027ee'),
(429,72,NULL,210,4,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'6a3f966a-aa85-4161-a0b0-0433f1954e98'),
(430,73,NULL,211,4,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'63487207-f775-4ab2-bb13-b1b3dfd36313'),
(431,74,NULL,212,4,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'431fffd1-ee06-4838-a2bc-d7099d9afb7d'),
(432,75,NULL,213,4,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'df0c6fd0-93a8-4dfe-b4ac-06f4ace2525c'),
(433,76,NULL,214,4,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'4c13186c-43fc-4e46-b500-cce37bc371d5'),
(445,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-08-20 21:24:25','2025-09-11 18:48:35',NULL,'2025-09-11 18:48:35',NULL,'ae63e78a-7eeb-49e8-92cd-4ee9706e3f41'),
(452,36,NULL,222,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:57:06','2025-08-20 21:57:06',NULL,'2025-08-20 21:57:12',NULL,'6b7cd467-67b1-4146-8845-ab5d5f1a3dcc'),
(453,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:57:13','2025-08-20 21:57:20',NULL,'2025-08-20 21:58:20',NULL,'92e5d931-915e-4bdc-ba87-caa0a66a765b'),
(454,453,NULL,223,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:57:20','2025-08-20 21:57:20',NULL,NULL,NULL,'4a5509ff-de7f-42c9-8b46-96e3034eebc8'),
(455,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:57:25','2025-08-20 21:57:32',NULL,'2025-08-20 21:58:20',NULL,'a74613e1-4bfb-44a5-88a1-590b8dd7fdaa'),
(456,455,NULL,224,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:57:32','2025-08-20 21:57:32',NULL,NULL,NULL,'54f0ea99-df53-4b1c-ad97-316d341948ce'),
(457,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:58:35','2025-09-23 20:25:31',NULL,NULL,NULL,'6afe8b39-15ff-42bb-b973-3f0fdc816be2'),
(458,457,NULL,225,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:58:42','2025-08-20 21:58:42',NULL,NULL,NULL,'885e099b-06ad-4ca9-b798-1cc8eb8f0874'),
(459,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:58:47','2025-09-23 21:13:19',NULL,NULL,NULL,'d2b03ab3-9f68-48c7-b08a-fa96143faa3a'),
(460,459,NULL,226,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:58:54','2025-08-20 21:58:54',NULL,NULL,NULL,'4a02cd04-c703-4960-81f6-b02080e8cf60'),
(461,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:02','2025-09-23 20:25:25',NULL,NULL,NULL,'f1b0b1b6-ae43-43c7-bce0-29bcc5cd3a17'),
(462,461,NULL,227,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:06','2025-08-20 21:59:06',NULL,NULL,NULL,'f8ef6ca5-d997-41af-a600-4932f5cfbf34'),
(463,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:10','2025-09-23 20:25:37',NULL,NULL,NULL,'aa400bc6-8fa9-476b-b82a-cd3ccfb1803a'),
(464,463,NULL,228,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:15','2025-08-20 21:59:15',NULL,NULL,NULL,'6dfd32dc-d32f-448f-80f9-9f9c7eb16450'),
(465,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:23','2025-09-23 21:13:37',NULL,NULL,NULL,'25b87173-d04e-40ab-bd45-abe288dd5941'),
(466,465,NULL,229,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:33','2025-08-20 21:59:33',NULL,NULL,NULL,'bd10878c-d3f4-4a77-aac0-26a4ce94cd6f'),
(467,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:39','2025-09-23 20:25:55',NULL,NULL,NULL,'6ff7afbb-4b9a-483f-9da6-218c3997ad6f'),
(468,467,NULL,230,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:45','2025-08-20 21:59:45',NULL,NULL,NULL,'7a32a7f2-637a-4b64-8ae7-7cb144e935b2'),
(469,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:56','2025-09-23 20:26:04',NULL,NULL,NULL,'cd4f4662-0b03-4087-9e8f-1b485f959b82'),
(470,469,NULL,231,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:03','2025-08-20 22:00:03',NULL,NULL,NULL,'3131549f-c089-4f69-96e5-e59fde4a9009'),
(471,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:03','2025-09-23 20:26:11',NULL,NULL,NULL,'f4ec289c-bde1-4c45-bfbb-5c1069a516e0'),
(472,471,NULL,232,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:11','2025-08-20 22:00:11',NULL,NULL,NULL,'d12f9c87-584a-4bbf-be08-e02a6ca26147'),
(473,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:11','2025-08-20 22:00:22',NULL,NULL,NULL,'e0971592-0abc-45c9-9817-fa746354d89b'),
(474,473,NULL,233,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:22','2025-08-20 22:00:22',NULL,NULL,NULL,'ce04c12a-98d4-449f-8835-7c027df5d590'),
(475,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:31','2025-09-23 20:26:26',NULL,NULL,NULL,'544f9c74-39e1-48a1-b848-5c91ce2903e3'),
(476,475,NULL,234,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:38','2025-08-20 22:00:38',NULL,NULL,NULL,'7a1268bf-5a4e-4e66-95a8-801a89088c9f'),
(477,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:42','2025-09-23 20:26:34',NULL,NULL,NULL,'aab1bf62-810e-4549-8f8d-319f5098e937'),
(478,477,NULL,235,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:46','2025-08-20 22:00:46',NULL,NULL,NULL,'f83a6d0f-e336-4b20-94d9-f7a5bea8f26f'),
(479,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:52','2025-09-23 20:26:42',NULL,NULL,NULL,'5824e18b-943c-49f4-aee0-26e9486372c4'),
(480,479,NULL,236,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:59','2025-08-20 22:00:59',NULL,NULL,NULL,'6ac0ebba-f48a-49af-a6fc-eb49875f0a4c'),
(481,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:02','2025-09-23 20:26:54',NULL,NULL,NULL,'53138f5c-15f3-46af-9c57-838c36ff6907'),
(482,481,NULL,237,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:08','2025-08-20 22:01:08',NULL,NULL,NULL,'592f6284-128f-4372-8839-e24271e9a5e0'),
(483,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:12','2025-09-23 20:27:03',NULL,NULL,NULL,'db4fc231-4ebe-49dd-9e62-ea62d3c23f72'),
(484,483,NULL,238,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:17','2025-08-20 22:01:17',NULL,NULL,NULL,'485ae322-0a90-47c8-aa28-1a535baff5c5'),
(485,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:22','2025-09-23 20:27:13',NULL,NULL,NULL,'019352c4-069d-42e8-8424-ac0de36a3ff3'),
(486,485,NULL,239,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:30','2025-08-20 22:01:30',NULL,NULL,NULL,'5b15e794-120c-4028-a939-70a24320f03a'),
(487,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:56','2025-09-23 21:13:50',NULL,NULL,NULL,'12909ae0-a512-4b87-a2de-762fc097ba48'),
(488,487,NULL,240,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:03','2025-08-20 22:02:03',NULL,NULL,NULL,'8f2f40b7-c8dd-4269-9a64-5ebeb4c3c3fb'),
(489,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:05','2025-09-23 20:29:09',NULL,NULL,NULL,'25f98012-5633-4829-b941-2757508affba'),
(490,489,NULL,241,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:13','2025-08-20 22:02:13',NULL,NULL,NULL,'b7550ee6-d64a-4724-9914-4c567aa2ece7'),
(491,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:13','2025-09-23 20:29:17',NULL,NULL,NULL,'50117c21-038a-42be-bf0c-d5732fc15be7'),
(492,491,NULL,242,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:19','2025-08-20 22:02:19',NULL,NULL,NULL,'43c9b5a3-7c85-4352-a122-8a3f4c8a8616'),
(493,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:23','2025-09-23 20:29:24',NULL,NULL,NULL,'c8d4490f-c38e-4c36-a37e-57c3a8a9b1a3'),
(494,493,NULL,243,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:28','2025-08-20 22:02:28',NULL,NULL,NULL,'1861e046-fd59-41b8-beb6-8ec6c9a75cec'),
(495,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:28','2025-09-23 20:29:38',NULL,NULL,NULL,'5e632a25-c3f5-48b7-b309-57ff17c2b80f'),
(496,495,NULL,244,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:34','2025-08-20 22:02:34',NULL,NULL,NULL,'c838b1bb-69d2-47a9-a1c1-1a84fde8ca9a'),
(497,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:53','2025-09-23 21:13:43',NULL,NULL,NULL,'68eb2786-c4db-4964-b947-56e3b1a85a38'),
(498,497,NULL,245,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:59','2025-08-20 22:02:59',NULL,NULL,NULL,'01d3e7fa-cfdf-4d96-b03e-c0e321fbc668'),
(499,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:20','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'0ce91c4a-ace5-4055-b123-443e291031f2'),
(500,499,NULL,246,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:23','2025-08-20 22:12:23',NULL,'2025-09-26 17:59:44',NULL,'09985d3b-e9d4-4eed-9b6a-d07a77b69524'),
(501,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:23','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'372887eb-9909-4edd-b5ea-459796d65105'),
(502,501,NULL,247,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:28','2025-08-20 22:12:28',NULL,'2025-09-26 17:59:44',NULL,'fdcb9b26-a13b-44e2-b4b9-38c3e52e4436'),
(503,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:32','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'07e6baca-fca0-4500-aabe-36a66b94ad5b'),
(504,503,NULL,248,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:34','2025-08-20 22:12:34',NULL,'2025-09-26 17:59:44',NULL,'a1979fb9-d778-4efe-96bd-5742c169e4c0'),
(505,NULL,224,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:34','2025-08-20 22:12:34',NULL,NULL,NULL,'d5b94a83-6ba3-4e1d-96e3-85cae8ddb0c1'),
(506,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:49','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'5ebee889-c8d9-4b9f-8bf7-a62ae1a29956'),
(507,506,NULL,249,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:50','2025-08-20 22:12:50',NULL,'2025-09-26 17:59:44',NULL,'ac17d91b-f5d0-4971-8b0b-cdc61f16d510'),
(508,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:50','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'98ca941b-4d3d-4084-bc19-15ee6f02b9a0'),
(509,508,NULL,250,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:54','2025-08-20 22:12:54',NULL,'2025-09-26 17:59:44',NULL,'c9960642-98ec-4f90-827f-3a044bb7c082'),
(510,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:54','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'7b3bdf54-cae0-4032-b4f1-acc65e1beb0f'),
(511,510,NULL,251,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:57','2025-08-20 22:12:57',NULL,'2025-09-26 17:59:44',NULL,'bcac39b9-622a-43cc-805f-8639537ff312'),
(512,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:57','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'ec55fc9e-09c2-4e54-b4a8-df507090f928'),
(513,512,NULL,252,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:01','2025-08-20 22:13:01',NULL,'2025-09-26 17:59:44',NULL,'529baec6-ff2b-4ba4-905c-a0f1428b7f6b'),
(514,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:01','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'7d5b01fc-0c04-4065-ad4a-43f3c0ced039'),
(515,514,NULL,253,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:04','2025-08-20 22:13:04',NULL,'2025-09-26 17:59:44',NULL,'bc91f4c4-eaba-4d4f-a70c-490b78486402'),
(516,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:04','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'5fd7eefd-57e5-49b8-b751-0f0cc5db74bf'),
(517,516,NULL,254,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:07','2025-08-20 22:13:07',NULL,'2025-09-26 17:59:44',NULL,'71b81f4e-a2f8-43a1-b9b0-2c7dfc7adcc4'),
(518,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:07','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'73a2ffe4-2e14-4cfd-86de-d43278471aec'),
(519,518,NULL,255,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:10','2025-08-20 22:13:10',NULL,'2025-09-26 17:59:44',NULL,'627cf149-b41f-40ef-86f3-6cb12a2e47cc'),
(520,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:10','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'6518b18a-a543-41c0-9993-1ecebe38c0fb'),
(521,520,NULL,256,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:13','2025-08-20 22:13:13',NULL,'2025-09-26 17:59:44',NULL,'ec864cfd-7930-42ab-8ce1-a3eb03c4cf77'),
(522,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:13','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'a9d646b2-ab9b-4d0f-95a0-b1389cb6a587'),
(523,522,NULL,257,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:15','2025-08-20 22:13:15',NULL,'2025-09-26 17:59:44',NULL,'31f7b586-090d-4d4a-a050-1d74b96a7f51'),
(524,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:15','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'9bda47a5-c030-4f3a-8918-3f21140d5519'),
(525,524,NULL,258,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:18','2025-08-20 22:13:18',NULL,'2025-09-26 17:59:44',NULL,'6f7a86a5-d734-4d6b-a8b6-747209a7ee0b'),
(530,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:17:42','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'ee840fa4-636f-423a-9142-830b7c0e85d3'),
(531,530,NULL,260,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:17:46','2025-08-20 22:17:46',NULL,'2025-09-26 17:59:44',NULL,'ad752b76-fe98-477b-8889-9948c9492c9b'),
(532,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:17:53','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'3638cb68-2a5a-43d0-a9f7-64efac14abf3'),
(533,532,NULL,261,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:18:02','2025-08-20 22:18:02',NULL,'2025-09-26 17:59:44',NULL,'3abc8fb7-bb91-4f65-8767-397b8e7fc8a2'),
(534,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:18:14','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'ede61ecf-d245-424c-975b-73d620cf6db3'),
(535,534,NULL,262,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:18:21','2025-08-20 22:18:21',NULL,'2025-09-26 17:59:44',NULL,'73f04776-257b-4186-a45b-53b68a59f537'),
(536,534,NULL,263,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:18:29','2025-08-20 22:18:29',NULL,'2025-09-26 17:59:44',NULL,'759b074e-21ae-4792-bdc5-82829ff9e5e6'),
(545,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-09-02 20:43:21','2025-09-02 20:43:21',NULL,NULL,NULL,'b2b558ce-cd40-4d4c-a797-ca5bb55acd23'),
(548,NULL,NULL,NULL,9,'craft\\elements\\Asset',1,0,'2025-09-02 21:15:29','2025-09-02 21:15:29',NULL,NULL,NULL,'229e6ff4-c6db-48ed-8904-f9db2161ad70'),
(553,2,NULL,272,1,'craft\\elements\\Entry',1,0,'2025-09-02 21:46:06','2025-09-02 21:46:06',NULL,NULL,NULL,'23125f1d-4f6b-4631-b698-3c6276b803b3'),
(554,NULL,NULL,NULL,16,'craft\\elements\\GlobalSet',1,0,'2025-09-02 21:50:29','2025-10-23 00:48:30',NULL,NULL,NULL,'ac2e66d3-984a-4e83-b29d-422f84e8c085'),
(555,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-09-02 22:24:40','2025-09-29 18:59:42',NULL,NULL,NULL,'d84d167e-eaf4-4415-99d2-ab38cfaa1965'),
(556,555,NULL,273,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:24:46','2025-09-02 22:24:46',NULL,NULL,NULL,'6a620e7e-d6e3-4a23-a5f8-6258867f4daa'),
(557,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-09-02 22:24:46','2025-09-29 18:59:42',NULL,NULL,NULL,'1cee90b2-4187-4b57-a0bd-db245bf510a1'),
(558,557,NULL,274,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:24:52','2025-09-02 22:24:52',NULL,NULL,NULL,'f836702a-f488-4fee-90ed-15f1cb5bb4a1'),
(559,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-09-02 22:24:52','2025-09-29 18:59:42',NULL,NULL,NULL,'2abc4ce0-fc48-4a6c-9c02-573fdcccfd9e'),
(560,559,NULL,275,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:24:59','2025-09-02 22:24:59',NULL,NULL,NULL,'0264ae86-3a96-46f7-837a-1ee4c05e4104'),
(561,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-09-02 22:24:59','2025-09-29 18:59:42',NULL,NULL,NULL,'d6eb4e88-c542-461f-a878-846ece13c964'),
(562,561,NULL,276,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:25:02','2025-09-02 22:25:02',NULL,NULL,NULL,'66eca11b-cd50-46c2-a268-d41bf867f57d'),
(563,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-09-02 22:25:02','2025-09-29 18:59:42',NULL,NULL,NULL,'42130eab-77a7-44f1-83bb-7d6217866d87'),
(564,563,NULL,277,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:25:06','2025-09-02 22:25:06',NULL,NULL,NULL,'b4b77612-2541-43d8-82d0-4fc70a534781'),
(566,2,NULL,278,1,'craft\\elements\\Entry',1,0,'2025-09-02 22:26:19','2025-09-02 22:26:19',NULL,NULL,NULL,'e66b361a-afdb-4938-bea9-dfbce02ac7c4'),
(568,2,NULL,279,1,'craft\\elements\\Entry',1,0,'2025-09-02 22:26:44','2025-09-02 22:26:44',NULL,NULL,NULL,'406473a9-3124-4715-a7fc-69bffdb23581'),
(570,2,NULL,280,1,'craft\\elements\\Entry',1,0,'2025-09-02 22:27:53','2025-09-02 22:27:53',NULL,NULL,NULL,'ac6de050-ca9d-41d0-a8c4-8ed04545d9fb'),
(575,2,NULL,281,1,'craft\\elements\\Entry',1,0,'2025-09-02 22:28:18','2025-09-02 22:28:18',NULL,NULL,NULL,'87ee2d89-619f-4253-a750-b3b0c959bd62'),
(577,2,NULL,282,1,'craft\\elements\\Entry',1,0,'2025-09-03 01:11:03','2025-09-03 01:11:03',NULL,NULL,NULL,'b880b4ad-fb48-40e0-b69a-57063decd1a9'),
(581,2,NULL,284,1,'craft\\elements\\Entry',1,0,'2025-09-03 19:59:09','2025-09-03 19:59:09',NULL,NULL,NULL,'15378359-c704-42d1-b7a5-3617822ce0e5'),
(586,2,NULL,285,1,'craft\\elements\\Entry',1,0,'2025-09-03 21:05:58','2025-09-03 21:05:58',NULL,NULL,NULL,'75f819fc-b8d4-43c7-9b21-d330c09b78ab'),
(587,56,NULL,286,3,'craft\\elements\\Entry',1,0,'2025-09-03 21:05:58','2025-09-03 21:05:58',NULL,NULL,NULL,'00567ab8-f390-4a29-87ef-1d98b34e4d5e'),
(588,57,NULL,287,3,'craft\\elements\\Entry',1,0,'2025-09-03 21:05:58','2025-09-03 21:05:58',NULL,NULL,NULL,'a1ef1575-747a-40ff-ab52-7d93e4303e22'),
(589,63,NULL,288,3,'craft\\elements\\Entry',1,0,'2025-09-03 21:05:58','2025-09-03 21:05:58',NULL,NULL,NULL,'16fd532f-395f-4c22-999d-c5cb59a60542'),
(592,2,NULL,289,1,'craft\\elements\\Entry',1,0,'2025-09-03 21:06:15','2025-09-03 21:06:15',NULL,NULL,NULL,'bffaeda7-0048-432d-9e5e-517fc27be3db'),
(593,63,NULL,290,3,'craft\\elements\\Entry',1,0,'2025-09-03 21:06:15','2025-09-03 21:06:15',NULL,NULL,NULL,'f64dc4e0-f21a-4b12-8a56-b8b8a1b1ba5d'),
(596,2,NULL,291,1,'craft\\elements\\Entry',1,0,'2025-09-03 21:08:08','2025-09-03 21:08:08',NULL,NULL,NULL,'bf84cc3e-fe8b-4026-afb0-f4e9a6d000f0'),
(597,63,NULL,292,3,'craft\\elements\\Entry',1,0,'2025-09-03 21:08:08','2025-09-03 21:08:08',NULL,NULL,NULL,'83cf04aa-cff0-4968-8a54-92870b171901'),
(599,2,NULL,293,1,'craft\\elements\\Entry',1,0,'2025-09-03 21:21:53','2025-09-03 21:21:53',NULL,NULL,NULL,'6b31251e-1ce2-445a-a160-3adf5e41b5a4'),
(601,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:04','2025-10-03 20:24:31',NULL,NULL,NULL,'9a0f8b68-a562-4873-b0ed-8507a6b25f6a'),
(602,601,NULL,294,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:33','2025-09-03 21:48:33',NULL,NULL,NULL,'5493f4d8-9cd9-489a-9503-1616b9080fd0'),
(603,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:33','2025-09-03 21:58:36',NULL,'2025-09-03 21:58:36',NULL,'836fd052-4d0c-4245-8774-acddb158100b'),
(604,603,NULL,295,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:45','2025-09-03 21:48:45',NULL,'2025-09-03 21:58:36',NULL,'8f5c13ca-7ca3-4c0c-b9cc-a6efdebd5579'),
(605,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:47','2025-10-03 20:24:40',NULL,NULL,NULL,'81303c7f-793e-4e55-bfa7-c02492f7c347'),
(606,605,NULL,296,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:52','2025-09-03 21:48:52',NULL,NULL,NULL,'7f0e29a6-41f3-45fd-925d-fd9e234a832a'),
(607,605,NULL,297,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:49:15','2025-09-03 21:49:15',NULL,NULL,NULL,'da47c1b6-8b38-4b88-808b-a3c12590b010'),
(608,601,NULL,298,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:49:20','2025-09-03 21:49:20',NULL,NULL,NULL,'6b9349c5-491f-4b98-9c0c-558baa78c3dd'),
(609,601,NULL,299,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:49:25','2025-09-03 21:49:26',NULL,NULL,NULL,'7d47a22a-2b18-45e2-a9be-172f304f50b1'),
(610,601,NULL,300,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:52:33','2025-09-03 21:52:33',NULL,NULL,NULL,'187fd43b-d044-4624-afc8-234a7d9a5532'),
(612,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-03 21:56:34','2025-09-03 21:56:34',NULL,NULL,NULL,'b6a9c079-dc19-4954-b3f6-6ac89a38efea'),
(613,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-03 21:56:34','2025-09-03 21:56:34',NULL,NULL,NULL,'201462f8-ba2a-4661-84ed-78215a573b9d'),
(614,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-03 21:56:35','2025-10-08 18:25:13',NULL,NULL,NULL,'1c2571b2-105d-4981-882f-33972a3fa4f6'),
(616,601,NULL,301,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:56:43','2025-09-03 21:56:43',NULL,NULL,NULL,'271d147f-fb1b-4556-92ef-f203c3166ec0'),
(617,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:56:43','2025-10-03 20:24:49',NULL,NULL,NULL,'17aedcab-15f5-449a-a2ee-a3f262aa4476'),
(618,617,NULL,302,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:56:47','2025-09-03 21:56:47',NULL,NULL,NULL,'87697077-a17f-4c23-aae4-1a85ccbe1848'),
(619,617,NULL,303,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:56:57','2025-09-03 21:56:57',NULL,NULL,NULL,'7cdd5ba4-6db4-41b5-9831-12e4bdbcac37'),
(621,617,NULL,304,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:57:10','2025-09-03 21:57:10',NULL,NULL,NULL,'13fcae8c-1e31-42a7-8a3a-cb30b2361924'),
(623,605,NULL,305,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:58:30','2025-09-03 21:58:30',NULL,NULL,NULL,'396501be-a3ae-4f36-9f6a-93100cf965c8'),
(624,NULL,280,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:58:41','2025-09-03 21:58:41',NULL,NULL,NULL,'d1a40978-5caf-4aae-a94d-4f2bc707514c'),
(625,2,NULL,306,1,'craft\\elements\\Entry',1,0,'2025-09-03 21:59:11','2025-09-03 21:59:11',NULL,NULL,NULL,'b5ebfcfa-bdca-43d6-be70-54ef931f1886'),
(627,2,NULL,307,1,'craft\\elements\\Entry',1,0,'2025-09-03 22:00:27','2025-09-03 22:00:27',NULL,NULL,NULL,'4f1169ce-377f-4715-9313-747ce51ebf82'),
(629,601,NULL,308,5,'craft\\elements\\Entry',1,0,'2025-09-03 22:13:41','2025-09-03 22:13:41',NULL,NULL,NULL,'f99e598e-5b3f-408e-a17b-84356450ed28'),
(630,2,NULL,309,1,'craft\\elements\\Entry',1,0,'2025-09-03 22:13:43','2025-09-03 22:13:43',NULL,NULL,NULL,'ee2306c4-1096-43a3-a639-4da1cc2cdd16'),
(632,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-09-03 22:27:11','2025-09-03 22:27:11',NULL,NULL,NULL,'091c844c-50d7-4e50-bafa-a6bf56239538'),
(634,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-09-03 22:27:23','2025-09-03 22:27:23',NULL,NULL,NULL,'a5ef07ab-c50e-4220-a35a-0951d700536e'),
(636,2,NULL,310,1,'craft\\elements\\Entry',1,0,'2025-09-03 22:27:29','2025-09-03 22:27:30',NULL,NULL,NULL,'927bb0f8-4b17-4c65-8d99-1f778f903322'),
(637,44,NULL,311,2,'craft\\elements\\Entry',1,0,'2025-09-03 22:27:30','2025-09-03 22:27:30',NULL,'2025-09-11 18:48:35',NULL,'0fceaddd-72a5-45fd-84d0-23dab07d78bb'),
(638,445,NULL,312,2,'craft\\elements\\Entry',1,0,'2025-09-03 22:27:30','2025-09-03 22:27:30',NULL,'2025-09-11 18:48:35',NULL,'d1d14c83-6091-4c8f-a603-acc72dd8de77'),
(640,2,NULL,313,1,'craft\\elements\\Entry',1,0,'2025-09-03 22:28:47','2025-09-03 22:28:47',NULL,NULL,NULL,'7ab34e60-a78f-445e-8ea3-e5b9c1dee16e'),
(643,294,NULL,314,12,'craft\\elements\\Entry',1,0,'2025-09-05 20:01:00','2025-09-05 20:01:00',NULL,'2025-09-19 17:25:28',NULL,'7eafbe4f-c358-4e15-881c-a9746014b665'),
(645,294,NULL,315,12,'craft\\elements\\Entry',1,0,'2025-09-05 20:01:26','2025-09-05 20:01:26',NULL,'2025-09-19 17:25:28',NULL,'6047d60c-06f7-41db-a671-e6e8a8bb216d'),
(646,294,NULL,316,12,'craft\\elements\\Entry',1,0,'2025-09-05 20:01:55','2025-09-05 20:01:55',NULL,'2025-09-19 17:25:28',NULL,'be7fa520-3857-4afe-84d0-cdae09d42dce'),
(647,2,NULL,317,1,'craft\\elements\\Entry',1,0,'2025-09-11 17:30:28','2025-09-11 17:30:28',NULL,NULL,NULL,'1fce243f-20e5-4f45-8c7b-053b878a1e6b'),
(648,2,NULL,318,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:32','2025-09-11 18:16:32',NULL,NULL,NULL,'5b2c04e8-b905-4f6e-88ee-898ee7839269'),
(649,56,NULL,319,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:32','2025-09-11 18:16:32',NULL,NULL,NULL,'905845c7-66b1-4db1-b559-6bb13b4b2de9'),
(650,57,NULL,320,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:32','2025-09-11 18:16:32',NULL,NULL,NULL,'bbd10392-6dde-4d9e-aeee-ef45959ee705'),
(651,63,NULL,321,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:32','2025-09-11 18:16:32',NULL,NULL,NULL,'588cd696-05da-4324-8587-dbecd42c1b68'),
(652,44,NULL,322,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:32','2025-09-11 18:16:32',NULL,'2025-09-11 18:48:35',NULL,'592458e2-0949-4bca-a262-241135ba53d1'),
(653,445,NULL,323,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:32','2025-09-11 18:16:32',NULL,'2025-09-11 18:48:35',NULL,'8a8c63d2-f9b9-4bd0-99ae-6afa17215b68'),
(834,2,NULL,414,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:35','2025-09-11 18:16:35',NULL,NULL,NULL,'82fd5379-edc8-473e-8eae-0a4c38627028'),
(835,56,NULL,415,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:35','2025-09-11 18:16:35',NULL,NULL,NULL,'3d2e1b65-21e5-4b61-b39d-7af3c6514782'),
(836,57,NULL,416,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:35','2025-09-11 18:16:35',NULL,NULL,NULL,'7201ab16-8f87-4eb4-863f-9741b570da54'),
(837,63,NULL,417,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:35','2025-09-11 18:16:35',NULL,NULL,NULL,'faffecea-e5ff-4d44-9c15-2e6482072e68'),
(838,44,NULL,418,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:35','2025-09-11 18:16:35',NULL,'2025-09-11 18:48:35',NULL,'00d844b9-3946-4447-8a9f-ea6423199e05'),
(839,445,NULL,419,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:35','2025-09-11 18:16:35',NULL,'2025-09-11 18:48:35',NULL,'913a6407-8c18-4354-bce7-684f37a61b0a'),
(932,2,NULL,511,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:17:21','2025-09-11 18:17:21',NULL,NULL,NULL,'2d1fd9af-d8bc-4fdb-826e-d8170fef5752'),
(937,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:16',NULL,'2025-09-11 18:51:16',NULL,'24f55e9b-db5a-4235-9480-ab15fa446afa'),
(938,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:16',NULL,'2025-09-11 18:51:16',NULL,'a2418a26-2f30-4381-89b0-90c4cbe3dacb'),
(939,2,NULL,512,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'0608e6fd-701b-4ef9-bfb2-28202ae1886c'),
(940,56,NULL,513,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'a553cc4e-8e7d-4709-a19b-8d2cd234b877'),
(941,57,NULL,514,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'f56b37f2-34d1-4730-badb-a114a02b6029'),
(942,63,NULL,515,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'a4f6d4e7-738c-4de1-8dd5-e4e4ce07d859'),
(943,937,NULL,516,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:16',NULL,'773f8d6e-dfed-4e6e-83ab-6393a3764e56'),
(944,938,NULL,517,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:16',NULL,'c436d386-fa7b-4585-8b4c-e08d05082488'),
(945,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-14 16:13:45',NULL,NULL,NULL,'48a6c670-2b37-4c4d-8fd4-53ac20d90d2e'),
(946,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:16',NULL,'2025-09-11 18:51:16',NULL,'4677fc2c-6108-4598-bf64-bb392f01fb31'),
(947,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:16',NULL,'2025-09-11 18:51:16',NULL,'f6d15841-9c18-449c-9709-1cd9541bfcad'),
(948,945,NULL,518,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'d00d49ed-451a-4fdb-b911-c0dd3830e8f8'),
(949,946,NULL,519,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:16',NULL,'23bd81a5-b057-407f-9a12-423c4b17248f'),
(950,947,NULL,520,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:16',NULL,'429de7e3-148b-4e9e-b6f2-6e307adc6d7a'),
(951,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-10 18:22:39',NULL,NULL,NULL,'41b0861e-5cf7-40dd-9483-713f223be7e6'),
(952,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'b98b3342-f7f3-4cf7-a606-dfb8d8c57213'),
(953,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'7d66e02a-7cd7-43c9-b9f7-242ee195d3c9'),
(954,951,NULL,521,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'fee03515-569f-49ee-adf2-268d99539a65'),
(955,952,NULL,522,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'5e020e4c-9336-4523-a3b6-35fd878e2937'),
(956,953,NULL,523,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'408b201e-e403-43ec-ac8e-74c31393f3af'),
(957,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-08 22:20:19',NULL,NULL,NULL,'e399c88e-b5dc-4726-a6ed-2abac9d595cb'),
(958,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'c8a9aff4-6509-4848-8d3d-9f4311033df8'),
(959,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'14f9dc98-7af4-4950-8606-ecec2f3929d4'),
(960,957,NULL,524,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'e8874927-9f48-44ab-8399-c26f2b036a0d'),
(961,958,NULL,525,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'2448fede-bcb5-4ace-98a8-aff6695e4df6'),
(962,959,NULL,526,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'dc2ae1c5-62d2-40ce-8ed1-24d8733e65a1'),
(963,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-08 18:52:55',NULL,NULL,NULL,'73fa4e85-c923-4543-bb10-e2c4af7a8a17'),
(964,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'d81c823d-a779-49e9-a216-23cfb46cb460'),
(965,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'c254f4b1-a25c-4871-9fd3-69b5afebe8e6'),
(966,963,NULL,527,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'a21fa523-80fb-46ea-805c-0c79a2c01954'),
(967,964,NULL,528,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'3b464a7a-52fc-4e24-99dd-2d4eb9706fae'),
(968,965,NULL,529,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'dd64d8f9-be2f-40d1-a9ca-4b9f3cb36958'),
(969,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-08 19:00:47',NULL,NULL,NULL,'07e32559-1a52-481c-b6b0-cf9c82ae6850'),
(970,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'4d8952f3-ed9d-425f-9e15-5fe6f7bf26b6'),
(971,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'93a39675-83de-4d41-baf4-5f48eee70b29'),
(972,969,NULL,530,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'c5660b75-e1ce-4318-829a-c60ac71b25e8'),
(973,970,NULL,531,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'3b3fa9f9-a462-4c4c-af1f-83cd52d5b165'),
(974,971,NULL,532,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'5cf0cb2a-e814-4b30-b488-c2c1cfb581d2'),
(975,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-08 19:59:16',NULL,NULL,NULL,'2dc195b1-ef47-4f8b-8fe9-340e9da84901'),
(976,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'faa48ae5-3e79-4c59-bdc6-2aa586af5553'),
(977,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'5a8b5a39-85df-41bb-ac1e-10d860fe42e0'),
(978,975,NULL,533,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'67175160-28fc-4c6a-a070-f0ba8162580d'),
(979,976,NULL,534,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'d210c426-699d-4eea-b8e5-a8b22c5e5779'),
(980,977,NULL,535,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'4bd07ed0-8527-413c-9091-b6850b773e2c'),
(981,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-08 20:26:01',NULL,NULL,NULL,'1ce07899-fff0-4291-a8ab-81cc5f758ceb'),
(982,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'89785f90-186f-4e20-92e2-e4e13eb3fc91'),
(983,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'a60ca119-2b59-4ec7-9c47-0b6792cb9a53'),
(984,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'f8804960-fbb9-4691-82e6-47af75a67885'),
(985,981,NULL,536,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'2ff31236-ba07-46cb-8b22-885f7da30d1c'),
(986,982,NULL,537,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'f60b78b7-d499-4613-b9b2-3553ca165c5d'),
(987,983,NULL,538,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'f7435bea-b704-4e70-8961-143d3c3c1579'),
(988,984,NULL,539,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'cffbb52c-6dd3-4743-9b5d-a7ef325b2175'),
(989,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-09 15:36:03',NULL,NULL,NULL,'24ff8e10-f560-4744-b23a-be3b06e92a17'),
(990,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'55bd04a3-719f-48ca-b282-f2dd4556d0a2'),
(991,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'ce6367da-e26a-4506-a8ab-ce07526e1b47'),
(992,989,NULL,540,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'8886d22b-fe27-466a-b242-7a796f6f2f45'),
(993,990,NULL,541,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'122bb9c9-b72a-463f-9f48-f8cbaed95ea6'),
(994,991,NULL,542,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'74190f3a-9041-428a-b16e-ee4741323fee'),
(995,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-09 16:31:37',NULL,NULL,NULL,'9e6b6166-fdac-4d25-a9fd-5af0c347d533'),
(996,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'430a0992-651a-4999-8ab8-3ec562e0a769'),
(997,995,NULL,543,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'7cf080d4-86a9-4aaa-b315-118ae1207f6e'),
(998,996,NULL,544,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'d1d4a4a6-1fd3-447f-b00f-bed7b6dcbab5'),
(999,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-14 16:14:34',NULL,NULL,NULL,'6e18b054-3c3d-4c80-b7f6-2f7880b2b470'),
(1000,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'a221ac78-813c-4565-a618-069c18a125bd'),
(1001,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'4827e856-5dff-48af-b34b-97be57272aaf'),
(1002,999,NULL,545,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'e891c1c5-3d90-4227-94fa-cef374a97e4b'),
(1003,1000,NULL,546,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'7ffbf820-c595-4969-a049-c838993ee417'),
(1004,1001,NULL,547,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'e606e83b-c362-4d1f-aa6f-1c9fe4541cff'),
(1005,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-09 16:42:58',NULL,NULL,NULL,'5a87fb4c-c5fd-47b4-869e-ec6321ddf8d9'),
(1006,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'3de731a8-bb64-4220-8e1f-15102b5d8ee1'),
(1007,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'3414182c-7409-4c4f-a868-6c5f349bcd3c'),
(1008,1005,NULL,548,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'dda5d0cb-58f2-4149-958f-32b48f2bf45d'),
(1009,1006,NULL,549,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'9c234813-244f-415d-9dd0-21715c828f5f'),
(1010,1007,NULL,550,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'cbe40bb5-8ea1-4a4b-9770-3985889f0b8e'),
(1011,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-09 17:05:54',NULL,NULL,NULL,'95bbd3aa-0bb6-4efa-a47a-610d2b4e2cb3'),
(1012,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'6f95a7aa-4f67-469f-8038-8afcdb7c9685'),
(1013,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'c5bb4917-076b-4924-aec1-fd0c4f79a42c'),
(1014,1011,NULL,551,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'27bbd0e6-a56f-4a3f-8839-fd58d1be5299'),
(1015,1012,NULL,552,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'4e7c266d-b559-4240-af3a-f6a2b9e4360c'),
(1016,1013,NULL,553,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'13978b24-0157-45b8-b886-e9785b0e7126'),
(1017,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-09 17:10:31',NULL,NULL,NULL,'ce3eb7f7-2f87-4b59-9c53-05e0f3c21178'),
(1018,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'856571b0-b255-41c6-a5ae-a33bc32ab06c'),
(1019,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'c4a42116-23b5-4e52-a424-0c665420ab56'),
(1020,1017,NULL,554,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'cd4d931f-c631-47a8-8828-141c1add0474'),
(1021,1018,NULL,555,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'9cf29ee2-f40a-4ef9-ac7d-18404b1d9b61'),
(1022,1019,NULL,556,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'7c7e60b6-0853-480d-8577-ba223745e3ed'),
(1023,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-09 17:20:39',NULL,NULL,NULL,'f2039029-4db6-41fc-921f-6c250bc2b9d7'),
(1024,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'8d5e81f6-0e55-41b8-8147-3c13b5c87e67'),
(1025,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'668a4d24-7a2a-4c68-9eeb-6c95e34557bd'),
(1026,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'0d0fa5bf-4df1-4cf8-8f5c-24033275e48a'),
(1027,1023,NULL,557,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'cf8f523b-2ab7-4b05-8d54-9f197787cf21'),
(1028,1024,NULL,558,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'de20176b-6d25-4248-867c-9a8d438ac844'),
(1029,1025,NULL,559,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'0a9d5a84-0170-4d86-9106-105a3cb1a981'),
(1030,1026,NULL,560,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'6cff5b11-ddd8-4bd5-99a9-46539fc264ae'),
(1031,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:31',NULL,NULL,NULL,'950498f4-be9d-468b-a88c-f8c53d277de3'),
(1032,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'e0e830b2-2fe5-4efe-a492-5e1071461d5d'),
(1033,1031,NULL,561,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'93d7bde7-5e6f-49e9-b08e-455f032272e1'),
(1034,1032,NULL,562,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'d6be10d9-eee2-48c5-90db-d4f0b2c95a8d'),
(1035,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-09 17:24:37',NULL,NULL,NULL,'4c1f47b4-c776-4a3d-91bf-971cca51fc46'),
(1036,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'b1af9f9e-abb0-4b93-9b79-b41ad65d5667'),
(1037,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'b9615338-fd34-496d-b5b4-a1aedd0ec222'),
(1038,1035,NULL,563,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'5c1a9229-e14b-451a-b8c1-1e924c7e046c'),
(1039,1036,NULL,564,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'88a3cd53-502a-4fe7-83b5-4b381adcf1c8'),
(1040,1037,NULL,565,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'65be40ee-c2e1-472f-be8a-2639abc82794'),
(1041,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-09 17:29:43',NULL,NULL,NULL,'3de194dc-8f35-4e34-862d-7ec10c5e8f04'),
(1042,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'5baa6d92-c54a-4dc2-8217-dd570508fd35'),
(1043,1041,NULL,566,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'636fe767-0234-4469-80ab-8bbf0036bac8'),
(1044,1042,NULL,567,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'9f984eb8-4779-4ee1-b5ed-ba9f407893d1'),
(1045,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-09 20:48:21',NULL,NULL,NULL,'dec3ccf7-835a-4e35-8f30-b2b10064595e'),
(1046,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'0102d6b3-5998-40fc-93e2-ac2442ddb221'),
(1047,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'af9ae13b-1806-43f1-9cd4-d01bf7ea63db'),
(1048,1045,NULL,568,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'966f7852-e2ba-4820-93ab-097a0f43f29d'),
(1049,1046,NULL,569,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'d76acbc8-371a-40ac-bd6f-602642269fd9'),
(1050,1047,NULL,570,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'34283c57-d2ab-4f7a-83ca-aee032db2306'),
(1051,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-09 20:56:04',NULL,NULL,NULL,'7ecdfcf7-57f3-4966-92e3-a846e195f1f0'),
(1052,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'3953c615-c4f9-4b23-b206-81680036bf19'),
(1053,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'50fb3de6-c544-4fae-ba32-9c102626cde3'),
(1054,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'891675f1-6ee0-45e7-a0ee-c5f1def29961'),
(1055,1051,NULL,571,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'746107ef-7585-441e-90aa-bfcee8ce2a05'),
(1056,1052,NULL,572,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'0ad6941f-640f-497f-a520-3f6f0d612754'),
(1057,1053,NULL,573,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'bd598fbf-d50d-4281-9c88-da2c39fe2bd3'),
(1058,1054,NULL,574,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'f3e4bff4-6dd7-459b-81ab-324d84025de5'),
(1059,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-13 16:02:37',NULL,NULL,NULL,'1db34b40-992e-4b6a-957b-2ab444012d2d'),
(1060,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'82dd976d-5d80-4d37-91c2-975c5bfa56b7'),
(1061,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'69532f71-ad21-4e1f-8838-d65bfcaf6fb2'),
(1062,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'35450d10-89b4-4158-a5c5-02e9ce986870'),
(1063,1059,NULL,575,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'bb9c87b2-9543-4600-8052-8186727edb3c'),
(1064,1060,NULL,576,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'3320e605-1717-45f8-b8cb-051aa2ad09d2'),
(1065,1061,NULL,577,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'fad8af60-3f9b-4e49-8dce-0b22322826ff'),
(1066,1062,NULL,578,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'a7f11528-4355-46a5-9bf5-8564a92ea7a7'),
(1067,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-13 16:08:14',NULL,NULL,NULL,'3e896674-276a-4fac-9bae-6043a7566c71'),
(1068,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'1ea44685-d248-47ea-a73f-c1c827d519db'),
(1069,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'ffafd33f-b84a-4f08-9c4f-eb356107eb89'),
(1070,1067,NULL,579,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'096a387c-cf17-4eb7-baee-66df6d186421'),
(1071,1068,NULL,580,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'43db53d3-3109-4eaa-ab04-7792f01bd012'),
(1072,1069,NULL,581,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'bac4d24a-213e-45d3-99c3-97f84f2c20c8'),
(1073,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:31',NULL,NULL,NULL,'cf2218ca-b445-43a5-9a1f-3eb02abce60c'),
(1074,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'a5d8c15e-e74c-42ca-a88e-07f359c881fa'),
(1075,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'fea85ae0-fddf-4c69-b29b-41a708363761'),
(1076,1073,NULL,582,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'e3331081-443b-456e-8bdc-49788985f4d5'),
(1077,1074,NULL,583,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'2f0a8a72-810c-4661-9912-0cb05b93f112'),
(1078,1075,NULL,584,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'3eb1a75d-afb1-49e9-8bff-d4863316d87b'),
(1079,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-13 16:15:51',NULL,NULL,NULL,'5ae1ceec-e10f-482d-9b12-2d210b34fc9c'),
(1080,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'4f3429eb-9312-4dc9-87b3-f10cb743c365'),
(1081,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'40bc5374-c46c-4484-95ae-bc223a6c29c5'),
(1082,1079,NULL,585,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'b3b33bb7-7fdc-4d82-a425-80bc21f95332'),
(1083,1080,NULL,586,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'8ee0a6fc-a030-4d6c-ab6b-22b9dcab8887'),
(1084,1081,NULL,587,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'bdba192b-c83b-4bcf-87a1-15c2dfac991d'),
(1085,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-13 16:43:50',NULL,NULL,NULL,'560ed462-30a9-4c94-a0de-7d5cbce1bb13'),
(1086,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'964b1887-b339-4799-bc22-3d38f1bcec99'),
(1087,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'170b6a26-1f00-43fd-a16d-b8e1de89f362'),
(1088,1085,NULL,588,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'ab6e9010-8c9d-43fd-9921-66e64b8f3ab1'),
(1089,1086,NULL,589,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'cce369e7-aff6-45ee-b1d0-f4d8e1ef17ed'),
(1090,1087,NULL,590,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'ad74462a-0acc-45d9-88f3-74dbd4ac8ccb'),
(1091,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-13 17:09:47',NULL,NULL,NULL,'af8ab057-06a9-44da-a782-bce073caf3f7'),
(1092,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'1ab57f16-7dd2-438e-a80d-55d999c71173'),
(1093,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'19434827-facd-4a27-a494-9872800b7c00'),
(1094,1091,NULL,591,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'f310452f-bef2-43da-955e-ab8bbcfa8936'),
(1095,1092,NULL,592,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'f765ad23-369d-4e1e-9b9a-6d08b3eef309'),
(1096,1093,NULL,593,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'e183a3be-1a97-4aba-b30e-f87a1b5254ee'),
(1097,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-13 17:23:02',NULL,NULL,NULL,'e6a0a789-a128-4e9b-877e-cc076269bc49'),
(1098,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'c0cd0323-daed-4e05-964d-af8a63249fa5'),
(1099,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'cbb49a99-c13e-4eba-8c34-6b8a23387b19'),
(1100,1097,NULL,594,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'e6edc4a4-2f7c-41cf-8384-f76b0f961a5b'),
(1101,1098,NULL,595,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'87a71333-86d7-4929-a0cf-353398a98599'),
(1102,1099,NULL,596,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'c1e44615-926b-4d1c-882a-0bd8360c9c30'),
(1103,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-13 17:28:26',NULL,NULL,NULL,'f53d9228-7793-482e-ad9e-9266a29f470d'),
(1104,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'f7c584cc-48e7-443b-90ff-acf209238b46'),
(1105,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'338f45dd-aa66-42a4-85c1-bb6256261b91'),
(1106,1103,NULL,597,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'5bff26aa-4fa4-4926-8f2d-625ffd7225d3'),
(1107,1104,NULL,598,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'f70e062a-9e97-48e5-b354-19a4e919e692'),
(1108,1105,NULL,599,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'ef740bed-8b65-4b82-98a6-0027eeeeec08'),
(1109,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-13 17:43:34',NULL,NULL,NULL,'398ec3ba-8547-4d8c-a91c-a2de31cf9d20'),
(1110,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'2b7e749b-c62a-4693-a91a-46f8b6ddcba2'),
(1111,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'6e2b9404-765f-4991-be6b-a12b2991259d'),
(1112,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'14548fc8-ebd3-4568-889c-d54db90c442c'),
(1113,1109,NULL,600,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'844070a9-93f6-437e-96ea-3f24a1fe5866'),
(1114,1110,NULL,601,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'2e6602ca-b53e-4dec-81ac-01c98ac5f553'),
(1115,1111,NULL,602,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'05ec7e05-5c60-4b67-882e-66edaf355367'),
(1116,1112,NULL,603,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'c6c82188-bb68-421b-90c7-28bb67edbd81'),
(1117,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-13 17:47:19',NULL,NULL,NULL,'a08d8d64-84ed-4630-94bb-e92bb7619949'),
(1118,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'8bf0c634-b6dd-4835-a858-7057529489d2'),
(1119,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'cf758b45-6e11-4945-90c5-db861a5d0b8f'),
(1120,1117,NULL,604,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'f4d033fd-dcd7-43cb-aef9-37d702ce7efa'),
(1121,1118,NULL,605,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'d1ab9b0d-752d-4163-b91e-123f67052b84'),
(1122,1119,NULL,606,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'dc20d49e-5b88-4a95-af7e-d615672a0254'),
(1123,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-13 17:53:11',NULL,NULL,NULL,'5706c4a0-fcfc-4823-a969-32440ed553a3'),
(1124,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'3fe3895a-f641-40f0-91f0-a2121e5e757c'),
(1125,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'e8fe88b5-9df3-430c-8f7f-3f6d22cfa580'),
(1126,1123,NULL,607,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'6564539b-e5a1-48dd-8d99-f86a99df55e0'),
(1127,1124,NULL,608,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:20',NULL,'d852d746-ed46-4090-9777-9211be73fde7'),
(1128,1125,NULL,609,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:20',NULL,'452d4af9-a048-4f88-9abc-bf8f8e74f3da'),
(1129,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-13 17:57:28',NULL,NULL,NULL,'28a28f32-135b-474d-9045-2fb69fbcde32'),
(1130,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'18e5ed3e-7421-486b-bb13-99055ff0fb06'),
(1131,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'2e0c9d8b-55c1-48c5-9a02-d2737801c6c6'),
(1132,1129,NULL,610,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'291813ba-7229-4de4-aba7-911ce4ac6394'),
(1133,1130,NULL,611,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:20',NULL,'0949fa92-a911-4736-bf34-7e8223a20bbe'),
(1134,1131,NULL,612,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:20',NULL,'714fd2cd-0dd2-435d-a421-ba319c18ce94'),
(1135,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:32',NULL,NULL,NULL,'5851bd11-29aa-43b3-b611-fc88dd5e211d'),
(1136,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'c6dee479-40b3-430e-9858-341e650d0ab5'),
(1137,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'05d9e4a1-4db0-4349-abc1-7b8c59745877'),
(1138,1135,NULL,613,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'7708f32d-a59e-406a-840f-f9bf1dd0b749'),
(1139,1136,NULL,614,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'42a075b2-2fef-4890-9730-78a79bbc30d6'),
(1140,1137,NULL,615,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'3e62702c-29e4-422e-8ca8-7339310e88c5'),
(1141,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 19:22:03',NULL,NULL,NULL,'1d957e72-1e3c-4f74-8b78-4c0e762aab48'),
(1142,1141,NULL,616,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'4f267a08-11ce-418a-ac1f-6be097019354'),
(1143,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-13 18:02:09',NULL,NULL,NULL,'44c0f461-8c7c-4f47-b5f0-717c1c50c7a2'),
(1144,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'87aaf7fe-938f-4de7-b373-ee459a264923'),
(1145,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'f8873476-c276-43f1-8542-a4caab1bd3ba'),
(1146,1143,NULL,617,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'d4e60a3a-c323-4be2-a57f-0f627737705a'),
(1147,1144,NULL,618,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'98327891-4a30-40db-a2b7-fdc217b74322'),
(1148,1145,NULL,619,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'1cf2fd55-9139-4883-a3cc-dde3e269c2bf'),
(1149,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-13 19:10:27',NULL,NULL,NULL,'f381df8f-e64f-4bf2-abd8-61cbfcceaea2'),
(1150,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'a1bbd559-8b53-4167-9115-4e2adef24804'),
(1151,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'ec1adc96-db31-484b-b38c-762fcaaebf7b'),
(1152,1149,NULL,620,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'b136a7dc-9afb-4472-b693-4b52744631b4'),
(1153,1150,NULL,621,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'483bcb91-61eb-4e71-8b68-de6a6513779a'),
(1154,1151,NULL,622,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'43714484-1768-4f83-9ab6-d30e57461fb1'),
(1155,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-13 19:24:55',NULL,NULL,NULL,'c0f22461-831a-49b7-a594-09cc88d08098'),
(1156,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'e4a3bdea-6875-4e60-8be9-d7277eb27ef3'),
(1157,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'55922826-85ab-4780-b623-cadf0c9ea182'),
(1158,1155,NULL,623,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'b8b1578f-dc37-484b-8dab-37b24bd9377b'),
(1159,1156,NULL,624,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'04167b78-fc6a-4be2-a302-8f0b94c0d779'),
(1160,1157,NULL,625,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'ce0d8389-1634-4dbf-9e2d-6074319bdde7'),
(1161,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:33',NULL,NULL,NULL,'09b0cfa0-a3e5-4ad8-996a-8faaef93dada'),
(1162,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'08ecada2-bf45-40c5-b6b0-c36dc2b4d165'),
(1163,1161,NULL,626,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'9c9f8d12-26af-44ec-bf64-114ad399c910'),
(1164,1162,NULL,627,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'e0281d02-7c77-4091-bd6e-6cbd38edf2bc'),
(1165,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-13 19:30:06',NULL,NULL,NULL,'c7655616-7d4f-4c6a-b370-6126b174a372'),
(1166,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'c1ebe08d-fbf7-4c2f-9604-00444aeb05ad'),
(1167,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'85ec9aa3-6b87-4275-a805-73f2756601fa'),
(1168,1165,NULL,628,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'174a460d-f3ba-4c8a-abb3-59cac5feb1a1'),
(1169,1166,NULL,629,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'ef46220a-5e22-4147-af65-ea20db188176'),
(1170,1167,NULL,630,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'5f5b36d1-8f54-4130-ae14-2caeb4bb9092'),
(1171,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-13 19:34:44',NULL,NULL,NULL,'055d79fb-6463-4d54-8399-b6ebcc287543'),
(1172,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'1a1d4edf-2a46-43b7-90d1-7678aac6b95b'),
(1173,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'daa5ed51-917d-4918-ad5f-14e19f004c46'),
(1174,1171,NULL,631,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'c63f66be-908a-45f6-b664-2ae9dffa1cd9'),
(1175,1172,NULL,632,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'69fb9b60-8113-4fe7-9933-15d763968daa'),
(1176,1173,NULL,633,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'a1c4bb3b-e362-4186-9cd4-a0dc87724a6d'),
(1177,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-13 19:39:32',NULL,NULL,NULL,'2be2bbd1-385e-425c-8c2d-272477117748'),
(1178,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:48:37',NULL,'6cf406cf-7a73-438a-a35e-55085b1c4834'),
(1179,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:48:37',NULL,'c9bc5e99-f0a9-48bc-ba8d-ee7a89618626'),
(1180,1177,NULL,634,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'70f1a720-5733-4000-bf9a-20bfec84c620'),
(1181,1178,NULL,635,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:48:37',NULL,'a5299d6f-50e5-4c68-b2db-a911bf3d23de'),
(1182,1179,NULL,636,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:48:37',NULL,'93f7c789-d10a-41e7-905e-175963ccd047'),
(1183,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'7551bf18-63d6-4aee-979e-50600aaa5011'),
(1184,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'9396d020-e2c9-4503-a79a-d588a1c57003'),
(1185,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-13 19:51:50',NULL,NULL,NULL,'89bfa064-7f1a-4480-81eb-bbb78109087f'),
(1186,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'13112f7e-6a50-47cc-85cf-753fcea43111'),
(1187,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'fd5765c6-f665-4a02-815a-5105814ce806'),
(1188,1185,NULL,637,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'526e17f0-4799-4b50-9003-7cae2871fa1f'),
(1189,1186,NULL,638,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'baaa85fd-6100-4868-9429-3e10c48fad6c'),
(1190,1187,NULL,639,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'90b682ef-348b-41a1-b39a-d44e3681d170'),
(1191,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-14 16:49:14',NULL,NULL,NULL,'c917f067-e6d1-42f1-ba71-c9910cdf356f'),
(1192,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'da1a0e04-418a-42e0-a960-44584a7fdb5f'),
(1193,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'9994b8b2-4b7a-43fa-9170-eb4dbec75df9'),
(1194,1191,NULL,640,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'41b9e46c-fa99-46a8-9723-1526a6fa1e6d'),
(1195,1192,NULL,641,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'a37bc56c-550d-4537-8481-97b30c9fc51e'),
(1196,1193,NULL,642,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'5bbd680a-d39e-4ba0-8a2a-39d4704344f9'),
(1197,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-14 16:53:18',NULL,NULL,NULL,'a6698012-4054-4391-80ee-3f26c63ac0cf'),
(1198,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'ad2eba91-fdd1-4990-9a43-f7f0141ca539'),
(1199,1197,NULL,643,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'68d70228-e975-4723-93e4-bb1d919ac31e'),
(1200,1198,NULL,644,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'921c7a77-e591-405c-b040-34de76b14d8f'),
(1201,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-14 16:56:56',NULL,NULL,NULL,'b5c6ccd8-0e99-4efd-a495-8c5c49b45f2d'),
(1202,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'86fdea10-7626-43bc-bbe9-964584761c5d'),
(1203,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'ebe0438c-7661-4587-b14e-a83a21ad065b'),
(1204,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'2d327abb-b910-440f-8f3b-42793de72379'),
(1205,1201,NULL,645,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'4aeac103-0513-44b2-a75b-22fe41ff94a9'),
(1206,1202,NULL,646,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'c713e2b3-a3c2-4d20-bab6-66bae092be4d'),
(1207,1203,NULL,647,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'a17a7dc7-5a10-48fd-8429-362e1ad4b425'),
(1208,1204,NULL,648,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'45a9f629-d9c6-42fa-b588-eddba6553542'),
(1209,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-14 17:00:06',NULL,NULL,NULL,'6426c6e4-aede-4aab-8e51-3605bafda3f2'),
(1210,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'b7dc73bf-effb-4665-b518-2a72a327f95d'),
(1211,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'08f6f1b5-8aff-4d05-8675-164e9b04171c'),
(1212,1209,NULL,649,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'b3eda0a4-8a43-4e74-9355-17b70cee35dc'),
(1213,1210,NULL,650,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'051bd566-20a6-42fe-8817-296144e44534'),
(1214,1211,NULL,651,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'4af34744-eeea-4260-8231-ca668cc192a4'),
(1215,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-14 17:05:13',NULL,NULL,NULL,'5bd94697-9fd6-4d4e-8848-3fe542b3bbda'),
(1216,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'6d71c8ab-c698-4295-b08f-ffa9061c8077'),
(1217,1215,NULL,652,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'12bd724e-8184-4679-9b88-20a39863abf8'),
(1218,1216,NULL,653,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'8c43b830-8619-42d3-ab08-94055ea805c2'),
(1219,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-14 17:09:21',NULL,NULL,NULL,'a2c697ad-df34-4492-a9f1-dae21a012b6d'),
(1220,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'c6b85159-a923-4cec-9fff-f03161a2efcc'),
(1221,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'5a2a6dfc-82b9-4dcd-8e8f-4c94f5de0e3d'),
(1222,1219,NULL,654,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:38',NULL,NULL,NULL,'dcb64168-cb4b-4687-9e89-63890ed5f69c'),
(1223,1220,NULL,655,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'34480a28-3cd6-4794-a923-a7376e674dbd'),
(1224,1221,NULL,656,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'9ea4b749-d616-48e8-a736-a7f1f2fdf7f7'),
(1225,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-10-14 17:12:18',NULL,NULL,NULL,'37807e51-bdf9-484c-9984-d3175d293933'),
(1226,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'7204ee6d-8c0a-440d-bbed-ed5ba7c73566'),
(1227,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'f4abdad0-9da1-4584-a755-1ac496074fea'),
(1228,1225,NULL,657,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'a03b6bc5-7bd1-49f0-9358-98d36fdcce53'),
(1229,1226,NULL,658,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'957a9562-56ee-4531-a1b4-e1a063f06e7d'),
(1230,1227,NULL,659,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'6a8f51cd-ead9-4e95-a103-3517f084165a'),
(1231,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-10-14 17:15:30',NULL,NULL,NULL,'8f0d2923-6550-4757-8bea-573605d2135f'),
(1232,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'0bb10668-8b22-44b4-b00b-62a7aa051d2f'),
(1233,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'1fb3327e-b3f2-4b5c-954c-6bf74d4c60bf'),
(1234,1231,NULL,660,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'23ddadd8-f438-4ec7-9cf8-a36731a6a9d1'),
(1235,1232,NULL,661,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'f8b0db55-cdf6-4da2-b2e2-a90cb9710d08'),
(1236,1233,NULL,662,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'fa93c549-eba1-48dc-b3b6-f0d7638eed41'),
(1237,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-10-14 17:22:21',NULL,NULL,NULL,'831198a5-a1c7-4506-9bac-ba8a760422f7'),
(1238,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'bbd52683-b622-4e7f-a893-a0cdd535a5fa'),
(1239,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'9c20ffff-befb-443f-90d7-7a162a6452a5'),
(1240,1237,NULL,663,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'1c693d24-a2ba-4121-9892-11d95b30c106'),
(1241,1238,NULL,664,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'b1d6c857-74a6-49d3-b4dd-bf7bd6514fa5'),
(1242,1239,NULL,665,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'07a0b9a0-d137-487e-b40e-389d89424067'),
(1243,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-10-14 17:25:14',NULL,NULL,NULL,'c5279fef-fc70-454a-9f6b-c8eb84670bf9'),
(1244,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'26e0a0a0-a0c2-4f9b-9a1f-509afdfd0ab6'),
(1245,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'a977cfb5-6806-4611-b0f7-5e758613bd40'),
(1246,1243,NULL,666,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'27795513-a0ac-4529-a8a2-148532aa4999'),
(1247,1244,NULL,667,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'d69d680d-89a1-48b0-bb0c-a2883c2c3be2'),
(1248,1245,NULL,668,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'6c658dea-614a-4ef3-9b57-bd4425deb5a0'),
(1249,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-10-14 17:28:09',NULL,NULL,NULL,'98f6c7e0-e81c-42ec-8429-6ac1e78827c9'),
(1250,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'e2f8e639-e575-42e9-9e80-fa9c1944a2ff'),
(1251,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'5e65210f-f52e-4202-9f70-a983ed21083f'),
(1252,1249,NULL,669,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'1873b339-5e4d-4b06-ab0c-a83eb068f3bf'),
(1253,1250,NULL,670,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'fcf77344-c556-4172-8f67-0867546ff865'),
(1254,1251,NULL,671,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'093428c5-4db5-41ff-8c0f-0071ab5d4ea7'),
(1255,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-10-16 20:22:32',NULL,NULL,NULL,'f283d066-0b82-44eb-b879-14ec2219674a'),
(1256,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'c8cefe31-fbf7-4df4-8335-c5249aef2344'),
(1257,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'2f998d89-7531-481e-a73e-25548cab0b9a'),
(1258,1255,NULL,672,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'807ce93c-0611-45cc-86f1-a1752e4144ed'),
(1259,1256,NULL,673,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'76642036-dbbf-438e-93a7-cf306fe8714f'),
(1260,1257,NULL,674,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'3efd6cd6-5025-419b-8254-5cdeb7538790'),
(1261,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:34',NULL,NULL,NULL,'15943273-e8c3-4a51-b5d9-e3fc7cd32a8f'),
(1262,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'669b6452-688a-4133-908c-055a66cff5e1'),
(1263,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'32684ff2-cd50-4bc2-8df8-47ac6c9695a0'),
(1264,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'f584e501-f863-4648-8fd7-9cc2772752c8'),
(1265,1261,NULL,675,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'0a26fa57-210a-4186-80d6-03b48f59656c'),
(1266,1262,NULL,676,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'14de058b-d7c4-4cd1-b4b0-b3a031601409'),
(1267,1263,NULL,677,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'d9652a04-b7d2-47d3-98f4-c924e260267b'),
(1268,1264,NULL,678,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'bb0262df-3c23-4eaa-9d4e-3fb526dd8bf9'),
(1269,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:34',NULL,NULL,NULL,'d3debf21-6311-42d6-a153-c4d5a58464f6'),
(1270,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'87beb08f-b473-4f64-9cfc-55683192267a'),
(1271,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'42e051d9-ffbc-402e-b5dc-b3107c29cafc'),
(1272,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'f358722c-ef6d-4fda-8feb-6b2d93e2a041'),
(1273,1269,NULL,679,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'c0a047e6-f59b-41de-a4f1-89d32e25a0bc'),
(1274,1270,NULL,680,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'611c4c6d-e885-442b-af38-d456a49260d4'),
(1275,1271,NULL,681,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'ebed7c12-2fb9-483c-af57-f2ad48e43bbf'),
(1276,1272,NULL,682,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'a9d29ed5-3300-438c-bb92-b28dd1047f02'),
(1277,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'406cd088-3430-4963-accc-1e6e86db6052'),
(1278,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'aa2d165b-6b89-45f2-a104-ce337866a947'),
(1279,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'fea5f623-4050-40dd-88c2-5ad59110cf95'),
(1280,1277,NULL,683,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'60065f1f-4961-4a9a-a900-814a03d767a5'),
(1281,1278,NULL,684,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'a10bd7a2-0059-4ca0-9c80-faa5ceda7d98'),
(1282,1279,NULL,685,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'94a8740d-e5bd-4f1e-b5d3-cd7d0e8d5247'),
(1283,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-22 18:42:35',NULL,NULL,NULL,'a14f333f-5d97-4f28-adf7-1eb6de8a62dd'),
(1284,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'16f849bf-8b2b-44b3-8c12-54d94e8c6e09'),
(1285,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'77e50c01-3b96-41da-aa5b-29bfbc4816eb'),
(1286,1283,NULL,686,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'b83326e2-4680-4c83-9a5e-a117bad15222'),
(1287,1284,NULL,687,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'9dcfeb26-8b38-403a-ae08-f1818117576e'),
(1288,1285,NULL,688,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'81c3b452-fba1-4ae7-a459-8483baf683d2'),
(1289,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'1e0bb049-da11-4a90-9e51-1549b36f3102'),
(1290,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'b8e0ffb1-5428-4ab7-80c7-77a9fd1fd911'),
(1291,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'064fc539-91b2-4d4e-9566-2ef3bc7143bb'),
(1292,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'0b5324da-3ba4-4600-a30c-ede53304bf82'),
(1293,1289,NULL,689,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'b543b24d-e8a8-4cab-be14-c9d7c7bf30fb'),
(1294,1290,NULL,690,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'ad21d5eb-6be6-4f43-94db-43ba63afe000'),
(1295,1291,NULL,691,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'2efc46dd-208e-46fc-8ba1-1bafefe9dff3'),
(1296,1292,NULL,692,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'03e88e82-4b9a-4ead-86ae-e77f88bc8305'),
(1297,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'63f83f5e-ea30-4d1a-9cd7-742ab2705cc1'),
(1298,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'de4c8138-9138-4c6a-a9a4-8b80bd5bbb5d'),
(1299,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'f2cfc895-91c2-4973-83e3-6409acd12711'),
(1300,1297,NULL,693,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'2d58e33b-1434-472d-b977-53e6be4e270e'),
(1301,1298,NULL,694,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'4cfec8e5-e0b2-4b49-8801-80c343be3782'),
(1302,1299,NULL,695,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'a9d1eb84-e219-462b-9c9e-7834ebc53e8d'),
(1303,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'6f09b6a2-cbf4-472a-9f08-6e209deb09a1'),
(1304,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'20cbbf8d-dd29-4b59-8f34-253a4b57d02a'),
(1305,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'a8d2ac4d-bf5a-45cd-aa39-847cd30098d0'),
(1306,1303,NULL,696,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'f7550701-b282-4c05-865d-2dc9990a6b39'),
(1307,1304,NULL,697,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'b3c00404-2c96-42af-b91c-d090625debee'),
(1308,1305,NULL,698,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'9fbb9366-eb03-4898-976e-b0f0b025bcd5'),
(1309,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'1e37f615-9815-4e6b-bef1-b6c2d9b7f291'),
(1310,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'9968f953-ee7a-43ed-8ccf-d1fbb6c53297'),
(1311,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'2a9caa7f-7ea0-424d-a570-0f087a4a2222'),
(1312,1309,NULL,699,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'20139750-d97a-4693-aa69-39ccdd656367'),
(1313,1310,NULL,700,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'7a6a4d0b-14b3-4689-96ff-bedad8dbee7d'),
(1314,1311,NULL,701,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'4ed5266a-eafa-4dff-8c2f-9809e41f8048'),
(1315,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'af1f0dc9-56db-4a3d-adad-a0710d5382fc'),
(1316,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'8043e61a-5d17-44bb-9058-bc868dc49ce1'),
(1317,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'89ed9071-61ce-44a1-b7f2-c0fc40b5c955'),
(1318,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'4f1e758e-0e34-44b7-baec-2c9eced211e1'),
(1319,1315,NULL,702,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'ecc4c9a2-339a-45bd-bca3-5a269e212c39'),
(1320,1316,NULL,703,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:25',NULL,'874bbcfd-90e9-482b-ab82-2681ec104cdc'),
(1321,1317,NULL,704,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:25',NULL,'08b39ef2-0325-4439-ac82-4f9773940ed7'),
(1322,1318,NULL,705,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:25',NULL,'a309dc10-48fa-4065-9fa7-9c93c32da578'),
(1323,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'6d44985a-9c4f-4f58-b4ee-714eefdab563'),
(1324,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'e0e43dea-0616-4e0d-bb7d-64ebacc06517'),
(1325,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'09f42432-3df5-4c7c-974b-e8b694ee3c4b'),
(1326,1323,NULL,706,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:39',NULL,NULL,NULL,'87fe8d58-03b3-43d3-ad8f-c4cade82789d'),
(1327,1324,NULL,707,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'7a6b7e2a-0a6f-4243-b309-fb66786d0d72'),
(1328,1325,NULL,708,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'65f511dc-8f93-479a-8d3e-6021a6b9778d'),
(1329,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 20:39:35',NULL,NULL,NULL,'1fd9bbc0-7bf1-46c9-ac24-0176114d3823'),
(1330,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'430de6e4-45df-469c-a0ac-15547a6ea506'),
(1331,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'ae0bbb33-7fe7-4e2f-b36d-8360e0b47ac5'),
(1332,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'c8b25d21-3bcc-43cb-a982-6aa042ce7c7a'),
(1333,1329,NULL,709,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'8fbb0b37-b9f2-4614-835e-de6c647719a5'),
(1334,1330,NULL,710,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'c26615ba-e4c9-4d9a-925b-9c90103ae00a'),
(1335,1331,NULL,711,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'0a8eb40c-1e1d-4fd1-8e2c-4a04d13a29d9'),
(1336,1332,NULL,712,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'f0b59803-a16a-4a3d-8963-809337502b79'),
(1337,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 20:39:36',NULL,NULL,NULL,'8dcaf5df-07b7-471a-8789-20e7877f2acf'),
(1338,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'ff30ff8c-9982-4b8c-bd0c-456261a04c3b'),
(1339,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'65c56459-3662-4e2e-bbf9-e82eb7d99d31'),
(1340,1337,NULL,713,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'c5a0b65f-7882-4513-a5d1-8039a767d40e'),
(1341,1338,NULL,714,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'ef3f32c1-0b07-4ad9-8029-f9d21d4ea52d'),
(1342,1339,NULL,715,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'bc4525aa-9015-468f-a9d9-78ace2d48ec9'),
(1343,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 20:39:36',NULL,NULL,NULL,'dc8c0434-33bf-4a60-8f74-5e9e67c67891'),
(1344,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'41d99e48-d5cf-408d-906d-340735136b96'),
(1345,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'41d77cae-2b52-436a-8fa4-27d35f39561f'),
(1346,1343,NULL,716,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'24024ef0-16b1-4688-984c-de8e2d231d43'),
(1347,1344,NULL,717,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'b6b20adb-acb3-49da-8df0-55b3eae7da84'),
(1348,1345,NULL,718,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'0acc5d37-de89-4bf4-8d81-4351d737de77'),
(1349,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 20:39:36',NULL,NULL,NULL,'1fab1df4-d265-4be0-a1fb-123a3d0f4312'),
(1350,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'345b51c1-2dd4-48fb-9194-f56d0135f9bb'),
(1351,1349,NULL,719,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'c07c82ac-f45a-4488-8e34-2752ddc02019'),
(1352,1350,NULL,720,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'80005875-b4fb-4a6f-9b0a-efc12dc3323b'),
(1353,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-10-10 18:22:08',NULL,NULL,NULL,'f29068a1-d909-4477-8a54-4f870de19253'),
(1354,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'253848be-d726-4334-8439-419a077a6d65'),
(1355,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'fdcb05fd-b7df-4ba7-be10-ea749bf599a4'),
(1356,1353,NULL,721,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'4c26fc44-ef5b-4836-a0e1-3e1d2bb714b9'),
(1357,1354,NULL,722,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'afbae2bd-2382-48fe-80e2-43466202bb2a'),
(1358,1355,NULL,723,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'a1a16467-6f7e-4b73-9d1b-4c4e644d69b0'),
(1359,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:20:32',NULL,NULL,NULL,'0a78517d-cd10-42a9-9b07-bd04013eaa7a'),
(1360,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'1661cb08-fadf-4970-af2d-42b2bcbcc6a6'),
(1361,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'a4b559ec-0ec4-42c3-89c5-1175ff52b3cd'),
(1362,1359,NULL,724,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'7bee03aa-7706-4450-a56b-7e342d33674c'),
(1363,1360,NULL,725,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'1efe27fb-b3ec-44f8-88c2-c76667c92eb7'),
(1364,1361,NULL,726,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'40974069-b708-4298-ac81-ef5084e2f449'),
(1365,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:20:52',NULL,NULL,NULL,'b1b7bedc-a69c-43e5-a051-864302bb5316'),
(1366,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'237f0de8-486f-455b-bb4e-cb875251ba3e'),
(1367,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'54b40113-d8ad-46f9-b11d-4728753e74b9'),
(1368,1365,NULL,727,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'c64e4f58-6d8c-4ea2-808f-11038133461e'),
(1369,1366,NULL,728,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'8308aac5-f93e-44ef-b9cb-1c4cb05e5f6c'),
(1370,1367,NULL,729,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'25559755-16d6-452a-97d2-0ad02800b00d'),
(1371,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:21:35',NULL,NULL,NULL,'1bc8135b-532b-434c-9bfd-75701f485a3c'),
(1372,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'2e261345-db78-4d7b-847e-765a6af5b014'),
(1373,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'f19dd849-9553-4f3c-8a5d-4e761016e010'),
(1374,1371,NULL,730,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'9e667f0c-03ff-4446-b89d-0c3200e4c8dd'),
(1375,1372,NULL,731,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'0f5359d8-ba45-4002-a348-b377c0ff9a0a'),
(1376,1373,NULL,732,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'58fa238e-a540-4873-95f7-8bf693d3de3b'),
(1377,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:22:06',NULL,NULL,NULL,'d3466f3d-8d29-494a-b948-a4b0893f19e2'),
(1378,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'befd8433-ea04-4e2b-8fa7-bdecc16273c1'),
(1379,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'bc9fcfa7-4653-4a00-b5b5-fa6b3cf95c43'),
(1380,1377,NULL,733,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'18c9209a-e7aa-4f4a-9bdb-0bf747856160'),
(1381,1378,NULL,734,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'4a03e149-e9f8-4ebd-b1a4-076e9a096736'),
(1382,1379,NULL,735,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'fc0ac719-9207-4ea7-8a02-530c28a50aab'),
(1383,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:22:45',NULL,NULL,NULL,'69022d4d-5d2e-4e2a-8a66-4e47358a2867'),
(1384,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'7b685ee2-7565-4acf-8e09-00c7584a4c2e'),
(1385,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'b6f03b11-d559-4b74-8c8e-111414003414'),
(1386,1383,NULL,736,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'91ed79b0-819d-4400-843b-7fe2f965145c'),
(1387,1384,NULL,737,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'c732bb86-d763-4643-a7a6-6456036e6b2c'),
(1388,1385,NULL,738,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'fc779cc1-739e-41d0-831e-489bc6ceeb1a'),
(1389,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:23:01',NULL,NULL,NULL,'fb8a6fbe-da4c-4b0d-97b9-df4fceca0c83'),
(1390,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'1252935e-8575-4ed3-9d1b-b8f45c05a53a'),
(1391,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'b5c7baba-cd62-4faa-b917-7fc71bd30dbd'),
(1392,1389,NULL,739,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'ba4a3d1c-f46b-43ba-8729-46570d722618'),
(1393,1390,NULL,740,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'b2ddb548-3695-4822-a942-b64469682468'),
(1394,1391,NULL,741,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'48f4970e-7a01-4de9-8ebd-cc3fb18a5e31'),
(1395,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-29 18:59:03',NULL,NULL,NULL,'ad605fca-f52b-4f94-ad29-1bf717718384'),
(1396,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'19773b1d-8517-4181-a953-11ef69fad669'),
(1397,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'afc0add6-72c7-49c3-8778-f1b8e7106d76'),
(1398,1395,NULL,742,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'ac8b35f6-8ade-4fa6-8698-ee9bcaed8dc3'),
(1399,1396,NULL,743,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'20b18ece-9636-458e-a861-34f802032de9'),
(1400,1397,NULL,744,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'6c1c4a3a-7ef2-46b6-bc3a-0a976a4b1d11'),
(1401,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:22:29',NULL,NULL,NULL,'10136db3-f742-4345-b1a1-3f99a22062c7'),
(1402,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'d1e067a4-53a5-4350-84c1-d64030187043'),
(1403,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'2b80baee-96c6-4993-95ca-ccf103ee535d'),
(1404,1401,NULL,745,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'3bbb8803-986e-450b-9796-659e2b7de2c7'),
(1405,1402,NULL,746,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'b03033ea-1bf9-48f2-93b0-7584f9ecd395'),
(1406,1403,NULL,747,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'b96cca2d-013e-4d54-9c2b-d6ebc1c94f64'),
(1407,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:23:24',NULL,NULL,NULL,'2ce11a9e-c93b-4ff0-89ed-0449154cae89'),
(1408,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'ce6fef3d-772f-4a4f-8b54-f29fdf182ae1'),
(1409,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'13e29f85-3faf-4d70-82e5-40842ee9b37b'),
(1410,1407,NULL,748,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'ab91c63d-5d6e-48a4-9c10-7e26395b19e5'),
(1411,1408,NULL,749,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'c534a2ab-96f0-4165-a937-a481dfad9b7b'),
(1412,1409,NULL,750,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'e7b156b5-5e57-4c89-85a1-4e4f8901dae9'),
(1413,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:18:15',NULL,NULL,NULL,'e90d7f5f-3681-4be5-8773-1c482e673ccc'),
(1414,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'ebd9af9d-9938-4547-b1d3-83cde3059a17'),
(1415,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'59cc73d1-18f2-4e04-bfca-809e0c4b69ba'),
(1416,1413,NULL,751,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'190384e1-ab95-4523-8051-9ebe0984616c'),
(1417,1414,NULL,752,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'e9370a84-57a6-4369-9473-8a91cdd74e8e'),
(1418,1415,NULL,753,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'2cb148f2-b545-4e25-b90e-de795d1043c5'),
(1419,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 20:39:37',NULL,NULL,NULL,'2f4b7332-a50d-492c-b8a1-863f352f896b'),
(1420,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'a3105570-e185-449a-a984-464a3b30cf02'),
(1421,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'7df53d4f-bf94-469a-984e-750a1a5cfce9'),
(1422,1419,NULL,754,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'c4302b70-c839-4f09-9d08-61441e302a2a'),
(1423,1420,NULL,755,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'f5015a23-32bc-45f0-bdd4-574e50eb3340'),
(1424,1421,NULL,756,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'e93d7c83-fe99-4ed8-9873-067781188103'),
(1425,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 20:39:37',NULL,NULL,NULL,'137c19fb-13a6-43b3-a183-3d975cff4c0b'),
(1426,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'e12bddeb-9d59-49e9-bfca-879d3358eedd'),
(1427,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'9a4c32a0-41a7-4196-9681-452c9b2c0589'),
(1428,1425,NULL,757,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:40',NULL,NULL,NULL,'f9d41542-541f-455a-b8e4-77971605eee1'),
(1429,1426,NULL,758,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'732f7e0a-a58e-44df-86da-ab57812d8c1d'),
(1430,1427,NULL,759,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'6b82c2d1-81ec-47b4-9d48-093d5a1093de'),
(1431,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:37',NULL,NULL,NULL,'48eba560-3fda-4658-863a-2ed2ea78d8c4'),
(1432,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'e6de6bdb-fda1-4ba4-a403-f7e505a85f25'),
(1433,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'1d4df37b-a1f7-44aa-a752-bd27261ee3e0'),
(1434,1431,NULL,760,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'98908d06-d1ae-4627-aba7-7930830d590f'),
(1435,1432,NULL,761,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'d9a4fded-91e0-45ae-9c88-7d40e18fa331'),
(1436,1433,NULL,762,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'66f3a2bf-6704-4029-9343-d7de7457180f'),
(1437,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-10-23 01:33:57',NULL,NULL,NULL,'cbfd4361-ffce-4592-b81d-197459a87850'),
(1438,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'79f8bfad-f6fd-496b-bb2b-b18aeef9c1da'),
(1439,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'df18802f-5928-4428-b780-465aeda74ac0'),
(1440,1437,NULL,763,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'3e88023a-6fd1-4295-9fbf-f91a299dea90'),
(1441,1438,NULL,764,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'f5d08f5a-95a5-41b1-914d-b306484b36ed'),
(1442,1439,NULL,765,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'9a7d5c70-c5c9-40ec-8a5c-5c258ecb9ecd'),
(1443,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-10-14 13:43:52',NULL,NULL,NULL,'831b2af1-17e9-43bf-a866-1b800adbf68a'),
(1444,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'e00c8df3-3971-48c8-af19-038b82eb4ba7'),
(1445,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'3c65783f-33e7-4ffc-bb0a-04996639d730'),
(1446,1443,NULL,766,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'f586d7cd-93d2-4b89-ac91-a054e12cb936'),
(1447,1444,NULL,767,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'ff273a9d-eff7-4a20-bc7a-21c1201f4103'),
(1448,1445,NULL,768,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'0322bb74-57b5-470d-964b-b30250ce5c19'),
(1449,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:38',NULL,NULL,NULL,'b3760ae8-a6d0-4798-b7d5-0e34e2f724eb'),
(1450,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'a1751340-9fe1-4b40-9a9d-37e0f2c3475c'),
(1451,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'c96dca8e-8a09-4e4c-82db-24631a5f6897'),
(1452,1449,NULL,769,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'5795e92e-598e-4042-9fa8-12750031e6a8'),
(1453,1450,NULL,770,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'cb5978d5-79e0-4a0f-ba7d-ff4e3da1ee70'),
(1454,1451,NULL,771,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'916f1236-d9ae-4ccd-8615-9ec2181873d9'),
(1455,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:38',NULL,NULL,NULL,'8652f720-82f3-44c9-87dc-ac5f3c6151fc'),
(1456,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'8c6cd355-9b93-4b0c-af81-587274a7a28c'),
(1457,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'e86f45b4-3583-4604-a341-32c0b2a92b55'),
(1458,1455,NULL,772,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'70df6f09-6608-4f8b-bee7-de4d42f3774a'),
(1459,1456,NULL,773,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'3bafd2d4-301b-455e-abb3-a874bf8b7d0d'),
(1460,1457,NULL,774,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'4dbbb847-1ac6-4514-a003-ca72f57a24e2'),
(1461,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:38',NULL,NULL,NULL,'e7791e13-ae0e-4fae-9b48-9b58ceaf42e8'),
(1462,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'d1707441-5c0d-45a3-93b5-841925d01056'),
(1463,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'0a29bd69-fbf6-4b46-95a2-37d02ef166f8'),
(1464,1461,NULL,775,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'54273e6b-363c-443c-ae4b-853f51fd4622'),
(1465,1462,NULL,776,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'5a9ff66e-d3a3-406f-8e0b-d0f21209ff4b'),
(1466,1463,NULL,777,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'cd6adbb7-5876-4d33-ac1a-e4746ddb1cea'),
(1467,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:38',NULL,NULL,NULL,'2968431d-70dd-4a0d-831a-b32a94b232c0'),
(1468,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'d84ae4c3-70cb-414b-bae9-6f1d9166db44'),
(1469,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'c84a1aa1-887f-41de-a39c-6e72f6048bff'),
(1470,1467,NULL,778,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'a04b3e26-89b2-4a53-a861-c62c8f14019b'),
(1471,1468,NULL,779,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'0fa18d33-5f4f-427c-96a0-7ad438682e27'),
(1472,1469,NULL,780,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'5af2ceb6-7782-4114-8437-d8c354c6c67e'),
(1473,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-10-16 19:18:56',NULL,NULL,NULL,'1b66deef-1654-4f64-80a7-f8cb4ea28cb6'),
(1474,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'88d15859-d314-492e-af61-c806c266654e'),
(1475,1473,NULL,781,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'7d170fad-ea7c-4c68-b0cd-6d00fd70097c'),
(1476,1474,NULL,782,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'5f7f1c0c-d22e-42c6-b93b-8851aee587a8'),
(1477,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-10-16 19:21:39',NULL,NULL,NULL,'4dac3a68-c074-41c9-a527-20c0f8126c51'),
(1478,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'7b5b31ea-9bff-410c-b9bd-cf0e6184e684'),
(1479,1477,NULL,783,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'8722911b-d004-4988-a9b2-2b0f3f68ca6b'),
(1480,1478,NULL,784,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'314cbf6d-05d4-4a79-892f-4a2579e6d857'),
(1481,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-10-16 19:23:32',NULL,NULL,NULL,'39cc6402-c4cc-48b9-bf88-74665c556ebb'),
(1482,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'dbe046f9-6776-4d71-ac3e-249e91a16180'),
(1483,1481,NULL,785,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'be58ee60-8046-4fd4-bb1c-db7f45a69814'),
(1484,1482,NULL,786,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'09eabf2e-24a1-4379-a4bd-5c713d80194f'),
(1486,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-17 19:37:16',NULL,NULL,NULL,'3d790092-8841-4a7f-8010-4b58d8fb75ed'),
(1487,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-17 19:37:16',NULL,NULL,NULL,'d8648c2a-9f0f-4b86-a648-71d5f39267c9'),
(1488,2,NULL,787,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'992830bd-a5fc-42e4-a202-cce71ac1a0ce'),
(1489,56,NULL,788,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'c3d65e62-45f2-4259-8494-7f2ba346948c'),
(1490,57,NULL,789,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'19428224-8116-4c4f-b11e-0d7099a1e308'),
(1491,63,NULL,790,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'d41f031f-75e1-4b69-89a4-8cb06acbd798'),
(1492,1486,NULL,791,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'3c2d1464-09b2-4466-ae39-e699ad9a086f'),
(1493,1487,NULL,792,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'c2a20ee2-0904-4957-aeab-156c5c545e29'),
(1494,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 20:39:29',NULL,NULL,NULL,'bcc07c12-ea8c-4c99-a036-705be2becdbc'),
(1495,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 20:39:29',NULL,NULL,NULL,'a218a501-28dd-435f-9065-d960aabc82d2'),
(1496,945,NULL,793,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'5f6578e3-b703-4f4f-9519-c6d2d22c1188'),
(1497,1494,NULL,794,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'c34c9e2a-0a10-4471-b5ff-96ba4bc1eb94'),
(1498,1495,NULL,795,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'70a98b62-35fa-4e15-a66b-40c239a54583'),
(1499,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 22:21:46',NULL,NULL,NULL,'869ba898-7c45-4e23-9b77-d0773cdb9e77'),
(1500,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 20:39:29',NULL,NULL,NULL,'ec2cb18c-7316-4561-bedd-709e604c85da'),
(1501,951,NULL,796,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:17',NULL,NULL,NULL,'2cc6f3e1-db5f-466e-aaea-ccfa3e835f3d'),
(1502,1499,NULL,797,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'2b960c80-8328-4c72-9045-9c13cb8d99ed'),
(1503,1500,NULL,798,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'04afa3b4-6ebd-4e9a-a5e2-3398fa2692c1'),
(1504,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 18:43:12',NULL,NULL,NULL,'fa6a8d9c-3388-4a14-a4ab-15a641f5c9c7'),
(1505,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 18:43:12',NULL,NULL,NULL,'19235825-3470-44a9-bcf5-f90804e5d549'),
(1506,957,NULL,799,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'ce8aa21f-6119-4d65-a5ca-e3544c8df9f1'),
(1507,1504,NULL,800,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'4071bdfe-4fad-4db8-a7bd-0567ea5df964'),
(1508,1505,NULL,801,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'8ac1a79d-1eb3-46de-af1f-caad72418e35'),
(1509,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 18:52:55',NULL,NULL,NULL,'4c813f98-05db-45a9-baff-afa71ea75d34'),
(1510,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 18:52:55',NULL,NULL,NULL,'c2a25819-6441-4a63-a27d-fd3a8ece8c59'),
(1511,963,NULL,802,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'22fd9aa2-a8d5-4bbf-8295-a99d3198168e'),
(1512,1509,NULL,803,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'325642a7-4c06-4361-8278-7d17876c002d'),
(1513,1510,NULL,804,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'94226a6b-0d5f-43d3-bd3a-f57cb25e54ca'),
(1514,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 19:00:47',NULL,NULL,NULL,'f47ec6a8-040e-4f19-b6bf-aa54fcd868f3'),
(1515,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 19:00:47',NULL,NULL,NULL,'2b582155-bafd-41d2-b61e-18900b57bf14'),
(1516,969,NULL,805,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'446e4054-bec5-41b2-ac2b-28a2716d7d3a'),
(1517,1514,NULL,806,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'1c650e5c-0773-4b97-bbd2-4b6a3b8566ff'),
(1518,1515,NULL,807,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'7be8d060-1fde-4af5-9f3f-70d6be6f3c18'),
(1519,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 19:59:16',NULL,NULL,NULL,'a2ea9619-681e-4bce-8251-ea3ec57d5055'),
(1520,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 19:59:16',NULL,NULL,NULL,'01750b34-4fb1-47c1-b412-a69ea5a63651'),
(1521,975,NULL,808,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'c14d1e9f-a3cb-477e-b419-ad0729e1ef99'),
(1522,1519,NULL,809,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'cdbb91b8-a5dc-4dde-b32e-193ce3193240'),
(1523,1520,NULL,810,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'f329bcfc-4243-4c63-8072-a67f1711c59c'),
(1524,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 20:39:30',NULL,NULL,NULL,'cae0731d-61a3-476e-b171-2347ec8f448f'),
(1525,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 20:25:58',NULL,NULL,NULL,'5a04ca5a-45d1-4921-bdca-3968a162f1f6'),
(1526,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 20:25:58',NULL,NULL,NULL,'c680d7e5-a164-4fe0-b75a-d750f8b669c1'),
(1527,981,NULL,811,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'e6354882-6a38-4788-a719-5d9184e2c47a'),
(1528,1524,NULL,812,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'fe1f44f3-e0b3-422a-9236-44b13e46fde6'),
(1529,1525,NULL,813,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'f4713859-22d9-4013-8ae0-f4844cafd16b'),
(1530,1526,NULL,814,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'22e968f1-a11e-498a-bc3d-6e1b7004a362'),
(1531,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-09 14:59:55',NULL,NULL,NULL,'1c70e206-c29c-4bf5-9067-3e0c185019a7'),
(1532,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-09 14:59:55',NULL,NULL,NULL,'472435b3-86eb-42e3-9e21-4039c10d851b'),
(1533,989,NULL,815,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'de45191a-4bb2-4730-8a22-fe030c5948da'),
(1534,1531,NULL,816,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'f211a9f0-f573-48b9-a56f-b6baf9fa84a7'),
(1535,1532,NULL,817,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'d32e1c7b-b917-488b-b698-dc9bc15402e1'),
(1536,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-09 16:31:32',NULL,NULL,NULL,'7b7a96c0-fd88-4e61-b3a1-434634e705d7'),
(1537,995,NULL,818,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'5346c5a0-8582-46ca-974e-7f1915f7034f'),
(1538,1536,NULL,819,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'5de51e2c-a327-45cb-8505-c72a80d0de4f'),
(1539,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-14 16:14:34',NULL,NULL,NULL,'8f9f6928-4dea-4f6a-b61a-ce50ce7a4487'),
(1540,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-14 16:14:34',NULL,NULL,NULL,'ee6281cf-dd6a-4ead-b69b-52f35cbc3037'),
(1541,999,NULL,820,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'b4fa0f92-4aeb-44b8-b784-cea7078d71a7'),
(1542,1539,NULL,821,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'7a6ca703-0936-4b26-8dab-a6ac2fc8c3a8'),
(1543,1540,NULL,822,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'0e8889d6-7949-4344-8c01-acd2e4e9d70c'),
(1544,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 16:42:54',NULL,NULL,NULL,'b3d474bd-9a80-446e-be3b-f3dd8f95a749'),
(1545,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 16:42:54',NULL,NULL,NULL,'f797fd60-d5b7-4a1c-ba1d-cf2985a2dd0e'),
(1546,1005,NULL,823,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'cfdf2b5c-c774-4c9c-9533-83a66068228a'),
(1547,1544,NULL,824,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'9f308709-117d-44b9-bf51-dcd985e12112'),
(1548,1545,NULL,825,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'72f3a745-6155-48a3-a80f-ae5b637e6e2f'),
(1549,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 17:05:50',NULL,NULL,NULL,'2c4d4b91-a2cd-44e4-a698-411d971566d7'),
(1550,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 17:05:50',NULL,NULL,NULL,'6bfee32f-985b-4da9-aac7-6d136c688743'),
(1551,1011,NULL,826,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'6e31745b-43ad-41e0-af18-e7449a4006dd'),
(1552,1549,NULL,827,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'24083c0b-7342-45ad-a2d4-c9f153dd3997'),
(1553,1550,NULL,828,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'d1398982-fbea-4427-9d84-8ca4e994ea85'),
(1554,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 17:10:15',NULL,NULL,NULL,'818e14f3-eced-4187-bb05-1e7052a16d2d'),
(1555,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 17:10:15',NULL,NULL,NULL,'1c97b0fb-ef0a-4374-af62-9d7ddcd2adaf'),
(1556,1017,NULL,829,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'d527fae8-aa6c-412c-a757-c4e33dfa5389'),
(1557,1554,NULL,830,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'d460cd6c-e9d5-4dfe-9a7a-4e64b03781ec'),
(1558,1555,NULL,831,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'35455501-4a8b-4d5f-a8aa-cbeb3eb37081'),
(1559,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'08b7891f-7ef9-492e-9a1a-4f70b6182e4b'),
(1560,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 17:20:39',NULL,NULL,NULL,'3beaa422-e9a0-487b-8fc8-5c51a3db68a2'),
(1561,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 17:20:39',NULL,NULL,NULL,'5fb39a85-440f-47c8-bb92-0ac03be1f30b'),
(1562,1023,NULL,832,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'24b898cc-fbd0-42ec-818b-b907e76dc91e'),
(1563,1559,NULL,833,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'deea09bf-a9ba-4433-96fa-9aaead6811db'),
(1564,1560,NULL,834,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'396907d2-ddcf-46d1-8981-67def04b52e1'),
(1565,1561,NULL,835,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'97993b18-f936-40a2-bddc-3a84c14babcd'),
(1566,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:31',NULL,NULL,NULL,'3cfc1ccf-a8ef-46dd-aa1e-cd1fc857648b'),
(1567,1031,NULL,836,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'a76e1caf-84dd-411b-844f-e596924a4ce4'),
(1568,1566,NULL,837,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'ca03c0ae-718f-45a0-b018-be3a500378cf'),
(1569,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 17:24:35',NULL,NULL,NULL,'242041a7-0de1-4672-841c-dc68b0234fd2'),
(1570,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 17:24:35',NULL,NULL,NULL,'fe040441-4598-4c71-910e-ab8973b5641c'),
(1571,1035,NULL,838,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'76a6436f-bc71-4fc9-b8a3-428357e8de61'),
(1572,1569,NULL,839,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'cdf57a62-37c3-4e8d-bf55-4d37a59d2097'),
(1573,1570,NULL,840,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'6932c67a-2fc3-43ff-a5f9-df73478a6a39'),
(1574,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-10-09 17:29:43',NULL,NULL,NULL,'80dbadc7-dbf1-427d-83d3-9b7ccc560196'),
(1575,1041,NULL,841,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:19',NULL,NULL,NULL,'3e29aef8-b773-4acf-8035-1be83196a311'),
(1576,1574,NULL,842,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:19',NULL,NULL,NULL,'d4f3fac6-ec2d-4d4d-a2b4-88315ac164cc'),
(1577,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-09 20:48:21',NULL,NULL,NULL,'dc1d4a8f-d428-4342-9942-efcf7a829bd7'),
(1578,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-09 20:48:21',NULL,NULL,NULL,'267f52a0-90be-4067-acf5-3ca538764045'),
(1579,1045,NULL,843,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'9ef5a4b7-dee9-4bfa-8018-360096a4d121'),
(1580,1577,NULL,844,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'18a3d99a-f249-4dee-9400-d60c21c0b9e1'),
(1581,1578,NULL,845,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'5b0073cd-9b18-445f-93ed-aadd165f7367'),
(1582,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'ab186df8-b9a2-49ea-af07-66f2378ecf5e'),
(1583,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-09 20:56:04',NULL,NULL,NULL,'f1b27b4a-f865-4548-bf7e-0613c02036a6'),
(1584,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-09 20:56:04',NULL,NULL,NULL,'9cc47e5a-cf9f-48df-8d55-7bc428be06d4'),
(1585,1051,NULL,846,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'a650b655-05e4-4ef2-864b-ff66f7652d92'),
(1586,1582,NULL,847,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'446c3fc8-16d3-4de6-939d-24d8afdbe60b'),
(1587,1583,NULL,848,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'30cbeb54-8185-40fa-856a-c57b2f80399a'),
(1588,1584,NULL,849,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'06c74666-b097-4802-a6dc-212d5d809a2f'),
(1589,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'96327c94-0c72-4895-9f4f-8e04afd352df'),
(1590,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:02:33',NULL,NULL,NULL,'7d9136f2-15e1-4ab7-b2b1-56fa9e43355e'),
(1591,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:02:33',NULL,NULL,NULL,'a1f9bafa-b757-435e-8731-9219b2071673'),
(1592,1059,NULL,850,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'3a917f4d-9320-49a8-9f19-69b79db4f4c7'),
(1593,1589,NULL,851,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'f996d56f-9d63-403f-ba02-ce316e65b30d'),
(1594,1590,NULL,852,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'50c7a625-31db-4ef8-ad56-cb2e9f2729bd'),
(1595,1591,NULL,853,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'2faa8e39-89fb-4e33-9f76-96d89f68c39a'),
(1596,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:04:07',NULL,NULL,NULL,'71542126-c1bb-482b-97ef-4fe0b493c037'),
(1597,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:04:07',NULL,NULL,NULL,'f1e31aa6-e7f0-4123-bc34-c0945bb7f522'),
(1598,1067,NULL,854,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'1298d3fb-9375-4d68-b188-9c1359be283e'),
(1599,1596,NULL,855,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'9303380c-4e51-4955-99f9-918c5b6b8d48'),
(1600,1597,NULL,856,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'08cdbe79-c9d2-477e-acff-2cb18e7d7191'),
(1601,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'877bfd37-9baa-457b-8185-cfee54576b3b'),
(1602,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'624eff7a-6fc4-4aad-b6b7-02f89bedcca3'),
(1603,1073,NULL,857,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'ce628c80-6ce7-4a27-a78a-55dbf6f89f47'),
(1604,1601,NULL,858,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'a41048fc-3a9c-402d-bda0-ccdfe72e60e1'),
(1605,1602,NULL,859,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'f69e19b2-88de-4b99-9b7c-a76590a308f2'),
(1606,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:15:51',NULL,NULL,NULL,'f1118721-674d-4a90-9282-79cb352dbe26'),
(1607,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:15:51',NULL,NULL,NULL,'6967b0d6-ef75-4363-a983-b9e5b454ab9f'),
(1608,1079,NULL,860,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'ac2e114a-7b24-43f9-848d-0b81aab82de3'),
(1609,1606,NULL,861,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'6ce33d5c-0f53-4ec9-a16e-6c6cc55388d3'),
(1610,1607,NULL,862,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'1c1b47e0-f50c-4763-8578-925a6c5d61c9'),
(1611,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:43:47',NULL,NULL,NULL,'0fd673de-e926-43c2-8964-9cfb361c6b50'),
(1612,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-10-13 16:43:47',NULL,NULL,NULL,'93ac7653-3cca-4460-9789-0948234f458a'),
(1613,1085,NULL,863,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'62bfdfca-f0de-45c8-8eb2-89a72f5a8845'),
(1614,1611,NULL,864,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:20',NULL,NULL,NULL,'2789a5f6-d3d9-4711-b469-d77789f115d2'),
(1615,1612,NULL,865,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:20',NULL,NULL,NULL,'4e2e029c-f9c6-4106-ad34-f3639b3a7475'),
(1616,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:09:47',NULL,NULL,NULL,'e4ff0752-72c2-4db7-997b-e0c2fab843fb'),
(1617,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:09:47',NULL,NULL,NULL,'dd4f1c54-ed3e-492d-a4e2-64a4b58e1aa7'),
(1618,1091,NULL,866,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'26ecb9a6-97eb-4e7a-aa6d-323e1d108fa8'),
(1619,1616,NULL,867,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'26d9cdba-f85d-4a93-9b25-e0369b28df1c'),
(1620,1617,NULL,868,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'6d361fb2-b6d7-4a90-baca-62c4fc7a05d1'),
(1621,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:23:02',NULL,NULL,NULL,'67749652-d5a4-47f3-9731-42af69829579'),
(1622,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:23:02',NULL,NULL,NULL,'99ff09c9-fb4c-49c1-890a-b48ea561e917'),
(1623,1097,NULL,869,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'e2d2d06e-0044-4731-93d9-c1b7c02d30d0'),
(1624,1621,NULL,870,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'69669ad6-3ef8-40ba-8c6f-ed4562b6f106'),
(1625,1622,NULL,871,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'33839b4e-f77d-4e2e-8ee8-40e3a087dc2f'),
(1626,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:28:26',NULL,NULL,NULL,'2ce3deea-8f5c-488a-8774-aed3fae0e087'),
(1627,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:28:26',NULL,NULL,NULL,'048e1eef-0ea7-462f-89ba-d9008fcf2f0f'),
(1628,1103,NULL,872,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'90443b6c-75e3-4a87-b152-aa180ef0dbde'),
(1629,1626,NULL,873,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'98a0fc20-da2b-47e0-b836-07a12d30118b'),
(1630,1627,NULL,874,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'6823ffa5-5400-47b6-b9a6-f3baf4d39a4d'),
(1631,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'48d52a92-a8f0-49de-a547-f5bc7e8d9fc9'),
(1632,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:43:34',NULL,NULL,NULL,'6bc7c756-aef2-4ed6-8479-624220c98c2a'),
(1633,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:43:34',NULL,NULL,NULL,'2bfd22e4-9e3a-4af7-afe9-09be20061e66'),
(1634,1109,NULL,875,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'c21527da-4a68-46dd-9aa7-31d4fa2f0ef9'),
(1635,1631,NULL,876,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'7075bacd-530b-4fd7-8ea9-1251ed13ee4c'),
(1636,1632,NULL,877,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'fc062f0e-ba24-48e9-a1b7-5f14da43550d'),
(1637,1633,NULL,878,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'c5a58884-0d89-4fc5-884d-60ade35000b7'),
(1638,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:47:19',NULL,NULL,NULL,'7de51130-bec9-4b22-b2cc-40d3949c8d42'),
(1639,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:47:19',NULL,NULL,NULL,'d4d941e5-4019-411f-a89a-3e114d000059'),
(1640,1117,NULL,879,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'db1b1244-f5cb-4a6e-add5-669895a3dd1b'),
(1641,1638,NULL,880,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'fd652a0c-c552-4698-9159-acaba1002a7b'),
(1642,1639,NULL,881,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'f00ca14e-86d7-48cc-86c4-19d789070ac2'),
(1643,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:52:01',NULL,NULL,NULL,'93866d5c-e218-4a5c-83d1-748eabf50ca6'),
(1644,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:52:01',NULL,NULL,NULL,'f0fd69b9-cb1d-4e34-b692-f7aa1308332b'),
(1645,1123,NULL,882,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'9de724ae-da94-4d92-8e97-7a82a656291b'),
(1646,1643,NULL,883,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'28ee316e-d8f0-4a59-b4aa-f7514e5af48c'),
(1647,1644,NULL,884,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'94383d30-23a5-4549-9758-9223e57af554'),
(1648,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:57:28',NULL,NULL,NULL,'12b722db-8261-462d-a755-15979b6f0776'),
(1649,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-10-13 17:57:28',NULL,NULL,NULL,'f07ff0d1-bfbf-4d9e-b615-de7da942ece5'),
(1650,1129,NULL,885,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'d55c08d6-0076-4c93-85c9-547c11277fd3'),
(1651,1648,NULL,886,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'4d4fb4aa-b1ee-4e2b-b0f6-128719ce2adc'),
(1652,1649,NULL,887,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'8a8565f0-3e8b-46e8-a878-16eda6c4b32f'),
(1653,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:32',NULL,NULL,NULL,'76803157-1a52-4ad4-bf4b-5c6dd96ced73'),
(1654,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:32',NULL,NULL,NULL,'2f57269c-dff1-4ea7-8e9f-a3424434b1c9'),
(1655,1135,NULL,888,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'9608b27e-a7f2-47df-a45a-6b7f8e4e5ebe'),
(1656,1653,NULL,889,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'2eb10c5d-4451-4a81-8916-83999c45eaaf'),
(1657,1654,NULL,890,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'9efa88df-403b-48cb-9f10-0d9a348d5fd0'),
(1658,1141,NULL,891,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'a1dd39cc-e343-4483-a3dc-1e4beaa5a8ce'),
(1659,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 18:02:09',NULL,'2025-10-13 18:02:09',NULL,'3a523137-c22a-4542-b907-8e324e63286a'),
(1660,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 18:02:09',NULL,NULL,NULL,'62d624e2-e31b-4c3f-9860-4724e86067e3'),
(1661,1143,NULL,892,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'849cc0a0-0c96-463b-939e-ba9f41b6bae1'),
(1662,1659,NULL,893,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,'2025-10-13 18:02:09',NULL,'755d8179-aaeb-4bd8-8d6d-01c55c1e9b9f'),
(1663,1660,NULL,894,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'7938168f-3f25-4a40-b1e2-cdd1bcdd40ca'),
(1664,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:10:27',NULL,'2025-10-13 19:10:27',NULL,'c976e4fd-a038-489e-8477-bde184a4ee42'),
(1665,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:10:27',NULL,NULL,NULL,'1c14f825-78a0-4c69-aaab-7e5653da9f7c'),
(1666,1149,NULL,895,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'59f2f3ff-1362-4e08-9ec0-9d18531f00a2'),
(1667,1664,NULL,896,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,'2025-10-13 19:10:27',NULL,'ed2b76e3-408d-4f68-962a-adda88e19dcf'),
(1668,1665,NULL,897,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'ad45b4bf-2650-4f21-ac8b-2d2a7ca4e17e'),
(1669,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:24:55',NULL,'2025-10-13 19:24:55',NULL,'81b2f1ac-2a38-4eab-82e9-64a4c778113d'),
(1670,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:24:55',NULL,NULL,NULL,'719386ef-189c-4aa3-bd88-5f85ec1457e8'),
(1671,1155,NULL,898,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'04029068-43ff-49d3-81c8-621db14e58c9'),
(1672,1669,NULL,899,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,'2025-10-13 19:24:55',NULL,'8466022f-0af6-4d3c-b2be-db150ff7a6a8'),
(1673,1670,NULL,900,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'e755ba7a-a013-40bc-9f3e-f81b04c2d98e'),
(1674,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:33',NULL,NULL,NULL,'e7e6448a-d2dc-4442-8f22-aaa73546d208'),
(1675,1161,NULL,901,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'9d6c6c4b-202c-491a-847a-d0f7fd1b00ed'),
(1676,1674,NULL,902,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'db79726b-a515-41fe-acd9-a419ff26279e'),
(1677,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:30:02',NULL,NULL,NULL,'8e117128-fc30-4864-ab2a-2ec752739976'),
(1678,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:30:02',NULL,NULL,NULL,'9ef20d13-0f68-4d1c-84b0-488a5047dc0d'),
(1679,1165,NULL,903,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'ebec268c-1bac-491f-a0e2-99785f7f779a'),
(1680,1677,NULL,904,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'aee49ab0-ca98-4965-adef-1ce8d0bb56eb'),
(1681,1678,NULL,905,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'119a073c-fb35-4520-a35a-c2dbbe835b0a'),
(1682,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:34:44',NULL,NULL,NULL,'2d4b474d-0e73-48cc-8848-d539e0cb0a0d'),
(1683,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-10-13 19:34:44',NULL,NULL,NULL,'5413ecea-af7a-4c90-adb2-fb08a69c6858'),
(1684,1171,NULL,906,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'41486ac5-5bdb-401d-949d-a0506d41d6c6'),
(1685,1682,NULL,907,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'3e8540fc-6ea4-43b6-9fdd-1b2971980111'),
(1686,1683,NULL,908,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'2d3a096f-aa14-4c23-893b-e00529728b95'),
(1687,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'802ff893-9dd0-47f6-b76b-1f79ab5cb3bd'),
(1688,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'56cb0fa7-e9c5-44e7-9b65-64a18ccf8ae7'),
(1689,1177,NULL,909,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'fae1110a-a367-4215-9a8b-6ba4046ec272'),
(1690,1687,NULL,910,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'3b35e70a-c077-4351-bd17-ef473da66bef'),
(1691,1688,NULL,911,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'a4eda232-1f4a-4461-a016-665c50316ebb'),
(1692,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-13 19:39:32',NULL,NULL,NULL,'71e11bb6-2370-4290-bebb-18c47e65bcc8'),
(1693,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-13 19:39:32',NULL,NULL,NULL,'4927887c-3d65-40a0-9f31-4c8cfd54330d'),
(1694,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-13 19:47:44',NULL,NULL,NULL,'fed36498-fd42-4455-8920-8485427e2921'),
(1695,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-13 19:47:44',NULL,NULL,NULL,'ca92fb52-1474-4b0c-a08a-b54accf3ce7e'),
(1696,1185,NULL,912,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'ee4c93be-cd3d-400d-9979-f08d3a927d51'),
(1697,1694,NULL,913,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'27e66328-8500-4cbe-ab42-3dc45ddb4eb6'),
(1698,1695,NULL,914,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'9421cb12-8c71-486a-bc81-e956452c0f44'),
(1699,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-14 16:49:14',NULL,NULL,NULL,'ba72f07f-60ac-43f1-b149-8b2cc7f13296'),
(1700,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-14 16:49:14',NULL,NULL,NULL,'198c5c70-c72b-4af9-817c-fca417943203'),
(1701,1191,NULL,915,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'3d50dea2-d914-487e-84bd-61342a08114a'),
(1702,1699,NULL,916,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'adb139dc-ce51-41eb-863c-c4153f853698'),
(1703,1700,NULL,917,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'44abfe06-6d07-468c-9bab-bb3129d06883'),
(1704,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-14 16:53:18',NULL,NULL,NULL,'e4becd4f-4f88-45e9-aa43-cba6bf902c55'),
(1705,1197,NULL,918,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'444121f4-f36b-4b38-8982-30cce4084e7a'),
(1706,1704,NULL,919,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'0598bdda-bfb2-4337-8640-a7da196530df'),
(1707,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'45d1a41a-8ae9-4339-9f60-5151521a8370'),
(1708,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-14 16:56:56',NULL,NULL,NULL,'85ba5ba2-dcd2-4d62-a5f4-e4e7899a49ad'),
(1709,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-14 16:56:56',NULL,NULL,NULL,'a5582294-c853-4a4d-b525-a7d0a8d1df93'),
(1710,1201,NULL,920,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'83f1f19b-c802-495b-ac4e-889569fd4156'),
(1711,1707,NULL,921,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'beb1f95e-9150-4d43-aa8d-dbf7bc015536'),
(1712,1708,NULL,922,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'3e781fdb-4dc0-4b47-a806-13f29b4650f1'),
(1713,1709,NULL,923,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'6ea5a8a2-7ca1-46ea-afa4-59dcd493e3dd'),
(1714,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-14 17:00:06',NULL,NULL,NULL,'d9236cf2-6abc-4b9e-9cdd-4d4d0d3591c0'),
(1715,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-14 17:00:06',NULL,NULL,NULL,'d990cde1-8e63-4ef5-9870-8fc3972bb19c'),
(1716,1209,NULL,924,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'46b9077b-a2bb-46e0-9e5c-3efdc48dd02b'),
(1717,1714,NULL,925,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'79b446c7-ec6e-4d57-abe9-d890d04da4d3'),
(1718,1715,NULL,926,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'ba3156d4-274d-46be-b952-07829b41f675'),
(1719,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-10-14 17:05:13',NULL,NULL,NULL,'64c70303-a72c-4aea-92ce-c5429bd30743'),
(1720,1215,NULL,927,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'30d3383e-0fe5-4b6a-8feb-df65f4c624ca'),
(1721,1719,NULL,928,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'c9d9d4da-c518-4d82-ba0d-b15820567031'),
(1722,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:09:21',NULL,'2025-10-14 17:09:21',NULL,'33f1fc78-0dac-4051-a32a-80d2c70ba679'),
(1723,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:09:21',NULL,NULL,NULL,'439ee6ec-aac0-4819-8f5d-194f2ba7bbe4'),
(1724,1219,NULL,929,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:23',NULL,NULL,NULL,'0b853c5c-8428-490a-aac0-eb738f9e93ef'),
(1725,1722,NULL,930,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,'2025-10-14 17:09:21',NULL,'ab0a4a36-83d7-4f20-9ed3-598816917770'),
(1726,1723,NULL,931,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'3dfa9614-f48a-43f1-9fed-75dee00001af'),
(1727,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:12:18',NULL,NULL,NULL,'3f0b0778-06c4-4c22-a78f-37547b8405db'),
(1728,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:12:18',NULL,NULL,NULL,'9644df4d-82f1-45cc-9361-778ff3706f07'),
(1729,1225,NULL,932,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'fb5b253f-9c1e-416e-9485-97278d2a960f'),
(1730,1727,NULL,933,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'9b104be7-5ab2-4b96-b596-c3145d9d6844'),
(1731,1728,NULL,934,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'17d578b0-68af-48f4-a4c9-82ea467b06d8'),
(1732,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:15:30',NULL,NULL,NULL,'f7b088e1-ddf5-409e-8372-6630ebc6c03a'),
(1733,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:15:30',NULL,'2025-10-14 17:15:30',NULL,'11ae1d50-4e9d-4c54-b48b-08a6dafa0591'),
(1734,1231,NULL,935,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'ff3b6f48-2d80-4a4f-8a43-8d12cd9e7865'),
(1735,1732,NULL,936,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'dc171179-0907-416d-963b-507021688924'),
(1736,1733,NULL,937,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,'2025-10-14 17:15:30',NULL,'b8eb67d9-030b-4583-85d5-f6b732efa259'),
(1737,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:22:21',NULL,NULL,NULL,'788af7e4-7d73-41d4-ac96-0d205a4d96d8'),
(1738,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:22:21',NULL,NULL,NULL,'3613d1ca-196a-4292-ac4f-5f8154c3fe4e'),
(1739,1237,NULL,938,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'31d69baf-751b-422e-a10b-79cb9012ed50'),
(1740,1737,NULL,939,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'cc47d91a-414f-4212-a14e-cd58a7f83847'),
(1741,1738,NULL,940,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'d9c9f84b-8fc2-46bc-8078-09c9085664e4'),
(1742,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:25:14',NULL,NULL,NULL,'6a79d926-9798-4b90-87e8-6f9b1ba98aab'),
(1743,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:25:14',NULL,NULL,NULL,'228b7411-ef34-4956-8205-cab4baa70528'),
(1744,1243,NULL,941,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'21869279-96e1-482b-9317-e1bce6d13352'),
(1745,1742,NULL,942,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'3ff79a04-7487-456b-838d-8978082c23e5'),
(1746,1743,NULL,943,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'e0e84cff-2980-41a7-9ae6-a44c707ce1fc'),
(1747,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:28:10',NULL,NULL,NULL,'ec1206c6-2e89-4d63-8d6f-2e22dc517182'),
(1748,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-10-14 17:28:10',NULL,NULL,NULL,'5abe7f78-77c0-400e-a8a0-1627bda5ca98'),
(1749,1249,NULL,944,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'555bcebc-4e66-4d31-b11f-dc62ea4f0be5'),
(1750,1747,NULL,945,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'ab669648-fd16-45e3-aad4-db2741c89bc7'),
(1751,1748,NULL,946,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'7a119e1d-8d0a-42ff-8112-cfa7aab49453'),
(1752,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'e1c081a3-0cae-4820-8e5b-e010258bd9c1'),
(1753,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'42912698-68d2-423f-8fe9-2a80a2580d36'),
(1754,1255,NULL,947,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'44e659cb-a664-4699-a76f-8ed6a69c05ad'),
(1755,1752,NULL,948,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'ad1bde53-106d-47ea-aec6-e25410fb1a21'),
(1756,1753,NULL,949,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'e2862ace-de8d-470f-84d2-d57b4f10a6e9'),
(1757,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'968ad18e-9c07-4f7a-86df-7fdede551920'),
(1758,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'9ea957be-188f-49b7-8206-f375d4c6d08f'),
(1759,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'2de3e020-43c0-478a-806b-a143a8d12003'),
(1760,1261,NULL,950,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'9cd00f41-7b44-4143-a3eb-5b0706fa4d75'),
(1761,1757,NULL,951,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'d14b5f05-3259-4274-b858-b113de92899f'),
(1762,1758,NULL,952,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:24',NULL,NULL,NULL,'9fb2dbfa-384c-4984-9e55-232f259911dc'),
(1763,1759,NULL,953,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:24',NULL,NULL,NULL,'02201b4f-61f3-4de1-8f5c-6c3c12fa383d'),
(1764,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:34',NULL,NULL,NULL,'d82ebff9-5908-4f22-bec7-1f9332e237a7'),
(1765,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:34',NULL,NULL,NULL,'93f5f7e8-4301-4b40-bf8c-6046ce439a01'),
(1766,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:34',NULL,NULL,NULL,'9105f58c-e41a-425c-8a07-d988a8ecc2a9'),
(1767,1269,NULL,954,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'fbb5940a-24c7-4e57-9090-c782be86152b'),
(1768,1764,NULL,955,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'973a3325-eede-4664-9655-93ad2dfd9575'),
(1769,1765,NULL,956,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'91b7146b-f6b1-416c-a469-3a7578b0e48c'),
(1770,1766,NULL,957,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'b1aad48c-3854-487a-b805-03ce09484897'),
(1771,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'6d3bda87-f433-487f-b3e2-d02b6842b642'),
(1772,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'ddde8323-5f54-4bfe-8bf6-e327cc50a1cd'),
(1773,1277,NULL,958,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'919843e7-a5a4-47fc-bdd4-106f1503e923'),
(1774,1771,NULL,959,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'64bf31c6-050b-40a8-ba90-b6206c0e454a'),
(1775,1772,NULL,960,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'fe47425f-36c0-4a02-acae-e8507aa4acb2'),
(1776,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'c8395bcb-be25-4ef3-a610-dcd81378968f'),
(1777,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'70f3485b-1285-4936-97d5-7e0aabbca8a0'),
(1778,1283,NULL,961,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'6280843f-504f-4120-801e-4475984a064f'),
(1779,1776,NULL,962,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'0efa9bef-ab8e-4d76-a7cd-83929ce58592'),
(1780,1777,NULL,963,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'d2c17d3c-85a9-4621-af91-13c1685e1b1b'),
(1781,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'5368e443-5c98-489e-9860-db31db17d82e'),
(1782,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'412aec4d-0997-4bc7-a129-fee5322650c2'),
(1783,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'853b8c61-6a72-44a0-817c-151ee35b010f'),
(1784,1289,NULL,964,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'a71e4b86-90a4-49b3-bfac-ed673a00c619'),
(1785,1781,NULL,965,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'ad96e4ef-df1b-4355-9d03-c123070c74cb'),
(1786,1782,NULL,966,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'30bd123e-5fad-4325-8e71-dfc1eac92e93'),
(1787,1783,NULL,967,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'c2bd872c-6fa6-43a9-8794-5fbe5087d461'),
(1788,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'6dc12b4c-d661-4071-8291-06d5b9cfd6cf'),
(1789,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'8aef1db4-40d1-4d6e-aed7-9bc8ea3ccdd0'),
(1790,1297,NULL,968,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'ba582ce6-1373-44d7-a421-ec7d6fdffbe7'),
(1791,1788,NULL,969,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'27b07007-0ba5-4e11-8036-91d75e82beca'),
(1792,1789,NULL,970,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'3923cf3c-b335-4d70-a749-8fc02031984e'),
(1793,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'b0e8d74e-cae3-4bed-b433-cb4e98a80284'),
(1794,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'17a15f6c-143a-46bf-8383-901156835ab9'),
(1795,1303,NULL,971,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'092c3550-d902-457c-afb7-33011fd9ab86'),
(1796,1793,NULL,972,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'56c7d6bc-a4b2-404c-8491-755ccffe190b'),
(1797,1794,NULL,973,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'99c4e080-d14a-4409-af47-b9f539b30aa4'),
(1798,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'81229918-1389-4a86-92eb-56599daefbce'),
(1799,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'19f71060-ccf7-4fdc-a096-e765cbe4fa42'),
(1800,1309,NULL,974,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'73975a23-192f-47ab-9866-475d41f92e0b'),
(1801,1798,NULL,975,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'11785b0a-fe00-4003-a98a-93e22827611c'),
(1802,1799,NULL,976,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'8b1c5678-dd33-49b3-9dbf-bb83c045c075'),
(1803,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'0206e4c2-57f8-47ef-8560-4f35cee9ac0c'),
(1804,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'af57dddf-d829-46e9-93dd-8cec190c875b'),
(1805,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'82518c7b-5d2c-4d07-8b4b-51454aa88f45'),
(1806,1315,NULL,977,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'f05cfc82-5f81-4a16-b351-09d2a3562004'),
(1807,1803,NULL,978,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'d9d93d76-998a-4854-96ed-6c0c36ef981e'),
(1808,1804,NULL,979,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'ae6a96b1-7c13-4fb6-83fd-df178fd7da65'),
(1809,1805,NULL,980,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'060fad59-a8f3-401e-9b3b-c367abe79c3d'),
(1810,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'73e0c48a-d6b4-4ec6-a6af-83f8335f5652'),
(1811,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'918715b2-c4bc-4658-af5a-69db0da27cc3'),
(1812,1323,NULL,981,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'25fc5d75-043d-401b-bc4e-ec235be580a4'),
(1813,1810,NULL,982,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'96c40c9a-bf39-4b02-b0b3-d1ef699c7887'),
(1814,1811,NULL,983,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'008e9455-4302-437a-8200-f2c034e19054'),
(1815,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'06b9c2ce-1651-4a8a-86a7-7c5356bb72af'),
(1816,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'64699b22-e5f8-495a-b69f-002ec3c6c252'),
(1817,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'0000dc09-3e71-484c-bdd8-77f99317562d'),
(1818,1329,NULL,984,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'3979d680-a116-4b1e-a7a5-0a6c121b2dc6'),
(1819,1815,NULL,985,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'12929fde-3e14-4bf7-9962-35fb681d31aa'),
(1820,1816,NULL,986,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'20ea7922-0d56-4a6a-b101-82f8b3f912b0'),
(1821,1817,NULL,987,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'c7698e18-05df-4952-a42f-cf3c9b9f24cf'),
(1822,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'471f4d74-c7fa-499a-8cae-306b30164931'),
(1823,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'666740d0-f6b4-47b6-b6a0-06d620be07d4'),
(1824,1337,NULL,988,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'3cf03e59-8bbb-4c7c-ab6a-0a16b94ec7a3'),
(1825,1822,NULL,989,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'86e25dad-040d-4151-9433-981ae7171fa5'),
(1826,1823,NULL,990,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'b8e50546-66e4-4357-a6ff-79e90168fd42'),
(1827,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'d3297528-3b32-409c-b6be-16af3d192a2e'),
(1828,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'5087fcba-21f3-4836-aa5f-bb4358991f64'),
(1829,1343,NULL,991,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'47a34faa-5c96-4fc7-8038-ed197f8f08f8'),
(1830,1827,NULL,992,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'cb7d2bb5-23a8-43c7-871e-bcebdab94058'),
(1831,1828,NULL,993,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'413693ae-357a-4d84-a471-2f80573de0c6'),
(1832,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'a8a0fbbc-b600-474a-9ed9-5f0019fe100e'),
(1833,1349,NULL,994,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'a78de810-8a4e-417b-81f9-42be6866eda3'),
(1834,1832,NULL,995,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'619841f7-7e5d-42d6-b07a-3be4749d3c8a'),
(1835,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-10-08 22:38:45',NULL,NULL,NULL,'94e32ba8-ebc3-4b5e-b654-181c1c9d4545'),
(1836,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'25e0d7c9-f92f-456b-80e8-a37d0b1767f1'),
(1837,1353,NULL,996,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'be0e5ef2-a793-433d-82d6-2456045c46fc'),
(1838,1835,NULL,997,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'5c6db164-2569-4421-8654-bce24f27e6ba'),
(1839,1836,NULL,998,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'87c30f26-abbe-4f47-9054-4b591400aeee'),
(1840,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'6a5ff6fc-1ec6-4ae9-b309-d0857b40ffa9'),
(1841,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'0f75f919-cb58-42dd-ae2e-4a91477fa236'),
(1842,1359,NULL,999,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'054a9a26-bdf7-45d7-8904-7fa9ecb55865'),
(1843,1840,NULL,1000,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'5b6f6017-48f2-460d-ac3a-23b26e7b8519'),
(1844,1841,NULL,1001,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'243810f1-d51b-4b1f-8162-f5e19ddb5962'),
(1845,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'4cff4e0b-5e78-4452-8f7e-e59371200276'),
(1846,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'ab0ec391-d1fa-4972-bbe7-45f12d4cfe8a'),
(1847,1365,NULL,1002,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'7781b427-d058-4403-aa0f-cc068a97f598'),
(1848,1845,NULL,1003,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'110582f7-c9f0-4429-81c7-3eba238f02d7'),
(1849,1846,NULL,1004,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'8c6e358e-10e8-4c81-8685-997dee75488d'),
(1850,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'13d41bc9-272a-4b56-8acd-e47b263a7dc8'),
(1851,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'6f4138d3-17a0-4d35-9eaa-aa312afd0223'),
(1852,1371,NULL,1005,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'c31ec460-aa3f-4444-8912-d9d68ea626e8'),
(1853,1850,NULL,1006,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'6f7e1ed2-fa79-4f7f-9f85-5571e196b830'),
(1854,1851,NULL,1007,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'3d978518-f030-488a-ac90-3446c7b5c99e'),
(1855,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'7eb9ab17-2f8b-4252-bf92-afc200567d39'),
(1856,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'a36f62f6-2a9d-4c98-99be-27f86f6fd7ed'),
(1857,1377,NULL,1008,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'870a76c4-fb89-486f-b437-7d4124e5bdc4'),
(1858,1855,NULL,1009,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'8d42fd47-6ef8-4ecc-8061-fa3a8ad0432f'),
(1859,1856,NULL,1010,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'0896b4a9-0c43-4d98-85ae-9380b42d7f00'),
(1860,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'f4c2cf13-cf8d-4f75-9de0-85a34cda8767'),
(1861,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'692c5aaf-2be0-450e-b7dd-651bf6b6bf65'),
(1862,1383,NULL,1011,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'db174a89-be16-4626-9d89-18cc50c974c2'),
(1863,1860,NULL,1012,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'a876c37e-51c7-4417-a804-26bf56eab368'),
(1864,1861,NULL,1013,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'9072cc2d-0e66-46e7-aa12-ec0b6bc7ec48'),
(1865,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:37',NULL,NULL,NULL,'68fde66d-5ac0-42f4-a230-9b18495b7cab'),
(1866,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:37',NULL,NULL,NULL,'93cb8898-e7e9-4e8e-8a28-5a848b31808c'),
(1867,1389,NULL,1014,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'1ed059d2-1144-4704-be70-5daa0ed180a0'),
(1868,1865,NULL,1015,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'21903756-72b0-4bcc-87c3-ed845b043936'),
(1869,1866,NULL,1016,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'a622bc58-439c-4405-aaa8-34d6abe614b2'),
(1870,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:37',NULL,NULL,NULL,'79a4a800-b9ab-42d8-a63a-b451c268f49d'),
(1871,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:37',NULL,NULL,NULL,'c01a1617-10de-4435-a1ec-af12f1a5b62a'),
(1872,1395,NULL,1017,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'caa05347-6568-409c-a3f9-f937b62b94db'),
(1873,1870,NULL,1018,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'69c49503-d621-4a2e-b522-3496dec7fd43'),
(1874,1871,NULL,1019,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'f92ecf03-bc16-4699-838a-268fbed4dc9b'),
(1875,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:37',NULL,NULL,NULL,'7de77e35-487c-43f4-82d4-3cd73a9d9565'),
(1876,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:37',NULL,NULL,NULL,'d6965542-553d-488f-9455-2f53e087ece4'),
(1877,1401,NULL,1020,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:27',NULL,NULL,NULL,'3f235e86-5e7a-418d-91e0-fd1bb542ed90'),
(1878,1875,NULL,1021,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:27',NULL,NULL,NULL,'3b2f4148-5f19-406a-a7f9-92b0073fd6c2'),
(1879,1876,NULL,1022,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:27',NULL,NULL,NULL,'220dc80f-f81e-435d-8d0f-c610b0e867ca'),
(1880,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'11b2072d-e970-498f-a551-3269d8746893'),
(1881,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'08763e8f-9bc0-4f50-b349-a7606d107ab7'),
(1882,1407,NULL,1023,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'4a2eb12d-52e8-460c-833b-ee57c3d87ec4'),
(1883,1880,NULL,1024,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'14018a65-97f2-4571-bae4-6eabeacec21a'),
(1884,1881,NULL,1025,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'9bcce777-508d-4d4d-9818-d5bd44cc5525'),
(1885,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'230aafd5-fc7c-4ed5-bc04-07c152bc9305'),
(1886,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'a0affaf5-f3ae-498a-b8da-a05b6090982f'),
(1887,1413,NULL,1026,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'65f855ac-56d8-4dba-8e9c-579984fc626f'),
(1888,1885,NULL,1027,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'3d742b37-3867-414b-bbe2-f41326865c39'),
(1889,1886,NULL,1028,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'8bdd245d-2d07-49e8-a0b9-7dad79746fd3'),
(1890,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'a907db03-80e3-4fdc-8b3b-c6a0996071f2'),
(1891,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'f3038bca-418b-4e59-ba90-46f17cb83fb6'),
(1892,1419,NULL,1029,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'78f3b688-0e1e-424c-af6a-d8cf547ce2db'),
(1893,1890,NULL,1030,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'1135cd0e-5f94-4fed-b2bf-ede302b67f6b'),
(1894,1891,NULL,1031,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'704d5513-6f43-4d3d-8b54-fc07f2302d92'),
(1895,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'d33ac818-2b17-44ab-a4b6-a82f65147afd'),
(1896,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'d81333f6-ce9b-48d8-b8ea-efbfcb630410'),
(1897,1425,NULL,1032,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'3fc7cbab-9fd4-4bfa-b64b-a276e58e7a84'),
(1898,1895,NULL,1033,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'b9620373-ee8e-40f8-973e-0dd43b60c231'),
(1899,1896,NULL,1034,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'99c80352-f042-40ac-b568-8d5c28bdb51b'),
(1900,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'0920a6e0-b711-472c-9e82-2e7797f40822'),
(1901,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'c7fafe4f-2c59-46f0-95a1-36187c2bb9f2'),
(1902,1431,NULL,1035,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'a85d2601-cfed-4635-8410-7e0c3ef9b540'),
(1903,1900,NULL,1036,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'cf8cc35d-2a82-4759-9e25-729180f5320f'),
(1904,1901,NULL,1037,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'090e2936-d647-4b9d-8d3c-db7f4a342ad9'),
(1905,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'500423d5-fe9b-42a5-826b-7939bd7f9754'),
(1906,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'c3123b29-086a-4c9b-8425-63e307e498d0'),
(1907,1437,NULL,1038,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'bdd3a31a-23d2-4aba-8e99-dab5f8de482c'),
(1908,1905,NULL,1039,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'b748b024-0ff4-4e84-8518-aa52c0b61ad0'),
(1909,1906,NULL,1040,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'6b9a555f-2d7c-4e25-9d47-59eb0c8370b9'),
(1910,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'0bb92b57-5291-4f7e-88ad-87a4bc4785dc'),
(1911,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-10-14 13:43:52',NULL,NULL,NULL,'c4404b6a-770f-4759-856d-1f40e2496c8a'),
(1912,1443,NULL,1041,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'9a4a6e25-26ea-4ddf-9a33-256fc99de417'),
(1913,1910,NULL,1042,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'8606d728-1a7a-404b-a5a6-ca0a58f0aa7e'),
(1914,1911,NULL,1043,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'68800b7a-9bcc-404a-8129-709b324a84bb'),
(1915,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'1e5b50e5-aa15-41cd-844f-d693555e098c'),
(1916,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'cb288b57-6c2b-407a-988c-1fd6fc42d6db'),
(1917,1449,NULL,1044,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'25550513-724a-4fe1-bf13-524630ad9c9a'),
(1918,1915,NULL,1045,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'3ca9d135-e056-4e5e-9505-58e9675be716'),
(1919,1916,NULL,1046,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'e8c7b86b-9038-4260-b9c1-de90363db8b8'),
(1920,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'14ac5709-531d-420e-9026-888e03f07ffe'),
(1921,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'b83165b6-a1a8-44f9-95d5-43ca0cf6416c'),
(1922,1455,NULL,1047,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'4e19b3af-86c6-48f1-96b9-97f153cf7f1f'),
(1923,1920,NULL,1048,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'138f1306-d885-45d1-aa0c-b5b500498840'),
(1924,1921,NULL,1049,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'63943615-d97d-4702-ab4e-1bc8eb09354b'),
(1925,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'8e4e8ed5-d2a1-423f-adce-87931beecf0e'),
(1926,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'dfd8d683-58f6-468e-be34-b4b6e7c17fb9'),
(1927,1461,NULL,1050,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'243ef27b-8197-40bb-bf53-5ccabaaa9b5c'),
(1928,1925,NULL,1051,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'59b2bd62-935f-4859-8080-4d09e205366c'),
(1929,1926,NULL,1052,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'986c668a-08e6-4c51-a72d-0919da9021e2'),
(1930,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'f4c1f7dc-7a75-42ee-ac92-9ef9b78f61fc'),
(1931,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'a438d929-77c9-4af7-abef-b2879f1e5c84'),
(1932,1467,NULL,1053,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'45ea515f-3ed9-4075-8894-188072e6c3ed'),
(1933,1930,NULL,1054,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'50604da0-dcf0-4764-a777-f68bc1810b66'),
(1934,1931,NULL,1055,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'be79f7df-2425-484e-ab24-abbba17b0ceb'),
(1935,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-10-16 19:18:56',NULL,NULL,NULL,'cfce61df-c81b-4f57-a3aa-983ba807fa20'),
(1936,1473,NULL,1056,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'45419a6a-da1f-451e-8953-6ca423ce243f'),
(1937,1935,NULL,1057,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'4ab12f2e-3542-4181-b00e-1fe92785fb63'),
(1938,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-10-16 19:21:39',NULL,NULL,NULL,'f6ee35b4-a050-4d7c-8729-843db1a50ea4'),
(1939,1477,NULL,1058,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'8fa91883-d767-4d14-aa41-5f61d84248bc'),
(1940,1938,NULL,1059,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'fc374cf4-3141-4289-bed8-f0135c5d6ad0'),
(1941,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-10-16 19:23:32',NULL,NULL,NULL,'327c5010-6976-4b31-a426-5bef2b9716fb'),
(1942,1481,NULL,1060,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'bdeca20e-b791-49e2-bc6a-f184d054b824'),
(1943,1941,NULL,1061,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'9db34f42-920d-4a3a-bbac-1487575bef3b'),
(1945,1255,NULL,1062,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:39','2025-09-11 18:51:39',NULL,NULL,NULL,'aeb6cd6e-166d-49b1-94c2-122362509693'),
(1950,1045,NULL,1063,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:54:53','2025-09-11 18:54:53',NULL,NULL,NULL,'037c6a7b-f4ca-4f5f-9d41-5546b1bc4dec'),
(1952,1045,NULL,1064,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:55:25','2025-09-11 18:55:25',NULL,NULL,NULL,'a4b7340f-335d-4bae-90fa-eabca932cfe4'),
(1953,2,NULL,1065,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:58:05','2025-09-11 18:58:05',NULL,NULL,NULL,'d78c1ed2-b618-480b-afb4-c12f63f5d9f5'),
(1956,1165,NULL,1066,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:58:34','2025-09-11 18:58:35',NULL,NULL,NULL,'6e371be7-c4c2-4691-9a2f-3d690e430c61'),
(1958,1165,NULL,1067,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:58:45','2025-09-11 18:58:45',NULL,NULL,NULL,'a35e30f1-61b0-4883-a550-c6061b7b17ec'),
(1960,1045,NULL,1068,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:59:21','2025-09-11 18:59:21',NULL,NULL,NULL,'579adcfc-bfd4-4709-a62d-081711589a66'),
(1961,1255,NULL,1069,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:59:27','2025-09-11 18:59:27',NULL,NULL,NULL,'7f35ef7b-b5c6-443e-a315-18c28e5f4483'),
(1963,1171,NULL,1070,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:00:06','2025-09-11 19:00:06',NULL,NULL,NULL,'71bfee52-d555-4a08-9534-077ca5cbe269'),
(1965,945,NULL,1071,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:00:18','2025-09-11 19:00:18',NULL,NULL,NULL,'769e2c1e-2d82-4230-adde-ca78df4c3414'),
(1967,951,NULL,1072,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:24','2025-09-11 19:01:24',NULL,NULL,NULL,'c324fefe-82cf-4376-97f7-2b69f44746d0'),
(1969,1261,NULL,1073,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:31','2025-09-11 19:01:31',NULL,NULL,NULL,'1da2dfd1-fdde-4e7c-8c1c-b16c1dfbf1ec'),
(1971,1177,NULL,1074,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:39','2025-09-11 19:01:39',NULL,NULL,NULL,'7428aa4c-a324-48f5-bc4b-f83ad1e242cb'),
(1972,1692,NULL,1075,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 19:01:39',NULL,NULL,NULL,'177d8af8-68d2-405d-bb09-9da61b2e8e0b'),
(1973,1693,NULL,1076,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 19:01:39',NULL,NULL,NULL,'3490e4fe-14b5-46b7-931a-24ed1625eaab'),
(1975,957,NULL,1077,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:46','2025-09-11 19:01:46',NULL,NULL,NULL,'5a6d582d-e693-4542-95d5-694ae8edd825'),
(1977,963,NULL,1078,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:52','2025-09-11 19:01:52',NULL,NULL,NULL,'ded4b389-d06d-4955-b88e-e03f1cb638f1'),
(1979,1051,NULL,1079,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:59','2025-09-11 19:01:59',NULL,NULL,NULL,'f46cb30c-a0c6-4d8a-a88b-82625188ec6d'),
(1981,1051,NULL,1080,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:02:12','2025-09-11 19:02:12',NULL,NULL,NULL,'db1d62cc-7f60-471e-af4e-b339a6f884b0'),
(1983,1185,NULL,1081,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:02:19','2025-09-11 19:02:19',NULL,NULL,NULL,'fa0de283-2588-4fb8-93b5-2bddd3befe3c'),
(1985,1161,NULL,1082,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:02:26','2025-09-11 19:02:26',NULL,NULL,NULL,'3f884b43-9ad9-4476-8d54-de21b35d977e'),
(1987,1353,NULL,1083,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:02:33','2025-09-11 19:02:33',NULL,NULL,NULL,'3f62a119-8a49-4505-b812-2432afec1c4b'),
(1989,1353,NULL,1084,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:03','2025-09-11 19:03:03',NULL,NULL,NULL,'9f717ca5-e7c2-44b7-916c-0abb30e940e0'),
(1991,1059,NULL,1085,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:09','2025-09-11 19:03:09',NULL,NULL,NULL,'53f2d592-8c00-47ab-ad91-35cb9e26d24c'),
(1993,1269,NULL,1086,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:21','2025-09-11 19:03:21',NULL,NULL,NULL,'f5dbd9bf-09ad-4271-b3cd-08dc704adbc3'),
(1995,969,NULL,1087,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:31','2025-09-11 19:03:31',NULL,NULL,NULL,'ca4f3f93-fb2c-422b-887a-3b42918a2742'),
(1997,1277,NULL,1088,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:39','2025-09-11 19:03:39',NULL,NULL,NULL,'4e32f9a1-e6c0-464e-b2af-5b3bb1e53f37'),
(1999,1191,NULL,1089,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:56','2025-09-11 19:03:56',NULL,NULL,NULL,'79286800-b391-44a3-ba13-864b0de6eebf'),
(2001,1419,NULL,1090,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:06','2025-09-11 19:04:06',NULL,NULL,NULL,'15b9b681-8401-45b0-bd13-5d8d55fef6ec'),
(2003,1419,NULL,1091,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:21','2025-09-11 19:04:21',NULL,NULL,NULL,'1efa532e-9b4c-4b07-9af8-4403ad2ce57b'),
(2005,1425,NULL,1092,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:31','2025-09-11 19:04:31',NULL,NULL,NULL,'06d52a4f-7755-48c4-87eb-7752656a9233'),
(2007,1359,NULL,1093,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:40','2025-09-11 19:04:40',NULL,NULL,NULL,'de8e5c35-5844-4e09-a2e5-4833c2b07705'),
(2009,1365,NULL,1094,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:55','2025-09-11 19:04:55',NULL,NULL,NULL,'8054172c-564b-47df-a889-5aeb069b98db'),
(2011,975,NULL,1095,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:05:04','2025-09-11 19:05:04',NULL,NULL,NULL,'7861fac0-724f-4983-8169-f3863032cfb3'),
(2013,1067,NULL,1096,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:05:28','2025-09-11 19:05:28',NULL,NULL,NULL,'c4a17551-66b4-41d0-9db9-bd0c5a6ff983'),
(2015,1431,NULL,1097,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:05:37','2025-09-11 19:05:37',NULL,NULL,NULL,'183d926c-0797-4eb4-8ea6-975b647a9ecf'),
(2017,1437,NULL,1098,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:05:50','2025-09-11 19:05:50',NULL,NULL,NULL,'e756ade6-4126-4ad8-811f-19e1cf67f171'),
(2019,1283,NULL,1099,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:06:02','2025-09-11 19:06:02',NULL,NULL,NULL,'ced759c0-5d53-4329-8723-8b737c7e5013'),
(2021,1437,NULL,1100,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:06:46','2025-09-11 19:06:47',NULL,NULL,NULL,'c6b693cf-a6a5-4087-8ee3-52d37d094925'),
(2022,1283,NULL,1101,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:06:53','2025-09-11 19:06:53',NULL,NULL,NULL,'5ae3fcb4-c324-4f2d-bbcf-8d2e8fa407d2'),
(2024,1197,NULL,1102,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:01','2025-09-11 19:07:01',NULL,NULL,NULL,'fc0623dc-0cad-463c-bda5-8e8fe27bc7de'),
(2026,1201,NULL,1103,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:11','2025-09-11 19:07:12',NULL,NULL,NULL,'b96525de-7389-41f8-8216-6e51abe1e8b6'),
(2028,1443,NULL,1104,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:29','2025-09-11 19:07:29',NULL,NULL,NULL,'fd8301a6-5532-457f-8fa1-84cbdda41116'),
(2030,1209,NULL,1105,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:38','2025-09-11 19:07:38',NULL,NULL,NULL,'e4b44308-2f90-4005-aa80-2ac211a8bf77'),
(2032,1289,NULL,1106,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:47','2025-09-11 19:07:47',NULL,NULL,NULL,'1121d306-d4be-48b2-9462-3232de9d17aa'),
(2034,1297,NULL,1107,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:59','2025-09-11 19:07:59',NULL,NULL,NULL,'65fa8d79-6df8-4b00-8a69-e093f3da6aac'),
(2036,1303,NULL,1108,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:08:08','2025-09-11 19:08:08',NULL,NULL,NULL,'69ed4dc5-add5-40fa-b43b-ac9827039a47'),
(2039,1073,NULL,1109,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:08:31','2025-09-11 19:08:31',NULL,NULL,NULL,'1c6a3457-61ed-4d09-83d1-ac5eef6dfa6d'),
(2041,981,NULL,1110,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:08:55','2025-09-11 19:08:55',NULL,NULL,NULL,'fd810555-a475-4dc2-8fce-5f1f42ed2e87'),
(2043,1215,NULL,1111,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:04','2025-09-11 19:09:04',NULL,NULL,NULL,'8f3990ad-19d7-4d8e-881b-49f19c2c58af'),
(2045,1371,NULL,1112,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:15','2025-09-11 19:09:15',NULL,NULL,NULL,'8edd622b-4958-459c-b064-61231eb17fac'),
(2047,1449,NULL,1113,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:25','2025-09-11 19:09:25',NULL,NULL,NULL,'63066403-79fc-4d19-8c64-191a0eb81c37'),
(2049,1455,NULL,1114,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:37','2025-09-11 19:09:37',NULL,NULL,NULL,'ff3e62f8-0754-42b1-a096-64f04af0c4f8'),
(2051,989,NULL,1115,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:56','2025-09-11 19:09:56',NULL,NULL,NULL,'c9c12ae3-7c68-44d9-96df-d7ce4caabfca'),
(2053,1309,NULL,1116,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:10:06','2025-09-11 19:10:06',NULL,NULL,NULL,'c8161a3d-e5b4-4737-b2d6-530516336b02'),
(2055,995,NULL,1117,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:10:16','2025-09-11 19:10:16',NULL,NULL,NULL,'2dfb8d83-0cd8-4b55-83ef-92273a04153c'),
(2057,1219,NULL,1118,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:10:32','2025-09-11 19:10:32',NULL,NULL,NULL,'fb13fab4-d7a9-4278-a6be-489bc6ea86eb'),
(2059,1079,NULL,1119,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:10:45','2025-09-11 19:10:45',NULL,NULL,NULL,'7c111a7d-bd62-416f-8e79-af0f875e7f77'),
(2061,1477,NULL,1120,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:11:04','2025-09-11 19:11:04',NULL,NULL,NULL,'3a9d6c76-22b3-4fd7-9eb6-c23943d00bfa'),
(2063,1377,NULL,1121,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:11:43','2025-09-11 19:11:43',NULL,NULL,NULL,'f91db735-2a6c-47e4-bf40-a0e90cd1e6cc'),
(2065,1461,NULL,1122,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:11:57','2025-09-11 19:11:57',NULL,NULL,NULL,'d3992f92-5b45-42ed-999b-fe134c7957a2'),
(2067,1467,NULL,1123,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:12:17','2025-09-11 19:12:17',NULL,NULL,NULL,'e4d2d6ae-69aa-4fa2-9f6c-30c0773497c1'),
(2069,1467,NULL,1124,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:12:28','2025-09-11 19:12:28',NULL,NULL,NULL,'4dd55d21-d6b3-48c3-8b00-cd66cc763be1'),
(2071,1225,NULL,1125,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:12:43','2025-09-11 19:12:43',NULL,NULL,NULL,'f919eb6c-9177-4540-8272-521b059be394'),
(2073,1225,NULL,1126,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:12:57','2025-09-11 19:12:57',NULL,NULL,NULL,'a6ce2774-35b6-4250-9ad7-5d2170515117'),
(2075,1005,NULL,1127,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:13:09','2025-09-11 19:13:09',NULL,NULL,NULL,'a94bf1a5-e38c-44f4-8a28-7ada754147b5'),
(2077,1315,NULL,1128,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:13:20','2025-09-11 19:13:20',NULL,NULL,NULL,'0fa73409-ee0d-4c09-8362-d4103abcd787'),
(2079,1085,NULL,1129,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:13:54','2025-09-11 19:13:54',NULL,NULL,NULL,'ab1fe88c-150b-4e00-81c6-4919458ee93f'),
(2081,1383,NULL,1130,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:14:08','2025-09-11 19:14:08',NULL,NULL,NULL,'6fb5e57c-6c45-426c-84e0-8dd44b4a6371'),
(2083,1323,NULL,1131,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:14:25','2025-09-11 19:14:25',NULL,NULL,NULL,'3b340bb2-b777-4403-ad32-f4dc48fd168b'),
(2085,1011,NULL,1132,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:14:55','2025-09-11 19:14:55',NULL,NULL,NULL,'4d24b9f2-448f-4cda-b181-3f5a092eedee'),
(2087,1091,NULL,1133,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:07','2025-09-11 19:15:07',NULL,NULL,NULL,'8cbaf9be-7fe2-459d-9e47-4d9e599e95a8'),
(2089,1097,NULL,1134,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:25','2025-09-11 19:15:25',NULL,NULL,NULL,'e2027a29-e251-4ab5-b941-da3ed42e565f'),
(2091,1097,NULL,1135,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:41','2025-09-11 19:15:41',NULL,NULL,NULL,'188649eb-7b5a-40a4-9d8a-d7987434cb4d'),
(2093,1231,NULL,1136,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:48','2025-09-11 19:15:48',NULL,NULL,NULL,'58843612-2201-4031-8a2e-27b4d1fdf543'),
(2095,1103,NULL,1137,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:58','2025-09-11 19:15:58',NULL,NULL,NULL,'4b531cc3-8568-42bb-a169-633998f0cbdc'),
(2097,1237,NULL,1138,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:16:11','2025-09-11 19:16:11',NULL,NULL,NULL,'e59f3c54-4311-4224-ad56-f5850287a5be'),
(2099,1243,NULL,1139,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:16:31','2025-09-11 19:16:31',NULL,NULL,NULL,'87067b26-d622-42d1-9a23-f6cce931c3bc'),
(2102,1389,NULL,1140,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:16:56','2025-09-11 19:16:56',NULL,NULL,NULL,'124437b5-cec4-48b2-9ee7-85e937bf1838'),
(2103,1243,NULL,1141,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:17:03','2025-09-11 19:17:03',NULL,NULL,NULL,'867de1e8-dc80-4d60-a5c7-87cd2e003c18'),
(2105,1149,NULL,1142,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:17:31','2025-09-11 19:17:31',NULL,NULL,NULL,'38169acf-dfa1-4d5b-b8d6-f43e340d9eb9'),
(2107,1149,NULL,1143,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:17:42','2025-09-11 19:17:42',NULL,NULL,NULL,'268757dc-351d-4c82-a469-3dffabebac7b'),
(2109,1155,NULL,1144,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:17:58','2025-09-11 19:17:58',NULL,NULL,NULL,'1b29a977-2c91-4483-b1ab-8837337ff882'),
(2111,1329,NULL,1145,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:18:15','2025-09-11 19:18:15',NULL,NULL,NULL,'429646eb-2b77-48bb-8380-1754da05cdb9'),
(2113,1329,NULL,1146,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:18:25','2025-09-11 19:18:25',NULL,NULL,NULL,'cbcbb25d-6d83-45d5-8904-a3ed7ca981d5'),
(2115,1481,NULL,1147,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:18:38','2025-09-11 19:18:38',NULL,NULL,NULL,'c280fc34-0bf7-41a9-899f-1abf988aa6ee'),
(2117,1337,NULL,1148,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:18:55','2025-09-11 19:18:55',NULL,NULL,NULL,'19284174-7252-465b-b26d-107b795e1b9a'),
(2119,1407,NULL,1149,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:07','2025-09-11 19:19:07',NULL,NULL,NULL,'098e0b0a-81ad-4706-838a-eb180aa2f551'),
(2121,1343,NULL,1150,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:20','2025-09-11 19:19:20',NULL,NULL,NULL,'30907729-e9f0-48b0-bc40-7f9f2474f864'),
(2123,1395,NULL,1151,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:37','2025-09-11 19:19:37',NULL,NULL,NULL,'034a676e-d0c3-4198-a6ca-e7f228bdd5f2'),
(2125,1401,NULL,1152,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:49','2025-09-11 19:19:49',NULL,NULL,NULL,'4b5ada0f-bd5e-4d2f-8d79-6d66c2bfddf9'),
(2127,1473,NULL,1153,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:59','2025-09-11 19:19:59',NULL,NULL,NULL,'0a81651d-9d48-4f62-aa11-cd74ba613f36'),
(2129,1031,NULL,1154,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:20:11','2025-09-11 19:20:11',NULL,NULL,NULL,'a6265b03-a98c-40b8-b3b7-a368c32df4bd'),
(2131,1413,NULL,1155,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:20:35','2025-09-11 19:20:35',NULL,NULL,NULL,'795dd5f1-22f2-4bf8-a3d2-e314c7d0fd8b'),
(2133,1035,NULL,1156,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:20:48','2025-09-11 19:20:48',NULL,NULL,NULL,'1fd64ce7-13e6-4b3b-b75c-7e92550ca2b6'),
(2135,1041,NULL,1157,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:20:57','2025-09-11 19:20:57',NULL,NULL,NULL,'9c2ef53c-f806-4d03-9676-1d79eb8d776d'),
(2137,1249,NULL,1158,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:06','2025-09-11 19:21:06',NULL,NULL,NULL,'e14b57ba-a400-4be5-ae17-3f19da532c1b'),
(2139,1123,NULL,1159,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:17','2025-09-11 19:21:17',NULL,NULL,NULL,'717b966a-f061-43a1-ac67-6d9e36a302b4'),
(2141,1129,NULL,1160,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:27','2025-09-11 19:21:27',NULL,NULL,NULL,'bc0b3233-81f6-443a-b3ee-30dbfb648e88'),
(2143,1349,NULL,1161,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:36','2025-09-11 19:21:37',NULL,NULL,NULL,'b33c7e7d-a9d9-4212-90d5-d5506decebb1'),
(2145,1135,NULL,1162,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:45','2025-09-11 19:21:45',NULL,NULL,NULL,'b2e18ab4-0ee7-4015-af21-551ddfaaaa45'),
(2147,1141,NULL,1163,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:55','2025-09-11 19:21:55',NULL,NULL,NULL,'a7892f37-90c2-44ee-bb1c-bf24b417b97a'),
(2149,1141,NULL,1164,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:22:03','2025-09-11 19:22:03',NULL,NULL,NULL,'dc8d4e0e-c074-48c4-9d5c-47020a0dd90f'),
(2152,1143,NULL,1165,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:22:43','2025-09-11 19:22:43',NULL,NULL,NULL,'bbbf47b5-b0fc-4c27-946b-24678475e6fc'),
(2154,1117,NULL,1166,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:23:17','2025-09-11 19:23:17',NULL,NULL,NULL,'d3a7392b-cf13-4484-b503-300c52fce2de'),
(2156,1109,NULL,1167,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:23:27','2025-09-11 19:23:27',NULL,NULL,NULL,'06f188b6-d912-4561-a403-92160842c7d0'),
(2158,1023,NULL,1168,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:23:46','2025-09-11 19:23:46',NULL,NULL,NULL,'183c6dc7-807d-4933-830e-ec86f265f495'),
(2160,1017,NULL,1169,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:23:59','2025-09-11 19:23:59',NULL,NULL,NULL,'28e8a7b5-4c4d-4835-98ca-60b3e29b0a85'),
(2162,999,NULL,1170,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:24:30','2025-09-11 19:24:30',NULL,NULL,NULL,'1aba5b72-1133-4e69-9ffe-ad18f4b17baa'),
(2164,1255,NULL,1171,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:34:46','2025-09-11 19:34:46',NULL,NULL,NULL,'e1f929a8-8a5a-4f05-890f-0483155ad718'),
(2166,1261,NULL,1172,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:34:52','2025-09-11 19:34:52',NULL,NULL,NULL,'d12f63d1-c3b1-49c6-ab0c-159f96d6077c'),
(2168,1177,NULL,1173,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:34:59','2025-09-11 19:34:59',NULL,NULL,NULL,'22bbf03c-f9db-4a08-b7c1-775034c245b0'),
(2170,1185,NULL,1174,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:10','2025-09-11 19:35:10',NULL,NULL,NULL,'564a2f6d-d289-44cf-9111-627c267d9070'),
(2172,1353,NULL,1175,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:16','2025-09-11 19:35:16',NULL,NULL,NULL,'59c680cd-72eb-46ba-a5a9-a8abef1dd96e'),
(2174,1277,NULL,1176,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:24','2025-09-11 19:35:24',NULL,NULL,NULL,'1f7b5541-779c-4c78-b58f-d1b705ac267f'),
(2176,1191,NULL,1177,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:30','2025-09-11 19:35:30',NULL,NULL,NULL,'057aa1ca-89a3-44bb-b2de-2288c4c0605a'),
(2178,1359,NULL,1178,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:38','2025-09-11 19:35:38',NULL,NULL,NULL,'d1a1d83f-5780-42cb-929c-73f104f97786'),
(2180,1431,NULL,1179,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:45','2025-09-11 19:35:45',NULL,NULL,NULL,'237fafc6-7654-470b-9cfc-efb98a6d7271'),
(2182,1197,NULL,1180,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:51','2025-09-11 19:35:51',NULL,NULL,NULL,'e3b2b065-886b-40e6-920d-e7df10e52616'),
(2184,1201,NULL,1181,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:58','2025-09-11 19:35:58',NULL,NULL,NULL,'1f3bae81-3cdf-42b0-bf1c-df0190d766e7'),
(2186,1309,NULL,1182,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:36:26','2025-09-11 19:36:26',NULL,NULL,NULL,'96ebee49-8963-4c9c-8597-267e083243c3'),
(2188,1443,NULL,1183,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:36:38','2025-09-11 19:36:38',NULL,NULL,NULL,'28f0121a-37b6-4ca3-af90-5e7269320ca3'),
(2190,1209,NULL,1184,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:36:45','2025-09-11 19:36:45',NULL,NULL,NULL,'953faded-417d-4438-85ac-49071795e887'),
(2192,1289,NULL,1185,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:36:53','2025-09-11 19:36:53',NULL,NULL,NULL,'e30dcae5-ccfe-49cf-93b8-a69701e666d2'),
(2194,1297,NULL,1186,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:00','2025-09-11 19:37:00',NULL,NULL,NULL,'df9825e6-1ac9-47d8-8a64-b9d919d41d54'),
(2196,1303,NULL,1187,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:09','2025-09-11 19:37:09',NULL,NULL,NULL,'1d9da0c5-dccd-4eb6-9192-0260bd1984f8'),
(2197,1215,NULL,1188,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:16','2025-09-11 19:37:16',NULL,NULL,NULL,'540ad7cf-b5e1-409f-afa7-88630103ba50'),
(2199,1371,NULL,1189,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:24','2025-09-11 19:37:24',NULL,NULL,NULL,'220dbb9c-a7bb-49a3-b5ec-06335d4d074d'),
(2201,1449,NULL,1190,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:31','2025-09-11 19:37:31',NULL,NULL,NULL,'378afe3c-7ad2-4057-8861-763cb525f48b'),
(2203,1231,NULL,1191,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:38','2025-09-11 19:37:38',NULL,NULL,NULL,'89c6954e-718d-48d5-b247-84e07933c47d'),
(2206,1161,NULL,1192,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:52:35','2025-09-11 19:52:35',NULL,NULL,NULL,'adccd7e0-b5fb-4f81-b009-4cfe297a5849'),
(2207,1255,NULL,1193,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:52:43','2025-09-11 19:52:43',NULL,NULL,NULL,'f3c60345-c1b2-4c53-99a3-6baae8d56224'),
(2208,497,NULL,1194,6,'craft\\elements\\Entry',1,0,'2025-09-11 20:12:38','2025-09-11 20:12:38',NULL,NULL,NULL,'3498aeec-5b14-4b84-bafb-08697c8b53f9'),
(2210,2,NULL,1195,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:27:00','2025-09-11 20:27:00',NULL,NULL,NULL,'6c183475-e793-4012-8f59-5ffdc27ab3d1'),
(2212,945,NULL,1196,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:27:20','2025-09-11 20:27:20',NULL,NULL,NULL,'b420004f-163b-4034-8658-a94341a4a0ed'),
(2214,945,NULL,1197,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:30:33','2025-09-11 20:30:33',NULL,NULL,NULL,'2374b5ae-3391-4a6d-aa6c-6e1f9f339b64'),
(2216,951,NULL,1198,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:30:50','2025-09-11 20:30:50',NULL,NULL,NULL,'9118d376-91a5-4fae-b2fe-537f74bb71dd'),
(2218,1437,NULL,1199,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:31:02','2025-09-11 20:31:02',NULL,NULL,NULL,'c4dc8153-951e-41c1-a1f4-4315cb87714f'),
(2220,1045,NULL,1200,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:37:16','2025-09-11 20:37:16',NULL,NULL,NULL,'08484410-644a-4005-8b7c-4aa667156fc5'),
(2222,2,NULL,1201,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'9d2f8cf2-9910-4632-872c-69598fbaa05f'),
(2223,56,NULL,1202,3,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'4e5eb46e-e14e-43f3-8d8d-f5a86820c322'),
(2224,57,NULL,1203,3,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'6811b45c-2526-425c-9771-c76348de7f60'),
(2225,63,NULL,1204,3,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'bec226d8-89bd-4ba4-b8a9-d169181f88ca'),
(2226,1486,NULL,1205,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'15d38a5a-2b8a-4111-882d-206d37e17420'),
(2227,1487,NULL,1206,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'52ca4f91-3f38-47a8-8bee-24bd2ad542f4'),
(2228,945,NULL,1207,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'a1546e0b-f5e7-4d50-acf1-a056630ff547'),
(2229,1494,NULL,1208,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'d455be16-8f79-481c-b59f-bd05e884bb55'),
(2230,1495,NULL,1209,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'818f03d2-2c7f-432c-834b-4e423ee03a8f'),
(2231,951,NULL,1210,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'35bff0ce-c0b2-4bbd-93cf-8c5d2d9b2ac8'),
(2232,1499,NULL,1211,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'5333d547-c46a-4718-a413-cfd01d1d7bd9'),
(2233,1500,NULL,1212,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'d168976e-2cc4-4d4c-af00-dc14d2a37bc7'),
(2234,957,NULL,1213,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'11054c99-805e-4238-af87-1a52d87a267f'),
(2235,1504,NULL,1214,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'31ca1736-0b72-49e5-8b26-1fc644fb6e0c'),
(2236,1505,NULL,1215,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'66c2d571-d2f3-4537-9dfd-ca69866967ae'),
(2237,963,NULL,1216,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'15ba3880-7c72-4877-81da-202a88bedd85'),
(2238,1509,NULL,1217,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'9e453bae-4d20-410b-81e8-2c650402d2be'),
(2239,1510,NULL,1218,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'ba139b53-862e-4d30-b107-c74786ddc7c3'),
(2240,969,NULL,1219,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'76467b31-29e9-40c7-a25c-794903e321bd'),
(2241,1514,NULL,1220,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'37c2f1d8-f48d-4d37-bf79-86544c5bf1c9'),
(2242,1515,NULL,1221,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'b80b993f-bd4d-4975-8703-151af6f1e21c'),
(2243,975,NULL,1222,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'e2c3f267-0edf-4d28-a871-5534827dcd13'),
(2244,1519,NULL,1223,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'14d99b35-006a-4797-87c8-7c252b050c34'),
(2245,1520,NULL,1224,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'8c8ee26e-61fc-4272-9f5b-93cad0aea522'),
(2246,981,NULL,1225,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'5c4a8ed7-bccf-4437-aaa7-ccef65c83c1d'),
(2247,1524,NULL,1226,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'49785bf4-1804-40ae-902c-62aa105e5baf'),
(2248,1525,NULL,1227,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'49b1fef5-b341-46a6-8539-65944a4f9d37'),
(2249,1526,NULL,1228,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'fde5d0cc-d53c-4192-abec-5146012a0d9e'),
(2250,989,NULL,1229,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'1a80dca2-0fa0-4653-bd07-8c40d380e4ce'),
(2251,1531,NULL,1230,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'12ce86c0-0c3d-4ff2-b6b5-fdf5c1e2b7df'),
(2252,1532,NULL,1231,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'f13c2c60-e917-4db6-acb2-69a827a40b98'),
(2253,995,NULL,1232,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'375cd1b6-6ec5-440e-8538-f21a90afbcd2'),
(2254,1536,NULL,1233,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'441b9908-0779-4bf8-b2be-fd673573a183'),
(2255,999,NULL,1234,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'6500fb11-8903-4680-be51-66242e0c7a20'),
(2256,1539,NULL,1235,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'dd556e78-6349-447f-b8d0-707142b16ec5'),
(2257,1540,NULL,1236,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'ec389eac-6d0c-4afe-bdd2-4f08d61461c1'),
(2258,1005,NULL,1237,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'b3a7f86f-79b9-46c9-8ab2-e0e9b0e9d916'),
(2259,1544,NULL,1238,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'6f5eb08b-cc8c-4d43-a1a4-8f641b93d518'),
(2260,1545,NULL,1239,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'0a490659-8694-4bac-8ce9-52eeabd18f52'),
(2261,1011,NULL,1240,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'4f3698dd-fd09-40a7-b4c3-bfc3ad5be997'),
(2262,1549,NULL,1241,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'eb92debb-00f0-4953-928e-ac061fad2a19'),
(2263,1550,NULL,1242,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'5627854d-5dc2-454c-ad79-f9a8f48b4bd5'),
(2264,1017,NULL,1243,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'bbc28ebf-a9f6-49da-acd8-ac0b6d0b7acc'),
(2265,1554,NULL,1244,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'aca4acd2-c94c-4cc5-9b3e-0312a8f8b4b7'),
(2266,1555,NULL,1245,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'75b7da17-206c-4efb-8ddf-c8b801b712b0'),
(2267,1023,NULL,1246,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'176c0ba4-bc21-4067-b569-92ef20f7e264'),
(2268,1559,NULL,1247,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:31',NULL,NULL,NULL,'e17f6c2d-9f0d-4c47-8af3-ca8ce6ea4a7b'),
(2269,1560,NULL,1248,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:31',NULL,NULL,NULL,'368a349a-efc7-4b30-b2e2-b3249d10a78d'),
(2270,1561,NULL,1249,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:31',NULL,NULL,NULL,'1fac32b3-6aad-4a48-925d-cd3835dcd99c'),
(2271,1031,NULL,1250,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'12dad23f-955f-460e-ad35-6acc8ecfd830'),
(2272,1566,NULL,1251,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'81ed302a-8151-4dea-9454-f47db8b9952a'),
(2273,1035,NULL,1252,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'6411ee32-f902-4121-9ccf-0078ea5de8d5'),
(2274,1569,NULL,1253,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'9ffcb1f0-a9e9-452c-813c-02a7f4978917'),
(2275,1570,NULL,1254,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'a14619a0-72b1-40db-ad1e-5ad7a06e4946'),
(2276,1041,NULL,1255,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'70162289-9d4e-45d6-99b6-e49a8104b1d3'),
(2277,1574,NULL,1256,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'ac390979-2a8a-4b12-8501-6c6bea6cda41'),
(2278,1045,NULL,1257,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'af310d04-cb63-45fa-8a23-6afc7798913e'),
(2279,1577,NULL,1258,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'5b60e712-d1da-498a-9082-440f853077eb'),
(2280,1578,NULL,1259,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'fd2f732f-b26f-49a2-93b9-b331716686f1'),
(2281,1051,NULL,1260,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'38d50995-0253-44eb-8f77-5a17e5acf2c2'),
(2282,1582,NULL,1261,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'69f1dc7e-221e-47ad-862d-15ac4300cdeb'),
(2283,1583,NULL,1262,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'3702f942-39d6-460e-b36e-8b4540db6f7c'),
(2284,1584,NULL,1263,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'beaba663-8777-4d6c-bc57-d51a866a3c30'),
(2285,1059,NULL,1264,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'e836ae4c-c9dc-4d8b-ab0d-a6fcb75733c4'),
(2286,1589,NULL,1265,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'dcfd9632-efc0-4d7f-b776-a48ddea5b270'),
(2287,1590,NULL,1266,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'08905de6-b619-444b-aee7-a9189ee1f75c'),
(2288,1591,NULL,1267,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'a940b45d-155e-4ce6-b24b-2d2e68ffe4e1'),
(2289,1067,NULL,1268,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'d045bc02-ef67-4ed6-aeca-22f47813749c'),
(2290,1596,NULL,1269,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'1578dcc9-d907-4e8d-910f-263caaef3727'),
(2291,1597,NULL,1270,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'a33634ac-17e3-4467-bfdb-c6858f3f2024'),
(2292,1073,NULL,1271,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'a9919f68-a24e-47df-880a-5717be11b580'),
(2293,1601,NULL,1272,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'9dec0979-58c5-457b-926b-aed67e022895'),
(2294,1602,NULL,1273,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'683b5e74-9f8d-4b0f-973b-26fa1644b6b4'),
(2295,1079,NULL,1274,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'149786bc-fabb-496b-a566-85da74d4967d'),
(2296,1606,NULL,1275,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'8b1fedcb-9f31-4e98-8184-d0534b10afe3'),
(2297,1607,NULL,1276,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'35dc0f46-424d-4a7c-abfd-4897971b5b41'),
(2298,1085,NULL,1277,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:32',NULL,NULL,NULL,'c5018270-43ab-4486-a44c-0fd2c8bcd2a9'),
(2299,1611,NULL,1278,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'318a27e4-e09a-4352-bbb3-67cca0fa51a0'),
(2300,1612,NULL,1279,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'29274ee7-c4cd-4f9e-994f-d1abfc4bfa9b'),
(2301,1091,NULL,1280,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'f1135250-e2aa-43a0-91d0-c9caad7d1b29'),
(2302,1616,NULL,1281,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'42d461cd-6404-402c-a3e3-4381c5465191'),
(2303,1617,NULL,1282,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'60fde109-9d7f-46c3-b7b8-69b88a6ca346'),
(2304,1097,NULL,1283,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'db301f11-7b2a-400d-8159-ed7281d24ab4'),
(2305,1621,NULL,1284,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'e1686c55-70f9-4cea-b2e4-ce7d009313ac'),
(2306,1622,NULL,1285,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'c575a8a9-8783-42b6-9e61-4dd59a93bf68'),
(2307,1103,NULL,1286,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'bdd2c1c5-a5a2-4ed0-8941-ac20afe35b46'),
(2308,1626,NULL,1287,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'eb5f4d12-a163-48cc-b7c2-7146a9a7107d'),
(2309,1627,NULL,1288,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'742faf6d-455f-4c82-8830-f0dae1821511'),
(2310,1109,NULL,1289,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'0df07b97-babd-453b-82cd-4e18f11ba143'),
(2311,1631,NULL,1290,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'bbcadf66-9f58-4fb9-aac3-42b2c570bfee'),
(2312,1632,NULL,1291,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'4ba61cc5-0260-4953-8a79-7033f7b5096d'),
(2313,1633,NULL,1292,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'1369a244-487c-4518-ba07-64248e20b85b'),
(2314,1117,NULL,1293,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'1b9fbc17-10fb-4369-a185-46b2afa727e9'),
(2315,1638,NULL,1294,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'80d863cd-9d73-420e-b1fc-a61edb711aff'),
(2316,1639,NULL,1295,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'50ffd002-fe77-4eda-a3d2-0cf1f7b07f6b'),
(2317,1123,NULL,1296,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'601f8f21-3091-456f-9185-aa916538225a'),
(2318,1643,NULL,1297,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'c3abce8a-7758-4bc9-b353-361646b8f575'),
(2319,1644,NULL,1298,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'1778485e-5250-4a01-83a1-4816289cda3e'),
(2320,1129,NULL,1299,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'ba6bd15e-93a1-4996-a040-0b1ea2c919d0'),
(2321,1648,NULL,1300,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'0c9c9c8b-5f65-446f-9afc-5ce22954bc23'),
(2322,1649,NULL,1301,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'75cb9044-877e-4d2e-9d67-9387824fd9ab'),
(2323,1135,NULL,1302,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'fa073e70-6bd1-41c1-936a-02054306890a'),
(2324,1653,NULL,1303,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'88b97d45-a1bb-403e-91e1-af71ec7ba5ed'),
(2325,1654,NULL,1304,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'e3b15f85-f876-4a6f-bbd4-9dd6da462126'),
(2326,1143,NULL,1305,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'69f60b46-c429-48f0-aa64-abdad6aaf818'),
(2327,1659,NULL,1306,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,'2025-10-13 18:02:09',NULL,'3ed02ca8-a643-400f-a241-8db19287039f'),
(2328,1660,NULL,1307,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'f312c3e7-8f70-4c6a-9efe-872191e5164c'),
(2329,1155,NULL,1308,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:33',NULL,NULL,NULL,'d287b69c-8250-4ee9-a834-d0ba58ca4fc5'),
(2330,1669,NULL,1309,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:33',NULL,'2025-10-13 19:24:55',NULL,'af969a0f-2e30-4bc2-8ad0-c0b6e8d55eb3'),
(2331,1670,NULL,1310,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:33',NULL,NULL,NULL,'229b21e1-f73f-4cec-9f87-1198ea7163ce'),
(2332,1161,NULL,1311,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'22a2031a-af48-4eed-9a66-29a2653663bc'),
(2333,1674,NULL,1312,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'02a66161-b187-4cd4-9646-0f72924d0ca9'),
(2334,1165,NULL,1313,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'447b1859-1dd1-4510-8ee5-9430c23fb45e'),
(2335,1677,NULL,1314,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'62c9baf2-0e7a-4f34-8388-c8ecd479244f'),
(2336,1678,NULL,1315,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'daace896-c1d2-4f14-82e8-6d240e620a92'),
(2337,1171,NULL,1316,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'24f44ae8-34bd-46e5-aa09-0914caa600b2'),
(2338,1682,NULL,1317,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'77d5caee-4f33-4be3-aaeb-4fd3fd3aa5c4'),
(2339,1683,NULL,1318,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'615ad73f-b89b-4ba4-a254-640a8a5d3d4c'),
(2340,1177,NULL,1319,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'f80cf382-c0ae-4d76-9d33-22cbe487fc6c'),
(2341,1692,NULL,1320,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'302bb6f1-d9bb-4cc3-bd55-43b46052e0e6'),
(2342,1693,NULL,1321,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'0583ff14-67b8-4711-9744-179778f29ace'),
(2343,1185,NULL,1322,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'d99e2d79-896b-46b8-ad33-2e3d92ac5b92'),
(2344,1694,NULL,1323,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'2de33317-f01f-4f76-946d-22dd32906035'),
(2345,1695,NULL,1324,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'20f6e708-e817-46f5-bb1c-d44613d1bea0'),
(2346,1191,NULL,1325,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'999e5bad-ced0-4cbd-9bb5-359ef3340337'),
(2347,1699,NULL,1326,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'b49521a0-f8ba-4dac-a492-ac2ab2e92e3c'),
(2348,1700,NULL,1327,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'90c34b75-3716-4000-af7c-7e24226d62bb'),
(2349,1197,NULL,1328,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'735f8e22-9d2a-48ef-b8c7-ab7e5572583d'),
(2350,1704,NULL,1329,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'000c10f4-d2c2-4071-bec1-e93a0d65c883'),
(2351,1201,NULL,1330,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'878faeb0-b61e-48e1-8c7b-2db2cc43389f'),
(2352,1707,NULL,1331,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'0f8c41f5-b2d5-4d69-ba23-592a5103aec3'),
(2353,1708,NULL,1332,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'acaa840d-86fa-442e-8e53-bf0e4beebdfd'),
(2354,1709,NULL,1333,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'cd432b78-fafc-468f-be95-a5a0967fbc7d'),
(2355,1209,NULL,1334,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'295c970e-33c8-4134-aa84-d1775bcef760'),
(2356,1714,NULL,1335,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'dd652f5c-bb0d-4383-b6a6-0250fe5553df'),
(2357,1715,NULL,1336,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'853ee76f-fb61-4858-a0b8-aca65f2f8ad0'),
(2358,1215,NULL,1337,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'4da48e8a-75ac-4a32-8211-a3e3a6c75f69'),
(2359,1719,NULL,1338,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'1adc891b-aee2-436d-95d5-a83bdd712103'),
(2360,1219,NULL,1339,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'3d9248ae-121a-4422-b4c9-54237e914052'),
(2361,1722,NULL,1340,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,'2025-10-14 17:09:21',NULL,'24822f30-3c64-4717-8006-c4e04100388a'),
(2362,1723,NULL,1341,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'c29db490-a81c-48b0-b8c3-9c840d4a9c72'),
(2363,1225,NULL,1342,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'73f673e9-a465-4b9d-89bb-caefe009bcfb'),
(2364,1727,NULL,1343,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'244ba4b5-84a2-4acc-a96b-82f8c5d71f99'),
(2365,1728,NULL,1344,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'d6e5c3cc-5eb9-436e-8b0c-6f6ce78b9d05'),
(2366,1231,NULL,1345,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'bdd115bb-c739-443f-a8a2-8dac106fa02d'),
(2367,1732,NULL,1346,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'19cfc3ae-9f47-439c-85dc-456085e59bde'),
(2368,1733,NULL,1347,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,'2025-10-14 17:15:30',NULL,'bd3e4ff3-c52b-4094-9616-0b7226bcf167'),
(2369,1237,NULL,1348,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'301e703b-180e-4835-9592-3a5fa7600feb'),
(2370,1737,NULL,1349,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'47f446bc-7243-4938-8778-6ccdae77c8e0'),
(2371,1738,NULL,1350,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'78a76273-243a-4741-ba3f-f480a40b707f'),
(2372,1243,NULL,1351,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'f6b602c3-394b-4cb1-b6b9-13d0ffc01b70'),
(2373,1742,NULL,1352,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'e0cb9382-0256-489b-b489-06cc430acd98'),
(2374,1743,NULL,1353,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'362fd34e-62a4-482a-85e9-f68906489122'),
(2375,1249,NULL,1354,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'60b1bd86-14f2-4bdd-8073-65575453f82d'),
(2376,1747,NULL,1355,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'fe0f430b-b348-4cf0-887f-143cb7151774'),
(2377,1748,NULL,1356,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'d09312ba-d309-4a58-8ec6-87a973026dcd'),
(2378,1255,NULL,1357,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'f33f77f9-fea5-4ad0-a6e8-9cb5a7868f5a'),
(2379,1752,NULL,1358,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'bc67b775-0e01-4baa-80e4-09d14ade2540'),
(2380,1753,NULL,1359,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'6851c682-011c-4aac-82cb-f7d64dd36881'),
(2381,1261,NULL,1360,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'4fe257b0-e184-41bf-9790-9eb1e990f1aa'),
(2382,1757,NULL,1361,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'3bf93cf3-aab0-4cd6-a0d2-38e962e79b2b'),
(2383,1758,NULL,1362,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'320dd30b-4b1b-44d1-9551-0c5432eafb7f'),
(2384,1759,NULL,1363,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'42945697-1ae2-4285-a5d4-6f63dd66aa27'),
(2385,1269,NULL,1364,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:35',NULL,NULL,NULL,'71f985e0-ac5e-4096-8c4c-cd84d329274e'),
(2386,1764,NULL,1365,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:35',NULL,NULL,NULL,'4afd8dc9-cc58-490c-be34-7947478a9537'),
(2387,1765,NULL,1366,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:35',NULL,NULL,NULL,'90f445c8-f90a-4f78-9dae-c70091a3590f'),
(2388,1766,NULL,1367,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:35',NULL,NULL,NULL,'a0f3ec1a-5eda-4702-92d1-2f30a1988bfc'),
(2389,1277,NULL,1368,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'f29c23f3-def9-4e63-acb5-40182c356a95'),
(2390,1771,NULL,1369,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'49ddf47e-12f4-4da3-b8c6-9d64ad45483e'),
(2391,1772,NULL,1370,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'840bbd83-fdf2-4a10-bfef-562e15ad93c0'),
(2392,1283,NULL,1371,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'e8ffcc5c-0dfe-44e6-810d-5858c9b4ee34'),
(2393,1776,NULL,1372,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'2d5ac8b2-ef1d-49d5-a7bc-d1a520ba2955'),
(2394,1777,NULL,1373,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'ea2d3ccc-e764-49b9-ac13-889e64227fbd'),
(2395,1289,NULL,1374,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'158f173e-9874-4200-8e2f-6120f706e8cc'),
(2396,1781,NULL,1375,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'1eb22d46-fc96-4bf6-90f2-d06e7bfe3803'),
(2397,1782,NULL,1376,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'89131c6c-7c9b-4e50-8fcd-694af4fcdfd5'),
(2398,1783,NULL,1377,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'5ca644a2-0b4e-4884-a7ca-85bab193d717'),
(2399,1297,NULL,1378,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'6ca8d549-c107-448b-b8f9-b0a2c86d79e6'),
(2400,1788,NULL,1379,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'b1bb2727-65f3-4b81-a3e4-f7df5c372159'),
(2401,1789,NULL,1380,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'35aa0712-f0da-4c82-a6f4-560eb1b3ff1e'),
(2402,1303,NULL,1381,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'db172afb-d9b3-406d-9dd6-0a049936d879'),
(2403,1793,NULL,1382,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'0ab79989-1460-4b4c-a966-cf1c33ae7521'),
(2404,1794,NULL,1383,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'5a6ba16b-cb14-45cf-bd8c-4a8bd409b61f'),
(2405,1309,NULL,1384,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'bb0429e3-3120-479c-8449-36e0494035ce'),
(2406,1798,NULL,1385,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'307d5258-7f51-4824-a0b4-94ee9f610479'),
(2407,1799,NULL,1386,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'3bdef452-1787-4e86-a8e0-cfeb2eaa1377'),
(2408,1315,NULL,1387,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'39b8dbdb-4257-4a09-a9c6-4170aa7bc502'),
(2409,1803,NULL,1388,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'bebddb5c-63e4-401a-a3df-112ce48082fe'),
(2410,1804,NULL,1389,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'06123830-b9af-486a-b680-902c60f61746'),
(2411,1805,NULL,1390,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'236c0610-a142-45c5-8e3d-5dd35b0339ac'),
(2412,1323,NULL,1391,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'2f4efa94-8b11-460f-a936-1f90fb340eda'),
(2413,1810,NULL,1392,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'c4aebf86-a5df-4964-a9e3-7a38ca2faa33'),
(2414,1811,NULL,1393,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'99833e80-f9cd-47f6-9655-a5757b3618da'),
(2415,1329,NULL,1394,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:36',NULL,NULL,NULL,'914212f0-1dc6-4e77-a408-e8f6615d7469'),
(2416,1815,NULL,1395,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:36',NULL,NULL,NULL,'f5c7fb9b-1756-41f8-acb0-33eb138c2b7c'),
(2417,1816,NULL,1396,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'bd78096f-5f01-4fc1-a962-14c6e6c4f62f'),
(2418,1817,NULL,1397,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'c8cbecdb-b3b4-4754-bcef-37df56fdf273'),
(2419,1337,NULL,1398,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'4dd4c136-5d42-4f74-8cf7-5aa04c35a4c9'),
(2420,1822,NULL,1399,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'30af53b8-1d0f-49d4-a48c-664e46c580ab'),
(2421,1823,NULL,1400,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'8d1b1d6d-c4f5-46e0-b51f-779484f742c0'),
(2422,1343,NULL,1401,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'19b1b671-03e5-4c03-aa81-43c82c7b25a4'),
(2423,1827,NULL,1402,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'d8e033bd-666f-45c6-a719-60aec288e902'),
(2424,1828,NULL,1403,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'62b2db04-602b-4930-b2ef-c098a79f84bc'),
(2425,1349,NULL,1404,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'d66b4656-f7f7-469a-b9c1-e3c51d2b0b7d'),
(2426,1832,NULL,1405,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'4a04f375-aa30-4a31-8fc8-6c62cdd843df'),
(2427,1353,NULL,1406,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'689bd08a-0ab6-4f19-b353-c15990d0aa36'),
(2428,1835,NULL,1407,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'82e8162c-e2f4-4b58-aa51-e982e351f6bf'),
(2429,1836,NULL,1408,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'343d4adc-f8f0-4d7f-85db-ab38824a577f'),
(2430,1359,NULL,1409,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'0412a0a4-d5f3-4dfd-915e-6349ef1f3dde'),
(2431,1840,NULL,1410,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'da049ea8-74df-486e-a7c2-44fc22a24cfd'),
(2432,1841,NULL,1411,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'35eaa790-5a17-410b-a030-8377d40d951a'),
(2433,1365,NULL,1412,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'2c13f3db-0d8c-40b4-b97a-ed4b02877eb8'),
(2434,1845,NULL,1413,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'2b292a19-ce1a-45ca-b797-8b8352b0c03f'),
(2435,1846,NULL,1414,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'7dcc9947-c567-48fc-8f28-452082e360de'),
(2436,1371,NULL,1415,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'4bc9d9ba-31bf-48ce-b091-e1b2e37809e6'),
(2437,1850,NULL,1416,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'ba212c3f-a596-412b-8010-896c8635c7a3'),
(2438,1851,NULL,1417,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'625668bb-b59f-4385-b729-be0c8df447d9'),
(2439,1377,NULL,1418,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'94fff098-79fd-42e7-8043-959f261b5337'),
(2440,1855,NULL,1419,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'78fc354f-286f-4409-83fe-9d7e0ab48ee6'),
(2441,1856,NULL,1420,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'219de754-7949-4025-8356-cc77f7cee520'),
(2442,1383,NULL,1421,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'9785984c-dd86-450b-b529-e8087a3d74c6'),
(2443,1860,NULL,1422,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'a840cbe7-f639-4a9f-b1be-2c02cb2cccb3'),
(2444,1861,NULL,1423,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'19f58fd6-32c7-4770-b0cd-a3adf01002c3'),
(2445,1389,NULL,1424,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'fcdc2dce-6995-41ba-8e8f-b748e4df7a14'),
(2446,1865,NULL,1425,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'160e3d0a-1e12-4513-b797-e71c56cb5873'),
(2447,1866,NULL,1426,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'cbcc8965-9ff1-42d6-871c-df8f126844f0'),
(2448,1395,NULL,1427,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'ee63e3c3-657f-42cd-82a4-159eb5173afb'),
(2449,1870,NULL,1428,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'ac44157f-7d13-4dbf-8810-8d8191d068fd'),
(2450,1871,NULL,1429,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'8a096c6a-f26a-42ed-84c9-cb66dd2aded9'),
(2451,1401,NULL,1430,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'26a9b7cb-2bb6-4bb1-b3b0-ddce5f1db05d'),
(2452,1875,NULL,1431,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'344f3dcc-df4f-4862-8dc7-788bf7cca35d'),
(2453,1876,NULL,1432,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'6460116b-b922-4014-b99f-b0399674b736'),
(2454,1407,NULL,1433,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'4e5015bf-2cf4-49a5-82c4-6b4017b3a9ba'),
(2455,1880,NULL,1434,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'6f5fa7ae-78a6-46e9-a606-70bb2b28b856'),
(2456,1881,NULL,1435,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'a328c246-05bb-46cc-a94b-7fb52151ad08'),
(2457,1413,NULL,1436,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'e119a524-5b34-4c28-a95e-f3b48918737e'),
(2458,1885,NULL,1437,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'c78d3645-9668-4cb6-8143-ed476ca7c6eb'),
(2459,1886,NULL,1438,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'601ca390-6a8d-45c4-aa43-d18cc3960f87'),
(2460,1419,NULL,1439,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'13d8e805-1633-4a70-aaa4-a79dd5540a83'),
(2461,1890,NULL,1440,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'45a8ad70-0044-41e2-9169-f8e49485961d'),
(2462,1891,NULL,1441,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'ff1ac66d-c92e-4350-b7c7-b5ff6f6d718b'),
(2463,1425,NULL,1442,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'5d25cbb7-1ce2-4f47-a70d-bb9bb77f76f7'),
(2464,1895,NULL,1443,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'6a5c2cf4-c64c-4983-aea0-39f3c0c71e25'),
(2465,1896,NULL,1444,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'9c83df00-0358-438f-a7ae-c1ced938097e'),
(2466,1431,NULL,1445,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'6612c1de-535b-4fcd-97fd-95e01c14ab39'),
(2467,1900,NULL,1446,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'494aab11-2cd1-4443-beca-41df55b19858'),
(2468,1901,NULL,1447,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'619ba96f-c0c1-4680-ad8a-30cdd7878df7'),
(2469,1437,NULL,1448,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'0612b687-bc28-42e6-bd01-98552b99bf4a'),
(2470,1905,NULL,1449,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'caed6cba-1baa-4348-8f24-da474e051ffe'),
(2471,1906,NULL,1450,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'0340d5c2-3598-4571-b476-e46e7c5426fb'),
(2472,1443,NULL,1451,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:38',NULL,NULL,NULL,'3412bce4-5016-4097-8ca3-4e2df3d26db3'),
(2473,1910,NULL,1452,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:38',NULL,NULL,NULL,'3d3d9ed5-dd22-4069-8bde-d8e7d6ed79a0'),
(2474,1911,NULL,1453,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:38',NULL,NULL,NULL,'9614a6a2-90fc-42eb-8d0e-dfec76b8c68d'),
(2475,1449,NULL,1454,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'38aba39a-0322-4825-8439-e1173b1c251f'),
(2476,1915,NULL,1455,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'3dd2a0bd-1b32-4c57-ad79-a564fb6e89f3'),
(2477,1916,NULL,1456,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'41948a97-c816-4437-bd78-daadd75fd33c'),
(2478,1455,NULL,1457,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'db7c4b65-ae52-41cd-9314-33f537c1f5bc'),
(2479,1920,NULL,1458,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'fcaecb61-cd2c-401b-956f-e9bc1238011a'),
(2480,1921,NULL,1459,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'88788456-bbb6-4513-8104-b076a6f86f51'),
(2481,1461,NULL,1460,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'b40150b0-3477-4388-8a3f-d90d99a8b929'),
(2482,1925,NULL,1461,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'28cf4f1e-8941-417a-99e4-e5d448cb45b6'),
(2483,1926,NULL,1462,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'a74f0cfb-8234-4629-8684-aab1486dd1e4'),
(2484,1467,NULL,1463,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'b725cd86-2fff-4ea7-9b4b-6989100dc9e5'),
(2485,1930,NULL,1464,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'fbe32637-1457-4339-81f6-9011c1d42f2e'),
(2486,1931,NULL,1465,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'751e7a36-baf0-4343-9ee1-01e0c9a00fe7'),
(2487,1473,NULL,1466,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'15132208-ac5b-4d2d-921d-b49d10b9dbc5'),
(2488,1935,NULL,1467,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'89101061-0b59-4b87-8829-9dfccaa42ed9'),
(2489,1477,NULL,1468,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'4565583a-cd7e-42a2-bb8b-1eb48dd44483'),
(2490,1938,NULL,1469,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'ef99128a-288d-4762-a0bd-3ef128729c43'),
(2491,1481,NULL,1470,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'c3f3281f-4cca-4c3b-8c45-50bc9d1d259e'),
(2492,1941,NULL,1471,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'0697548d-424c-426b-884f-84436b0ef39c'),
(2493,2,NULL,1472,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:45','2025-09-11 20:39:45',NULL,NULL,NULL,'495a7749-af8d-49c8-a6b9-e0c87103f07e'),
(2495,1255,NULL,1473,1,'craft\\elements\\Entry',1,0,'2025-09-16 22:43:05','2025-09-16 22:43:05',NULL,NULL,NULL,'ebf28e94-b65d-4006-803c-d194c2e2802d'),
(2499,2,NULL,1474,1,'craft\\elements\\Entry',1,0,'2025-09-17 19:37:16','2025-09-17 19:37:16',NULL,NULL,NULL,'03316bb3-2f55-4682-9204-128d91d29e6c'),
(2500,1486,NULL,1475,2,'craft\\elements\\Entry',1,0,'2025-09-17 19:37:16','2025-09-17 19:37:16',NULL,NULL,NULL,'95fac550-69f1-42b6-a591-ada2f68752af'),
(2501,1487,NULL,1476,2,'craft\\elements\\Entry',1,0,'2025-09-17 19:37:16','2025-09-17 19:37:16',NULL,NULL,NULL,'a94ed8ae-0e30-4160-b54e-a86536244182'),
(2504,NULL,437,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-18 19:05:12','2025-09-18 19:05:12',NULL,NULL,NULL,'1bf94d00-f2b6-431f-941d-50d978be0d58'),
(2505,NULL,438,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-18 19:05:56','2025-09-18 19:05:56',NULL,NULL,NULL,'c9467667-c317-4f21-b15f-cf238a2cf152'),
(2506,NULL,439,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-18 19:06:07','2025-09-18 19:06:07',NULL,NULL,NULL,'56dbee44-e706-4928-a092-a16c1e9bba61'),
(2507,NULL,440,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-18 19:06:28','2025-09-18 19:06:28',NULL,NULL,NULL,'92b41541-7670-4f62-b8ea-d736e0d7590b'),
(2508,NULL,441,NULL,6,'craft\\elements\\Entry',1,0,'2025-09-18 19:07:14','2025-09-18 19:07:14',NULL,NULL,NULL,'76f1554d-f200-45f9-857c-e5ab84ba2ef7'),
(2509,NULL,442,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-18 19:10:23','2025-09-18 19:10:23',NULL,NULL,NULL,'4b258bb6-8345-47c6-9618-ff5325483a67'),
(2510,NULL,443,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-18 19:10:54','2025-09-18 19:10:54',NULL,NULL,NULL,'de86485d-714d-484d-a1ba-4cba7bcea5d6'),
(2516,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-19 16:58:14','2025-09-19 16:58:14',NULL,NULL,NULL,'a88dc780-1702-4136-8c14-39c1b8af932e'),
(2518,605,NULL,1477,5,'craft\\elements\\Entry',1,0,'2025-09-19 16:58:18','2025-09-19 16:58:18',NULL,NULL,NULL,'c4ac66da-0efc-4159-9b88-86cb23f6d62a'),
(2519,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:25:28','2025-09-24 19:41:47',NULL,NULL,NULL,'798407a8-dc42-4891-824a-5b688cae9b01'),
(2520,2519,NULL,1478,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:27:09','2025-09-19 17:27:09',NULL,NULL,NULL,'fa3f1a9f-6f97-42f5-99a3-205b578e474b'),
(2522,2519,NULL,1479,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:27:31','2025-09-19 17:27:31',NULL,NULL,NULL,'e5505781-4c57-4615-8b16-d5ef7ba052ec'),
(2523,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:28:47','2025-09-24 17:20:23',NULL,NULL,NULL,'2e9f1bdb-a41c-42cc-8dde-7aa89ffddd2f'),
(2524,2523,NULL,1480,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:29:12','2025-09-19 17:29:12',NULL,NULL,NULL,'9f84aee8-686d-471e-8b34-83d6caf38ded'),
(2526,2523,NULL,1481,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:29:35','2025-09-19 17:29:35',NULL,NULL,NULL,'8f6a715d-fff5-4e6c-8926-4cdf0ec3db0d'),
(2527,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:30:10','2025-09-24 17:20:14',NULL,NULL,NULL,'fc7c950a-4533-492a-a7a7-e2afea558b45'),
(2528,2527,NULL,1482,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:31:21','2025-09-19 17:31:21',NULL,NULL,NULL,'14ceef1a-cf0a-4f95-92a4-1f227f35893c'),
(2530,2527,NULL,1483,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:31:59','2025-09-19 17:31:59',NULL,NULL,NULL,'8ad99ee4-b840-43d9-a671-379c3e9e99fb'),
(2531,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:32:19','2025-09-30 19:28:07',NULL,NULL,NULL,'f679d85c-04bf-4fdf-aa69-2619259a729e'),
(2532,2531,NULL,1484,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:33:26','2025-09-19 17:33:26',NULL,NULL,NULL,'ec10f6fb-97fa-43dc-a55a-499e37faaa0e'),
(2534,2531,NULL,1485,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:34:50','2025-09-19 17:34:50',NULL,NULL,NULL,'9e3e9ed4-21f7-4059-9a2c-e745e294f9d6'),
(2535,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:34:52','2025-09-24 17:19:43',NULL,NULL,NULL,'a7be63ba-1aef-4be2-bbdf-387693347e0c'),
(2536,2535,NULL,1486,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:35:50','2025-09-19 17:35:50',NULL,NULL,NULL,'50604867-8e85-40ba-987a-deb315a8b043'),
(2537,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:37:12','2025-09-24 17:19:53',NULL,NULL,NULL,'56881ee1-2b77-454e-b507-84c6eeef5674'),
(2538,2537,NULL,1487,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:38:19','2025-09-19 17:38:19',NULL,NULL,NULL,'4ca31b6d-0a38-4b5f-b1b4-45ff2cc21e8b'),
(2540,2535,NULL,1488,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:38:52','2025-09-19 17:38:52',NULL,NULL,NULL,'85586ca8-0eb5-4f04-a1ce-3a1396134b8f'),
(2542,2537,NULL,1489,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:18','2025-09-19 17:40:18',NULL,NULL,NULL,'493901ce-3b81-4599-b50a-4ca08a357afa'),
(2544,2535,NULL,1490,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:24','2025-09-19 17:40:24',NULL,NULL,NULL,'16370887-6b06-44bd-8209-3f7d03301751'),
(2546,2531,NULL,1491,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:31','2025-09-19 17:40:31',NULL,NULL,NULL,'cc536b73-77ec-426a-ae5d-ff768d2f5e4e'),
(2548,2527,NULL,1492,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:36','2025-09-19 17:40:36',NULL,NULL,NULL,'ddcf4584-17c9-4aeb-884f-8cbcc989ffd1'),
(2550,2523,NULL,1493,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:43','2025-09-19 17:40:43',NULL,NULL,NULL,'589cd3dd-fa2a-43a5-a2ac-a51ad123960a'),
(2552,2519,NULL,1494,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:50','2025-09-19 17:40:50',NULL,NULL,NULL,'a606d8ab-1fdf-4776-9e86-df6900369c8f'),
(2553,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:07','2025-09-19 18:50:13',NULL,NULL,NULL,'1f82e73c-c692-4568-b585-ae99eb7d380b'),
(2554,2553,NULL,1495,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:13','2025-09-19 18:50:13',NULL,NULL,NULL,'447453c2-b29f-478c-946d-abd97da673ff'),
(2555,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:13','2025-09-19 18:50:15',NULL,NULL,NULL,'b329aaf6-6f21-444a-b552-c1d9a05f909f'),
(2556,2555,NULL,1496,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:15','2025-09-19 18:50:15',NULL,NULL,NULL,'6b12fb58-47ab-496a-a6ef-81c893b554d6'),
(2557,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:15','2025-09-19 18:50:18',NULL,NULL,NULL,'d89963c6-a945-4912-b645-59a7dbe99761'),
(2558,2557,NULL,1497,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:18','2025-09-19 18:50:18',NULL,NULL,NULL,'ea0ccd3e-caa3-4ba3-b016-4af7d0df34c4'),
(2559,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:18','2025-09-19 18:50:27',NULL,NULL,NULL,'92068cd8-0a8e-4188-93e4-d0adbb22dc1e'),
(2560,2559,NULL,1498,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:27','2025-09-19 18:50:27',NULL,NULL,NULL,'34e48f02-d6e9-488f-86e0-0cffb3195a70'),
(2561,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:37','2025-09-19 18:50:45',NULL,NULL,NULL,'a231e115-688d-4f00-b246-4c3505b058dc'),
(2562,2561,NULL,1499,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:45','2025-09-19 18:50:45',NULL,NULL,NULL,'935997ba-edcf-4fd2-89ac-fbc4b386f843'),
(2563,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:45','2025-09-19 18:50:48',NULL,NULL,NULL,'a9ae196c-4c39-41b5-a34b-03614b7a607a'),
(2564,2563,NULL,1500,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:48','2025-09-19 18:50:48',NULL,NULL,NULL,'cde9bda8-b387-4efd-92c1-35b8fafb67cf'),
(2565,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:48','2025-09-19 18:50:50',NULL,NULL,NULL,'ee7ae933-c2c6-4a6a-8f16-96b6f1b9b6bd'),
(2566,2565,NULL,1501,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:50','2025-09-19 18:50:50',NULL,NULL,NULL,'d087424b-77d9-433a-b247-1ee011a5834c'),
(2567,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:50','2025-09-19 18:50:52',NULL,NULL,NULL,'be85fe8b-f433-47f1-95d4-351af20a2806'),
(2568,2567,NULL,1502,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:52','2025-09-19 18:50:52',NULL,NULL,NULL,'0b23eb9f-9b41-4259-a1ea-c97d2c437346'),
(2569,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:52','2025-09-19 18:50:55',NULL,NULL,NULL,'4dd3b51c-ef51-4e69-a1ae-51b556192a86'),
(2570,2569,NULL,1503,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:55','2025-09-19 18:50:55',NULL,NULL,NULL,'9aa038d4-3589-415e-9fce-ff6f17a1a4e4'),
(2571,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:55','2025-09-19 18:50:59',NULL,NULL,NULL,'b608439b-ca0f-4766-b3e2-94df92a69e2e'),
(2572,2571,NULL,1504,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:59','2025-09-19 18:50:59',NULL,NULL,NULL,'d42f5795-c8d7-43b8-9c6e-50db5eb4422a'),
(2573,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:59','2025-09-19 18:51:06',NULL,NULL,NULL,'d41283ba-951c-4073-81d9-a12cab8c4ca2'),
(2574,2573,NULL,1505,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:03','2025-09-19 18:51:03',NULL,NULL,NULL,'e650f765-b5b2-4adb-b603-6ffea7fe1eab'),
(2575,2573,NULL,1506,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:06','2025-09-19 18:51:06',NULL,NULL,NULL,'64a59e0d-63dd-4e47-9235-f311e24c2822'),
(2576,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:06','2025-09-19 18:51:09',NULL,NULL,NULL,'328cf59f-6de8-42e8-a1b4-0e8ca15a9118'),
(2577,2576,NULL,1507,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:09','2025-09-19 18:51:09',NULL,NULL,NULL,'efe25b57-54ec-4dda-86e7-f8e3db89d470'),
(2579,2537,NULL,1508,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:30','2025-09-19 18:51:30',NULL,NULL,NULL,'d1828e30-43ad-41ad-a279-bf18508cc953'),
(2581,2535,NULL,1509,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:46','2025-09-19 18:51:46',NULL,NULL,NULL,'2b22d8d4-2fa6-4aac-98be-d594893b5212'),
(2583,2531,NULL,1510,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:56','2025-09-19 18:51:56',NULL,NULL,NULL,'d4ea6741-e126-47b2-9b94-4261ad889e7a'),
(2585,2527,NULL,1511,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:52:10','2025-09-19 18:52:10',NULL,NULL,NULL,'533472d2-9f5b-422f-8881-c8fc9d1cec24'),
(2587,2523,NULL,1512,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:52:18','2025-09-19 18:52:18',NULL,NULL,NULL,'c2990695-289a-4a5b-82ff-a483f97bf743'),
(2589,2519,NULL,1513,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:52:27','2025-09-19 18:52:27',NULL,NULL,NULL,'f0260a8f-8d2d-4af1-9771-887da16e8f84'),
(2590,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:52:38','2025-09-19 19:15:03',NULL,NULL,NULL,'6cae16a6-f883-4139-a765-c67347143182'),
(2591,2590,NULL,1514,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:53:29','2025-09-19 18:53:29',NULL,NULL,NULL,'530fb6e6-1e63-401c-8814-5f6576b81df6'),
(2592,2537,NULL,1515,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:53:35','2025-09-19 18:53:35',NULL,NULL,NULL,'6f41855b-e4c1-4d65-90bf-3edb7c561ac0'),
(2594,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-19 18:57:57','2025-09-19 18:57:57',NULL,NULL,NULL,'42d65d55-306b-417d-8600-0bb8ec837d7a'),
(2595,2590,NULL,1516,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:57:59','2025-09-19 18:57:59',NULL,NULL,NULL,'b0b62e6c-322d-4cd0-bf67-e701786ccddc'),
(2596,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:05:39','2025-09-19 19:06:52',NULL,NULL,NULL,'ed5b5724-8a1c-4424-a8aa-bcc5e5591568'),
(2597,2596,NULL,1517,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:06:52','2025-09-19 19:06:52',NULL,NULL,NULL,'cf4c9543-4654-44b2-bc1a-0eec18aa2fdf'),
(2598,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:06:52','2025-09-19 19:06:57',NULL,NULL,NULL,'2b425daa-3c83-4d5f-855e-9aaadf81a9e3'),
(2599,2598,NULL,1518,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:06:57','2025-09-19 19:06:57',NULL,NULL,NULL,'0a37fe07-9f4b-4616-bd4d-d342ccbdab00'),
(2600,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:06:57','2025-09-19 19:07:03',NULL,NULL,NULL,'03b51710-5c79-4483-afe4-bda55784e2f3'),
(2601,2600,NULL,1519,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:03','2025-09-19 19:07:03',NULL,NULL,NULL,'57723b37-e14c-4bbe-bac4-0df0f4508f5b'),
(2602,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:03','2025-09-19 19:07:09',NULL,NULL,NULL,'bd40e808-1b5a-4674-8f1f-79ce381e440c'),
(2603,2602,NULL,1520,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:09','2025-09-19 19:07:09',NULL,NULL,NULL,'31cd7061-ac55-4c56-9548-7d2f30484574'),
(2604,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:09','2025-09-19 19:07:13',NULL,NULL,NULL,'c1580479-2261-4e66-a3b0-771bbd6898b3'),
(2605,2604,NULL,1521,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:13','2025-09-19 19:07:13',NULL,NULL,NULL,'c43cf147-5984-4462-bce8-231f550507c2'),
(2606,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:13','2025-09-19 19:07:17',NULL,NULL,NULL,'a54c9d4f-1de7-4f3f-a0d9-1bc5ef6c3b82'),
(2607,2606,NULL,1522,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:17','2025-09-19 19:07:17',NULL,NULL,NULL,'705217ff-3a28-400c-a46f-3446855a2538'),
(2608,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:17','2025-09-19 19:07:23',NULL,NULL,NULL,'f9a5647d-ff01-4f49-a021-5fc8e32ddc73'),
(2609,2608,NULL,1523,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:23','2025-09-19 19:07:23',NULL,NULL,NULL,'366283e4-5e9a-43e9-bc56-54b1250d0c21'),
(2610,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:23','2025-09-19 19:07:27',NULL,NULL,NULL,'775903a5-eb1a-492f-a3a4-59a280676468'),
(2611,2610,NULL,1524,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:27','2025-09-19 19:07:27',NULL,NULL,NULL,'9690e450-9ea6-48b5-a4ef-5e0f65ce5dc1'),
(2612,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:27','2025-09-19 19:07:36',NULL,NULL,NULL,'cf692f93-e1c4-4161-ac36-11ae0932ee6d'),
(2613,2612,NULL,1525,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:36','2025-09-19 19:07:36',NULL,NULL,NULL,'9d55947e-e594-40a3-a249-5c5c28525fde'),
(2614,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:36','2025-09-19 19:07:44',NULL,NULL,NULL,'cb61d67e-83c4-4abc-bf6e-080ed8a8a973'),
(2615,2614,NULL,1526,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:44','2025-09-19 19:07:44',NULL,NULL,NULL,'9abe030a-b0f1-49da-b606-49d5c64d67c6'),
(2616,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:44','2025-09-22 17:36:14',NULL,'2025-09-22 17:36:14',NULL,'1585f072-dbe2-4e26-a123-c6ae0273e564'),
(2617,2616,NULL,1527,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:47','2025-09-19 19:07:47',NULL,'2025-09-22 17:36:14',NULL,'29963604-bb2a-4542-8325-5d0a929aebe0'),
(2618,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:47','2025-09-19 19:07:49',NULL,NULL,NULL,'b5e0de7b-b9c8-48f0-91c6-484d8caa02ca'),
(2619,2618,NULL,1528,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:49','2025-09-19 19:07:49',NULL,NULL,NULL,'13d5c252-c187-4d28-a171-c29ca8de64cd'),
(2620,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:49','2025-09-26 16:12:24',NULL,'2025-09-26 16:12:24',NULL,'a35a0819-49d2-4d5f-ae68-e84695c72829'),
(2621,2620,NULL,1529,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:53','2025-09-19 19:07:53',NULL,'2025-09-26 16:12:24',NULL,'c64ba2e0-e3d4-419e-b291-e7187ceef2f7'),
(2622,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:53','2025-09-24 16:01:26',NULL,NULL,NULL,'0a1cb6bd-d0cc-4b56-94d6-4573d769d02c'),
(2623,2622,NULL,1530,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:55','2025-09-19 19:07:55',NULL,NULL,NULL,'ccb4c11c-644a-45d9-a660-734ba66b717a'),
(2624,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:55','2025-09-19 19:07:59',NULL,NULL,NULL,'501cb39a-b029-4e58-b73e-2c796bd1926c'),
(2625,2624,NULL,1531,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:59','2025-09-19 19:07:59',NULL,NULL,NULL,'5a043e60-e89d-457d-ad36-2d7d38519ce8'),
(2626,2,NULL,1532,1,'craft\\elements\\Entry',1,0,'2025-09-19 19:10:35','2025-09-19 19:10:35',NULL,NULL,NULL,'cd94c5fa-ab73-4c55-a0a3-782ddf513bc1'),
(2627,945,NULL,1533,1,'craft\\elements\\Entry',1,0,'2025-09-19 19:10:40','2025-09-19 19:10:40',NULL,NULL,NULL,'eaf36663-e691-4c12-a7c4-9e5e33ad4f2b'),
(2628,1255,NULL,1534,1,'craft\\elements\\Entry',1,0,'2025-09-19 19:10:44','2025-09-19 19:10:44',NULL,NULL,NULL,'af395f92-4d90-4e6e-828c-13b2c1e28c08'),
(2629,1165,NULL,1535,1,'craft\\elements\\Entry',1,0,'2025-09-19 19:10:48','2025-09-19 19:10:48',NULL,NULL,NULL,'e1a41b0a-395c-461c-98d7-ffda5bf0a805'),
(2631,2590,NULL,1536,12,'craft\\elements\\Entry',1,0,'2025-09-19 19:15:03','2025-09-19 19:15:03',NULL,NULL,NULL,'3b597831-2740-4f3d-9196-0d831107edfb'),
(2633,497,NULL,1537,6,'craft\\elements\\Entry',1,0,'2025-09-19 19:22:04','2025-09-19 19:22:04',NULL,NULL,NULL,'6272791a-de82-4b56-9175-163e15b04f6b'),
(2635,951,NULL,1538,1,'craft\\elements\\Entry',1,0,'2025-09-22 17:36:50','2025-09-22 17:36:50',NULL,NULL,NULL,'567baa8c-18ca-4f71-bf0c-49d45ab5d6e9'),
(2637,1353,NULL,1539,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:01:29','2025-09-22 18:01:29',NULL,NULL,NULL,'0cfd97a2-b25e-4990-8d49-4e4a73836e75'),
(2640,1359,NULL,1540,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:03:21','2025-09-22 18:03:22',NULL,NULL,NULL,'5d28cdde-151f-4f3c-866c-1ad41a17312c'),
(2641,1353,NULL,1541,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:03:40','2025-09-22 18:03:40',NULL,NULL,NULL,'9b6e0d49-0cd5-42cc-b5d3-49c6382ccb72'),
(2643,1365,NULL,1542,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:04:13','2025-09-22 18:04:13',NULL,NULL,NULL,'2f77c9ad-e35a-40f5-81ff-806c1f22da65'),
(2645,1371,NULL,1543,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:04:46','2025-09-22 18:04:46',NULL,NULL,NULL,'ec8a6866-7615-4634-a4ec-ffe1e7799e18'),
(2647,1353,NULL,1544,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:04:56','2025-09-22 18:04:56',NULL,NULL,NULL,'fa7fd048-7fe9-41c6-97e5-ae47bd39fadd'),
(2649,1359,NULL,1545,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:05:05','2025-09-22 18:05:05',NULL,NULL,NULL,'2d451d36-1ae8-48bd-bce5-4eae79f08bfc'),
(2651,1365,NULL,1546,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:05:37','2025-09-22 18:05:37',NULL,NULL,NULL,'c697e627-4e31-4d1a-880e-5b89c6307c8b'),
(2653,1377,NULL,1547,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:06:29','2025-09-22 18:06:29',NULL,NULL,NULL,'8ddfb5d1-1881-47b0-a5f8-6f766eb4e9c9'),
(2655,1383,NULL,1548,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:06:50','2025-09-22 18:06:50',NULL,NULL,NULL,'b6f34d50-21c8-4413-b4fa-cb591a437244'),
(2657,1389,NULL,1549,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:07:16','2025-09-22 18:07:16',NULL,NULL,NULL,'f5c5299c-8dfe-4fff-b2b2-214e915f50c0'),
(2659,1395,NULL,1550,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:08:00','2025-09-22 18:08:00',NULL,NULL,NULL,'d8d50f8a-5155-43f9-ad24-d17286bcab2c'),
(2661,1401,NULL,1551,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:08:33','2025-09-22 18:08:33',NULL,NULL,NULL,'af589c20-0be9-4a3e-9752-b34db1355b8d'),
(2663,1407,NULL,1552,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:08:56','2025-09-22 18:08:56',NULL,NULL,NULL,'c956fdad-0162-4993-b457-60ded1ef76f9'),
(2665,1413,NULL,1553,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:09:23','2025-09-22 18:09:23',NULL,NULL,NULL,'d60c7ef7-e87a-4f3c-b875-12d039894748'),
(2667,1413,NULL,1554,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:09:38','2025-09-22 18:09:38',NULL,NULL,NULL,'4452d2c3-b7e9-40b4-9b5d-f251e3d6fdc5'),
(2669,1413,NULL,1555,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:09:54','2025-09-22 18:09:54',NULL,NULL,NULL,'1988353a-0bb8-4430-b9a8-3cbffc4772fc'),
(2671,1359,NULL,1556,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:10:03','2025-09-22 18:10:03',NULL,NULL,NULL,'1e51a1e3-3b09-471d-86b5-8c3caa82a99a'),
(2673,1353,NULL,1557,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:10:11','2025-09-22 18:10:11',NULL,NULL,NULL,'7b3ecea1-cf13-4251-a491-14c4e29e37e8'),
(2675,1395,NULL,1558,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:10:30','2025-09-22 18:10:30',NULL,NULL,NULL,'f4e3d187-5f5b-4240-8d04-2f09cde373d0'),
(2678,1365,NULL,1559,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:10:48','2025-09-22 18:10:48',NULL,NULL,NULL,'31e57a87-8928-4f1b-8f68-ff5b8dafce53'),
(2680,1371,NULL,1560,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:11:25','2025-09-22 18:11:25',NULL,NULL,NULL,'02a82296-3dee-4128-9909-4b2cb74a82c6'),
(2682,1377,NULL,1561,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:11:35','2025-09-22 18:11:35',NULL,NULL,NULL,'044d3a09-7711-4916-9efb-81892f95fb05'),
(2684,1383,NULL,1562,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:11:49','2025-09-22 18:11:49',NULL,NULL,NULL,'8ed1ac02-aefa-4daf-9d24-698ac17f4712'),
(2686,1389,NULL,1563,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:12:03','2025-09-22 18:12:03',NULL,NULL,NULL,'b437b1a6-ba58-4119-a194-8216f04fa596'),
(2689,1401,NULL,1564,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:12:28','2025-09-22 18:12:28',NULL,NULL,NULL,'e067c24c-2576-4600-abab-2c6703865199'),
(2691,1407,NULL,1565,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:13:02','2025-09-22 18:13:02',NULL,NULL,NULL,'d95c3554-d596-4337-95e6-f25c14ea837e'),
(2693,1413,NULL,1566,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:18:15','2025-09-22 18:18:15',NULL,NULL,NULL,'7d3c09d5-33bc-49b0-9b20-52ab558dd130'),
(2695,1353,NULL,1567,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:20:10','2025-09-22 18:20:10',NULL,NULL,NULL,'cf9416ca-910d-4782-b4f7-350e2f6a7685'),
(2697,1359,NULL,1568,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:20:32','2025-09-22 18:20:33',NULL,NULL,NULL,'75051435-a9e8-4561-91e8-46d34b6aca30'),
(2698,1365,NULL,1569,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:20:52','2025-09-22 18:20:52',NULL,NULL,NULL,'bbf8407d-bac1-47fb-b03a-5b057b9a32df'),
(2699,1395,NULL,1570,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:21:16','2025-09-22 18:21:16',NULL,NULL,NULL,'c058663d-1b8b-4b28-abbe-a485ead99e64'),
(2701,1371,NULL,1571,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:21:35','2025-09-22 18:21:35',NULL,NULL,NULL,'b0bb1e40-42aa-4e8c-a453-e9d77f1d9e0f'),
(2703,1377,NULL,1572,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:22:06','2025-09-22 18:22:06',NULL,NULL,NULL,'6fadb5fa-d81a-4f7d-8b92-c83d74107c67'),
(2705,1401,NULL,1573,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:22:29','2025-09-22 18:22:29',NULL,NULL,NULL,'ce543f07-040e-4d57-bcc5-8acd57217816'),
(2707,1383,NULL,1574,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:22:45','2025-09-22 18:22:45',NULL,NULL,NULL,'aebab139-b1aa-43a9-b06b-8c7cfabcb458'),
(2709,1389,NULL,1575,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:23:01','2025-09-22 18:23:02',NULL,NULL,NULL,'ef58f931-789e-483c-a450-8b7d4d1eb7ed'),
(2711,1407,NULL,1576,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:23:24','2025-09-22 18:23:24',NULL,NULL,NULL,'f96f2cd0-e318-46d3-a704-1a5f524db1b1'),
(2712,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:31:54','2025-10-06 16:09:59',NULL,NULL,NULL,'dd61e91a-428e-4c7e-92a2-b1678fb22a9f'),
(2713,2712,NULL,1577,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:33:07','2025-09-22 18:33:07',NULL,NULL,NULL,'f0e219c3-0b40-405e-b74f-3a6a4e87fcee'),
(2716,2712,NULL,1578,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:33:47','2025-09-22 18:33:47',NULL,NULL,NULL,'c725bc56-b88f-4150-b481-9efd1c0431e5'),
(2717,2,NULL,1579,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:33:52','2025-09-22 18:33:52',NULL,NULL,NULL,'2b7dd672-66e5-45ee-a14b-413bd45df09f'),
(2719,2712,NULL,1580,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:33:59','2025-09-22 18:33:59',NULL,NULL,NULL,'055e1545-833e-4929-b4dc-1d22a9d7787d'),
(2720,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:34:20','2025-10-08 22:20:23',NULL,NULL,NULL,'8edf8d99-3b37-4cf7-8604-05cdfd866b47'),
(2721,2720,NULL,1581,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:35:27','2025-09-22 18:35:27',NULL,NULL,NULL,'c1d0d498-a622-47b1-a8d7-7e0f0a6bf998'),
(2723,2720,NULL,1582,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:35:58','2025-09-22 18:35:58',NULL,NULL,NULL,'b90d043b-1cbf-4469-beb6-f9248e860704'),
(2725,2720,NULL,1583,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:36:12','2025-09-22 18:36:12',NULL,NULL,NULL,'0f75944b-28b9-4f57-a792-1cf7f9f23fe2'),
(2727,2720,NULL,1584,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:36:20','2025-09-22 18:36:20',NULL,NULL,NULL,'7d8cf309-af4b-4543-9dea-d4576cd6748a'),
(2729,2712,NULL,1585,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:36:55','2025-09-22 18:36:55',NULL,NULL,NULL,'1ef5bc5d-deb8-4f07-a030-6782faff4a0b'),
(2731,2,NULL,1586,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:42:24','2025-09-22 18:42:24',NULL,NULL,NULL,'00c6af15-ce7d-4849-a610-326c7c928efa'),
(2732,1059,NULL,1587,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:42:30','2025-09-22 18:42:30',NULL,NULL,NULL,'f99c1038-bb40-418b-9813-63a7025dfd6f'),
(2733,1283,NULL,1588,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:42:35','2025-09-22 18:42:35',NULL,NULL,NULL,'464e4b65-76d2-4d1a-8f39-81b5f6bdda47'),
(2735,NULL,554,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-22 19:39:53','2025-09-22 19:39:53',NULL,NULL,NULL,'08fe5f3a-2bd4-4a5b-8fa4-3e4c8e7b91bf'),
(2736,2,NULL,1589,1,'craft\\elements\\Entry',1,0,'2025-09-22 19:42:28','2025-09-22 19:42:29',NULL,NULL,NULL,'8301ac1c-cbef-421f-bfde-7c3436caf2a4'),
(2740,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-22 20:40:47','2025-09-22 20:46:11',NULL,'2025-09-22 20:46:11',NULL,'f0036f95-cf2b-4e1d-baf9-6310bfa91a51'),
(2742,601,NULL,1590,5,'craft\\elements\\Entry',1,0,'2025-09-22 20:40:59','2025-09-22 20:40:59',NULL,NULL,NULL,'90518e6f-0901-4395-be9a-cd14eda0165c'),
(2743,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'a520d29b-eced-425e-bf1a-f1a35646d600'),
(2744,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'7c1de11f-ebcf-4c6e-b2e8-1c5eb53efc68'),
(2745,2,NULL,1591,1,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'5ebcf8a0-f927-4075-97e3-43891e2ffeaa'),
(2746,2743,NULL,1592,3,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'50b13f66-01f6-4bee-8165-85f2e52ab10a'),
(2747,2744,NULL,1593,3,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'5c11c11b-6c2d-46c1-96c3-9442dcacdd1d'),
(2750,601,NULL,1594,5,'craft\\elements\\Entry',1,0,'2025-09-22 20:45:52','2025-09-22 20:45:52',NULL,NULL,NULL,'53ce4217-639b-419a-a73c-6443a3417118'),
(2751,459,NULL,1595,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:24:58','2025-09-23 20:24:58',NULL,NULL,NULL,'5a05c997-033a-4a62-ba13-559b802db7ef'),
(2753,459,NULL,1596,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:08','2025-09-23 20:25:08',NULL,NULL,NULL,'83e87564-d2a9-441d-94c8-ed6e5f2bf570'),
(2754,461,NULL,1597,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:25','2025-09-23 20:25:25',NULL,NULL,NULL,'e5f3ce22-f12e-4c27-bd18-8800f1f29444'),
(2756,457,NULL,1598,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:31','2025-09-23 20:25:31',NULL,NULL,NULL,'79000580-aa18-4ac5-960c-e1ec4bacd872'),
(2758,463,NULL,1599,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:37','2025-09-23 20:25:37',NULL,NULL,NULL,'18d046ca-46ee-4d51-9f67-2c42cdcaf067'),
(2760,465,NULL,1600,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:47','2025-09-23 20:25:47',NULL,NULL,NULL,'fda55c44-299e-4f1a-ae6d-fbbeec708d23'),
(2761,467,NULL,1601,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:55','2025-09-23 20:25:55',NULL,NULL,NULL,'20ab7767-16a4-4677-91c8-e5a8581b8e17'),
(2763,469,NULL,1602,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:04','2025-09-23 20:26:04',NULL,NULL,NULL,'27d68ba6-8788-4d0e-b5ca-40669ea528b7'),
(2764,471,NULL,1603,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:11','2025-09-23 20:26:11',NULL,NULL,NULL,'7272a6d5-a6bd-495f-a010-cee877695ac9'),
(2766,475,NULL,1604,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:19','2025-09-23 20:26:19',NULL,NULL,NULL,'774aa463-25fe-45e9-85e8-89b8f2eeb2dc'),
(2768,475,NULL,1605,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:26','2025-09-23 20:26:26',NULL,NULL,NULL,'e5b5440a-7cd9-4e0b-9320-3d413c6c873d'),
(2769,477,NULL,1606,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:34','2025-09-23 20:26:34',NULL,NULL,NULL,'9c3a45da-b569-44f2-8afe-f869cae19015'),
(2770,479,NULL,1607,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:42','2025-09-23 20:26:42',NULL,NULL,NULL,'1044a086-a589-4314-8063-db7230f407f8'),
(2772,481,NULL,1608,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:54','2025-09-23 20:26:54',NULL,NULL,NULL,'2e91cad0-71c1-4ae3-b7f4-249b6bbba78d'),
(2774,483,NULL,1609,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:27:03','2025-09-23 20:27:03',NULL,NULL,NULL,'89510032-755b-4553-9af0-79e69d2f2aba'),
(2775,485,NULL,1610,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:27:13','2025-09-23 20:27:13',NULL,NULL,NULL,'54c4f5d4-0aed-4ab5-a2eb-87fb9ff18ca7'),
(2776,497,NULL,1611,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:27:28','2025-09-23 20:27:28',NULL,NULL,NULL,'d2ffd692-e9c1-4969-8340-7a3bd760e48b'),
(2778,487,NULL,1612,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:02','2025-09-23 20:29:02',NULL,NULL,NULL,'bbcf8b4e-8275-4917-a71b-81fe04c749fa'),
(2780,489,NULL,1613,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:09','2025-09-23 20:29:09',NULL,NULL,NULL,'adc63a2c-f16a-4cd2-8937-f5e39b1b1d5e'),
(2781,491,NULL,1614,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:17','2025-09-23 20:29:17',NULL,NULL,NULL,'74537ed0-d9b5-4630-a5a0-13cd647368ae'),
(2782,493,NULL,1615,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:24','2025-09-23 20:29:24',NULL,NULL,NULL,'0046eebf-0773-4e96-abdb-7005b1844456'),
(2784,495,NULL,1616,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:38','2025-09-23 20:29:38',NULL,NULL,NULL,'94205c05-e2f4-414d-a0dd-443cbfdec53b'),
(2785,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:43:42','2025-09-30 22:22:13',NULL,NULL,NULL,'e13f4958-4796-464e-b66a-72e49c7d45cb'),
(2786,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:43:49','2025-09-30 22:22:24',NULL,NULL,NULL,'e6acfaec-6184-424c-8a4f-fbe541f2fe91'),
(2787,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:43:54','2025-09-30 22:22:37',NULL,NULL,NULL,'46ebec47-7046-4634-af10-57e83a4bd1aa'),
(2791,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-30 22:41:39',NULL,NULL,NULL,'75a41dd2-8fe4-4d4a-9c95-66b0698211a3'),
(2792,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-30 22:45:18',NULL,'2025-09-30 22:45:18',NULL,'de2fd3c6-8fe9-4b33-924e-4bac8ed713ab'),
(2793,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-30 22:46:11',NULL,NULL,NULL,'bb6951d7-9f9a-4283-bc5e-6467bf906b9e'),
(2794,2,NULL,1617,1,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-23 20:45:18',NULL,NULL,NULL,'e647b307-5a23-4c78-8c3f-33870184eb7e'),
(2795,2791,NULL,1618,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-23 20:45:18',NULL,NULL,NULL,'333e2a9e-590f-4f51-beae-f7048d30c5cf'),
(2796,2792,NULL,1619,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-23 20:45:18',NULL,'2025-09-30 22:45:18',NULL,'a5deccbe-6457-4cdc-9c99-fd5a01af792d'),
(2797,2793,NULL,1620,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-23 20:45:18',NULL,NULL,NULL,'1e6b62b8-1294-42f0-8203-58ef942874b6'),
(2799,2,NULL,1621,1,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:07','2025-09-23 21:13:07',NULL,NULL,NULL,'9945537d-c2b2-459f-a8c4-fc387da11a49'),
(2800,NULL,NULL,NULL,22,'craft\\elements\\Asset',1,0,'2025-09-23 21:13:16','2025-09-23 21:22:49',NULL,NULL,NULL,'d06a14ea-0b3f-46f1-9fc3-27f80e36224e'),
(2802,459,NULL,1622,6,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:19','2025-09-23 21:13:19',NULL,NULL,NULL,'c6632179-233c-4e81-8b06-f027664fe5c6'),
(2803,NULL,NULL,NULL,22,'craft\\elements\\Asset',1,0,'2025-09-23 21:13:36','2025-09-23 21:22:40',NULL,NULL,NULL,'645ea5ae-4175-4410-ba89-7daf862ff408'),
(2805,465,NULL,1623,6,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:37','2025-09-23 21:13:37',NULL,NULL,NULL,'3c57da7a-d1fa-4fd7-8b32-89ab823a439d'),
(2806,NULL,NULL,NULL,22,'craft\\elements\\Asset',1,0,'2025-09-23 21:13:42','2025-09-23 21:22:33',NULL,NULL,NULL,'3aa27850-e4b8-4894-b00a-059bfe04c324'),
(2808,497,NULL,1624,6,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:43','2025-09-23 21:13:43',NULL,NULL,NULL,'0b046278-b13a-4781-88f7-6d2b466a1a29'),
(2809,NULL,NULL,NULL,22,'craft\\elements\\Asset',1,0,'2025-09-23 21:13:48','2025-09-23 21:22:25',NULL,NULL,NULL,'1442f42d-5abd-4e2c-a860-c63e22014cab'),
(2811,487,NULL,1625,6,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:50','2025-09-23 21:13:50',NULL,NULL,NULL,'bb03ac1d-f805-4602-abeb-2294590f0184'),
(2812,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:56:15','2025-09-23 21:56:42',NULL,NULL,NULL,'9e84d8c4-96c0-4bce-b66e-a095a9f0f08b'),
(2813,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:56:43','2025-09-23 21:56:57',NULL,NULL,NULL,'d2b74fb7-6d80-4ad7-81d2-2be6696b7351'),
(2814,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:57:02','2025-09-23 21:57:09',NULL,NULL,NULL,'331a4fd5-0801-4feb-b418-dcc4cab532ac'),
(2815,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:57:13','2025-09-23 21:57:19',NULL,NULL,NULL,'9805002c-e2bf-456f-aabe-b2e1aa762420'),
(2816,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:57:23','2025-09-23 21:57:28',NULL,NULL,NULL,'a35a41c4-7359-413b-b4a3-3abcc48f9f51'),
(2817,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:57:32','2025-09-23 21:57:37',NULL,NULL,NULL,'1160191a-e6ca-451e-8818-e29608b3a552'),
(2825,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'853cdf0a-cf7b-449b-bd96-774731d82a62'),
(2826,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'3a20e533-ab54-412e-a69e-1a235f6ec472'),
(2827,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'6ab8c753-d0ae-4279-b9a6-cb3dda256892'),
(2828,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'d64b9941-05a9-49e0-955f-2646b283f66f'),
(2829,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'e9ae92c4-d6d1-47de-9386-f392617552fd'),
(2830,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'b41f5c54-1e17-4c19-80a5-8b00f74c063d'),
(2831,2,NULL,1626,1,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'2dbaaead-55ae-46cd-b9be-dba4b3f793b2'),
(2832,2825,NULL,1627,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'cd724529-1bf1-4cda-9a89-3d2e3a80c60b'),
(2833,2826,NULL,1628,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'31244ec1-ed25-41c6-b2cb-4b15a8dcc2b8'),
(2834,2827,NULL,1629,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'64cc34f6-a02c-446f-9b55-318ad50fcdb2'),
(2835,2828,NULL,1630,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'664273f1-70f1-4ff8-8adb-93e88db663cf'),
(2836,2829,NULL,1631,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'0bdc7b3b-6c94-43cd-86d0-a3d1f9d58589'),
(2837,2830,NULL,1632,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'8d22cc7b-fcc4-40b9-b839-9a356dc70b59'),
(2839,2,NULL,1633,1,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:58','2025-09-23 21:59:58',NULL,NULL,NULL,'3360ea81-5f28-4884-90f4-189f3291f6f9'),
(2841,2,NULL,1634,1,'craft\\elements\\Entry',1,0,'2025-09-23 22:00:31','2025-09-23 22:00:31',NULL,NULL,NULL,'7545304f-aac6-4d86-9ba7-8b0e5bd29eb8'),
(2843,2,NULL,1635,1,'craft\\elements\\Entry',1,0,'2025-09-23 22:02:08','2025-09-23 22:02:08',NULL,NULL,NULL,'06e6866e-568a-4299-bf1f-e28b529632f5'),
(2847,945,NULL,1636,1,'craft\\elements\\Entry',1,0,'2025-09-24 15:56:07','2025-09-24 15:56:07',NULL,NULL,NULL,'8b61121d-1a0b-4a00-9265-b9717a0bd2b3'),
(2848,1171,NULL,1637,1,'craft\\elements\\Entry',1,0,'2025-09-24 15:56:11','2025-09-24 15:56:11',NULL,NULL,NULL,'842aa2a0-afad-411b-b604-5b4687a01a25'),
(2850,2622,NULL,1638,20,'craft\\elements\\Entry',1,0,'2025-09-24 16:01:26','2025-09-24 16:01:26',NULL,NULL,NULL,'4b6d4640-e6f3-4965-9f7e-f361c808dcf9'),
(2852,1481,NULL,1639,1,'craft\\elements\\Entry',1,0,'2025-09-24 16:04:13','2025-09-24 16:04:13',NULL,NULL,NULL,'e3788412-d844-4d8d-8a35-ccb65973bf87'),
(2853,2,NULL,1640,1,'craft\\elements\\Entry',1,0,'2025-09-24 16:06:15','2025-09-24 16:06:15',NULL,NULL,NULL,'4a19536d-7c33-4f0e-81c2-0352d7365703'),
(2854,945,NULL,1641,1,'craft\\elements\\Entry',1,0,'2025-09-24 16:40:05','2025-09-24 16:40:05',NULL,NULL,NULL,'0704a698-27b6-47ea-901e-77dbffbb45f5'),
(2855,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 17:19:20','2025-09-24 17:19:20',NULL,NULL,NULL,'e39eb379-f3ed-40d5-a676-c15e7b7caf9c'),
(2856,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 17:19:27','2025-09-24 17:19:27',NULL,NULL,NULL,'190a5570-3d3b-4219-b9ba-b279e874db56'),
(2857,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 17:19:28','2025-09-24 17:19:28',NULL,NULL,NULL,'ae1aa4c4-bb08-4885-8929-dffc5bd3fcae'),
(2858,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 17:19:28','2025-09-24 17:19:28',NULL,NULL,NULL,'89de1b06-2658-444f-a947-fc203512607b'),
(2860,2537,NULL,1642,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:19:33','2025-09-24 17:19:33',NULL,NULL,NULL,'222c9f8f-075b-423c-8194-1c4b77f8b142'),
(2862,2535,NULL,1643,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:19:43','2025-09-24 17:19:43',NULL,NULL,NULL,'a09276e7-87d2-43b3-8fad-7b8ed0c4089b'),
(2864,2537,NULL,1644,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:19:53','2025-09-24 17:19:53',NULL,NULL,NULL,'da67dd91-d7e5-4662-a2e8-f6a9cb9952a4'),
(2866,2527,NULL,1645,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:20:14','2025-09-24 17:20:14',NULL,NULL,NULL,'6d5836ee-5ca9-474e-a501-e82f00926ac0'),
(2868,2523,NULL,1646,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:20:23','2025-09-24 17:20:23',NULL,NULL,NULL,'9c454b78-f629-4187-975e-a1e1dce3c6fc'),
(2869,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:43','2025-09-24 18:09:43',NULL,NULL,NULL,'17a750d9-c9cb-4a80-b339-1d7e13b052e4'),
(2870,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:44','2025-09-24 18:09:44',NULL,NULL,NULL,'f4e7c045-25a8-492f-82e5-56ebeac79e40'),
(2871,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:44','2025-09-24 18:09:44',NULL,NULL,NULL,'725ddece-9d08-441e-97b9-a876cc319ef5'),
(2872,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:44','2025-09-24 18:09:44',NULL,NULL,NULL,'afaff2b4-2931-4511-9f19-d3b1712a4d22'),
(2873,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:45','2025-10-08 18:24:25',NULL,NULL,NULL,'b24b5202-8da9-4cba-bb7b-bc3e358aac70'),
(2874,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:45','2025-10-08 18:29:50',NULL,NULL,NULL,'acc48022-aa74-461f-be1f-e060daafaa4c'),
(2876,2531,NULL,1647,12,'craft\\elements\\Entry',0,0,'2025-09-24 18:45:18','2025-09-24 18:45:18',NULL,NULL,NULL,'c6377d46-7e13-42d8-8b21-ada7088b2ec4'),
(2877,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 19:41:44','2025-09-24 19:41:44',NULL,NULL,NULL,'1bf9dac5-dfae-41af-95bd-ed3239e532e7'),
(2879,2519,NULL,1648,12,'craft\\elements\\Entry',1,0,'2025-09-24 19:41:47','2025-09-24 19:41:47',NULL,NULL,NULL,'c37699f6-a2af-4a48-8689-05b33b681d15'),
(2880,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-24 23:06:33','2025-10-10 18:22:50',NULL,NULL,NULL,'bef2444f-80b9-482f-bf1a-b25832667146'),
(2881,2880,NULL,1649,1,'craft\\elements\\Entry',1,0,'2025-09-24 23:07:59','2025-09-24 23:07:59',NULL,NULL,NULL,'7abd4bb1-3369-4f94-a5a3-978eaca4ac90'),
(2882,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-24 23:08:22','2025-10-22 18:20:00',NULL,'2025-10-22 18:20:00',NULL,'11c8dd90-e5a3-4fdd-b8e0-2e7831e8dc3b'),
(2883,2882,NULL,1650,1,'craft\\elements\\Entry',1,0,'2025-09-24 23:09:19','2025-09-24 23:09:19',NULL,'2025-10-22 18:20:00',NULL,'c74b1976-2fd7-40e8-b9e8-3ad0e4b02219'),
(2885,1255,NULL,1651,1,'craft\\elements\\Entry',1,0,'2025-09-25 02:15:57','2025-09-25 02:15:57',NULL,NULL,NULL,'7bc7d46f-4151-4012-a966-9e56985d3335'),
(2886,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 14:02:15','2025-09-25 14:02:15',NULL,NULL,NULL,'f7d6ba8f-6ac9-461b-a87c-df38fe080397'),
(2887,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 14:05:38','2025-10-09 16:34:55',NULL,NULL,NULL,'f3ab68b0-c780-49b7-85c6-b270a22a2120'),
(2888,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 14:05:39','2025-09-25 14:07:01',NULL,NULL,NULL,'cbf53f06-3113-4c1b-a3ec-f86d25f82f6d'),
(2889,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 15:18:29','2025-09-25 15:24:16',NULL,NULL,NULL,'2196ef41-7959-416e-834f-3e7f395383ef'),
(2890,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 15:18:40','2025-09-25 15:24:29',NULL,NULL,NULL,'bf4644ad-09e8-4d62-a5d0-10f77cf961aa'),
(2891,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-09-26 17:59:45','2025-09-29 19:09:02',NULL,NULL,NULL,'091623a3-eae4-4db8-88d6-e973fdd7615a'),
(2892,2891,NULL,1652,6,'craft\\elements\\Entry',1,0,'2025-09-26 17:59:52','2025-09-26 17:59:52',NULL,NULL,NULL,'4749bab5-fdcb-4972-837c-3b9482352428'),
(2894,2,NULL,1653,1,'craft\\elements\\Entry',1,0,'2025-09-26 18:00:58','2025-09-26 18:00:58',NULL,NULL,NULL,'150705cb-79ee-4439-8edf-096636031c71'),
(2896,2,NULL,1654,1,'craft\\elements\\Entry',1,0,'2025-09-26 18:05:11','2025-09-26 18:05:11',NULL,NULL,NULL,'4117f518-2706-44a2-87d4-2a11681a4c4a'),
(2899,1255,NULL,1655,1,'craft\\elements\\Entry',1,0,'2025-09-26 20:17:54','2025-09-26 20:17:54',NULL,NULL,NULL,'bb07685c-bfd8-4f27-9515-87e73935070d'),
(2905,1177,NULL,1656,1,'craft\\elements\\Entry',1,0,'2025-09-29 18:35:28','2025-09-29 18:35:28',NULL,NULL,NULL,'c9551b91-1c37-4a62-9935-bcdb87457390'),
(2907,1177,NULL,1657,1,'craft\\elements\\Entry',1,0,'2025-09-29 18:35:55','2025-09-29 18:35:55',NULL,NULL,NULL,'3f75ab05-805a-4abe-85f9-4a34dea3282e'),
(2908,2,NULL,1658,1,'craft\\elements\\Entry',1,0,'2025-09-29 18:58:54','2025-09-29 18:58:54',NULL,NULL,NULL,'0d0f2ff1-94f7-47fa-8745-cae920c54f12'),
(2909,1395,NULL,1659,1,'craft\\elements\\Entry',1,0,'2025-09-29 18:59:03','2025-09-29 18:59:03',NULL,NULL,NULL,'65f9351d-3861-4e4e-b8c4-0ba7bcd27cf2'),
(2910,111,NULL,1660,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'c650617a-b594-4e54-bb13-14156916f521'),
(2911,113,NULL,1661,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'8ff0adae-1d66-407c-b2d4-507013201ea6'),
(2912,115,NULL,1662,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'3c8788ed-8351-455c-8912-af7f8be15220'),
(2913,117,NULL,1663,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'3c5a81c9-23fb-47bd-a420-bf380ae636c1'),
(2914,119,NULL,1664,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'f0c843a5-4350-4870-8d2e-93e13170963b'),
(2915,121,NULL,1665,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'6e4d414d-af0d-4fef-8cc7-cb0f260209d4'),
(2916,555,NULL,1666,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'f734afe7-0719-4f17-9efd-5497f899accc'),
(2917,557,NULL,1667,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'e4fa05cf-72d2-4bcf-bfcc-b1acc0e5b588'),
(2918,559,NULL,1668,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'55a9d344-dde2-4d75-adb3-59c6074b104e'),
(2919,561,NULL,1669,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'01ebb8b5-bf52-4108-a1bd-8fe21e7f1855'),
(2920,563,NULL,1670,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'705b0518-0d58-4f65-8a29-0a6c118a99cb'),
(2923,1289,628,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-29 19:07:48','2025-09-29 19:07:48',NULL,NULL,NULL,'ba67bc1b-f872-475c-ade4-fb9b77c06d46'),
(2925,2891,NULL,1671,6,'craft\\elements\\Entry',1,0,'2025-09-29 19:09:02','2025-09-29 19:09:02',NULL,NULL,NULL,'bbc19e60-bda0-4ab7-85c4-2d59f464dc1c'),
(2927,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-30 19:28:01','2025-09-30 19:28:01',NULL,NULL,NULL,'09d388c7-0016-4619-997e-07c4fe87c800'),
(2929,2531,NULL,1672,12,'craft\\elements\\Entry',1,0,'2025-09-30 19:28:07','2025-09-30 19:28:07',NULL,NULL,NULL,'57b7f73d-8020-4985-9b65-0c3a40be891b'),
(2931,NULL,NULL,NULL,9,'craft\\elements\\Asset',1,0,'2025-09-30 22:22:11','2025-09-30 22:22:11',NULL,NULL,NULL,'d53e1dc0-a6fa-4ec6-b669-5a46d86a0c1f'),
(2933,NULL,NULL,NULL,9,'craft\\elements\\Asset',1,0,'2025-09-30 22:22:21','2025-09-30 22:22:21',NULL,NULL,NULL,'bbe1e0e2-b667-4e3b-be36-6e2bd1c32344'),
(2934,NULL,NULL,NULL,9,'craft\\elements\\Asset',1,0,'2025-09-30 22:22:35','2025-09-30 22:22:35',NULL,NULL,NULL,'7fda0972-eaa2-42f3-925e-2a9c367210b7'),
(2938,2,NULL,1673,1,'craft\\elements\\Entry',1,0,'2025-09-30 22:41:39','2025-09-30 22:41:39',NULL,NULL,NULL,'ddad6dd5-c5c8-4f75-8e26-bbb0ae786794'),
(2939,2791,NULL,1674,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:41:39','2025-09-30 22:41:39',NULL,NULL,NULL,'18e7b730-40a0-4fc8-ba3f-046afa3e7dcd'),
(2941,NULL,NULL,NULL,9,'craft\\elements\\Asset',1,0,'2025-09-30 22:43:05','2025-09-30 22:43:05',NULL,NULL,NULL,'cce62c0f-586e-43e7-8f0b-34dfec5796b5'),
(2945,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:18','2025-09-30 22:45:57',NULL,NULL,NULL,'f15f8b74-c868-460c-9e9d-dedc7a1b36f5'),
(2946,2,NULL,1675,1,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:18','2025-09-30 22:45:18',NULL,NULL,NULL,'f079aa0c-7131-43f7-a4fc-e520537806a7'),
(2947,2793,NULL,1676,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:18','2025-09-30 22:45:18',NULL,NULL,NULL,'dbab52c4-438b-4346-ba52-f1468cd206e1'),
(2948,2945,NULL,1677,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:18','2025-09-30 22:45:18',NULL,NULL,NULL,'e80b7480-2708-4d64-a239-5861e125a7c5'),
(2951,2,NULL,1678,1,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:57','2025-09-30 22:45:57',NULL,NULL,NULL,'d8a85eda-1c40-41ce-b7b3-b85805b4382b'),
(2952,2945,NULL,1679,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:57','2025-09-30 22:45:57',NULL,NULL,NULL,'940b2d3c-d38a-4a39-a33e-bb7e3b4f024e'),
(2955,2,NULL,1680,1,'craft\\elements\\Entry',1,0,'2025-09-30 22:46:11','2025-09-30 22:46:11',NULL,NULL,NULL,'f2a7b376-7741-4819-8105-22f757c51677'),
(2956,2793,NULL,1681,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:46:11','2025-09-30 22:46:11',NULL,NULL,NULL,'8753d74d-0fe8-4bcf-9d92-5af949f3572f'),
(2959,601,NULL,1682,5,'craft\\elements\\Entry',1,0,'2025-10-03 20:24:31','2025-10-03 20:24:31',NULL,NULL,NULL,'e7687068-e69a-4297-b2e5-fcb902e1c687'),
(2961,605,NULL,1683,5,'craft\\elements\\Entry',1,0,'2025-10-03 20:24:40','2025-10-03 20:24:40',NULL,NULL,NULL,'1901a062-005c-4ef8-a664-4a22001fe540'),
(2963,617,NULL,1684,5,'craft\\elements\\Entry',1,0,'2025-10-03 20:24:49','2025-10-03 20:24:49',NULL,NULL,NULL,'36142205-ddda-4d6f-9181-a7244c956373'),
(2965,1045,NULL,1685,1,'craft\\elements\\Entry',1,0,'2025-10-06 16:09:49','2025-10-06 16:09:49',NULL,NULL,NULL,'0d01d621-5e7c-4d0e-8fc5-d8e9fb5fa3bf'),
(2966,2712,NULL,1686,1,'craft\\elements\\Entry',1,0,'2025-10-06 16:09:59','2025-10-06 16:09:59',NULL,NULL,NULL,'f2f3b5ca-4b08-4fbd-8663-5e0200c78aa2'),
(2968,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-06 17:44:48','2025-10-06 17:45:01',NULL,NULL,NULL,'1e415e16-5d61-4b38-b4ca-eea293fa5718'),
(2969,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:45:32','2025-10-06 17:47:25',NULL,NULL,NULL,'7bd0e66d-ba6f-462c-b940-8a507312e64c'),
(2970,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-06 17:45:59','2025-10-08 18:24:15',NULL,NULL,NULL,'244b1cd5-9af2-47b0-8d0f-cbee1fa1da55'),
(2971,2969,NULL,1687,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:46:02','2025-10-06 17:46:02',NULL,NULL,NULL,'ac8cf22c-9eaf-4340-8e01-73f04dd1d98c'),
(2972,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:46:14','2025-10-08 18:21:43',NULL,NULL,NULL,'9852d22d-7977-41ef-b9e5-8434fd943927'),
(2973,2972,NULL,1688,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:46:44','2025-10-06 17:46:44',NULL,NULL,NULL,'94f173b2-a178-496a-a9cd-78f2d7103b55'),
(2974,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:46:46','2025-10-09 16:34:57',NULL,NULL,NULL,'f1a45e0b-97f6-484c-aaf9-862a950df77c'),
(2975,2974,NULL,1689,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:47:00','2025-10-06 17:47:00',NULL,NULL,NULL,'46992ec8-dc68-47f1-a296-3da03000f308'),
(2976,2969,NULL,1690,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:47:25','2025-10-06 17:47:25',NULL,NULL,NULL,'e7819822-f028-4ebe-a821-66f59652192f'),
(2977,2974,NULL,1691,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:47:42','2025-10-06 17:47:42',NULL,NULL,NULL,'88b5c63d-67e7-402f-b5aa-89de02497f86'),
(2983,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'dff524c0-f322-4745-a9c9-f3b1a7a4588d'),
(2984,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'2ebdb9f4-1f94-4e6c-a05b-10cb3360ed12'),
(2985,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'00ae0086-f18d-4c0b-9118-866e6ecc58c6'),
(2986,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'26553af5-fbad-4e27-bbc0-8e13aaae314e'),
(2987,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'b9d159c2-3e0f-4ef5-8399-7071afa15be8'),
(2988,945,NULL,1692,1,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'1492e223-e36b-4823-9c76-ec2d9ce8b232'),
(2989,2983,NULL,1693,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'d78404f0-6e13-4842-a760-a268ccc6ae9c'),
(2990,2984,NULL,1694,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'b744fdd6-07ef-4759-bfab-43a08b1eba16'),
(2991,2985,NULL,1695,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'7c45e2a2-eceb-48b8-88bf-090da2be04cc'),
(2992,2986,NULL,1696,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'19b60af6-db6e-46bc-8b9c-e30b283da145'),
(2993,2987,NULL,1697,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'dd01058a-36b5-4bee-bd58-7fd825444905'),
(2995,945,NULL,1698,1,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:49','2025-10-06 17:50:49',NULL,NULL,NULL,'f80dad38-a3d9-4ef1-8767-f4692e8f8a3e'),
(2999,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'55ab1db7-1e58-4e8a-a3bc-386a040bbcef'),
(3000,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'dd4bd306-e50b-40d3-8e5c-5322170d20f1'),
(3001,945,NULL,1699,1,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'bb2ef1ca-b53e-4a8f-b034-f075201f6237'),
(3002,2999,NULL,1700,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'30e97202-0552-4122-bc2a-fac3d13d209b'),
(3003,3000,NULL,1701,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'87a8c7fe-59b7-4473-b14a-5092baeb90dd'),
(3005,NULL,664,NULL,21,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:50','2025-10-06 17:51:50',NULL,NULL,NULL,'62f4ca57-c861-4beb-848f-8063faa17160'),
(3006,945,NULL,1702,1,'craft\\elements\\Entry',1,0,'2025-10-06 17:52:05','2025-10-06 17:52:05',NULL,NULL,NULL,'ac03093c-3750-4e39-a3d5-d0cb9f9a7859'),
(3009,957,NULL,1703,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:17:50','2025-10-08 18:17:50',NULL,NULL,NULL,'c20e5e52-00cf-4069-a1d3-149780a4fc3f'),
(3011,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 18:19:10','2025-10-08 18:19:10',NULL,NULL,NULL,'dc5c17f6-765e-48b3-85a8-55202a0faf0b'),
(3012,NULL,668,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:19:48','2025-10-08 18:19:48',NULL,NULL,NULL,'8aedb629-6fc8-471f-b6b1-c45c3808c572'),
(3014,2972,NULL,1704,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:21:43','2025-10-08 18:21:43',NULL,NULL,NULL,'f03c5430-813f-45f9-9bca-5aeb0f5c34bd'),
(3015,NULL,670,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:21:49','2025-10-08 18:21:49',NULL,NULL,NULL,'572fde05-b998-4a02-99e9-2f602364ea50'),
(3016,NULL,671,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:22:14','2025-10-08 18:22:24',NULL,NULL,NULL,'180780b3-2a96-4030-a27b-6e5392364481'),
(3017,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:26:16','2025-10-08 18:26:30',NULL,NULL,NULL,'13b67eac-63bd-408e-9f79-f0cf8847bc4b'),
(3018,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:26:55','2025-10-08 18:27:05',NULL,NULL,NULL,'c9a18e0b-fd23-4af0-8cc5-01e1b23e5954'),
(3019,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:28:08','2025-10-08 18:28:18',NULL,NULL,NULL,'24fb6028-a4fb-41b6-b9b9-8b60c849bba5'),
(3020,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:29:13','2025-10-08 18:30:02',NULL,NULL,NULL,'c7aaea27-9af3-4730-85a4-0bb39f7b4afa'),
(3021,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:30:50','2025-10-08 18:31:22',NULL,NULL,NULL,'5f8fe953-5abe-416d-a8da-0525c95105cd'),
(3022,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:31:41','2025-10-08 18:32:14',NULL,NULL,NULL,'8574977d-e956-4be2-8186-3a286b884e33'),
(3023,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:32:26','2025-10-08 18:32:47',NULL,NULL,NULL,'fc3421f8-4272-4d92-b724-eb867dbe405e'),
(3024,NULL,672,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:33:21','2025-10-08 18:33:21',NULL,NULL,NULL,'303eb696-94bd-4b23-b924-0caa70cf802b'),
(3025,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:34:47','2025-10-08 18:35:41',NULL,NULL,NULL,'195a0190-3c42-41ca-8040-a184e12e6ee4'),
(3026,3025,NULL,1705,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:35:41','2025-10-08 18:35:41',NULL,NULL,NULL,'5e21e4d4-d6dd-4493-a82e-2b438a591bad'),
(3027,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:35:57','2025-10-08 18:36:16',NULL,NULL,NULL,'a736b85e-4e04-40a9-94dc-c1cb48631e31'),
(3028,3027,NULL,1706,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:36:16','2025-10-08 18:36:16',NULL,NULL,NULL,'0cbea65c-66d1-4a48-9c8d-b6a33060b865'),
(3029,957,NULL,1707,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:36:38','2025-10-08 18:36:38',NULL,NULL,NULL,'24d1296e-21a5-40d5-8f8c-330bedf30467'),
(3036,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'8f123bf6-963c-448e-aed5-60d1334d9ccb'),
(3037,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'67491fc8-76c6-4a66-9c71-d5f44b50bab5'),
(3038,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'5ba542a2-ede0-43ca-8441-fef9aee3afea'),
(3039,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'4a14c1e3-6853-4034-8db5-394a882839ce'),
(3040,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'3cad777e-f3f6-4f1f-bc3b-d066f73de1df'),
(3041,957,NULL,1708,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'6bbf1680-c1e8-439b-b920-cf523ab91027'),
(3042,3036,NULL,1709,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'2e9ad6d6-f5e1-4ca8-9ddd-5b39dfab7c24'),
(3043,3037,NULL,1710,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'c7af399a-8d39-4bbc-ad83-5e85731cfca4'),
(3044,3038,NULL,1711,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'16e1ff19-1d0a-4427-8f65-1c452774cd6d'),
(3045,3039,NULL,1712,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'b80e5a21-7a15-42e5-a7ec-341b23efd69f'),
(3046,3040,NULL,1713,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'d28b2edb-8ca3-4906-bb56-43b2c0cead06'),
(3048,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 18:42:24','2025-10-08 18:42:24',NULL,NULL,NULL,'56a1fb3c-8b4d-4327-a5e6-511911c4a0ca'),
(3051,957,NULL,1714,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:43:12','2025-10-08 18:43:12',NULL,NULL,NULL,'f29e2170-5dda-4b5e-8959-38478e2c0f95'),
(3052,1504,NULL,1715,2,'craft\\elements\\Entry',1,0,'2025-10-08 18:43:12','2025-10-08 18:43:12',NULL,NULL,NULL,'35df403f-543c-4c6b-8c85-8f39d3dad9cb'),
(3053,1505,NULL,1716,2,'craft\\elements\\Entry',1,0,'2025-10-08 18:43:12','2025-10-08 18:43:12',NULL,NULL,NULL,'5fcd11d2-8b9f-463a-895a-6399cdbf6c7a'),
(3055,957,NULL,1717,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:43:42','2025-10-08 18:43:42',NULL,NULL,NULL,'503f8b07-4773-43b6-a2be-e40c28829ec5'),
(3058,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 18:44:46','2025-10-08 18:44:46',NULL,NULL,NULL,'054301c8-faa7-4c0f-a0d8-34aa2934601b'),
(3059,963,NULL,1718,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:46:53','2025-10-08 18:46:53',NULL,NULL,NULL,'9b0e7323-6207-40ae-a84e-b33acc52a043'),
(3066,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'b43aabfd-e6e5-4afe-892a-ec662230bf96'),
(3067,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'1172871b-3e60-4daa-b4b0-9158465c8bf0'),
(3068,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'bd49a00d-87bf-452c-963a-5a76a777c7fa'),
(3069,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'b67311d5-3f55-49b1-9aee-af4bf1cfc1dc'),
(3070,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'2cdf0ee4-1d10-4fd9-ad1a-7868205cc2dd'),
(3071,963,NULL,1719,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'0f830da5-13ec-4510-bd46-1d43b29c49ad'),
(3072,3066,NULL,1720,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'aacc9f96-b49f-4f94-8feb-6b8ca9b9e6e7'),
(3073,3067,NULL,1721,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'3a6b6d70-4f17-4cb1-98ec-26c233367544'),
(3074,3068,NULL,1722,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'c38d949b-8425-4112-9386-3b1c0a0a8bea'),
(3075,3069,NULL,1723,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'7763659b-af9b-4bba-86dc-ae4a23c5fe77'),
(3076,3070,NULL,1724,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'423df36c-6bec-48fa-a836-16ffdf6ab642'),
(3079,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:50:11','2025-10-08 18:50:11',NULL,NULL,NULL,'e1707b8c-e2eb-48f3-8374-c8cee50bf48b'),
(3080,963,NULL,1725,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:50:11','2025-10-08 18:50:11',NULL,NULL,NULL,'e1d5b1c0-df0e-46b6-93ac-c07b26796b1c'),
(3081,3079,NULL,1726,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:50:11','2025-10-08 18:50:11',NULL,NULL,NULL,'83151760-cf8b-495e-95d3-3b8ff0495a48'),
(3084,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 18:51:15','2025-10-08 18:51:29',NULL,NULL,NULL,'f9f86cbf-1eac-4ad0-b1b8-0c15e781282e'),
(3086,963,NULL,1727,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:52:55','2025-10-08 18:52:55',NULL,NULL,NULL,'beb5010d-47de-4e80-a0d6-ae4a8c284add'),
(3087,1509,NULL,1728,2,'craft\\elements\\Entry',1,0,'2025-10-08 18:52:55','2025-10-08 18:52:55',NULL,NULL,NULL,'e2b692bc-4bd5-48dc-b3c4-6cbaf69672c0'),
(3088,1510,NULL,1729,2,'craft\\elements\\Entry',1,0,'2025-10-08 18:52:55','2025-10-08 18:52:55',NULL,NULL,NULL,'ad119916-cade-4058-b3ce-0656f73664c7'),
(3090,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 18:53:49','2025-10-08 18:54:27',NULL,NULL,NULL,'232474b4-5e67-49ff-ad01-79e918687e9e'),
(3091,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:54:51','2025-10-08 18:55:24',NULL,NULL,NULL,'019e342e-cde0-4f5c-b2ce-50ffb09049eb'),
(3092,3091,NULL,1730,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:55:24','2025-10-08 18:55:24',NULL,NULL,NULL,'0a1427e4-62d4-4a32-8ee4-56a273508e21'),
(3093,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:55:36','2025-10-08 18:55:51',NULL,NULL,NULL,'d528be92-2b52-489a-8b53-7106c43b0536'),
(3094,3093,NULL,1731,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:55:51','2025-10-08 18:55:51',NULL,NULL,NULL,'f3f5f0b0-849c-442b-8b52-cd6de2b6af71'),
(3095,969,NULL,1732,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:56:08','2025-10-08 18:56:08',NULL,NULL,NULL,'be26992b-bedf-4f4f-864e-a98a3f00e202'),
(3102,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'21bda4c0-d863-48a2-abe5-26c081922e37'),
(3103,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'76995242-ad43-4bb7-8a3a-8da9ac50cff7'),
(3104,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'a7a33caf-632e-45a9-a668-26a09c3014b8'),
(3105,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'1f4362e1-f513-4665-b739-fb32290f369c'),
(3106,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'709eb709-f9f1-4b1b-90ec-dab090c098f2'),
(3107,969,NULL,1733,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'6a3a98db-d84e-4d72-8d01-caec80c4de80'),
(3108,3102,NULL,1734,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'0fc8cae8-f860-41af-a02a-75f8e31f310e'),
(3109,3103,NULL,1735,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'c410006b-7e18-4705-bc2a-8ec99da92639'),
(3110,3104,NULL,1736,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'3617ee59-b774-4f71-b7e1-9dd7ac0f9ba2'),
(3111,3105,NULL,1737,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'80f82d97-6bf7-459b-9d5d-f38ee04dae3c'),
(3112,3106,NULL,1738,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'d01acf0d-ee03-4c40-a561-f2285c001b37'),
(3114,969,NULL,1739,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:59:33','2025-10-08 18:59:33',NULL,NULL,NULL,'4505dfc3-6dbc-490e-9423-01eb64fdd2b2'),
(3118,969,NULL,1740,1,'craft\\elements\\Entry',1,0,'2025-10-08 19:00:47','2025-10-08 19:00:47',NULL,NULL,NULL,'629d38f3-0c11-4e07-ba26-b21476a62a68'),
(3119,1514,NULL,1741,2,'craft\\elements\\Entry',1,0,'2025-10-08 19:00:47','2025-10-08 19:00:47',NULL,NULL,NULL,'e818e493-afdb-48bd-bd1d-665393b576e8'),
(3120,1515,NULL,1742,2,'craft\\elements\\Entry',1,0,'2025-10-08 19:00:47','2025-10-08 19:00:47',NULL,NULL,NULL,'3bab0044-19a5-4343-8e69-48f89213b1d0'),
(3122,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 19:52:53','2025-10-08 19:52:53',NULL,NULL,NULL,'af87fd51-f341-4428-ac78-492fdb8c02c3'),
(3123,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 19:54:05','2025-10-08 19:54:15',NULL,NULL,NULL,'8f44127f-8524-4436-8a28-f1ac404fe254'),
(3124,3123,NULL,1743,5,'craft\\elements\\Entry',1,0,'2025-10-08 19:54:15','2025-10-08 19:54:15',NULL,NULL,NULL,'9dc88c62-70a3-43f3-b500-2b7bd82ab5db'),
(3125,975,NULL,1744,1,'craft\\elements\\Entry',1,0,'2025-10-08 19:54:49','2025-10-08 19:54:50',NULL,NULL,NULL,'830a7f17-8a35-4d63-a22c-942530733649'),
(3137,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 19:59:08','2025-10-08 19:59:08',NULL,NULL,NULL,'4ccceeae-e63e-45b0-8e79-e7c1920d31d3'),
(3138,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'059d822b-724e-4fcb-bc8d-7cd1fac7f86c'),
(3139,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'4a4ee3ac-31d1-47b5-8715-6ab4043d92e1'),
(3140,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'2810da40-ce95-4714-8200-76b5c0e4eede'),
(3141,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'7263269e-6321-4733-9d51-0677c821a91b'),
(3142,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'c3a826ba-826c-4dd6-a935-5841c40dd622'),
(3143,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'362500c9-bdf4-44a4-97a0-42826aded357'),
(3144,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'f114560b-6a15-4011-9841-8d43a9487a16'),
(3145,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'d7e50521-a96e-496a-a3b3-1d2c7ec9a4ef'),
(3146,975,NULL,1745,1,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'b0198c8f-b922-4014-b82c-2e61dd55659a'),
(3147,3138,NULL,1746,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'8421bd29-7ff6-436f-8f96-708fb36cae2d'),
(3148,3139,NULL,1747,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'880d66c3-15aa-4e43-bf1a-7eed1143eb86'),
(3149,3140,NULL,1748,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'15584359-b7df-4a67-9631-c7423eb7e1dd'),
(3150,3141,NULL,1749,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'31390b18-ac5d-400e-bbf8-5f5cd2e49593'),
(3151,3142,NULL,1750,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'84763762-27a3-4086-89da-a9cd825265ed'),
(3152,3143,NULL,1751,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'3bf2a799-08a3-4f11-aec7-e101d5749221'),
(3153,3144,NULL,1752,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'c06d50ef-9902-405b-b5de-ba80371aa240'),
(3154,3145,NULL,1753,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'0092bbb1-79d0-4298-aea9-0f3e3c6bcee0'),
(3155,1519,NULL,1754,2,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'e941ebf3-6905-4ba1-b1ab-f5ed79003139'),
(3156,1520,NULL,1755,2,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'2c914bdc-4a7b-4fd2-b110-08716b2af8b5'),
(3158,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 20:21:30','2025-10-08 20:22:26',NULL,NULL,NULL,'83b7d259-d0a6-4d99-9467-7abb85c36e23'),
(3159,981,NULL,1756,1,'craft\\elements\\Entry',1,0,'2025-10-08 20:22:53','2025-10-08 20:22:54',NULL,NULL,NULL,'bbf24774-8c10-43e6-9ee2-5d6fb8dcdee6'),
(3166,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'d34a4ef4-e951-41e0-9fb2-f4fbc873209e'),
(3167,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'87fdc99f-8de3-424a-b23b-a74240ea791a'),
(3168,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'abd946e5-2322-4f04-8ea9-b698d3ee5fe3'),
(3169,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'0ae280fb-3cb2-4f8c-8784-15b4465073a9'),
(3170,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'3e7195c7-e715-420c-842f-27fadf0cb033'),
(3171,981,NULL,1757,1,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'dea4d9dd-1b96-4a42-ab36-87998774d0d0'),
(3172,3166,NULL,1758,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'ba7cb77c-c80a-4a7b-8af7-e901ba51d019'),
(3173,3167,NULL,1759,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'8309ecbe-aa76-4b2b-af6d-f8585fc3da26'),
(3174,3168,NULL,1760,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'675e44df-d694-4d1b-b233-3309b32dd204'),
(3175,3169,NULL,1761,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'70d6cd9c-6db3-48f0-bcc1-de7521f44642'),
(3176,3170,NULL,1762,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'7d145633-87dc-4c7a-a107-7286d02ee50b'),
(3180,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 20:25:38','2025-10-08 20:25:38',NULL,NULL,NULL,'c68a7f61-7a3e-45ed-9bc2-3bd8c1f90fcf'),
(3182,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:58','2025-10-08 20:25:58',NULL,NULL,NULL,'6831c17a-4ed4-47be-a357-2d24c2601d49'),
(3183,981,NULL,1763,1,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:57','2025-10-08 20:25:58',NULL,NULL,NULL,'85386aa8-e38c-4514-be7d-0db0739049df'),
(3184,3182,NULL,1764,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:58','2025-10-08 20:25:58',NULL,NULL,NULL,'6cfe6525-108f-48d0-9a9b-cce2039e6cdc'),
(3185,1525,NULL,1765,2,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:58','2025-10-08 20:25:58',NULL,NULL,NULL,'bf934570-09ee-42f4-8fd7-fd6ac64c5f84'),
(3186,1526,NULL,1766,2,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:58','2025-10-08 20:25:58',NULL,NULL,NULL,'787aa8e9-d8bf-4aae-8d66-799555c5d52d'),
(3188,981,NULL,1767,1,'craft\\elements\\Entry',1,0,'2025-10-08 20:26:01','2025-10-08 20:26:01',NULL,NULL,NULL,'5e8d679a-823e-454c-8b16-a5e31d9015c3'),
(3189,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Form',1,0,'2025-10-08 22:17:51','2025-10-23 01:16:23',NULL,NULL,NULL,'fe2e5e5e-abbd-4561-a3ba-37026f922a57'),
(3190,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Form',1,0,'2025-10-08 22:17:57','2025-10-23 01:16:40',NULL,NULL,NULL,'a86c2379-7dd0-4176-b497-17774e589315'),
(3191,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Form',1,0,'2025-10-08 22:18:05','2025-10-23 01:15:27',NULL,NULL,NULL,'0eb29f3f-cbde-4407-be4f-b02acee98449'),
(3192,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:49','2025-10-08 22:18:56',NULL,NULL,NULL,'fdcf5c6f-b728-447f-8c82-fbb551b5226e'),
(3193,3192,NULL,1768,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:56','2025-10-08 22:18:56',NULL,NULL,NULL,'cb42d871-81de-45fc-b52b-366d6efc1a2f'),
(3194,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:56','2025-10-08 22:18:59',NULL,NULL,NULL,'7f438e6a-e1fa-4e24-a2e9-1648ba399aa6'),
(3195,3194,NULL,1769,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:59','2025-10-08 22:18:59',NULL,NULL,NULL,'5c0344c3-000b-4c15-a977-80d3684def8a'),
(3196,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:59','2025-10-08 22:19:01',NULL,NULL,NULL,'742c6231-be5b-4f77-90a7-29083f2c688e'),
(3197,3196,NULL,1770,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:01','2025-10-08 22:19:01',NULL,NULL,NULL,'bc745dd8-db76-458d-83f9-102dbf55ff21'),
(3198,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:01','2025-10-08 22:19:04',NULL,NULL,NULL,'62fa409a-ca19-4c74-abe3-38b7808d8d7a'),
(3199,3198,NULL,1771,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:04','2025-10-08 22:19:04',NULL,NULL,NULL,'3fd9cb80-d945-4673-97b4-2752ad48de06'),
(3200,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:04','2025-10-08 22:19:06',NULL,NULL,NULL,'c1356cab-a204-400c-b6ed-106236a55ace'),
(3201,3200,NULL,1772,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:06','2025-10-08 22:19:06',NULL,NULL,NULL,'f1f30280-8da4-45d1-93ad-b1bf87fc1a99'),
(3202,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:06','2025-10-08 22:19:10',NULL,NULL,NULL,'14c7ade6-f49b-47cd-adb2-9ed996427e7b'),
(3203,3202,NULL,1773,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:10','2025-10-08 22:19:10',NULL,NULL,NULL,'23f72963-e31d-4c68-9d75-c88b1eba4ef1'),
(3204,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:10','2025-10-08 22:19:13',NULL,NULL,NULL,'5fe38de9-ef00-4a60-9edb-199aba2abeb0'),
(3205,3204,NULL,1774,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:13','2025-10-08 22:19:13',NULL,NULL,NULL,'457314c2-9b4a-48fc-b2ee-58acf9211588'),
(3206,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:13','2025-10-08 22:19:15',NULL,NULL,NULL,'21831c2c-63e7-4c73-8d71-b4382d343ec1'),
(3207,3206,NULL,1775,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:15','2025-10-08 22:19:15',NULL,NULL,NULL,'671b7251-dc16-4097-b83c-9180d0e36bc7'),
(3208,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:15','2025-10-08 22:19:18',NULL,NULL,NULL,'267ab4a4-242c-4556-adb9-da28988d3814'),
(3209,3208,NULL,1776,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:18','2025-10-08 22:19:18',NULL,NULL,NULL,'dfb00755-2955-4c8e-ad3a-bd157298da31'),
(3210,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:18','2025-10-08 22:19:21',NULL,NULL,NULL,'70a9acfe-dd17-46ba-a43c-181ef4e6f3eb'),
(3211,3210,NULL,1777,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:21','2025-10-08 22:19:21',NULL,NULL,NULL,'48dbcb6a-94b7-41d3-94e0-46747c6ed15d'),
(3212,945,NULL,1778,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:59','2025-10-08 22:19:59',NULL,NULL,NULL,'a39dd38b-4c13-4b7c-abea-a9c5fe7b968b'),
(3213,1255,NULL,1779,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:05','2025-10-08 22:20:05',NULL,NULL,NULL,'4b1aa3be-d0d8-416f-8609-420070e42fd8'),
(3214,2,NULL,1780,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:09','2025-10-08 22:20:09',NULL,NULL,NULL,'80636f1b-7665-4338-b68a-ec4787e8b947'),
(3216,2,NULL,1781,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:12','2025-10-08 22:20:12',NULL,NULL,NULL,'f86e3dc2-543a-4c52-b5aa-e3327f08f7ef'),
(3217,1165,NULL,1782,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:15','2025-10-08 22:20:15',NULL,NULL,NULL,'47659f3a-d549-4f3b-9a63-9108d9807044'),
(3218,957,NULL,1783,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:19','2025-10-08 22:20:19',NULL,NULL,NULL,'62d4ca5a-ce2c-4855-856b-11bad1d37709'),
(3219,2720,NULL,1784,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:23','2025-10-08 22:20:23',NULL,NULL,NULL,'132a0129-be0e-4488-9bc9-8637e1c22948'),
(3221,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 22:21:38','2025-10-08 22:21:38',NULL,NULL,NULL,'bdc16f15-f46f-4437-8456-4f61d3a02e89'),
(3223,951,NULL,1785,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:21:46','2025-10-08 22:21:46',NULL,NULL,NULL,'d79aa478-10ab-42d4-9220-d3d3683b044e'),
(3224,1499,NULL,1786,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:21:46','2025-10-08 22:21:46',NULL,NULL,NULL,'8929c7c6-6dea-4018-8d44-290bb8663880'),
(3235,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:24:18','2025-10-08 22:24:18',NULL,NULL,NULL,'627b2b6b-1518-430e-998b-bf5c8934774e'),
(3236,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:24:35','2025-10-08 22:24:35',NULL,NULL,NULL,'b5404ca1-c473-44f8-a42f-4eddf48b474c'),
(3237,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:24:46','2025-10-08 22:24:46',NULL,NULL,NULL,'9bd95623-c874-426e-afde-5af3089ba860'),
(3238,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:24:57','2025-10-08 22:24:57',NULL,NULL,NULL,'560a5bc7-8092-43fb-92dc-2a33924dce10'),
(3239,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:07','2025-10-08 22:25:07',NULL,NULL,NULL,'c322f018-7d22-4eb0-b96b-1e4f4c964427'),
(3240,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:18','2025-10-08 22:25:18',NULL,NULL,NULL,'1a74ea73-9636-466d-8569-5f588f575f87'),
(3241,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:29','2025-10-08 22:25:29',NULL,NULL,NULL,'95dfc41f-cf70-4f09-9316-e6f5e0450622'),
(3242,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:38','2025-10-08 22:25:38',NULL,NULL,NULL,'6de533ef-4635-4f28-b60d-49fcc57c4a3d'),
(3243,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:45','2025-10-08 22:25:45',NULL,NULL,NULL,'21d30ca9-2dc4-4472-a21a-e52d0e486570'),
(3244,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:47','2025-10-08 22:25:47',NULL,NULL,NULL,'22d78448-056c-46a4-a7ca-839f4fd4d268'),
(3245,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:37','2025-10-08 22:28:37',NULL,NULL,NULL,'9733e01e-92e1-409e-a13c-25f7a5b85d16'),
(3246,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:39','2025-10-08 22:28:39',NULL,NULL,NULL,'71a8753e-1f70-4071-8e74-fd3ed12702ca'),
(3247,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:40','2025-10-08 22:28:40',NULL,NULL,NULL,'fa897fc0-44eb-45bf-93d4-c784a7e678d0'),
(3248,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:40','2025-10-08 22:28:40',NULL,NULL,NULL,'4a1dcc5f-11a4-497c-a7b9-1fe32fd4b2e3'),
(3249,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:41','2025-10-08 22:28:41',NULL,NULL,NULL,'73ea64cc-e552-4ff7-a7aa-f043ac594c5e'),
(3250,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:42','2025-10-08 22:28:42',NULL,NULL,NULL,'6c862239-0290-449b-8c2e-e15b87bb2df6'),
(3251,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:43','2025-10-08 22:28:43',NULL,NULL,NULL,'4a00740d-2bfd-4662-a6f9-cb5f4348fced'),
(3252,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:43','2025-10-08 22:28:43',NULL,NULL,NULL,'241cfdf9-ee01-4999-8ccc-1201776b31ee'),
(3253,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:44','2025-10-08 22:28:44',NULL,NULL,NULL,'96d62528-d0e1-4e65-8c8c-2acdaeff7745'),
(3254,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:45','2025-10-08 22:28:45',NULL,NULL,NULL,'bfb466e7-af2b-40e0-a112-e03a3666daf1'),
(3255,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'cb0037a3-1a81-4fc5-8c12-4b958b69b0ad'),
(3256,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'869c3b32-0a9e-4114-ba10-ce54e2ee774f'),
(3257,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'3af8d3b0-3cc3-4b0d-ac91-c3f0f1f90897'),
(3258,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'926da004-87c3-4218-b38e-d6392e6b5953'),
(3259,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'3a54dcc4-f16a-48de-87d9-39254d852dbc'),
(3260,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'684bb1bd-2c75-48c3-b747-e40a1c53f889'),
(3261,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'231ebd46-582a-4308-8b39-55fe0546ae63'),
(3262,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'3204721d-8dd0-4be7-8087-109eadc1ce4f'),
(3263,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'ea58d1bd-ea2e-42ac-973f-f4ab5165e693'),
(3264,951,NULL,1787,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'a6925da7-5d11-4581-94d3-eea1dbceb565'),
(3265,3255,NULL,1788,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'ed1f1483-71dd-4017-b820-aa352dc2419f'),
(3266,3256,NULL,1789,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'099bdd28-edef-4603-8fa3-c74521ac9cfd'),
(3267,3257,NULL,1790,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'92047dd5-dec8-4ae3-9d86-cad05f375f02'),
(3268,3258,NULL,1791,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'045335df-424c-4979-ae80-535040f6ee9f'),
(3269,3259,NULL,1792,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'0a99e62f-d788-4324-9f38-34aad42587b4'),
(3270,3260,NULL,1793,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'974c7b3a-2d4f-4dec-8e8a-e1982e379a40'),
(3271,3261,NULL,1794,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'bfc41e73-5d62-4f56-8c15-4fb7d010d7e1'),
(3272,3262,NULL,1795,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'8e53431c-1e44-49d8-a41f-f14f4494c16b'),
(3273,3263,NULL,1796,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'779f531d-dd18-47a1-998d-3fc8ca698806'),
(3275,951,NULL,1797,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:29:34','2025-10-08 22:29:34',NULL,NULL,NULL,'4cf2679c-1e0e-4e8d-ac48-26cbd4dd71c1'),
(3276,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:31','2025-10-08 22:32:31',NULL,NULL,NULL,'aca06e20-47e4-4040-8414-8b3f22ba5765'),
(3278,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:34','2025-10-08 22:32:34',NULL,NULL,NULL,'d156ddf6-c740-4d5b-b58e-a7f63b1effa7'),
(3279,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:35','2025-10-08 22:32:35',NULL,NULL,NULL,'4f48001b-13a2-4b9e-87a8-6b6209e7f9e2'),
(3280,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:37','2025-10-08 22:32:37',NULL,NULL,NULL,'c8cfa90c-a527-4ad9-a684-4de68ee14df5'),
(3281,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:38','2025-10-08 22:32:38',NULL,NULL,NULL,'d8ad29b5-965c-462d-b8a9-ee4d77b0155e'),
(3282,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:40','2025-10-08 22:32:40',NULL,NULL,NULL,'31fb1537-f558-483f-b21d-d697983bf9e6'),
(3283,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:41','2025-10-08 22:32:41',NULL,NULL,NULL,'b730aeaa-4638-4f08-b8ff-6de3ff1625d2'),
(3284,2880,NULL,1798,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:32:49','2025-10-08 22:32:49',NULL,NULL,NULL,'58f0cd84-0616-4aa1-af03-c08cdba9af77'),
(3286,2880,NULL,1799,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:18','2025-10-08 22:33:18',NULL,NULL,NULL,'427848f1-64a1-4f1c-9dcb-11e04c74dbee'),
(3292,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'33c86f5d-fcf9-4953-995e-0ae40ee2484e'),
(3293,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'faecdb87-ed68-4322-822f-c4c743e8c4ff'),
(3294,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'d2c3740c-ae0a-4a8b-bef7-754430631cda'),
(3295,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'18acd8a1-72cf-4c59-ae41-98d7d35dcce5'),
(3296,2880,NULL,1800,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'506cf3f6-e40f-4abf-80bb-4f3f2c66014c'),
(3297,3292,NULL,1801,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:46',NULL,NULL,NULL,'10b4c630-fa31-4051-b6c3-b4e94df607c9'),
(3298,3293,NULL,1802,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:46',NULL,NULL,NULL,'d1498675-49a4-43f4-adf9-2b1d2154356d'),
(3299,3294,NULL,1803,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:46',NULL,NULL,NULL,'9f5fea88-14c7-443e-a686-ef834ef6c758'),
(3300,3295,NULL,1804,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:46',NULL,NULL,NULL,'76907b6b-16e8-486f-be6d-4ae5620742af'),
(3303,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:34:45','2025-10-08 22:34:45',NULL,NULL,NULL,'d661a50d-4334-4ddb-81be-4bd4ac48c934'),
(3304,2880,NULL,1805,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:34:45','2025-10-08 22:34:45',NULL,NULL,NULL,'b73fa99b-9207-417a-8eb0-7195479484ad'),
(3305,3303,NULL,1806,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:34:45','2025-10-08 22:34:45',NULL,NULL,NULL,'850cf421-3270-4edb-aa4b-34a3557413c1'),
(3308,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:10','2025-10-08 22:35:10',NULL,NULL,NULL,'dc424e0e-0c44-4684-977b-6bbb15e03bae'),
(3309,2880,NULL,1807,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:10','2025-10-08 22:35:10',NULL,NULL,NULL,'8c8e9f9c-5a22-43ed-ab88-e0a63102b044'),
(3310,3308,NULL,1808,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:10','2025-10-08 22:35:10',NULL,NULL,NULL,'3cd5fa52-ec18-4ce2-8817-1ce0591b6548'),
(3316,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'8969d108-e7d5-4546-96c7-01326ddffe7b'),
(3317,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'36b4f8bc-082c-4c26-86fe-a5a5f01e024f'),
(3318,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'7b34198e-87ce-4d20-9421-e4f3ff211698'),
(3319,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'f773fd54-576e-4109-a8e5-f04b3e27935f'),
(3320,2880,NULL,1809,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'3a962400-24ea-4a9c-8472-3ff801ea24da'),
(3321,3316,NULL,1810,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:47',NULL,NULL,NULL,'6fc19b16-934e-495a-961a-dd5549b40cbf'),
(3322,3317,NULL,1811,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:47',NULL,NULL,NULL,'4efc2a03-eb60-4910-ad3f-2033d80152d6'),
(3323,3318,NULL,1812,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:47',NULL,NULL,NULL,'f30893d9-052e-42ee-896a-57854d88e1db'),
(3324,3319,NULL,1813,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:47',NULL,NULL,NULL,'1f24e35e-22a1-4e7b-878a-5ac10367ae21'),
(3335,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'7e8b5496-fedf-4a84-bd26-064fe6c1b823'),
(3336,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'5f114127-ecf5-4041-a894-9ac71e46daa1'),
(3337,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'4cee0710-f8bc-4b56-b361-9798733a7552'),
(3338,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'ed8efdf6-38db-4c67-b4cf-ec8edbfa9a81'),
(3339,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'97d938f6-1902-4675-8115-424195284649'),
(3340,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'5188fac9-9e32-48d1-9f3f-3d799283a888'),
(3341,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'47e4702d-6092-4623-9b1c-4ae764aa3ccb'),
(3342,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'856794d9-80d9-4788-bcf2-8860a036d87a'),
(3343,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'fd190f6f-3cf6-42d9-b3c9-671afd744f7a'),
(3344,1353,NULL,1814,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'22eac443-6e38-4647-bfcc-2ceed65d0cdf'),
(3345,3335,NULL,1815,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'18607dcf-65e1-41ad-989a-a815d4d8d52f'),
(3346,3336,NULL,1816,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'cac4758b-5a46-4fc2-b48d-770426c52c91'),
(3347,3337,NULL,1817,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'5750e4c6-f430-4e13-b15d-4115d7a5cb40'),
(3348,3338,NULL,1818,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'a10bdd20-d263-4f02-8ede-e0da2694cf55'),
(3349,3339,NULL,1819,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'f949e1ea-175c-4582-862b-73a418fa87f5'),
(3350,3340,NULL,1820,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'f56073cb-d456-4ea0-80e4-aedcac8152eb'),
(3351,3341,NULL,1821,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'70888f46-5ee1-4d3b-9694-8f4a56f09a9f'),
(3352,3342,NULL,1822,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'0334185d-fb7f-4679-80fe-7192e4313936'),
(3353,3343,NULL,1823,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'51a63420-3e24-4b8d-9641-92445926349a'),
(3356,1353,NULL,1824,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:45','2025-10-08 22:38:45',NULL,NULL,NULL,'9fb9ec2c-3156-491a-b7e8-c4ba46690569'),
(3357,1835,NULL,1825,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:45','2025-10-08 22:38:45',NULL,NULL,NULL,'b819b9d7-247e-45d7-9f34-6833e4417e06'),
(3359,1353,NULL,1826,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:40:25','2025-10-08 22:40:25',NULL,NULL,NULL,'ace0a890-89d0-4b09-9eb7-044c82db1153'),
(3361,NULL,776,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:40:33','2025-10-08 22:40:33',NULL,NULL,NULL,'b107e934-b037-4e02-b2d1-e4f0169aa197'),
(3362,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:49','2025-10-08 22:40:49',NULL,NULL,NULL,'1b4870ed-c6ab-486e-84e6-846e8c82c76c'),
(3363,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:50','2025-10-08 22:40:50',NULL,NULL,NULL,'91f91620-da2c-4c51-a168-96f9397c3a6f'),
(3364,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:50','2025-10-08 22:40:50',NULL,NULL,NULL,'ed703b69-c26d-4fba-ad46-061978e899a6'),
(3365,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:51','2025-10-08 22:40:51',NULL,NULL,NULL,'843bf451-ea46-4e9b-8b0a-f4bd4912be4c'),
(3366,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:52','2025-10-08 22:40:52',NULL,NULL,NULL,'6805b5fb-6934-4a9b-b066-e113dbd18328'),
(3367,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:53','2025-10-08 22:40:53',NULL,NULL,NULL,'4ea78724-356d-4120-8b75-4a8b6fb13915'),
(3368,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:54','2025-10-08 22:40:54',NULL,NULL,NULL,'3ea5d451-bdb3-42da-a846-c469b07af340'),
(3369,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:54','2025-10-08 22:40:54',NULL,NULL,NULL,'13f5695f-b44d-4804-aa0e-e68d4a79372f'),
(3370,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:56','2025-10-08 22:40:56',NULL,NULL,NULL,'3e8998bb-8848-4315-aecc-63e6f5c989f0'),
(3371,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:57','2025-10-08 22:40:57',NULL,NULL,NULL,'a8513575-6827-4572-9e6d-b8fee7475225'),
(3372,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:59','2025-10-08 22:40:59',NULL,NULL,NULL,'512e185b-aec6-4a21-ac73-5602efb36dc0'),
(3373,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:41:00','2025-10-08 22:41:00',NULL,NULL,NULL,'79ff754c-990d-424b-84bf-15780ecf449a'),
(3374,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:41:02','2025-10-08 22:41:02',NULL,NULL,NULL,'be86a4ca-1d97-4506-8e55-b23028646685'),
(3375,1353,NULL,1827,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:41:35','2025-10-08 22:41:35',NULL,NULL,NULL,'31e28523-5181-4da7-a3d1-16fc7a2d23d3'),
(3377,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 14:40:18','2025-10-09 14:40:35',NULL,NULL,NULL,'a2e401dd-b7b3-406b-92b7-949f212de674'),
(3378,989,NULL,1828,1,'craft\\elements\\Entry',1,0,'2025-10-09 14:50:00','2025-10-09 14:50:00',NULL,NULL,NULL,'95459cf8-461f-4440-8560-13f45fe6be2b'),
(3385,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'5bac949d-a46d-4ded-993b-e8b90806b96f'),
(3386,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'4a92b04b-d692-4ca9-a373-d08b3f8f29d9'),
(3387,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'346b8250-c6af-4afb-8789-c5178d2b80ac'),
(3388,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'fc121df5-eef0-4c66-87e5-65a2358a74e6'),
(3389,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'9f94b8e1-f51d-42aa-b8e4-816969d0c359'),
(3390,989,NULL,1829,1,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'c7f87614-9b3f-4bc3-b8ed-abf52036b258'),
(3391,3385,NULL,1830,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'3f979fa2-063f-431b-ad04-2de15edfe681'),
(3392,3386,NULL,1831,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'1651373a-2219-4a68-87be-aa1004d9d7af'),
(3393,3387,NULL,1832,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'a5562963-50b6-46b4-87d9-000a9c418bca'),
(3394,3388,NULL,1833,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'6feeb8eb-4364-4a77-9311-9e9998e30d76'),
(3395,3389,NULL,1834,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:52:39','2025-10-09 14:52:39',NULL,NULL,NULL,'2db1c4f1-8bbe-490b-9498-33c1f39dcae9'),
(3397,989,NULL,1835,1,'craft\\elements\\Entry',1,0,'2025-10-09 14:53:20','2025-10-09 14:53:20',NULL,NULL,NULL,'98b88d7d-b0bd-4610-86ce-e01dd79d2bf6'),
(3403,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:47',NULL,NULL,NULL,'3bd68452-554a-4b19-bb92-9b3254b147f8'),
(3404,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:47',NULL,NULL,NULL,'77c79f40-cdc4-4454-8f77-4a21643d469a'),
(3405,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:47',NULL,NULL,NULL,'c1abf041-a20f-4494-b980-820bb73e3181'),
(3406,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:47',NULL,NULL,NULL,'4d1f6694-bd10-4010-a9fd-25d0736178a8'),
(3407,989,NULL,1836,1,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:47',NULL,NULL,NULL,'b47e0b82-e853-4dbd-87ed-94bb923deb18'),
(3408,3403,NULL,1837,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:47',NULL,NULL,NULL,'3cdb861b-fedf-43ed-910c-e714482161eb'),
(3409,3404,NULL,1838,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:48',NULL,NULL,NULL,'ebcc1ea3-645d-4894-a35a-e77961f17810'),
(3410,3405,NULL,1839,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:48',NULL,NULL,NULL,'1eb85fd3-d2c5-4c69-9ec5-840d2de21ace'),
(3411,3406,NULL,1840,3,'craft\\elements\\Entry',1,0,'2025-10-09 14:54:47','2025-10-09 14:54:48',NULL,NULL,NULL,'f3fd0b74-beb2-4158-800f-46ae81c9d342'),
(3413,989,NULL,1841,1,'craft\\elements\\Entry',1,0,'2025-10-09 14:58:54','2025-10-09 14:58:54',NULL,NULL,NULL,'d1e2ed20-5672-41f3-a7e6-e6c7541673ba'),
(3416,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 14:59:18','2025-10-09 14:59:18',NULL,NULL,NULL,'3985500b-f08c-43c8-b70f-dc76d06625b0'),
(3418,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 14:59:46','2025-10-09 14:59:46',NULL,NULL,NULL,'7183b6ff-7b93-4eab-a229-f0afc34b7046'),
(3419,989,NULL,1842,1,'craft\\elements\\Entry',1,0,'2025-10-09 14:59:55','2025-10-09 14:59:55',NULL,NULL,NULL,'6a86f8b8-cab6-4b2f-9772-b601393b4b89'),
(3420,1531,NULL,1843,2,'craft\\elements\\Entry',1,0,'2025-10-09 14:59:55','2025-10-09 14:59:55',NULL,NULL,NULL,'be0cdc78-0a56-4fb8-b998-077d76bce9ed'),
(3421,1532,NULL,1844,2,'craft\\elements\\Entry',1,0,'2025-10-09 14:59:55','2025-10-09 14:59:55',NULL,NULL,NULL,'c6bfc81e-7e24-4cfb-98a0-4823f26ea794'),
(3423,989,NULL,1845,1,'craft\\elements\\Entry',1,0,'2025-10-09 15:36:03','2025-10-09 15:36:03',NULL,NULL,NULL,'a770cda6-6715-42dc-a2ff-81a9751877cc'),
(3425,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 16:20:09','2025-10-09 16:20:23',NULL,NULL,NULL,'018ea585-8010-473e-8a32-4cbf4cbcaa10'),
(3431,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'4e1ee282-f15e-4d54-b4ed-395c31690453'),
(3432,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'25ed1b2e-0d99-4a29-b676-7951432f185c'),
(3433,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'fa0d710a-774d-4738-a884-92160e5d37d2'),
(3434,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'e82ca79b-0c06-43aa-919d-09538cba2d7d'),
(3435,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'b714b652-80d9-4f2c-a384-b970473e83a8'),
(3436,995,NULL,1846,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'2b77ad52-3fad-4488-9afe-680a7460cb0a'),
(3437,3431,NULL,1847,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'fed601b6-7f01-48b4-8fdd-8480a5f9b22e'),
(3438,3432,NULL,1848,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'08cc0e9e-b059-4903-b539-b0276500ad1d'),
(3439,3433,NULL,1849,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'42f70d31-eb8e-4050-b044-804ba67695e6'),
(3440,3434,NULL,1850,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'36bdf469-91a3-4835-8264-72328ce9663d'),
(3441,3435,NULL,1851,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:25:17','2025-10-09 16:25:17',NULL,NULL,NULL,'f4806e7b-fe6e-49d3-9e5f-847308966bb8'),
(3443,995,NULL,1852,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:29:17','2025-10-09 16:29:17',NULL,NULL,NULL,'7a1cee7a-e42f-4a3d-8d4c-19c3d85ae593'),
(3450,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'42f9236b-0437-42af-9478-7d80b9fe4e82'),
(3451,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'2400b99c-4ac8-4cc5-8621-320562393f18'),
(3452,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'b0562da9-378f-4add-a6ec-bee759a2c9fe'),
(3453,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'617e20cb-c418-49d2-a76b-c27e14350fc5'),
(3454,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'6e7681e6-8d64-48f6-bfe7-f05cb4750f1b'),
(3455,995,NULL,1853,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'8841635f-8616-4039-b5af-7ff7c38f1299'),
(3456,3450,NULL,1854,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'44822184-b243-481f-bea2-c3384026dc78'),
(3457,3451,NULL,1855,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'838c8104-853e-4a22-b101-0ef35d9a9440'),
(3458,3452,NULL,1856,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'df7ff97c-8bc6-4b0e-9559-bf97c46a2e6c'),
(3459,3453,NULL,1857,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'422a6c5d-be6e-408f-ab85-1e09d3afa186'),
(3460,3454,NULL,1858,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:30:48','2025-10-09 16:30:48',NULL,NULL,NULL,'a8c076f1-3128-4686-8cea-198a6863bc3e'),
(3463,995,NULL,1859,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:31:32','2025-10-09 16:31:32',NULL,NULL,NULL,'9e3e7b94-90a6-4eaa-877a-a0fe54290128'),
(3464,1536,NULL,1860,2,'craft\\elements\\Entry',1,0,'2025-10-09 16:31:32','2025-10-09 16:31:32',NULL,NULL,NULL,'72a36f56-4453-4270-a196-ea6835c3fd89'),
(3465,995,NULL,1861,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:31:37','2025-10-09 16:31:37',NULL,NULL,NULL,'fad055cd-029c-49ca-afa0-fd45132c8b9b'),
(3467,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 16:32:33','2025-10-09 16:32:41',NULL,NULL,NULL,'ff247821-2679-45c4-a657-fe1bb5d3dcb2'),
(3468,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-09 16:33:29','2025-10-09 16:33:43',NULL,NULL,NULL,'6360faac-521b-40ee-8abd-0fba7e83f8e8'),
(3469,3468,NULL,1862,5,'craft\\elements\\Entry',1,0,'2025-10-09 16:33:43','2025-10-09 16:33:43',NULL,NULL,NULL,'f1830387-fd43-48a3-9c57-0b43a76ece7e'),
(3471,2974,NULL,1863,5,'craft\\elements\\Entry',1,0,'2025-10-09 16:34:57','2025-10-09 16:34:57',NULL,NULL,NULL,'20c02a0d-6596-4748-a355-2a519fc45bb7'),
(3472,999,NULL,1864,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:34:59','2025-10-09 16:34:59',NULL,NULL,NULL,'d0df8df0-d3a5-410d-aab7-e2ba46c34bac'),
(3479,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'9f84783a-7d61-4ab7-baeb-b99817079b5f'),
(3480,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'1d8b1a93-7f28-4a6d-b5ff-051afe358f44'),
(3481,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'c368d4ba-d32b-4567-99e4-5b4daf8b8c1a'),
(3482,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'0af9bec1-fe2f-4691-9628-30aa98d8abcf'),
(3483,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'79d4af48-b026-48a4-bd94-1aa8c27e4fdd'),
(3484,999,NULL,1865,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'ad1e1457-b031-4c04-88a0-b1e6d7f65521'),
(3485,3479,NULL,1866,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'58cd5e75-de1d-44a2-a7ef-03d5812de62a'),
(3486,3480,NULL,1867,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'91c7cbfc-3e92-4ac4-a85b-1b5f40625a7a'),
(3487,3481,NULL,1868,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'e2553962-27d2-47c4-826a-ee1df376933d'),
(3488,3482,NULL,1869,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'3c83e31c-d901-4df2-ad9d-702ad7d6df88'),
(3489,3483,NULL,1870,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:27','2025-10-09 16:36:27',NULL,NULL,NULL,'d4ba0c40-16c5-4b05-a735-9256efa7ed3e'),
(3491,999,NULL,1871,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:36:52','2025-10-09 16:36:52',NULL,NULL,NULL,'e85dd643-ad35-494f-8440-e9ef7ad2db20'),
(3494,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 16:37:14','2025-10-09 16:37:14',NULL,NULL,NULL,'beb72bf0-7900-478a-a858-6a6fc664a24f'),
(3495,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 16:37:24','2025-10-09 16:37:50',NULL,NULL,NULL,'b4c6ff02-f95d-4291-9840-29837cb64bfc'),
(3498,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 16:38:58','2025-10-09 16:39:11',NULL,NULL,NULL,'6b60157f-fd52-46ea-aad4-2d078a788dc4'),
(3499,1005,NULL,1872,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:40:04','2025-10-09 16:40:04',NULL,NULL,NULL,'9a3f4d62-6d94-448c-843e-2147d2e8e81a'),
(3506,NULL,830,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:41:35','2025-10-09 16:41:35',NULL,NULL,NULL,'94069173-f817-4a3e-a9ab-e54b564fd570'),
(3507,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'fc45669f-48b3-4943-a77e-9dd4730acf75'),
(3508,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'10e57df8-098e-4525-98c3-7c0dc1ebd0c9'),
(3509,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'4714385a-c300-44d9-b595-a8b88508f7d1'),
(3510,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'5345b10d-db17-4f93-96ec-4ce3590bd774'),
(3511,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'c895075f-f08f-4889-9b39-6e85151d1e38'),
(3512,1005,NULL,1873,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'502af62e-1034-4287-8e87-7c3cfbf54c75'),
(3513,3507,NULL,1874,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'83c45288-512c-4457-b230-7ba60acbf47d'),
(3514,3508,NULL,1875,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'1896a8ac-f85e-4452-8ea5-c994c2d2774b'),
(3515,3509,NULL,1876,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'dabc496b-5f20-4d5d-8f61-630a793bf332'),
(3516,3510,NULL,1877,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'6b744f56-c1cd-4035-854e-19c296f39f95'),
(3517,3511,NULL,1878,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:02','2025-10-09 16:42:02',NULL,NULL,NULL,'bb5c4b90-761d-47fb-b7f8-c52cf34d7711'),
(3522,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:54','2025-10-09 16:42:54',NULL,NULL,NULL,'62b9a044-3045-4689-9eb4-6acd4dc246b9'),
(3523,1005,NULL,1879,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:54','2025-10-09 16:42:54',NULL,NULL,NULL,'86f88adb-9bd3-4eb4-8339-dd0590ea6c9d'),
(3524,3522,NULL,1880,3,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:54','2025-10-09 16:42:55',NULL,NULL,NULL,'26d90215-18b6-4521-899c-a53a72505960'),
(3525,1544,NULL,1881,2,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:54','2025-10-09 16:42:55',NULL,NULL,NULL,'1399a021-fdce-4929-bebd-f6816d25f48d'),
(3526,1545,NULL,1882,2,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:54','2025-10-09 16:42:55',NULL,NULL,NULL,'23083187-842c-4388-96bd-6aabe1c82135'),
(3528,1005,NULL,1883,1,'craft\\elements\\Entry',1,0,'2025-10-09 16:42:58','2025-10-09 16:42:58',NULL,NULL,NULL,'3ece6770-fc81-4117-93f7-4bccb79d1a1a'),
(3530,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 17:00:32','2025-10-09 17:00:45',NULL,NULL,NULL,'2db95d6d-ff0a-4793-835b-0ec3f007dd80'),
(3536,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'2be6d69f-9e6b-47d5-9a9a-735e1bc79444'),
(3537,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'519e1278-392f-4f7f-9b4d-1da82fad2e41'),
(3538,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'b5b3a93b-5780-4f0c-b13c-c785f787703d'),
(3539,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'aec81209-1e67-41c2-a9a3-42231a4aaecc'),
(3540,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'7024f509-7283-487c-b25d-ae771a445bce'),
(3541,1011,NULL,1884,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'936cb6f7-0696-4317-998e-0320ff451e65'),
(3542,3536,NULL,1885,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'c09ab8eb-1da5-4561-ad37-1ea9b797dd29'),
(3543,3537,NULL,1886,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'aee9273d-1b8d-435a-a35f-5e6bf04b277f'),
(3544,3538,NULL,1887,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'3d7b0d40-04ea-41c1-940c-5182bd1c57e9'),
(3545,3539,NULL,1888,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'4c008831-1c17-49c3-badc-4ed3cc247d33'),
(3546,3540,NULL,1889,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:12','2025-10-09 17:04:12',NULL,NULL,NULL,'773453b3-9468-4506-9832-d5c2e55bf38e'),
(3548,1011,NULL,1890,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:04:34','2025-10-09 17:04:34',NULL,NULL,NULL,'e02ea7ab-c0e9-4ce7-8d04-a64f08ad9329'),
(3554,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'aed77a2c-a9c4-4415-ba89-5d6033d2f17e'),
(3555,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'fc7b17cd-dcd3-4d3b-88cc-8443cf4e19d9'),
(3556,1011,NULL,1891,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'0c2275ef-4ee0-4387-a539-358ad5ba6241'),
(3557,3554,NULL,1892,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'b587a532-0eb9-4463-885b-4fa8cd98e591'),
(3558,3555,NULL,1893,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'53405e28-e2b1-4795-8667-ae230d821d7c'),
(3559,1549,NULL,1894,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'7a544893-34d6-4a56-ad3f-31e0688a8b90'),
(3560,1550,NULL,1895,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:50','2025-10-09 17:05:50',NULL,NULL,NULL,'21d3b4da-9469-4ca1-b5a0-b3626be0c36c'),
(3562,1011,NULL,1896,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:05:54','2025-10-09 17:05:54',NULL,NULL,NULL,'f9a1716d-354f-469a-9c4a-c327f2d99eb5'),
(3564,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 17:07:07','2025-10-09 17:07:07',NULL,NULL,NULL,'f2572e55-c9ee-4124-9840-49f254d6f40c'),
(3565,1017,NULL,1897,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:07:55','2025-10-09 17:07:55',NULL,NULL,NULL,'d673b3e0-080a-4bd2-9be2-8ccfbe80de0e'),
(3572,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'6b004649-7dd6-4e35-9ee0-2cc48c42f26c'),
(3573,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'93585b8d-e411-48a8-978e-bd28d3ce188f'),
(3574,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'6ac64390-099f-402e-a69c-ceefd1e221cd'),
(3575,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'69bcd4a2-ba7f-4fe6-af26-332a6dcc199f'),
(3576,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'cbdb13cb-770f-4204-83b1-998acdaf45a7'),
(3577,1017,NULL,1898,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:20','2025-10-09 17:09:21',NULL,NULL,NULL,'3b3b5d70-131a-4ca3-87de-a783a7ea6dcd'),
(3578,3572,NULL,1899,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'debfc912-7805-4c9b-a73f-4e8adcc1295f'),
(3579,3573,NULL,1900,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'cf05b33e-92bf-4ec8-9da5-1d66762cecdd'),
(3580,3574,NULL,1901,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'c8ca3b57-4820-4388-8f51-5c667145c61c'),
(3581,3575,NULL,1902,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'df8f2faf-ce48-4b97-8607-c75977adeeb1'),
(3582,3576,NULL,1903,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:21','2025-10-09 17:09:21',NULL,NULL,NULL,'43e6435f-8600-4946-9528-bafffdc90196'),
(3584,1017,NULL,1904,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:09:46','2025-10-09 17:09:46',NULL,NULL,NULL,'7009fb8f-6366-485f-b4c2-bec683eddd24'),
(3588,1017,NULL,1905,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:10:15','2025-10-09 17:10:15',NULL,NULL,NULL,'f06119df-74ff-47c7-98c3-a97b42e4931f'),
(3589,1554,NULL,1906,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:10:15','2025-10-09 17:10:15',NULL,NULL,NULL,'e9c802f0-87b6-4c6b-ad35-1b26c3d8c2f6'),
(3590,1555,NULL,1907,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:10:15','2025-10-09 17:10:15',NULL,NULL,NULL,'27202baa-93e7-44ec-992f-bee3f3248c7c'),
(3592,1017,NULL,1908,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:10:31','2025-10-09 17:10:31',NULL,NULL,NULL,'a61bd919-ae1b-4502-82d2-aa2f525d25d9'),
(3594,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 17:14:28','2025-10-09 17:14:28',NULL,NULL,NULL,'9325eeb8-d4a9-4b68-9f2a-0e950de6e020'),
(3595,1023,NULL,1909,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:15:09','2025-10-09 17:15:09',NULL,NULL,NULL,'c4d61382-7e69-4f77-ba12-ba6b4f74823f'),
(3602,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'83b4c63d-163b-4af6-b7aa-e2c71ed8fe48'),
(3603,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'65f35979-f914-4575-a85e-6297670c5425'),
(3604,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'191a6adb-1b50-4a0b-af97-875245ef6f30'),
(3605,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'af6de89f-16c4-4e8d-b17b-f3265900ec21'),
(3606,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'f426352c-0b46-4f31-8c43-89c4f8f367d4'),
(3607,1023,NULL,1910,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'10f20865-f5f1-4d81-9c2a-f89547ed967e'),
(3608,3602,NULL,1911,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'3f75b37a-ca01-4299-9b7a-27da85af1cdd'),
(3609,3603,NULL,1912,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'1a6b88bd-ff9b-4749-b57c-e29b0716bccd'),
(3610,3604,NULL,1913,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'2c045287-9291-417b-a2ad-7a8eab8ddf24'),
(3611,3605,NULL,1914,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'22c4cba5-0022-498e-997f-fba26c88857d'),
(3612,3606,NULL,1915,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:19:43','2025-10-09 17:19:43',NULL,NULL,NULL,'0f8bc432-f8e3-4807-96b3-c8f51119fa12'),
(3614,1023,NULL,1916,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:20:03','2025-10-09 17:20:03',NULL,NULL,NULL,'83f93676-b07a-4ea4-889f-b117a847f620'),
(3616,NULL,870,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:20:07','2025-10-09 17:20:07',NULL,NULL,NULL,'1c8f1d9e-2975-48b5-9d74-748edfd38bdb'),
(3619,1023,NULL,1917,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:20:39','2025-10-09 17:20:39',NULL,NULL,NULL,'8bc35f00-de8b-4f25-9b19-cc5d8f11b7ed'),
(3620,1560,NULL,1918,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:20:39','2025-10-09 17:20:39',NULL,NULL,NULL,'273121de-3639-44f6-852e-8ff17b221f06'),
(3621,1561,NULL,1919,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:20:39','2025-10-09 17:20:39',NULL,NULL,NULL,'0c98bb03-bdb3-40ed-9932-56c5a040eda6'),
(3623,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 17:21:43','2025-10-09 17:21:43',NULL,NULL,NULL,'82cfca8f-97c7-467d-b8fe-3ff831048619'),
(3624,1035,NULL,1920,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:22:03','2025-10-09 17:22:03',NULL,NULL,NULL,'d821524c-aa33-4879-b1e0-94a8b3096d8c'),
(3631,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'e0473c9a-8dc4-4dd4-96cd-71f0ff33e710'),
(3632,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'764a21ea-21d6-4e58-9db2-28ea928b0ab4'),
(3633,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'cf214155-f2a3-4395-8a9a-3e94f01cbc71'),
(3634,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'3e9053ab-6a78-434b-b90e-c1c37f81ca5c'),
(3635,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'bffadf16-9f4e-4c0b-83d3-4a03e07642ac'),
(3636,1035,NULL,1921,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'fe9c5e3c-8a91-4532-9511-d3be444a7c75'),
(3637,3631,NULL,1922,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'533e5584-a87c-49ca-87a4-17e2d12f8457'),
(3638,3632,NULL,1923,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'5a9587e6-6ec8-461d-8b94-d507e76b2df5'),
(3639,3633,NULL,1924,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'554c8035-77c5-42c3-9d66-0782a38018c8'),
(3640,3634,NULL,1925,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'23d2da06-7427-43e0-bd07-870d8cb082a4'),
(3641,3635,NULL,1926,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:33','2025-10-09 17:23:33',NULL,NULL,NULL,'8889c84a-72a5-4ed3-aaa6-34416465f0f4'),
(3643,1035,NULL,1927,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:52','2025-10-09 17:23:52',NULL,NULL,NULL,'a686888e-1b3e-4059-9a94-921649b5b248'),
(3645,NULL,882,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:23:58','2025-10-09 17:23:58',NULL,NULL,NULL,'aa31be71-ca6b-45b9-9439-1909c4f37351'),
(3648,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 17:24:29','2025-10-09 17:24:29',NULL,NULL,NULL,'24d5cd55-7d2b-4b59-b95d-60928fa86e7b'),
(3649,1035,NULL,1928,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:24:35','2025-10-09 17:24:35',NULL,NULL,NULL,'bad36670-6774-46a0-ba4a-63c9ce04fa74'),
(3650,1569,NULL,1929,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:24:35','2025-10-09 17:24:35',NULL,NULL,NULL,'925e98b4-bea5-4ae5-a2c8-9f07b170f101'),
(3651,1570,NULL,1930,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:24:35','2025-10-09 17:24:35',NULL,NULL,NULL,'38fac39a-bd5c-44e2-ac06-3792f1349712'),
(3653,1035,NULL,1931,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:24:37','2025-10-09 17:24:37',NULL,NULL,NULL,'b24dddf9-9cbd-4124-a2b5-efe1cd78dd23'),
(3655,1041,NULL,1932,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:26:17','2025-10-09 17:26:17',NULL,NULL,NULL,'d23c112a-cd19-424b-a718-93339f4ea328'),
(3662,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'82f02427-89ac-42ca-a344-0a3201c419c1'),
(3663,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'077f62b5-f904-4ba5-aad5-f4e9958226f3'),
(3664,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'e2345b31-a63a-47cd-a911-400bc682a2b9'),
(3665,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'b55a3112-bb5c-4f63-a864-464d7c5abe61'),
(3666,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'a201c89c-8475-45fa-9c4d-6e611b2afeb0'),
(3667,1041,NULL,1933,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'39e9a434-aa55-4eab-933a-fdf7a092f557'),
(3668,3662,NULL,1934,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'6ecf7d35-bc6e-49c0-9dfd-a99658ea5e8c'),
(3669,3663,NULL,1935,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'e80a19e6-6d3e-4b21-9827-059eba9a76c3'),
(3670,3664,NULL,1936,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'e6587b13-c9e7-423f-8386-d4ba61f6dc88'),
(3671,3665,NULL,1937,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'852392e0-12f5-4bc9-aff3-cf0c29bf15cc'),
(3672,3666,NULL,1938,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:27:46','2025-10-09 17:27:46',NULL,NULL,NULL,'9d59247f-4108-4b81-b04c-b26d0bcbb21b'),
(3674,1041,NULL,1939,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:28:11','2025-10-09 17:28:11',NULL,NULL,NULL,'e30fdf49-4123-42f9-8b86-5f091a8e801e'),
(3680,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'42bbd2a8-0093-49d4-909e-ac7afc87c2a1'),
(3681,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'cc514d58-4f97-49df-aeee-0970a4399a03'),
(3682,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'205f4452-72b0-40e5-a79b-a9bf0b788ab3'),
(3683,1041,NULL,1940,1,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'2cd72ad9-125c-4125-b7c5-2e21cc70235f'),
(3684,3680,NULL,1941,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'a140f62a-97c4-4267-8ed5-fa6304f5959d'),
(3685,3681,NULL,1942,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'4a5fe42d-85b9-49be-aa7f-67e0dd3371fb'),
(3686,3682,NULL,1943,3,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'21163904-7fb7-4895-9036-07ff25ecbd26'),
(3687,1574,NULL,1944,2,'craft\\elements\\Entry',1,0,'2025-10-09 17:29:43','2025-10-09 17:29:43',NULL,NULL,NULL,'824bd24a-48d0-4b18-9f7d-442ae8312d3a'),
(3689,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 20:42:59','2025-10-09 20:43:24',NULL,NULL,NULL,'5e9e3676-39c2-40bb-8c72-4205cc2f1c20'),
(3690,1045,NULL,1945,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:44:20','2025-10-09 20:44:20',NULL,NULL,NULL,'f658dd75-296f-4a6e-ab6c-e0875cd93fc9'),
(3697,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:06','2025-10-09 20:46:21',NULL,NULL,NULL,'2f64c502-d62e-473b-9c08-ed80c734ebb9'),
(3698,3697,NULL,1946,6,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:21','2025-10-09 20:46:21',NULL,NULL,NULL,'498d04f5-1cc4-4daf-b7c7-284be8832ef7'),
(3699,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'e6cedecd-f1fb-4d88-8ede-46530b968f44'),
(3700,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'90146cdd-a8ca-4768-bd1c-172dbdae13a7'),
(3701,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'40ccec75-c670-4aba-9538-a1f67be5e416'),
(3702,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'d5944596-326a-4f16-826a-00c570db5227'),
(3703,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'466023f5-cb24-457a-942e-0ef314e26a69'),
(3704,1045,NULL,1947,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'86975381-4c63-4971-a439-93f548c4c6f9'),
(3705,3699,NULL,1948,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'b2a37535-336b-407c-beb8-0b841d44b14e'),
(3706,3700,NULL,1949,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'e4dd54fd-dc52-47b8-8018-4b3baade799f'),
(3707,3701,NULL,1950,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'14d932c5-2dd1-4723-9216-3250beeee07b'),
(3708,3702,NULL,1951,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'f8a71d94-23a1-4b16-be2d-f77e5718226d'),
(3709,3703,NULL,1952,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:46:26','2025-10-09 20:46:26',NULL,NULL,NULL,'31ae445d-4c5b-42a8-84f2-a5879ffbc60a'),
(3712,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 20:47:03','2025-10-09 20:47:03',NULL,NULL,NULL,'7608abe9-1b42-4396-ac87-548b8b3015cb'),
(3714,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 20:48:06','2025-10-09 20:48:06',NULL,NULL,NULL,'75da13cc-3b53-4ae3-ab40-e82046bd6efe'),
(3716,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:48:21','2025-10-09 20:48:21',NULL,NULL,NULL,'abd5fc75-96fb-4bfe-b8d3-3b2dc279ceb2'),
(3717,1045,NULL,1953,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:48:21','2025-10-09 20:48:21',NULL,NULL,NULL,'f00f71de-7603-4ba4-9742-4cdb5d04edd1'),
(3718,3716,NULL,1954,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:48:21','2025-10-09 20:48:21',NULL,NULL,NULL,'e6645617-9c73-4faa-aae1-f5426fcb856c'),
(3719,1577,NULL,1955,2,'craft\\elements\\Entry',1,0,'2025-10-09 20:48:21','2025-10-09 20:48:21',NULL,NULL,NULL,'326c24a9-6977-42bd-99c4-4be43d62af50'),
(3720,1578,NULL,1956,2,'craft\\elements\\Entry',1,0,'2025-10-09 20:48:21','2025-10-09 20:48:21',NULL,NULL,NULL,'1654ac97-add2-4f38-b6e9-f2285798e514'),
(3722,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-09 20:50:40','2025-10-09 20:50:40',NULL,NULL,NULL,'64cbbe56-a0ee-4bd5-9ea1-7d0444fda32b'),
(3723,1051,NULL,1957,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:52:58','2025-10-09 20:52:58',NULL,NULL,NULL,'9f878777-6985-447c-9183-bbdd4902dd54'),
(3730,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'65cf2e2b-45be-4029-b547-cd53c0904306'),
(3731,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'89f2f03a-4f72-4572-8e77-9385e0a461fc'),
(3732,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'a0008e56-ea4b-48c6-be5a-d52f1c80998f'),
(3733,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'fc290ac5-ff1e-403d-b23a-5266f398e50f'),
(3734,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'d9484c43-1e06-42ea-be7f-d1c69eb8549c'),
(3735,1051,NULL,1958,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'e10f9975-5f28-4e1c-9c54-c6cab82bf1a0'),
(3736,3730,NULL,1959,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'ba8e7849-101c-4460-b79f-c2a6828b13a1'),
(3737,3731,NULL,1960,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:27',NULL,NULL,NULL,'690fbcd1-aa27-4058-940d-3b640d4bd401'),
(3738,3732,NULL,1961,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:28',NULL,NULL,NULL,'10d16818-acd2-4414-9449-deab38c6d8fb'),
(3739,3733,NULL,1962,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:28',NULL,NULL,NULL,'d5e8cb70-16da-466e-9bb8-b5db30171ccb'),
(3740,3734,NULL,1963,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:27','2025-10-09 20:54:28',NULL,NULL,NULL,'46976404-d587-4364-a3d6-7bd3aefcec75'),
(3742,1051,NULL,1964,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:54:48','2025-10-09 20:54:48',NULL,NULL,NULL,'fbbe05e1-dfb8-4849-b18a-a31183d1f04a'),
(3746,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 20:55:28','2025-10-09 20:55:28',NULL,NULL,NULL,'fe81bf01-cb45-4d27-8b33-eb39a7088c2f'),
(3748,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-09 20:55:46','2025-10-09 20:55:46',NULL,NULL,NULL,'08d72cdd-d6ce-40ac-9ccc-48e5b4197042'),
(3749,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:56:04','2025-10-09 20:56:04',NULL,NULL,NULL,'d0bf0ca5-975c-4005-8fa4-95e2e7dbd174'),
(3750,1051,NULL,1965,1,'craft\\elements\\Entry',1,0,'2025-10-09 20:56:04','2025-10-09 20:56:04',NULL,NULL,NULL,'605f03b2-1d79-4669-a87d-73acca795559'),
(3751,3749,NULL,1966,3,'craft\\elements\\Entry',1,0,'2025-10-09 20:56:04','2025-10-09 20:56:04',NULL,NULL,NULL,'201b063e-b97f-4bfb-82a0-ab5e108d773d'),
(3752,1583,NULL,1967,2,'craft\\elements\\Entry',1,0,'2025-10-09 20:56:04','2025-10-09 20:56:04',NULL,NULL,NULL,'9efb0b6d-6759-43a5-a414-ac7796470e8e'),
(3753,1584,NULL,1968,2,'craft\\elements\\Entry',1,0,'2025-10-09 20:56:04','2025-10-09 20:56:04',NULL,NULL,NULL,'3703bab7-21e7-4323-97ca-76ed272dd348'),
(3755,1353,NULL,1969,1,'craft\\elements\\Entry',1,0,'2025-10-10 18:22:08','2025-10-10 18:22:08',NULL,NULL,NULL,'2eeb28ba-66c1-434d-9d55-24b3b258edd4'),
(3757,951,NULL,1970,1,'craft\\elements\\Entry',1,0,'2025-10-10 18:22:39','2025-10-10 18:22:39',NULL,NULL,NULL,'7c883abd-42b2-4ff7-acd8-8753471d25dd'),
(3759,2880,NULL,1971,1,'craft\\elements\\Entry',1,0,'2025-10-10 18:22:50','2025-10-10 18:22:51',NULL,NULL,NULL,'5d68b813-7384-4f4d-b26d-c4ef1b1b2924'),
(3761,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 15:57:58','2025-10-13 15:57:58',NULL,NULL,NULL,'5b1cf97e-925b-4eec-8d9f-60c115190faa'),
(3762,1059,NULL,1972,1,'craft\\elements\\Entry',1,0,'2025-10-13 15:58:53','2025-10-13 15:58:54',NULL,NULL,NULL,'b0141dd7-8d60-41f3-9748-75cf10ce6019'),
(3769,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'332f9153-1705-40d1-9660-9531c97dbd01'),
(3770,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'ed107e8c-0bb1-4a2b-883d-bd53ad0119eb'),
(3771,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'bae68c7d-0fe2-4291-af85-b8d3ce8a73e5'),
(3772,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'68ddda38-a8e1-46b6-8b94-5a72981d2553'),
(3773,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'660f782e-af0a-4824-9f53-db5f852d784f'),
(3774,1059,NULL,1973,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'a475f88a-023e-4306-959d-76152549d02a'),
(3775,3769,NULL,1974,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'94ebe8bb-d88e-495b-b253-2ec0bed08b10'),
(3776,3770,NULL,1975,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'f94b32be-a1db-40b1-b5f0-123a2cd3328f'),
(3777,3771,NULL,1976,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'8102b0b3-ba4d-4154-957d-fd6ff74a271b'),
(3778,3772,NULL,1977,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'e3210c99-b7f8-4202-bb7a-e87750927e52'),
(3779,3773,NULL,1978,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:23','2025-10-13 16:00:23',NULL,NULL,NULL,'cdf459e9-7fb4-45cf-a527-662247547845'),
(3781,1059,NULL,1979,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:00:53','2025-10-13 16:00:53',NULL,NULL,NULL,'237222d7-84b1-478f-99f5-ffd5b1543e41'),
(3785,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:01:40','2025-10-13 16:01:40',NULL,NULL,NULL,'7726370e-2ffa-4012-bf0c-50863a42f7fc'),
(3786,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:01:40','2025-10-13 16:01:40',NULL,NULL,NULL,'9f3aa730-a932-43b3-8f56-da7b7d1af718'),
(3787,1059,NULL,1980,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:01:40','2025-10-13 16:01:41',NULL,NULL,NULL,'975dfeb3-7000-45e0-9293-269deba10a06'),
(3788,3785,NULL,1981,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:01:40','2025-10-13 16:01:41',NULL,NULL,NULL,'7ce9a21d-bc07-4dfd-a6b0-aecdacee80a8'),
(3789,3786,NULL,1982,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:01:40','2025-10-13 16:01:41',NULL,NULL,NULL,'034de22f-82dd-4f4b-b240-4ed5f645a52b'),
(3793,1059,NULL,1983,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:02:33','2025-10-13 16:02:33',NULL,NULL,NULL,'3790074b-da9f-4ce4-bfb7-b6cda24aff4b'),
(3794,1590,NULL,1984,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:02:33','2025-10-13 16:02:33',NULL,NULL,NULL,'13a12d41-4e97-495e-973c-98b52d95ccfb'),
(3795,1591,NULL,1985,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:02:33','2025-10-13 16:02:33',NULL,NULL,NULL,'2f2be886-c813-46fe-ac6d-2eb7c884fd93'),
(3797,1059,NULL,1986,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:02:37','2025-10-13 16:02:37',NULL,NULL,NULL,'84670b37-732f-4463-87ab-0c456e766d36'),
(3800,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 16:03:32','2025-10-13 16:03:42',NULL,NULL,NULL,'6a8222df-62d7-40e4-9fd0-463dfcd4aed8'),
(3802,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 16:04:02','2025-10-13 16:04:02',NULL,NULL,NULL,'23e420f1-728b-4627-8617-ace60ec827f5'),
(3803,1067,NULL,1987,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:04:07','2025-10-13 16:04:07',NULL,NULL,NULL,'0470595f-7a58-4003-a3aa-e650cc6065ad'),
(3804,1596,NULL,1988,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:04:07','2025-10-13 16:04:07',NULL,NULL,NULL,'df7b6042-efab-4725-9682-3646a23bbc63'),
(3805,1597,NULL,1989,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:04:07','2025-10-13 16:04:07',NULL,NULL,NULL,'dc2ad204-8498-485b-add3-c08b6e40c69f'),
(3808,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 16:05:35','2025-10-13 16:05:35',NULL,NULL,NULL,'1e09a858-3639-49cf-bb25-9daec6ae56a6'),
(3814,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'cd08b48b-c54a-4049-8d38-c94a70086fa0'),
(3815,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'dc3d7ee6-2887-486f-acd3-5cdc0b3c9010'),
(3816,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'61a09bbb-c305-49c1-bd0e-80ce618ecfe2'),
(3817,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'ba34f517-2422-42f5-bee9-5cb10173bea9'),
(3818,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'180b7503-1a32-4e78-8272-4cedebfc42ca'),
(3819,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'1a64a325-0fa1-42da-9738-27dbce6952b0'),
(3820,1067,NULL,1990,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'c2994a54-13d2-40e6-b3ef-60ef4503bad9'),
(3821,3814,NULL,1991,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'6d1f66ba-6623-4b5e-ab3b-a4f1a0319a2a'),
(3822,3815,NULL,1992,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'fd8dc983-5af0-4dd3-bd9c-59d2a79f04a9'),
(3823,3816,NULL,1993,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'a60012b7-b41c-4e23-9986-a8374fee3682'),
(3824,3817,NULL,1994,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'3d7a3f43-5af4-457a-8e56-c5b65e28cdda'),
(3825,3818,NULL,1995,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'9552b841-31b5-4b39-ada2-efb681ba4907'),
(3826,3819,NULL,1996,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:23','2025-10-13 16:07:23',NULL,NULL,NULL,'790628a2-8962-4ce2-bef2-ca4f794290de'),
(3828,1067,NULL,1997,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:07:45','2025-10-13 16:07:45',NULL,NULL,NULL,'b8e85a9f-6ef1-463c-b618-a32a7e5c5fde'),
(3830,1067,NULL,1998,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:08:14','2025-10-13 16:08:14',NULL,NULL,NULL,'db54389b-6111-4521-bff1-ebf01626a6ad'),
(3831,1073,953,NULL,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:09:39','2025-10-13 16:09:39',NULL,NULL,NULL,'7847c63f-657d-43ec-8c34-7f36bbdcc9c7'),
(3833,1079,NULL,1999,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:12:15','2025-10-13 16:12:15',NULL,NULL,NULL,'de70c0c4-8783-4138-9f41-f4da79a39de6'),
(3840,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'c417b84c-a022-4d92-97d6-b5da8da0961a'),
(3841,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'3d0ee3d6-d528-4815-a861-f4f3f978fcb6'),
(3842,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'ce6e5f74-605f-4e97-a68f-2ca27f15f139'),
(3843,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'87a557b3-8da6-4906-9bd8-613191234553'),
(3844,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'0033ecc9-0e0b-4ff4-82fa-1cabb8e40ecd'),
(3845,1079,NULL,2000,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'f1d699ef-7ea3-4105-87b2-51c46485fe44'),
(3846,3840,NULL,2001,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'99bdecaf-7790-4aea-b8f5-3fbfeb303d54'),
(3847,3841,NULL,2002,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'f4f162df-b217-4938-b8f2-3bad8e94da71'),
(3848,3842,NULL,2003,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'06555db2-21a1-47b0-8e9c-7e2b5a363d1f'),
(3849,3843,NULL,2004,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'b4741a4b-fd4f-414e-849e-410546b5b878'),
(3850,3844,NULL,2005,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:13:49','2025-10-13 16:13:49',NULL,NULL,NULL,'1a782033-b50a-40a0-a5df-ff0c9c35ab80'),
(3852,1079,NULL,2006,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:14:29','2025-10-13 16:14:30',NULL,NULL,NULL,'22044155-52df-4b23-bbed-97aa9e030784'),
(3856,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 16:15:24','2025-10-13 16:15:24',NULL,NULL,NULL,'c3f7c8cb-36ee-4796-9f1b-dc17ac9b4a4d'),
(3858,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 16:15:40','2025-10-13 16:15:40',NULL,NULL,NULL,'bf12f978-cde5-4a38-802e-9bdd701fa97c'),
(3859,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:15:51','2025-10-13 16:15:51',NULL,NULL,NULL,'c8aa57d5-8414-4c93-98d8-d3e7c06aa840'),
(3860,1079,NULL,2007,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:15:51','2025-10-13 16:15:51',NULL,NULL,NULL,'c753f9c6-0440-4f08-ace4-56e446e1019a'),
(3861,3859,NULL,2008,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:15:51','2025-10-13 16:15:51',NULL,NULL,NULL,'0e198a6d-4252-4726-9180-781257a292d9'),
(3862,1606,NULL,2009,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:15:51','2025-10-13 16:15:51',NULL,NULL,NULL,'ac9c27ec-c03c-4b30-bbd6-d8842842a446'),
(3863,1607,NULL,2010,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:15:51','2025-10-13 16:15:51',NULL,NULL,NULL,'a72543c7-947d-4fbd-92f5-0b86c5fdbe54'),
(3865,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 16:20:27','2025-10-13 16:20:27',NULL,NULL,NULL,'393c9bff-0570-459d-926c-c6eb005839e6'),
(3866,1085,NULL,2011,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:41:23','2025-10-13 16:41:23',NULL,NULL,NULL,'4afcbd44-0710-474e-a49f-fabab0fb53c4'),
(3874,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'6c408be1-1c0b-463a-b45c-efa17737b976'),
(3875,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'6346990d-7366-4922-886c-508e138d67b0'),
(3876,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'51240748-32cb-4e66-b056-e472abb71c69'),
(3877,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'b3ba5379-c9b3-4b68-a1d6-4860bb4c6f5a'),
(3878,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'109e05e3-5db9-4f0f-a0fe-c295cf5297e5'),
(3879,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'98592287-96f5-45fd-b069-60900d7ece23'),
(3880,1085,NULL,2012,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'3987d78a-f6ca-4878-bbab-6655693adff0'),
(3881,3874,NULL,2013,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'86b63b08-2bd0-4416-bca8-743fb44af72a'),
(3882,3875,NULL,2014,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'4108a3e1-ffd0-443d-ab77-c57b9e8420c2'),
(3883,3876,NULL,2015,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'2e21e449-b4d8-4ada-bada-cd3b3c9711b4'),
(3884,3877,NULL,2016,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'b8f938ba-5aa0-47d7-9212-5c3e4b7c6fce'),
(3885,3878,NULL,2017,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'2bf92097-1ffb-422c-80a9-c0c60558906b'),
(3886,3879,NULL,2018,3,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:20','2025-10-13 16:43:20',NULL,NULL,NULL,'a7f12634-a672-46a5-848d-729286c7ee15'),
(3890,1085,NULL,2019,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:47','2025-10-13 16:43:47',NULL,NULL,NULL,'904648fc-327c-4e0e-9867-1aec28d3ffc3'),
(3891,1611,NULL,2020,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:47','2025-10-13 16:43:47',NULL,NULL,NULL,'14798446-6461-4058-b204-90ab6e9ef346'),
(3892,1612,NULL,2021,2,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:47','2025-10-13 16:43:47',NULL,NULL,NULL,'cb64ce2d-41d2-4976-95ed-06da0b073e1a'),
(3894,1085,NULL,2022,1,'craft\\elements\\Entry',1,0,'2025-10-13 16:43:50','2025-10-13 16:43:50',NULL,NULL,NULL,'05331432-a920-4c05-a4af-3f239a81c072'),
(3896,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:02:38','2025-10-13 17:02:38',NULL,NULL,NULL,'7bd5068c-3814-4c9b-9898-6a251cac8c8e'),
(3902,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'78d615a6-25d1-49fc-ab40-de186ebc9b86'),
(3903,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'e2aedee6-bd93-4101-898e-14dc0e1bb0f8'),
(3904,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'e57893b7-2ddc-4ff8-98bb-b75570184257'),
(3905,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'3feef635-be19-4a6d-b213-a3dbb0217f64'),
(3906,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'75048d77-a4aa-45a8-853e-197661d92762'),
(3907,1091,NULL,2023,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'1437753d-d375-49e1-a89d-ffacf91b3706'),
(3908,3902,NULL,2024,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'dac93926-bc48-4c66-b221-ef5dd46a5b31'),
(3909,3903,NULL,2025,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'7bdf78a7-054f-4cba-b4d7-2554c0dfca26'),
(3910,3904,NULL,2026,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'f35aac30-97e6-46f8-9b78-5d2238464a42'),
(3911,3905,NULL,2027,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'76973061-f24d-4754-a056-e5a7c3cadc50'),
(3912,3906,NULL,2028,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:16','2025-10-13 17:05:16',NULL,NULL,NULL,'a52b44a1-4b80-4ee9-b922-945382806217'),
(3914,1091,NULL,2029,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:05:41','2025-10-13 17:05:41',NULL,NULL,NULL,'1dde69df-d240-49ae-8705-9ea3529b7b90'),
(3918,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:06:23','2025-10-13 17:06:23',NULL,NULL,NULL,'96edee62-bf13-467b-a925-cf34cb888839'),
(3920,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:06:39','2025-10-13 17:06:39',NULL,NULL,NULL,'8f2a6313-f096-4859-8d92-f71931a00bd9'),
(3921,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:09:47','2025-10-13 17:09:47',NULL,NULL,NULL,'784e35f3-7981-46f8-981f-45c8aaa3de14'),
(3922,1091,NULL,2030,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:09:47','2025-10-13 17:09:47',NULL,NULL,NULL,'5ea22ba7-d211-4980-a22a-972b2709bef0'),
(3923,3921,NULL,2031,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:09:47','2025-10-13 17:09:47',NULL,NULL,NULL,'948ce7d6-af59-4d14-bcb1-e8ae03570cb6'),
(3924,1616,NULL,2032,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:09:47','2025-10-13 17:09:47',NULL,NULL,NULL,'b3bf9d38-1e10-42d4-926e-603e6bf751ea'),
(3925,1617,NULL,2033,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:09:47','2025-10-13 17:09:47',NULL,NULL,NULL,'6e7a6af8-45c0-4923-a7ad-f44f3066c0a7'),
(3927,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:19:49','2025-10-13 17:19:49',NULL,NULL,NULL,'5c1ab61a-27d0-4c3a-a433-2b84849eb2cf'),
(3928,1097,NULL,2034,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:20:16','2025-10-13 17:20:17',NULL,NULL,NULL,'854ca287-47db-4d48-a11c-7da2b179c9b8'),
(3935,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'94c439b9-e3c0-424e-af82-b9a995f26e5d'),
(3936,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'8f7554b3-1da4-4bc6-802c-b84bc38b5176'),
(3937,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'dfa7f5e1-8c01-46f6-a66e-afeaee07d469'),
(3938,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'15fdbfc5-ad16-43fd-b420-e6312c4c2e93'),
(3939,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'4293c612-f747-46bb-bbc1-208a734a5307'),
(3940,1097,NULL,2035,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'5931751f-080b-46ac-86c7-91d4538fb645'),
(3941,3935,NULL,2036,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'e0f70a0d-a17c-4d5a-8ef5-2390352222ec'),
(3942,3936,NULL,2037,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'0e6a15ff-f522-48e2-b6cd-39e521f4c416'),
(3943,3937,NULL,2038,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'4cf83c1c-2954-4691-bdea-494c153b3d1b'),
(3944,3938,NULL,2039,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'b3bf6b64-0fc9-4aff-8b70-05346156b6e7'),
(3945,3939,NULL,2040,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:21:33','2025-10-13 17:21:33',NULL,NULL,NULL,'2c9b50f0-d4e4-4dd0-be41-0852aca4f3ca'),
(3948,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:22:18','2025-10-13 17:22:18',NULL,NULL,NULL,'5ba4a939-6287-43bf-bf98-d292e2bfc257'),
(3949,1097,NULL,2041,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:22:18','2025-10-13 17:22:18',NULL,NULL,NULL,'9cb6c5ce-0f50-4b78-87fe-b69c5f7e2f95'),
(3950,3948,NULL,2042,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:22:18','2025-10-13 17:22:18',NULL,NULL,NULL,'9ca96325-458a-4d2d-a5dd-bd990c090a43'),
(3954,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:22:55','2025-10-13 17:22:55',NULL,NULL,NULL,'e96116b7-f71b-4c13-893d-a88ce2c6df4c'),
(3955,1097,NULL,2043,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:23:02','2025-10-13 17:23:02',NULL,NULL,NULL,'0eec1f63-a7b5-44ce-80d0-07544ba66bf3'),
(3956,1621,NULL,2044,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:23:02','2025-10-13 17:23:02',NULL,NULL,NULL,'cae02c4a-af7b-4abc-8cc9-7aa0f19e1910'),
(3957,1622,NULL,2045,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:23:02','2025-10-13 17:23:02',NULL,NULL,NULL,'95409328-3cd5-4bf9-8370-0b27e0bf08f0'),
(3959,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:25:39','2025-10-13 17:25:55',NULL,NULL,NULL,'1701a219-50cd-430c-be86-2b75ad7f5ae1'),
(3965,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'2fab5094-9b24-4e66-b001-536f17a5ea1b'),
(3966,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'8c6dfd0e-2a3a-4439-992f-0be0b244c21c'),
(3967,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'5dd167c1-38dd-4043-9267-586773ecef14'),
(3968,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'72d15429-573d-43e4-a7c0-e2a750af6e96'),
(3969,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'ee6d7801-cb59-4569-af31-bc6bd251a7b9'),
(3970,1103,NULL,2046,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'374e34ca-4767-4641-896d-4a6b870593b4'),
(3971,3965,NULL,2047,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'348771db-2035-463b-9b16-baba6316966d'),
(3972,3966,NULL,2048,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'6b57de47-25d0-40f1-804f-449228732a23'),
(3973,3967,NULL,2049,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'1479489c-9b93-41e8-8ffa-0fc656288956'),
(3974,3968,NULL,2050,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'7fa1465a-628f-48e1-8301-fddbe2367b8c'),
(3975,3969,NULL,2051,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:27','2025-10-13 17:27:27',NULL,NULL,NULL,'62f7355d-ec49-41ed-bce3-3c51c00048da'),
(3977,1103,NULL,2052,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:27:45','2025-10-13 17:27:45',NULL,NULL,NULL,'3c214a87-5730-4daa-ab39-43f9ecfc7a80'),
(3981,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:28:18','2025-10-13 17:28:18',NULL,NULL,NULL,'237ec093-2328-47e2-8675-2e160f80bdf7'),
(3982,1103,NULL,2053,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:28:26','2025-10-13 17:28:26',NULL,NULL,NULL,'25848392-d487-44c6-be3f-c18f92029a66'),
(3983,1626,NULL,2054,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:28:26','2025-10-13 17:28:26',NULL,NULL,NULL,'a43b5ab2-b618-41a7-9002-78beca9e0aea'),
(3984,1627,NULL,2055,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:28:26','2025-10-13 17:28:26',NULL,NULL,NULL,'2e3aa1e8-6a80-4d77-ae34-c6cb34acb266'),
(3986,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:40:30','2025-10-13 17:40:30',NULL,NULL,NULL,'efacff44-cd06-41d0-a14b-021999a11a51'),
(3992,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'aac7f17b-239c-45dd-8241-572c213582a9'),
(3993,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'efc23a89-6b18-4db2-86a3-beabbb9e1e52'),
(3994,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'835ed6d6-ab4c-41f7-99e1-471c78621514'),
(3995,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'6837e2f9-1649-4463-9103-547f054c1a8a'),
(3996,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'ec47ff37-bb7b-425d-83ba-589379ca957f'),
(3997,1109,NULL,2056,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'cff4e695-b3f0-4cd0-a11f-1daa8ec72d56'),
(3998,3992,NULL,2057,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'2d6748bb-07e2-4188-b50b-cb2434e6d320'),
(3999,3993,NULL,2058,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'2c943d9e-a65c-4978-8c73-99215c1d4ce8'),
(4000,3994,NULL,2059,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'9a57a8a0-19ba-4691-a163-09c0d4fed136'),
(4001,3995,NULL,2060,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'8838f83d-2cfe-46ae-84d7-9abedc4c34b8'),
(4002,3996,NULL,2061,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:06','2025-10-13 17:42:06',NULL,NULL,NULL,'fa532c61-b3cb-4025-83d2-c26a58398221'),
(4004,1109,NULL,2062,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:42:25','2025-10-13 17:42:25',NULL,NULL,NULL,'5506daf4-2b1a-490c-8c3a-08cca7a2a2f2'),
(4008,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:43:03','2025-10-13 17:43:03',NULL,NULL,NULL,'48a087d8-0d21-4941-b82b-5a0097a2ec58'),
(4010,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:43:27','2025-10-13 17:43:27',NULL,NULL,NULL,'e4912cd6-8ea9-49d1-9e79-6303a3a22c05'),
(4011,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:43:34','2025-10-13 17:43:34',NULL,NULL,NULL,'236a698f-69e6-42e8-8744-0b6e4382e3db'),
(4012,1109,NULL,2063,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:43:34','2025-10-13 17:43:34',NULL,NULL,NULL,'061a5777-9140-463a-8b5b-1cd467c067b3'),
(4013,4011,NULL,2064,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:43:34','2025-10-13 17:43:34',NULL,NULL,NULL,'ba9e88d6-5469-4ed9-a520-cde8d581ff88'),
(4014,1632,NULL,2065,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:43:34','2025-10-13 17:43:34',NULL,NULL,NULL,'cd7bda22-7b3e-4a87-92f8-30337d89ab53'),
(4015,1633,NULL,2066,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:43:34','2025-10-13 17:43:34',NULL,NULL,NULL,'0f0a84b3-abb3-49e9-800c-aa82e8ac6b0b'),
(4017,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:44:49','2025-10-13 17:44:49',NULL,NULL,NULL,'0bdb5069-757f-42ae-9cf0-9d35c534e465'),
(4018,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:45:02','2025-10-13 17:45:02',NULL,NULL,NULL,'c8d03316-3fb3-42ca-be17-5b6690e266b0'),
(4020,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:45:12','2025-10-13 17:45:12',NULL,NULL,NULL,'99de9186-e678-4fca-aa6c-adbd851b9331'),
(4026,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'a5e6b15c-baf6-4f15-8854-3741960d6509'),
(4027,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'acf21f36-c284-4e56-8dd0-9528ffba797a'),
(4028,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'7a8e3dc4-29c1-4a3a-804d-92cdfd8c11b5'),
(4029,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'820335d6-39b8-4eb4-8c2a-6f7f5e0ee494'),
(4030,1117,NULL,2067,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'bbdc3462-f3f1-4a21-97c7-fa567143d6f7'),
(4031,4026,NULL,2068,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'6e9e2ec8-c28b-4d29-91fc-9752c4706968'),
(4032,4027,NULL,2069,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'7ff79758-31aa-4515-9b5a-3a8c6a333651'),
(4033,4028,NULL,2070,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'2b702b65-5430-4557-aab9-51098839b473'),
(4034,4029,NULL,2071,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'8d99e06e-bb73-4ca1-aa67-3e07215a74b4'),
(4035,1638,NULL,2072,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'3b94f841-2384-4369-89e2-17bd76b6d1b3'),
(4036,1639,NULL,2073,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:38','2025-10-13 17:46:38',NULL,NULL,NULL,'0040236f-b6c5-4797-ab7c-5ae72449f718'),
(4038,1117,NULL,2074,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:46:53','2025-10-13 17:46:53',NULL,NULL,NULL,'db48266c-b7c7-43ed-9d3f-5f9553507688'),
(4042,1117,NULL,2075,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:47:19','2025-10-13 17:47:19',NULL,NULL,NULL,'84e2bde3-0af5-4b15-aca0-00d05ee487df'),
(4043,1638,NULL,2076,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:47:19','2025-10-13 17:47:19',NULL,NULL,NULL,'3d21bb03-d970-4920-b666-a7051b366bc4'),
(4044,1639,NULL,2077,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:47:19','2025-10-13 17:47:19',NULL,NULL,NULL,'9cf4204f-4c68-4d1a-a084-ed561478c17f'),
(4046,1123,NULL,2078,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:48:10','2025-10-13 17:48:10',NULL,NULL,NULL,'359064b2-8195-4194-b2ad-7fee34905ea2'),
(4053,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'0861b384-3f2d-4ef0-a442-a7c6779de429'),
(4054,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'f4a30cd3-f01e-4f0e-8900-af8f59dc5cf1'),
(4055,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'bbcb4e4e-c500-46bb-a26e-755893ee3dc1'),
(4056,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'3c4baf18-035d-4aef-a62f-411c2be75452'),
(4057,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'2884ddd7-5175-4a0e-9869-7fe4b9bc177f'),
(4058,1123,NULL,2079,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'112ef6f1-5258-48c2-b959-caa96de24488'),
(4059,4053,NULL,2080,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'1c64e5d7-029f-4a5d-8f35-4a305e9f2172'),
(4060,4054,NULL,2081,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'378382ba-fd14-4f7e-82f2-62cd4a109364'),
(4061,4055,NULL,2082,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'0275c8b4-e54d-44bb-aab2-9070730515ad'),
(4062,4056,NULL,2083,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'a206b450-d282-437b-a886-62496e7cf940'),
(4063,4057,NULL,2084,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:49:38','2025-10-13 17:49:38',NULL,NULL,NULL,'cf41f687-e0ae-44da-8ec0-8d1057b2800c'),
(4069,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:51:54','2025-10-13 17:51:54',NULL,NULL,NULL,'ea737fe8-10e6-4128-8085-979721397257'),
(4070,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'157ac3b1-bfab-4b36-8e50-abe1dfad7938'),
(4071,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'d2bff5fb-7c26-4025-8815-4a8b2231b6d6'),
(4072,1123,NULL,2085,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'00ad63b7-c18d-4cda-896b-a0883999ead2'),
(4073,4070,NULL,2086,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'f4aa05af-aa20-4706-bf3e-5b9ac2fbb7a4'),
(4074,4071,NULL,2087,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'710abb8f-d559-4695-b188-66d092df5df9'),
(4075,1643,NULL,2088,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'9e6235a7-3d82-4fb1-a04b-1d1c02e77b6d'),
(4076,1644,NULL,2089,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:01','2025-10-13 17:52:01',NULL,NULL,NULL,'b53a2a44-02af-4444-9380-b4c7ee5b6425'),
(4078,1123,NULL,2090,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:52:50','2025-10-13 17:52:50',NULL,NULL,NULL,'4f42082e-1068-4d7a-a690-a2e4afe8510b'),
(4080,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:53:05','2025-10-13 17:53:05',NULL,NULL,NULL,'4793d098-df4d-45d3-a379-25ee987a9fd6'),
(4081,1123,NULL,2091,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:53:11','2025-10-13 17:53:11',NULL,NULL,NULL,'77f6a796-8071-4115-8750-109cc6209d8a'),
(4083,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 17:54:18','2025-10-13 17:54:18',NULL,NULL,NULL,'3e0f4047-7feb-4766-943a-a55d52e0bb62'),
(4089,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'81685bd5-6bbc-4371-b6f1-a72bd2c00f99'),
(4090,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'b56634c1-f27a-45dc-8568-caa429f5c977'),
(4091,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'02e1059b-723e-436e-a06e-b8738b5b2046'),
(4092,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'42cab4fd-a418-46c9-8043-e0f67c60ddb4'),
(4093,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'5c34036b-6791-446f-a1b7-cef7b719a057'),
(4094,1129,NULL,2092,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'6d78e7b2-2680-4199-8e07-131a87092bd2'),
(4095,4089,NULL,2093,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'c33ce76e-3e0d-4593-a254-c7101899639c'),
(4096,4090,NULL,2094,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'1d227f57-f732-4f5d-86b3-11b780d31ce1'),
(4097,4091,NULL,2095,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'648da2bb-1cc2-4794-86be-ae22558b02a8'),
(4098,4092,NULL,2096,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'4ce071c4-a19a-4703-b95c-800186ee6175'),
(4099,4093,NULL,2097,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:55:52','2025-10-13 17:55:52',NULL,NULL,NULL,'7e6a70f3-bf6f-4a8e-8c4b-617cf3cb4f74'),
(4101,1129,NULL,2098,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:56:22','2025-10-13 17:56:22',NULL,NULL,NULL,'1a044971-0a78-4a13-953a-6786a06d353a'),
(4105,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 17:56:57','2025-10-13 17:57:21',NULL,NULL,NULL,'40e36cdd-9451-430a-a74a-caf5150785bf'),
(4106,1129,NULL,2099,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:57:28','2025-10-13 17:57:28',NULL,NULL,NULL,'f82d604b-399a-4a49-816b-0dfb7d018e55'),
(4107,1648,NULL,2100,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:57:28','2025-10-13 17:57:28',NULL,NULL,NULL,'d14c63f5-bbe2-4898-a00c-56a65e472c06'),
(4108,1649,NULL,2101,2,'craft\\elements\\Entry',1,0,'2025-10-13 17:57:28','2025-10-13 17:57:28',NULL,NULL,NULL,'63a37e93-74ce-484e-b349-8fe1a7d34df5'),
(4110,1143,NULL,2102,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:58:05','2025-10-13 17:58:05',NULL,NULL,NULL,'47fbca3f-8985-4d0e-a9b2-3efe7d88c667'),
(4117,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:21',NULL,NULL,NULL,'0be060e9-83d0-4186-8518-30d6c6836868'),
(4118,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:21',NULL,NULL,NULL,'5affa6aa-b918-4611-ba36-7ae7963bd0dd'),
(4119,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:21',NULL,NULL,NULL,'da352630-e965-4ed4-ad1a-15ef076621f7'),
(4120,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:21',NULL,NULL,NULL,'858a76da-ceaa-43d5-ad31-68dc64a8da98'),
(4121,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:21',NULL,NULL,NULL,'5cf3ce59-b2b9-4e7d-98c5-da8a2e4a7701'),
(4122,1143,NULL,2103,1,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:21',NULL,NULL,NULL,'253017e9-ebc0-4459-8503-9c1f9bc393b5'),
(4123,4117,NULL,2104,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:22',NULL,NULL,NULL,'bbeb1123-c632-4daa-8b2f-da7a2ea6670b'),
(4124,4118,NULL,2105,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:22',NULL,NULL,NULL,'351fbff7-0e2e-4e77-bea9-3f8798f7d745'),
(4125,4119,NULL,2106,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:22',NULL,NULL,NULL,'4d0db377-002b-4cda-a3b8-3967ecddf03b'),
(4126,4120,NULL,2107,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:22',NULL,NULL,NULL,'449e5ff4-a79b-4a38-8576-5dab5fb11cda'),
(4127,4121,NULL,2108,3,'craft\\elements\\Entry',1,0,'2025-10-13 17:59:21','2025-10-13 17:59:22',NULL,NULL,NULL,'b3075fb0-0fd3-44d8-ac47-06e66e71da34'),
(4131,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 18:00:02','2025-10-13 18:00:02',NULL,NULL,NULL,'725094e8-6c3d-4768-9f54-8a748b6e4e5e'),
(4132,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 18:00:02','2025-10-13 18:00:02',NULL,NULL,NULL,'b2e49f2c-9926-4f4c-9b45-e419dad94da4'),
(4133,1143,NULL,2109,1,'craft\\elements\\Entry',1,0,'2025-10-13 18:00:02','2025-10-13 18:00:02',NULL,NULL,NULL,'ee0b31cd-77a1-4dfb-9f82-43b90ba80ab6'),
(4134,4131,NULL,2110,3,'craft\\elements\\Entry',1,0,'2025-10-13 18:00:02','2025-10-13 18:00:02',NULL,NULL,NULL,'29b663f2-d287-46df-8efb-622e7e7d9c29'),
(4135,4132,NULL,2111,3,'craft\\elements\\Entry',1,0,'2025-10-13 18:00:02','2025-10-13 18:00:02',NULL,NULL,NULL,'3ffcb078-9b70-47f9-8246-dbf87e263c27'),
(4138,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 18:01:28','2025-10-13 18:01:28',NULL,NULL,NULL,'2902e679-f962-4baf-85c7-72231aae82f9'),
(4141,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 18:01:44','2025-10-13 18:01:44',NULL,NULL,NULL,'0b40b7d0-fd36-43ce-8b54-0c0064010888'),
(4142,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 18:02:04','2025-10-13 18:02:04',NULL,NULL,NULL,'695d4da6-e73f-4c2b-b1e8-b9fb08c01ffe'),
(4143,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-13 18:02:09','2025-10-13 18:02:09',NULL,NULL,NULL,'1de73e62-39e1-498c-9aeb-79ac75073e88'),
(4144,1143,NULL,2112,1,'craft\\elements\\Entry',1,0,'2025-10-13 18:02:09','2025-10-13 18:02:09',NULL,NULL,NULL,'b918d3a9-94dc-4a74-80e9-f674cc5737a6'),
(4145,4143,NULL,2113,2,'craft\\elements\\Entry',1,0,'2025-10-13 18:02:09','2025-10-13 18:02:09',NULL,NULL,NULL,'23ef7a3b-aee3-4315-931d-5ccbab55de8b'),
(4146,1660,NULL,2114,2,'craft\\elements\\Entry',1,0,'2025-10-13 18:02:09','2025-10-13 18:02:09',NULL,NULL,NULL,'8cd8f7df-db77-4ccc-80cc-b5fadb09f436'),
(4148,1149,NULL,2115,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:03:49','2025-10-13 19:03:49',NULL,NULL,NULL,'c623ea77-4216-43a6-8a4a-9c7463ebfa1f'),
(4150,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 19:05:27','2025-10-13 19:05:27',NULL,NULL,NULL,'ad23f0b4-70ac-4de9-8e6b-cb19a989f8f8'),
(4156,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'ba4cae3b-492a-45c1-b88a-1f9f33f2a214'),
(4157,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'3c7a713b-7dfe-4d5a-bc96-ed254af225bd'),
(4158,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'a10eef7b-857d-4360-b1ce-f556224eb3ac'),
(4159,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'774cdad5-67a4-414f-8a78-c60d82f3b52f'),
(4160,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'456ff720-95cc-4897-8af9-c15417234740'),
(4161,1149,NULL,2116,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'c0d8ac1e-4594-415d-9ea2-bdebe1b2e456'),
(4162,4156,NULL,2117,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'2f78cc4f-3bb9-4c9c-8f71-e574fea0cb78'),
(4163,4157,NULL,2118,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'981820fa-ac79-424b-836a-02fedf1405ad'),
(4164,4158,NULL,2119,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'99e7db5c-288e-4707-9871-439e378344e5'),
(4165,4159,NULL,2120,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'904243fb-729c-4877-89f0-d86eab1b73ba'),
(4166,4160,NULL,2121,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:10','2025-10-13 19:09:10',NULL,NULL,NULL,'0038bd1e-2d55-4045-9b0d-7c9f11cf3dca'),
(4168,1149,NULL,2122,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:09:29','2025-10-13 19:09:29',NULL,NULL,NULL,'788b59b7-177c-44e1-8b0e-df174360219a'),
(4172,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 19:10:22','2025-10-13 19:10:22',NULL,NULL,NULL,'7fd6c38a-924a-45ef-856e-b6b9ea0f5e44'),
(4174,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:10:27','2025-10-13 19:10:27',NULL,NULL,NULL,'740f9f9a-93fa-4dc8-a08f-f67ea762b6fc'),
(4175,1149,NULL,2123,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:10:27','2025-10-13 19:10:27',NULL,NULL,NULL,'dcd4db4f-7844-4181-ae1d-945d5ed9bd4f'),
(4176,4174,NULL,2124,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:10:27','2025-10-13 19:10:27',NULL,NULL,NULL,'69169515-6e5b-42be-a96d-2b74bce36527'),
(4177,1665,NULL,2125,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:10:27','2025-10-13 19:10:27',NULL,NULL,NULL,'b9d8d18d-354f-4dbf-bb07-143666fb0d30'),
(4179,1155,NULL,2126,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:11:14','2025-10-13 19:11:14',NULL,NULL,NULL,'e78e91b4-c172-47a7-abd1-6cfcefadeb88'),
(4181,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 19:12:28','2025-10-13 19:12:28',NULL,NULL,NULL,'1ae634c0-cef3-4ae8-b695-ac297934ddb5'),
(4182,1155,NULL,2127,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:14:26','2025-10-13 19:14:26',NULL,NULL,NULL,'e1585a80-855f-4690-bc75-04ba16d790be'),
(4189,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'bddaa596-6d19-4503-962d-00a06b113845'),
(4190,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'4450f04c-5cd5-4083-9949-bd15e7cea782'),
(4191,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'7e037ca1-b057-4df0-b0bb-d38a875efb6e'),
(4192,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'409c5942-be03-43e7-86ae-4f1ce2f1a1d2'),
(4193,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'ad691c87-2e0c-43cc-8adb-2b40a175fdd4'),
(4194,1155,NULL,2128,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'3dacb6e3-9908-4c2d-920f-80a5ff5dca08'),
(4195,4189,NULL,2129,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'a29bd748-d3f8-4c18-8c5d-d622d35ab7b6'),
(4196,4190,NULL,2130,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'1fafbc51-89f1-4ecb-9e48-78ef78f3628c'),
(4197,4191,NULL,2131,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'5d1148ee-8e1e-4d31-a982-094d737f7375'),
(4198,4192,NULL,2132,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'48de7f5f-075e-43d9-b44b-ec60d9c90df0'),
(4199,4193,NULL,2133,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:16:05','2025-10-13 19:16:05',NULL,NULL,NULL,'7dcd9ef7-ed88-4ba1-8ab1-154409f1d8ee'),
(4207,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 19:17:28','2025-10-13 19:17:28',NULL,NULL,NULL,'946bf00f-6b48-4ef5-bde0-ea4ac46d00bc'),
(4208,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 19:17:38','2025-10-13 19:17:38',NULL,NULL,NULL,'174aff5b-5db6-4b7e-9c63-e50708b6a8be'),
(4210,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'6e9fd1b9-8e40-49f7-88c6-ea1025a670ba'),
(4211,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'b45e1ef5-5a36-4ccd-8e1c-b6b6961b1815'),
(4212,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'0375b3b1-1523-40c6-ad39-deef55dd5fd5'),
(4213,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'e6ff9754-28a3-4dc2-add7-a77d70ecf4bc'),
(4214,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'ee8f28f5-016e-46e3-8478-129c575bcf27'),
(4215,1155,NULL,2134,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'35d08a65-ae19-4646-9f1a-3f0dd55fbcbc'),
(4216,4210,NULL,2135,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'a7c337ce-7acb-4908-a613-37a6d85038bf'),
(4217,4211,NULL,2136,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'7e7cd301-99fc-452d-b93f-bae04bacf20a'),
(4218,4212,NULL,2137,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'870a853b-8311-40d3-92b7-eba16183905f'),
(4219,4213,NULL,2138,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'10ad3944-5954-43e9-9519-04b027d372fd'),
(4220,4214,NULL,2139,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'af31d3d3-2cb4-488c-b55a-10fb3f1c915e'),
(4221,1670,NULL,2140,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:24:55','2025-10-13 19:24:55',NULL,NULL,NULL,'47093c9a-6098-4fb7-8982-097dde1c3a1c'),
(4223,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 19:26:37','2025-10-13 19:26:37',NULL,NULL,NULL,'9000a937-4f22-424a-bf55-fbc1c23c7adb'),
(4224,1165,NULL,2141,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:27:40','2025-10-13 19:27:41',NULL,NULL,NULL,'54528f8a-8527-457f-9921-5e3917eecd0d'),
(4231,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'4992795a-fe66-41fc-9c25-4626afacfaca'),
(4232,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'f86004ff-378b-4b98-ac62-afd6bd096cc9'),
(4233,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'f0f229e0-7dc4-48d9-b4af-6cb3c64dbec1'),
(4234,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'8f7b4d4b-af9a-4600-9dd1-a66353756090'),
(4235,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'7d9447b6-8bf1-46e0-9d4a-fbecbc6f04dd'),
(4236,1165,NULL,2142,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'09ca3029-94d6-4df6-9294-c3fbe07ebb0a'),
(4237,4231,NULL,2143,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'cf0ffa1b-b0d8-42d8-a573-e9741906219b'),
(4238,4232,NULL,2144,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'9a5bf88f-8347-4008-be94-348db544d8f9'),
(4239,4233,NULL,2145,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'519e32c3-5435-417b-8371-4384808d8761'),
(4240,4234,NULL,2146,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'f925457f-27aa-4f8a-88a7-543cb547137f'),
(4241,4235,NULL,2147,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:00','2025-10-13 19:29:00',NULL,NULL,NULL,'f72f5b93-ce2c-45bd-95c2-17f4f56b2fcf'),
(4243,1165,NULL,2148,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:29:18','2025-10-13 19:29:18',NULL,NULL,NULL,'66d4469f-d785-4e43-b07d-33ffa5020b88'),
(4246,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-13 19:29:49','2025-10-13 19:29:49',NULL,NULL,NULL,'c249c36b-8c67-41ca-b805-e5a914aecad1'),
(4248,1165,NULL,2149,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:30:02','2025-10-13 19:30:02',NULL,NULL,NULL,'ff0b2076-2997-4d88-81b7-bb1a0db6e312'),
(4249,1677,NULL,2150,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:30:02','2025-10-13 19:30:03',NULL,NULL,NULL,'fc2d75b4-0612-4e62-b351-5d7d07f203e4'),
(4250,1678,NULL,2151,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:30:02','2025-10-13 19:30:03',NULL,NULL,NULL,'e1537adf-909f-4928-9409-833d841658d4'),
(4252,1165,NULL,2152,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:30:06','2025-10-13 19:30:06',NULL,NULL,NULL,'d40d682c-d9b4-46f0-9ff3-921ce74bb4d5'),
(4254,1171,NULL,2153,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:30:40','2025-10-13 19:30:40',NULL,NULL,NULL,'e2f7827e-38d7-4bb6-8a4b-b2b8d65f9ed9'),
(4261,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'21e9a836-77b2-4142-928c-105a7d8b7e0e'),
(4262,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'d8c486f7-7acc-4461-bd7e-4ce4f44ad92d'),
(4263,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'c1175a17-87b4-41e1-9a58-f07c21080351'),
(4264,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'58723179-c356-485b-ab03-861666d659a1'),
(4265,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'b2d3a936-66e9-4499-8845-f1d9b295ba61'),
(4266,1171,NULL,2154,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'0f640bc8-6baa-4685-b95e-71bcac28db27'),
(4267,4261,NULL,2155,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'e29ed76a-7ef9-47d4-9b84-b4e1e90f0a61'),
(4268,4262,NULL,2156,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'293ce225-ed38-471a-befc-ca727029971b'),
(4269,4263,NULL,2157,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'6465eb73-c99d-44d0-819a-f0129bbd0628'),
(4270,4264,NULL,2158,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'29ef6ba4-6ed7-4a21-9b23-0db2c4cff918'),
(4271,4265,NULL,2159,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:31:57','2025-10-13 19:31:57',NULL,NULL,NULL,'d55d0d80-53c0-402b-b56b-df91dc76f906'),
(4276,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 19:34:09','2025-10-13 19:34:09',NULL,NULL,NULL,'b2efb3ab-b61c-4207-91fa-84eed33e027d'),
(4277,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:34:44','2025-10-13 19:34:44',NULL,NULL,NULL,'7391c03a-3ffc-457c-932d-ef6a5ca26e29'),
(4278,1171,NULL,2160,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:34:44','2025-10-13 19:34:44',NULL,NULL,NULL,'80e1b5f0-0b97-4137-88ba-c51b511a714c'),
(4279,4277,NULL,2161,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:34:44','2025-10-13 19:34:44',NULL,NULL,NULL,'a709c094-80f2-4722-ad60-55534021ba67'),
(4280,1682,NULL,2162,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:34:44','2025-10-13 19:34:44',NULL,NULL,NULL,'0c9b9280-5870-4595-943b-cb4cf4a144c0'),
(4281,1683,NULL,2163,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:34:44','2025-10-13 19:34:44',NULL,NULL,NULL,'6ba4d252-d3fc-44fd-8364-d53f6971e2e2'),
(4282,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 19:36:07','2025-10-13 19:36:07',NULL,NULL,NULL,'c492aeca-56fc-4b46-91d7-4ebfcdda17d5'),
(4289,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'bb7c2c0c-e89a-4e4e-9e7c-4d4e46e5b8f5'),
(4290,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'0c6abb15-e685-477a-9d16-28390372afe5'),
(4291,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'332a9fe0-6943-467f-9e14-f4566cea1241'),
(4292,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'aaee8434-f389-4ec5-aeb5-0dbd2e028eac'),
(4293,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'0f04f331-644c-402d-93f9-1e87f0f48835'),
(4294,1177,NULL,2164,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'555db4d6-448b-418e-8f51-a0dde12716a9'),
(4295,4289,NULL,2165,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'26f65cf3-ecb7-448e-ba66-3a19b2f91cc7'),
(4296,4290,NULL,2166,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'cc3a27a0-0faf-4196-a41f-e31c48c3aba6'),
(4297,4291,NULL,2167,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'09bda69b-8dbb-4a50-aabc-9aad0f4da605'),
(4298,4292,NULL,2168,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'64e2b939-f78c-4431-a60b-6c29ee6afbc0'),
(4299,4293,NULL,2169,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:45','2025-10-13 19:37:45',NULL,NULL,NULL,'46bc35e9-87c2-4865-a81b-6cd67046c191'),
(4301,1177,NULL,2170,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:37:58','2025-10-13 19:37:58',NULL,NULL,NULL,'4ecb78d7-9669-42a6-93a7-b4054ab3f37e'),
(4306,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:00','2025-10-13 19:39:00',NULL,NULL,NULL,'b05b9be9-a134-4cbc-b62a-d561f285211d'),
(4307,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:00','2025-10-13 19:39:00',NULL,NULL,NULL,'1d46c9fd-5073-4975-92ed-ec2b875aa71e'),
(4308,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:00','2025-10-13 19:39:00',NULL,NULL,NULL,'759db7d4-e50e-4e79-925c-f61ecaf511a5'),
(4309,1177,NULL,2171,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:38:59','2025-10-13 19:39:00',NULL,NULL,NULL,'8d41802e-4231-4bed-97dd-862cd6900f05'),
(4310,4306,NULL,2172,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:00','2025-10-13 19:39:00',NULL,NULL,NULL,'f5630e4a-8b08-465b-8e17-86989062e1ad'),
(4311,4307,NULL,2173,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:00','2025-10-13 19:39:00',NULL,NULL,NULL,'6b4f7c51-05c9-4238-a451-769c4a38bd69'),
(4312,4308,NULL,2174,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:00','2025-10-13 19:39:00',NULL,NULL,NULL,'d5fc3ba4-ce5f-4c4e-a972-2ad963b3b3e3'),
(4316,1177,NULL,2175,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:32','2025-10-13 19:39:32',NULL,NULL,NULL,'72d74b7e-f94d-4ede-a4b8-a82d4983a8e7'),
(4317,1692,NULL,2176,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:32','2025-10-13 19:39:32',NULL,NULL,NULL,'063c5698-cfdb-4ec3-8700-8c9a4e638c46'),
(4318,1693,NULL,2177,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:39:32','2025-10-13 19:39:32',NULL,NULL,NULL,'e5130c4c-748d-46af-9f6d-a88c49176077'),
(4322,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-13 19:47:23','2025-10-13 19:47:23',NULL,NULL,NULL,'ad68b265-d96d-45d0-a725-496e94ae61cb'),
(4323,1185,NULL,2178,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:47:44','2025-10-13 19:47:44',NULL,NULL,NULL,'66911b05-f718-406e-ad87-73455ed96d5f'),
(4324,1694,NULL,2179,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:47:44','2025-10-13 19:47:44',NULL,NULL,NULL,'8400e6f2-1548-4b71-aea0-8926cb69fc35'),
(4325,1695,NULL,2180,2,'craft\\elements\\Entry',1,0,'2025-10-13 19:47:44','2025-10-13 19:47:44',NULL,NULL,NULL,'dc3ca947-74b8-4bbc-862a-8109839efde7'),
(4332,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'2da53d05-df77-4d94-ac1c-d9589849bcd7'),
(4333,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'88d5e36d-acec-4e4d-96d4-50abada30ed2'),
(4334,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'d16578b8-99ea-45a9-acf9-9413622cf3b7'),
(4335,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'2bb4b4aa-7cc5-47e9-b14b-fef23d31759a'),
(4336,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'3c1092e8-e7ce-4961-b496-7baed3de9c92'),
(4337,1185,NULL,2181,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'7778e6bf-63c5-4583-8cd2-6e51be0a53fa'),
(4338,4332,NULL,2182,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'de979bd4-a980-4626-b766-f56a00a1bb5e'),
(4339,4333,NULL,2183,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'611e8e6d-19d3-4c3e-b655-4a965757b295'),
(4340,4334,NULL,2184,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'8cbdc2ec-0f84-4c4f-aecf-06ad46af66a8'),
(4341,4335,NULL,2185,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'48057c68-636c-4d10-aec2-ae821469301a'),
(4342,4336,NULL,2186,3,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:09','2025-10-13 19:51:09',NULL,NULL,NULL,'dc85a8f9-d4f6-4a31-9eeb-7a02d77e78fe'),
(4344,1185,NULL,2187,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:30','2025-10-13 19:51:30',NULL,NULL,NULL,'b38e5158-8a13-4ed9-beaa-018786a2bcb1'),
(4345,1185,NULL,2188,1,'craft\\elements\\Entry',1,0,'2025-10-13 19:51:50','2025-10-13 19:51:50',NULL,NULL,NULL,'90993f04-07ed-47e7-ba53-2c8bc106af05'),
(4349,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-14 13:43:17','2025-10-14 13:43:17',NULL,NULL,NULL,'26c87cbe-ce40-4b6e-a39b-ae11425a8bbb'),
(4350,1443,NULL,2189,1,'craft\\elements\\Entry',1,0,'2025-10-14 13:43:52','2025-10-14 13:43:52',NULL,NULL,NULL,'17370d28-0907-4e32-9718-f8b7291211f4'),
(4351,1911,NULL,2190,2,'craft\\elements\\Entry',1,0,'2025-10-14 13:43:52','2025-10-14 13:43:52',NULL,NULL,NULL,'695d05f1-19e6-4113-98cc-86fd5bccec7a'),
(4353,945,NULL,2191,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:13:45','2025-10-14 16:13:46',NULL,NULL,NULL,'aaf734fc-149a-4608-8754-20fff11c0b0b'),
(4354,999,NULL,2192,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:14:34','2025-10-14 16:14:34',NULL,NULL,NULL,'d454a10b-c028-471b-9971-36bf13421108'),
(4355,1539,NULL,2193,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:14:34','2025-10-14 16:14:34',NULL,NULL,NULL,'fc6e7931-49f4-4a71-a1d4-59018a3fd6b8'),
(4356,1540,NULL,2194,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:14:34','2025-10-14 16:14:34',NULL,NULL,NULL,'5bce45d5-b380-4207-a683-ec94887c1340'),
(4358,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 16:46:42','2025-10-14 16:46:42',NULL,NULL,NULL,'f0e54b99-ba93-4326-ab74-edec09ee7518'),
(4365,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'65f2f2ca-f79d-446a-a26c-9f658bc96563'),
(4366,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'712ff4db-3260-4ea5-99ad-c5b0222ec4e1'),
(4367,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'56880df3-d534-4703-bcec-f46a9a57e461'),
(4368,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'8da4231c-6709-47b3-b86c-f90434936d13'),
(4369,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'58e72202-fa22-4dba-b888-8ea40e36b20c'),
(4370,1191,NULL,2195,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'6d73eb79-4ee9-492f-b94c-7433de282658'),
(4371,4365,NULL,2196,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'cc885001-c609-4809-930f-7fc29b667370'),
(4372,4366,NULL,2197,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'7827d3e1-4a72-434f-8221-13bb164caae2'),
(4373,4367,NULL,2198,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'6fda258c-87b1-469a-99c4-95197bb871f9'),
(4374,4368,NULL,2199,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'ba7df0b5-3d0e-4746-85ed-576bbefb5454'),
(4375,4369,NULL,2200,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:02','2025-10-14 16:48:02',NULL,NULL,NULL,'03ce2209-a6cb-40bd-8d01-ed684cc14084'),
(4377,1191,NULL,2201,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:48:25','2025-10-14 16:48:25',NULL,NULL,NULL,'ec5cb8fe-1cce-40b3-962f-6fecf24ce906'),
(4381,1191,NULL,2202,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:49:14','2025-10-14 16:49:14',NULL,NULL,NULL,'c8886d75-c546-46dc-a68a-bcfcb0bd07d8'),
(4382,1699,NULL,2203,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:49:14','2025-10-14 16:49:14',NULL,NULL,NULL,'5b0d0e80-4f94-4c3c-b3d4-10ebf3dfc9d7'),
(4383,1700,NULL,2204,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:49:14','2025-10-14 16:49:14',NULL,NULL,NULL,'6e26ddff-bb96-4a06-827d-a4fc65d1dd58'),
(4385,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 16:50:16','2025-10-14 16:50:16',NULL,NULL,NULL,'a7467d5a-c4a8-4c8f-ae77-a82d8324af8e'),
(4391,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'3b776065-9769-4b76-9953-fc959490780b'),
(4392,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'dfb79b5e-9633-46ca-ac48-957db45bc3f4'),
(4393,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'38188e70-73c6-414f-85a2-b1cf920290c5'),
(4394,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'2f5d31af-4820-4a14-b441-87e9deb1b919'),
(4395,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'51888495-0b79-4d66-b219-b72a1d2452ef'),
(4396,1197,NULL,2205,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'f09638bd-ce63-4b80-8feb-861ef5426b89'),
(4397,4391,NULL,2206,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'aceaa5dc-494a-4d87-9b4e-9c4e74635a0f'),
(4398,4392,NULL,2207,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'86a0c1c2-bbf0-48bd-8d3f-45312c012f36'),
(4399,4393,NULL,2208,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'5af57da1-de2b-4abf-85ad-444f82fff67e'),
(4400,4394,NULL,2209,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'96f2e5a6-a427-4850-8ca0-96b1c5670309'),
(4401,4395,NULL,2210,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:02','2025-10-14 16:52:02',NULL,NULL,NULL,'a2026e3b-ecbd-4674-9eff-7ed9fdd4793c'),
(4403,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:31','2025-10-14 16:52:36',NULL,NULL,NULL,'65df3a5d-a5e7-4bc3-8e2c-ae52f22451e9'),
(4404,4403,NULL,2211,6,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:36','2025-10-14 16:52:36',NULL,NULL,NULL,'34f205d3-853a-44b7-96c0-01f10a709d8b'),
(4405,1197,NULL,2212,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:52:41','2025-10-14 16:52:41',NULL,NULL,NULL,'6331f429-7e69-44cb-8f29-6601f1c5a663'),
(4409,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:53:18','2025-10-14 16:53:18',NULL,NULL,NULL,'f13aa7c3-d27c-4ec5-841a-526c90d2c82f'),
(4410,1197,NULL,2213,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:53:18','2025-10-14 16:53:18',NULL,NULL,NULL,'f8036931-5620-4273-98d2-57666543bb80'),
(4411,4409,NULL,2214,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:53:18','2025-10-14 16:53:18',NULL,NULL,NULL,'c86a5173-61e2-4caf-b1b6-a9e2ea9fca6e'),
(4412,1704,NULL,2215,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:53:18','2025-10-14 16:53:18',NULL,NULL,NULL,'7196f9c8-e1d3-4063-90c3-9f5a148c22e1'),
(4414,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 16:54:20','2025-10-14 16:54:20',NULL,NULL,NULL,'3fbb3e40-782e-436f-a493-605911155328'),
(4420,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'16d6b673-3735-4c33-b22d-720587a88f75'),
(4421,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'bf51a0f4-a9a4-484d-b5f9-ece81eb87250'),
(4422,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'2086f450-f1d2-4ac3-81f8-d8ae0b1f7492'),
(4423,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'63ee4371-2a12-4c3f-8d26-85b2e6f11f53'),
(4424,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'6e136f21-4c99-45b4-919f-990a2481d1a9'),
(4425,1201,NULL,2216,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'027be2ca-3329-4bd6-8d3f-8d4348e1a1b1'),
(4426,4420,NULL,2217,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'b7104d75-70bd-4633-b6b8-bcb8fc8542d5'),
(4427,4421,NULL,2218,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'e96b9f14-8b1a-46aa-9b12-d4cf44060735'),
(4428,4422,NULL,2219,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'efbf2462-d6bc-4c15-972c-3ae9086da66b'),
(4429,4423,NULL,2220,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'192a5ba2-7cd6-4761-a8b5-32fd257b0c71'),
(4430,4424,NULL,2221,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:55:56','2025-10-14 16:55:56',NULL,NULL,NULL,'1f54ff0e-28db-463c-8f7f-88737dbcff07'),
(4432,1201,NULL,2222,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:56:21','2025-10-14 16:56:21',NULL,NULL,NULL,'2c617e62-1244-410d-a2f4-f05cede03da2'),
(4436,1201,NULL,2223,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:56:56','2025-10-14 16:56:56',NULL,NULL,NULL,'2393e587-ae26-441d-9828-a13813aea517'),
(4437,1708,NULL,2224,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:56:56','2025-10-14 16:56:56',NULL,NULL,NULL,'cd47e4f9-5fae-4f7d-98b3-d63e53f9241c'),
(4438,1709,NULL,2225,2,'craft\\elements\\Entry',1,0,'2025-10-14 16:56:56','2025-10-14 16:56:56',NULL,NULL,NULL,'319af4b3-eaae-4388-87fa-b9fe27ddd382'),
(4440,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 16:57:51','2025-10-14 16:57:51',NULL,NULL,NULL,'ebbd20f1-f103-4d3d-9db5-46ea4b8a9118'),
(4446,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:10',NULL,NULL,NULL,'1703f52a-3e84-41fe-a9e4-d3b514e8c876'),
(4447,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:10',NULL,NULL,NULL,'c0d66d10-577c-4a20-8696-22d1f3631f68'),
(4448,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:10',NULL,NULL,NULL,'00550f30-b927-41bf-8909-5d0f12a9fbd0'),
(4449,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:10',NULL,NULL,NULL,'465cf671-1b88-4dec-a0ba-64a9d68f2e18'),
(4450,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:10',NULL,NULL,NULL,'169c27d5-b5eb-4311-abad-ebfb4f293306'),
(4451,1209,NULL,2226,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:11',NULL,NULL,NULL,'8367eb40-bdff-4f82-894d-c2f9a05b2fc9'),
(4452,4446,NULL,2227,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:11',NULL,NULL,NULL,'9552799c-f8ca-4e16-bf8d-c32f005e19b8'),
(4453,4447,NULL,2228,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:11',NULL,NULL,NULL,'e53caff2-244a-4943-a046-34c705051337'),
(4454,4448,NULL,2229,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:11',NULL,NULL,NULL,'33877028-9f8e-4da0-a13a-635fcd76a268'),
(4455,4449,NULL,2230,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:11',NULL,NULL,NULL,'cd5a4a37-dd66-4fb0-b0d6-550769344bae'),
(4456,4450,NULL,2231,3,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:10','2025-10-14 16:59:11',NULL,NULL,NULL,'6ebb1ee3-ebcc-477b-8b98-4110b616d907'),
(4458,1209,NULL,2232,1,'craft\\elements\\Entry',1,0,'2025-10-14 16:59:35','2025-10-14 16:59:36',NULL,NULL,NULL,'5d84ab35-4c0c-4c5f-bc51-ae686ce5a714'),
(4462,1209,NULL,2233,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:00:06','2025-10-14 17:00:06',NULL,NULL,NULL,'4e3470ce-3cb6-4f5c-918c-69734c1651ea'),
(4463,1714,NULL,2234,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:00:06','2025-10-14 17:00:06',NULL,NULL,NULL,'25ebf60f-ed86-4bf9-89e3-1fd020566153'),
(4464,1715,NULL,2235,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:00:06','2025-10-14 17:00:06',NULL,NULL,NULL,'29bbeb15-85b7-4463-9370-59d8283296b6'),
(4466,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:00:49','2025-10-14 17:01:23',NULL,NULL,NULL,'0d32fdfc-d798-44f1-8d0f-d4bb1f2ea650'),
(4467,1215,NULL,2236,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:01:41','2025-10-14 17:01:41',NULL,NULL,NULL,'5323273b-c84e-47fc-8310-1c3ed7b0291f'),
(4474,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'182a432b-e782-4a30-86a3-3e8b8dde3667'),
(4475,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'5ff7ae57-b076-4b8d-bde7-974eed4f1da0'),
(4476,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'f05f92af-59c8-488a-b259-2160eaf71228'),
(4477,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'0b248ef0-b462-4adf-87c5-f197c9a1dc92'),
(4478,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'b3947e95-1681-49c2-86f8-1a2bc85bd274'),
(4479,1215,NULL,2237,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'35759317-7f82-4415-af03-acc41865763a'),
(4480,4474,NULL,2238,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'6088b5ea-258a-4207-82b7-dbe771cdd567'),
(4481,4475,NULL,2239,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'bb6a5c3f-46f4-4d9d-8df9-ed14cd9a1ab9'),
(4482,4476,NULL,2240,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'fb2cde6c-fb8d-4ca0-825f-cdbe5a8704db'),
(4483,4477,NULL,2241,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'2d8837f9-3d74-4267-a500-20a2f925d8c8'),
(4484,4478,NULL,2242,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:02:50','2025-10-14 17:02:50',NULL,NULL,NULL,'ed8e85c8-1a42-46f6-a91e-9daab2bacf66'),
(4486,1215,NULL,2243,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:04:16','2025-10-14 17:04:16',NULL,NULL,NULL,'6a7f4763-eada-4cfa-9268-9bd2820108ed'),
(4488,1215,NULL,2244,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:04:31','2025-10-14 17:04:31',NULL,NULL,NULL,'47ed21f0-b9ba-4295-a7a0-5397423cfef3'),
(4492,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:05:13','2025-10-14 17:05:13',NULL,NULL,NULL,'74f7669b-8d72-4f8f-8de1-3312065b8c33'),
(4493,1215,NULL,2245,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:05:13','2025-10-14 17:05:13',NULL,NULL,NULL,'7edec2de-38e7-442b-9143-f5f423ceeda0'),
(4494,4492,NULL,2246,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:05:13','2025-10-14 17:05:13',NULL,NULL,NULL,'84cb1bb0-58a7-49f1-b56b-428a51e8da79'),
(4495,1719,NULL,2247,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:05:13','2025-10-14 17:05:13',NULL,NULL,NULL,'487b40e1-fc24-468b-a1e7-c5cf186ffa5f'),
(4497,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:06:55','2025-10-14 17:06:55',NULL,NULL,NULL,'ec8d0fcf-8ac8-4baa-b864-904846e06352'),
(4504,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'f64812bb-9517-495d-9fb0-04b029d93f68'),
(4505,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'63dcfdcd-f90a-4dfb-ba21-0c424dec1e67'),
(4506,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'e4fb2a50-0323-4b9f-9423-30b2a16f433e'),
(4507,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'345aab99-8935-4c41-b53c-565b593b3ff5'),
(4508,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'cb6d7e9e-5896-4468-805e-f44517e528d2'),
(4509,1219,NULL,2248,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'bd30ee7a-8b05-4e55-814c-bd8924f0e68d'),
(4510,4504,NULL,2249,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'e89979ce-a905-4636-9aa4-d8ef513fbae1'),
(4511,4505,NULL,2250,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'9f7cda5d-8893-4945-92d5-dab22b354730'),
(4512,4506,NULL,2251,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'91ec56e4-b950-4548-ac5e-d6e9ade12049'),
(4513,4507,NULL,2252,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'1472bf84-0694-4d9b-b8a1-57d690dea452'),
(4514,4508,NULL,2253,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:08:27','2025-10-14 17:08:27',NULL,NULL,NULL,'34c23816-09d3-44aa-adf4-59190c0b9784'),
(4518,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-14 17:09:05','2025-10-14 17:09:05',NULL,NULL,NULL,'9236c29d-3afb-4e93-b233-74cf198a6ed1'),
(4519,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-14 17:09:11','2025-10-14 17:09:11',NULL,NULL,NULL,'277bfa08-6dfe-47fb-8671-0742e04a0cde'),
(4521,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:09:21','2025-10-14 17:09:21',NULL,NULL,NULL,'0a20cad6-20e4-426e-871e-a3a800d2aaaa'),
(4522,1219,NULL,2254,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:09:21','2025-10-14 17:09:21',NULL,NULL,NULL,'26c097af-a01d-4b8b-a557-fe0c4e86401e'),
(4523,4521,NULL,2255,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:09:21','2025-10-14 17:09:21',NULL,NULL,NULL,'63c83e86-b79a-48d9-ac53-1fb07cf50d25'),
(4524,1723,NULL,2256,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:09:21','2025-10-14 17:09:21',NULL,NULL,NULL,'f9f688a7-90d8-4b18-bfca-daacba56ec6a'),
(4526,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:10:03','2025-10-14 17:10:03',NULL,NULL,NULL,'eef3aeff-d250-4872-ae9d-3275ee45b3c0'),
(4527,1225,NULL,2257,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:10:19','2025-10-14 17:10:19',NULL,NULL,NULL,'923ca987-a0d8-4141-8dc0-207868537b4c'),
(4534,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'1387671e-81ca-4d10-ba20-5cd59efb6018'),
(4535,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'b772059b-e929-4a9f-b47b-9fe8d27f1d68'),
(4536,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'92a30bf9-3196-453a-a243-f5d40378969d'),
(4537,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'5d7d8add-d5c1-47f8-ab4d-6f1cd5b3f0ed'),
(4538,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'cac93746-fc44-4ecb-a6e7-3397d2c972d3'),
(4539,1225,NULL,2258,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'4280ec76-40a2-4b1f-abe5-1ff3eaae5de5'),
(4540,4534,NULL,2259,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'c18863d4-3a67-49e5-9b44-2bc3ae683139'),
(4541,4535,NULL,2260,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'7b38d9ec-5862-4e56-a1b6-96fc1dc10cf4'),
(4542,4536,NULL,2261,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'d377b785-e362-42ec-a313-aa8663effb89'),
(4543,4537,NULL,2262,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'83627a76-0e3d-492f-8cff-4ca25e457297'),
(4544,4538,NULL,2263,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:27','2025-10-14 17:11:27',NULL,NULL,NULL,'320e081f-81e4-49cf-8589-2f862964c7c6'),
(4546,1225,NULL,2264,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:11:44','2025-10-14 17:11:44',NULL,NULL,NULL,'db1d1a9b-cbea-4520-a808-3c9f98958e4e'),
(4550,1225,NULL,2265,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:12:18','2025-10-14 17:12:18',NULL,NULL,NULL,'b5bd7fa7-d08a-4bc8-b2d9-61ed0ae4bfc8'),
(4551,1727,NULL,2266,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:12:18','2025-10-14 17:12:18',NULL,NULL,NULL,'cbed09d5-9702-46bc-9c7a-3f0d96255787'),
(4552,1728,NULL,2267,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:12:18','2025-10-14 17:12:18',NULL,NULL,NULL,'54501edd-af7e-43f7-ae40-7a242811cab8'),
(4554,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:13:18','2025-10-14 17:13:18',NULL,NULL,NULL,'cef852d6-2fb5-4519-b0ff-d89f0605f204'),
(4562,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-14 17:15:24','2025-10-14 17:15:24',NULL,NULL,NULL,'600068fb-ff31-411e-a90e-487c38e9fae6'),
(4564,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'eed3a0df-460e-48c4-b3a0-dd6c8c2896a3'),
(4565,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'06d9c88d-b971-4654-8dfa-3068dea739e3'),
(4566,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'dc9f7aa8-9707-4692-abad-e4c1ea1ecf09'),
(4567,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'ccee82cc-0492-4171-ae1f-b739d2757ffa'),
(4568,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'5ce11069-c659-4e7b-8c1d-20e59a75eaa7'),
(4569,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'f3dc5f4a-0775-4a23-800f-1203e9bed476'),
(4570,1231,NULL,2268,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'7afd1984-958e-4420-9cd2-f3d4a6c385de'),
(4571,4564,NULL,2269,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'b8578131-53e5-4e6b-b5d0-08a4f5eb337e'),
(4572,4565,NULL,2270,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'30b42fa2-aba5-4e4c-a2dc-273b57c351f3'),
(4573,4566,NULL,2271,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'0fd5ccd7-d4d2-45af-9191-4033166157ab'),
(4574,4567,NULL,2272,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'2162c72f-fe52-4262-9fd9-4af809230213'),
(4575,4568,NULL,2273,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'2632f0dd-494d-48da-aece-f704468fac70'),
(4576,1732,NULL,2274,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'ee1af10e-450e-4ead-8544-5048bca7b3ea'),
(4577,4569,NULL,2275,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:15:30','2025-10-14 17:15:30',NULL,NULL,NULL,'13da8c3e-621a-4b1c-b573-82200a2b1c1d'),
(4579,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:19:40','2025-10-14 17:19:40',NULL,NULL,NULL,'05b33ae5-ec78-4ebf-b8ee-1ae6710a6347'),
(4580,NULL,1236,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:19:54','2025-10-14 17:19:54',NULL,NULL,NULL,'753410f0-a89e-40fa-9da7-231bbeb0f409'),
(4586,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'7ad8ebd9-a3e2-4600-82f2-a65a4e356091'),
(4587,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'668b57c8-d8f7-4a46-9ad3-85c67e9c0f62'),
(4588,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'af19ece0-a23f-4636-8789-aa0eb064226b'),
(4589,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'e5c24651-bbf2-4dcb-aa17-6ad71472be3d'),
(4590,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'60a0dbf2-4f7e-4136-a2a9-54a2be87c234'),
(4591,1237,NULL,2276,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'e7f7c738-cb8a-46eb-ab6d-fd1b66262f91'),
(4592,4586,NULL,2277,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'a0020084-73cf-4f4b-a4ba-eea7891065d7'),
(4593,4587,NULL,2278,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'36b93d8c-1f2e-4f18-9eaf-1f3ff6217511'),
(4594,4588,NULL,2279,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'cb6498e0-5092-46b6-8c1f-8689536bb6c5'),
(4595,4589,NULL,2280,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'9acae0cb-ffe9-4f35-9fd5-352d1d64d28f'),
(4596,4590,NULL,2281,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:05','2025-10-14 17:21:05',NULL,NULL,NULL,'5c7dcf55-a18d-4b00-997f-b93704f0f08e'),
(4598,1237,NULL,2282,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:21:31','2025-10-14 17:21:31',NULL,NULL,NULL,'abe725f4-503a-4cae-b29f-bdf5a0ddcc4f'),
(4602,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-14 17:22:03','2025-10-14 17:22:03',NULL,NULL,NULL,'383a6331-11d5-40c8-81cd-0607c4cf5bdb'),
(4604,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:22:21','2025-10-14 17:22:21',NULL,NULL,NULL,'76635f82-2344-4382-a6c1-b3b7f934e3e7'),
(4605,1237,NULL,2283,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:22:21','2025-10-14 17:22:21',NULL,NULL,NULL,'41695181-4550-4b7f-ab45-e6761cba831f'),
(4606,4604,NULL,2284,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:22:21','2025-10-14 17:22:21',NULL,NULL,NULL,'d7e8df2d-bdd1-427c-9f67-3a1e35e8f18e'),
(4607,1737,NULL,2285,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:22:21','2025-10-14 17:22:21',NULL,NULL,NULL,'b3cad4f2-662b-4176-8e79-f1a5edf15e1e'),
(4608,1738,NULL,2286,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:22:21','2025-10-14 17:22:21',NULL,NULL,NULL,'99a63734-b4f3-4a3d-a767-663202692d5b'),
(4610,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:22:39','2025-10-14 17:22:39',NULL,NULL,NULL,'fdd5d51e-e354-4dc3-9fd5-bcaba5dbb2b5'),
(4620,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-14 17:25:09','2025-10-14 17:25:09',NULL,NULL,NULL,'74796526-0a42-4379-9ac8-35185d91c54d'),
(4621,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'457c889c-9d82-45fd-af37-25fa40acf6e5'),
(4622,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'7d78fb89-f54b-45ab-a32d-6e414dd5d11c'),
(4623,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'043a221b-80b5-4fab-9a1e-6e331b8fef90'),
(4624,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'be0f3e5e-432b-4c9d-bddf-d4348c9e4df6'),
(4625,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'a3db911a-d735-4aaa-8923-b01c0a50f2e3'),
(4626,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'55ed1e62-5782-4a35-88b4-1298eae4fc89'),
(4627,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'faccd65c-4e98-4888-8cf1-7c1250326c6f'),
(4628,1243,NULL,2287,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'1daa7fd9-3dc6-4e3b-b604-ee487dab060b'),
(4629,4621,NULL,2288,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'2f607fe7-fd6d-45f7-98fc-db98e1cf6373'),
(4630,4622,NULL,2289,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'24b875b6-767d-4f49-8696-2e7eb440d14a'),
(4631,4623,NULL,2290,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'0d328628-ba9a-473b-a6fd-f716f717cef5'),
(4632,4624,NULL,2291,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'dcec9424-6738-4fb8-b479-17e2ab94714d'),
(4633,4625,NULL,2292,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'f452a690-392a-460c-983f-a9a25fbc81ed'),
(4634,4626,NULL,2293,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'cc59f994-c547-4b8a-bfe0-ae37c63f9317'),
(4635,4627,NULL,2294,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'807bc6f6-93ff-493c-b532-c9511c188cc3'),
(4636,1742,NULL,2295,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'83d04946-40da-4282-afad-119663375a3a'),
(4637,1743,NULL,2296,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:25:14','2025-10-14 17:25:14',NULL,NULL,NULL,'2a68ab8b-0908-499d-a18d-db7682c9efcc'),
(4639,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-14 17:25:32','2025-10-14 17:25:32',NULL,NULL,NULL,'74593d4f-e93c-4be4-92ec-014eacadbcd6'),
(4645,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'0e702e8a-e341-45c4-97df-72c181ea7994'),
(4646,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'bad14890-e510-4357-bee8-b0b3794a1923'),
(4647,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'ac378203-56ce-489b-9e06-153ad7823d6a'),
(4648,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'23468d9c-8484-442d-9ff4-31092d7a7add'),
(4649,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'ab6bc909-f6de-484e-9a62-59750bfd55be'),
(4650,1249,NULL,2297,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'64e385be-6057-4b44-8933-c1207fab5e0b'),
(4651,4645,NULL,2298,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'4be058f4-0c90-4731-802c-35f66c2e6cba'),
(4652,4646,NULL,2299,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'09a01c49-a1d3-4d56-bc4e-3ad5f5e132ff'),
(4653,4647,NULL,2300,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'8b1bb8ba-221f-4b5d-ba39-cde94be186f0'),
(4654,4648,NULL,2301,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'5e46dc51-f861-4e30-a40b-687ac6b5d06a'),
(4655,4649,NULL,2302,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:27:20','2025-10-14 17:27:20',NULL,NULL,NULL,'93656225-8e67-4043-82bd-0ffe3ce27796'),
(4660,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:28:10','2025-10-14 17:28:10',NULL,NULL,NULL,'10e12fd7-e5d3-46a4-baa3-188fd6ef0612'),
(4661,1249,NULL,2303,1,'craft\\elements\\Entry',1,0,'2025-10-14 17:28:09','2025-10-14 17:28:10',NULL,NULL,NULL,'4ceb31fb-5899-4005-9e38-740ad54babb0'),
(4662,4660,NULL,2304,3,'craft\\elements\\Entry',1,0,'2025-10-14 17:28:10','2025-10-14 17:28:10',NULL,NULL,NULL,'70cb7f38-49c8-4f10-8d0a-d9c96c251617'),
(4663,1747,NULL,2305,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:28:10','2025-10-14 17:28:10',NULL,NULL,NULL,'3d870c27-a45d-4bbb-ad5b-e1741bdfad80'),
(4664,1748,NULL,2306,2,'craft\\elements\\Entry',1,0,'2025-10-14 17:28:10','2025-10-14 17:28:10',NULL,NULL,NULL,'b75d6c0f-ba4b-4571-bf91-14a97e12cbd4'),
(4666,1481,NULL,2307,1,'craft\\elements\\Entry',1,0,'2025-10-14 20:32:10','2025-10-14 20:32:11',NULL,NULL,NULL,'9d0f1764-93cc-41d0-b219-16f4eb6b7cbc'),
(4668,1473,NULL,2308,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:16:00','2025-10-16 19:16:00',NULL,NULL,NULL,'f9afb73a-d7be-4f58-91fc-19cd970ce311'),
(4670,1473,NULL,2309,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:16:56','2025-10-16 19:16:56',NULL,NULL,NULL,'6a6d191d-920d-40b6-8fad-e8e14a7b31a0'),
(4674,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:18:57','2025-10-16 19:18:57',NULL,NULL,NULL,'fbd37b4c-3ee5-4e6e-96fd-2e6890abf734'),
(4675,1473,NULL,2310,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:18:56','2025-10-16 19:18:57',NULL,NULL,NULL,'1213038a-d086-4519-8002-90362dbcafd7'),
(4676,1935,NULL,2311,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:18:56','2025-10-16 19:18:57',NULL,NULL,NULL,'599d06d9-6cc5-4b7f-b9dd-5216dc01e0b0'),
(4677,4674,NULL,2312,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:18:57','2025-10-16 19:18:57',NULL,NULL,NULL,'91d17638-5c30-4b0c-a090-bad014627de7'),
(4679,1477,NULL,2313,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:19:28','2025-10-16 19:19:28',NULL,NULL,NULL,'a93bf8df-fd4d-486c-a098-d8427ec86674'),
(4681,1477,NULL,2314,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:19:52','2025-10-16 19:19:52',NULL,NULL,NULL,'31a56416-a8be-4f9b-8142-a72dcbc90354'),
(4683,1477,NULL,2315,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:20:30','2025-10-16 19:20:30',NULL,NULL,NULL,'ee5df520-098e-4b42-8319-40b516bc7b06'),
(4687,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:21:39','2025-10-16 19:21:39',NULL,NULL,NULL,'d2038a75-b8b6-4834-b69b-aecdebbfc4b0'),
(4688,1477,NULL,2316,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:21:39','2025-10-16 19:21:39',NULL,NULL,NULL,'a19273b7-d279-4649-ad42-8d7e38bf4439'),
(4689,1938,NULL,2317,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:21:39','2025-10-16 19:21:39',NULL,NULL,NULL,'3df73f4e-5719-42f2-8c34-fa69abe66925'),
(4690,4687,NULL,2318,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:21:39','2025-10-16 19:21:39',NULL,NULL,NULL,'8e8df349-71ae-4c28-9fbf-abd27c82dc6f'),
(4692,1481,NULL,2319,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:22:12','2025-10-16 19:22:12',NULL,NULL,NULL,'967c485a-f58a-4ea7-8002-5e49ad57d0b6'),
(4694,1481,NULL,2320,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:22:20','2025-10-16 19:22:21',NULL,NULL,NULL,'28de5d00-dd4c-4901-93a8-c311076939df'),
(4696,1481,NULL,2321,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:22:51','2025-10-16 19:22:51',NULL,NULL,NULL,'8ad33643-7085-4473-acc2-7711530a532f'),
(4700,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:23:32','2025-10-16 19:23:32',NULL,NULL,NULL,'d13c6438-2e1a-4a10-8926-b89b3716428c'),
(4701,1481,NULL,2322,1,'craft\\elements\\Entry',1,0,'2025-10-16 19:23:32','2025-10-16 19:23:32',NULL,NULL,NULL,'906198c9-aab0-4d1f-b20e-8c0979d57859'),
(4702,1941,NULL,2323,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:23:32','2025-10-16 19:23:32',NULL,NULL,NULL,'0b6800da-7ec9-4778-a329-abd93467f4c9'),
(4703,4700,NULL,2324,2,'craft\\elements\\Entry',1,0,'2025-10-16 19:23:32','2025-10-16 19:23:32',NULL,NULL,NULL,'f608a7da-2528-46c3-ab5b-1baa561302b5'),
(4704,1255,NULL,2325,1,'craft\\elements\\Entry',1,0,'2025-10-16 20:22:32','2025-10-16 20:22:32',NULL,NULL,NULL,'41cb8070-3d63-404f-a000-5e57771e069f'),
(4705,2882,1285,NULL,1,'craft\\elements\\Entry',1,0,'2025-10-22 18:19:28','2025-10-22 18:19:28',NULL,'2025-10-22 18:20:00',NULL,'8b5bbc16-6955-418d-a07d-0fd7a088f6f0'),
(4706,1437,NULL,2326,1,'craft\\elements\\Entry',1,0,'2025-10-22 18:20:15','2025-10-22 18:20:15',NULL,NULL,NULL,'8f0080f8-74d4-4d05-b204-0be9d78dade2'),
(4707,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-22 23:42:42','2025-10-22 23:42:42',NULL,NULL,NULL,'29bbd7b6-11b1-49e9-8e0c-935df9a51681'),
(4708,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-22 23:42:50','2025-10-22 23:42:50',NULL,NULL,NULL,'85f021f8-9e3e-44a3-a5e3-1ea5a5fe4bf0'),
(4710,1437,NULL,2327,1,'craft\\elements\\Entry',1,0,'2025-10-22 23:46:58','2025-10-22 23:46:58',NULL,NULL,NULL,'b37d08a9-0ed9-4ef8-8674-f40e25d732ec'),
(4712,1437,NULL,2328,1,'craft\\elements\\Entry',1,0,'2025-10-22 23:47:07','2025-10-22 23:47:07',NULL,NULL,NULL,'9b4b6d0b-5784-437c-a2e8-d637c2fd55de'),
(4713,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-22 23:50:26','2025-10-22 23:50:26',NULL,NULL,NULL,'7a23257d-71ad-4481-87a6-c1a404b346f4'),
(4714,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-22 23:51:07','2025-10-22 23:51:07',NULL,NULL,NULL,'ba3c2822-1050-4855-b9c6-403513f16941'),
(4716,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:10:04','2025-10-23 00:10:04',NULL,NULL,NULL,'dd667d04-54fb-44d4-9c05-a4d480a92ff1'),
(4717,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 00:10:19','2025-10-23 00:10:19',NULL,NULL,NULL,'3218d1a8-c417-4f60-9421-9872e405ae06'),
(4718,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:17:45','2025-10-23 00:17:45',NULL,NULL,NULL,'56c85468-bb1c-4e9a-977c-ee15b038f8a2'),
(4719,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 00:18:05','2025-10-23 00:18:05',NULL,NULL,NULL,'df317cb1-b81c-4aee-be1b-4bb027da8613'),
(4720,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:20:15','2025-10-23 00:20:15',NULL,NULL,NULL,'74182867-2ee6-4181-8ed6-1cbe72dd2fca'),
(4721,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 00:20:22','2025-10-23 00:20:22',NULL,NULL,NULL,'ee3302d4-5e8e-471c-a1c7-8e5bda60cbef'),
(4722,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:22:05','2025-10-23 00:22:05',NULL,NULL,NULL,'6896d554-4993-4d93-a4d0-73af086ca151'),
(4723,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 00:22:25','2025-10-23 00:22:25',NULL,NULL,NULL,'6cfbb12e-96a0-463a-b99c-e5532ff1ae99'),
(4724,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:25:34','2025-10-23 00:25:34',NULL,NULL,NULL,'c0e2bc14-cb69-46dd-a602-9c886b48ce54'),
(4725,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 00:25:39','2025-10-23 00:25:39',NULL,NULL,NULL,'dde0d2af-216e-469a-871c-d00cc519a098'),
(4726,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:33:13','2025-10-23 00:33:13',NULL,NULL,NULL,'35ccae51-8aba-47fd-b222-cf792fcc9e12'),
(4727,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 00:33:17','2025-10-23 00:33:17',NULL,NULL,NULL,'39486025-b223-4129-a126-b7bd75705e0e'),
(4728,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:34:41','2025-10-23 00:34:41',NULL,NULL,NULL,'91c1fdcd-6700-4cc2-afce-71812abb4549'),
(4729,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 00:34:45','2025-10-23 00:34:45',NULL,NULL,NULL,'08fbc6f5-7320-41ba-8795-f66cacbcf2e6'),
(4730,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 00:52:01','2025-10-23 00:52:01',NULL,NULL,NULL,'86a80071-5350-42c8-bed7-a2560fccd00c'),
(4731,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 00:52:31','2025-10-23 00:52:31',NULL,NULL,NULL,'e9e496bf-ab54-44d8-acd4-7709d99e707f'),
(4732,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:05:29','2025-10-23 01:05:29',NULL,NULL,NULL,'30818cba-d2e5-4621-84cb-f2ca982dc5ca'),
(4733,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 01:05:46','2025-10-23 01:05:46',NULL,NULL,NULL,'c216027f-d561-44fa-aa29-fc68292746a7'),
(4734,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:09:45','2025-10-23 01:09:45',NULL,NULL,NULL,'e0e3ecaf-87ca-4a89-9acd-ab7aab201579'),
(4735,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 01:09:49','2025-10-23 01:09:49',NULL,NULL,NULL,'348d885c-fc81-4aeb-9c58-19c37fbda9cf'),
(4736,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:11:03','2025-10-23 01:11:03',NULL,NULL,NULL,'ace48b90-eaf4-4c4f-a0c0-81d226b766c2'),
(4737,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:11:44','2025-10-23 01:11:44',NULL,NULL,NULL,'6bbaca74-7dde-4323-b985-a9678bbfc61a'),
(4738,NULL,NULL,NULL,24,'craft\\elements\\Asset',1,0,'2025-10-23 01:11:44','2025-10-23 01:11:44',NULL,NULL,NULL,'8d6f3c11-9037-46cb-8cd4-234bf975f70f'),
(4739,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:12:39','2025-10-23 01:12:39',NULL,NULL,NULL,'f59036b0-5d28-4369-a0da-179f9da2d154'),
(4740,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:12:49','2025-10-23 01:12:49',NULL,NULL,NULL,'088ebcb3-0291-4e3a-a023-dc4262a0e478'),
(4741,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:13:08','2025-10-23 01:13:08',NULL,NULL,NULL,'86efacc0-a0e2-4813-8af8-5a1594658b9c'),
(4742,NULL,NULL,NULL,24,'craft\\elements\\Asset',1,0,'2025-10-23 01:13:08','2025-10-23 01:13:08',NULL,NULL,NULL,'e654a4c8-648e-4fc8-bda5-f13003785bf7'),
(4743,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 01:13:12','2025-10-23 01:13:12',NULL,NULL,NULL,'b771e9d9-a801-422b-8d30-df07521c8bf4'),
(4744,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 01:13:13','2025-10-23 01:13:13',NULL,NULL,NULL,'a4ae6aff-e3d9-46c5-9fa3-b84b391ed2ad'),
(4745,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 01:13:13','2025-10-23 01:13:13',NULL,NULL,NULL,'4dbbc635-252f-47e5-8f19-4a99afd7d8cd'),
(4746,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 01:13:13','2025-10-23 01:13:13',NULL,NULL,NULL,'4d1babc5-f929-4733-b60e-a898b2db919c'),
(4747,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 01:13:13','2025-10-23 01:13:13',NULL,NULL,NULL,'02c70e66-2d5c-4b56-9403-64fd47ef2916'),
(4748,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:20:15','2025-10-23 01:20:15',NULL,NULL,NULL,'17ed538a-43b2-47b2-952b-d96fa26c294c'),
(4749,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:21:51','2025-10-23 01:21:51',NULL,NULL,NULL,'5902870a-1bbc-49dd-ace0-b2be8a2ac54b'),
(4750,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 01:21:59','2025-10-23 01:21:59',NULL,NULL,NULL,'c18e13c9-a8f2-4787-bbac-8a46c20ddf84'),
(4751,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 01:22:00','2025-10-23 01:22:00',NULL,NULL,NULL,'abbaacaf-2377-424e-b071-c24e448fad90'),
(4752,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:22:16','2025-10-23 01:22:16',NULL,NULL,NULL,'208c5b19-b632-4b7e-a114-5d66310e1e48'),
(4753,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:24:10','2025-10-23 01:24:10',NULL,NULL,NULL,'d32523f7-f8b4-477b-9104-3b832d8403f9'),
(4754,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Submission',1,0,'2025-10-23 01:27:32','2025-10-23 01:27:32',NULL,NULL,NULL,'892582f2-a589-4cd6-8fb4-cc0b5247fb8d'),
(4755,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 01:28:01','2025-10-23 01:28:01',NULL,NULL,NULL,'ca7d0b58-d279-4f6c-8d64-291f4dfe4fdb'),
(4756,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 01:28:01','2025-10-23 01:28:01',NULL,NULL,NULL,'ff7ae05e-3cb6-4df0-84ad-e5a27f4592d9'),
(4757,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\SentNotification',1,0,'2025-10-23 01:28:01','2025-10-23 01:28:01',NULL,NULL,NULL,'b64328ab-0d05-4afc-ab5b-228339136f61'),
(4758,1437,NULL,2329,1,'craft\\elements\\Entry',1,0,'2025-10-23 01:33:57','2025-10-23 01:33:57',NULL,NULL,NULL,'fde6898d-be84-4920-bb51-c4017964d0e1'),
(4759,2,NULL,2330,1,'craft\\elements\\Entry',1,0,'2025-10-23 01:34:07','2025-10-23 01:34:07',NULL,NULL,NULL,'7fa3fd59-fc02-43af-b19a-1cb4d543ff70'),
(4760,2,NULL,2331,1,'craft\\elements\\Entry',1,0,'2025-10-23 01:39:13','2025-10-23 01:39:13',NULL,NULL,NULL,'2ecdf06d-e3f6-46c9-bec6-e9cf7177196f');
/*!40000 ALTER TABLE `elements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements_bulkops`
--

LOCK TABLES `elements_bulkops` WRITE;
/*!40000 ALTER TABLE `elements_bulkops` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `elements_bulkops` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements_owners`
--

LOCK TABLES `elements_owners` WRITE;
/*!40000 ALTER TABLE `elements_owners` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements_owners` VALUES
(8,2,1),
(44,2,1),
(45,2,2),
(46,2,3),
(47,2,4),
(56,2,1),
(57,2,2),
(63,2,3),
(72,2,1),
(73,2,2),
(74,2,3),
(75,2,4),
(76,2,5),
(96,2,1),
(97,2,2),
(98,2,3),
(99,2,4),
(100,2,5),
(101,2,6),
(131,2,1),
(132,2,2),
(420,553,1),
(420,566,1),
(420,568,1),
(420,570,1),
(420,575,1),
(420,577,1),
(420,581,1),
(420,586,1),
(420,592,1),
(420,596,1),
(420,599,1),
(421,553,2),
(421,566,2),
(421,568,2),
(421,570,2),
(421,575,2),
(421,577,2),
(421,581,2),
(421,586,2),
(421,592,2),
(421,596,2),
(421,599,2),
(426,553,1),
(426,566,1),
(426,568,1),
(426,570,1),
(426,575,1),
(426,577,1),
(426,581,1),
(427,553,2),
(427,566,2),
(427,568,2),
(427,570,2),
(427,575,2),
(427,577,2),
(427,581,2),
(428,553,3),
(428,566,3),
(428,568,3),
(428,570,3),
(428,575,3),
(428,577,3),
(428,581,3),
(429,553,1),
(429,566,1),
(429,568,1),
(429,570,1),
(429,575,1),
(429,577,1),
(429,581,1),
(430,553,2),
(430,566,2),
(430,568,2),
(430,570,2),
(430,575,2),
(430,577,2),
(430,581,2),
(431,553,3),
(431,566,3),
(431,568,3),
(431,570,3),
(431,575,3),
(431,577,3),
(431,581,3),
(432,553,4),
(432,566,4),
(432,568,4),
(432,570,4),
(432,575,4),
(432,577,4),
(432,581,4),
(433,553,5),
(433,566,5),
(433,568,5),
(433,570,5),
(433,575,5),
(433,577,5),
(433,581,5),
(445,2,1),
(587,586,1),
(587,592,1),
(587,596,1),
(587,599,1),
(587,625,1),
(587,627,1),
(587,630,1),
(587,636,1),
(587,640,1),
(587,647,1),
(588,586,2),
(588,592,2),
(588,596,2),
(588,599,2),
(588,625,2),
(588,627,2),
(588,630,2),
(588,636,2),
(588,640,2),
(588,647,2),
(589,586,3),
(593,592,3),
(597,596,3),
(597,599,3),
(597,625,3),
(597,627,3),
(597,630,3),
(597,636,3),
(597,640,3),
(597,647,3),
(637,636,1),
(637,640,1),
(637,647,1),
(638,636,1),
(638,640,1),
(638,647,1),
(649,648,1),
(650,648,2),
(651,648,3),
(652,648,1),
(653,648,1),
(835,834,1),
(835,932,1),
(836,834,2),
(836,932,2),
(837,834,3),
(837,932,3),
(838,834,1),
(838,932,1),
(839,834,1),
(839,932,1),
(937,2,1),
(938,2,1),
(940,939,1),
(941,939,2),
(942,939,3),
(943,939,1),
(944,939,1),
(946,945,1),
(947,945,1),
(949,948,1),
(950,948,1),
(952,951,1),
(953,951,1),
(955,954,1),
(956,954,1),
(958,957,1),
(959,957,1),
(961,960,1),
(962,960,1),
(964,963,1),
(965,963,1),
(967,966,1),
(968,966,1),
(970,969,1),
(971,969,1),
(973,972,1),
(974,972,1),
(976,975,1),
(977,975,1),
(979,978,1),
(980,978,1),
(982,981,1),
(983,981,1),
(984,981,1),
(986,985,1),
(987,985,1),
(988,985,1),
(990,989,1),
(991,989,1),
(993,992,1),
(994,992,1),
(996,995,1),
(998,997,1),
(1000,999,1),
(1001,999,1),
(1003,1002,1),
(1004,1002,1),
(1006,1005,1),
(1007,1005,1),
(1009,1008,1),
(1010,1008,1),
(1012,1011,1),
(1013,1011,1),
(1015,1014,1),
(1016,1014,1),
(1018,1017,1),
(1019,1017,1),
(1021,1020,1),
(1022,1020,1),
(1024,1023,1),
(1025,1023,1),
(1026,1023,1),
(1028,1027,1),
(1029,1027,1),
(1030,1027,1),
(1032,1031,1),
(1034,1033,1),
(1036,1035,1),
(1037,1035,1),
(1039,1038,1),
(1040,1038,1),
(1042,1041,1),
(1044,1043,1),
(1046,1045,1),
(1047,1045,1),
(1049,1048,1),
(1050,1048,1),
(1052,1051,1),
(1053,1051,1),
(1054,1051,1),
(1056,1055,1),
(1057,1055,1),
(1058,1055,1),
(1060,1059,1),
(1061,1059,1),
(1062,1059,1),
(1064,1063,1),
(1065,1063,1),
(1066,1063,1),
(1068,1067,1),
(1069,1067,1),
(1071,1070,1),
(1072,1070,1),
(1074,1073,1),
(1074,3831,1),
(1075,1073,1),
(1075,3831,1),
(1077,1076,1),
(1078,1076,1),
(1080,1079,1),
(1081,1079,1),
(1083,1082,1),
(1084,1082,1),
(1086,1085,1),
(1087,1085,1),
(1089,1088,1),
(1090,1088,1),
(1092,1091,1),
(1093,1091,1),
(1095,1094,1),
(1096,1094,1),
(1098,1097,1),
(1099,1097,1),
(1101,1100,1),
(1102,1100,1),
(1104,1103,1),
(1105,1103,1),
(1107,1106,1),
(1108,1106,1),
(1110,1109,1),
(1111,1109,1),
(1112,1109,1),
(1114,1113,1),
(1115,1113,1),
(1116,1113,1),
(1118,1117,1),
(1119,1117,1),
(1121,1120,1),
(1122,1120,1),
(1124,1123,1),
(1125,1123,1),
(1127,1126,1),
(1128,1126,1),
(1130,1129,1),
(1131,1129,1),
(1133,1132,1),
(1134,1132,1),
(1136,1135,1),
(1137,1135,1),
(1139,1138,1),
(1140,1138,1),
(1144,1143,1),
(1145,1143,1),
(1147,1146,1),
(1148,1146,1),
(1150,1149,1),
(1151,1149,1),
(1153,1152,1),
(1154,1152,1),
(1156,1155,1),
(1157,1155,1),
(1159,1158,1),
(1160,1158,1),
(1162,1161,1),
(1164,1163,1),
(1166,1165,1),
(1167,1165,1),
(1169,1168,1),
(1170,1168,1),
(1172,1171,1),
(1173,1171,1),
(1175,1174,1),
(1176,1174,1),
(1178,1177,1),
(1179,1177,1),
(1181,1180,1),
(1182,1180,1),
(1183,1177,1),
(1184,1177,1),
(1186,1185,1),
(1187,1185,1),
(1189,1188,1),
(1190,1188,1),
(1192,1191,1),
(1193,1191,1),
(1195,1194,1),
(1196,1194,1),
(1198,1197,1),
(1200,1199,1),
(1202,1201,1),
(1203,1201,1),
(1204,1201,1),
(1206,1205,1),
(1207,1205,1),
(1208,1205,1),
(1210,1209,1),
(1211,1209,1),
(1213,1212,1),
(1214,1212,1),
(1216,1215,1),
(1218,1217,1),
(1220,1219,1),
(1221,1219,1),
(1223,1222,1),
(1224,1222,1),
(1226,1225,1),
(1227,1225,1),
(1229,1228,1),
(1230,1228,1),
(1232,1231,1),
(1233,1231,1),
(1235,1234,1),
(1236,1234,1),
(1238,1237,1),
(1239,1237,1),
(1241,1240,1),
(1242,1240,1),
(1244,1243,1),
(1245,1243,1),
(1247,1246,1),
(1248,1246,1),
(1250,1249,1),
(1251,1249,1),
(1253,1252,1),
(1254,1252,1),
(1256,1255,1),
(1257,1255,1),
(1259,1258,1),
(1260,1258,1),
(1262,1261,1),
(1263,1261,1),
(1264,1261,1),
(1266,1265,1),
(1267,1265,1),
(1268,1265,1),
(1270,1269,1),
(1271,1269,1),
(1272,1269,1),
(1274,1273,1),
(1275,1273,1),
(1276,1273,1),
(1278,1277,1),
(1279,1277,1),
(1281,1280,1),
(1282,1280,1),
(1284,1283,1),
(1285,1283,1),
(1287,1286,1),
(1288,1286,1),
(1290,1289,1),
(1290,2923,1),
(1291,1289,1),
(1291,2923,1),
(1292,1289,1),
(1292,2923,1),
(1294,1293,1),
(1295,1293,1),
(1296,1293,1),
(1298,1297,1),
(1299,1297,1),
(1301,1300,1),
(1302,1300,1),
(1304,1303,1),
(1305,1303,1),
(1307,1306,1),
(1308,1306,1),
(1310,1309,1),
(1311,1309,1),
(1313,1312,1),
(1314,1312,1),
(1316,1315,1),
(1317,1315,1),
(1318,1315,1),
(1320,1319,1),
(1321,1319,1),
(1322,1319,1),
(1324,1323,1),
(1325,1323,1),
(1327,1326,1),
(1328,1326,1),
(1330,1329,1),
(1331,1329,1),
(1332,1329,1),
(1334,1333,1),
(1335,1333,1),
(1336,1333,1),
(1338,1337,1),
(1339,1337,1),
(1341,1340,1),
(1342,1340,1),
(1344,1343,1),
(1345,1343,1),
(1347,1346,1),
(1348,1346,1),
(1350,1349,1),
(1352,1351,1),
(1354,1353,1),
(1355,1353,1),
(1357,1356,1),
(1358,1356,1),
(1360,1359,1),
(1361,1359,1),
(1363,1362,1),
(1364,1362,1),
(1366,1365,1),
(1367,1365,1),
(1369,1368,1),
(1370,1368,1),
(1372,1371,1),
(1373,1371,1),
(1375,1374,1),
(1376,1374,1),
(1378,1377,1),
(1379,1377,1),
(1381,1380,1),
(1382,1380,1),
(1384,1383,1),
(1385,1383,1),
(1387,1386,1),
(1388,1386,1),
(1390,1389,1),
(1391,1389,1),
(1393,1392,1),
(1394,1392,1),
(1396,1395,1),
(1397,1395,1),
(1399,1398,1),
(1400,1398,1),
(1402,1401,1),
(1403,1401,1),
(1405,1404,1),
(1406,1404,1),
(1408,1407,1),
(1409,1407,1),
(1411,1410,1),
(1412,1410,1),
(1414,1413,1),
(1415,1413,1),
(1417,1416,1),
(1418,1416,1),
(1420,1419,1),
(1421,1419,1),
(1423,1422,1),
(1424,1422,1),
(1426,1425,1),
(1427,1425,1),
(1429,1428,1),
(1430,1428,1),
(1432,1431,1),
(1433,1431,1),
(1435,1434,1),
(1436,1434,1),
(1438,1437,1),
(1439,1437,1),
(1441,1440,1),
(1442,1440,1),
(1444,1443,1),
(1445,1443,1),
(1447,1446,1),
(1448,1446,1),
(1450,1449,1),
(1451,1449,1),
(1453,1452,1),
(1454,1452,1),
(1456,1455,1),
(1457,1455,1),
(1459,1458,1),
(1460,1458,1),
(1462,1461,1),
(1463,1461,1),
(1465,1464,1),
(1466,1464,1),
(1468,1467,1),
(1469,1467,1),
(1471,1470,1),
(1472,1470,1),
(1474,1473,1),
(1476,1475,1),
(1478,1477,1),
(1480,1479,1),
(1482,1481,1),
(1484,1483,1),
(1486,2,1),
(1487,2,1),
(1489,1488,1),
(1489,1953,1),
(1489,2210,1),
(1490,1488,2),
(1490,1953,2),
(1490,2210,2),
(1491,1488,3),
(1491,1953,3),
(1491,2210,3),
(1492,1488,1),
(1492,1953,1),
(1492,2210,1),
(1493,1488,1),
(1493,1953,1),
(1493,2210,1),
(1494,945,1),
(1495,945,1),
(1497,1496,1),
(1497,1965,1),
(1497,2212,1),
(1497,2214,1),
(1498,1496,1),
(1498,1965,1),
(1498,2212,1),
(1498,2214,1),
(1499,951,1),
(1500,951,1),
(1502,1501,1),
(1502,1967,1),
(1502,2216,1),
(1503,1501,1),
(1503,1967,1),
(1503,2216,1),
(1504,957,1),
(1505,957,1),
(1507,1506,1),
(1507,1975,1),
(1508,1506,1),
(1508,1975,1),
(1509,963,1),
(1510,963,1),
(1512,1511,1),
(1512,1977,1),
(1513,1511,1),
(1513,1977,1),
(1514,969,1),
(1515,969,1),
(1517,1516,1),
(1517,1995,1),
(1518,1516,1),
(1518,1995,1),
(1519,975,1),
(1520,975,1),
(1522,1521,1),
(1522,2011,1),
(1523,1521,1),
(1523,2011,1),
(1524,981,1),
(1525,981,1),
(1526,981,1),
(1528,1527,1),
(1528,2041,1),
(1529,1527,1),
(1529,2041,1),
(1530,1527,1),
(1530,2041,1),
(1531,989,1),
(1532,989,1),
(1534,1533,1),
(1534,2051,1),
(1535,1533,1),
(1535,2051,1),
(1536,995,1),
(1538,1537,1),
(1538,2055,1),
(1539,999,1),
(1540,999,1),
(1542,1541,1),
(1542,2162,1),
(1543,1541,1),
(1543,2162,1),
(1544,1005,1),
(1545,1005,1),
(1547,1546,1),
(1547,2075,1),
(1548,1546,1),
(1548,2075,1),
(1549,1011,1),
(1550,1011,1),
(1552,1551,1),
(1552,2085,1),
(1553,1551,1),
(1553,2085,1),
(1554,1017,1),
(1555,1017,1),
(1557,1556,1),
(1557,2160,1),
(1558,1556,1),
(1558,2160,1),
(1559,1023,1),
(1560,1023,1),
(1561,1023,1),
(1563,1562,1),
(1563,2158,1),
(1564,1562,1),
(1564,2158,1),
(1565,1562,1),
(1565,2158,1),
(1566,1031,1),
(1568,1567,1),
(1568,2129,1),
(1569,1035,1),
(1570,1035,1),
(1572,1571,1),
(1572,2133,1),
(1573,1571,1),
(1573,2133,1),
(1574,1041,1),
(1576,1575,1),
(1576,2135,1),
(1577,1045,1),
(1578,1045,1),
(1580,1579,1),
(1580,1950,1),
(1580,1952,1),
(1580,1960,1),
(1580,2220,1),
(1581,1579,1),
(1581,1950,1),
(1581,1952,1),
(1581,1960,1),
(1581,2220,1),
(1582,1051,1),
(1583,1051,1),
(1584,1051,1),
(1586,1585,1),
(1586,1979,1),
(1586,1981,1),
(1587,1585,1),
(1587,1979,1),
(1587,1981,1),
(1588,1585,1),
(1588,1979,1),
(1588,1981,1),
(1589,1059,1),
(1590,1059,1),
(1591,1059,1),
(1593,1592,1),
(1593,1991,1),
(1594,1592,1),
(1594,1991,1),
(1595,1592,1),
(1595,1991,1),
(1596,1067,1),
(1597,1067,1),
(1599,1598,1),
(1599,2013,1),
(1600,1598,1),
(1600,2013,1),
(1601,1073,1),
(1601,3831,1),
(1602,1073,1),
(1602,3831,1),
(1604,1603,1),
(1604,2039,1),
(1605,1603,1),
(1605,2039,1),
(1606,1079,1),
(1607,1079,1),
(1609,1608,1),
(1609,2059,1),
(1610,1608,1),
(1610,2059,1),
(1611,1085,1),
(1612,1085,1),
(1614,1613,1),
(1614,2079,1),
(1615,1613,1),
(1615,2079,1),
(1616,1091,1),
(1617,1091,1),
(1619,1618,1),
(1619,2087,1),
(1620,1618,1),
(1620,2087,1),
(1621,1097,1),
(1622,1097,1),
(1624,1623,1),
(1624,2089,1),
(1624,2091,1),
(1625,1623,1),
(1625,2089,1),
(1625,2091,1),
(1626,1103,1),
(1627,1103,1),
(1629,1628,1),
(1629,2095,1),
(1630,1628,1),
(1630,2095,1),
(1631,1109,1),
(1632,1109,1),
(1633,1109,1),
(1635,1634,1),
(1635,2156,1),
(1636,1634,1),
(1636,2156,1),
(1637,1634,1),
(1637,2156,1),
(1638,1117,1),
(1639,1117,1),
(1641,1640,1),
(1641,2154,1),
(1642,1640,1),
(1642,2154,1),
(1643,1123,1),
(1644,1123,1),
(1646,1645,1),
(1646,2139,1),
(1647,1645,1),
(1647,2139,1),
(1648,1129,1),
(1649,1129,1),
(1651,1650,1),
(1651,2141,1),
(1652,1650,1),
(1652,2141,1),
(1653,1135,1),
(1654,1135,1),
(1656,1655,1),
(1656,2145,1),
(1657,1655,1),
(1657,2145,1),
(1659,1143,1),
(1660,1143,1),
(1662,1661,1),
(1662,2152,1),
(1663,1661,1),
(1663,2152,1),
(1664,1149,1),
(1665,1149,1),
(1667,1666,1),
(1667,2105,1),
(1667,2107,1),
(1667,4148,1),
(1667,4161,1),
(1667,4168,1),
(1668,1666,1),
(1668,2105,1),
(1668,2107,1),
(1668,4148,1),
(1668,4161,1),
(1668,4168,1),
(1669,1155,1),
(1670,1155,1),
(1672,1671,1),
(1672,2109,1),
(1673,1671,1),
(1673,2109,1),
(1674,1161,1),
(1676,1675,1),
(1676,1985,1),
(1676,2206,1),
(1677,1165,1),
(1678,1165,1),
(1680,1679,1),
(1680,1956,1),
(1680,1958,1),
(1681,1679,1),
(1681,1956,1),
(1681,1958,1),
(1682,1171,1),
(1683,1171,1),
(1685,1684,1),
(1685,1963,1),
(1686,1684,1),
(1686,1963,1),
(1687,1177,1),
(1688,1177,1),
(1690,1689,1),
(1691,1689,1),
(1692,1177,1),
(1693,1177,1),
(1694,1185,1),
(1695,1185,1),
(1697,1696,1),
(1697,1983,1),
(1697,2170,1),
(1698,1696,1),
(1698,1983,1),
(1698,2170,1),
(1699,1191,1),
(1700,1191,1),
(1702,1701,1),
(1702,1999,1),
(1702,2176,1),
(1703,1701,1),
(1703,1999,1),
(1703,2176,1),
(1704,1197,1),
(1706,1705,1),
(1706,2024,1),
(1706,2182,1),
(1707,1201,1),
(1708,1201,1),
(1709,1201,1),
(1711,1710,1),
(1711,2026,1),
(1711,2184,1),
(1712,1710,1),
(1712,2026,1),
(1712,2184,1),
(1713,1710,1),
(1713,2026,1),
(1713,2184,1),
(1714,1209,1),
(1715,1209,1),
(1717,1716,1),
(1717,2030,1),
(1717,2190,1),
(1718,1716,1),
(1718,2030,1),
(1718,2190,1),
(1719,1215,1),
(1721,1720,1),
(1721,2043,1),
(1721,2197,1),
(1722,1219,1),
(1723,1219,1),
(1725,1724,1),
(1725,2057,1),
(1726,1724,1),
(1726,2057,1),
(1727,1225,1),
(1728,1225,1),
(1730,1729,1),
(1730,2071,1),
(1730,2073,1),
(1731,1729,1),
(1731,2071,1),
(1731,2073,1),
(1732,1231,1),
(1733,1231,1),
(1735,1734,1),
(1735,2093,1),
(1735,2203,1),
(1736,1734,1),
(1736,2093,1),
(1736,2203,1),
(1737,1237,1),
(1738,1237,1),
(1740,1739,1),
(1740,2097,1),
(1741,1739,1),
(1741,2097,1),
(1742,1243,1),
(1743,1243,1),
(1745,1744,1),
(1745,2099,1),
(1745,2103,1),
(1746,1744,1),
(1746,2099,1),
(1746,2103,1),
(1747,1249,1),
(1748,1249,1),
(1750,1749,1),
(1750,2137,1),
(1751,1749,1),
(1751,2137,1),
(1752,1255,1),
(1753,1255,1),
(1755,1754,1),
(1755,1945,1),
(1755,1961,1),
(1755,2164,1),
(1755,2207,1),
(1756,1754,1),
(1756,1945,1),
(1756,1961,1),
(1756,2164,1),
(1756,2207,1),
(1757,1261,1),
(1758,1261,1),
(1759,1261,1),
(1761,1760,1),
(1761,1969,1),
(1761,2166,1),
(1762,1760,1),
(1762,1969,1),
(1762,2166,1),
(1763,1760,1),
(1763,1969,1),
(1763,2166,1),
(1764,1269,1),
(1765,1269,1),
(1766,1269,1),
(1768,1767,1),
(1768,1993,1),
(1769,1767,1),
(1769,1993,1),
(1770,1767,1),
(1770,1993,1),
(1771,1277,1),
(1772,1277,1),
(1774,1773,1),
(1774,1997,1),
(1774,2174,1),
(1775,1773,1),
(1775,1997,1),
(1775,2174,1),
(1776,1283,1),
(1777,1283,1),
(1779,1778,1),
(1779,2019,1),
(1779,2022,1),
(1780,1778,1),
(1780,2019,1),
(1780,2022,1),
(1781,1289,1),
(1781,2923,1),
(1782,1289,1),
(1782,2923,1),
(1783,1289,1),
(1783,2923,1),
(1785,1784,1),
(1785,2032,1),
(1785,2192,1),
(1786,1784,1),
(1786,2032,1),
(1786,2192,1),
(1787,1784,1),
(1787,2032,1),
(1787,2192,1),
(1788,1297,1),
(1789,1297,1),
(1791,1790,1),
(1791,2034,1),
(1791,2194,1),
(1792,1790,1),
(1792,2034,1),
(1792,2194,1),
(1793,1303,1),
(1794,1303,1),
(1796,1795,1),
(1796,2036,1),
(1796,2196,1),
(1797,1795,1),
(1797,2036,1),
(1797,2196,1),
(1798,1309,1),
(1799,1309,1),
(1801,1800,1),
(1801,2053,1),
(1801,2186,1),
(1802,1800,1),
(1802,2053,1),
(1802,2186,1),
(1803,1315,1),
(1804,1315,1),
(1805,1315,1),
(1807,1806,1),
(1807,2077,1),
(1808,1806,1),
(1808,2077,1),
(1809,1806,1),
(1809,2077,1),
(1810,1323,1),
(1811,1323,1),
(1813,1812,1),
(1813,2083,1),
(1814,1812,1),
(1814,2083,1),
(1815,1329,1),
(1816,1329,1),
(1817,1329,1),
(1819,1818,1),
(1819,2111,1),
(1819,2113,1),
(1820,1818,1),
(1820,2111,1),
(1820,2113,1),
(1821,1818,1),
(1821,2111,1),
(1821,2113,1),
(1822,1337,1),
(1823,1337,1),
(1825,1824,1),
(1825,2117,1),
(1826,1824,1),
(1826,2117,1),
(1827,1343,1),
(1828,1343,1),
(1830,1829,1),
(1830,2121,1),
(1831,1829,1),
(1831,2121,1),
(1832,1349,1),
(1834,1833,1),
(1834,2143,1),
(1835,1353,1),
(1836,1353,1),
(1838,1837,1),
(1838,1987,1),
(1838,1989,1),
(1838,2172,1),
(1839,1837,1),
(1839,1987,1),
(1839,1989,1),
(1839,2172,1),
(1840,1359,1),
(1841,1359,1),
(1843,1842,1),
(1843,2007,1),
(1843,2178,1),
(1844,1842,1),
(1844,2007,1),
(1844,2178,1),
(1845,1365,1),
(1846,1365,1),
(1848,1847,1),
(1848,2009,1),
(1849,1847,1),
(1849,2009,1),
(1850,1371,1),
(1851,1371,1),
(1853,1852,1),
(1853,2045,1),
(1853,2199,1),
(1854,1852,1),
(1854,2045,1),
(1854,2199,1),
(1855,1377,1),
(1856,1377,1),
(1858,1857,1),
(1858,2063,1),
(1859,1857,1),
(1859,2063,1),
(1860,1383,1),
(1861,1383,1),
(1863,1862,1),
(1863,2081,1),
(1864,1862,1),
(1864,2081,1),
(1865,1389,1),
(1866,1389,1),
(1868,1867,1),
(1868,2102,1),
(1869,1867,1),
(1869,2102,1),
(1870,1395,1),
(1871,1395,1),
(1873,1872,1),
(1873,2123,1),
(1874,1872,1),
(1874,2123,1),
(1875,1401,1),
(1876,1401,1),
(1878,1877,1),
(1878,2125,1),
(1879,1877,1),
(1879,2125,1),
(1880,1407,1),
(1881,1407,1),
(1883,1882,1),
(1883,2119,1),
(1884,1882,1),
(1884,2119,1),
(1885,1413,1),
(1886,1413,1),
(1888,1887,1),
(1888,2131,1),
(1889,1887,1),
(1889,2131,1),
(1890,1419,1),
(1891,1419,1),
(1893,1892,1),
(1893,2001,1),
(1893,2003,1),
(1894,1892,1),
(1894,2001,1),
(1894,2003,1),
(1895,1425,1),
(1896,1425,1),
(1898,1897,1),
(1898,2005,1),
(1899,1897,1),
(1899,2005,1),
(1900,1431,1),
(1901,1431,1),
(1903,1902,1),
(1903,2015,1),
(1903,2180,1),
(1904,1902,1),
(1904,2015,1),
(1904,2180,1),
(1905,1437,1),
(1906,1437,1),
(1908,1907,1),
(1908,2017,1),
(1908,2021,1),
(1908,2218,1),
(1909,1907,1),
(1909,2017,1),
(1909,2021,1),
(1909,2218,1),
(1910,1443,1),
(1911,1443,1),
(1913,1912,1),
(1913,2028,1),
(1913,2188,1),
(1914,1912,1),
(1914,2028,1),
(1914,2188,1),
(1915,1449,1),
(1916,1449,1),
(1918,1917,1),
(1918,2047,1),
(1918,2201,1),
(1919,1917,1),
(1919,2047,1),
(1919,2201,1),
(1920,1455,1),
(1921,1455,1),
(1923,1922,1),
(1923,2049,1),
(1924,1922,1),
(1924,2049,1),
(1925,1461,1),
(1926,1461,1),
(1928,1927,1),
(1928,2065,1),
(1929,1927,1),
(1929,2065,1),
(1930,1467,1),
(1931,1467,1),
(1933,1932,1),
(1933,2067,1),
(1933,2069,1),
(1934,1932,1),
(1934,2067,1),
(1934,2069,1),
(1935,1473,1),
(1937,1936,1),
(1937,2127,1),
(1938,1477,1),
(1940,1939,1),
(1940,2061,1),
(1941,1481,1),
(1943,1942,1),
(1943,2115,1),
(1972,1971,1),
(1972,2168,1),
(1973,1971,1),
(1973,2168,1),
(2223,2222,1),
(2223,2493,1),
(2223,2499,1),
(2223,2626,1),
(2223,2717,1),
(2223,2731,1),
(2223,2736,1),
(2223,2745,1),
(2223,2794,1),
(2223,2799,1),
(2223,2831,1),
(2223,2839,1),
(2223,2841,1),
(2223,2843,1),
(2223,2853,1),
(2223,2894,1),
(2223,2896,1),
(2223,2908,1),
(2223,2938,1),
(2223,2946,1),
(2223,2951,1),
(2223,2955,1),
(2223,3214,1),
(2223,3216,1),
(2223,4759,1),
(2223,4760,1),
(2224,2222,2),
(2224,2493,2),
(2224,2499,2),
(2224,2626,2),
(2224,2717,2),
(2224,2731,2),
(2224,2736,2),
(2224,2745,2),
(2224,2794,2),
(2224,2799,2),
(2224,2831,2),
(2224,2839,2),
(2224,2841,2),
(2224,2843,2),
(2224,2853,2),
(2224,2894,2),
(2224,2896,2),
(2224,2908,2),
(2224,2938,2),
(2224,2946,2),
(2224,2951,2),
(2224,2955,2),
(2224,3214,2),
(2224,3216,2),
(2224,4759,2),
(2224,4760,2),
(2225,2222,3),
(2225,2493,3),
(2225,2499,3),
(2225,2626,3),
(2225,2717,3),
(2225,2731,3),
(2225,2736,3),
(2225,2745,3),
(2225,2794,3),
(2225,2799,3),
(2225,2831,3),
(2225,2839,3),
(2225,2841,3),
(2225,2843,3),
(2225,2853,3),
(2225,2894,3),
(2225,2896,3),
(2225,2908,3),
(2225,2938,3),
(2225,2946,3),
(2225,2951,3),
(2225,2955,3),
(2225,3214,3),
(2225,3216,3),
(2225,4759,3),
(2225,4760,3),
(2226,2222,1),
(2226,2493,1),
(2227,2222,1),
(2227,2493,1),
(2229,2228,1),
(2229,2627,1),
(2229,2847,1),
(2229,2854,1),
(2229,2988,1),
(2229,2995,1),
(2229,3001,1),
(2229,3006,1),
(2229,3212,1),
(2229,4353,1),
(2230,2228,1),
(2230,2627,1),
(2230,2847,1),
(2230,2854,1),
(2230,2988,1),
(2230,2995,1),
(2230,3001,1),
(2230,3006,1),
(2230,3212,1),
(2230,4353,1),
(2232,2231,1),
(2232,2635,1),
(2233,2231,1),
(2233,2635,1),
(2233,3223,1),
(2233,3264,1),
(2233,3275,1),
(2233,3757,1),
(2235,2234,1),
(2235,3009,1),
(2235,3029,1),
(2235,3041,1),
(2236,2234,1),
(2236,3009,1),
(2236,3029,1),
(2236,3041,1),
(2238,2237,1),
(2238,3059,1),
(2238,3071,1),
(2238,3080,1),
(2239,2237,1),
(2239,3059,1),
(2239,3071,1),
(2239,3080,1),
(2241,2240,1),
(2241,3095,1),
(2241,3107,1),
(2241,3114,1),
(2242,2240,1),
(2242,3095,1),
(2242,3107,1),
(2242,3114,1),
(2244,2243,1),
(2244,3125,1),
(2245,2243,1),
(2245,3125,1),
(2247,2246,1),
(2247,3159,1),
(2247,3171,1),
(2247,3183,1),
(2247,3188,1),
(2248,2246,1),
(2248,3159,1),
(2248,3171,1),
(2249,2246,1),
(2249,3159,1),
(2249,3171,1),
(2251,2250,1),
(2251,3378,1),
(2251,3390,1),
(2251,3397,1),
(2251,3407,1),
(2251,3413,1),
(2252,2250,1),
(2252,3378,1),
(2252,3390,1),
(2252,3397,1),
(2252,3407,1),
(2252,3413,1),
(2254,2253,1),
(2254,3436,1),
(2254,3443,1),
(2254,3455,1),
(2256,2255,1),
(2256,3472,1),
(2256,3484,1),
(2256,3491,1),
(2257,2255,1),
(2257,3472,1),
(2257,3484,1),
(2257,3491,1),
(2259,2258,1),
(2259,3499,1),
(2259,3512,1),
(2260,2258,1),
(2260,3499,1),
(2260,3512,1),
(2262,2261,1),
(2262,3541,1),
(2262,3548,1),
(2263,2261,1),
(2263,3541,1),
(2263,3548,1),
(2265,2264,1),
(2265,3565,1),
(2265,3577,1),
(2265,3584,1),
(2266,2264,1),
(2266,3565,1),
(2266,3577,1),
(2266,3584,1),
(2268,2267,1),
(2268,3595,1),
(2268,3607,1),
(2268,3614,1),
(2268,3619,1),
(2269,2267,1),
(2269,3595,1),
(2269,3607,1),
(2269,3614,1),
(2270,2267,1),
(2270,3595,1),
(2270,3607,1),
(2270,3614,1),
(2272,2271,1),
(2274,2273,1),
(2274,3624,1),
(2274,3636,1),
(2274,3643,1),
(2275,2273,1),
(2275,3624,1),
(2275,3636,1),
(2275,3643,1),
(2277,2276,1),
(2277,3655,1),
(2277,3667,1),
(2277,3674,1),
(2279,2278,1),
(2279,2965,1),
(2279,3690,1),
(2279,3704,1),
(2280,2278,1),
(2280,2965,1),
(2280,3690,1),
(2280,3704,1),
(2282,2281,1),
(2282,3723,1),
(2282,3735,1),
(2282,3742,1),
(2282,3750,1),
(2283,2281,1),
(2283,3723,1),
(2283,3735,1),
(2283,3742,1),
(2284,2281,1),
(2284,3723,1),
(2284,3735,1),
(2284,3742,1),
(2286,2285,1),
(2286,2732,1),
(2287,2285,1),
(2287,2732,1),
(2287,3762,1),
(2287,3774,1),
(2287,3781,1),
(2287,3787,1),
(2288,2285,1),
(2288,2732,1),
(2288,3762,1),
(2288,3774,1),
(2288,3781,1),
(2288,3787,1),
(2290,2289,1),
(2291,2289,1),
(2293,2292,1),
(2294,2292,1),
(2296,2295,1),
(2296,3833,1),
(2296,3845,1),
(2296,3852,1),
(2297,2295,1),
(2297,3833,1),
(2297,3845,1),
(2297,3852,1),
(2299,2298,1),
(2299,3866,1),
(2299,3880,1),
(2300,2298,1),
(2300,3866,1),
(2300,3880,1),
(2302,2301,1),
(2302,3907,1),
(2302,3914,1),
(2303,2301,1),
(2303,3907,1),
(2303,3914,1),
(2305,2304,1),
(2305,3928,1),
(2305,3940,1),
(2305,3949,1),
(2306,2304,1),
(2306,3928,1),
(2306,3940,1),
(2306,3949,1),
(2308,2307,1),
(2308,3970,1),
(2308,3977,1),
(2309,2307,1),
(2309,3970,1),
(2309,3977,1),
(2311,2310,1),
(2312,2310,1),
(2312,3997,1),
(2312,4004,1),
(2313,2310,1),
(2313,3997,1),
(2313,4004,1),
(2315,2314,1),
(2316,2314,1),
(2318,2317,1),
(2318,4046,1),
(2318,4058,1),
(2319,2317,1),
(2319,4046,1),
(2319,4058,1),
(2321,2320,1),
(2321,4094,1),
(2321,4101,1),
(2322,2320,1),
(2322,4094,1),
(2322,4101,1),
(2324,2323,1),
(2325,2323,1),
(2327,2326,1),
(2327,4110,1),
(2327,4122,1),
(2327,4133,1),
(2328,2326,1),
(2328,4110,1),
(2328,4122,1),
(2328,4133,1),
(2330,2329,1),
(2330,4179,1),
(2330,4182,1),
(2330,4194,1),
(2331,2329,1),
(2331,4179,1),
(2331,4182,1),
(2331,4194,1),
(2333,2332,1),
(2335,2334,1),
(2335,2629,1),
(2335,3217,1),
(2335,4224,1),
(2335,4236,1),
(2335,4243,1),
(2336,2334,1),
(2336,2629,1),
(2336,3217,1),
(2336,4224,1),
(2336,4236,1),
(2336,4243,1),
(2338,2337,1),
(2338,2848,1),
(2338,4254,1),
(2338,4266,1),
(2339,2337,1),
(2339,2848,1),
(2339,4254,1),
(2339,4266,1),
(2341,2340,1),
(2341,2905,1),
(2341,2907,1),
(2341,4294,1),
(2341,4301,1),
(2341,4309,1),
(2342,2340,1),
(2342,2905,1),
(2342,2907,1),
(2342,4294,1),
(2342,4301,1),
(2342,4309,1),
(2344,2343,1),
(2345,2343,1),
(2347,2346,1),
(2347,4370,1),
(2347,4377,1),
(2348,2346,1),
(2348,4370,1),
(2348,4377,1),
(2350,2349,1),
(2350,4396,1),
(2350,4405,1),
(2352,2351,1),
(2353,2351,1),
(2353,4425,1),
(2353,4432,1),
(2354,2351,1),
(2354,4425,1),
(2354,4432,1),
(2356,2355,1),
(2356,4451,1),
(2356,4458,1),
(2357,2355,1),
(2357,4451,1),
(2357,4458,1),
(2359,2358,1),
(2359,4467,1),
(2359,4479,1),
(2359,4486,1),
(2359,4488,1),
(2361,2360,1),
(2361,4509,1),
(2362,2360,1),
(2362,4509,1),
(2364,2363,1),
(2364,4527,1),
(2364,4539,1),
(2364,4546,1),
(2365,2363,1),
(2365,4527,1),
(2365,4539,1),
(2365,4546,1),
(2367,2366,1),
(2368,2366,1),
(2370,2369,1),
(2370,4591,1),
(2370,4598,1),
(2371,2369,1),
(2371,4591,1),
(2371,4598,1),
(2373,2372,1),
(2374,2372,1),
(2376,2375,1),
(2376,4650,1),
(2377,2375,1),
(2377,4650,1),
(2379,2378,1),
(2379,2495,1),
(2379,2628,1),
(2379,2885,1),
(2379,2899,1),
(2379,3213,1),
(2379,4704,1),
(2380,2378,1),
(2380,2495,1),
(2380,2628,1),
(2380,2885,1),
(2380,2899,1),
(2380,3213,1),
(2380,4704,1),
(2382,2381,1),
(2383,2381,1),
(2384,2381,1),
(2386,2385,1),
(2387,2385,1),
(2388,2385,1),
(2390,2389,1),
(2391,2389,1),
(2393,2392,1),
(2393,2733,1),
(2394,2392,1),
(2394,2733,1),
(2396,2395,1),
(2397,2395,1),
(2398,2395,1),
(2400,2399,1),
(2401,2399,1),
(2403,2402,1),
(2404,2402,1),
(2406,2405,1),
(2407,2405,1),
(2409,2408,1),
(2410,2408,1),
(2411,2408,1),
(2413,2412,1),
(2414,2412,1),
(2416,2415,1),
(2417,2415,1),
(2418,2415,1),
(2420,2419,1),
(2421,2419,1),
(2423,2422,1),
(2424,2422,1),
(2426,2425,1),
(2428,2427,1),
(2428,2637,1),
(2428,2641,1),
(2428,2647,1),
(2428,2673,1),
(2428,2695,1),
(2428,3344,1),
(2429,2427,1),
(2429,2637,1),
(2429,2641,1),
(2429,2647,1),
(2429,2673,1),
(2429,2695,1),
(2429,3344,1),
(2429,3356,1),
(2429,3359,1),
(2429,3375,1),
(2429,3755,1),
(2431,2430,1),
(2431,2640,1),
(2431,2649,1),
(2431,2671,1),
(2431,2697,1),
(2432,2430,1),
(2432,2640,1),
(2432,2649,1),
(2432,2671,1),
(2432,2697,1),
(2434,2433,1),
(2434,2643,1),
(2434,2651,1),
(2434,2678,1),
(2434,2698,1),
(2435,2433,1),
(2435,2643,1),
(2435,2651,1),
(2435,2678,1),
(2435,2698,1),
(2437,2436,1),
(2437,2645,1),
(2437,2680,1),
(2437,2701,1),
(2438,2436,1),
(2438,2645,1),
(2438,2680,1),
(2438,2701,1),
(2440,2439,1),
(2440,2653,1),
(2440,2682,1),
(2440,2703,1),
(2441,2439,1),
(2441,2653,1),
(2441,2682,1),
(2441,2703,1),
(2443,2442,1),
(2443,2655,1),
(2443,2684,1),
(2443,2707,1),
(2444,2442,1),
(2444,2655,1),
(2444,2684,1),
(2444,2707,1),
(2446,2445,1),
(2446,2657,1),
(2446,2686,1),
(2446,2709,1),
(2447,2445,1),
(2447,2657,1),
(2447,2686,1),
(2447,2709,1),
(2449,2448,1),
(2449,2659,1),
(2449,2675,1),
(2449,2699,1),
(2449,2909,1),
(2450,2448,1),
(2450,2659,1),
(2450,2675,1),
(2450,2699,1),
(2450,2909,1),
(2452,2451,1),
(2452,2661,1),
(2452,2689,1),
(2452,2705,1),
(2453,2451,1),
(2453,2661,1),
(2453,2689,1),
(2453,2705,1),
(2455,2454,1),
(2455,2663,1),
(2455,2691,1),
(2455,2711,1),
(2456,2454,1),
(2456,2663,1),
(2456,2691,1),
(2456,2711,1),
(2458,2457,1),
(2458,2665,1),
(2458,2667,1),
(2458,2669,1),
(2458,2693,1),
(2459,2457,1),
(2459,2665,1),
(2459,2667,1),
(2459,2669,1),
(2459,2693,1),
(2461,2460,1),
(2462,2460,1),
(2464,2463,1),
(2465,2463,1),
(2467,2466,1),
(2468,2466,1),
(2470,2469,1),
(2470,4706,1),
(2470,4710,1),
(2470,4712,1),
(2470,4758,1),
(2471,2469,1),
(2471,4706,1),
(2471,4710,1),
(2471,4712,1),
(2471,4758,1),
(2473,2472,1),
(2473,4350,1),
(2474,2472,1),
(2476,2475,1),
(2477,2475,1),
(2479,2478,1),
(2480,2478,1),
(2482,2481,1),
(2483,2481,1),
(2485,2484,1),
(2486,2484,1),
(2488,2487,1),
(2488,4668,1),
(2488,4670,1),
(2490,2489,1),
(2490,4679,1),
(2490,4681,1),
(2490,4683,1),
(2492,2491,1),
(2492,2852,1),
(2492,4666,1),
(2492,4692,1),
(2492,4694,1),
(2492,4696,1),
(2500,2499,1),
(2500,2626,1),
(2500,2717,1),
(2500,2731,1),
(2500,2736,1),
(2500,2745,1),
(2500,2794,1),
(2500,2799,1),
(2500,2831,1),
(2500,2839,1),
(2500,2841,1),
(2500,2843,1),
(2500,2853,1),
(2500,2894,1),
(2500,2896,1),
(2500,2908,1),
(2500,2938,1),
(2500,2946,1),
(2500,2951,1),
(2500,2955,1),
(2500,3214,1),
(2500,3216,1),
(2500,4759,1),
(2500,4760,1),
(2501,2499,1),
(2501,2626,1),
(2501,2717,1),
(2501,2731,1),
(2501,2736,1),
(2501,2745,1),
(2501,2794,1),
(2501,2799,1),
(2501,2831,1),
(2501,2839,1),
(2501,2841,1),
(2501,2843,1),
(2501,2853,1),
(2501,2894,1),
(2501,2896,1),
(2501,2908,1),
(2501,2938,1),
(2501,2946,1),
(2501,2951,1),
(2501,2955,1),
(2501,3214,1),
(2501,3216,1),
(2501,4759,1),
(2501,4760,1),
(2743,2,4),
(2744,2,5),
(2746,2745,4),
(2746,2794,4),
(2746,2799,4),
(2746,2831,4),
(2746,2839,4),
(2746,2841,4),
(2746,2843,4),
(2746,2853,4),
(2746,2894,4),
(2746,2896,4),
(2746,2908,4),
(2746,2938,4),
(2746,2946,4),
(2746,2951,4),
(2746,2955,4),
(2746,3214,4),
(2746,3216,4),
(2746,4759,4),
(2746,4760,4),
(2747,2745,5),
(2747,2794,5),
(2747,2799,5),
(2747,2831,5),
(2747,2839,5),
(2747,2841,5),
(2747,2843,5),
(2747,2853,5),
(2747,2894,5),
(2747,2896,5),
(2747,2908,5),
(2747,2938,5),
(2747,2946,5),
(2747,2951,5),
(2747,2955,5),
(2747,3214,5),
(2747,3216,5),
(2747,4759,5),
(2747,4760,5),
(2785,554,1),
(2786,554,2),
(2787,554,3),
(2791,2,1),
(2792,2,2),
(2793,2,2),
(2795,2794,1),
(2795,2799,1),
(2795,2831,1),
(2795,2839,1),
(2795,2841,1),
(2795,2843,1),
(2795,2853,1),
(2795,2894,1),
(2795,2896,1),
(2795,2908,1),
(2796,2794,2),
(2796,2799,2),
(2796,2831,2),
(2796,2839,2),
(2796,2841,2),
(2796,2843,2),
(2796,2853,2),
(2796,2894,2),
(2796,2896,2),
(2796,2908,2),
(2796,2938,2),
(2797,2794,3),
(2797,2799,3),
(2797,2831,3),
(2797,2839,3),
(2797,2841,3),
(2797,2843,3),
(2797,2853,3),
(2797,2894,3),
(2797,2896,3),
(2797,2908,3),
(2797,2938,3),
(2812,554,1),
(2813,554,2),
(2814,554,3),
(2815,554,4),
(2816,554,5),
(2817,554,6),
(2825,2,1),
(2826,2,2),
(2827,2,3),
(2828,2,4),
(2829,2,5),
(2830,2,6),
(2832,2831,1),
(2832,2839,1),
(2832,2841,1),
(2832,2843,1),
(2832,2853,1),
(2832,2894,1),
(2832,2896,1),
(2832,2908,1),
(2832,2938,1),
(2832,2946,1),
(2832,2951,1),
(2832,2955,1),
(2832,3214,1),
(2832,3216,1),
(2832,4759,1),
(2832,4760,1),
(2833,2831,2),
(2833,2839,2),
(2833,2841,2),
(2833,2843,2),
(2833,2853,2),
(2833,2894,2),
(2833,2896,2),
(2833,2908,2),
(2833,2938,2),
(2833,2946,2),
(2833,2951,2),
(2833,2955,2),
(2833,3214,2),
(2833,3216,2),
(2833,4759,2),
(2833,4760,2),
(2834,2831,3),
(2834,2839,3),
(2834,2841,3),
(2834,2843,3),
(2834,2853,3),
(2834,2894,3),
(2834,2896,3),
(2834,2908,3),
(2834,2938,3),
(2834,2946,3),
(2834,2951,3),
(2834,2955,3),
(2834,3214,3),
(2834,3216,3),
(2834,4759,3),
(2834,4760,3),
(2835,2831,4),
(2835,2839,4),
(2835,2841,4),
(2835,2843,4),
(2835,2853,4),
(2835,2894,4),
(2835,2896,4),
(2835,2908,4),
(2835,2938,4),
(2835,2946,4),
(2835,2951,4),
(2835,2955,4),
(2835,3214,4),
(2835,3216,4),
(2835,4759,4),
(2835,4760,4),
(2836,2831,5),
(2836,2839,5),
(2836,2841,5),
(2836,2843,5),
(2836,2853,5),
(2836,2894,5),
(2836,2896,5),
(2836,2908,5),
(2836,2938,5),
(2836,2946,5),
(2836,2951,5),
(2836,2955,5),
(2836,3214,5),
(2836,3216,5),
(2836,4759,5),
(2836,4760,5),
(2837,2831,6),
(2837,2839,6),
(2837,2841,6),
(2837,2843,6),
(2837,2853,6),
(2837,2894,6),
(2837,2896,6),
(2837,2908,6),
(2837,2938,6),
(2837,2946,6),
(2837,2951,6),
(2837,2955,6),
(2837,3214,6),
(2837,3216,6),
(2837,4759,6),
(2837,4760,6),
(2939,2938,1),
(2939,2946,1),
(2939,2951,1),
(2939,2955,1),
(2939,3214,1),
(2939,3216,1),
(2939,4759,1),
(2939,4760,1),
(2945,2,3),
(2947,2946,2),
(2947,2951,2),
(2948,2946,3),
(2952,2951,3),
(2952,2955,3),
(2952,3214,3),
(2952,3216,3),
(2952,4759,3),
(2952,4760,3),
(2956,2955,2),
(2956,3214,2),
(2956,3216,2),
(2956,4759,2),
(2956,4760,2),
(2983,945,1),
(2984,945,2),
(2985,945,3),
(2986,945,4),
(2987,945,5),
(2989,2988,1),
(2989,2995,1),
(2989,3001,1),
(2989,3006,1),
(2989,3212,1),
(2989,4353,1),
(2990,2988,2),
(2990,2995,2),
(2990,3001,2),
(2990,3006,2),
(2990,3212,2),
(2990,4353,2),
(2991,2988,3),
(2991,2995,3),
(2991,3001,3),
(2991,3006,3),
(2991,3212,3),
(2991,4353,3),
(2992,2988,4),
(2992,2995,4),
(2992,3001,4),
(2992,3006,4),
(2992,3212,4),
(2992,4353,4),
(2993,2988,5),
(2993,2995,5),
(2993,3001,5),
(2993,3006,5),
(2993,3212,5),
(2993,4353,5),
(2999,945,1),
(3000,945,2),
(3002,3001,1),
(3002,3006,1),
(3002,3212,1),
(3002,4353,1),
(3003,3001,2),
(3003,3006,2),
(3003,3212,2),
(3003,4353,2),
(3036,957,1),
(3037,957,2),
(3038,957,3),
(3039,957,4),
(3040,957,5),
(3042,3041,1),
(3042,3051,1),
(3042,3055,1),
(3042,3218,1),
(3043,3041,2),
(3043,3051,2),
(3043,3055,2),
(3043,3218,2),
(3044,3041,3),
(3044,3051,3),
(3044,3055,3),
(3044,3218,3),
(3045,3041,4),
(3045,3051,4),
(3045,3055,4),
(3045,3218,4),
(3046,3041,5),
(3046,3051,5),
(3046,3055,5),
(3046,3218,5),
(3052,3051,1),
(3052,3055,1),
(3052,3218,1),
(3053,3051,1),
(3053,3055,1),
(3053,3218,1),
(3066,963,1),
(3067,963,2),
(3068,963,3),
(3069,963,4),
(3070,963,5),
(3072,3071,1),
(3072,3080,1),
(3072,3086,1),
(3073,3071,2),
(3073,3080,2),
(3073,3086,2),
(3074,3071,3),
(3074,3080,3),
(3074,3086,3),
(3075,3071,4),
(3075,3080,4),
(3075,3086,4),
(3076,3071,5),
(3076,3080,5),
(3076,3086,5),
(3079,963,1),
(3081,3080,1),
(3081,3086,1),
(3087,3086,1),
(3088,3086,1),
(3102,969,1),
(3103,969,2),
(3104,969,3),
(3105,969,4),
(3106,969,5),
(3108,3107,1),
(3108,3114,1),
(3108,3118,1),
(3109,3107,2),
(3109,3114,2),
(3109,3118,2),
(3110,3107,3),
(3110,3114,3),
(3110,3118,3),
(3111,3107,4),
(3111,3114,4),
(3111,3118,4),
(3112,3107,5),
(3112,3114,5),
(3112,3118,5),
(3119,3118,1),
(3120,3118,1),
(3138,975,1),
(3139,975,2),
(3140,975,3),
(3141,975,4),
(3142,975,5),
(3143,975,1),
(3144,975,2),
(3145,975,3),
(3147,3146,1),
(3148,3146,2),
(3149,3146,3),
(3150,3146,4),
(3151,3146,5),
(3152,3146,1),
(3153,3146,2),
(3154,3146,3),
(3155,3146,1),
(3156,3146,1),
(3166,981,1),
(3167,981,2),
(3168,981,3),
(3169,981,4),
(3170,981,5),
(3172,3171,1),
(3172,3183,1),
(3172,3188,1),
(3173,3171,2),
(3173,3183,2),
(3173,3188,2),
(3174,3171,3),
(3174,3183,3),
(3174,3188,3),
(3175,3171,4),
(3175,3183,4),
(3175,3188,4),
(3176,3171,5),
(3176,3183,5),
(3176,3188,5),
(3182,981,1),
(3184,3183,1),
(3184,3188,1),
(3185,3183,1),
(3185,3188,1),
(3186,3183,1),
(3186,3188,1),
(3224,3223,1),
(3224,3264,1),
(3224,3275,1),
(3224,3757,1),
(3255,951,1),
(3256,951,2),
(3257,951,3),
(3258,951,4),
(3259,951,5),
(3260,951,1),
(3261,951,2),
(3262,951,3),
(3263,951,4),
(3265,3264,1),
(3265,3275,1),
(3265,3757,1),
(3266,3264,2),
(3266,3275,2),
(3266,3757,2),
(3267,3264,3),
(3267,3275,3),
(3267,3757,3),
(3268,3264,4),
(3268,3275,4),
(3268,3757,4),
(3269,3264,5),
(3269,3275,5),
(3269,3757,5),
(3270,3264,1),
(3270,3275,1),
(3270,3757,1),
(3271,3264,2),
(3271,3275,2),
(3271,3757,2),
(3272,3264,3),
(3272,3275,3),
(3272,3757,3),
(3273,3264,4),
(3273,3275,4),
(3273,3757,4),
(3292,2880,1),
(3293,2880,2),
(3294,2880,3),
(3295,2880,4),
(3297,3296,1),
(3297,3304,1),
(3297,3309,1),
(3297,3320,1),
(3297,3759,1),
(3298,3296,2),
(3298,3304,2),
(3298,3309,2),
(3298,3320,2),
(3298,3759,2),
(3299,3296,3),
(3299,3304,3),
(3299,3309,3),
(3299,3320,3),
(3299,3759,3),
(3300,3296,4),
(3300,3304,4),
(3300,3309,4),
(3300,3320,4),
(3300,3759,4),
(3303,2880,1),
(3305,3304,1),
(3305,3309,1),
(3305,3320,1),
(3305,3759,1),
(3308,2880,1),
(3310,3309,1),
(3310,3320,1),
(3310,3759,1),
(3316,2880,1),
(3317,2880,2),
(3318,2880,3),
(3319,2880,4),
(3321,3320,1),
(3321,3759,1),
(3322,3320,2),
(3322,3759,2),
(3323,3320,3),
(3323,3759,3),
(3324,3320,4),
(3324,3759,4),
(3335,1353,1),
(3336,1353,2),
(3337,1353,3),
(3338,1353,4),
(3339,1353,5),
(3340,1353,1),
(3341,1353,2),
(3342,1353,3),
(3343,1353,4),
(3345,3344,1),
(3345,3356,1),
(3345,3359,1),
(3345,3375,1),
(3345,3755,1),
(3346,3344,2),
(3346,3356,2),
(3346,3359,2),
(3346,3375,2),
(3346,3755,2),
(3347,3344,3),
(3347,3356,3),
(3347,3359,3),
(3347,3375,3),
(3347,3755,3),
(3348,3344,4),
(3348,3356,4),
(3348,3359,4),
(3348,3375,4),
(3348,3755,4),
(3349,3344,5),
(3349,3356,5),
(3349,3359,5),
(3349,3375,5),
(3349,3755,5),
(3350,3344,1),
(3350,3356,1),
(3350,3359,1),
(3350,3375,1),
(3350,3755,1),
(3351,3344,2),
(3351,3356,2),
(3351,3359,2),
(3351,3375,2),
(3351,3755,2),
(3352,3344,3),
(3352,3356,3),
(3352,3359,3),
(3352,3375,3),
(3352,3755,3),
(3353,3344,4),
(3353,3356,4),
(3353,3359,4),
(3353,3375,4),
(3353,3755,4),
(3357,3356,1),
(3357,3359,1),
(3357,3375,1),
(3357,3755,1),
(3385,989,1),
(3386,989,2),
(3387,989,3),
(3388,989,4),
(3389,989,5),
(3391,3390,1),
(3391,3397,1),
(3391,3407,1),
(3391,3413,1),
(3391,3419,1),
(3391,3423,1),
(3392,3390,2),
(3392,3397,2),
(3392,3407,2),
(3392,3413,2),
(3392,3419,2),
(3392,3423,2),
(3393,3390,3),
(3393,3397,3),
(3393,3407,3),
(3393,3413,3),
(3393,3419,3),
(3393,3423,3),
(3394,3390,4),
(3394,3397,4),
(3394,3407,4),
(3394,3413,4),
(3394,3419,4),
(3394,3423,4),
(3395,3390,5),
(3395,3397,5),
(3395,3407,5),
(3395,3413,5),
(3395,3419,5),
(3395,3423,5),
(3403,989,1),
(3404,989,2),
(3405,989,3),
(3406,989,4),
(3408,3407,1),
(3408,3413,1),
(3408,3419,1),
(3408,3423,1),
(3409,3407,2),
(3409,3413,2),
(3409,3419,2),
(3409,3423,2),
(3410,3407,3),
(3410,3413,3),
(3410,3419,3),
(3410,3423,3),
(3411,3407,4),
(3411,3413,4),
(3411,3419,4),
(3411,3423,4),
(3420,3419,1),
(3420,3423,1),
(3421,3419,1),
(3421,3423,1),
(3431,995,1),
(3432,995,2),
(3433,995,3),
(3434,995,4),
(3435,995,5),
(3437,3436,1),
(3437,3443,1),
(3437,3455,1),
(3437,3463,1),
(3437,3465,1),
(3438,3436,2),
(3438,3443,2),
(3438,3455,2),
(3438,3463,2),
(3438,3465,2),
(3439,3436,3),
(3439,3443,3),
(3439,3455,3),
(3439,3463,3),
(3439,3465,3),
(3440,3436,4),
(3440,3443,4),
(3440,3455,4),
(3440,3463,4),
(3440,3465,4),
(3441,3436,5),
(3441,3443,5),
(3441,3455,5),
(3441,3463,5),
(3441,3465,5),
(3450,995,1),
(3451,995,2),
(3452,995,3),
(3453,995,4),
(3454,995,5),
(3456,3455,1),
(3456,3463,1),
(3456,3465,1),
(3457,3455,2),
(3457,3463,2),
(3457,3465,2),
(3458,3455,3),
(3458,3463,3),
(3458,3465,3),
(3459,3455,4),
(3459,3463,4),
(3459,3465,4),
(3460,3455,5),
(3460,3463,5),
(3460,3465,5),
(3464,3463,1),
(3464,3465,1),
(3479,999,1),
(3480,999,2),
(3481,999,3),
(3482,999,4),
(3483,999,5),
(3485,3484,1),
(3485,3491,1),
(3485,4354,1),
(3486,3484,2),
(3486,3491,2),
(3486,4354,2),
(3487,3484,3),
(3487,3491,3),
(3487,4354,3),
(3488,3484,4),
(3488,3491,4),
(3488,4354,4),
(3489,3484,5),
(3489,3491,5),
(3489,4354,5),
(3507,1005,1),
(3508,1005,2),
(3509,1005,3),
(3510,1005,4),
(3511,1005,5),
(3513,3512,1),
(3513,3523,1),
(3513,3528,1),
(3514,3512,2),
(3514,3523,2),
(3514,3528,2),
(3515,3512,3),
(3515,3523,3),
(3515,3528,3),
(3516,3512,4),
(3516,3523,4),
(3516,3528,4),
(3517,3512,5),
(3517,3523,5),
(3517,3528,5),
(3522,1005,1),
(3524,3523,1),
(3524,3528,1),
(3525,3523,1),
(3525,3528,1),
(3526,3523,1),
(3526,3528,1),
(3536,1011,1),
(3537,1011,2),
(3538,1011,3),
(3539,1011,4),
(3540,1011,5),
(3542,3541,1),
(3542,3548,1),
(3542,3556,1),
(3542,3562,1),
(3543,3541,2),
(3543,3548,2),
(3543,3556,2),
(3543,3562,2),
(3544,3541,3),
(3544,3548,3),
(3544,3556,3),
(3544,3562,3),
(3545,3541,4),
(3545,3548,4),
(3545,3556,4),
(3545,3562,4),
(3546,3541,5),
(3546,3548,5),
(3546,3556,5),
(3546,3562,5),
(3554,1011,1),
(3555,1011,2),
(3557,3556,1),
(3557,3562,1),
(3558,3556,2),
(3558,3562,2),
(3559,3556,1),
(3559,3562,1),
(3560,3556,1),
(3560,3562,1),
(3572,1017,1),
(3573,1017,2),
(3574,1017,3),
(3575,1017,4),
(3576,1017,5),
(3578,3577,1),
(3578,3584,1),
(3578,3588,1),
(3578,3592,1),
(3579,3577,2),
(3579,3584,2),
(3579,3588,2),
(3579,3592,2),
(3580,3577,3),
(3580,3584,3),
(3580,3588,3),
(3580,3592,3),
(3581,3577,4),
(3581,3584,4),
(3581,3588,4),
(3581,3592,4),
(3582,3577,5),
(3582,3584,5),
(3582,3588,5),
(3582,3592,5),
(3589,3588,1),
(3589,3592,1),
(3590,3588,1),
(3590,3592,1),
(3602,1023,1),
(3603,1023,2),
(3604,1023,3),
(3605,1023,4),
(3606,1023,5),
(3608,3607,1),
(3608,3614,1),
(3608,3619,1),
(3609,3607,2),
(3609,3614,2),
(3609,3619,2),
(3610,3607,3),
(3610,3614,3),
(3610,3619,3),
(3611,3607,4),
(3611,3614,4),
(3611,3619,4),
(3612,3607,5),
(3612,3614,5),
(3612,3619,5),
(3620,3619,1),
(3621,3619,1),
(3631,1035,1),
(3632,1035,2),
(3633,1035,3),
(3634,1035,4),
(3635,1035,5),
(3637,3636,1),
(3637,3643,1),
(3637,3649,1),
(3637,3653,1),
(3638,3636,2),
(3638,3643,2),
(3638,3649,2),
(3638,3653,2),
(3639,3636,3),
(3639,3643,3),
(3639,3649,3),
(3639,3653,3),
(3640,3636,4),
(3640,3643,4),
(3640,3649,4),
(3640,3653,4),
(3641,3636,5),
(3641,3643,5),
(3641,3649,5),
(3641,3653,5),
(3650,3649,1),
(3650,3653,1),
(3651,3649,1),
(3651,3653,1),
(3662,1041,1),
(3663,1041,2),
(3664,1041,3),
(3665,1041,4),
(3666,1041,5),
(3668,3667,1),
(3668,3674,1),
(3668,3683,1),
(3669,3667,2),
(3669,3674,2),
(3669,3683,2),
(3670,3667,3),
(3670,3674,3),
(3670,3683,3),
(3671,3667,4),
(3671,3674,4),
(3671,3683,4),
(3672,3667,5),
(3672,3674,5),
(3672,3683,5),
(3680,1041,1),
(3681,1041,2),
(3682,1041,3),
(3684,3683,1),
(3685,3683,2),
(3686,3683,3),
(3687,3683,1),
(3699,1045,1),
(3700,1045,2),
(3701,1045,3),
(3702,1045,4),
(3703,1045,5),
(3705,3704,1),
(3705,3717,1),
(3706,3704,2),
(3706,3717,2),
(3707,3704,3),
(3707,3717,3),
(3708,3704,4),
(3708,3717,4),
(3709,3704,5),
(3709,3717,5),
(3716,1045,1),
(3718,3717,1),
(3719,3717,1),
(3720,3717,1),
(3730,1051,1),
(3731,1051,2),
(3732,1051,3),
(3733,1051,4),
(3734,1051,5),
(3736,3735,1),
(3736,3742,1),
(3736,3750,1),
(3737,3735,2),
(3737,3742,2),
(3737,3750,2),
(3738,3735,3),
(3738,3742,3),
(3738,3750,3),
(3739,3735,4),
(3739,3742,4),
(3739,3750,4),
(3740,3735,5),
(3740,3742,5),
(3740,3750,5),
(3749,1051,1),
(3751,3750,1),
(3752,3750,1),
(3753,3750,1),
(3769,1059,1),
(3770,1059,2),
(3771,1059,3),
(3772,1059,4),
(3773,1059,5),
(3775,3774,1),
(3775,3781,1),
(3775,3787,1),
(3775,3793,1),
(3775,3797,1),
(3776,3774,2),
(3776,3781,2),
(3776,3787,2),
(3776,3793,2),
(3776,3797,2),
(3777,3774,3),
(3777,3781,3),
(3777,3787,3),
(3777,3793,3),
(3777,3797,3),
(3778,3774,4),
(3778,3781,4),
(3778,3787,4),
(3778,3793,4),
(3778,3797,4),
(3779,3774,5),
(3779,3781,5),
(3779,3787,5),
(3779,3793,5),
(3779,3797,5),
(3785,1059,1),
(3786,1059,2),
(3788,3787,1),
(3788,3793,1),
(3788,3797,1),
(3789,3787,2),
(3789,3793,2),
(3789,3797,2),
(3794,3793,1),
(3794,3797,1),
(3795,3793,1),
(3795,3797,1),
(3804,3803,1),
(3804,3820,1),
(3804,3828,1),
(3804,3830,1),
(3805,3803,1),
(3805,3820,1),
(3805,3828,1),
(3805,3830,1),
(3814,1067,1),
(3815,1067,2),
(3816,1067,3),
(3817,1067,4),
(3818,1067,5),
(3819,1067,1),
(3821,3820,1),
(3821,3828,1),
(3821,3830,1),
(3822,3820,2),
(3822,3828,2),
(3822,3830,2),
(3823,3820,3),
(3823,3828,3),
(3823,3830,3),
(3824,3820,4),
(3824,3828,4),
(3824,3830,4),
(3825,3820,5),
(3825,3828,5),
(3825,3830,5),
(3826,3820,1),
(3826,3828,1),
(3826,3830,1),
(3840,1079,1),
(3841,1079,2),
(3842,1079,3),
(3843,1079,4),
(3844,1079,5),
(3846,3845,1),
(3846,3852,1),
(3846,3860,1),
(3847,3845,2),
(3847,3852,2),
(3847,3860,2),
(3848,3845,3),
(3848,3852,3),
(3848,3860,3),
(3849,3845,4),
(3849,3852,4),
(3849,3860,4),
(3850,3845,5),
(3850,3852,5),
(3850,3860,5),
(3859,1079,1),
(3861,3860,1),
(3862,3860,1),
(3863,3860,1),
(3874,1085,1),
(3875,1085,2),
(3876,1085,3),
(3877,1085,4),
(3878,1085,5),
(3879,1085,1),
(3881,3880,1),
(3881,3890,1),
(3881,3894,1),
(3882,3880,2),
(3882,3890,2),
(3882,3894,2),
(3883,3880,3),
(3883,3890,3),
(3883,3894,3),
(3884,3880,4),
(3884,3890,4),
(3884,3894,4),
(3885,3880,5),
(3885,3890,5),
(3885,3894,5),
(3886,3880,1),
(3886,3890,1),
(3886,3894,1),
(3891,3890,1),
(3891,3894,1),
(3892,3890,1),
(3892,3894,1),
(3902,1091,1),
(3903,1091,2),
(3904,1091,3),
(3905,1091,4),
(3906,1091,5),
(3908,3907,1),
(3908,3914,1),
(3908,3922,1),
(3909,3907,2),
(3909,3914,2),
(3909,3922,2),
(3910,3907,3),
(3910,3914,3),
(3910,3922,3),
(3911,3907,4),
(3911,3914,4),
(3911,3922,4),
(3912,3907,5),
(3912,3914,5),
(3912,3922,5),
(3921,1091,1),
(3923,3922,1),
(3924,3922,1),
(3925,3922,1),
(3935,1097,1),
(3936,1097,2),
(3937,1097,3),
(3938,1097,4),
(3939,1097,5),
(3941,3940,1),
(3941,3949,1),
(3941,3955,1),
(3942,3940,2),
(3942,3949,2),
(3942,3955,2),
(3943,3940,3),
(3943,3949,3),
(3943,3955,3),
(3944,3940,4),
(3944,3949,4),
(3944,3955,4),
(3945,3940,5),
(3945,3949,5),
(3945,3955,5),
(3948,1097,1),
(3950,3949,1),
(3950,3955,1),
(3956,3955,1),
(3957,3955,1),
(3965,1103,1),
(3966,1103,2),
(3967,1103,3),
(3968,1103,4),
(3969,1103,5),
(3971,3970,1),
(3971,3977,1),
(3971,3982,1),
(3972,3970,2),
(3972,3977,2),
(3972,3982,2),
(3973,3970,3),
(3973,3977,3),
(3973,3982,3),
(3974,3970,4),
(3974,3977,4),
(3974,3982,4),
(3975,3970,5),
(3975,3977,5),
(3975,3982,5),
(3983,3982,1),
(3984,3982,1),
(3992,1109,1),
(3993,1109,2),
(3994,1109,3),
(3995,1109,4),
(3996,1109,5),
(3998,3997,1),
(3998,4004,1),
(3998,4012,1),
(3999,3997,2),
(3999,4004,2),
(3999,4012,2),
(4000,3997,3),
(4000,4004,3),
(4000,4012,3),
(4001,3997,4),
(4001,4004,4),
(4001,4012,4),
(4002,3997,5),
(4002,4004,5),
(4002,4012,5),
(4011,1109,1),
(4013,4012,1),
(4014,4012,1),
(4015,4012,1),
(4026,1117,1),
(4027,1117,2),
(4028,1117,3),
(4029,1117,4),
(4031,4030,1),
(4031,4038,1),
(4031,4042,1),
(4032,4030,2),
(4032,4038,2),
(4032,4042,2),
(4033,4030,3),
(4033,4038,3),
(4033,4042,3),
(4034,4030,4),
(4034,4038,4),
(4034,4042,4),
(4035,4030,1),
(4035,4038,1),
(4036,4030,1),
(4036,4038,1),
(4043,4042,1),
(4044,4042,1),
(4053,1123,1),
(4054,1123,2),
(4055,1123,3),
(4056,1123,4),
(4057,1123,5),
(4059,4058,1),
(4059,4072,1),
(4059,4078,1),
(4059,4081,1),
(4060,4058,2),
(4060,4072,2),
(4060,4078,2),
(4060,4081,2),
(4061,4058,3),
(4061,4072,3),
(4061,4078,3),
(4061,4081,3),
(4062,4058,4),
(4062,4072,4),
(4062,4078,4),
(4062,4081,4),
(4063,4058,5),
(4063,4072,5),
(4063,4078,5),
(4063,4081,5),
(4070,1123,1),
(4071,1123,2),
(4073,4072,1),
(4073,4078,1),
(4073,4081,1),
(4074,4072,2),
(4074,4078,2),
(4074,4081,2),
(4075,4072,1),
(4075,4078,1),
(4075,4081,1),
(4076,4072,1),
(4076,4078,1),
(4076,4081,1),
(4089,1129,1),
(4090,1129,2),
(4091,1129,3),
(4092,1129,4),
(4093,1129,5),
(4095,4094,1),
(4095,4101,1),
(4095,4106,1),
(4096,4094,2),
(4096,4101,2),
(4096,4106,2),
(4097,4094,3),
(4097,4101,3),
(4097,4106,3),
(4098,4094,4),
(4098,4101,4),
(4098,4106,4),
(4099,4094,5),
(4099,4101,5),
(4099,4106,5),
(4107,4106,1),
(4108,4106,1),
(4117,1143,1),
(4118,1143,2),
(4119,1143,3),
(4120,1143,4),
(4121,1143,5),
(4123,4122,1),
(4123,4133,1),
(4123,4144,1),
(4124,4122,2),
(4124,4133,2),
(4124,4144,2),
(4125,4122,3),
(4125,4133,3),
(4125,4144,3),
(4126,4122,4),
(4126,4133,4),
(4126,4144,4),
(4127,4122,5),
(4127,4133,5),
(4127,4144,5),
(4131,1143,1),
(4132,1143,2),
(4134,4133,1),
(4134,4144,1),
(4135,4133,2),
(4135,4144,2),
(4143,1143,1),
(4145,4144,1),
(4146,4144,1),
(4156,1149,1),
(4157,1149,2),
(4158,1149,3),
(4159,1149,4),
(4160,1149,5),
(4162,4161,1),
(4162,4168,1),
(4162,4175,1),
(4163,4161,2),
(4163,4168,2),
(4163,4175,2),
(4164,4161,3),
(4164,4168,3),
(4164,4175,3),
(4165,4161,4),
(4165,4168,4),
(4165,4175,4),
(4166,4161,5),
(4166,4168,5),
(4166,4175,5),
(4174,1149,1),
(4176,4175,1),
(4177,4175,1),
(4189,1155,1),
(4190,1155,2),
(4191,1155,3),
(4192,1155,4),
(4193,1155,5),
(4195,4194,1),
(4195,4215,1),
(4196,4194,2),
(4196,4215,2),
(4197,4194,3),
(4197,4215,3),
(4198,4194,4),
(4198,4215,4),
(4199,4194,5),
(4199,4215,5),
(4210,1155,1),
(4211,1155,2),
(4212,1155,3),
(4213,1155,4),
(4214,1155,1),
(4216,4215,1),
(4217,4215,2),
(4218,4215,3),
(4219,4215,4),
(4220,4215,1),
(4221,4215,1),
(4231,1165,1),
(4232,1165,2),
(4233,1165,3),
(4234,1165,4),
(4235,1165,5),
(4237,4236,1),
(4237,4243,1),
(4237,4248,1),
(4237,4252,1),
(4238,4236,2),
(4238,4243,2),
(4238,4248,2),
(4238,4252,2),
(4239,4236,3),
(4239,4243,3),
(4239,4248,3),
(4239,4252,3),
(4240,4236,4),
(4240,4243,4),
(4240,4248,4),
(4240,4252,4),
(4241,4236,5),
(4241,4243,5),
(4241,4248,5),
(4241,4252,5),
(4249,4248,1),
(4249,4252,1),
(4250,4248,1),
(4250,4252,1),
(4261,1171,1),
(4262,1171,2),
(4263,1171,3),
(4264,1171,4),
(4265,1171,5),
(4267,4266,1),
(4267,4278,1),
(4268,4266,2),
(4268,4278,2),
(4269,4266,3),
(4269,4278,3),
(4270,4266,4),
(4270,4278,4),
(4271,4266,5),
(4271,4278,5),
(4277,1171,1),
(4279,4278,1),
(4280,4278,1),
(4281,4278,1),
(4289,1177,1),
(4290,1177,2),
(4291,1177,3),
(4292,1177,4),
(4293,1177,5),
(4295,4294,1),
(4295,4301,1),
(4295,4309,1),
(4295,4316,1),
(4296,4294,2),
(4296,4301,2),
(4296,4309,2),
(4296,4316,2),
(4297,4294,3),
(4297,4301,3),
(4297,4309,3),
(4297,4316,3),
(4298,4294,4),
(4298,4301,4),
(4298,4309,4),
(4298,4316,4),
(4299,4294,5),
(4299,4301,5),
(4299,4309,5),
(4299,4316,5),
(4306,1177,1),
(4307,1177,2),
(4308,1177,3),
(4310,4309,1),
(4310,4316,1),
(4311,4309,2),
(4311,4316,2),
(4312,4309,3),
(4312,4316,3),
(4317,4316,1),
(4318,4316,1),
(4324,4323,1),
(4324,4337,1),
(4324,4344,1),
(4324,4345,1),
(4325,4323,1),
(4325,4337,1),
(4325,4344,1),
(4325,4345,1),
(4332,1185,1),
(4333,1185,2),
(4334,1185,3),
(4335,1185,4),
(4336,1185,5),
(4338,4337,1),
(4338,4344,1),
(4338,4345,1),
(4339,4337,2),
(4339,4344,2),
(4339,4345,2),
(4340,4337,3),
(4340,4344,3),
(4340,4345,3),
(4341,4337,4),
(4341,4344,4),
(4341,4345,4),
(4342,4337,5),
(4342,4344,5),
(4342,4345,5),
(4351,4350,1),
(4355,4354,1),
(4356,4354,1),
(4365,1191,1),
(4366,1191,2),
(4367,1191,3),
(4368,1191,4),
(4369,1191,5),
(4371,4370,1),
(4371,4377,1),
(4371,4381,1),
(4372,4370,2),
(4372,4377,2),
(4372,4381,2),
(4373,4370,3),
(4373,4377,3),
(4373,4381,3),
(4374,4370,4),
(4374,4377,4),
(4374,4381,4),
(4375,4370,5),
(4375,4377,5),
(4375,4381,5),
(4382,4381,1),
(4383,4381,1),
(4391,1197,1),
(4392,1197,2),
(4393,1197,3),
(4394,1197,4),
(4395,1197,5),
(4397,4396,1),
(4397,4405,1),
(4397,4410,1),
(4398,4396,2),
(4398,4405,2),
(4398,4410,2),
(4399,4396,3),
(4399,4405,3),
(4399,4410,3),
(4400,4396,4),
(4400,4405,4),
(4400,4410,4),
(4401,4396,5),
(4401,4405,5),
(4401,4410,5),
(4409,1197,1),
(4411,4410,1),
(4412,4410,1),
(4420,1201,1),
(4421,1201,2),
(4422,1201,3),
(4423,1201,4),
(4424,1201,5),
(4426,4425,1),
(4426,4432,1),
(4426,4436,1),
(4427,4425,2),
(4427,4432,2),
(4427,4436,2),
(4428,4425,3),
(4428,4432,3),
(4428,4436,3),
(4429,4425,4),
(4429,4432,4),
(4429,4436,4),
(4430,4425,5),
(4430,4432,5),
(4430,4436,5),
(4437,4436,1),
(4438,4436,1),
(4446,1209,1),
(4447,1209,2),
(4448,1209,3),
(4449,1209,4),
(4450,1209,5),
(4452,4451,1),
(4452,4458,1),
(4452,4462,1),
(4453,4451,2),
(4453,4458,2),
(4453,4462,2),
(4454,4451,3),
(4454,4458,3),
(4454,4462,3),
(4455,4451,4),
(4455,4458,4),
(4455,4462,4),
(4456,4451,5),
(4456,4458,5),
(4456,4462,5),
(4463,4462,1),
(4464,4462,1),
(4474,1215,1),
(4475,1215,2),
(4476,1215,3),
(4477,1215,4),
(4478,1215,5),
(4480,4479,1),
(4480,4486,1),
(4480,4488,1),
(4480,4493,1),
(4481,4479,2),
(4481,4486,2),
(4481,4488,2),
(4481,4493,2),
(4482,4479,3),
(4482,4486,3),
(4482,4488,3),
(4482,4493,3),
(4483,4479,4),
(4483,4486,4),
(4483,4488,4),
(4483,4493,4),
(4484,4479,5),
(4484,4486,5),
(4484,4488,5),
(4484,4493,5),
(4492,1215,1),
(4494,4493,1),
(4495,4493,1),
(4504,1219,1),
(4505,1219,2),
(4506,1219,3),
(4507,1219,4),
(4508,1219,5),
(4510,4509,1),
(4510,4522,1),
(4511,4509,2),
(4511,4522,2),
(4512,4509,3),
(4512,4522,3),
(4513,4509,4),
(4513,4522,4),
(4514,4509,5),
(4514,4522,5),
(4521,1219,1),
(4523,4522,1),
(4524,4522,1),
(4534,1225,1),
(4535,1225,2),
(4536,1225,3),
(4537,1225,4),
(4538,1225,5),
(4540,4539,1),
(4540,4546,1),
(4540,4550,1),
(4541,4539,2),
(4541,4546,2),
(4541,4550,2),
(4542,4539,3),
(4542,4546,3),
(4542,4550,3),
(4543,4539,4),
(4543,4546,4),
(4543,4550,4),
(4544,4539,5),
(4544,4546,5),
(4544,4550,5),
(4551,4550,1),
(4552,4550,1),
(4564,1231,1),
(4565,1231,2),
(4566,1231,3),
(4567,1231,4),
(4568,1231,5),
(4569,1231,1),
(4571,4570,1),
(4572,4570,2),
(4573,4570,3),
(4574,4570,4),
(4575,4570,5),
(4576,4570,1),
(4577,4570,1),
(4586,1237,2),
(4587,1237,3),
(4588,1237,4),
(4589,1237,5),
(4590,1237,6),
(4592,4591,2),
(4592,4598,2),
(4592,4605,2),
(4593,4591,3),
(4593,4598,3),
(4593,4605,3),
(4594,4591,4),
(4594,4598,4),
(4594,4605,4),
(4595,4591,5),
(4595,4598,5),
(4595,4605,5),
(4596,4591,6),
(4596,4598,6),
(4596,4605,6),
(4604,1237,1),
(4606,4605,1),
(4607,4605,1),
(4608,4605,1),
(4621,1243,1),
(4622,1243,2),
(4623,1243,3),
(4624,1243,4),
(4625,1243,5),
(4626,1243,1),
(4627,1243,2),
(4629,4628,1),
(4630,4628,2),
(4631,4628,3),
(4632,4628,4),
(4633,4628,5),
(4634,4628,1),
(4635,4628,2),
(4636,4628,1),
(4637,4628,1),
(4645,1249,1),
(4646,1249,2),
(4647,1249,3),
(4648,1249,4),
(4649,1249,5),
(4651,4650,1),
(4651,4661,1),
(4652,4650,2),
(4652,4661,2),
(4653,4650,3),
(4653,4661,3),
(4654,4650,4),
(4654,4661,4),
(4655,4650,5),
(4655,4661,5),
(4660,1249,1),
(4662,4661,1),
(4663,4661,1),
(4664,4661,1),
(4674,1473,1),
(4676,4675,1),
(4677,4675,1),
(4687,1477,1),
(4689,4688,1),
(4690,4688,1),
(4700,1481,1),
(4702,4701,1),
(4703,4701,1);
/*!40000 ALTER TABLE `elements_owners` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements_sites`
--

LOCK TABLES `elements_sites` WRITE;
/*!40000 ALTER TABLE `elements_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements_sites` VALUES
(1,1,1,NULL,NULL,NULL,NULL,1,'2025-04-18 16:59:46','2025-04-18 16:59:46','c07ab660-8f99-458f-87e2-994099c418d5'),
(2,2,1,'Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Arbors\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Arbors\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccarbors.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[545],\"482ad396-5443-4761-a410-c644d0217e5a\":[601,617,605],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[2610,2598,2608,2600,2596,2602,2604],\"f352e58c-d152-4a45-9615-d0526b009523\":[2891],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[548],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[545,137,138,136],\"c67c0ac3-ce5c-4eb0-b6c1-86c68413a548\":[],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[548],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[548],\"b46c7894-3c01-4cc4-b90f-9612b3b9891b\":\"<script src=\\\"https://apploi.link/Complete_Care_at_Arbors-career-page\\\"></script>\",\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7329140090\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccarbors.com\"}',1,'2025-04-18 17:15:09','2025-10-23 01:34:07','e04f89f6-42a8-4658-b5fe-f4da794eda56'),
(8,8,1,'Complete Care at Arbors','__temp_oafegazovtrfydqmmqaxsfbghndwkdltlqnq',NULL,NULL,1,'2025-04-18 17:32:44','2025-04-18 17:32:44','fcb60278-fad3-409c-927c-9d65720b2d2e'),
(10,10,1,'Complete Care at Arbors','__temp_oafegazovtrfydqmmqaxsfbghndwkdltlqnq',NULL,NULL,1,'2025-04-18 17:32:44','2025-04-18 17:32:44','e528f061-cda8-4793-a9ce-03c12a5ae22b'),
(14,14,1,NULL,'__temp_ajigsuelynrhqqirjqmxctezreglmrxljdge',NULL,NULL,1,'2025-04-18 17:57:42','2025-04-18 17:57:42','b85338da-4c93-4ecc-90e8-f63457a74fa0'),
(16,16,1,'Complete Care at Arbors','__temp_oafegazovtrfydqmmqaxsfbghndwkdltlqnq',NULL,NULL,1,'2025-04-18 17:57:57','2025-04-18 17:57:57','269e069f-1c6b-488d-a876-4d6156ca6771'),
(18,18,1,'Subacute Rehab','subacute-rehab',NULL,NULL,1,'2025-04-18 18:06:39','2025-08-20 21:55:53','ca50ef90-8d9f-4887-b40f-5a623e7f88bc'),
(19,19,1,'Subacute Rehab','subacute-rehab','services/__temp_nikydbscpieabfmxdqpavpbcwhcsbwjfdtau','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Subacute Rehab\"}',1,'2025-04-18 18:06:50','2025-08-20 21:55:00','9e1f7117-7f2e-43f9-953f-a2185cce5396'),
(20,20,1,'Respiratory Care','respiratory-care',NULL,NULL,1,'2025-04-18 18:06:50','2025-08-20 21:55:53','912a3a84-16f7-465e-b9e0-cd2988c22a0c'),
(21,21,1,'Respiratory Care','respiratory-care','services/__temp_lijhtcjgykuwiuknfjjdihijzodkbmxjxouv','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Respiratory Care\"}',1,'2025-04-18 18:06:58','2025-08-20 21:55:00','5b3834e7-d399-45f3-82a9-3d1d8f094af6'),
(22,22,1,'Orthopedic Rehab','orthopedic-rehab',NULL,NULL,1,'2025-04-18 18:06:58','2025-08-20 21:55:53','1c05ee85-3afc-46c2-8a81-0a18f30f5321'),
(23,23,1,'Orthopedic Rehab','orthopedic-rehab','services/__temp_vljdabksbxhsgiduvoeervsdyxbulmhplrgh','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Orthopedic Rehab\"}',1,'2025-04-18 18:07:06','2025-08-20 21:55:00','444febdb-e4d3-4aba-af3a-82d3e39a28bf'),
(24,24,1,'Long-Term Care','long-term-care',NULL,NULL,1,'2025-04-18 18:07:06','2025-08-20 21:55:53','9d1e1a91-fd7a-4b83-811d-4528a6fe8967'),
(25,25,1,'Long-Term Care','long-term-care','services/__temp_vghfulxfpfozycvjnqzxyevgorqyearkupni','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Long-Term Care\"}',1,'2025-04-18 18:07:32','2025-08-20 21:55:00','336063e3-c89f-4ccb-9abf-82e54cdcd792'),
(26,26,1,'Wound Care','wound-care',NULL,NULL,1,'2025-04-18 18:07:32','2025-08-20 21:55:53','f5ad6b40-4fd8-4849-a227-225dd152f119'),
(27,27,1,'Wound Care','wound-care','services/__temp_fokjbrjltnspbxurfimxovogpkrpxdtjnuzw','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Wound Care\"}',1,'2025-04-18 18:07:37','2025-08-20 21:55:00','ae0c4706-f366-4d1a-b66e-5cbd3e2534c8'),
(28,28,1,'Renal Care','renal-care',NULL,NULL,1,'2025-04-18 18:07:37','2025-08-20 21:55:53','d8aef05e-5007-4829-a486-97ebb61afcc9'),
(29,29,1,'Renal Care','renal-care','services/__temp_jjnqbuohveczgaxqjecilxdpzmqcpxzgogmu','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Renal Care\"}',1,'2025-04-18 18:07:43','2025-08-20 21:55:00','9b9bc0c2-f32b-4cc7-be29-ec863e6c3073'),
(30,30,1,'Hospice Care','hospice-care',NULL,NULL,1,'2025-04-18 18:07:43','2025-08-20 21:55:53','a13a939f-b9af-457d-997b-8e9d5fe1f5fa'),
(31,31,1,'Hospice Care','hospice-care','services/__temp_svcddqtzudwfjzlpiwsitxsbwbbznyrrxhat','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Hospice Care\"}',1,'2025-04-18 18:07:48','2025-08-20 21:55:00','3eeb5c2e-4b3d-4c0a-9414-5c48c4c989ce'),
(32,32,1,'Memory Care','memory-care',NULL,NULL,1,'2025-04-18 18:07:48','2025-08-20 21:55:53','faa1cbb6-0aa1-4a90-8af1-250187a8576e'),
(33,33,1,'Memory Care','memory-care','services/__temp_ljmzvxuslwdaxqwfjbgsldbrrqygzikmxfkh','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Memory Care\"}',1,'2025-04-18 18:07:53','2025-08-20 21:55:00','e785080f-ee7a-492c-8a84-947150eb46fc'),
(34,34,1,'Stroke Recovery','stroke-recovery',NULL,NULL,1,'2025-04-18 18:07:53','2025-08-20 21:55:53','49ebb121-5f9b-4bdf-abde-37cc2dd92b32'),
(35,35,1,'Stroke Recovery','stroke-recovery','services/__temp_stgtoxrgnvjqmnnltxvcekvlefvehlctqcty','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Stroke Recovery\"}',1,'2025-04-18 18:08:00','2025-08-20 21:55:00','6a3bf50f-df24-4b0a-acfb-2c898fb82ebc'),
(36,36,1,'Rehabilitation Program','cardiac-care',NULL,NULL,1,'2025-04-18 18:08:00','2025-08-20 21:57:06','1dd01031-2491-4a50-a573-c4e398caaa25'),
(37,37,1,'Cardiac Care','cardiac-care','services/__temp_kjnxfskmhvmqutotbwekktlmieaaphczdypd','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Cardiac Care\"}',1,'2025-04-18 18:08:04','2025-08-20 21:55:00','7e25f67b-6dfa-421a-a184-9219522da991'),
(44,44,1,'Menachem Shapiro','menachem-shapiro',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\": \"Menachem Shapiro\", \"50d484f9-ea00-4870-8b7a-a1c7400f42ab\": [632], \"6859b0cf-ccd8-409d-84f9-b76fcac3eda0\": \"mshapiro@ccarbors.com\"}',1,'2025-04-18 18:10:41','2025-09-03 22:27:30','152fc37a-8041-4a16-a25e-ff764f726adb'),
(45,45,1,'Elizabeth Schwear','elizabeth-schwear',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\": \"Elizabeth Schwear\", \"579071f5-918a-4d7a-8c5b-98905ecbe548\": \"Infection Control\"}',1,'2025-04-18 18:10:41','2025-04-18 18:10:41','efea344c-9995-4674-8d66-d44e986a7d78'),
(46,46,1,'Chrissy Martin','chrissy-martin',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\": \"Chrissy Martin\", \"579071f5-918a-4d7a-8c5b-98905ecbe548\": \"Activity Director\"}',1,'2025-04-18 18:10:41','2025-04-18 18:10:41','0218ebb2-dab2-45c0-a7a3-3186d10acb24'),
(47,47,1,'Jackie Boyle','jackie-boyle',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\": \"Jackie Boyle\", \"579071f5-918a-4d7a-8c5b-98905ecbe548\": \"Director of Nursing\"}',1,'2025-04-18 18:10:41','2025-04-18 18:10:41','2aae050f-df49-45f3-98b0-1e634c2519fb'),
(56,56,1,'Ashie T.','robert-a',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Ashie T.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"The staff at Complete Care goes above and beyond to provide patient care and satisfaction! Always with a smile and a good word, the staff is there whenever you need them and the services they provide are unparalleled.\"}',1,'2025-04-18 18:14:39','2025-09-03 21:05:58','d578bc04-9ede-461b-ab91-bfd2b26ca8f5'),
(57,57,1,'Carole T.','bernadette-m',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Carole T.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"Very professional and caring place, staff and nurses were overly helpful in attending to needs. Therapy went way above to assist in getting us to reach maximum potential.\"}',1,'2025-04-18 18:14:39','2025-09-03 21:05:58','359347a7-f306-422c-8a16-6404cd8292f9'),
(63,63,1,'Cora O.','mary-o',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Cora O.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"I have been here for 3 years and I am thrilled with the quality care I receive. I enjoy every day is a new amazing experience with activities. The staff are wonderful! The place is very clean and every one is very polite!\"}',1,'2025-04-18 18:15:36','2025-09-03 21:08:08','d44334bf-5f39-4646-bcb5-f92a8fbf9641'),
(72,72,1,'Lobby','lobby',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Lobby\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','daa9fe3b-dbec-45e6-9392-1cea08697c39'),
(73,73,1,'Rehab Gym','rehab-gym',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Rehab Gym\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','fdc59595-0504-4c12-94c1-6c938628206a'),
(74,74,1,'Patient Room','patient-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Patient Room\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','6b409b7f-c08e-4140-aea6-a1e0f1e9e23f'),
(75,75,1,'Recreation Room','recreation-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Recreation Room\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','fbc3a2aa-119b-4210-877e-662fed603e36'),
(76,76,1,'Dining Room','dining-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Dining Room\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','c2439c98-2c43-4e98-a5f6-6204c3b3ff38'),
(78,78,1,'Lobby','lobby',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Lobby\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','41d809bc-a5eb-4a95-b941-471706db1278'),
(79,79,1,'Rehab Gym','rehab-gym',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Rehab Gym\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','08d9cdcf-e2b8-499d-991a-65e8dc11fe55'),
(80,80,1,'Patient Room','patient-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Patient Room\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','ec53206f-55ec-409b-aa4f-8bbb9e4e7c27'),
(81,81,1,'Recreation Room','recreation-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Recreation Room\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','486f23d4-61e0-4710-956f-46a188e3eb12'),
(82,82,1,'Dining Room','dining-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Dining Room\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','7a1810e6-4ac9-4d46-b8c2-552a459ea641'),
(86,86,1,'Arbors',NULL,NULL,NULL,1,'2025-04-18 18:31:40','2025-04-18 18:31:40','03ebf2ca-c4ea-4e16-9de9-b0242e9f79dd'),
(96,96,1,'Private & Semi-Private Suites','private-semi-private-suites',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Private & Semi-Private Suites\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','c71d2acd-9750-4f6b-a49a-3111b169a4b3'),
(97,97,1,'Cafe/Restaurant-Style Dining','cafe-restaurant-style-dining',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Cafe/Restaurant-Style Dining\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','925f9a28-9f29-4795-8059-5930c90ac462'),
(98,98,1,'On-Site Beauty Salon and Barbershop','on-site-beauty-salon-and-barbershop',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"On-Site Beauty Salon and Barbershop\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','c7d0ffc2-955a-4f5f-a872-8715a9f60d1b'),
(99,99,1,'Lounges and Guest Areas','lounges-and-guest-areas',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Lounges and Guest Areas\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','a21487a0-f2ad-459e-a492-a1063c80c361'),
(100,100,1,'Courtyard Gardens','courtyard-gardens',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Courtyard Gardens\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','e484b667-dc71-4291-a630-e973dc0abe8f'),
(101,101,1,'Cultural, Educational, Religious and Social Activities','cultural-educational-religious-and-social-activities',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Cultural, Educational, Religious and Social Activities\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','6f7acd1b-a7bd-4ae8-b081-c3e58016