/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.14-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: akg_craft
-- ------------------------------------------------------
-- Server version	10.11.14-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `addresses`
--

DROP TABLE IF EXISTS `addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `addresses` (
  `id` int(11) NOT NULL,
  `primaryOwnerId` int(11) DEFAULT NULL,
  `fieldId` int(11) DEFAULT NULL,
  `countryCode` varchar(255) NOT NULL,
  `administrativeArea` varchar(255) DEFAULT NULL,
  `locality` varchar(255) DEFAULT NULL,
  `dependentLocality` varchar(255) DEFAULT NULL,
  `postalCode` varchar(255) DEFAULT NULL,
  `sortingCode` varchar(255) DEFAULT NULL,
  `addressLine1` varchar(255) DEFAULT NULL,
  `addressLine2` varchar(255) DEFAULT NULL,
  `addressLine3` varchar(255) DEFAULT NULL,
  `organization` varchar(255) DEFAULT NULL,
  `organizationTaxId` varchar(255) DEFAULT NULL,
  `fullName` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `latitude` varchar(255) DEFAULT NULL,
  `longitude` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_iqvloikvkpdwacapmodeegqbfwwsttzfiaqx` (`primaryOwnerId`),
  CONSTRAINT `fk_dwkislensiccokeopruhqgnyoosvtqpqvnxz` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_iqvloikvkpdwacapmodeegqbfwwsttzfiaqx` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `pluginId` int(11) DEFAULT NULL,
  `heading` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `unread` tinyint(1) NOT NULL DEFAULT 1,
  `dateRead` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_uukijiyyfbdpzlzeqyvxlovumrsxhmnoygak` (`userId`,`unread`,`dateRead`,`dateCreated`),
  KEY `idx_mgewutpavvnrbjchxdqzhgengtvihkgkczjl` (`dateRead`),
  KEY `fk_wruwonaklxcgxnetazpxvohcqbbhhjbqrkoe` (`pluginId`),
  CONSTRAINT `fk_wospxzotjkupqslxknxobuiyjbevdfwiqlck` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wruwonaklxcgxnetazpxvohcqbbhhjbqrkoe` FOREIGN KEY (`pluginId`) REFERENCES `plugins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexdata`
--

DROP TABLE IF EXISTS `assetindexdata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assetindexdata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sessionId` int(11) NOT NULL,
  `volumeId` int(11) NOT NULL,
  `uri` text DEFAULT NULL,
  `size` bigint(20) unsigned DEFAULT NULL,
  `timestamp` datetime DEFAULT NULL,
  `isDir` tinyint(1) DEFAULT 0,
  `recordId` int(11) DEFAULT NULL,
  `isSkipped` tinyint(1) DEFAULT 0,
  `inProgress` tinyint(1) DEFAULT 0,
  `completed` tinyint(1) DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_vvjtokdopumqivgaxhocgaebidhfqnctkahc` (`sessionId`,`volumeId`),
  KEY `idx_gzbdxenxksafpxnsqlillxlimxjghnkkkmeu` (`volumeId`),
  CONSTRAINT `fk_sbdvwtpkiwufghhdpxbxpywoanluihrohqtp` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_uttkbdmmxkkkmehzpvgxbbggkbofttzmldfc` FOREIGN KEY (`sessionId`) REFERENCES `assetindexingsessions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assetindexingsessions`
--

DROP TABLE IF EXISTS `assetindexingsessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assetindexingsessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `indexedVolumes` text DEFAULT NULL,
  `totalEntries` int(11) DEFAULT NULL,
  `processedEntries` int(11) NOT NULL DEFAULT 0,
  `cacheRemoteImages` tinyint(1) DEFAULT NULL,
  `listEmptyFolders` tinyint(1) DEFAULT 0,
  `isCli` tinyint(1) DEFAULT 0,
  `actionRequired` tinyint(1) DEFAULT 0,
  `processIfRootEmpty` tinyint(1) DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assets`
--

DROP TABLE IF EXISTS `assets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets` (
  `id` int(11) NOT NULL,
  `volumeId` int(11) DEFAULT NULL,
  `folderId` int(11) NOT NULL,
  `uploaderId` int(11) DEFAULT NULL,
  `filename` varchar(255) NOT NULL,
  `mimeType` varchar(255) DEFAULT NULL,
  `kind` varchar(50) NOT NULL DEFAULT 'unknown',
  `alt` text DEFAULT NULL,
  `width` int(10) unsigned DEFAULT NULL,
  `height` int(10) unsigned DEFAULT NULL,
  `size` bigint(20) unsigned DEFAULT NULL,
  `focalPoint` varchar(13) DEFAULT NULL,
  `deletedWithVolume` tinyint(1) DEFAULT NULL,
  `keptFile` tinyint(1) DEFAULT NULL,
  `dateModified` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_qvgtvxwwlxpafqemsbgcnfuuabsghawguivf` (`filename`,`folderId`),
  KEY `idx_abvtfcfcqgzppjrgofuzjkgdprqvrgecamec` (`folderId`),
  KEY `idx_bivetzxptnogsjjvthfyfqtxmejmcknttcde` (`volumeId`),
  KEY `fk_tekocsxyxnieyklrguywvjqnhanpwcufwobg` (`uploaderId`),
  CONSTRAINT `fk_lvihrokbpxzrgrmhkbhnnzcdbpixlpsyxbrj` FOREIGN KEY (`folderId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_modowmfkudoeglagnxbsrdobeahipbmutmmx` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tekocsxyxnieyklrguywvjqnhanpwcufwobg` FOREIGN KEY (`uploaderId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_tsjsorwzadpbpqdekpcuubqwgsphuvpxaufc` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `assets_sites`
--

DROP TABLE IF EXISTS `assets_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `assets_sites` (
  `assetId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `alt` text DEFAULT NULL,
  PRIMARY KEY (`assetId`,`siteId`),
  KEY `fk_aknalnuelkvjzfggeovumibomcxcvfyzuvba` (`siteId`),
  CONSTRAINT `fk_aknalnuelkvjzfggeovumibomcxcvfyzuvba` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_glkidgkgevdmgjkbjibfhlzlaocozqmqmgqu` FOREIGN KEY (`assetId`) REFERENCES `assets` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `auth_oauth_tokens`
--

DROP TABLE IF EXISTS `auth_oauth_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `auth_oauth_tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ownerHandle` varchar(255) NOT NULL,
  `providerType` varchar(255) NOT NULL,
  `tokenType` varchar(255) NOT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `accessToken` text DEFAULT NULL,
  `secret` text DEFAULT NULL,
  `expires` varchar(255) DEFAULT NULL,
  `refreshToken` text DEFAULT NULL,
  `resourceOwnerId` varchar(255) DEFAULT NULL,
  `values` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `authenticator`
--

DROP TABLE IF EXISTS `authenticator`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `authenticator` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `auth2faSecret` varchar(255) DEFAULT NULL,
  `oldTimestamp` int(10) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_lqkqvklsscofkuzcmuhzmqyirarugttwxhkz` (`userId`),
  CONSTRAINT `fk_lqkqvklsscofkuzcmuhzmqyirarugttwxhkz` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `bulkopevents`
--

DROP TABLE IF EXISTS `bulkopevents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bulkopevents` (
  `key` char(10) NOT NULL,
  `senderClass` varchar(255) NOT NULL,
  `eventName` varchar(255) NOT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`key`,`senderClass`,`eventName`),
  KEY `idx_ysvuwziiymmrgtwdrkpsowlzqogybnlfzaze` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `parentId` int(11) DEFAULT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_jdtdhiipxibhqhdrjnrsorabilokzbcngtpy` (`groupId`),
  KEY `fk_gtqjpmdvxqkiktckauevmrakbedagbcawuxa` (`parentId`),
  CONSTRAINT `fk_ekltgmycyzqgniebmeziaiuvonfituulthmy` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_gtqjpmdvxqkiktckauevmrakbedagbcawuxa` FOREIGN KEY (`parentId`) REFERENCES `categories` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_vrqtvmuntnirtheyxwwnaivpmzsdrijkpkjk` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups`
--

DROP TABLE IF EXISTS `categorygroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorygroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `defaultPlacement` enum('beginning','end') NOT NULL DEFAULT 'end',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uunanhzxghwptsxiizkbzlnjuwaxvmpbntgx` (`name`),
  KEY `idx_jwjmbrdxzdvswgrzsxdsstawqtrgjopuqzgo` (`handle`),
  KEY `idx_uvwkerycvzjcvbjxqobjxhwqxoehosngowzm` (`structureId`),
  KEY `idx_iucivdbueuhqivcstqnxhmmedcbhluyifnpy` (`fieldLayoutId`),
  KEY `idx_piswzyqdhcmfztsrkgdtwovlvnvphbovffqn` (`dateDeleted`),
  CONSTRAINT `fk_aerphudzxhtbpmredahlvapzjxoudhxkwhon` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_yzkizfrsuoibmzojzqbbaosarsptufacqxgz` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `categorygroups_sites`
--

DROP TABLE IF EXISTS `categorygroups_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorygroups_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT 1,
  `uriFormat` text DEFAULT NULL,
  `template` varchar(500) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_idnjmmbumtlyimwpghcnmcqvdndfqhlvokyx` (`groupId`,`siteId`),
  KEY `idx_cjkndovfayjuexqykawqmchuozjoagueujba` (`siteId`),
  CONSTRAINT `fk_ggkknmnhztypspuotgseladohqtwzrmyixrx` FOREIGN KEY (`groupId`) REFERENCES `categorygroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_lcmrwwreuymkayhpoussqwkblzkvhsjdbksu` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedattributes`
--

DROP TABLE IF EXISTS `changedattributes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `changedattributes` (
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `attribute` varchar(255) NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int(11) DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`attribute`),
  KEY `idx_khvqpffjismcfsqpdqlgcruhvygcepogvadg` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_rwywfgyogaofdouikozlmtushjaueatcoiek` (`siteId`),
  KEY `fk_xyhmlobytgekueeosolyvopkjtkrqkkfkpnm` (`userId`),
  CONSTRAINT `fk_nrkxricfghplaoujxnuyozvnhdetruyvpxhv` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_rwywfgyogaofdouikozlmtushjaueatcoiek` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_xyhmlobytgekueeosolyvopkjtkrqkkfkpnm` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `changedfields`
--

DROP TABLE IF EXISTS `changedfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `changedfields` (
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `layoutElementUid` char(36) NOT NULL DEFAULT '0',
  `dateUpdated` datetime NOT NULL,
  `propagated` tinyint(1) NOT NULL,
  `userId` int(11) DEFAULT NULL,
  PRIMARY KEY (`elementId`,`siteId`,`fieldId`,`layoutElementUid`),
  KEY `idx_yixjevqontcntogoqmbjpqlnxgctmkhhrxlz` (`elementId`,`siteId`,`dateUpdated`),
  KEY `fk_hxkitwxxoprypxilpoicfxohxearcpcokspe` (`siteId`),
  KEY `fk_lkktxosmjbksmxbgkfwwjudteinxrsdpcqnp` (`fieldId`),
  KEY `fk_tzrmrhhebfbnhvaeqtwqpyqirmjezdfehvot` (`userId`),
  CONSTRAINT `fk_hxkitwxxoprypxilpoicfxohxearcpcokspe` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_lkktxosmjbksmxbgkfwwjudteinxrsdpcqnp` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_tzrmrhhebfbnhvaeqtwqpyqirmjezdfehvot` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_vrypsfgzpzeijownmupepjjfqymlxzcjvvjy` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `contentblocks`
--

DROP TABLE IF EXISTS `contentblocks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contentblocks` (
  `id` int(11) NOT NULL,
  `primaryOwnerId` int(11) DEFAULT NULL,
  `fieldId` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_fbatyxybqahalcbfhhjfwmwiucjohusckaea` (`primaryOwnerId`),
  KEY `idx_cpwzlbyfwmbeyuergpumcknelghukdyfzysk` (`fieldId`),
  CONSTRAINT `fk_enihsclmaiypgqhyaifvzxuxwanxakwdvzcp` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_rawdacbutrhywmbxlthvtezzhyoirgakpxxz` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vewpqxqvrdsjnrnnonhuvfuylfcvbuzblrwb` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `craftidtokens`
--

DROP TABLE IF EXISTS `craftidtokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `craftidtokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `accessToken` text NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_aprtjzfhhgnrfsbfjhiyisovjfhnbxdbhaiq` (`userId`),
  CONSTRAINT `fk_aprtjzfhhgnrfsbfjhiyisovjfhnbxdbhaiq` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `deprecationerrors`
--

DROP TABLE IF EXISTS `deprecationerrors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `deprecationerrors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `key` varchar(255) NOT NULL,
  `fingerprint` varchar(255) NOT NULL,
  `lastOccurrence` datetime NOT NULL,
  `file` varchar(255) NOT NULL,
  `line` smallint(5) unsigned DEFAULT NULL,
  `message` text DEFAULT NULL,
  `traces` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`traces`)),
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ggqeiyvtqgzlkparplrdgikcqzkzsmglclkk` (`key`,`fingerprint`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `drafts`
--

DROP TABLE IF EXISTS `drafts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drafts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `canonicalId` int(11) DEFAULT NULL,
  `creatorId` int(11) DEFAULT NULL,
  `provisional` tinyint(1) NOT NULL DEFAULT 0,
  `name` varchar(255) NOT NULL,
  `notes` text DEFAULT NULL,
  `trackChanges` tinyint(1) NOT NULL DEFAULT 0,
  `dateLastMerged` datetime DEFAULT NULL,
  `saved` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `idx_pbjjnhpnrprdqbvwdqhmmjirshfkswdhbgnq` (`creatorId`,`provisional`),
  KEY `idx_igyysutmncnnbstaaxnbnygayzheetcgeovq` (`saved`),
  KEY `fk_pnjziqnbyykzrupscelklaupbcksriwnrrme` (`canonicalId`),
  CONSTRAINT `fk_ipktlizajpmowigitytbcucvtuqwzstrwdzy` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_pnjziqnbyykzrupscelklaupbcksriwnrrme` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=777 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elementactivity`
--

DROP TABLE IF EXISTS `elementactivity`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elementactivity` (
  `elementId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `draftId` int(11) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `timestamp` datetime DEFAULT NULL,
  PRIMARY KEY (`elementId`,`userId`,`type`),
  KEY `idx_lfntenacxydtfclryddiugdzcrshilkochqv` (`elementId`,`timestamp`,`userId`),
  KEY `fk_gesincdiwdmutikkuyhqzlrkadkbheroqanw` (`userId`),
  KEY `fk_uxobxrfpuiweyzqxztckzqcflucstlcywyqs` (`siteId`),
  KEY `fk_mgtnxakxxzfjcoldzotieovkfwsbaabewkjg` (`draftId`),
  CONSTRAINT `fk_gesincdiwdmutikkuyhqzlrkadkbheroqanw` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_mgtnxakxxzfjcoldzotieovkfwsbaabewkjg` FOREIGN KEY (`draftId`) REFERENCES `drafts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ncpfsuiybumtansfrugtqqwvywlllycrfhwm` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_uxobxrfpuiweyzqxztckzqcflucstlcywyqs` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements`
--

DROP TABLE IF EXISTS `elements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `canonicalId` int(11) DEFAULT NULL,
  `draftId` int(11) DEFAULT NULL,
  `revisionId` int(11) DEFAULT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `archived` tinyint(1) NOT NULL DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateLastMerged` datetime DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `deletedWithOwner` tinyint(1) DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qiibialuucjqeqxthdndfhqodrhcnlzfryro` (`dateDeleted`),
  KEY `idx_ycbmfgoisupnxhxbincuvcqpnilqkyuiqhag` (`fieldLayoutId`),
  KEY `idx_xagvruibfecvrqupeapkjclkpyozwbmooveu` (`type`),
  KEY `idx_gacuplsrjqjabddulzactzayoarjxuwvhnbb` (`enabled`),
  KEY `idx_tlnsdquubyavsbbrsfdevfzbltifdsoathqr` (`canonicalId`),
  KEY `idx_ufwcipjfzmbqkyzwpuxvljjnqtmluscldgsx` (`archived`,`dateCreated`),
  KEY `idx_hfbbfrbzhfugnxytcpftxoyddpuwguflobnx` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`),
  KEY `idx_tzjbhylhnfaupogwdllppqrniipqnkyxwpwd` (`archived`,`dateDeleted`,`draftId`,`revisionId`,`canonicalId`,`enabled`),
  KEY `fk_nurtvhxbusantavjrasarobzxbtelrsznnqc` (`draftId`),
  KEY `fk_bzohdwhanrmeucuqmzngbmuqlvlmuqirwbwr` (`revisionId`),
  CONSTRAINT `fk_bzohdwhanrmeucuqmzngbmuqlvlmuqirwbwr` FOREIGN KEY (`revisionId`) REFERENCES `revisions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_hdleolnjwfddskkpgcpedovmcaifkpzvupof` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_iqjvcupoxaaihgbplrxhefoucnbqfqbstukh` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_nurtvhxbusantavjrasarobzxbtelrsznnqc` FOREIGN KEY (`draftId`) REFERENCES `drafts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3376 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_bulkops`
--

DROP TABLE IF EXISTS `elements_bulkops`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_bulkops` (
  `elementId` int(11) NOT NULL,
  `key` char(10) NOT NULL,
  `timestamp` datetime NOT NULL,
  PRIMARY KEY (`elementId`,`key`),
  KEY `idx_vfrkqqvsamrcteuklvsypdwjixvezigivpdo` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_owners`
--

DROP TABLE IF EXISTS `elements_owners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_owners` (
  `elementId` int(11) NOT NULL,
  `ownerId` int(11) NOT NULL,
  `sortOrder` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`elementId`,`ownerId`),
  KEY `fk_dhwumnkkblggmgardwijeathnljiwubhkuzg` (`ownerId`),
  CONSTRAINT `fk_aczdnoaszuzejaadsmwxtpgjycqznkzzwago` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_dhwumnkkblggmgardwijeathnljiwubhkuzg` FOREIGN KEY (`ownerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `elements_sites`
--

DROP TABLE IF EXISTS `elements_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `elements_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `uri` varchar(255) DEFAULT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`content`)),
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_vjnigzezqicqxwafasnrqoyquqdduvdvdftq` (`elementId`,`siteId`),
  KEY `idx_ixpowpedfpxftkmpsitspmtnyxoefwchhery` (`siteId`),
  KEY `idx_faibkbrfkfvxazgejlgjrfrxnjqeblawadvk` (`title`,`siteId`),
  KEY `idx_lnznnfmrnlfaqunuspaemenziszgmlygpbnz` (`slug`,`siteId`),
  KEY `idx_cdkhcjlloeortlaiftjiniuunlenmlbluawu` (`enabled`),
  KEY `idx_icfhuppkjtndtkrunqobxqfcgpiebpzzeczy` (`uri`,`siteId`),
  CONSTRAINT `fk_jpjaekscyqockvjkuqbivtndfzwdoyxwdzxw` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ocrawvafzozycdcpcvcyeuoznawsacoananj` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3376 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entries`
--

DROP TABLE IF EXISTS `entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `entries` (
  `id` int(11) NOT NULL,
  `sectionId` int(11) DEFAULT NULL,
  `parentId` int(11) DEFAULT NULL,
  `primaryOwnerId` int(11) DEFAULT NULL,
  `fieldId` int(11) DEFAULT NULL,
  `typeId` int(11) NOT NULL,
  `postDate` datetime DEFAULT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `status` enum('live','pending','expired') NOT NULL DEFAULT 'live',
  `deletedWithEntryType` tinyint(1) DEFAULT NULL,
  `deletedWithSection` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_vxuhugvxhgwekpmglgfmpvpdaswydtlpmnsd` (`postDate`),
  KEY `idx_dqmpytanywvwebfvxiuzoelkiuzmipglvlci` (`expiryDate`),
  KEY `idx_snnelwquugcgsgcsyxztzzdagzzgbzctkkxn` (`status`),
  KEY `idx_oyusrrffxwjasnvimazilomnuayamrqrkkrs` (`sectionId`),
  KEY `idx_pcjlgiaggbycgdkknxbchlptmhrrklpwphsl` (`typeId`),
  KEY `idx_pqzzoyioccqmeqqxwdhzjuhucuqbgflktocu` (`primaryOwnerId`),
  KEY `idx_izzumizhihbjambmxxmqxetcmzycideztdow` (`fieldId`),
  KEY `fk_cbcpwmlhnhvcbapyfnqjxpyvjqlrypwyoegd` (`parentId`),
  CONSTRAINT `fk_btaaxmdovcglmftbupzffceaoihqwxqquprk` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_cbcpwmlhnhvcbapyfnqjxpyvjqlrypwyoegd` FOREIGN KEY (`parentId`) REFERENCES `entries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_qdyopajwvztatqgfirqpattfdtpbmmgivadv` FOREIGN KEY (`primaryOwnerId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tzonnsswtfphhxpunbliniqybfolxriqvsjv` FOREIGN KEY (`typeId`) REFERENCES `entrytypes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wdykeepvoppudrfwgjrfizqwqutksqefapak` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zyczynbybirhrsunpruvzossdkcuajozzxdo` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entries_authors`
--

DROP TABLE IF EXISTS `entries_authors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `entries_authors` (
  `entryId` int(11) NOT NULL,
  `authorId` int(11) NOT NULL,
  `sortOrder` smallint(5) unsigned NOT NULL,
  PRIMARY KEY (`entryId`,`authorId`),
  KEY `idx_kkkhdomcumrntegqlbnixgdvjxgomwxstvuy` (`authorId`),
  KEY `idx_yfevyzfnrsztelswamdicptklnkglnixdqxp` (`entryId`,`sortOrder`),
  CONSTRAINT `fk_dmrvjudwrfejjxwchksnnnnilhppsfaqlymf` FOREIGN KEY (`entryId`) REFERENCES `entries` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vefmiipxkunjvixyiptlbmvvuczdjslwmyjj` FOREIGN KEY (`authorId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `entrytypes`
--

DROP TABLE IF EXISTS `entrytypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `entrytypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `icon` varchar(255) DEFAULT NULL,
  `color` varchar(255) DEFAULT NULL,
  `hasTitleField` tinyint(1) NOT NULL DEFAULT 1,
  `titleTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text DEFAULT NULL,
  `titleFormat` varchar(255) DEFAULT NULL,
  `showSlugField` tinyint(1) DEFAULT 1,
  `slugTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `slugTranslationKeyFormat` text DEFAULT NULL,
  `showStatusField` tinyint(1) DEFAULT 1,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_vkehvdetjwprdqsulpbglbksfkusjqjgucci` (`fieldLayoutId`),
  KEY `idx_jjwomxpvnhulsribozssqisaqqlbsqjvmsyi` (`dateDeleted`),
  CONSTRAINT `fk_yafrsjzjdqztnbrxmdfobdpjjhyhaegzzlxc` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `feedme_feeds`
--

DROP TABLE IF EXISTS `feedme_feeds`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `feedme_feeds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `feedUrl` text NOT NULL,
  `feedType` varchar(255) DEFAULT NULL,
  `primaryElement` varchar(255) DEFAULT NULL,
  `elementType` varchar(255) NOT NULL,
  `elementGroup` text DEFAULT NULL,
  `siteId` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `singleton` tinyint(1) NOT NULL DEFAULT 0,
  `duplicateHandle` text DEFAULT NULL,
  `updateSearchIndexes` tinyint(1) NOT NULL DEFAULT 1,
  `paginationNode` text DEFAULT NULL,
  `fieldMapping` mediumtext DEFAULT NULL,
  `fieldUnique` text DEFAULT NULL,
  `passkey` varchar(255) NOT NULL,
  `backup` tinyint(1) NOT NULL DEFAULT 0,
  `setEmptyValues` tinyint(1) NOT NULL DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `feedme_logs`
--

DROP TABLE IF EXISTS `feedme_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `feedme_logs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `level` int(11) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `log_time` double DEFAULT NULL,
  `prefix` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_log_level` (`level`),
  KEY `idx_log_category` (`category`)
) ENGINE=InnoDB AUTO_INCREMENT=10189 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fieldlayouts`
--

DROP TABLE IF EXISTS `fieldlayouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `fieldlayouts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `config` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`config`)),
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qwwlwnqfvylkuewgaagypsrycjehryatpzow` (`dateDeleted`),
  KEY `idx_wchkxdaphzpbzeecvukzveawczlewmlmfyar` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `fields`
--

DROP TABLE IF EXISTS `fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `handle` varchar(64) NOT NULL,
  `context` varchar(255) NOT NULL DEFAULT 'global',
  `columnSuffix` char(8) DEFAULT NULL,
  `instructions` text DEFAULT NULL,
  `searchable` tinyint(1) NOT NULL DEFAULT 1,
  `translationMethod` varchar(255) NOT NULL DEFAULT 'none',
  `translationKeyFormat` text DEFAULT NULL,
  `type` varchar(255) NOT NULL,
  `settings` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_lsqfyxfqwsraezylphubazinzxcumkbmxziw` (`handle`,`context`),
  KEY `idx_dmvvcaxllibxdtchgbgdehiojdcqsayhgqpd` (`context`),
  KEY `idx_wysugkgwsibkwauvrgcreyaivgyqbwyyvwav` (`dateDeleted`)
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_emailtemplates`
--

DROP TABLE IF EXISTS `formie_emailtemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_emailtemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `template` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_fieldlayout_pages`
--

DROP TABLE IF EXISTS `formie_fieldlayout_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_fieldlayout_pages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `label` text NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `settings` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_wsellseropllfqtjvnmmlbieaotzifgaoqox` (`layoutId`),
  CONSTRAINT `fk_cgufcpckavqgbguoganyvvagswfccogwvstd` FOREIGN KEY (`layoutId`) REFERENCES `formie_fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_fieldlayout_rows`
--

DROP TABLE IF EXISTS `formie_fieldlayout_rows`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_fieldlayout_rows` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `pageId` int(11) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_yuhycebplsysnvprbobsairuoyjungdvbqkm` (`layoutId`),
  KEY `idx_zmrariclaivgmsbxewzqoawnbqaapexcsyza` (`pageId`),
  CONSTRAINT `fk_erbaorsqdlbvwbxpocexnfcqzfuahxkbndsf` FOREIGN KEY (`layoutId`) REFERENCES `formie_fieldlayouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vjombnskdidvaxcbyuzszobrfxmbalnerazb` FOREIGN KEY (`pageId`) REFERENCES `formie_fieldlayout_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_fieldlayouts`
--

DROP TABLE IF EXISTS `formie_fieldlayouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_fieldlayouts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_fields`
--

DROP TABLE IF EXISTS `formie_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_fields` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `layoutId` int(11) NOT NULL,
  `pageId` int(11) NOT NULL,
  `rowId` int(11) NOT NULL,
  `syncId` int(11) DEFAULT NULL,
  `label` text NOT NULL,
  `handle` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `settings` mediumtext DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_tkpfjpvluewfmtufxqestjgpkiomuegvjnmb` (`layoutId`),
  KEY `idx_vgtiahcwedmvzngwifqklgdigfurdcfhyzar` (`pageId`),
  KEY `idx_fyqoxcnmaojfduuzikkmcsmgnlvzluyueneu` (`rowId`),
  KEY `idx_difxqkzzntipncmbjbqlutovxnodjcpvqade` (`syncId`),
  KEY `idx_vfldraqemfzvopodoulmlrmpudvurlqwgwvq` (`handle`),
  CONSTRAINT `fk_brpmayrtdxwysvhsjyowqeqtahmlbwfbtqsf` FOREIGN KEY (`syncId`) REFERENCES `formie_fields` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_flrlfrzkprvpccfhbtjwrrebtaxrkthvywta` FOREIGN KEY (`pageId`) REFERENCES `formie_fieldlayout_pages` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vhjkvimadlsqmaablakviavmjyozlzyukgmt` FOREIGN KEY (`rowId`) REFERENCES `formie_fieldlayout_rows` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zcenyegufgxlsaktpzfvtpfcxzziagdtsnnz` FOREIGN KEY (`layoutId`) REFERENCES `formie_fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_forms`
--

DROP TABLE IF EXISTS `formie_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_forms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` varchar(64) NOT NULL,
  `settings` mediumtext DEFAULT NULL,
  `layoutId` int(11) DEFAULT NULL,
  `templateId` int(11) DEFAULT NULL,
  `submitActionEntryId` int(11) DEFAULT NULL,
  `submitActionEntrySiteId` int(11) DEFAULT NULL,
  `defaultStatusId` int(11) DEFAULT NULL,
  `dataRetention` enum('forever','minutes','hours','days','weeks','months','years') NOT NULL DEFAULT 'forever',
  `dataRetentionValue` int(11) DEFAULT NULL,
  `userDeletedAction` enum('retain','delete') NOT NULL DEFAULT 'retain',
  `fileUploadsAction` enum('retain','delete') NOT NULL DEFAULT 'retain',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_rxajpptdthellnalugthfibzkarwjchtukgq` (`layoutId`),
  KEY `idx_prrydlukpxxlywdrkzvaqhjhukbyapajnlgh` (`templateId`),
  KEY `idx_cddfegcondnyvkxhqlpbkezolseodmoqkpaz` (`defaultStatusId`),
  KEY `idx_xsjisypncmucbgsdbizpyrnllxnswvjvyrfd` (`submitActionEntryId`),
  KEY `idx_zidgduqsvixavfkicwnyffrldjnatpbtywhb` (`submitActionEntrySiteId`),
  CONSTRAINT `fk_abcroeupevcjhiuyisknquzeodeewuxgtqdw` FOREIGN KEY (`submitActionEntryId`) REFERENCES `entries` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_bsgirrthfwrrckqwjqvzctzyxqezwzmjtyxf` FOREIGN KEY (`layoutId`) REFERENCES `formie_fieldlayouts` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_clnhfclwuejwakbvnhedsmkwizknjehniaet` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_eozbcreculatnzjfkfvyfvxyyiducufpqdaa` FOREIGN KEY (`templateId`) REFERENCES `formie_formtemplates` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_wxhceocahlfqeouayilmxgnpwsjmtfopfxpp` FOREIGN KEY (`defaultStatusId`) REFERENCES `formie_statuses` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=3192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_formtemplates`
--

DROP TABLE IF EXISTS `formie_formtemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_formtemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `template` varchar(255) DEFAULT NULL,
  `useCustomTemplates` tinyint(1) DEFAULT 1,
  `outputCssLayout` tinyint(1) DEFAULT 1,
  `outputCssTheme` tinyint(1) DEFAULT 1,
  `outputJsBase` tinyint(1) DEFAULT 1,
  `outputJsTheme` tinyint(1) DEFAULT 1,
  `outputCssLocation` varchar(255) DEFAULT NULL,
  `outputJsLocation` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_ivnbqrrsusukwlcovuppjzsxzjawjzeauitw` (`fieldLayoutId`),
  CONSTRAINT `fk_fichcmwibfuzkopsjybkcsogwrymzfprbqso` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_integrations`
--

DROP TABLE IF EXISTS `formie_integrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_integrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `type` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `enabled` varchar(255) NOT NULL DEFAULT 'true',
  `settings` mediumtext DEFAULT NULL,
  `cache` longtext DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_notifications`
--

DROP TABLE IF EXISTS `formie_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `formId` int(11) NOT NULL,
  `templateId` int(11) DEFAULT NULL,
  `pdfTemplateId` int(11) DEFAULT NULL,
  `name` text NOT NULL,
  `handle` varchar(64) NOT NULL,
  `enabled` tinyint(1) DEFAULT 1,
  `subject` text DEFAULT NULL,
  `recipients` enum('email','conditions') NOT NULL DEFAULT 'email',
  `to` text DEFAULT NULL,
  `toConditions` text DEFAULT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `replyTo` text DEFAULT NULL,
  `replyToName` text DEFAULT NULL,
  `from` text DEFAULT NULL,
  `fromName` text DEFAULT NULL,
  `sender` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `attachFiles` tinyint(1) DEFAULT 1,
  `attachPdf` tinyint(1) DEFAULT 0,
  `attachAssets` text DEFAULT NULL,
  `enableConditions` tinyint(1) DEFAULT 0,
  `conditions` text DEFAULT NULL,
  `customSettings` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_zxqfoctgxwbdevfmmabgkrmwwqufuraobahh` (`formId`),
  KEY `idx_ksvgenjmxuqvmstuvbkfuptspgbbwqqmobkg` (`templateId`),
  KEY `fk_hbzxebnldpvsnatdeumrzzrlnlafggxyxqdm` (`pdfTemplateId`),
  CONSTRAINT `fk_hbzxebnldpvsnatdeumrzzrlnlafggxyxqdm` FOREIGN KEY (`pdfTemplateId`) REFERENCES `formie_pdftemplates` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_jpfstsfcpjbftrpchydfmynrxpqeyjnuyuep` FOREIGN KEY (`formId`) REFERENCES `formie_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_qafechuvybojsdanjvlitganxgabnizpjioo` FOREIGN KEY (`templateId`) REFERENCES `formie_emailtemplates` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_payments`
--

DROP TABLE IF EXISTS `formie_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) NOT NULL,
  `submissionId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `subscriptionId` int(11) DEFAULT NULL,
  `amount` decimal(14,4) DEFAULT NULL,
  `currency` varchar(255) DEFAULT NULL,
  `status` enum('pending','redirect','success','failed','processing') NOT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `redirectUrl` text DEFAULT NULL,
  `note` mediumtext DEFAULT NULL,
  `response` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_pbpccfwvxsddledccvybkyltlglhtsiiyduh` (`integrationId`),
  KEY `idx_kmdzjixkgxdsvydtmpsqepvqwlpqckytrras` (`fieldId`),
  KEY `idx_ljfmfdvtpljvxqwdzuttbyxoatjofonlzhel` (`reference`),
  KEY `fk_pewvqtdjfutudzwwlfnpwujpdxoeebrwgvaw` (`submissionId`),
  KEY `fk_hwdxrwbyjrmnjkqdmrjnhqcjvzymdyvtfxoe` (`subscriptionId`),
  CONSTRAINT `fk_hwdxrwbyjrmnjkqdmrjnhqcjvzymdyvtfxoe` FOREIGN KEY (`subscriptionId`) REFERENCES `formie_payments_subscriptions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_jdwnwutfmlpcfizxnevsycehuzmnxhvyufcr` FOREIGN KEY (`integrationId`) REFERENCES `formie_integrations` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_pewvqtdjfutudzwwlfnpwujpdxoeebrwgvaw` FOREIGN KEY (`submissionId`) REFERENCES `formie_submissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zxgjdlztummejihvjzdgkspmadwkcxwnrqkr` FOREIGN KEY (`fieldId`) REFERENCES `formie_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_payments_plans`
--

DROP TABLE IF EXISTS `formie_payments_plans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_payments_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `handle` varchar(255) DEFAULT NULL,
  `reference` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL,
  `planData` text DEFAULT NULL,
  `isArchived` tinyint(1) NOT NULL,
  `dateArchived` datetime DEFAULT NULL,
  `sortOrder` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_gsqragqbhwexxmiptcirqaaumovfjyvdlfzb` (`handle`),
  KEY `idx_hmvurhqpfrkwcdmnyeirkozngfyropqjabiv` (`integrationId`),
  KEY `idx_anutxptxtxzxnmxzvfnqgasbnvvnophoojqn` (`reference`),
  CONSTRAINT `fk_hoawurlvwiyyjfmxlsfaehjrtgywcertkpqc` FOREIGN KEY (`integrationId`) REFERENCES `formie_integrations` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_payments_subscriptions`
--

DROP TABLE IF EXISTS `formie_payments_subscriptions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_payments_subscriptions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `integrationId` int(11) DEFAULT NULL,
  `submissionId` int(11) DEFAULT NULL,
  `fieldId` int(11) DEFAULT NULL,
  `planId` int(11) DEFAULT NULL,
  `reference` varchar(255) NOT NULL,
  `subscriptionData` text DEFAULT NULL,
  `trialDays` int(11) NOT NULL,
  `nextPaymentDate` datetime DEFAULT NULL,
  `hasStarted` tinyint(1) NOT NULL DEFAULT 1,
  `isSuspended` tinyint(1) NOT NULL DEFAULT 0,
  `dateSuspended` datetime DEFAULT NULL,
  `isCanceled` tinyint(1) NOT NULL,
  `dateCanceled` datetime DEFAULT NULL,
  `isExpired` tinyint(1) NOT NULL,
  `dateExpired` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_nszdpiypzhcwyakbootpxshyktpwzerfrbzf` (`integrationId`),
  KEY `idx_zhvcbesabsmcoegwdwpktdqhcsnhdovhlzrm` (`submissionId`),
  KEY `idx_uletgfycsqbvrdelunglcnjlyvabwridbkty` (`fieldId`),
  KEY `idx_ohoppbbpwtnwwyojayaxfyrsrtoctdlulqcg` (`planId`),
  KEY `idx_llfcdwbgmcnntykgljiutliqdhrvsausrbhi` (`reference`),
  KEY `idx_zzsastgcuehsnntipcjeayqiiiktxdhibpnv` (`nextPaymentDate`),
  KEY `idx_hnsdofoqxmnafdzgkfwtlqkziirrhdcazwpo` (`dateExpired`),
  KEY `idx_qwdhmcokuwuekdyrlnymwistgsyvqwirgigg` (`dateExpired`),
  CONSTRAINT `fk_fiacfdjiyvmkpafronahyrfveeuaauyzwhhb` FOREIGN KEY (`planId`) REFERENCES `formie_payments_plans` (`id`),
  CONSTRAINT `fk_luawsngdzjezbvtbzswvrecbrrsrygmvkwjz` FOREIGN KEY (`integrationId`) REFERENCES `formie_integrations` (`id`),
  CONSTRAINT `fk_mafqwsjkkhduyzenonqoxwdrdbfryetvmnju` FOREIGN KEY (`fieldId`) REFERENCES `formie_fields` (`id`),
  CONSTRAINT `fk_nopxcmmxfmondobylqzshmzbtavtmpwtmbmk` FOREIGN KEY (`submissionId`) REFERENCES `formie_submissions` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_pdftemplates`
--

DROP TABLE IF EXISTS `formie_pdftemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_pdftemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `template` varchar(255) NOT NULL,
  `filenameFormat` varchar(255) NOT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_relations`
--

DROP TABLE IF EXISTS `formie_relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `sourceId` int(11) NOT NULL,
  `sourceSiteId` int(11) DEFAULT NULL,
  `targetId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_fkenkvdvfrtrtzlrefzxqobmuwyusbsfllcw` (`sourceId`,`sourceSiteId`,`targetId`),
  KEY `idx_llttzpibnyhbdrymipbzkhpzmnsgwwpavcmo` (`sourceId`),
  KEY `idx_hbfnwnohjgsdoulwdajldpmcuvzhfkfckkbd` (`targetId`),
  KEY `idx_jzsaagwfentfmkfiptzvrnvhzocbvmzwbclk` (`sourceSiteId`),
  CONSTRAINT `fk_hknyrmitrylzxpxxugaflkwtwvrijhjudmdr` FOREIGN KEY (`sourceSiteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_sciuhgapcxftmbgqmnulfkbpzsolhfwnwiqc` FOREIGN KEY (`sourceId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_wkyimtleaicvbvzxfclqtunufacelfllugap` FOREIGN KEY (`targetId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_sentnotifications`
--

DROP TABLE IF EXISTS `formie_sentnotifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_sentnotifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `formId` int(11) DEFAULT NULL,
  `submissionId` int(11) DEFAULT NULL,
  `notificationId` int(11) DEFAULT NULL,
  `subject` text DEFAULT NULL,
  `to` text DEFAULT NULL,
  `cc` text DEFAULT NULL,
  `bcc` text DEFAULT NULL,
  `replyTo` text DEFAULT NULL,
  `replyToName` text DEFAULT NULL,
  `from` text DEFAULT NULL,
  `fromName` text DEFAULT NULL,
  `sender` text DEFAULT NULL,
  `body` mediumtext DEFAULT NULL,
  `htmlBody` mediumtext DEFAULT NULL,
  `info` text DEFAULT NULL,
  `success` tinyint(1) DEFAULT NULL,
  `message` text DEFAULT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `dateUpdated` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_mqmpkuhgvgufeqlggrjgfhuiqxkjtgokjwuc` (`formId`),
  KEY `fk_sytrqqjukpgyazrxrgkxitgiptqqrffqvdxf` (`submissionId`),
  KEY `fk_ffuurdlhwmlgeojoxlzdclittlgukdtysdho` (`notificationId`),
  CONSTRAINT `fk_ffuurdlhwmlgeojoxlzdclittlgukdtysdho` FOREIGN KEY (`notificationId`) REFERENCES `formie_notifications` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_mqmpkuhgvgufeqlggrjgfhuiqxkjtgokjwuc` FOREIGN KEY (`formId`) REFERENCES `formie_forms` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_mvcayarqktrskzgiwybxpyuptxpzkgwtdbmy` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_sytrqqjukpgyazrxrgkxitgiptqqrffqvdxf` FOREIGN KEY (`submissionId`) REFERENCES `formie_submissions` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_statuses`
--

DROP TABLE IF EXISTS `formie_statuses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_statuses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `color` enum('green','orange','red','blue','yellow','pink','purple','turquoise','light','grey','black') NOT NULL DEFAULT 'green',
  `description` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(6) unsigned DEFAULT NULL,
  `isDefault` tinyint(1) DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_stencils`
--

DROP TABLE IF EXISTS `formie_stencils`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_stencils` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(64) NOT NULL,
  `data` mediumtext DEFAULT NULL,
  `templateId` int(11) DEFAULT NULL,
  `submitActionEntryId` int(11) DEFAULT NULL,
  `submitActionEntrySiteId` int(11) DEFAULT NULL,
  `defaultStatusId` int(11) DEFAULT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_fyzvxirpggezywbhsiojmfrlrrdkcqchhnev` (`templateId`),
  KEY `idx_rhqthqeoprhffhorqyzdddcnnbngdbmxqray` (`defaultStatusId`),
  CONSTRAINT `fk_jeuoiqhsntnbeatowkqqlsenlqvjjexrlnsv` FOREIGN KEY (`templateId`) REFERENCES `formie_formtemplates` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_pifswfutfxntlzwvfpnckosafkvzronuppem` FOREIGN KEY (`defaultStatusId`) REFERENCES `formie_statuses` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `formie_submissions`
--

DROP TABLE IF EXISTS `formie_submissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `formie_submissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`content`)),
  `formId` int(11) NOT NULL,
  `statusId` int(11) DEFAULT NULL,
  `userId` int(11) DEFAULT NULL,
  `isIncomplete` tinyint(1) DEFAULT 0,
  `isSpam` tinyint(1) DEFAULT 0,
  `spamReason` text DEFAULT NULL,
  `spamClass` varchar(255) DEFAULT NULL,
  `snapshot` text DEFAULT NULL,
  `ipAddress` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_olhwfygrtbpbmujrokconqbtpovixoozahum` (`formId`),
  KEY `idx_ihovtpcpdubtodiaudryjjvedjzylitswzah` (`statusId`),
  KEY `idx_zaogrohjldodbykdyhyhbemdldyzbmmadjga` (`userId`),
  CONSTRAINT `fk_lrgpcpaueytvbxkmowfrymxrmpukzoddkhuw` FOREIGN KEY (`formId`) REFERENCES `formie_forms` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ookegsgoqxoncsjobblmoluviszeggpxzjtz` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_wzcashzdbqtqwjvstxacgoyyuaathxgmrusd` FOREIGN KEY (`statusId`) REFERENCES `formie_statuses` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_xmzmkirxvmsxwanzeoayftmfuxoajxbcalnw` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `globalsets`
--

DROP TABLE IF EXISTS `globalsets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `globalsets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_xbsaazzhfhszjjvlrtwakfprfftqylfpoixl` (`name`),
  KEY `idx_oekjlhinxdcgehqfghqgsitypscdnsmtpyiy` (`handle`),
  KEY `idx_pcmckodvesbnmrquykwlfoaxnixovjpovxlj` (`fieldLayoutId`),
  KEY `idx_agwesgbdiznudgikaivifjxnsxdqljydismg` (`sortOrder`),
  CONSTRAINT `fk_abuqvrvmzewsyxtxaizvqgrmfbetlpqmzscq` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_riekewyysqlkppelpzwfwrhantegwhpxccqn` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=555 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `googlemaps_addresses`
--

DROP TABLE IF EXISTS `googlemaps_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `googlemaps_addresses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `formatted` varchar(255) DEFAULT NULL,
  `raw` text DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `street1` varchar(255) DEFAULT NULL,
  `street2` varchar(255) DEFAULT NULL,
  `city` varchar(255) DEFAULT NULL,
  `state` varchar(255) DEFAULT NULL,
  `zip` varchar(255) DEFAULT NULL,
  `neighborhood` varchar(255) DEFAULT NULL,
  `county` varchar(255) DEFAULT NULL,
  `country` varchar(255) DEFAULT NULL,
  `countryCode` varchar(255) DEFAULT NULL,
  `placeId` varchar(255) DEFAULT NULL,
  `lat` decimal(12,8) DEFAULT NULL,
  `lng` decimal(12,8) DEFAULT NULL,
  `zoom` tinyint(4) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_kvewpboexmmxkfkedwfaeivmkkpknwcquoim` (`elementId`,`siteId`,`fieldId`),
  KEY `idx_mgjyhmxoovosoprsajqyhvfpzwjehhuecgdz` (`elementId`),
  KEY `idx_brugxkjnouwaarvezexnxaiudgikpoleaosv` (`siteId`),
  KEY `idx_qkhwwucjjehzuzyjxcybinmhbllgiahxpojr` (`fieldId`),
  KEY `idx_imafefrmhshjeanocszdytsvejjniwqognqy` (`siteId`,`fieldId`),
  KEY `idx_ngoasmkxngxsymdpmacpljledlqbichkrzcn` (`elementId`,`siteId`),
  KEY `idx_icrdjferjjmtcnfsnfexnmwpsybhosgxbijj` (`elementId`,`fieldId`),
  CONSTRAINT `fk_bdhsrifdslnlnqvynhscqmytjtclqlvkqvgh` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_nqvnkbomsoehnizexbvpzvbobwynxzlvjzau` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_vivediezdmsegdgoqqvywzulessinjrfkusi` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1333 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqlschemas`
--

DROP TABLE IF EXISTS `gqlschemas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gqlschemas` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `scope` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`scope`)),
  `isPublic` tinyint(1) NOT NULL DEFAULT 0,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gqltokens`
--

DROP TABLE IF EXISTS `gqltokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gqltokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `accessToken` varchar(255) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `expiryDate` datetime DEFAULT NULL,
  `lastUsed` datetime DEFAULT NULL,
  `schemaId` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ogdlpvwgfwqnxgziosoqipsbajxwcpdwjpfq` (`accessToken`),
  UNIQUE KEY `idx_twiblfqsstzxrejysmhraysianqcokpkibmz` (`name`),
  KEY `fk_chalaclacaykoxoscfxramybbfsmeojwptnl` (`schemaId`),
  CONSTRAINT `fk_chalaclacaykoxoscfxramybbfsmeojwptnl` FOREIGN KEY (`schemaId`) REFERENCES `gqlschemas` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `imagetransformindex`
--

DROP TABLE IF EXISTS `imagetransformindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `imagetransformindex` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `assetId` int(11) NOT NULL,
  `transformer` varchar(255) DEFAULT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `format` varchar(255) DEFAULT NULL,
  `transformString` varchar(255) NOT NULL,
  `fileExists` tinyint(1) NOT NULL DEFAULT 0,
  `inProgress` tinyint(1) NOT NULL DEFAULT 0,
  `error` tinyint(1) NOT NULL DEFAULT 0,
  `dateIndexed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_fuqeeozcucihypiijzlhbyulpdsbulpbygma` (`assetId`,`transformString`)
) ENGINE=InnoDB AUTO_INCREMENT=192 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `imagetransforms`
--

DROP TABLE IF EXISTS `imagetransforms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `imagetransforms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `mode` enum('stretch','fit','crop','letterbox') NOT NULL DEFAULT 'crop',
  `position` enum('top-left','top-center','top-right','center-left','center-center','center-right','bottom-left','bottom-center','bottom-right') NOT NULL DEFAULT 'center-center',
  `width` int(10) unsigned DEFAULT NULL,
  `height` int(10) unsigned DEFAULT NULL,
  `format` varchar(255) DEFAULT NULL,
  `quality` int(11) DEFAULT NULL,
  `interlace` enum('none','line','plane','partition') NOT NULL DEFAULT 'none',
  `fill` varchar(11) DEFAULT NULL,
  `upscale` tinyint(1) NOT NULL DEFAULT 1,
  `parameterChangeTime` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_mltxzxqagzcumyyrnndebhvcxrrukqglcxsx` (`name`),
  KEY `idx_zhmqifimxmjppdwuaxxdkxrffslngdzxcfdl` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `info`
--

DROP TABLE IF EXISTS `info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(50) NOT NULL,
  `schemaVersion` varchar(15) NOT NULL,
  `maintenance` tinyint(1) NOT NULL DEFAULT 0,
  `configVersion` char(12) NOT NULL DEFAULT '000000000000',
  `fieldVersion` char(12) NOT NULL DEFAULT '000000000000',
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `track` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `applyTime` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_hokepbzjninyxdvfjfnijzzopbbwebbeobxn` (`track`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `plugins`
--

DROP TABLE IF EXISTS `plugins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `plugins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `handle` varchar(255) NOT NULL,
  `version` varchar(255) NOT NULL,
  `schemaVersion` varchar(255) NOT NULL,
  `installDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_yjxfmhlhejuqmhasefmufgetzyskntqrqzem` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `projectconfig`
--

DROP TABLE IF EXISTS `projectconfig`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `projectconfig` (
  `path` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`path`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue`
--

DROP TABLE IF EXISTS `queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `queue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `channel` varchar(255) NOT NULL DEFAULT 'queue',
  `job` longblob NOT NULL,
  `description` text DEFAULT NULL,
  `timePushed` int(11) NOT NULL,
  `ttr` int(11) NOT NULL,
  `delay` int(11) NOT NULL DEFAULT 0,
  `priority` int(10) unsigned NOT NULL DEFAULT 1024,
  `dateReserved` datetime DEFAULT NULL,
  `timeUpdated` int(11) DEFAULT NULL,
  `progress` smallint(6) NOT NULL DEFAULT 0,
  `progressLabel` varchar(255) DEFAULT NULL,
  `attempt` int(11) DEFAULT NULL,
  `fail` tinyint(1) DEFAULT 0,
  `dateFailed` datetime DEFAULT NULL,
  `error` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_mbkdbqdnsdqkupumbwhvaipofvnvhvivegkc` (`channel`,`fail`,`timeUpdated`,`timePushed`),
  KEY `idx_rmgvdauuujsoeewlyivkfntmyljkozojtunh` (`channel`,`fail`,`timeUpdated`,`delay`)
) ENGINE=InnoDB AUTO_INCREMENT=5675 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `recoverycodes`
--

DROP TABLE IF EXISTS `recoverycodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `recoverycodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `recoveryCodes` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `relations`
--

DROP TABLE IF EXISTS `relations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `relations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldId` int(11) NOT NULL,
  `sourceId` int(11) NOT NULL,
  `sourceSiteId` int(11) DEFAULT NULL,
  `targetId` int(11) NOT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_gtkubxldumrdhogfwakgskbciupcusvafuqe` (`fieldId`,`sourceId`,`sourceSiteId`,`targetId`),
  KEY `idx_wjqdselkasklqvojxksaspfrjjampxaiguep` (`sourceId`),
  KEY `idx_ljbakwrnceegyzzhwmologvanyctoojvyjwz` (`targetId`),
  KEY `idx_dksxuagleembzlnuapswpewfpjzdnytgmiqm` (`sourceSiteId`),
  CONSTRAINT `fk_lynlgeiiwesivccxiiqdhzsjtzqduvdqowlh` FOREIGN KEY (`sourceId`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ogujvhfyrzouqcbwfswvpvzaggtbkfsmatzk` FOREIGN KEY (`sourceSiteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_ubslzsujihoamjhneyxhzvnfwfemreqgvome` FOREIGN KEY (`fieldId`) REFERENCES `fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4195 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `resourcepaths`
--

DROP TABLE IF EXISTS `resourcepaths`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `resourcepaths` (
  `hash` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  PRIMARY KEY (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `canonicalId` int(11) NOT NULL,
  `creatorId` int(11) DEFAULT NULL,
  `num` int(11) NOT NULL,
  `notes` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_vovfedpvphsnrkjgenttfyeflnvxiiktyeto` (`canonicalId`,`num`),
  KEY `fk_hhcoenppvmvdebazuoowwqofstjgxyikfbaz` (`creatorId`),
  CONSTRAINT `fk_hhcoenppvmvdebazuoowwqofstjgxyikfbaz` FOREIGN KEY (`creatorId`) REFERENCES `users` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_wiafzflznoonbpoobdjzrqktmxhlqxjsmeml` FOREIGN KEY (`canonicalId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1828 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindex`
--

DROP TABLE IF EXISTS `searchindex`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindex` (
  `elementId` int(11) NOT NULL,
  `attribute` varchar(25) NOT NULL,
  `fieldId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `keywords` text NOT NULL,
  PRIMARY KEY (`elementId`,`attribute`,`fieldId`,`siteId`),
  FULLTEXT KEY `idx_xktlgbqafoazkhqgwffwkojajphychvralgk` (`keywords`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindexqueue`
--

DROP TABLE IF EXISTS `searchindexqueue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindexqueue` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `elementId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `reserved` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_vukubcqmqptdqhnjzffekcltjlskakssoxux` (`elementId`,`siteId`,`reserved`),
  CONSTRAINT `fk_yoxlyfepzvxrllzacpkqrqvglkwxjfswxgjh` FOREIGN KEY (`elementId`) REFERENCES `elements` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2257 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `searchindexqueue_fields`
--

DROP TABLE IF EXISTS `searchindexqueue_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `searchindexqueue_fields` (
  `jobId` int(11) NOT NULL,
  `fieldHandle` varchar(255) NOT NULL,
  PRIMARY KEY (`jobId`,`fieldHandle`),
  UNIQUE KEY `idx_qdndfxhuijqbydgqelcnmyopalwmuxymxwsg` (`jobId`,`fieldHandle`),
  CONSTRAINT `fk_dcqpxgjgquvnwtwfuoqiskmkciulpaitiasy` FOREIGN KEY (`jobId`) REFERENCES `searchindexqueue` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections`
--

DROP TABLE IF EXISTS `sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `type` enum('single','channel','structure') NOT NULL DEFAULT 'channel',
  `enableVersioning` tinyint(1) NOT NULL DEFAULT 0,
  `maxAuthors` smallint(5) unsigned DEFAULT NULL,
  `propagationMethod` varchar(255) NOT NULL DEFAULT 'all',
  `defaultPlacement` enum('beginning','end') NOT NULL DEFAULT 'end',
  `previewTargets` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`previewTargets`)),
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_qrpmxnrfdjqpcopeltsisloriogabqdfaurp` (`handle`),
  KEY `idx_lxsrucgwoiznmcttjddzpotbrkcackcqqoje` (`name`),
  KEY `idx_utlycaldrseybljwruetlrqruihxjocmutvg` (`structureId`),
  KEY `idx_mdzvlemchdowfonenjrjihvswxdlogpeqwyg` (`dateDeleted`),
  CONSTRAINT `fk_vfyocjkdagdwihnjzqqrvugbgscisixtvczd` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections_entrytypes`
--

DROP TABLE IF EXISTS `sections_entrytypes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections_entrytypes` (
  `sectionId` int(11) NOT NULL,
  `typeId` int(11) NOT NULL,
  `sortOrder` smallint(5) unsigned NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `handle` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`sectionId`,`typeId`),
  KEY `fk_fzigcrmravgmjettoztjeftkyrlaprkqnysd` (`typeId`),
  CONSTRAINT `fk_drwrmldkqtjkxxucxxbzrhgyyjkfyfcybgus` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_fzigcrmravgmjettoztjeftkyrlaprkqnysd` FOREIGN KEY (`typeId`) REFERENCES `entrytypes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sections_sites`
--

DROP TABLE IF EXISTS `sections_sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sections_sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sectionId` int(11) NOT NULL,
  `siteId` int(11) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT 1,
  `uriFormat` text DEFAULT NULL,
  `template` varchar(500) DEFAULT NULL,
  `enabledByDefault` tinyint(1) NOT NULL DEFAULT 1,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_sjfbyghiwpeyxcuyphrglivoldlooghoofln` (`sectionId`,`siteId`),
  KEY `idx_fvdgzfzqkyjrlybsmzbmdyzwgztjeuuwhmep` (`siteId`),
  CONSTRAINT `fk_vlwdqpgzrrzybebxkteyxjjjzurerhqwaplj` FOREIGN KEY (`sectionId`) REFERENCES `sections` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_xxqvpgliyyjqfdpqaoetmruffzwhxcdfcnrq` FOREIGN KEY (`siteId`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sequences`
--

DROP TABLE IF EXISTS `sequences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sequences` (
  `name` varchar(255) NOT NULL,
  `next` int(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `token` char(100) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_kilfokhjllioafxuubkvjdcixmrsekotyjhg` (`uid`),
  KEY `idx_njmiqpmztdeqgzgbsvfamewjqfrxmkphaqtj` (`token`),
  KEY `idx_tnwbupjfwdkdanuwtvpfzfalryslymvgvtze` (`dateUpdated`),
  KEY `idx_khjbkwfudyxgliaqlrendaqfjwdyxwgtuxjb` (`userId`),
  CONSTRAINT `fk_bekwypktjzctsibpuhnymderwsiuwtibgqhc` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `shunnedmessages`
--

DROP TABLE IF EXISTS `shunnedmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `shunnedmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `message` varchar(255) NOT NULL,
  `expiryDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_aaoaazajyxmzihslmjgrgtbicncsriryfchn` (`userId`,`message`),
  CONSTRAINT `fk_qfodjaorjzskvwglfrxoisuvanymqqcvgwlu` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sitegroups`
--

DROP TABLE IF EXISTS `sitegroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sitegroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_wotsdtzykyxrnlpgkmamgfwimmypdgimmxme` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sites`
--

DROP TABLE IF EXISTS `sites`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sites` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `primary` tinyint(1) NOT NULL,
  `enabled` varchar(255) NOT NULL DEFAULT 'true',
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `language` varchar(255) NOT NULL,
  `hasUrls` tinyint(1) NOT NULL DEFAULT 0,
  `baseUrl` varchar(255) DEFAULT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_gvthfinszicvegnghpypqvjyxbqzddgbrape` (`dateDeleted`),
  KEY `idx_wtrpnmcmvqellmztgodbqedlonroyqvsmwyb` (`handle`),
  KEY `idx_ksomrwvmiuodevyqoavcvapuhjdbqwmaqroq` (`sortOrder`),
  KEY `fk_sfbucdquvkgcghgtwgjgnxmxyvvlinltawtl` (`groupId`),
  CONSTRAINT `fk_sfbucdquvkgcghgtwgjgnxmxyvvlinltawtl` FOREIGN KEY (`groupId`) REFERENCES `sitegroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `sso_identities`
--

DROP TABLE IF EXISTS `sso_identities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sso_identities` (
  `provider` varchar(255) NOT NULL,
  `identityId` varchar(255) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`provider`,`identityId`,`userId`),
  KEY `fk_tzaclnpswsibbekhqqcwgglzwhxdxfhnxiue` (`userId`),
  CONSTRAINT `fk_tzaclnpswsibbekhqqcwgglzwhxdxfhnxiue` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structureelements`
--

DROP TABLE IF EXISTS `structureelements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `structureelements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `structureId` int(11) NOT NULL,
  `elementId` int(11) DEFAULT NULL,
  `root` int(10) unsigned DEFAULT NULL,
  `lft` int(10) unsigned NOT NULL,
  `rgt` int(10) unsigned NOT NULL,
  `level` smallint(5) unsigned NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_glwsesfxeuywleseaskiatelgqwhsavphfrk` (`structureId`,`elementId`),
  KEY `idx_ohtyplamqxdgdvwoewiufbgfssopjcnmobge` (`root`),
  KEY `idx_izhqjbyrvekgahskdtwwfrtdwxsxittabvdp` (`lft`),
  KEY `idx_mntqqgbsgtmmuqztopbyqqsewgvogzcwkgsj` (`rgt`),
  KEY `idx_crinuebacqhlojgjzlutlnsrduujsndwwxux` (`level`),
  KEY `idx_qksygbxkmeaxgbsnpapwjimqfaxckwnsynzh` (`elementId`),
  CONSTRAINT `fk_polmcjevuxconbxjzmwypjizowoyyalakuga` FOREIGN KEY (`structureId`) REFERENCES `structures` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `structures`
--

DROP TABLE IF EXISTS `structures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `structures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `maxLevels` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_vurwjlkxxmzdpcxvjeiisrjpptdstfqmxjtf` (`dateDeleted`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `systemmessages`
--

DROP TABLE IF EXISTS `systemmessages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `systemmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `subject` text NOT NULL,
  `body` text NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_etrewehssuqhqbrnqtyeafgiicowmywmjdgr` (`key`,`language`),
  KEY `idx_cllsekzmrcdtmciypfmewxfovgqqebegrhwr` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `taggroups`
--

DROP TABLE IF EXISTS `taggroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `taggroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_uavrgdjpotgogvrnlzfdumjufmaqyuuxujly` (`name`),
  KEY `idx_yldnmnceyqfaubyllydpjbhiiduwasouaycf` (`handle`),
  KEY `idx_uyueliiozbqtgcnrxcyjoxovkmthrexvcsmt` (`dateDeleted`),
  KEY `fk_hwbtqbpxtsynsgcrpnyskmdebwhmmwsakzex` (`fieldLayoutId`),
  CONSTRAINT `fk_hwbtqbpxtsynsgcrpnyskmdebwhmmwsakzex` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `deletedWithGroup` tinyint(1) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_rgiwbykgvorxrpuyakeblpjfenuxaxsdxjpm` (`groupId`),
  CONSTRAINT `fk_jeakhckbbkxymeltjxwzwxufybyhyxifcjgo` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_mvibepzqksdytkxjohuuwuylabzlyrdqlfre` FOREIGN KEY (`groupId`) REFERENCES `taggroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `tokens`
--

DROP TABLE IF EXISTS `tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tokens` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `token` char(32) NOT NULL,
  `route` text DEFAULT NULL,
  `usageLimit` tinyint(3) unsigned DEFAULT NULL,
  `usageCount` tinyint(3) unsigned DEFAULT NULL,
  `expiryDate` datetime NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_iguhilcajijkqzzmiuaqsnvkjisprqlcqmme` (`token`),
  KEY `idx_bgrdrdanvrlcjwrwqyrwtzaipjiympabilql` (`expiryDate`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups`
--

DROP TABLE IF EXISTS `usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `usergroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `description` text DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_nifgpehogtkhcvvjwvdwmfwlozfdnbsujsgs` (`handle`),
  KEY `idx_jrxgafsujnsuoqncgwjlevwprvvtpfvuheha` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `usergroups_users`
--

DROP TABLE IF EXISTS `usergroups_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `usergroups_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `groupId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_wbuxnxijmlcywxwuweutdpvzwupsblalziyu` (`groupId`,`userId`),
  KEY `idx_dqsqmznpdazocfzhimavjhxfgesvrsavnphg` (`userId`),
  CONSTRAINT `fk_ljeblfdgmxbubgysbibtizlwmlknlkupehih` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_nmguplpcqlnmygqmojtshsryqwgyoystbyce` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions`
--

DROP TABLE IF EXISTS `userpermissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ddentucjxuehhjtoimzoqdtygrwphwzvaxww` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_usergroups`
--

DROP TABLE IF EXISTS `userpermissions_usergroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions_usergroups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permissionId` int(11) NOT NULL,
  `groupId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_ucjurorivfhaorffdrnomvhgtccyazavhutz` (`permissionId`,`groupId`),
  KEY `idx_fnmnqwfixjevawiudypfcgvtigcnbipmovhe` (`groupId`),
  CONSTRAINT `fk_ahbgiomxhstwpcelpekgmyiuypuuazcculwj` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_zxjibncdboywfmcxqwhpostyonqmcgmqnmds` FOREIGN KEY (`groupId`) REFERENCES `usergroups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpermissions_users`
--

DROP TABLE IF EXISTS `userpermissions_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpermissions_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `permissionId` int(11) NOT NULL,
  `userId` int(11) NOT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_agjecihoglwrhpzfepiretvhgyrsyeydbien` (`permissionId`,`userId`),
  KEY `idx_gwgqwdcwjrmjrewzsdulljzkbnhwohhhdole` (`userId`),
  CONSTRAINT `fk_edvjmuwynfgcnocdgkpinysmqwewednubgsx` FOREIGN KEY (`permissionId`) REFERENCES `userpermissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_xwygztsglwroncjawbabwftszxrhhcliojsx` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `userpreferences`
--

DROP TABLE IF EXISTS `userpreferences`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `userpreferences` (
  `userId` int(11) NOT NULL AUTO_INCREMENT,
  `preferences` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`preferences`)),
  PRIMARY KEY (`userId`),
  CONSTRAINT `fk_ndzcvkhzlvudkhfdijyylmzljbmswdgdhemh` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` int(11) NOT NULL,
  `photoId` int(11) DEFAULT NULL,
  `affiliatedSiteId` int(11) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `pending` tinyint(1) NOT NULL DEFAULT 0,
  `locked` tinyint(1) NOT NULL DEFAULT 0,
  `suspended` tinyint(1) NOT NULL DEFAULT 0,
  `admin` tinyint(1) NOT NULL DEFAULT 0,
  `username` varchar(255) DEFAULT NULL,
  `fullName` varchar(255) DEFAULT NULL,
  `firstName` varchar(255) DEFAULT NULL,
  `lastName` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `lastLoginDate` datetime DEFAULT NULL,
  `lastLoginAttemptIp` varchar(45) DEFAULT NULL,
  `invalidLoginWindowStart` datetime DEFAULT NULL,
  `invalidLoginCount` tinyint(3) unsigned DEFAULT NULL,
  `lastInvalidLoginDate` datetime DEFAULT NULL,
  `lockoutDate` datetime DEFAULT NULL,
  `hasDashboard` tinyint(1) NOT NULL DEFAULT 0,
  `verificationCode` varchar(255) DEFAULT NULL,
  `verificationCodeIssuedDate` datetime DEFAULT NULL,
  `unverifiedEmail` varchar(255) DEFAULT NULL,
  `passwordResetRequired` tinyint(1) NOT NULL DEFAULT 0,
  `lastPasswordChangeDate` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_zpgnwdxlibbpqazfhgiwlypvdkvfnbhvbofm` (`active`),
  KEY `idx_yblhifndlrcnhyhntbrnildiqaxglncchxaf` (`locked`),
  KEY `idx_uvqjtsznmwpxjnrznfuhevpvmbyaohgpdsuz` (`pending`),
  KEY `idx_mlimddujldrcphevposyxvdwufmefhhekgis` (`suspended`),
  KEY `idx_suhaweibsmrkzahdbttcrozifoymoiqwaevc` (`verificationCode`),
  KEY `idx_pmwjwhvicilxxwxrvjmzmvcqqajgpeaokyhq` (`email`),
  KEY `idx_svrmuefimiuinvktrrntubsnuknqkufdojdg` (`username`),
  KEY `fk_ktgltzjkmpoqfsdclgvnmiroliayurdlnviy` (`photoId`),
  KEY `fk_tnnwhvjjcpdbztlspbsbcziwqoqjzwzwwirb` (`affiliatedSiteId`),
  CONSTRAINT `fk_ktgltzjkmpoqfsdclgvnmiroliayurdlnviy` FOREIGN KEY (`photoId`) REFERENCES `assets` (`id`) ON DELETE SET NULL,
  CONSTRAINT `fk_pvogbbkodeqspdsqgfvcbkamrfjvbpqfnuvo` FOREIGN KEY (`id`) REFERENCES `elements` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_tnnwhvjjcpdbztlspbsbcziwqoqjzwzwwirb` FOREIGN KEY (`affiliatedSiteId`) REFERENCES `sites` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumefolders`
--

DROP TABLE IF EXISTS `volumefolders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumefolders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parentId` int(11) DEFAULT NULL,
  `volumeId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `path` varchar(255) DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_xymsimganfahzmnhhaxbizplgrkrozpeqovc` (`name`,`parentId`,`volumeId`),
  KEY `idx_vvdhtvkgzdckqxhuwvsmzaxijrvcrtfhcuai` (`parentId`),
  KEY `idx_lxshjhzcrxghtwsrndsufsgsfqigqpzjnrtc` (`volumeId`),
  CONSTRAINT `fk_cltqwyvsdanditwyzasjkmcotokzlpizvaaz` FOREIGN KEY (`parentId`) REFERENCES `volumefolders` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fk_ktzfquwhcsxsnxyahxfiduamgksdpfvfpxql` FOREIGN KEY (`volumeId`) REFERENCES `volumes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `volumes`
--

DROP TABLE IF EXISTS `volumes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `volumes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fieldLayoutId` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `handle` varchar(255) NOT NULL,
  `fs` varchar(255) NOT NULL,
  `subpath` varchar(255) DEFAULT NULL,
  `transformFs` varchar(255) DEFAULT NULL,
  `transformSubpath` varchar(255) DEFAULT NULL,
  `titleTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `titleTranslationKeyFormat` text DEFAULT NULL,
  `altTranslationMethod` varchar(255) NOT NULL DEFAULT 'site',
  `altTranslationKeyFormat` text DEFAULT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `dateDeleted` datetime DEFAULT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_gbigkeuoxhyqciuxrrmcfnnfvmsymtdtlkgk` (`name`),
  KEY `idx_nibgarnftzszvgolotdqcktqauupeyhpcqgo` (`handle`),
  KEY `idx_ndvgpmousdymdklznjefxqtpldprglmmbqhj` (`fieldLayoutId`),
  KEY `idx_gusuktkxxflgmckzckhzuameydxzprqrhkfj` (`dateDeleted`),
  CONSTRAINT `fk_nyzfmnsroeqpwepnfcjzoeuevldyotxpgwqo` FOREIGN KEY (`fieldLayoutId`) REFERENCES `fieldlayouts` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `webauthn`
--

DROP TABLE IF EXISTS `webauthn`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `webauthn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `credentialId` varchar(255) DEFAULT NULL,
  `credential` text DEFAULT NULL,
  `credentialName` varchar(255) DEFAULT NULL,
  `dateLastUsed` datetime DEFAULT NULL,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fk_iwgkrireoeyxfnrukfprchjerpaxphldcxvj` (`userId`),
  CONSTRAINT `fk_iwgkrireoeyxfnrukfprchjerpaxphldcxvj` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `sortOrder` smallint(5) unsigned DEFAULT NULL,
  `colspan` tinyint(4) DEFAULT NULL,
  `settings` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`settings`)),
  `enabled` tinyint(1) NOT NULL DEFAULT 1,
  `dateCreated` datetime NOT NULL,
  `dateUpdated` datetime NOT NULL,
  `uid` char(36) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_nerzmenxwpjdybozzdiijnhabosizuuofrex` (`userId`),
  CONSTRAINT `fk_otipcgdghpcpsmkctrysvrtttpiqgarfiigu` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping routines for database 'akg_craft'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-10-08 17:45:33
/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.14-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: akg_craft
-- ------------------------------------------------------
-- Server version	10.11.14-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Dumping data for table `addresses`
--

LOCK TABLES `addresses` WRITE;
/*!40000 ALTER TABLE `addresses` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `addresses` VALUES
(8,2,2,'US','NJ','Toms River',NULL,'08757',NULL,'1750 NJ-37',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-04-18 17:32:44','2025-04-18 17:32:44');
/*!40000 ALTER TABLE `addresses` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assetindexingsessions`
--

LOCK TABLES `assetindexingsessions` WRITE;
/*!40000 ALTER TABLE `assetindexingsessions` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `assetindexingsessions` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assets`
--

LOCK TABLES `assets` WRITE;
/*!40000 ALTER TABLE `assets` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `assets` VALUES
(86,1,1,1,'arbors.svg',NULL,'image',NULL,481,65,7435,NULL,1,1,'2025-04-18 18:31:40','2025-04-18 18:31:40','2025-04-18 18:31:40'),
(136,2,2,1,'arbors-entrance.jpg',NULL,'image',NULL,1920,1440,1835577,NULL,NULL,NULL,'2025-04-18 18:44:35','2025-04-18 18:44:35','2025-04-18 18:44:35'),
(137,2,2,1,'arbors-room.jpg',NULL,'image',NULL,1500,1000,220928,NULL,NULL,NULL,'2025-04-18 18:44:36','2025-04-18 18:44:36','2025-04-18 18:44:36'),
(138,2,2,1,'arbors-table.jpg',NULL,'image',NULL,1500,1000,402800,NULL,NULL,NULL,'2025-04-18 18:44:36','2025-04-18 18:44:36','2025-04-18 18:44:36'),
(285,5,7,1,'hands_holding.jpg','image/jpeg','image',NULL,1601,801,850595,NULL,NULL,NULL,'2025-09-05 20:01:00','2025-07-30 22:47:59','2025-09-05 20:01:00'),
(545,2,2,1,'Arbors-Cover-Photo.jpg','image/jpeg','image',NULL,5002,3336,4317908,NULL,NULL,NULL,'2025-09-02 20:43:22','2025-09-02 20:43:22','2025-09-02 20:43:22'),
(548,3,3,1,'Arbors-flyer.pdf','application/pdf','pdf',NULL,NULL,NULL,1965207,NULL,NULL,NULL,'2025-09-02 21:15:28','2025-09-02 21:15:29','2025-09-02 21:15:29'),
(612,6,8,1,'GreatPlacetoWork.jpg','image/jpeg','image',NULL,500,500,91067,NULL,NULL,NULL,'2025-09-03 21:56:34','2025-09-03 21:56:34','2025-09-03 21:56:34'),
(613,6,8,1,'StrivingforTen.jpg','image/jpeg','image',NULL,500,500,55294,NULL,NULL,NULL,'2025-09-03 21:56:34','2025-09-03 21:56:34','2025-09-03 21:56:34'),
(614,6,8,1,'5Star_OQM.jpg','image/jpeg','image',NULL,500,500,99483,NULL,NULL,NULL,'2025-09-03 21:56:35','2025-09-03 21:56:35','2025-09-03 21:56:35'),
(632,4,4,1,'Arbors-Admin.jpg','image/jpeg','image',NULL,1080,1080,62300,NULL,NULL,NULL,'2025-09-03 22:27:11','2025-09-03 22:27:11','2025-09-03 22:27:11'),
(634,4,4,1,'Arbors-AD-1.jpg','image/jpeg','image',NULL,1080,1080,75707,NULL,NULL,NULL,'2025-09-03 22:27:23','2025-09-03 22:27:23','2025-09-03 22:27:23'),
(2516,6,8,1,'StriveforTen_Updated.jpg','image/jpeg','image',NULL,1000,1000,194040,NULL,NULL,NULL,'2025-09-19 16:58:14','2025-09-19 16:58:14','2025-09-19 16:58:14'),
(2594,5,7,1,'ListenToUsVideo.jpg','image/jpeg','image',NULL,1248,702,524232,NULL,NULL,NULL,'2025-09-19 18:57:57','2025-09-19 18:57:57','2025-09-19 18:57:57'),
(2740,6,8,1,'CMS_5-Star-QM-2.png','image/png','image',NULL,2160,2164,694997,NULL,0,0,'2025-09-22 20:40:48','2025-09-22 20:40:48','2025-09-22 20:40:48'),
(2800,7,9,1,'rehab_2025-09-23-212249_sgzj.png','image/png','image',NULL,178,178,10114,NULL,NULL,NULL,'2025-09-23 21:22:49','2025-09-23 21:13:16','2025-09-23 21:22:49'),
(2803,7,9,1,'post-acute_2025-09-23-212238_tmva.png','image/png','image',NULL,178,178,8458,NULL,NULL,NULL,'2025-09-23 21:22:38','2025-09-23 21:13:36','2025-09-23 21:22:38'),
(2806,7,9,1,'advanced_2025-09-23-212231_zbhk.png','image/png','image',NULL,178,178,9147,NULL,NULL,NULL,'2025-09-23 21:22:31','2025-09-23 21:13:42','2025-09-23 21:22:31'),
(2809,7,9,1,'long-term_2025-09-23-212224_mktw.png','image/png','image',NULL,178,178,11754,NULL,NULL,NULL,'2025-09-23 21:22:24','2025-09-23 21:13:48','2025-09-23 21:22:24'),
(2855,5,7,1,'WhatisaRespiteStay_Article.jpg','image/jpeg','image',NULL,1020,510,144402,NULL,NULL,NULL,'2025-09-24 17:19:20','2025-09-24 17:19:20','2025-09-24 17:19:20'),
(2856,5,7,1,'CaringForaLovedOneatHome_Article.jpg','image/jpeg','image',NULL,1020,510,113589,NULL,NULL,NULL,'2025-09-24 17:19:27','2025-09-24 17:19:27','2025-09-24 17:19:27'),
(2857,5,7,1,'CaringFortheWholePerson_Article.jpg','image/jpeg','image',NULL,1020,510,145044,NULL,NULL,NULL,'2025-09-24 17:19:28','2025-09-24 17:19:28','2025-09-24 17:19:28'),
(2858,5,7,1,'LevelsofCareExplained_Article.jpg','image/jpeg','image',NULL,1020,510,105189,NULL,NULL,NULL,'2025-09-24 17:19:28','2025-09-24 17:19:28','2025-09-24 17:19:28'),
(2869,6,8,1,'BestOfMineralCounty.png','image/png','image',NULL,299,300,75547,NULL,NULL,NULL,'2025-09-24 18:09:43','2025-09-24 18:09:43','2025-09-24 18:09:43'),
(2870,6,8,1,'GreatPlaceToWork-2025.png','image/png','image',NULL,300,302,25150,NULL,NULL,NULL,'2025-09-24 18:09:44','2025-09-24 18:09:44','2025-09-24 18:09:44'),
(2871,6,8,1,'JointCommission.png','image/png','image',NULL,300,302,91559,NULL,NULL,NULL,'2025-09-24 18:09:44','2025-09-24 18:09:44','2025-09-24 18:09:44'),
(2872,6,8,1,'NewsweekBestNursingHomes.png','image/png','image',NULL,299,300,80372,NULL,NULL,NULL,'2025-09-24 18:09:44','2025-09-24 18:09:44','2025-09-24 18:09:44'),
(2873,6,8,1,'CMS_5-Star-QM-2.png','image/png','image',NULL,2160,2164,694997,NULL,NULL,NULL,'2025-10-06 17:12:47','2025-09-24 18:09:45','2025-10-06 17:12:47'),
(2874,6,8,1,'US-News-Best-Nursing-Homes.png','image/png','image',NULL,300,302,64612,NULL,NULL,NULL,'2025-09-24 18:09:45','2025-09-24 18:09:45','2025-10-08 18:29:50'),
(2877,5,7,1,'BeyondBingo_Article.jpg','image/jpeg','image',NULL,1020,510,215411,NULL,NULL,NULL,'2025-09-24 19:41:44','2025-09-24 19:41:44','2025-09-24 19:41:44'),
(2886,6,8,1,'striving_for_ten.png','image/png','image',NULL,1810,1810,221332,NULL,NULL,NULL,'2025-09-25 14:02:18','2025-09-25 14:02:18','2025-09-25 14:02:18'),
(2887,6,8,1,'Bronze-ahca.png','image/png','image',NULL,363,362,114299,NULL,NULL,NULL,'2025-09-25 14:07:12','2025-09-25 14:05:38','2025-09-25 14:07:18'),
(2888,6,8,1,'Silver-AHCA.png','image/png','image',NULL,364,365,108343,NULL,NULL,NULL,'2025-09-25 14:06:48','2025-09-25 14:05:39','2025-09-25 14:07:01'),
(2889,6,8,1,'AHCA-Silver2.png','image/png','image',NULL,364,365,108343,NULL,NULL,NULL,'2025-09-25 15:24:15','2025-09-25 15:18:29','2025-09-25 15:24:15'),
(2890,6,8,1,'AHCA-Bronze-2.png','image/png','image',NULL,363,362,114299,NULL,NULL,NULL,'2025-09-25 15:24:27','2025-09-25 15:18:40','2025-09-25 15:24:27'),
(2927,5,7,1,'QuestionstoAsk_Blog.jpg','image/jpeg','image',NULL,1020,510,135378,NULL,NULL,NULL,'2025-09-30 19:28:01','2025-09-30 19:28:01','2025-09-30 19:28:01'),
(2931,3,3,1,'Complete-Care-Privacy-Policy.pdf','application/pdf','pdf',NULL,NULL,NULL,171776,NULL,NULL,NULL,'2025-09-30 22:22:11','2025-09-30 22:22:11','2025-09-30 22:22:11'),
(2933,3,3,1,'Complete-Care-Website-Privacy-Policy.pdf','application/pdf','pdf',NULL,NULL,NULL,124312,NULL,NULL,NULL,'2025-09-30 22:22:21','2025-09-30 22:22:21','2025-09-30 22:22:21'),
(2934,3,3,1,'Complete-Care-Terms-of-Service.pdf','application/pdf','pdf',NULL,NULL,NULL,93180,NULL,NULL,NULL,'2025-09-30 22:22:35','2025-09-30 22:22:35','2025-09-30 22:22:35'),
(2941,3,3,1,'NonDiscriminationNotice.pdf','application/pdf','pdf',NULL,NULL,NULL,151589,NULL,NULL,NULL,'2025-09-30 22:43:05','2025-09-30 22:43:05','2025-09-30 22:43:05'),
(2968,2,2,1,'DSC_1449.jpg','image/jpeg','image',NULL,6016,4016,12007055,NULL,NULL,NULL,'2025-10-06 17:44:50','2025-10-06 17:44:50','2025-10-06 17:44:50'),
(2970,6,8,1,'CMS_4-Star-QM.png','image/png','image',NULL,2160,2164,694073,NULL,NULL,NULL,'2025-10-06 17:46:00','2025-10-06 17:46:00','2025-10-06 17:46:00'),
(3011,2,2,1,'Brick-Lobby.jpg','image/jpeg','image',NULL,1600,1200,302745,NULL,NULL,NULL,'2025-10-08 18:19:10','2025-10-08 18:19:10','2025-10-08 18:19:10'),
(3017,6,8,1,'CMS-Overall-5.png','image/png','image',NULL,2160,2164,696318,NULL,NULL,NULL,'2025-10-08 18:26:17','2025-10-08 18:26:17','2025-10-08 18:26:17'),
(3018,6,8,1,'CMS-Overall-4.png','image/png','image',NULL,2160,2164,695247,NULL,NULL,NULL,'2025-10-08 18:26:56','2025-10-08 18:26:56','2025-10-08 18:26:56'),
(3019,6,8,1,'CMS-Quality-and-Overall-4.png','image/png','image',NULL,2160,2164,693858,NULL,NULL,NULL,'2025-10-08 18:28:09','2025-10-08 18:28:09','2025-10-08 18:28:09'),
(3020,6,8,1,'US-News-Short-Term.png','image/png','image',NULL,924,976,143109,NULL,NULL,NULL,'2025-10-08 18:29:13','2025-10-08 18:29:13','2025-10-08 18:29:13'),
(3021,6,8,1,'VOHRA.png','image/png','image',NULL,1275,501,71637,NULL,NULL,NULL,'2025-10-08 18:30:50','2025-10-08 18:30:50','2025-10-08 18:31:22'),
(3022,6,8,1,'Local-BOMineral-2025-Logo.png','image/png','image',NULL,3600,3600,4033236,NULL,NULL,NULL,'2025-10-08 18:31:48','2025-10-08 18:31:49','2025-10-08 18:31:49'),
(3023,6,8,1,'Local-BOMineral-2025-Logo_WINNER.png','image/png','image',NULL,3600,3600,4296041,NULL,NULL,NULL,'2025-10-08 18:32:35','2025-10-08 18:32:35','2025-10-08 18:32:35'),
(3048,4,4,1,'Brick-Admin.jpg','image/jpeg','image',NULL,1080,1080,94395,NULL,NULL,NULL,'2025-10-08 18:42:24','2025-10-08 18:42:24','2025-10-08 18:42:24'),
(3058,2,2,1,'BurlingtonWoods-Lobby.jpg','image/jpeg','image',NULL,5044,3363,5445041,NULL,NULL,NULL,'2025-10-08 18:44:46','2025-10-08 18:44:46','2025-10-08 18:44:46'),
(3084,4,4,1,'Burlington-AD-1.jpg','image/jpeg','image',NULL,1080,1080,103887,NULL,NULL,NULL,'2025-10-08 18:51:15','2025-10-08 18:51:15','2025-10-08 18:51:15'),
(3090,2,2,1,'court-house-lobby.jpg','image/jpeg','image',NULL,5968,3979,9229046,NULL,NULL,NULL,'2025-10-08 18:53:50','2025-10-08 18:53:50','2025-10-08 18:54:27'),
(3122,2,2,1,'GreenAcres-Lobby.jpg','image/jpeg','image',NULL,6016,4016,11784141,NULL,NULL,NULL,'2025-10-08 19:52:53','2025-10-08 19:52:54','2025-10-08 19:52:54'),
(3137,4,4,1,'GreenAcres-AD.jpg','image/jpeg','image',NULL,1080,1080,105237,NULL,NULL,NULL,'2025-10-08 19:59:08','2025-10-08 19:59:08','2025-10-08 19:59:08'),
(3158,2,2,1,'HolidayCity-Lobby.jpg','image/jpeg','image',NULL,6016,4016,15103883,NULL,NULL,NULL,'2025-10-08 20:21:30','2025-10-08 20:21:30','2025-10-08 20:22:26'),
(3180,4,4,1,'Holiday-City-AD.jpg','image/jpeg','image',NULL,1080,1080,97681,NULL,NULL,NULL,'2025-10-08 20:25:38','2025-10-08 20:25:38','2025-10-08 20:25:38'),
(3221,4,4,1,'Bey-Lea-AL-Admin.jpg','image/jpeg','image',NULL,1080,1080,148526,NULL,NULL,NULL,'2025-10-08 22:21:38','2025-10-08 22:21:38','2025-10-08 22:21:38'),
(3235,2,2,1,'bey-lea_bathroom.jpg','image/jpeg','image',NULL,6016,4016,9138369,NULL,NULL,NULL,'2025-10-08 22:24:19','2025-10-08 22:24:19','2025-10-08 22:24:19'),
(3236,2,2,1,'bey-lea_common.jpg','image/jpeg','image',NULL,6016,4016,16366238,NULL,NULL,NULL,'2025-10-08 22:24:35','2025-10-08 22:24:36','2025-10-08 22:24:36'),
(3237,2,2,1,'bey-lea_couch.jpg','image/jpeg','image',NULL,6016,4016,12007055,NULL,NULL,NULL,'2025-10-08 22:24:47','2025-10-08 22:24:47','2025-10-08 22:24:47'),
(3238,2,2,1,'bey-lea_room.jpg','image/jpeg','image',NULL,6016,4016,12238256,NULL,NULL,NULL,'2025-10-08 22:24:58','2025-10-08 22:24:58','2025-10-08 22:24:58'),
(3239,2,2,1,'bey-lea_room2.jpg','image/jpeg','image',NULL,6016,4016,12394826,NULL,NULL,NULL,'2025-10-08 22:25:08','2025-10-08 22:25:08','2025-10-08 22:25:08'),
(3240,2,2,1,'bey-lea_bed.jpg','image/jpeg','image',NULL,6016,4016,14126115,NULL,NULL,NULL,'2025-10-08 22:25:18','2025-10-08 22:25:19','2025-10-08 22:25:19'),
(3241,2,2,1,'bey-lea_clinic.jpg','image/jpeg','image',NULL,6016,4016,10272411,NULL,NULL,NULL,'2025-10-08 22:25:30','2025-10-08 22:25:30','2025-10-08 22:25:30'),
(3242,2,2,1,'bey-lea_gym.jpg','image/jpeg','image',NULL,6016,4016,9866225,NULL,NULL,NULL,'2025-10-08 22:25:39','2025-10-08 22:25:39','2025-10-08 22:25:39'),
(3243,2,2,1,'bey-lea_kitchen.jpg','image/jpeg','image',NULL,6016,4016,12116386,NULL,NULL,NULL,'2025-10-08 22:25:46','2025-10-08 22:25:46','2025-10-08 22:25:46'),
(3244,2,2,1,'bey-lea_lobby.jpg','image/jpeg','image',NULL,6068,3413,2171386,NULL,NULL,NULL,'2025-10-08 22:25:48','2025-10-08 22:25:48','2025-10-08 22:25:48'),
(3245,2,2,1,'bey-lea_bathroom_2025-10-08-222837_modw.jpg','image/jpeg','image',NULL,1200,801,255038,NULL,NULL,NULL,'2025-10-08 22:28:38','2025-10-08 22:28:38','2025-10-08 22:28:38'),
(3246,2,2,1,'bey-lea_bed_2025-10-08-222839_xulc.jpg','image/jpeg','image',NULL,1200,801,413455,NULL,NULL,NULL,'2025-10-08 22:28:39','2025-10-08 22:28:39','2025-10-08 22:28:39'),
(3247,2,2,1,'bey-lea_clinic_2025-10-08-222840_oadk.jpg','image/jpeg','image',NULL,1200,801,286247,NULL,NULL,NULL,'2025-10-08 22:28:40','2025-10-08 22:28:40','2025-10-08 22:28:40'),
(3248,2,2,1,'bey-lea_common_2025-10-08-222840_orrb.jpg','image/jpeg','image',NULL,1200,801,451102,NULL,NULL,NULL,'2025-10-08 22:28:40','2025-10-08 22:28:40','2025-10-08 22:28:40'),
(3249,2,2,1,'bey-lea_couch_2025-10-08-222841_bwye.jpg','image/jpeg','image',NULL,1200,801,289343,NULL,NULL,NULL,'2025-10-08 22:28:41','2025-10-08 22:28:41','2025-10-08 22:28:41'),
(3250,2,2,1,'bey-lea_gym_2025-10-08-222842_arrz.jpg','image/jpeg','image',NULL,1200,801,346341,NULL,NULL,NULL,'2025-10-08 22:28:42','2025-10-08 22:28:42','2025-10-08 22:28:42'),
(3251,2,2,1,'bey-lea_kitchen_2025-10-08-222843_urug.jpg','image/jpeg','image',NULL,1200,801,399046,NULL,NULL,NULL,'2025-10-08 22:28:43','2025-10-08 22:28:43','2025-10-08 22:28:43'),
(3252,2,2,1,'bey-lea_lobby_2025-10-08-222843_pqvz.jpg','image/jpeg','image',NULL,1200,675,311470,NULL,NULL,NULL,'2025-10-08 22:28:43','2025-10-08 22:28:43','2025-10-08 22:28:43'),
(3253,2,2,1,'bey-lea_room_2025-10-08-222844_dvij.jpg','image/jpeg','image',NULL,1200,801,339247,NULL,NULL,NULL,'2025-10-08 22:28:44','2025-10-08 22:28:44','2025-10-08 22:28:44'),
(3254,2,2,1,'bey-lea_room2_2025-10-08-222845_hoiy.jpg','image/jpeg','image',NULL,1200,801,322293,NULL,NULL,NULL,'2025-10-08 22:28:45','2025-10-08 22:28:45','2025-10-08 22:28:45'),
(3276,2,2,1,'BrakeleyPark_Lobby.jpg','image/jpeg','image',NULL,1200,800,352223,NULL,NULL,NULL,'2025-10-08 22:32:31','2025-10-08 22:32:31','2025-10-08 22:32:31'),
(3278,2,2,1,'BrakeleyPark_Lobby2.jpg','image/jpeg','image',NULL,1200,800,399884,NULL,NULL,NULL,'2025-10-08 22:32:34','2025-10-08 22:32:34','2025-10-08 22:32:34'),
(3279,2,2,1,'BrakeleyPark_Lobby3.jpg','image/jpeg','image',NULL,1200,800,347819,NULL,NULL,NULL,'2025-10-08 22:32:35','2025-10-08 22:32:35','2025-10-08 22:32:35'),
(3280,2,2,1,'BrakeleyPark_RehabGym.jpg','image/jpeg','image',NULL,1200,800,321435,NULL,NULL,NULL,'2025-10-08 22:32:37','2025-10-08 22:32:37','2025-10-08 22:32:37'),
(3281,2,2,1,'BrakeleyPark_RehabGym2.jpg','image/jpeg','image',NULL,1200,800,360099,NULL,NULL,NULL,'2025-10-08 22:32:38','2025-10-08 22:32:38','2025-10-08 22:32:38'),
(3282,2,2,1,'BrakeleyPark_Room.jpg','image/jpeg','image',NULL,1200,800,355174,NULL,NULL,NULL,'2025-10-08 22:32:40','2025-10-08 22:32:40','2025-10-08 22:32:40'),
(3283,2,2,1,'BrakeleyPark_Room2.jpg','image/jpeg','image',NULL,1200,800,332176,NULL,NULL,NULL,'2025-10-08 22:32:41','2025-10-08 22:32:41','2025-10-08 22:32:41'),
(3362,2,2,1,'367A4645.jpg','image/jpeg','image',NULL,1200,800,371249,NULL,NULL,NULL,'2025-10-08 22:40:49','2025-10-08 22:40:49','2025-10-08 22:40:49'),
(3363,2,2,1,'367A4650.jpg','image/jpeg','image',NULL,1200,801,304292,NULL,NULL,NULL,'2025-10-08 22:40:50','2025-10-08 22:40:50','2025-10-08 22:40:50'),
(3364,2,2,1,'367A4664.jpg','image/jpeg','image',NULL,1200,800,263017,NULL,NULL,NULL,'2025-10-08 22:40:50','2025-10-08 22:40:50','2025-10-08 22:40:50'),
(3365,2,2,1,'367A4717.jpg','image/jpeg','image',NULL,1200,801,307841,NULL,NULL,NULL,'2025-10-08 22:40:51','2025-10-08 22:40:51','2025-10-08 22:40:51'),
(3366,2,2,1,'367A4731.jpg','image/jpeg','image',NULL,1200,801,295434,NULL,NULL,NULL,'2025-10-08 22:40:52','2025-10-08 22:40:52','2025-10-08 22:40:52'),
(3367,2,2,1,'367A4751.jpg','image/jpeg','image',NULL,1200,801,239398,NULL,NULL,NULL,'2025-10-08 22:40:53','2025-10-08 22:40:53','2025-10-08 22:40:53'),
(3368,2,2,1,'367A4760.jpg','image/jpeg','image',NULL,1200,800,269367,NULL,NULL,NULL,'2025-10-08 22:40:54','2025-10-08 22:40:54','2025-10-08 22:40:54'),
(3369,2,2,1,'367A4773.jpg','image/jpeg','image',NULL,1200,802,277448,NULL,NULL,NULL,'2025-10-08 22:40:55','2025-10-08 22:40:55','2025-10-08 22:40:55'),
(3370,2,2,1,'367A4781.jpg','image/jpeg','image',NULL,1200,800,424423,NULL,NULL,NULL,'2025-10-08 22:40:56','2025-10-08 22:40:56','2025-10-08 22:40:56'),
(3371,2,2,1,'367A4808.jpg','image/jpeg','image',NULL,1200,800,447405,NULL,NULL,NULL,'2025-10-08 22:40:58','2025-10-08 22:40:58','2025-10-08 22:40:58'),
(3372,2,2,1,'367A4820.jpg','image/jpeg','image',NULL,1200,800,490160,NULL,NULL,NULL,'2025-10-08 22:40:59','2025-10-08 22:40:59','2025-10-08 22:40:59'),
(3373,2,2,1,'DJI_0862_ChristianHome_Waupun.jpg','image/jpeg','image',NULL,1200,899,586189,NULL,NULL,NULL,'2025-10-08 22:41:00','2025-10-08 22:41:00','2025-10-08 22:41:00'),
(3374,2,2,1,'IMG_4736_ChristianHome_Waupun.jpg','image/jpeg','image',NULL,1200,800,434955,NULL,NULL,NULL,'2025-10-08 22:41:02','2025-10-08 22:41:02','2025-10-08 22:41:02');
/*!40000 ALTER TABLE `assets` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `assets_sites`
--

LOCK TABLES `assets_sites` WRITE;
/*!40000 ALTER TABLE `assets_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `assets_sites` VALUES
(86,1,NULL),
(136,1,NULL),
(137,1,NULL),
(138,1,NULL),
(285,1,NULL),
(545,1,NULL),
(548,1,NULL),
(612,1,NULL),
(613,1,NULL),
(614,1,NULL),
(632,1,NULL),
(634,1,NULL),
(2516,1,NULL),
(2594,1,NULL),
(2740,1,NULL),
(2800,1,NULL),
(2803,1,NULL),
(2806,1,NULL),
(2809,1,NULL),
(2855,1,NULL),
(2856,1,NULL),
(2857,1,NULL),
(2858,1,NULL),
(2869,1,NULL),
(2870,1,NULL),
(2871,1,NULL),
(2872,1,NULL),
(2873,1,NULL),
(2874,1,NULL),
(2877,1,NULL),
(2886,1,NULL),
(2887,1,NULL),
(2888,1,NULL),
(2889,1,NULL),
(2890,1,NULL),
(2927,1,NULL),
(2931,1,NULL),
(2933,1,NULL),
(2934,1,NULL),
(2941,1,NULL),
(2968,1,NULL),
(2970,1,NULL),
(3011,1,NULL),
(3017,1,NULL),
(3018,1,NULL),
(3019,1,NULL),
(3020,1,NULL),
(3021,1,NULL),
(3022,1,NULL),
(3023,1,NULL),
(3048,1,NULL),
(3058,1,NULL),
(3084,1,NULL),
(3090,1,NULL),
(3122,1,NULL),
(3137,1,NULL),
(3158,1,NULL),
(3180,1,NULL),
(3221,1,NULL),
(3235,1,NULL),
(3236,1,NULL),
(3237,1,NULL),
(3238,1,NULL),
(3239,1,NULL),
(3240,1,NULL),
(3241,1,NULL),
(3242,1,NULL),
(3243,1,NULL),
(3244,1,NULL),
(3245,1,NULL),
(3246,1,NULL),
(3247,1,NULL),
(3248,1,NULL),
(3249,1,NULL),
(3250,1,NULL),
(3251,1,NULL),
(3252,1,NULL),
(3253,1,NULL),
(3254,1,NULL),
(3276,1,NULL),
(3278,1,NULL),
(3279,1,NULL),
(3280,1,NULL),
(3281,1,NULL),
(3282,1,NULL),
(3283,1,NULL),
(3362,1,NULL),
(3363,1,NULL),
(3364,1,NULL),
(3365,1,NULL),
(3366,1,NULL),
(3367,1,NULL),
(3368,1,NULL),
(3369,1,NULL),
(3370,1,NULL),
(3371,1,NULL),
(3372,1,NULL),
(3373,1,NULL),
(3374,1,NULL);
/*!40000 ALTER TABLE `assets_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `auth_oauth_tokens`
--

LOCK TABLES `auth_oauth_tokens` WRITE;
/*!40000 ALTER TABLE `auth_oauth_tokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `auth_oauth_tokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `authenticator`
--

LOCK TABLES `authenticator` WRITE;
/*!40000 ALTER TABLE `authenticator` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `authenticator` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `bulkopevents`
--

LOCK TABLES `bulkopevents` WRITE;
/*!40000 ALTER TABLE `bulkopevents` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `bulkopevents` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups`
--

LOCK TABLES `categorygroups` WRITE;
/*!40000 ALTER TABLE `categorygroups` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categorygroups` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `categorygroups_sites`
--

LOCK TABLES `categorygroups_sites` WRITE;
/*!40000 ALTER TABLE `categorygroups_sites` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `categorygroups_sites` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedattributes`
--

LOCK TABLES `changedattributes` WRITE;
/*!40000 ALTER TABLE `changedattributes` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `changedattributes` VALUES
(2,1,'postDate','2025-04-18 17:16:03',0,1),
(2,1,'slug','2025-04-18 17:58:01',0,1),
(2,1,'title','2025-04-18 17:33:58',0,1),
(2,1,'uri','2025-08-20 17:56:29',0,1),
(18,1,'postDate','2025-04-18 18:06:50',0,1),
(18,1,'slug','2025-04-18 18:06:50',0,1),
(18,1,'title','2025-04-18 18:06:50',0,1),
(18,1,'uri','2025-04-18 18:06:50',0,1),
(20,1,'postDate','2025-04-18 18:06:58',0,1),
(20,1,'slug','2025-04-18 18:06:58',0,1),
(20,1,'status','2025-04-18 18:06:58',0,1),
(20,1,'title','2025-04-18 18:06:58',0,1),
(20,1,'uri','2025-04-18 18:06:58',0,1),
(22,1,'postDate','2025-04-18 18:07:06',0,1),
(22,1,'slug','2025-04-18 18:07:06',0,1),
(22,1,'status','2025-04-18 18:07:06',0,1),
(22,1,'title','2025-04-18 18:07:06',0,1),
(22,1,'uri','2025-04-18 18:07:06',0,1),
(24,1,'postDate','2025-04-18 18:07:32',0,1),
(24,1,'slug','2025-04-18 18:07:32',0,1),
(24,1,'status','2025-04-18 18:07:32',0,1),
(24,1,'title','2025-04-18 18:07:32',0,1),
(24,1,'uri','2025-04-18 18:07:32',0,1),
(26,1,'postDate','2025-04-18 18:07:37',0,1),
(26,1,'slug','2025-04-18 18:07:37',0,1),
(26,1,'status','2025-04-18 18:07:37',0,1),
(26,1,'title','2025-04-18 18:07:37',0,1),
(26,1,'uri','2025-04-18 18:07:37',0,1),
(28,1,'postDate','2025-04-18 18:07:43',0,1),
(28,1,'slug','2025-04-18 18:07:43',0,1),
(28,1,'status','2025-04-18 18:07:43',0,1),
(28,1,'title','2025-04-18 18:07:43',0,1),
(28,1,'uri','2025-04-18 18:07:43',0,1),
(30,1,'postDate','2025-04-18 18:07:48',0,1),
(30,1,'slug','2025-04-18 18:07:48',0,1),
(30,1,'status','2025-04-18 18:07:48',0,1),
(30,1,'title','2025-04-18 18:07:48',0,1),
(30,1,'uri','2025-04-18 18:07:48',0,1),
(32,1,'postDate','2025-04-18 18:07:53',0,1),
(32,1,'slug','2025-04-18 18:07:53',0,1),
(32,1,'status','2025-04-18 18:07:53',0,1),
(32,1,'title','2025-04-18 18:07:53',0,1),
(32,1,'uri','2025-04-18 18:07:53',0,1),
(34,1,'postDate','2025-04-18 18:08:00',0,1),
(34,1,'slug','2025-04-18 18:08:00',0,1),
(34,1,'status','2025-04-18 18:08:00',0,1),
(34,1,'title','2025-04-18 18:08:00',0,1),
(34,1,'uri','2025-04-18 18:08:00',0,1),
(36,1,'postDate','2025-04-18 18:08:04',0,1),
(36,1,'slug','2025-04-18 18:08:04',0,1),
(36,1,'status','2025-04-18 18:08:04',0,1),
(36,1,'title','2025-08-20 21:57:06',0,1),
(36,1,'uri','2025-04-18 18:08:04',0,1),
(44,1,'primaryOwnerId','2025-09-03 22:27:30',0,1),
(56,1,'primaryOwnerId','2025-09-03 21:05:58',0,1),
(56,1,'title','2025-09-03 21:05:58',0,1),
(57,1,'primaryOwnerId','2025-09-03 21:05:58',0,1),
(57,1,'title','2025-09-03 21:05:58',0,1),
(63,1,'primaryOwnerId','2025-09-03 21:08:08',0,1),
(63,1,'title','2025-09-03 21:05:58',0,1),
(111,1,'enabled','2025-09-29 18:59:42',0,1),
(111,1,'postDate','2025-04-18 18:38:40',0,1),
(111,1,'slug','2025-04-18 18:38:40',0,1),
(111,1,'title','2025-04-18 18:38:37',0,1),
(113,1,'enabled','2025-09-29 18:59:42',0,1),
(113,1,'postDate','2025-04-18 18:38:46',0,1),
(113,1,'slug','2025-04-18 18:38:46',0,1),
(113,1,'title','2025-04-18 18:38:45',0,1),
(115,1,'enabled','2025-09-29 18:59:42',0,1),
(115,1,'postDate','2025-04-18 18:38:51',0,1),
(115,1,'slug','2025-04-18 18:38:51',0,1),
(115,1,'title','2025-04-18 18:38:50',0,1),
(117,1,'enabled','2025-09-29 18:59:42',0,1),
(117,1,'postDate','2025-04-18 18:38:56',0,1),
(117,1,'slug','2025-04-18 18:38:56',0,1),
(117,1,'title','2025-04-18 18:38:55',0,1),
(119,1,'enabled','2025-09-29 18:59:42',0,1),
(119,1,'postDate','2025-04-18 18:39:00',0,1),
(119,1,'slug','2025-04-18 18:39:00',0,1),
(119,1,'title','2025-04-18 18:39:00',0,1),
(121,1,'enabled','2025-09-29 18:59:42',0,1),
(121,1,'postDate','2025-04-18 18:39:04',0,1),
(121,1,'slug','2025-04-18 18:39:04',0,1),
(121,1,'title','2025-04-18 18:39:04',0,1),
(283,1,'postDate','2025-07-30 21:07:33',0,1),
(283,1,'slug','2025-07-30 21:07:37',0,1),
(283,1,'status','2025-07-30 21:07:33',0,1),
(283,1,'title','2025-07-30 23:10:37',0,1),
(283,1,'uri','2025-07-30 21:07:37',0,1),
(288,1,'title','2025-07-30 23:10:31',0,1),
(290,1,'title','2025-07-30 23:11:03',0,1),
(292,1,'title','2025-07-30 23:10:55',0,1),
(294,1,'postDate','2025-07-30 23:11:29',0,1),
(296,1,'postDate','2025-07-30 23:11:31',0,1),
(296,1,'title','2025-07-30 23:10:45',0,1),
(323,1,'postDate','2025-08-01 17:59:31',0,1),
(323,1,'slug','2025-08-01 17:59:31',0,1),
(323,1,'title','2025-08-01 17:59:31',0,1),
(325,1,'fieldLayoutId','2025-08-01 17:59:53',0,1),
(325,1,'postDate','2025-08-01 17:59:41',0,1),
(325,1,'slug','2025-08-01 17:59:41',0,1),
(325,1,'title','2025-08-01 17:59:41',0,1),
(325,1,'typeId','2025-08-01 17:59:53',0,1),
(329,1,'postDate','2025-08-01 18:04:57',0,1),
(329,1,'slug','2025-08-01 18:04:54',0,1),
(329,1,'title','2025-08-01 18:04:54',0,1),
(331,1,'postDate','2025-08-01 18:05:01',0,1),
(331,1,'slug','2025-08-01 18:05:00',0,1),
(331,1,'status','2025-08-01 18:05:01',0,1),
(331,1,'title','2025-08-01 18:05:00',0,1),
(333,1,'postDate','2025-08-01 18:05:04',0,1),
(333,1,'slug','2025-08-01 18:05:04',0,1),
(333,1,'status','2025-08-01 18:05:04',0,1),
(333,1,'title','2025-08-01 18:05:04',0,1),
(335,1,'postDate','2025-08-01 18:05:08',0,1),
(335,1,'slug','2025-08-01 18:05:07',0,1),
(335,1,'status','2025-08-01 18:05:08',0,1),
(335,1,'title','2025-08-01 18:05:07',0,1),
(337,1,'postDate','2025-08-01 18:05:10',0,1),
(337,1,'slug','2025-08-01 18:05:10',0,1),
(337,1,'status','2025-08-01 18:05:10',0,1),
(337,1,'title','2025-08-01 18:05:10',0,1),
(339,1,'postDate','2025-08-01 18:05:15',0,1),
(339,1,'slug','2025-08-01 18:05:14',0,1),
(339,1,'status','2025-08-01 18:05:15',0,1),
(339,1,'title','2025-08-01 18:05:14',0,1),
(341,1,'postDate','2025-08-01 18:05:18',0,1),
(341,1,'slug','2025-08-01 18:05:18',0,1),
(341,1,'status','2025-08-01 18:05:18',0,1),
(341,1,'title','2025-08-01 18:05:18',0,1),
(343,1,'postDate','2025-08-01 18:05:21',0,1),
(343,1,'slug','2025-08-01 18:05:21',0,1),
(343,1,'status','2025-08-01 18:05:21',0,1),
(343,1,'title','2025-08-01 18:05:21',0,1),
(348,1,'postDate','2025-08-01 18:06:22',0,1),
(348,1,'slug','2025-08-01 18:06:15',0,1),
(348,1,'status','2025-08-01 18:06:22',0,1),
(348,1,'title','2025-08-01 18:06:15',0,1),
(350,1,'postDate','2025-08-01 18:06:40',0,1),
(350,1,'slug','2025-08-01 18:06:27',0,1),
(350,1,'status','2025-08-01 18:06:40',0,1),
(350,1,'title','2025-08-01 18:06:27',0,1),
(352,1,'postDate','2025-08-01 18:07:25',0,1),
(352,1,'slug','2025-08-01 18:07:16',0,1),
(352,1,'title','2025-08-01 18:07:16',0,1),
(354,1,'postDate','2025-08-01 18:07:35',0,1),
(354,1,'slug','2025-08-01 18:07:27',0,1),
(354,1,'status','2025-08-01 18:07:35',0,1),
(354,1,'title','2025-08-01 18:07:27',0,1),
(356,1,'postDate','2025-08-01 18:07:48',0,1),
(356,1,'slug','2025-08-01 18:07:40',0,1),
(356,1,'status','2025-08-01 18:07:48',0,1),
(356,1,'title','2025-08-01 18:07:40',0,1),
(358,1,'postDate','2025-08-01 18:07:58',0,1),
(358,1,'slug','2025-08-01 18:07:52',0,1),
(358,1,'title','2025-08-01 18:07:52',0,1),
(360,1,'postDate','2025-08-01 18:08:08',0,1),
(360,1,'slug','2025-08-01 18:08:02',0,1),
(360,1,'title','2025-08-01 18:08:02',0,1),
(362,1,'postDate','2025-08-01 18:08:17',0,1),
(362,1,'slug','2025-08-01 18:08:11',0,1),
(362,1,'title','2025-08-01 18:08:11',0,1),
(364,1,'postDate','2025-08-01 18:08:31',0,1),
(364,1,'slug','2025-08-01 18:08:22',0,1),
(364,1,'title','2025-08-01 18:08:22',0,1),
(366,1,'postDate','2025-08-01 18:09:02',0,1),
(366,1,'slug','2025-08-01 18:08:52',0,1),
(366,1,'title','2025-08-01 18:08:52',0,1),
(368,1,'postDate','2025-08-01 18:09:12',0,1),
(368,1,'slug','2025-08-01 18:09:04',0,1),
(368,1,'status','2025-08-01 18:09:12',0,1),
(368,1,'title','2025-08-01 18:09:04',0,1),
(370,1,'postDate','2025-08-01 18:09:33',0,1),
(370,1,'slug','2025-08-01 18:09:16',0,1),
(370,1,'status','2025-08-01 18:09:33',0,1),
(370,1,'title','2025-08-01 18:09:16',0,1),
(372,1,'postDate','2025-08-01 18:09:44',0,1),
(372,1,'slug','2025-08-01 18:09:38',0,1),
(372,1,'status','2025-08-01 18:09:44',0,1),
(372,1,'title','2025-08-01 18:09:38',0,1),
(374,1,'postDate','2025-08-01 18:10:00',0,1),
(374,1,'slug','2025-08-01 18:09:48',0,1),
(374,1,'status','2025-08-01 18:10:00',0,1),
(374,1,'title','2025-08-01 18:09:48',0,1),
(376,1,'postDate','2025-08-01 18:10:07',0,1),
(376,1,'slug','2025-08-01 18:10:02',0,1),
(376,1,'status','2025-08-01 18:10:07',0,1),
(376,1,'title','2025-08-01 18:10:02',0,1),
(378,1,'postDate','2025-08-01 18:10:18',0,1),
(378,1,'slug','2025-08-01 18:10:11',0,1),
(378,1,'status','2025-08-01 18:10:18',0,1),
(378,1,'title','2025-08-01 18:10:11',0,1),
(380,1,'postDate','2025-08-01 18:10:31',0,1),
(380,1,'slug','2025-08-01 18:10:22',0,1),
(380,1,'status','2025-08-01 18:10:31',0,1),
(380,1,'title','2025-08-01 18:10:22',0,1),
(382,1,'postDate','2025-08-01 18:10:53',0,1),
(382,1,'slug','2025-08-01 18:10:47',0,1),
(382,1,'title','2025-08-01 18:10:47',0,1),
(384,1,'postDate','2025-08-01 18:11:04',0,1),
(384,1,'slug','2025-08-01 18:10:58',0,1),
(384,1,'title','2025-08-01 18:10:58',0,1),
(386,1,'postDate','2025-08-01 18:11:17',0,1),
(386,1,'slug','2025-08-01 18:11:11',0,1),
(386,1,'title','2025-08-01 18:11:11',0,1),
(388,1,'postDate','2025-08-01 18:11:31',0,1),
(388,1,'slug','2025-08-01 18:11:21',0,1),
(388,1,'title','2025-08-01 18:11:21',0,1),
(390,1,'postDate','2025-08-01 18:11:48',0,1),
(390,1,'slug','2025-08-01 18:11:41',0,1),
(390,1,'title','2025-08-01 18:11:41',0,1),
(392,1,'postDate','2025-08-01 18:12:02',0,1),
(392,1,'slug','2025-08-01 18:11:52',0,1),
(392,1,'status','2025-08-01 18:12:02',0,1),
(392,1,'title','2025-08-01 18:11:52',0,1),
(394,1,'postDate','2025-08-01 18:12:14',0,1),
(394,1,'slug','2025-08-01 18:12:07',0,1),
(394,1,'status','2025-08-01 18:12:14',0,1),
(394,1,'title','2025-08-01 18:12:07',0,1),
(396,1,'postDate','2025-08-01 18:12:26',0,1),
(396,1,'slug','2025-08-01 18:12:18',0,1),
(396,1,'status','2025-08-01 18:12:26',0,1),
(396,1,'title','2025-08-01 18:12:18',0,1),
(398,1,'postDate','2025-08-01 18:12:34',0,1),
(398,1,'slug','2025-08-01 18:12:27',0,1),
(398,1,'status','2025-08-01 18:12:34',0,1),
(398,1,'title','2025-08-01 18:12:27',0,1),
(400,1,'postDate','2025-08-01 18:12:57',0,1),
(400,1,'slug','2025-08-01 18:12:49',0,1),
(400,1,'title','2025-08-01 18:12:49',0,1),
(402,1,'postDate','2025-08-01 18:13:07',0,1),
(402,1,'slug','2025-08-01 18:13:00',0,1),
(402,1,'status','2025-08-01 18:13:07',0,1),
(402,1,'title','2025-08-01 18:13:00',0,1),
(404,1,'postDate','2025-08-01 18:13:20',0,1),
(404,1,'slug','2025-08-01 18:13:10',0,1),
(404,1,'status','2025-08-01 18:13:20',0,1),
(404,1,'title','2025-08-01 18:13:10',0,1),
(406,1,'postDate','2025-08-01 18:13:33',0,1),
(406,1,'slug','2025-08-01 18:13:23',0,1),
(406,1,'status','2025-08-01 18:13:33',0,1),
(406,1,'title','2025-08-01 18:13:23',0,1),
(408,1,'postDate','2025-08-01 18:13:42',0,1),
(408,1,'slug','2025-08-01 18:13:35',0,1),
(408,1,'status','2025-08-01 18:13:42',0,1),
(408,1,'title','2025-08-01 18:13:35',0,1),
(410,1,'postDate','2025-08-01 18:13:53',0,1),
(410,1,'slug','2025-08-01 18:13:47',0,1),
(410,1,'status','2025-08-01 18:13:53',0,1),
(410,1,'title','2025-08-01 18:13:47',0,1),
(412,1,'postDate','2025-08-01 18:14:03',0,1),
(412,1,'slug','2025-08-01 18:13:56',0,1),
(412,1,'status','2025-08-01 18:14:03',0,1),
(412,1,'title','2025-08-01 18:13:56',0,1),
(414,1,'postDate','2025-08-01 18:14:13',0,1),
(414,1,'slug','2025-08-01 18:14:08',0,1),
(414,1,'status','2025-08-01 18:14:13',0,1),
(414,1,'title','2025-08-01 18:14:08',0,1),
(426,1,'primaryOwnerId','2025-10-08 22:20:13',0,1),
(427,1,'primaryOwnerId','2025-10-08 22:20:13',0,1),
(428,1,'primaryOwnerId','2025-10-08 22:20:13',0,1),
(445,1,'primaryOwnerId','2025-09-03 22:27:30',0,1),
(453,1,'postDate','2025-08-20 21:57:20',0,1),
(453,1,'slug','2025-08-20 21:57:14',0,1),
(453,1,'title','2025-08-20 21:57:14',0,1),
(455,1,'postDate','2025-08-20 21:57:32',0,1),
(455,1,'slug','2025-08-20 21:57:26',0,1),
(455,1,'title','2025-08-20 21:57:26',0,1),
(457,1,'postDate','2025-08-20 21:58:42',0,1),
(457,1,'slug','2025-08-20 21:58:36',0,1),
(457,1,'title','2025-08-20 21:58:36',0,1),
(459,1,'postDate','2025-08-20 21:58:54',0,1),
(459,1,'slug','2025-08-20 21:58:48',0,1),
(459,1,'title','2025-08-20 21:58:48',0,1),
(461,1,'postDate','2025-08-20 21:59:06',0,1),
(461,1,'slug','2025-08-20 21:59:02',0,1),
(461,1,'title','2025-08-20 21:59:02',0,1),
(463,1,'postDate','2025-08-20 21:59:15',0,1),
(463,1,'slug','2025-08-20 21:59:11',0,1),
(463,1,'title','2025-08-20 21:59:11',0,1),
(465,1,'postDate','2025-08-20 21:59:33',0,1),
(465,1,'slug','2025-08-20 21:59:31',0,1),
(465,1,'title','2025-08-20 21:59:31',0,1),
(467,1,'postDate','2025-08-20 21:59:45',0,1),
(467,1,'slug','2025-08-20 21:59:43',0,1),
(467,1,'title','2025-08-20 21:59:43',0,1),
(469,1,'postDate','2025-08-20 22:00:03',0,1),
(469,1,'slug','2025-08-20 21:59:57',0,1),
(469,1,'title','2025-08-20 21:59:57',0,1),
(471,1,'postDate','2025-08-20 22:00:11',0,1),
(471,1,'slug','2025-08-20 22:00:07',0,1),
(471,1,'status','2025-08-20 22:00:11',0,1),
(471,1,'title','2025-08-20 22:00:07',0,1),
(473,1,'postDate','2025-08-20 22:00:22',0,1),
(473,1,'slug','2025-08-20 22:00:20',0,1),
(473,1,'status','2025-08-20 22:00:22',0,1),
(473,1,'title','2025-08-20 22:00:20',0,1),
(475,1,'postDate','2025-08-20 22:00:38',0,1),
(475,1,'slug','2025-08-20 22:00:32',0,1),
(475,1,'title','2025-08-20 22:00:32',0,1),
(477,1,'postDate','2025-08-20 22:00:46',0,1),
(477,1,'slug','2025-08-20 22:00:45',0,1),
(477,1,'title','2025-08-20 22:00:45',0,1),
(479,1,'postDate','2025-08-20 22:00:59',0,1),
(479,1,'slug','2025-08-20 22:00:55',0,1),
(479,1,'title','2025-08-20 22:00:55',0,1),
(481,1,'postDate','2025-08-20 22:01:08',0,1),
(481,1,'slug','2025-08-20 22:01:03',0,1),
(481,1,'title','2025-08-20 22:01:03',0,1),
(483,1,'postDate','2025-08-20 22:01:17',0,1),
(483,1,'slug','2025-08-20 22:01:13',0,1),
(483,1,'title','2025-08-20 22:01:13',0,1),
(485,1,'postDate','2025-08-20 22:01:30',0,1),
(485,1,'slug','2025-08-20 22:01:23',0,1),
(485,1,'title','2025-08-20 22:01:23',0,1),
(487,1,'postDate','2025-08-20 22:02:03',0,1),
(487,1,'slug','2025-08-20 22:02:00',0,1),
(487,1,'title','2025-08-20 22:02:00',0,1),
(489,1,'postDate','2025-08-20 22:02:13',0,1),
(489,1,'slug','2025-08-20 22:02:09',0,1),
(489,1,'title','2025-08-20 22:02:09',0,1),
(491,1,'postDate','2025-08-20 22:02:19',0,1),
(491,1,'slug','2025-08-20 22:02:19',0,1),
(491,1,'status','2025-08-20 22:02:19',0,1),
(491,1,'title','2025-08-20 22:02:19',0,1),
(493,1,'postDate','2025-08-20 22:02:28',0,1),
(493,1,'slug','2025-08-20 22:02:28',0,1),
(493,1,'title','2025-08-20 22:02:28',0,1),
(495,1,'postDate','2025-08-20 22:02:34',0,1),
(495,1,'slug','2025-08-20 22:02:33',0,1),
(495,1,'status','2025-08-20 22:02:34',0,1),
(495,1,'title','2025-08-20 22:02:33',0,1),
(497,1,'postDate','2025-08-20 22:02:59',0,1),
(497,1,'slug','2025-08-20 22:02:53',0,1),
(497,1,'title','2025-09-11 20:12:38',0,1),
(499,1,'postDate','2025-08-20 22:12:23',0,1),
(499,1,'slug','2025-08-20 22:12:22',0,1),
(499,1,'title','2025-08-20 22:12:22',0,1),
(501,1,'postDate','2025-08-20 22:12:28',0,1),
(501,1,'slug','2025-08-20 22:12:28',0,1),
(501,1,'status','2025-08-20 22:12:28',0,1),
(501,1,'title','2025-08-20 22:12:28',0,1),
(503,1,'postDate','2025-08-20 22:12:34',0,1),
(503,1,'slug','2025-08-20 22:12:33',0,1),
(503,1,'title','2025-08-20 22:12:33',0,1),
(506,1,'postDate','2025-08-20 22:12:50',0,1),
(506,1,'slug','2025-08-20 22:12:50',0,1),
(506,1,'title','2025-08-20 22:12:50',0,1),
(508,1,'postDate','2025-08-20 22:12:54',0,1),
(508,1,'slug','2025-08-20 22:12:54',0,1),
(508,1,'status','2025-08-20 22:12:54',0,1),
(508,1,'title','2025-08-20 22:12:54',0,1),
(510,1,'postDate','2025-08-20 22:12:57',0,1),
(510,1,'slug','2025-08-20 22:12:57',0,1),
(510,1,'status','2025-08-20 22:12:57',0,1),
(510,1,'title','2025-08-20 22:12:57',0,1),
(512,1,'postDate','2025-08-20 22:13:01',0,1),
(512,1,'slug','2025-08-20 22:13:00',0,1),
(512,1,'status','2025-08-20 22:13:01',0,1),
(512,1,'title','2025-08-20 22:13:00',0,1),
(514,1,'postDate','2025-08-20 22:13:04',0,1),
(514,1,'slug','2025-08-20 22:13:04',0,1),
(514,1,'status','2025-08-20 22:13:04',0,1),
(514,1,'title','2025-08-20 22:13:04',0,1),
(516,1,'postDate','2025-08-20 22:13:07',0,1),
(516,1,'slug','2025-08-20 22:13:07',0,1),
(516,1,'status','2025-08-20 22:13:07',0,1),
(516,1,'title','2025-08-20 22:13:07',0,1),
(518,1,'postDate','2025-08-20 22:13:10',0,1),
(518,1,'slug','2025-08-20 22:13:10',0,1),
(518,1,'status','2025-08-20 22:13:10',0,1),
(518,1,'title','2025-08-20 22:13:10',0,1),
(520,1,'postDate','2025-08-20 22:13:13',0,1),
(520,1,'slug','2025-08-20 22:13:12',0,1),
(520,1,'status','2025-08-20 22:13:13',0,1),
(520,1,'title','2025-08-20 22:13:12',0,1),
(522,1,'postDate','2025-08-20 22:13:15',0,1),
(522,1,'slug','2025-08-20 22:13:15',0,1),
(522,1,'status','2025-08-20 22:13:15',0,1),
(522,1,'title','2025-08-20 22:13:15',0,1),
(524,1,'postDate','2025-08-20 22:13:18',0,1),
(524,1,'slug','2025-08-20 22:13:18',0,1),
(524,1,'status','2025-08-20 22:13:18',0,1),
(524,1,'title','2025-08-20 22:13:18',0,1),
(530,1,'postDate','2025-08-20 22:17:46',0,1),
(530,1,'slug','2025-08-20 22:17:46',0,1),
(530,1,'title','2025-08-20 22:17:46',0,1),
(532,1,'postDate','2025-08-20 22:18:02',0,1),
(532,1,'slug','2025-08-20 22:18:02',0,1),
(532,1,'title','2025-08-20 22:18:02',0,1),
(534,1,'postDate','2025-08-20 22:18:21',0,1),
(534,1,'slug','2025-08-20 22:18:21',0,1),
(534,1,'title','2025-08-20 22:18:29',0,1),
(555,1,'enabled','2025-09-29 18:59:42',0,1),
(555,1,'postDate','2025-09-02 22:24:46',0,1),
(555,1,'slug','2025-09-02 22:24:46',0,1),
(555,1,'title','2025-09-02 22:24:41',0,1),
(557,1,'enabled','2025-09-29 18:59:42',0,1),
(557,1,'postDate','2025-09-02 22:24:52',0,1),
(557,1,'slug','2025-09-02 22:24:52',0,1),
(557,1,'status','2025-09-02 22:24:52',0,1),
(557,1,'title','2025-09-02 22:24:51',0,1),
(559,1,'enabled','2025-09-29 18:59:42',0,1),
(559,1,'postDate','2025-09-02 22:24:59',0,1),
(559,1,'slug','2025-09-02 22:24:59',0,1),
(559,1,'status','2025-09-02 22:24:59',0,1),
(559,1,'title','2025-09-02 22:24:59',0,1),
(561,1,'enabled','2025-09-29 18:59:42',0,1),
(561,1,'postDate','2025-09-02 22:25:02',0,1),
(561,1,'slug','2025-09-02 22:25:02',0,1),
(561,1,'status','2025-09-02 22:25:02',0,1),
(561,1,'title','2025-09-02 22:25:02',0,1),
(563,1,'enabled','2025-09-29 18:59:42',0,1),
(563,1,'postDate','2025-09-02 22:25:06',0,1),
(563,1,'slug','2025-09-02 22:25:06',0,1),
(563,1,'status','2025-09-02 22:25:06',0,1),
(563,1,'title','2025-09-02 22:25:06',0,1),
(601,1,'postDate','2025-09-03 21:48:33',0,1),
(601,1,'slug','2025-09-03 21:48:33',0,1),
(601,1,'title','2025-09-03 21:49:20',0,1),
(603,1,'postDate','2025-09-03 21:48:45',0,1),
(603,1,'slug','2025-09-03 21:48:45',0,1),
(603,1,'status','2025-09-03 21:48:45',0,1),
(603,1,'title','2025-09-03 21:48:44',0,1),
(605,1,'postDate','2025-09-03 21:48:52',0,1),
(605,1,'slug','2025-09-03 21:48:52',0,1),
(605,1,'title','2025-09-03 21:58:30',0,1),
(617,1,'postDate','2025-09-03 21:56:47',0,1),
(617,1,'slug','2025-09-03 21:56:47',0,1),
(617,1,'status','2025-09-03 21:56:47',0,1),
(617,1,'title','2025-09-03 21:57:10',0,1),
(951,1,'title','2025-09-22 17:36:50',0,1),
(1149,1,'slug','2025-09-11 19:17:31',0,1),
(1353,1,'slug','2025-09-22 18:10:11',0,1),
(1353,1,'title','2025-09-22 18:03:40',0,1),
(1359,1,'slug','2025-09-22 18:10:03',0,1),
(1359,1,'title','2025-09-22 18:03:21',0,1),
(1365,1,'slug','2025-09-22 18:10:48',0,1),
(1371,1,'slug','2025-09-22 18:11:25',0,1),
(1377,1,'slug','2025-09-22 18:11:36',0,1),
(1383,1,'slug','2025-09-22 18:11:49',0,1),
(1389,1,'slug','2025-09-22 18:12:03',0,1),
(1395,1,'slug','2025-09-22 18:10:30',0,1),
(1395,1,'title','2025-09-22 18:08:00',0,1),
(1401,1,'slug','2025-09-22 18:12:28',0,1),
(1401,1,'title','2025-09-22 18:08:33',0,1),
(1407,1,'slug','2025-09-22 18:13:02',0,1),
(1413,1,'slug','2025-09-22 18:09:54',0,1),
(1413,1,'title','2025-09-22 18:09:23',0,1),
(1486,1,'primaryOwnerId','2025-09-17 19:37:16',0,1),
(1486,1,'slug','2025-09-17 19:37:16',0,1),
(1487,1,'primaryOwnerId','2025-09-17 19:37:16',0,1),
(1487,1,'slug','2025-09-17 19:37:16',0,1),
(1499,1,'primaryOwnerId','2025-10-08 22:21:46',0,1),
(1499,1,'slug','2025-10-08 22:21:46',0,1),
(1504,1,'primaryOwnerId','2025-10-08 18:43:12',0,1),
(1504,1,'slug','2025-10-08 18:43:12',0,1),
(1505,1,'primaryOwnerId','2025-10-08 18:43:12',0,1),
(1505,1,'slug','2025-10-08 18:43:12',0,1),
(1509,1,'primaryOwnerId','2025-10-08 18:52:55',0,1),
(1509,1,'slug','2025-10-08 18:52:55',0,1),
(1510,1,'primaryOwnerId','2025-10-08 18:52:55',0,1),
(1510,1,'slug','2025-10-08 18:52:55',0,1),
(1514,1,'primaryOwnerId','2025-10-08 19:00:47',0,1),
(1514,1,'slug','2025-10-08 19:00:47',0,1),
(1515,1,'primaryOwnerId','2025-10-08 19:00:47',0,1),
(1515,1,'slug','2025-10-08 19:00:47',0,1),
(1519,1,'primaryOwnerId','2025-10-08 19:59:16',0,1),
(1519,1,'slug','2025-10-08 19:59:16',0,1),
(1520,1,'primaryOwnerId','2025-10-08 19:59:16',0,1),
(1520,1,'slug','2025-10-08 19:59:16',0,1),
(1525,1,'primaryOwnerId','2025-10-08 20:25:58',0,1),
(1525,1,'slug','2025-10-08 20:25:58',0,1),
(1526,1,'primaryOwnerId','2025-10-08 20:25:58',0,1),
(1526,1,'slug','2025-10-08 20:25:58',0,1),
(1835,1,'primaryOwnerId','2025-10-08 22:38:45',0,1),
(1835,1,'slug','2025-10-08 22:38:45',0,1),
(1835,1,'title','2025-10-08 22:38:45',0,1),
(2519,1,'postDate','2025-09-19 18:52:27',0,1),
(2519,1,'slug','2025-09-19 17:27:09',0,1),
(2519,1,'title','2025-09-19 17:25:35',0,1),
(2519,1,'uri','2025-09-19 17:27:09',0,1),
(2523,1,'postDate','2025-09-19 18:52:18',0,1),
(2523,1,'slug','2025-09-19 17:28:49',0,1),
(2523,1,'title','2025-09-19 17:28:49',0,1),
(2523,1,'uri','2025-09-19 17:28:49',0,1),
(2527,1,'postDate','2025-09-19 18:52:10',0,1),
(2527,1,'slug','2025-09-19 17:30:14',0,1),
(2527,1,'title','2025-09-19 17:30:14',0,1),
(2527,1,'uri','2025-09-19 17:30:14',0,1),
(2531,1,'enabled','2025-09-30 19:28:07',0,1),
(2531,1,'postDate','2025-09-19 18:51:56',0,1),
(2531,1,'slug','2025-09-19 17:32:33',0,1),
(2531,1,'title','2025-09-19 17:32:33',0,1),
(2531,1,'uri','2025-09-19 17:32:33',0,1),
(2535,1,'postDate','2025-09-19 18:51:46',0,1),
(2535,1,'slug','2025-09-19 17:34:59',0,1),
(2535,1,'title','2025-09-19 17:34:59',0,1),
(2535,1,'uri','2025-09-19 17:34:59',0,1),
(2537,1,'postDate','2025-09-19 18:53:35',0,1),
(2537,1,'slug','2025-09-19 17:37:13',0,1),
(2537,1,'title','2025-09-19 17:37:13',0,1),
(2537,1,'uri','2025-09-19 17:37:13',0,1),
(2553,1,'postDate','2025-09-19 18:50:13',0,1),
(2553,1,'slug','2025-09-19 18:50:13',0,1),
(2553,1,'title','2025-09-19 18:50:13',0,1),
(2555,1,'postDate','2025-09-19 18:50:15',0,1),
(2555,1,'slug','2025-09-19 18:50:15',0,1),
(2555,1,'status','2025-09-19 18:50:15',0,1),
(2555,1,'title','2025-09-19 18:50:15',0,1),
(2557,1,'postDate','2025-09-19 18:50:18',0,1),
(2557,1,'slug','2025-09-19 18:50:18',0,1),
(2557,1,'status','2025-09-19 18:50:18',0,1),
(2557,1,'title','2025-09-19 18:50:18',0,1),
(2559,1,'postDate','2025-09-19 18:50:27',0,1),
(2559,1,'slug','2025-09-19 18:50:27',0,1),
(2559,1,'status','2025-09-19 18:50:27',0,1),
(2559,1,'title','2025-09-19 18:50:27',0,1),
(2561,1,'postDate','2025-09-19 18:50:45',0,1),
(2561,1,'slug','2025-09-19 18:50:45',0,1),
(2561,1,'title','2025-09-19 18:50:45',0,1),
(2563,1,'postDate','2025-09-19 18:50:48',0,1),
(2563,1,'slug','2025-09-19 18:50:48',0,1),
(2563,1,'status','2025-09-19 18:50:48',0,1),
(2563,1,'title','2025-09-19 18:50:48',0,1),
(2565,1,'postDate','2025-09-19 18:50:50',0,1),
(2565,1,'slug','2025-09-19 18:50:50',0,1),
(2565,1,'status','2025-09-19 18:50:50',0,1),
(2565,1,'title','2025-09-19 18:50:50',0,1),
(2567,1,'postDate','2025-09-19 18:50:52',0,1),
(2567,1,'slug','2025-09-19 18:50:52',0,1),
(2567,1,'status','2025-09-19 18:50:52',0,1),
(2567,1,'title','2025-09-19 18:50:52',0,1),
(2569,1,'postDate','2025-09-19 18:50:55',0,1),
(2569,1,'slug','2025-09-19 18:50:55',0,1),
(2569,1,'status','2025-09-19 18:50:55',0,1),
(2569,1,'title','2025-09-19 18:50:55',0,1),
(2571,1,'postDate','2025-09-19 18:50:59',0,1),
(2571,1,'slug','2025-09-19 18:50:59',0,1),
(2571,1,'status','2025-09-19 18:50:59',0,1),
(2571,1,'title','2025-09-19 18:50:59',0,1),
(2573,1,'postDate','2025-09-19 18:51:03',0,1),
(2573,1,'slug','2025-09-19 18:51:03',0,1),
(2573,1,'status','2025-09-19 18:51:03',0,1),
(2573,1,'title','2025-09-19 18:51:03',0,1),
(2576,1,'postDate','2025-09-19 18:51:09',0,1),
(2576,1,'slug','2025-09-19 18:51:09',0,1),
(2576,1,'status','2025-09-19 18:51:09',0,1),
(2576,1,'title','2025-09-19 18:51:09',0,1),
(2590,1,'postDate','2025-09-19 18:53:29',0,1),
(2590,1,'slug','2025-09-19 18:52:40',0,1),
(2590,1,'title','2025-09-19 18:52:40',0,1),
(2590,1,'uri','2025-09-19 18:52:40',0,1),
(2596,1,'postDate','2025-09-19 19:06:52',0,1),
(2596,1,'slug','2025-09-19 19:06:50',0,1),
(2596,1,'title','2025-09-19 19:06:50',0,1),
(2598,1,'postDate','2025-09-19 19:06:57',0,1),
(2598,1,'slug','2025-09-19 19:06:57',0,1),
(2598,1,'status','2025-09-19 19:06:57',0,1),
(2598,1,'title','2025-09-19 19:06:57',0,1),
(2600,1,'postDate','2025-09-19 19:07:03',0,1),
(2600,1,'slug','2025-09-19 19:07:03',0,1),
(2600,1,'status','2025-09-19 19:07:03',0,1),
(2600,1,'title','2025-09-19 19:07:03',0,1),
(2602,1,'postDate','2025-09-19 19:07:09',0,1),
(2602,1,'slug','2025-09-19 19:07:09',0,1),
(2602,1,'status','2025-09-19 19:07:09',0,1),
(2602,1,'title','2025-09-19 19:07:09',0,1),
(2604,1,'postDate','2025-09-19 19:07:13',0,1),
(2604,1,'slug','2025-09-19 19:07:13',0,1),
(2604,1,'status','2025-09-19 19:07:13',0,1),
(2604,1,'title','2025-09-19 19:07:13',0,1),
(2606,1,'postDate','2025-09-19 19:07:17',0,1),
(2606,1,'slug','2025-09-19 19:07:17',0,1),
(2606,1,'status','2025-09-19 19:07:17',0,1),
(2606,1,'title','2025-09-19 19:07:17',0,1),
(2608,1,'postDate','2025-09-19 19:07:23',0,1),
(2608,1,'slug','2025-09-19 19:07:23',0,1),
(2608,1,'status','2025-09-19 19:07:23',0,1),
(2608,1,'title','2025-09-19 19:07:23',0,1),
(2610,1,'postDate','2025-09-19 19:07:27',0,1),
(2610,1,'slug','2025-09-19 19:07:27',0,1),
(2610,1,'status','2025-09-19 19:07:27',0,1),
(2610,1,'title','2025-09-19 19:07:27',0,1),
(2612,1,'postDate','2025-09-19 19:07:36',0,1),
(2612,1,'slug','2025-09-19 19:07:36',0,1),
(2612,1,'status','2025-09-19 19:07:36',0,1),
(2612,1,'title','2025-09-19 19:07:36',0,1),
(2614,1,'postDate','2025-09-19 19:07:44',0,1),
(2614,1,'slug','2025-09-19 19:07:44',0,1),
(2614,1,'status','2025-09-19 19:07:44',0,1),
(2614,1,'title','2025-09-19 19:07:44',0,1),
(2616,1,'postDate','2025-09-19 19:07:47',0,1),
(2616,1,'slug','2025-09-19 19:07:47',0,1),
(2616,1,'status','2025-09-19 19:07:47',0,1),
(2616,1,'title','2025-09-19 19:07:47',0,1),
(2618,1,'postDate','2025-09-19 19:07:49',0,1),
(2618,1,'slug','2025-09-19 19:07:49',0,1),
(2618,1,'status','2025-09-19 19:07:49',0,1),
(2618,1,'title','2025-09-19 19:07:49',0,1),
(2620,1,'postDate','2025-09-19 19:07:53',0,1),
(2620,1,'slug','2025-09-19 19:07:53',0,1),
(2620,1,'status','2025-09-19 19:07:53',0,1),
(2620,1,'title','2025-09-19 19:07:53',0,1),
(2622,1,'postDate','2025-09-19 19:07:55',0,1),
(2622,1,'slug','2025-09-19 19:07:55',0,1),
(2622,1,'status','2025-09-19 19:07:55',0,1),
(2622,1,'title','2025-09-19 19:07:55',0,1),
(2624,1,'postDate','2025-09-19 19:07:59',0,1),
(2624,1,'slug','2025-09-19 19:07:58',0,1),
(2624,1,'status','2025-09-19 19:07:59',0,1),
(2624,1,'title','2025-09-19 19:07:58',0,1),
(2712,1,'postDate','2025-09-22 18:33:07',0,1),
(2712,1,'slug','2025-09-22 18:33:59',0,1),
(2712,1,'title','2025-09-22 18:32:29',0,1),
(2712,1,'uri','2025-09-22 18:33:07',0,1),
(2720,1,'postDate','2025-09-22 18:35:27',0,1),
(2720,1,'slug','2025-09-22 18:35:58',0,1),
(2720,1,'title','2025-09-22 18:34:24',0,1),
(2720,1,'uri','2025-09-22 18:34:57',0,1),
(2785,1,'postDate','2025-09-23 20:43:48',0,1),
(2785,1,'slug','2025-09-23 20:43:48',0,1),
(2785,1,'status','2025-09-23 20:43:48',0,1),
(2785,1,'title','2025-09-23 20:43:48',0,1),
(2786,1,'postDate','2025-09-23 20:43:53',0,1),
(2786,1,'slug','2025-09-23 20:43:53',0,1),
(2786,1,'status','2025-09-23 20:43:53',0,1),
(2786,1,'title','2025-09-23 20:43:53',0,1),
(2787,1,'postDate','2025-09-23 20:44:13',0,1),
(2787,1,'slug','2025-09-23 20:44:12',0,1),
(2787,1,'status','2025-09-23 20:44:13',0,1),
(2787,1,'title','2025-09-23 20:44:12',0,1),
(2791,1,'primaryOwnerId','2025-09-30 22:41:39',0,1),
(2793,1,'primaryOwnerId','2025-09-30 22:46:11',0,1),
(2812,1,'postDate','2025-09-23 21:56:42',0,1),
(2812,1,'slug','2025-09-23 21:56:42',0,1),
(2812,1,'status','2025-09-23 21:56:42',0,1),
(2812,1,'title','2025-09-23 21:56:41',0,1),
(2813,1,'postDate','2025-09-23 21:56:57',0,1),
(2813,1,'slug','2025-09-23 21:56:57',0,1),
(2813,1,'status','2025-09-23 21:56:57',0,1),
(2813,1,'title','2025-09-23 21:56:57',0,1),
(2814,1,'postDate','2025-09-23 21:57:09',0,1),
(2814,1,'slug','2025-09-23 21:57:09',0,1),
(2814,1,'status','2025-09-23 21:57:09',0,1),
(2814,1,'title','2025-09-23 21:57:06',0,1),
(2815,1,'postDate','2025-09-23 21:57:19',0,1),
(2815,1,'slug','2025-09-23 21:57:19',0,1),
(2815,1,'status','2025-09-23 21:57:19',0,1),
(2815,1,'title','2025-09-23 21:57:19',0,1),
(2816,1,'postDate','2025-09-23 21:57:28',0,1),
(2816,1,'slug','2025-09-23 21:57:28',0,1),
(2816,1,'status','2025-09-23 21:57:28',0,1),
(2816,1,'title','2025-09-23 21:57:28',0,1),
(2817,1,'postDate','2025-09-23 21:57:37',0,1),
(2817,1,'slug','2025-09-23 21:57:37',0,1),
(2817,1,'status','2025-09-23 21:57:37',0,1),
(2817,1,'title','2025-09-23 21:57:37',0,1),
(2880,1,'postDate','2025-09-24 23:07:59',0,1),
(2880,1,'slug','2025-09-24 23:07:59',0,1),
(2880,1,'title','2025-09-24 23:06:38',0,1),
(2880,1,'uri','2025-09-24 23:07:59',0,1),
(2882,1,'postDate','2025-09-24 23:09:19',0,1),
(2882,1,'slug','2025-09-24 23:09:19',0,1),
(2882,1,'title','2025-09-24 23:08:27',0,1),
(2882,1,'uri','2025-09-24 23:09:19',0,1),
(2891,1,'postDate','2025-09-26 17:59:52',0,1),
(2891,1,'slug','2025-09-26 17:59:51',0,1),
(2891,1,'title','2025-09-26 17:59:51',0,1),
(2945,1,'primaryOwnerId','2025-09-30 22:45:57',0,1),
(2969,1,'postDate','2025-10-06 17:46:02',0,1),
(2969,1,'slug','2025-10-06 17:47:25',0,1),
(2969,1,'title','2025-10-06 17:47:25',0,1),
(2972,1,'postDate','2025-10-06 17:46:44',0,1),
(2972,1,'slug','2025-10-08 18:21:43',0,1),
(2972,1,'title','2025-10-08 18:21:43',0,1),
(2974,1,'postDate','2025-10-06 17:47:00',0,1),
(2974,1,'slug','2025-10-06 17:47:42',0,1),
(2974,1,'title','2025-10-06 17:47:42',0,1),
(3016,1,'slug','2025-10-08 18:22:24',0,1),
(3016,1,'title','2025-10-08 18:22:24',0,1),
(3025,1,'postDate','2025-10-08 18:35:41',0,1),
(3025,1,'slug','2025-10-08 18:35:37',0,1),
(3025,1,'title','2025-10-08 18:35:20',0,1),
(3027,1,'postDate','2025-10-08 18:36:16',0,1),
(3027,1,'slug','2025-10-08 18:36:15',0,1),
(3027,1,'title','2025-10-08 18:36:11',0,1),
(3091,1,'postDate','2025-10-08 18:55:24',0,1),
(3091,1,'slug','2025-10-08 18:55:24',0,1),
(3091,1,'title','2025-10-08 18:55:22',0,1),
(3093,1,'postDate','2025-10-08 18:55:51',0,1),
(3093,1,'slug','2025-10-08 18:55:51',0,1),
(3093,1,'title','2025-10-08 18:55:50',0,1),
(3123,1,'postDate','2025-10-08 19:54:15',0,1),
(3123,1,'slug','2025-10-08 19:54:15',0,1),
(3123,1,'title','2025-10-08 19:54:15',0,1),
(3192,1,'postDate','2025-10-08 22:18:56',0,1),
(3192,1,'slug','2025-10-08 22:18:54',0,1),
(3192,1,'title','2025-10-08 22:18:54',0,1),
(3194,1,'postDate','2025-10-08 22:18:59',0,1),
(3194,1,'slug','2025-10-08 22:18:59',0,1),
(3194,1,'status','2025-10-08 22:18:59',0,1),
(3194,1,'title','2025-10-08 22:18:59',0,1),
(3196,1,'postDate','2025-10-08 22:19:01',0,1),
(3196,1,'slug','2025-10-08 22:19:01',0,1),
(3196,1,'status','2025-10-08 22:19:01',0,1),
(3196,1,'title','2025-10-08 22:19:01',0,1),
(3198,1,'postDate','2025-10-08 22:19:04',0,1),
(3198,1,'slug','2025-10-08 22:19:04',0,1),
(3198,1,'status','2025-10-08 22:19:04',0,1),
(3198,1,'title','2025-10-08 22:19:04',0,1),
(3200,1,'postDate','2025-10-08 22:19:06',0,1),
(3200,1,'slug','2025-10-08 22:19:06',0,1),
(3200,1,'status','2025-10-08 22:19:06',0,1),
(3200,1,'title','2025-10-08 22:19:06',0,1),
(3202,1,'postDate','2025-10-08 22:19:10',0,1),
(3202,1,'slug','2025-10-08 22:19:10',0,1),
(3202,1,'status','2025-10-08 22:19:10',0,1),
(3202,1,'title','2025-10-08 22:19:10',0,1),
(3204,1,'postDate','2025-10-08 22:19:13',0,1),
(3204,1,'slug','2025-10-08 22:19:13',0,1),
(3204,1,'status','2025-10-08 22:19:13',0,1),
(3204,1,'title','2025-10-08 22:19:13',0,1),
(3206,1,'postDate','2025-10-08 22:19:15',0,1),
(3206,1,'slug','2025-10-08 22:19:15',0,1),
(3206,1,'status','2025-10-08 22:19:15',0,1),
(3206,1,'title','2025-10-08 22:19:15',0,1),
(3208,1,'postDate','2025-10-08 22:19:18',0,1),
(3208,1,'slug','2025-10-08 22:19:18',0,1),
(3208,1,'status','2025-10-08 22:19:18',0,1),
(3208,1,'title','2025-10-08 22:19:18',0,1),
(3210,1,'postDate','2025-10-08 22:19:21',0,1),
(3210,1,'slug','2025-10-08 22:19:21',0,1),
(3210,1,'status','2025-10-08 22:19:21',0,1),
(3210,1,'title','2025-10-08 22:19:21',0,1);
/*!40000 ALTER TABLE `changedattributes` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `changedfields`
--

LOCK TABLES `changedfields` WRITE;
/*!40000 ALTER TABLE `changedfields` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `changedfields` VALUES
(2,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:29',0,1),
(2,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 22:20:12',0,1),
(2,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:29',0,1),
(2,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:29',0,1),
(2,1,5,'b2903903-6010-4012-bc8c-c8c21f059638','2025-04-18 18:32:48',0,1),
(2,1,6,'85dc9325-7c30-405d-9715-22e9294f7735','2025-04-18 17:33:58',0,1),
(2,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:29',0,1),
(2,1,8,'20f5fa3c-80d5-481b-862d-599d54f0fd29','2025-04-18 17:33:58',0,1),
(2,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-17 19:37:16',0,1),
(2,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-22 20:41:13',0,1),
(2,1,11,'d26c0574-65df-44ac-815a-723f6a2599ad','2025-04-18 18:17:53',0,1),
(2,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:29',0,1),
(2,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:29',0,1),
(2,1,14,'702dab28-10e4-44a1-9271-72e0eda7fa6e','2025-04-18 17:33:58',0,1),
(2,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:29',0,1),
(2,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:29',0,1),
(2,1,16,'7270a303-7119-43a8-b9bb-8360964189de','2025-04-18 18:45:07',0,1),
(2,1,17,'2bdc1e0d-4fd6-448b-b82c-71a75241bd23','2025-04-18 18:28:56',0,1),
(2,1,19,'0783e761-d312-48eb-a4f3-02333736ad99','2025-04-18 18:29:57',0,1),
(2,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:29',0,1),
(2,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-19 19:10:35',0,1),
(2,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:29',0,1),
(2,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:29',0,1),
(2,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:29',0,1),
(2,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-17 19:37:16',0,1),
(2,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-26 18:00:58',0,1),
(2,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:29',0,1),
(2,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:29',0,1),
(2,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:29',0,1),
(2,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:29',0,1),
(2,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:29',0,1),
(2,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-23 21:59:36',0,1),
(2,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:29',0,1),
(2,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:29',0,1),
(2,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:29',0,1),
(2,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2025-09-30 22:46:11',0,1),
(18,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:06:46',0,1),
(20,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:06:58',0,1),
(22,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:07:05',0,1),
(24,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:07:29',0,1),
(26,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:07:37',0,1),
(28,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:07:43',0,1),
(30,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:07:48',0,1),
(32,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:07:53',0,1),
(34,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:08:00',0,1),
(36,1,29,'a7b99092-005a-4069-87ab-f34eea7da598','2025-04-18 18:08:04',0,1),
(36,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-08-20 21:57:06',0,1),
(44,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-08-20 21:24:25',0,1),
(44,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-09-03 22:27:30',0,1),
(44,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-08-20 21:24:25',0,1),
(56,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-03 21:05:58',0,1),
(56,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-03 21:05:58',0,1),
(57,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-03 21:05:58',0,1),
(57,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-03 21:05:58',0,1),
(63,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-03 21:08:08',0,1),
(63,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-03 21:05:58',0,1),
(111,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-04-18 18:38:37',0,1),
(113,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-04-18 18:38:45',0,1),
(115,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-04-18 18:38:50',0,1),
(117,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-04-18 18:38:55',0,1),
(119,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-04-18 18:39:00',0,1),
(121,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-04-18 18:39:04',0,1),
(283,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-07-30 21:07:17',0,1),
(283,1,35,'6507c83d-4852-4bbd-9fee-2e10673e660b','2025-07-30 21:07:24',0,1),
(283,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-07-30 21:07:13',0,1),
(283,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-07-30 22:48:02',0,1),
(283,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-07-30 21:07:13',0,1),
(288,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-07-30 22:58:03',0,1),
(290,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-07-30 22:58:06',0,1),
(292,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-07-30 22:58:10',0,1),
(294,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-05 20:01:55',0,1),
(325,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:06:11',0,1),
(325,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:06:11',0,1),
(348,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:06:20',0,1),
(348,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:06:20',0,1),
(350,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:06:39',0,1),
(350,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:06:40',0,1),
(352,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:07:24',0,1),
(352,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:07:20',0,1),
(354,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:07:34',0,1),
(354,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:07:30',0,1),
(356,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:07:46',0,1),
(356,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:07:43',0,1),
(358,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:07:57',0,1),
(358,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:07:54',0,1),
(360,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:08:07',0,1),
(360,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:08:05',0,1),
(362,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:08:17',0,1),
(362,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:08:15',0,1),
(364,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:08:28',0,1),
(364,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:08:27',0,1),
(366,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:09:00',0,1),
(366,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:08:55',0,1),
(368,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:09:11',0,1),
(368,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:09:07',0,1),
(370,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:09:32',0,1),
(370,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:09:20',0,1),
(372,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:09:44',0,1),
(372,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:09:41',0,1),
(374,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:09:56',0,1),
(374,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:09:52',0,1),
(376,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:10:07',0,1),
(376,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:10:05',0,1),
(378,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:10:17',0,1),
(378,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:10:15',0,1),
(380,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:10:23',0,1),
(380,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:10:27',0,1),
(382,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:10:52',0,1),
(382,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:10:50',0,1),
(384,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:11:03',0,1),
(384,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:11:01',0,1),
(386,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:11:16',0,1),
(386,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:11:08',0,1),
(388,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:11:27',0,1),
(388,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:11:26',0,1),
(390,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:11:47',0,1),
(390,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:11:43',0,1),
(392,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:12:01',0,1),
(392,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:11:55',0,1),
(394,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:12:13',0,1),
(394,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:12:10',0,1),
(396,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:12:23',0,1),
(396,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:12:21',0,1),
(398,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:12:31',0,1),
(398,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:12:33',0,1),
(400,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:12:56',0,1),
(400,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:12:53',0,1),
(402,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:13:06',0,1),
(402,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:13:03',0,1),
(404,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:13:19',0,1),
(404,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:13:13',0,1),
(406,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:13:30',0,1),
(406,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:13:26',0,1),
(408,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:13:42',0,1),
(408,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:13:37',0,1),
(410,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:13:52',0,1),
(410,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:13:49',0,1),
(412,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:14:03',0,1),
(412,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:13:59',0,1),
(414,1,39,'77b43f80-b3db-4c4a-a697-e7337b02c937','2025-08-01 18:14:11',0,1),
(414,1,40,'ba4b9e07-f61a-405f-8896-aa42437b9c53','2025-08-01 18:14:09',0,1),
(445,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-09-03 22:27:30',0,1),
(453,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-08-20 21:57:20',0,1),
(455,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-08-20 21:57:31',0,1),
(457,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:25:31',0,1),
(459,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:25:08',0,1),
(459,1,69,'89752275-60b9-4b61-9143-06d0fc3bb511','2025-09-23 21:13:19',0,1),
(461,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:25:25',0,1),
(463,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:25:37',0,1),
(465,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:25:47',0,1),
(465,1,69,'89752275-60b9-4b61-9143-06d0fc3bb511','2025-09-23 21:13:37',0,1),
(467,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:25:55',0,1),
(469,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:26:04',0,1),
(471,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:26:11',0,1),
(473,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-08-20 22:00:22',0,1),
(475,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:26:26',0,1),
(477,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:26:34',0,1),
(479,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:26:42',0,1),
(481,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:26:54',0,1),
(483,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:27:03',0,1),
(485,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:27:13',0,1),
(487,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:29:02',0,1),
(487,1,69,'89752275-60b9-4b61-9143-06d0fc3bb511','2025-09-23 21:13:50',0,1),
(489,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:29:09',0,1),
(491,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:29:17',0,1),
(493,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-08-20 22:02:28',0,1),
(495,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-23 20:29:38',0,1),
(497,1,45,'a2de05eb-1437-41e9-bc0a-6f2defdc0d4e','2025-09-19 19:22:04',0,1),
(497,1,69,'89752275-60b9-4b61-9143-06d0fc3bb511','2025-09-23 21:13:43',0,1),
(555,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-09-02 22:24:44',0,1),
(557,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-09-02 22:24:51',0,1),
(559,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-09-02 22:24:59',0,1),
(561,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-09-02 22:25:02',0,1),
(563,1,30,'af4c29fe-7284-4a39-93a8-6ee23005762f','2025-09-02 22:25:06',0,1),
(601,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-09-03 21:49:20',0,1),
(601,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-03 20:24:31',0,1),
(603,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-09-03 21:48:44',0,1),
(605,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-09-03 21:58:30',0,1),
(605,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-03 20:24:40',0,1),
(617,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-09-03 21:57:10',0,1),
(617,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-03 20:24:49',0,1),
(945,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:29',0,1),
(945,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 22:19:59',0,1),
(945,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:29',0,1),
(945,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:29',0,1),
(945,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-06 17:50:00',0,1),
(945,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:29',0,1),
(945,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-06 17:50:00',0,1),
(945,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:29',0,1),
(945,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:29',0,1),
(945,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:29',0,1),
(945,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-06 17:50:00',0,1),
(945,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:29',0,1),
(945,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-06 17:50:49',0,1),
(945,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:29',0,1),
(945,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:29',0,1),
(945,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:29',0,1),
(945,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:29',0,1),
(945,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:29',0,1),
(945,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:29',0,1),
(945,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:29',0,1),
(945,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:29',0,1),
(945,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:29',0,1),
(945,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:29',0,1),
(945,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-06 17:51:32',0,1),
(945,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:29',0,1),
(945,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:29',0,1),
(945,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:29',0,1),
(945,1,64,'6ce2653f-cadb-4733-bde2-580e6c5ab8d7','2025-10-06 17:52:05',0,1),
(951,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 17:36:50',0,1),
(951,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 22:29:34',0,1),
(951,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:29',0,1),
(951,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:29',0,1),
(951,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:29',0,1),
(951,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 22:21:46',0,1),
(951,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 22:28:53',0,1),
(951,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:29',0,1),
(951,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:29',0,1),
(951,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:29',0,1),
(951,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 22:28:53',0,1),
(951,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:29',0,1),
(951,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:29',0,1),
(951,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:29',0,1),
(951,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 17:36:50',0,1),
(951,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:29',0,1),
(951,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:29',0,1),
(951,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:29',0,1),
(951,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:29',0,1),
(951,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:29',0,1),
(951,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:29',0,1),
(951,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:29',0,1),
(951,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:29',0,1),
(951,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 22:28:53',0,1),
(951,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-10-08 22:29:34',0,1),
(951,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:29',0,1),
(951,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:29',0,1),
(957,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:29',0,1),
(957,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 22:20:19',0,1),
(957,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:29',0,1),
(957,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:29',0,1),
(957,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-08 18:36:38',0,1),
(957,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 18:43:12',0,1),
(957,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 18:39:34',0,1),
(957,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:29',0,1),
(957,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:29',0,1),
(957,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:29',0,1),
(957,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 18:36:38',0,1),
(957,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:29',0,1),
(957,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 18:43:12',0,1),
(957,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 18:43:12',0,1),
(957,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:29',0,1),
(957,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:29',0,1),
(957,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-08 18:43:12',0,1),
(957,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:29',0,1),
(957,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:29',0,1),
(957,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:29',0,1),
(957,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-10-08 18:17:50',0,1),
(957,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:29',0,1),
(957,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:29',0,1),
(957,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:29',0,1),
(957,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:29',0,1),
(957,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:29',0,1),
(957,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:29',0,1),
(963,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:29',0,1),
(963,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 18:52:55',0,1),
(963,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:29',0,1),
(963,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:29',0,1),
(963,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-08 18:46:53',0,1),
(963,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 18:52:55',0,1),
(963,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 18:48:30',0,1),
(963,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:29',0,1),
(963,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:29',0,1),
(963,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:29',0,1),
(963,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 18:46:53',0,1),
(963,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:29',0,1),
(963,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 18:50:11',0,1),
(963,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 18:50:11',0,1),
(963,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:29',0,1),
(963,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:29',0,1),
(963,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-08 18:52:55',0,1),
(963,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-10-08 18:50:11',0,1),
(963,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:29',0,1),
(963,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:29',0,1),
(963,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:29',0,1),
(963,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:29',0,1),
(963,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:29',0,1),
(963,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 18:50:11',0,1),
(963,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:29',0,1),
(963,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:29',0,1),
(963,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:29',0,1),
(969,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(969,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 19:00:47',0,1),
(969,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(969,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(969,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-08 18:56:08',0,1),
(969,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 19:00:47',0,1),
(969,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 18:57:34',0,1),
(969,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(969,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(969,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(969,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 18:56:08',0,1),
(969,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(969,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 18:59:33',0,1),
(969,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 18:59:33',0,1),
(969,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(969,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(969,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-08 19:00:47',0,1),
(969,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(969,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(969,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(969,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(969,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(969,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(969,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:30',0,1),
(969,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(969,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(969,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(975,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(975,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 19:59:16',0,1),
(975,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(975,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(975,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-08 19:54:50',0,1),
(975,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 19:59:16',0,1),
(975,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 19:59:16',0,1),
(975,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(975,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(975,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(975,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 19:54:50',0,1),
(975,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(975,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 19:59:16',0,1),
(975,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 19:59:16',0,1),
(975,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(975,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(975,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-08 19:59:16',0,1),
(975,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(975,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(975,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(975,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(975,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(975,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(975,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 19:59:16',0,1),
(975,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(975,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(975,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(981,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(981,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 20:26:02',0,1),
(981,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(981,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(981,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-08 20:22:54',0,1),
(981,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 20:25:58',0,1),
(981,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 20:24:41',0,1),
(981,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(981,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(981,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(981,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 20:22:54',0,1),
(981,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(981,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 20:24:41',0,1),
(981,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 20:24:42',0,1),
(981,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(981,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(981,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-08 20:25:58',0,1),
(981,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(981,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(981,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(981,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(981,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(981,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(981,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 20:25:58',0,1),
(981,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(981,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(981,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(989,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(989,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:30',0,1),
(989,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(989,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(989,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:30',0,1),
(989,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:30',0,1),
(989,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:30',0,1),
(989,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(989,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(989,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(989,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:30',0,1),
(989,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(989,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:30',0,1),
(989,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:30',0,1),
(989,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(989,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(989,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:30',0,1),
(989,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(989,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(989,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(989,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(989,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(989,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(989,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:30',0,1),
(989,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(989,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(989,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(995,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(995,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:30',0,1),
(995,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(995,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(995,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:30',0,1),
(995,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:30',0,1),
(995,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:30',0,1),
(995,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(995,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(995,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(995,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:30',0,1),
(995,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(995,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:30',0,1),
(995,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:30',0,1),
(995,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(995,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(995,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:30',0,1),
(995,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(995,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(995,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(995,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(995,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(995,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(995,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:30',0,1),
(995,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(995,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(995,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(999,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(999,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:30',0,1),
(999,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(999,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(999,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:30',0,1),
(999,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:30',0,1),
(999,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:30',0,1),
(999,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(999,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(999,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(999,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:30',0,1),
(999,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(999,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:30',0,1),
(999,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:30',0,1),
(999,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(999,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(999,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:30',0,1),
(999,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(999,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(999,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(999,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(999,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(999,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(999,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:30',0,1),
(999,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(999,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(999,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(1005,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(1005,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:30',0,1),
(1005,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(1005,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(1005,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:30',0,1),
(1005,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:30',0,1),
(1005,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:30',0,1),
(1005,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(1005,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(1005,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(1005,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:30',0,1),
(1005,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(1005,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:30',0,1),
(1005,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:30',0,1),
(1005,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(1005,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(1005,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:30',0,1),
(1005,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(1005,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(1005,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(1005,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(1005,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(1005,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(1005,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:30',0,1),
(1005,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(1005,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(1005,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(1011,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(1011,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:30',0,1),
(1011,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(1011,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(1011,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:30',0,1),
(1011,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:30',0,1),
(1011,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:30',0,1),
(1011,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(1011,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(1011,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(1011,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:30',0,1),
(1011,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(1011,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:30',0,1),
(1011,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:30',0,1),
(1011,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(1011,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(1011,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:30',0,1),
(1011,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(1011,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(1011,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(1011,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(1011,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(1011,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(1011,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:30',0,1),
(1011,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(1011,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(1011,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(1017,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:30',0,1),
(1017,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:30',0,1),
(1017,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:30',0,1),
(1017,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:30',0,1),
(1017,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:30',0,1),
(1017,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:30',0,1),
(1017,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:30',0,1),
(1017,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:30',0,1),
(1017,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:30',0,1),
(1017,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:30',0,1),
(1017,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:30',0,1),
(1017,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:30',0,1),
(1017,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:30',0,1),
(1017,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:30',0,1),
(1017,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:30',0,1),
(1017,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:30',0,1),
(1017,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:30',0,1),
(1017,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:30',0,1),
(1017,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:30',0,1),
(1017,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:30',0,1),
(1017,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:30',0,1),
(1017,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:30',0,1),
(1017,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:30',0,1),
(1017,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:30',0,1),
(1017,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:30',0,1),
(1017,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:30',0,1),
(1017,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:30',0,1),
(1023,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1023,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:31',0,1),
(1023,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1023,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1023,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:31',0,1),
(1023,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:31',0,1),
(1023,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1023,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1023,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1023,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1023,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1023,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1023,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1023,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:31',0,1),
(1023,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1023,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1023,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1023,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1023,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1023,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1023,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1023,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1023,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1023,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1023,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1023,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1023,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1031,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1031,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:31',0,1),
(1031,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1031,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1031,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:31',0,1),
(1031,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:31',0,1),
(1031,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1031,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1031,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1031,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1031,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1031,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1031,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1031,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:31',0,1),
(1031,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1031,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1031,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1031,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1031,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1031,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1031,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1031,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1031,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1031,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1031,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1031,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1031,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1035,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1035,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:31',0,1),
(1035,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1035,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1035,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:31',0,1),
(1035,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:31',0,1),
(1035,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1035,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1035,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1035,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1035,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1035,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1035,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1035,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:31',0,1),
(1035,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1035,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1035,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1035,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1035,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1035,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1035,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1035,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1035,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1035,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1035,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1035,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1035,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1041,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1041,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:31',0,1),
(1041,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1041,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1041,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:31',0,1),
(1041,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:31',0,1),
(1041,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1041,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1041,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1041,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1041,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1041,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1041,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1041,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:31',0,1),
(1041,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1041,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1041,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1041,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1041,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1041,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1041,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1041,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1041,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1041,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1041,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1041,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1041,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1045,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1045,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-06 16:09:49',0,1),
(1045,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1045,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1045,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:31',0,1),
(1045,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:31',0,1),
(1045,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1045,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1045,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1045,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1045,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1045,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1045,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1045,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:31',0,1),
(1045,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1045,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1045,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1045,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1045,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1045,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1045,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1045,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1045,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1045,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1045,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1045,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1045,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1051,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1051,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:31',0,1),
(1051,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1051,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1051,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:31',0,1),
(1051,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:31',0,1),
(1051,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1051,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1051,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1051,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1051,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1051,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1051,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1051,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:31',0,1),
(1051,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1051,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1051,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1051,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1051,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1051,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1051,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1051,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1051,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1051,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1051,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1051,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1051,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1059,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1059,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:42:30',0,1),
(1059,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1059,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1059,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:31',0,1),
(1059,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:31',0,1),
(1059,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1059,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1059,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1059,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1059,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1059,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1059,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1059,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:31',0,1),
(1059,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1059,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1059,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1059,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1059,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1059,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1059,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1059,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1059,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1059,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1059,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1059,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1059,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1067,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1067,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:31',0,1),
(1067,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1067,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1067,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:31',0,1),
(1067,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:31',0,1),
(1067,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1067,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1067,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1067,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1067,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1067,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1067,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1067,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:31',0,1),
(1067,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1067,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1067,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1067,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1067,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1067,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1067,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1067,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1067,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1067,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1067,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1067,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1067,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1073,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1073,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:31',0,1),
(1073,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1073,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1073,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:31',0,1),
(1073,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:31',0,1),
(1073,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1073,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1073,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1073,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1073,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1073,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1073,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1073,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:31',0,1),
(1073,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1073,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1073,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1073,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1073,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1073,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1073,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1073,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1073,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1073,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1073,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1073,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1073,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1079,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:31',0,1),
(1079,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:31',0,1),
(1079,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:31',0,1),
(1079,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:31',0,1),
(1079,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:31',0,1),
(1079,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:31',0,1),
(1079,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:31',0,1),
(1079,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:31',0,1),
(1079,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:31',0,1),
(1079,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:31',0,1),
(1079,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:31',0,1),
(1079,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:31',0,1),
(1079,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:31',0,1),
(1079,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:31',0,1),
(1079,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:31',0,1),
(1079,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:31',0,1),
(1079,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:31',0,1),
(1079,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:31',0,1),
(1079,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:31',0,1),
(1079,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:31',0,1),
(1079,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:31',0,1),
(1079,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:31',0,1),
(1079,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:31',0,1),
(1079,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:31',0,1),
(1079,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:31',0,1),
(1079,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:31',0,1),
(1079,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:31',0,1),
(1085,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1085,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:32',0,1),
(1085,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1085,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1085,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:32',0,1),
(1085,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:32',0,1),
(1085,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:32',0,1),
(1085,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1085,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1085,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1085,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:32',0,1),
(1085,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1085,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:32',0,1),
(1085,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:32',0,1),
(1085,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1085,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1085,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:32',0,1),
(1085,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1085,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1085,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1085,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1085,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1085,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1085,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1085,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1085,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1085,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1091,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1091,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:32',0,1),
(1091,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1091,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1091,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:32',0,1),
(1091,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:32',0,1),
(1091,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:32',0,1),
(1091,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1091,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1091,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1091,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:32',0,1),
(1091,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1091,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:32',0,1),
(1091,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:32',0,1),
(1091,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1091,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1091,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:32',0,1),
(1091,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1091,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1091,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1091,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1091,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1091,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1091,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1091,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1091,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1091,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1097,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1097,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:32',0,1),
(1097,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1097,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1097,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:32',0,1),
(1097,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:32',0,1),
(1097,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:32',0,1),
(1097,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1097,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1097,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1097,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:32',0,1),
(1097,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1097,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:32',0,1),
(1097,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:32',0,1),
(1097,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1097,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1097,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:32',0,1),
(1097,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1097,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1097,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1097,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1097,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1097,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1097,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1097,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1097,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1097,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1103,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1103,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:32',0,1),
(1103,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1103,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1103,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:32',0,1),
(1103,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:32',0,1),
(1103,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:32',0,1),
(1103,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1103,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1103,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1103,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:32',0,1),
(1103,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1103,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:32',0,1),
(1103,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:32',0,1),
(1103,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1103,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1103,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:32',0,1),
(1103,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1103,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1103,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1103,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1103,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1103,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1103,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1103,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1103,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1103,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1109,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1109,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:32',0,1),
(1109,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1109,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1109,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:32',0,1),
(1109,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:32',0,1),
(1109,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:32',0,1),
(1109,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1109,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1109,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1109,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:32',0,1),
(1109,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1109,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:32',0,1),
(1109,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:32',0,1),
(1109,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1109,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1109,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:32',0,1),
(1109,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1109,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1109,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1109,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1109,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1109,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1109,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1109,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1109,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1109,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1117,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1117,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:32',0,1),
(1117,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1117,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1117,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:32',0,1),
(1117,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:32',0,1),
(1117,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:32',0,1),
(1117,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1117,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1117,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1117,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:32',0,1),
(1117,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1117,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:32',0,1),
(1117,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:32',0,1),
(1117,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1117,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1117,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:32',0,1),
(1117,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1117,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1117,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1117,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1117,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1117,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1117,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1117,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1117,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1117,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1123,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1123,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:32',0,1),
(1123,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1123,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1123,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:32',0,1),
(1123,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:32',0,1),
(1123,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:32',0,1),
(1123,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1123,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1123,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1123,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:32',0,1),
(1123,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1123,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:32',0,1),
(1123,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:32',0,1),
(1123,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1123,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1123,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:32',0,1),
(1123,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1123,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1123,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1123,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1123,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1123,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1123,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1123,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1123,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1123,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1129,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1129,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:32',0,1),
(1129,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1129,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1129,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:32',0,1),
(1129,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:32',0,1),
(1129,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:32',0,1),
(1129,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1129,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1129,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1129,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:32',0,1),
(1129,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1129,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:32',0,1),
(1129,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:32',0,1),
(1129,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1129,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1129,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:32',0,1),
(1129,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1129,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1129,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1129,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1129,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1129,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1129,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1129,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1129,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1129,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1135,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1135,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:32',0,1),
(1135,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1135,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1135,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:32',0,1),
(1135,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:32',0,1),
(1135,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:32',0,1),
(1135,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1135,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1135,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1135,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:32',0,1),
(1135,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1135,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:32',0,1),
(1135,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:32',0,1),
(1135,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1135,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1135,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:32',0,1),
(1135,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1135,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1135,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1135,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1135,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1135,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1135,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1135,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1135,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1135,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1141,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 18:51:21',0,1),
(1141,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 19:22:03',0,1),
(1141,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 18:51:21',0,1),
(1141,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 18:51:21',0,1),
(1141,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 18:51:21',0,1),
(1141,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 18:51:21',0,1),
(1141,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 18:51:21',0,1),
(1141,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 18:51:21',0,1),
(1141,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 18:51:21',0,1),
(1141,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 18:51:21',0,1),
(1141,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 18:51:21',0,1),
(1141,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 18:51:21',0,1),
(1141,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 18:51:21',0,1),
(1141,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 18:51:21',0,1),
(1141,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 18:51:21',0,1),
(1141,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 18:51:21',0,1),
(1141,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 18:51:21',0,1),
(1141,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 18:51:21',0,1),
(1141,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 18:51:21',0,1),
(1141,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 18:51:21',0,1),
(1141,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 18:51:21',0,1),
(1141,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 18:51:21',0,1),
(1141,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 18:51:21',0,1),
(1141,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 18:51:21',0,1),
(1141,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 18:51:21',0,1),
(1141,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 18:51:21',0,1),
(1143,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:32',0,1),
(1143,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:32',0,1),
(1143,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:32',0,1),
(1143,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:32',0,1),
(1143,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:32',0,1),
(1143,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:32',0,1),
(1143,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:32',0,1),
(1143,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:32',0,1),
(1143,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:32',0,1),
(1143,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:32',0,1),
(1143,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:32',0,1),
(1143,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:32',0,1),
(1143,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:32',0,1),
(1143,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:32',0,1),
(1143,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:32',0,1),
(1143,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:32',0,1),
(1143,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:32',0,1),
(1143,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:32',0,1),
(1143,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:32',0,1),
(1143,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:32',0,1),
(1143,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:32',0,1),
(1143,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:32',0,1),
(1143,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:32',0,1),
(1143,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:32',0,1),
(1143,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:32',0,1),
(1143,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:32',0,1),
(1143,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:32',0,1),
(1149,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 18:51:21',0,1),
(1149,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 19:17:42',0,1),
(1149,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 18:51:21',0,1),
(1149,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 18:51:21',0,1),
(1149,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 18:51:21',0,1),
(1149,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 18:51:21',0,1),
(1149,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 18:51:21',0,1),
(1149,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 18:51:21',0,1),
(1149,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 18:51:21',0,1),
(1149,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 18:51:21',0,1),
(1149,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 18:51:21',0,1),
(1149,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 18:51:21',0,1),
(1149,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 18:51:21',0,1),
(1149,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 18:51:21',0,1),
(1149,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 18:51:21',0,1),
(1149,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 18:51:21',0,1),
(1149,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 18:51:21',0,1),
(1149,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 18:51:21',0,1),
(1149,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 18:51:21',0,1),
(1149,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 18:51:21',0,1),
(1149,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 18:51:21',0,1),
(1149,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 18:51:21',0,1),
(1149,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 18:51:21',0,1),
(1149,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 18:51:21',0,1),
(1149,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 18:51:21',0,1),
(1149,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 18:51:21',0,1),
(1155,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1155,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:33',0,1),
(1155,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1155,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1155,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:33',0,1),
(1155,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:33',0,1),
(1155,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:33',0,1),
(1155,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1155,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1155,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1155,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:33',0,1),
(1155,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1155,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:33',0,1),
(1155,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:33',0,1),
(1155,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1155,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1155,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:33',0,1),
(1155,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1155,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1155,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1155,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1155,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1155,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1155,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1155,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1155,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1155,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1161,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1161,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:33',0,1),
(1161,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1161,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1161,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:33',0,1),
(1161,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:33',0,1),
(1161,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:33',0,1),
(1161,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1161,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1161,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1161,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:33',0,1),
(1161,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1161,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:33',0,1),
(1161,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:33',0,1),
(1161,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1161,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1161,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:33',0,1),
(1161,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1161,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1161,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1161,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1161,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1161,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1161,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1161,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1161,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1161,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1165,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1165,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 22:20:15',0,1),
(1165,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1165,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1165,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:33',0,1),
(1165,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:33',0,1),
(1165,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:33',0,1),
(1165,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1165,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1165,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1165,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:33',0,1),
(1165,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1165,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:33',0,1),
(1165,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:33',0,1),
(1165,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1165,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1165,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:33',0,1),
(1165,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1165,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1165,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1165,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1165,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1165,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1165,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1165,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1165,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1165,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1171,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1171,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-24 15:56:11',0,1),
(1171,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1171,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1171,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:33',0,1),
(1171,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:33',0,1),
(1171,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:33',0,1),
(1171,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1171,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1171,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1171,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:33',0,1),
(1171,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1171,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:33',0,1),
(1171,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:33',0,1),
(1171,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1171,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1171,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:33',0,1),
(1171,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1171,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1171,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1171,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1171,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1171,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1171,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1171,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1171,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1171,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1177,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1177,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-29 18:35:55',0,1),
(1177,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1177,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1177,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:33',0,1),
(1177,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:33',0,1),
(1177,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:33',0,1),
(1177,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1177,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1177,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1177,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:33',0,1),
(1177,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1177,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:33',0,1),
(1177,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:33',0,1),
(1177,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1177,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-29 18:35:28',0,1),
(1177,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:33',0,1),
(1177,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1177,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1177,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1177,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1177,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1177,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1177,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1177,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1177,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-29 18:35:55',0,1),
(1177,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1185,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1185,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:33',0,1),
(1185,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1185,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1185,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:33',0,1),
(1185,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:33',0,1),
(1185,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:33',0,1),
(1185,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1185,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1185,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1185,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:33',0,1),
(1185,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1185,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:33',0,1),
(1185,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:33',0,1),
(1185,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1185,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1185,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:33',0,1),
(1185,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1185,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1185,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1185,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1185,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1185,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1185,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1185,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1185,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1185,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1191,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1191,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:33',0,1),
(1191,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1191,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1191,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:33',0,1),
(1191,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:33',0,1),
(1191,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:33',0,1),
(1191,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1191,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1191,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1191,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:33',0,1),
(1191,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1191,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:33',0,1),
(1191,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:33',0,1),
(1191,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1191,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1191,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:33',0,1),
(1191,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1191,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1191,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1191,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1191,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1191,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1191,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1191,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1191,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1191,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1197,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1197,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:33',0,1),
(1197,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1197,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1197,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:33',0,1),
(1197,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:33',0,1),
(1197,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:33',0,1),
(1197,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1197,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1197,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1197,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:33',0,1),
(1197,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1197,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:33',0,1),
(1197,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:33',0,1),
(1197,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1197,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1197,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:33',0,1),
(1197,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1197,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1197,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1197,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1197,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1197,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1197,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1197,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1197,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1197,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1201,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1201,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:33',0,1),
(1201,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1201,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1201,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:33',0,1),
(1201,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:33',0,1),
(1201,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:33',0,1),
(1201,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1201,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1201,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1201,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:33',0,1),
(1201,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1201,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:33',0,1),
(1201,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:33',0,1),
(1201,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1201,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1201,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:33',0,1),
(1201,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1201,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1201,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1201,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1201,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1201,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1201,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1201,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1201,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1201,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1209,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:33',0,1),
(1209,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:33',0,1),
(1209,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:33',0,1),
(1209,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:33',0,1),
(1209,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:33',0,1),
(1209,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:33',0,1),
(1209,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:33',0,1),
(1209,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:33',0,1),
(1209,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:33',0,1),
(1209,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:33',0,1),
(1209,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:33',0,1),
(1209,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:33',0,1),
(1209,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:33',0,1),
(1209,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:33',0,1),
(1209,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:33',0,1),
(1209,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:33',0,1),
(1209,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:33',0,1),
(1209,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:33',0,1),
(1209,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:33',0,1),
(1209,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:33',0,1),
(1209,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:33',0,1),
(1209,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:33',0,1),
(1209,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:33',0,1),
(1209,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:33',0,1),
(1209,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:33',0,1),
(1209,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:33',0,1),
(1209,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:33',0,1),
(1215,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1215,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:34',0,1),
(1215,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1215,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1215,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:34',0,1),
(1215,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:34',0,1),
(1215,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:34',0,1),
(1215,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1215,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1215,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1215,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:34',0,1),
(1215,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1215,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:34',0,1),
(1215,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:34',0,1),
(1215,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1215,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1215,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:34',0,1),
(1215,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1215,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1215,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1215,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1215,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1215,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1215,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1215,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1215,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1215,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1219,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1219,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:34',0,1),
(1219,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1219,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1219,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:34',0,1),
(1219,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:34',0,1),
(1219,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:34',0,1),
(1219,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1219,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1219,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1219,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:34',0,1),
(1219,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1219,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:34',0,1),
(1219,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:34',0,1),
(1219,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1219,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1219,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:34',0,1),
(1219,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1219,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1219,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1219,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1219,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1219,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1219,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1219,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1219,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1219,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1225,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1225,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:34',0,1),
(1225,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1225,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1225,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:34',0,1),
(1225,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:34',0,1),
(1225,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:34',0,1),
(1225,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1225,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1225,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1225,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:34',0,1),
(1225,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1225,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:34',0,1),
(1225,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:34',0,1),
(1225,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1225,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1225,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:34',0,1),
(1225,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1225,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1225,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1225,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1225,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1225,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1225,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1225,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1225,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1225,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1231,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1231,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:34',0,1),
(1231,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1231,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1231,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:34',0,1),
(1231,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:34',0,1),
(1231,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:34',0,1),
(1231,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1231,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1231,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1231,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:34',0,1),
(1231,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1231,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:34',0,1),
(1231,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:34',0,1),
(1231,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1231,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1231,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:34',0,1),
(1231,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1231,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1231,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1231,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1231,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1231,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1231,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1231,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1231,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1231,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1237,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1237,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:34',0,1),
(1237,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1237,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1237,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:34',0,1),
(1237,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:34',0,1),
(1237,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:34',0,1),
(1237,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1237,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1237,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1237,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:34',0,1),
(1237,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1237,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:34',0,1),
(1237,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:34',0,1),
(1237,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1237,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1237,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:34',0,1),
(1237,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1237,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1237,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1237,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1237,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1237,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1237,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1237,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1237,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1237,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1243,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1243,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:34',0,1),
(1243,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1243,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1243,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:34',0,1),
(1243,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:34',0,1),
(1243,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:34',0,1),
(1243,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1243,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1243,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1243,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:34',0,1),
(1243,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1243,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:34',0,1),
(1243,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:34',0,1),
(1243,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1243,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1243,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:34',0,1),
(1243,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1243,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1243,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1243,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1243,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1243,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1243,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1243,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1243,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1243,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1249,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1249,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:34',0,1),
(1249,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1249,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1249,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:34',0,1),
(1249,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:34',0,1),
(1249,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:34',0,1),
(1249,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1249,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1249,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1249,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:34',0,1),
(1249,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1249,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:34',0,1),
(1249,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:34',0,1),
(1249,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1249,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1249,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:34',0,1),
(1249,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1249,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1249,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1249,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1249,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1249,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1249,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1249,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1249,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1249,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1255,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1255,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 22:20:05',0,1),
(1255,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1255,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1255,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:34',0,1),
(1255,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:34',0,1),
(1255,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:34',0,1),
(1255,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1255,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1255,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1255,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:34',0,1),
(1255,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1255,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-25 02:15:57',0,1),
(1255,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:34',0,1),
(1255,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1255,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1255,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:34',0,1),
(1255,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1255,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1255,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1255,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1255,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1255,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1255,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1255,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1255,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1255,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1261,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:34',0,1),
(1261,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:34',0,1),
(1261,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:34',0,1),
(1261,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:34',0,1),
(1261,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:34',0,1),
(1261,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:34',0,1),
(1261,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:34',0,1),
(1261,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:34',0,1),
(1261,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:34',0,1),
(1261,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:34',0,1),
(1261,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:34',0,1),
(1261,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:34',0,1),
(1261,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:34',0,1),
(1261,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:34',0,1),
(1261,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:34',0,1),
(1261,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:34',0,1),
(1261,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:34',0,1),
(1261,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:34',0,1),
(1261,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:34',0,1),
(1261,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:34',0,1),
(1261,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:34',0,1),
(1261,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:34',0,1),
(1261,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:34',0,1),
(1261,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:34',0,1),
(1261,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:34',0,1),
(1261,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:34',0,1),
(1261,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:34',0,1),
(1269,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1269,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1269,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1269,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1269,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1269,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1269,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1269,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1269,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1269,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1269,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1269,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1269,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1269,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1269,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1269,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1269,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1269,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1269,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1269,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1269,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1269,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1269,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1269,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1269,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1269,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1269,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1277,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1277,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1277,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1277,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1277,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1277,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1277,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1277,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1277,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1277,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1277,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1277,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1277,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1277,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1277,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1277,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1277,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1277,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1277,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1277,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1277,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1277,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1277,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1277,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1277,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1277,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1277,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1283,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1283,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:42:35',0,1),
(1283,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1283,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1283,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1283,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1283,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1283,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1283,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1283,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1283,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1283,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1283,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1283,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1283,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1283,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1283,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1283,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1283,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1283,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1283,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1283,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1283,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1283,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1283,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1283,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1283,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1289,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1289,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1289,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1289,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1289,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1289,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1289,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1289,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1289,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1289,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1289,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1289,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1289,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1289,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1289,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1289,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1289,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1289,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1289,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1289,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1289,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1289,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1289,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1289,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1289,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1289,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1289,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1297,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1297,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1297,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1297,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1297,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1297,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1297,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1297,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1297,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1297,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1297,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1297,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1297,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1297,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1297,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1297,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1297,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1297,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1297,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1297,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1297,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1297,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1297,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1297,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1297,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1297,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1297,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1303,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1303,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1303,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1303,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1303,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1303,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1303,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1303,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1303,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1303,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1303,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1303,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1303,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1303,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1303,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1303,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1303,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1303,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1303,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1303,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1303,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1303,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1303,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1303,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1303,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1303,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1303,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1309,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1309,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1309,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1309,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1309,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1309,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1309,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1309,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1309,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1309,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1309,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1309,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1309,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1309,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1309,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1309,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1309,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1309,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1309,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1309,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1309,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1309,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1309,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1309,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1309,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1309,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1309,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1315,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1315,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1315,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1315,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1315,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1315,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1315,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1315,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1315,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1315,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1315,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1315,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1315,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1315,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1315,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1315,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1315,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1315,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1315,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1315,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1315,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1315,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1315,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1315,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1315,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1315,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1315,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1323,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:35',0,1),
(1323,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:35',0,1),
(1323,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:35',0,1),
(1323,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:35',0,1),
(1323,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:35',0,1),
(1323,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:35',0,1),
(1323,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:35',0,1),
(1323,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:35',0,1),
(1323,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:35',0,1),
(1323,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:35',0,1),
(1323,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:35',0,1),
(1323,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:35',0,1),
(1323,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:35',0,1),
(1323,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:35',0,1),
(1323,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:35',0,1),
(1323,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:35',0,1),
(1323,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:35',0,1),
(1323,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:35',0,1),
(1323,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:35',0,1),
(1323,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:35',0,1),
(1323,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:35',0,1),
(1323,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:35',0,1),
(1323,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:35',0,1),
(1323,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:35',0,1),
(1323,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:35',0,1),
(1323,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:35',0,1),
(1323,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:35',0,1),
(1329,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:36',0,1),
(1329,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:36',0,1),
(1329,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1329,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:36',0,1),
(1329,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1329,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1329,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1329,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1329,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1329,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1329,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1329,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1329,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1329,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1329,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1329,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1329,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1329,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1329,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1329,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1329,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1329,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1329,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1329,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1329,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1329,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1329,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1337,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:36',0,1),
(1337,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:36',0,1),
(1337,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1337,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:36',0,1),
(1337,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1337,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1337,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1337,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1337,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1337,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1337,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1337,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1337,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1337,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1337,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1337,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1337,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1337,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1337,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1337,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1337,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1337,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1337,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1337,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1337,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1337,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1337,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1343,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:36',0,1),
(1343,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:36',0,1),
(1343,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1343,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:36',0,1),
(1343,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1343,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1343,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1343,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1343,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1343,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1343,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1343,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1343,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1343,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1343,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1343,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1343,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1343,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1343,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1343,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1343,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1343,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1343,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1343,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1343,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1343,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1343,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1349,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:36',0,1),
(1349,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:36',0,1),
(1349,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1349,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:36',0,1),
(1349,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1349,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1349,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1349,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1349,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1349,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1349,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1349,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1349,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1349,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1349,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1349,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1349,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1349,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1349,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1349,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1349,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1349,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1349,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1349,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1349,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1349,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1349,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1353,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:03:40',0,1),
(1353,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 22:41:35',0,1),
(1353,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1353,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:20:10',0,1),
(1353,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-10-08 22:40:25',0,1),
(1353,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 22:38:45',0,1),
(1353,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 22:38:17',0,1),
(1353,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1353,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1353,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1353,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 22:41:35',0,1),
(1353,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1353,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-10-08 22:40:25',0,1),
(1353,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-10-08 22:40:25',0,1),
(1353,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:03:40',0,1),
(1353,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1353,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1353,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1353,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1353,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1353,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1353,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1353,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-10-08 22:41:35',0,1),
(1353,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 22:38:17',0,1),
(1353,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-10-08 22:41:35',0,1),
(1353,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1353,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1359,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:03:22',0,1),
(1359,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:20:33',0,1),
(1359,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1359,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:20:33',0,1),
(1359,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1359,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1359,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1359,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1359,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1359,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1359,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1359,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1359,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1359,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1359,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:03:22',0,1),
(1359,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1359,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1359,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1359,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1359,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1359,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1359,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1359,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1359,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1359,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1359,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1359,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1365,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:20:52',0,1),
(1365,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:20:52',0,1),
(1365,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-22 18:20:52',0,1),
(1365,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:20:52',0,1),
(1365,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-22 18:20:52',0,1),
(1365,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1365,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1365,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-22 18:20:52',0,1),
(1365,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-22 18:20:52',0,1),
(1365,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-22 18:20:52',0,1),
(1365,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-22 18:20:52',0,1),
(1365,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-22 18:20:52',0,1),
(1365,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-22 18:20:52',0,1),
(1365,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-22 18:20:52',0,1),
(1365,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:20:52',0,1),
(1365,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-22 18:20:52',0,1),
(1365,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1365,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-22 18:20:52',0,1),
(1365,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-22 18:20:52',0,1),
(1365,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-22 18:20:52',0,1),
(1365,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-22 18:20:52',0,1),
(1365,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-22 18:20:52',0,1),
(1365,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1365,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1365,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-22 18:20:52',0,1),
(1365,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-22 18:20:52',0,1),
(1365,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-22 18:20:52',0,1),
(1371,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:04:46',0,1),
(1371,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:21:35',0,1),
(1371,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1371,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:21:35',0,1),
(1371,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1371,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1371,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1371,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1371,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1371,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1371,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1371,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1371,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1371,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1371,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1371,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1371,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1371,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1371,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1371,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1371,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1371,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1371,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1371,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1371,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1371,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1371,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1377,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:06:29',0,1),
(1377,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:22:06',0,1),
(1377,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1377,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:22:06',0,1),
(1377,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1377,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1377,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1377,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1377,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1377,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1377,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1377,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1377,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1377,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1377,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1377,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1377,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1377,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1377,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1377,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1377,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1377,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1377,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1377,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1377,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1377,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1377,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1383,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:06:50',0,1),
(1383,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:22:45',0,1),
(1383,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:36',0,1),
(1383,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:22:45',0,1),
(1383,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:36',0,1),
(1383,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:36',0,1),
(1383,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:36',0,1),
(1383,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:36',0,1),
(1383,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:36',0,1),
(1383,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:36',0,1),
(1383,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:36',0,1),
(1383,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:36',0,1),
(1383,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:36',0,1),
(1383,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:36',0,1),
(1383,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:36',0,1),
(1383,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:36',0,1),
(1383,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:36',0,1),
(1383,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:36',0,1),
(1383,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:36',0,1),
(1383,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:36',0,1),
(1383,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:36',0,1),
(1383,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:36',0,1),
(1383,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:36',0,1),
(1383,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:36',0,1),
(1383,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:36',0,1),
(1383,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:36',0,1),
(1383,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:36',0,1),
(1389,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:07:16',0,1),
(1389,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:23:02',0,1),
(1389,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1389,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:23:02',0,1),
(1389,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1389,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1389,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1389,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1389,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1389,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1389,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1389,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1389,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1389,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1389,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:37',0,1),
(1389,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1389,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1389,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1389,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1389,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1389,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1389,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1389,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1389,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1389,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1389,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1389,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1395,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:08:00',0,1),
(1395,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-29 18:59:03',0,1),
(1395,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1395,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:21:16',0,1),
(1395,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1395,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1395,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1395,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1395,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1395,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1395,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1395,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1395,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1395,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1395,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:08:00',0,1),
(1395,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1395,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1395,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1395,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1395,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1395,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1395,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1395,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1395,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1395,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1395,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1395,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1401,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:08:33',0,1),
(1401,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:22:29',0,1),
(1401,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1401,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:22:29',0,1),
(1401,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1401,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1401,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1401,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1401,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1401,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1401,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1401,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1401,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1401,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1401,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:08:33',0,1),
(1401,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1401,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1401,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1401,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1401,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1401,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1401,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1401,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1401,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1401,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1401,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1401,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1407,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:08:56',0,1),
(1407,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:23:24',0,1),
(1407,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1407,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:23:24',0,1),
(1407,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1407,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1407,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1407,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1407,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1407,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1407,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1407,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1407,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1407,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1407,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:37',0,1),
(1407,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1407,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1407,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1407,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1407,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1407,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1407,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1407,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1407,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1407,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1407,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1407,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1413,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:09:23',0,1),
(1413,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-22 18:18:15',0,1),
(1413,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1413,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:18:15',0,1),
(1413,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1413,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1413,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1413,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1413,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1413,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1413,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1413,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1413,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1413,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1413,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:09:23',0,1),
(1413,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1413,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1413,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1413,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1413,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1413,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1413,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1413,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1413,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1413,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1413,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1413,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1419,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:37',0,1),
(1419,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:37',0,1),
(1419,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1419,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:37',0,1),
(1419,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1419,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1419,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1419,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1419,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1419,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1419,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1419,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1419,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1419,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1419,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:37',0,1),
(1419,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1419,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1419,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1419,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1419,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1419,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1419,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1419,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1419,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1419,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1419,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1419,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1425,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:37',0,1),
(1425,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:37',0,1),
(1425,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1425,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:37',0,1),
(1425,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1425,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1425,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1425,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1425,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1425,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1425,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1425,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1425,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1425,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1425,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:37',0,1),
(1425,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1425,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1425,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1425,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1425,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1425,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1425,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1425,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1425,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1425,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1425,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1425,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1431,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:37',0,1),
(1431,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:37',0,1),
(1431,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1431,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:37',0,1),
(1431,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1431,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1431,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1431,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1431,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1431,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1431,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1431,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1431,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1431,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1431,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:37',0,1),
(1431,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1431,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1431,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1431,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1431,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1431,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1431,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1431,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1431,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1431,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1431,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1431,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1437,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:37',0,1),
(1437,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:37',0,1),
(1437,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:37',0,1),
(1437,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:37',0,1),
(1437,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:37',0,1),
(1437,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:37',0,1),
(1437,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:37',0,1),
(1437,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:37',0,1),
(1437,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:37',0,1),
(1437,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:37',0,1),
(1437,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:37',0,1),
(1437,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:37',0,1),
(1437,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:37',0,1),
(1437,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:37',0,1),
(1437,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:37',0,1),
(1437,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:37',0,1),
(1437,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:37',0,1),
(1437,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:37',0,1),
(1437,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:37',0,1),
(1437,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:37',0,1),
(1437,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:37',0,1),
(1437,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:37',0,1),
(1437,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:37',0,1),
(1437,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:37',0,1),
(1437,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:37',0,1),
(1437,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:37',0,1),
(1437,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:37',0,1),
(1443,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1443,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:38',0,1),
(1443,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1443,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1443,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1443,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1443,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1443,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1443,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1443,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1443,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1443,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1443,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1443,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1443,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1443,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1443,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:38',0,1),
(1443,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1443,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1443,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1443,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1443,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1443,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1443,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1443,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1443,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1443,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1449,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1449,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:38',0,1),
(1449,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1449,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1449,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1449,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1449,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1449,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1449,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1449,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1449,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1449,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1449,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1449,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1449,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1449,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1449,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:38',0,1),
(1449,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1449,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1449,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1449,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1449,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1449,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1449,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1449,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1449,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1449,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1455,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1455,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:38',0,1),
(1455,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1455,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1455,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1455,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1455,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1455,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1455,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1455,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1455,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1455,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1455,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1455,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1455,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1455,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1455,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:38',0,1),
(1455,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1455,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1455,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1455,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1455,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1455,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1455,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1455,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1455,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1455,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1461,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1461,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:38',0,1),
(1461,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1461,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1461,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1461,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1461,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1461,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1461,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1461,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1461,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1461,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1461,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1461,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1461,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1461,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1461,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:38',0,1),
(1461,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1461,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1461,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1461,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1461,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1461,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1461,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1461,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1461,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1461,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1467,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1467,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:38',0,1),
(1467,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1467,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1467,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1467,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1467,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1467,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1467,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1467,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1467,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1467,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1467,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1467,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1467,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1467,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1467,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:38',0,1),
(1467,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1467,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1467,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1467,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1467,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1467,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1467,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1467,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1467,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1467,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1473,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1473,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:38',0,1),
(1473,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1473,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1473,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1473,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1473,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1473,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1473,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1473,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1473,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1473,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1473,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1473,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1473,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1473,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1473,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:38',0,1),
(1473,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1473,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1473,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1473,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1473,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1473,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1473,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1473,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1473,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1473,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1477,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1477,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-11 20:39:38',0,1),
(1477,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1477,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1477,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1477,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1477,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1477,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1477,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1477,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1477,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1477,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1477,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1477,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1477,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1477,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1477,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:38',0,1),
(1477,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1477,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1477,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1477,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1477,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1477,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1477,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1477,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1477,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1477,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1481,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-11 20:39:38',0,1),
(1481,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-24 16:04:13',0,1),
(1481,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-11 20:39:38',0,1),
(1481,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-11 20:39:38',0,1),
(1481,1,7,'482ad396-5443-4761-a410-c644d0217e5a','2025-09-11 20:39:38',0,1),
(1481,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-09-11 20:39:38',0,1),
(1481,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-09-11 20:39:38',0,1),
(1481,1,12,'688e0d64-8999-47be-a427-f9e9c6e1789e','2025-09-11 20:39:38',0,1),
(1481,1,13,'92b514e7-6c85-40f3-9885-4ed4138887ea','2025-09-11 20:39:38',0,1),
(1481,1,15,'559340ef-728e-4935-84cc-443bd407f901','2025-09-11 20:39:38',0,1),
(1481,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-09-11 20:39:38',0,1),
(1481,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-11 20:39:38',0,1),
(1481,1,32,'0be5b641-0a34-4d93-8816-9a4b1ad24ffd','2025-09-11 20:39:38',0,1),
(1481,1,33,'cced3c80-6988-403a-9b5a-14455350e923','2025-09-11 20:39:38',0,1),
(1481,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-11 20:39:38',0,1),
(1481,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-11 20:39:38',0,1),
(1481,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-09-11 20:39:38',0,1),
(1481,1,46,'f352e58c-d152-4a45-9615-d0526b009523','2025-09-11 20:39:38',0,1),
(1481,1,47,'a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f','2025-09-11 20:39:38',0,1),
(1481,1,48,'403d1895-f32e-4164-8084-b11fdea310cb','2025-09-11 20:39:38',0,1),
(1481,1,49,'5e40a449-23c9-418a-a0d6-36ff8f57583d','2025-09-11 20:39:38',0,1),
(1481,1,50,'8e701860-42c4-437f-a61c-a48f2ecf1b99','2025-09-11 20:39:38',0,1),
(1481,1,55,'5b9eeabd-1ace-4610-b19d-ef257949824b','2025-09-11 20:39:38',0,1),
(1481,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-09-11 20:39:38',0,1),
(1481,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-09-11 20:39:38',0,1),
(1481,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-11 20:39:38',0,1),
(1481,1,60,'b46c7894-3c01-4cc4-b90f-9612b3b9891b','2025-09-11 20:39:38',0,1),
(1486,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-09-17 19:37:16',0,1),
(1487,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-09-17 19:37:16',0,1),
(1499,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-08 22:21:46',0,1),
(1504,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 18:43:12',0,1),
(1504,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-08 18:43:12',0,1),
(1504,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-08 18:43:12',0,1),
(1505,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 18:43:12',0,1),
(1509,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 18:52:55',0,1),
(1509,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-08 18:52:55',0,1),
(1510,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 18:52:55',0,1),
(1510,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-08 18:52:55',0,1),
(1514,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 19:00:47',0,1),
(1514,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-08 19:00:47',0,1),
(1515,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 19:00:47',0,1),
(1519,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 19:59:16',0,1),
(1519,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-08 19:59:16',0,1),
(1520,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 19:59:16',0,1),
(1520,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-08 19:59:16',0,1),
(1525,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 20:25:58',0,1),
(1525,1,43,'6859b0cf-ccd8-409d-84f9-b76fcac3eda0','2025-10-08 20:25:58',0,1),
(1526,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 20:25:58',0,1),
(1526,1,22,'50d484f9-ea00-4870-8b7a-a1c7400f42ab','2025-10-08 20:25:58',0,1),
(1835,1,20,'2b573339-79e1-4bb1-82cf-7c0dfabcab22','2025-10-08 22:38:45',0,1),
(1835,1,21,'579071f5-918a-4d7a-8c5b-98905ecbe548','2025-10-08 22:38:45',0,1),
(2519,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:52:27',0,1),
(2519,1,35,'6507c83d-4852-4bbd-9fee-2e10673e660b','2025-09-19 17:27:31',0,1),
(2519,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 17:25:45',0,1),
(2519,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-24 19:41:47',0,1),
(2519,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 17:26:58',0,1),
(2523,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:52:18',0,1),
(2523,1,35,'6507c83d-4852-4bbd-9fee-2e10673e660b','2025-09-19 17:29:09',0,1),
(2523,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 17:29:06',0,1),
(2523,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-24 17:20:23',0,1),
(2523,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 17:29:35',0,1),
(2527,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:52:10',0,1),
(2527,1,35,'6507c83d-4852-4bbd-9fee-2e10673e660b','2025-09-19 17:30:21',0,1),
(2527,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 17:30:27',0,1),
(2527,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-24 17:20:14',0,1),
(2527,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 17:31:59',0,1),
(2531,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:51:56',0,1),
(2531,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 17:34:50',0,1),
(2531,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-30 19:28:07',0,1),
(2531,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 17:34:51',0,1),
(2535,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:51:46',0,1),
(2535,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 17:35:04',0,1),
(2535,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-24 17:19:43',0,1),
(2535,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 17:35:48',0,1),
(2537,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:51:30',0,1),
(2537,1,35,'6507c83d-4852-4bbd-9fee-2e10673e660b','2025-09-19 18:51:30',0,1),
(2537,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 17:37:56',0,1),
(2537,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-24 17:19:53',0,1),
(2537,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 17:38:14',0,1),
(2590,1,34,'bd5a1d46-6844-4735-ad59-9d17e566aa16','2025-09-19 18:53:01',0,1),
(2590,1,35,'6507c83d-4852-4bbd-9fee-2e10673e660b','2025-09-19 18:52:59',0,1),
(2590,1,36,'909d57b4-6b9f-42fb-8e21-bd64fb6371e6','2025-09-19 18:52:51',0,1),
(2590,1,37,'aceb4af7-e092-4894-a59a-eafca28db8e2','2025-09-19 18:57:59',0,1),
(2590,1,38,'3bd7f129-28a9-4a77-8dac-a592f11fdf61','2025-09-19 18:52:51',0,1),
(2590,1,61,'b7de2ec4-9407-4c88-8439-eecd0bc52d8a','2025-09-19 18:52:42',0,1),
(2590,1,62,'479ed735-51b9-4c23-9872-4e95d2914634','2025-09-19 19:15:03',0,1),
(2712,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:32:26',0,1),
(2712,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-06 16:10:00',0,1),
(2712,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-22 18:32:59',0,1),
(2712,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:33:47',0,1),
(2712,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-22 18:33:03',0,1),
(2712,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:32:29',0,1),
(2712,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-22 18:32:35',0,1),
(2712,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-22 18:36:55',0,1),
(2720,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-22 18:34:22',0,1),
(2720,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 22:20:23',0,1),
(2720,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-22 18:35:24',0,1),
(2720,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-22 18:36:12',0,1),
(2720,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-22 18:36:20',0,1),
(2720,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-22 18:34:24',0,1),
(2720,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-22 18:34:29',0,1),
(2720,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-22 18:34:34',0,1),
(2785,1,66,'681970c0-9b7f-4dae-90d9-2db13d19dc70','2025-09-30 22:22:13',0,1),
(2785,1,67,'9cec38eb-79ed-49c5-91bc-20226553bedd','2025-09-30 22:22:13',0,1),
(2786,1,66,'681970c0-9b7f-4dae-90d9-2db13d19dc70','2025-09-30 22:22:24',0,1),
(2786,1,67,'9cec38eb-79ed-49c5-91bc-20226553bedd','2025-09-30 22:22:24',0,1),
(2787,1,66,'681970c0-9b7f-4dae-90d9-2db13d19dc70','2025-09-30 22:22:37',0,1),
(2791,1,67,'9cec38eb-79ed-49c5-91bc-20226553bedd','2025-09-30 22:41:39',0,1),
(2791,1,68,'4fdb89f2-25d0-447f-acfa-ae9e099b1ec0','2025-09-30 22:41:39',0,1),
(2793,1,66,'681970c0-9b7f-4dae-90d9-2db13d19dc70','2025-09-30 22:45:18',0,1),
(2812,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-23 21:56:41',0,1),
(2812,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-23 21:56:41',0,1),
(2813,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-23 21:56:57',0,1),
(2813,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-23 21:56:57',0,1),
(2814,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-23 21:57:09',0,1),
(2814,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-23 21:57:06',0,1),
(2815,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-23 21:57:19',0,1),
(2815,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-23 21:57:19',0,1),
(2816,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-23 21:57:28',0,1),
(2816,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-23 21:57:28',0,1),
(2817,1,23,'ffdd5871-4e4c-4e46-88b5-06b52502357e','2025-09-23 21:57:37',0,1),
(2817,1,24,'1e69e1f4-c7b2-4468-8668-aa722b6f7163','2025-09-23 21:57:37',0,1),
(2880,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-24 23:06:35',0,1),
(2880,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-08 22:35:47',0,1),
(2880,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-24 23:07:17',0,1),
(2880,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-24 23:07:59',0,1),
(2880,1,9,'ab57cfd4-5e19-423b-b570-4e770a56e436','2025-10-08 22:34:45',0,1),
(2880,1,10,'7ed7a1dc-2e02-42e1-9349-7e518fe2a973','2025-10-08 22:33:45',0,1),
(2880,1,16,'10d5be16-947c-4646-b2d0-3619f2760ace','2025-10-08 22:33:18',0,1),
(2880,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-24 23:06:38',0,1),
(2880,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-24 23:06:55',0,1),
(2880,1,44,'2c726802-f189-49e5-935d-af3557619590','2025-10-08 22:35:10',0,1),
(2880,1,56,'1183c802-1c51-4571-b5c9-c327cf3a5eab','2025-10-08 22:35:46',0,1),
(2880,1,57,'9a83aaf9-b86b-4272-88b0-1a3cd8eec119','2025-10-08 22:32:49',0,1),
(2880,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-24 23:07:28',0,1),
(2882,1,1,'075f1904-e0fc-49c8-9cfb-6990ae779dec','2025-09-24 23:08:25',0,1),
(2882,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-24 23:08:43',0,1),
(2882,1,3,'0d6389a7-9cd0-496d-96dd-72ebf02f7bbb','2025-09-24 23:08:55',0,1),
(2882,1,4,'3b262689-7127-4814-bab5-a1972e0869d4','2025-09-24 23:09:19',0,1),
(2882,1,31,'31a45631-ecd4-4327-aca7-18b9d213bb16','2025-09-24 23:09:14',0,1),
(2882,1,41,'7a0d2797-bfc8-4d68-b107-61c1dd081ea0','2025-09-24 23:08:27',0,1),
(2882,1,42,'19b0086c-bc10-46cc-9f45-ffc5746e8681','2025-09-24 23:08:29',0,1),
(2882,1,59,'0d799588-2604-4e16-86f6-6ee8c522fe72','2025-09-24 23:08:37',0,1),
(2923,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-09-29 19:07:48',0,1),
(2945,1,68,'4fdb89f2-25d0-447f-acfa-ae9e099b1ec0','2025-09-30 22:45:57',0,1),
(2957,1,2,'762be5f6-1f41-4b1a-a99f-0b59fb0cdddb','2025-10-02 19:26:42',0,1),
(2969,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-06 17:47:25',0,1),
(2969,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-06 17:46:00',0,1),
(2972,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 18:21:43',0,1),
(2972,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-06 17:46:35',0,1),
(2974,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-06 17:47:42',0,1),
(2974,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-06 17:46:58',0,1),
(3016,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 18:22:24',0,1),
(3025,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 18:35:20',0,1),
(3025,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-08 18:34:54',0,1),
(3027,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 18:36:11',0,1),
(3027,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-08 18:36:06',0,1),
(3091,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 18:55:22',0,1),
(3091,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-08 18:55:12',0,1),
(3093,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 18:55:50',0,1),
(3093,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-08 18:55:41',0,1),
(3123,1,27,'71d07053-43eb-40fe-8f9e-ad7480cc3193','2025-10-08 19:54:15',0,1),
(3123,1,58,'5e076972-0a7c-4184-8570-4b3688ebe3d8','2025-10-08 19:54:10',0,1);
/*!40000 ALTER TABLE `changedfields` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `contentblocks`
--

LOCK TABLES `contentblocks` WRITE;
/*!40000 ALTER TABLE `contentblocks` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `contentblocks` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `craftidtokens`
--

LOCK TABLES `craftidtokens` WRITE;
/*!40000 ALTER TABLE `craftidtokens` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `craftidtokens` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `deprecationerrors`
--

LOCK TABLES `deprecationerrors` WRITE;
/*!40000 ALTER TABLE `deprecationerrors` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `deprecationerrors` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `drafts`
--

LOCK TABLES `drafts` WRITE;
/*!40000 ALTER TABLE `drafts` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `drafts` VALUES
(7,NULL,1,0,'First draft',NULL,0,NULL,0),
(52,NULL,1,0,'First draft',NULL,0,NULL,0),
(96,NULL,1,0,'First draft',NULL,0,NULL,0),
(137,NULL,1,0,'First draft',NULL,0,NULL,0),
(224,NULL,1,0,'First draft',NULL,0,NULL,0),
(280,NULL,1,0,'First draft',NULL,0,NULL,0),
(437,NULL,1,0,'First draft',NULL,0,NULL,0),
(438,NULL,1,0,'First draft',NULL,0,NULL,0),
(439,NULL,1,0,'First draft',NULL,0,NULL,0),
(440,NULL,1,0,'First draft',NULL,0,NULL,0),
(441,NULL,1,0,'First draft',NULL,0,NULL,0),
(442,NULL,1,0,'First draft',NULL,0,NULL,0),
(443,NULL,1,0,'First draft',NULL,0,NULL,0),
(554,NULL,1,0,'First draft',NULL,0,NULL,0),
(628,1289,1,1,'Draft 1','',1,NULL,1),
(645,1437,1,1,'Draft 1','',1,NULL,1),
(664,NULL,1,0,'First draft',NULL,0,NULL,0),
(668,NULL,1,0,'First draft',NULL,0,NULL,0),
(670,NULL,1,0,'First draft',NULL,0,NULL,0),
(671,NULL,1,0,'First draft','',0,NULL,1),
(672,NULL,1,0,'First draft',NULL,0,NULL,0),
(776,NULL,1,0,'First draft',NULL,0,NULL,0);
/*!40000 ALTER TABLE `drafts` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elementactivity`
--

LOCK TABLES `elementactivity` WRITE;
/*!40000 ALTER TABLE `elementactivity` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elementactivity` VALUES
(2,1,1,NULL,'edit','2025-10-08 22:20:10'),
(2,1,1,NULL,'save','2025-10-08 22:20:12'),
(18,1,1,NULL,'save','2025-04-18 18:06:50'),
(20,1,1,NULL,'save','2025-04-18 18:06:58'),
(22,1,1,NULL,'save','2025-04-18 18:07:06'),
(24,1,1,NULL,'save','2025-04-18 18:07:32'),
(26,1,1,NULL,'save','2025-04-18 18:07:37'),
(28,1,1,NULL,'save','2025-04-18 18:07:43'),
(30,1,1,NULL,'save','2025-04-18 18:07:48'),
(32,1,1,NULL,'save','2025-04-18 18:07:53'),
(34,1,1,NULL,'save','2025-04-18 18:08:00'),
(36,1,1,NULL,'edit','2025-08-20 21:57:06'),
(36,1,1,NULL,'save','2025-08-20 21:57:06'),
(44,1,1,NULL,'edit','2025-09-03 22:27:13'),
(56,1,1,NULL,'edit','2025-09-03 21:05:06'),
(57,1,1,NULL,'edit','2025-09-03 21:05:21'),
(63,1,1,NULL,'edit','2025-09-03 21:08:03'),
(63,1,1,NULL,'save','2025-09-03 21:05:57'),
(111,1,1,NULL,'save','2025-04-18 18:38:40'),
(113,1,1,NULL,'save','2025-04-18 18:38:46'),
(115,1,1,NULL,'save','2025-04-18 18:38:51'),
(117,1,1,NULL,'save','2025-04-18 18:38:56'),
(119,1,1,NULL,'save','2025-04-18 18:39:00'),
(121,1,1,NULL,'save','2025-04-18 18:39:04'),
(283,1,1,NULL,'edit','2025-07-30 22:48:01'),
(283,1,1,NULL,'save','2025-07-30 23:10:37'),
(288,1,1,NULL,'edit','2025-07-30 23:10:31'),
(288,1,1,NULL,'save','2025-07-30 23:10:31'),
(290,1,1,NULL,'edit','2025-07-30 22:58:05'),
(290,1,1,NULL,'save','2025-07-30 23:11:03'),
(292,1,1,NULL,'edit','2025-07-30 23:10:54'),
(292,1,1,NULL,'save','2025-07-30 23:10:55'),
(294,1,1,NULL,'edit','2025-09-05 20:01:25'),
(294,1,1,NULL,'save','2025-09-05 20:01:55'),
(296,1,1,NULL,'edit','2025-07-30 23:11:18'),
(296,1,1,NULL,'save','2025-07-30 23:11:31'),
(323,1,1,NULL,'save','2025-08-01 17:59:31'),
(325,1,1,NULL,'edit','2025-09-18 19:12:04'),
(325,1,1,NULL,'save','2025-08-01 18:06:11'),
(329,1,1,NULL,'save','2025-08-01 18:04:57'),
(331,1,1,NULL,'save','2025-08-01 18:05:01'),
(333,1,1,NULL,'save','2025-08-01 18:05:04'),
(335,1,1,NULL,'save','2025-08-01 18:05:08'),
(337,1,1,NULL,'save','2025-08-01 18:05:10'),
(339,1,1,NULL,'save','2025-08-01 18:05:15'),
(341,1,1,NULL,'save','2025-08-01 18:05:18'),
(343,1,1,NULL,'save','2025-08-01 18:05:21'),
(348,1,1,NULL,'save','2025-08-01 18:06:22'),
(350,1,1,NULL,'save','2025-08-01 18:06:40'),
(352,1,1,NULL,'save','2025-08-01 18:07:25'),
(354,1,1,NULL,'save','2025-08-01 18:07:35'),
(356,1,1,NULL,'save','2025-08-01 18:07:48'),
(358,1,1,NULL,'save','2025-08-01 18:07:58'),
(360,1,1,NULL,'save','2025-08-01 18:08:08'),
(362,1,1,NULL,'save','2025-08-01 18:08:17'),
(364,1,1,NULL,'save','2025-08-01 18:08:31'),
(366,1,1,NULL,'save','2025-08-01 18:09:02'),
(368,1,1,NULL,'save','2025-08-01 18:09:12'),
(370,1,1,NULL,'save','2025-08-01 18:09:33'),
(372,1,1,NULL,'save','2025-08-01 18:09:44'),
(374,1,1,NULL,'save','2025-08-01 18:10:00'),
(376,1,1,NULL,'save','2025-08-01 18:10:07'),
(378,1,1,NULL,'save','2025-08-01 18:10:18'),
(380,1,1,NULL,'save','2025-08-01 18:10:31'),
(382,1,1,NULL,'save','2025-08-01 18:10:53'),
(384,1,1,NULL,'save','2025-08-01 18:11:04'),
(386,1,1,NULL,'save','2025-08-01 18:11:17'),
(388,1,1,NULL,'save','2025-08-01 18:11:31'),
(390,1,1,NULL,'save','2025-08-01 18:11:48'),
(392,1,1,NULL,'save','2025-08-01 18:12:02'),
(394,1,1,NULL,'save','2025-08-01 18:12:14'),
(396,1,1,NULL,'save','2025-08-01 18:12:26'),
(398,1,1,NULL,'save','2025-08-01 18:12:34'),
(400,1,1,NULL,'save','2025-08-01 18:12:57'),
(402,1,1,NULL,'save','2025-08-01 18:13:07'),
(404,1,1,NULL,'save','2025-08-01 18:13:20'),
(406,1,1,NULL,'save','2025-08-01 18:13:33'),
(408,1,1,NULL,'save','2025-08-01 18:13:42'),
(410,1,1,NULL,'save','2025-08-01 18:13:53'),
(412,1,1,NULL,'save','2025-08-01 18:14:03'),
(414,1,1,NULL,'save','2025-08-01 18:14:13'),
(445,1,1,NULL,'edit','2025-09-03 22:27:27'),
(453,1,1,NULL,'save','2025-08-20 21:57:20'),
(455,1,1,NULL,'save','2025-08-20 21:57:32'),
(457,1,1,NULL,'edit','2025-09-23 20:25:30'),
(457,1,1,NULL,'save','2025-09-23 20:25:31'),
(459,1,1,NULL,'edit','2025-09-23 21:13:17'),
(459,1,1,NULL,'save','2025-09-23 21:13:19'),
(461,1,1,NULL,'save','2025-09-23 20:25:25'),
(463,1,1,NULL,'edit','2025-09-23 20:25:36'),
(463,1,1,NULL,'save','2025-09-23 20:25:37'),
(465,1,1,NULL,'edit','2025-09-23 21:13:37'),
(465,1,1,NULL,'save','2025-09-23 21:13:37'),
(467,1,1,NULL,'save','2025-09-23 20:25:55'),
(469,1,1,NULL,'edit','2025-09-23 20:26:04'),
(469,1,1,NULL,'save','2025-09-23 20:26:04'),
(471,1,1,NULL,'save','2025-09-23 20:26:11'),
(473,1,1,NULL,'save','2025-08-20 22:00:22'),
(475,1,1,NULL,'edit','2025-09-23 20:26:26'),
(475,1,1,NULL,'save','2025-09-23 20:26:26'),
(477,1,1,NULL,'save','2025-09-23 20:26:34'),
(479,1,1,NULL,'save','2025-09-23 20:26:42'),
(481,1,1,NULL,'edit','2025-09-23 20:26:53'),
(481,1,1,NULL,'save','2025-09-23 20:26:54'),
(483,1,1,NULL,'edit','2025-09-23 20:27:03'),
(483,1,1,NULL,'save','2025-09-23 20:27:03'),
(485,1,1,NULL,'save','2025-09-23 20:27:13'),
(487,1,1,NULL,'edit','2025-09-23 21:13:49'),
(487,1,1,NULL,'save','2025-09-23 21:13:50'),
(489,1,1,NULL,'edit','2025-09-23 20:29:09'),
(489,1,1,NULL,'save','2025-09-23 20:29:09'),
(491,1,1,NULL,'save','2025-09-23 20:29:17'),
(493,1,1,NULL,'save','2025-09-23 20:29:24'),
(495,1,1,NULL,'edit','2025-09-23 20:29:37'),
(495,1,1,NULL,'save','2025-09-23 20:29:38'),
(497,1,1,NULL,'edit','2025-09-23 21:13:43'),
(497,1,1,NULL,'save','2025-09-23 21:13:43'),
(499,1,1,NULL,'save','2025-08-20 22:12:23'),
(501,1,1,NULL,'save','2025-08-20 22:12:28'),
(503,1,1,NULL,'save','2025-08-20 22:12:34'),
(506,1,1,NULL,'save','2025-08-20 22:12:50'),
(508,1,1,NULL,'save','2025-08-20 22:12:54'),
(510,1,1,NULL,'save','2025-08-20 22:12:57'),
(512,1,1,NULL,'save','2025-08-20 22:13:01'),
(514,1,1,NULL,'save','2025-08-20 22:13:04'),
(516,1,1,NULL,'save','2025-08-20 22:13:07'),
(518,1,1,NULL,'save','2025-08-20 22:13:10'),
(520,1,1,NULL,'save','2025-08-20 22:13:13'),
(522,1,1,NULL,'save','2025-08-20 22:13:15'),
(524,1,1,NULL,'save','2025-08-20 22:13:18'),
(530,1,1,NULL,'save','2025-08-20 22:17:46'),
(532,1,1,NULL,'save','2025-08-20 22:18:02'),
(534,1,1,NULL,'save','2025-08-20 22:18:29'),
(555,1,1,NULL,'save','2025-09-02 22:24:46'),
(557,1,1,NULL,'save','2025-09-02 22:24:52'),
(559,1,1,NULL,'save','2025-09-02 22:24:59'),
(561,1,1,NULL,'save','2025-09-02 22:25:02'),
(563,1,1,NULL,'save','2025-09-02 22:25:06'),
(601,1,1,NULL,'edit','2025-10-03 20:24:29'),
(601,1,1,NULL,'save','2025-10-03 20:24:31'),
(603,1,1,NULL,'save','2025-09-03 21:48:45'),
(605,1,1,NULL,'edit','2025-10-03 20:24:40'),
(605,1,1,NULL,'save','2025-10-03 20:24:40'),
(614,1,1,NULL,'save','2025-10-08 18:25:13'),
(617,1,1,NULL,'edit','2025-10-03 20:24:49'),
(617,1,1,NULL,'save','2025-10-03 20:24:49'),
(945,1,1,NULL,'edit','2025-10-06 17:52:06'),
(945,1,1,NULL,'save','2025-10-08 22:19:59'),
(951,1,1,NULL,'edit','2025-10-08 22:29:33'),
(951,1,1,NULL,'save','2025-10-08 22:29:34'),
(957,1,1,NULL,'edit','2025-10-08 18:44:15'),
(957,1,1,NULL,'save','2025-10-08 22:20:19'),
(963,1,1,NULL,'edit','2025-10-08 18:51:33'),
(963,1,1,NULL,'save','2025-10-08 18:52:55'),
(969,1,1,NULL,'edit','2025-10-08 19:00:34'),
(969,1,1,NULL,'save','2025-10-08 19:00:47'),
(975,1,1,NULL,'edit','2025-10-08 19:59:13'),
(975,1,1,NULL,'save','2025-10-08 19:59:16'),
(981,1,1,NULL,'edit','2025-10-08 20:26:00'),
(981,1,1,NULL,'save','2025-10-08 20:26:01'),
(989,1,1,NULL,'edit','2025-09-11 19:09:55'),
(989,1,1,NULL,'save','2025-09-11 19:09:56'),
(995,1,1,NULL,'edit','2025-09-11 19:10:15'),
(995,1,1,NULL,'save','2025-09-11 19:10:16'),
(999,1,1,NULL,'edit','2025-09-11 19:24:29'),
(999,1,1,NULL,'save','2025-09-11 19:24:30'),
(1005,1,1,NULL,'edit','2025-09-11 19:13:08'),
(1005,1,1,NULL,'save','2025-09-11 19:13:09'),
(1011,1,1,NULL,'edit','2025-09-11 19:14:51'),
(1011,1,1,NULL,'save','2025-09-11 19:14:55'),
(1017,1,1,NULL,'edit','2025-09-11 19:23:58'),
(1017,1,1,NULL,'save','2025-09-11 19:23:59'),
(1023,1,1,NULL,'edit','2025-09-11 19:23:45'),
(1023,1,1,NULL,'save','2025-09-11 19:23:46'),
(1031,1,1,NULL,'edit','2025-09-11 19:20:07'),
(1031,1,1,NULL,'save','2025-09-11 19:20:11'),
(1035,1,1,NULL,'edit','2025-09-11 19:20:47'),
(1035,1,1,NULL,'save','2025-09-11 19:20:48'),
(1041,1,1,NULL,'edit','2025-09-11 19:20:56'),
(1041,1,1,NULL,'save','2025-09-11 19:20:57'),
(1045,1,1,NULL,'edit','2025-10-06 16:09:46'),
(1045,1,1,NULL,'save','2025-10-06 16:09:49'),
(1051,1,1,NULL,'edit','2025-09-11 19:02:11'),
(1051,1,1,NULL,'save','2025-09-11 19:02:12'),
(1059,1,1,NULL,'edit','2025-09-22 18:42:29'),
(1059,1,1,NULL,'save','2025-09-22 18:42:30'),
(1067,1,1,NULL,'edit','2025-09-11 19:05:26'),
(1067,1,1,NULL,'save','2025-09-11 19:05:28'),
(1073,1,1,NULL,'edit','2025-09-11 19:08:30'),
(1073,1,1,NULL,'save','2025-09-11 19:08:31'),
(1079,1,1,NULL,'edit','2025-09-11 19:10:40'),
(1079,1,1,NULL,'save','2025-09-11 19:10:45'),
(1085,1,1,NULL,'edit','2025-09-11 19:13:53'),
(1085,1,1,NULL,'save','2025-09-11 19:13:54'),
(1091,1,1,NULL,'edit','2025-09-11 19:15:06'),
(1091,1,1,NULL,'save','2025-09-11 19:15:07'),
(1097,1,1,NULL,'edit','2025-09-11 19:15:37'),
(1097,1,1,NULL,'save','2025-09-11 19:15:41'),
(1103,1,1,NULL,'edit','2025-09-11 19:15:57'),
(1103,1,1,NULL,'save','2025-09-11 19:15:58'),
(1109,1,1,NULL,'edit','2025-09-11 19:23:25'),
(1109,1,1,NULL,'save','2025-09-11 19:23:27'),
(1117,1,1,NULL,'edit','2025-09-11 19:23:16'),
(1117,1,1,NULL,'save','2025-09-11 19:23:17'),
(1123,1,1,NULL,'edit','2025-09-11 19:21:16'),
(1123,1,1,NULL,'save','2025-09-11 19:21:17'),
(1129,1,1,NULL,'edit','2025-09-11 19:21:24'),
(1129,1,1,NULL,'save','2025-09-11 19:21:27'),
(1135,1,1,NULL,'edit','2025-09-11 19:21:44'),
(1135,1,1,NULL,'save','2025-09-11 19:21:45'),
(1141,1,1,NULL,'edit','2025-09-11 19:22:00'),
(1141,1,1,NULL,'save','2025-09-11 19:22:03'),
(1143,1,1,NULL,'edit','2025-09-11 19:22:41'),
(1143,1,1,NULL,'save','2025-09-11 19:22:43'),
(1149,1,1,NULL,'edit','2025-09-11 19:17:41'),
(1149,1,1,NULL,'save','2025-09-11 19:17:42'),
(1155,1,1,NULL,'edit','2025-09-11 19:17:54'),
(1155,1,1,NULL,'save','2025-09-11 19:17:58'),
(1161,1,1,NULL,'edit','2025-09-11 19:49:40'),
(1161,1,1,NULL,'save','2025-09-11 19:52:35'),
(1165,1,1,NULL,'edit','2025-10-08 22:20:15'),
(1165,1,1,NULL,'save','2025-10-08 22:20:15'),
(1171,1,1,NULL,'edit','2025-09-24 14:01:59'),
(1171,1,1,NULL,'save','2025-09-24 15:56:11'),
(1177,1,1,NULL,'edit','2025-09-29 18:35:54'),
(1177,1,1,NULL,'save','2025-09-29 18:35:55'),
(1185,1,1,NULL,'edit','2025-09-11 19:35:09'),
(1185,1,1,NULL,'save','2025-09-11 19:35:10'),
(1191,1,1,NULL,'edit','2025-09-11 19:35:29'),
(1191,1,1,NULL,'save','2025-09-11 19:35:30'),
(1197,1,1,NULL,'edit','2025-09-11 19:35:50'),
(1197,1,1,NULL,'save','2025-09-11 19:35:51'),
(1201,1,1,NULL,'edit','2025-09-11 19:35:57'),
(1201,1,1,NULL,'save','2025-09-11 19:35:58'),
(1209,1,1,NULL,'edit','2025-09-11 19:36:44'),
(1209,1,1,NULL,'save','2025-09-11 19:36:45'),
(1215,1,1,NULL,'edit','2025-09-11 19:09:03'),
(1215,1,1,NULL,'save','2025-09-11 19:37:16'),
(1219,1,1,NULL,'edit','2025-09-11 19:10:31'),
(1219,1,1,NULL,'save','2025-09-11 19:10:32'),
(1225,1,1,NULL,'edit','2025-09-11 19:12:52'),
(1225,1,1,NULL,'save','2025-09-11 19:12:57'),
(1231,1,1,NULL,'edit','2025-09-11 19:37:37'),
(1231,1,1,NULL,'save','2025-09-11 19:37:38'),
(1237,1,1,NULL,'edit','2025-09-11 19:16:10'),
(1237,1,1,NULL,'save','2025-09-11 19:16:11'),
(1243,1,1,NULL,'edit','2025-09-11 19:17:03'),
(1243,1,1,NULL,'save','2025-09-11 19:17:03'),
(1249,1,1,NULL,'edit','2025-09-11 19:21:05'),
(1249,1,1,NULL,'save','2025-09-11 19:21:06'),
(1255,1,1,NULL,'edit','2025-10-08 22:20:04'),
(1255,1,1,NULL,'save','2025-10-08 22:20:05'),
(1261,1,1,NULL,'edit','2025-09-11 19:34:51'),
(1261,1,1,NULL,'save','2025-09-11 19:34:52'),
(1269,1,1,NULL,'edit','2025-09-11 19:03:20'),
(1269,1,1,NULL,'save','2025-09-11 19:03:21'),
(1277,1,1,NULL,'edit','2025-09-11 19:35:23'),
(1277,1,1,NULL,'save','2025-09-11 19:35:24'),
(1283,1,1,NULL,'edit','2025-09-22 18:33:26'),
(1283,1,1,NULL,'save','2025-09-22 18:42:35'),
(1289,1,1,NULL,'edit','2025-09-29 19:07:48'),
(1289,1,1,NULL,'save','2025-09-11 19:36:53'),
(1297,1,1,NULL,'edit','2025-09-11 19:36:59'),
(1297,1,1,NULL,'save','2025-09-11 19:37:00'),
(1303,1,1,NULL,'edit','2025-09-11 19:37:07'),
(1303,1,1,NULL,'save','2025-09-11 19:37:09'),
(1309,1,1,NULL,'edit','2025-09-11 19:36:24'),
(1309,1,1,NULL,'save','2025-09-11 19:36:26'),
(1315,1,1,NULL,'edit','2025-09-11 19:13:19'),
(1315,1,1,NULL,'save','2025-09-11 19:13:20'),
(1323,1,1,NULL,'edit','2025-09-11 19:14:24'),
(1323,1,1,NULL,'save','2025-09-11 19:14:25'),
(1329,1,1,NULL,'edit','2025-09-11 19:18:24'),
(1329,1,1,NULL,'save','2025-09-11 19:18:25'),
(1337,1,1,NULL,'edit','2025-09-11 19:18:54'),
(1337,1,1,NULL,'save','2025-09-11 19:18:55'),
(1343,1,1,NULL,'edit','2025-09-11 19:19:19'),
(1343,1,1,NULL,'save','2025-09-11 19:19:20'),
(1349,1,1,NULL,'edit','2025-09-11 19:21:35'),
(1349,1,1,NULL,'save','2025-09-11 19:21:37'),
(1353,1,1,NULL,'edit','2025-10-08 22:41:34'),
(1353,1,1,NULL,'save','2025-10-08 22:41:35'),
(1359,1,1,NULL,'edit','2025-09-22 18:20:31'),
(1359,1,1,NULL,'save','2025-09-22 18:20:33'),
(1365,1,1,NULL,'edit','2025-09-22 18:10:45'),
(1365,1,1,NULL,'save','2025-09-22 18:20:52'),
(1371,1,1,NULL,'edit','2025-09-22 18:21:33'),
(1371,1,1,NULL,'save','2025-09-22 18:21:35'),
(1377,1,1,NULL,'edit','2025-09-22 18:22:05'),
(1377,1,1,NULL,'save','2025-09-22 18:22:06'),
(1383,1,1,NULL,'edit','2025-09-22 18:22:44'),
(1383,1,1,NULL,'save','2025-09-22 18:22:45'),
(1389,1,1,NULL,'edit','2025-09-22 18:23:00'),
(1389,1,1,NULL,'save','2025-09-22 18:23:02'),
(1395,1,1,NULL,'edit','2025-09-29 18:59:00'),
(1395,1,1,NULL,'save','2025-09-29 18:59:03'),
(1401,1,1,NULL,'edit','2025-09-22 18:22:28'),
(1401,1,1,NULL,'save','2025-09-22 18:22:29'),
(1407,1,1,NULL,'edit','2025-09-22 18:23:22'),
(1407,1,1,NULL,'save','2025-09-22 18:23:24'),
(1413,1,1,NULL,'edit','2025-09-22 18:18:13'),
(1413,1,1,NULL,'save','2025-09-22 18:18:15'),
(1419,1,1,NULL,'edit','2025-09-11 19:04:21'),
(1419,1,1,NULL,'save','2025-09-11 19:04:21'),
(1425,1,1,NULL,'edit','2025-09-11 19:04:30'),
(1425,1,1,NULL,'save','2025-09-11 19:04:31'),
(1431,1,1,NULL,'edit','2025-09-11 19:35:44'),
(1431,1,1,NULL,'save','2025-09-11 19:35:45'),
(1437,1,1,NULL,'edit','2025-10-02 19:26:42'),
(1437,1,1,NULL,'save','2025-09-11 20:31:02'),
(1443,1,1,NULL,'edit','2025-09-11 19:36:37'),
(1443,1,1,NULL,'save','2025-09-11 19:36:38'),
(1449,1,1,NULL,'edit','2025-09-11 19:37:30'),
(1449,1,1,NULL,'save','2025-09-11 19:37:31'),
(1455,1,1,NULL,'edit','2025-09-11 19:09:36'),
(1455,1,1,NULL,'save','2025-09-11 19:09:37'),
(1461,1,1,NULL,'edit','2025-09-11 19:11:56'),
(1461,1,1,NULL,'save','2025-09-11 19:11:57'),
(1467,1,1,NULL,'edit','2025-09-11 19:12:27'),
(1467,1,1,NULL,'save','2025-09-11 19:12:28'),
(1473,1,1,NULL,'edit','2025-09-11 19:19:58'),
(1473,1,1,NULL,'save','2025-09-11 19:19:59'),
(1477,1,1,NULL,'edit','2025-09-11 19:11:02'),
(1477,1,1,NULL,'save','2025-09-11 19:11:04'),
(1481,1,1,NULL,'edit','2025-09-24 16:04:10'),
(1481,1,1,NULL,'save','2025-09-24 16:04:13'),
(1486,1,1,NULL,'edit','2025-09-17 19:37:14'),
(1487,1,1,NULL,'edit','2025-09-17 19:37:06'),
(1499,1,1,NULL,'edit','2025-10-08 22:21:40'),
(1504,1,1,NULL,'edit','2025-10-08 18:42:47'),
(1505,1,1,NULL,'edit','2025-10-08 18:43:08'),
(1509,1,1,NULL,'edit','2025-10-08 18:50:56'),
(1510,1,1,NULL,'edit','2025-10-08 18:51:33'),
(1510,1,1,NULL,'save','2025-10-08 18:51:43'),
(1514,1,1,NULL,'edit','2025-10-08 19:00:05'),
(1515,1,1,NULL,'edit','2025-10-08 19:00:34'),
(1519,1,1,NULL,'edit','2025-10-08 19:58:22'),
(1520,1,1,NULL,'edit','2025-10-08 19:59:12'),
(1525,1,1,NULL,'edit','2025-10-08 20:25:20'),
(1526,1,1,NULL,'edit','2025-10-08 20:25:49'),
(1835,1,1,NULL,'edit','2025-10-08 22:38:38'),
(2519,1,1,NULL,'edit','2025-09-24 19:41:46'),
(2519,1,1,NULL,'save','2025-09-24 19:41:47'),
(2523,1,1,NULL,'edit','2025-09-24 17:20:23'),
(2523,1,1,NULL,'save','2025-09-24 17:20:23'),
(2527,1,1,NULL,'edit','2025-09-24 17:20:13'),
(2527,1,1,NULL,'save','2025-09-24 17:20:14'),
(2531,1,1,NULL,'edit','2025-09-30 19:28:06'),
(2531,1,1,NULL,'save','2025-09-30 19:28:07'),
(2535,1,1,NULL,'edit','2025-09-24 17:19:42'),
(2535,1,1,NULL,'save','2025-09-24 17:19:43'),
(2537,1,1,NULL,'edit','2025-09-24 17:19:52'),
(2537,1,1,NULL,'save','2025-09-24 17:19:53'),
(2553,1,1,NULL,'save','2025-09-19 18:50:13'),
(2555,1,1,NULL,'save','2025-09-19 18:50:15'),
(2557,1,1,NULL,'save','2025-09-19 18:50:18'),
(2559,1,1,NULL,'save','2025-09-19 18:50:27'),
(2561,1,1,NULL,'save','2025-09-19 18:50:45'),
(2563,1,1,NULL,'save','2025-09-19 18:50:48'),
(2565,1,1,NULL,'save','2025-09-19 18:50:50'),
(2567,1,1,NULL,'save','2025-09-19 18:50:52'),
(2569,1,1,NULL,'save','2025-09-19 18:50:55'),
(2571,1,1,NULL,'save','2025-09-19 18:50:59'),
(2573,1,1,NULL,'save','2025-09-19 18:51:06'),
(2576,1,1,NULL,'save','2025-09-19 18:51:09'),
(2590,1,1,NULL,'edit','2025-09-19 19:15:01'),
(2590,1,1,NULL,'save','2025-09-19 19:15:03'),
(2596,1,1,NULL,'save','2025-09-19 19:06:52'),
(2598,1,1,NULL,'save','2025-09-19 19:06:57'),
(2600,1,1,NULL,'save','2025-09-19 19:07:03'),
(2602,1,1,NULL,'save','2025-09-19 19:07:09'),
(2604,1,1,NULL,'save','2025-09-19 19:07:13'),
(2606,1,1,NULL,'save','2025-09-19 19:07:17'),
(2608,1,1,NULL,'save','2025-09-19 19:07:23'),
(2610,1,1,NULL,'save','2025-09-19 19:07:27'),
(2612,1,1,NULL,'save','2025-09-19 19:07:36'),
(2614,1,1,NULL,'save','2025-09-19 19:07:44'),
(2616,1,1,NULL,'save','2025-09-19 19:07:47'),
(2618,1,1,NULL,'save','2025-09-19 19:07:49'),
(2620,1,1,NULL,'save','2025-09-19 19:07:53'),
(2622,1,1,NULL,'save','2025-09-24 16:01:26'),
(2624,1,1,NULL,'save','2025-09-19 19:07:59'),
(2712,1,1,NULL,'edit','2025-09-29 18:29:03'),
(2712,1,1,NULL,'save','2025-10-06 16:09:59'),
(2720,1,1,NULL,'edit','2025-10-08 22:20:23'),
(2720,1,1,NULL,'save','2025-10-08 22:20:23'),
(2740,1,1,NULL,'save','2025-09-22 20:42:41'),
(2785,1,1,NULL,'edit','2025-09-30 22:22:11'),
(2785,1,1,NULL,'save','2025-09-30 22:22:13'),
(2786,1,1,NULL,'edit','2025-09-30 22:22:22'),
(2786,1,1,NULL,'save','2025-09-30 22:22:24'),
(2787,1,1,NULL,'edit','2025-09-30 22:22:35'),
(2787,1,1,NULL,'save','2025-09-30 22:22:37'),
(2791,1,1,NULL,'edit','2025-09-30 22:41:21'),
(2791,1,1,NULL,'save','2025-09-30 22:41:25'),
(2792,1,1,NULL,'edit','2025-09-30 22:43:28'),
(2793,1,1,NULL,'edit','2025-09-30 22:46:09'),
(2800,1,1,NULL,'save','2025-09-23 21:22:49'),
(2803,1,1,NULL,'save','2025-09-23 21:22:40'),
(2806,1,1,NULL,'save','2025-09-23 21:22:33'),
(2809,1,1,NULL,'save','2025-09-23 21:22:25'),
(2812,1,1,NULL,'save','2025-09-23 21:56:42'),
(2813,1,1,NULL,'save','2025-09-23 21:56:57'),
(2814,1,1,NULL,'save','2025-09-23 21:57:09'),
(2815,1,1,NULL,'save','2025-09-23 21:57:19'),
(2816,1,1,NULL,'save','2025-09-23 21:57:28'),
(2817,1,1,NULL,'save','2025-09-23 21:57:37'),
(2873,1,1,NULL,'save','2025-10-08 18:24:25'),
(2874,1,1,NULL,'save','2025-10-08 18:29:50'),
(2880,1,1,NULL,'edit','2025-10-08 22:35:42'),
(2880,1,1,NULL,'save','2025-10-08 22:35:47'),
(2882,1,1,NULL,'save','2025-09-24 23:09:19'),
(2887,1,1,NULL,'save','2025-09-25 14:07:18'),
(2888,1,1,NULL,'save','2025-09-25 14:07:01'),
(2889,1,1,NULL,'save','2025-09-25 15:24:16'),
(2890,1,1,NULL,'save','2025-09-25 15:24:29'),
(2891,1,1,NULL,'save','2025-09-29 19:09:02'),
(2945,1,1,NULL,'edit','2025-09-30 22:45:55'),
(2968,1,1,NULL,'save','2025-10-06 17:45:01'),
(2969,1,1,NULL,'save','2025-10-06 17:47:25'),
(2970,1,1,NULL,'save','2025-10-08 18:24:15'),
(2972,1,1,NULL,'edit','2025-10-08 18:21:40'),
(2972,1,1,NULL,'save','2025-10-08 18:21:43'),
(2974,1,1,NULL,'save','2025-10-06 17:47:42'),
(3016,1,1,NULL,'save','2025-10-08 18:22:24'),
(3017,1,1,NULL,'save','2025-10-08 18:26:30'),
(3018,1,1,NULL,'save','2025-10-08 18:27:05'),
(3019,1,1,NULL,'save','2025-10-08 18:28:18'),
(3020,1,1,NULL,'save','2025-10-08 18:30:02'),
(3021,1,1,NULL,'save','2025-10-08 18:31:22'),
(3022,1,1,NULL,'save','2025-10-08 18:32:14'),
(3023,1,1,NULL,'save','2025-10-08 18:32:47'),
(3025,1,1,NULL,'save','2025-10-08 18:35:41'),
(3027,1,1,NULL,'save','2025-10-08 18:36:16'),
(3084,1,1,NULL,'save','2025-10-08 18:51:29'),
(3090,1,1,NULL,'save','2025-10-08 18:54:27'),
(3091,1,1,NULL,'save','2025-10-08 18:55:24'),
(3093,1,1,NULL,'save','2025-10-08 18:55:51'),
(3123,1,1,NULL,'save','2025-10-08 19:54:15'),
(3158,1,1,NULL,'save','2025-10-08 20:22:26'),
(3192,1,1,NULL,'save','2025-10-08 22:18:56'),
(3194,1,1,NULL,'save','2025-10-08 22:18:59'),
(3196,1,1,NULL,'save','2025-10-08 22:19:01'),
(3198,1,1,NULL,'save','2025-10-08 22:19:04'),
(3200,1,1,NULL,'save','2025-10-08 22:19:06'),
(3202,1,1,NULL,'save','2025-10-08 22:19:10'),
(3204,1,1,NULL,'save','2025-10-08 22:19:13'),
(3206,1,1,NULL,'save','2025-10-08 22:19:15'),
(3208,1,1,NULL,'save','2025-10-08 22:19:18'),
(3210,1,1,NULL,'save','2025-10-08 22:19:21');
/*!40000 ALTER TABLE `elementactivity` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements`
--

LOCK TABLES `elements` WRITE;
/*!40000 ALTER TABLE `elements` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements` VALUES
(1,NULL,NULL,NULL,NULL,'craft\\elements\\User',1,0,'2025-04-18 16:59:46','2025-04-18 16:59:46',NULL,NULL,NULL,'e3682bee-bd77-4012-b16c-20d4c1d6741e'),
(2,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-04-18 17:15:09','2025-10-08 22:20:12',NULL,NULL,NULL,'fb43295f-50d1-4199-9547-b616822746d7'),
(8,NULL,NULL,NULL,NULL,'craft\\elements\\Address',1,0,'2025-04-18 17:32:44','2025-04-18 17:37:13',NULL,NULL,NULL,'70e10205-927a-4a3d-8e91-9e3ffe573ce3'),
(10,8,NULL,4,NULL,'craft\\elements\\Address',1,0,'2025-04-18 17:32:44','2025-04-18 17:32:44',NULL,NULL,NULL,'d9e8d544-dbad-4f54-a2fa-87088e720db9'),
(14,NULL,7,NULL,2,'craft\\elements\\Entry',1,0,'2025-04-18 17:57:42','2025-04-18 17:57:42',NULL,NULL,NULL,'c1f79f68-e8c6-4804-933b-f8e101ccfec0'),
(16,8,NULL,7,NULL,'craft\\elements\\Address',1,0,'2025-04-18 17:37:13','2025-04-18 17:57:57',NULL,NULL,NULL,'6815ef49-b7c0-4172-83d5-784b766e1d24'),
(18,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:06:39','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'52fd2ad7-fbff-4f46-965c-e9b93f5475e1'),
(19,18,NULL,9,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:06:50','2025-04-18 18:06:50',NULL,'2025-08-20 21:57:12',NULL,'ff937fe5-a347-42af-a84d-364ede501006'),
(20,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:06:50','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'ab2ec6e7-b567-4a20-867e-593a3ae40ff6'),
(21,20,NULL,10,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:06:58','2025-04-18 18:06:58',NULL,'2025-08-20 21:57:12',NULL,'d45473b0-cdfa-4d60-b51c-0ba2eb2f25fc'),
(22,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:06:58','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'9219e8e3-d389-40e4-93d5-049cea4484d7'),
(23,22,NULL,11,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:06','2025-04-18 18:07:06',NULL,'2025-08-20 21:57:12',NULL,'94e66f9c-36d3-4154-9631-d82ffdbeb1af'),
(24,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:06','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'3a825176-0a84-4f2a-996b-3f4bd4770f3f'),
(25,24,NULL,12,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:32','2025-04-18 18:07:32',NULL,'2025-08-20 21:57:12',NULL,'2c134b83-5c7e-4a8e-83ab-aa66a981e508'),
(26,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:32','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'40928895-f36c-4108-a1e4-564ae2424ee4'),
(27,26,NULL,13,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:37','2025-04-18 18:07:37',NULL,'2025-08-20 21:57:12',NULL,'ed08da6e-f8d3-4f00-8bc2-bf0f777875f2'),
(28,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:37','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'56921bc4-017a-46d3-ac85-05b47f57bd77'),
(29,28,NULL,14,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:43','2025-04-18 18:07:43',NULL,'2025-08-20 21:57:12',NULL,'afe819d0-90cf-4853-bb8d-2c816199c653'),
(30,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:43','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'d580a613-5ab1-4051-b261-fb71b222fdad'),
(31,30,NULL,15,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:48','2025-04-18 18:07:48',NULL,'2025-08-20 21:57:12',NULL,'f6ceba8a-38e9-4a30-bbcf-3f53e7f3a3f0'),
(32,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:48','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'5818599c-3b59-4b75-8027-f3af86d4e2b7'),
(33,32,NULL,16,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:53','2025-04-18 18:07:53',NULL,'2025-08-20 21:57:12',NULL,'7ac990ce-be72-4bf1-a4f8-85d18bed1def'),
(34,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:07:53','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'3ccd345c-16a2-4a6e-b6a8-f959829490ca'),
(35,34,NULL,17,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:08:00','2025-04-18 18:08:00',NULL,'2025-08-20 21:57:12',NULL,'6698e76d-c879-44a8-832a-3a08edb99c6a'),
(36,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:08:00','2025-08-20 21:57:12',NULL,'2025-08-20 21:57:12',NULL,'30202a0c-1dab-4496-b0d9-a2e4db046073'),
(37,36,NULL,18,6,'craft\\elements\\Entry',1,0,'2025-04-18 18:08:04','2025-04-18 18:08:04',NULL,'2025-08-20 21:57:12',NULL,'af4aec2f-2c51-443d-afd2-f243f2c6db79'),
(44,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-04-18 18:10:41','2025-09-11 18:48:35',NULL,'2025-09-11 18:48:35',NULL,'66670719-86b2-4c25-a2d7-3268eb0b40e9'),
(45,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-04-18 18:10:41','2025-08-20 21:24:25',NULL,'2025-08-20 21:24:25',NULL,'d2f1243f-5911-46b3-ad4c-1fd18163d3cf'),
(46,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-04-18 18:10:41','2025-08-20 21:24:25',NULL,'2025-08-20 21:24:25',NULL,'e89fa079-a0ca-4f25-b733-547e3e9b74f4'),
(47,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-04-18 18:10:41','2025-08-20 21:24:25',NULL,'2025-08-20 21:24:25',NULL,'136b64d8-a9bb-44f3-ad1b-5b3d0e59aeb7'),
(56,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-04-18 18:14:39','2025-09-11 20:39:29',NULL,NULL,NULL,'cced9ffb-b1a4-432b-82dd-39ae892c0350'),
(57,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-04-18 18:14:39','2025-09-11 20:39:29',NULL,NULL,NULL,'5c75acb1-1c32-464d-a385-7d8e4367e7ad'),
(63,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-04-18 18:15:36','2025-09-11 20:39:29',NULL,NULL,NULL,'6b94fb19-0b48-4dbd-a994-fcc7c42212ac'),
(72,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'65faed90-739e-412a-ae6b-1141af4adff8'),
(73,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'15f1b50a-a6bf-404b-92d3-441e13132ed1'),
(74,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'02403c1b-68a0-4814-9d28-465a0dd3fd27'),
(75,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'d9c3d7d0-5243-443e-b0f7-d9e5c8e77f66'),
(76,NULL,NULL,NULL,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'3ddce6d7-14e4-4ed9-9384-71082ffc55a9'),
(78,72,NULL,30,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'d17c8ead-0ba1-4be3-bb3f-50f7b6bb1631'),
(79,73,NULL,31,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'885375ba-05c1-41a6-89db-4b73021f8132'),
(80,74,NULL,32,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'b8cf5928-cf35-40a0-8dd5-7b268a6cb35a'),
(81,75,NULL,33,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'420bcba9-27b9-4219-ab82-5e907810c874'),
(82,76,NULL,34,4,'craft\\elements\\Entry',1,0,'2025-04-18 18:17:53','2025-08-20 17:52:26',NULL,NULL,NULL,'c62a29bd-d219-4eb7-8448-3770a5e0234e'),
(86,NULL,NULL,NULL,7,'craft\\elements\\Asset',1,0,'2025-04-18 18:31:40','2025-09-04 22:50:00',NULL,'2025-09-04 22:50:00',NULL,'0fc1718b-a60f-47e7-8e1a-4c67a6e22462'),
(96,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:38:26',NULL,'2025-04-18 18:38:26',NULL,'76dad8f7-c48c-4ed9-9f87-edbba7ce9dcf'),
(97,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:38:26',NULL,'2025-04-18 18:38:26',NULL,'733b8349-6d24-4796-901f-e6cccb78f65d'),
(98,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:38:26',NULL,'2025-04-18 18:38:26',NULL,'1d77e91d-0d5a-4c40-a992-b87dcb0b8786'),
(99,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:38:26',NULL,'2025-04-18 18:38:26',NULL,'044388df-8aaa-4929-83df-33e2cceb95c1'),
(100,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:38:26',NULL,'2025-04-18 18:38:26',NULL,'894d2df8-3989-44d9-ae0e-e7860708bc75'),
(101,NULL,NULL,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:38:26',NULL,'2025-04-18 18:38:26',NULL,'17ebe246-d2b0-4c36-b223-80704f9d9182'),
(103,96,NULL,39,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:36:37',NULL,'2025-04-18 18:38:26',NULL,'e430eb07-6216-43e2-95c5-b2cc0935a963'),
(104,97,NULL,40,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:36:37',NULL,'2025-04-18 18:38:26',NULL,'14b1e5db-e0b3-4881-b609-d0f63e82af5d'),
(105,98,NULL,41,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:36:37',NULL,'2025-04-18 18:38:26',NULL,'bab88878-fb5d-498c-8b48-2eb77c8be0e6'),
(106,99,NULL,42,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:36:37',NULL,'2025-04-18 18:38:26',NULL,'9b39a9a1-7d1d-4ac8-a0e3-5e92f89ee08f'),
(107,100,NULL,43,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:36:37',NULL,'2025-04-18 18:38:26',NULL,'840fe20c-b9d9-467e-9525-3f383a31b004'),
(108,101,NULL,44,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:36:37','2025-04-18 18:36:37',NULL,'2025-04-18 18:38:26',NULL,'10a5e0c4-06b0-43fc-9f28-6ded2ef94793'),
(111,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-04-18 18:38:34','2025-09-29 18:59:42',NULL,NULL,NULL,'1c014517-f0ca-4b34-a4ec-8c06c66e936c'),
(112,111,NULL,46,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:40','2025-04-18 18:38:40',NULL,NULL,NULL,'b69fbe05-7e0a-444c-87cb-538dab008405'),
(113,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-04-18 18:38:44','2025-09-29 18:59:42',NULL,NULL,NULL,'e8577614-718f-4f49-9a2c-762b53180e15'),
(114,113,NULL,47,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:46','2025-04-18 18:38:46',NULL,NULL,NULL,'62564fb6-d7ee-42e1-a94c-0d101b1862ad'),
(115,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-04-18 18:38:49','2025-09-29 18:59:42',NULL,NULL,NULL,'c1291b59-240b-4c7d-a481-b43ceffa5843'),
(116,115,NULL,48,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:51','2025-04-18 18:38:51',NULL,NULL,NULL,'0de6d844-6a84-45b9-a5a4-219bf907924c'),
(117,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-04-18 18:38:54','2025-09-29 18:59:42',NULL,NULL,NULL,'c983b9b7-0678-4980-a3a6-bf04df690818'),
(118,117,NULL,49,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:38:56','2025-04-18 18:38:56',NULL,NULL,NULL,'6532d990-a37a-4e60-98a6-d2f6ad40d415'),
(119,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-04-18 18:38:58','2025-09-29 18:59:42',NULL,NULL,NULL,'07f26095-e9ed-4a30-9fcc-ee9e7b1c89a5'),
(120,119,NULL,50,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:39:00','2025-04-18 18:39:00',NULL,NULL,NULL,'9ef9e4fb-c780-42aa-b260-c57f1c904855'),
(121,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-04-18 18:39:03','2025-09-29 18:59:42',NULL,NULL,NULL,'f48f3d64-37db-4387-ad42-86a0d4022e8f'),
(122,121,NULL,51,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:39:04','2025-04-18 18:39:04',NULL,NULL,NULL,'5c8697a2-2860-47df-90df-d73d461ed250'),
(124,NULL,52,NULL,11,'craft\\elements\\Entry',1,0,'2025-04-18 18:40:11','2025-04-18 18:40:11',NULL,NULL,NULL,'5166d027-121a-4f77-9b1e-d976affec3c3'),
(131,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-04-18 18:42:36','2025-08-20 17:52:26',NULL,NULL,NULL,'10a402bd-e708-4f1b-8f19-9d6f2dd41e56'),
(132,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-04-18 18:42:36','2025-08-20 17:52:26',NULL,NULL,NULL,'61411460-73b4-43ef-93b9-77c20db6e79f'),
(134,131,NULL,55,5,'craft\\elements\\Entry',1,0,'2025-04-18 18:42:36','2025-08-20 17:52:26',NULL,NULL,NULL,'f22c54ba-b032-4465-9c01-dc3499eaf990'),
(135,132,NULL,56,5,'craft\\elements\\Entry',1,0,'2025-04-18 18:42:36','2025-08-20 17:52:26',NULL,NULL,NULL,'951dcef9-231c-4dde-b1c2-ae7b0fdeaba9'),
(136,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-04-18 18:44:35','2025-04-18 18:44:35',NULL,NULL,NULL,'73525736-57a1-472f-b811-bd05b62fb341'),
(137,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-04-18 18:44:36','2025-04-18 18:44:36',NULL,NULL,NULL,'abf930ea-95bc-4a2c-9696-8a563fc70185'),
(138,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-04-18 18:44:36','2025-04-18 18:44:36',NULL,NULL,NULL,'10a14980-1c09-497a-af73-3d142632703b'),
(220,NULL,96,NULL,2,'craft\\elements\\Entry',1,0,'2025-04-25 18:32:58','2025-04-25 18:32:58',NULL,NULL,NULL,'c5f32f5e-4201-48e7-b118-a723db8874fd'),
(283,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-07-30 21:03:21','2025-09-19 17:25:28',NULL,'2025-09-19 17:25:28',NULL,'4ec784d1-6952-4acb-85c3-56b744ba0e4f'),
(284,283,NULL,133,12,'craft\\elements\\Entry',1,0,'2025-07-30 21:07:37','2025-07-30 21:07:37',NULL,'2025-09-19 17:25:28',NULL,'d91825b2-b7b9-4fd2-9aec-343ce2cd1923'),
(285,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-07-30 22:47:59','2025-09-05 20:01:00',NULL,NULL,NULL,'805f8534-dd6f-4152-b919-0c5d87163b8b'),
(287,283,NULL,134,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:48:02','2025-07-30 22:48:02',NULL,'2025-09-19 17:25:28',NULL,'5a62d56e-00f3-4b23-9e5c-8d4e1333ea76'),
(288,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:29','2025-07-30 23:11:09',NULL,'2025-07-30 23:11:09',NULL,'f63f9936-131d-4c53-a08c-8479797747f2'),
(289,288,NULL,135,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:29','2025-07-30 22:56:29',NULL,'2025-07-30 23:11:09',NULL,'543128e6-7c91-492f-9438-6b07c988b05a'),
(290,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:32','2025-09-19 17:25:28',NULL,'2025-09-19 17:25:28',NULL,'2a15ad68-0e5b-4d2b-8e9b-d02cf1d4457f'),
(291,290,NULL,136,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:32','2025-07-30 22:56:32',NULL,'2025-09-19 17:25:28',NULL,'13ecbf19-a864-4bdc-be24-bf94ea582ebe'),
(292,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:33','2025-09-19 17:25:28',NULL,'2025-09-19 17:25:28',NULL,'fabdb4bb-67e5-4bd7-b818-c4e6e4094b75'),
(293,292,NULL,137,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:33','2025-07-30 22:56:33',NULL,'2025-09-19 17:25:28',NULL,'dcb8c580-bb1b-40fe-97ba-ad716c474ba1'),
(294,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:34','2025-09-19 17:25:28',NULL,'2025-09-19 17:25:28',NULL,'6b7a16eb-660d-4393-95fe-4f8c34f97d49'),
(295,294,NULL,138,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:34','2025-07-30 22:56:34',NULL,'2025-09-19 17:25:28',NULL,'22d6754d-4135-482b-891b-bb366b3e7d90'),
(296,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:35','2025-09-19 17:25:28',NULL,'2025-09-19 17:25:28',NULL,'8755e2a1-5452-40d8-bb12-b26a15d3c5ad'),
(297,296,NULL,139,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:56:35','2025-07-30 22:56:35',NULL,'2025-09-19 17:25:28',NULL,'0d1d0b08-140e-4c49-8bfa-70d3b8406bbe'),
(299,288,NULL,140,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:58:03','2025-07-30 22:58:03',NULL,'2025-07-30 23:11:09',NULL,'68b59346-df11-46ae-a35a-99ad3efd0769'),
(301,290,NULL,141,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:58:06','2025-07-30 22:58:06',NULL,'2025-09-19 17:25:28',NULL,'ecb6636c-b8a8-4058-b118-829e13f652a3'),
(303,292,NULL,142,12,'craft\\elements\\Entry',1,0,'2025-07-30 22:58:10','2025-07-30 22:58:10',NULL,'2025-09-19 17:25:28',NULL,'c0d976a8-5eea-446d-84d0-550445c219a0'),
(305,288,NULL,143,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:10:31','2025-07-30 23:10:31',NULL,'2025-07-30 23:11:09',NULL,'f286d6c6-85f4-4ea0-83d1-77d0f50d96a8'),
(306,283,NULL,144,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:10:37','2025-07-30 23:10:37',NULL,'2025-09-19 17:25:28',NULL,'d783f074-7582-4c2e-b04a-afee352e2417'),
(308,296,NULL,145,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:10:45','2025-07-30 23:10:45',NULL,'2025-09-19 17:25:28',NULL,'8c24349f-c77d-4763-956c-b9d29db3da7d'),
(310,292,NULL,146,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:10:55','2025-07-30 23:10:55',NULL,'2025-09-19 17:25:28',NULL,'bba6679f-f1f7-48bb-bbc1-928afdadf0a2'),
(311,290,NULL,147,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:11:02','2025-07-30 23:11:02',NULL,'2025-09-19 17:25:28',NULL,'2513036e-aebf-45d2-a083-ba0cc0d0623a'),
(314,294,NULL,148,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:11:29','2025-07-30 23:11:29',NULL,'2025-09-19 17:25:28',NULL,'721a1151-d124-44df-8f94-1b90139041f8'),
(315,296,NULL,149,12,'craft\\elements\\Entry',1,0,'2025-07-30 23:11:31','2025-07-30 23:11:31',NULL,'2025-09-19 17:25:28',NULL,'f695af88-e16a-46f4-a0d4-156e20b34fb2'),
(318,NULL,137,NULL,3,'craft\\elements\\Entry',1,0,'2025-07-31 17:41:05','2025-07-31 17:41:05',NULL,NULL,NULL,'41f2a05b-7f0e-41c8-972f-8796e135476d'),
(323,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:15','2025-08-01 18:04:08',NULL,'2025-08-01 18:04:08',NULL,'6b3e54cf-b357-46c1-8251-4cd6c1f951b1'),
(324,323,NULL,152,15,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:31','2025-08-01 17:59:31',NULL,'2025-08-01 18:04:08',NULL,'168018b4-8cee-43fd-bf87-7af9c47cced8'),
(325,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:34','2025-08-01 18:06:11',NULL,NULL,NULL,'583d4518-7524-42db-a63d-0d921f008d36'),
(326,325,NULL,153,15,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:41','2025-08-01 17:59:41',NULL,NULL,NULL,'52a01e8d-717e-470b-bbc1-3dd874556d25'),
(328,325,NULL,154,14,'craft\\elements\\Entry',1,0,'2025-08-01 17:59:53','2025-08-01 17:59:53',NULL,NULL,NULL,'c817c185-395d-435a-84c6-42430c2239a4'),
(329,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:04:51','2025-08-01 18:04:57',NULL,NULL,NULL,'328e73a9-9198-46ee-8ce1-292e019d2ac6'),
(330,329,NULL,155,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:04:57','2025-08-01 18:04:57',NULL,NULL,NULL,'82c64f78-283c-4a64-9681-11a3be4d4d40'),
(331,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:04:57','2025-08-01 18:05:01',NULL,NULL,NULL,'de1dbf90-2df4-4a57-8ef0-88e981636992'),
(332,331,NULL,156,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:01','2025-08-01 18:05:01',NULL,NULL,NULL,'ae5cc034-9679-48f5-9594-0c61fafe6990'),
(333,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:01','2025-08-01 18:05:04',NULL,NULL,NULL,'27c35b6d-8b9d-4bcc-abaf-a2338d548dfa'),
(334,333,NULL,157,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:04','2025-08-01 18:05:04',NULL,NULL,NULL,'70055f31-2d03-42d3-a985-121a1e2b2572'),
(335,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:04','2025-08-01 18:05:08',NULL,NULL,NULL,'5d7aa22c-6b88-4187-afb5-24fffb7c6539'),
(336,335,NULL,158,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:08','2025-08-01 18:05:08',NULL,NULL,NULL,'52c8f108-5ec7-4eb7-83e1-4c214d2d933b'),
(337,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:08','2025-08-01 18:05:10',NULL,NULL,NULL,'fdc36882-7b46-43fa-8ff9-4245e8dd9bd0'),
(338,337,NULL,159,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:10','2025-08-01 18:05:10',NULL,NULL,NULL,'1070a399-73d2-43b8-ad87-2e72974ec72a'),
(339,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:10','2025-08-01 18:05:15',NULL,NULL,NULL,'2558370f-56ae-47a6-8deb-2d7cb1e6ffe8'),
(340,339,NULL,160,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:15','2025-08-01 18:05:15',NULL,NULL,NULL,'a717b773-e41d-4eb4-a975-1f516ac78eeb'),
(341,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:15','2025-08-01 18:05:18',NULL,NULL,NULL,'c8f9f0cd-8e20-41d4-984b-30b14d2471af'),
(342,341,NULL,161,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:18','2025-08-01 18:05:18',NULL,NULL,NULL,'9b932f54-8d57-46cd-8c94-e9932a283f31'),
(343,NULL,NULL,NULL,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:18','2025-08-01 18:05:21',NULL,NULL,NULL,'edff3928-0002-4ca4-8b65-c9328c6c7162'),
(344,343,NULL,162,15,'craft\\elements\\Entry',1,0,'2025-08-01 18:05:21','2025-08-01 18:05:21',NULL,NULL,NULL,'6bfe948f-11ac-4494-8387-13a1d64719a8'),
(347,325,NULL,163,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:11','2025-08-01 18:06:11',NULL,NULL,NULL,'3b36b76d-7a5f-42fc-ba6e-2474c3e4f604'),
(348,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:11','2025-08-01 18:06:22',NULL,NULL,NULL,'af2219ff-28ec-46eb-b7f5-294fc48c9592'),
(349,348,NULL,164,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:22','2025-08-01 18:06:22',NULL,NULL,NULL,'49e28ec6-9273-48fd-bc9f-9624a56e7e96'),
(350,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:22','2025-08-01 18:06:40',NULL,NULL,NULL,'62a9aee5-450d-4d74-ac3c-22a50eb327d9'),
(351,350,NULL,165,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:06:40','2025-08-01 18:06:40',NULL,NULL,NULL,'f2c0689f-e1b0-4149-ba01-d0981abdda1e'),
(352,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:13','2025-08-01 18:07:25',NULL,NULL,NULL,'81854a0e-389f-4f30-8603-f133fa881688'),
(353,352,NULL,166,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:25','2025-08-01 18:07:25',NULL,NULL,NULL,'d5c48d8f-ac42-479e-8798-a50fc596d6d1'),
(354,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:25','2025-08-01 18:07:35',NULL,NULL,NULL,'7d9e199d-e444-4270-95c2-e0d6c18d7eda'),
(355,354,NULL,167,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:35','2025-08-01 18:07:35',NULL,NULL,NULL,'7a8fc6bc-eaf0-44e7-b00c-faab057bca0a'),
(356,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:35','2025-08-01 18:07:48',NULL,NULL,NULL,'1a91cd2e-f777-4327-82bf-9d4952df04dd'),
(357,356,NULL,168,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:48','2025-08-01 18:07:48',NULL,NULL,NULL,'da159131-b262-48b8-b0c9-8ca4af83f540'),
(358,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:51','2025-08-01 18:07:58',NULL,NULL,NULL,'83178051-07e6-40c6-ac65-1803e199667a'),
(359,358,NULL,169,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:07:58','2025-08-01 18:07:58',NULL,NULL,NULL,'d712ccab-478b-4d57-a770-e516c4c08e67'),
(360,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:01','2025-08-01 18:08:08',NULL,NULL,NULL,'47d21938-0536-4427-8f5f-cc02e140ab9d'),
(361,360,NULL,170,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:08','2025-08-01 18:08:08',NULL,NULL,NULL,'fae28537-8e36-4e69-a83a-8d0ddf218299'),
(362,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:10','2025-08-01 18:08:17',NULL,NULL,NULL,'d0e07c9d-1540-47f6-9214-6072a6894154'),
(363,362,NULL,171,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:17','2025-08-01 18:08:17',NULL,NULL,NULL,'695949a8-88ed-4210-8f64-4aa21bec75ad'),
(364,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:21','2025-08-01 18:08:31',NULL,NULL,NULL,'d55b94a3-92b7-4e30-85db-817cc33f7281'),
(365,364,NULL,172,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:31','2025-08-01 18:08:31',NULL,NULL,NULL,'9b0f4c33-4420-4c1a-a158-285c77d7ac98'),
(366,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:08:41','2025-08-01 18:09:02',NULL,NULL,NULL,'1c397521-de13-43d2-8460-dbda17e5b9dc'),
(367,366,NULL,173,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:02','2025-08-01 18:09:02',NULL,NULL,NULL,'3e8a2f04-8045-4812-af81-174a31a95925'),
(368,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:02','2025-08-01 18:09:12',NULL,NULL,NULL,'8ee85d47-9148-40ec-bd5b-c84d73572f95'),
(369,368,NULL,174,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:12','2025-08-01 18:09:12',NULL,NULL,NULL,'d99724a6-54f1-4049-b361-55adf27661e2'),
(370,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:12','2025-08-01 18:09:33',NULL,NULL,NULL,'2ce7941c-d93f-403c-bfd6-49b638f4035a'),
(371,370,NULL,175,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:33','2025-08-01 18:09:33',NULL,NULL,NULL,'c7581c6a-d0d7-4e1c-a436-ed6c88693ffd'),
(372,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:33','2025-08-01 18:09:44',NULL,NULL,NULL,'18f99c19-28c4-4251-8b65-2eb57599534e'),
(373,372,NULL,176,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:44','2025-08-01 18:09:44',NULL,NULL,NULL,'510e667e-1473-46b5-978c-c3d2101510f6'),
(374,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:09:44','2025-08-01 18:10:00',NULL,NULL,NULL,'f9783239-388c-401a-8006-ab0e5f64e90c'),
(375,374,NULL,177,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:00','2025-08-01 18:10:00',NULL,NULL,NULL,'cae79123-f9c7-4bf7-86e4-deb1ead10b4c'),
(376,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:00','2025-08-01 18:10:07',NULL,NULL,NULL,'82798d00-f457-47dd-a197-136a8979cb07'),
(377,376,NULL,178,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:07','2025-08-01 18:10:07',NULL,NULL,NULL,'539ea850-c01d-4267-a3ee-4238f88ce5cc'),
(378,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:07','2025-08-01 18:10:18',NULL,NULL,NULL,'8e689347-9d85-4f7e-98a0-fedc85d7efd8'),
(379,378,NULL,179,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:18','2025-08-01 18:10:18',NULL,NULL,NULL,'c04693d2-c401-4525-a351-aada42c7ef60'),
(380,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:18','2025-08-01 18:10:31',NULL,NULL,NULL,'5f7daf9d-7dfe-4651-aabb-f38c89bbee1a'),
(381,380,NULL,180,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:31','2025-08-01 18:10:31',NULL,NULL,NULL,'86babb64-34dc-45a1-863a-3200a52b8b2b'),
(382,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:45','2025-08-01 18:10:53',NULL,NULL,NULL,'59cac7d1-17fd-4d38-bb0d-aeabbdf85711'),
(383,382,NULL,181,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:53','2025-08-01 18:10:53',NULL,NULL,NULL,'99f0f1cb-7140-453a-97a3-2347159ad061'),
(384,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:10:57','2025-08-01 18:11:04',NULL,NULL,NULL,'f25f3853-7910-43ae-8a40-77d2c8cb955a'),
(385,384,NULL,182,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:04','2025-08-01 18:11:04',NULL,NULL,NULL,'2e6ec653-4724-40f0-9825-e0f16f6bfa46'),
(386,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:07','2025-08-01 18:11:17',NULL,NULL,NULL,'368912c4-ff2f-4791-b5f7-c7ab02e9366d'),
(387,386,NULL,183,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:17','2025-08-01 18:11:17',NULL,NULL,NULL,'c73507a9-d3c1-44e8-a1e5-6d417be2f20d'),
(388,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:20','2025-08-01 18:11:31',NULL,NULL,NULL,'95c17a71-7dbc-4bb1-bd1b-f68eef362ae3'),
(389,388,NULL,184,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:31','2025-08-01 18:11:31',NULL,NULL,NULL,'64da7682-e0dd-47fb-b824-18f245cc4a96'),
(390,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:35','2025-08-01 18:11:48',NULL,NULL,NULL,'86133147-b29a-42ed-adea-703e49287bba'),
(391,390,NULL,185,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:48','2025-08-01 18:11:48',NULL,NULL,NULL,'46f0d01f-8e54-45ad-82ce-574f2ca3b97b'),
(392,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:11:48','2025-08-01 18:12:02',NULL,NULL,NULL,'a250b11d-668e-42db-a3ef-4c92bd5c2c11'),
(393,392,NULL,186,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:02','2025-08-01 18:12:02',NULL,NULL,NULL,'c44b8aa0-829f-41d8-a2aa-564b5dca44b4'),
(394,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:03','2025-08-01 18:12:14',NULL,NULL,NULL,'673dd0fa-da64-4850-b460-39601e040741'),
(395,394,NULL,187,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:14','2025-08-01 18:12:14',NULL,NULL,NULL,'0a5a42ce-c4c8-4c85-bc6d-895c165cae4d'),
(396,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:14','2025-08-01 18:12:26',NULL,NULL,NULL,'bdb1359d-c180-4611-8a95-2eb8b1f816e1'),
(397,396,NULL,188,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:26','2025-08-01 18:12:26',NULL,NULL,NULL,'71b23c28-a5f2-4207-af9d-f5d212218964'),
(398,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:26','2025-08-01 18:12:34',NULL,NULL,NULL,'0cb6c888-0464-4bbb-a350-e279e9d68b35'),
(399,398,NULL,189,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:34','2025-08-01 18:12:34',NULL,NULL,NULL,'790a58f9-967e-4233-ba06-bf22f9465677'),
(400,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:46','2025-08-01 18:12:57',NULL,NULL,NULL,'c6ca4057-3b10-40f6-a7b5-bbf90d2b25aa'),
(401,400,NULL,190,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:57','2025-08-01 18:12:57',NULL,NULL,NULL,'473fe0de-7e10-487c-942b-04510711521b'),
(402,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:12:57','2025-08-01 18:13:07',NULL,NULL,NULL,'331b5ad6-85d6-4a40-a7e1-cb2cff2685eb'),
(403,402,NULL,191,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:07','2025-08-01 18:13:07',NULL,NULL,NULL,'7bfb3e73-2ffe-4080-843e-56ab6da363c4'),
(404,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:07','2025-08-01 18:13:20',NULL,NULL,NULL,'3a19f3c2-7434-48ca-bb52-5ed62fb004e3'),
(405,404,NULL,192,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:20','2025-08-01 18:13:20',NULL,NULL,NULL,'41e84075-2d04-47a9-bd20-a6c5f2d7f1a0'),
(406,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:20','2025-08-01 18:13:33',NULL,NULL,NULL,'4af36b42-1b01-4cd8-a0aa-90e28d3caa06'),
(407,406,NULL,193,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:33','2025-08-01 18:13:33',NULL,NULL,NULL,'82385c94-48ae-43fa-8fd6-629e2851bf81'),
(408,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:33','2025-08-01 18:13:42',NULL,NULL,NULL,'6df397ab-c7a8-4ca9-afb2-998ca8e61820'),
(409,408,NULL,194,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:42','2025-08-01 18:13:42',NULL,NULL,NULL,'62d62837-bd43-4e98-a743-3ac0d3dfccb3'),
(410,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:42','2025-08-01 18:13:53',NULL,NULL,NULL,'adb995c3-6ef3-49fd-b8f8-de40b96021d3'),
(411,410,NULL,195,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:53','2025-08-01 18:13:53',NULL,NULL,NULL,'16dbb9a1-3887-4648-97a1-e0ddda8ddec8'),
(412,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:13:53','2025-08-01 18:14:03',NULL,NULL,NULL,'278fe834-90b2-40c5-9857-c4d166881f23'),
(413,412,NULL,196,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:14:03','2025-08-01 18:14:03',NULL,NULL,NULL,'69ae175c-0c03-4018-83db-eff2a046c29f'),
(414,NULL,NULL,NULL,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:14:03','2025-08-01 18:14:13',NULL,NULL,NULL,'780c5721-1030-4d98-969b-9deff3557653'),
(415,414,NULL,197,14,'craft\\elements\\Entry',1,0,'2025-08-01 18:14:13','2025-08-01 18:14:13',NULL,NULL,NULL,'7bc31cdf-c3c5-4335-b7bf-cc36f78001bf'),
(420,131,NULL,201,5,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'16280068-4786-4702-b34c-09c22cfd6196'),
(421,132,NULL,202,5,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'a06d4a0e-10ed-4645-92aa-853fc34d33bf'),
(426,56,NULL,207,3,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-10-08 22:20:13',NULL,NULL,NULL,'705e6945-919e-4d42-8f84-1f06ae7dcf2b'),
(427,57,NULL,208,3,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-10-08 22:20:13',NULL,NULL,NULL,'5981aa88-a731-49d8-b05b-699a4b3bb570'),
(428,63,NULL,209,3,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-10-08 22:20:13',NULL,NULL,NULL,'ce588e48-eda2-47ae-99f8-aaad483027ee'),
(429,72,NULL,210,4,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'6a3f966a-aa85-4161-a0b0-0433f1954e98'),
(430,73,NULL,211,4,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'63487207-f775-4ab2-bb13-b1b3dfd36313'),
(431,74,NULL,212,4,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'431fffd1-ee06-4838-a2bc-d7099d9afb7d'),
(432,75,NULL,213,4,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'df0c6fd0-93a8-4dfe-b4ac-06f4ace2525c'),
(433,76,NULL,214,4,'craft\\elements\\Entry',1,0,'2025-08-20 17:52:26','2025-08-20 17:56:29',NULL,NULL,NULL,'4c13186c-43fc-4e46-b500-cce37bc371d5'),
(445,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-08-20 21:24:25','2025-09-11 18:48:35',NULL,'2025-09-11 18:48:35',NULL,'ae63e78a-7eeb-49e8-92cd-4ee9706e3f41'),
(452,36,NULL,222,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:57:06','2025-08-20 21:57:06',NULL,'2025-08-20 21:57:12',NULL,'6b7cd467-67b1-4146-8845-ab5d5f1a3dcc'),
(453,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:57:13','2025-08-20 21:57:20',NULL,'2025-08-20 21:58:20',NULL,'92e5d931-915e-4bdc-ba87-caa0a66a765b'),
(454,453,NULL,223,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:57:20','2025-08-20 21:57:20',NULL,NULL,NULL,'4a5509ff-de7f-42c9-8b46-96e3034eebc8'),
(455,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:57:25','2025-08-20 21:57:32',NULL,'2025-08-20 21:58:20',NULL,'a74613e1-4bfb-44a5-88a1-590b8dd7fdaa'),
(456,455,NULL,224,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:57:32','2025-08-20 21:57:32',NULL,NULL,NULL,'54f0ea99-df53-4b1c-ad97-316d341948ce'),
(457,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:58:35','2025-09-23 20:25:31',NULL,NULL,NULL,'6afe8b39-15ff-42bb-b973-3f0fdc816be2'),
(458,457,NULL,225,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:58:42','2025-08-20 21:58:42',NULL,NULL,NULL,'885e099b-06ad-4ca9-b798-1cc8eb8f0874'),
(459,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:58:47','2025-09-23 21:13:19',NULL,NULL,NULL,'d2b03ab3-9f68-48c7-b08a-fa96143faa3a'),
(460,459,NULL,226,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:58:54','2025-08-20 21:58:54',NULL,NULL,NULL,'4a02cd04-c703-4960-81f6-b02080e8cf60'),
(461,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:02','2025-09-23 20:25:25',NULL,NULL,NULL,'f1b0b1b6-ae43-43c7-bce0-29bcc5cd3a17'),
(462,461,NULL,227,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:06','2025-08-20 21:59:06',NULL,NULL,NULL,'f8ef6ca5-d997-41af-a600-4932f5cfbf34'),
(463,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:10','2025-09-23 20:25:37',NULL,NULL,NULL,'aa400bc6-8fa9-476b-b82a-cd3ccfb1803a'),
(464,463,NULL,228,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:15','2025-08-20 21:59:15',NULL,NULL,NULL,'6dfd32dc-d32f-448f-80f9-9f9c7eb16450'),
(465,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:23','2025-09-23 21:13:37',NULL,NULL,NULL,'25b87173-d04e-40ab-bd45-abe288dd5941'),
(466,465,NULL,229,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:33','2025-08-20 21:59:33',NULL,NULL,NULL,'bd10878c-d3f4-4a77-aac0-26a4ce94cd6f'),
(467,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:39','2025-09-23 20:25:55',NULL,NULL,NULL,'6ff7afbb-4b9a-483f-9da6-218c3997ad6f'),
(468,467,NULL,230,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:45','2025-08-20 21:59:45',NULL,NULL,NULL,'7a32a7f2-637a-4b64-8ae7-7cb144e935b2'),
(469,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 21:59:56','2025-09-23 20:26:04',NULL,NULL,NULL,'cd4f4662-0b03-4087-9e8f-1b485f959b82'),
(470,469,NULL,231,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:03','2025-08-20 22:00:03',NULL,NULL,NULL,'3131549f-c089-4f69-96e5-e59fde4a9009'),
(471,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:03','2025-09-23 20:26:11',NULL,NULL,NULL,'f4ec289c-bde1-4c45-bfbb-5c1069a516e0'),
(472,471,NULL,232,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:11','2025-08-20 22:00:11',NULL,NULL,NULL,'d12f9c87-584a-4bbf-be08-e02a6ca26147'),
(473,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:11','2025-08-20 22:00:22',NULL,NULL,NULL,'e0971592-0abc-45c9-9817-fa746354d89b'),
(474,473,NULL,233,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:22','2025-08-20 22:00:22',NULL,NULL,NULL,'ce04c12a-98d4-449f-8835-7c027df5d590'),
(475,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:31','2025-09-23 20:26:26',NULL,NULL,NULL,'544f9c74-39e1-48a1-b848-5c91ce2903e3'),
(476,475,NULL,234,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:38','2025-08-20 22:00:38',NULL,NULL,NULL,'7a1268bf-5a4e-4e66-95a8-801a89088c9f'),
(477,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:42','2025-09-23 20:26:34',NULL,NULL,NULL,'aab1bf62-810e-4549-8f8d-319f5098e937'),
(478,477,NULL,235,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:46','2025-08-20 22:00:46',NULL,NULL,NULL,'f83a6d0f-e336-4b20-94d9-f7a5bea8f26f'),
(479,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:52','2025-09-23 20:26:42',NULL,NULL,NULL,'5824e18b-943c-49f4-aee0-26e9486372c4'),
(480,479,NULL,236,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:00:59','2025-08-20 22:00:59',NULL,NULL,NULL,'6ac0ebba-f48a-49af-a6fc-eb49875f0a4c'),
(481,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:02','2025-09-23 20:26:54',NULL,NULL,NULL,'53138f5c-15f3-46af-9c57-838c36ff6907'),
(482,481,NULL,237,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:08','2025-08-20 22:01:08',NULL,NULL,NULL,'592f6284-128f-4372-8839-e24271e9a5e0'),
(483,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:12','2025-09-23 20:27:03',NULL,NULL,NULL,'db4fc231-4ebe-49dd-9e62-ea62d3c23f72'),
(484,483,NULL,238,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:17','2025-08-20 22:01:17',NULL,NULL,NULL,'485ae322-0a90-47c8-aa28-1a535baff5c5'),
(485,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:22','2025-09-23 20:27:13',NULL,NULL,NULL,'019352c4-069d-42e8-8424-ac0de36a3ff3'),
(486,485,NULL,239,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:30','2025-08-20 22:01:30',NULL,NULL,NULL,'5b15e794-120c-4028-a939-70a24320f03a'),
(487,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:01:56','2025-09-23 21:13:50',NULL,NULL,NULL,'12909ae0-a512-4b87-a2de-762fc097ba48'),
(488,487,NULL,240,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:03','2025-08-20 22:02:03',NULL,NULL,NULL,'8f2f40b7-c8dd-4269-9a64-5ebeb4c3c3fb'),
(489,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:05','2025-09-23 20:29:09',NULL,NULL,NULL,'25f98012-5633-4829-b941-2757508affba'),
(490,489,NULL,241,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:13','2025-08-20 22:02:13',NULL,NULL,NULL,'b7550ee6-d64a-4724-9914-4c567aa2ece7'),
(491,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:13','2025-09-23 20:29:17',NULL,NULL,NULL,'50117c21-038a-42be-bf0c-d5732fc15be7'),
(492,491,NULL,242,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:19','2025-08-20 22:02:19',NULL,NULL,NULL,'43c9b5a3-7c85-4352-a122-8a3f4c8a8616'),
(493,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:23','2025-09-23 20:29:24',NULL,NULL,NULL,'c8d4490f-c38e-4c36-a37e-57c3a8a9b1a3'),
(494,493,NULL,243,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:28','2025-08-20 22:02:28',NULL,NULL,NULL,'1861e046-fd59-41b8-beb6-8ec6c9a75cec'),
(495,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:28','2025-09-23 20:29:38',NULL,NULL,NULL,'5e632a25-c3f5-48b7-b309-57ff17c2b80f'),
(496,495,NULL,244,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:34','2025-08-20 22:02:34',NULL,NULL,NULL,'c838b1bb-69d2-47a9-a1c1-1a84fde8ca9a'),
(497,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:53','2025-09-23 21:13:43',NULL,NULL,NULL,'68eb2786-c4db-4964-b947-56e3b1a85a38'),
(498,497,NULL,245,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:02:59','2025-08-20 22:02:59',NULL,NULL,NULL,'01d3e7fa-cfdf-4d96-b03e-c0e321fbc668'),
(499,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:20','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'0ce91c4a-ace5-4055-b123-443e291031f2'),
(500,499,NULL,246,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:23','2025-08-20 22:12:23',NULL,'2025-09-26 17:59:44',NULL,'09985d3b-e9d4-4eed-9b6a-d07a77b69524'),
(501,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:23','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'372887eb-9909-4edd-b5ea-459796d65105'),
(502,501,NULL,247,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:28','2025-08-20 22:12:28',NULL,'2025-09-26 17:59:44',NULL,'fdcb9b26-a13b-44e2-b4b9-38c3e52e4436'),
(503,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:32','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'07e6baca-fca0-4500-aabe-36a66b94ad5b'),
(504,503,NULL,248,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:34','2025-08-20 22:12:34',NULL,'2025-09-26 17:59:44',NULL,'a1979fb9-d778-4efe-96bd-5742c169e4c0'),
(505,NULL,224,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:34','2025-08-20 22:12:34',NULL,NULL,NULL,'d5b94a83-6ba3-4e1d-96e3-85cae8ddb0c1'),
(506,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:49','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'5ebee889-c8d9-4b9f-8bf7-a62ae1a29956'),
(507,506,NULL,249,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:50','2025-08-20 22:12:50',NULL,'2025-09-26 17:59:44',NULL,'ac17d91b-f5d0-4971-8b0b-cdc61f16d510'),
(508,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:50','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'98ca941b-4d3d-4084-bc19-15ee6f02b9a0'),
(509,508,NULL,250,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:54','2025-08-20 22:12:54',NULL,'2025-09-26 17:59:44',NULL,'c9960642-98ec-4f90-827f-3a044bb7c082'),
(510,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:54','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'7b3bdf54-cae0-4032-b4f1-acc65e1beb0f'),
(511,510,NULL,251,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:57','2025-08-20 22:12:57',NULL,'2025-09-26 17:59:44',NULL,'bcac39b9-622a-43cc-805f-8639537ff312'),
(512,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:12:57','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'ec55fc9e-09c2-4e54-b4a8-df507090f928'),
(513,512,NULL,252,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:01','2025-08-20 22:13:01',NULL,'2025-09-26 17:59:44',NULL,'529baec6-ff2b-4ba4-905c-a0f1428b7f6b'),
(514,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:01','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'7d5b01fc-0c04-4065-ad4a-43f3c0ced039'),
(515,514,NULL,253,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:04','2025-08-20 22:13:04',NULL,'2025-09-26 17:59:44',NULL,'bc91f4c4-eaba-4d4f-a70c-490b78486402'),
(516,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:04','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'5fd7eefd-57e5-49b8-b751-0f0cc5db74bf'),
(517,516,NULL,254,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:07','2025-08-20 22:13:07',NULL,'2025-09-26 17:59:44',NULL,'71b81f4e-a2f8-43a1-b9b0-2c7dfc7adcc4'),
(518,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:07','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'73a2ffe4-2e14-4cfd-86de-d43278471aec'),
(519,518,NULL,255,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:10','2025-08-20 22:13:10',NULL,'2025-09-26 17:59:44',NULL,'627cf149-b41f-40ef-86f3-6cb12a2e47cc'),
(520,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:10','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'6518b18a-a543-41c0-9993-1ecebe38c0fb'),
(521,520,NULL,256,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:13','2025-08-20 22:13:13',NULL,'2025-09-26 17:59:44',NULL,'ec864cfd-7930-42ab-8ce1-a3eb03c4cf77'),
(522,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:13','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'a9d646b2-ab9b-4d0f-95a0-b1389cb6a587'),
(523,522,NULL,257,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:15','2025-08-20 22:13:15',NULL,'2025-09-26 17:59:44',NULL,'31f7b586-090d-4d4a-a050-1d74b96a7f51'),
(524,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:15','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'9bda47a5-c030-4f3a-8918-3f21140d5519'),
(525,524,NULL,258,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:13:18','2025-08-20 22:13:18',NULL,'2025-09-26 17:59:44',NULL,'6f7a86a5-d734-4d6b-a8b6-747209a7ee0b'),
(530,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:17:42','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'ee840fa4-636f-423a-9142-830b7c0e85d3'),
(531,530,NULL,260,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:17:46','2025-08-20 22:17:46',NULL,'2025-09-26 17:59:44',NULL,'ad752b76-fe98-477b-8889-9948c9492c9b'),
(532,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:17:53','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'3638cb68-2a5a-43d0-a9f7-64efac14abf3'),
(533,532,NULL,261,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:18:02','2025-08-20 22:18:02',NULL,'2025-09-26 17:59:44',NULL,'3abc8fb7-bb91-4f65-8767-397b8e7fc8a2'),
(534,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:18:14','2025-09-26 17:59:44',NULL,'2025-09-26 17:59:44',NULL,'ede61ecf-d245-424c-975b-73d620cf6db3'),
(535,534,NULL,262,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:18:21','2025-08-20 22:18:21',NULL,'2025-09-26 17:59:44',NULL,'73f04776-257b-4186-a45b-53b68a59f537'),
(536,534,NULL,263,6,'craft\\elements\\Entry',1,0,'2025-08-20 22:18:29','2025-08-20 22:18:29',NULL,'2025-09-26 17:59:44',NULL,'759b074e-21ae-4792-bdc5-82829ff9e5e6'),
(545,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-09-02 20:43:21','2025-09-02 20:43:21',NULL,NULL,NULL,'b2b558ce-cd40-4d4c-a797-ca5bb55acd23'),
(546,2,NULL,269,1,'craft\\elements\\Entry',1,0,'2025-09-02 20:43:29','2025-09-02 20:43:30',NULL,NULL,NULL,'441c0b7d-1c0f-41db-a655-566fdbfb221f'),
(548,NULL,NULL,NULL,9,'craft\\elements\\Asset',1,0,'2025-09-02 21:15:29','2025-09-02 21:15:29',NULL,NULL,NULL,'229e6ff4-c6db-48ed-8904-f9db2161ad70'),
(549,2,NULL,270,1,'craft\\elements\\Entry',1,0,'2025-09-02 21:15:32','2025-09-02 21:15:32',NULL,NULL,NULL,'582b4cc3-7045-4b75-b773-da22c188c7a5'),
(553,2,NULL,272,1,'craft\\elements\\Entry',1,0,'2025-09-02 21:46:06','2025-09-02 21:46:06',NULL,NULL,NULL,'23125f1d-4f6b-4631-b698-3c6276b803b3'),
(554,NULL,NULL,NULL,16,'craft\\elements\\GlobalSet',1,0,'2025-09-02 21:50:29','2025-10-08 22:16:36',NULL,NULL,NULL,'ac2e66d3-984a-4e83-b29d-422f84e8c085'),
(555,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-09-02 22:24:40','2025-09-29 18:59:42',NULL,NULL,NULL,'d84d167e-eaf4-4415-99d2-ab38cfaa1965'),
(556,555,NULL,273,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:24:46','2025-09-02 22:24:46',NULL,NULL,NULL,'6a620e7e-d6e3-4a23-a5f8-6258867f4daa'),
(557,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-09-02 22:24:46','2025-09-29 18:59:42',NULL,NULL,NULL,'1cee90b2-4187-4b57-a0bd-db245bf510a1'),
(558,557,NULL,274,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:24:52','2025-09-02 22:24:52',NULL,NULL,NULL,'f836702a-f488-4fee-90ed-15f1cb5bb4a1'),
(559,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-09-02 22:24:52','2025-09-29 18:59:42',NULL,NULL,NULL,'2abc4ce0-fc48-4a6c-9c02-573fdcccfd9e'),
(560,559,NULL,275,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:24:59','2025-09-02 22:24:59',NULL,NULL,NULL,'0264ae86-3a96-46f7-837a-1ee4c05e4104'),
(561,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-09-02 22:24:59','2025-09-29 18:59:42',NULL,NULL,NULL,'d6eb4e88-c542-461f-a878-846ece13c964'),
(562,561,NULL,276,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:25:02','2025-09-02 22:25:02',NULL,NULL,NULL,'66eca11b-cd50-46c2-a268-d41bf867f57d'),
(563,NULL,NULL,NULL,11,'craft\\elements\\Entry',0,0,'2025-09-02 22:25:02','2025-09-29 18:59:42',NULL,NULL,NULL,'42130eab-77a7-44f1-83bb-7d6217866d87'),
(564,563,NULL,277,11,'craft\\elements\\Entry',1,0,'2025-09-02 22:25:06','2025-09-02 22:25:06',NULL,NULL,NULL,'b4b77612-2541-43d8-82d0-4fc70a534781'),
(566,2,NULL,278,1,'craft\\elements\\Entry',1,0,'2025-09-02 22:26:19','2025-09-02 22:26:19',NULL,NULL,NULL,'e66b361a-afdb-4938-bea9-dfbce02ac7c4'),
(568,2,NULL,279,1,'craft\\elements\\Entry',1,0,'2025-09-02 22:26:44','2025-09-02 22:26:44',NULL,NULL,NULL,'406473a9-3124-4715-a7fc-69bffdb23581'),
(570,2,NULL,280,1,'craft\\elements\\Entry',1,0,'2025-09-02 22:27:53','2025-09-02 22:27:53',NULL,NULL,NULL,'ac6de050-ca9d-41d0-a8c4-8ed04545d9fb'),
(575,2,NULL,281,1,'craft\\elements\\Entry',1,0,'2025-09-02 22:28:18','2025-09-02 22:28:18',NULL,NULL,NULL,'87ee2d89-619f-4253-a750-b3b0c959bd62'),
(577,2,NULL,282,1,'craft\\elements\\Entry',1,0,'2025-09-03 01:11:03','2025-09-03 01:11:03',NULL,NULL,NULL,'b880b4ad-fb48-40e0-b69a-57063decd1a9'),
(581,2,NULL,284,1,'craft\\elements\\Entry',1,0,'2025-09-03 19:59:09','2025-09-03 19:59:09',NULL,NULL,NULL,'15378359-c704-42d1-b7a5-3617822ce0e5'),
(586,2,NULL,285,1,'craft\\elements\\Entry',1,0,'2025-09-03 21:05:58','2025-09-03 21:05:58',NULL,NULL,NULL,'75f819fc-b8d4-43c7-9b21-d330c09b78ab'),
(587,56,NULL,286,3,'craft\\elements\\Entry',1,0,'2025-09-03 21:05:58','2025-09-03 21:05:58',NULL,NULL,NULL,'00567ab8-f390-4a29-87ef-1d98b34e4d5e'),
(588,57,NULL,287,3,'craft\\elements\\Entry',1,0,'2025-09-03 21:05:58','2025-09-03 21:05:58',NULL,NULL,NULL,'a1ef1575-747a-40ff-ab52-7d93e4303e22'),
(589,63,NULL,288,3,'craft\\elements\\Entry',1,0,'2025-09-03 21:05:58','2025-09-03 21:05:58',NULL,NULL,NULL,'16fd532f-395f-4c22-999d-c5cb59a60542'),
(592,2,NULL,289,1,'craft\\elements\\Entry',1,0,'2025-09-03 21:06:15','2025-09-03 21:06:15',NULL,NULL,NULL,'bffaeda7-0048-432d-9e5e-517fc27be3db'),
(593,63,NULL,290,3,'craft\\elements\\Entry',1,0,'2025-09-03 21:06:15','2025-09-03 21:06:15',NULL,NULL,NULL,'f64dc4e0-f21a-4b12-8a56-b8b8a1b1ba5d'),
(596,2,NULL,291,1,'craft\\elements\\Entry',1,0,'2025-09-03 21:08:08','2025-09-03 21:08:08',NULL,NULL,NULL,'bf84cc3e-fe8b-4026-afb0-f4e9a6d000f0'),
(597,63,NULL,292,3,'craft\\elements\\Entry',1,0,'2025-09-03 21:08:08','2025-09-03 21:08:08',NULL,NULL,NULL,'83cf04aa-cff0-4968-8a54-92870b171901'),
(599,2,NULL,293,1,'craft\\elements\\Entry',1,0,'2025-09-03 21:21:53','2025-09-03 21:21:53',NULL,NULL,NULL,'6b31251e-1ce2-445a-a160-3adf5e41b5a4'),
(601,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:04','2025-10-03 20:24:31',NULL,NULL,NULL,'9a0f8b68-a562-4873-b0ed-8507a6b25f6a'),
(602,601,NULL,294,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:33','2025-09-03 21:48:33',NULL,NULL,NULL,'5493f4d8-9cd9-489a-9503-1616b9080fd0'),
(603,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:33','2025-09-03 21:58:36',NULL,'2025-09-03 21:58:36',NULL,'836fd052-4d0c-4245-8774-acddb158100b'),
(604,603,NULL,295,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:45','2025-09-03 21:48:45',NULL,'2025-09-03 21:58:36',NULL,'8f5c13ca-7ca3-4c0c-b9cc-a6efdebd5579'),
(605,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:47','2025-10-03 20:24:40',NULL,NULL,NULL,'81303c7f-793e-4e55-bfa7-c02492f7c347'),
(606,605,NULL,296,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:48:52','2025-09-03 21:48:52',NULL,NULL,NULL,'7f0e29a6-41f3-45fd-925d-fd9e234a832a'),
(607,605,NULL,297,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:49:15','2025-09-03 21:49:15',NULL,NULL,NULL,'da47c1b6-8b38-4b88-808b-a3c12590b010'),
(608,601,NULL,298,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:49:20','2025-09-03 21:49:20',NULL,NULL,NULL,'6b9349c5-491f-4b98-9c0c-558baa78c3dd'),
(609,601,NULL,299,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:49:25','2025-09-03 21:49:26',NULL,NULL,NULL,'7d47a22a-2b18-45e2-a9be-172f304f50b1'),
(610,601,NULL,300,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:52:33','2025-09-03 21:52:33',NULL,NULL,NULL,'187fd43b-d044-4624-afc8-234a7d9a5532'),
(612,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-03 21:56:34','2025-09-03 21:56:34',NULL,NULL,NULL,'b6a9c079-dc19-4954-b3f6-6ac89a38efea'),
(613,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-03 21:56:34','2025-09-03 21:56:34',NULL,NULL,NULL,'201462f8-ba2a-4661-84ed-78215a573b9d'),
(614,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-03 21:56:35','2025-10-08 18:25:13',NULL,NULL,NULL,'1c2571b2-105d-4981-882f-33972a3fa4f6'),
(616,601,NULL,301,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:56:43','2025-09-03 21:56:43',NULL,NULL,NULL,'271d147f-fb1b-4556-92ef-f203c3166ec0'),
(617,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:56:43','2025-10-03 20:24:49',NULL,NULL,NULL,'17aedcab-15f5-449a-a2ee-a3f262aa4476'),
(618,617,NULL,302,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:56:47','2025-09-03 21:56:47',NULL,NULL,NULL,'87697077-a17f-4c23-aae4-1a85ccbe1848'),
(619,617,NULL,303,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:56:57','2025-09-03 21:56:57',NULL,NULL,NULL,'7cdd5ba4-6db4-41b5-9831-12e4bdbcac37'),
(621,617,NULL,304,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:57:10','2025-09-03 21:57:10',NULL,NULL,NULL,'13fcae8c-1e31-42a7-8a3a-cb30b2361924'),
(623,605,NULL,305,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:58:30','2025-09-03 21:58:30',NULL,NULL,NULL,'396501be-a3ae-4f36-9f6a-93100cf965c8'),
(624,NULL,280,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-03 21:58:41','2025-09-03 21:58:41',NULL,NULL,NULL,'d1a40978-5caf-4aae-a94d-4f2bc707514c'),
(625,2,NULL,306,1,'craft\\elements\\Entry',1,0,'2025-09-03 21:59:11','2025-09-03 21:59:11',NULL,NULL,NULL,'b5ebfcfa-bdca-43d6-be70-54ef931f1886'),
(627,2,NULL,307,1,'craft\\elements\\Entry',1,0,'2025-09-03 22:00:27','2025-09-03 22:00:27',NULL,NULL,NULL,'4f1169ce-377f-4715-9313-747ce51ebf82'),
(629,601,NULL,308,5,'craft\\elements\\Entry',1,0,'2025-09-03 22:13:41','2025-09-03 22:13:41',NULL,NULL,NULL,'f99e598e-5b3f-408e-a17b-84356450ed28'),
(630,2,NULL,309,1,'craft\\elements\\Entry',1,0,'2025-09-03 22:13:43','2025-09-03 22:13:43',NULL,NULL,NULL,'ee2306c4-1096-43a3-a639-4da1cc2cdd16'),
(632,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-09-03 22:27:11','2025-09-03 22:27:11',NULL,NULL,NULL,'091c844c-50d7-4e50-bafa-a6bf56239538'),
(634,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-09-03 22:27:23','2025-09-03 22:27:23',NULL,NULL,NULL,'a5ef07ab-c50e-4220-a35a-0951d700536e'),
(636,2,NULL,310,1,'craft\\elements\\Entry',1,0,'2025-09-03 22:27:29','2025-09-03 22:27:30',NULL,NULL,NULL,'927bb0f8-4b17-4c65-8d99-1f778f903322'),
(637,44,NULL,311,2,'craft\\elements\\Entry',1,0,'2025-09-03 22:27:30','2025-09-03 22:27:30',NULL,'2025-09-11 18:48:35',NULL,'0fceaddd-72a5-45fd-84d0-23dab07d78bb'),
(638,445,NULL,312,2,'craft\\elements\\Entry',1,0,'2025-09-03 22:27:30','2025-09-03 22:27:30',NULL,'2025-09-11 18:48:35',NULL,'d1d14c83-6091-4c8f-a603-acc72dd8de77'),
(640,2,NULL,313,1,'craft\\elements\\Entry',1,0,'2025-09-03 22:28:47','2025-09-03 22:28:47',NULL,NULL,NULL,'7ab34e60-a78f-445e-8ea3-e5b9c1dee16e'),
(643,294,NULL,314,12,'craft\\elements\\Entry',1,0,'2025-09-05 20:01:00','2025-09-05 20:01:00',NULL,'2025-09-19 17:25:28',NULL,'7eafbe4f-c358-4e15-881c-a9746014b665'),
(645,294,NULL,315,12,'craft\\elements\\Entry',1,0,'2025-09-05 20:01:26','2025-09-05 20:01:26',NULL,'2025-09-19 17:25:28',NULL,'6047d60c-06f7-41db-a671-e6e8a8bb216d'),
(646,294,NULL,316,12,'craft\\elements\\Entry',1,0,'2025-09-05 20:01:55','2025-09-05 20:01:55',NULL,'2025-09-19 17:25:28',NULL,'be7fa520-3857-4afe-84d0-cdae09d42dce'),
(647,2,NULL,317,1,'craft\\elements\\Entry',1,0,'2025-09-11 17:30:28','2025-09-11 17:30:28',NULL,NULL,NULL,'1fce243f-20e5-4f45-8c7b-053b878a1e6b'),
(648,2,NULL,318,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:32','2025-09-11 18:16:32',NULL,NULL,NULL,'5b2c04e8-b905-4f6e-88ee-898ee7839269'),
(649,56,NULL,319,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:32','2025-09-11 18:16:32',NULL,NULL,NULL,'905845c7-66b1-4db1-b559-6bb13b4b2de9'),
(650,57,NULL,320,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:32','2025-09-11 18:16:32',NULL,NULL,NULL,'bbd10392-6dde-4d9e-aeee-ef45959ee705'),
(651,63,NULL,321,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:32','2025-09-11 18:16:32',NULL,NULL,NULL,'588cd696-05da-4324-8587-dbecd42c1b68'),
(652,44,NULL,322,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:32','2025-09-11 18:16:32',NULL,'2025-09-11 18:48:35',NULL,'592458e2-0949-4bca-a262-241135ba53d1'),
(653,445,NULL,323,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:32','2025-09-11 18:16:32',NULL,'2025-09-11 18:48:35',NULL,'8a8c63d2-f9b9-4bd0-99ae-6afa17215b68'),
(834,2,NULL,414,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:35','2025-09-11 18:16:35',NULL,NULL,NULL,'82fd5379-edc8-473e-8eae-0a4c38627028'),
(835,56,NULL,415,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:35','2025-09-11 18:16:35',NULL,NULL,NULL,'3d2e1b65-21e5-4b61-b39d-7af3c6514782'),
(836,57,NULL,416,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:35','2025-09-11 18:16:35',NULL,NULL,NULL,'7201ab16-8f87-4eb4-863f-9741b570da54'),
(837,63,NULL,417,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:35','2025-09-11 18:16:35',NULL,NULL,NULL,'faffecea-e5ff-4d44-9c15-2e6482072e68'),
(838,44,NULL,418,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:35','2025-09-11 18:16:35',NULL,'2025-09-11 18:48:35',NULL,'00d844b9-3946-4447-8a9f-ea6423199e05'),
(839,445,NULL,419,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:16:35','2025-09-11 18:16:35',NULL,'2025-09-11 18:48:35',NULL,'913a6407-8c18-4354-bce7-684f37a61b0a'),
(932,2,NULL,511,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:17:21','2025-09-11 18:17:21',NULL,NULL,NULL,'2d1fd9af-d8bc-4fdb-826e-d8170fef5752'),
(937,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:16',NULL,'2025-09-11 18:51:16',NULL,'24f55e9b-db5a-4235-9480-ab15fa446afa'),
(938,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:16',NULL,'2025-09-11 18:51:16',NULL,'a2418a26-2f30-4381-89b0-90c4cbe3dacb'),
(939,2,NULL,512,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'0608e6fd-701b-4ef9-bfb2-28202ae1886c'),
(940,56,NULL,513,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'a553cc4e-8e7d-4709-a19b-8d2cd234b877'),
(941,57,NULL,514,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'f56b37f2-34d1-4730-badb-a114a02b6029'),
(942,63,NULL,515,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'a4f6d4e7-738c-4de1-8dd5-e4e4ce07d859'),
(943,937,NULL,516,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:16',NULL,'773f8d6e-dfed-4e6e-83ab-6393a3764e56'),
(944,938,NULL,517,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:16',NULL,'c436d386-fa7b-4585-8b4c-e08d05082488'),
(945,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-08 22:19:59',NULL,NULL,NULL,'48a6c670-2b37-4c4d-8fd4-53ac20d90d2e'),
(946,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:16',NULL,'2025-09-11 18:51:16',NULL,'4677fc2c-6108-4598-bf64-bb392f01fb31'),
(947,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:16',NULL,'2025-09-11 18:51:16',NULL,'f6d15841-9c18-449c-9709-1cd9541bfcad'),
(948,945,NULL,518,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'d00d49ed-451a-4fdb-b911-c0dd3830e8f8'),
(949,946,NULL,519,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:16',NULL,'23bd81a5-b057-407f-9a12-423c4b17248f'),
(950,947,NULL,520,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:16',NULL,'429de7e3-148b-4e9e-b6f2-6e307adc6d7a'),
(951,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-08 22:29:34',NULL,NULL,NULL,'41b0861e-5cf7-40dd-9483-713f223be7e6'),
(952,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'b98b3342-f7f3-4cf7-a606-dfb8d8c57213'),
(953,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'7d66e02a-7cd7-43c9-b9f7-242ee195d3c9'),
(954,951,NULL,521,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'fee03515-569f-49ee-adf2-268d99539a65'),
(955,952,NULL,522,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'5e020e4c-9336-4523-a3b6-35fd878e2937'),
(956,953,NULL,523,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'408b201e-e403-43ec-ac8e-74c31393f3af'),
(957,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-08 22:20:19',NULL,NULL,NULL,'e399c88e-b5dc-4726-a6ed-2abac9d595cb'),
(958,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'c8a9aff4-6509-4848-8d3d-9f4311033df8'),
(959,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'14f9dc98-7af4-4950-8606-ecec2f3929d4'),
(960,957,NULL,524,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'e8874927-9f48-44ab-8399-c26f2b036a0d'),
(961,958,NULL,525,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'2448fede-bcb5-4ace-98a8-aff6695e4df6'),
(962,959,NULL,526,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'dc2ae1c5-62d2-40ce-8ed1-24d8733e65a1'),
(963,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-08 18:52:55',NULL,NULL,NULL,'73fa4e85-c923-4543-bb10-e2c4af7a8a17'),
(964,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'d81c823d-a779-49e9-a216-23cfb46cb460'),
(965,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'c254f4b1-a25c-4871-9fd3-69b5afebe8e6'),
(966,963,NULL,527,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'a21fa523-80fb-46ea-805c-0c79a2c01954'),
(967,964,NULL,528,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'3b464a7a-52fc-4e24-99dd-2d4eb9706fae'),
(968,965,NULL,529,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'dd64d8f9-be2f-40d1-a9ca-4b9f3cb36958'),
(969,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-08 19:00:47',NULL,NULL,NULL,'07e32559-1a52-481c-b6b0-cf9c82ae6850'),
(970,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'4d8952f3-ed9d-425f-9e15-5fe6f7bf26b6'),
(971,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'93a39675-83de-4d41-baf4-5f48eee70b29'),
(972,969,NULL,530,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'c5660b75-e1ce-4318-829a-c60ac71b25e8'),
(973,970,NULL,531,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'3b3fa9f9-a462-4c4c-af1f-83cd52d5b165'),
(974,971,NULL,532,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'5cf0cb2a-e814-4b30-b488-c2c1cfb581d2'),
(975,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-08 19:59:16',NULL,NULL,NULL,'2dc195b1-ef47-4f8b-8fe9-340e9da84901'),
(976,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'faa48ae5-3e79-4c59-bdc6-2aa586af5553'),
(977,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'5a8b5a39-85df-41bb-ac1e-10d860fe42e0'),
(978,975,NULL,533,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'67175160-28fc-4c6a-a070-f0ba8162580d'),
(979,976,NULL,534,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'d210c426-699d-4eea-b8e5-a8b22c5e5779'),
(980,977,NULL,535,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'4bd07ed0-8527-413c-9091-b6850b773e2c'),
(981,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-10-08 20:26:01',NULL,NULL,NULL,'1ce07899-fff0-4291-a8ab-81cc5f758ceb'),
(982,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'89785f90-186f-4e20-92e2-e4e13eb3fc91'),
(983,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'a60ca119-2b59-4ec7-9c47-0b6792cb9a53'),
(984,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'f8804960-fbb9-4691-82e6-47af75a67885'),
(985,981,NULL,536,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'2ff31236-ba07-46cb-8b22-885f7da30d1c'),
(986,982,NULL,537,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'f60b78b7-d499-4613-b9b2-3553ca165c5d'),
(987,983,NULL,538,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'f7435bea-b704-4e70-8961-143d3c3c1579'),
(988,984,NULL,539,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'cffbb52c-6dd3-4743-9b5d-a7ef325b2175'),
(989,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 20:39:30',NULL,NULL,NULL,'24ff8e10-f560-4744-b23a-be3b06e92a17'),
(990,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'55bd04a3-719f-48ca-b282-f2dd4556d0a2'),
(991,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'ce6367da-e26a-4506-a8ab-ce07526e1b47'),
(992,989,NULL,540,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'8886d22b-fe27-466a-b242-7a796f6f2f45'),
(993,990,NULL,541,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'122bb9c9-b72a-463f-9f48-f8cbaed95ea6'),
(994,991,NULL,542,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'74190f3a-9041-428a-b16e-ee4741323fee'),
(995,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 20:39:30',NULL,NULL,NULL,'9e6b6166-fdac-4d25-a9fd-5af0c347d533'),
(996,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:17',NULL,'2025-09-11 18:51:17',NULL,'430a0992-651a-4999-8ab8-3ec562e0a769'),
(997,995,NULL,543,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'7cf080d4-86a9-4aaa-b315-118ae1207f6e'),
(998,996,NULL,544,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:17',NULL,'d1d4a4a6-1fd3-447f-b00f-bed7b6dcbab5'),
(999,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 20:39:30',NULL,NULL,NULL,'6e18b054-3c3d-4c80-b7f6-2f7880b2b470'),
(1000,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'a221ac78-813c-4565-a618-069c18a125bd'),
(1001,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'4827e856-5dff-48af-b34b-97be57272aaf'),
(1002,999,NULL,545,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'e891c1c5-3d90-4227-94fa-cef374a97e4b'),
(1003,1000,NULL,546,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'7ffbf820-c595-4969-a049-c838993ee417'),
(1004,1001,NULL,547,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'e606e83b-c362-4d1f-aa6f-1c9fe4541cff'),
(1005,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 20:39:30',NULL,NULL,NULL,'5a87fb4c-c5fd-47b4-869e-ec6321ddf8d9'),
(1006,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'3de731a8-bb64-4220-8e1f-15102b5d8ee1'),
(1007,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'3414182c-7409-4c4f-a868-6c5f349bcd3c'),
(1008,1005,NULL,548,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'dda5d0cb-58f2-4149-958f-32b48f2bf45d'),
(1009,1006,NULL,549,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'9c234813-244f-415d-9dd0-21715c828f5f'),
(1010,1007,NULL,550,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'cbe40bb5-8ea1-4a4b-9770-3985889f0b8e'),
(1011,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 20:39:30',NULL,NULL,NULL,'95bbd3aa-0bb6-4efa-a47a-610d2b4e2cb3'),
(1012,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'6f95a7aa-4f67-469f-8038-8afcdb7c9685'),
(1013,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'c5bb4917-076b-4924-aec1-fd0c4f79a42c'),
(1014,1011,NULL,551,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'27bbd0e6-a56f-4a3f-8839-fd58d1be5299'),
(1015,1012,NULL,552,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'4e7c266d-b559-4240-af3a-f6a2b9e4360c'),
(1016,1013,NULL,553,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,'2025-09-11 18:51:18',NULL,'13978b24-0157-45b8-b886-e9785b0e7126'),
(1017,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 20:39:30',NULL,NULL,NULL,'ce3eb7f7-2f87-4b59-9c53-05e0f3c21178'),
(1018,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'856571b0-b255-41c6-a5ae-a33bc32ab06c'),
(1019,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'c4a42116-23b5-4e52-a424-0c665420ab56'),
(1020,1017,NULL,554,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:35',NULL,NULL,NULL,'cd4d931f-c631-47a8-8828-141c1add0474'),
(1021,1018,NULL,555,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'9cf29ee2-f40a-4ef9-ac7d-18404b1d9b61'),
(1022,1019,NULL,556,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:35','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'7c7e60b6-0853-480d-8577-ba223745e3ed'),
(1023,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:30',NULL,NULL,NULL,'f2039029-4db6-41fc-921f-6c250bc2b9d7'),
(1024,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'8d5e81f6-0e55-41b8-8147-3c13b5c87e67'),
(1025,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'668a4d24-7a2a-4c68-9eeb-6c95e34557bd'),
(1026,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'0d0fa5bf-4df1-4cf8-8f5c-24033275e48a'),
(1027,1023,NULL,557,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'cf8f523b-2ab7-4b05-8d54-9f197787cf21'),
(1028,1024,NULL,558,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'de20176b-6d25-4248-867c-9a8d438ac844'),
(1029,1025,NULL,559,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'0a9d5a84-0170-4d86-9106-105a3cb1a981'),
(1030,1026,NULL,560,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'6cff5b11-ddd8-4bd5-99a9-46539fc264ae'),
(1031,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:31',NULL,NULL,NULL,'950498f4-be9d-468b-a88c-f8c53d277de3'),
(1032,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'e0e830b2-2fe5-4efe-a492-5e1071461d5d'),
(1033,1031,NULL,561,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'93d7bde7-5e6f-49e9-b08e-455f032272e1'),
(1034,1032,NULL,562,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'d6be10d9-eee2-48c5-90db-d4f0b2c95a8d'),
(1035,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:31',NULL,NULL,NULL,'4c1f47b4-c776-4a3d-91bf-971cca51fc46'),
(1036,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'b1af9f9e-abb0-4b93-9b79-b41ad65d5667'),
(1037,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'b9615338-fd34-496d-b5b4-a1aedd0ec222'),
(1038,1035,NULL,563,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'5c1a9229-e14b-451a-b8c1-1e924c7e046c'),
(1039,1036,NULL,564,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'88a3cd53-502a-4fe7-83b5-4b381adcf1c8'),
(1040,1037,NULL,565,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'65be40ee-c2e1-472f-be8a-2639abc82794'),
(1041,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:31',NULL,NULL,NULL,'3de194dc-8f35-4e34-862d-7ec10c5e8f04'),
(1042,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:18',NULL,'2025-09-11 18:51:18',NULL,'5baa6d92-c54a-4dc2-8217-dd570508fd35'),
(1043,1041,NULL,566,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'636fe767-0234-4469-80ab-8bbf0036bac8'),
(1044,1042,NULL,567,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:18',NULL,'9f984eb8-4779-4ee1-b5ed-ba9f407893d1'),
(1045,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-10-06 16:09:49',NULL,NULL,NULL,'dec3ccf7-835a-4e35-8f30-b2b10064595e'),
(1046,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'0102d6b3-5998-40fc-93e2-ac2442ddb221'),
(1047,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'af9ae13b-1806-43f1-9cd4-d01bf7ea63db'),
(1048,1045,NULL,568,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'966f7852-e2ba-4820-93ab-097a0f43f29d'),
(1049,1046,NULL,569,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'d76acbc8-371a-40ac-bd6f-602642269fd9'),
(1050,1047,NULL,570,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'34283c57-d2ab-4f7a-83ca-aee032db2306'),
(1051,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:31',NULL,NULL,NULL,'7ecdfcf7-57f3-4966-92e3-a846e195f1f0'),
(1052,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'3953c615-c4f9-4b23-b206-81680036bf19'),
(1053,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'50fb3de6-c544-4fae-ba32-9c102626cde3'),
(1054,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'891675f1-6ee0-45e7-a0ee-c5f1def29961'),
(1055,1051,NULL,571,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'746107ef-7585-441e-90aa-bfcee8ce2a05'),
(1056,1052,NULL,572,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'0ad6941f-640f-497f-a520-3f6f0d612754'),
(1057,1053,NULL,573,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'bd598fbf-d50d-4281-9c88-da2c39fe2bd3'),
(1058,1054,NULL,574,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'f3e4bff4-6dd7-459b-81ab-324d84025de5'),
(1059,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-22 18:42:30',NULL,NULL,NULL,'1db34b40-992e-4b6a-957b-2ab444012d2d'),
(1060,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'82dd976d-5d80-4d37-91c2-975c5bfa56b7'),
(1061,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'69532f71-ad21-4e1f-8838-d65bfcaf6fb2'),
(1062,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'35450d10-89b4-4158-a5c5-02e9ce986870'),
(1063,1059,NULL,575,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'bb9c87b2-9543-4600-8052-8186727edb3c'),
(1064,1060,NULL,576,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'3320e605-1717-45f8-b8cb-051aa2ad09d2'),
(1065,1061,NULL,577,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'fad8af60-3f9b-4e49-8dce-0b22322826ff'),
(1066,1062,NULL,578,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'a7f11528-4355-46a5-9bf5-8564a92ea7a7'),
(1067,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:31',NULL,NULL,NULL,'3e896674-276a-4fac-9bae-6043a7566c71'),
(1068,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'1ea44685-d248-47ea-a73f-c1c827d519db'),
(1069,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'ffafd33f-b84a-4f08-9c4f-eb356107eb89'),
(1070,1067,NULL,579,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'096a387c-cf17-4eb7-baee-66df6d186421'),
(1071,1068,NULL,580,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'43db53d3-3109-4eaa-ab04-7792f01bd012'),
(1072,1069,NULL,581,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'bac4d24a-213e-45d3-99c3-97f84f2c20c8'),
(1073,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:31',NULL,NULL,NULL,'cf2218ca-b445-43a5-9a1f-3eb02abce60c'),
(1074,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'a5d8c15e-e74c-42ca-a88e-07f359c881fa'),
(1075,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'fea85ae0-fddf-4c69-b29b-41a708363761'),
(1076,1073,NULL,582,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'e3331081-443b-456e-8bdc-49788985f4d5'),
(1077,1074,NULL,583,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'2f0a8a72-810c-4661-9912-0cb05b93f112'),
(1078,1075,NULL,584,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'3eb1a75d-afb1-49e9-8bff-d4863316d87b'),
(1079,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:31',NULL,NULL,NULL,'5ae1ceec-e10f-482d-9b12-2d210b34fc9c'),
(1080,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'4f3429eb-9312-4dc9-87b3-f10cb743c365'),
(1081,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'40bc5374-c46c-4484-95ae-bc223a6c29c5'),
(1082,1079,NULL,585,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'b3b33bb7-7fdc-4d82-a425-80bc21f95332'),
(1083,1080,NULL,586,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'8ee0a6fc-a030-4d6c-ab6b-22b9dcab8887'),
(1084,1081,NULL,587,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'bdba192b-c83b-4bcf-87a1-15c2dfac991d'),
(1085,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:31',NULL,NULL,NULL,'560ed462-30a9-4c94-a0de-7d5cbce1bb13'),
(1086,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'964b1887-b339-4799-bc22-3d38f1bcec99'),
(1087,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:19',NULL,'2025-09-11 18:51:19',NULL,'170b6a26-1f00-43fd-a16d-b8e1de89f362'),
(1088,1085,NULL,588,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'ab6e9010-8c9d-43fd-9921-66e64b8f3ab1'),
(1089,1086,NULL,589,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'cce369e7-aff6-45ee-b1d0-f4d8e1ef17ed'),
(1090,1087,NULL,590,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:19',NULL,'ad74462a-0acc-45d9-88f3-74dbd4ac8ccb'),
(1091,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:32',NULL,NULL,NULL,'af8ab057-06a9-44da-a782-bce073caf3f7'),
(1092,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'1ab57f16-7dd2-438e-a80d-55d999c71173'),
(1093,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'19434827-facd-4a27-a494-9872800b7c00'),
(1094,1091,NULL,591,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'f310452f-bef2-43da-955e-ab8bbcfa8936'),
(1095,1092,NULL,592,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'f765ad23-369d-4e1e-9b9a-6d08b3eef309'),
(1096,1093,NULL,593,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'e183a3be-1a97-4aba-b30e-f87a1b5254ee'),
(1097,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:32',NULL,NULL,NULL,'e6a0a789-a128-4e9b-877e-cc076269bc49'),
(1098,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'c0cd0323-daed-4e05-964d-af8a63249fa5'),
(1099,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'cbb49a99-c13e-4eba-8c34-6b8a23387b19'),
(1100,1097,NULL,594,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'e6edc4a4-2f7c-41cf-8384-f76b0f961a5b'),
(1101,1098,NULL,595,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'87a71333-86d7-4929-a0cf-353398a98599'),
(1102,1099,NULL,596,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'c1e44615-926b-4d1c-882a-0bd8360c9c30'),
(1103,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:32',NULL,NULL,NULL,'f53d9228-7793-482e-ad9e-9266a29f470d'),
(1104,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'f7c584cc-48e7-443b-90ff-acf209238b46'),
(1105,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'338f45dd-aa66-42a4-85c1-bb6256261b91'),
(1106,1103,NULL,597,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'5bff26aa-4fa4-4926-8f2d-625ffd7225d3'),
(1107,1104,NULL,598,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'f70e062a-9e97-48e5-b354-19a4e919e692'),
(1108,1105,NULL,599,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'ef740bed-8b65-4b82-98a6-0027eeeeec08'),
(1109,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:32',NULL,NULL,NULL,'398ec3ba-8547-4d8c-a91c-a2de31cf9d20'),
(1110,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'2b7e749b-c62a-4693-a91a-46f8b6ddcba2'),
(1111,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'6e2b9404-765f-4991-be6b-a12b2991259d'),
(1112,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'14548fc8-ebd3-4568-889c-d54db90c442c'),
(1113,1109,NULL,600,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'844070a9-93f6-437e-96ea-3f24a1fe5866'),
(1114,1110,NULL,601,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'2e6602ca-b53e-4dec-81ac-01c98ac5f553'),
(1115,1111,NULL,602,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'05ec7e05-5c60-4b67-882e-66edaf355367'),
(1116,1112,NULL,603,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'c6c82188-bb68-421b-90c7-28bb67edbd81'),
(1117,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 20:39:32',NULL,NULL,NULL,'a08d8d64-84ed-4630-94bb-e92bb7619949'),
(1118,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'8bf0c634-b6dd-4835-a858-7057529489d2'),
(1119,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'cf758b45-6e11-4945-90c5-db861a5d0b8f'),
(1120,1117,NULL,604,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,NULL,NULL,'f4d033fd-dcd7-43cb-aef9-37d702ce7efa'),
(1121,1118,NULL,605,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'d1ab9b0d-752d-4163-b91e-123f67052b84'),
(1122,1119,NULL,606,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:36','2025-09-11 18:48:36',NULL,'2025-09-11 18:51:20',NULL,'dc20d49e-5b88-4a95-af7e-d615672a0254'),
(1123,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:32',NULL,NULL,NULL,'5706c4a0-fcfc-4823-a969-32440ed553a3'),
(1124,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'3fe3895a-f641-40f0-91f0-a2121e5e757c'),
(1125,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'e8fe88b5-9df3-430c-8f7f-3f6d22cfa580'),
(1126,1123,NULL,607,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'6564539b-e5a1-48dd-8d99-f86a99df55e0'),
(1127,1124,NULL,608,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:20',NULL,'d852d746-ed46-4090-9777-9211be73fde7'),
(1128,1125,NULL,609,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:20',NULL,'452d4af9-a048-4f88-9abc-bf8f8e74f3da'),
(1129,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:32',NULL,NULL,NULL,'28a28f32-135b-474d-9045-2fb69fbcde32'),
(1130,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'18e5ed3e-7421-486b-bb13-99055ff0fb06'),
(1131,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:20',NULL,'2025-09-11 18:51:20',NULL,'2e0c9d8b-55c1-48c5-9a02-d2737801c6c6'),
(1132,1129,NULL,610,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'291813ba-7229-4de4-aba7-911ce4ac6394'),
(1133,1130,NULL,611,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:20',NULL,'0949fa92-a911-4736-bf34-7e8223a20bbe'),
(1134,1131,NULL,612,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:20',NULL,'714fd2cd-0dd2-435d-a421-ba319c18ce94'),
(1135,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:32',NULL,NULL,NULL,'5851bd11-29aa-43b3-b611-fc88dd5e211d'),
(1136,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'c6dee479-40b3-430e-9858-341e650d0ab5'),
(1137,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'05d9e4a1-4db0-4349-abc1-7b8c59745877'),
(1138,1135,NULL,613,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'7708f32d-a59e-406a-840f-f9bf1dd0b749'),
(1139,1136,NULL,614,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'42a075b2-2fef-4890-9730-78a79bbc30d6'),
(1140,1137,NULL,615,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'3e62702c-29e4-422e-8ca8-7339310e88c5'),
(1141,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 19:22:03',NULL,NULL,NULL,'1d957e72-1e3c-4f74-8b78-4c0e762aab48'),
(1142,1141,NULL,616,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'4f267a08-11ce-418a-ac1f-6be097019354'),
(1143,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:32',NULL,NULL,NULL,'44c0f461-8c7c-4f47-b5f0-717c1c50c7a2'),
(1144,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'87aaf7fe-938f-4de7-b373-ee459a264923'),
(1145,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'f8873476-c276-43f1-8542-a4caab1bd3ba'),
(1146,1143,NULL,617,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'d4e60a3a-c323-4be2-a57f-0f627737705a'),
(1147,1144,NULL,618,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'98327891-4a30-40db-a2b7-fdc217b74322'),
(1148,1145,NULL,619,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'1cf2fd55-9139-4883-a3cc-dde3e269c2bf'),
(1149,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 19:17:42',NULL,NULL,NULL,'f381df8f-e64f-4bf2-abd8-61cbfcceaea2'),
(1150,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'a1bbd559-8b53-4167-9115-4e2adef24804'),
(1151,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'ec1adc96-db31-484b-b38c-762fcaaebf7b'),
(1152,1149,NULL,620,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'b136a7dc-9afb-4472-b693-4b52744631b4'),
(1153,1150,NULL,621,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'483bcb91-61eb-4e71-8b68-de6a6513779a'),
(1154,1151,NULL,622,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'43714484-1768-4f83-9ab6-d30e57461fb1'),
(1155,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:32',NULL,NULL,NULL,'c0f22461-831a-49b7-a594-09cc88d08098'),
(1156,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'e4a3bdea-6875-4e60-8be9-d7277eb27ef3'),
(1157,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'55922826-85ab-4780-b623-cadf0c9ea182'),
(1158,1155,NULL,623,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'b8b1578f-dc37-484b-8dab-37b24bd9377b'),
(1159,1156,NULL,624,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'04167b78-fc6a-4be2-a302-8f0b94c0d779'),
(1160,1157,NULL,625,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'ce0d8389-1634-4dbf-9e2d-6074319bdde7'),
(1161,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:33',NULL,NULL,NULL,'09b0cfa0-a3e5-4ad8-996a-8faaef93dada'),
(1162,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'08ecada2-bf45-40c5-b6b0-c36dc2b4d165'),
(1163,1161,NULL,626,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'9c9f8d12-26af-44ec-bf64-114ad399c910'),
(1164,1162,NULL,627,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'e0281d02-7c77-4091-bd6e-6cbd38edf2bc'),
(1165,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-10-08 22:20:15',NULL,NULL,NULL,'c7655616-7d4f-4c6a-b370-6126b174a372'),
(1166,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'c1ebe08d-fbf7-4c2f-9604-00444aeb05ad'),
(1167,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'85ec9aa3-6b87-4275-a805-73f2756601fa'),
(1168,1165,NULL,628,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'174a460d-f3ba-4c8a-abb3-59cac5feb1a1'),
(1169,1166,NULL,629,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'ef46220a-5e22-4147-af65-ea20db188176'),
(1170,1167,NULL,630,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'5f5b36d1-8f54-4130-ae14-2caeb4bb9092'),
(1171,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-24 15:56:11',NULL,NULL,NULL,'055d79fb-6463-4d54-8399-b6ebcc287543'),
(1172,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'1a1d4edf-2a46-43b7-90d1-7678aac6b95b'),
(1173,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:21',NULL,'2025-09-11 18:51:21',NULL,'daa5ed51-917d-4918-ad5f-14e19f004c46'),
(1174,1171,NULL,631,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'c63f66be-908a-45f6-b664-2ae9dffa1cd9'),
(1175,1172,NULL,632,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'69fb9b60-8113-4fe7-9933-15d763968daa'),
(1176,1173,NULL,633,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:21',NULL,'a1c4bb3b-e362-4186-9cd4-a0dc87724a6d'),
(1177,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-29 18:35:55',NULL,NULL,NULL,'2be2bbd1-385e-425c-8c2d-272477117748'),
(1178,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:48:37',NULL,'6cf406cf-7a73-438a-a35e-55085b1c4834'),
(1179,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:48:37',NULL,'c9bc5e99-f0a9-48bc-ba8d-ee7a89618626'),
(1180,1177,NULL,634,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'70f1a720-5733-4000-bf9a-20bfec84c620'),
(1181,1178,NULL,635,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:48:37',NULL,'a5299d6f-50e5-4c68-b2db-a911bf3d23de'),
(1182,1179,NULL,636,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:48:37',NULL,'93f7c789-d10a-41e7-905e-175963ccd047'),
(1183,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'7551bf18-63d6-4aee-979e-50600aaa5011'),
(1184,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'9396d020-e2c9-4503-a79a-d588a1c57003'),
(1185,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:33',NULL,NULL,NULL,'89bfa064-7f1a-4480-81eb-bbb78109087f'),
(1186,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'13112f7e-6a50-47cc-85cf-753fcea43111'),
(1187,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'fd5765c6-f665-4a02-815a-5105814ce806'),
(1188,1185,NULL,637,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'526e17f0-4799-4b50-9003-7cae2871fa1f'),
(1189,1186,NULL,638,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'baaa85fd-6100-4868-9429-3e10c48fad6c'),
(1190,1187,NULL,639,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'90b682ef-348b-41a1-b39a-d44e3681d170'),
(1191,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:33',NULL,NULL,NULL,'c917f067-e6d1-42f1-ba71-c9910cdf356f'),
(1192,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'da1a0e04-418a-42e0-a960-44584a7fdb5f'),
(1193,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'9994b8b2-4b7a-43fa-9170-eb4dbec75df9'),
(1194,1191,NULL,640,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'41b9e46c-fa99-46a8-9723-1526a6fa1e6d'),
(1195,1192,NULL,641,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'a37bc56c-550d-4537-8481-97b30c9fc51e'),
(1196,1193,NULL,642,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'5bbd680a-d39e-4ba0-8a2a-39d4704344f9'),
(1197,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:33',NULL,NULL,NULL,'a6698012-4054-4391-80ee-3f26c63ac0cf'),
(1198,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'ad2eba91-fdd1-4990-9a43-f7f0141ca539'),
(1199,1197,NULL,643,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'68d70228-e975-4723-93e4-bb1d919ac31e'),
(1200,1198,NULL,644,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'921c7a77-e591-405c-b040-34de76b14d8f'),
(1201,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:33',NULL,NULL,NULL,'b5c6ccd8-0e99-4efd-a495-8c5c49b45f2d'),
(1202,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'86fdea10-7626-43bc-bbe9-964584761c5d'),
(1203,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'ebe0438c-7661-4587-b14e-a83a21ad065b'),
(1204,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'2d327abb-b910-440f-8f3b-42793de72379'),
(1205,1201,NULL,645,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'4aeac103-0513-44b2-a75b-22fe41ff94a9'),
(1206,1202,NULL,646,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'c713e2b3-a3c2-4d20-bab6-66bae092be4d'),
(1207,1203,NULL,647,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'a17a7dc7-5a10-48fd-8429-362e1ad4b425'),
(1208,1204,NULL,648,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'45a9f629-d9c6-42fa-b588-eddba6553542'),
(1209,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:33',NULL,NULL,NULL,'6426c6e4-aede-4aab-8e51-3605bafda3f2'),
(1210,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'b7dc73bf-effb-4665-b518-2a72a327f95d'),
(1211,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'08f6f1b5-8aff-4d05-8675-164e9b04171c'),
(1212,1209,NULL,649,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'b3eda0a4-8a43-4e74-9355-17b70cee35dc'),
(1213,1210,NULL,650,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'051bd566-20a6-42fe-8817-296144e44534'),
(1214,1211,NULL,651,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'4af34744-eeea-4260-8231-ca668cc192a4'),
(1215,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:34',NULL,NULL,NULL,'5bd94697-9fd6-4d4e-8848-3fe542b3bbda'),
(1216,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'6d71c8ab-c698-4295-b08f-ffa9061c8077'),
(1217,1215,NULL,652,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,NULL,NULL,'12bd724e-8184-4679-9b88-20a39863abf8'),
(1218,1216,NULL,653,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:37',NULL,'2025-09-11 18:51:22',NULL,'8c43b830-8619-42d3-ab08-94055ea805c2'),
(1219,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 20:39:34',NULL,NULL,NULL,'a2c697ad-df34-4492-a9f1-dae21a012b6d'),
(1220,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'c6b85159-a923-4cec-9fff-f03161a2efcc'),
(1221,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'5a2a6dfc-82b9-4dcd-8e8f-4c94f5de0e3d'),
(1222,1219,NULL,654,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:38',NULL,NULL,NULL,'dcb64168-cb4b-4687-9e89-63890ed5f69c'),
(1223,1220,NULL,655,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'34480a28-3cd6-4794-a923-a7376e674dbd'),
(1224,1221,NULL,656,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:37','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'9ea4b749-d616-48e8-a736-a7f1f2fdf7f7'),
(1225,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:34',NULL,NULL,NULL,'37807e51-bdf9-484c-9984-d3175d293933'),
(1226,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'7204ee6d-8c0a-440d-bbed-ed5ba7c73566'),
(1227,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'f4abdad0-9da1-4584-a755-1ac496074fea'),
(1228,1225,NULL,657,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'a03b6bc5-7bd1-49f0-9358-98d36fdcce53'),
(1229,1226,NULL,658,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'957a9562-56ee-4531-a1b4-e1a063f06e7d'),
(1230,1227,NULL,659,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'6a8f51cd-ead9-4e95-a103-3517f084165a'),
(1231,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:34',NULL,NULL,NULL,'8f0d2923-6550-4757-8bea-573605d2135f'),
(1232,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'0bb10668-8b22-44b4-b00b-62a7aa051d2f'),
(1233,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'1fb3327e-b3f2-4b5c-954c-6bf74d4c60bf'),
(1234,1231,NULL,660,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'23ddadd8-f438-4ec7-9cf8-a36731a6a9d1'),
(1235,1232,NULL,661,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'f8b0db55-cdf6-4da2-b2e2-a90cb9710d08'),
(1236,1233,NULL,662,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'fa93c549-eba1-48dc-b3b6-f0d7638eed41'),
(1237,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:34',NULL,NULL,NULL,'831198a5-a1c7-4506-9bac-ba8a760422f7'),
(1238,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'bbd52683-b622-4e7f-a893-a0cdd535a5fa'),
(1239,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'9c20ffff-befb-443f-90d7-7a162a6452a5'),
(1240,1237,NULL,663,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'1c693d24-a2ba-4121-9892-11d95b30c106'),
(1241,1238,NULL,664,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'b1d6c857-74a6-49d3-b4dd-bf7bd6514fa5'),
(1242,1239,NULL,665,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'07a0b9a0-d137-487e-b40e-389d89424067'),
(1243,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:34',NULL,NULL,NULL,'c5279fef-fc70-454a-9f6b-c8eb84670bf9'),
(1244,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'26e0a0a0-a0c2-4f9b-9a1f-509afdfd0ab6'),
(1245,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'a977cfb5-6806-4611-b0f7-5e758613bd40'),
(1246,1243,NULL,666,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'27795513-a0ac-4529-a8a2-148532aa4999'),
(1247,1244,NULL,667,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'d69d680d-89a1-48b0-bb0c-a2883c2c3be2'),
(1248,1245,NULL,668,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'6c658dea-614a-4ef3-9b57-bd4425deb5a0'),
(1249,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:34',NULL,NULL,NULL,'98f6c7e0-e81c-42ec-8429-6ac1e78827c9'),
(1250,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'e2f8e639-e575-42e9-9e80-fa9c1944a2ff'),
(1251,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'5e65210f-f52e-4202-9f70-a983ed21083f'),
(1252,1249,NULL,669,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'1873b339-5e4d-4b06-ab0c-a83eb068f3bf'),
(1253,1250,NULL,670,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'fcf77344-c556-4172-8f67-0867546ff865'),
(1254,1251,NULL,671,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'093428c5-4db5-41ff-8c0f-0071ab5d4ea7'),
(1255,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-10-08 22:20:05',NULL,NULL,NULL,'f283d066-0b82-44eb-b879-14ec2219674a'),
(1256,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'c8cefe31-fbf7-4df4-8335-c5249aef2344'),
(1257,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'2f998d89-7531-481e-a73e-25548cab0b9a'),
(1258,1255,NULL,672,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'807ce93c-0611-45cc-86f1-a1752e4144ed'),
(1259,1256,NULL,673,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'76642036-dbbf-438e-93a7-cf306fe8714f'),
(1260,1257,NULL,674,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'3efd6cd6-5025-419b-8254-5cdeb7538790'),
(1261,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:34',NULL,NULL,NULL,'15943273-e8c3-4a51-b5d9-e3fc7cd32a8f'),
(1262,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'669b6452-688a-4133-908c-055a66cff5e1'),
(1263,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'32684ff2-cd50-4bc2-8df8-47ac6c9695a0'),
(1264,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:23',NULL,'2025-09-11 18:51:23',NULL,'f584e501-f863-4648-8fd7-9cc2772752c8'),
(1265,1261,NULL,675,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'0a26fa57-210a-4186-80d6-03b48f59656c'),
(1266,1262,NULL,676,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'14de058b-d7c4-4cd1-b4b0-b3a031601409'),
(1267,1263,NULL,677,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'d9652a04-b7d2-47d3-98f4-c924e260267b'),
(1268,1264,NULL,678,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:23',NULL,'bb0262df-3c23-4eaa-9d4e-3fb526dd8bf9'),
(1269,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:34',NULL,NULL,NULL,'d3debf21-6311-42d6-a153-c4d5a58464f6'),
(1270,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'87beb08f-b473-4f64-9cfc-55683192267a'),
(1271,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'42e051d9-ffbc-402e-b5dc-b3107c29cafc'),
(1272,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'f358722c-ef6d-4fda-8feb-6b2d93e2a041'),
(1273,1269,NULL,679,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'c0a047e6-f59b-41de-a4f1-89d32e25a0bc'),
(1274,1270,NULL,680,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'611c4c6d-e885-442b-af38-d456a49260d4'),
(1275,1271,NULL,681,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'ebed7c12-2fb9-483c-af57-f2ad48e43bbf'),
(1276,1272,NULL,682,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'a9d29ed5-3300-438c-bb92-b28dd1047f02'),
(1277,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'406cd088-3430-4963-accc-1e6e86db6052'),
(1278,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'aa2d165b-6b89-45f2-a104-ce337866a947'),
(1279,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'fea5f623-4050-40dd-88c2-5ad59110cf95'),
(1280,1277,NULL,683,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'60065f1f-4961-4a9a-a900-814a03d767a5'),
(1281,1278,NULL,684,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'a10bd7a2-0059-4ca0-9c80-faa5ceda7d98'),
(1282,1279,NULL,685,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'94a8740d-e5bd-4f1e-b5d3-cd7d0e8d5247'),
(1283,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-22 18:42:35',NULL,NULL,NULL,'a14f333f-5d97-4f28-adf7-1eb6de8a62dd'),
(1284,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'16f849bf-8b2b-44b3-8c12-54d94e8c6e09'),
(1285,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'77e50c01-3b96-41da-aa5b-29bfbc4816eb'),
(1286,1283,NULL,686,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'b83326e2-4680-4c83-9a5e-a117bad15222'),
(1287,1284,NULL,687,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'9dcfeb26-8b38-403a-ae08-f1818117576e'),
(1288,1285,NULL,688,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'81c3b452-fba1-4ae7-a459-8483baf683d2'),
(1289,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'1e0bb049-da11-4a90-9e51-1549b36f3102'),
(1290,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'b8e0ffb1-5428-4ab7-80c7-77a9fd1fd911'),
(1291,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'064fc539-91b2-4d4e-9566-2ef3bc7143bb'),
(1292,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'0b5324da-3ba4-4600-a30c-ede53304bf82'),
(1293,1289,NULL,689,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'b543b24d-e8a8-4cab-be14-c9d7c7bf30fb'),
(1294,1290,NULL,690,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'ad21d5eb-6be6-4f43-94db-43ba63afe000'),
(1295,1291,NULL,691,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'2efc46dd-208e-46fc-8ba1-1bafefe9dff3'),
(1296,1292,NULL,692,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'03e88e82-4b9a-4ead-86ae-e77f88bc8305'),
(1297,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'63f83f5e-ea30-4d1a-9cd7-742ab2705cc1'),
(1298,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'de4c8138-9138-4c6a-a9a4-8b80bd5bbb5d'),
(1299,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'f2cfc895-91c2-4973-83e3-6409acd12711'),
(1300,1297,NULL,693,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'2d58e33b-1434-472d-b977-53e6be4e270e'),
(1301,1298,NULL,694,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'4cfec8e5-e0b2-4b49-8801-80c343be3782'),
(1302,1299,NULL,695,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'a9d1eb84-e219-462b-9c9e-7834ebc53e8d'),
(1303,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'6f09b6a2-cbf4-472a-9f08-6e209deb09a1'),
(1304,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'20cbbf8d-dd29-4b59-8f34-253a4b57d02a'),
(1305,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'a8d2ac4d-bf5a-45cd-aa39-847cd30098d0'),
(1306,1303,NULL,696,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'f7550701-b282-4c05-865d-2dc9990a6b39'),
(1307,1304,NULL,697,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'b3c00404-2c96-42af-b91c-d090625debee'),
(1308,1305,NULL,698,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'9fbb9366-eb03-4898-976e-b0f0b025bcd5'),
(1309,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'1e37f615-9815-4e6b-bef1-b6c2d9b7f291'),
(1310,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'9968f953-ee7a-43ed-8ccf-d1fbb6c53297'),
(1311,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:24',NULL,'2025-09-11 18:51:24',NULL,'2a9caa7f-7ea0-424d-a570-0f087a4a2222'),
(1312,1309,NULL,699,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'20139750-d97a-4693-aa69-39ccdd656367'),
(1313,1310,NULL,700,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'7a6a4d0b-14b3-4689-96ff-bedad8dbee7d'),
(1314,1311,NULL,701,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:24',NULL,'4ed5266a-eafa-4dff-8c2f-9809e41f8048'),
(1315,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'af1f0dc9-56db-4a3d-adad-a0710d5382fc'),
(1316,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'8043e61a-5d17-44bb-9058-bc868dc49ce1'),
(1317,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'89ed9071-61ce-44a1-b7f2-c0fc40b5c955'),
(1318,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'4f1e758e-0e34-44b7-baec-2c9eced211e1'),
(1319,1315,NULL,702,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,NULL,NULL,'ecc4c9a2-339a-45bd-bca3-5a269e212c39'),
(1320,1316,NULL,703,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:25',NULL,'874bbcfd-90e9-482b-ab82-2681ec104cdc'),
(1321,1317,NULL,704,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:25',NULL,'08b39ef2-0325-4439-ac82-4f9773940ed7'),
(1322,1318,NULL,705,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:38',NULL,'2025-09-11 18:51:25',NULL,'a309dc10-48fa-4065-9fa7-9c93c32da578'),
(1323,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 20:39:35',NULL,NULL,NULL,'6d44985a-9c4f-4f58-b4ee-714eefdab563'),
(1324,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'e0e43dea-0616-4e0d-bb7d-64ebacc06517'),
(1325,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'09f42432-3df5-4c7c-974b-e8b694ee3c4b'),
(1326,1323,NULL,706,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:39',NULL,NULL,NULL,'87fe8d58-03b3-43d3-ad8f-c4cade82789d'),
(1327,1324,NULL,707,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'7a6b7e2a-0a6f-4243-b309-fb66786d0d72'),
(1328,1325,NULL,708,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:38','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'65f511dc-8f93-479a-8d3e-6021a6b9778d'),
(1329,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 20:39:35',NULL,NULL,NULL,'1fd9bbc0-7bf1-46c9-ac24-0176114d3823'),
(1330,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'430de6e4-45df-469c-a0ac-15547a6ea506'),
(1331,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'ae0bbb33-7fe7-4e2f-b36d-8360e0b47ac5'),
(1332,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'c8b25d21-3bcc-43cb-a982-6aa042ce7c7a'),
(1333,1329,NULL,709,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'8fbb0b37-b9f2-4614-835e-de6c647719a5'),
(1334,1330,NULL,710,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'c26615ba-e4c9-4d9a-925b-9c90103ae00a'),
(1335,1331,NULL,711,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'0a8eb40c-1e1d-4fd1-8e2c-4a04d13a29d9'),
(1336,1332,NULL,712,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'f0b59803-a16a-4a3d-8963-809337502b79'),
(1337,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 20:39:36',NULL,NULL,NULL,'8dcaf5df-07b7-471a-8789-20e7877f2acf'),
(1338,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'ff30ff8c-9982-4b8c-bd0c-456261a04c3b'),
(1339,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'65c56459-3662-4e2e-bbf9-e82eb7d99d31'),
(1340,1337,NULL,713,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'c5a0b65f-7882-4513-a5d1-8039a767d40e'),
(1341,1338,NULL,714,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'ef3f32c1-0b07-4ad9-8029-f9d21d4ea52d'),
(1342,1339,NULL,715,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'bc4525aa-9015-468f-a9d9-78ace2d48ec9'),
(1343,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 20:39:36',NULL,NULL,NULL,'dc8c0434-33bf-4a60-8f74-5e9e67c67891'),
(1344,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'41d99e48-d5cf-408d-906d-340735136b96'),
(1345,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'41d77cae-2b52-436a-8fa4-27d35f39561f'),
(1346,1343,NULL,716,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'24024ef0-16b1-4688-984c-de8e2d231d43'),
(1347,1344,NULL,717,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'b6b20adb-acb3-49da-8df0-55b3eae7da84'),
(1348,1345,NULL,718,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'0acc5d37-de89-4bf4-8d81-4351d737de77'),
(1349,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 20:39:36',NULL,NULL,NULL,'1fab1df4-d265-4be0-a1fb-123a3d0f4312'),
(1350,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'345b51c1-2dd4-48fb-9194-f56d0135f9bb'),
(1351,1349,NULL,719,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'c07c82ac-f45a-4488-8e34-2752ddc02019'),
(1352,1350,NULL,720,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'80005875-b4fb-4a6f-9b0a-efc12dc3323b'),
(1353,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-10-08 22:41:35',NULL,NULL,NULL,'f29068a1-d909-4477-8a54-4f870de19253'),
(1354,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'253848be-d726-4334-8439-419a077a6d65'),
(1355,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:25',NULL,'2025-09-11 18:51:25',NULL,'fdcb05fd-b7df-4ba7-be10-ea749bf599a4'),
(1356,1353,NULL,721,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'4c26fc44-ef5b-4836-a0e1-3e1d2bb714b9'),
(1357,1354,NULL,722,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'afbae2bd-2382-48fe-80e2-43466202bb2a'),
(1358,1355,NULL,723,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:25',NULL,'a1a16467-6f7e-4b73-9d1b-4c4e644d69b0'),
(1359,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:20:32',NULL,NULL,NULL,'0a78517d-cd10-42a9-9b07-bd04013eaa7a'),
(1360,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'1661cb08-fadf-4970-af2d-42b2bcbcc6a6'),
(1361,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'a4b559ec-0ec4-42c3-89c5-1175ff52b3cd'),
(1362,1359,NULL,724,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'7bee03aa-7706-4450-a56b-7e342d33674c'),
(1363,1360,NULL,725,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'1efe27fb-b3ec-44f8-88c2-c76667c92eb7'),
(1364,1361,NULL,726,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'40974069-b708-4298-ac81-ef5084e2f449'),
(1365,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:20:52',NULL,NULL,NULL,'b1b7bedc-a69c-43e5-a051-864302bb5316'),
(1366,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'237f0de8-486f-455b-bb4e-cb875251ba3e'),
(1367,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'54b40113-d8ad-46f9-b11d-4728753e74b9'),
(1368,1365,NULL,727,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'c64e4f58-6d8c-4ea2-808f-11038133461e'),
(1369,1366,NULL,728,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'8308aac5-f93e-44ef-b9cb-1c4cb05e5f6c'),
(1370,1367,NULL,729,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'25559755-16d6-452a-97d2-0ad02800b00d'),
(1371,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:21:35',NULL,NULL,NULL,'1bc8135b-532b-434c-9bfd-75701f485a3c'),
(1372,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'2e261345-db78-4d7b-847e-765a6af5b014'),
(1373,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'f19dd849-9553-4f3c-8a5d-4e761016e010'),
(1374,1371,NULL,730,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'9e667f0c-03ff-4446-b89d-0c3200e4c8dd'),
(1375,1372,NULL,731,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'0f5359d8-ba45-4002-a348-b377c0ff9a0a'),
(1376,1373,NULL,732,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'58fa238e-a540-4873-95f7-8bf693d3de3b'),
(1377,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:22:06',NULL,NULL,NULL,'d3466f3d-8d29-494a-b948-a4b0893f19e2'),
(1378,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'befd8433-ea04-4e2b-8fa7-bdecc16273c1'),
(1379,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'bc9fcfa7-4653-4a00-b5b5-fa6b3cf95c43'),
(1380,1377,NULL,733,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'18c9209a-e7aa-4f4a-9bdb-0bf747856160'),
(1381,1378,NULL,734,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'4a03e149-e9f8-4ebd-b1a4-076e9a096736'),
(1382,1379,NULL,735,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'fc0ac719-9207-4ea7-8a02-530c28a50aab'),
(1383,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:22:45',NULL,NULL,NULL,'69022d4d-5d2e-4e2a-8a66-4e47358a2867'),
(1384,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'7b685ee2-7565-4acf-8e09-00c7584a4c2e'),
(1385,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'b6f03b11-d559-4b74-8c8e-111414003414'),
(1386,1383,NULL,736,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'91ed79b0-819d-4400-843b-7fe2f965145c'),
(1387,1384,NULL,737,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'c732bb86-d763-4643-a7a6-6456036e6b2c'),
(1388,1385,NULL,738,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'fc779cc1-739e-41d0-831e-489bc6ceeb1a'),
(1389,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:23:01',NULL,NULL,NULL,'fb8a6fbe-da4c-4b0d-97b9-df4fceca0c83'),
(1390,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'1252935e-8575-4ed3-9d1b-b8f45c05a53a'),
(1391,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'b5c7baba-cd62-4faa-b917-7fc71bd30dbd'),
(1392,1389,NULL,739,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'ba4a3d1c-f46b-43ba-8729-46570d722618'),
(1393,1390,NULL,740,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'b2ddb548-3695-4822-a942-b64469682468'),
(1394,1391,NULL,741,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'48f4970e-7a01-4de9-8ebd-cc3fb18a5e31'),
(1395,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-29 18:59:03',NULL,NULL,NULL,'ad605fca-f52b-4f94-ad29-1bf717718384'),
(1396,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'19773b1d-8517-4181-a953-11ef69fad669'),
(1397,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'afc0add6-72c7-49c3-8778-f1b8e7106d76'),
(1398,1395,NULL,742,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'ac8b35f6-8ade-4fa6-8698-ee9bcaed8dc3'),
(1399,1396,NULL,743,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'20b18ece-9636-458e-a861-34f802032de9'),
(1400,1397,NULL,744,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'6c1c4a3a-7ef2-46b6-bc3a-0a976a4b1d11'),
(1401,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:22:29',NULL,NULL,NULL,'10136db3-f742-4345-b1a1-3f99a22062c7'),
(1402,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:26',NULL,'2025-09-11 18:51:26',NULL,'d1e067a4-53a5-4350-84c1-d64030187043'),
(1403,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'2b80baee-96c6-4993-95ca-ccf103ee535d'),
(1404,1401,NULL,745,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'3bbb8803-986e-450b-9796-659e2b7de2c7'),
(1405,1402,NULL,746,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:26',NULL,'b03033ea-1bf9-48f2-93b0-7584f9ecd395'),
(1406,1403,NULL,747,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'b96cca2d-013e-4d54-9c2b-d6ebc1c94f64'),
(1407,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:23:24',NULL,NULL,NULL,'2ce11a9e-c93b-4ff0-89ed-0449154cae89'),
(1408,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'ce6fef3d-772f-4a4f-8b54-f29fdf182ae1'),
(1409,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'13e29f85-3faf-4d70-82e5-40842ee9b37b'),
(1410,1407,NULL,748,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'ab91c63d-5d6e-48a4-9c10-7e26395b19e5'),
(1411,1408,NULL,749,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'c534a2ab-96f0-4165-a937-a481dfad9b7b'),
(1412,1409,NULL,750,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'e7b156b5-5e57-4c89-85a1-4e4f8901dae9'),
(1413,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-22 18:18:15',NULL,NULL,NULL,'e90d7f5f-3681-4be5-8773-1c482e673ccc'),
(1414,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'ebd9af9d-9938-4547-b1d3-83cde3059a17'),
(1415,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'59cc73d1-18f2-4e04-bfca-809e0c4b69ba'),
(1416,1413,NULL,751,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'190384e1-ab95-4523-8051-9ebe0984616c'),
(1417,1414,NULL,752,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'e9370a84-57a6-4369-9473-8a91cdd74e8e'),
(1418,1415,NULL,753,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'2cb148f2-b545-4e25-b90e-de795d1043c5'),
(1419,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 20:39:37',NULL,NULL,NULL,'2f4b7332-a50d-492c-b8a1-863f352f896b'),
(1420,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'a3105570-e185-449a-a984-464a3b30cf02'),
(1421,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'7df53d4f-bf94-469a-984e-750a1a5cfce9'),
(1422,1419,NULL,754,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,NULL,NULL,'c4302b70-c839-4f09-9d08-61441e302a2a'),
(1423,1420,NULL,755,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'f5015a23-32bc-45f0-bdd4-574e50eb3340'),
(1424,1421,NULL,756,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:39',NULL,'2025-09-11 18:51:27',NULL,'e93d7c83-fe99-4ed8-9873-067781188103'),
(1425,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 20:39:37',NULL,NULL,NULL,'137c19fb-13a6-43b3-a183-3d975cff4c0b'),
(1426,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'e12bddeb-9d59-49e9-bfca-879d3358eedd'),
(1427,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'9a4c32a0-41a7-4196-9681-452c9b2c0589'),
(1428,1425,NULL,757,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:40',NULL,NULL,NULL,'f9d41542-541f-455a-b8e4-77971605eee1'),
(1429,1426,NULL,758,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'732f7e0a-a58e-44df-86da-ab57812d8c1d'),
(1430,1427,NULL,759,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:39','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'6b82c2d1-81ec-47b4-9d48-093d5a1093de'),
(1431,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:37',NULL,NULL,NULL,'48eba560-3fda-4658-863a-2ed2ea78d8c4'),
(1432,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'e6de6bdb-fda1-4ba4-a403-f7e505a85f25'),
(1433,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'1d4df37b-a1f7-44aa-a752-bd27261ee3e0'),
(1434,1431,NULL,760,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'98908d06-d1ae-4627-aba7-7930830d590f'),
(1435,1432,NULL,761,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'d9a4fded-91e0-45ae-9c88-7d40e18fa331'),
(1436,1433,NULL,762,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'66f3a2bf-6704-4029-9343-d7de7457180f'),
(1437,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:37',NULL,NULL,NULL,'cbfd4361-ffce-4592-b81d-197459a87850'),
(1438,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'79f8bfad-f6fd-496b-bb2b-b18aeef9c1da'),
(1439,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'df18802f-5928-4428-b780-465aeda74ac0'),
(1440,1437,NULL,763,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'3e88023a-6fd1-4295-9fbf-f91a299dea90'),
(1441,1438,NULL,764,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'f5d08f5a-95a5-41b1-914d-b306484b36ed'),
(1442,1439,NULL,765,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'9a7d5c70-c5c9-40ec-8a5c-5c258ecb9ecd'),
(1443,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:37',NULL,NULL,NULL,'831b2af1-17e9-43bf-a866-1b800adbf68a'),
(1444,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'e00c8df3-3971-48c8-af19-038b82eb4ba7'),
(1445,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:27',NULL,'2025-09-11 18:51:27',NULL,'3c65783f-33e7-4ffc-bb0a-04996639d730'),
(1446,1443,NULL,766,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'f586d7cd-93d2-4b89-ac91-a054e12cb936'),
(1447,1444,NULL,767,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'ff273a9d-eff7-4a20-bc7a-21c1201f4103'),
(1448,1445,NULL,768,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:27',NULL,'0322bb74-57b5-470d-964b-b30250ce5c19'),
(1449,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:38',NULL,NULL,NULL,'b3760ae8-a6d0-4798-b7d5-0e34e2f724eb'),
(1450,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'a1751340-9fe1-4b40-9a9d-37e0f2c3475c'),
(1451,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'c96dca8e-8a09-4e4c-82db-24631a5f6897'),
(1452,1449,NULL,769,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'5795e92e-598e-4042-9fa8-12750031e6a8'),
(1453,1450,NULL,770,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'cb5978d5-79e0-4a0f-ba7d-ff4e3da1ee70'),
(1454,1451,NULL,771,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'916f1236-d9ae-4ccd-8615-9ec2181873d9'),
(1455,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:38',NULL,NULL,NULL,'8652f720-82f3-44c9-87dc-ac5f3c6151fc'),
(1456,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'8c6cd355-9b93-4b0c-af81-587274a7a28c'),
(1457,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'e86f45b4-3583-4604-a341-32c0b2a92b55'),
(1458,1455,NULL,772,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'70df6f09-6608-4f8b-bee7-de4d42f3774a'),
(1459,1456,NULL,773,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'3bafd2d4-301b-455e-abb3-a874bf8b7d0d'),
(1460,1457,NULL,774,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'4dbbb847-1ac6-4514-a003-ca72f57a24e2'),
(1461,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:38',NULL,NULL,NULL,'e7791e13-ae0e-4fae-9b48-9b58ceaf42e8'),
(1462,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'d1707441-5c0d-45a3-93b5-841925d01056'),
(1463,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'0a29bd69-fbf6-4b46-95a2-37d02ef166f8'),
(1464,1461,NULL,775,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'54273e6b-363c-443c-ae4b-853f51fd4622'),
(1465,1462,NULL,776,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'5a9ff66e-d3a3-406f-8e0b-d0f21209ff4b'),
(1466,1463,NULL,777,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'cd6adbb7-5876-4d33-ac1a-e4746ddb1cea'),
(1467,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:38',NULL,NULL,NULL,'2968431d-70dd-4a0d-831a-b32a94b232c0'),
(1468,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'d84ae4c3-70cb-414b-bae9-6f1d9166db44'),
(1469,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'c84a1aa1-887f-41de-a39c-6e72f6048bff'),
(1470,1467,NULL,778,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'a04b3e26-89b2-4a53-a861-c62c8f14019b'),
(1471,1468,NULL,779,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'0fa18d33-5f4f-427c-96a0-7ad438682e27'),
(1472,1469,NULL,780,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'5af2ceb6-7782-4114-8437-d8c354c6c67e'),
(1473,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:38',NULL,NULL,NULL,'1b66deef-1654-4f64-80a7-f8cb4ea28cb6'),
(1474,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'88d15859-d314-492e-af61-c806c266654e'),
(1475,1473,NULL,781,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'7d170fad-ea7c-4c68-b0cd-6d00fd70097c'),
(1476,1474,NULL,782,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'5f7f1c0c-d22e-42c6-b93b-8851aee587a8'),
(1477,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 20:39:38',NULL,NULL,NULL,'4dac3a68-c074-41c9-a527-20c0f8126c51'),
(1478,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'7b5b31ea-9bff-410c-b9bd-cf0e6184e684'),
(1479,1477,NULL,783,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'8722911b-d004-4988-a9b2-2b0f3f68ca6b'),
(1480,1478,NULL,784,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'314cbf6d-05d4-4a79-892f-4a2579e6d857'),
(1481,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-24 16:04:13',NULL,NULL,NULL,'39cc6402-c4cc-48b9-bf88-74665c556ebb'),
(1482,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:51:28',NULL,'2025-09-11 18:51:28',NULL,'dbe046f9-6776-4d71-ac3e-249e91a16180'),
(1483,1481,NULL,785,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,NULL,NULL,'be58ee60-8046-4fd4-bb1c-db7f45a69814'),
(1484,1482,NULL,786,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:48:40','2025-09-11 18:48:40',NULL,'2025-09-11 18:51:28',NULL,'09eabf2e-24a1-4379-a4bd-5c713d80194f'),
(1486,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-17 19:37:16',NULL,NULL,NULL,'3d790092-8841-4a7f-8010-4b58d8fb75ed'),
(1487,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-17 19:37:16',NULL,NULL,NULL,'d8648c2a-9f0f-4b86-a648-71d5f39267c9'),
(1488,2,NULL,787,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'992830bd-a5fc-42e4-a202-cce71ac1a0ce'),
(1489,56,NULL,788,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'c3d65e62-45f2-4259-8494-7f2ba346948c'),
(1490,57,NULL,789,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'19428224-8116-4c4f-b11e-0d7099a1e308'),
(1491,63,NULL,790,3,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'d41f031f-75e1-4b69-89a4-8cb06acbd798'),
(1492,1486,NULL,791,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'3c2d1464-09b2-4466-ae39-e699ad9a086f'),
(1493,1487,NULL,792,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'c2a20ee2-0904-4957-aeab-156c5c545e29'),
(1494,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 20:39:29',NULL,NULL,NULL,'bcc07c12-ea8c-4c99-a036-705be2becdbc'),
(1495,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 20:39:29',NULL,NULL,NULL,'a218a501-28dd-435f-9065-d960aabc82d2'),
(1496,945,NULL,793,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'5f6578e3-b703-4f4f-9519-c6d2d22c1188'),
(1497,1494,NULL,794,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'c34c9e2a-0a10-4471-b5ff-96ba4bc1eb94'),
(1498,1495,NULL,795,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:16',NULL,NULL,NULL,'70a98b62-35fa-4e15-a66b-40c239a54583'),
(1499,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 22:21:46',NULL,NULL,NULL,'869ba898-7c45-4e23-9b77-d0773cdb9e77'),
(1500,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 20:39:29',NULL,NULL,NULL,'ec2cb18c-7316-4561-bedd-709e604c85da'),
(1501,951,NULL,796,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:16','2025-09-11 18:51:17',NULL,NULL,NULL,'2cc6f3e1-db5f-466e-aaea-ccfa3e835f3d'),
(1502,1499,NULL,797,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'2b960c80-8328-4c72-9045-9c13cb8d99ed'),
(1503,1500,NULL,798,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'04afa3b4-6ebd-4e9a-a5e2-3398fa2692c1'),
(1504,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 18:43:12',NULL,NULL,NULL,'fa6a8d9c-3388-4a14-a4ab-15a641f5c9c7'),
(1505,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 18:43:12',NULL,NULL,NULL,'19235825-3470-44a9-bcf5-f90804e5d549'),
(1506,957,NULL,799,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'ce8aa21f-6119-4d65-a5ca-e3544c8df9f1'),
(1507,1504,NULL,800,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'4071bdfe-4fad-4db8-a7bd-0567ea5df964'),
(1508,1505,NULL,801,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'8ac1a79d-1eb3-46de-af1f-caad72418e35'),
(1509,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 18:52:55',NULL,NULL,NULL,'4c813f98-05db-45a9-baff-afa71ea75d34'),
(1510,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 18:52:55',NULL,NULL,NULL,'c2a25819-6441-4a63-a27d-fd3a8ece8c59'),
(1511,963,NULL,802,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'22fd9aa2-a8d5-4bbf-8295-a99d3198168e'),
(1512,1509,NULL,803,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'325642a7-4c06-4361-8278-7d17876c002d'),
(1513,1510,NULL,804,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'94226a6b-0d5f-43d3-bd3a-f57cb25e54ca'),
(1514,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 19:00:47',NULL,NULL,NULL,'f47ec6a8-040e-4f19-b6bf-aa54fcd868f3'),
(1515,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 19:00:47',NULL,NULL,NULL,'2b582155-bafd-41d2-b61e-18900b57bf14'),
(1516,969,NULL,805,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'446e4054-bec5-41b2-ac2b-28a2716d7d3a'),
(1517,1514,NULL,806,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'1c650e5c-0773-4b97-bbd2-4b6a3b8566ff'),
(1518,1515,NULL,807,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'7be8d060-1fde-4af5-9f3f-70d6be6f3c18'),
(1519,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 19:59:16',NULL,NULL,NULL,'a2ea9619-681e-4bce-8251-ea3ec57d5055'),
(1520,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 19:59:16',NULL,NULL,NULL,'01750b34-4fb1-47c1-b412-a69ea5a63651'),
(1521,975,NULL,808,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'c14d1e9f-a3cb-477e-b419-ad0729e1ef99'),
(1522,1519,NULL,809,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'cdbb91b8-a5dc-4dde-b32e-193ce3193240'),
(1523,1520,NULL,810,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'f329bcfc-4243-4c63-8072-a67f1711c59c'),
(1524,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 20:39:30',NULL,NULL,NULL,'cae0731d-61a3-476e-b171-2347ec8f448f'),
(1525,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 20:25:58',NULL,NULL,NULL,'5a04ca5a-45d1-4921-bdca-3968a162f1f6'),
(1526,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-10-08 20:25:58',NULL,NULL,NULL,'c680d7e5-a164-4fe0-b75a-d750f8b669c1'),
(1527,981,NULL,811,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'e6354882-6a38-4788-a719-5d9184e2c47a'),
(1528,1524,NULL,812,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'fe1f44f3-e0b3-422a-9236-44b13e46fde6'),
(1529,1525,NULL,813,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'f4713859-22d9-4013-8ae0-f4844cafd16b'),
(1530,1526,NULL,814,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'22e968f1-a11e-498a-bc3d-6e1b7004a362'),
(1531,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 20:39:30',NULL,NULL,NULL,'1c70e206-c29c-4bf5-9067-3e0c185019a7'),
(1532,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 20:39:30',NULL,NULL,NULL,'472435b3-86eb-42e3-9e21-4039c10d851b'),
(1533,989,NULL,815,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'de45191a-4bb2-4730-8a22-fe030c5948da'),
(1534,1531,NULL,816,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'f211a9f0-f573-48b9-a56f-b6baf9fa84a7'),
(1535,1532,NULL,817,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'d32e1c7b-b917-488b-b698-dc9bc15402e1'),
(1536,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 20:39:30',NULL,NULL,NULL,'7b7a96c0-fd88-4e61-b3a1-434634e705d7'),
(1537,995,NULL,818,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'5346c5a0-8582-46ca-974e-7f1915f7034f'),
(1538,1536,NULL,819,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:17','2025-09-11 18:51:17',NULL,NULL,NULL,'5de51e2c-a327-45cb-8505-c72a80d0de4f'),
(1539,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'8f9f6928-4dea-4f6a-b61a-ce50ce7a4487'),
(1540,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'ee6281cf-dd6a-4ead-b69b-52f35cbc3037'),
(1541,999,NULL,820,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'b4fa0f92-4aeb-44b8-b784-cea7078d71a7'),
(1542,1539,NULL,821,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'7a6ca703-0936-4b26-8dab-a6ac2fc8c3a8'),
(1543,1540,NULL,822,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'0e8889d6-7949-4344-8c01-acd2e4e9d70c'),
(1544,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'b3d474bd-9a80-446e-be3b-f3dd8f95a749'),
(1545,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'f797fd60-d5b7-4a1c-ba1d-cf2985a2dd0e'),
(1546,1005,NULL,823,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'cfdf2b5c-c774-4c9c-9533-83a66068228a'),
(1547,1544,NULL,824,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'9f308709-117d-44b9-bf51-dcd985e12112'),
(1548,1545,NULL,825,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'72f3a745-6155-48a3-a80f-ae5b637e6e2f'),
(1549,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'2c4d4b91-a2cd-44e4-a698-411d971566d7'),
(1550,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'6bfee32f-985b-4da9-aac7-6d136c688743'),
(1551,1011,NULL,826,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'6e31745b-43ad-41e0-af18-e7449a4006dd'),
(1552,1549,NULL,827,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'24083c0b-7342-45ad-a2d4-c9f153dd3997'),
(1553,1550,NULL,828,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'d1398982-fbea-4427-9d84-8ca4e994ea85'),
(1554,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'818e14f3-eced-4187-bb05-1e7052a16d2d'),
(1555,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'1c97b0fb-ef0a-4374-af62-9d7ddcd2adaf'),
(1556,1017,NULL,829,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'d527fae8-aa6c-412c-a757-c4e33dfa5389'),
(1557,1554,NULL,830,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'d460cd6c-e9d5-4dfe-9a7a-4e64b03781ec'),
(1558,1555,NULL,831,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'35455501-4a8b-4d5f-a8aa-cbeb3eb37081'),
(1559,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'08b7891f-7ef9-492e-9a1a-4f70b6182e4b'),
(1560,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'3beaa422-e9a0-487b-8fc8-5c51a3db68a2'),
(1561,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:30',NULL,NULL,NULL,'5fb39a85-440f-47c8-bb92-0ac03be1f30b'),
(1562,1023,NULL,832,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'24b898cc-fbd0-42ec-818b-b907e76dc91e'),
(1563,1559,NULL,833,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'deea09bf-a9ba-4433-96fa-9aaead6811db'),
(1564,1560,NULL,834,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'396907d2-ddcf-46d1-8981-67def04b52e1'),
(1565,1561,NULL,835,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'97993b18-f936-40a2-bddc-3a84c14babcd'),
(1566,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:31',NULL,NULL,NULL,'3cfc1ccf-a8ef-46dd-aa1e-cd1fc857648b'),
(1567,1031,NULL,836,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'a76e1caf-84dd-411b-844f-e596924a4ce4'),
(1568,1566,NULL,837,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'ca03c0ae-718f-45a0-b018-be3a500378cf'),
(1569,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:31',NULL,NULL,NULL,'242041a7-0de1-4672-841c-dc68b0234fd2'),
(1570,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:31',NULL,NULL,NULL,'fe040441-4598-4c71-910e-ab8973b5641c'),
(1571,1035,NULL,838,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'76a6436f-bc71-4fc9-b8a3-428357e8de61'),
(1572,1569,NULL,839,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'cdf57a62-37c3-4e8d-bf55-4d37a59d2097'),
(1573,1570,NULL,840,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:18',NULL,NULL,NULL,'6932c67a-2fc3-43ff-a5f9-df73478a6a39'),
(1574,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 20:39:31',NULL,NULL,NULL,'80dbadc7-dbf1-427d-83d3-9b7ccc560196'),
(1575,1041,NULL,841,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:19',NULL,NULL,NULL,'3e29aef8-b773-4acf-8035-1be83196a311'),
(1576,1574,NULL,842,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:18','2025-09-11 18:51:19',NULL,NULL,NULL,'d4f3fac6-ec2d-4d4d-a2b4-88315ac164cc'),
(1577,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'dc1d4a8f-d428-4342-9942-efcf7a829bd7'),
(1578,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'267f52a0-90be-4067-acf5-3ca538764045'),
(1579,1045,NULL,843,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'9ef5a4b7-dee9-4bfa-8018-360096a4d121'),
(1580,1577,NULL,844,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'18a3d99a-f249-4dee-9400-d60c21c0b9e1'),
(1581,1578,NULL,845,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'5b0073cd-9b18-445f-93ed-aadd165f7367'),
(1582,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'ab186df8-b9a2-49ea-af07-66f2378ecf5e'),
(1583,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'f1b27b4a-f865-4548-bf7e-0613c02036a6'),
(1584,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'9cc47e5a-cf9f-48df-8d55-7bc428be06d4'),
(1585,1051,NULL,846,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'a650b655-05e4-4ef2-864b-ff66f7652d92'),
(1586,1582,NULL,847,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'446c3fc8-16d3-4de6-939d-24d8afdbe60b'),
(1587,1583,NULL,848,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'30cbeb54-8185-40fa-856a-c57b2f80399a'),
(1588,1584,NULL,849,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'06c74666-b097-4802-a6dc-212d5d809a2f'),
(1589,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'96327c94-0c72-4895-9f4f-8e04afd352df'),
(1590,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'7d9136f2-15e1-4ab7-b2b1-56fa9e43355e'),
(1591,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'a1f9bafa-b757-435e-8731-9219b2071673'),
(1592,1059,NULL,850,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'3a917f4d-9320-49a8-9f19-69b79db4f4c7'),
(1593,1589,NULL,851,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'f996d56f-9d63-403f-ba02-ce316e65b30d'),
(1594,1590,NULL,852,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'50c7a625-31db-4ef8-ad56-cb2e9f2729bd'),
(1595,1591,NULL,853,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'2faa8e39-89fb-4e33-9f76-96d89f68c39a'),
(1596,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'71542126-c1bb-482b-97ef-4fe0b493c037'),
(1597,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'f1e31aa6-e7f0-4123-bc34-c0945bb7f522'),
(1598,1067,NULL,854,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'1298d3fb-9375-4d68-b188-9c1359be283e'),
(1599,1596,NULL,855,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'9303380c-4e51-4955-99f9-918c5b6b8d48'),
(1600,1597,NULL,856,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'08cdbe79-c9d2-477e-acff-2cb18e7d7191'),
(1601,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'877bfd37-9baa-457b-8185-cfee54576b3b'),
(1602,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'624eff7a-6fc4-4aad-b6b7-02f89bedcca3'),
(1603,1073,NULL,857,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'ce628c80-6ce7-4a27-a78a-55dbf6f89f47'),
(1604,1601,NULL,858,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'a41048fc-3a9c-402d-bda0-ccdfe72e60e1'),
(1605,1602,NULL,859,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'f69e19b2-88de-4b99-9b7c-a76590a308f2'),
(1606,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'f1118721-674d-4a90-9282-79cb352dbe26'),
(1607,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:31',NULL,NULL,NULL,'6967b0d6-ef75-4363-a983-b9e5b454ab9f'),
(1608,1079,NULL,860,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'ac2e114a-7b24-43f9-848d-0b81aab82de3'),
(1609,1606,NULL,861,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'6ce33d5c-0f53-4ec9-a16e-6c6cc55388d3'),
(1610,1607,NULL,862,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'1c1b47e0-f50c-4763-8578-925a6c5d61c9'),
(1611,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:32',NULL,NULL,NULL,'0fd673de-e926-43c2-8964-9cfb361c6b50'),
(1612,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 20:39:32',NULL,NULL,NULL,'93ac7653-3cca-4460-9789-0948234f458a'),
(1613,1085,NULL,863,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:19',NULL,NULL,NULL,'62bfdfca-f0de-45c8-8eb2-89a72f5a8845'),
(1614,1611,NULL,864,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:20',NULL,NULL,NULL,'2789a5f6-d3d9-4711-b469-d77789f115d2'),
(1615,1612,NULL,865,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:19','2025-09-11 18:51:20',NULL,NULL,NULL,'4e2e029c-f9c6-4106-ad34-f3639b3a7475'),
(1616,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'e4ff0752-72c2-4db7-997b-e0c2fab843fb'),
(1617,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'dd4f1c54-ed3e-492d-a4e2-64a4b58e1aa7'),
(1618,1091,NULL,866,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'26ecb9a6-97eb-4e7a-aa6d-323e1d108fa8'),
(1619,1616,NULL,867,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'26d9cdba-f85d-4a93-9b25-e0369b28df1c'),
(1620,1617,NULL,868,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'6d361fb2-b6d7-4a90-baca-62c4fc7a05d1'),
(1621,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'67749652-d5a4-47f3-9731-42af69829579'),
(1622,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'99ff09c9-fb4c-49c1-890a-b48ea561e917'),
(1623,1097,NULL,869,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'e2d2d06e-0044-4731-93d9-c1b7c02d30d0'),
(1624,1621,NULL,870,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'69669ad6-3ef8-40ba-8c6f-ed4562b6f106'),
(1625,1622,NULL,871,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'33839b4e-f77d-4e2e-8ee8-40e3a087dc2f'),
(1626,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'2ce3deea-8f5c-488a-8774-aed3fae0e087'),
(1627,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'048e1eef-0ea7-462f-89ba-d9008fcf2f0f'),
(1628,1103,NULL,872,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'90443b6c-75e3-4a87-b152-aa180ef0dbde'),
(1629,1626,NULL,873,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'98a0fc20-da2b-47e0-b836-07a12d30118b'),
(1630,1627,NULL,874,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'6823ffa5-5400-47b6-b9a6-f3baf4d39a4d'),
(1631,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'48d52a92-a8f0-49de-a547-f5bc7e8d9fc9'),
(1632,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'6bc7c756-aef2-4ed6-8479-624220c98c2a'),
(1633,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'2bfd22e4-9e3a-4af7-afe9-09be20061e66'),
(1634,1109,NULL,875,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'c21527da-4a68-46dd-9aa7-31d4fa2f0ef9'),
(1635,1631,NULL,876,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'7075bacd-530b-4fd7-8ea9-1251ed13ee4c'),
(1636,1632,NULL,877,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'fc062f0e-ba24-48e9-a1b7-5f14da43550d'),
(1637,1633,NULL,878,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'c5a58884-0d89-4fc5-884d-60ade35000b7'),
(1638,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'7de51130-bec9-4b22-b2cc-40d3949c8d42'),
(1639,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'d4d941e5-4019-411f-a89a-3e114d000059'),
(1640,1117,NULL,879,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'db1b1244-f5cb-4a6e-add5-669895a3dd1b'),
(1641,1638,NULL,880,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'fd652a0c-c552-4698-9159-acaba1002a7b'),
(1642,1639,NULL,881,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'f00ca14e-86d7-48cc-86c4-19d789070ac2'),
(1643,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'93866d5c-e218-4a5c-83d1-748eabf50ca6'),
(1644,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'f0fd69b9-cb1d-4e34-b692-f7aa1308332b'),
(1645,1123,NULL,882,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'9de724ae-da94-4d92-8e97-7a82a656291b'),
(1646,1643,NULL,883,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'28ee316e-d8f0-4a59-b4aa-f7514e5af48c'),
(1647,1644,NULL,884,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'94383d30-23a5-4549-9758-9223e57af554'),
(1648,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'12b722db-8261-462d-a755-15979b6f0776'),
(1649,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 20:39:32',NULL,NULL,NULL,'f07ff0d1-bfbf-4d9e-b615-de7da942ece5'),
(1650,1129,NULL,885,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'d55c08d6-0076-4c93-85c9-547c11277fd3'),
(1651,1648,NULL,886,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'4d4fb4aa-b1ee-4e2b-b0f6-128719ce2adc'),
(1652,1649,NULL,887,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:20','2025-09-11 18:51:20',NULL,NULL,NULL,'8a8565f0-3e8b-46e8-a878-16eda6c4b32f'),
(1653,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:32',NULL,NULL,NULL,'76803157-1a52-4ad4-bf4b-5c6dd96ced73'),
(1654,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:32',NULL,NULL,NULL,'2f57269c-dff1-4ea7-8e9f-a3424434b1c9'),
(1655,1135,NULL,888,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'9608b27e-a7f2-47df-a45a-6b7f8e4e5ebe'),
(1656,1653,NULL,889,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'2eb10c5d-4451-4a81-8916-83999c45eaaf'),
(1657,1654,NULL,890,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'9efa88df-403b-48cb-9f10-0d9a348d5fd0'),
(1658,1141,NULL,891,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'a1dd39cc-e343-4483-a3dc-1e4beaa5a8ce'),
(1659,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:32',NULL,NULL,NULL,'3a523137-c22a-4542-b907-8e324e63286a'),
(1660,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:32',NULL,NULL,NULL,'62d624e2-e31b-4c3f-9860-4724e86067e3'),
(1661,1143,NULL,892,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'849cc0a0-0c96-463b-939e-ba9f41b6bae1'),
(1662,1659,NULL,893,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'755d8179-aaeb-4bd8-8d6d-01c55c1e9b9f'),
(1663,1660,NULL,894,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'7938168f-3f25-4a40-b1e2-cdd1bcdd40ca'),
(1664,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'c976e4fd-a038-489e-8477-bde184a4ee42'),
(1665,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'1c14f825-78a0-4c69-aaab-7e5653da9f7c'),
(1666,1149,NULL,895,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'59f2f3ff-1362-4e08-9ec0-9d18531f00a2'),
(1667,1664,NULL,896,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'ed2b76e3-408d-4f68-962a-adda88e19dcf'),
(1668,1665,NULL,897,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'ad45b4bf-2650-4f21-ac8b-2d2a7ca4e17e'),
(1669,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:32',NULL,NULL,NULL,'81b2f1ac-2a38-4eab-82e9-64a4c778113d'),
(1670,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:32',NULL,NULL,NULL,'719386ef-189c-4aa3-bd88-5f85ec1457e8'),
(1671,1155,NULL,898,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'04029068-43ff-49d3-81c8-621db14e58c9'),
(1672,1669,NULL,899,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'8466022f-0af6-4d3c-b2be-db150ff7a6a8'),
(1673,1670,NULL,900,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'e755ba7a-a013-40bc-9f3e-f81b04c2d98e'),
(1674,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:33',NULL,NULL,NULL,'e7e6448a-d2dc-4442-8f22-aaa73546d208'),
(1675,1161,NULL,901,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'9d6c6c4b-202c-491a-847a-d0f7fd1b00ed'),
(1676,1674,NULL,902,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'db79726b-a515-41fe-acd9-a419ff26279e'),
(1677,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:33',NULL,NULL,NULL,'8e117128-fc30-4864-ab2a-2ec752739976'),
(1678,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:33',NULL,NULL,NULL,'9ef20d13-0f68-4d1c-84b0-488a5047dc0d'),
(1679,1165,NULL,903,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'ebec268c-1bac-491f-a0e2-99785f7f779a'),
(1680,1677,NULL,904,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'aee49ab0-ca98-4965-adef-1ce8d0bb56eb'),
(1681,1678,NULL,905,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'119a073c-fb35-4520-a35a-c2dbbe835b0a'),
(1682,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:33',NULL,NULL,NULL,'2d4b474d-0e73-48cc-8848-d539e0cb0a0d'),
(1683,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 20:39:33',NULL,NULL,NULL,'5413ecea-af7a-4c90-adb2-fb08a69c6858'),
(1684,1171,NULL,906,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'41486ac5-5bdb-401d-949d-a0506d41d6c6'),
(1685,1682,NULL,907,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'3e8540fc-6ea4-43b6-9fdd-1b2971980111'),
(1686,1683,NULL,908,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:21','2025-09-11 18:51:21',NULL,NULL,NULL,'2d3a096f-aa14-4c23-893b-e00529728b95'),
(1687,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'802ff893-9dd0-47f6-b76b-1f79ab5cb3bd'),
(1688,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'56cb0fa7-e9c5-44e7-9b65-64a18ccf8ae7'),
(1689,1177,NULL,909,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'fae1110a-a367-4215-9a8b-6ba4046ec272'),
(1690,1687,NULL,910,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'3b35e70a-c077-4351-bd17-ef473da66bef'),
(1691,1688,NULL,911,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,'2025-09-11 18:51:22',NULL,'a4eda232-1f4a-4461-a016-665c50316ebb'),
(1692,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'71e11bb6-2370-4290-bebb-18c47e65bcc8'),
(1693,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'4927887c-3d65-40a0-9f31-4c8cfd54330d'),
(1694,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'fed36498-fd42-4455-8920-8485427e2921'),
(1695,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'ca92fb52-1474-4b0c-a08a-b54accf3ce7e'),
(1696,1185,NULL,912,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'ee4c93be-cd3d-400d-9979-f08d3a927d51'),
(1697,1694,NULL,913,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'27e66328-8500-4cbe-ab42-3dc45ddb4eb6'),
(1698,1695,NULL,914,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'9421cb12-8c71-486a-bc81-e956452c0f44'),
(1699,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'ba72f07f-60ac-43f1-b149-8b2cc7f13296'),
(1700,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'198c5c70-c72b-4af9-817c-fca417943203'),
(1701,1191,NULL,915,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'3d50dea2-d914-487e-84bd-61342a08114a'),
(1702,1699,NULL,916,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'adb139dc-ce51-41eb-863c-c4153f853698'),
(1703,1700,NULL,917,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'44abfe06-6d07-468c-9bab-bb3129d06883'),
(1704,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'e4becd4f-4f88-45e9-aa43-cba6bf902c55'),
(1705,1197,NULL,918,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'444121f4-f36b-4b38-8982-30cce4084e7a'),
(1706,1704,NULL,919,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'0598bdda-bfb2-4337-8640-a7da196530df'),
(1707,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'45d1a41a-8ae9-4339-9f60-5151521a8370'),
(1708,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'85ba5ba2-dcd2-4d62-a5f4-e4e7899a49ad'),
(1709,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'a5582294-c853-4a4d-b525-a7d0a8d1df93'),
(1710,1201,NULL,920,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'83f1f19b-c802-495b-ac4e-889569fd4156'),
(1711,1707,NULL,921,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'beb1f95e-9150-4d43-aa8d-dbf7bc015536'),
(1712,1708,NULL,922,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'3e781fdb-4dc0-4b47-a806-13f29b4650f1'),
(1713,1709,NULL,923,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'6ea5a8a2-7ca1-46ea-afa4-59dcd493e3dd'),
(1714,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'d9236cf2-6abc-4b9e-9cdd-4d4d0d3591c0'),
(1715,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:33',NULL,NULL,NULL,'d990cde1-8e63-4ef5-9870-8fc3972bb19c'),
(1716,1209,NULL,924,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'46b9077b-a2bb-46e0-9e5c-3efdc48dd02b'),
(1717,1714,NULL,925,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'79b446c7-ec6e-4d57-abe9-d890d04da4d3'),
(1718,1715,NULL,926,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'ba3156d4-274d-46be-b952-07829b41f675'),
(1719,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 20:39:34',NULL,NULL,NULL,'64c70303-a72c-4aea-92ce-c5429bd30743'),
(1720,1215,NULL,927,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'30d3383e-0fe5-4b6a-8feb-df65f4c624ca'),
(1721,1719,NULL,928,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:22',NULL,NULL,NULL,'c9d9d4da-c518-4d82-ba0d-b15820567031'),
(1722,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'33f1fc78-0dac-4051-a32a-80d2c70ba679'),
(1723,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'439ee6ec-aac0-4819-8f5d-194f2ba7bbe4'),
(1724,1219,NULL,929,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 18:51:23',NULL,NULL,NULL,'0b853c5c-8428-490a-aac0-eb738f9e93ef'),
(1725,1722,NULL,930,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'ab0a4a36-83d7-4f20-9ed3-598816917770'),
(1726,1723,NULL,931,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'3dfa9614-f48a-43f1-9fed-75dee00001af'),
(1727,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'3f0b0778-06c4-4c22-a78f-37547b8405db'),
(1728,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'9644df4d-82f1-45cc-9361-778ff3706f07'),
(1729,1225,NULL,932,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'fb5b253f-9c1e-416e-9485-97278d2a960f'),
(1730,1727,NULL,933,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'9b104be7-5ab2-4b96-b596-c3145d9d6844'),
(1731,1728,NULL,934,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'17d578b0-68af-48f4-a4c9-82ea467b06d8'),
(1732,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'f7b088e1-ddf5-409e-8372-6630ebc6c03a'),
(1733,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'11ae1d50-4e9d-4c54-b48b-08a6dafa0591'),
(1734,1231,NULL,935,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'ff3b6f48-2d80-4a4f-8a43-8d12cd9e7865'),
(1735,1732,NULL,936,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'dc171179-0907-416d-963b-507021688924'),
(1736,1733,NULL,937,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'b8eb67d9-030b-4583-85d5-f6b732efa259'),
(1737,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'788af7e4-7d73-41d4-ac96-0d205a4d96d8'),
(1738,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'3613d1ca-196a-4292-ac4f-5f8154c3fe4e'),
(1739,1237,NULL,938,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'31d69baf-751b-422e-a10b-79cb9012ed50'),
(1740,1737,NULL,939,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'cc47d91a-414f-4212-a14e-cd58a7f83847'),
(1741,1738,NULL,940,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'d9c9f84b-8fc2-46bc-8078-09c9085664e4'),
(1742,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'6a79d926-9798-4b90-87e8-6f9b1ba98aab'),
(1743,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'228b7411-ef34-4956-8205-cab4baa70528'),
(1744,1243,NULL,941,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'21869279-96e1-482b-9317-e1bce6d13352'),
(1745,1742,NULL,942,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'3ff79a04-7487-456b-838d-8978082c23e5'),
(1746,1743,NULL,943,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'e0e84cff-2980-41a7-9ae6-a44c707ce1fc'),
(1747,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'ec1206c6-2e89-4d63-8d6f-2e22dc517182'),
(1748,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'5abe7f78-77c0-400e-a8a0-1627bda5ca98'),
(1749,1249,NULL,944,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'555bcebc-4e66-4d31-b11f-dc62ea4f0be5'),
(1750,1747,NULL,945,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'ab669648-fd16-45e3-aad4-db2741c89bc7'),
(1751,1748,NULL,946,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'7a119e1d-8d0a-42ff-8112-cfa7aab49453'),
(1752,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'e1c081a3-0cae-4820-8e5b-e010258bd9c1'),
(1753,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'42912698-68d2-423f-8fe9-2a80a2580d36'),
(1754,1255,NULL,947,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'44e659cb-a664-4699-a76f-8ed6a69c05ad'),
(1755,1752,NULL,948,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'ad1bde53-106d-47ea-aec6-e25410fb1a21'),
(1756,1753,NULL,949,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'e2862ace-de8d-470f-84d2-d57b4f10a6e9'),
(1757,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'968ad18e-9c07-4f7a-86df-7fdede551920'),
(1758,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'9ea957be-188f-49b7-8206-f375d4c6d08f'),
(1759,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 20:39:34',NULL,NULL,NULL,'2de3e020-43c0-478a-806b-a143a8d12003'),
(1760,1261,NULL,950,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'9cd00f41-7b44-4143-a3eb-5b0706fa4d75'),
(1761,1757,NULL,951,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:23',NULL,NULL,NULL,'d14b5f05-3259-4274-b858-b113de92899f'),
(1762,1758,NULL,952,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:24',NULL,NULL,NULL,'9fb2dbfa-384c-4984-9e55-232f259911dc'),
(1763,1759,NULL,953,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:23','2025-09-11 18:51:24',NULL,NULL,NULL,'02201b4f-61f3-4de1-8f5c-6c3c12fa383d'),
(1764,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:34',NULL,NULL,NULL,'d82ebff9-5908-4f22-bec7-1f9332e237a7'),
(1765,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:34',NULL,NULL,NULL,'93f5f7e8-4301-4b40-bf8c-6046ce439a01'),
(1766,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:34',NULL,NULL,NULL,'9105f58c-e41a-425c-8a07-d988a8ecc2a9'),
(1767,1269,NULL,954,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'fbb5940a-24c7-4e57-9090-c782be86152b'),
(1768,1764,NULL,955,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'973a3325-eede-4664-9655-93ad2dfd9575'),
(1769,1765,NULL,956,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'91b7146b-f6b1-416c-a469-3a7578b0e48c'),
(1770,1766,NULL,957,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'b1aad48c-3854-487a-b805-03ce09484897'),
(1771,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'6d3bda87-f433-487f-b3e2-d02b6842b642'),
(1772,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'ddde8323-5f54-4bfe-8bf6-e327cc50a1cd'),
(1773,1277,NULL,958,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'919843e7-a5a4-47fc-bdd4-106f1503e923'),
(1774,1771,NULL,959,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'64bf31c6-050b-40a8-ba90-b6206c0e454a'),
(1775,1772,NULL,960,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'fe47425f-36c0-4a02-acae-e8507aa4acb2'),
(1776,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'c8395bcb-be25-4ef3-a610-dcd81378968f'),
(1777,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'70f3485b-1285-4936-97d5-7e0aabbca8a0'),
(1778,1283,NULL,961,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'6280843f-504f-4120-801e-4475984a064f'),
(1779,1776,NULL,962,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'0efa9bef-ab8e-4d76-a7cd-83929ce58592'),
(1780,1777,NULL,963,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'d2c17d3c-85a9-4621-af91-13c1685e1b1b'),
(1781,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'5368e443-5c98-489e-9860-db31db17d82e'),
(1782,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'412aec4d-0997-4bc7-a129-fee5322650c2'),
(1783,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'853b8c61-6a72-44a0-817c-151ee35b010f'),
(1784,1289,NULL,964,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'a71e4b86-90a4-49b3-bfac-ed673a00c619'),
(1785,1781,NULL,965,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'ad96e4ef-df1b-4355-9d03-c123070c74cb'),
(1786,1782,NULL,966,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'30bd123e-5fad-4325-8e71-dfc1eac92e93'),
(1787,1783,NULL,967,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'c2bd872c-6fa6-43a9-8794-5fbe5087d461'),
(1788,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'6dc12b4c-d661-4071-8291-06d5b9cfd6cf'),
(1789,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'8aef1db4-40d1-4d6e-aed7-9bc8ea3ccdd0'),
(1790,1297,NULL,968,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'ba582ce6-1373-44d7-a421-ec7d6fdffbe7'),
(1791,1788,NULL,969,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'27b07007-0ba5-4e11-8036-91d75e82beca'),
(1792,1789,NULL,970,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'3923cf3c-b335-4d70-a749-8fc02031984e'),
(1793,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'b0e8d74e-cae3-4bed-b433-cb4e98a80284'),
(1794,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'17a15f6c-143a-46bf-8383-901156835ab9'),
(1795,1303,NULL,971,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'092c3550-d902-457c-afb7-33011fd9ab86'),
(1796,1793,NULL,972,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'56c7d6bc-a4b2-404c-8491-755ccffe190b'),
(1797,1794,NULL,973,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'99c4e080-d14a-4409-af47-b9f539b30aa4'),
(1798,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'81229918-1389-4a86-92eb-56599daefbce'),
(1799,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 20:39:35',NULL,NULL,NULL,'19f71060-ccf7-4fdc-a096-e765cbe4fa42'),
(1800,1309,NULL,974,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'73975a23-192f-47ab-9866-475d41f92e0b'),
(1801,1798,NULL,975,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'11785b0a-fe00-4003-a98a-93e22827611c'),
(1802,1799,NULL,976,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:24','2025-09-11 18:51:24',NULL,NULL,NULL,'8b1c5678-dd33-49b3-9dbf-bb83c045c075'),
(1803,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'0206e4c2-57f8-47ef-8560-4f35cee9ac0c'),
(1804,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'af57dddf-d829-46e9-93dd-8cec190c875b'),
(1805,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'82518c7b-5d2c-4d07-8b4b-51454aa88f45'),
(1806,1315,NULL,977,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'f05cfc82-5f81-4a16-b351-09d2a3562004'),
(1807,1803,NULL,978,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'d9d93d76-998a-4854-96ed-6c0c36ef981e'),
(1808,1804,NULL,979,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'ae6a96b1-7c13-4fb6-83fd-df178fd7da65'),
(1809,1805,NULL,980,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'060fad59-a8f3-401e-9b3b-c367abe79c3d'),
(1810,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'73e0c48a-d6b4-4ec6-a6af-83f8335f5652'),
(1811,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'918715b2-c4bc-4658-af5a-69db0da27cc3'),
(1812,1323,NULL,981,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'25fc5d75-043d-401b-bc4e-ec235be580a4'),
(1813,1810,NULL,982,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'96c40c9a-bf39-4b02-b0b3-d1ef699c7887'),
(1814,1811,NULL,983,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'008e9455-4302-437a-8200-f2c034e19054'),
(1815,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:35',NULL,NULL,NULL,'06b9c2ce-1651-4a8a-86a7-7c5356bb72af'),
(1816,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'64699b22-e5f8-495a-b69f-002ec3c6c252'),
(1817,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'0000dc09-3e71-484c-bdd8-77f99317562d'),
(1818,1329,NULL,984,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'3979d680-a116-4b1e-a7a5-0a6c121b2dc6'),
(1819,1815,NULL,985,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'12929fde-3e14-4bf7-9962-35fb681d31aa'),
(1820,1816,NULL,986,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'20ea7922-0d56-4a6a-b101-82f8b3f912b0'),
(1821,1817,NULL,987,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'c7698e18-05df-4952-a42f-cf3c9b9f24cf'),
(1822,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'471f4d74-c7fa-499a-8cae-306b30164931'),
(1823,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'666740d0-f6b4-47b6-b6a0-06d620be07d4'),
(1824,1337,NULL,988,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'3cf03e59-8bbb-4c7c-ab6a-0a16b94ec7a3'),
(1825,1822,NULL,989,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'86e25dad-040d-4151-9433-981ae7171fa5'),
(1826,1823,NULL,990,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'b8e50546-66e4-4357-a6ff-79e90168fd42'),
(1827,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'d3297528-3b32-409c-b6be-16af3d192a2e'),
(1828,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'5087fcba-21f3-4836-aa5f-bb4358991f64'),
(1829,1343,NULL,991,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'47a34faa-5c96-4fc7-8038-ed197f8f08f8'),
(1830,1827,NULL,992,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'cb7d2bb5-23a8-43c7-871e-bcebdab94058'),
(1831,1828,NULL,993,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'413693ae-357a-4d84-a471-2f80573de0c6'),
(1832,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'a8a0fbbc-b600-474a-9ed9-5f0019fe100e'),
(1833,1349,NULL,994,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'a78de810-8a4e-417b-81f9-42be6866eda3'),
(1834,1832,NULL,995,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'619841f7-7e5d-42d6-b07a-3be4749d3c8a'),
(1835,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-10-08 22:38:45',NULL,NULL,NULL,'94e32ba8-ebc3-4b5e-b654-181c1c9d4545'),
(1836,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 20:39:36',NULL,NULL,NULL,'25e0d7c9-f92f-456b-80e8-a37d0b1767f1'),
(1837,1353,NULL,996,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'be0e5ef2-a793-433d-82d6-2456045c46fc'),
(1838,1835,NULL,997,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'5c6db164-2569-4421-8654-bce24f27e6ba'),
(1839,1836,NULL,998,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:25','2025-09-11 18:51:25',NULL,NULL,NULL,'87c30f26-abbe-4f47-9054-4b591400aeee'),
(1840,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'6a5ff6fc-1ec6-4ae9-b309-d0857b40ffa9'),
(1841,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'0f75f919-cb58-42dd-ae2e-4a91477fa236'),
(1842,1359,NULL,999,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'054a9a26-bdf7-45d7-8904-7fa9ecb55865'),
(1843,1840,NULL,1000,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'5b6f6017-48f2-460d-ac3a-23b26e7b8519'),
(1844,1841,NULL,1001,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'243810f1-d51b-4b1f-8162-f5e19ddb5962'),
(1845,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'4cff4e0b-5e78-4452-8f7e-e59371200276'),
(1846,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'ab0ec391-d1fa-4972-bbe7-45f12d4cfe8a'),
(1847,1365,NULL,1002,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'7781b427-d058-4403-aa0f-cc068a97f598'),
(1848,1845,NULL,1003,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'110582f7-c9f0-4429-81c7-3eba238f02d7'),
(1849,1846,NULL,1004,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'8c6e358e-10e8-4c81-8685-997dee75488d'),
(1850,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'13d41bc9-272a-4b56-8acd-e47b263a7dc8'),
(1851,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'6f4138d3-17a0-4d35-9eaa-aa312afd0223'),
(1852,1371,NULL,1005,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'c31ec460-aa3f-4444-8912-d9d68ea626e8'),
(1853,1850,NULL,1006,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'6f7e1ed2-fa79-4f7f-9f85-5571e196b830'),
(1854,1851,NULL,1007,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'3d978518-f030-488a-ac90-3446c7b5c99e'),
(1855,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'7eb9ab17-2f8b-4252-bf92-afc200567d39'),
(1856,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'a36f62f6-2a9d-4c98-99be-27f86f6fd7ed'),
(1857,1377,NULL,1008,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'870a76c4-fb89-486f-b437-7d4124e5bdc4'),
(1858,1855,NULL,1009,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'8d42fd47-6ef8-4ecc-8061-fa3a8ad0432f'),
(1859,1856,NULL,1010,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'0896b4a9-0c43-4d98-85ae-9380b42d7f00'),
(1860,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'f4c2cf13-cf8d-4f75-9de0-85a34cda8767'),
(1861,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:36',NULL,NULL,NULL,'692c5aaf-2be0-450e-b7dd-651bf6b6bf65'),
(1862,1383,NULL,1011,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'db174a89-be16-4626-9d89-18cc50c974c2'),
(1863,1860,NULL,1012,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'a876c37e-51c7-4417-a804-26bf56eab368'),
(1864,1861,NULL,1013,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'9072cc2d-0e66-46e7-aa12-ec0b6bc7ec48'),
(1865,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:37',NULL,NULL,NULL,'68fde66d-5ac0-42f4-a230-9b18495b7cab'),
(1866,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:37',NULL,NULL,NULL,'93cb8898-e7e9-4e8e-8a28-5a848b31808c'),
(1867,1389,NULL,1014,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'1ed059d2-1144-4704-be70-5daa0ed180a0'),
(1868,1865,NULL,1015,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'21903756-72b0-4bcc-87c3-ed845b043936'),
(1869,1866,NULL,1016,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'a622bc58-439c-4405-aaa8-34d6abe614b2'),
(1870,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:37',NULL,NULL,NULL,'79a4a800-b9ab-42d8-a63a-b451c268f49d'),
(1871,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:37',NULL,NULL,NULL,'c01a1617-10de-4435-a1ec-af12f1a5b62a'),
(1872,1395,NULL,1017,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'caa05347-6568-409c-a3f9-f937b62b94db'),
(1873,1870,NULL,1018,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'69c49503-d621-4a2e-b522-3496dec7fd43'),
(1874,1871,NULL,1019,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:26',NULL,NULL,NULL,'f92ecf03-bc16-4699-838a-268fbed4dc9b'),
(1875,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:37',NULL,NULL,NULL,'7de77e35-487c-43f4-82d4-3cd73a9d9565'),
(1876,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 20:39:37',NULL,NULL,NULL,'d6965542-553d-488f-9455-2f53e087ece4'),
(1877,1401,NULL,1020,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:27',NULL,NULL,NULL,'3f235e86-5e7a-418d-91e0-fd1bb542ed90'),
(1878,1875,NULL,1021,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:27',NULL,NULL,NULL,'3b2f4148-5f19-406a-a7f9-92b0073fd6c2'),
(1879,1876,NULL,1022,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:26','2025-09-11 18:51:27',NULL,NULL,NULL,'220dc80f-f81e-435d-8d0f-c610b0e867ca'),
(1880,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'11b2072d-e970-498f-a551-3269d8746893'),
(1881,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'08763e8f-9bc0-4f50-b349-a7606d107ab7'),
(1882,1407,NULL,1023,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'4a2eb12d-52e8-460c-833b-ee57c3d87ec4'),
(1883,1880,NULL,1024,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'14018a65-97f2-4571-bae4-6eabeacec21a'),
(1884,1881,NULL,1025,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'9bcce777-508d-4d4d-9818-d5bd44cc5525'),
(1885,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'230aafd5-fc7c-4ed5-bc04-07c152bc9305'),
(1886,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'a0affaf5-f3ae-498a-b8da-a05b6090982f'),
(1887,1413,NULL,1026,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'65f855ac-56d8-4dba-8e9c-579984fc626f'),
(1888,1885,NULL,1027,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'3d742b37-3867-414b-bbe2-f41326865c39'),
(1889,1886,NULL,1028,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'8bdd245d-2d07-49e8-a0b9-7dad79746fd3'),
(1890,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'a907db03-80e3-4fdc-8b3b-c6a0996071f2'),
(1891,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'f3038bca-418b-4e59-ba90-46f17cb83fb6'),
(1892,1419,NULL,1029,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'78f3b688-0e1e-424c-af6a-d8cf547ce2db'),
(1893,1890,NULL,1030,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'1135cd0e-5f94-4fed-b2bf-ede302b67f6b'),
(1894,1891,NULL,1031,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'704d5513-6f43-4d3d-8b54-fc07f2302d92'),
(1895,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'d33ac818-2b17-44ab-a4b6-a82f65147afd'),
(1896,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'d81333f6-ce9b-48d8-b8ea-efbfcb630410'),
(1897,1425,NULL,1032,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'3fc7cbab-9fd4-4bfa-b64b-a276e58e7a84'),
(1898,1895,NULL,1033,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'b9620373-ee8e-40f8-973e-0dd43b60c231'),
(1899,1896,NULL,1034,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'99c80352-f042-40ac-b568-8d5c28bdb51b'),
(1900,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'0920a6e0-b711-472c-9e82-2e7797f40822'),
(1901,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'c7fafe4f-2c59-46f0-95a1-36187c2bb9f2'),
(1902,1431,NULL,1035,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'a85d2601-cfed-4635-8410-7e0c3ef9b540'),
(1903,1900,NULL,1036,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'cf8cc35d-2a82-4759-9e25-729180f5320f'),
(1904,1901,NULL,1037,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'090e2936-d647-4b9d-8d3c-db7f4a342ad9'),
(1905,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'500423d5-fe9b-42a5-826b-7939bd7f9754'),
(1906,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'c3123b29-086a-4c9b-8425-63e307e498d0'),
(1907,1437,NULL,1038,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'bdd3a31a-23d2-4aba-8e99-dab5f8de482c'),
(1908,1905,NULL,1039,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'b748b024-0ff4-4e84-8518-aa52c0b61ad0'),
(1909,1906,NULL,1040,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'6b9a555f-2d7c-4e25-9d47-59eb0c8370b9'),
(1910,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'0bb92b57-5291-4f7e-88ad-87a4bc4785dc'),
(1911,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 20:39:37',NULL,NULL,NULL,'c4404b6a-770f-4759-856d-1f40e2496c8a'),
(1912,1443,NULL,1041,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'9a4a6e25-26ea-4ddf-9a33-256fc99de417'),
(1913,1910,NULL,1042,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'8606d728-1a7a-404b-a5a6-ca0a58f0aa7e'),
(1914,1911,NULL,1043,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:27','2025-09-11 18:51:27',NULL,NULL,NULL,'68800b7a-9bcc-404a-8129-709b324a84bb'),
(1915,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'1e5b50e5-aa15-41cd-844f-d693555e098c'),
(1916,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'cb288b57-6c2b-407a-988c-1fd6fc42d6db'),
(1917,1449,NULL,1044,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'25550513-724a-4fe1-bf13-524630ad9c9a'),
(1918,1915,NULL,1045,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'3ca9d135-e056-4e5e-9505-58e9675be716'),
(1919,1916,NULL,1046,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'e8c7b86b-9038-4260-b9c1-de90363db8b8'),
(1920,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'14ac5709-531d-420e-9026-888e03f07ffe'),
(1921,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'b83165b6-a1a8-44f9-95d5-43ca0cf6416c'),
(1922,1455,NULL,1047,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'4e19b3af-86c6-48f1-96b9-97f153cf7f1f'),
(1923,1920,NULL,1048,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'138f1306-d885-45d1-aa0c-b5b500498840'),
(1924,1921,NULL,1049,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'63943615-d97d-4702-ab4e-1bc8eb09354b'),
(1925,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'8e4e8ed5-d2a1-423f-adce-87931beecf0e'),
(1926,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'dfd8d683-58f6-468e-be34-b4b6e7c17fb9'),
(1927,1461,NULL,1050,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'243ef27b-8197-40bb-bf53-5ccabaaa9b5c'),
(1928,1925,NULL,1051,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'59b2bd62-935f-4859-8080-4d09e205366c'),
(1929,1926,NULL,1052,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'986c668a-08e6-4c51-a72d-0919da9021e2'),
(1930,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'f4c1f7dc-7a75-42ee-ac92-9ef9b78f61fc'),
(1931,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'a438d929-77c9-4af7-abef-b2879f1e5c84'),
(1932,1467,NULL,1053,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'45ea515f-3ed9-4075-8894-188072e6c3ed'),
(1933,1930,NULL,1054,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'50604da0-dcf0-4764-a777-f68bc1810b66'),
(1934,1931,NULL,1055,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'be79f7df-2425-484e-ab24-abbba17b0ceb'),
(1935,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'cfce61df-c81b-4f57-a3aa-983ba807fa20'),
(1936,1473,NULL,1056,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'45419a6a-da1f-451e-8953-6ca423ce243f'),
(1937,1935,NULL,1057,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'4ab12f2e-3542-4181-b00e-1fe92785fb63'),
(1938,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'f6ee35b4-a050-4d7c-8729-843db1a50ea4'),
(1939,1477,NULL,1058,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'8fa91883-d767-4d14-aa41-5f61d84248bc'),
(1940,1938,NULL,1059,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'fc374cf4-3141-4289-bed8-f0135c5d6ad0'),
(1941,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 20:39:38',NULL,NULL,NULL,'327c5010-6976-4b31-a426-5bef2b9716fb'),
(1942,1481,NULL,1060,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'bdeca20e-b791-49e2-bc6a-f184d054b824'),
(1943,1941,NULL,1061,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:28','2025-09-11 18:51:28',NULL,NULL,NULL,'9db34f42-920d-4a3a-bbac-1487575bef3b'),
(1945,1255,NULL,1062,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:39','2025-09-11 18:51:39',NULL,NULL,NULL,'aeb6cd6e-166d-49b1-94c2-122362509693'),
(1950,1045,NULL,1063,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:54:53','2025-09-11 18:54:53',NULL,NULL,NULL,'037c6a7b-f4ca-4f5f-9d41-5546b1bc4dec'),
(1952,1045,NULL,1064,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:55:25','2025-09-11 18:55:25',NULL,NULL,NULL,'a4b7340f-335d-4bae-90fa-eabca932cfe4'),
(1953,2,NULL,1065,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:58:05','2025-09-11 18:58:05',NULL,NULL,NULL,'d78c1ed2-b618-480b-afb4-c12f63f5d9f5'),
(1956,1165,NULL,1066,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:58:34','2025-09-11 18:58:35',NULL,NULL,NULL,'6e371be7-c4c2-4691-9a2f-3d690e430c61'),
(1958,1165,NULL,1067,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:58:45','2025-09-11 18:58:45',NULL,NULL,NULL,'a35e30f1-61b0-4883-a550-c6061b7b17ec'),
(1960,1045,NULL,1068,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:59:21','2025-09-11 18:59:21',NULL,NULL,NULL,'579adcfc-bfd4-4709-a62d-081711589a66'),
(1961,1255,NULL,1069,1,'craft\\elements\\Entry',1,0,'2025-09-11 18:59:27','2025-09-11 18:59:27',NULL,NULL,NULL,'7f35ef7b-b5c6-443e-a315-18c28e5f4483'),
(1963,1171,NULL,1070,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:00:06','2025-09-11 19:00:06',NULL,NULL,NULL,'71bfee52-d555-4a08-9534-077ca5cbe269'),
(1965,945,NULL,1071,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:00:18','2025-09-11 19:00:18',NULL,NULL,NULL,'769e2c1e-2d82-4230-adde-ca78df4c3414'),
(1967,951,NULL,1072,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:24','2025-09-11 19:01:24',NULL,NULL,NULL,'c324fefe-82cf-4376-97f7-2b69f44746d0'),
(1969,1261,NULL,1073,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:31','2025-09-11 19:01:31',NULL,NULL,NULL,'1da2dfd1-fdde-4e7c-8c1c-b16c1dfbf1ec'),
(1971,1177,NULL,1074,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:39','2025-09-11 19:01:39',NULL,NULL,NULL,'7428aa4c-a324-48f5-bc4b-f83ad1e242cb'),
(1972,1692,NULL,1075,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 19:01:39',NULL,NULL,NULL,'177d8af8-68d2-405d-bb09-9da61b2e8e0b'),
(1973,1693,NULL,1076,2,'craft\\elements\\Entry',1,0,'2025-09-11 18:51:22','2025-09-11 19:01:39',NULL,NULL,NULL,'3490e4fe-14b5-46b7-931a-24ed1625eaab'),
(1975,957,NULL,1077,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:46','2025-09-11 19:01:46',NULL,NULL,NULL,'5a6d582d-e693-4542-95d5-694ae8edd825'),
(1977,963,NULL,1078,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:52','2025-09-11 19:01:52',NULL,NULL,NULL,'ded4b389-d06d-4955-b88e-e03f1cb638f1'),
(1979,1051,NULL,1079,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:01:59','2025-09-11 19:01:59',NULL,NULL,NULL,'f46cb30c-a0c6-4d8a-a88b-82625188ec6d'),
(1981,1051,NULL,1080,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:02:12','2025-09-11 19:02:12',NULL,NULL,NULL,'db1d62cc-7f60-471e-af4e-b339a6f884b0'),
(1983,1185,NULL,1081,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:02:19','2025-09-11 19:02:19',NULL,NULL,NULL,'fa0de283-2588-4fb8-93b5-2bddd3befe3c'),
(1985,1161,NULL,1082,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:02:26','2025-09-11 19:02:26',NULL,NULL,NULL,'3f884b43-9ad9-4476-8d54-de21b35d977e'),
(1987,1353,NULL,1083,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:02:33','2025-09-11 19:02:33',NULL,NULL,NULL,'3f62a119-8a49-4505-b812-2432afec1c4b'),
(1989,1353,NULL,1084,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:03','2025-09-11 19:03:03',NULL,NULL,NULL,'9f717ca5-e7c2-44b7-916c-0abb30e940e0'),
(1991,1059,NULL,1085,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:09','2025-09-11 19:03:09',NULL,NULL,NULL,'53f2d592-8c00-47ab-ad91-35cb9e26d24c'),
(1993,1269,NULL,1086,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:21','2025-09-11 19:03:21',NULL,NULL,NULL,'f5dbd9bf-09ad-4271-b3cd-08dc704adbc3'),
(1995,969,NULL,1087,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:31','2025-09-11 19:03:31',NULL,NULL,NULL,'ca4f3f93-fb2c-422b-887a-3b42918a2742'),
(1997,1277,NULL,1088,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:39','2025-09-11 19:03:39',NULL,NULL,NULL,'4e32f9a1-e6c0-464e-b2af-5b3bb1e53f37'),
(1999,1191,NULL,1089,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:03:56','2025-09-11 19:03:56',NULL,NULL,NULL,'79286800-b391-44a3-ba13-864b0de6eebf'),
(2001,1419,NULL,1090,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:06','2025-09-11 19:04:06',NULL,NULL,NULL,'15b9b681-8401-45b0-bd13-5d8d55fef6ec'),
(2003,1419,NULL,1091,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:21','2025-09-11 19:04:21',NULL,NULL,NULL,'1efa532e-9b4c-4b07-9af8-4403ad2ce57b'),
(2005,1425,NULL,1092,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:31','2025-09-11 19:04:31',NULL,NULL,NULL,'06d52a4f-7755-48c4-87eb-7752656a9233'),
(2007,1359,NULL,1093,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:40','2025-09-11 19:04:40',NULL,NULL,NULL,'de8e5c35-5844-4e09-a2e5-4833c2b07705'),
(2009,1365,NULL,1094,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:04:55','2025-09-11 19:04:55',NULL,NULL,NULL,'8054172c-564b-47df-a889-5aeb069b98db'),
(2011,975,NULL,1095,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:05:04','2025-09-11 19:05:04',NULL,NULL,NULL,'7861fac0-724f-4983-8169-f3863032cfb3'),
(2013,1067,NULL,1096,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:05:28','2025-09-11 19:05:28',NULL,NULL,NULL,'c4a17551-66b4-41d0-9db9-bd0c5a6ff983'),
(2015,1431,NULL,1097,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:05:37','2025-09-11 19:05:37',NULL,NULL,NULL,'183d926c-0797-4eb4-8ea6-975b647a9ecf'),
(2017,1437,NULL,1098,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:05:50','2025-09-11 19:05:50',NULL,NULL,NULL,'e756ade6-4126-4ad8-811f-19e1cf67f171'),
(2019,1283,NULL,1099,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:06:02','2025-09-11 19:06:02',NULL,NULL,NULL,'ced759c0-5d53-4329-8723-8b737c7e5013'),
(2021,1437,NULL,1100,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:06:46','2025-09-11 19:06:47',NULL,NULL,NULL,'c6b693cf-a6a5-4087-8ee3-52d37d094925'),
(2022,1283,NULL,1101,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:06:53','2025-09-11 19:06:53',NULL,NULL,NULL,'5ae3fcb4-c324-4f2d-bbcf-8d2e8fa407d2'),
(2024,1197,NULL,1102,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:01','2025-09-11 19:07:01',NULL,NULL,NULL,'fc0623dc-0cad-463c-bda5-8e8fe27bc7de'),
(2026,1201,NULL,1103,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:11','2025-09-11 19:07:12',NULL,NULL,NULL,'b96525de-7389-41f8-8216-6e51abe1e8b6'),
(2028,1443,NULL,1104,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:29','2025-09-11 19:07:29',NULL,NULL,NULL,'fd8301a6-5532-457f-8fa1-84cbdda41116'),
(2030,1209,NULL,1105,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:38','2025-09-11 19:07:38',NULL,NULL,NULL,'e4b44308-2f90-4005-aa80-2ac211a8bf77'),
(2032,1289,NULL,1106,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:47','2025-09-11 19:07:47',NULL,NULL,NULL,'1121d306-d4be-48b2-9462-3232de9d17aa'),
(2034,1297,NULL,1107,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:07:59','2025-09-11 19:07:59',NULL,NULL,NULL,'65fa8d79-6df8-4b00-8a69-e093f3da6aac'),
(2036,1303,NULL,1108,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:08:08','2025-09-11 19:08:08',NULL,NULL,NULL,'69ed4dc5-add5-40fa-b43b-ac9827039a47'),
(2039,1073,NULL,1109,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:08:31','2025-09-11 19:08:31',NULL,NULL,NULL,'1c6a3457-61ed-4d09-83d1-ac5eef6dfa6d'),
(2041,981,NULL,1110,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:08:55','2025-09-11 19:08:55',NULL,NULL,NULL,'fd810555-a475-4dc2-8fce-5f1f42ed2e87'),
(2043,1215,NULL,1111,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:04','2025-09-11 19:09:04',NULL,NULL,NULL,'8f3990ad-19d7-4d8e-881b-49f19c2c58af'),
(2045,1371,NULL,1112,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:15','2025-09-11 19:09:15',NULL,NULL,NULL,'8edd622b-4958-459c-b064-61231eb17fac'),
(2047,1449,NULL,1113,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:25','2025-09-11 19:09:25',NULL,NULL,NULL,'63066403-79fc-4d19-8c64-191a0eb81c37'),
(2049,1455,NULL,1114,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:37','2025-09-11 19:09:37',NULL,NULL,NULL,'ff3e62f8-0754-42b1-a096-64f04af0c4f8'),
(2051,989,NULL,1115,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:09:56','2025-09-11 19:09:56',NULL,NULL,NULL,'c9c12ae3-7c68-44d9-96df-d7ce4caabfca'),
(2053,1309,NULL,1116,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:10:06','2025-09-11 19:10:06',NULL,NULL,NULL,'c8161a3d-e5b4-4737-b2d6-530516336b02'),
(2055,995,NULL,1117,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:10:16','2025-09-11 19:10:16',NULL,NULL,NULL,'2dfb8d83-0cd8-4b55-83ef-92273a04153c'),
(2057,1219,NULL,1118,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:10:32','2025-09-11 19:10:32',NULL,NULL,NULL,'fb13fab4-d7a9-4278-a6be-489bc6ea86eb'),
(2059,1079,NULL,1119,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:10:45','2025-09-11 19:10:45',NULL,NULL,NULL,'7c111a7d-bd62-416f-8e79-af0f875e7f77'),
(2061,1477,NULL,1120,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:11:04','2025-09-11 19:11:04',NULL,NULL,NULL,'3a9d6c76-22b3-4fd7-9eb6-c23943d00bfa'),
(2063,1377,NULL,1121,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:11:43','2025-09-11 19:11:43',NULL,NULL,NULL,'f91db735-2a6c-47e4-bf40-a0e90cd1e6cc'),
(2065,1461,NULL,1122,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:11:57','2025-09-11 19:11:57',NULL,NULL,NULL,'d3992f92-5b45-42ed-999b-fe134c7957a2'),
(2067,1467,NULL,1123,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:12:17','2025-09-11 19:12:17',NULL,NULL,NULL,'e4d2d6ae-69aa-4fa2-9f6c-30c0773497c1'),
(2069,1467,NULL,1124,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:12:28','2025-09-11 19:12:28',NULL,NULL,NULL,'4dd55d21-d6b3-48c3-8b00-cd66cc763be1'),
(2071,1225,NULL,1125,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:12:43','2025-09-11 19:12:43',NULL,NULL,NULL,'f919eb6c-9177-4540-8272-521b059be394'),
(2073,1225,NULL,1126,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:12:57','2025-09-11 19:12:57',NULL,NULL,NULL,'a6ce2774-35b6-4250-9ad7-5d2170515117'),
(2075,1005,NULL,1127,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:13:09','2025-09-11 19:13:09',NULL,NULL,NULL,'a94bf1a5-e38c-44f4-8a28-7ada754147b5'),
(2077,1315,NULL,1128,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:13:20','2025-09-11 19:13:20',NULL,NULL,NULL,'0fa73409-ee0d-4c09-8362-d4103abcd787'),
(2079,1085,NULL,1129,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:13:54','2025-09-11 19:13:54',NULL,NULL,NULL,'ab1fe88c-150b-4e00-81c6-4919458ee93f'),
(2081,1383,NULL,1130,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:14:08','2025-09-11 19:14:08',NULL,NULL,NULL,'6fb5e57c-6c45-426c-84e0-8dd44b4a6371'),
(2083,1323,NULL,1131,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:14:25','2025-09-11 19:14:25',NULL,NULL,NULL,'3b340bb2-b777-4403-ad32-f4dc48fd168b'),
(2085,1011,NULL,1132,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:14:55','2025-09-11 19:14:55',NULL,NULL,NULL,'4d24b9f2-448f-4cda-b181-3f5a092eedee'),
(2087,1091,NULL,1133,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:07','2025-09-11 19:15:07',NULL,NULL,NULL,'8cbaf9be-7fe2-459d-9e47-4d9e599e95a8'),
(2089,1097,NULL,1134,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:25','2025-09-11 19:15:25',NULL,NULL,NULL,'e2027a29-e251-4ab5-b941-da3ed42e565f'),
(2091,1097,NULL,1135,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:41','2025-09-11 19:15:41',NULL,NULL,NULL,'188649eb-7b5a-40a4-9d8a-d7987434cb4d'),
(2093,1231,NULL,1136,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:48','2025-09-11 19:15:48',NULL,NULL,NULL,'58843612-2201-4031-8a2e-27b4d1fdf543'),
(2095,1103,NULL,1137,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:15:58','2025-09-11 19:15:58',NULL,NULL,NULL,'4b531cc3-8568-42bb-a169-633998f0cbdc'),
(2097,1237,NULL,1138,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:16:11','2025-09-11 19:16:11',NULL,NULL,NULL,'e59f3c54-4311-4224-ad56-f5850287a5be'),
(2099,1243,NULL,1139,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:16:31','2025-09-11 19:16:31',NULL,NULL,NULL,'87067b26-d622-42d1-9a23-f6cce931c3bc'),
(2102,1389,NULL,1140,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:16:56','2025-09-11 19:16:56',NULL,NULL,NULL,'124437b5-cec4-48b2-9ee7-85e937bf1838'),
(2103,1243,NULL,1141,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:17:03','2025-09-11 19:17:03',NULL,NULL,NULL,'867de1e8-dc80-4d60-a5c7-87cd2e003c18'),
(2105,1149,NULL,1142,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:17:31','2025-09-11 19:17:31',NULL,NULL,NULL,'38169acf-dfa1-4d5b-b8d6-f43e340d9eb9'),
(2107,1149,NULL,1143,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:17:42','2025-09-11 19:17:42',NULL,NULL,NULL,'268757dc-351d-4c82-a469-3dffabebac7b'),
(2109,1155,NULL,1144,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:17:58','2025-09-11 19:17:58',NULL,NULL,NULL,'1b29a977-2c91-4483-b1ab-8837337ff882'),
(2111,1329,NULL,1145,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:18:15','2025-09-11 19:18:15',NULL,NULL,NULL,'429646eb-2b77-48bb-8380-1754da05cdb9'),
(2113,1329,NULL,1146,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:18:25','2025-09-11 19:18:25',NULL,NULL,NULL,'cbcbb25d-6d83-45d5-8904-a3ed7ca981d5'),
(2115,1481,NULL,1147,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:18:38','2025-09-11 19:18:38',NULL,NULL,NULL,'c280fc34-0bf7-41a9-899f-1abf988aa6ee'),
(2117,1337,NULL,1148,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:18:55','2025-09-11 19:18:55',NULL,NULL,NULL,'19284174-7252-465b-b26d-107b795e1b9a'),
(2119,1407,NULL,1149,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:07','2025-09-11 19:19:07',NULL,NULL,NULL,'098e0b0a-81ad-4706-838a-eb180aa2f551'),
(2121,1343,NULL,1150,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:20','2025-09-11 19:19:20',NULL,NULL,NULL,'30907729-e9f0-48b0-bc40-7f9f2474f864'),
(2123,1395,NULL,1151,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:37','2025-09-11 19:19:37',NULL,NULL,NULL,'034a676e-d0c3-4198-a6ca-e7f228bdd5f2'),
(2125,1401,NULL,1152,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:49','2025-09-11 19:19:49',NULL,NULL,NULL,'4b5ada0f-bd5e-4d2f-8d79-6d66c2bfddf9'),
(2127,1473,NULL,1153,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:19:59','2025-09-11 19:19:59',NULL,NULL,NULL,'0a81651d-9d48-4f62-aa11-cd74ba613f36'),
(2129,1031,NULL,1154,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:20:11','2025-09-11 19:20:11',NULL,NULL,NULL,'a6265b03-a98c-40b8-b3b7-a368c32df4bd'),
(2131,1413,NULL,1155,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:20:35','2025-09-11 19:20:35',NULL,NULL,NULL,'795dd5f1-22f2-4bf8-a3d2-e314c7d0fd8b'),
(2133,1035,NULL,1156,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:20:48','2025-09-11 19:20:48',NULL,NULL,NULL,'1fd64ce7-13e6-4b3b-b75c-7e92550ca2b6'),
(2135,1041,NULL,1157,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:20:57','2025-09-11 19:20:57',NULL,NULL,NULL,'9c2ef53c-f806-4d03-9676-1d79eb8d776d'),
(2137,1249,NULL,1158,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:06','2025-09-11 19:21:06',NULL,NULL,NULL,'e14b57ba-a400-4be5-ae17-3f19da532c1b'),
(2139,1123,NULL,1159,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:17','2025-09-11 19:21:17',NULL,NULL,NULL,'717b966a-f061-43a1-ac67-6d9e36a302b4'),
(2141,1129,NULL,1160,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:27','2025-09-11 19:21:27',NULL,NULL,NULL,'bc0b3233-81f6-443a-b3ee-30dbfb648e88'),
(2143,1349,NULL,1161,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:36','2025-09-11 19:21:37',NULL,NULL,NULL,'b33c7e7d-a9d9-4212-90d5-d5506decebb1'),
(2145,1135,NULL,1162,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:45','2025-09-11 19:21:45',NULL,NULL,NULL,'b2e18ab4-0ee7-4015-af21-551ddfaaaa45'),
(2147,1141,NULL,1163,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:21:55','2025-09-11 19:21:55',NULL,NULL,NULL,'a7892f37-90c2-44ee-bb1c-bf24b417b97a'),
(2149,1141,NULL,1164,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:22:03','2025-09-11 19:22:03',NULL,NULL,NULL,'dc8d4e0e-c074-48c4-9d5c-47020a0dd90f'),
(2152,1143,NULL,1165,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:22:43','2025-09-11 19:22:43',NULL,NULL,NULL,'bbbf47b5-b0fc-4c27-946b-24678475e6fc'),
(2154,1117,NULL,1166,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:23:17','2025-09-11 19:23:17',NULL,NULL,NULL,'d3a7392b-cf13-4484-b503-300c52fce2de'),
(2156,1109,NULL,1167,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:23:27','2025-09-11 19:23:27',NULL,NULL,NULL,'06f188b6-d912-4561-a403-92160842c7d0'),
(2158,1023,NULL,1168,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:23:46','2025-09-11 19:23:46',NULL,NULL,NULL,'183c6dc7-807d-4933-830e-ec86f265f495'),
(2160,1017,NULL,1169,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:23:59','2025-09-11 19:23:59',NULL,NULL,NULL,'28e8a7b5-4c4d-4835-98ca-60b3e29b0a85'),
(2162,999,NULL,1170,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:24:30','2025-09-11 19:24:30',NULL,NULL,NULL,'1aba5b72-1133-4e69-9ffe-ad18f4b17baa'),
(2164,1255,NULL,1171,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:34:46','2025-09-11 19:34:46',NULL,NULL,NULL,'e1f929a8-8a5a-4f05-890f-0483155ad718'),
(2166,1261,NULL,1172,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:34:52','2025-09-11 19:34:52',NULL,NULL,NULL,'d12f63d1-c3b1-49c6-ab0c-159f96d6077c'),
(2168,1177,NULL,1173,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:34:59','2025-09-11 19:34:59',NULL,NULL,NULL,'22bbf03c-f9db-4a08-b7c1-775034c245b0'),
(2170,1185,NULL,1174,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:10','2025-09-11 19:35:10',NULL,NULL,NULL,'564a2f6d-d289-44cf-9111-627c267d9070'),
(2172,1353,NULL,1175,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:16','2025-09-11 19:35:16',NULL,NULL,NULL,'59c680cd-72eb-46ba-a5a9-a8abef1dd96e'),
(2174,1277,NULL,1176,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:24','2025-09-11 19:35:24',NULL,NULL,NULL,'1f7b5541-779c-4c78-b58f-d1b705ac267f'),
(2176,1191,NULL,1177,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:30','2025-09-11 19:35:30',NULL,NULL,NULL,'057aa1ca-89a3-44bb-b2de-2288c4c0605a'),
(2178,1359,NULL,1178,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:38','2025-09-11 19:35:38',NULL,NULL,NULL,'d1a1d83f-5780-42cb-929c-73f104f97786'),
(2180,1431,NULL,1179,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:45','2025-09-11 19:35:45',NULL,NULL,NULL,'237fafc6-7654-470b-9cfc-efb98a6d7271'),
(2182,1197,NULL,1180,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:51','2025-09-11 19:35:51',NULL,NULL,NULL,'e3b2b065-886b-40e6-920d-e7df10e52616'),
(2184,1201,NULL,1181,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:35:58','2025-09-11 19:35:58',NULL,NULL,NULL,'1f3bae81-3cdf-42b0-bf1c-df0190d766e7'),
(2186,1309,NULL,1182,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:36:26','2025-09-11 19:36:26',NULL,NULL,NULL,'96ebee49-8963-4c9c-8597-267e083243c3'),
(2188,1443,NULL,1183,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:36:38','2025-09-11 19:36:38',NULL,NULL,NULL,'28f0121a-37b6-4ca3-af90-5e7269320ca3'),
(2190,1209,NULL,1184,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:36:45','2025-09-11 19:36:45',NULL,NULL,NULL,'953faded-417d-4438-85ac-49071795e887'),
(2192,1289,NULL,1185,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:36:53','2025-09-11 19:36:53',NULL,NULL,NULL,'e30dcae5-ccfe-49cf-93b8-a69701e666d2'),
(2194,1297,NULL,1186,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:00','2025-09-11 19:37:00',NULL,NULL,NULL,'df9825e6-1ac9-47d8-8a64-b9d919d41d54'),
(2196,1303,NULL,1187,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:09','2025-09-11 19:37:09',NULL,NULL,NULL,'1d9da0c5-dccd-4eb6-9192-0260bd1984f8'),
(2197,1215,NULL,1188,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:16','2025-09-11 19:37:16',NULL,NULL,NULL,'540ad7cf-b5e1-409f-afa7-88630103ba50'),
(2199,1371,NULL,1189,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:24','2025-09-11 19:37:24',NULL,NULL,NULL,'220dbb9c-a7bb-49a3-b5ec-06335d4d074d'),
(2201,1449,NULL,1190,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:31','2025-09-11 19:37:31',NULL,NULL,NULL,'378afe3c-7ad2-4057-8861-763cb525f48b'),
(2203,1231,NULL,1191,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:37:38','2025-09-11 19:37:38',NULL,NULL,NULL,'89c6954e-718d-48d5-b247-84e07933c47d'),
(2206,1161,NULL,1192,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:52:35','2025-09-11 19:52:35',NULL,NULL,NULL,'adccd7e0-b5fb-4f81-b009-4cfe297a5849'),
(2207,1255,NULL,1193,1,'craft\\elements\\Entry',1,0,'2025-09-11 19:52:43','2025-09-11 19:52:43',NULL,NULL,NULL,'f3c60345-c1b2-4c53-99a3-6baae8d56224'),
(2208,497,NULL,1194,6,'craft\\elements\\Entry',1,0,'2025-09-11 20:12:38','2025-09-11 20:12:38',NULL,NULL,NULL,'3498aeec-5b14-4b84-bafb-08697c8b53f9'),
(2210,2,NULL,1195,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:27:00','2025-09-11 20:27:00',NULL,NULL,NULL,'6c183475-e793-4012-8f59-5ffdc27ab3d1'),
(2212,945,NULL,1196,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:27:20','2025-09-11 20:27:20',NULL,NULL,NULL,'b420004f-163b-4034-8658-a94341a4a0ed'),
(2214,945,NULL,1197,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:30:33','2025-09-11 20:30:33',NULL,NULL,NULL,'2374b5ae-3391-4a6d-aa6c-6e1f9f339b64'),
(2216,951,NULL,1198,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:30:50','2025-09-11 20:30:50',NULL,NULL,NULL,'9118d376-91a5-4fae-b2fe-537f74bb71dd'),
(2218,1437,NULL,1199,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:31:02','2025-09-11 20:31:02',NULL,NULL,NULL,'c4dc8153-951e-41c1-a1f4-4315cb87714f'),
(2220,1045,NULL,1200,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:37:16','2025-09-11 20:37:16',NULL,NULL,NULL,'08484410-644a-4005-8b7c-4aa667156fc5'),
(2222,2,NULL,1201,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'9d2f8cf2-9910-4632-872c-69598fbaa05f'),
(2223,56,NULL,1202,3,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'4e5eb46e-e14e-43f3-8d8d-f5a86820c322'),
(2224,57,NULL,1203,3,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'6811b45c-2526-425c-9771-c76348de7f60'),
(2225,63,NULL,1204,3,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'bec226d8-89bd-4ba4-b8a9-d169181f88ca'),
(2226,1486,NULL,1205,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'15d38a5a-2b8a-4111-882d-206d37e17420'),
(2227,1487,NULL,1206,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'52ca4f91-3f38-47a8-8bee-24bd2ad542f4'),
(2228,945,NULL,1207,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'a1546e0b-f5e7-4d50-acf1-a056630ff547'),
(2229,1494,NULL,1208,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'d455be16-8f79-481c-b59f-bd05e884bb55'),
(2230,1495,NULL,1209,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'818f03d2-2c7f-432c-834b-4e423ee03a8f'),
(2231,951,NULL,1210,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'35bff0ce-c0b2-4bbd-93cf-8c5d2d9b2ac8'),
(2232,1499,NULL,1211,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'5333d547-c46a-4718-a413-cfd01d1d7bd9'),
(2233,1500,NULL,1212,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'d168976e-2cc4-4d4c-af00-dc14d2a37bc7'),
(2234,957,NULL,1213,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'11054c99-805e-4238-af87-1a52d87a267f'),
(2235,1504,NULL,1214,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'31ca1736-0b72-49e5-8b26-1fc644fb6e0c'),
(2236,1505,NULL,1215,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'66c2d571-d2f3-4537-9dfd-ca69866967ae'),
(2237,963,NULL,1216,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'15ba3880-7c72-4877-81da-202a88bedd85'),
(2238,1509,NULL,1217,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'9e453bae-4d20-410b-81e8-2c650402d2be'),
(2239,1510,NULL,1218,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:29','2025-09-11 20:39:29',NULL,NULL,NULL,'ba139b53-862e-4d30-b107-c74786ddc7c3'),
(2240,969,NULL,1219,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'76467b31-29e9-40c7-a25c-794903e321bd'),
(2241,1514,NULL,1220,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'37c2f1d8-f48d-4d37-bf79-86544c5bf1c9'),
(2242,1515,NULL,1221,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'b80b993f-bd4d-4975-8703-151af6f1e21c'),
(2243,975,NULL,1222,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'e2c3f267-0edf-4d28-a871-5534827dcd13'),
(2244,1519,NULL,1223,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'14d99b35-006a-4797-87c8-7c252b050c34'),
(2245,1520,NULL,1224,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'8c8ee26e-61fc-4272-9f5b-93cad0aea522'),
(2246,981,NULL,1225,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'5c4a8ed7-bccf-4437-aaa7-ccef65c83c1d'),
(2247,1524,NULL,1226,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'49785bf4-1804-40ae-902c-62aa105e5baf'),
(2248,1525,NULL,1227,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'49b1fef5-b341-46a6-8539-65944a4f9d37'),
(2249,1526,NULL,1228,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'fde5d0cc-d53c-4192-abec-5146012a0d9e'),
(2250,989,NULL,1229,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'1a80dca2-0fa0-4653-bd07-8c40d380e4ce'),
(2251,1531,NULL,1230,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'12ce86c0-0c3d-4ff2-b6b5-fdf5c1e2b7df'),
(2252,1532,NULL,1231,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'f13c2c60-e917-4db6-acb2-69a827a40b98'),
(2253,995,NULL,1232,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'375cd1b6-6ec5-440e-8538-f21a90afbcd2'),
(2254,1536,NULL,1233,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'441b9908-0779-4bf8-b2be-fd673573a183'),
(2255,999,NULL,1234,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'6500fb11-8903-4680-be51-66242e0c7a20'),
(2256,1539,NULL,1235,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'dd556e78-6349-447f-b8d0-707142b16ec5'),
(2257,1540,NULL,1236,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'ec389eac-6d0c-4afe-bdd2-4f08d61461c1'),
(2258,1005,NULL,1237,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'b3a7f86f-79b9-46c9-8ab2-e0e9b0e9d916'),
(2259,1544,NULL,1238,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'6f5eb08b-cc8c-4d43-a1a4-8f641b93d518'),
(2260,1545,NULL,1239,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'0a490659-8694-4bac-8ce9-52eeabd18f52'),
(2261,1011,NULL,1240,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'4f3698dd-fd09-40a7-b4c3-bfc3ad5be997'),
(2262,1549,NULL,1241,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'eb92debb-00f0-4953-928e-ac061fad2a19'),
(2263,1550,NULL,1242,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'5627854d-5dc2-454c-ad79-f9a8f48b4bd5'),
(2264,1017,NULL,1243,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'bbc28ebf-a9f6-49da-acd8-ac0b6d0b7acc'),
(2265,1554,NULL,1244,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'aca4acd2-c94c-4cc5-9b3e-0312a8f8b4b7'),
(2266,1555,NULL,1245,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'75b7da17-206c-4efb-8ddf-c8b801b712b0'),
(2267,1023,NULL,1246,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:30',NULL,NULL,NULL,'176c0ba4-bc21-4067-b569-92ef20f7e264'),
(2268,1559,NULL,1247,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:31',NULL,NULL,NULL,'e17f6c2d-9f0d-4c47-8af3-ca8ce6ea4a7b'),
(2269,1560,NULL,1248,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:31',NULL,NULL,NULL,'368a349a-efc7-4b30-b2e2-b3249d10a78d'),
(2270,1561,NULL,1249,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:30','2025-09-11 20:39:31',NULL,NULL,NULL,'1fac32b3-6aad-4a48-925d-cd3835dcd99c'),
(2271,1031,NULL,1250,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'12dad23f-955f-460e-ad35-6acc8ecfd830'),
(2272,1566,NULL,1251,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'81ed302a-8151-4dea-9454-f47db8b9952a'),
(2273,1035,NULL,1252,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'6411ee32-f902-4121-9ccf-0078ea5de8d5'),
(2274,1569,NULL,1253,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'9ffcb1f0-a9e9-452c-813c-02a7f4978917'),
(2275,1570,NULL,1254,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'a14619a0-72b1-40db-ad1e-5ad7a06e4946'),
(2276,1041,NULL,1255,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'70162289-9d4e-45d6-99b6-e49a8104b1d3'),
(2277,1574,NULL,1256,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'ac390979-2a8a-4b12-8501-6c6bea6cda41'),
(2278,1045,NULL,1257,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'af310d04-cb63-45fa-8a23-6afc7798913e'),
(2279,1577,NULL,1258,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'5b60e712-d1da-498a-9082-440f853077eb'),
(2280,1578,NULL,1259,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'fd2f732f-b26f-49a2-93b9-b331716686f1'),
(2281,1051,NULL,1260,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'38d50995-0253-44eb-8f77-5a17e5acf2c2'),
(2282,1582,NULL,1261,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'69f1dc7e-221e-47ad-862d-15ac4300cdeb'),
(2283,1583,NULL,1262,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'3702f942-39d6-460e-b36e-8b4540db6f7c'),
(2284,1584,NULL,1263,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'beaba663-8777-4d6c-bc57-d51a866a3c30'),
(2285,1059,NULL,1264,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'e836ae4c-c9dc-4d8b-ab0d-a6fcb75733c4'),
(2286,1589,NULL,1265,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'dcfd9632-efc0-4d7f-b776-a48ddea5b270'),
(2287,1590,NULL,1266,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'08905de6-b619-444b-aee7-a9189ee1f75c'),
(2288,1591,NULL,1267,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'a940b45d-155e-4ce6-b24b-2d2e68ffe4e1'),
(2289,1067,NULL,1268,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'d045bc02-ef67-4ed6-aeca-22f47813749c'),
(2290,1596,NULL,1269,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'1578dcc9-d907-4e8d-910f-263caaef3727'),
(2291,1597,NULL,1270,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'a33634ac-17e3-4467-bfdb-c6858f3f2024'),
(2292,1073,NULL,1271,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'a9919f68-a24e-47df-880a-5717be11b580'),
(2293,1601,NULL,1272,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'9dec0979-58c5-457b-926b-aed67e022895'),
(2294,1602,NULL,1273,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'683b5e74-9f8d-4b0f-973b-26fa1644b6b4'),
(2295,1079,NULL,1274,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'149786bc-fabb-496b-a566-85da74d4967d'),
(2296,1606,NULL,1275,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'8b1fedcb-9f31-4e98-8184-d0534b10afe3'),
(2297,1607,NULL,1276,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:31',NULL,NULL,NULL,'35dc0f46-424d-4a7c-abfd-4897971b5b41'),
(2298,1085,NULL,1277,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:31','2025-09-11 20:39:32',NULL,NULL,NULL,'c5018270-43ab-4486-a44c-0fd2c8bcd2a9'),
(2299,1611,NULL,1278,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'318a27e4-e09a-4352-bbb3-67cca0fa51a0'),
(2300,1612,NULL,1279,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'29274ee7-c4cd-4f9e-994f-d1abfc4bfa9b'),
(2301,1091,NULL,1280,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'f1135250-e2aa-43a0-91d0-c9caad7d1b29'),
(2302,1616,NULL,1281,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'42d461cd-6404-402c-a3e3-4381c5465191'),
(2303,1617,NULL,1282,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'60fde109-9d7f-46c3-b7b8-69b88a6ca346'),
(2304,1097,NULL,1283,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'db301f11-7b2a-400d-8159-ed7281d24ab4'),
(2305,1621,NULL,1284,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'e1686c55-70f9-4cea-b2e4-ce7d009313ac'),
(2306,1622,NULL,1285,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'c575a8a9-8783-42b6-9e61-4dd59a93bf68'),
(2307,1103,NULL,1286,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'bdd2c1c5-a5a2-4ed0-8941-ac20afe35b46'),
(2308,1626,NULL,1287,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'eb5f4d12-a163-48cc-b7c2-7146a9a7107d'),
(2309,1627,NULL,1288,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'742faf6d-455f-4c82-8830-f0dae1821511'),
(2310,1109,NULL,1289,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'0df07b97-babd-453b-82cd-4e18f11ba143'),
(2311,1631,NULL,1290,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'bbcadf66-9f58-4fb9-aac3-42b2c570bfee'),
(2312,1632,NULL,1291,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'4ba61cc5-0260-4953-8a79-7033f7b5096d'),
(2313,1633,NULL,1292,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'1369a244-487c-4518-ba07-64248e20b85b'),
(2314,1117,NULL,1293,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'1b9fbc17-10fb-4369-a185-46b2afa727e9'),
(2315,1638,NULL,1294,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'80d863cd-9d73-420e-b1fc-a61edb711aff'),
(2316,1639,NULL,1295,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'50ffd002-fe77-4eda-a3d2-0cf1f7b07f6b'),
(2317,1123,NULL,1296,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'601f8f21-3091-456f-9185-aa916538225a'),
(2318,1643,NULL,1297,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'c3abce8a-7758-4bc9-b353-361646b8f575'),
(2319,1644,NULL,1298,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'1778485e-5250-4a01-83a1-4816289cda3e'),
(2320,1129,NULL,1299,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'ba6bd15e-93a1-4996-a040-0b1ea2c919d0'),
(2321,1648,NULL,1300,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'0c9c9c8b-5f65-446f-9afc-5ce22954bc23'),
(2322,1649,NULL,1301,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'75cb9044-877e-4d2e-9d67-9387824fd9ab'),
(2323,1135,NULL,1302,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'fa073e70-6bd1-41c1-936a-02054306890a'),
(2324,1653,NULL,1303,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'88b97d45-a1bb-403e-91e1-af71ec7ba5ed'),
(2325,1654,NULL,1304,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'e3b15f85-f876-4a6f-bbd4-9dd6da462126'),
(2326,1143,NULL,1305,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'69f60b46-c429-48f0-aa64-abdad6aaf818'),
(2327,1659,NULL,1306,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'3ed02ca8-a643-400f-a241-8db19287039f'),
(2328,1660,NULL,1307,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:32',NULL,NULL,NULL,'f312c3e7-8f70-4c6a-9efe-872191e5164c'),
(2329,1155,NULL,1308,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:33',NULL,NULL,NULL,'d287b69c-8250-4ee9-a834-d0ba58ca4fc5'),
(2330,1669,NULL,1309,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:33',NULL,NULL,NULL,'af969a0f-2e30-4bc2-8ad0-c0b6e8d55eb3'),
(2331,1670,NULL,1310,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:32','2025-09-11 20:39:33',NULL,NULL,NULL,'229b21e1-f73f-4cec-9f87-1198ea7163ce'),
(2332,1161,NULL,1311,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'22a2031a-af48-4eed-9a66-29a2653663bc'),
(2333,1674,NULL,1312,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'02a66161-b187-4cd4-9646-0f72924d0ca9'),
(2334,1165,NULL,1313,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'447b1859-1dd1-4510-8ee5-9430c23fb45e'),
(2335,1677,NULL,1314,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'62c9baf2-0e7a-4f34-8388-c8ecd479244f'),
(2336,1678,NULL,1315,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'daace896-c1d2-4f14-82e8-6d240e620a92'),
(2337,1171,NULL,1316,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'24f44ae8-34bd-46e5-aa09-0914caa600b2'),
(2338,1682,NULL,1317,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'77d5caee-4f33-4be3-aaeb-4fd3fd3aa5c4'),
(2339,1683,NULL,1318,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'615ad73f-b89b-4ba4-a254-640a8a5d3d4c'),
(2340,1177,NULL,1319,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'f80cf382-c0ae-4d76-9d33-22cbe487fc6c'),
(2341,1692,NULL,1320,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'302bb6f1-d9bb-4cc3-bd55-43b46052e0e6'),
(2342,1693,NULL,1321,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'0583ff14-67b8-4711-9744-179778f29ace'),
(2343,1185,NULL,1322,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'d99e2d79-896b-46b8-ad33-2e3d92ac5b92'),
(2344,1694,NULL,1323,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'2de33317-f01f-4f76-946d-22dd32906035'),
(2345,1695,NULL,1324,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'20f6e708-e817-46f5-bb1c-d44613d1bea0'),
(2346,1191,NULL,1325,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'999e5bad-ced0-4cbd-9bb5-359ef3340337'),
(2347,1699,NULL,1326,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'b49521a0-f8ba-4dac-a492-ac2ab2e92e3c'),
(2348,1700,NULL,1327,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'90c34b75-3716-4000-af7c-7e24226d62bb'),
(2349,1197,NULL,1328,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'735f8e22-9d2a-48ef-b8c7-ab7e5572583d'),
(2350,1704,NULL,1329,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'000c10f4-d2c2-4071-bec1-e93a0d65c883'),
(2351,1201,NULL,1330,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'878faeb0-b61e-48e1-8c7b-2db2cc43389f'),
(2352,1707,NULL,1331,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'0f8c41f5-b2d5-4d69-ba23-592a5103aec3'),
(2353,1708,NULL,1332,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'acaa840d-86fa-442e-8e53-bf0e4beebdfd'),
(2354,1709,NULL,1333,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'cd432b78-fafc-468f-be95-a5a0967fbc7d'),
(2355,1209,NULL,1334,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'295c970e-33c8-4134-aa84-d1775bcef760'),
(2356,1714,NULL,1335,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'dd652f5c-bb0d-4383-b6a6-0250fe5553df'),
(2357,1715,NULL,1336,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:33','2025-09-11 20:39:33',NULL,NULL,NULL,'853ee76f-fb61-4858-a0b8-aca65f2f8ad0'),
(2358,1215,NULL,1337,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'4da48e8a-75ac-4a32-8211-a3e3a6c75f69'),
(2359,1719,NULL,1338,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'1adc891b-aee2-436d-95d5-a83bdd712103'),
(2360,1219,NULL,1339,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'3d9248ae-121a-4422-b4c9-54237e914052'),
(2361,1722,NULL,1340,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'24822f30-3c64-4717-8006-c4e04100388a'),
(2362,1723,NULL,1341,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'c29db490-a81c-48b0-b8c3-9c840d4a9c72'),
(2363,1225,NULL,1342,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'73f673e9-a465-4b9d-89bb-caefe009bcfb'),
(2364,1727,NULL,1343,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'244ba4b5-84a2-4acc-a96b-82f8c5d71f99'),
(2365,1728,NULL,1344,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'d6e5c3cc-5eb9-436e-8b0c-6f6ce78b9d05'),
(2366,1231,NULL,1345,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'bdd115bb-c739-443f-a8a2-8dac106fa02d'),
(2367,1732,NULL,1346,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'19cfc3ae-9f47-439c-85dc-456085e59bde'),
(2368,1733,NULL,1347,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'bd3e4ff3-c52b-4094-9616-0b7226bcf167'),
(2369,1237,NULL,1348,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'301e703b-180e-4835-9592-3a5fa7600feb'),
(2370,1737,NULL,1349,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'47f446bc-7243-4938-8778-6ccdae77c8e0'),
(2371,1738,NULL,1350,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'78a76273-243a-4741-ba3f-f480a40b707f'),
(2372,1243,NULL,1351,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'f6b602c3-394b-4cb1-b6b9-13d0ffc01b70'),
(2373,1742,NULL,1352,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'e0cb9382-0256-489b-b489-06cc430acd98'),
(2374,1743,NULL,1353,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'362fd34e-62a4-482a-85e9-f68906489122'),
(2375,1249,NULL,1354,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'60b1bd86-14f2-4bdd-8073-65575453f82d'),
(2376,1747,NULL,1355,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'fe0f430b-b348-4cf0-887f-143cb7151774'),
(2377,1748,NULL,1356,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'d09312ba-d309-4a58-8ec6-87a973026dcd'),
(2378,1255,NULL,1357,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'f33f77f9-fea5-4ad0-a6e8-9cb5a7868f5a'),
(2379,1752,NULL,1358,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'bc67b775-0e01-4baa-80e4-09d14ade2540'),
(2380,1753,NULL,1359,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'6851c682-011c-4aac-82cb-f7d64dd36881'),
(2381,1261,NULL,1360,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'4fe257b0-e184-41bf-9790-9eb1e990f1aa'),
(2382,1757,NULL,1361,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'3bf93cf3-aab0-4cd6-a0d2-38e962e79b2b'),
(2383,1758,NULL,1362,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'320dd30b-4b1b-44d1-9551-0c5432eafb7f'),
(2384,1759,NULL,1363,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:34',NULL,NULL,NULL,'42945697-1ae2-4285-a5d4-6f63dd66aa27'),
(2385,1269,NULL,1364,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:35',NULL,NULL,NULL,'71f985e0-ac5e-4096-8c4c-cd84d329274e'),
(2386,1764,NULL,1365,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:35',NULL,NULL,NULL,'4afd8dc9-cc58-490c-be34-7947478a9537'),
(2387,1765,NULL,1366,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:35',NULL,NULL,NULL,'90f445c8-f90a-4f78-9dae-c70091a3590f'),
(2388,1766,NULL,1367,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:34','2025-09-11 20:39:35',NULL,NULL,NULL,'a0f3ec1a-5eda-4702-92d1-2f30a1988bfc'),
(2389,1277,NULL,1368,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'f29c23f3-def9-4e63-acb5-40182c356a95'),
(2390,1771,NULL,1369,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'49ddf47e-12f4-4da3-b8c6-9d64ad45483e'),
(2391,1772,NULL,1370,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'840bbd83-fdf2-4a10-bfef-562e15ad93c0'),
(2392,1283,NULL,1371,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'e8ffcc5c-0dfe-44e6-810d-5858c9b4ee34'),
(2393,1776,NULL,1372,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'2d5ac8b2-ef1d-49d5-a7bc-d1a520ba2955'),
(2394,1777,NULL,1373,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'ea2d3ccc-e764-49b9-ac13-889e64227fbd'),
(2395,1289,NULL,1374,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'158f173e-9874-4200-8e2f-6120f706e8cc'),
(2396,1781,NULL,1375,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'1eb22d46-fc96-4bf6-90f2-d06e7bfe3803'),
(2397,1782,NULL,1376,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'89131c6c-7c9b-4e50-8fcd-694af4fcdfd5'),
(2398,1783,NULL,1377,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'5ca644a2-0b4e-4884-a7ca-85bab193d717'),
(2399,1297,NULL,1378,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'6ca8d549-c107-448b-b8f9-b0a2c86d79e6'),
(2400,1788,NULL,1379,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'b1bb2727-65f3-4b81-a3e4-f7df5c372159'),
(2401,1789,NULL,1380,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'35aa0712-f0da-4c82-a6f4-560eb1b3ff1e'),
(2402,1303,NULL,1381,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'db172afb-d9b3-406d-9dd6-0a049936d879'),
(2403,1793,NULL,1382,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'0ab79989-1460-4b4c-a966-cf1c33ae7521'),
(2404,1794,NULL,1383,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'5a6ba16b-cb14-45cf-bd8c-4a8bd409b61f'),
(2405,1309,NULL,1384,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'bb0429e3-3120-479c-8449-36e0494035ce'),
(2406,1798,NULL,1385,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'307d5258-7f51-4824-a0b4-94ee9f610479'),
(2407,1799,NULL,1386,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'3bdef452-1787-4e86-a8e0-cfeb2eaa1377'),
(2408,1315,NULL,1387,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'39b8dbdb-4257-4a09-a9c6-4170aa7bc502'),
(2409,1803,NULL,1388,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'bebddb5c-63e4-401a-a3df-112ce48082fe'),
(2410,1804,NULL,1389,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'06123830-b9af-486a-b680-902c60f61746'),
(2411,1805,NULL,1390,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'236c0610-a142-45c5-8e3d-5dd35b0339ac'),
(2412,1323,NULL,1391,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'2f4efa94-8b11-460f-a936-1f90fb340eda'),
(2413,1810,NULL,1392,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'c4aebf86-a5df-4964-a9e3-7a38ca2faa33'),
(2414,1811,NULL,1393,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:35',NULL,NULL,NULL,'99833e80-f9cd-47f6-9655-a5757b3618da'),
(2415,1329,NULL,1394,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:36',NULL,NULL,NULL,'914212f0-1dc6-4e77-a408-e8f6615d7469'),
(2416,1815,NULL,1395,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:35','2025-09-11 20:39:36',NULL,NULL,NULL,'f5c7fb9b-1756-41f8-acb0-33eb138c2b7c'),
(2417,1816,NULL,1396,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'bd78096f-5f01-4fc1-a962-14c6e6c4f62f'),
(2418,1817,NULL,1397,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'c8cbecdb-b3b4-4754-bcef-37df56fdf273'),
(2419,1337,NULL,1398,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'4dd4c136-5d42-4f74-8cf7-5aa04c35a4c9'),
(2420,1822,NULL,1399,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'30af53b8-1d0f-49d4-a48c-664e46c580ab'),
(2421,1823,NULL,1400,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'8d1b1d6d-c4f5-46e0-b51f-779484f742c0'),
(2422,1343,NULL,1401,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'19b1b671-03e5-4c03-aa81-43c82c7b25a4'),
(2423,1827,NULL,1402,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'d8e033bd-666f-45c6-a719-60aec288e902'),
(2424,1828,NULL,1403,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'62b2db04-602b-4930-b2ef-c098a79f84bc'),
(2425,1349,NULL,1404,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'d66b4656-f7f7-469a-b9c1-e3c51d2b0b7d'),
(2426,1832,NULL,1405,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'4a04f375-aa30-4a31-8fc8-6c62cdd843df'),
(2427,1353,NULL,1406,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'689bd08a-0ab6-4f19-b353-c15990d0aa36'),
(2428,1835,NULL,1407,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'82e8162c-e2f4-4b58-aa51-e982e351f6bf'),
(2429,1836,NULL,1408,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'343d4adc-f8f0-4d7f-85db-ab38824a577f'),
(2430,1359,NULL,1409,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'0412a0a4-d5f3-4dfd-915e-6349ef1f3dde'),
(2431,1840,NULL,1410,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'da049ea8-74df-486e-a7c2-44fc22a24cfd'),
(2432,1841,NULL,1411,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'35eaa790-5a17-410b-a030-8377d40d951a'),
(2433,1365,NULL,1412,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'2c13f3db-0d8c-40b4-b97a-ed4b02877eb8'),
(2434,1845,NULL,1413,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'2b292a19-ce1a-45ca-b797-8b8352b0c03f'),
(2435,1846,NULL,1414,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'7dcc9947-c567-48fc-8f28-452082e360de'),
(2436,1371,NULL,1415,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'4bc9d9ba-31bf-48ce-b091-e1b2e37809e6'),
(2437,1850,NULL,1416,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'ba212c3f-a596-412b-8010-896c8635c7a3'),
(2438,1851,NULL,1417,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'625668bb-b59f-4385-b729-be0c8df447d9'),
(2439,1377,NULL,1418,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'94fff098-79fd-42e7-8043-959f261b5337'),
(2440,1855,NULL,1419,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'78fc354f-286f-4409-83fe-9d7e0ab48ee6'),
(2441,1856,NULL,1420,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'219de754-7949-4025-8356-cc77f7cee520'),
(2442,1383,NULL,1421,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'9785984c-dd86-450b-b529-e8087a3d74c6'),
(2443,1860,NULL,1422,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'a840cbe7-f639-4a9f-b1be-2c02cb2cccb3'),
(2444,1861,NULL,1423,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:36','2025-09-11 20:39:36',NULL,NULL,NULL,'19f58fd6-32c7-4770-b0cd-a3adf01002c3'),
(2445,1389,NULL,1424,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'fcdc2dce-6995-41ba-8e8f-b748e4df7a14'),
(2446,1865,NULL,1425,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'160e3d0a-1e12-4513-b797-e71c56cb5873'),
(2447,1866,NULL,1426,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'cbcc8965-9ff1-42d6-871c-df8f126844f0'),
(2448,1395,NULL,1427,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'ee63e3c3-657f-42cd-82a4-159eb5173afb'),
(2449,1870,NULL,1428,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'ac44157f-7d13-4dbf-8810-8d8191d068fd'),
(2450,1871,NULL,1429,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'8a096c6a-f26a-42ed-84c9-cb66dd2aded9'),
(2451,1401,NULL,1430,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'26a9b7cb-2bb6-4bb1-b3b0-ddce5f1db05d'),
(2452,1875,NULL,1431,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'344f3dcc-df4f-4862-8dc7-788bf7cca35d'),
(2453,1876,NULL,1432,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'6460116b-b922-4014-b99f-b0399674b736'),
(2454,1407,NULL,1433,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'4e5015bf-2cf4-49a5-82c4-6b4017b3a9ba'),
(2455,1880,NULL,1434,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'6f5fa7ae-78a6-46e9-a606-70bb2b28b856'),
(2456,1881,NULL,1435,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'a328c246-05bb-46cc-a94b-7fb52151ad08'),
(2457,1413,NULL,1436,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'e119a524-5b34-4c28-a95e-f3b48918737e'),
(2458,1885,NULL,1437,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'c78d3645-9668-4cb6-8143-ed476ca7c6eb'),
(2459,1886,NULL,1438,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'601ca390-6a8d-45c4-aa43-d18cc3960f87'),
(2460,1419,NULL,1439,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'13d8e805-1633-4a70-aaa4-a79dd5540a83'),
(2461,1890,NULL,1440,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'45a8ad70-0044-41e2-9169-f8e49485961d'),
(2462,1891,NULL,1441,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'ff1ac66d-c92e-4350-b7c7-b5ff6f6d718b'),
(2463,1425,NULL,1442,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'5d25cbb7-1ce2-4f47-a70d-bb9bb77f76f7'),
(2464,1895,NULL,1443,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'6a5c2cf4-c64c-4983-aea0-39f3c0c71e25'),
(2465,1896,NULL,1444,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'9c83df00-0358-438f-a7ae-c1ced938097e'),
(2466,1431,NULL,1445,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'6612c1de-535b-4fcd-97fd-95e01c14ab39'),
(2467,1900,NULL,1446,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'494aab11-2cd1-4443-beca-41df55b19858'),
(2468,1901,NULL,1447,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'619ba96f-c0c1-4680-ad8a-30cdd7878df7'),
(2469,1437,NULL,1448,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'0612b687-bc28-42e6-bd01-98552b99bf4a'),
(2470,1905,NULL,1449,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'caed6cba-1baa-4348-8f24-da474e051ffe'),
(2471,1906,NULL,1450,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:37',NULL,NULL,NULL,'0340d5c2-3598-4571-b476-e46e7c5426fb'),
(2472,1443,NULL,1451,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:38',NULL,NULL,NULL,'3412bce4-5016-4097-8ca3-4e2df3d26db3'),
(2473,1910,NULL,1452,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:38',NULL,NULL,NULL,'3d3d9ed5-dd22-4069-8bde-d8e7d6ed79a0'),
(2474,1911,NULL,1453,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:37','2025-09-11 20:39:38',NULL,NULL,NULL,'9614a6a2-90fc-42eb-8d0e-dfec76b8c68d'),
(2475,1449,NULL,1454,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'38aba39a-0322-4825-8439-e1173b1c251f'),
(2476,1915,NULL,1455,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'3dd2a0bd-1b32-4c57-ad79-a564fb6e89f3'),
(2477,1916,NULL,1456,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'41948a97-c816-4437-bd78-daadd75fd33c'),
(2478,1455,NULL,1457,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'db7c4b65-ae52-41cd-9314-33f537c1f5bc'),
(2479,1920,NULL,1458,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'fcaecb61-cd2c-401b-956f-e9bc1238011a'),
(2480,1921,NULL,1459,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'88788456-bbb6-4513-8104-b076a6f86f51'),
(2481,1461,NULL,1460,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'b40150b0-3477-4388-8a3f-d90d99a8b929'),
(2482,1925,NULL,1461,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'28cf4f1e-8941-417a-99e4-e5d448cb45b6'),
(2483,1926,NULL,1462,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'a74f0cfb-8234-4629-8684-aab1486dd1e4'),
(2484,1467,NULL,1463,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'b725cd86-2fff-4ea7-9b4b-6989100dc9e5'),
(2485,1930,NULL,1464,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'fbe32637-1457-4339-81f6-9011c1d42f2e'),
(2486,1931,NULL,1465,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'751e7a36-baf0-4343-9ee1-01e0c9a00fe7'),
(2487,1473,NULL,1466,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'15132208-ac5b-4d2d-921d-b49d10b9dbc5'),
(2488,1935,NULL,1467,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'89101061-0b59-4b87-8829-9dfccaa42ed9'),
(2489,1477,NULL,1468,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'4565583a-cd7e-42a2-bb8b-1eb48dd44483'),
(2490,1938,NULL,1469,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'ef99128a-288d-4762-a0bd-3ef128729c43'),
(2491,1481,NULL,1470,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'c3f3281f-4cca-4c3b-8c45-50bc9d1d259e'),
(2492,1941,NULL,1471,2,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:38','2025-09-11 20:39:38',NULL,NULL,NULL,'0697548d-424c-426b-884f-84436b0ef39c'),
(2493,2,NULL,1472,1,'craft\\elements\\Entry',1,0,'2025-09-11 20:39:45','2025-09-11 20:39:45',NULL,NULL,NULL,'495a7749-af8d-49c8-a6b9-e0c87103f07e'),
(2495,1255,NULL,1473,1,'craft\\elements\\Entry',1,0,'2025-09-16 22:43:05','2025-09-16 22:43:05',NULL,NULL,NULL,'ebf28e94-b65d-4006-803c-d194c2e2802d'),
(2499,2,NULL,1474,1,'craft\\elements\\Entry',1,0,'2025-09-17 19:37:16','2025-09-17 19:37:16',NULL,NULL,NULL,'03316bb3-2f55-4682-9204-128d91d29e6c'),
(2500,1486,NULL,1475,2,'craft\\elements\\Entry',1,0,'2025-09-17 19:37:16','2025-09-17 19:37:16',NULL,NULL,NULL,'95fac550-69f1-42b6-a591-ada2f68752af'),
(2501,1487,NULL,1476,2,'craft\\elements\\Entry',1,0,'2025-09-17 19:37:16','2025-09-17 19:37:16',NULL,NULL,NULL,'a94ed8ae-0e30-4160-b54e-a86536244182'),
(2504,NULL,437,NULL,2,'craft\\elements\\Entry',1,0,'2025-09-18 19:05:12','2025-09-18 19:05:12',NULL,NULL,NULL,'1bf94d00-f2b6-431f-941d-50d978be0d58'),
(2505,NULL,438,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-18 19:05:56','2025-09-18 19:05:56',NULL,NULL,NULL,'c9467667-c317-4f21-b15f-cf238a2cf152'),
(2506,NULL,439,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-18 19:06:07','2025-09-18 19:06:07',NULL,NULL,NULL,'56dbee44-e706-4928-a092-a16c1e9bba61'),
(2507,NULL,440,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-18 19:06:28','2025-09-18 19:06:28',NULL,NULL,NULL,'92b41541-7670-4f62-b8ea-d736e0d7590b'),
(2508,NULL,441,NULL,6,'craft\\elements\\Entry',1,0,'2025-09-18 19:07:14','2025-09-18 19:07:14',NULL,NULL,NULL,'76f1554d-f200-45f9-857c-e5ab84ba2ef7'),
(2509,NULL,442,NULL,5,'craft\\elements\\Entry',1,0,'2025-09-18 19:10:23','2025-09-18 19:10:23',NULL,NULL,NULL,'4b258bb6-8345-47c6-9618-ff5325483a67'),
(2510,NULL,443,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-18 19:10:54','2025-09-18 19:10:54',NULL,NULL,NULL,'de86485d-714d-484d-a1ba-4cba7bcea5d6'),
(2516,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-19 16:58:14','2025-09-19 16:58:14',NULL,NULL,NULL,'a88dc780-1702-4136-8c14-39c1b8af932e'),
(2518,605,NULL,1477,5,'craft\\elements\\Entry',1,0,'2025-09-19 16:58:18','2025-09-19 16:58:18',NULL,NULL,NULL,'c4ac66da-0efc-4159-9b88-86cb23f6d62a'),
(2519,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:25:28','2025-09-24 19:41:47',NULL,NULL,NULL,'798407a8-dc42-4891-824a-5b688cae9b01'),
(2520,2519,NULL,1478,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:27:09','2025-09-19 17:27:09',NULL,NULL,NULL,'fa3f1a9f-6f97-42f5-99a3-205b578e474b'),
(2522,2519,NULL,1479,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:27:31','2025-09-19 17:27:31',NULL,NULL,NULL,'e5505781-4c57-4615-8b16-d5ef7ba052ec'),
(2523,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:28:47','2025-09-24 17:20:23',NULL,NULL,NULL,'2e9f1bdb-a41c-42cc-8dde-7aa89ffddd2f'),
(2524,2523,NULL,1480,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:29:12','2025-09-19 17:29:12',NULL,NULL,NULL,'9f84aee8-686d-471e-8b34-83d6caf38ded'),
(2526,2523,NULL,1481,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:29:35','2025-09-19 17:29:35',NULL,NULL,NULL,'8f6a715d-fff5-4e6c-8926-4cdf0ec3db0d'),
(2527,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:30:10','2025-09-24 17:20:14',NULL,NULL,NULL,'fc7c950a-4533-492a-a7a7-e2afea558b45'),
(2528,2527,NULL,1482,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:31:21','2025-09-19 17:31:21',NULL,NULL,NULL,'14ceef1a-cf0a-4f95-92a4-1f227f35893c'),
(2530,2527,NULL,1483,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:31:59','2025-09-19 17:31:59',NULL,NULL,NULL,'8ad99ee4-b840-43d9-a671-379c3e9e99fb'),
(2531,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:32:19','2025-09-30 19:28:07',NULL,NULL,NULL,'f679d85c-04bf-4fdf-aa69-2619259a729e'),
(2532,2531,NULL,1484,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:33:26','2025-09-19 17:33:26',NULL,NULL,NULL,'ec10f6fb-97fa-43dc-a55a-499e37faaa0e'),
(2534,2531,NULL,1485,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:34:50','2025-09-19 17:34:50',NULL,NULL,NULL,'9e3e9ed4-21f7-4059-9a2c-e745e294f9d6'),
(2535,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:34:52','2025-09-24 17:19:43',NULL,NULL,NULL,'a7be63ba-1aef-4be2-bbdf-387693347e0c'),
(2536,2535,NULL,1486,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:35:50','2025-09-19 17:35:50',NULL,NULL,NULL,'50604867-8e85-40ba-987a-deb315a8b043'),
(2537,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:37:12','2025-09-24 17:19:53',NULL,NULL,NULL,'56881ee1-2b77-454e-b507-84c6eeef5674'),
(2538,2537,NULL,1487,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:38:19','2025-09-19 17:38:19',NULL,NULL,NULL,'4ca31b6d-0a38-4b5f-b1b4-45ff2cc21e8b'),
(2540,2535,NULL,1488,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:38:52','2025-09-19 17:38:52',NULL,NULL,NULL,'85586ca8-0eb5-4f04-a1ce-3a1396134b8f'),
(2542,2537,NULL,1489,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:18','2025-09-19 17:40:18',NULL,NULL,NULL,'493901ce-3b81-4599-b50a-4ca08a357afa'),
(2544,2535,NULL,1490,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:24','2025-09-19 17:40:24',NULL,NULL,NULL,'16370887-6b06-44bd-8209-3f7d03301751'),
(2546,2531,NULL,1491,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:31','2025-09-19 17:40:31',NULL,NULL,NULL,'cc536b73-77ec-426a-ae5d-ff768d2f5e4e'),
(2548,2527,NULL,1492,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:36','2025-09-19 17:40:36',NULL,NULL,NULL,'ddcf4584-17c9-4aeb-884f-8cbcc989ffd1'),
(2550,2523,NULL,1493,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:43','2025-09-19 17:40:43',NULL,NULL,NULL,'589cd3dd-fa2a-43a5-a2ac-a51ad123960a'),
(2552,2519,NULL,1494,12,'craft\\elements\\Entry',1,0,'2025-09-19 17:40:50','2025-09-19 17:40:50',NULL,NULL,NULL,'a606d8ab-1fdf-4776-9e86-df6900369c8f'),
(2553,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:07','2025-09-19 18:50:13',NULL,NULL,NULL,'1f82e73c-c692-4568-b585-ae99eb7d380b'),
(2554,2553,NULL,1495,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:13','2025-09-19 18:50:13',NULL,NULL,NULL,'447453c2-b29f-478c-946d-abd97da673ff'),
(2555,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:13','2025-09-19 18:50:15',NULL,NULL,NULL,'b329aaf6-6f21-444a-b552-c1d9a05f909f'),
(2556,2555,NULL,1496,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:15','2025-09-19 18:50:15',NULL,NULL,NULL,'6b12fb58-47ab-496a-a6ef-81c893b554d6'),
(2557,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:15','2025-09-19 18:50:18',NULL,NULL,NULL,'d89963c6-a945-4912-b645-59a7dbe99761'),
(2558,2557,NULL,1497,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:18','2025-09-19 18:50:18',NULL,NULL,NULL,'ea0ccd3e-caa3-4ba3-b016-4af7d0df34c4'),
(2559,NULL,NULL,NULL,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:18','2025-09-19 18:50:27',NULL,NULL,NULL,'92068cd8-0a8e-4188-93e4-d0adbb22dc1e'),
(2560,2559,NULL,1498,18,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:27','2025-09-19 18:50:27',NULL,NULL,NULL,'34e48f02-d6e9-488f-86e0-0cffb3195a70'),
(2561,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:37','2025-09-19 18:50:45',NULL,NULL,NULL,'a231e115-688d-4f00-b246-4c3505b058dc'),
(2562,2561,NULL,1499,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:45','2025-09-19 18:50:45',NULL,NULL,NULL,'935997ba-edcf-4fd2-89ac-fbc4b386f843'),
(2563,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:45','2025-09-19 18:50:48',NULL,NULL,NULL,'a9ae196c-4c39-41b5-a34b-03614b7a607a'),
(2564,2563,NULL,1500,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:48','2025-09-19 18:50:48',NULL,NULL,NULL,'cde9bda8-b387-4efd-92c1-35b8fafb67cf'),
(2565,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:48','2025-09-19 18:50:50',NULL,NULL,NULL,'ee7ae933-c2c6-4a6a-8f16-96b6f1b9b6bd'),
(2566,2565,NULL,1501,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:50','2025-09-19 18:50:50',NULL,NULL,NULL,'d087424b-77d9-433a-b247-1ee011a5834c'),
(2567,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:50','2025-09-19 18:50:52',NULL,NULL,NULL,'be85fe8b-f433-47f1-95d4-351af20a2806'),
(2568,2567,NULL,1502,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:52','2025-09-19 18:50:52',NULL,NULL,NULL,'0b23eb9f-9b41-4259-a1ea-c97d2c437346'),
(2569,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:52','2025-09-19 18:50:55',NULL,NULL,NULL,'4dd3b51c-ef51-4e69-a1ae-51b556192a86'),
(2570,2569,NULL,1503,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:55','2025-09-19 18:50:55',NULL,NULL,NULL,'9aa038d4-3589-415e-9fce-ff6f17a1a4e4'),
(2571,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:55','2025-09-19 18:50:59',NULL,NULL,NULL,'b608439b-ca0f-4766-b3e2-94df92a69e2e'),
(2572,2571,NULL,1504,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:59','2025-09-19 18:50:59',NULL,NULL,NULL,'d42f5795-c8d7-43b8-9c6e-50db5eb4422a'),
(2573,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:50:59','2025-09-19 18:51:06',NULL,NULL,NULL,'d41283ba-951c-4073-81d9-a12cab8c4ca2'),
(2574,2573,NULL,1505,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:03','2025-09-19 18:51:03',NULL,NULL,NULL,'e650f765-b5b2-4adb-b603-6ffea7fe1eab'),
(2575,2573,NULL,1506,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:06','2025-09-19 18:51:06',NULL,NULL,NULL,'64a59e0d-63dd-4e47-9235-f311e24c2822'),
(2576,NULL,NULL,NULL,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:06','2025-09-19 18:51:09',NULL,NULL,NULL,'328cf59f-6de8-42e8-a1b4-0e8ca15a9118'),
(2577,2576,NULL,1507,19,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:09','2025-09-19 18:51:09',NULL,NULL,NULL,'efe25b57-54ec-4dda-86e7-f8e3db89d470'),
(2579,2537,NULL,1508,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:30','2025-09-19 18:51:30',NULL,NULL,NULL,'d1828e30-43ad-41ad-a279-bf18508cc953'),
(2581,2535,NULL,1509,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:46','2025-09-19 18:51:46',NULL,NULL,NULL,'2b22d8d4-2fa6-4aac-98be-d594893b5212'),
(2583,2531,NULL,1510,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:51:56','2025-09-19 18:51:56',NULL,NULL,NULL,'d4ea6741-e126-47b2-9b94-4261ad889e7a'),
(2585,2527,NULL,1511,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:52:10','2025-09-19 18:52:10',NULL,NULL,NULL,'533472d2-9f5b-422f-8881-c8fc9d1cec24'),
(2587,2523,NULL,1512,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:52:18','2025-09-19 18:52:18',NULL,NULL,NULL,'c2990695-289a-4a5b-82ff-a483f97bf743'),
(2589,2519,NULL,1513,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:52:27','2025-09-19 18:52:27',NULL,NULL,NULL,'f0260a8f-8d2d-4af1-9771-887da16e8f84'),
(2590,NULL,NULL,NULL,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:52:38','2025-09-19 19:15:03',NULL,NULL,NULL,'6cae16a6-f883-4139-a765-c67347143182'),
(2591,2590,NULL,1514,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:53:29','2025-09-19 18:53:29',NULL,NULL,NULL,'530fb6e6-1e63-401c-8814-5f6576b81df6'),
(2592,2537,NULL,1515,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:53:35','2025-09-19 18:53:35',NULL,NULL,NULL,'6f41855b-e4c1-4d65-90bf-3edb7c561ac0'),
(2594,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-19 18:57:57','2025-09-19 18:57:57',NULL,NULL,NULL,'42d65d55-306b-417d-8600-0bb8ec837d7a'),
(2595,2590,NULL,1516,12,'craft\\elements\\Entry',1,0,'2025-09-19 18:57:59','2025-09-19 18:57:59',NULL,NULL,NULL,'b0b62e6c-322d-4cd0-bf67-e701786ccddc'),
(2596,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:05:39','2025-09-19 19:06:52',NULL,NULL,NULL,'ed5b5724-8a1c-4424-a8aa-bcc5e5591568'),
(2597,2596,NULL,1517,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:06:52','2025-09-19 19:06:52',NULL,NULL,NULL,'cf4c9543-4654-44b2-bc1a-0eec18aa2fdf'),
(2598,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:06:52','2025-09-19 19:06:57',NULL,NULL,NULL,'2b425daa-3c83-4d5f-855e-9aaadf81a9e3'),
(2599,2598,NULL,1518,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:06:57','2025-09-19 19:06:57',NULL,NULL,NULL,'0a37fe07-9f4b-4616-bd4d-d342ccbdab00'),
(2600,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:06:57','2025-09-19 19:07:03',NULL,NULL,NULL,'03b51710-5c79-4483-afe4-bda55784e2f3'),
(2601,2600,NULL,1519,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:03','2025-09-19 19:07:03',NULL,NULL,NULL,'57723b37-e14c-4bbe-bac4-0df0f4508f5b'),
(2602,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:03','2025-09-19 19:07:09',NULL,NULL,NULL,'bd40e808-1b5a-4674-8f1f-79ce381e440c'),
(2603,2602,NULL,1520,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:09','2025-09-19 19:07:09',NULL,NULL,NULL,'31cd7061-ac55-4c56-9548-7d2f30484574'),
(2604,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:09','2025-09-19 19:07:13',NULL,NULL,NULL,'c1580479-2261-4e66-a3b0-771bbd6898b3'),
(2605,2604,NULL,1521,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:13','2025-09-19 19:07:13',NULL,NULL,NULL,'c43cf147-5984-4462-bce8-231f550507c2'),
(2606,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:13','2025-09-19 19:07:17',NULL,NULL,NULL,'a54c9d4f-1de7-4f3f-a0d9-1bc5ef6c3b82'),
(2607,2606,NULL,1522,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:17','2025-09-19 19:07:17',NULL,NULL,NULL,'705217ff-3a28-400c-a46f-3446855a2538'),
(2608,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:17','2025-09-19 19:07:23',NULL,NULL,NULL,'f9a5647d-ff01-4f49-a021-5fc8e32ddc73'),
(2609,2608,NULL,1523,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:23','2025-09-19 19:07:23',NULL,NULL,NULL,'366283e4-5e9a-43e9-bc56-54b1250d0c21'),
(2610,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:23','2025-09-19 19:07:27',NULL,NULL,NULL,'775903a5-eb1a-492f-a3a4-59a280676468'),
(2611,2610,NULL,1524,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:27','2025-09-19 19:07:27',NULL,NULL,NULL,'9690e450-9ea6-48b5-a4ef-5e0f65ce5dc1'),
(2612,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:27','2025-09-19 19:07:36',NULL,NULL,NULL,'cf692f93-e1c4-4161-ac36-11ae0932ee6d'),
(2613,2612,NULL,1525,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:36','2025-09-19 19:07:36',NULL,NULL,NULL,'9d55947e-e594-40a3-a249-5c5c28525fde'),
(2614,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:36','2025-09-19 19:07:44',NULL,NULL,NULL,'cb61d67e-83c4-4abc-bf6e-080ed8a8a973'),
(2615,2614,NULL,1526,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:44','2025-09-19 19:07:44',NULL,NULL,NULL,'9abe030a-b0f1-49da-b606-49d5c64d67c6'),
(2616,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:44','2025-09-22 17:36:14',NULL,'2025-09-22 17:36:14',NULL,'1585f072-dbe2-4e26-a123-c6ae0273e564'),
(2617,2616,NULL,1527,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:47','2025-09-19 19:07:47',NULL,'2025-09-22 17:36:14',NULL,'29963604-bb2a-4542-8325-5d0a929aebe0'),
(2618,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:47','2025-09-19 19:07:49',NULL,NULL,NULL,'b5e0de7b-b9c8-48f0-91c6-484d8caa02ca'),
(2619,2618,NULL,1528,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:49','2025-09-19 19:07:49',NULL,NULL,NULL,'13d5c252-c187-4d28-a171-c29ca8de64cd'),
(2620,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:49','2025-09-26 16:12:24',NULL,'2025-09-26 16:12:24',NULL,'a35a0819-49d2-4d5f-ae68-e84695c72829'),
(2621,2620,NULL,1529,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:53','2025-09-19 19:07:53',NULL,'2025-09-26 16:12:24',NULL,'c64ba2e0-e3d4-419e-b291-e7187ceef2f7'),
(2622,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:53','2025-09-24 16:01:26',NULL,NULL,NULL,'0a1cb6bd-d0cc-4b56-94d6-4573d769d02c'),
(2623,2622,NULL,1530,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:55','2025-09-19 19:07:55',NULL,NULL,NULL,'ccb4c11c-644a-45d9-a660-734ba66b717a'),
(2624,NULL,NULL,NULL,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:55','2025-09-19 19:07:59',NULL,NULL,NULL,'501cb39a-b029-4e58-b73e-2c796bd1926c'),
(2625,2624,NULL,1531,20,'craft\\elements\\Entry',1,0,'2025-09-19 19:07:59','2025-09-19 19:07:59',NULL,NULL,NULL,'5a043e60-e89d-457d-ad36-2d7d38519ce8'),
(2626,2,NULL,1532,1,'craft\\elements\\Entry',1,0,'2025-09-19 19:10:35','2025-09-19 19:10:35',NULL,NULL,NULL,'cd94c5fa-ab73-4c55-a0a3-782ddf513bc1'),
(2627,945,NULL,1533,1,'craft\\elements\\Entry',1,0,'2025-09-19 19:10:40','2025-09-19 19:10:40',NULL,NULL,NULL,'eaf36663-e691-4c12-a7c4-9e5e33ad4f2b'),
(2628,1255,NULL,1534,1,'craft\\elements\\Entry',1,0,'2025-09-19 19:10:44','2025-09-19 19:10:44',NULL,NULL,NULL,'af395f92-4d90-4e6e-828c-13b2c1e28c08'),
(2629,1165,NULL,1535,1,'craft\\elements\\Entry',1,0,'2025-09-19 19:10:48','2025-09-19 19:10:48',NULL,NULL,NULL,'e1a41b0a-395c-461c-98d7-ffda5bf0a805'),
(2631,2590,NULL,1536,12,'craft\\elements\\Entry',1,0,'2025-09-19 19:15:03','2025-09-19 19:15:03',NULL,NULL,NULL,'3b597831-2740-4f3d-9196-0d831107edfb'),
(2633,497,NULL,1537,6,'craft\\elements\\Entry',1,0,'2025-09-19 19:22:04','2025-09-19 19:22:04',NULL,NULL,NULL,'6272791a-de82-4b56-9175-163e15b04f6b'),
(2635,951,NULL,1538,1,'craft\\elements\\Entry',1,0,'2025-09-22 17:36:50','2025-09-22 17:36:50',NULL,NULL,NULL,'567baa8c-18ca-4f71-bf0c-49d45ab5d6e9'),
(2637,1353,NULL,1539,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:01:29','2025-09-22 18:01:29',NULL,NULL,NULL,'0cfd97a2-b25e-4990-8d49-4e4a73836e75'),
(2640,1359,NULL,1540,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:03:21','2025-09-22 18:03:22',NULL,NULL,NULL,'5d28cdde-151f-4f3c-866c-1ad41a17312c'),
(2641,1353,NULL,1541,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:03:40','2025-09-22 18:03:40',NULL,NULL,NULL,'9b6e0d49-0cd5-42cc-b5d3-49c6382ccb72'),
(2643,1365,NULL,1542,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:04:13','2025-09-22 18:04:13',NULL,NULL,NULL,'2f77c9ad-e35a-40f5-81ff-806c1f22da65'),
(2645,1371,NULL,1543,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:04:46','2025-09-22 18:04:46',NULL,NULL,NULL,'ec8a6866-7615-4634-a4ec-ffe1e7799e18'),
(2647,1353,NULL,1544,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:04:56','2025-09-22 18:04:56',NULL,NULL,NULL,'fa7fd048-7fe9-41c6-97e5-ae47bd39fadd'),
(2649,1359,NULL,1545,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:05:05','2025-09-22 18:05:05',NULL,NULL,NULL,'2d451d36-1ae8-48bd-bce5-4eae79f08bfc'),
(2651,1365,NULL,1546,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:05:37','2025-09-22 18:05:37',NULL,NULL,NULL,'c697e627-4e31-4d1a-880e-5b89c6307c8b'),
(2653,1377,NULL,1547,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:06:29','2025-09-22 18:06:29',NULL,NULL,NULL,'8ddfb5d1-1881-47b0-a5f8-6f766eb4e9c9'),
(2655,1383,NULL,1548,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:06:50','2025-09-22 18:06:50',NULL,NULL,NULL,'b6f34d50-21c8-4413-b4fa-cb591a437244'),
(2657,1389,NULL,1549,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:07:16','2025-09-22 18:07:16',NULL,NULL,NULL,'f5c5299c-8dfe-4fff-b2b2-214e915f50c0'),
(2659,1395,NULL,1550,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:08:00','2025-09-22 18:08:00',NULL,NULL,NULL,'d8d50f8a-5155-43f9-ad24-d17286bcab2c'),
(2661,1401,NULL,1551,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:08:33','2025-09-22 18:08:33',NULL,NULL,NULL,'af589c20-0be9-4a3e-9752-b34db1355b8d'),
(2663,1407,NULL,1552,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:08:56','2025-09-22 18:08:56',NULL,NULL,NULL,'c956fdad-0162-4993-b457-60ded1ef76f9'),
(2665,1413,NULL,1553,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:09:23','2025-09-22 18:09:23',NULL,NULL,NULL,'d60c7ef7-e87a-4f3c-b875-12d039894748'),
(2667,1413,NULL,1554,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:09:38','2025-09-22 18:09:38',NULL,NULL,NULL,'4452d2c3-b7e9-40b4-9b5d-f251e3d6fdc5'),
(2669,1413,NULL,1555,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:09:54','2025-09-22 18:09:54',NULL,NULL,NULL,'1988353a-0bb8-4430-b9a8-3cbffc4772fc'),
(2671,1359,NULL,1556,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:10:03','2025-09-22 18:10:03',NULL,NULL,NULL,'1e51a1e3-3b09-471d-86b5-8c3caa82a99a'),
(2673,1353,NULL,1557,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:10:11','2025-09-22 18:10:11',NULL,NULL,NULL,'7b3ecea1-cf13-4251-a491-14c4e29e37e8'),
(2675,1395,NULL,1558,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:10:30','2025-09-22 18:10:30',NULL,NULL,NULL,'f4e3d187-5f5b-4240-8d04-2f09cde373d0'),
(2678,1365,NULL,1559,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:10:48','2025-09-22 18:10:48',NULL,NULL,NULL,'31e57a87-8928-4f1b-8f68-ff5b8dafce53'),
(2680,1371,NULL,1560,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:11:25','2025-09-22 18:11:25',NULL,NULL,NULL,'02a82296-3dee-4128-9909-4b2cb74a82c6'),
(2682,1377,NULL,1561,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:11:35','2025-09-22 18:11:35',NULL,NULL,NULL,'044d3a09-7711-4916-9efb-81892f95fb05'),
(2684,1383,NULL,1562,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:11:49','2025-09-22 18:11:49',NULL,NULL,NULL,'8ed1ac02-aefa-4daf-9d24-698ac17f4712'),
(2686,1389,NULL,1563,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:12:03','2025-09-22 18:12:03',NULL,NULL,NULL,'b437b1a6-ba58-4119-a194-8216f04fa596'),
(2689,1401,NULL,1564,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:12:28','2025-09-22 18:12:28',NULL,NULL,NULL,'e067c24c-2576-4600-abab-2c6703865199'),
(2691,1407,NULL,1565,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:13:02','2025-09-22 18:13:02',NULL,NULL,NULL,'d95c3554-d596-4337-95e6-f25c14ea837e'),
(2693,1413,NULL,1566,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:18:15','2025-09-22 18:18:15',NULL,NULL,NULL,'7d3c09d5-33bc-49b0-9b20-52ab558dd130'),
(2695,1353,NULL,1567,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:20:10','2025-09-22 18:20:10',NULL,NULL,NULL,'cf9416ca-910d-4782-b4f7-350e2f6a7685'),
(2697,1359,NULL,1568,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:20:32','2025-09-22 18:20:33',NULL,NULL,NULL,'75051435-a9e8-4561-91e8-46d34b6aca30'),
(2698,1365,NULL,1569,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:20:52','2025-09-22 18:20:52',NULL,NULL,NULL,'bbf8407d-bac1-47fb-b03a-5b057b9a32df'),
(2699,1395,NULL,1570,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:21:16','2025-09-22 18:21:16',NULL,NULL,NULL,'c058663d-1b8b-4b28-abbe-a485ead99e64'),
(2701,1371,NULL,1571,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:21:35','2025-09-22 18:21:35',NULL,NULL,NULL,'b0bb1e40-42aa-4e8c-a453-e9d77f1d9e0f'),
(2703,1377,NULL,1572,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:22:06','2025-09-22 18:22:06',NULL,NULL,NULL,'6fadb5fa-d81a-4f7d-8b92-c83d74107c67'),
(2705,1401,NULL,1573,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:22:29','2025-09-22 18:22:29',NULL,NULL,NULL,'ce543f07-040e-4d57-bcc5-8acd57217816'),
(2707,1383,NULL,1574,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:22:45','2025-09-22 18:22:45',NULL,NULL,NULL,'aebab139-b1aa-43a9-b06b-8c7cfabcb458'),
(2709,1389,NULL,1575,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:23:01','2025-09-22 18:23:02',NULL,NULL,NULL,'ef58f931-789e-483c-a450-8b7d4d1eb7ed'),
(2711,1407,NULL,1576,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:23:24','2025-09-22 18:23:24',NULL,NULL,NULL,'f96f2cd0-e318-46d3-a704-1a5f524db1b1'),
(2712,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:31:54','2025-10-06 16:09:59',NULL,NULL,NULL,'dd61e91a-428e-4c7e-92a2-b1678fb22a9f'),
(2713,2712,NULL,1577,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:33:07','2025-09-22 18:33:07',NULL,NULL,NULL,'f0e219c3-0b40-405e-b74f-3a6a4e87fcee'),
(2716,2712,NULL,1578,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:33:47','2025-09-22 18:33:47',NULL,NULL,NULL,'c725bc56-b88f-4150-b481-9efd1c0431e5'),
(2717,2,NULL,1579,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:33:52','2025-09-22 18:33:52',NULL,NULL,NULL,'2b7dd672-66e5-45ee-a14b-413bd45df09f'),
(2719,2712,NULL,1580,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:33:59','2025-09-22 18:33:59',NULL,NULL,NULL,'055e1545-833e-4929-b4dc-1d22a9d7787d'),
(2720,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:34:20','2025-10-08 22:20:23',NULL,NULL,NULL,'8edf8d99-3b37-4cf7-8604-05cdfd866b47'),
(2721,2720,NULL,1581,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:35:27','2025-09-22 18:35:27',NULL,NULL,NULL,'c1d0d498-a622-47b1-a8d7-7e0f0a6bf998'),
(2723,2720,NULL,1582,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:35:58','2025-09-22 18:35:58',NULL,NULL,NULL,'b90d043b-1cbf-4469-beb6-f9248e860704'),
(2725,2720,NULL,1583,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:36:12','2025-09-22 18:36:12',NULL,NULL,NULL,'0f75944b-28b9-4f57-a792-1cf7f9f23fe2'),
(2727,2720,NULL,1584,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:36:20','2025-09-22 18:36:20',NULL,NULL,NULL,'7d8cf309-af4b-4543-9dea-d4576cd6748a'),
(2729,2712,NULL,1585,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:36:55','2025-09-22 18:36:55',NULL,NULL,NULL,'1ef5bc5d-deb8-4f07-a030-6782faff4a0b'),
(2731,2,NULL,1586,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:42:24','2025-09-22 18:42:24',NULL,NULL,NULL,'00c6af15-ce7d-4849-a610-326c7c928efa'),
(2732,1059,NULL,1587,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:42:30','2025-09-22 18:42:30',NULL,NULL,NULL,'f99c1038-bb40-418b-9813-63a7025dfd6f'),
(2733,1283,NULL,1588,1,'craft\\elements\\Entry',1,0,'2025-09-22 18:42:35','2025-09-22 18:42:35',NULL,NULL,NULL,'464e4b65-76d2-4d1a-8f39-81b5f6bdda47'),
(2735,NULL,554,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-22 19:39:53','2025-09-22 19:39:53',NULL,NULL,NULL,'08fe5f3a-2bd4-4a5b-8fa4-3e4c8e7b91bf'),
(2736,2,NULL,1589,1,'craft\\elements\\Entry',1,0,'2025-09-22 19:42:28','2025-09-22 19:42:29',NULL,NULL,NULL,'8301ac1c-cbef-421f-bfde-7c3436caf2a4'),
(2740,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-22 20:40:47','2025-09-22 20:46:11',NULL,'2025-09-22 20:46:11',NULL,'f0036f95-cf2b-4e1d-baf9-6310bfa91a51'),
(2742,601,NULL,1590,5,'craft\\elements\\Entry',1,0,'2025-09-22 20:40:59','2025-09-22 20:40:59',NULL,NULL,NULL,'90518e6f-0901-4395-be9a-cd14eda0165c'),
(2743,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'a520d29b-eced-425e-bf1a-f1a35646d600'),
(2744,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'7c1de11f-ebcf-4c6e-b2e8-1c5eb53efc68'),
(2745,2,NULL,1591,1,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'5ebcf8a0-f927-4075-97e3-43891e2ffeaa'),
(2746,2743,NULL,1592,3,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'50b13f66-01f6-4bee-8165-85f2e52ab10a'),
(2747,2744,NULL,1593,3,'craft\\elements\\Entry',1,0,'2025-09-22 20:41:13','2025-09-22 20:41:13',NULL,NULL,NULL,'5c11c11b-6c2d-46c1-96c3-9442dcacdd1d'),
(2750,601,NULL,1594,5,'craft\\elements\\Entry',1,0,'2025-09-22 20:45:52','2025-09-22 20:45:52',NULL,NULL,NULL,'53ce4217-639b-419a-a73c-6443a3417118'),
(2751,459,NULL,1595,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:24:58','2025-09-23 20:24:58',NULL,NULL,NULL,'5a05c997-033a-4a62-ba13-559b802db7ef'),
(2753,459,NULL,1596,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:08','2025-09-23 20:25:08',NULL,NULL,NULL,'83e87564-d2a9-441d-94c8-ed6e5f2bf570'),
(2754,461,NULL,1597,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:25','2025-09-23 20:25:25',NULL,NULL,NULL,'e5f3ce22-f12e-4c27-bd18-8800f1f29444'),
(2756,457,NULL,1598,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:31','2025-09-23 20:25:31',NULL,NULL,NULL,'79000580-aa18-4ac5-960c-e1ec4bacd872'),
(2758,463,NULL,1599,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:37','2025-09-23 20:25:37',NULL,NULL,NULL,'18d046ca-46ee-4d51-9f67-2c42cdcaf067'),
(2760,465,NULL,1600,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:47','2025-09-23 20:25:47',NULL,NULL,NULL,'fda55c44-299e-4f1a-ae6d-fbbeec708d23'),
(2761,467,NULL,1601,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:25:55','2025-09-23 20:25:55',NULL,NULL,NULL,'20ab7767-16a4-4677-91c8-e5a8581b8e17'),
(2763,469,NULL,1602,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:04','2025-09-23 20:26:04',NULL,NULL,NULL,'27d68ba6-8788-4d0e-b5ca-40669ea528b7'),
(2764,471,NULL,1603,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:11','2025-09-23 20:26:11',NULL,NULL,NULL,'7272a6d5-a6bd-495f-a010-cee877695ac9'),
(2766,475,NULL,1604,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:19','2025-09-23 20:26:19',NULL,NULL,NULL,'774aa463-25fe-45e9-85e8-89b8f2eeb2dc'),
(2768,475,NULL,1605,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:26','2025-09-23 20:26:26',NULL,NULL,NULL,'e5b5440a-7cd9-4e0b-9320-3d413c6c873d'),
(2769,477,NULL,1606,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:34','2025-09-23 20:26:34',NULL,NULL,NULL,'9c3a45da-b569-44f2-8afe-f869cae19015'),
(2770,479,NULL,1607,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:42','2025-09-23 20:26:42',NULL,NULL,NULL,'1044a086-a589-4314-8063-db7230f407f8'),
(2772,481,NULL,1608,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:26:54','2025-09-23 20:26:54',NULL,NULL,NULL,'2e91cad0-71c1-4ae3-b7f4-249b6bbba78d'),
(2774,483,NULL,1609,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:27:03','2025-09-23 20:27:03',NULL,NULL,NULL,'89510032-755b-4553-9af0-79e69d2f2aba'),
(2775,485,NULL,1610,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:27:13','2025-09-23 20:27:13',NULL,NULL,NULL,'54c4f5d4-0aed-4ab5-a2eb-87fb9ff18ca7'),
(2776,497,NULL,1611,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:27:28','2025-09-23 20:27:28',NULL,NULL,NULL,'d2ffd692-e9c1-4969-8340-7a3bd760e48b'),
(2778,487,NULL,1612,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:02','2025-09-23 20:29:02',NULL,NULL,NULL,'bbcf8b4e-8275-4917-a71b-81fe04c749fa'),
(2780,489,NULL,1613,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:09','2025-09-23 20:29:09',NULL,NULL,NULL,'adc63a2c-f16a-4cd2-8937-f5e39b1b1d5e'),
(2781,491,NULL,1614,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:17','2025-09-23 20:29:17',NULL,NULL,NULL,'74537ed0-d9b5-4630-a5a0-13cd647368ae'),
(2782,493,NULL,1615,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:24','2025-09-23 20:29:24',NULL,NULL,NULL,'0046eebf-0773-4e96-abdb-7005b1844456'),
(2784,495,NULL,1616,6,'craft\\elements\\Entry',1,0,'2025-09-23 20:29:38','2025-09-23 20:29:38',NULL,NULL,NULL,'94205c05-e2f4-414d-a0dd-443cbfdec53b'),
(2785,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:43:42','2025-09-30 22:22:13',NULL,NULL,NULL,'e13f4958-4796-464e-b66a-72e49c7d45cb'),
(2786,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:43:49','2025-09-30 22:22:24',NULL,NULL,NULL,'e6acfaec-6184-424c-8a4f-fbe541f2fe91'),
(2787,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:43:54','2025-09-30 22:22:37',NULL,NULL,NULL,'46ebec47-7046-4634-af10-57e83a4bd1aa'),
(2791,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-30 22:41:39',NULL,NULL,NULL,'75a41dd2-8fe4-4d4a-9c95-66b0698211a3'),
(2792,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-30 22:45:18',NULL,'2025-09-30 22:45:18',NULL,'de2fd3c6-8fe9-4b33-924e-4bac8ed713ab'),
(2793,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-30 22:46:11',NULL,NULL,NULL,'bb6951d7-9f9a-4283-bc5e-6467bf906b9e'),
(2794,2,NULL,1617,1,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-23 20:45:18',NULL,NULL,NULL,'e647b307-5a23-4c78-8c3f-33870184eb7e'),
(2795,2791,NULL,1618,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-23 20:45:18',NULL,NULL,NULL,'333e2a9e-590f-4f51-beae-f7048d30c5cf'),
(2796,2792,NULL,1619,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-23 20:45:18',NULL,'2025-09-30 22:45:18',NULL,'a5deccbe-6457-4cdc-9c99-fd5a01af792d'),
(2797,2793,NULL,1620,21,'craft\\elements\\Entry',1,0,'2025-09-23 20:45:18','2025-09-23 20:45:18',NULL,NULL,NULL,'1e6b62b8-1294-42f0-8203-58ef942874b6'),
(2799,2,NULL,1621,1,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:07','2025-09-23 21:13:07',NULL,NULL,NULL,'9945537d-c2b2-459f-a8c4-fc387da11a49'),
(2800,NULL,NULL,NULL,22,'craft\\elements\\Asset',1,0,'2025-09-23 21:13:16','2025-09-23 21:22:49',NULL,NULL,NULL,'d06a14ea-0b3f-46f1-9fc3-27f80e36224e'),
(2802,459,NULL,1622,6,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:19','2025-09-23 21:13:19',NULL,NULL,NULL,'c6632179-233c-4e81-8b06-f027664fe5c6'),
(2803,NULL,NULL,NULL,22,'craft\\elements\\Asset',1,0,'2025-09-23 21:13:36','2025-09-23 21:22:40',NULL,NULL,NULL,'645ea5ae-4175-4410-ba89-7daf862ff408'),
(2805,465,NULL,1623,6,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:37','2025-09-23 21:13:37',NULL,NULL,NULL,'3c57da7a-d1fa-4fd7-8b32-89ab823a439d'),
(2806,NULL,NULL,NULL,22,'craft\\elements\\Asset',1,0,'2025-09-23 21:13:42','2025-09-23 21:22:33',NULL,NULL,NULL,'3aa27850-e4b8-4894-b00a-059bfe04c324'),
(2808,497,NULL,1624,6,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:43','2025-09-23 21:13:43',NULL,NULL,NULL,'0b046278-b13a-4781-88f7-6d2b466a1a29'),
(2809,NULL,NULL,NULL,22,'craft\\elements\\Asset',1,0,'2025-09-23 21:13:48','2025-09-23 21:22:25',NULL,NULL,NULL,'1442f42d-5abd-4e2c-a860-c63e22014cab'),
(2811,487,NULL,1625,6,'craft\\elements\\Entry',1,0,'2025-09-23 21:13:50','2025-09-23 21:13:50',NULL,NULL,NULL,'bb03ac1d-f805-4602-abeb-2294590f0184'),
(2812,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:56:15','2025-09-23 21:56:42',NULL,NULL,NULL,'9e84d8c4-96c0-4bce-b66e-a095a9f0f08b'),
(2813,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:56:43','2025-09-23 21:56:57',NULL,NULL,NULL,'d2b74fb7-6d80-4ad7-81d2-2be6696b7351'),
(2814,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:57:02','2025-09-23 21:57:09',NULL,NULL,NULL,'331a4fd5-0801-4feb-b418-dcc4cab532ac'),
(2815,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:57:13','2025-09-23 21:57:19',NULL,NULL,NULL,'9805002c-e2bf-456f-aabe-b2e1aa762420'),
(2816,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:57:23','2025-09-23 21:57:28',NULL,NULL,NULL,'a35a41c4-7359-413b-b4a3-3abcc48f9f51'),
(2817,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:57:32','2025-09-23 21:57:37',NULL,NULL,NULL,'1160191a-e6ca-451e-8818-e29608b3a552'),
(2825,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'853cdf0a-cf7b-449b-bd96-774731d82a62'),
(2826,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'3a20e533-ab54-412e-a69e-1a235f6ec472'),
(2827,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'6ab8c753-d0ae-4279-b9a6-cb3dda256892'),
(2828,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'d64b9941-05a9-49e0-955f-2646b283f66f'),
(2829,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'e9ae92c4-d6d1-47de-9386-f392617552fd'),
(2830,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'b41f5c54-1e17-4c19-80a5-8b00f74c063d'),
(2831,2,NULL,1626,1,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'2dbaaead-55ae-46cd-b9be-dba4b3f793b2'),
(2832,2825,NULL,1627,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'cd724529-1bf1-4cda-9a89-3d2e3a80c60b'),
(2833,2826,NULL,1628,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'31244ec1-ed25-41c6-b2cb-4b15a8dcc2b8'),
(2834,2827,NULL,1629,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'64cc34f6-a02c-446f-9b55-318ad50fcdb2'),
(2835,2828,NULL,1630,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'664273f1-70f1-4ff8-8adb-93e88db663cf'),
(2836,2829,NULL,1631,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'0bdc7b3b-6c94-43cd-86d0-a3d1f9d58589'),
(2837,2830,NULL,1632,3,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:36','2025-09-23 21:59:36',NULL,NULL,NULL,'8d22cc7b-fcc4-40b9-b839-9a356dc70b59'),
(2839,2,NULL,1633,1,'craft\\elements\\Entry',1,0,'2025-09-23 21:59:58','2025-09-23 21:59:58',NULL,NULL,NULL,'3360ea81-5f28-4884-90f4-189f3291f6f9'),
(2841,2,NULL,1634,1,'craft\\elements\\Entry',1,0,'2025-09-23 22:00:31','2025-09-23 22:00:31',NULL,NULL,NULL,'7545304f-aac6-4d86-9ba7-8b0e5bd29eb8'),
(2843,2,NULL,1635,1,'craft\\elements\\Entry',1,0,'2025-09-23 22:02:08','2025-09-23 22:02:08',NULL,NULL,NULL,'06e6866e-568a-4299-bf1f-e28b529632f5'),
(2847,945,NULL,1636,1,'craft\\elements\\Entry',1,0,'2025-09-24 15:56:07','2025-09-24 15:56:07',NULL,NULL,NULL,'8b61121d-1a0b-4a00-9265-b9717a0bd2b3'),
(2848,1171,NULL,1637,1,'craft\\elements\\Entry',1,0,'2025-09-24 15:56:11','2025-09-24 15:56:11',NULL,NULL,NULL,'842aa2a0-afad-411b-b604-5b4687a01a25'),
(2850,2622,NULL,1638,20,'craft\\elements\\Entry',1,0,'2025-09-24 16:01:26','2025-09-24 16:01:26',NULL,NULL,NULL,'4b6d4640-e6f3-4965-9f7e-f361c808dcf9'),
(2852,1481,NULL,1639,1,'craft\\elements\\Entry',1,0,'2025-09-24 16:04:13','2025-09-24 16:04:13',NULL,NULL,NULL,'e3788412-d844-4d8d-8a35-ccb65973bf87'),
(2853,2,NULL,1640,1,'craft\\elements\\Entry',1,0,'2025-09-24 16:06:15','2025-09-24 16:06:15',NULL,NULL,NULL,'4a19536d-7c33-4f0e-81c2-0352d7365703'),
(2854,945,NULL,1641,1,'craft\\elements\\Entry',1,0,'2025-09-24 16:40:05','2025-09-24 16:40:05',NULL,NULL,NULL,'0704a698-27b6-47ea-901e-77dbffbb45f5'),
(2855,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 17:19:20','2025-09-24 17:19:20',NULL,NULL,NULL,'e39eb379-f3ed-40d5-a676-c15e7b7caf9c'),
(2856,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 17:19:27','2025-09-24 17:19:27',NULL,NULL,NULL,'190a5570-3d3b-4219-b9ba-b279e874db56'),
(2857,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 17:19:28','2025-09-24 17:19:28',NULL,NULL,NULL,'ae1aa4c4-bb08-4885-8929-dffc5bd3fcae'),
(2858,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 17:19:28','2025-09-24 17:19:28',NULL,NULL,NULL,'89de1b06-2658-444f-a947-fc203512607b'),
(2860,2537,NULL,1642,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:19:33','2025-09-24 17:19:33',NULL,NULL,NULL,'222c9f8f-075b-423c-8194-1c4b77f8b142'),
(2862,2535,NULL,1643,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:19:43','2025-09-24 17:19:43',NULL,NULL,NULL,'a09276e7-87d2-43b3-8fad-7b8ed0c4089b'),
(2864,2537,NULL,1644,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:19:53','2025-09-24 17:19:53',NULL,NULL,NULL,'da67dd91-d7e5-4662-a2e8-f6a9cb9952a4'),
(2866,2527,NULL,1645,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:20:14','2025-09-24 17:20:14',NULL,NULL,NULL,'6d5836ee-5ca9-474e-a501-e82f00926ac0'),
(2868,2523,NULL,1646,12,'craft\\elements\\Entry',1,0,'2025-09-24 17:20:23','2025-09-24 17:20:23',NULL,NULL,NULL,'9c454b78-f629-4187-975e-a1e1dce3c6fc'),
(2869,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:43','2025-09-24 18:09:43',NULL,NULL,NULL,'17a750d9-c9cb-4a80-b339-1d7e13b052e4'),
(2870,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:44','2025-09-24 18:09:44',NULL,NULL,NULL,'f4e7c045-25a8-492f-82e5-56ebeac79e40'),
(2871,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:44','2025-09-24 18:09:44',NULL,NULL,NULL,'725ddece-9d08-441e-97b9-a876cc319ef5'),
(2872,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:44','2025-09-24 18:09:44',NULL,NULL,NULL,'afaff2b4-2931-4511-9f19-d3b1712a4d22'),
(2873,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:45','2025-10-08 18:24:25',NULL,NULL,NULL,'b24b5202-8da9-4cba-bb7b-bc3e358aac70'),
(2874,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-24 18:09:45','2025-10-08 18:29:50',NULL,NULL,NULL,'acc48022-aa74-461f-be1f-e060daafaa4c'),
(2876,2531,NULL,1647,12,'craft\\elements\\Entry',0,0,'2025-09-24 18:45:18','2025-09-24 18:45:18',NULL,NULL,NULL,'c6377d46-7e13-42d8-8b21-ada7088b2ec4'),
(2877,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-24 19:41:44','2025-09-24 19:41:44',NULL,NULL,NULL,'1bf9dac5-dfae-41af-95bd-ed3239e532e7'),
(2879,2519,NULL,1648,12,'craft\\elements\\Entry',1,0,'2025-09-24 19:41:47','2025-09-24 19:41:47',NULL,NULL,NULL,'c37699f6-a2af-4a48-8689-05b33b681d15'),
(2880,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-24 23:06:33','2025-10-08 22:35:46',NULL,NULL,NULL,'bef2444f-80b9-482f-bf1a-b25832667146'),
(2881,2880,NULL,1649,1,'craft\\elements\\Entry',1,0,'2025-09-24 23:07:59','2025-09-24 23:07:59',NULL,NULL,NULL,'7abd4bb1-3369-4f94-a5a3-978eaca4ac90'),
(2882,NULL,NULL,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-24 23:08:22','2025-09-24 23:09:19',NULL,NULL,NULL,'11c8dd90-e5a3-4fdd-b8e0-2e7831e8dc3b'),
(2883,2882,NULL,1650,1,'craft\\elements\\Entry',1,0,'2025-09-24 23:09:19','2025-09-24 23:09:19',NULL,NULL,NULL,'c74b1976-2fd7-40e8-b9e8-3ad0e4b02219'),
(2885,1255,NULL,1651,1,'craft\\elements\\Entry',1,0,'2025-09-25 02:15:57','2025-09-25 02:15:57',NULL,NULL,NULL,'7bc7d46f-4151-4012-a966-9e56985d3335'),
(2886,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 14:02:15','2025-09-25 14:02:15',NULL,NULL,NULL,'f7d6ba8f-6ac9-461b-a87c-df38fe080397'),
(2887,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 14:05:38','2025-09-25 14:07:18',NULL,NULL,NULL,'f3ab68b0-c780-49b7-85c6-b270a22a2120'),
(2888,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 14:05:39','2025-09-25 14:07:01',NULL,NULL,NULL,'cbf53f06-3113-4c1b-a3ec-f86d25f82f6d'),
(2889,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 15:18:29','2025-09-25 15:24:16',NULL,NULL,NULL,'2196ef41-7959-416e-834f-3e7f395383ef'),
(2890,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-09-25 15:18:40','2025-09-25 15:24:29',NULL,NULL,NULL,'bf4644ad-09e8-4d62-a5d0-10f77cf961aa'),
(2891,NULL,NULL,NULL,6,'craft\\elements\\Entry',1,0,'2025-09-26 17:59:45','2025-09-29 19:09:02',NULL,NULL,NULL,'091623a3-eae4-4db8-88d6-e973fdd7615a'),
(2892,2891,NULL,1652,6,'craft\\elements\\Entry',1,0,'2025-09-26 17:59:52','2025-09-26 17:59:52',NULL,NULL,NULL,'4749bab5-fdcb-4972-837c-3b9482352428'),
(2894,2,NULL,1653,1,'craft\\elements\\Entry',1,0,'2025-09-26 18:00:58','2025-09-26 18:00:58',NULL,NULL,NULL,'150705cb-79ee-4439-8edf-096636031c71'),
(2896,2,NULL,1654,1,'craft\\elements\\Entry',1,0,'2025-09-26 18:05:11','2025-09-26 18:05:11',NULL,NULL,NULL,'4117f518-2706-44a2-87d4-2a11681a4c4a'),
(2899,1255,NULL,1655,1,'craft\\elements\\Entry',1,0,'2025-09-26 20:17:54','2025-09-26 20:17:54',NULL,NULL,NULL,'bb07685c-bfd8-4f27-9515-87e73935070d'),
(2905,1177,NULL,1656,1,'craft\\elements\\Entry',1,0,'2025-09-29 18:35:28','2025-09-29 18:35:28',NULL,NULL,NULL,'c9551b91-1c37-4a62-9935-bcdb87457390'),
(2907,1177,NULL,1657,1,'craft\\elements\\Entry',1,0,'2025-09-29 18:35:55','2025-09-29 18:35:55',NULL,NULL,NULL,'3f75ab05-805a-4abe-85f9-4a34dea3282e'),
(2908,2,NULL,1658,1,'craft\\elements\\Entry',1,0,'2025-09-29 18:58:54','2025-09-29 18:58:54',NULL,NULL,NULL,'0d0f2ff1-94f7-47fa-8745-cae920c54f12'),
(2909,1395,NULL,1659,1,'craft\\elements\\Entry',1,0,'2025-09-29 18:59:03','2025-09-29 18:59:03',NULL,NULL,NULL,'65f9351d-3861-4e4e-b8c4-0ba7bcd27cf2'),
(2910,111,NULL,1660,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'c650617a-b594-4e54-bb13-14156916f521'),
(2911,113,NULL,1661,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'8ff0adae-1d66-407c-b2d4-507013201ea6'),
(2912,115,NULL,1662,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'3c8788ed-8351-455c-8912-af7f8be15220'),
(2913,117,NULL,1663,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'3c5a81c9-23fb-47bd-a420-bf380ae636c1'),
(2914,119,NULL,1664,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'f0c843a5-4350-4870-8d2e-93e13170963b'),
(2915,121,NULL,1665,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'6e4d414d-af0d-4fef-8cc7-cb0f260209d4'),
(2916,555,NULL,1666,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'f734afe7-0719-4f17-9efd-5497f899accc'),
(2917,557,NULL,1667,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'e4fa05cf-72d2-4bcf-bfcc-b1acc0e5b588'),
(2918,559,NULL,1668,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'55a9d344-dde2-4d75-adb3-59c6074b104e'),
(2919,561,NULL,1669,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'01ebb8b5-bf52-4108-a1bd-8fe21e7f1855'),
(2920,563,NULL,1670,11,'craft\\elements\\Entry',0,0,'2025-09-29 18:59:42','2025-09-29 18:59:42',NULL,NULL,NULL,'705b0518-0d58-4f65-8a29-0a6c118a99cb'),
(2923,1289,628,NULL,1,'craft\\elements\\Entry',1,0,'2025-09-29 19:07:48','2025-09-29 19:07:48',NULL,NULL,NULL,'ba67bc1b-f872-475c-ade4-fb9b77c06d46'),
(2925,2891,NULL,1671,6,'craft\\elements\\Entry',1,0,'2025-09-29 19:09:02','2025-09-29 19:09:02',NULL,NULL,NULL,'bbc19e60-bda0-4ab7-85c4-2d59f464dc1c'),
(2927,NULL,NULL,NULL,13,'craft\\elements\\Asset',1,0,'2025-09-30 19:28:01','2025-09-30 19:28:01',NULL,NULL,NULL,'09d388c7-0016-4619-997e-07c4fe87c800'),
(2929,2531,NULL,1672,12,'craft\\elements\\Entry',1,0,'2025-09-30 19:28:07','2025-09-30 19:28:07',NULL,NULL,NULL,'57b7f73d-8020-4985-9b65-0c3a40be891b'),
(2931,NULL,NULL,NULL,9,'craft\\elements\\Asset',1,0,'2025-09-30 22:22:11','2025-09-30 22:22:11',NULL,NULL,NULL,'d53e1dc0-a6fa-4ec6-b669-5a46d86a0c1f'),
(2933,NULL,NULL,NULL,9,'craft\\elements\\Asset',1,0,'2025-09-30 22:22:21','2025-09-30 22:22:21',NULL,NULL,NULL,'bbe1e0e2-b667-4e3b-be36-6e2bd1c32344'),
(2934,NULL,NULL,NULL,9,'craft\\elements\\Asset',1,0,'2025-09-30 22:22:35','2025-09-30 22:22:35',NULL,NULL,NULL,'7fda0972-eaa2-42f3-925e-2a9c367210b7'),
(2938,2,NULL,1673,1,'craft\\elements\\Entry',1,0,'2025-09-30 22:41:39','2025-09-30 22:41:39',NULL,NULL,NULL,'ddad6dd5-c5c8-4f75-8e26-bbb0ae786794'),
(2939,2791,NULL,1674,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:41:39','2025-09-30 22:41:39',NULL,NULL,NULL,'18e7b730-40a0-4fc8-ba3f-046afa3e7dcd'),
(2941,NULL,NULL,NULL,9,'craft\\elements\\Asset',1,0,'2025-09-30 22:43:05','2025-09-30 22:43:05',NULL,NULL,NULL,'cce62c0f-586e-43e7-8f0b-34dfec5796b5'),
(2945,NULL,NULL,NULL,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:18','2025-09-30 22:45:57',NULL,NULL,NULL,'f15f8b74-c868-460c-9e9d-dedc7a1b36f5'),
(2946,2,NULL,1675,1,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:18','2025-09-30 22:45:18',NULL,NULL,NULL,'f079aa0c-7131-43f7-a4fc-e520537806a7'),
(2947,2793,NULL,1676,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:18','2025-09-30 22:45:18',NULL,NULL,NULL,'dbab52c4-438b-4346-ba52-f1468cd206e1'),
(2948,2945,NULL,1677,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:18','2025-09-30 22:45:18',NULL,NULL,NULL,'e80b7480-2708-4d64-a239-5861e125a7c5'),
(2951,2,NULL,1678,1,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:57','2025-09-30 22:45:57',NULL,NULL,NULL,'d8a85eda-1c40-41ce-b7b3-b85805b4382b'),
(2952,2945,NULL,1679,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:45:57','2025-09-30 22:45:57',NULL,NULL,NULL,'940b2d3c-d38a-4a39-a33e-bb7e3b4f024e'),
(2955,2,NULL,1680,1,'craft\\elements\\Entry',1,0,'2025-09-30 22:46:11','2025-09-30 22:46:11',NULL,NULL,NULL,'f2a7b376-7741-4819-8105-22f757c51677'),
(2956,2793,NULL,1681,21,'craft\\elements\\Entry',1,0,'2025-09-30 22:46:11','2025-09-30 22:46:11',NULL,NULL,NULL,'8753d74d-0fe8-4bcf-9d92-5af949f3572f'),
(2957,1437,645,NULL,1,'craft\\elements\\Entry',1,0,'2025-10-02 19:26:41','2025-10-02 19:26:42',NULL,NULL,NULL,'89a0d051-db24-46b2-9951-d0c8b65e67d8'),
(2959,601,NULL,1682,5,'craft\\elements\\Entry',1,0,'2025-10-03 20:24:31','2025-10-03 20:24:31',NULL,NULL,NULL,'e7687068-e69a-4297-b2e5-fcb902e1c687'),
(2961,605,NULL,1683,5,'craft\\elements\\Entry',1,0,'2025-10-03 20:24:40','2025-10-03 20:24:40',NULL,NULL,NULL,'1901a062-005c-4ef8-a664-4a22001fe540'),
(2963,617,NULL,1684,5,'craft\\elements\\Entry',1,0,'2025-10-03 20:24:49','2025-10-03 20:24:49',NULL,NULL,NULL,'36142205-ddda-4d6f-9181-a7244c956373'),
(2965,1045,NULL,1685,1,'craft\\elements\\Entry',1,0,'2025-10-06 16:09:49','2025-10-06 16:09:49',NULL,NULL,NULL,'0d01d621-5e7c-4d0e-8fc5-d8e9fb5fa3bf'),
(2966,2712,NULL,1686,1,'craft\\elements\\Entry',1,0,'2025-10-06 16:09:59','2025-10-06 16:09:59',NULL,NULL,NULL,'f2f3b5ca-4b08-4fbd-8663-5e0200c78aa2'),
(2968,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-06 17:44:48','2025-10-06 17:45:01',NULL,NULL,NULL,'1e415e16-5d61-4b38-b4ca-eea293fa5718'),
(2969,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:45:32','2025-10-06 17:47:25',NULL,NULL,NULL,'7bd0e66d-ba6f-462c-b940-8a507312e64c'),
(2970,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-06 17:45:59','2025-10-08 18:24:15',NULL,NULL,NULL,'244b1cd5-9af2-47b0-8d0f-cbee1fa1da55'),
(2971,2969,NULL,1687,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:46:02','2025-10-06 17:46:02',NULL,NULL,NULL,'ac8cf22c-9eaf-4340-8e01-73f04dd1d98c'),
(2972,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:46:14','2025-10-08 18:21:43',NULL,NULL,NULL,'9852d22d-7977-41ef-b9e5-8434fd943927'),
(2973,2972,NULL,1688,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:46:44','2025-10-06 17:46:44',NULL,NULL,NULL,'94f173b2-a178-496a-a9cd-78f2d7103b55'),
(2974,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:46:46','2025-10-06 17:47:42',NULL,NULL,NULL,'f1a45e0b-97f6-484c-aaf9-862a950df77c'),
(2975,2974,NULL,1689,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:47:00','2025-10-06 17:47:00',NULL,NULL,NULL,'46992ec8-dc68-47f1-a296-3da03000f308'),
(2976,2969,NULL,1690,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:47:25','2025-10-06 17:47:25',NULL,NULL,NULL,'e7819822-f028-4ebe-a821-66f59652192f'),
(2977,2974,NULL,1691,5,'craft\\elements\\Entry',1,0,'2025-10-06 17:47:42','2025-10-06 17:47:42',NULL,NULL,NULL,'88b5c63d-67e7-402f-b5aa-89de02497f86'),
(2983,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'dff524c0-f322-4745-a9c9-f3b1a7a4588d'),
(2984,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'2ebdb9f4-1f94-4e6c-a05b-10cb3360ed12'),
(2985,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'00ae0086-f18d-4c0b-9118-866e6ecc58c6'),
(2986,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'26553af5-fbad-4e27-bbc0-8e13aaae314e'),
(2987,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'b9d159c2-3e0f-4ef5-8399-7071afa15be8'),
(2988,945,NULL,1692,1,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'1492e223-e36b-4823-9c76-ec2d9ce8b232'),
(2989,2983,NULL,1693,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'d78404f0-6e13-4842-a760-a268ccc6ae9c'),
(2990,2984,NULL,1694,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'b744fdd6-07ef-4759-bfab-43a08b1eba16'),
(2991,2985,NULL,1695,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'7c45e2a2-eceb-48b8-88bf-090da2be04cc'),
(2992,2986,NULL,1696,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'19b60af6-db6e-46bc-8b9c-e30b283da145'),
(2993,2987,NULL,1697,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:00','2025-10-06 17:50:00',NULL,NULL,NULL,'dd01058a-36b5-4bee-bd58-7fd825444905'),
(2995,945,NULL,1698,1,'craft\\elements\\Entry',1,0,'2025-10-06 17:50:49','2025-10-06 17:50:49',NULL,NULL,NULL,'f80dad38-a3d9-4ef1-8767-f4692e8f8a3e'),
(2999,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'55ab1db7-1e58-4e8a-a3bc-386a040bbcef'),
(3000,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'dd4bd306-e50b-40d3-8e5c-5322170d20f1'),
(3001,945,NULL,1699,1,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'bb2ef1ca-b53e-4a8f-b034-f075201f6237'),
(3002,2999,NULL,1700,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'30e97202-0552-4122-bc2a-fac3d13d209b'),
(3003,3000,NULL,1701,3,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:32','2025-10-06 17:51:32',NULL,NULL,NULL,'87a8c7fe-59b7-4473-b14a-5092baeb90dd'),
(3005,NULL,664,NULL,21,'craft\\elements\\Entry',1,0,'2025-10-06 17:51:50','2025-10-06 17:51:50',NULL,NULL,NULL,'62f4ca57-c861-4beb-848f-8063faa17160'),
(3006,945,NULL,1702,1,'craft\\elements\\Entry',1,0,'2025-10-06 17:52:05','2025-10-06 17:52:05',NULL,NULL,NULL,'ac03093c-3750-4e39-a3d5-d0cb9f9a7859'),
(3009,957,NULL,1703,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:17:50','2025-10-08 18:17:50',NULL,NULL,NULL,'c20e5e52-00cf-4069-a1d3-149780a4fc3f'),
(3011,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 18:19:10','2025-10-08 18:19:10',NULL,NULL,NULL,'dc5c17f6-765e-48b3-85a8-55202a0faf0b'),
(3012,NULL,668,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:19:48','2025-10-08 18:19:48',NULL,NULL,NULL,'8aedb629-6fc8-471f-b6b1-c45c3808c572'),
(3014,2972,NULL,1704,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:21:43','2025-10-08 18:21:43',NULL,NULL,NULL,'f03c5430-813f-45f9-9bca-5aeb0f5c34bd'),
(3015,NULL,670,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:21:49','2025-10-08 18:21:49',NULL,NULL,NULL,'572fde05-b998-4a02-99e9-2f602364ea50'),
(3016,NULL,671,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:22:14','2025-10-08 18:22:24',NULL,NULL,NULL,'180780b3-2a96-4030-a27b-6e5392364481'),
(3017,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:26:16','2025-10-08 18:26:30',NULL,NULL,NULL,'13b67eac-63bd-408e-9f79-f0cf8847bc4b'),
(3018,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:26:55','2025-10-08 18:27:05',NULL,NULL,NULL,'c9a18e0b-fd23-4af0-8cc5-01e1b23e5954'),
(3019,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:28:08','2025-10-08 18:28:18',NULL,NULL,NULL,'24fb6028-a4fb-41b6-b9b9-8b60c849bba5'),
(3020,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:29:13','2025-10-08 18:30:02',NULL,NULL,NULL,'c7aaea27-9af3-4730-85a4-0bb39f7b4afa'),
(3021,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:30:50','2025-10-08 18:31:22',NULL,NULL,NULL,'5f8fe953-5abe-416d-a8da-0525c95105cd'),
(3022,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:31:41','2025-10-08 18:32:14',NULL,NULL,NULL,'8574977d-e956-4be2-8186-3a286b884e33'),
(3023,NULL,NULL,NULL,17,'craft\\elements\\Asset',1,0,'2025-10-08 18:32:26','2025-10-08 18:32:47',NULL,NULL,NULL,'fc3421f8-4272-4d92-b724-eb867dbe405e'),
(3024,NULL,672,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:33:21','2025-10-08 18:33:21',NULL,NULL,NULL,'303eb696-94bd-4b23-b924-0caa70cf802b'),
(3025,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:34:47','2025-10-08 18:35:41',NULL,NULL,NULL,'195a0190-3c42-41ca-8040-a184e12e6ee4'),
(3026,3025,NULL,1705,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:35:41','2025-10-08 18:35:41',NULL,NULL,NULL,'5e21e4d4-d6dd-4493-a82e-2b438a591bad'),
(3027,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:35:57','2025-10-08 18:36:16',NULL,NULL,NULL,'a736b85e-4e04-40a9-94dc-c1cb48631e31'),
(3028,3027,NULL,1706,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:36:16','2025-10-08 18:36:16',NULL,NULL,NULL,'0cbea65c-66d1-4a48-9c8d-b6a33060b865'),
(3029,957,NULL,1707,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:36:38','2025-10-08 18:36:38',NULL,NULL,NULL,'24d1296e-21a5-40d5-8f8c-330bedf30467'),
(3036,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'8f123bf6-963c-448e-aed5-60d1334d9ccb'),
(3037,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'67491fc8-76c6-4a66-9c71-d5f44b50bab5'),
(3038,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'5ba542a2-ede0-43ca-8441-fef9aee3afea'),
(3039,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'4a14c1e3-6853-4034-8db5-394a882839ce'),
(3040,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'3cad777e-f3f6-4f1f-bc3b-d066f73de1df'),
(3041,957,NULL,1708,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'6bbf1680-c1e8-439b-b920-cf523ab91027'),
(3042,3036,NULL,1709,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'2e9ad6d6-f5e1-4ca8-9ddd-5b39dfab7c24'),
(3043,3037,NULL,1710,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'c7af399a-8d39-4bbc-ad83-5e85731cfca4'),
(3044,3038,NULL,1711,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'16e1ff19-1d0a-4427-8f65-1c452774cd6d'),
(3045,3039,NULL,1712,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'b80e5a21-7a15-42e5-a7ec-341b23efd69f'),
(3046,3040,NULL,1713,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:39:34','2025-10-08 18:39:34',NULL,NULL,NULL,'d28b2edb-8ca3-4906-bb56-43b2c0cead06'),
(3048,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 18:42:24','2025-10-08 18:42:24',NULL,NULL,NULL,'56a1fb3c-8b4d-4327-a5e6-511911c4a0ca'),
(3051,957,NULL,1714,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:43:12','2025-10-08 18:43:12',NULL,NULL,NULL,'f29e2170-5dda-4b5e-8959-38478e2c0f95'),
(3052,1504,NULL,1715,2,'craft\\elements\\Entry',1,0,'2025-10-08 18:43:12','2025-10-08 18:43:12',NULL,NULL,NULL,'35df403f-543c-4c6b-8c85-8f39d3dad9cb'),
(3053,1505,NULL,1716,2,'craft\\elements\\Entry',1,0,'2025-10-08 18:43:12','2025-10-08 18:43:12',NULL,NULL,NULL,'5fcd11d2-8b9f-463a-895a-6399cdbf6c7a'),
(3055,957,NULL,1717,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:43:42','2025-10-08 18:43:42',NULL,NULL,NULL,'503f8b07-4773-43b6-a2be-e40c28829ec5'),
(3058,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 18:44:46','2025-10-08 18:44:46',NULL,NULL,NULL,'054301c8-faa7-4c0f-a0d8-34aa2934601b'),
(3059,963,NULL,1718,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:46:53','2025-10-08 18:46:53',NULL,NULL,NULL,'9b0e7323-6207-40ae-a84e-b33acc52a043'),
(3066,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'b43aabfd-e6e5-4afe-892a-ec662230bf96'),
(3067,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'1172871b-3e60-4daa-b4b0-9158465c8bf0'),
(3068,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'bd49a00d-87bf-452c-963a-5a76a777c7fa'),
(3069,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'b67311d5-3f55-49b1-9aee-af4bf1cfc1dc'),
(3070,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'2cdf0ee4-1d10-4fd9-ad1a-7868205cc2dd'),
(3071,963,NULL,1719,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'0f830da5-13ec-4510-bd46-1d43b29c49ad'),
(3072,3066,NULL,1720,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'aacc9f96-b49f-4f94-8feb-6b8ca9b9e6e7'),
(3073,3067,NULL,1721,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'3a6b6d70-4f17-4cb1-98ec-26c233367544'),
(3074,3068,NULL,1722,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'c38d949b-8425-4112-9386-3b1c0a0a8bea'),
(3075,3069,NULL,1723,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'7763659b-af9b-4bba-86dc-ae4a23c5fe77'),
(3076,3070,NULL,1724,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:48:30','2025-10-08 18:48:30',NULL,NULL,NULL,'423df36c-6bec-48fa-a836-16ffdf6ab642'),
(3079,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:50:11','2025-10-08 18:50:11',NULL,NULL,NULL,'e1707b8c-e2eb-48f3-8374-c8cee50bf48b'),
(3080,963,NULL,1725,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:50:11','2025-10-08 18:50:11',NULL,NULL,NULL,'e1d5b1c0-df0e-46b6-93ac-c07b26796b1c'),
(3081,3079,NULL,1726,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:50:11','2025-10-08 18:50:11',NULL,NULL,NULL,'83151760-cf8b-495e-95d3-3b8ff0495a48'),
(3084,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 18:51:15','2025-10-08 18:51:29',NULL,NULL,NULL,'f9f86cbf-1eac-4ad0-b1b8-0c15e781282e'),
(3086,963,NULL,1727,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:52:55','2025-10-08 18:52:55',NULL,NULL,NULL,'beb5010d-47de-4e80-a0d6-ae4a8c284add'),
(3087,1509,NULL,1728,2,'craft\\elements\\Entry',1,0,'2025-10-08 18:52:55','2025-10-08 18:52:55',NULL,NULL,NULL,'e2b692bc-4bd5-48dc-b3c4-6cbaf69672c0'),
(3088,1510,NULL,1729,2,'craft\\elements\\Entry',1,0,'2025-10-08 18:52:55','2025-10-08 18:52:55',NULL,NULL,NULL,'ad119916-cade-4058-b3ce-0656f73664c7'),
(3090,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 18:53:49','2025-10-08 18:54:27',NULL,NULL,NULL,'232474b4-5e67-49ff-ad01-79e918687e9e'),
(3091,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:54:51','2025-10-08 18:55:24',NULL,NULL,NULL,'019e342e-cde0-4f5c-b2ce-50ffb09049eb'),
(3092,3091,NULL,1730,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:55:24','2025-10-08 18:55:24',NULL,NULL,NULL,'0a1427e4-62d4-4a32-8ee4-56a273508e21'),
(3093,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:55:36','2025-10-08 18:55:51',NULL,NULL,NULL,'d528be92-2b52-489a-8b53-7106c43b0536'),
(3094,3093,NULL,1731,5,'craft\\elements\\Entry',1,0,'2025-10-08 18:55:51','2025-10-08 18:55:51',NULL,NULL,NULL,'f3f5f0b0-849c-442b-8b52-cd6de2b6af71'),
(3095,969,NULL,1732,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:56:08','2025-10-08 18:56:08',NULL,NULL,NULL,'be26992b-bedf-4f4f-864e-a98a3f00e202'),
(3102,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'21bda4c0-d863-48a2-abe5-26c081922e37'),
(3103,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'76995242-ad43-4bb7-8a3a-8da9ac50cff7'),
(3104,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'a7a33caf-632e-45a9-a668-26a09c3014b8'),
(3105,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'1f4362e1-f513-4665-b739-fb32290f369c'),
(3106,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'709eb709-f9f1-4b1b-90ec-dab090c098f2'),
(3107,969,NULL,1733,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'6a3a98db-d84e-4d72-8d01-caec80c4de80'),
(3108,3102,NULL,1734,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'0fc8cae8-f860-41af-a02a-75f8e31f310e'),
(3109,3103,NULL,1735,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'c410006b-7e18-4705-bc2a-8ec99da92639'),
(3110,3104,NULL,1736,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'3617ee59-b774-4f71-b7e1-9dd7ac0f9ba2'),
(3111,3105,NULL,1737,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'80f82d97-6bf7-459b-9d5d-f38ee04dae3c'),
(3112,3106,NULL,1738,3,'craft\\elements\\Entry',1,0,'2025-10-08 18:57:34','2025-10-08 18:57:34',NULL,NULL,NULL,'d01acf0d-ee03-4c40-a561-f2285c001b37'),
(3114,969,NULL,1739,1,'craft\\elements\\Entry',1,0,'2025-10-08 18:59:33','2025-10-08 18:59:33',NULL,NULL,NULL,'4505dfc3-6dbc-490e-9423-01eb64fdd2b2'),
(3118,969,NULL,1740,1,'craft\\elements\\Entry',1,0,'2025-10-08 19:00:47','2025-10-08 19:00:47',NULL,NULL,NULL,'629d38f3-0c11-4e07-ba26-b21476a62a68'),
(3119,1514,NULL,1741,2,'craft\\elements\\Entry',1,0,'2025-10-08 19:00:47','2025-10-08 19:00:47',NULL,NULL,NULL,'e818e493-afdb-48bd-bd1d-665393b576e8'),
(3120,1515,NULL,1742,2,'craft\\elements\\Entry',1,0,'2025-10-08 19:00:47','2025-10-08 19:00:47',NULL,NULL,NULL,'3bab0044-19a5-4343-8e69-48f89213b1d0'),
(3122,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 19:52:53','2025-10-08 19:52:53',NULL,NULL,NULL,'af87fd51-f341-4428-ac78-492fdb8c02c3'),
(3123,NULL,NULL,NULL,5,'craft\\elements\\Entry',1,0,'2025-10-08 19:54:05','2025-10-08 19:54:15',NULL,NULL,NULL,'8f44127f-8524-4436-8a28-f1ac404fe254'),
(3124,3123,NULL,1743,5,'craft\\elements\\Entry',1,0,'2025-10-08 19:54:15','2025-10-08 19:54:15',NULL,NULL,NULL,'9dc88c62-70a3-43f3-b500-2b7bd82ab5db'),
(3125,975,NULL,1744,1,'craft\\elements\\Entry',1,0,'2025-10-08 19:54:49','2025-10-08 19:54:50',NULL,NULL,NULL,'830a7f17-8a35-4d63-a22c-942530733649'),
(3137,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 19:59:08','2025-10-08 19:59:08',NULL,NULL,NULL,'4ccceeae-e63e-45b0-8e79-e7c1920d31d3'),
(3138,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'059d822b-724e-4fcb-bc8d-7cd1fac7f86c'),
(3139,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'4a4ee3ac-31d1-47b5-8715-6ab4043d92e1'),
(3140,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'2810da40-ce95-4714-8200-76b5c0e4eede'),
(3141,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'7263269e-6321-4733-9d51-0677c821a91b'),
(3142,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'c3a826ba-826c-4dd6-a935-5841c40dd622'),
(3143,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'362500c9-bdf4-44a4-97a0-42826aded357'),
(3144,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'f114560b-6a15-4011-9841-8d43a9487a16'),
(3145,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'d7e50521-a96e-496a-a3b3-1d2c7ec9a4ef'),
(3146,975,NULL,1745,1,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'b0198c8f-b922-4014-b82c-2e61dd55659a'),
(3147,3138,NULL,1746,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'8421bd29-7ff6-436f-8f96-708fb36cae2d'),
(3148,3139,NULL,1747,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'880d66c3-15aa-4e43-bf1a-7eed1143eb86'),
(3149,3140,NULL,1748,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'15584359-b7df-4a67-9631-c7423eb7e1dd'),
(3150,3141,NULL,1749,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'31390b18-ac5d-400e-bbf8-5f5cd2e49593'),
(3151,3142,NULL,1750,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'84763762-27a3-4086-89da-a9cd825265ed'),
(3152,3143,NULL,1751,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'3bf2a799-08a3-4f11-aec7-e101d5749221'),
(3153,3144,NULL,1752,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'c06d50ef-9902-405b-b5de-ba80371aa240'),
(3154,3145,NULL,1753,3,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'0092bbb1-79d0-4298-aea9-0f3e3c6bcee0'),
(3155,1519,NULL,1754,2,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'e941ebf3-6905-4ba1-b1ab-f5ed79003139'),
(3156,1520,NULL,1755,2,'craft\\elements\\Entry',1,0,'2025-10-08 19:59:16','2025-10-08 19:59:16',NULL,NULL,NULL,'2c914bdc-4a7b-4fd2-b110-08716b2af8b5'),
(3158,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 20:21:30','2025-10-08 20:22:26',NULL,NULL,NULL,'83b7d259-d0a6-4d99-9467-7abb85c36e23'),
(3159,981,NULL,1756,1,'craft\\elements\\Entry',1,0,'2025-10-08 20:22:53','2025-10-08 20:22:54',NULL,NULL,NULL,'bbf24774-8c10-43e6-9ee2-5d6fb8dcdee6'),
(3166,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'d34a4ef4-e951-41e0-9fb2-f4fbc873209e'),
(3167,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'87fdc99f-8de3-424a-b23b-a74240ea791a'),
(3168,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'abd946e5-2322-4f04-8ea9-b698d3ee5fe3'),
(3169,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'0ae280fb-3cb2-4f8c-8784-15b4465073a9'),
(3170,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'3e7195c7-e715-420c-842f-27fadf0cb033'),
(3171,981,NULL,1757,1,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'dea4d9dd-1b96-4a42-ab36-87998774d0d0'),
(3172,3166,NULL,1758,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'ba7cb77c-c80a-4a7b-8af7-e901ba51d019'),
(3173,3167,NULL,1759,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'8309ecbe-aa76-4b2b-af6d-f8585fc3da26'),
(3174,3168,NULL,1760,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'675e44df-d694-4d1b-b233-3309b32dd204'),
(3175,3169,NULL,1761,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'70d6cd9c-6db3-48f0-bcc1-de7521f44642'),
(3176,3170,NULL,1762,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:24:41','2025-10-08 20:24:41',NULL,NULL,NULL,'7d145633-87dc-4c7a-a107-7286d02ee50b'),
(3180,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 20:25:38','2025-10-08 20:25:38',NULL,NULL,NULL,'c68a7f61-7a3e-45ed-9bc2-3bd8c1f90fcf'),
(3182,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:58','2025-10-08 20:25:58',NULL,NULL,NULL,'6831c17a-4ed4-47be-a357-2d24c2601d49'),
(3183,981,NULL,1763,1,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:57','2025-10-08 20:25:58',NULL,NULL,NULL,'85386aa8-e38c-4514-be7d-0db0739049df'),
(3184,3182,NULL,1764,3,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:58','2025-10-08 20:25:58',NULL,NULL,NULL,'6cfe6525-108f-48d0-9a9b-cce2039e6cdc'),
(3185,1525,NULL,1765,2,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:58','2025-10-08 20:25:58',NULL,NULL,NULL,'bf934570-09ee-42f4-8fd7-fd6ac64c5f84'),
(3186,1526,NULL,1766,2,'craft\\elements\\Entry',1,0,'2025-10-08 20:25:58','2025-10-08 20:25:58',NULL,NULL,NULL,'787aa8e9-d8bf-4aae-8d66-799555c5d52d'),
(3188,981,NULL,1767,1,'craft\\elements\\Entry',1,0,'2025-10-08 20:26:01','2025-10-08 20:26:01',NULL,NULL,NULL,'5e8d679a-823e-454c-8b16-a5e31d9015c3'),
(3189,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Form',1,0,'2025-10-08 22:17:51','2025-10-08 22:17:51',NULL,NULL,NULL,'fe2e5e5e-abbd-4561-a3ba-37026f922a57'),
(3190,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Form',1,0,'2025-10-08 22:17:57','2025-10-08 22:17:57',NULL,NULL,NULL,'a86c2379-7dd0-4176-b497-17774e589315'),
(3191,NULL,NULL,NULL,NULL,'verbb\\formie\\elements\\Form',1,0,'2025-10-08 22:18:05','2025-10-08 22:18:05',NULL,NULL,NULL,'0eb29f3f-cbde-4407-be4f-b02acee98449'),
(3192,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:49','2025-10-08 22:18:56',NULL,NULL,NULL,'fdcf5c6f-b728-447f-8c82-fbb551b5226e'),
(3193,3192,NULL,1768,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:56','2025-10-08 22:18:56',NULL,NULL,NULL,'cb42d871-81de-45fc-b52b-366d6efc1a2f'),
(3194,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:56','2025-10-08 22:18:59',NULL,NULL,NULL,'7f438e6a-e1fa-4e24-a2e9-1648ba399aa6'),
(3195,3194,NULL,1769,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:59','2025-10-08 22:18:59',NULL,NULL,NULL,'5c0344c3-000b-4c15-a977-80d3684def8a'),
(3196,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:18:59','2025-10-08 22:19:01',NULL,NULL,NULL,'742c6231-be5b-4f77-90a7-29083f2c688e'),
(3197,3196,NULL,1770,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:01','2025-10-08 22:19:01',NULL,NULL,NULL,'bc745dd8-db76-458d-83f9-102dbf55ff21'),
(3198,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:01','2025-10-08 22:19:04',NULL,NULL,NULL,'62fa409a-ca19-4c74-abe3-38b7808d8d7a'),
(3199,3198,NULL,1771,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:04','2025-10-08 22:19:04',NULL,NULL,NULL,'3fd9cb80-d945-4673-97b4-2752ad48de06'),
(3200,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:04','2025-10-08 22:19:06',NULL,NULL,NULL,'c1356cab-a204-400c-b6ed-106236a55ace'),
(3201,3200,NULL,1772,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:06','2025-10-08 22:19:06',NULL,NULL,NULL,'f1f30280-8da4-45d1-93ad-b1bf87fc1a99'),
(3202,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:06','2025-10-08 22:19:10',NULL,NULL,NULL,'14c7ade6-f49b-47cd-adb2-9ed996427e7b'),
(3203,3202,NULL,1773,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:10','2025-10-08 22:19:10',NULL,NULL,NULL,'23f72963-e31d-4c68-9d75-c88b1eba4ef1'),
(3204,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:10','2025-10-08 22:19:13',NULL,NULL,NULL,'5fe38de9-ef00-4a60-9edb-199aba2abeb0'),
(3205,3204,NULL,1774,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:13','2025-10-08 22:19:13',NULL,NULL,NULL,'457314c2-9b4a-48fc-b2ee-58acf9211588'),
(3206,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:13','2025-10-08 22:19:15',NULL,NULL,NULL,'21831c2c-63e7-4c73-8d71-b4382d343ec1'),
(3207,3206,NULL,1775,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:15','2025-10-08 22:19:15',NULL,NULL,NULL,'671b7251-dc16-4097-b83c-9180d0e36bc7'),
(3208,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:15','2025-10-08 22:19:18',NULL,NULL,NULL,'267ab4a4-242c-4556-adb9-da28988d3814'),
(3209,3208,NULL,1776,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:18','2025-10-08 22:19:18',NULL,NULL,NULL,'dfb00755-2955-4c8e-ad3a-bd157298da31'),
(3210,NULL,NULL,NULL,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:18','2025-10-08 22:19:21',NULL,NULL,NULL,'70a9acfe-dd17-46ba-a43c-181ef4e6f3eb'),
(3211,3210,NULL,1777,23,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:21','2025-10-08 22:19:21',NULL,NULL,NULL,'48dbcb6a-94b7-41d3-94e0-46747c6ed15d'),
(3212,945,NULL,1778,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:19:59','2025-10-08 22:19:59',NULL,NULL,NULL,'a39dd38b-4c13-4b7c-abea-a9c5fe7b968b'),
(3213,1255,NULL,1779,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:05','2025-10-08 22:20:05',NULL,NULL,NULL,'4b1aa3be-d0d8-416f-8609-420070e42fd8'),
(3214,2,NULL,1780,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:09','2025-10-08 22:20:09',NULL,NULL,NULL,'80636f1b-7665-4338-b68a-ec4787e8b947'),
(3216,2,NULL,1781,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:12','2025-10-08 22:20:12',NULL,NULL,NULL,'f86e3dc2-543a-4c52-b5aa-e3327f08f7ef'),
(3217,1165,NULL,1782,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:15','2025-10-08 22:20:15',NULL,NULL,NULL,'47659f3a-d549-4f3b-9a63-9108d9807044'),
(3218,957,NULL,1783,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:19','2025-10-08 22:20:19',NULL,NULL,NULL,'62d4ca5a-ce2c-4855-856b-11bad1d37709'),
(3219,2720,NULL,1784,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:20:23','2025-10-08 22:20:23',NULL,NULL,NULL,'132a0129-be0e-4488-9bc9-8637e1c22948'),
(3221,NULL,NULL,NULL,10,'craft\\elements\\Asset',1,0,'2025-10-08 22:21:38','2025-10-08 22:21:38',NULL,NULL,NULL,'bdc16f15-f46f-4437-8456-4f61d3a02e89'),
(3223,951,NULL,1785,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:21:46','2025-10-08 22:21:46',NULL,NULL,NULL,'d79aa478-10ab-42d4-9220-d3d3683b044e'),
(3224,1499,NULL,1786,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:21:46','2025-10-08 22:21:46',NULL,NULL,NULL,'8929c7c6-6dea-4018-8d44-290bb8663880'),
(3235,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:24:18','2025-10-08 22:24:18',NULL,NULL,NULL,'627b2b6b-1518-430e-998b-bf5c8934774e'),
(3236,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:24:35','2025-10-08 22:24:35',NULL,NULL,NULL,'b5404ca1-c473-44f8-a42f-4eddf48b474c'),
(3237,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:24:46','2025-10-08 22:24:46',NULL,NULL,NULL,'9bd95623-c874-426e-afde-5af3089ba860'),
(3238,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:24:57','2025-10-08 22:24:57',NULL,NULL,NULL,'560a5bc7-8092-43fb-92dc-2a33924dce10'),
(3239,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:07','2025-10-08 22:25:07',NULL,NULL,NULL,'c322f018-7d22-4eb0-b96b-1e4f4c964427'),
(3240,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:18','2025-10-08 22:25:18',NULL,NULL,NULL,'1a74ea73-9636-466d-8569-5f588f575f87'),
(3241,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:29','2025-10-08 22:25:29',NULL,NULL,NULL,'95dfc41f-cf70-4f09-9316-e6f5e0450622'),
(3242,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:38','2025-10-08 22:25:38',NULL,NULL,NULL,'6de533ef-4635-4f28-b60d-49fcc57c4a3d'),
(3243,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:45','2025-10-08 22:25:45',NULL,NULL,NULL,'21d30ca9-2dc4-4472-a21a-e52d0e486570'),
(3244,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:25:47','2025-10-08 22:25:47',NULL,NULL,NULL,'22d78448-056c-46a4-a7ca-839f4fd4d268'),
(3245,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:37','2025-10-08 22:28:37',NULL,NULL,NULL,'9733e01e-92e1-409e-a13c-25f7a5b85d16'),
(3246,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:39','2025-10-08 22:28:39',NULL,NULL,NULL,'71a8753e-1f70-4071-8e74-fd3ed12702ca'),
(3247,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:40','2025-10-08 22:28:40',NULL,NULL,NULL,'fa897fc0-44eb-45bf-93d4-c784a7e678d0'),
(3248,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:40','2025-10-08 22:28:40',NULL,NULL,NULL,'4a1dcc5f-11a4-497c-a7b9-1fe32fd4b2e3'),
(3249,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:41','2025-10-08 22:28:41',NULL,NULL,NULL,'73ea64cc-e552-4ff7-a7aa-f043ac594c5e'),
(3250,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:42','2025-10-08 22:28:42',NULL,NULL,NULL,'6c862239-0290-449b-8c2e-e15b87bb2df6'),
(3251,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:43','2025-10-08 22:28:43',NULL,NULL,NULL,'4a00740d-2bfd-4662-a6f9-cb5f4348fced'),
(3252,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:43','2025-10-08 22:28:43',NULL,NULL,NULL,'241cfdf9-ee01-4999-8ccc-1201776b31ee'),
(3253,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:44','2025-10-08 22:28:44',NULL,NULL,NULL,'96d62528-d0e1-4e65-8c8c-2acdaeff7745'),
(3254,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:28:45','2025-10-08 22:28:45',NULL,NULL,NULL,'bfb466e7-af2b-40e0-a112-e03a3666daf1'),
(3255,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'cb0037a3-1a81-4fc5-8c12-4b958b69b0ad'),
(3256,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'869c3b32-0a9e-4114-ba10-ce54e2ee774f'),
(3257,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'3af8d3b0-3cc3-4b0d-ac91-c3f0f1f90897'),
(3258,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'926da004-87c3-4218-b38e-d6392e6b5953'),
(3259,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'3a54dcc4-f16a-48de-87d9-39254d852dbc'),
(3260,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'684bb1bd-2c75-48c3-b747-e40a1c53f889'),
(3261,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'231ebd46-582a-4308-8b39-55fe0546ae63'),
(3262,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'3204721d-8dd0-4be7-8087-109eadc1ce4f'),
(3263,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:52',NULL,NULL,NULL,'ea58d1bd-ea2e-42ac-973f-f4ab5165e693'),
(3264,951,NULL,1787,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'a6925da7-5d11-4581-94d3-eea1dbceb565'),
(3265,3255,NULL,1788,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'ed1f1483-71dd-4017-b820-aa352dc2419f'),
(3266,3256,NULL,1789,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'099bdd28-edef-4603-8fa3-c74521ac9cfd'),
(3267,3257,NULL,1790,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'92047dd5-dec8-4ae3-9d86-cad05f375f02'),
(3268,3258,NULL,1791,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'045335df-424c-4979-ae80-535040f6ee9f'),
(3269,3259,NULL,1792,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'0a99e62f-d788-4324-9f38-34aad42587b4'),
(3270,3260,NULL,1793,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'974c7b3a-2d4f-4dec-8e8a-e1982e379a40'),
(3271,3261,NULL,1794,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'bfc41e73-5d62-4f56-8c15-4fb7d010d7e1'),
(3272,3262,NULL,1795,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'8e53431c-1e44-49d8-a41f-f14f4494c16b'),
(3273,3263,NULL,1796,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:28:52','2025-10-08 22:28:53',NULL,NULL,NULL,'779f531d-dd18-47a1-998d-3fc8ca698806'),
(3275,951,NULL,1797,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:29:34','2025-10-08 22:29:34',NULL,NULL,NULL,'4cf2679c-1e0e-4e8d-ac48-26cbd4dd71c1'),
(3276,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:31','2025-10-08 22:32:31',NULL,NULL,NULL,'aca06e20-47e4-4040-8414-8b3f22ba5765'),
(3278,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:34','2025-10-08 22:32:34',NULL,NULL,NULL,'d156ddf6-c740-4d5b-b58e-a7f63b1effa7'),
(3279,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:35','2025-10-08 22:32:35',NULL,NULL,NULL,'4f48001b-13a2-4b9e-87a8-6b6209e7f9e2'),
(3280,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:37','2025-10-08 22:32:37',NULL,NULL,NULL,'c8cfa90c-a527-4ad9-a684-4de68ee14df5'),
(3281,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:38','2025-10-08 22:32:38',NULL,NULL,NULL,'d8ad29b5-965c-462d-b8a9-ee4d77b0155e'),
(3282,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:40','2025-10-08 22:32:40',NULL,NULL,NULL,'31fb1537-f558-483f-b21d-d697983bf9e6'),
(3283,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:32:41','2025-10-08 22:32:41',NULL,NULL,NULL,'b730aeaa-4638-4f08-b8ff-6de3ff1625d2'),
(3284,2880,NULL,1798,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:32:49','2025-10-08 22:32:49',NULL,NULL,NULL,'58f0cd84-0616-4aa1-af03-c08cdba9af77'),
(3286,2880,NULL,1799,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:18','2025-10-08 22:33:18',NULL,NULL,NULL,'427848f1-64a1-4f1c-9dcb-11e04c74dbee'),
(3292,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'33c86f5d-fcf9-4953-995e-0ae40ee2484e'),
(3293,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'faecdb87-ed68-4322-822f-c4c743e8c4ff'),
(3294,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'d2c3740c-ae0a-4a8b-bef7-754430631cda'),
(3295,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'18acd8a1-72cf-4c59-ae41-98d7d35dcce5'),
(3296,2880,NULL,1800,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:45',NULL,NULL,NULL,'506cf3f6-e40f-4abf-80bb-4f3f2c66014c'),
(3297,3292,NULL,1801,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:46',NULL,NULL,NULL,'10b4c630-fa31-4051-b6c3-b4e94df607c9'),
(3298,3293,NULL,1802,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:46',NULL,NULL,NULL,'d1498675-49a4-43f4-adf9-2b1d2154356d'),
(3299,3294,NULL,1803,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:46',NULL,NULL,NULL,'9f5fea88-14c7-443e-a686-ef834ef6c758'),
(3300,3295,NULL,1804,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:33:45','2025-10-08 22:33:46',NULL,NULL,NULL,'76907b6b-16e8-486f-be6d-4ae5620742af'),
(3303,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:34:45','2025-10-08 22:34:45',NULL,NULL,NULL,'d661a50d-4334-4ddb-81be-4bd4ac48c934'),
(3304,2880,NULL,1805,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:34:45','2025-10-08 22:34:45',NULL,NULL,NULL,'b73fa99b-9207-417a-8eb0-7195479484ad'),
(3305,3303,NULL,1806,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:34:45','2025-10-08 22:34:45',NULL,NULL,NULL,'850cf421-3270-4edb-aa4b-34a3557413c1'),
(3308,NULL,NULL,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:10','2025-10-08 22:35:10',NULL,NULL,NULL,'dc424e0e-0c44-4684-977b-6bbb15e03bae'),
(3309,2880,NULL,1807,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:10','2025-10-08 22:35:10',NULL,NULL,NULL,'8c8e9f9c-5a22-43ed-ab88-e0a63102b044'),
(3310,3308,NULL,1808,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:10','2025-10-08 22:35:10',NULL,NULL,NULL,'3cd5fa52-ec18-4ce2-8817-1ce0591b6548'),
(3316,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'8969d108-e7d5-4546-96c7-01326ddffe7b'),
(3317,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'36b4f8bc-082c-4c26-86fe-a5a5f01e024f'),
(3318,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'7b34198e-87ce-4d20-9421-e4f3ff211698'),
(3319,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'f773fd54-576e-4109-a8e5-f04b3e27935f'),
(3320,2880,NULL,1809,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:46',NULL,NULL,NULL,'3a962400-24ea-4a9c-8472-3ff801ea24da'),
(3321,3316,NULL,1810,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:47',NULL,NULL,NULL,'6fc19b16-934e-495a-961a-dd5549b40cbf'),
(3322,3317,NULL,1811,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:47',NULL,NULL,NULL,'4efc2a03-eb60-4910-ad3f-2033d80152d6'),
(3323,3318,NULL,1812,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:47',NULL,NULL,NULL,'f30893d9-052e-42ee-896a-57854d88e1db'),
(3324,3319,NULL,1813,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:35:46','2025-10-08 22:35:47',NULL,NULL,NULL,'1f24e35e-22a1-4e7b-878a-5ac10367ae21'),
(3335,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'7e8b5496-fedf-4a84-bd26-064fe6c1b823'),
(3336,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'5f114127-ecf5-4041-a894-9ac71e46daa1'),
(3337,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'4cee0710-f8bc-4b56-b361-9798733a7552'),
(3338,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'ed8efdf6-38db-4c67-b4cf-ec8edbfa9a81'),
(3339,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'97d938f6-1902-4675-8115-424195284649'),
(3340,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'5188fac9-9e32-48d1-9f3f-3d799283a888'),
(3341,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'47e4702d-6092-4623-9b1c-4ae764aa3ccb'),
(3342,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'856794d9-80d9-4788-bcf2-8860a036d87a'),
(3343,NULL,NULL,NULL,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'fd190f6f-3cf6-42d9-b3c9-671afd744f7a'),
(3344,1353,NULL,1814,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'22eac443-6e38-4647-bfcc-2ceed65d0cdf'),
(3345,3335,NULL,1815,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'18607dcf-65e1-41ad-989a-a815d4d8d52f'),
(3346,3336,NULL,1816,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'cac4758b-5a46-4fc2-b48d-770426c52c91'),
(3347,3337,NULL,1817,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'5750e4c6-f430-4e13-b15d-4115d7a5cb40'),
(3348,3338,NULL,1818,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'a10bdd20-d263-4f02-8ede-e0da2694cf55'),
(3349,3339,NULL,1819,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'f949e1ea-175c-4582-862b-73a418fa87f5'),
(3350,3340,NULL,1820,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'f56073cb-d456-4ea0-80e4-aedcac8152eb'),
(3351,3341,NULL,1821,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'70888f46-5ee1-4d3b-9694-8f4a56f09a9f'),
(3352,3342,NULL,1822,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'0334185d-fb7f-4679-80fe-7192e4313936'),
(3353,3343,NULL,1823,3,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:17','2025-10-08 22:38:17',NULL,NULL,NULL,'51a63420-3e24-4b8d-9641-92445926349a'),
(3356,1353,NULL,1824,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:45','2025-10-08 22:38:45',NULL,NULL,NULL,'9fb9ec2c-3156-491a-b7e8-c4ba46690569'),
(3357,1835,NULL,1825,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:38:45','2025-10-08 22:38:45',NULL,NULL,NULL,'b819b9d7-247e-45d7-9f34-6833e4417e06'),
(3359,1353,NULL,1826,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:40:25','2025-10-08 22:40:25',NULL,NULL,NULL,'ace0a890-89d0-4b09-9eb7-044c82db1153'),
(3361,NULL,776,NULL,2,'craft\\elements\\Entry',1,0,'2025-10-08 22:40:33','2025-10-08 22:40:33',NULL,NULL,NULL,'b107e934-b037-4e02-b2d1-e4f0169aa197'),
(3362,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:49','2025-10-08 22:40:49',NULL,NULL,NULL,'1b4870ed-c6ab-486e-84e6-846e8c82c76c'),
(3363,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:50','2025-10-08 22:40:50',NULL,NULL,NULL,'91f91620-da2c-4c51-a168-96f9397c3a6f'),
(3364,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:50','2025-10-08 22:40:50',NULL,NULL,NULL,'ed703b69-c26d-4fba-ad46-061978e899a6'),
(3365,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:51','2025-10-08 22:40:51',NULL,NULL,NULL,'843bf451-ea46-4e9b-8b0a-f4bd4912be4c'),
(3366,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:52','2025-10-08 22:40:52',NULL,NULL,NULL,'6805b5fb-6934-4a9b-b066-e113dbd18328'),
(3367,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:53','2025-10-08 22:40:53',NULL,NULL,NULL,'4ea78724-356d-4120-8b75-4a8b6fb13915'),
(3368,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:54','2025-10-08 22:40:54',NULL,NULL,NULL,'3ea5d451-bdb3-42da-a846-c469b07af340'),
(3369,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:54','2025-10-08 22:40:54',NULL,NULL,NULL,'13f5695f-b44d-4804-aa0e-e68d4a79372f'),
(3370,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:56','2025-10-08 22:40:56',NULL,NULL,NULL,'3e8998bb-8848-4315-aecc-63e6f5c989f0'),
(3371,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:57','2025-10-08 22:40:57',NULL,NULL,NULL,'a8513575-6827-4572-9e6d-b8fee7475225'),
(3372,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:40:59','2025-10-08 22:40:59',NULL,NULL,NULL,'512e185b-aec6-4a21-ac73-5602efb36dc0'),
(3373,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:41:00','2025-10-08 22:41:00',NULL,NULL,NULL,'79ff754c-990d-424b-84bf-15780ecf449a'),
(3374,NULL,NULL,NULL,8,'craft\\elements\\Asset',1,0,'2025-10-08 22:41:02','2025-10-08 22:41:02',NULL,NULL,NULL,'be86a4ca-1d97-4506-8e55-b23028646685'),
(3375,1353,NULL,1827,1,'craft\\elements\\Entry',1,0,'2025-10-08 22:41:35','2025-10-08 22:41:35',NULL,NULL,NULL,'31e28523-5181-4da7-a3d1-16fc7a2d23d3');
/*!40000 ALTER TABLE `elements` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements_bulkops`
--

LOCK TABLES `elements_bulkops` WRITE;
/*!40000 ALTER TABLE `elements_bulkops` DISABLE KEYS */;
set autocommit=0;
/*!40000 ALTER TABLE `elements_bulkops` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements_owners`
--

LOCK TABLES `elements_owners` WRITE;
/*!40000 ALTER TABLE `elements_owners` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements_owners` VALUES
(8,2,1),
(44,2,1),
(45,2,2),
(46,2,3),
(47,2,4),
(56,2,1),
(57,2,2),
(63,2,3),
(72,2,1),
(73,2,2),
(74,2,3),
(75,2,4),
(76,2,5),
(96,2,1),
(97,2,2),
(98,2,3),
(99,2,4),
(100,2,5),
(101,2,6),
(131,2,1),
(132,2,2),
(420,546,1),
(420,549,1),
(420,553,1),
(420,566,1),
(420,568,1),
(420,570,1),
(420,575,1),
(420,577,1),
(420,581,1),
(420,586,1),
(420,592,1),
(420,596,1),
(420,599,1),
(421,546,2),
(421,549,2),
(421,553,2),
(421,566,2),
(421,568,2),
(421,570,2),
(421,575,2),
(421,577,2),
(421,581,2),
(421,586,2),
(421,592,2),
(421,596,2),
(421,599,2),
(426,546,1),
(426,549,1),
(426,553,1),
(426,566,1),
(426,568,1),
(426,570,1),
(426,575,1),
(426,577,1),
(426,581,1),
(427,546,2),
(427,549,2),
(427,553,2),
(427,566,2),
(427,568,2),
(427,570,2),
(427,575,2),
(427,577,2),
(427,581,2),
(428,546,3),
(428,549,3),
(428,553,3),
(428,566,3),
(428,568,3),
(428,570,3),
(428,575,3),
(428,577,3),
(428,581,3),
(429,546,1),
(429,549,1),
(429,553,1),
(429,566,1),
(429,568,1),
(429,570,1),
(429,575,1),
(429,577,1),
(429,581,1),
(430,546,2),
(430,549,2),
(430,553,2),
(430,566,2),
(430,568,2),
(430,570,2),
(430,575,2),
(430,577,2),
(430,581,2),
(431,546,3),
(431,549,3),
(431,553,3),
(431,566,3),
(431,568,3),
(431,570,3),
(431,575,3),
(431,577,3),
(431,581,3),
(432,546,4),
(432,549,4),
(432,553,4),
(432,566,4),
(432,568,4),
(432,570,4),
(432,575,4),
(432,577,4),
(432,581,4),
(433,546,5),
(433,549,5),
(433,553,5),
(433,566,5),
(433,568,5),
(433,570,5),
(433,575,5),
(433,577,5),
(433,581,5),
(445,2,1),
(587,586,1),
(587,592,1),
(587,596,1),
(587,599,1),
(587,625,1),
(587,627,1),
(587,630,1),
(587,636,1),
(587,640,1),
(587,647,1),
(588,586,2),
(588,592,2),
(588,596,2),
(588,599,2),
(588,625,2),
(588,627,2),
(588,630,2),
(588,636,2),
(588,640,2),
(588,647,2),
(589,586,3),
(593,592,3),
(597,596,3),
(597,599,3),
(597,625,3),
(597,627,3),
(597,630,3),
(597,636,3),
(597,640,3),
(597,647,3),
(637,636,1),
(637,640,1),
(637,647,1),
(638,636,1),
(638,640,1),
(638,647,1),
(649,648,1),
(650,648,2),
(651,648,3),
(652,648,1),
(653,648,1),
(835,834,1),
(835,932,1),
(836,834,2),
(836,932,2),
(837,834,3),
(837,932,3),
(838,834,1),
(838,932,1),
(839,834,1),
(839,932,1),
(937,2,1),
(938,2,1),
(940,939,1),
(941,939,2),
(942,939,3),
(943,939,1),
(944,939,1),
(946,945,1),
(947,945,1),
(949,948,1),
(950,948,1),
(952,951,1),
(953,951,1),
(955,954,1),
(956,954,1),
(958,957,1),
(959,957,1),
(961,960,1),
(962,960,1),
(964,963,1),
(965,963,1),
(967,966,1),
(968,966,1),
(970,969,1),
(971,969,1),
(973,972,1),
(974,972,1),
(976,975,1),
(977,975,1),
(979,978,1),
(980,978,1),
(982,981,1),
(983,981,1),
(984,981,1),
(986,985,1),
(987,985,1),
(988,985,1),
(990,989,1),
(991,989,1),
(993,992,1),
(994,992,1),
(996,995,1),
(998,997,1),
(1000,999,1),
(1001,999,1),
(1003,1002,1),
(1004,1002,1),
(1006,1005,1),
(1007,1005,1),
(1009,1008,1),
(1010,1008,1),
(1012,1011,1),
(1013,1011,1),
(1015,1014,1),
(1016,1014,1),
(1018,1017,1),
(1019,1017,1),
(1021,1020,1),
(1022,1020,1),
(1024,1023,1),
(1025,1023,1),
(1026,1023,1),
(1028,1027,1),
(1029,1027,1),
(1030,1027,1),
(1032,1031,1),
(1034,1033,1),
(1036,1035,1),
(1037,1035,1),
(1039,1038,1),
(1040,1038,1),
(1042,1041,1),
(1044,1043,1),
(1046,1045,1),
(1047,1045,1),
(1049,1048,1),
(1050,1048,1),
(1052,1051,1),
(1053,1051,1),
(1054,1051,1),
(1056,1055,1),
(1057,1055,1),
(1058,1055,1),
(1060,1059,1),
(1061,1059,1),
(1062,1059,1),
(1064,1063,1),
(1065,1063,1),
(1066,1063,1),
(1068,1067,1),
(1069,1067,1),
(1071,1070,1),
(1072,1070,1),
(1074,1073,1),
(1075,1073,1),
(1077,1076,1),
(1078,1076,1),
(1080,1079,1),
(1081,1079,1),
(1083,1082,1),
(1084,1082,1),
(1086,1085,1),
(1087,1085,1),
(1089,1088,1),
(1090,1088,1),
(1092,1091,1),
(1093,1091,1),
(1095,1094,1),
(1096,1094,1),
(1098,1097,1),
(1099,1097,1),
(1101,1100,1),
(1102,1100,1),
(1104,1103,1),
(1105,1103,1),
(1107,1106,1),
(1108,1106,1),
(1110,1109,1),
(1111,1109,1),
(1112,1109,1),
(1114,1113,1),
(1115,1113,1),
(1116,1113,1),
(1118,1117,1),
(1119,1117,1),
(1121,1120,1),
(1122,1120,1),
(1124,1123,1),
(1125,1123,1),
(1127,1126,1),
(1128,1126,1),
(1130,1129,1),
(1131,1129,1),
(1133,1132,1),
(1134,1132,1),
(1136,1135,1),
(1137,1135,1),
(1139,1138,1),
(1140,1138,1),
(1144,1143,1),
(1145,1143,1),
(1147,1146,1),
(1148,1146,1),
(1150,1149,1),
(1151,1149,1),
(1153,1152,1),
(1154,1152,1),
(1156,1155,1),
(1157,1155,1),
(1159,1158,1),
(1160,1158,1),
(1162,1161,1),
(1164,1163,1),
(1166,1165,1),
(1167,1165,1),
(1169,1168,1),
(1170,1168,1),
(1172,1171,1),
(1173,1171,1),
(1175,1174,1),
(1176,1174,1),
(1178,1177,1),
(1179,1177,1),
(1181,1180,1),
(1182,1180,1),
(1183,1177,1),
(1184,1177,1),
(1186,1185,1),
(1187,1185,1),
(1189,1188,1),
(1190,1188,1),
(1192,1191,1),
(1193,1191,1),
(1195,1194,1),
(1196,1194,1),
(1198,1197,1),
(1200,1199,1),
(1202,1201,1),
(1203,1201,1),
(1204,1201,1),
(1206,1205,1),
(1207,1205,1),
(1208,1205,1),
(1210,1209,1),
(1211,1209,1),
(1213,1212,1),
(1214,1212,1),
(1216,1215,1),
(1218,1217,1),
(1220,1219,1),
(1221,1219,1),
(1223,1222,1),
(1224,1222,1),
(1226,1225,1),
(1227,1225,1),
(1229,1228,1),
(1230,1228,1),
(1232,1231,1),
(1233,1231,1),
(1235,1234,1),
(1236,1234,1),
(1238,1237,1),
(1239,1237,1),
(1241,1240,1),
(1242,1240,1),
(1244,1243,1),
(1245,1243,1),
(1247,1246,1),
(1248,1246,1),
(1250,1249,1),
(1251,1249,1),
(1253,1252,1),
(1254,1252,1),
(1256,1255,1),
(1257,1255,1),
(1259,1258,1),
(1260,1258,1),
(1262,1261,1),
(1263,1261,1),
(1264,1261,1),
(1266,1265,1),
(1267,1265,1),
(1268,1265,1),
(1270,1269,1),
(1271,1269,1),
(1272,1269,1),
(1274,1273,1),
(1275,1273,1),
(1276,1273,1),
(1278,1277,1),
(1279,1277,1),
(1281,1280,1),
(1282,1280,1),
(1284,1283,1),
(1285,1283,1),
(1287,1286,1),
(1288,1286,1),
(1290,1289,1),
(1290,2923,1),
(1291,1289,1),
(1291,2923,1),
(1292,1289,1),
(1292,2923,1),
(1294,1293,1),
(1295,1293,1),
(1296,1293,1),
(1298,1297,1),
(1299,1297,1),
(1301,1300,1),
(1302,1300,1),
(1304,1303,1),
(1305,1303,1),
(1307,1306,1),
(1308,1306,1),
(1310,1309,1),
(1311,1309,1),
(1313,1312,1),
(1314,1312,1),
(1316,1315,1),
(1317,1315,1),
(1318,1315,1),
(1320,1319,1),
(1321,1319,1),
(1322,1319,1),
(1324,1323,1),
(1325,1323,1),
(1327,1326,1),
(1328,1326,1),
(1330,1329,1),
(1331,1329,1),
(1332,1329,1),
(1334,1333,1),
(1335,1333,1),
(1336,1333,1),
(1338,1337,1),
(1339,1337,1),
(1341,1340,1),
(1342,1340,1),
(1344,1343,1),
(1345,1343,1),
(1347,1346,1),
(1348,1346,1),
(1350,1349,1),
(1352,1351,1),
(1354,1353,1),
(1355,1353,1),
(1357,1356,1),
(1358,1356,1),
(1360,1359,1),
(1361,1359,1),
(1363,1362,1),
(1364,1362,1),
(1366,1365,1),
(1367,1365,1),
(1369,1368,1),
(1370,1368,1),
(1372,1371,1),
(1373,1371,1),
(1375,1374,1),
(1376,1374,1),
(1378,1377,1),
(1379,1377,1),
(1381,1380,1),
(1382,1380,1),
(1384,1383,1),
(1385,1383,1),
(1387,1386,1),
(1388,1386,1),
(1390,1389,1),
(1391,1389,1),
(1393,1392,1),
(1394,1392,1),
(1396,1395,1),
(1397,1395,1),
(1399,1398,1),
(1400,1398,1),
(1402,1401,1),
(1403,1401,1),
(1405,1404,1),
(1406,1404,1),
(1408,1407,1),
(1409,1407,1),
(1411,1410,1),
(1412,1410,1),
(1414,1413,1),
(1415,1413,1),
(1417,1416,1),
(1418,1416,1),
(1420,1419,1),
(1421,1419,1),
(1423,1422,1),
(1424,1422,1),
(1426,1425,1),
(1427,1425,1),
(1429,1428,1),
(1430,1428,1),
(1432,1431,1),
(1433,1431,1),
(1435,1434,1),
(1436,1434,1),
(1438,1437,1),
(1438,2957,1),
(1439,1437,1),
(1439,2957,1),
(1441,1440,1),
(1442,1440,1),
(1444,1443,1),
(1445,1443,1),
(1447,1446,1),
(1448,1446,1),
(1450,1449,1),
(1451,1449,1),
(1453,1452,1),
(1454,1452,1),
(1456,1455,1),
(1457,1455,1),
(1459,1458,1),
(1460,1458,1),
(1462,1461,1),
(1463,1461,1),
(1465,1464,1),
(1466,1464,1),
(1468,1467,1),
(1469,1467,1),
(1471,1470,1),
(1472,1470,1),
(1474,1473,1),
(1476,1475,1),
(1478,1477,1),
(1480,1479,1),
(1482,1481,1),
(1484,1483,1),
(1486,2,1),
(1487,2,1),
(1489,1488,1),
(1489,1953,1),
(1489,2210,1),
(1490,1488,2),
(1490,1953,2),
(1490,2210,2),
(1491,1488,3),
(1491,1953,3),
(1491,2210,3),
(1492,1488,1),
(1492,1953,1),
(1492,2210,1),
(1493,1488,1),
(1493,1953,1),
(1493,2210,1),
(1494,945,1),
(1495,945,1),
(1497,1496,1),
(1497,1965,1),
(1497,2212,1),
(1497,2214,1),
(1498,1496,1),
(1498,1965,1),
(1498,2212,1),
(1498,2214,1),
(1499,951,1),
(1500,951,1),
(1502,1501,1),
(1502,1967,1),
(1502,2216,1),
(1503,1501,1),
(1503,1967,1),
(1503,2216,1),
(1504,957,1),
(1505,957,1),
(1507,1506,1),
(1507,1975,1),
(1508,1506,1),
(1508,1975,1),
(1509,963,1),
(1510,963,1),
(1512,1511,1),
(1512,1977,1),
(1513,1511,1),
(1513,1977,1),
(1514,969,1),
(1515,969,1),
(1517,1516,1),
(1517,1995,1),
(1518,1516,1),
(1518,1995,1),
(1519,975,1),
(1520,975,1),
(1522,1521,1),
(1522,2011,1),
(1523,1521,1),
(1523,2011,1),
(1524,981,1),
(1525,981,1),
(1526,981,1),
(1528,1527,1),
(1528,2041,1),
(1529,1527,1),
(1529,2041,1),
(1530,1527,1),
(1530,2041,1),
(1531,989,1),
(1532,989,1),
(1534,1533,1),
(1534,2051,1),
(1535,1533,1),
(1535,2051,1),
(1536,995,1),
(1538,1537,1),
(1538,2055,1),
(1539,999,1),
(1540,999,1),
(1542,1541,1),
(1542,2162,1),
(1543,1541,1),
(1543,2162,1),
(1544,1005,1),
(1545,1005,1),
(1547,1546,1),
(1547,2075,1),
(1548,1546,1),
(1548,2075,1),
(1549,1011,1),
(1550,1011,1),
(1552,1551,1),
(1552,2085,1),
(1553,1551,1),
(1553,2085,1),
(1554,1017,1),
(1555,1017,1),
(1557,1556,1),
(1557,2160,1),
(1558,1556,1),
(1558,2160,1),
(1559,1023,1),
(1560,1023,1),
(1561,1023,1),
(1563,1562,1),
(1563,2158,1),
(1564,1562,1),
(1564,2158,1),
(1565,1562,1),
(1565,2158,1),
(1566,1031,1),
(1568,1567,1),
(1568,2129,1),
(1569,1035,1),
(1570,1035,1),
(1572,1571,1),
(1572,2133,1),
(1573,1571,1),
(1573,2133,1),
(1574,1041,1),
(1576,1575,1),
(1576,2135,1),
(1577,1045,1),
(1578,1045,1),
(1580,1579,1),
(1580,1950,1),
(1580,1952,1),
(1580,1960,1),
(1580,2220,1),
(1581,1579,1),
(1581,1950,1),
(1581,1952,1),
(1581,1960,1),
(1581,2220,1),
(1582,1051,1),
(1583,1051,1),
(1584,1051,1),
(1586,1585,1),
(1586,1979,1),
(1586,1981,1),
(1587,1585,1),
(1587,1979,1),
(1587,1981,1),
(1588,1585,1),
(1588,1979,1),
(1588,1981,1),
(1589,1059,1),
(1590,1059,1),
(1591,1059,1),
(1593,1592,1),
(1593,1991,1),
(1594,1592,1),
(1594,1991,1),
(1595,1592,1),
(1595,1991,1),
(1596,1067,1),
(1597,1067,1),
(1599,1598,1),
(1599,2013,1),
(1600,1598,1),
(1600,2013,1),
(1601,1073,1),
(1602,1073,1),
(1604,1603,1),
(1604,2039,1),
(1605,1603,1),
(1605,2039,1),
(1606,1079,1),
(1607,1079,1),
(1609,1608,1),
(1609,2059,1),
(1610,1608,1),
(1610,2059,1),
(1611,1085,1),
(1612,1085,1),
(1614,1613,1),
(1614,2079,1),
(1615,1613,1),
(1615,2079,1),
(1616,1091,1),
(1617,1091,1),
(1619,1618,1),
(1619,2087,1),
(1620,1618,1),
(1620,2087,1),
(1621,1097,1),
(1622,1097,1),
(1624,1623,1),
(1624,2089,1),
(1624,2091,1),
(1625,1623,1),
(1625,2089,1),
(1625,2091,1),
(1626,1103,1),
(1627,1103,1),
(1629,1628,1),
(1629,2095,1),
(1630,1628,1),
(1630,2095,1),
(1631,1109,1),
(1632,1109,1),
(1633,1109,1),
(1635,1634,1),
(1635,2156,1),
(1636,1634,1),
(1636,2156,1),
(1637,1634,1),
(1637,2156,1),
(1638,1117,1),
(1639,1117,1),
(1641,1640,1),
(1641,2154,1),
(1642,1640,1),
(1642,2154,1),
(1643,1123,1),
(1644,1123,1),
(1646,1645,1),
(1646,2139,1),
(1647,1645,1),
(1647,2139,1),
(1648,1129,1),
(1649,1129,1),
(1651,1650,1),
(1651,2141,1),
(1652,1650,1),
(1652,2141,1),
(1653,1135,1),
(1654,1135,1),
(1656,1655,1),
(1656,2145,1),
(1657,1655,1),
(1657,2145,1),
(1659,1143,1),
(1660,1143,1),
(1662,1661,1),
(1662,2152,1),
(1663,1661,1),
(1663,2152,1),
(1664,1149,1),
(1665,1149,1),
(1667,1666,1),
(1667,2105,1),
(1667,2107,1),
(1668,1666,1),
(1668,2105,1),
(1668,2107,1),
(1669,1155,1),
(1670,1155,1),
(1672,1671,1),
(1672,2109,1),
(1673,1671,1),
(1673,2109,1),
(1674,1161,1),
(1676,1675,1),
(1676,1985,1),
(1676,2206,1),
(1677,1165,1),
(1678,1165,1),
(1680,1679,1),
(1680,1956,1),
(1680,1958,1),
(1681,1679,1),
(1681,1956,1),
(1681,1958,1),
(1682,1171,1),
(1683,1171,1),
(1685,1684,1),
(1685,1963,1),
(1686,1684,1),
(1686,1963,1),
(1687,1177,1),
(1688,1177,1),
(1690,1689,1),
(1691,1689,1),
(1692,1177,1),
(1693,1177,1),
(1694,1185,1),
(1695,1185,1),
(1697,1696,1),
(1697,1983,1),
(1697,2170,1),
(1698,1696,1),
(1698,1983,1),
(1698,2170,1),
(1699,1191,1),
(1700,1191,1),
(1702,1701,1),
(1702,1999,1),
(1702,2176,1),
(1703,1701,1),
(1703,1999,1),
(1703,2176,1),
(1704,1197,1),
(1706,1705,1),
(1706,2024,1),
(1706,2182,1),
(1707,1201,1),
(1708,1201,1),
(1709,1201,1),
(1711,1710,1),
(1711,2026,1),
(1711,2184,1),
(1712,1710,1),
(1712,2026,1),
(1712,2184,1),
(1713,1710,1),
(1713,2026,1),
(1713,2184,1),
(1714,1209,1),
(1715,1209,1),
(1717,1716,1),
(1717,2030,1),
(1717,2190,1),
(1718,1716,1),
(1718,2030,1),
(1718,2190,1),
(1719,1215,1),
(1721,1720,1),
(1721,2043,1),
(1721,2197,1),
(1722,1219,1),
(1723,1219,1),
(1725,1724,1),
(1725,2057,1),
(1726,1724,1),
(1726,2057,1),
(1727,1225,1),
(1728,1225,1),
(1730,1729,1),
(1730,2071,1),
(1730,2073,1),
(1731,1729,1),
(1731,2071,1),
(1731,2073,1),
(1732,1231,1),
(1733,1231,1),
(1735,1734,1),
(1735,2093,1),
(1735,2203,1),
(1736,1734,1),
(1736,2093,1),
(1736,2203,1),
(1737,1237,1),
(1738,1237,1),
(1740,1739,1),
(1740,2097,1),
(1741,1739,1),
(1741,2097,1),
(1742,1243,1),
(1743,1243,1),
(1745,1744,1),
(1745,2099,1),
(1745,2103,1),
(1746,1744,1),
(1746,2099,1),
(1746,2103,1),
(1747,1249,1),
(1748,1249,1),
(1750,1749,1),
(1750,2137,1),
(1751,1749,1),
(1751,2137,1),
(1752,1255,1),
(1753,1255,1),
(1755,1754,1),
(1755,1945,1),
(1755,1961,1),
(1755,2164,1),
(1755,2207,1),
(1756,1754,1),
(1756,1945,1),
(1756,1961,1),
(1756,2164,1),
(1756,2207,1),
(1757,1261,1),
(1758,1261,1),
(1759,1261,1),
(1761,1760,1),
(1761,1969,1),
(1761,2166,1),
(1762,1760,1),
(1762,1969,1),
(1762,2166,1),
(1763,1760,1),
(1763,1969,1),
(1763,2166,1),
(1764,1269,1),
(1765,1269,1),
(1766,1269,1),
(1768,1767,1),
(1768,1993,1),
(1769,1767,1),
(1769,1993,1),
(1770,1767,1),
(1770,1993,1),
(1771,1277,1),
(1772,1277,1),
(1774,1773,1),
(1774,1997,1),
(1774,2174,1),
(1775,1773,1),
(1775,1997,1),
(1775,2174,1),
(1776,1283,1),
(1777,1283,1),
(1779,1778,1),
(1779,2019,1),
(1779,2022,1),
(1780,1778,1),
(1780,2019,1),
(1780,2022,1),
(1781,1289,1),
(1781,2923,1),
(1782,1289,1),
(1782,2923,1),
(1783,1289,1),
(1783,2923,1),
(1785,1784,1),
(1785,2032,1),
(1785,2192,1),
(1786,1784,1),
(1786,2032,1),
(1786,2192,1),
(1787,1784,1),
(1787,2032,1),
(1787,2192,1),
(1788,1297,1),
(1789,1297,1),
(1791,1790,1),
(1791,2034,1),
(1791,2194,1),
(1792,1790,1),
(1792,2034,1),
(1792,2194,1),
(1793,1303,1),
(1794,1303,1),
(1796,1795,1),
(1796,2036,1),
(1796,2196,1),
(1797,1795,1),
(1797,2036,1),
(1797,2196,1),
(1798,1309,1),
(1799,1309,1),
(1801,1800,1),
(1801,2053,1),
(1801,2186,1),
(1802,1800,1),
(1802,2053,1),
(1802,2186,1),
(1803,1315,1),
(1804,1315,1),
(1805,1315,1),
(1807,1806,1),
(1807,2077,1),
(1808,1806,1),
(1808,2077,1),
(1809,1806,1),
(1809,2077,1),
(1810,1323,1),
(1811,1323,1),
(1813,1812,1),
(1813,2083,1),
(1814,1812,1),
(1814,2083,1),
(1815,1329,1),
(1816,1329,1),
(1817,1329,1),
(1819,1818,1),
(1819,2111,1),
(1819,2113,1),
(1820,1818,1),
(1820,2111,1),
(1820,2113,1),
(1821,1818,1),
(1821,2111,1),
(1821,2113,1),
(1822,1337,1),
(1823,1337,1),
(1825,1824,1),
(1825,2117,1),
(1826,1824,1),
(1826,2117,1),
(1827,1343,1),
(1828,1343,1),
(1830,1829,1),
(1830,2121,1),
(1831,1829,1),
(1831,2121,1),
(1832,1349,1),
(1834,1833,1),
(1834,2143,1),
(1835,1353,1),
(1836,1353,1),
(1838,1837,1),
(1838,1987,1),
(1838,1989,1),
(1838,2172,1),
(1839,1837,1),
(1839,1987,1),
(1839,1989,1),
(1839,2172,1),
(1840,1359,1),
(1841,1359,1),
(1843,1842,1),
(1843,2007,1),
(1843,2178,1),
(1844,1842,1),
(1844,2007,1),
(1844,2178,1),
(1845,1365,1),
(1846,1365,1),
(1848,1847,1),
(1848,2009,1),
(1849,1847,1),
(1849,2009,1),
(1850,1371,1),
(1851,1371,1),
(1853,1852,1),
(1853,2045,1),
(1853,2199,1),
(1854,1852,1),
(1854,2045,1),
(1854,2199,1),
(1855,1377,1),
(1856,1377,1),
(1858,1857,1),
(1858,2063,1),
(1859,1857,1),
(1859,2063,1),
(1860,1383,1),
(1861,1383,1),
(1863,1862,1),
(1863,2081,1),
(1864,1862,1),
(1864,2081,1),
(1865,1389,1),
(1866,1389,1),
(1868,1867,1),
(1868,2102,1),
(1869,1867,1),
(1869,2102,1),
(1870,1395,1),
(1871,1395,1),
(1873,1872,1),
(1873,2123,1),
(1874,1872,1),
(1874,2123,1),
(1875,1401,1),
(1876,1401,1),
(1878,1877,1),
(1878,2125,1),
(1879,1877,1),
(1879,2125,1),
(1880,1407,1),
(1881,1407,1),
(1883,1882,1),
(1883,2119,1),
(1884,1882,1),
(1884,2119,1),
(1885,1413,1),
(1886,1413,1),
(1888,1887,1),
(1888,2131,1),
(1889,1887,1),
(1889,2131,1),
(1890,1419,1),
(1891,1419,1),
(1893,1892,1),
(1893,2001,1),
(1893,2003,1),
(1894,1892,1),
(1894,2001,1),
(1894,2003,1),
(1895,1425,1),
(1896,1425,1),
(1898,1897,1),
(1898,2005,1),
(1899,1897,1),
(1899,2005,1),
(1900,1431,1),
(1901,1431,1),
(1903,1902,1),
(1903,2015,1),
(1903,2180,1),
(1904,1902,1),
(1904,2015,1),
(1904,2180,1),
(1905,1437,1),
(1905,2957,1),
(1906,1437,1),
(1906,2957,1),
(1908,1907,1),
(1908,2017,1),
(1908,2021,1),
(1908,2218,1),
(1909,1907,1),
(1909,2017,1),
(1909,2021,1),
(1909,2218,1),
(1910,1443,1),
(1911,1443,1),
(1913,1912,1),
(1913,2028,1),
(1913,2188,1),
(1914,1912,1),
(1914,2028,1),
(1914,2188,1),
(1915,1449,1),
(1916,1449,1),
(1918,1917,1),
(1918,2047,1),
(1918,2201,1),
(1919,1917,1),
(1919,2047,1),
(1919,2201,1),
(1920,1455,1),
(1921,1455,1),
(1923,1922,1),
(1923,2049,1),
(1924,1922,1),
(1924,2049,1),
(1925,1461,1),
(1926,1461,1),
(1928,1927,1),
(1928,2065,1),
(1929,1927,1),
(1929,2065,1),
(1930,1467,1),
(1931,1467,1),
(1933,1932,1),
(1933,2067,1),
(1933,2069,1),
(1934,1932,1),
(1934,2067,1),
(1934,2069,1),
(1935,1473,1),
(1937,1936,1),
(1937,2127,1),
(1938,1477,1),
(1940,1939,1),
(1940,2061,1),
(1941,1481,1),
(1943,1942,1),
(1943,2115,1),
(1972,1971,1),
(1972,2168,1),
(1973,1971,1),
(1973,2168,1),
(2223,2222,1),
(2223,2493,1),
(2223,2499,1),
(2223,2626,1),
(2223,2717,1),
(2223,2731,1),
(2223,2736,1),
(2223,2745,1),
(2223,2794,1),
(2223,2799,1),
(2223,2831,1),
(2223,2839,1),
(2223,2841,1),
(2223,2843,1),
(2223,2853,1),
(2223,2894,1),
(2223,2896,1),
(2223,2908,1),
(2223,2938,1),
(2223,2946,1),
(2223,2951,1),
(2223,2955,1),
(2223,3214,1),
(2223,3216,1),
(2224,2222,2),
(2224,2493,2),
(2224,2499,2),
(2224,2626,2),
(2224,2717,2),
(2224,2731,2),
(2224,2736,2),
(2224,2745,2),
(2224,2794,2),
(2224,2799,2),
(2224,2831,2),
(2224,2839,2),
(2224,2841,2),
(2224,2843,2),
(2224,2853,2),
(2224,2894,2),
(2224,2896,2),
(2224,2908,2),
(2224,2938,2),
(2224,2946,2),
(2224,2951,2),
(2224,2955,2),
(2224,3214,2),
(2224,3216,2),
(2225,2222,3),
(2225,2493,3),
(2225,2499,3),
(2225,2626,3),
(2225,2717,3),
(2225,2731,3),
(2225,2736,3),
(2225,2745,3),
(2225,2794,3),
(2225,2799,3),
(2225,2831,3),
(2225,2839,3),
(2225,2841,3),
(2225,2843,3),
(2225,2853,3),
(2225,2894,3),
(2225,2896,3),
(2225,2908,3),
(2225,2938,3),
(2225,2946,3),
(2225,2951,3),
(2225,2955,3),
(2225,3214,3),
(2225,3216,3),
(2226,2222,1),
(2226,2493,1),
(2227,2222,1),
(2227,2493,1),
(2229,2228,1),
(2229,2627,1),
(2229,2847,1),
(2229,2854,1),
(2229,2988,1),
(2229,2995,1),
(2229,3001,1),
(2229,3006,1),
(2229,3212,1),
(2230,2228,1),
(2230,2627,1),
(2230,2847,1),
(2230,2854,1),
(2230,2988,1),
(2230,2995,1),
(2230,3001,1),
(2230,3006,1),
(2230,3212,1),
(2232,2231,1),
(2232,2635,1),
(2233,2231,1),
(2233,2635,1),
(2233,3223,1),
(2233,3264,1),
(2233,3275,1),
(2235,2234,1),
(2235,3009,1),
(2235,3029,1),
(2235,3041,1),
(2236,2234,1),
(2236,3009,1),
(2236,3029,1),
(2236,3041,1),
(2238,2237,1),
(2238,3059,1),
(2238,3071,1),
(2238,3080,1),
(2239,2237,1),
(2239,3059,1),
(2239,3071,1),
(2239,3080,1),
(2241,2240,1),
(2241,3095,1),
(2241,3107,1),
(2241,3114,1),
(2242,2240,1),
(2242,3095,1),
(2242,3107,1),
(2242,3114,1),
(2244,2243,1),
(2244,3125,1),
(2245,2243,1),
(2245,3125,1),
(2247,2246,1),
(2247,3159,1),
(2247,3171,1),
(2247,3183,1),
(2247,3188,1),
(2248,2246,1),
(2248,3159,1),
(2248,3171,1),
(2249,2246,1),
(2249,3159,1),
(2249,3171,1),
(2251,2250,1),
(2252,2250,1),
(2254,2253,1),
(2256,2255,1),
(2257,2255,1),
(2259,2258,1),
(2260,2258,1),
(2262,2261,1),
(2263,2261,1),
(2265,2264,1),
(2266,2264,1),
(2268,2267,1),
(2269,2267,1),
(2270,2267,1),
(2272,2271,1),
(2274,2273,1),
(2275,2273,1),
(2277,2276,1),
(2279,2278,1),
(2279,2965,1),
(2280,2278,1),
(2280,2965,1),
(2282,2281,1),
(2283,2281,1),
(2284,2281,1),
(2286,2285,1),
(2286,2732,1),
(2287,2285,1),
(2287,2732,1),
(2288,2285,1),
(2288,2732,1),
(2290,2289,1),
(2291,2289,1),
(2293,2292,1),
(2294,2292,1),
(2296,2295,1),
(2297,2295,1),
(2299,2298,1),
(2300,2298,1),
(2302,2301,1),
(2303,2301,1),
(2305,2304,1),
(2306,2304,1),
(2308,2307,1),
(2309,2307,1),
(2311,2310,1),
(2312,2310,1),
(2313,2310,1),
(2315,2314,1),
(2316,2314,1),
(2318,2317,1),
(2319,2317,1),
(2321,2320,1),
(2322,2320,1),
(2324,2323,1),
(2325,2323,1),
(2327,2326,1),
(2328,2326,1),
(2330,2329,1),
(2331,2329,1),
(2333,2332,1),
(2335,2334,1),
(2335,2629,1),
(2335,3217,1),
(2336,2334,1),
(2336,2629,1),
(2336,3217,1),
(2338,2337,1),
(2338,2848,1),
(2339,2337,1),
(2339,2848,1),
(2341,2340,1),
(2341,2905,1),
(2341,2907,1),
(2342,2340,1),
(2342,2905,1),
(2342,2907,1),
(2344,2343,1),
(2345,2343,1),
(2347,2346,1),
(2348,2346,1),
(2350,2349,1),
(2352,2351,1),
(2353,2351,1),
(2354,2351,1),
(2356,2355,1),
(2357,2355,1),
(2359,2358,1),
(2361,2360,1),
(2362,2360,1),
(2364,2363,1),
(2365,2363,1),
(2367,2366,1),
(2368,2366,1),
(2370,2369,1),
(2371,2369,1),
(2373,2372,1),
(2374,2372,1),
(2376,2375,1),
(2377,2375,1),
(2379,2378,1),
(2379,2495,1),
(2379,2628,1),
(2379,2885,1),
(2379,2899,1),
(2379,3213,1),
(2380,2378,1),
(2380,2495,1),
(2380,2628,1),
(2380,2885,1),
(2380,2899,1),
(2380,3213,1),
(2382,2381,1),
(2383,2381,1),
(2384,2381,1),
(2386,2385,1),
(2387,2385,1),
(2388,2385,1),
(2390,2389,1),
(2391,2389,1),
(2393,2392,1),
(2393,2733,1),
(2394,2392,1),
(2394,2733,1),
(2396,2395,1),
(2397,2395,1),
(2398,2395,1),
(2400,2399,1),
(2401,2399,1),
(2403,2402,1),
(2404,2402,1),
(2406,2405,1),
(2407,2405,1),
(2409,2408,1),
(2410,2408,1),
(2411,2408,1),
(2413,2412,1),
(2414,2412,1),
(2416,2415,1),
(2417,2415,1),
(2418,2415,1),
(2420,2419,1),
(2421,2419,1),
(2423,2422,1),
(2424,2422,1),
(2426,2425,1),
(2428,2427,1),
(2428,2637,1),
(2428,2641,1),
(2428,2647,1),
(2428,2673,1),
(2428,2695,1),
(2428,3344,1),
(2429,2427,1),
(2429,2637,1),
(2429,2641,1),
(2429,2647,1),
(2429,2673,1),
(2429,2695,1),
(2429,3344,1),
(2429,3356,1),
(2429,3359,1),
(2429,3375,1),
(2431,2430,1),
(2431,2640,1),
(2431,2649,1),
(2431,2671,1),
(2431,2697,1),
(2432,2430,1),
(2432,2640,1),
(2432,2649,1),
(2432,2671,1),
(2432,2697,1),
(2434,2433,1),
(2434,2643,1),
(2434,2651,1),
(2434,2678,1),
(2434,2698,1),
(2435,2433,1),
(2435,2643,1),
(2435,2651,1),
(2435,2678,1),
(2435,2698,1),
(2437,2436,1),
(2437,2645,1),
(2437,2680,1),
(2437,2701,1),
(2438,2436,1),
(2438,2645,1),
(2438,2680,1),
(2438,2701,1),
(2440,2439,1),
(2440,2653,1),
(2440,2682,1),
(2440,2703,1),
(2441,2439,1),
(2441,2653,1),
(2441,2682,1),
(2441,2703,1),
(2443,2442,1),
(2443,2655,1),
(2443,2684,1),
(2443,2707,1),
(2444,2442,1),
(2444,2655,1),
(2444,2684,1),
(2444,2707,1),
(2446,2445,1),
(2446,2657,1),
(2446,2686,1),
(2446,2709,1),
(2447,2445,1),
(2447,2657,1),
(2447,2686,1),
(2447,2709,1),
(2449,2448,1),
(2449,2659,1),
(2449,2675,1),
(2449,2699,1),
(2449,2909,1),
(2450,2448,1),
(2450,2659,1),
(2450,2675,1),
(2450,2699,1),
(2450,2909,1),
(2452,2451,1),
(2452,2661,1),
(2452,2689,1),
(2452,2705,1),
(2453,2451,1),
(2453,2661,1),
(2453,2689,1),
(2453,2705,1),
(2455,2454,1),
(2455,2663,1),
(2455,2691,1),
(2455,2711,1),
(2456,2454,1),
(2456,2663,1),
(2456,2691,1),
(2456,2711,1),
(2458,2457,1),
(2458,2665,1),
(2458,2667,1),
(2458,2669,1),
(2458,2693,1),
(2459,2457,1),
(2459,2665,1),
(2459,2667,1),
(2459,2669,1),
(2459,2693,1),
(2461,2460,1),
(2462,2460,1),
(2464,2463,1),
(2465,2463,1),
(2467,2466,1),
(2468,2466,1),
(2470,2469,1),
(2471,2469,1),
(2473,2472,1),
(2474,2472,1),
(2476,2475,1),
(2477,2475,1),
(2479,2478,1),
(2480,2478,1),
(2482,2481,1),
(2483,2481,1),
(2485,2484,1),
(2486,2484,1),
(2488,2487,1),
(2490,2489,1),
(2492,2491,1),
(2492,2852,1),
(2500,2499,1),
(2500,2626,1),
(2500,2717,1),
(2500,2731,1),
(2500,2736,1),
(2500,2745,1),
(2500,2794,1),
(2500,2799,1),
(2500,2831,1),
(2500,2839,1),
(2500,2841,1),
(2500,2843,1),
(2500,2853,1),
(2500,2894,1),
(2500,2896,1),
(2500,2908,1),
(2500,2938,1),
(2500,2946,1),
(2500,2951,1),
(2500,2955,1),
(2500,3214,1),
(2500,3216,1),
(2501,2499,1),
(2501,2626,1),
(2501,2717,1),
(2501,2731,1),
(2501,2736,1),
(2501,2745,1),
(2501,2794,1),
(2501,2799,1),
(2501,2831,1),
(2501,2839,1),
(2501,2841,1),
(2501,2843,1),
(2501,2853,1),
(2501,2894,1),
(2501,2896,1),
(2501,2908,1),
(2501,2938,1),
(2501,2946,1),
(2501,2951,1),
(2501,2955,1),
(2501,3214,1),
(2501,3216,1),
(2743,2,4),
(2744,2,5),
(2746,2745,4),
(2746,2794,4),
(2746,2799,4),
(2746,2831,4),
(2746,2839,4),
(2746,2841,4),
(2746,2843,4),
(2746,2853,4),
(2746,2894,4),
(2746,2896,4),
(2746,2908,4),
(2746,2938,4),
(2746,2946,4),
(2746,2951,4),
(2746,2955,4),
(2746,3214,4),
(2746,3216,4),
(2747,2745,5),
(2747,2794,5),
(2747,2799,5),
(2747,2831,5),
(2747,2839,5),
(2747,2841,5),
(2747,2843,5),
(2747,2853,5),
(2747,2894,5),
(2747,2896,5),
(2747,2908,5),
(2747,2938,5),
(2747,2946,5),
(2747,2951,5),
(2747,2955,5),
(2747,3214,5),
(2747,3216,5),
(2785,554,1),
(2786,554,2),
(2787,554,3),
(2791,2,1),
(2792,2,2),
(2793,2,2),
(2795,2794,1),
(2795,2799,1),
(2795,2831,1),
(2795,2839,1),
(2795,2841,1),
(2795,2843,1),
(2795,2853,1),
(2795,2894,1),
(2795,2896,1),
(2795,2908,1),
(2796,2794,2),
(2796,2799,2),
(2796,2831,2),
(2796,2839,2),
(2796,2841,2),
(2796,2843,2),
(2796,2853,2),
(2796,2894,2),
(2796,2896,2),
(2796,2908,2),
(2796,2938,2),
(2797,2794,3),
(2797,2799,3),
(2797,2831,3),
(2797,2839,3),
(2797,2841,3),
(2797,2843,3),
(2797,2853,3),
(2797,2894,3),
(2797,2896,3),
(2797,2908,3),
(2797,2938,3),
(2812,554,1),
(2813,554,2),
(2814,554,3),
(2815,554,4),
(2816,554,5),
(2817,554,6),
(2825,2,1),
(2826,2,2),
(2827,2,3),
(2828,2,4),
(2829,2,5),
(2830,2,6),
(2832,2831,1),
(2832,2839,1),
(2832,2841,1),
(2832,2843,1),
(2832,2853,1),
(2832,2894,1),
(2832,2896,1),
(2832,2908,1),
(2832,2938,1),
(2832,2946,1),
(2832,2951,1),
(2832,2955,1),
(2832,3214,1),
(2832,3216,1),
(2833,2831,2),
(2833,2839,2),
(2833,2841,2),
(2833,2843,2),
(2833,2853,2),
(2833,2894,2),
(2833,2896,2),
(2833,2908,2),
(2833,2938,2),
(2833,2946,2),
(2833,2951,2),
(2833,2955,2),
(2833,3214,2),
(2833,3216,2),
(2834,2831,3),
(2834,2839,3),
(2834,2841,3),
(2834,2843,3),
(2834,2853,3),
(2834,2894,3),
(2834,2896,3),
(2834,2908,3),
(2834,2938,3),
(2834,2946,3),
(2834,2951,3),
(2834,2955,3),
(2834,3214,3),
(2834,3216,3),
(2835,2831,4),
(2835,2839,4),
(2835,2841,4),
(2835,2843,4),
(2835,2853,4),
(2835,2894,4),
(2835,2896,4),
(2835,2908,4),
(2835,2938,4),
(2835,2946,4),
(2835,2951,4),
(2835,2955,4),
(2835,3214,4),
(2835,3216,4),
(2836,2831,5),
(2836,2839,5),
(2836,2841,5),
(2836,2843,5),
(2836,2853,5),
(2836,2894,5),
(2836,2896,5),
(2836,2908,5),
(2836,2938,5),
(2836,2946,5),
(2836,2951,5),
(2836,2955,5),
(2836,3214,5),
(2836,3216,5),
(2837,2831,6),
(2837,2839,6),
(2837,2841,6),
(2837,2843,6),
(2837,2853,6),
(2837,2894,6),
(2837,2896,6),
(2837,2908,6),
(2837,2938,6),
(2837,2946,6),
(2837,2951,6),
(2837,2955,6),
(2837,3214,6),
(2837,3216,6),
(2939,2938,1),
(2939,2946,1),
(2939,2951,1),
(2939,2955,1),
(2939,3214,1),
(2939,3216,1),
(2945,2,3),
(2947,2946,2),
(2947,2951,2),
(2948,2946,3),
(2952,2951,3),
(2952,2955,3),
(2952,3214,3),
(2952,3216,3),
(2956,2955,2),
(2956,3214,2),
(2956,3216,2),
(2983,945,1),
(2984,945,2),
(2985,945,3),
(2986,945,4),
(2987,945,5),
(2989,2988,1),
(2989,2995,1),
(2989,3001,1),
(2989,3006,1),
(2989,3212,1),
(2990,2988,2),
(2990,2995,2),
(2990,3001,2),
(2990,3006,2),
(2990,3212,2),
(2991,2988,3),
(2991,2995,3),
(2991,3001,3),
(2991,3006,3),
(2991,3212,3),
(2992,2988,4),
(2992,2995,4),
(2992,3001,4),
(2992,3006,4),
(2992,3212,4),
(2993,2988,5),
(2993,2995,5),
(2993,3001,5),
(2993,3006,5),
(2993,3212,5),
(2999,945,1),
(3000,945,2),
(3002,3001,1),
(3002,3006,1),
(3002,3212,1),
(3003,3001,2),
(3003,3006,2),
(3003,3212,2),
(3036,957,1),
(3037,957,2),
(3038,957,3),
(3039,957,4),
(3040,957,5),
(3042,3041,1),
(3042,3051,1),
(3042,3055,1),
(3042,3218,1),
(3043,3041,2),
(3043,3051,2),
(3043,3055,2),
(3043,3218,2),
(3044,3041,3),
(3044,3051,3),
(3044,3055,3),
(3044,3218,3),
(3045,3041,4),
(3045,3051,4),
(3045,3055,4),
(3045,3218,4),
(3046,3041,5),
(3046,3051,5),
(3046,3055,5),
(3046,3218,5),
(3052,3051,1),
(3052,3055,1),
(3052,3218,1),
(3053,3051,1),
(3053,3055,1),
(3053,3218,1),
(3066,963,1),
(3067,963,2),
(3068,963,3),
(3069,963,4),
(3070,963,5),
(3072,3071,1),
(3072,3080,1),
(3072,3086,1),
(3073,3071,2),
(3073,3080,2),
(3073,3086,2),
(3074,3071,3),
(3074,3080,3),
(3074,3086,3),
(3075,3071,4),
(3075,3080,4),
(3075,3086,4),
(3076,3071,5),
(3076,3080,5),
(3076,3086,5),
(3079,963,1),
(3081,3080,1),
(3081,3086,1),
(3087,3086,1),
(3088,3086,1),
(3102,969,1),
(3103,969,2),
(3104,969,3),
(3105,969,4),
(3106,969,5),
(3108,3107,1),
(3108,3114,1),
(3108,3118,1),
(3109,3107,2),
(3109,3114,2),
(3109,3118,2),
(3110,3107,3),
(3110,3114,3),
(3110,3118,3),
(3111,3107,4),
(3111,3114,4),
(3111,3118,4),
(3112,3107,5),
(3112,3114,5),
(3112,3118,5),
(3119,3118,1),
(3120,3118,1),
(3138,975,1),
(3139,975,2),
(3140,975,3),
(3141,975,4),
(3142,975,5),
(3143,975,1),
(3144,975,2),
(3145,975,3),
(3147,3146,1),
(3148,3146,2),
(3149,3146,3),
(3150,3146,4),
(3151,3146,5),
(3152,3146,1),
(3153,3146,2),
(3154,3146,3),
(3155,3146,1),
(3156,3146,1),
(3166,981,1),
(3167,981,2),
(3168,981,3),
(3169,981,4),
(3170,981,5),
(3172,3171,1),
(3172,3183,1),
(3172,3188,1),
(3173,3171,2),
(3173,3183,2),
(3173,3188,2),
(3174,3171,3),
(3174,3183,3),
(3174,3188,3),
(3175,3171,4),
(3175,3183,4),
(3175,3188,4),
(3176,3171,5),
(3176,3183,5),
(3176,3188,5),
(3182,981,1),
(3184,3183,1),
(3184,3188,1),
(3185,3183,1),
(3185,3188,1),
(3186,3183,1),
(3186,3188,1),
(3224,3223,1),
(3224,3264,1),
(3224,3275,1),
(3255,951,1),
(3256,951,2),
(3257,951,3),
(3258,951,4),
(3259,951,5),
(3260,951,1),
(3261,951,2),
(3262,951,3),
(3263,951,4),
(3265,3264,1),
(3265,3275,1),
(3266,3264,2),
(3266,3275,2),
(3267,3264,3),
(3267,3275,3),
(3268,3264,4),
(3268,3275,4),
(3269,3264,5),
(3269,3275,5),
(3270,3264,1),
(3270,3275,1),
(3271,3264,2),
(3271,3275,2),
(3272,3264,3),
(3272,3275,3),
(3273,3264,4),
(3273,3275,4),
(3292,2880,1),
(3293,2880,2),
(3294,2880,3),
(3295,2880,4),
(3297,3296,1),
(3297,3304,1),
(3297,3309,1),
(3297,3320,1),
(3298,3296,2),
(3298,3304,2),
(3298,3309,2),
(3298,3320,2),
(3299,3296,3),
(3299,3304,3),
(3299,3309,3),
(3299,3320,3),
(3300,3296,4),
(3300,3304,4),
(3300,3309,4),
(3300,3320,4),
(3303,2880,1),
(3305,3304,1),
(3305,3309,1),
(3305,3320,1),
(3308,2880,1),
(3310,3309,1),
(3310,3320,1),
(3316,2880,1),
(3317,2880,2),
(3318,2880,3),
(3319,2880,4),
(3321,3320,1),
(3322,3320,2),
(3323,3320,3),
(3324,3320,4),
(3335,1353,1),
(3336,1353,2),
(3337,1353,3),
(3338,1353,4),
(3339,1353,5),
(3340,1353,1),
(3341,1353,2),
(3342,1353,3),
(3343,1353,4),
(3345,3344,1),
(3345,3356,1),
(3345,3359,1),
(3345,3375,1),
(3346,3344,2),
(3346,3356,2),
(3346,3359,2),
(3346,3375,2),
(3347,3344,3),
(3347,3356,3),
(3347,3359,3),
(3347,3375,3),
(3348,3344,4),
(3348,3356,4),
(3348,3359,4),
(3348,3375,4),
(3349,3344,5),
(3349,3356,5),
(3349,3359,5),
(3349,3375,5),
(3350,3344,1),
(3350,3356,1),
(3350,3359,1),
(3350,3375,1),
(3351,3344,2),
(3351,3356,2),
(3351,3359,2),
(3351,3375,2),
(3352,3344,3),
(3352,3356,3),
(3352,3359,3),
(3352,3375,3),
(3353,3344,4),
(3353,3356,4),
(3353,3359,4),
(3353,3375,4),
(3357,3356,1),
(3357,3359,1),
(3357,3375,1);
/*!40000 ALTER TABLE `elements_owners` ENABLE KEYS */;
UNLOCK TABLES;
commit;

--
-- Dumping data for table `elements_sites`
--

LOCK TABLES `elements_sites` WRITE;
/*!40000 ALTER TABLE `elements_sites` DISABLE KEYS */;
set autocommit=0;
INSERT INTO `elements_sites` VALUES
(1,1,1,NULL,NULL,NULL,NULL,1,'2025-04-18 16:59:46','2025-04-18 16:59:46','c07ab660-8f99-458f-87e2-994099c418d5'),
(2,2,1,'Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Arbors\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Arbors\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccarbors.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[545],\"482ad396-5443-4761-a410-c644d0217e5a\":[601,617,605],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[2610,2598,2608,2600,2596,2602,2604],\"f352e58c-d152-4a45-9615-d0526b009523\":[2891],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[548],\"559340ef-728e-4935-84cc-443bd407f901\":[111,555,557,559,561,563],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[545,137,138,136],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[548],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[548],\"b46c7894-3c01-4cc4-b90f-9612b3b9891b\":\"<script src=\\\"https://apploi.link/Complete_Care_at_Arbors-career-page\\\"></script>\",\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7329140090\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccarbors.com\"}',1,'2025-04-18 17:15:09','2025-09-26 18:00:58','e04f89f6-42a8-4658-b5fe-f4da794eda56'),
(8,8,1,'Complete Care at Arbors','__temp_oafegazovtrfydqmmqaxsfbghndwkdltlqnq',NULL,NULL,1,'2025-04-18 17:32:44','2025-04-18 17:32:44','fcb60278-fad3-409c-927c-9d65720b2d2e'),
(10,10,1,'Complete Care at Arbors','__temp_oafegazovtrfydqmmqaxsfbghndwkdltlqnq',NULL,NULL,1,'2025-04-18 17:32:44','2025-04-18 17:32:44','e528f061-cda8-4793-a9ce-03c12a5ae22b'),
(14,14,1,NULL,'__temp_ajigsuelynrhqqirjqmxctezreglmrxljdge',NULL,NULL,1,'2025-04-18 17:57:42','2025-04-18 17:57:42','b85338da-4c93-4ecc-90e8-f63457a74fa0'),
(16,16,1,'Complete Care at Arbors','__temp_oafegazovtrfydqmmqaxsfbghndwkdltlqnq',NULL,NULL,1,'2025-04-18 17:57:57','2025-04-18 17:57:57','269e069f-1c6b-488d-a876-4d6156ca6771'),
(18,18,1,'Subacute Rehab','subacute-rehab',NULL,NULL,1,'2025-04-18 18:06:39','2025-08-20 21:55:53','ca50ef90-8d9f-4887-b40f-5a623e7f88bc'),
(19,19,1,'Subacute Rehab','subacute-rehab','services/__temp_nikydbscpieabfmxdqpavpbcwhcsbwjfdtau','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Subacute Rehab\"}',1,'2025-04-18 18:06:50','2025-08-20 21:55:00','9e1f7117-7f2e-43f9-953f-a2185cce5396'),
(20,20,1,'Respiratory Care','respiratory-care',NULL,NULL,1,'2025-04-18 18:06:50','2025-08-20 21:55:53','912a3a84-16f7-465e-b9e0-cd2988c22a0c'),
(21,21,1,'Respiratory Care','respiratory-care','services/__temp_lijhtcjgykuwiuknfjjdihijzodkbmxjxouv','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Respiratory Care\"}',1,'2025-04-18 18:06:58','2025-08-20 21:55:00','5b3834e7-d399-45f3-82a9-3d1d8f094af6'),
(22,22,1,'Orthopedic Rehab','orthopedic-rehab',NULL,NULL,1,'2025-04-18 18:06:58','2025-08-20 21:55:53','1c05ee85-3afc-46c2-8a81-0a18f30f5321'),
(23,23,1,'Orthopedic Rehab','orthopedic-rehab','services/__temp_vljdabksbxhsgiduvoeervsdyxbulmhplrgh','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Orthopedic Rehab\"}',1,'2025-04-18 18:07:06','2025-08-20 21:55:00','444febdb-e4d3-4aba-af3a-82d3e39a28bf'),
(24,24,1,'Long-Term Care','long-term-care',NULL,NULL,1,'2025-04-18 18:07:06','2025-08-20 21:55:53','9d1e1a91-fd7a-4b83-811d-4528a6fe8967'),
(25,25,1,'Long-Term Care','long-term-care','services/__temp_vghfulxfpfozycvjnqzxyevgorqyearkupni','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Long-Term Care\"}',1,'2025-04-18 18:07:32','2025-08-20 21:55:00','336063e3-c89f-4ccb-9abf-82e54cdcd792'),
(26,26,1,'Wound Care','wound-care',NULL,NULL,1,'2025-04-18 18:07:32','2025-08-20 21:55:53','f5ad6b40-4fd8-4849-a227-225dd152f119'),
(27,27,1,'Wound Care','wound-care','services/__temp_fokjbrjltnspbxurfimxovogpkrpxdtjnuzw','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Wound Care\"}',1,'2025-04-18 18:07:37','2025-08-20 21:55:00','ae0c4706-f366-4d1a-b66e-5cbd3e2534c8'),
(28,28,1,'Renal Care','renal-care',NULL,NULL,1,'2025-04-18 18:07:37','2025-08-20 21:55:53','d8aef05e-5007-4829-a486-97ebb61afcc9'),
(29,29,1,'Renal Care','renal-care','services/__temp_jjnqbuohveczgaxqjecilxdpzmqcpxzgogmu','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Renal Care\"}',1,'2025-04-18 18:07:43','2025-08-20 21:55:00','9b9bc0c2-f32b-4cc7-be29-ec863e6c3073'),
(30,30,1,'Hospice Care','hospice-care',NULL,NULL,1,'2025-04-18 18:07:43','2025-08-20 21:55:53','a13a939f-b9af-457d-997b-8e9d5fe1f5fa'),
(31,31,1,'Hospice Care','hospice-care','services/__temp_svcddqtzudwfjzlpiwsitxsbwbbznyrrxhat','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Hospice Care\"}',1,'2025-04-18 18:07:48','2025-08-20 21:55:00','3eeb5c2e-4b3d-4c0a-9414-5c48c4c989ce'),
(32,32,1,'Memory Care','memory-care',NULL,NULL,1,'2025-04-18 18:07:48','2025-08-20 21:55:53','faa1cbb6-0aa1-4a90-8af1-250187a8576e'),
(33,33,1,'Memory Care','memory-care','services/__temp_ljmzvxuslwdaxqwfjbgsldbrrqygzikmxfkh','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Memory Care\"}',1,'2025-04-18 18:07:53','2025-08-20 21:55:00','e785080f-ee7a-492c-8a84-947150eb46fc'),
(34,34,1,'Stroke Recovery','stroke-recovery',NULL,NULL,1,'2025-04-18 18:07:53','2025-08-20 21:55:53','49ebb121-5f9b-4bdf-abde-37cc2dd92b32'),
(35,35,1,'Stroke Recovery','stroke-recovery','services/__temp_stgtoxrgnvjqmnnltxvcekvlefvehlctqcty','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Stroke Recovery\"}',1,'2025-04-18 18:08:00','2025-08-20 21:55:00','6a3bf50f-df24-4b0a-acfb-2c898fb82ebc'),
(36,36,1,'Rehabilitation Program','cardiac-care',NULL,NULL,1,'2025-04-18 18:08:00','2025-08-20 21:57:06','1dd01031-2491-4a50-a573-c4e398caaa25'),
(37,37,1,'Cardiac Care','cardiac-care','services/__temp_kjnxfskmhvmqutotbwekktlmieaaphczdypd','{\"a7b99092-005a-4069-87ab-f34eea7da598\": \"Cardiac Care\"}',1,'2025-04-18 18:08:04','2025-08-20 21:55:00','7e25f67b-6dfa-421a-a184-9219522da991'),
(44,44,1,'Menachem Shapiro','menachem-shapiro',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\": \"Menachem Shapiro\", \"50d484f9-ea00-4870-8b7a-a1c7400f42ab\": [632], \"6859b0cf-ccd8-409d-84f9-b76fcac3eda0\": \"mshapiro@ccarbors.com\"}',1,'2025-04-18 18:10:41','2025-09-03 22:27:30','152fc37a-8041-4a16-a25e-ff764f726adb'),
(45,45,1,'Elizabeth Schwear','elizabeth-schwear',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\": \"Elizabeth Schwear\", \"579071f5-918a-4d7a-8c5b-98905ecbe548\": \"Infection Control\"}',1,'2025-04-18 18:10:41','2025-04-18 18:10:41','efea344c-9995-4674-8d66-d44e986a7d78'),
(46,46,1,'Chrissy Martin','chrissy-martin',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\": \"Chrissy Martin\", \"579071f5-918a-4d7a-8c5b-98905ecbe548\": \"Activity Director\"}',1,'2025-04-18 18:10:41','2025-04-18 18:10:41','0218ebb2-dab2-45c0-a7a3-3186d10acb24'),
(47,47,1,'Jackie Boyle','jackie-boyle',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\": \"Jackie Boyle\", \"579071f5-918a-4d7a-8c5b-98905ecbe548\": \"Director of Nursing\"}',1,'2025-04-18 18:10:41','2025-04-18 18:10:41','2aae050f-df49-45f3-98b0-1e634c2519fb'),
(56,56,1,'Ashie T.','robert-a',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Ashie T.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"The staff at Complete Care goes above and beyond to provide patient care and satisfaction! Always with a smile and a good word, the staff is there whenever you need them and the services they provide are unparalleled.\"}',1,'2025-04-18 18:14:39','2025-09-03 21:05:58','d578bc04-9ede-461b-ab91-bfd2b26ca8f5'),
(57,57,1,'Carole T.','bernadette-m',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Carole T.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"Very professional and caring place, staff and nurses were overly helpful in attending to needs. Therapy went way above to assist in getting us to reach maximum potential.\"}',1,'2025-04-18 18:14:39','2025-09-03 21:05:58','359347a7-f306-422c-8a16-6404cd8292f9'),
(63,63,1,'Cora O.','mary-o',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Cora O.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"I have been here for 3 years and I am thrilled with the quality care I receive. I enjoy every day is a new amazing experience with activities. The staff are wonderful! The place is very clean and every one is very polite!\"}',1,'2025-04-18 18:15:36','2025-09-03 21:08:08','d44334bf-5f39-4646-bcb5-f92a8fbf9641'),
(72,72,1,'Lobby','lobby',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Lobby\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','daa9fe3b-dbec-45e6-9392-1cea08697c39'),
(73,73,1,'Rehab Gym','rehab-gym',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Rehab Gym\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','fdc59595-0504-4c12-94c1-6c938628206a'),
(74,74,1,'Patient Room','patient-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Patient Room\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','6b409b7f-c08e-4140-aea6-a1e0f1e9e23f'),
(75,75,1,'Recreation Room','recreation-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Recreation Room\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','fbc3a2aa-119b-4210-877e-662fed603e36'),
(76,76,1,'Dining Room','dining-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Dining Room\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','c2439c98-2c43-4e98-a5f6-6204c3b3ff38'),
(78,78,1,'Lobby','lobby',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Lobby\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','41d809bc-a5eb-4a95-b941-471706db1278'),
(79,79,1,'Rehab Gym','rehab-gym',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Rehab Gym\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','08d9cdcf-e2b8-499d-991a-65e8dc11fe55'),
(80,80,1,'Patient Room','patient-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Patient Room\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','ec53206f-55ec-409b-aa4f-8bbb9e4e7c27'),
(81,81,1,'Recreation Room','recreation-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Recreation Room\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','486f23d4-61e0-4710-956f-46a188e3eb12'),
(82,82,1,'Dining Room','dining-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Dining Room\"}',1,'2025-04-18 18:17:53','2025-04-18 18:17:53','7a1810e6-4ac9-4d46-b8c2-552a459ea641'),
(86,86,1,'Arbors',NULL,NULL,NULL,1,'2025-04-18 18:31:40','2025-04-18 18:31:40','03ebf2ca-c4ea-4e16-9de9-b0242e9f79dd'),
(96,96,1,'Private & Semi-Private Suites','private-semi-private-suites',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Private & Semi-Private Suites\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','c71d2acd-9750-4f6b-a49a-3111b169a4b3'),
(97,97,1,'Cafe/Restaurant-Style Dining','cafe-restaurant-style-dining',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Cafe/Restaurant-Style Dining\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','925f9a28-9f29-4795-8059-5930c90ac462'),
(98,98,1,'On-Site Beauty Salon and Barbershop','on-site-beauty-salon-and-barbershop',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"On-Site Beauty Salon and Barbershop\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','c7d0ffc2-955a-4f5f-a872-8715a9f60d1b'),
(99,99,1,'Lounges and Guest Areas','lounges-and-guest-areas',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Lounges and Guest Areas\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','a21487a0-f2ad-459e-a492-a1063c80c361'),
(100,100,1,'Courtyard Gardens','courtyard-gardens',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Courtyard Gardens\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','e484b667-dc71-4291-a630-e973dc0abe8f'),
(101,101,1,'Cultural, Educational, Religious and Social Activities','cultural-educational-religious-and-social-activities',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Cultural, Educational, Religious and Social Activities\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','6f7acd1b-a7bd-4ae8-b081-c3e580167794'),
(103,103,1,'Private & Semi-Private Suites','private-semi-private-suites',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Private & Semi-Private Suites\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','7d673778-8823-464b-bd21-df6e11f6e89a'),
(104,104,1,'Cafe/Restaurant-Style Dining','cafe-restaurant-style-dining',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Cafe/Restaurant-Style Dining\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','643b9705-0c1a-4a45-9f57-8b57be3b314a'),
(105,105,1,'On-Site Beauty Salon and Barbershop','on-site-beauty-salon-and-barbershop',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"On-Site Beauty Salon and Barbershop\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','c050a9e6-6d06-4b41-ab41-da655ed72713'),
(106,106,1,'Lounges and Guest Areas','lounges-and-guest-areas',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Lounges and Guest Areas\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','f4d007b1-eaeb-48ec-830a-5623672e9089'),
(107,107,1,'Courtyard Gardens','courtyard-gardens',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Courtyard Gardens\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','b6f5ad8c-632d-44fb-9f8d-09f1231aa63c'),
(108,108,1,'Cultural, Educational, Religious and Social Activities','cultural-educational-religious-and-social-activities',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Cultural, Educational, Religious and Social Activities\"}',1,'2025-04-18 18:36:37','2025-04-18 18:36:37','b4698716-2df2-422b-9aba-9f050b7493e9'),
(111,111,1,'Private & Semi-Private Suites','private-semi-private-suites',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Private & Semi-Private Suites\"}',1,'2025-04-18 18:38:34','2025-04-18 18:38:40','e5324aa5-19f3-4111-a61f-7cc72f98543e'),
(112,112,1,'Private & Semi-Private Suites','private-semi-private-suites',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Private & Semi-Private Suites\"}',1,'2025-04-18 18:38:40','2025-04-18 18:38:40','d16ae44c-e4fa-4a83-9932-beeb15aa46b2'),
(113,113,1,'Cafe/Restaurant-Style Dining','cafe-restaurant-style-dining',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Cafe/Restaurant-Style Dining\"}',1,'2025-04-18 18:38:44','2025-04-18 18:38:46','937f6cdb-d227-447f-8de7-722fde5df432'),
(114,114,1,'Cafe/Restaurant-Style Dining','cafe-restaurant-style-dining',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Cafe/Restaurant-Style Dining\"}',1,'2025-04-18 18:38:46','2025-04-18 18:38:46','544e75cc-573f-48c1-8a76-a4dbf939e30a'),
(115,115,1,'On-Site Beauty Salon and Barbershop','on-site-beauty-salon-and-barbershop',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"On-Site Beauty Salon and Barbershop\"}',1,'2025-04-18 18:38:49','2025-04-18 18:38:51','8d573d2b-d52b-4f2f-9e12-dc1a61db93b1'),
(116,116,1,'On-Site Beauty Salon and Barbershop','on-site-beauty-salon-and-barbershop',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"On-Site Beauty Salon and Barbershop\"}',1,'2025-04-18 18:38:51','2025-04-18 18:38:51','203fcc68-27db-404b-813e-e390508181b3'),
(117,117,1,'Lounges and Guest Areas','lounges-and-guest-areas',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Lounges and Guest Areas\"}',1,'2025-04-18 18:38:54','2025-04-18 18:38:56','abf891a7-bfde-4497-bec2-5fe1a85ceddf'),
(118,118,1,'Lounges and Guest Areas','lounges-and-guest-areas',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Lounges and Guest Areas\"}',1,'2025-04-18 18:38:56','2025-04-18 18:38:56','127f53b0-5f52-4d19-a06f-130a880cbfcb'),
(119,119,1,'Courtyard Gardens','courtyard-gardens',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Courtyard Gardens\"}',1,'2025-04-18 18:38:58','2025-04-18 18:39:00','722544d5-298c-4c8f-a89e-e8aea5d2af4c'),
(120,120,1,'Courtyard Gardens','courtyard-gardens',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Courtyard Gardens\"}',1,'2025-04-18 18:39:00','2025-04-18 18:39:00','946a1839-cc53-4369-b67b-3fbc10d2e03b'),
(121,121,1,'Cultural, Educational, Religious and Social Activities','cultural-educational-religious-and-social-activities',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Cultural, Educational, Religious and Social Activities\"}',1,'2025-04-18 18:39:03','2025-04-18 18:39:04','eaa04ffa-0f62-4e11-abac-b327cf1637b7'),
(122,122,1,'Cultural, Educational, Religious and Social Activities','cultural-educational-religious-and-social-activities',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Cultural, Educational, Religious and Social Activities\"}',1,'2025-04-18 18:39:04','2025-04-18 18:39:04','db20d81f-1849-454e-a583-ee9687cbb9bf'),
(124,124,1,NULL,'__temp_zfbjbdgopvnlqlcaqnwpktdmkecqqmvmugut',NULL,NULL,1,'2025-04-18 18:40:11','2025-04-18 18:40:11','c48ffa44-ae7d-4ff3-90f8-e1e094e30504'),
(131,131,1,'Rated 5 Stars','rated-5-stars-from-centers-for-medicare-medicaid-services',NULL,'{\"5e076972-0a7c-4184-8570-4b3688ebe3d8\": [], \"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"Rated 5 Stars\"}',1,'2025-04-18 18:42:36','2025-09-03 21:57:21','d49bdebb-10e7-4c4a-9981-6b79036a33eb'),
(132,132,1,'Rated 5 Stars in Quality Measures','rated-5-stars-in-quality-measures-from-centers-for-medicare-medicaid-services',NULL,'{\"5e076972-0a7c-4184-8570-4b3688ebe3d8\": [], \"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"Rated 5 Stars in Quality Measures\"}',1,'2025-04-18 18:42:36','2025-09-03 21:57:21','9e1c352a-719a-4e83-b8cd-1b2ab8a24d85'),
(134,134,1,'Rated 5 Stars from Centers for Medicare & Medicaid Services','rated-5-stars-from-centers-for-medicare-medicaid-services',NULL,'{\"36ce0123-f0b8-45e8-bc0a-878a012a385a\": \"Centers for Medicare & Medicaid Services\", \"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"Rated 5 Stars\"}',1,'2025-04-18 18:42:36','2025-04-18 18:42:36','60f1bfd0-49aa-4812-be5a-6b1830e55929'),
(135,135,1,'Rated 5 Stars in Quality Measures from Centers for Medicare & Medicaid Services','rated-5-stars-in-quality-measures-from-centers-for-medicare-medicaid-services',NULL,'{\"36ce0123-f0b8-45e8-bc0a-878a012a385a\": \"Centers for Medicare & Medicaid Services\", \"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"Rated 5 Stars in Quality Measures\"}',1,'2025-04-18 18:42:36','2025-04-18 18:42:36','c6c4e586-f8b5-4357-956d-0485a45bf8f7'),
(136,136,1,'Arbors entrance',NULL,NULL,NULL,1,'2025-04-18 18:44:35','2025-04-18 18:44:35','6625ca81-b1dc-4288-a45c-825ca38c689f'),
(137,137,1,'Arbors room',NULL,NULL,NULL,1,'2025-04-18 18:44:36','2025-04-18 18:44:36','7e95696b-4254-4069-919d-f3f7be1019d4'),
(138,138,1,'Arbors table',NULL,NULL,NULL,1,'2025-04-18 18:44:36','2025-04-18 18:44:36','21e9608c-071d-49dd-9d1e-322bea8e7245'),
(220,220,1,NULL,'__temp_myvhqbghrfcrejjoddsgbwksajddqjmvqfvc',NULL,NULL,1,'2025-04-25 18:32:58','2025-04-25 18:32:58','afec5aca-e422-4cd5-858e-c491ca4004fb'),
(283,283,1,'The Future of  Healthcare is Here','building-a-foundation-of-preventive-care','resources/building-a-foundation-of-preventive-care','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 21:03:21','2025-07-30 23:10:37','f2f7882d-a031-494b-a1cf-5f300cf6d4ae'),
(284,284,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care','resources/building-a-foundation-of-preventive-care','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 21:07:37','2025-07-30 21:07:37','4fcacd07-c9d2-43d1-98f9-ed2b92d94568'),
(285,285,1,'Hands holding',NULL,NULL,NULL,1,'2025-07-30 22:47:59','2025-07-30 22:47:59','f0cadabe-9409-47ba-9d93-3b26e25e7c5e'),
(287,287,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care','resources/building-a-foundation-of-preventive-care','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 22:48:02','2025-07-30 22:48:02','1d067e3f-5ba3-4d80-b864-c9e89df06f3c'),
(288,288,1,'Listen to Us: Voices from  New Jersey’s Nursing Homes','building-a-foundation-of-preventive-care-2','resources/building-a-foundation-of-preventive-care-2','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"news\"}',1,'2025-07-30 22:56:29','2025-07-30 23:10:31','7cbefe44-6dba-44c0-b966-13ff3189c932'),
(289,289,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-2','resources/building-a-foundation-of-preventive-care-2','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 22:56:29','2025-07-30 22:56:29','45d991df-91e6-4553-92ef-5a2bd65c715a'),
(290,290,1,'Innovative Approaches  to Wellness','building-a-foundation-of-preventive-care-3','resources/building-a-foundation-of-preventive-care-3','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"caseStudies\"}',1,'2025-07-30 22:56:32','2025-07-30 23:11:02','74a54fc5-c02f-4181-901f-36c9299eca42'),
(291,291,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-3','resources/building-a-foundation-of-preventive-care-3','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 22:56:32','2025-07-30 22:56:32','fff9e328-aa05-4d69-852e-16f2f61a484a'),
(292,292,1,'Navigating Your Path  to Complete Care','building-a-foundation-of-preventive-care-4','resources/building-a-foundation-of-preventive-care-4','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"videos\"}',1,'2025-07-30 22:56:33','2025-07-30 23:10:55','a39a614c-ffef-4c5e-a60a-d560f705f957'),
(293,293,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-4','resources/building-a-foundation-of-preventive-care-4','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 22:56:33','2025-07-30 22:56:33','7c4c791a-9402-4d6d-89af-9645daa30c01'),
(294,294,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-5','resources/building-a-foundation-of-preventive-care-5','{\"3bd7f129-28a9-4a77-8dac-a592f11fdf61\":\"<h1>Placeholder Text</h1><p>Lorem ipsum dolor sit amet. Rem eaque molestiae est consequuntur consequatur quo necessitatibus corrupti non nihil incidunt nam voluptatibus optio. Est molestias sint et quis commodi sed nemo cupiditate sed quia odio est magni quidem. In nulla tenetur aut doloribus omnis id saepe eius est deserunt nemo ea suscipit repudiandae qui eius ipsa et velit iure. Eos tempora officiis qui rerum Quis et sunt fuga id itaque animi qui voluptatibus eius ea eaque dolorem.</p><h2>Nam voluptates atque et voluptatem sapiente vel quia soluta?</h2><p>Id dicta consequatur ea molestiae libero sed atque vero vel cupiditate similique ab odio laborum sed commodi deserunt. Sed itaque voluptas qui voluptas quidem et consequuntur possimus nam optio enim qui quae culpa quo temporibus accusantium non magni doloribus? Nam quia quis et modi harum in reprehenderit architecto.</p><h3>Ea molestias nostrum est corrupti voluptatem.</h3><p>Aut dolores fugiat ea odio voluptas in excepturi ipsam aut consequatur molestiae et rerum esse vel repudiandae harum. In nostrum quisquam qui fugiat temporibus hic quam labore quo quia labore.</p><h4>Aut nobis iste vel dolor voluptatibus At quis rerum.</h4><p>Ab vero quidem est voluptas suscipit ut facilis dolorem. Ut dolorem expedita vel enim soluta est nihil quos!</p><p>Aut quod tenetur ut excepturi quos.</p><p>Vel illum reprehenderit eum inventore quia qui autem necessitatibus et enim provident aut voluptatibus quibusdam! Aut laboriosam esse et eius ipsum sed corrupti facilis id dolor sequi est distinctio ipsa et porro eius sit quae aperiam!</p><p>Aut rerum eligendi ab tenetur sapiente et magni natus aut rerum quia quo unde similique. Aut nihil odio non molestiae dolorem et quaerat dolorem eos tempore neque aut libero quasi vel rerum quisquam.</p><p>Est rerum eveniet et culpa neque cum vitae quidem. Est expedita dignissimos id molestiae velit eos fugiat deleniti et fugit laboriosam et facilis quidem quo dolore amet non odit repudiandae. Sed sint maiores qui velit sequi et aliquid quam qui earum enim. Hic illo itaque rem ipsa dolore ut fugiat quisquam vel reprehenderit ipsum.</p><p>Et nulla aliquam eos saepe assumenda ut enim nulla! Et nobis dolores est commodi rerum ad facere mollitia ut fuga possimus et deserunt possimus hic pariatur galisum qui voluptates veritatis! Et repudiandae internos ut rerum quasi in nisi autem 33 amet aliquid qui consequatur enim et perferendis obcaecati cum iure numquam. In voluptatibus voluptas ut eaque nihil sed harum rerum 33 inventore voluptatem est dolores reprehenderit qui ullam voluptatem quo sint voluptas.</p>\",\"aceb4af7-e092-4894-a59a-eafca28db8e2\":[285],\"bd5a1d46-6844-4735-ad59-9d17e566aa16\":\"articles\",\"6507c83d-4852-4bbd-9fee-2e10673e660b\":[\"health\",\"rehabilitation\"],\"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\":\"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\"}',1,'2025-07-30 22:56:34','2025-09-05 20:01:55','45de7097-88c9-466b-9b4f-a3b8783a3971'),
(295,295,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-5','resources/building-a-foundation-of-preventive-care-5','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 22:56:34','2025-07-30 22:56:34','4ef4f17b-dcb3-421d-8695-ea43ecea49b7'),
(296,296,1,'Listen to Us: Voices from  New Jersey’s Nursing Homes','building-a-foundation-of-preventive-care-6','resources/building-a-foundation-of-preventive-care-6','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 22:56:35','2025-07-30 23:10:45','90c1a5cf-266c-4ddd-a6d5-23c6419a832d'),
(297,297,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-6','resources/building-a-foundation-of-preventive-care-6','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 22:56:35','2025-07-30 22:56:35','83ffa419-b1b5-41f7-9618-53176c8a7563'),
(299,299,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-2','resources/building-a-foundation-of-preventive-care-2','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"news\"}',1,'2025-07-30 22:58:03','2025-07-30 22:58:03','3057de29-3da2-457c-b67c-9557ff177db2'),
(301,301,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-3','resources/building-a-foundation-of-preventive-care-3','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"caseStudies\"}',1,'2025-07-30 22:58:06','2025-07-30 22:58:06','57dd2e28-faff-4bcc-bfdf-8b34332d0983'),
(303,303,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-4','resources/building-a-foundation-of-preventive-care-4','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"videos\"}',1,'2025-07-30 22:58:10','2025-07-30 22:58:10','df660f59-be9e-4c27-8acd-bae4711ed093'),
(305,305,1,'Listen to Us: Voices from  New Jersey’s Nursing Homes','building-a-foundation-of-preventive-care-2','resources/building-a-foundation-of-preventive-care-2','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"news\"}',1,'2025-07-30 23:10:31','2025-07-30 23:10:31','ff2c2b64-b97e-4b14-999a-281a12d25573'),
(306,306,1,'The Future of  Healthcare is Here','building-a-foundation-of-preventive-care','resources/building-a-foundation-of-preventive-care','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 23:10:37','2025-07-30 23:10:37','f1fae36a-e73b-47e0-968e-53ad17901235'),
(308,308,1,'Listen to Us: Voices from  New Jersey’s Nursing Homes','building-a-foundation-of-preventive-care-6','resources/building-a-foundation-of-preventive-care-6','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 23:10:45','2025-07-30 23:10:45','714424eb-5f13-4f9c-adca-7a30e55d35b1'),
(310,310,1,'Navigating Your Path  to Complete Care','building-a-foundation-of-preventive-care-4','resources/building-a-foundation-of-preventive-care-4','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"videos\"}',1,'2025-07-30 23:10:55','2025-07-30 23:10:55','483fd053-64cc-4b1c-b2aa-c80eef82f602'),
(311,311,1,'Innovative Approaches  to Wellness','building-a-foundation-of-preventive-care-3','resources/building-a-foundation-of-preventive-care-3','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"caseStudies\"}',1,'2025-07-30 23:11:02','2025-07-30 23:11:02','48631e76-edb5-4bb8-b528-988228c21e95'),
(314,314,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-5','resources/building-a-foundation-of-preventive-care-5','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 23:11:29','2025-07-30 23:11:29','efb49a7f-2aa6-4ce4-91f7-c6b390563e8e'),
(315,315,1,'Listen to Us: Voices from  New Jersey’s Nursing Homes','building-a-foundation-of-preventive-care-6','resources/building-a-foundation-of-preventive-care-6','{\"6507c83d-4852-4bbd-9fee-2e10673e660b\": [\"health\", \"rehabilitation\"], \"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\": \"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\", \"aceb4af7-e092-4894-a59a-eafca28db8e2\": [285], \"bd5a1d46-6844-4735-ad59-9d17e566aa16\": \"articles\"}',1,'2025-07-30 23:11:31','2025-07-30 23:11:31','61437214-0f13-4281-83ba-8b9cddb2a74c'),
(318,318,1,NULL,'__temp_hxipjgqmdgxeydrzpenhiustiosvhmgikgji',NULL,NULL,1,'2025-07-31 17:41:05','2025-07-31 17:41:05','11324372-1f08-44da-88e5-56fe9866fe9f'),
(323,323,1,'General Information','general-information',NULL,NULL,1,'2025-08-01 17:59:15','2025-08-01 17:59:31','9e3da0a2-f24f-4874-be97-ba17e5d6cc64'),
(324,324,1,'General Information','general-information',NULL,NULL,1,'2025-08-01 17:59:31','2025-08-01 17:59:31','4f8a18ea-2ac4-48e0-9204-28243fc75673'),
(325,325,1,'What types of care do you provide?','what-types-of-care-do-you-provide',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [329], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We offer a full range of services, including post-acute rehabilitation, skilled nursing care, long-term care, and specialized programs for chronic conditions.\"}',1,'2025-08-01 17:59:34','2025-08-01 18:06:11','eb123de0-1d19-4f3d-adac-357a4111f450'),
(326,326,1,'What types of care do you provide?','what-types-of-care-do-you-provide',NULL,NULL,1,'2025-08-01 17:59:41','2025-08-01 17:59:41','fbd037c9-1246-44d5-b095-13ac24be8ebb'),
(328,328,1,'What types of care do you provide?','what-types-of-care-do-you-provide',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": []}',1,'2025-08-01 17:59:53','2025-08-01 18:17:25','5709cf60-5b44-43c1-9f15-5a0ee198199c'),
(329,329,1,'General Information','general-information',NULL,NULL,1,'2025-08-01 18:04:51','2025-08-01 18:04:54','76eff9af-3a87-4ca1-a36a-245b56f5165e'),
(330,330,1,'General Information','general-information',NULL,NULL,1,'2025-08-01 18:04:57','2025-08-01 18:04:57','9b5b9c59-16e3-4d56-9e6a-2aedd6b93e77'),
(331,331,1,'Admission Process','admission-process',NULL,NULL,1,'2025-08-01 18:04:57','2025-08-01 18:05:00','9d164f62-464e-4a37-bc85-90cba1372573'),
(332,332,1,'Admission Process','admission-process',NULL,NULL,1,'2025-08-01 18:05:01','2025-08-01 18:05:01','a199e56c-405d-491b-aa96-083651314753'),
(333,333,1,'Care and Services','care-and-services',NULL,NULL,1,'2025-08-01 18:05:01','2025-08-01 18:05:04','4762a1f6-e5fc-4552-9bfd-8b0eff677f3f'),
(334,334,1,'Care and Services','care-and-services',NULL,NULL,1,'2025-08-01 18:05:04','2025-08-01 18:05:04','f98e7aa0-29d0-4688-96fd-261abbc2e32f'),
(335,335,1,'Amenities and Lifestyle','amenities-and-lifestyle',NULL,NULL,1,'2025-08-01 18:05:04','2025-08-01 18:05:07','ef5f3f2d-4700-47dd-98c0-d4c09c1ac754'),
(336,336,1,'Amenities and Lifestyle','amenities-and-lifestyle',NULL,NULL,1,'2025-08-01 18:05:08','2025-08-01 18:05:08','846244b8-15d3-4e5d-95c5-4a52d37b055f'),
(337,337,1,'Visitation and Communication','visitation-and-communication',NULL,NULL,1,'2025-08-01 18:05:08','2025-08-01 18:05:10','5ad8c719-3334-44ea-9482-655315980f8b'),
(338,338,1,'Visitation and Communication','visitation-and-communication',NULL,NULL,1,'2025-08-01 18:05:10','2025-08-01 18:05:10','36fd4abf-c566-4141-bc2d-c0483e4c5508'),
(339,339,1,'Family Support & Involvement','family-support-involvement',NULL,NULL,1,'2025-08-01 18:05:10','2025-08-01 18:05:14','f460074b-0174-4fb4-8ec1-b9e8a36d98c4'),
(340,340,1,'Family Support & Involvement','family-support-involvement',NULL,NULL,1,'2025-08-01 18:05:15','2025-08-01 18:05:15','dd124a39-9d3a-4f1a-a5d8-0edb78d033b2'),
(341,341,1,'Financial Information','financial-information',NULL,NULL,1,'2025-08-01 18:05:15','2025-08-01 18:05:18','0210ddb8-dbce-41a6-853a-049cfd715d52'),
(342,342,1,'Financial Information','financial-information',NULL,NULL,1,'2025-08-01 18:05:18','2025-08-01 18:05:18','5f3d36c6-52e6-43c4-9b68-005e1157d136'),
(343,343,1,'Discharge and Transition','discharge-and-transition',NULL,NULL,1,'2025-08-01 18:05:18','2025-08-01 18:05:21','32416cbb-fd0a-4c33-b53e-58337c37d554'),
(344,344,1,'Discharge and Transition','discharge-and-transition',NULL,NULL,1,'2025-08-01 18:05:21','2025-08-01 18:05:21','02359400-f853-4fae-83cb-305b0fe80d41'),
(347,347,1,'What types of care do you provide?','what-types-of-care-do-you-provide',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [329], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We offer a full range of services, including post-acute rehabilitation, skilled nursing care, long-term care, and specialized programs for chronic conditions.\"}',1,'2025-08-01 18:06:11','2025-08-01 18:06:11','b47b4397-9a4e-4592-8815-b49bcf50422f'),
(348,348,1,'What is post-acute care?','what-is-post-acute-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [329], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Post-acute care provides short-term medical and rehabilitative services following a hospital stay. Our goal is to help patients regain strength, mobility, and independence before returning home.\"}',1,'2025-08-01 18:06:11','2025-08-01 18:06:20','d064bdeb-efc9-46fe-80ee-2050381004db'),
(349,349,1,'What is post-acute care?','what-is-post-acute-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [329], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Post-acute care provides short-term medical and rehabilitative services following a hospital stay. Our goal is to help patients regain strength, mobility, and independence before returning home.\"}',1,'2025-08-01 18:06:22','2025-08-01 18:06:22','1dde8933-9a09-47d4-93d9-e94ffc65c73b'),
(350,350,1,'How do I know if my loved one needs long-term care?','how-do-i-know-if-my-loved-one-needs-long-term-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [329], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Long-term care may be appropriate if your loved one requires ongoing medical care, assistance with daily activities, or specialized support for chronic conditions. Our team can guide you through the evaluation process.\"}',1,'2025-08-01 18:06:22','2025-08-01 18:06:39','81a41349-e384-49e2-8df0-711fee9255d4'),
(351,351,1,'How do I know if my loved one needs long-term care?','how-do-i-know-if-my-loved-one-needs-long-term-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [329], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Long-term care may be appropriate if your loved one requires ongoing medical care, assistance with daily activities, or specialized support for chronic conditions. Our team can guide you through the evaluation process.\"}',1,'2025-08-01 18:06:40','2025-08-01 18:06:40','facf9f24-f572-4f7c-89d8-48ec80b6a169'),
(352,352,1,'How do I start the admissions process?','how-do-i-start-the-admissions-process',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Contact our admissions team at 877-4CCADMIT (877-422-3648). We’ll walk you through the process, answer questions, and help gather necessary medical information.\"}',1,'2025-08-01 18:07:13','2025-08-01 18:07:24','541f8e10-335d-4483-986b-9b89a206e2b8'),
(353,353,1,'How do I start the admissions process?','how-do-i-start-the-admissions-process',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Contact our admissions team at 877-4CCADMIT (877-422-3648). We’ll walk you through the process, answer questions, and help gather necessary medical information.\"}',1,'2025-08-01 18:07:25','2025-08-01 18:07:25','50b34fa8-18c0-4f6d-a470-cab212a1c6da'),
(354,354,1,'What sort of paperwork is required?','what-sort-of-paperwork-is-required',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"An admission agreement and documents pertaining to it, such as insurance cards, will need to be completed by either the patient or responsible party within 48 hours of admission.\"}',1,'2025-08-01 18:07:25','2025-08-01 18:07:34','23e41724-d101-469b-b0df-eb5de6fb5de1'),
(355,355,1,'What sort of paperwork is required?','what-sort-of-paperwork-is-required',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"An admission agreement and documents pertaining to it, such as insurance cards, will need to be completed by either the patient or responsible party within 48 hours of admission.\"}',1,'2025-08-01 18:07:35','2025-08-01 18:07:35','8db8d349-7542-4394-a7ac-45f4a29f5514'),
(356,356,1,'Can I tour the facility before making a decision?','can-i-tour-the-facility-before-making-a-decision',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Absolutely! We encourage families to visit and meet our team. Contact us to schedule a tour at your convenience.\"}',1,'2025-08-01 18:07:35','2025-08-01 18:07:46','105f558f-f175-4761-a758-600659919398'),
(357,357,1,'Can I tour the facility before making a decision?','can-i-tour-the-facility-before-making-a-decision',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Absolutely! We encourage families to visit and meet our team. Contact us to schedule a tour at your convenience.\"}',1,'2025-08-01 18:07:48','2025-08-01 18:07:48','913cf0ee-4250-4b9b-aae9-44c5f89fc6fe'),
(358,358,1,'What should I bring when my loved one is admitted?','what-should-i-bring-when-my-loved-one-is-admitted',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Recommended items include comfortable clothing, sneakers, toiletries, assistive devices (like hearing aids or glasses), and personal items that bring comfort. We suggest labeling personal items prior to admission. You can also bring change for the vending machines, and any electronics or personal devices to keep you busy. Our admissions team can provide a detailed checklist.\"}',1,'2025-08-01 18:07:51','2025-08-01 18:07:57','6eaa43d3-6eb6-4e28-a82e-52c9e6ae7c88'),
(359,359,1,'What should I bring when my loved one is admitted?','what-should-i-bring-when-my-loved-one-is-admitted',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Recommended items include comfortable clothing, sneakers, toiletries, assistive devices (like hearing aids or glasses), and personal items that bring comfort. We suggest labeling personal items prior to admission. You can also bring change for the vending machines, and any electronics or personal devices to keep you busy. Our admissions team can provide a detailed checklist.\"}',1,'2025-08-01 18:07:58','2025-08-01 18:07:58','575fd055-adf8-4dc4-910a-d22a5dd45021'),
(360,360,1,'What will admission day look like?','what-will-admission-day-look-like',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"On the day of admission, a team member will greet your loved one, review their medications and care needs, and help them settle into their room. You may meet a nurse, aide, and therapy staff. We encourage you to bring personal items for comfort and stay as long or as briefly as feels right for your family.\"}',1,'2025-08-01 18:08:01','2025-08-01 18:08:07','3d4bdaf0-4ce4-4494-90de-7caee9dffb59'),
(361,361,1,'What will admission day look like?','what-will-admission-day-look-like',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"On the day of admission, a team member will greet your loved one, review their medications and care needs, and help them settle into their room. You may meet a nurse, aide, and therapy staff. We encourage you to bring personal items for comfort and stay as long or as briefly as feels right for your family.\"}',1,'2025-08-01 18:08:08','2025-08-01 18:08:08','25886786-9135-4d1d-bbec-8adb6a441bd5'),
(362,362,1,'Will someone contact me after admission?','will-someone-contact-me-after-admission',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Yes. A staff member will reach out within the first 24 hours to let you know how your loved one is settling in and answer any questions. You’ll also receive contact information for the care team.\"}',1,'2025-08-01 18:08:10','2025-08-01 18:08:17','33262c25-6a12-4f52-89dd-2a312c5ca8ae'),
(363,363,1,'Will someone contact me after admission?','will-someone-contact-me-after-admission',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Yes. A staff member will reach out within the first 24 hours to let you know how your loved one is settling in and answer any questions. You’ll also receive contact information for the care team.\"}',1,'2025-08-01 18:08:17','2025-08-01 18:08:17','1bbe3096-20c5-4374-9578-0d22ae3bbc14'),
(364,364,1,'What if my loved one moves from rehab to long-term care?','what-if-my-loved-one-moves-from-rehab-to-long-term-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"If care needs change, we’ll communicate with you in advance and help you understand the difference in routine and care. A new room and unit may be assigned, and you’ll be introduced to the new team. We’ll support both your loved one and your family through the transition.\"}',1,'2025-08-01 18:08:21','2025-08-01 18:08:28','b6e374fe-6d2d-496d-96a4-4238c12949d7'),
(365,365,1,'What if my loved one moves from rehab to long-term care?','what-if-my-loved-one-moves-from-rehab-to-long-term-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [331], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"If care needs change, we’ll communicate with you in advance and help you understand the difference in routine and care. A new room and unit may be assigned, and you’ll be introduced to the new team. We’ll support both your loved one and your family through the transition.\"}',1,'2025-08-01 18:08:31','2025-08-01 18:08:31','1348e4fb-bbf7-4433-8b74-40c1f8290302'),
(366,366,1,'What rehabilitation services are available?','what-rehabilitation-services-are-available',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We offer physical, occupational, and speech therapy to support recovery and independence. Our team customizes care plans based on individual needs and goals.\"}',1,'2025-08-01 18:08:41','2025-08-01 18:09:00','242787e4-e2a9-4d79-97dd-5780fbfcab09'),
(367,367,1,'What rehabilitation services are available?','what-rehabilitation-services-are-available',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We offer physical, occupational, and speech therapy to support recovery and independence. Our team customizes care plans based on individual needs and goals.\"}',1,'2025-08-01 18:09:02','2025-08-01 18:09:02','3c1bb662-81b7-47de-aad7-cec9d3463dd1'),
(368,368,1,'How soon does therapy begin?','how-soon-does-therapy-begin',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Our goal is to have therapy sessions start within 24 hours of admission, based on individual care plans. Therapy is offered up to seven days a week.\"}',1,'2025-08-01 18:09:02','2025-08-01 18:09:11','99c7a035-dbc1-450c-a3cc-3f4c5d2d8447'),
(369,369,1,'How soon does therapy begin?','how-soon-does-therapy-begin',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Our goal is to have therapy sessions start within 24 hours of admission, based on individual care plans. Therapy is offered up to seven days a week.\"}',1,'2025-08-01 18:09:12','2025-08-01 18:09:12','32095f8d-472e-46c2-a2d0-7177ab17fe1f'),
(370,370,1,'How do I know when therapy or care tasks are scheduled?','how-do-i-know-when-therapy-or-care-tasks-are-scheduled',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"You can request a basic daily routine to help you plan visits around therapy, meals, or rest. While times vary, we’re happy to help you avoid interruptions to care.\"}',1,'2025-08-01 18:09:12','2025-08-01 18:09:32','4bbe9769-bfec-4943-98de-aa5e952b47c5'),
(371,371,1,'How do I know when therapy or care tasks are scheduled?','how-do-i-know-when-therapy-or-care-tasks-are-scheduled',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"You can request a basic daily routine to help you plan visits around therapy, meals, or rest. While times vary, we’re happy to help you avoid interruptions to care.\"}',1,'2025-08-01 18:09:33','2025-08-01 18:09:33','5ae40a3c-9884-4a66-a784-d260f1a80648'),
(372,372,1,'How is medical care managed during a stay?','how-is-medical-care-managed-during-a-stay',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Our medical team coordinates closely with physicians, specialists, and your loved one’s care providers to ensure seamless care and communication.\"}',1,'2025-08-01 18:09:33','2025-08-01 18:09:44','be78260c-ac89-46e8-bf20-3714f8152e70'),
(373,373,1,'How is medical care managed during a stay?','how-is-medical-care-managed-during-a-stay',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Our medical team coordinates closely with physicians, specialists, and your loved one’s care providers to ensure seamless care and communication.\"}',1,'2025-08-01 18:09:44','2025-08-01 18:09:44','59ed0b82-2e2e-4f7e-8565-1f1639ac362c'),
(374,374,1,'Are family members involved in care planning?','are-family-members-involved-in-care-planning',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Yes! We believe family involvement is key to successful outcomes. We encourage open communication and invite families to participate in care discussions.\"}',1,'2025-08-01 18:09:44','2025-08-01 18:09:56','c1f4e248-c707-4f06-9f18-6e81892c8a75'),
(375,375,1,'Are family members involved in care planning?','are-family-members-involved-in-care-planning',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Yes! We believe family involvement is key to successful outcomes. We encourage open communication and invite families to participate in care discussions.\"}',1,'2025-08-01 18:10:00','2025-08-01 18:10:00','97ae3653-ead1-4728-8ab1-bc4ebb3d4c3e'),
(376,376,1,'How do you personalize care plans?','how-do-you-personalize-care-plans',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Each resident receives a full assessment, allowing us to create a customized care plan that evolves with their needs. By coordinating with a network of providers and specialists, we ensure every resident receives the best care possible.\"}',1,'2025-08-01 18:10:00','2025-08-01 18:10:07','484e0cbe-6f66-4d7d-a8bf-46d488961982'),
(377,377,1,'How do you personalize care plans?','how-do-you-personalize-care-plans',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Each resident receives a full assessment, allowing us to create a customized care plan that evolves with their needs. By coordinating with a network of providers and specialists, we ensure every resident receives the best care possible.\"}',1,'2025-08-01 18:10:07','2025-08-01 18:10:07','3de691ae-4190-4442-9e3f-2e653f0858f3'),
(378,378,1,'Who do I contact if I have concerns about care?','who-do-i-contact-if-i-have-concerns-about-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"You can speak to the unit manager or social worker assigned to your loved one’s care. If needed, our administrator is also available. We take every concern seriously and follow up within 24 hours.\"}',1,'2025-08-01 18:10:07','2025-08-01 18:10:17','a2b0836a-a045-47da-b383-5712581d3a93'),
(379,379,1,'Who do I contact if I have concerns about care?','who-do-i-contact-if-i-have-concerns-about-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"You can speak to the unit manager or social worker assigned to your loved one’s care. If needed, our administrator is also available. We take every concern seriously and follow up within 24 hours.\"}',1,'2025-08-01 18:10:18','2025-08-01 18:10:18','46606543-82f1-454b-9679-833d5f761f31'),
(380,380,1,'What happens if my loved one has a fall or incident?','what-happens-if-my-loved-one-has-a-fall-or-incident',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"You will be contacted right away by a nurse or unit manager. We’ll explain what happened, how your loved one is doing, and what actions are being taken.\"}',1,'2025-08-01 18:10:18','2025-08-01 18:10:27','de4f3e14-9713-4a38-9c3d-b21254d4636b'),
(381,381,1,'What happens if my loved one has a fall or incident?','what-happens-if-my-loved-one-has-a-fall-or-incident',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [333], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"You will be contacted right away by a nurse or unit manager. We’ll explain what happened, how your loved one is doing, and what actions are being taken.\"}',1,'2025-08-01 18:10:31','2025-08-01 18:10:31','d1b4a5a9-8d61-4433-9e7b-f6d8f5df72dd'),
(382,382,1,'What amenities are available to residents?','what-amenities-are-available-to-residents',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [335], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Our amenities include dining services, social activities, therapy spaces, outdoor areas, and personalized recreational programs designed to keep residents engaged and comfortable.\"}',1,'2025-08-01 18:10:45','2025-08-01 18:10:52','975a110e-a62f-4292-9243-27125e025aff'),
(383,383,1,'What amenities are available to residents?','what-amenities-are-available-to-residents',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [335], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Our amenities include dining services, social activities, therapy spaces, outdoor areas, and personalized recreational programs designed to keep residents engaged and comfortable.\"}',1,'2025-08-01 18:10:53','2025-08-01 18:10:53','ea88c5b1-3144-481e-aafe-0d49624ff1c1'),
(384,384,1,'Can residents personalize their rooms?','can-residents-personalize-their-rooms',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [335], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Absolutely! We encourage residents to bring familiar items from home to create a comfortable and personalized space.\"}',1,'2025-08-01 18:10:57','2025-08-01 18:11:03','55cbb58f-d753-4216-a166-a712b1566fa4'),
(385,385,1,'Can residents personalize their rooms?','can-residents-personalize-their-rooms',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [335], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Absolutely! We encourage residents to bring familiar items from home to create a comfortable and personalized space.\"}',1,'2025-08-01 18:11:04','2025-08-01 18:11:04','861b3159-20ea-4a53-85cf-f5d1194fddcb'),
(386,386,1,'Are there activities for residents?','are-there-activities-for-residents',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [335], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Absolutely! We offer a variety of activities and programs designed to engage residents and promote social interaction. Learn more about our beautiful locations.\"}',1,'2025-08-01 18:11:07','2025-08-01 18:11:16','75861510-eccd-4bf8-bb5f-5360666593c4'),
(387,387,1,'Are there activities for residents?','are-there-activities-for-residents',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [335], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Absolutely! We offer a variety of activities and programs designed to engage residents and promote social interaction. Learn more about our beautiful locations.\"}',1,'2025-08-01 18:11:17','2025-08-01 18:11:17','292d25cb-d092-48b3-a896-bd1058a24ab2'),
(388,388,1,'Do residents need money for anything?','do-residents-need-money-for-anything',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [335], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Residents don’t need much, but we recommend bringing a small amount of spending money for things like vending machine snacks or occasional personal care services like haircuts or shaves.\"}',1,'2025-08-01 18:11:20','2025-08-01 18:11:27','278fda72-3b9f-44e5-a24f-d76f2f033d46'),
(389,389,1,'Do residents need money for anything?','do-residents-need-money-for-anything',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [335], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Residents don’t need much, but we recommend bringing a small amount of spending money for things like vending machine snacks or occasional personal care services like haircuts or shaves.\"}',1,'2025-08-01 18:11:31','2025-08-01 18:11:31','e6519a58-f4b9-4b53-9694-a194792632c2'),
(390,390,1,'What are your visitation policies?','what-are-your-visitation-policies',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [337], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We welcome visitors and strive to provide flexible visitation hours. Please contact us for current guidelines to ensure a safe environment for all.\"}',1,'2025-08-01 18:11:35','2025-08-01 18:11:47','6b6e94e6-3e40-4134-8b19-e64339b1402c'),
(391,391,1,'What are your visitation policies?','what-are-your-visitation-policies',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [337], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We welcome visitors and strive to provide flexible visitation hours. Please contact us for current guidelines to ensure a safe environment for all.\"}',1,'2025-08-01 18:11:48','2025-08-01 18:11:48','c7890ab9-a810-4140-8251-e1d10d26c1e3'),
(392,392,1,'When is the best time to visit?','when-is-the-best-time-to-visit',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [337], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Mid-morning and early afternoons tend to be best. We suggest avoiding therapy hours and personal care times like bathing or rest periods. Our staff can help guide you based on your loved one’s schedule.\"}',1,'2025-08-01 18:11:48','2025-08-01 18:12:01','063c4668-66cb-40d8-bb84-056718bcb666'),
(393,393,1,'When is the best time to visit?','when-is-the-best-time-to-visit',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [337], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Mid-morning and early afternoons tend to be best. We suggest avoiding therapy hours and personal care times like bathing or rest periods. Our staff can help guide you based on your loved one’s schedule.\"}',1,'2025-08-01 18:12:02','2025-08-01 18:12:02','f8d01b77-6f3c-4083-b5b7-d107e4895964'),
(394,394,1,'How can I stay informed about my loved one’s care?','how-can-i-stay-informed-about-my-loved-ones-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [337], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Our team is committed to open communication. We provide regular updates and are always available to discuss care plans and progress.\"}',1,'2025-08-01 18:12:03','2025-08-01 18:12:13','e47dd7f2-4d32-4d1e-a466-ffc5a3d4acbf'),
(395,395,1,'How can I stay informed about my loved one’s care?','how-can-i-stay-informed-about-my-loved-ones-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [337], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Our team is committed to open communication. We provide regular updates and are always available to discuss care plans and progress.\"}',1,'2025-08-01 18:12:14','2025-08-01 18:12:14','83146ecd-077e-4bf0-9867-80b555221722'),
(396,396,1,'Who gets updates about care?','who-gets-updates-about-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [337], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We can communicate with more than one family member. If multiple contacts are listed, we encourage group emails or calls to keep everyone in the loop. Let us know who should be included.\"}',1,'2025-08-01 18:12:14','2025-08-01 18:12:23','55356885-f72f-457f-9031-d5fb8ff72f44'),
(397,397,1,'Who gets updates about care?','who-gets-updates-about-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [337], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We can communicate with more than one family member. If multiple contacts are listed, we encourage group emails or calls to keep everyone in the loop. Let us know who should be included.\"}',1,'2025-08-01 18:12:26','2025-08-01 18:12:26','23be0205-cbd0-4e8c-b999-3792b4a8e093'),
(398,398,1,'Can our family pet come for a visit?','can-our-family-pet-come-for-a-visit',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [337], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Yes! We may request vaccination records, and some breed restrictions may apply. Please ask our administrator for more details. Additionally, most centers offer pet therapy because we understand how valuable time with animals can be to emotional and mental health.\"}',1,'2025-08-01 18:12:26','2025-08-01 18:12:33','6dc3b276-8782-4fd5-8c5e-b509c07ac6c0'),
(399,399,1,'Can our family pet come for a visit?','can-our-family-pet-come-for-a-visit',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [337], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Yes! We may request vaccination records, and some breed restrictions may apply. Please ask our administrator for more details. Additionally, most centers offer pet therapy because we understand how valuable time with animals can be to emotional and mental health.\"}',1,'2025-08-01 18:12:34','2025-08-01 18:12:34','fd0ec9cd-9f7c-4d0d-9195-a81c7f3da5be'),
(400,400,1,'What should I expect emotionally during the first few days?','what-should-i-expect-emotionally-during-the-first-few-days',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [339], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"It’s completely normal to feel overwhelmed. Your loved one may seem confused, anxious, or withdrawn at first. Our team is here to support both the patient and the family through this transition.\"}',1,'2025-08-01 18:12:46','2025-08-01 18:12:56','2444b37b-c098-43ee-82b4-f4ad2d62f5c1'),
(401,401,1,'What should I expect emotionally during the first few days?','what-should-i-expect-emotionally-during-the-first-few-days',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [339], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"It’s completely normal to feel overwhelmed. Your loved one may seem confused, anxious, or withdrawn at first. Our team is here to support both the patient and the family through this transition.\"}',1,'2025-08-01 18:12:57','2025-08-01 18:12:57','63548e7a-78d3-4f77-8416-84d6e7a80331'),
(402,402,1,'How can I help my loved one adjust?','how-can-i-help-my-loved-one-adjust',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [339], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Familiar items from home, consistent visits, and staying positive can help. We’re happy to suggest personalized ways to support your loved one’s adjustment.\"}',1,'2025-08-01 18:12:57','2025-08-01 18:13:06','299f9183-b60c-465e-a139-0718f0ab995f'),
(403,403,1,'How can I help my loved one adjust?','how-can-i-help-my-loved-one-adjust',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [339], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Familiar items from home, consistent visits, and staying positive can help. We’re happy to suggest personalized ways to support your loved one’s adjustment.\"}',1,'2025-08-01 18:13:07','2025-08-01 18:13:07','d8366d4d-5af6-4969-9d16-9c10a2f9f75a'),
(404,404,1,'What if I feel unprepared or have questions later?','what-if-i-feel-unprepared-or-have-questions-later',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [339], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"You’re not alone. Our social workers and care team are always available to answer questions, even after admission. Don’t hesitate to ask.\"}',1,'2025-08-01 18:13:07','2025-08-01 18:13:19','63ee28d0-b009-44a7-8284-538e716e8694'),
(405,405,1,'What if I feel unprepared or have questions later?','what-if-i-feel-unprepared-or-have-questions-later',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [339], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"You’re not alone. Our social workers and care team are always available to answer questions, even after admission. Don’t hesitate to ask.\"}',1,'2025-08-01 18:13:20','2025-08-01 18:13:20','4662d269-8443-48d3-87bb-5ab1ce3e7bfb'),
(406,406,1,'What insurance plans do you accept?','what-insurance-plans-do-you-accept',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [341], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We accept a variety of insurance plans, including Medicare, Medicaid, and private insurance. Contact our business office to discuss coverage and payment options.\"}',1,'2025-08-01 18:13:20','2025-08-01 18:13:30','9e31aa6a-3511-457a-85c1-1ea00f399de3'),
(407,407,1,'What insurance plans do you accept?','what-insurance-plans-do-you-accept',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [341], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We accept a variety of insurance plans, including Medicare, Medicaid, and private insurance. Contact our business office to discuss coverage and payment options.\"}',1,'2025-08-01 18:13:33','2025-08-01 18:13:33','ed01d9fb-467a-49df-9b82-772d3abb883f'),
(408,408,1,'What if insurance coverage ends but my loved one still needs care?','what-if-insurance-coverage-ends-but-my-loved-one-still-needs-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [341], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We offer flexible private pay options at discounted rates to ensure continued care and recovery. Our team can discuss available options with you.\"}',1,'2025-08-01 18:13:33','2025-08-01 18:13:42','374b90d4-5ffd-410e-bd96-a94d06fa6499'),
(409,409,1,'What if insurance coverage ends but my loved one still needs care?','what-if-insurance-coverage-ends-but-my-loved-one-still-needs-care',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [341], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We offer flexible private pay options at discounted rates to ensure continued care and recovery. Our team can discuss available options with you.\"}',1,'2025-08-01 18:13:42','2025-08-01 18:13:42','861c1478-b067-4a4d-863a-27634b5f48a5'),
(410,410,1,'What happens if my loved one’s needs change and they stay longer than expected?','what-happens-if-my-loved-ones-needs-change-and-they-stay-longer-than-expected',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [343], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Our care team will review their progress and discuss whether long-term care is appropriate. We’ll guide you through the decision-making process and next steps, emotionally and logistically.\"}',1,'2025-08-01 18:13:42','2025-08-01 18:13:52','ee0a8f09-e4cf-4033-9e0c-cc7db4224238'),
(411,411,1,'What happens if my loved one’s needs change and they stay longer than expected?','what-happens-if-my-loved-ones-needs-change-and-they-stay-longer-than-expected',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [343], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Our care team will review their progress and discuss whether long-term care is appropriate. We’ll guide you through the decision-making process and next steps, emotionally and logistically.\"}',1,'2025-08-01 18:13:53','2025-08-01 18:13:53','fc6efb02-1364-4d01-b9c6-0983e5c6f017'),
(412,412,1,'How do you support residents when they are ready to return home?','how-do-you-support-residents-when-they-are-ready-to-return-home',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [343], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We create personalized discharge plans that may include home health resources, therapy recommendations, and education to ensure a smooth and confident transition home.\"}',1,'2025-08-01 18:13:53','2025-08-01 18:14:03','fd650f4f-2a9c-4ff6-98fc-1b483cf372cd'),
(413,413,1,'How do you support residents when they are ready to return home?','how-do-you-support-residents-when-they-are-ready-to-return-home',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [343], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"We create personalized discharge plans that may include home health resources, therapy recommendations, and education to ensure a smooth and confident transition home.\"}',1,'2025-08-01 18:14:03','2025-08-01 18:14:03','3a693ddf-565f-4aa8-8677-585b95178a98'),
(414,414,1,'Can my loved one return if they need more care after discharge?','can-my-loved-one-return-if-they-need-more-care-after-discharge',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [343], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Yes! We welcome returning patients for additional rehabilitation, care support, or respite services as needed.\"}',1,'2025-08-01 18:14:03','2025-08-01 18:14:11','3ced3d03-d4b3-4829-b118-3df0a465f08c'),
(415,415,1,'Can my loved one return if they need more care after discharge?','can-my-loved-one-return-if-they-need-more-care-after-discharge',NULL,'{\"77b43f80-b3db-4c4a-a697-e7337b02c937\": [343], \"ba4b9e07-f61a-405f-8896-aa42437b9c53\": \"Yes! We welcome returning patients for additional rehabilitation, care support, or respite services as needed.\"}',1,'2025-08-01 18:14:13','2025-08-01 18:14:13','ecad96ea-774f-4de2-9f7a-b36900413bdf'),
(420,420,1,'Rated 5 Stars from Centers for Medicare & Medicaid Services','rated-5-stars-from-centers-for-medicare-medicaid-services',NULL,'{\"36ce0123-f0b8-45e8-bc0a-878a012a385a\": \"Centers for Medicare & Medicaid Services\", \"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"Rated 5 Stars\"}',1,'2025-08-20 17:56:29','2025-08-20 17:56:29','0b9feaaf-9646-4e97-aa3c-d7cac4d4307c'),
(421,421,1,'Rated 5 Stars in Quality Measures from Centers for Medicare & Medicaid Services','rated-5-stars-in-quality-measures-from-centers-for-medicare-medicaid-services',NULL,'{\"36ce0123-f0b8-45e8-bc0a-878a012a385a\": \"Centers for Medicare & Medicaid Services\", \"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"Rated 5 Stars in Quality Measures\"}',1,'2025-08-20 17:56:29','2025-08-20 17:56:29','d8a81d4e-f8dd-4e52-9b57-42dfe0cdadb1'),
(426,426,1,'Robert A.','robert-a',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Robert A.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"We recently had to decide to place Mom in a nursing facility as she could no longer take care of herself. It is a difficult decision to make and choosing Complete Care at Arbors was the very best decision our family made. Mom is content and feels very safe and comfortable. The staff is very attentive, loving and provides excellent care. She is so happy and is thriving under their care. We are so pleased with everything that they do to make our Mom feel like she is home and appreciate all that they do each and every day.\"}',1,'2025-08-20 17:56:29','2025-08-20 17:56:29','e2842050-3e51-442e-8424-0929793b6102'),
(427,427,1,'Bernadette M.','bernadette-m',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Bernadette M.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"Our family never thought that we would have to place my dad in a nursing home. The time came to make this difficult decision, we are so happy that we placed him at Complete Care at Arbors. The facility is beautiful and he felt right at home, the staff treated him like family.\"}',1,'2025-08-20 17:56:29','2025-08-20 17:56:29','f01f08ce-c631-45e0-a79b-b4fecc4cc666'),
(428,428,1,'Mary O.','mary-o',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Mary O.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"In the last year our family needed rehab care my father in law. We were very pleased to be able to have him come to Complete Care at Arbors. The care was exceptional from the food to the therapy department to the nursing staff, everyone was pleasant and attentive. He rehabbed quickly and was discharged in better shape than before his illness. We would recommend Complete Care at Arbors to anyone looking for a clean home-like environment for their loved ones.\"}',1,'2025-08-20 17:56:29','2025-08-20 17:56:29','ebbfbd29-859b-478e-9e55-e69e7afb93ee'),
(429,429,1,'Lobby','lobby',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Lobby\"}',1,'2025-08-20 17:56:29','2025-08-20 17:56:29','4fc6a3ba-d3c9-4d9b-a58b-dca0a35ac8e4'),
(430,430,1,'Rehab Gym','rehab-gym',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Rehab Gym\"}',1,'2025-08-20 17:56:29','2025-08-20 17:56:29','ef49d8f7-8d52-4edf-8b5c-b43abf090f36'),
(431,431,1,'Patient Room','patient-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Patient Room\"}',1,'2025-08-20 17:56:29','2025-08-20 17:56:29','34ce5d32-a2fd-4685-a807-6d1990bcf5a4'),
(432,432,1,'Recreation Room','recreation-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Recreation Room\"}',1,'2025-08-20 17:56:29','2025-08-20 17:56:29','23718903-fffb-4771-acff-97d2f5fd3099'),
(433,433,1,'Dining Room','dining-room',NULL,'{\"75178903-a74b-4511-99f4-4fd13bced6e0\": \"Dining Room\"}',1,'2025-08-20 17:56:29','2025-08-20 17:56:29','2fda665e-3dbd-4cd3-b9e1-4f004669ba9f'),
(445,445,1,'Ashley Lewis','ashley-lewis',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\": \"Ashley Lewis\", \"50d484f9-ea00-4870-8b7a-a1c7400f42ab\": [634]}',1,'2025-08-20 21:24:25','2025-09-03 22:27:30','5784c4d7-577c-49f3-9f0e-7be11f765743'),
(452,452,1,'Rehabilitation Program','cardiac-care',NULL,NULL,1,'2025-08-20 21:57:06','2025-08-20 21:57:06','28bec844-2b06-4abc-b323-f4952010739a'),
(453,453,1,'Rehabilitation Program','rehabilitation-program',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"We provide extensive rehabilitation services up to seven days a week, tailored to individual needs and goals. In order to help progress and recovery, we adjust therapies based on the patient’s abilities and tolerance so their quality of life can continue to improve after transitioning home.\"}',1,'2025-08-20 21:57:13','2025-08-20 21:57:20','71b082bb-85b8-4cab-8be0-c07fc955d9d1'),
(454,454,1,'Rehabilitation Program','rehabilitation-program',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"We provide extensive rehabilitation services up to seven days a week, tailored to individual needs and goals. In order to help progress and recovery, we adjust therapies based on the patient’s abilities and tolerance so their quality of life can continue to improve after transitioning home.\"}',1,'2025-08-20 21:57:20','2025-08-20 21:57:20','ec496528-1786-409f-bfb1-1ae87e16d57e'),
(455,455,1,'Physical Therapy','physical-therapy',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Physical therapy focuses on improving mobility, strength, and coordination, helping patients recover from surgery, injury, or illness.\"}',1,'2025-08-20 21:57:25','2025-08-20 21:57:31','6d41e3ac-a19b-4b3f-bcbb-7e21bf869540'),
(456,456,1,'Physical Therapy','physical-therapy',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Physical therapy focuses on improving mobility, strength, and coordination, helping patients recover from surgery, injury, or illness.\"}',1,'2025-08-20 21:57:32','2025-08-20 21:57:32','519d273e-d91c-46dd-be1f-e7b40d0994c5'),
(457,457,1,'Occupational Therapy','occupational-therapy',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Occupational therapy addresses important everyday living skills, like getting dressed, bathing, cooking, going to work, or taking care of oneself and one’s home—especially if an illness, injury, disability, or aging makes those tasks harder. Occupational therapy focuses more on “fine motor skills”, which are critically important for independence in daily life and include the small movements we make using the tiny muscles in our hands and fingers. These skills help us do everyday tasks that require precision and coordination, for example, buttoning a shirt, using a smartphone, or opening a can of food.\"}',1,'2025-08-20 21:58:35','2025-09-23 20:25:31','9d9b0848-819a-469f-b841-d3ff2f090c7a'),
(458,458,1,'Occupational Therapy','occupational-therapy',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Occupational therapy addresses daily living skills, assisting patients in regaining their ability to perform tasks such as dressing, cooking, and bathing.\"}',1,'2025-08-20 21:58:42','2025-08-20 21:58:42','8e0c85d8-7da9-47c3-acae-b493b36330ff'),
(459,459,1,'Rehabilitation Program','rehabilitation-program',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"We provide extensive rehabilitation services up to seven days a week, tailored to individual needs and goals. In order to help progress and recovery, we adjust therapies based on our patients’ abilities and tolerance so their quality of life can continue to improve after transitioning home.\",\"89752275-60b9-4b61-9143-06d0fc3bb511\":[2800]}',1,'2025-08-20 21:58:47','2025-09-23 21:13:19','a1b8582e-2b58-4b41-a3a9-264293d0eae4'),
(460,460,1,'Rehabilitation Program','rehabilitation-program',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"We provide extensive rehabilitation services up to seven days a week, tailored to individual needs and goals. In order to help progress and recovery, we adjust therapies based on the patient’s abilities and tolerance so their quality of life can continue to improve after transitioning home.\"}',1,'2025-08-20 21:58:54','2025-08-20 21:58:54','31585a9a-536b-4c2e-b8d6-82adb5eb48be'),
(461,461,1,'Physical Therapy','physical-therapy',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Physical therapy focuses on “gross motor skills,” which involve movements of the arms, legs, and torso, and are important for balance, coordination, and strength. These skills help us do everyday activities like sitting up, standing, walking, and climbing stairs. Physical therapy plays a major role in helping patients recover from surgery, injury, or illness.\"}',1,'2025-08-20 21:59:02','2025-09-23 20:25:25','f494f769-633e-4612-99d0-497e04d911e6'),
(462,462,1,'Physical Therapy','physical-therapy',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Physical therapy focuses on improving mobility, strength, and coordination, helping patients recover from surgery, injury, or illness.\"}',1,'2025-08-20 21:59:06','2025-08-20 21:59:06','9d4fda35-9d25-48c7-b9be-d4658dcf244f'),
(463,463,1,'Speech Therapy','speech-therapy',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Speech therapy helps people who have trouble with communication, speaking clearly, understanding others, or swallowing. The goal of speech therapy is to improve a person’s ability to communicate effectively and safely eat or drink when those skills are affected by injury, surgery, or illness.\"}',1,'2025-08-20 21:59:10','2025-09-23 20:25:37','e30f0999-38e3-455b-9692-610ddb4bff93'),
(464,464,1,'Speech Therapy','speech-therapy',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Speech therapy supports communication and swallowing difficulties, helping patients overcome challenges related to speech, language, or cognitive function.\"}',1,'2025-08-20 21:59:15','2025-08-20 21:59:15','5c356ba9-f6a9-4a4f-8e72-958467d53c8b'),
(465,465,1,'Post-Acute Care and Skilled Nursing Services','post-acute-care-and-skilled-nursing-services',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Post-Acute Care refers to the medical and rehabilitation services people need after a hospital stay, especially after a serious illness, injury, or surgery. Post-acute care is the support someone gets after leaving the hospital, and skilled nursing services are the medical and therapy services provided as part of that recovery. The goal is to help patients recover enough to return home safely or reach their best level of function.\",\"89752275-60b9-4b61-9143-06d0fc3bb511\":[2803]}',1,'2025-08-20 21:59:23','2025-09-23 21:13:37','d6dde952-a8e5-4681-a523-adfbe312f5ed'),
(466,466,1,'Post-Acute Care and Skilled Nursing Services','post-acute-care-and-skilled-nursing-services',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"For those recovering from illness, injury, or surgery, our comprehensive Post-Acute Rehabilitation services help patients regain their strength and transition home as soon as possible. We offer an extensive range of care services with compassionate, certified professionals helping our patients recover in comfort.\"}',1,'2025-08-20 21:59:33','2025-08-20 21:59:33','2d74ecd3-7858-4e9f-9b99-99738d963255'),
(467,467,1,'Primary Care','primary-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Primary Care includes managing chronic conditions like diabetes, high blood pressure, heart disease, or dementia, as well as treating new concerns that may arise, such as infections or sudden changes in health. Our in-house primary care team, which is made up of doctors, nurse practitioners, or physician assistants, also monitors medications to make sure they are safe and effective and coordinates care with specialists, therapists, or hospitals when needed. Your primary care provider will work closely with the nursing staff and other caregivers in the facility to help you stay as healthy, comfortable, and independent as possible.\"}',1,'2025-08-20 21:59:39','2025-09-23 20:25:55','bfe20fd3-7f18-4538-a39e-e5c5ce2edb75'),
(468,468,1,'Primary Care','primary-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Our dedicated team provides comprehensive bedside primary care to manage chronic conditions and support overall health, including chronic care management, diabetes, and pain management. Our team also offers expert care for patients with feeding tubes and other complex medical needs, ensuring personalized, compassionate bedside support.\"}',1,'2025-08-20 21:59:45','2025-08-20 21:59:45','7d1a9975-083d-4ba4-af8f-ea50a374e276'),
(469,469,1,'Orthopedic & Post-Surgical Care','orthopedic-post-surgical-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Orthopedic care helps people recover after injuries or surgeries involving their bones, joints, muscles, or spine—like a hip or knee replacement, a broken bone, or back surgery. The goal is to get stronger and regain your ability to move safely and independently. Orthopedic care in this setting includes things like physical therapy to improve strength, balance, and walking, and occupational therapy to help with daily activities like dressing, bathing, or using the bathroom. Our orthopedic care also encompasses things like pain management to help control discomfort during recovery, wound care if there was surgery or injury, monitoring for complications, like infections or blood clots, and medication management for pain, swelling, or other medical needs.\"}',1,'2025-08-20 21:59:56','2025-09-23 20:26:04','1c034c29-59ff-47c7-aca7-9c2b653b9256'),
(470,470,1,'Orthopedic & Post-Surgical Care','orthopedic-post-surgical-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Our compassionate and certified team is here to help you regain motor skills and use assistive devices for independent living. We offer rehabilitation programs for those recovering from trauma, illness, or surgery, as well as support for conditions like arthritis, osteoporosis, and more.\"}',1,'2025-08-20 22:00:03','2025-08-20 22:00:03','4cabac51-4863-4972-a2ae-912436aeb9a0'),
(471,471,1,'Cardiac Care','cardiac-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Cardiac Care is designed to help people recover after a heart-related event or procedure—like a heart attack, heart surgery (such as bypass or valve replacement), a heart failure hospitalization, or a cardiac stent placement, providing a structured setting for recovery with medical support and rehabilitation. Our team will monitor and manage heart symptoms (like shortness of breath, chest pain, and swelling) and make sure heart medications are taken correctly and safely. We provide physical therapy to rebuild strength, stamina, and confidence with activity, and focused heart health and nutritional support, including heart-healthy diet education.\"}',1,'2025-08-20 22:00:03','2025-09-23 20:26:11','54963402-ae49-4fc7-89e6-2590a47e9f44'),
(472,472,1,'Cardiac Care','cardiac-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"We provide a safe and supportive environment for those recovering from heart-related conditions, including heart attacks, strokes, angina, heart failure, dysrhythmia, and more. Our focus is on helping you rehabilitate and regain your health.\"}',1,'2025-08-20 22:00:11','2025-08-20 22:00:11','9919a568-3016-49e3-af49-dd45a58029e9'),
(473,473,1,'Neuro & Stroke Care','neuro-stroke-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"We specialize in stroke recovery services aimed at minimizing brain injury, promoting healthy functioning, and reducing the risk of recurrence or future hospitalization.\"}',1,'2025-08-20 22:00:11','2025-08-20 22:08:43','58ab2947-9afd-4aa5-972d-97921c891e0b'),
(474,474,1,'Neuro & Stroke Care','neuro-stroke-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"We specialize in stroke recovery services aimed at minimizing brain injury, promoting healthy functioning, and reducing the risk of recurrence or future hospitalization.\"}',1,'2025-08-20 22:00:22','2025-08-20 22:00:22','223c6c49-dd84-4efa-9549-cd38554e7c9c'),
(475,475,1,'Pulmonary Care','pulmonary-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Pulmonary Care is focused on helping people recover and manage lung conditions, especially after hospitalization for things like Chronic Obstructive Pulmonary Disease (COPD) flare-ups, pneumonia, COVID-19, or Pulmonary Fibrosis or other chronic lung diseases.  We can provide breathing treatments (like nebulizers or inhalers), oxygen therapy, tracheostomy care, and ventilator weaning if needed. Additionally, our dedicated ventilator care units, where offered, support patients with chronic respiratory issues that require longer-term mechanical ventilation.\"}',1,'2025-08-20 22:00:31','2025-09-23 20:26:26','3791b162-cdcc-408e-b4ff-1fc3512f8025'),
(476,476,1,'Pulmonary Care','pulmonary-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"We provide specialized pulmonary care for individuals facing diseases or damage to the lungs, trachea, diaphragm, and other components of the pulmonary system. Our team includes leading respiratory care physicians and specialists, utilizing cutting-edge technology and evidence-based practices to ensure the best possible outcomes.\"}',1,'2025-08-20 22:00:38','2025-08-20 22:00:38','19415ba5-9727-4222-a6df-104c4be88800'),
(477,477,1,'Wound Care','wound-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Wound Care is designed to help people heal from serious or complex wounds that require more than basic care, especially after surgery, injury, or prolonged illness, including surgical wounds, skin infections, pressure injuries, diabetic foot ulcers, and chronic wounds related to poor circulation or vascular disease. Care plans include regular wound assessments by trained nurses and specialists who incorporate a number of advanced techniques and therapies into an individualized plan designed to promote healing, reduce pain, and prevent infections and wound-related complications.\"}',1,'2025-08-20 22:00:42','2025-09-23 20:26:34','709e7676-94b6-466c-a7a6-4415576b83d3'),
(478,478,1,'Wound Care','wound-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Our dedicated wound care team focuses on promoting healing and preventing both existing and in-house acquired wounds. We specialize in the treatment of chronic wounds, pressure ulcers, surgical wounds, and diabetic foot ulcers, using advanced techniques and therapies tailored to each patient\'s needs.\"}',1,'2025-08-20 22:00:46','2025-08-20 22:00:46','4f935120-4647-4d65-95b6-92a0d9f95572'),
(479,479,1,'Renal Care','renal-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Renal Care is a specialized care model designed to support patients with Acute Kidney Injury (AKI) or Chronic Kidney Disease (CKD) who are transitioning from hospital to home or a post-acute or long-term care setting. Emphasis is on early identification, renal function monitoring, medication optimization, fluid and electrolyte management, and coordination with nephrology for advanced treatments like hemodialysis and peritoneal dialysis when needed. Our dedicated team works closely with each patient to create individualized care plans that focus on improving kidney function, managing symptoms, and enhancing overall quality of life.\"}',1,'2025-08-20 22:00:52','2025-09-23 20:26:42','4a46d8a8-5ed6-46b1-a54b-6997737c1065'),
(480,480,1,'Renal Care','renal-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"For patients with chronic kidney disease, kidney failure, and end-stage renal disease (ESRD), we offer comprehensive disease management and dialysis services, including hemodialysis management, to ensure patients receive the highest level of care. Our dedicated team works closely with each patient to create individualized care plans that focus on improving kidney function, managing symptoms, and enhancing overall quality of life.\"}',1,'2025-08-20 22:00:59','2025-08-20 22:00:59','11fb480f-1594-4c6f-b71c-f250daf4091d'),
(481,481,1,'Palliative Care','palliative-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Our post-acute palliative care program, also called our supportive care program, provides specialized, goal-concordant support for patients with serious illness transitioning from hospital to home, post-acute, or long-term care settings. The program focuses on expert symptom management, advanced care planning, and psychosocial support. Our interdisciplinary team works closely with patients and their families to address physical, emotional, and spiritual needs, ensuring a holistic, interdisciplinary approach to care.\"}',1,'2025-08-20 22:01:02','2025-09-23 20:26:54','85ba8bc3-e2de-41a6-b419-2aca5e1e6f6c'),
(482,482,1,'Palliative Care','palliative-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Palliative Care provides comfort and support to patients facing serious illness. We focus on managing symptoms, such as pain, nausea, and fatigue, while enhancing quality of life through compassionate care. Our interdisciplinary team works closely with patients and their families to address physical, emotional, and spiritual needs, ensuring a holistic approach to care.\"}',1,'2025-08-20 22:01:08','2025-08-20 22:01:08','0987bc20-7692-4f06-8e92-d776a3f12910'),
(483,483,1,'Bariatric Care','bariatric-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"We offer comprehensive, specialized care for individuals living with obesity and related health conditions in a post-acute or long-term care setting. Our interdisciplinary team develops personalized care plans that address both medical complexities and mobility needs, prioritizing dignity, comfort, and safety. The facility is equipped with bariatric-friendly accommodations—including expanded-capacity beds, chairs, and medical devices—as well as advanced transfer equipment such as Hoyer lifts to support safe and respectful mobility assistance.\"}',1,'2025-08-20 22:01:12','2025-09-23 20:27:03','5937bec4-911f-4fcf-9c72-aaf50c8faf96'),
(484,484,1,'Bariatric Care','bariatric-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"We provide specialized support for individuals managing obesity and related health conditions. Our personalized care plans address both medical and mobility needs, utilizing specialized equipment to ensure comfort and safety. Our facility is equipped with bariatric-friendly tools, including larger beds, chairs, and medical equipment, as well as the capability to use Hoyer lifts for safe patient transfers.\"}',1,'2025-08-20 22:01:17','2025-08-20 22:01:17','71cebbf9-3566-4bda-80eb-32aab432c133'),
(485,485,1,'Psychology/Psychiatric Care','psychology-psychiatric-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Our Psychology and Psychiatry team delivers compassionate, patient-centered care for individuals experiencing mild to moderate mental health concerns such as anxiety, depression, and stress. Through individualized treatment plans, we focus on enhancing emotional well-being, building mental resilience, and supporting overall recovery. By integrating psychological support with medical care, we promote a comprehensive approach that fosters both physical healing and emotional balance in the post-acute and long-term care setting.\"}',1,'2025-08-20 22:01:22','2025-09-23 20:27:13','1995a6b0-aa08-4965-a22b-b3baff29f352'),
(486,486,1,'Psychology/Psychiatric Care','psychology-psychiatric-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Our Psychology and Psychiatric Care team provides compassionate support for patients experiencing mild mental health concerns, such as anxiety, depression, and stress. We focus on enhancing emotional well-being and mental resilience, offering individualized care that complements physical treatments. By addressing both mental and physical health, we support holistic recovery and promote a sense of balance and well-being for all patients.\"}',1,'2025-08-20 22:01:30','2025-08-20 22:01:30','ca222f0e-4f34-4237-b0f7-dc4131bfd34d'),
(487,487,1,'Long-Term Care Services','long-term-care-services',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Our long-term care programs provide 24/7 support for individuals with chronic illnesses, disabilities, or cognitive impairments who require ongoing assistance with activities of daily living. These programs offer comprehensive medical oversight, nursing care, personal care services, and social engagement to support residents’ health, safety, and quality of life. We provide long-term care in a homelike environment, with a focus on maintaining dignity, comfort, and functional independence for as long as possible. Some of our specialized long-term care programs include:\",\"89752275-60b9-4b61-9143-06d0fc3bb511\":[2809]}',1,'2025-08-20 22:01:56','2025-09-23 21:13:50','0947b9dd-9783-4329-95e6-aff05a2660b5'),
(488,488,1,'Long-Term Care Services','long-term-care-services',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"For patients with additional care requirements, we offer comprehensive Long-Term Care services that provide individuals with extra comfort, safety, and compassion.\"}',1,'2025-08-20 22:02:03','2025-08-20 22:02:03','93fe4875-e61e-48dd-85a0-3950d5427572'),
(489,489,1,'Geriatric Care','geriatric-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Geriatric specialty care provides compassionate, bedside medical care tailored to the unique needs of older adults in the long-term care setting. We focus on maintaining independence, comfort, and dignity while managing complex, age-related health conditions. Services include comprehensive falls prevention, expert wound care, chronic disease management, and proactive health monitoring to enhance safety and overall quality of life.\"}',1,'2025-08-20 22:02:05','2025-09-23 20:29:09','8bb85901-bc19-4b6d-ab4b-b84c2474ed08'),
(490,490,1,'Geriatric Care','geriatric-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Our team is dedicated to providing compassionate, round-the-clock care at the bedside for elderly patients with a variety of health needs. We focus on promoting independence and comfort while managing age-related conditions. Our services include falls prevention, wound care, and proactive health management to ensure safety and improve quality of life.\"}',1,'2025-08-20 22:02:13','2025-08-20 22:02:13','ad309d23-addc-4975-a74c-6f9a8e69eb5a'),
(491,491,1,'Memory Care','memory-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Our memory care programming is thoughtfully designed to cater to the unique needs of residents living with dementia, Alzheimer\'s disease, and other memory impairments. Understanding the complexities of memory-related conditions, our approach begins with the creation of a warm, familiar, and safe environment. We offer a comprehensive range of treatments and services that prioritize the well-being and quality of life of each individual. Our skilled memory unit team goes beyond basic care, fostering connections through compassion and understanding, which are vital for enhancing emotional well-being.\"}',1,'2025-08-20 22:02:13','2025-09-23 20:29:17','74605853-1c83-4877-ac00-0f3a4d64ff4f'),
(492,492,1,'Memory Care','memory-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Our memory care programming provides residents with dementia, Alzheimer’s disease, and other memory impairments with a full range of treatments and services. We focus on creating a warm, comfortable, and familiar environment where residents can enjoy routine while engaging with their community.\"}',1,'2025-08-20 22:02:19','2025-08-20 22:02:19','b51636f8-d7a6-4b8e-8142-85d4d9ece22c'),
(493,493,1,'Hospice Care','hospice-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Our approach to hospice emphasizes effective management of symptoms and side effects related to both the disease and its treatment, while also addressing emotional, psychological, and spiritual needs.  We provide compassionate, end-of-life care focused on comfort, dignity, and quality of life for patients with terminal illnesses. Our team works closely with patients and their loved ones to ensure peace of mind during this challenging time, helping to create a supportive and peaceful environment.\"}',1,'2025-08-20 22:02:23','2025-08-20 22:02:38','4e2c0696-d1b1-4c5d-8330-6b3806641c53'),
(494,494,1,'Hospice Care','hospice-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Our approach to hospice emphasizes effective management of symptoms and side effects related to both the disease and its treatment, while also addressing emotional, psychological, and spiritual needs.  We provide compassionate, end-of-life care focused on comfort, dignity, and quality of life for patients with terminal illnesses. Our team works closely with patients and their loved ones to ensure peace of mind during this challenging time, helping to create a supportive and peaceful environment.\"}',1,'2025-08-20 22:02:28','2025-08-20 22:02:28','4ba382da-c805-485c-a286-141609fd9256'),
(495,495,1,'Respite Care','respite-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"Our Respite Care program provides short-term, high-quality care for individuals whose primary caregivers need temporary relief. Whether it\'s due to a planned vacation, a family emergency, or simply the need for rest and renewal, we offer a safe and supportive environment where patients receive personalized attention from our experienced care team. During their stay, we prioritize each individual’s comfort, dignity, and well-being—ensuring continuity of care and giving caregivers the peace of mind they deserve.\"}',1,'2025-08-20 22:02:28','2025-09-23 20:29:38','5a9dc52b-366b-4741-83a1-19c79e2f4e1d'),
(496,496,1,'Respite Care','respite-care',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"Our Respite Care service offers short-term relief for caregivers, providing a temporary stay for patients in need of care. Whether due to a family emergency, a break, or other personal reasons, our team ensures that patients receive compassionate care and attention during their short stay. We focus on maintaining the patient’s comfort, safety, and well-being while offering caregivers peace of mind.\"}',1,'2025-08-20 22:02:34','2025-08-20 22:02:34','af1ba6d4-6392-4365-9957-cc76c55f0483'),
(497,497,1,'Advanced Clinical Programs','advanced-clinical-specialties',NULL,'{\"89752275-60b9-4b61-9143-06d0fc3bb511\":[2806],\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\":\"PathForward by Complete Care delivers structure, expertise, and compassion, giving patients and providers a clear path to better outcomes. Our physician-led advanced programs guide each step with proven outcomes, personalized support, and seamless transitions from hospital to home. Designed to elevate care beyond standard capabilities, PathForward focuses on what matters most: improving health, reducing readmissions, and restoring quality of life—one patient at a time.\"}',1,'2025-08-20 22:02:53','2025-09-23 21:13:43','e9b4533c-64d1-4d18-b220-b21c86e17211'),
(498,498,1,'Advanced Clinical Specialties','advanced-clinical-specialties',NULL,'{\"a2de05eb-1437-41e9-bc0a-6f2defdc0d4e\": \"We offer a range of specialty services to help patients with advanced conditions progress safely in their recovery and receive care that accommodates their individual needs. All programs and services are provided by accredited professionals and caring staff.\"}',1,'2025-08-20 22:02:59','2025-08-20 22:02:59','c45d5fd8-45ee-4d1b-bef1-01144a88e0b4'),
(499,499,1,'Acquired Traumatic Brain Injuries','acquired-traumatic-brain-injuries',NULL,NULL,1,'2025-08-20 22:12:20','2025-08-20 22:12:22','50cbf76d-a519-413b-ab3b-88da28504fdf'),
(500,500,1,'Acquired Traumatic Brain Injuries','acquired-traumatic-brain-injuries',NULL,NULL,1,'2025-08-20 22:12:23','2025-08-20 22:12:23','bbe405f7-bf56-4ec4-9fde-d5985961e42b'),
(501,501,1,'Behavioral Programming','behavioral-programming',NULL,NULL,1,'2025-08-20 22:12:23','2025-08-20 22:12:28','09702f87-909b-4313-b171-553883833a54'),
(502,502,1,'Behavioral Programming','behavioral-programming',NULL,NULL,1,'2025-08-20 22:12:28','2025-08-20 22:12:28','86eb952c-e64a-4007-b2c7-c0dfaaeda2d8'),
(503,503,1,'Ventilator Unit','ventilator-unit',NULL,NULL,1,'2025-08-20 22:12:32','2025-08-20 22:12:33','3d0a00ab-1304-41fd-a9a1-8b928111d7f3'),
(504,504,1,'Ventilator Unit','ventilator-unit',NULL,NULL,1,'2025-08-20 22:12:34','2025-08-20 22:12:34','ee55bd3e-ff0d-4324-af7f-28f80db6ca0f'),
(505,505,1,NULL,'__temp_deknzzudrgokojetknlijflesrnvjaayzhuo',NULL,NULL,1,'2025-08-20 22:12:34','2025-08-20 22:12:34','2d9c249e-7e79-40c3-83a9-862b2c6aca8a'),
(506,506,1,'On-Site Dialysis Unit','on-site-dialysis-unit',NULL,NULL,1,'2025-08-20 22:12:49','2025-08-20 22:12:50','b43b8cc5-c98a-4a4a-99ca-0d2cb2cc4bed'),
(507,507,1,'On-Site Dialysis Unit','on-site-dialysis-unit',NULL,NULL,1,'2025-08-20 22:12:50','2025-08-20 22:12:50','f10450ea-4856-47ba-8eb1-909a8a473b25'),
(508,508,1,'Oasis – Enhanced Specialized Rehab','oasis-enhanced-specialized-rehab',NULL,NULL,1,'2025-08-20 22:12:50','2025-08-20 22:12:54','2adf8f61-88f9-4952-9cf0-7478c60624e0'),
(509,509,1,'Oasis – Enhanced Specialized Rehab','oasis-enhanced-specialized-rehab',NULL,NULL,1,'2025-08-20 22:12:54','2025-08-20 22:12:54','a5895f05-3415-42da-97d8-00f516083e83'),
(510,510,1,'Substance Abuse Recovery Program','substance-abuse-recovery-program',NULL,NULL,1,'2025-08-20 22:12:54','2025-08-20 22:12:57','1d30be1d-10cc-48c9-ba73-f08a54b8580e'),
(511,511,1,'Substance Abuse Recovery Program','substance-abuse-recovery-program',NULL,NULL,1,'2025-08-20 22:12:57','2025-08-20 22:12:57','c01bbc4a-d32f-47af-ade5-30464bae3af0'),
(512,512,1,'Advanced Cardiac Capabilities','advanced-cardiac-capabilities',NULL,NULL,1,'2025-08-20 22:12:57','2025-08-20 22:13:00','e1c63bd6-1266-47f5-b9bb-5a755978f890'),
(513,513,1,'Advanced Cardiac Capabilities','advanced-cardiac-capabilities',NULL,NULL,1,'2025-08-20 22:13:01','2025-08-20 22:13:01','dc3ac253-9928-446d-a7d2-06945a3e82b9'),
(514,514,1,'Advanced Pulmonary Capabilities','advanced-pulmonary-capabilities',NULL,NULL,1,'2025-08-20 22:13:01','2025-08-20 22:13:04','04b3f992-72b7-4843-a724-fb38703f2882'),
(515,515,1,'Advanced Pulmonary Capabilities','advanced-pulmonary-capabilities',NULL,NULL,1,'2025-08-20 22:13:04','2025-08-20 22:13:04','e01686f1-41e4-4d8b-aa7b-24cc6b10d98f'),
(516,516,1,'Parkinson\'s Disease Management','parkinsons-disease-management',NULL,NULL,1,'2025-08-20 22:13:04','2025-08-20 22:13:07','c0cf2579-34a6-4b6b-b7bd-f3f7b3ce9c4b'),
(517,517,1,'Parkinson\'s Disease Management','parkinsons-disease-management',NULL,NULL,1,'2025-08-20 22:13:07','2025-08-20 22:13:07','b48b1a41-f623-4428-9ce0-81622f0a8448'),
(518,518,1,'Advanced Pain Management','advanced-pain-management',NULL,NULL,1,'2025-08-20 22:13:07','2025-08-20 22:13:10','c484a0c9-701d-4f3d-bae8-9ecc9b4ea32a'),
(519,519,1,'Advanced Pain Management','advanced-pain-management',NULL,NULL,1,'2025-08-20 22:13:10','2025-08-20 22:13:10','53b853b1-93ac-4668-9a01-a64cb7c618b6'),
(520,520,1,'Specialized Infectious Disease Pathogen Care','specialized-infectious-disease-pathogen-care',NULL,NULL,1,'2025-08-20 22:13:10','2025-08-20 22:13:12','e8a76e85-ceff-454a-b6fa-1a132962a65d'),
(521,521,1,'Specialized Infectious Disease Pathogen Care','specialized-infectious-disease-pathogen-care',NULL,NULL,1,'2025-08-20 22:13:13','2025-08-20 22:13:13','16adf247-c0bd-47ea-933a-19e3638175b2'),
(522,522,1,'Secured Memory Care Units','secured-memory-care-units',NULL,NULL,1,'2025-08-20 22:13:13','2025-08-20 22:13:15','7e4c078c-7a72-46c5-9248-36745924e1a0'),
(523,523,1,'Secured Memory Care Units','secured-memory-care-units',NULL,NULL,1,'2025-08-20 22:13:15','2025-08-20 22:13:15','7ac14140-7dfe-4ed6-8b98-58ecda79a95a'),
(524,524,1,'Supportive Care','supportive-care',NULL,NULL,1,'2025-08-20 22:13:15','2025-08-20 22:13:18','278b1e70-6b11-4479-b4cb-4c8c8e261732'),
(525,525,1,'Supportive Care','supportive-care',NULL,NULL,1,'2025-08-20 22:13:18','2025-08-20 22:13:18','3b3c7d7f-c4cf-45a3-961a-87f5d90a08c8'),
(530,530,1,'Life Vest','life-vest',NULL,NULL,1,'2025-08-20 22:17:42','2025-08-20 22:18:26','4853a6a3-b439-4629-98a7-dfc72e075a3c'),
(531,531,1,'Life Vest','life-vest',NULL,NULL,1,'2025-08-20 22:17:46','2025-08-20 22:17:46','050d4668-9b87-4c04-84ea-f1645595a97d'),
(532,532,1,'Pleurex Catheter','pleurex-catheter',NULL,NULL,1,'2025-08-20 22:17:53','2025-08-20 22:18:26','c17d5553-f91b-49aa-9f91-1ea21a0752d7'),
(533,533,1,'Pleurex Catheter','pleurex-catheter',NULL,NULL,1,'2025-08-20 22:18:02','2025-08-20 22:18:02','1e56b488-c021-4425-bb1d-04590779a2bf'),
(534,534,1,'Pacemaker Assessment/Monitoring','pacemaker-assement-monitoring',NULL,NULL,1,'2025-08-20 22:18:14','2025-08-20 22:18:29','b8eae01b-1a2f-4367-b30c-701c44ba4c71'),
(535,535,1,'Pacemaker Assement/Monitoring','pacemaker-assement-monitoring',NULL,NULL,1,'2025-08-20 22:18:21','2025-08-20 22:18:21','f2410329-a14e-49d9-9abb-7949815833ca'),
(536,536,1,'Pacemaker Assessment/Monitoring','pacemaker-assement-monitoring',NULL,NULL,1,'2025-08-20 22:18:29','2025-08-20 22:18:29','56b6c600-aa64-4758-9125-5bad657be06a'),
(545,545,1,'Arbors Cover Photo',NULL,NULL,NULL,1,'2025-09-02 20:43:21','2025-09-02 20:43:21','7fb3dfcb-629f-4a71-936f-43837ea18811'),
(546,546,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"559340ef-728e-4935-84cc-443bd407f901\": [111, 113, 115, 117, 119, 121], \"702dab28-10e4-44a1-9271-72e0eda7fa6e\": \"At Complete Care at Arbors, we understand the nuances that uplift the spirit and inspire optimism. With well-appointed, private and semi-private rooms and a host of amenities, Complete Care at Arbors is all about providing care that elevates patient health and wellbeing. Free Wi-Fi lets you keep in touch with family and friends, and we provide cable TV in every room. Residents enjoy full stylist services provided by our convenient on-site beauty salon.\", \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-02 20:43:30','2025-09-02 20:43:30','1627511b-478d-46d7-9575-9b8ce06328a6'),
(548,548,1,'Arbors flyer',NULL,NULL,NULL,1,'2025-09-02 21:15:29','2025-09-02 21:15:29','b7100d85-f6df-4c72-bad6-28606d616300'),
(549,549,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"559340ef-728e-4935-84cc-443bd407f901\": [111, 113, 115, 117, 119, 121], \"702dab28-10e4-44a1-9271-72e0eda7fa6e\": \"At Complete Care at Arbors, we understand the nuances that uplift the spirit and inspire optimism. With well-appointed, private and semi-private rooms and a host of amenities, Complete Care at Arbors is all about providing care that elevates patient health and wellbeing. Free Wi-Fi lets you keep in touch with family and friends, and we provide cable TV in every room. Residents enjoy full stylist services provided by our convenient on-site beauty salon.\", \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-02 21:15:32','2025-09-02 21:15:32','82025c5d-3b37-4e5a-b1fa-505c3acbbb47'),
(553,553,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"559340ef-728e-4935-84cc-443bd407f901\": [111, 113, 115, 117, 119, 121], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"702dab28-10e4-44a1-9271-72e0eda7fa6e\": \"At Complete Care at Arbors, we understand the nuances that uplift the spirit and inspire optimism. With well-appointed, private and semi-private rooms and a host of amenities, Complete Care at Arbors is all about providing care that elevates patient health and wellbeing. Free Wi-Fi lets you keep in touch with family and friends, and we provide cable TV in every room. Residents enjoy full stylist services provided by our convenient on-site beauty salon.\", \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-02 21:46:06','2025-09-02 21:46:06','563987fa-794d-4c17-9963-e7d8f5c22170'),
(554,554,1,NULL,NULL,NULL,'{\"3269556a-bffa-4f5d-bb1f-07351390ae8d\":[2873,2870,2874,2872,2889,2890,2886],\"08bdc0bd-b069-4092-acf0-a644868be0ef\":{\"value\":\"https://www.linkedin.com/company/complete-care-official/\",\"type\":\"url\"},\"f848018e-5001-479b-8e8b-55661313d1e1\":{\"value\":\"https://www.facebook.com/completecareofficial/\",\"type\":\"url\"},\"88944c2f-1fe8-4b2a-9ead-e286abcf9631\":{\"value\":\"https://www.instagram.com/completecareofficial/\",\"type\":\"url\"},\"d949ad26-a1c5-46fc-8ff6-c97efaf5f3fc\":{\"value\":\"https://www.tiktok.com/@completelycaring\",\"type\":\"url\"}}',1,'2025-09-02 21:50:29','2025-09-25 15:18:43','5762437d-5175-4f3f-aa2f-5793a002dce2'),
(555,555,1,'Daily Housekeeping','daily-housekeeping',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Daily Housekeeping\"}',1,'2025-09-02 22:24:40','2025-09-02 22:24:46','ea42e030-4fa3-46d8-a89a-45941c710e0c'),
(556,556,1,'Daily Housekeeping','daily-housekeeping',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Daily Housekeeping\"}',1,'2025-09-02 22:24:46','2025-09-02 22:24:46','a3dceab1-4e69-4bcd-9ac1-82ce5a303e13'),
(557,557,1,'Laundry Service','laundry-service',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Laundry Service\"}',1,'2025-09-02 22:24:46','2025-09-02 22:24:52','8ecbc561-efeb-4efc-8eda-770125c5e652'),
(558,558,1,'Laundry Service','laundry-service',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Laundry Service\"}',1,'2025-09-02 22:24:52','2025-09-02 22:24:52','af9b8b10-a16a-4601-ba79-2d3bea710263'),
(559,559,1,'Complimentary Wifi','complimentary-wifi',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Complimentary Wifi\"}',1,'2025-09-02 22:24:52','2025-09-02 22:24:59','886d2555-3877-4b36-aecb-352b871ffe95'),
(560,560,1,'Complimentary Wifi','complimentary-wifi',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Complimentary Wifi\"}',1,'2025-09-02 22:24:59','2025-09-02 22:24:59','ed44d23d-25f7-4038-b804-d8b974267ba9'),
(561,561,1,'Patios & Lounge Areas','patios-lounge-areas',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Patios & Lounge Areas\"}',1,'2025-09-02 22:24:59','2025-09-02 22:25:02','e202f234-df18-46d2-bde7-355983598174'),
(562,562,1,'Patios & Lounge Areas','patios-lounge-areas',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Patios & Lounge Areas\"}',1,'2025-09-02 22:25:02','2025-09-02 22:25:02','7965c49a-7c8c-4423-9f9d-91924f60b381'),
(563,563,1,'Beauty Services','beauty-services',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Beauty Services\"}',1,'2025-09-02 22:25:02','2025-09-02 22:25:06','80bfc14c-bb0c-4b01-a3f6-3735ec0db11c'),
(564,564,1,'Beauty Services','beauty-services',NULL,'{\"af4c29fe-7284-4a39-93a8-6ee23005762f\": \"Beauty Services\"}',1,'2025-09-02 22:25:06','2025-09-02 22:25:06','b66cdbff-490b-405f-9103-bee90eeaf9f0'),
(566,566,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"702dab28-10e4-44a1-9271-72e0eda7fa6e\": \"At Complete Care at Arbors, we understand the nuances that uplift the spirit and inspire optimism. With well-appointed, private and semi-private rooms and a host of amenities, Complete Care at Arbors is all about providing care that elevates patient health and wellbeing. Free Wi-Fi lets you keep in touch with family and friends, and we provide cable TV in every room. Residents enjoy full stylist services provided by our convenient on-site beauty salon.\", \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-02 22:26:19','2025-09-02 22:26:19','b8fad205-eec9-4a83-b26d-ec20a32dbcae'),
(568,568,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-02 22:26:44','2025-09-02 22:26:44','c2b44f1f-055d-474c-a9c6-eb343a9bb88b'),
(570,570,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-02 22:27:53','2025-09-02 22:27:53','099f6a87-f700-4449-9ffb-99545d6f266b'),
(575,575,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-02 22:28:18','2025-09-02 22:28:18','e0c33bd1-d02a-4562-bb1f-d23263af7eff'),
(577,577,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-03 01:11:03','2025-09-03 01:11:03','1b76f368-7a53-490f-828b-93283a5c7a77'),
(581,581,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"688e0d64-8999-47be-a427-f9e9c6e1789e\": [548], \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"92b514e7-6c85-40f3-9885-4ed4138887ea\": [548], \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-03 19:59:09','2025-09-03 19:59:09','670770c9-d539-4b93-be65-9cc83fc7e258'),
(586,586,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"688e0d64-8999-47be-a427-f9e9c6e1789e\": [548], \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"92b514e7-6c85-40f3-9885-4ed4138887ea\": [548], \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-03 21:05:58','2025-09-03 21:05:58','6b7dbe8b-4295-47c3-9398-09d51497c66f'),
(587,587,1,'Ashie T.','robert-a',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Ashie T.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"The staff at Complete Care goes above and beyond to provide patient care and satisfaction! Always with a smile and a good word, the staff is there whenever you need them and the services they provide are unparalleled.\"}',1,'2025-09-03 21:05:58','2025-09-03 21:05:58','a4adc943-c48d-4965-bb49-ae12b6c6bad8'),
(588,588,1,'Carole T.','bernadette-m',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Carole T.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"Very professional and caring place, staff and nurses were overly helpful in attending to needs. Therapy went way above to assist in getting us to reach maximum potential.\"}',1,'2025-09-03 21:05:58','2025-09-03 21:05:58','730ae9de-5648-4f3f-8dcc-25fcddd69b4a'),
(589,589,1,'Cora O.','mary-o',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Cora O.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"I have been here for 3 years and I am thrilled with the quality care I receive. I enjoy every day is a new amazing experience with activities. The staff are wonderful! The place is very clean and every one is very polite!\"}',1,'2025-09-03 21:05:58','2025-09-03 21:05:58','25236982-130f-4212-9881-cb8bf641dcff'),
(592,592,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"688e0d64-8999-47be-a427-f9e9c6e1789e\": [548], \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"92b514e7-6c85-40f3-9885-4ed4138887ea\": [548], \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-03 21:06:15','2025-09-03 21:06:15','0c97e2c0-f30b-48bf-87af-3e09e9095503'),
(593,593,1,'Cora O.','mary-o',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Cora O.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"I have been here for 3 years and I am thrilled with the quality care I receive. I enjoy every day is a new amazing experience with activities. The staff are wonderful! The place is very clean and every one is very polite1\"}',1,'2025-09-03 21:06:15','2025-09-03 21:06:15','dad27f89-6c1a-4697-b344-9ac513d1aa33'),
(596,596,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"688e0d64-8999-47be-a427-f9e9c6e1789e\": [548], \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"92b514e7-6c85-40f3-9885-4ed4138887ea\": [548], \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-03 21:08:08','2025-09-03 21:08:08','78d1deac-b73f-4b65-ae08-1896d8c50b53'),
(597,597,1,'Cora O.','mary-o',NULL,'{\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\": \"Cora O.\", \"ffdd5871-4e4c-4e46-88b5-06b52502357e\": \"I have been here for 3 years and I am thrilled with the quality care I receive. I enjoy every day is a new amazing experience with activities. The staff are wonderful! The place is very clean and every one is very polite!\"}',1,'2025-09-03 21:08:08','2025-09-03 21:08:08','3010e415-5a3a-43a0-be4b-62f4f5d88b76'),
(599,599,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"688e0d64-8999-47be-a427-f9e9c6e1789e\": [548], \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"92b514e7-6c85-40f3-9885-4ed4138887ea\": [548], \"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\": [545, 137, 138, 136], \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-03 21:21:53','2025-09-03 21:21:53','d07a14d2-f2ad-4aaa-a7f5-390d65a5c4e0'),
(601,601,1,'CMS Five Star Quality','cms-five-star-quality-measures-from',NULL,'{\"71d07053-43eb-40fe-8f9e-ad7480cc3193\":\"CMS Five Star Quality\",\"5e076972-0a7c-4184-8570-4b3688ebe3d8\":[2873]}',1,'2025-09-03 21:48:04','2025-10-03 20:24:31','cb774269-113e-4e04-bd53-9de86d340d10'),
(602,602,1,'CMS Five Star Quality Measures from','cms-five-star-quality-measures-from',NULL,'{\"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"CMS Five Star Quality Measures\"}',1,'2025-09-03 21:48:33','2025-09-03 21:48:33','a2e85f27-8115-4ade-871c-8fae6382c387'),
(603,603,1,'News Week Best Nursing Home 2025','news-week-best-nursing-home-2025-from',NULL,'{\"5e076972-0a7c-4184-8570-4b3688ebe3d8\": [], \"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"News Week Best Nursing Home 2025\"}',1,'2025-09-03 21:48:33','2025-09-03 21:57:21','62ddad80-27b7-4c58-a37f-8fd3986a0c29'),
(604,604,1,'News Week Best Nursing Home 2025 from','news-week-best-nursing-home-2025-from',NULL,'{\"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"News Week Best Nursing Home 2025\"}',1,'2025-09-03 21:48:45','2025-09-03 21:48:45','133971a7-0977-443f-8c7f-c5799aa18e86'),
(605,605,1,'Striving for Ten','ahca-bronze-award-from',NULL,'{\"71d07053-43eb-40fe-8f9e-ad7480cc3193\":\"Striving for Ten\",\"5e076972-0a7c-4184-8570-4b3688ebe3d8\":[2886]}',1,'2025-09-03 21:48:47','2025-10-03 20:24:40','313e713c-480b-4fec-b782-9be67a9c7eab'),
(606,606,1,'AHCA Bronze Award from','ahca-bronze-award-from',NULL,'{\"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"AHCA Bronze Award\"}',1,'2025-09-03 21:48:52','2025-09-03 21:48:52','d8ae6b2b-b48d-49ae-9405-97d0a3c760e3'),
(607,607,1,'AHCA Bronze Award from','ahca-bronze-award-from',NULL,'{\"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"AHCA Bronze Award\"}',1,'2025-09-03 21:49:15','2025-09-03 21:49:15','fd83569e-f553-4328-ac4a-4bd52540e0ff'),
(608,608,1,'CMS Five Star Quality from','cms-five-star-quality-measures-from',NULL,'{\"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"CMS Five Star Quality\"}',1,'2025-09-03 21:49:20','2025-09-03 21:49:20','2fb2762e-eee9-4063-90d0-5ecda4f110d6'),
(609,609,1,'CMS Five Star Quality from','cms-five-star-quality-measures-from',NULL,'{\"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"CMS Five Star Quality\"}',1,'2025-09-03 21:49:26','2025-09-03 21:49:26','3c0931c6-5365-4006-8e29-4084ce3f3736'),
(610,610,1,'CMS Five Star Quality from','cms-five-star-quality-measures-from',NULL,'{\"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"CMS Five Star Quality\"}',1,'2025-09-03 21:52:33','2025-09-03 21:52:33','2c16f905-90ac-4dd7-9528-1008c9b26c53'),
(612,612,1,'Great Placeto Work',NULL,NULL,NULL,1,'2025-09-03 21:56:34','2025-09-03 21:56:34','3e2f2583-5e40-41c2-8544-fdfdd36e7078'),
(613,613,1,'Strivingfor Ten',NULL,NULL,NULL,1,'2025-09-03 21:56:34','2025-09-03 21:56:34','d09a56ac-d75b-45c3-aa0d-41238b60df4d'),
(614,614,1,'CMS 5 Star Overall and Quality Measures',NULL,NULL,NULL,1,'2025-09-03 21:56:35','2025-10-08 18:25:13','1338ca40-df1e-4c38-b5db-47d62a345cf6'),
(616,616,1,'CMS Five Star Quality from','cms-five-star-quality-measures-from',NULL,'{\"5e076972-0a7c-4184-8570-4b3688ebe3d8\": [614], \"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"CMS Five Star Quality\"}',1,'2025-09-03 21:56:43','2025-09-03 21:56:43','0cd39479-8f42-4d95-90d4-1b980ff9aa26'),
(617,617,1,'Great Place to Work 2025-2026','from',NULL,'{\"71d07053-43eb-40fe-8f9e-ad7480cc3193\":\"Great Place to Work 2025-2026\",\"5e076972-0a7c-4184-8570-4b3688ebe3d8\":[2870]}',1,'2025-09-03 21:56:43','2025-10-03 20:24:49','e2d09a59-2350-4a98-bb83-2b1190b47eec'),
(618,618,1,'from','from',NULL,'{\"5e076972-0a7c-4184-8570-4b3688ebe3d8\": [612]}',1,'2025-09-03 21:56:47','2025-09-03 21:56:47','bd843c21-381c-4231-937d-aded5833f1d7'),
(619,619,1,'Great Place to Work from','from',NULL,'{\"5e076972-0a7c-4184-8570-4b3688ebe3d8\": [612], \"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"Great Place to Work\"}',1,'2025-09-03 21:56:57','2025-09-03 21:56:57','3cd85662-b30d-476c-9990-a3455a9fc2c4'),
(621,621,1,'Great Place to Work 2025-2026 from','from',NULL,'{\"5e076972-0a7c-4184-8570-4b3688ebe3d8\": [612], \"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"Great Place to Work 2025-2026\"}',1,'2025-09-03 21:57:10','2025-09-03 21:57:10','18cbf723-6bdf-4c15-a7a4-e45d3c3542df'),
(623,623,1,'Striving for Ten','ahca-bronze-award-from',NULL,'{\"5e076972-0a7c-4184-8570-4b3688ebe3d8\": [613], \"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"Striving for Ten\"}',1,'2025-09-03 21:58:30','2025-09-03 21:58:30','8fcd2c80-e6df-4457-a3d2-4690d09f5dd7'),
(624,624,1,NULL,'__temp_bsovuplmymlzudzwpdibgufjkwshuzyyxlyk',NULL,NULL,1,'2025-09-03 21:58:41','2025-09-03 21:58:41','f8dd3eb7-7d5c-4585-84fa-cee278bdb48a'),
(625,625,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"688e0d64-8999-47be-a427-f9e9c6e1789e\": [548], \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"92b514e7-6c85-40f3-9885-4ed4138887ea\": [548], \"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\": [545, 137, 138, 136], \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-03 21:59:11','2025-09-03 21:59:11','efc3a8e3-b7fb-44a4-b7b5-6a770fd8f2cd'),
(627,627,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"482ad396-5443-4761-a410-c644d0217e5a\": [601, 605, 617], \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"688e0d64-8999-47be-a427-f9e9c6e1789e\": [548], \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"92b514e7-6c85-40f3-9885-4ed4138887ea\": [548], \"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\": [545, 137, 138, 136], \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-03 22:00:27','2025-09-03 22:00:27','fc6f849a-b787-4671-88c8-23d741b22dac'),
(629,629,1,'CMS Five Star Quality','cms-five-star-quality-measures-from',NULL,'{\"5e076972-0a7c-4184-8570-4b3688ebe3d8\": [614], \"71d07053-43eb-40fe-8f9e-ad7480cc3193\": \"CMS Five Star Quality\"}',1,'2025-09-03 22:13:41','2025-09-03 22:13:41','f1afeab7-6939-499d-9860-87611d3125c1'),
(630,630,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"482ad396-5443-4761-a410-c644d0217e5a\": [601, 605, 617], \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"688e0d64-8999-47be-a427-f9e9c6e1789e\": [548], \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"92b514e7-6c85-40f3-9885-4ed4138887ea\": [548], \"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\": [545, 137, 138, 136], \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-03 22:13:43','2025-09-03 22:13:43','18c39dea-aed2-4038-817a-a9cb4d374a3a'),
(632,632,1,'Arbors Admin',NULL,NULL,NULL,1,'2025-09-03 22:27:11','2025-09-03 22:27:11','cf30e853-a441-466c-a347-366797faf5b4'),
(634,634,1,'Arbors AD 1',NULL,NULL,NULL,1,'2025-09-03 22:27:23','2025-09-03 22:27:23','380ed115-3979-4417-b069-c3a422f33f0b'),
(636,636,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"482ad396-5443-4761-a410-c644d0217e5a\": [601, 605, 617], \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"688e0d64-8999-47be-a427-f9e9c6e1789e\": [548], \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"92b514e7-6c85-40f3-9885-4ed4138887ea\": [548], \"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\": [545, 137, 138, 136], \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-03 22:27:30','2025-09-03 22:27:30','052f904f-8b95-41a1-82aa-0b591aac3752'),
(637,637,1,'Menachem Shapiro','menachem-shapiro',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\": \"Menachem Shapiro\", \"50d484f9-ea00-4870-8b7a-a1c7400f42ab\": [632], \"6859b0cf-ccd8-409d-84f9-b76fcac3eda0\": \"mshapiro@ccarbors.com\"}',1,'2025-09-03 22:27:30','2025-09-03 22:27:30','d720d211-a0e1-4967-80c8-9ae8afc43819'),
(638,638,1,'Ashley Lewis','ashley-lewis',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\": \"Ashley Lewis\", \"50d484f9-ea00-4870-8b7a-a1c7400f42ab\": [634]}',1,'2025-09-03 22:27:30','2025-09-03 22:27:30','745436c1-65fb-427c-ab7f-0b5ba6ff6317'),
(640,640,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\": \"Complete Care at Arbors\", \"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\": [\"bariatricCare\", \"infectiousDiseaseCare\", \"neuroStrokeCare\", \"pulmonaryCare\"], \"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\": {\"number\": \"(732) 914-0090\", \"region\": \"US\"}, \"10d5be16-947c-4646-b2d0-3619f2760ace\": [545], \"19b0086c-bc10-46cc-9f45-ffc5746e8681\": \"ltc\", \"31a45631-ecd4-4327-aca7-18b9d213bb16\": \"info@ccarbors.com\", \"3b262689-7127-4814-bab5-a1972e0869d4\": \"ccarbors.com\", \"403d1895-f32e-4164-8084-b11fdea310cb\": {\"type\": \"url\", \"value\": \"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\"}, \"482ad396-5443-4761-a410-c644d0217e5a\": [601, 605, 617], \"559340ef-728e-4935-84cc-443bd407f901\": [111, 555, 557, 559, 561, 563], \"5e40a449-23c9-418a-a0d6-36ff8f57583d\": {\"type\": \"url\", \"value\": \"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\"}, \"688e0d64-8999-47be-a427-f9e9c6e1789e\": [548], \"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\": \"Arbors\", \"8e701860-42c4-437f-a61c-a48f2ecf1b99\": {\"type\": \"url\", \"value\": \"https://www.linkedin.com/company/94146224/\"}, \"92b514e7-6c85-40f3-9885-4ed4138887ea\": [548], \"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\": [545, 137, 138, 136], \"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\": [548], \"b2903903-6010-4012-bc8c-c8c21f059638\": [86], \"cced3c80-6988-403a-9b5a-14455350e923\": [\"postAcuteCare\", \"longTermCare\"], \"f352e58c-d152-4a45-9615-d0526b009523\": [534, 530, 532]}',1,'2025-09-03 22:28:47','2025-09-03 22:28:47','43b59a4d-c891-4614-8609-0e84183c19df'),
(643,643,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-5','resources/building-a-foundation-of-preventive-care-5','{\"aceb4af7-e092-4894-a59a-eafca28db8e2\":[285],\"bd5a1d46-6844-4735-ad59-9d17e566aa16\":\"articles\",\"6507c83d-4852-4bbd-9fee-2e10673e660b\":[\"health\",\"rehabilitation\"],\"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\":\"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\",\"3bd7f129-28a9-4a77-8dac-a592f11fdf61\":\"<h2>Et laudantium nobis ut nisi rerum.</h2><p>Lorem ipsum dolor sit amet. Qui enim deserunt qui asperiores sint eum nulla eveniet qui eligendi adipisci? Qui ipsum iure ea voluptatem dolores est architecto dolorum aut pariatur nisi ad aliquam nihil.</p><h2>Cum tenetur saepe ex sint minus eos quam dignissimos.</h2><p>Eos vitae corrupti 33 magni temporibus non officia rerum eos nulla animi. Et alias illum nam harum dolorem et voluptatem numquam nam consequatur voluptatem qui quas eveniet. Vel galisum corporis vel exercitationem repellendus sed fuga enim qui minus internos ut numquam fuga ut explicabo dolor. Non nemo rerum quo unde veritatis quo voluptatem nihil qui omnis nihil ea omnis voluptatem.</p><h3>Est consectetur vitae est asperiores obcaecati.</h3><p>Sed expedita dolor ad ipsum exercitationem eos beatae suscipit et fuga fugiat ut nesciunt libero? Id voluptates amet non aliquid ducimus et voluptatem deserunt. Vel debitis accusamus est rerum libero sed deleniti molestiae sed culpa voluptatem ab rerum quia ut earum natus! Est tempora corrupti et temporibus dolorum ut iste molestias?</p><h4>Ad temporibus adipisci At laborum natus.</h4><p>Ut voluptas quidem est sint libero est quos amet sit nemo numquam. Aut unde culpa non corporis praesentium et quas quaerat et blanditiis cumque eos rerum alias in laborum voluptatem. Nam molestiae facere id atque sunt non totam eveniet est laboriosam assumenda et aperiam quisquam et itaque enim non exercitationem animi.</p><p>Ab assumenda asperiores qui aliquam amet.</p><p>Aut magni officiis aut consequatur error aut nobis dolorem et fuga veritatis. Id similique quia et aliquam tempora quo nulla dolore vel ratione obcaecati et autem enim vel earum nihil. Et autem nihil qui officia sunt id rerum galisum ut dolorem perspiciatis quo inventore iste ad asperiores dolor et ullam nostrum. Cum delectus labore et possimus natus et consectetur dignissimos.</p><p>Eos accusantium praesentium ut nihil pariatur aut fuga dolorem sed placeat consectetur. Rem corrupti rerum est maiores eius aut temporibus laborum ad incidunt asperiores. Aut corrupti corporis est excepturi nostrum At cupiditate sequi vel voluptas voluptatem et facere similique. At omnis enim a nobis similique et rerum maiores aut ullam eius.</p><p>At cumque dolorem ex odio veniam aut omnis voluptatem in aperiam laboriosam in consequatur maiores sit neque excepturi et laboriosam libero. Sit amet quod in necessitatibus sunt 33 voluptatum culpa ut galisum nemo sed voluptatem nobis eum quam officiis. Non saepe voluptatem sed reprehenderit corporis sed magnam molestias ex dolore impedit hic impedit quia qui veritatis minima. Id facere possimus non eligendi ducimus et magni quaerat sit asperiores excepturi?</p><p>Ea quasi corporis sit consequatur quas hic laboriosam illum. Eum architecto adipisci et accusamus assumenda sit modi quidem qui alias consequatur cum asperiores aliquam sed ipsa perspiciatis! Id mollitia laborum qui corrupti tenetur quo quasi consequuntur ea illo aspernatur qui eveniet quos qui debitis earum. Eos consequatur sint ut dignissimos omnis qui quam quisquam id voluptas pariatur sit architecto rerum qui velit omnis.</p>\"}',1,'2025-09-05 20:01:00','2025-09-05 20:01:00','67e817be-3400-47db-b101-f28268fc059d'),
(645,645,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-5','resources/building-a-foundation-of-preventive-care-5','{\"aceb4af7-e092-4894-a59a-eafca28db8e2\":[285],\"bd5a1d46-6844-4735-ad59-9d17e566aa16\":\"articles\",\"6507c83d-4852-4bbd-9fee-2e10673e660b\":[\"health\",\"rehabilitation\"],\"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\":\"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\",\"3bd7f129-28a9-4a77-8dac-a592f11fdf61\":\"<h1>Aut corporis nisi et modi saepe aut adipisci ipsam.</h1><p>Lorem ipsum dolor sit amet. Rem eaque molestiae est consequuntur consequatur quo necessitatibus corrupti non nihil incidunt nam voluptatibus optio. Est molestias sint et quis commodi sed nemo cupiditate sed quia odio est magni quidem. In nulla tenetur aut doloribus omnis id saepe eius est deserunt nemo ea suscipit repudiandae qui eius ipsa et velit iure. Eos tempora officiis qui rerum Quis et sunt fuga id itaque animi qui voluptatibus eius ea eaque dolorem.</p><h2>Nam voluptates atque et voluptatem sapiente vel quia soluta?</h2><p>Id dicta consequatur ea molestiae libero sed atque vero vel cupiditate similique ab odio laborum sed commodi deserunt. Sed itaque voluptas qui voluptas quidem et consequuntur possimus nam optio enim qui quae culpa quo temporibus accusantium non magni doloribus? Nam quia quis et modi harum in reprehenderit architecto.</p><h3>Ea molestias nostrum est corrupti voluptatem.</h3><p>Aut dolores fugiat ea odio voluptas in excepturi ipsam aut consequatur molestiae et rerum esse vel repudiandae harum. In nostrum quisquam qui fugiat temporibus hic quam labore quo quia labore.</p><h4>Aut nobis iste vel dolor voluptatibus At quis rerum.</h4><p>Ab vero quidem est voluptas suscipit ut facilis dolorem. Ut dolorem expedita vel enim soluta est nihil quos!</p><p>Aut quod tenetur ut excepturi quos.</p><p>Vel illum reprehenderit eum inventore quia qui autem necessitatibus et enim provident aut voluptatibus quibusdam! Aut laboriosam esse et eius ipsum sed corrupti facilis id dolor sequi est distinctio ipsa et porro eius sit quae aperiam!</p><p>Aut rerum eligendi ab tenetur sapiente et magni natus aut rerum quia quo unde similique. Aut nihil odio non molestiae dolorem et quaerat dolorem eos tempore neque aut libero quasi vel rerum quisquam.</p><p>Est rerum eveniet et culpa neque cum vitae quidem. Est expedita dignissimos id molestiae velit eos fugiat deleniti et fugit laboriosam et facilis quidem quo dolore amet non odit repudiandae. Sed sint maiores qui velit sequi et aliquid quam qui earum enim. Hic illo itaque rem ipsa dolore ut fugiat quisquam vel reprehenderit ipsum.</p><p>Et nulla aliquam eos saepe assumenda ut enim nulla! Et nobis dolores est commodi rerum ad facere mollitia ut fuga possimus et deserunt possimus hic pariatur galisum qui voluptates veritatis! Et repudiandae internos ut rerum quasi in nisi autem 33 amet aliquid qui consequatur enim et perferendis obcaecati cum iure numquam. In voluptatibus voluptas ut eaque nihil sed harum rerum 33 inventore voluptatem est dolores reprehenderit qui ullam voluptatem quo sint voluptas.</p>\"}',1,'2025-09-05 20:01:26','2025-09-05 20:01:26','5891c2eb-b309-4229-9684-915450520347'),
(646,646,1,'Building a Foundation  of Preventive Care','building-a-foundation-of-preventive-care-5','resources/building-a-foundation-of-preventive-care-5','{\"aceb4af7-e092-4894-a59a-eafca28db8e2\":[285],\"bd5a1d46-6844-4735-ad59-9d17e566aa16\":\"articles\",\"6507c83d-4852-4bbd-9fee-2e10673e660b\":[\"health\",\"rehabilitation\"],\"909d57b4-6b9f-42fb-8e21-bd64fb6371e6\":\"Preventive care is the cornerstone of long-lasting health. In this piece, we explore simple yet effective methods for early intervention and sustained well-being. Learn how everyday choices can protect you\",\"3bd7f129-28a9-4a77-8dac-a592f11fdf61\":\"<h1>Placeholder Text</h1><p>Lorem ipsum dolor sit amet. Rem eaque molestiae est consequuntur consequatur quo necessitatibus corrupti non nihil incidunt nam voluptatibus optio. Est molestias sint et quis commodi sed nemo cupiditate sed quia odio est magni quidem. In nulla tenetur aut doloribus omnis id saepe eius est deserunt nemo ea suscipit repudiandae qui eius ipsa et velit iure. Eos tempora officiis qui rerum Quis et sunt fuga id itaque animi qui voluptatibus eius ea eaque dolorem.</p><h2>Nam voluptates atque et voluptatem sapiente vel quia soluta?</h2><p>Id dicta consequatur ea molestiae libero sed atque vero vel cupiditate similique ab odio laborum sed commodi deserunt. Sed itaque voluptas qui voluptas quidem et consequuntur possimus nam optio enim qui quae culpa quo temporibus accusantium non magni doloribus? Nam quia quis et modi harum in reprehenderit architecto.</p><h3>Ea molestias nostrum est corrupti voluptatem.</h3><p>Aut dolores fugiat ea odio voluptas in excepturi ipsam aut consequatur molestiae et rerum esse vel repudiandae harum. In nostrum quisquam qui fugiat temporibus hic quam labore quo quia labore.</p><h4>Aut nobis iste vel dolor voluptatibus At quis rerum.</h4><p>Ab vero quidem est voluptas suscipit ut facilis dolorem. Ut dolorem expedita vel enim soluta est nihil quos!</p><p>Aut quod tenetur ut excepturi quos.</p><p>Vel illum reprehenderit eum inventore quia qui autem necessitatibus et enim provident aut voluptatibus quibusdam! Aut laboriosam esse et eius ipsum sed corrupti facilis id dolor sequi est distinctio ipsa et porro eius sit quae aperiam!</p><p>Aut rerum eligendi ab tenetur sapiente et magni natus aut rerum quia quo unde similique. Aut nihil odio non molestiae dolorem et quaerat dolorem eos tempore neque aut libero quasi vel rerum quisquam.</p><p>Est rerum eveniet et culpa neque cum vitae quidem. Est expedita dignissimos id molestiae velit eos fugiat deleniti et fugit laboriosam et facilis quidem quo dolore amet non odit repudiandae. Sed sint maiores qui velit sequi et aliquid quam qui earum enim. Hic illo itaque rem ipsa dolore ut fugiat quisquam vel reprehenderit ipsum.</p><p>Et nulla aliquam eos saepe assumenda ut enim nulla! Et nobis dolores est commodi rerum ad facere mollitia ut fuga possimus et deserunt possimus hic pariatur galisum qui voluptates veritatis! Et repudiandae internos ut rerum quasi in nisi autem 33 amet aliquid qui consequatur enim et perferendis obcaecati cum iure numquam. In voluptatibus voluptas ut eaque nihil sed harum rerum 33 inventore voluptatem est dolores reprehenderit qui ullam voluptatem quo sint voluptas.</p>\"}',1,'2025-09-05 20:01:55','2025-09-05 20:01:55','41d2519d-6000-4491-bdff-0b32aa17a9e7'),
(647,647,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Arbors\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Arbors\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccarbors.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[545],\"482ad396-5443-4761-a410-c644d0217e5a\":[601,617,605],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[\"bariatricCare\",\"infectiousDiseaseCare\",\"neuroStrokeCare\",\"pulmonaryCare\"],\"f352e58c-d152-4a45-9615-d0526b009523\":[534,530,532],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[548],\"559340ef-728e-4935-84cc-443bd407f901\":[111,555,557,559,561,563],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[545,137,138,136],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[548],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[548],\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"(732) 914-0090\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccarbors.com\"}',1,'2025-09-11 17:30:28','2025-09-11 17:30:28','f7f9d519-ecf6-49f8-942c-a013c336e4d1'),
(648,648,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Arbors\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Arbors\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccarbors.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"Working+at+Complete+Care+at+Arbors+|+Glassdoor\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[545],\"482ad396-5443-4761-a410-c644d0217e5a\":[601,617,605],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[\"bariatricCare\",\"infectiousDiseaseCare\",\"neuroStrokeCare\",\"pulmonaryCare\"],\"f352e58c-d152-4a45-9615-d0526b009523\":[534,530,532],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[548],\"559340ef-728e-4935-84cc-443bd407f901\":[111,555,557,559,561,563],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[545,137,138,136],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[548],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[548],\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"(732) 914-0090\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccarbors.com\"}',1,'2025-09-11 18:16:32','2025-09-11 18:16:32','2f38eb87-0caf-401a-9f76-7228ac0922b8'),
(649,649,1,'Ashie T.','robert-a',NULL,'{\"ffdd5871-4e4c-4e46-88b5-06b52502357e\":\"The staff at Complete Care goes above and beyond to provide patient care and satisfaction! Always with a smile and a good word, the staff is there whenever you need them and the services they provide are unparalleled.\",\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\":\"Ashie T.\"}',1,'2025-09-11 18:16:32','2025-09-11 18:16:32','5c992df3-7079-47e4-b45d-e6267a7f609a'),
(650,650,1,'Carole T.','bernadette-m',NULL,'{\"ffdd5871-4e4c-4e46-88b5-06b52502357e\":\"Very professional and caring place, staff and nurses were overly helpful in attending to needs. Therapy went way above to assist in getting us to reach maximum potential.\",\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\":\"Carole T.\"}',1,'2025-09-11 18:16:32','2025-09-11 18:16:32','7361d71b-1b5d-464f-9e88-849cea6d2d35'),
(651,651,1,'Cora O.','mary-o',NULL,'{\"ffdd5871-4e4c-4e46-88b5-06b52502357e\":\"I have been here for 3 years and I am thrilled with the quality care I receive. I enjoy every day is a new amazing experience with activities. The staff are wonderful! The place is very clean and every one is very polite!\",\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\":\"Cora O.\"}',1,'2025-09-11 18:16:32','2025-09-11 18:16:32','e89f9ec8-feee-411a-a3e1-31eed35b79a3'),
(652,652,1,'Menachem Shapiro','menachem-shapiro',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Menachem Shapiro\",\"50d484f9-ea00-4870-8b7a-a1c7400f42ab\":[632],\"6859b0cf-ccd8-409d-84f9-b76fcac3eda0\":\"mshapiro@ccarbors.com\"}',1,'2025-09-11 18:16:32','2025-09-11 18:16:32','c0a44cdf-302b-4d06-89c8-8c61dc1388ed'),
(653,653,1,'Ashley Lewis','ashley-lewis',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Ashley Lewis\",\"50d484f9-ea00-4870-8b7a-a1c7400f42ab\":[634]}',1,'2025-09-11 18:16:32','2025-09-11 18:16:32','33eba909-24fe-41d1-ad2e-ca2ff072875a'),
(834,834,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Arbors\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Arbors\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccarbors.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"Working+at+Complete+Care+at+Arbors+|+Glassdoor\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[545],\"482ad396-5443-4761-a410-c644d0217e5a\":[601,617,605],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[\"bariatricCare\",\"infectiousDiseaseCare\",\"neuroStrokeCare\",\"pulmonaryCare\"],\"f352e58c-d152-4a45-9615-d0526b009523\":[534,530,532],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[548],\"559340ef-728e-4935-84cc-443bd407f901\":[111,555,557,559,561,563],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[545,137,138,136],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[548],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[548],\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"(732) 914-0090\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccarbors.com\"}',1,'2025-09-11 18:16:35','2025-09-11 18:16:35','bfdd4a64-1bd0-4e5f-82b0-d88a45614224'),
(835,835,1,'Ashie T.','robert-a',NULL,'{\"ffdd5871-4e4c-4e46-88b5-06b52502357e\":\"The staff at Complete Care goes above and beyond to provide patient care and satisfaction! Always with a smile and a good word, the staff is there whenever you need them and the services they provide are unparalleled.\",\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\":\"Ashie T.\"}',1,'2025-09-11 18:16:35','2025-09-11 18:16:35','9d22335c-40a6-4c44-9421-13a252fe2e17'),
(836,836,1,'Carole T.','bernadette-m',NULL,'{\"ffdd5871-4e4c-4e46-88b5-06b52502357e\":\"Very professional and caring place, staff and nurses were overly helpful in attending to needs. Therapy went way above to assist in getting us to reach maximum potential.\",\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\":\"Carole T.\"}',1,'2025-09-11 18:16:35','2025-09-11 18:16:35','b44b4e80-333c-4beb-9f8b-278d0a35e196'),
(837,837,1,'Cora O.','mary-o',NULL,'{\"ffdd5871-4e4c-4e46-88b5-06b52502357e\":\"I have been here for 3 years and I am thrilled with the quality care I receive. I enjoy every day is a new amazing experience with activities. The staff are wonderful! The place is very clean and every one is very polite!\",\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\":\"Cora O.\"}',1,'2025-09-11 18:16:35','2025-09-11 18:16:35','855d90dc-8947-4879-8c03-827e62337067'),
(838,838,1,'Menachem Shapiro','menachem-shapiro',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Menachem Shapiro\",\"50d484f9-ea00-4870-8b7a-a1c7400f42ab\":[632],\"6859b0cf-ccd8-409d-84f9-b76fcac3eda0\":\"mshapiro@ccarbors.com\"}',1,'2025-09-11 18:16:35','2025-09-11 18:16:35','bce35f43-b602-4a18-8c83-6a62d36b3895'),
(839,839,1,'Ashley Lewis','ashley-lewis',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Ashley Lewis\",\"50d484f9-ea00-4870-8b7a-a1c7400f42ab\":[634]}',1,'2025-09-11 18:16:35','2025-09-11 18:16:35','41c9335e-e01b-4593-a3e2-dfa4da97a54d'),
(932,932,1,'Complete Care at Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Arbors\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Arbors\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccarbors.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[545],\"482ad396-5443-4761-a410-c644d0217e5a\":[601,617,605],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[\"bariatricCare\",\"infectiousDiseaseCare\",\"neuroStrokeCare\",\"pulmonaryCare\"],\"f352e58c-d152-4a45-9615-d0526b009523\":[534,530,532],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[548],\"559340ef-728e-4935-84cc-443bd407f901\":[111,555,557,559,561,563],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[545,137,138,136],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[548],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[548],\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"(732) 914-0090\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccarbors.com\"}',1,'2025-09-11 18:17:21','2025-09-11 18:17:21','fe743ed8-34fd-402c-a3df-6746cb4a09c8'),
(937,937,1,'Menachem Shapiro',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Menachem Shapiro\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','8175b51a-d574-48e3-b91f-41c65515ec73'),
(938,938,1,'Ashley Lewis',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Ashley Lewis\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','fc58e4b6-045a-4770-9565-d4c6fba0bf49'),
(939,939,1,'Arbors','ccarbors','ccarbors','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Arbors\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Arbors\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccarbors.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Arbors-116083393100113/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Arbors-EI_IE7548214.11,34.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[545],\"482ad396-5443-4761-a410-c644d0217e5a\":[601,617,605],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[\"bariatricCare\",\"infectiousDiseaseCare\",\"neuroStrokeCare\",\"pulmonaryCare\"],\"f352e58c-d152-4a45-9615-d0526b009523\":[534,530,532],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[548],\"559340ef-728e-4935-84cc-443bd407f901\":[111,555,557,559,561,563],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[545,137,138,136],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[548],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[548],\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7329140090\",\"region\":\"1\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccarbors.com\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','261be4fe-94d2-478e-9a77-e3504a78eadd'),
(940,940,1,'Ashie T.','robert-a',NULL,'{\"ffdd5871-4e4c-4e46-88b5-06b52502357e\":\"The staff at Complete Care goes above and beyond to provide patient care and satisfaction! Always with a smile and a good word, the staff is there whenever you need them and the services they provide are unparalleled.\",\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\":\"Ashie T.\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','68c45114-272f-45ce-b6da-3c7c353c5ebb'),
(941,941,1,'Carole T.','bernadette-m',NULL,'{\"ffdd5871-4e4c-4e46-88b5-06b52502357e\":\"Very professional and caring place, staff and nurses were overly helpful in attending to needs. Therapy went way above to assist in getting us to reach maximum potential.\",\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\":\"Carole T.\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','ba87940e-2df4-4c39-8580-b5aa52f1fe70'),
(942,942,1,'Cora O.','mary-o',NULL,'{\"ffdd5871-4e4c-4e46-88b5-06b52502357e\":\"I have been here for 3 years and I am thrilled with the quality care I receive. I enjoy every day is a new amazing experience with activities. The staff are wonderful! The place is very clean and every one is very polite!\",\"1e69e1f4-c7b2-4468-8668-aa722b6f7163\":\"Cora O.\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','0a6ab42c-1740-41bb-9400-87b10fcbd98f'),
(943,943,1,'Menachem Shapiro','menachem-shapiro',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Menachem Shapiro\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','7cc0e66d-27d9-4186-9b5e-64c82ca8bf90'),
(944,944,1,'Ashley Lewis','ashley-lewis',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Ashley Lewis\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','14e08175-110e-49b8-b983-496927a8718e'),
(945,945,1,'Bey Lea','ccbeylea','ccbeylea','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Bey Lea\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Bey Lea\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccbeylea.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Bey-Lea-240380446766715/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Bey-Lea-EI_IE2180780.11,35.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[2968],\"482ad396-5443-4761-a410-c644d0217e5a\":[2969,605,617,2974],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[2610,2598,2608,2600,2596,2602,2604],\"f352e58c-d152-4a45-9615-d0526b009523\":[],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[],\"559340ef-728e-4935-84cc-443bd407f901\":[],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[],\"b46c7894-3c01-4cc4-b90f-9612b3b9891b\":\"<script src=\\\"https://apploi.link/complete-care-beylea-career-page\\\"></script>\",\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7322400090\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccbeylea.com\"}',1,'2025-09-11 18:48:35','2025-10-06 17:50:49','3629311f-8661-4bb1-8e33-7435d054aece'),
(946,946,1,'Meir Lapides',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Meir Lapides\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','ce3400c7-1631-4c8f-b297-47c92647d1b6'),
(947,947,1,'Brianna Osipow',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Brianna Osipow\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','9d31c327-7f76-4466-beeb-ec63d3144808'),
(948,948,1,'Bey Lea','ccbeylea','ccbeylea','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Bey Lea\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Bey Lea\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccbeylea.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Bey-Lea-240380446766715/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Bey-Lea-EI_IE2180780.11,35.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7322400090\",\"region\":\"1\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccbeylea.com\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','fbafc900-c0b1-4b50-b747-c57cb3d17a60'),
(949,949,1,'Meir Lapides','meir-lapides',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Meir Lapides\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','161591c3-bd2b-409a-9597-b6746676a479'),
(950,950,1,'Brianna Osipow','brianna-osipow',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Brianna Osipow\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','c9c4bcd9-fb16-408b-b618-23079db707de'),
(951,951,1,'Bey Lea Assisted Living','ccbeyleaalf','ccbeyleaalf','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Bey Lea Assisted Living\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Bey Lea Assisted Living\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccbeyleaalf.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"assistedLiving\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Assisted Living\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Bey-Lea-240380446766715/\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[3252],\"482ad396-5443-4761-a410-c644d0217e5a\":[],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"assistedLiving\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[],\"f352e58c-d152-4a45-9615-d0526b009523\":[],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[],\"559340ef-728e-4935-84cc-443bd407f901\":[],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[3246,3254,3253,3251,3245,3248,3250,3249,3252,3247],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[],\"b46c7894-3c01-4cc4-b90f-9612b3b9891b\":\"<script src=\\\"https://apploi.link/complete-care-beylea-assisted-living-career-page\\\"></script>\",\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7322400090\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccbeylea.com\"}',1,'2025-09-11 18:48:35','2025-10-08 22:29:34','c2eecb22-79bb-44f4-91d3-fede42ec427d'),
(952,952,1,'Susan DeGeorge',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Susan DeGeorge\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','e3dd1c93-57a8-472c-8c17-a095be8b8b9e'),
(953,953,1,'Brianna Osipow',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Brianna Osipow\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','42ded48f-903d-4e7d-b8b9-5320065dfab0'),
(954,954,1,'Bey Lea','ccbeyleaalf','ccbeyleaalf','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Bey Lea\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Bey Lea\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccbeyleaalf.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"assistedLiving\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Assisted Living\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Bey-Lea-240380446766715/\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7322400090\",\"region\":\"1\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccbeylea.com\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','ed280e38-3aa3-4ecd-bb37-cf7aa8d53e2d'),
(955,955,1,'Susan DeGeorge','susan-degeorge',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Susan DeGeorge\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','1384285e-ee27-47d5-bf10-04e9b34f9aa9'),
(956,956,1,'Brianna Osipow','brianna-osipow',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Brianna Osipow\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','93370c86-55c6-47e7-be5d-3c1fc3f82abe'),
(957,957,1,'Brick','completecarebrick','completecarebrick','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Brick\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Brick\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"completecarebrick.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://m.facebook.com/100090397946860/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Brick-EI_IE10502442.11,33.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[3011],\"482ad396-5443-4761-a410-c644d0217e5a\":[601,3025,3027,617,605],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[2610,2598,2608,2600,2596,2602,2604],\"f352e58c-d152-4a45-9615-d0526b009523\":[],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[],\"559340ef-728e-4935-84cc-443bd407f901\":[],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[],\"b46c7894-3c01-4cc4-b90f-9612b3b9891b\":\"<script src=\\\"https://apploi.click/complete-care-at-brick-llc-career-page\\\"></script>\",\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7322068000\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@completecarebrick.com\"}',1,'2025-09-11 18:48:35','2025-10-08 18:43:12','0a481a95-1829-4578-96ba-4edc03dba781'),
(958,958,1,'Joe Hiller',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Joe Hiller\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','f8b457ed-4f3a-488d-bb7b-53dac7a9dbfb'),
(959,959,1,'Brianna Febus',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Brianna Febus\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','60dc03fa-100e-4f97-b202-a031ca6efb85'),
(960,960,1,'Brick','completecarebrick','completecarebrick','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Brick\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Brick\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"completecarebrick.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://m.facebook.com/100090397946860/\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7322068000\",\"region\":\"1\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@completecarebrick.com\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','57c8add1-fe4e-4513-bb7a-ea1c7239980e'),
(961,961,1,'Joe Hiller','joe-hiller',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Joe Hiller\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','85eb0de3-a7ad-4d0f-b0ea-2e96b115b024'),
(962,962,1,'Brianna Febus','brianna-febus',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Brianna Febus\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','25a5e378-15b5-469d-b52d-515352cf703c'),
(963,963,1,'Burlington Woods','ccburlingtonwoods','ccburlingtonwoods','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Burlington Woods\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Burlington Woods\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccburlingtonwoods.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Burlington-Woods-100109412568660\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Burlington-Woods-EI_IE10501634.11,44.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[3058],\"482ad396-5443-4761-a410-c644d0217e5a\":[2969,617,605],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[2610,2598,2624,2600,2596,2602,2606,2612,2604],\"f352e58c-d152-4a45-9615-d0526b009523\":[2891],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[],\"559340ef-728e-4935-84cc-443bd407f901\":[],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[],\"b46c7894-3c01-4cc4-b90f-9612b3b9891b\":\"<script src=\\\"https://apploi.link/ccburlingtonwoods-career-page\\\"></script>\",\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"6093873620\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@burlingtonwoods.com\"}',1,'2025-09-11 18:48:35','2025-10-08 18:50:11','d3ea07b1-a162-429b-8ffa-23498489c78d'),
(964,964,1,'Eli Goldman',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Eli Goldman\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','3b8a16dc-8a5c-4d37-bdb7-c2442e94784b'),
(965,965,1,'Carmen Gonzalez',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Carmen Gonzalez\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','5c276656-925d-4a7f-bad9-7145928e250e'),
(966,966,1,'Burlington Woods','ccburlingtonwoods','ccburlingtonwoods','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Burlington Woods\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Burlington Woods\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccburlingtonwoods.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Burlington-Woods-100109412568660\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Burlington-Woods-EI_IE10501634.11,44.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"6093873620\",\"region\":\"1\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@burlingtonwoods.com\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','fb68e87f-2c7e-444b-9eec-c8d9d926da17'),
(967,967,1,'Eli Goldman','eli-goldman',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Eli Goldman\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','adcc2254-116a-420e-bae4-7d3e23be203a'),
(968,968,1,'Carmen Gonzalez','carmen-gonzalez',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Carmen Gonzalez\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','fbd9655a-51ff-475b-8d56-8822948d32de'),
(969,969,1,'Court House','ccatcourthouse','ccatcourthouse','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Court House\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Court House\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccatcourthouse.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-At-Court-House-100238095889885\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Court-House-EI_IE10502030.11,39.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[3090],\"482ad396-5443-4761-a410-c644d0217e5a\":[3091,3093,617,605],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[2610,2598,2600,2596,2602,2604],\"f352e58c-d152-4a45-9615-d0526b009523\":[],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[],\"559340ef-728e-4935-84cc-443bd407f901\":[],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[],\"b46c7894-3c01-4cc4-b90f-9612b3b9891b\":\"<script src=\\\"https://apploi.link/ccatcourthouse-career-page\\\"></script>\",\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"6094657171\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccatcourthouse.com\"}',1,'2025-09-11 18:48:35','2025-10-08 18:59:33','e7ed115e-5fd7-42ec-b65b-5f90dd6c967b'),
(970,970,1,'Brian Klocke',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Brian Klocke\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','263abe28-5154-4dc7-b52a-0927e6db3986'),
(971,971,1,'Stacy Moldando',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Stacy Moldando\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','348fa87c-774e-4165-8bae-d777ac963a60'),
(972,972,1,'Court House','ccatcourthouse','ccatcourthouse','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Court House\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Court House\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccatcourthouse.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-At-Court-House-100238095889885\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Court-House-EI_IE10502030.11,39.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"6094657171\",\"region\":\"1\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccatcourthouse.com\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','c98e0025-90b1-433c-b0ff-95e14370fc39'),
(973,973,1,'Brian Klocke','brian-klocke',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Brian Klocke\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','9c580cca-205b-44e2-bbf2-8eca68025300'),
(974,974,1,'Stacy Moldando','stacy-moldando',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Stacy Moldando\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','d84cf0b2-dc28-43f7-b947-bc8b613d90af'),
(975,975,1,'Green Acres','ccatgreenacres','ccatgreenacres','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Green Acres\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Green Acres\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccatgreenacres.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/completecareatgreenacres\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Green-Acres-EI_IE3270719.11,39.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[3122],\"482ad396-5443-4761-a410-c644d0217e5a\":[3091,3123,2972,2974,617,605],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[2614,2610,2598,2608,2600,2596,2602,2604],\"f352e58c-d152-4a45-9615-d0526b009523\":[],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[],\"559340ef-728e-4935-84cc-443bd407f901\":[],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[],\"b46c7894-3c01-4cc4-b90f-9612b3b9891b\":\"<script src=\\\"https://apploi.link/complete-care-greenacres-career-page\\\"></script>\",\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7322862323\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccatgreenacres.com\"}',1,'2025-09-11 18:48:35','2025-10-08 19:59:16','b9b953ec-646c-425b-b715-c97540a007d7'),
(976,976,1,'Eli Basch',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Eli Basch\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','8186f98a-3a2f-4fee-a656-bf5e914b4847'),
(977,977,1,'Dana Bea',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Dana Bea\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','380ba856-79fe-4177-9428-2d795e45a05e'),
(978,978,1,'Green Acres','ccatgreenacres','ccatgreenacres','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Green Acres\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Green Acres\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccatgreenacres.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/completecareatgreenacres\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Green-Acres-EI_IE3270719.11,39.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7322862323\",\"region\":\"1\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccatgreenacres.com\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','b00f364b-cba9-4545-b945-7b993cc694c9'),
(979,979,1,'Eli Basch','eli-basch',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Eli Basch\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','28cb8bfd-a352-4e1a-bdbf-1ce344ede94b'),
(980,980,1,'Dana Bea','dana-bea',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Dana Bea\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','7bcfae34-97ad-48f6-8848-28b7c4851bdc'),
(981,981,1,'Holiday City','ccholidaycity','ccholidaycity','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Holiday City\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Holiday City\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccholidaycity.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/CompleteCareHolidayCity/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Holiday-City-EI_IE3343224.11,40.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[3158],\"482ad396-5443-4761-a410-c644d0217e5a\":[2969,2974,617,605],\"cced3c80-6988-403a-9b5a-14455350e923\":[\"postAcuteCare\",\"longTermCare\"],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[2614,2610,2598,2608,2600,2596,2602,2604],\"f352e58c-d152-4a45-9615-d0526b009523\":[],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[],\"559340ef-728e-4935-84cc-443bd407f901\":[],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[],\"b46c7894-3c01-4cc4-b90f-9612b3b9891b\":\"<script src=\\\"https://apploi.link/completecareatholidaycity-career-page\\\"></script>\",\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7322400900\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccholidaycity.com\"}',1,'2025-09-11 18:48:35','2025-10-08 20:24:41','179b64cf-344c-4e72-8191-4ca382cda719'),
(982,982,1,'Katie Davis',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Katie Davis\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','a1dc24fa-48bd-47f4-b622-4c55f79632b2'),
(983,983,1,'Riten Pandya',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Riten Pandya\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','879e771e-e871-4488-a270-85a5e05c6457'),
(984,984,1,'Shelby Svehla',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Shelby Svehla\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','95b5369b-09f3-46b2-b872-1574b606d45d'),
(985,985,1,'Holiday City','ccholidaycity','ccholidaycity','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Holiday City\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Holiday City\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"ccholidaycity.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/CompleteCareHolidayCity/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Holiday-City-EI_IE3343224.11,40.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7322400900\",\"region\":\"1\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@ccholidaycity.com\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','8b89ca20-d268-4985-9f54-6a87ed7bfedc'),
(986,986,1,'Katie Davis','katie-davis',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Katie Davis\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','a1de1069-bf70-43a5-b873-64b9c63fa41c'),
(987,987,1,'Riten Pandya','riten-pandya',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Riten Pandya\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','d3a34dd7-b56b-41b3-883d-6885238b8667'),
(988,988,1,'Shelby Svehla','shelby-svehla',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Shelby Svehla\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','e243b1c2-f80a-40e6-ab25-259c0aeac23b'),
(989,989,1,'Kresson View','cckressonview','cckressonview','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Kresson View\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Kresson View\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"cckressonview.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Kresson-View-100856862135179/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Kresson-View-EI_IE5847266.11,40.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[],\"482ad396-5443-4761-a410-c644d0217e5a\":[],\"cced3c80-6988-403a-9b5a-14455350e923\":[],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[],\"f352e58c-d152-4a45-9615-d0526b009523\":[],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[],\"559340ef-728e-4935-84cc-443bd407f901\":[],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[],\"b46c7894-3c01-4cc4-b90f-9612b3b9891b\":\"<script src=\\\"https://apploi.link/cckressonview-career-page\\\"></script>\",\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"8565961113\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@cckressonview.com\"}',1,'2025-09-11 18:48:35','2025-09-11 20:39:30','72e131eb-bca7-48a4-9eec-1379ba721a3c'),
(990,990,1,'Rita DeGore',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Rita DeGore\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','ca8af742-e3a6-4814-928f-176ee368623e'),
(991,991,1,'Elise McGlinchy',NULL,NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Elise McGlinchy\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','cd3ec17d-e9d9-4b36-92f5-b8130fb598cd'),
(992,992,1,'Kresson View','cckressonview','cckressonview','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Kresson View\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Kresson View\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"cckressonview.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/Complete-Care-at-Kresson-View-100856862135179/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Kresson-View-EI_IE5847266.11,40.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"8565961113\",\"region\":\"1\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@cckressonview.com\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','48113b9f-3a4a-48f1-91d6-08a0d4247f66'),
(993,993,1,'Rita DeGore','rita-degore',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Rita DeGore\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','3f78ce23-494b-44ae-bbb7-a146037d809d'),
(994,994,1,'Elise McGlinchy','elise-mcglinchy',NULL,'{\"2b573339-79e1-4bb1-82cf-7c0dfabcab22\":\"Elise McGlinchy\"}',1,'2025-09-11 18:48:35','2025-09-11 18:48:35','bb752675-18cd-47dd-83bb-44276aee718e'),
(995,995,1,'Laurelton','cclaurelton','cclaurelton','{\"075f1904-e0fc-49c8-9cfb-6990ae779dec\":\"Complete Care at Laurelton\",\"7a0d2797-bfc8-4d68-b107-61c1dd081ea0\":\"Laurelton\",\"3b262689-7127-4814-bab5-a1972e0869d4\":\"cclaurelton.com\",\"19b0086c-bc10-46cc-9f45-ffc5746e8681\":\"ltc\",\"0d799588-2604-4e16-86f6-6ee8c522fe72\":\"Post-Acute, Skilled Nursing, and Long-Term Care\",\"403d1895-f32e-4164-8084-b11fdea310cb\":{\"value\":\"https://www.facebook.com/CCLAURELTON/\",\"type\":\"url\"},\"5e40a449-23c9-418a-a0d6-36ff8f57583d\":{\"value\":\"https://www.glassdoor.com/Overview/Working-at-Complete-Care-at-Laurelton-EI_IE4662069.11,37.htm\",\"type\":\"url\"},\"8e701860-42c4-437f-a61c-a48f2ecf1b99\":{\"value\":\"https://www.linkedin.com/company/94146224/\",\"type\":\"url\"},\"10d5be16-947c-4646-b2d0-3619f2760ace\":[],\"482ad396-5443-4761-a410-c644d0217e5a\":[],\"cced3c80-6988-403a-9b5a-14455350e923\":[],\"0be5b641-0a34-4d93-8816-9a4b1ad24ffd\":[],\"f352e58c-d152-4a45-9615-d0526b009523\":[],\"a8f7b1eb-08e8-44fa-9777-c9a0daa85c5f\":[],\"559340ef-728e-4935-84cc-443bd407f901\":[],\"9a83aaf9-b86b-4272-88b0-1a3cd8eec119\":[],\"92b514e7-6c85-40f3-9885-4ed4138887ea\":[],\"688e0d64-8999-47be-a427-f9e9c6e1789e\":[],\"b46c7894-3c01-4cc4-b90f-9612b3b9891b\":\"<script src=\\\"https://apploi.link/complete-care-laurelton-career-page\\\"></script>\",\"0d6389a7-9cd0-496d-96dd-72ebf02f7bbb\":{\"number\":\"7324586600\",\"region\":\"US\"},\"31a45631-ecd4-4327-aca7-18b9d213bb16\":\"info@cclau